/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(MEDIA_SESSION)

#include "IDLTypes.h"
#include "JSCallbackData.h"
#include "MediaSessionActionHandler.h"
#include <wtf/Forward.h>

namespace WebCore {

class JSMediaSessionActionHandler final : public MediaSessionActionHandler {
public:
    static Ref<JSMediaSessionActionHandler> create(JSC::JSObject* callback, JSDOMGlobalObject* globalObject)
    {
        return adoptRef(*new JSMediaSessionActionHandler(callback, globalObject));
    }

    ScriptExecutionContext* scriptExecutionContext() const { return ContextDestructionObserver::scriptExecutionContext(); }

    ~JSMediaSessionActionHandler() final;
    JSCallbackData* callbackData() { return m_data; }

    // Functions
    CallbackResult<typename IDLUndefined::CallbackReturnType> handleEvent(typename IDLDictionary<MediaSessionActionDetails>::ParameterType details) override;

private:
    JSMediaSessionActionHandler(JSC::JSObject*, JSDOMGlobalObject*);

    bool hasCallback() const final { return m_data && m_data->callback(); }

    void visitJSFunction(JSC::AbstractSlotVisitor&) override;

    void visitJSFunction(JSC::SlotVisitor&) override;

    JSCallbackData* m_data;
};

JSC::JSValue toJS(MediaSessionActionHandler&);
inline JSC::JSValue toJS(MediaSessionActionHandler* impl) { return impl ? toJS(*impl) : JSC::jsNull(); }

template<> struct JSDOMCallbackConverterTraits<JSMediaSessionActionHandler> {
    using Base = MediaSessionActionHandler;
};
} // namespace WebCore

#endif // ENABLE(MEDIA_SESSION)
