/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPU.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUAdapter.h"
#include "JSGPURequestAdapterOptions.h"
#include "JSGPUTextureFormat.h"
#include "JSWGSLLanguageFeatures.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGPUPrototypeFunction_requestAdapter);
static JSC_DECLARE_HOST_FUNCTION(jsGPUPrototypeFunction_getPreferredCanvasFormat);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPU_wgslLanguageFeatures);

class JSGPUPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUPrototype>(vm)) JSGPUPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUPrototype, JSGPUPrototype::Base);

using JSGPUDOMConstructor = JSDOMConstructorNotConstructable<JSGPU>;

template<> const ClassInfo JSGPUDOMConstructor::s_info = { "GPU"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUDOMConstructor) };

template<> JSValue JSGPUDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPU"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPU::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPUPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUConstructor, 0 } },
    { "wgslLanguageFeatures"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPU_wgslLanguageFeatures, 0 } },
    { "requestAdapter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUPrototypeFunction_requestAdapter, 0 } },
    { "getPreferredCanvasFormat"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUPrototypeFunction_getPreferredCanvasFormat, 0 } },
};

const ClassInfo JSGPUPrototype::s_info = { "GPU"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUPrototype) };

void JSGPUPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPU::info(), JSGPUPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPU::s_info = { "GPU"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPU) };

JSGPU::JSGPU(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPU>&& impl)
    : JSDOMWrapper<GPU>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPU>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPU::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPU::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPU>(vm, globalObject);
}

JSValue JSGPU::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUDOMConstructor, DOMConstructorID::GPU>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPU::destroy(JSC::JSCell* cell)
{
    JSGPU* thisObject = static_cast<JSGPU*>(cell);
    thisObject->JSGPU::~JSGPU();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPU::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsGPU_wgslLanguageFeaturesGetter(JSGlobalObject& lexicalGlobalObject, JSGPU& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<WGSLLanguageFeatures>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.wgslLanguageFeatures())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPU_wgslLanguageFeatures, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPU>::get<jsGPU_wgslLanguageFeaturesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsGPUPrototypeFunction_requestAdapterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSGPU>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<GPURequestAdapterOptions>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(optionsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLNullable<IDLInterface<GPUAdapter>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.requestAdapter(optionsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUPrototypeFunction_requestAdapter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSGPU>::call<jsGPUPrototypeFunction_requestAdapterBody>(*lexicalGlobalObject, *callFrame, "requestAdapter");
}

static inline JSC::EncodedJSValue jsGPUPrototypeFunction_getPreferredCanvasFormatBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPU>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLEnumeration<GPUTextureFormat>>(*lexicalGlobalObject, throwScope, impl.getPreferredCanvasFormat())));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUPrototypeFunction_getPreferredCanvasFormat, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPU>::call<jsGPUPrototypeFunction_getPreferredCanvasFormatBody>(*lexicalGlobalObject, *callFrame, "getPreferredCanvasFormat");
}

JSC::GCClient::IsoSubspace* JSGPU::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPU, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPU.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPU = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPU.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPU = std::forward<decltype(space)>(space); }
    );
}

void JSGPU::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPU*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPU = static_cast<JSGPU*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPU->protectedWrapped().ptr(), jsGPU);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPU@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore3GPUE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, GPU>, void>> static inline void verifyVTable(GPU* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPU@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore3GPUE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPU has subclasses. If GPU has subclasses that get passed
        // to toJS() we currently require GPU you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPU>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPU>(impl.ptr());
#endif
    return createWrapper<GPU>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPU& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPU* JSGPU::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPU*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
