/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAddEventListenerOptions.h"

#include "JSAbortSignal.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<AddEventListenerOptions>> convertDictionary<AddEventListenerOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    AddEventListenerOptions result;
    JSValue captureValue;
    if (isNullOrUndefined)
        captureValue = jsUndefined();
    else {
        captureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "capture"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto captureConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, captureValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(captureConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.capture = captureConversionResult.releaseReturnValue();
    JSValue onceValue;
    if (isNullOrUndefined)
        onceValue = jsUndefined();
    else {
        onceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "once"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto onceConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, onceValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(onceConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.once = onceConversionResult.releaseReturnValue();
    JSValue passiveValue;
    if (isNullOrUndefined)
        passiveValue = jsUndefined();
    else {
        passiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "passive"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!passiveValue.isUndefined()) {
        auto passiveConversionResult = convert<IDLBoolean>(lexicalGlobalObject, passiveValue);
        if (UNLIKELY(passiveConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.passive = passiveConversionResult.releaseReturnValue();
    }
    JSValue signalValue;
    if (isNullOrUndefined)
        signalValue = jsUndefined();
    else {
        signalValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "signal"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!signalValue.isUndefined()) {
        auto signalConversionResult = convert<IDLInterface<AbortSignal>>(lexicalGlobalObject, signalValue);
        if (UNLIKELY(signalConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.signal = signalConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore
