/*
 * Copyright (c) 2007, 2022 -2022 Apple Inc.  All rights reserved.
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "CommandLineAPIModuleSourceBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/ImplementationVisibility.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSObjectInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_commandLineAPIModuleSourceInjectModuleCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_commandLineAPIModuleSourceInjectModuleCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_commandLineAPIModuleSourceInjectModuleCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_commandLineAPIModuleSourceInjectModuleCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_commandLineAPIModuleSourceInjectModuleCodeLength = 6155;
static const JSC::Intrinsic s_commandLineAPIModuleSourceInjectModuleCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_commandLineAPIModuleSourceInjectModuleCode =
    "(function (InjectedScriptHost, inspectedGlobalObject, injectedScriptId, injectedScript, {RemoteObject, CommandLineAPI}, CommandLineAPIHost)\n" \
    "{\n" \
    "\n" \
    "//\n" \
    "\n" \
    "injectedScript._inspectObject = function(object) {\n" \
    "    if (arguments.length === 0)\n" \
    "        return;\n" \
    "\n" \
    "    let objectId = RemoteObject.create(object);\n" \
    "    let hints = {};\n" \
    "\n" \
    "    switch (RemoteObject.describe(object)) {\n" \
    "    case \"Database\":\n" \
    "        var databaseId = CommandLineAPIHost.databaseId(object);\n" \
    "        if (databaseId)\n" \
    "            hints.databaseId = databaseId;\n" \
    "        break;\n" \
    "    case \"Storage\":\n" \
    "        var storageId = CommandLineAPIHost.storageId(object);\n" \
    "        if (storageId)\n" \
    "            hints.domStorageId = InjectedScriptHost.evaluate(\"(\" + storageId + \")\");\n" \
    "        break;\n" \
    "    }\n" \
    "\n" \
    "    CommandLineAPIHost.inspect(objectId, hints);\n" \
    "};\n" \
    "\n" \
    "CommandLineAPI.getters[\"0\"] = function() {\n" \
    "    return CommandLineAPIHost.inspectedObject();\n" \
    "};\n" \
    "\n" \
    "CommandLineAPI.methods[\"copy\"] = function(object) {\n" \
    "    let string = null;\n" \
    "\n" \
    "    let subtype = RemoteObject.subtype(object);\n" \
    "    if (subtype === \"node\")\n" \
    "        string = object.outerHTML;\n" \
    "    else if (subtype === \"regexp\")\n" \
    "        string = \"\" + object;\n" \
    "    else if (injectedScript.isPrimitiveValue(object))\n" \
    "        string = \"\" + object;\n" \
    "    else if (typeof object === \"symbol\")\n" \
    "        string = @String(object);\n" \
    "    else if (typeof object === \"function\")\n" \
    "        string = \"\" + object;\n" \
    "    else {\n" \
    "        try {\n" \
    "            string = @jsonStringify(object, \"  \");\n" \
    "        } catch {\n" \
    "            string = \"\" + object;\n" \
    "        }\n" \
    "    }\n" \
    "\n" \
    "    CommandLineAPIHost.copyText(string);\n" \
    "};\n" \
    "\n" \
    "CommandLineAPI.methods[\"getEventListeners\"] = function(target) {\n" \
    "    return CommandLineAPIHost.getEventListeners(target);\n" \
    "};\n" \
    "\n" \
    "function normalizeEventTypes(types) {\n" \
    "    if (types === @undefined)\n" \
    "        types = @createArrayWithoutPrototype(\"mouse\", \"key\", \"touch\", \"control\", \"abort\", \"blur\", \"change\", \"devicemotion\", \"deviceorientation\", \"error\", \"focus\", \"load\", \"reset\", \"resize\", \"scroll\", \"search\", \"select\", \"submit\", \"unload\");\n" \
    "    else if (typeof types === \"string\")\n" \
    "        types = @createArrayWithoutPrototype(types);\n" \
    "\n" \
    "    let result = new @Set;\n" \
    "    function addTypesToResult() {\n" \
    "        for (let i = 0; i < arguments.length; ++i)\n" \
    "            result.@add(arguments[i]);\n" \
    "    }\n" \
    "\n" \
    "    for (let i = 0; i < types.length; i++) {\n" \
    "        if (types[i] === \"mouse\")\n" \
    "            addTypesToResult(\"click\", \"dblclick\", \"mousedown\", \"mousemove\", \"mouseout\", \"mouseover\", \"mouseup\", \"mousewheel\");\n" \
    "        else if (types[i] === \"key\")\n" \
    "            addTypesToResult(\"keydown\", \"keypress\", \"keyup\", \"textInput\");\n" \
    "        else if (types[i] === \"touch\")\n" \
    "            addTypesToResult(\"touchcancel\", \"touchend\", \"touchmove\", \"touchstart\");\n" \
    "        else if (types[i] === \"control\")\n" \
    "            addTypesToResult(\"blur\", \"change\", \"focus\", \"reset\", \"resize\", \"scroll\", \"select\", \"submit\", \"zoom\");\n" \
    "        else\n" \
    "            result.@add(types[i]);\n" \
    "    }\n" \
    "    return result;\n" \
    "}\n" \
    "\n" \
    "function logEvent(event)\n" \
    "{\n" \
    "    inspectedGlobalObject.console.log(event.type, event);\n" \
    "}\n" \
    "\n" \
    "CommandLineAPI.methods[\"monitorEvents\"] = function(object, types) {\n" \
    "    if (!object || !object.addEventListener || !object.removeEventListener)\n" \
    "        return;\n" \
    "    for (let type of @builtinSetIterable(normalizeEventTypes(types))) {\n" \
    "        object.removeEventListener(type, logEvent, false);\n" \
    "        object.addEventListener(type, logEvent, false);\n" \
    "    }\n" \
    "};\n" \
    "\n" \
    "CommandLineAPI.methods[\"unmonitorEvents\"] = function(object, types) {\n" \
    "    if (!object || !object.addEventListener || !object.removeEventListener)\n" \
    "        return;\n" \
    "    for (let type of @builtinSetIterable(normalizeEventTypes(types)))\n" \
    "        object.removeEventListener(type, logEvent, false);\n" \
    "};\n" \
    "\n" \
    "if (inspectedGlobalObject.document && inspectedGlobalObject.Node) {\n" \
    "    function canQuerySelectorOnNode(node) {\n" \
    "        return node && InjectedScriptHost.subtype(node) === \"node\" && (node.nodeType === inspectedGlobalObject.Node.ELEMENT_NODE || node.nodeType === inspectedGlobalObject.Node.DOCUMENT_NODE || node.nodeType === inspectedGlobalObject.Node.DOCUMENT_FRAGMENT_NODE);\n" \
    "    }\n" \
    "\n" \
    "    CommandLineAPI.methods[\"$\"] = function(selector, start) {\n" \
    "        if (canQuerySelectorOnNode(start))\n" \
    "            return start.querySelector(selector);\n" \
    "\n" \
    "        let result = inspectedGlobalObject.document.querySelector(selector);\n" \
    "        if (result)\n" \
    "            return result;\n" \
    "\n" \
    "        if (selector && selector[0] !== \"#\") {\n" \
    "            result = inspectedGlobalObject.document.getElementById(selector);\n" \
    "            if (result) {\n" \
    "                inspectedGlobalObject.console.warn(\"The console function $() has changed from $=getElementById(id) to $=querySelector(selector). You might try $(\\\"#%s\\\")\", selector);\n" \
    "                return null;\n" \
    "            }\n" \
    "        }\n" \
    "\n" \
    "        return result;\n" \
    "    };\n" \
    "\n" \
    "    CommandLineAPI.methods[\"$$\"] = function(selector, start) {\n" \
    "        //\n" \
    "        if (canQuerySelectorOnNode(start))\n" \
    "            return @Array.@from(start.querySelectorAll(selector));\n" \
    "        return @Array.@from(inspectedGlobalObject.document.querySelectorAll(selector));\n" \
    "    };\n" \
    "\n" \
    "    CommandLineAPI.methods[\"$x\"] = function(xpath, context) {\n" \
    "        let doc = (context && context.ownerDocument) || inspectedGlobalObject.document;\n" \
    "        let result = doc.evaluate(xpath, context || doc, null, inspectedGlobalObject.XPathResult.ANY_TYPE, null);\n" \
    "        switch (result.resultType) {\n" \
    "        case inspectedGlobalObject.XPathResult.NUMBER_TYPE:\n" \
    "            return result.numberValue;\n" \
    "        case inspectedGlobalObject.XPathResult.STRING_TYPE:\n" \
    "            return result.stringValue;\n" \
    "        case inspectedGlobalObject.XPathResult.BOOLEAN_TYPE:\n" \
    "            return result.booleanValue;\n" \
    "        }\n" \
    "\n" \
    "        //\n" \
    "        let nodes = new @Array;\n" \
    "        let node = null;\n" \
    "        while (node = result.iterateNext())\n" \
    "            @arrayPush(nodes, node);\n" \
    "        return nodes;\n" \
    "    };\n" \
    "}\n" \
    "\n" \
    "if (CommandLineAPIHost.gatherRTCLogs) {\n" \
    "    CommandLineAPI.methods[\"gatherRTCLogs\"] = function(callback) {\n" \
    "        return CommandLineAPIHost.gatherRTCLogs(callback);\n" \
    "    };\n" \
    "}\n" \
    "\n" \
    "for (let name in CommandLineAPI.methods)\n" \
    "    CommandLineAPI.methods[name].toString = function() { return \"function \" + name + \"() { [Command Line API] }\"; };\n" \
    "\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().commandLineAPIModuleSourceBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().commandLineAPIModuleSourceBuiltins().codeName##Source(), std::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
