/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkIsolatedWatershedImageFilter_h
#define sitkIsolatedWatershedImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class IsolatedWatershedImageFilter
\brief Isolate watershed basins using two seeds.

IsolatedWatershedImageFilter labels pixels with ReplaceValue1 that are in the same watershed basin as Seed1 AND NOT the same as Seed2. The filter adjusts the waterlevel until the two seeds are not in different basins. The user supplies a Watershed threshold. The algorithm uses a binary search to adjust the upper waterlevel, starting at UpperValueLimit. UpperValueLimit defaults to the 1.0.
\sa itk::simple::IsolatedWatershed for the procedural interface
\sa itk::IsolatedWatershedImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT IsolatedWatershedImageFilter : public ImageFilter {
    public:
      using Self = IsolatedWatershedImageFilter;

      /** Destructor */
      virtual ~IsolatedWatershedImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      IsolatedWatershedImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set seed point 1. This seed will be isolated from Seed2 (if possible). All pixels connected to this seed will be replaced with ReplaceValue1.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSeed1 ( std::vector<uint32_t> Seed1 ) { this->m_Seed1 = std::move(Seed1); return *this; }

      /**
       * Set seed point 1. This seed will be isolated from Seed2 (if possible). All pixels connected to this seed will be replaced with ReplaceValue1.
       */
      std::vector<uint32_t> GetSeed1() const { return this->m_Seed1; }\

      /**
       * Set seed point 2. This seed will be isolated from Seed1 (if possible). All pixels connected to this seed will be replaced with ReplaceValue2.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSeed2 ( std::vector<uint32_t> Seed2 ) { this->m_Seed2 = std::move(Seed2); return *this; }

      /**
       * Set seed point 2. This seed will be isolated from Seed1 (if possible). All pixels connected to this seed will be replaced with ReplaceValue2.
       */
      std::vector<uint32_t> GetSeed2() const { return this->m_Seed2; }\

      /**
       * Set/Get the Watershed threshold. The default is 0.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetThreshold ( double Threshold ) { this->m_Threshold = Threshold; return *this; }

      /**
       * Set/Get the Watershed threshold. The default is 0.
       */
      double GetThreshold() const { return this->m_Threshold; }\

      /**
       * Set/Get the limit on the upper waterlevel value. The default is 1.0.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUpperValueLimit ( double UpperValueLimit ) { this->m_UpperValueLimit = UpperValueLimit; return *this; }

      /**
       * Set/Get the limit on the upper waterlevel value. The default is 1.0.
       */
      double GetUpperValueLimit() const { return this->m_UpperValueLimit; }\

      /**
       * Set/Get the precision required for the intensity threshold value. The default is .001.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetIsolatedValueTolerance ( double IsolatedValueTolerance ) { this->m_IsolatedValueTolerance = IsolatedValueTolerance; return *this; }

      /**
       * Set/Get the precision required for the intensity threshold value. The default is .001.
       */
      double GetIsolatedValueTolerance() const { return this->m_IsolatedValueTolerance; }\

      /**
       * Set/Get value to replace Seed1(Seed2) pixels, pixels that are within the basin that contains Seed1(Seed2) this value. The default is 1(0).
       */
      SITK_RETURN_SELF_TYPE_HEADER SetReplaceValue1 ( uint8_t ReplaceValue1 ) { this->m_ReplaceValue1 = ReplaceValue1; return *this; }

      /**
       * Set/Get value to replace Seed1(Seed2) pixels, pixels that are within the basin that contains Seed1(Seed2) this value. The default is 1(0).
       */
      uint8_t GetReplaceValue1() const { return this->m_ReplaceValue1; }\

      /**
       * Set/Get value to replace Seed1(Seed2) pixels, pixels that are within the basin that contains Seed1(Seed2) this value. The default is 1(0).
       */
      SITK_RETURN_SELF_TYPE_HEADER SetReplaceValue2 ( uint8_t ReplaceValue2 ) { this->m_ReplaceValue2 = ReplaceValue2; return *this; }

      /**
       * Set/Get value to replace Seed1(Seed2) pixels, pixels that are within the basin that contains Seed1(Seed2) this value. The default is 1(0).
       */
      uint8_t GetReplaceValue2() const { return this->m_ReplaceValue2; }

      /** Name of this class */
      std::string GetName() const { return std::string ("IsolatedWatershedImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<uint32_t>  m_Seed1{std::vector<uint32_t>(3, 0)};

      /*  */
      std::vector<uint32_t>  m_Seed2{std::vector<uint32_t>(3, 0)};

      double  m_Threshold{0.0};

      double  m_UpperValueLimit{1.0};

      double  m_IsolatedValueTolerance{0.001};

      uint8_t  m_ReplaceValue1{1u};

      uint8_t  m_ReplaceValue2{2u};


    };

    /**\
     * \brief Isolate watershed basins using two seeds.
     *
     * This function directly calls the execute method of IsolatedWatershedImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::IsolatedWatershedImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image IsolatedWatershed ( const Image& image1, std::vector<uint32_t> seed1 = std::vector<uint32_t>(3, 0), std::vector<uint32_t> seed2 = std::vector<uint32_t>(3, 0), double threshold = 0.0, double upperValueLimit = 1.0, double isolatedValueTolerance = 0.001, uint8_t replaceValue1 = 1u, uint8_t replaceValue2 = 2u );

     /** @} */
}
#endif
