/*
 *     Copyright (c) 2022, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 *
 */

#ifndef __NVHPC_CUDA_COMPLEX_H
#define __NVHPC_CUDA_COMPLEX_H

typedef float cmplx[2];
typedef struct {
    float r, i;
} cmplx2;

typedef double dcmplx[2];
typedef struct {
    double r, i;
} dcmplx2;

__device__ static __inline__ cmplx2
__pgi_scmplx(float real, float imag)
{
    cmplx2 retval;

    retval.r = real;
    retval.i = imag;
    return retval;
}

__device__ static __inline__ dcmplx2
__pgi_dcmplx(double real, double imag)
{
    dcmplx2 retval;

    retval.r = real;
    retval.i = imag;
    return retval;
}

#define REAL(x) (x).r
#define IMAG(x) (x).i
#define SCMPLX(x, y) __pgi_scmplx(x, y)
#define DCMPLX(x, y) __pgi_dcmplx(x, y)

#endif /* __NVHPC_CUDA_COMPLEX_H */
