/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.netty.buffer.ByteBuf;
import io.undertow.UndertowLogger;
import io.undertow.httpcore.OutputChannel;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.RangeAwareResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PathResource
implements RangeAwareResource {
    private final Path file;
    private final String path;
    private final ETag eTag;
    private final PathResourceManager manager;

    public PathResource(Path file, PathResourceManager manager, String path, ETag eTag) {
        this.file = file;
        this.path = path;
        this.manager = manager;
        this.eTag = eTag;
    }

    public PathResource(Path file, PathResourceManager manager, String path) {
        this(file, manager, path, null);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Date getLastModified() {
        try {
            return new Date(Files.getLastModifiedTime(this.file, new LinkOption[0]).toMillis());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getLastModifiedString() {
        return DateUtils.toDateString(this.getLastModified());
    }

    @Override
    public ETag getETag() {
        return this.eTag;
    }

    @Override
    public String getName() {
        return this.file.getFileName().toString();
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.file, new LinkOption[0]);
    }

    @Override
    public List<Resource> list() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.file);){
            for (Path child : stream) {
                resources.add(new PathResource(child, this.manager, this.path + File.separator + child.getFileName().toString()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resources;
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        String fileName = this.file.getFileName().toString();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && index != fileName.length() - 1) {
            return mimeMappings.getMimeType(fileName.substring(index + 1));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serveBlocking(OutputStream sender, HttpServerExchange exchange) throws IOException {
        ByteBuf buffer = exchange.allocateBuffer(false);
        try (InputStream in = Files.newInputStream(this.file, new OpenOption[0]);){
            int r;
            while ((r = in.read(buffer.array(), buffer.arrayOffset(), buffer.writableBytes())) > 0) {
                sender.write(buffer.array(), buffer.arrayOffset(), r);
            }
            sender.close();
        }
        finally {
            buffer.release();
        }
    }

    @Override
    public void serveAsync(OutputChannel stream, final HttpServerExchange exchange) {
        exchange.dispatch(new Runnable(){

            @Override
            public void run() {
                try {
                    PathResource.this.serveBlocking(exchange.getOutputStream(), exchange);
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    exchange.endExchange();
                }
            }
        });
    }

    @Override
    public Long getContentLength() {
        try {
            return Files.size(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getCacheKey() {
        return this.file.toString();
    }

    @Override
    public File getFile() {
        return this.file.toFile();
    }

    @Override
    public Path getFilePath() {
        return this.file;
    }

    @Override
    public File getResourceManagerRoot() {
        return this.manager.getBasePath().toFile();
    }

    @Override
    public Path getResourceManagerRootPath() {
        return this.manager.getBasePath();
    }

    @Override
    public URL getUrl() {
        try {
            return this.file.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serveRangeBlocking(OutputStream sender, HttpServerExchange exchange, long start, long end) throws IOException {
        ByteBuf buffer = exchange.allocateBuffer(false);
        int pos = 0;
        try (InputStream in = Files.newInputStream(this.file, new OpenOption[0]);){
            int r;
            while ((r = in.read(buffer.array(), buffer.arrayOffset(), buffer.writableBytes())) > 0) {
                int toEat;
                int sw = (long)pos < start ? ((toEat = (int)(start - (long)pos)) > r ? -1 : toEat) : 0;
                int rem = (int)(end - Math.max((long)pos, start)) + 1;
                if (rem <= 0) {
                    sender.close();
                    return;
                }
                int ew = r > rem ? rem : r;
                if (sw != -1) {
                    sender.write(buffer.array(), buffer.arrayOffset() + sw, ew);
                }
                pos += r;
            }
        }
        finally {
            buffer.release();
        }
    }

    @Override
    public void serveRangeAsync(OutputChannel outputStream, final HttpServerExchange exchange, final long start, final long end) {
        exchange.dispatch(new Runnable(){

            @Override
            public void run() {
                try {
                    PathResource.this.serveRangeBlocking(exchange.getOutputStream(), exchange, start, end);
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    exchange.endExchange();
                }
            }
        });
    }

    @Override
    public boolean isRangeSupported() {
        return true;
    }
}

