/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.graph;

import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.graph.KCoreUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.ComplexFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class KCoreBuilder
implements FilterBuilder {
    public Category getCategory() {
        return FilterLibrary.TOPOLOGY;
    }

    public String getName() {
        return NbBundle.getMessage(KCoreBuilder.class, (String)"KCoreBuilder.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(KCoreBuilder.class, (String)"KCoreBuilder.description");
    }

    public Filter getFilter(Workspace workspace) {
        return new KCoreFilter();
    }

    public JPanel getPanel(Filter filter) {
        KCoreUI ui = (KCoreUI)Lookup.getDefault().lookup(KCoreUI.class);
        if (ui != null) {
            return ui.getPanel((KCoreFilter)filter);
        }
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class KCoreFilter
    implements ComplexFilter {
        private FilterProperty[] filterProperties;
        private Integer k = 1;

        public Graph filter(Graph graph) {
            int removed = 0;
            do {
                removed = 0;
                for (Node n : graph.getNodes().toArray()) {
                    if (graph.getDegree(n) >= this.k) continue;
                    graph.removeNode(n);
                    ++removed;
                }
            } while (removed > 0);
            return graph;
        }

        public String getName() {
            return NbBundle.getMessage(KCoreBuilder.class, (String)"KCoreBuilder.name");
        }

        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty((Filter)this, Integer.class, (String)"k")};
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.filterProperties;
        }

        public Integer getK() {
            return this.k;
        }

        public void setK(Integer k) {
            this.k = k;
        }
    }
}

