import QtQuick 2.1
import QtQuick.Controls 1.4
import QtQuick.Layouts 1.0
import Shotcut.Controls 1.0 as Shotcut
Shotcut.KeyframableFilter {
    width: 350
    height: 225
    keyframableParameters: ["hfov0", "hfov1", "vfov0", "vfov1", "blurStart", "blurEnd"]
    startValues: [0.5, 0.5, 0.5, 0.5, 0.5, 0.5]
    middleValues: [-90.0, 90.0, -45.0, 45.0, 0.1, 1.0]
    endValues: [0.5, 0.5, 0.5, 0.5, 0.5, 0.5]
    property var allParameters: [
        {
            name: "hfov0",
            type: "simple",
            def: -90
        },
        {
            name: "hfov1",
            type: "simple",
            def: 90
        },
        {
            name: "vfov0",
            type: "simple",
            def: -45
        },
        {
            name: "vfov1",
            type: "simple",
            def: 45
        },
        {
            name: "blurStart",
            type: "simple",
            def: 0.1
        },
        {
            name: "blurEnd",
            type: "simple",
            def: 1.0
        }
        ]
    function isKeyframeButtonChecked(control){
        return filter.animateIn <= 0 && filter.animateOut <= 0 && filter.keyframeCount(control) > 0;
    }
    
    function setSimpleControl(parameter, controlSlider, controlKeyframeButton) {
        controlSlider.value = filter.getDouble(parameter, getPosition());
        controlKeyframeButton.checked = isKeyframeButtonChecked(parameter);
    }
    
    function setSimpleControlStatic(parameter, controlSlider) {
        controlSlider.value = filter.getDouble(parameter, getPosition());
    }
    
    function setSimpleComboBox(parameter, controlComboBox) {
        controlComboBox.currentIndex = filter.get(parameter);
    }
    
    function setSimpleCheckBox(parameter, controlCheckBox) {
        controlCheckBox.checked = filter.get(parameter) == "1";
    }
    
    function setSimpleTextField(parameter, controlTextField) {
        controlTextField.text = filter.get(parameter);
    }
    
    function setSimpleNumTextField(parameter, controlTextField) {
        controlTextField.text = filter.getDouble(parameter).toFixed(4);
    }
    
    function getFrameRate() {
        return producer.getDouble("meta.media.frame_rate_num", getPosition()) / producer.getDouble("meta.media.frame_rate_den", getPosition());
    }
    
    function getClipOffset() {
        return filter.in;
    }
    function getKeyframesButton(param) {
        return this["prop_" + param.name + "KeyframesButton"];
    }
    
    function getControl(param) {
        if (param.control != null && param.control !== undefined) {
            return this["prop_" + param.control];
        } else if (param.type == "simple" || param.type == "static") {
            return this["prop_" + param.name + "Slider"];
        } else if (param.type == "checkbox") {
            return this["prop_" + param.name + "CheckBox"];
        } else if (param.type == "combobox") {
            return this["prop_" + param.name + "ComboBox"];
        } else if (param.type == "textfield" || param.type == "numtextfield") {
            return this["prop_" + param.name + "TextField"];
        } else {
            return null;
        }
    }
    
    function enableControls(enabled) {
        for (var i = 0; i < allParameters.length; ++i) {
            var control = getControl(allParameters[i]);
            control.enabled = enabled;
        }
    }
    
    function defaultBeforePresetLoaded() {
        for (var i in preset.parameters) {
            filter.resetProperty(preset.parameters[i]);
        }
        resetSimpleKeyframes();
    }
    
    function defaultPresetSelected() {
        initializeSimpleKeyframes();
        setControls();
    }
    
    function setControlsForAllParameters() {
        console.log("START");
        console.log(allParameters.length);
        for (var i = 0; i < allParameters.length; ++i) {
            console.log(i);
            var param = allParameters[i];
            var control = getControl(param);
            console.log(param.name);
            console.log(param.type);
            console.log(control);
            if (param.type == "simple") {
                setSimpleControl(param.name, control, getKeyframesButton(param));
            } else if (param.type == "static") {
                setSimpleControlStatic(param.name, control);
            } else if (param.type == "combobox") {
                setSimpleComboBox(param.name, control);
            } else if (param.type == "checkbox") {
                setSimpleCheckBox(param.name, control);
            } else if (param.type == "textfield") {
                setSimpleTextField(param.name, control);
            } else if (param.type == "numtextfield") {
                setSimpleNumTextField(param.name, control);
            }
        }
    }
    function setControls() {
        blockUpdate = true;
        setControlsForAllParameters();
        blockUpdate = false;
        enableControls(isSimpleKeyframesActive());
    }
    
    function defaultOnCompleted() {
        if (filter.isNew) {
            for (var i = 0; i < allParameters.length; ++i) {
                var param = allParameters[i];
                console.log(param.name);
                if (param.def != null) {
                    var control = getControl(param);
                    filter.set(param.name, param.def);
                }
            }
            filter.savePreset(preset.parameters);
        }
        setControls();
    }
    
    function updateSimpleKeyframes() {
        setControlsForAllParameters();
    }
    
    Component.onCompleted: {
        defaultOnCompleted()
    }
    function updateProperty_hfov0 () {
        if (!blockUpdate) {
            updateFilter("hfov0", hfov0Slider.value, hfov0KeyframesButton, getPosition());
        }
    }
    property alias prop_hfov0Slider : hfov0Slider;
    property alias prop_hfov0KeyframesButton : hfov0KeyframesButton;
    
    function updateProperty_hfov1 () {
        if (!blockUpdate) {
            updateFilter("hfov1", hfov1Slider.value, hfov1KeyframesButton, getPosition());
        }
    }
    property alias prop_hfov1Slider : hfov1Slider;
    property alias prop_hfov1KeyframesButton : hfov1KeyframesButton;
    
    function updateProperty_vfov0 () {
        if (!blockUpdate) {
            updateFilter("vfov0", vfov0Slider.value, vfov0KeyframesButton, getPosition());
        }
    }
    property alias prop_vfov0Slider : vfov0Slider;
    property alias prop_vfov0KeyframesButton : vfov0KeyframesButton;
    
    function updateProperty_vfov1 () {
        if (!blockUpdate) {
            updateFilter("vfov1", vfov1Slider.value, vfov1KeyframesButton, getPosition());
        }
    }
    property alias prop_vfov1Slider : vfov1Slider;
    property alias prop_vfov1KeyframesButton : vfov1KeyframesButton;
    
    function updateProperty_blurStart () {
        if (!blockUpdate) {
            updateFilter("blurStart", blurStartSlider.value, blurStartKeyframesButton, getPosition());
        }
    }
    property alias prop_blurStartSlider : blurStartSlider;
    property alias prop_blurStartKeyframesButton : blurStartKeyframesButton;
    
    function updateProperty_blurEnd () {
        if (!blockUpdate) {
            updateFilter("blurEnd", blurEndSlider.value, blurEndKeyframesButton, getPosition());
        }
    }
    property alias prop_blurEndSlider : blurEndSlider;
    property alias prop_blurEndKeyframesButton : blurEndKeyframesButton;
    
    GridLayout {
        columns: 4
        anchors.fill: parent
        anchors.margins: 8
        Label {
            text: qsTr('Preset')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.Preset {
            id: preset
            parameters: ["hfov0", "hfov1", "vfov0", "vfov1", "blurStart", "blurEnd"]
            Layout.columnSpan: 3
            onBeforePresetLoaded: {
                defaultBeforePresetLoaded()
            }
            onPresetSelected: {
                defaultPresetSelected()
            }
        }
        Label {
            text: qsTr('Left')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: hfov0Slider
            minimumValue: -180
            maximumValue: 180
            spinnerWidth: 120;
            suffix: ' deg';
            decimals: 3;
            stepSize: 1;
            onValueChanged: updateProperty_hfov0()
        }
        Shotcut.KeyframesButton {
            id: hfov0KeyframesButton;
            checked: isKeyframeButtonChecked("hfov0");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "hfov0", hfov0Slider.value);
            }
        }
        Shotcut.UndoButton {
            id: hfov0Undo
            onClicked: hfov0Slider.value = -90
        }
        Label {
            text: qsTr('Right')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: hfov1Slider
            minimumValue: -180
            maximumValue: 180
            spinnerWidth: 120;
            suffix: ' deg';
            decimals: 3;
            stepSize: 1;
            onValueChanged: updateProperty_hfov1()
        }
        Shotcut.KeyframesButton {
            id: hfov1KeyframesButton;
            checked: isKeyframeButtonChecked("hfov1");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "hfov1", hfov1Slider.value);
            }
        }
        Shotcut.UndoButton {
            id: hfov1Undo
            onClicked: hfov1Slider.value = 90
        }
        Label {
            text: qsTr('Top')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: vfov0Slider
            minimumValue: -90
            maximumValue: 90
            spinnerWidth: 120;
            suffix: ' deg';
            decimals: 3;
            stepSize: 1;
            onValueChanged: updateProperty_vfov0()
        }
        Shotcut.KeyframesButton {
            id: vfov0KeyframesButton;
            checked: isKeyframeButtonChecked("vfov0");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "vfov0", vfov0Slider.value);
            }
        }
        Shotcut.UndoButton {
            id: vfov0Undo
            onClicked: vfov0Slider.value = -45
        }
        Label {
            text: qsTr('Bottom')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: vfov1Slider
            minimumValue: -90
            maximumValue: 90
            spinnerWidth: 120;
            suffix: ' deg';
            decimals: 3;
            stepSize: 1;
            onValueChanged: updateProperty_vfov1()
        }
        Shotcut.KeyframesButton {
            id: vfov1KeyframesButton;
            checked: isKeyframeButtonChecked("vfov1");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "vfov1", vfov1Slider.value);
            }
        }
        Shotcut.UndoButton {
            id: vfov1Undo
            onClicked: vfov1Slider.value = 45
        }
        Label {
            text: qsTr('Blur Start')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: blurStartSlider
            minimumValue: 0
            maximumValue: 2.0
            spinnerWidth: 120;
            suffix: '';
            decimals: 2;
            stepSize: 0.01;
            onValueChanged: updateProperty_blurStart()
        }
        Shotcut.KeyframesButton {
            id: blurStartKeyframesButton;
            checked: isKeyframeButtonChecked("blurStart");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "blurStart", blurStartSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: blurStartUndo
            onClicked: blurStartSlider.value = 0.2
        }
        Label {
            text: qsTr('Blur End')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: blurEndSlider
            minimumValue: 0
            maximumValue: 2.0
            spinnerWidth: 120;
            suffix: '';
            decimals: 2;
            stepSize: 0.01;
            onValueChanged: updateProperty_blurEnd()
        }
        Shotcut.KeyframesButton {
            id: blurEndKeyframesButton;
            checked: isKeyframeButtonChecked("blurEnd");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "blurEnd", blurEndSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: blurEndUndo
            onClicked: blurEndSlider.value = 1.5
        }
    }
    Connections {
        target: filter
        onInChanged: updateSimpleKeyframes();
        onOutChanged: updateSimpleKeyframes();
        onAnimateInChanged: updateSimpleKeyframes();
        onAnimateOutChanged: updateSimpleKeyframes();
        onChanged: setControls();
    }
    
    Connections {
        target: producer;
        onPositionChanged: setControls();
    }
    
}
