/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.digester.ArrayStack;
import org.apache.tomcat.util.digester.CallMethodRule;
import org.apache.tomcat.util.digester.CallParamRule;
import org.apache.tomcat.util.digester.DocumentProperties;
import org.apache.tomcat.util.digester.FactoryCreateRule;
import org.apache.tomcat.util.digester.ObjectCreateRule;
import org.apache.tomcat.util.digester.ObjectCreationFactory;
import org.apache.tomcat.util.digester.Rule;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.digester.Rules;
import org.apache.tomcat.util.digester.RulesBase;
import org.apache.tomcat.util.digester.SetNextRule;
import org.apache.tomcat.util.digester.SetPropertiesRule;
import org.apache.tomcat.util.digester.SystemPropertySource;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.AttributesImpl;

public class Digester
extends DefaultHandler2 {
    protected static IntrospectionUtils.PropertySource[] propertySources;
    private static boolean propertySourcesSet;
    protected static final StringManager sm;
    private static final HashSet<String> generatedClasses;
    private static GeneratedCodeLoader generatedCodeLoader;
    protected IntrospectionUtils.PropertySource[] source;
    protected StringBuilder bodyText = new StringBuilder();
    protected ArrayStack<StringBuilder> bodyTexts = new ArrayStack();
    protected ArrayStack<List<Rule>> matches = new ArrayStack(10);
    protected ClassLoader classLoader = null;
    protected boolean configured = false;
    protected EntityResolver entityResolver;
    protected HashMap<String, String> entityValidator = new HashMap();
    protected ErrorHandler errorHandler = null;
    protected SAXParserFactory factory = null;
    protected Locator locator = null;
    protected String match = "";
    protected boolean namespaceAware = false;
    protected HashMap<String, ArrayStack<String>> namespaces = new HashMap();
    protected ArrayStack<Object> params = new ArrayStack();
    protected SAXParser parser = null;
    protected String publicId = null;
    protected XMLReader reader = null;
    protected Object root = null;
    protected Rules rules = null;
    protected ArrayStack<Object> stack = new ArrayStack();
    protected boolean useContextClassLoader = false;
    protected boolean validating = false;
    protected boolean rulesValidation = false;
    protected Map<Class<?>, List<String>> fakeAttributes = null;
    protected Log log = LogFactory.getLog(Digester.class);
    protected Log saxLog = LogFactory.getLog((String)"org.apache.tomcat.util.digester.Digester.sax");
    protected StringBuilder code = null;
    protected ArrayList<Object> known = new ArrayList();

    public static void setPropertySource(IntrospectionUtils.PropertySource propertySource) {
        if (!propertySourcesSet) {
            propertySources = new IntrospectionUtils.PropertySource[1];
            Digester.propertySources[0] = propertySource;
            propertySourcesSet = true;
        }
    }

    public static void setPropertySource(IntrospectionUtils.PropertySource[] propertySourceArray) {
        if (!propertySourcesSet) {
            propertySources = propertySourceArray;
            propertySourcesSet = true;
        }
    }

    public static void addGeneratedClass(String string) {
        generatedClasses.add(string);
    }

    public static String[] getGeneratedClasses() {
        return generatedClasses.toArray(new String[0]);
    }

    public static boolean isGeneratedCodeLoaderSet() {
        return generatedCodeLoader != null;
    }

    public static void setGeneratedCodeLoader(GeneratedCodeLoader generatedCodeLoader) {
        if (Digester.generatedCodeLoader == null) {
            Digester.generatedCodeLoader = generatedCodeLoader;
        }
    }

    public static Object loadGeneratedClass(String string) {
        if (generatedCodeLoader != null) {
            return generatedCodeLoader.loadGeneratedCode(string);
        }
        return null;
    }

    public Digester() {
        propertySourcesSet = true;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        if (propertySources != null) {
            for (IntrospectionUtils.PropertySource propertySource : propertySources) {
                if (propertySource instanceof SystemPropertySource) {
                    bl = true;
                }
                arrayList.add(propertySource);
            }
        }
        if (!bl) {
            arrayList.add(new SystemPropertySource());
        }
        this.source = arrayList.toArray(new IntrospectionUtils.PropertySource[0]);
    }

    public static void replaceSystemProperties() {
        Log log = LogFactory.getLog(Digester.class);
        if (propertySources != null) {
            Properties properties = System.getProperties();
            Set<String> set = properties.stringPropertyNames();
            for (String string : set) {
                String string2 = System.getProperty(string);
                if (string2 == null) continue;
                try {
                    String string3 = IntrospectionUtils.replaceProperties((String)string2, null, (IntrospectionUtils.PropertySource[])propertySources, null);
                    if (string2.equals(string3)) continue;
                    System.setProperty(string, string3);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("digester.failedToUpdateSystemProperty", new Object[]{string, string2}), (Throwable)exception);
                }
            }
        }
    }

    public void startGeneratingCode() {
        this.code = new StringBuilder();
    }

    public void endGeneratingCode() {
        this.code = null;
        this.known.clear();
    }

    public StringBuilder getGeneratedCode() {
        return this.code;
    }

    public void setKnown(Object object) {
        this.known.add(object);
    }

    public String toVariableName(Object object) {
        boolean bl = false;
        int n = 0;
        if (this.known.size() > 0) {
            for (int i = this.known.size() - 1; i >= 0; --i) {
                if (this.known.get(i) != object) continue;
                n = i;
                bl = true;
                break;
            }
        }
        if (!bl) {
            n = this.known.size();
            this.known.add(object);
        }
        return "tc_" + object.getClass().getSimpleName() + "_" + String.valueOf(n);
    }

    public String findNamespaceURI(String string) {
        ArrayStack<String> arrayStack = this.namespaces.get(string);
        if (arrayStack == null) {
            return null;
        }
        try {
            return arrayStack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int getCount() {
        return this.stack.size();
    }

    public String getCurrentElementName() {
        String string = this.match;
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public SAXParserFactory getFactory() throws SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
            this.factory.setNamespaceAware(this.namespaceAware);
            if (this.namespaceAware) {
                this.factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            this.factory.setValidating(this.validating);
            if (this.validating) {
                this.factory.setFeature("http://xml.org/sax/features/validation", true);
                this.factory.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
        }
        return this.factory;
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.getFactory().setFeature(string, bl);
    }

    public Log getLogger() {
        return this.log;
    }

    public void setLogger(Log log) {
        this.log = log;
    }

    public Log getSAXLogger() {
        return this.saxLog;
    }

    public void setSAXLogger(Log log) {
        this.saxLog = log;
    }

    public String getMatch() {
        return this.match;
    }

    public boolean getNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean bl) {
        this.namespaceAware = bl;
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public SAXParser getParser() {
        if (this.parser != null) {
            return this.parser;
        }
        try {
            this.parser = this.getFactory().newSAXParser();
        }
        catch (Exception exception) {
            this.log.error((Object)sm.getString("digester.createParserError"), (Throwable)exception);
            return null;
        }
        return this.parser;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.getParser().getProperty(string);
    }

    public Rules getRules() {
        if (this.rules == null) {
            this.rules = new RulesBase();
            this.rules.setDigester(this);
        }
        return this.rules;
    }

    public void setRules(Rules rules) {
        this.rules = rules;
        this.rules.setDigester(this);
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean bl) {
        this.useContextClassLoader = bl;
    }

    public boolean getValidating() {
        return this.validating;
    }

    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    public boolean getRulesValidation() {
        return this.rulesValidation;
    }

    public void setRulesValidation(boolean bl) {
        this.rulesValidation = bl;
    }

    public Map<Class<?>, List<String>> getFakeAttributes() {
        return this.fakeAttributes;
    }

    public boolean isFakeAttribute(Object object, String string) {
        if (this.fakeAttributes == null) {
            return false;
        }
        List<String> list = this.fakeAttributes.get(object.getClass());
        if (list == null) {
            list = this.fakeAttributes.get(Object.class);
        }
        if (list == null) {
            return false;
        }
        return list.contains(string);
    }

    public void setFakeAttributes(Map<Class<?>, List<String>> map) {
        this.fakeAttributes = map;
    }

    public XMLReader getXMLReader() throws SAXException {
        if (this.reader == null) {
            this.reader = this.getParser().getXMLReader();
        }
        this.reader.setDTDHandler(this);
        this.reader.setContentHandler(this);
        EntityResolver entityResolver = this.getEntityResolver();
        if (entityResolver == null) {
            entityResolver = this;
        }
        entityResolver = entityResolver instanceof EntityResolver2 ? new EntityResolver2Wrapper((EntityResolver2)entityResolver, this.source, this.classLoader) : new EntityResolverWrapper(entityResolver, this.source, this.classLoader);
        this.reader.setEntityResolver(entityResolver);
        this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        this.reader.setErrorHandler(this);
        return this.reader;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.saxLog.isTraceEnabled()) {
            this.saxLog.trace((Object)("characters(" + new String(cArray, n, n2) + ")"));
        }
        this.bodyText.append(cArray, n, n2);
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.saxLog.isTraceEnabled()) {
            if (this.getCount() > 1) {
                this.saxLog.trace((Object)("endDocument():  " + this.getCount() + " elements left"));
            } else {
                this.saxLog.trace((Object)"endDocument()");
            }
        }
        while (this.getCount() > 1) {
            this.pop();
        }
        for (Rule rule : this.getRules().rules()) {
            try {
                rule.finish();
            }
            catch (Exception exception) {
                this.log.error((Object)sm.getString("digester.error.finish"), (Throwable)exception);
                throw this.createSAXException(exception);
            }
            catch (Error error) {
                this.log.error((Object)sm.getString("digester.error.finish"), (Throwable)error);
                throw error;
            }
        }
        this.clear();
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        int n;
        List<Rule> list;
        boolean bl = this.log.isTraceEnabled();
        if (bl) {
            if (this.saxLog.isDebugEnabled()) {
                this.saxLog.trace((Object)("endElement(" + string + "," + string2 + "," + string3 + ")"));
            }
            this.log.trace((Object)("  match='" + this.match + "'"));
            this.log.trace((Object)("  bodyText='" + this.bodyText + "'"));
        }
        this.bodyText = this.updateBodyText(this.bodyText);
        String string4 = string2;
        if (string4 == null || string4.length() < 1) {
            string4 = string3;
        }
        if ((list = this.matches.pop()) != null && list.size() > 0) {
            String string5 = this.bodyText.toString().intern();
            for (Rule rule : list) {
                try {
                    Rule rule2 = rule;
                    if (bl) {
                        this.log.trace((Object)("  Fire body() for " + rule2));
                    }
                    rule2.body(string, string4, string5);
                }
                catch (Exception exception) {
                    this.log.error((Object)sm.getString("digester.error.body"), (Throwable)exception);
                    throw this.createSAXException(exception);
                }
                catch (Error error) {
                    this.log.error((Object)sm.getString("digester.error.body"), (Throwable)error);
                    throw error;
                }
            }
        } else {
            if (bl) {
                this.log.trace((Object)sm.getString("digester.noRulesFound", new Object[]{this.match}));
            }
            if (this.rulesValidation) {
                this.log.warn((Object)sm.getString("digester.noRulesFound", new Object[]{this.match}));
            }
        }
        this.bodyText = this.bodyTexts.pop();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                int n2 = list.size() - i - 1;
                try {
                    Rule rule;
                    rule = list.get(n2);
                    if (bl) {
                        this.log.trace((Object)("  Fire end() for " + rule));
                    }
                    rule.end(string, string4);
                    continue;
                }
                catch (Exception exception) {
                    this.log.error((Object)sm.getString("digester.error.end"), (Throwable)exception);
                    throw this.createSAXException(exception);
                }
                catch (Error error) {
                    this.log.error((Object)sm.getString("digester.error.end"), (Throwable)error);
                    throw error;
                }
            }
        }
        this.match = (n = this.match.lastIndexOf(47)) >= 0 ? this.match.substring(0, n) : "";
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        ArrayStack<String> arrayStack;
        if (this.saxLog.isTraceEnabled()) {
            this.saxLog.trace((Object)("endPrefixMapping(" + string + ")"));
        }
        if ((arrayStack = this.namespaces.get(string)) == null) {
            return;
        }
        try {
            arrayStack.pop();
            if (arrayStack.empty()) {
                this.namespaces.remove(string);
            }
        }
        catch (EmptyStackException emptyStackException) {
            throw this.createSAXException(sm.getString("digester.emptyStackError"));
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.saxLog.isTraceEnabled()) {
            this.saxLog.trace((Object)("ignorableWhitespace(" + new String(cArray, n, n2) + ")"));
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.saxLog.isTraceEnabled()) {
            this.saxLog.trace((Object)("processingInstruction('" + string + "','" + string2 + "')"));
        }
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.saxLog.isTraceEnabled()) {
            this.saxLog.trace((Object)("setDocumentLocator(" + locator + ")"));
        }
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        if (this.saxLog.isTraceEnabled()) {
            this.saxLog.trace((Object)("skippedEntity(" + string + ")"));
        }
    }

    @Override
    public void startDocument() throws SAXException {
        String string;
        if (this.saxLog.isTraceEnabled()) {
            this.saxLog.trace((Object)"startDocument()");
        }
        if (this.locator instanceof Locator2 && this.root instanceof DocumentProperties.Charset && (string = ((Locator2)this.locator).getEncoding()) != null) {
            try {
                ((DocumentProperties.Charset)this.root).setCharset(B2CConverter.getCharset((String)string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.log.warn((Object)sm.getString("digester.encodingInvalid", new Object[]{string}), (Throwable)unsupportedEncodingException);
            }
        }
        this.configure();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = this.log.isTraceEnabled();
        if (this.saxLog.isTraceEnabled()) {
            this.saxLog.trace((Object)("startElement(" + string + "," + string2 + "," + string3 + ")"));
        }
        attributes = this.updateAttributes(attributes);
        this.bodyTexts.push(this.bodyText);
        this.bodyText = new StringBuilder();
        String string4 = string2;
        if (string4 == null || string4.length() < 1) {
            string4 = string3;
        }
        StringBuilder stringBuilder = new StringBuilder(this.match);
        if (this.match.length() > 0) {
            stringBuilder.append('/');
        }
        stringBuilder.append(string4);
        this.match = stringBuilder.toString();
        if (bl) {
            this.log.trace((Object)("  New match='" + this.match + "'"));
        }
        List<Rule> list = this.getRules().match(string, this.match);
        this.matches.push(list);
        if (list != null && list.size() > 0) {
            for (Rule rule : list) {
                try {
                    Rule rule2 = rule;
                    if (bl) {
                        this.log.trace((Object)("  Fire begin() for " + rule2));
                    }
                    rule2.begin(string, string4, attributes);
                }
                catch (Exception exception) {
                    this.log.error((Object)sm.getString("digester.error.begin"), (Throwable)exception);
                    throw this.createSAXException(exception);
                }
                catch (Error error) {
                    this.log.error((Object)sm.getString("digester.error.begin"), (Throwable)error);
                    throw error;
                }
            }
        } else if (bl) {
            this.log.trace((Object)sm.getString("digester.noRulesFound", new Object[]{this.match}));
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        ArrayStack<String> arrayStack;
        if (this.saxLog.isTraceEnabled()) {
            this.saxLog.trace((Object)("startPrefixMapping(" + string + "," + string2 + ")"));
        }
        if ((arrayStack = this.namespaces.get(string)) == null) {
            arrayStack = new ArrayStack();
            this.namespaces.put(string, arrayStack);
        }
        arrayStack.push(string2);
    }

    @Override
    public void notationDecl(String string, String string2, String string3) {
        if (this.saxLog.isTraceEnabled()) {
            this.saxLog.trace((Object)("notationDecl(" + string + "," + string2 + "," + string3 + ")"));
        }
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        if (this.saxLog.isTraceEnabled()) {
            this.saxLog.trace((Object)("unparsedEntityDecl(" + string + "," + string2 + "," + string3 + "," + string4 + ")"));
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public InputSource resolveEntity(String string, String string2, String string3, String string4) throws SAXException, IOException {
        String string5;
        block13: {
            if (this.saxLog.isTraceEnabled()) {
                this.saxLog.trace((Object)("resolveEntity('" + string2 + "', '" + string4 + "', '" + string3 + "')"));
            }
            string5 = null;
            if (string2 != null) {
                string5 = this.entityValidator.get(string2);
            }
            if (string5 == null) {
                if (string4 == null) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)(" Cannot resolve entity: '" + string2 + "'"));
                    }
                    return null;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(" Trying to resolve using system ID '" + string4 + "'"));
                }
                string5 = string4;
                if (string3 != null) {
                    try {
                        URI uRI = new URI(string4);
                        if (!uRI.isAbsolute()) {
                            string5 = new URI(string3).resolve(uRI).toString();
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        if (!this.log.isDebugEnabled()) break block13;
                        this.log.debug((Object)sm.getString("digester.invalidURI", new Object[]{string3, string4}));
                    }
                }
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(" Resolving to alternate DTD '" + string5 + "'"));
        }
        try {
            return new InputSource(string5);
        }
        catch (Exception exception) {
            throw this.createSAXException(exception);
        }
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.setPublicId(string2);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.log.error((Object)sm.getString("digester.parseError", new Object[]{sAXParseException.getLineNumber(), sAXParseException.getColumnNumber()}), (Throwable)sAXParseException);
        if (this.errorHandler != null) {
            this.errorHandler.error(sAXParseException);
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.log.error((Object)sm.getString("digester.parseErrorFatal", new Object[]{sAXParseException.getLineNumber(), sAXParseException.getColumnNumber()}), (Throwable)sAXParseException);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(sAXParseException);
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.log.error((Object)sm.getString("digester.parseWarning", new Object[]{sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException}));
        if (this.errorHandler != null) {
            this.errorHandler.warning(sAXParseException);
        }
    }

    public Object parse(File file) throws IOException, SAXException {
        this.configure();
        InputSource inputSource = new InputSource(new FileInputStream(file));
        inputSource.setSystemId("file://" + file.getAbsolutePath());
        this.getXMLReader().parse(inputSource);
        return this.root;
    }

    public Object parse(InputSource inputSource) throws IOException, SAXException {
        this.configure();
        this.getXMLReader().parse(inputSource);
        return this.root;
    }

    public Object parse(InputStream inputStream) throws IOException, SAXException {
        this.configure();
        InputSource inputSource = new InputSource(inputStream);
        this.getXMLReader().parse(inputSource);
        return this.root;
    }

    public void register(String string, String string2) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("register('" + string + "', '" + string2 + "'"));
        }
        this.entityValidator.put(string, string2);
    }

    public void addRule(String string, Rule rule) {
        rule.setDigester(this);
        this.getRules().add(string, rule);
    }

    public void addRuleSet(RuleSet ruleSet) {
        ruleSet.addRuleInstances(this);
    }

    public void addCallMethod(String string, String string2) {
        this.addRule(string, new CallMethodRule(string2));
    }

    public void addCallMethod(String string, String string2, int n) {
        this.addRule(string, new CallMethodRule(string2, n));
    }

    public void addCallParam(String string, int n) {
        this.addRule(string, new CallParamRule(n));
    }

    public void addFactoryCreate(String string, ObjectCreationFactory objectCreationFactory, boolean bl) {
        objectCreationFactory.setDigester(this);
        this.addRule(string, new FactoryCreateRule(objectCreationFactory, bl));
    }

    public void addObjectCreate(String string, String string2) {
        this.addRule(string, new ObjectCreateRule(string2));
    }

    public void addObjectCreate(String string, String string2, String string3) {
        this.addRule(string, new ObjectCreateRule(string2, string3));
    }

    public void addSetNext(String string, String string2, String string3) {
        this.addRule(string, new SetNextRule(string2, string3));
    }

    public void addSetProperties(String string) {
        this.addRule(string, new SetPropertiesRule());
    }

    public void addSetProperties(String string, String[] stringArray) {
        this.addRule(string, new SetPropertiesRule(stringArray));
    }

    public void clear() {
        this.match = "";
        this.bodyTexts.clear();
        this.params.clear();
        this.publicId = null;
        this.stack.clear();
        this.log = null;
        this.saxLog = null;
        this.configured = false;
    }

    public void reset() {
        this.root = null;
        this.setErrorHandler(null);
        this.clear();
    }

    public Object peek() {
        try {
            return this.stack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            this.log.warn((Object)sm.getString("digester.emptyStack"));
            return null;
        }
    }

    public Object peek(int n) {
        try {
            return this.stack.peek(n);
        }
        catch (EmptyStackException emptyStackException) {
            this.log.warn((Object)sm.getString("digester.emptyStack"));
            return null;
        }
    }

    public Object pop() {
        try {
            return this.stack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            this.log.warn((Object)sm.getString("digester.emptyStack"));
            return null;
        }
    }

    public void push(Object object) {
        if (this.stack.size() == 0) {
            this.root = object;
        }
        this.stack.push(object);
    }

    public Object getRoot() {
        return this.root;
    }

    protected void configure() {
        if (this.configured) {
            return;
        }
        this.log = LogFactory.getLog((String)"org.apache.tomcat.util.digester.Digester");
        this.saxLog = LogFactory.getLog((String)"org.apache.tomcat.util.digester.Digester.sax");
        this.configured = true;
    }

    public Object peekParams() {
        try {
            return this.params.peek();
        }
        catch (EmptyStackException emptyStackException) {
            this.log.warn((Object)sm.getString("digester.emptyStack"));
            return null;
        }
    }

    public Object popParams() {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Popping params");
            }
            return this.params.pop();
        }
        catch (EmptyStackException emptyStackException) {
            this.log.warn((Object)sm.getString("digester.emptyStack"));
            return null;
        }
    }

    public void pushParams(Object object) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Pushing params");
        }
        this.params.push(object);
    }

    public SAXException createSAXException(String string, Exception exception) {
        Object object;
        if (exception != null && exception instanceof InvocationTargetException) {
            object = exception.getCause();
            if (object instanceof ThreadDeath) {
                throw (ThreadDeath)object;
            }
            if (object instanceof VirtualMachineError) {
                throw (VirtualMachineError)object;
            }
            if (object instanceof Exception) {
                exception = (Exception)object;
            }
        }
        if (this.locator != null) {
            object = sm.getString("digester.errorLocation", new Object[]{this.locator.getLineNumber(), this.locator.getColumnNumber(), string});
            if (exception != null) {
                return new SAXParseException((String)object, this.locator, exception);
            }
            return new SAXParseException((String)object, this.locator);
        }
        this.log.error((Object)sm.getString("digester.noLocator"));
        if (exception != null) {
            return new SAXException(string, exception);
        }
        return new SAXException(string);
    }

    public SAXException createSAXException(Exception exception) {
        if (exception instanceof InvocationTargetException) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof VirtualMachineError) {
                throw (VirtualMachineError)throwable;
            }
            if (throwable instanceof Exception) {
                exception = (Exception)throwable;
            }
        }
        return this.createSAXException(exception.getMessage(), exception);
    }

    public SAXException createSAXException(String string) {
        return this.createSAXException(string, null);
    }

    private Attributes updateAttributes(Attributes attributes) {
        if (attributes.getLength() == 0) {
            return attributes;
        }
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = attributesImpl.getLength();
        for (int i = 0; i < n; ++i) {
            String string = attributesImpl.getValue(i);
            try {
                attributesImpl.setValue(i, IntrospectionUtils.replaceProperties((String)string, null, (IntrospectionUtils.PropertySource[])this.source, (ClassLoader)this.getClassLoader()).intern());
                continue;
            }
            catch (Exception exception) {
                this.log.warn((Object)sm.getString("digester.failedToUpdateAttributes", new Object[]{attributesImpl.getLocalName(i), string}), (Throwable)exception);
            }
        }
        return attributesImpl;
    }

    private StringBuilder updateBodyText(StringBuilder stringBuilder) {
        String string;
        String string2 = stringBuilder.toString();
        try {
            string = IntrospectionUtils.replaceProperties((String)string2, null, (IntrospectionUtils.PropertySource[])this.source, (ClassLoader)this.getClassLoader());
        }
        catch (Exception exception) {
            return stringBuilder;
        }
        if (string == string2) {
            return stringBuilder;
        }
        return new StringBuilder(string);
    }

    static {
        propertySourcesSet = false;
        sm = StringManager.getManager(Digester.class);
        String string = System.getProperty("org.apache.tomcat.util.digester.PROPERTY_SOURCE");
        ArrayList<IntrospectionUtils.PropertySource> arrayList = new ArrayList<IntrospectionUtils.PropertySource>();
        IntrospectionUtils.PropertySource[] propertySourceArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            block2: while (stringTokenizer.hasMoreTokens()) {
                ClassLoader[] classLoaderArray;
                String string2 = stringTokenizer.nextToken().trim();
                for (ClassLoader classLoader : classLoaderArray = new ClassLoader[]{Digester.class.getClassLoader(), Thread.currentThread().getContextClassLoader()}) {
                    try {
                        Class<?> clazz = Class.forName(string2, true, classLoader);
                        arrayList.add((IntrospectionUtils.PropertySource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                        continue block2;
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        LogFactory.getLog(Digester.class).error((Object)sm.getString("digester.propertySourceLoadError", new Object[]{string2}), throwable);
                    }
                }
            }
            propertySourceArray = arrayList.toArray(new IntrospectionUtils.PropertySource[0]);
        }
        if (propertySourceArray != null) {
            propertySources = propertySourceArray;
            propertySourcesSet = true;
        }
        if (Boolean.getBoolean("org.apache.tomcat.util.digester.REPLACE_SYSTEM_PROPERTIES")) {
            Digester.replaceSystemProperties();
        }
        generatedClasses = new HashSet();
    }

    public static interface GeneratedCodeLoader {
        public Object loadGeneratedCode(String var1);
    }

    private static class EntityResolver2Wrapper
    extends EntityResolverWrapper
    implements EntityResolver2 {
        private final EntityResolver2 entityResolver2;

        EntityResolver2Wrapper(EntityResolver2 entityResolver2, IntrospectionUtils.PropertySource[] propertySourceArray, ClassLoader classLoader) {
            super(entityResolver2, propertySourceArray, classLoader);
            this.entityResolver2 = entityResolver2;
        }

        @Override
        public InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
            string = this.replace(string);
            string2 = this.replace(string2);
            return this.entityResolver2.getExternalSubset(string, string2);
        }

        @Override
        public InputSource resolveEntity(String string, String string2, String string3, String string4) throws SAXException, IOException {
            string = this.replace(string);
            string2 = this.replace(string2);
            string3 = this.replace(string3);
            string4 = this.replace(string4);
            return this.entityResolver2.resolveEntity(string, string2, string3, string4);
        }
    }

    private static class EntityResolverWrapper
    implements EntityResolver {
        private final EntityResolver entityResolver;
        private final IntrospectionUtils.PropertySource[] source;
        private final ClassLoader classLoader;

        EntityResolverWrapper(EntityResolver entityResolver, IntrospectionUtils.PropertySource[] propertySourceArray, ClassLoader classLoader) {
            this.entityResolver = entityResolver;
            this.source = propertySourceArray;
            this.classLoader = classLoader;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            string = this.replace(string);
            string2 = this.replace(string2);
            return this.entityResolver.resolveEntity(string, string2);
        }

        protected String replace(String string) {
            try {
                return IntrospectionUtils.replaceProperties((String)string, null, (IntrospectionUtils.PropertySource[])this.source, (ClassLoader)this.classLoader);
            }
            catch (Exception exception) {
                return string;
            }
        }
    }
}

