/*
 * Decompiled with CFR 0.152.
 */
package hughai;

import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.basictypes.Float3;
import hughai.utils.Formatting;
import hughai.utils.LogFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Ownership {
    int maxdistanceconsideredsame = 500;
    List<OwnershipOrder> orders = new ArrayList<OwnershipOrder>();
    Map<Unit, OwnershipOrder> ordersbyconstructor = new HashMap<Unit, OwnershipOrder>();
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;

    Ownership(PlayerObjects playerObjects) {
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.csai.registerGameListener(new GameListener());
        if (this.csai.DebugOn) {
            this.csai.RegisterVoiceCommand("dumpownership", new DumpOwnershipHandler());
        }
    }

    public void SignalConstructorIsIdle(Unit unit) {
        this.RemovePreviousOrdersFromThisConstructor(unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RemovePreviousOrdersFromThisConstructor(Unit unit) {
        List<OwnershipOrder> list = this.orders;
        synchronized (list) {
            if (this.ordersbyconstructor.containsKey(unit)) {
                OwnershipOrder ownershipOrder = this.ordersbyconstructor.get(unit);
                this.logfile.WriteLine("Removing order by " + unit.getUnitId() + " for " + ownershipOrder.orderedunit.getHumanName());
                ownershipOrder.builder.UnitDestroyed(ownershipOrder, ownershipOrder.newunit);
                this.orders.remove(ownershipOrder);
                this.ordersbyconstructor.remove(unit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOrder RegisterBuildingOrder(IBuilder iBuilder, Unit unit, UnitDef unitDef, Float3 float3) {
        this.RemovePreviousOrdersFromThisConstructor(unit);
        OwnershipOrder ownershipOrder = new OwnershipOrder(iBuilder, unit, unitDef, float3);
        List<OwnershipOrder> list = this.orders;
        synchronized (list) {
            this.orders.add(ownershipOrder);
            this.ordersbyconstructor.put(unit, ownershipOrder);
        }
        return ownershipOrder;
    }

    class GameListener
    extends GameAdapter {
        GameListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void UnitDestroyed(Unit unit, Unit unit2) {
            List<OwnershipOrder> list = Ownership.this.orders;
            synchronized (list) {
                ArrayList<OwnershipOrder> arrayList = new ArrayList<OwnershipOrder>();
                for (OwnershipOrder ownershipOrder : Ownership.this.orders) {
                    if (ownershipOrder.newunit != unit) continue;
                    ownershipOrder.builder.UnitDestroyed(ownershipOrder, unit);
                    arrayList.add(ownershipOrder);
                }
                for (OwnershipOrder ownershipOrder : arrayList) {
                    Ownership.this.orders.remove(ownershipOrder);
                }
                Ownership.this.ordersbyconstructor.remove(unit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void UnitCreated(Unit unit, Unit unit2) {
            if (unit2 != null) {
                Ownership.this.logfile.WriteLine("Ownership.unitcreated " + unit.getUnitId() + " " + unit.getDef().getHumanName() + " by " + unit2.getUnitId() + " " + unit2.getDef().getHumanName());
            } else {
                Ownership.this.logfile.WriteLine("Ownership.unitcreated " + unit.getUnitId() + " " + unit.getDef().getHumanName());
            }
            List<OwnershipOrder> list = Ownership.this.orders;
            synchronized (list) {
                for (OwnershipOrder ownershipOrder : Ownership.this.orders) {
                    if (ownershipOrder.constructor != unit2) continue;
                    Ownership.this.logfile.WriteLine(" ... matches order");
                    ownershipOrder.newunit = unit;
                    ownershipOrder.builder.UnitCreated(ownershipOrder, unit);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void UnitFinished(Unit unit) {
            List<OwnershipOrder> list = Ownership.this.orders;
            synchronized (list) {
                Random random = new Random();
                ArrayList<OwnershipOrder> arrayList = new ArrayList<OwnershipOrder>();
                Ownership.this.logfile.WriteLine("orders count is : " + Ownership.this.orders.size());
                try {
                    for (OwnershipOrder ownershipOrder : Ownership.this.orders) {
                        if (ownershipOrder.newunit != unit) continue;
                        ownershipOrder.builder.UnitFinished(ownershipOrder, unit);
                        arrayList.add(ownershipOrder);
                    }
                    for (OwnershipOrder ownershipOrder : arrayList) {
                        Ownership.this.logfile.WriteLine("removing order for " + ownershipOrder.orderedunit.getHumanName() + " , built by " + ownershipOrder.constructor.getUnitId() + " " + ownershipOrder.constructor.getDef().getHumanName());
                        Ownership.this.orders.remove(ownershipOrder);
                    }
                    Ownership.this.ordersbyconstructor.remove(unit);
                }
                catch (Exception exception) {
                    Ownership.this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
                    Ownership.this.logfile.WriteLine(exception.toString());
                    throw new RuntimeException(exception);
                }
            }
        }
    }

    public class DumpOwnershipHandler
    implements VoiceCommandHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            List<OwnershipOrder> list = Ownership.this.orders;
            synchronized (list) {
                Ownership.this.logfile.WriteLine("number orders: " + Ownership.this.orders.size());
                for (OwnershipOrder ownershipOrder : Ownership.this.orders) {
                    Ownership.this.logfile.WriteLine(ownershipOrder.toString());
                }
            }
        }
    }

    static class OwnershipOrder
    implements IOrder {
        public IBuilder builder;
        public Unit constructor;
        public UnitDef orderedunit;
        public Float3 pos;
        public Unit newunit = null;

        public OwnershipOrder() {
        }

        public OwnershipOrder(IBuilder iBuilder, Unit unit, UnitDef unitDef, Float3 float3) {
            this.builder = iBuilder;
            this.constructor = unit;
            this.orderedunit = unitDef;
            this.pos = float3;
        }

        public String toString() {
            return "OwnershipOrder orderedunit: " + this.orderedunit.getHumanName() + " pos " + this.pos.toString() + " deployedid " + this.newunit;
        }
    }

    public static interface IOrder {
    }

    public static interface IBuilder {
        public void UnitCreated(IOrder var1, Unit var2);

        public void UnitFinished(IOrder var1, Unit var2);

        public void UnitDestroyed(IOrder var1, Unit var2);
    }
}

