################################################################################
#
# This module provides the following imported targets, if found:
#
#  rz_analysis::rz_analysis
#
# This file is intended to be consumed by clients who wish to use rz_analysis from CMake.
# The recommended way to use find this module is using `find_package(Rizin COMPONENTS ...)`.
#
# Provides the following variables
# rz_analysis_FOUND        - Flag for indicating that rz_analysis package has been found
# rz_analysis_VERSION      - Version of rz_analysis
# rz_analysis_INCLUDE_DIRS - Directories to include
# rz_analysis_LIBRARY      - Path to the single library that this module represents, without dependencies
# rz_analysis_LIBRARIES    - Libraries to link
# rz_analysis_LIBRARY_DIRS - Library directories to search for link libraries
# rz_analysis_PLUGINDIR    - Directory where plugins are placed, without the prefix part
#
################################################################################

set(RIZIN_MODULE_PREFIXED rz_analysis)
set(rz_analysis_VERSION 0.4.1)

# FIXME: workaround for https://github.com/mesonbuild/meson/issues/9702 (see https://github.com/rizinorg/rizin/issues/2102)
get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../.." ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

set(rz_analysis_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include/librz" "${PACKAGE_PREFIX_DIR}/include/librz/sdb")
set_and_check(rz_analysis_LIBRARY_DIRS "${PACKAGE_PREFIX_DIR}/lib")
find_library(rz_analysis_LIBRARY NAMES rz_analysis HINTS "${rz_analysis_LIBRARY_DIRS}" NO_DEFAULT_PATH REQUIRED)
set(rz_analysis_LIBRARIES "${rz_analysis_LIBRARY}")
set(_rz_analysis_DEPENDENCIES rz_util rz_crypto rz_reg rz_asm rz_parse rz_syscall rz_search rz_cons rz_diff rz_bin rz_flag rz_type)
set(rz_analysis_PLUGINDIR lib/rizin/plugins)

include(CMakeFindDependencyMacro)
get_filename_component(_rizin_cmake_path "${CMAKE_CURRENT_LIST_DIR}/.." ABSOLUTE)
set(_rz_analysis_DEPENDENCY_TARGETS)
foreach(_module_dep ${_rz_analysis_DEPENDENCIES})
  if (NOT ${_module_dep}_FOUND)
    find_dependency(${_module_dep} PATHS ${_rizin_cmake_path})
  endif()

  if (NOT ${_module_dep}_FOUND)
    set(rz_analysis_FOUND False)
    return()
  endif()

  list(APPEND rz_analysis_INCLUDE_DIRS "${${_module_dep}_INCLUDE_DIRS}")
  list(APPEND rz_analysis_LIBRARIES "${${_module_dep}_LIBRARIES}")
  list(APPEND _rz_analysis_DEPENDENCY_TARGETS "${_module_dep}::${_module_dep}")
endforeach()

list(REMOVE_DUPLICATES rz_analysis_INCLUDE_DIRS)
list(REMOVE_DUPLICATES rz_analysis_LIBRARIES)

if(NOT TARGET rz_analysis::rz_analysis)
  add_library(rz_analysis::rz_analysis SHARED IMPORTED)
  target_link_libraries(rz_analysis::rz_analysis INTERFACE ${_rz_analysis_DEPENDENCY_TARGETS})
  set_target_properties(rz_analysis::rz_analysis PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${rz_analysis_INCLUDE_DIRS}")
  set_target_properties(rz_analysis::rz_analysis PROPERTIES
    IMPORTED_LOCATION "${rz_analysis_LIBRARY}")
endif()
set(rz_analysis_TARGET rz_analysis::rz_analysis)
