/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_yue extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "ADP", "ADP" },
            { "AED", "AED" },
            { "AFA", "AFA" },
            { "AFN", "AFN" },
            { "ALK", "ALK" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "AOK", "AOK" },
            { "AON", "AON" },
            { "AOR", "AOR" },
            { "ARA", "ARA" },
            { "ARL", "ARL" },
            { "ARM", "ARM" },
            { "ARP", "ARP" },
            { "ARS", "ARS" },
            { "ATS", "ATS" },
            { "AUD", "AU$" },
            { "AWG", "AWG" },
            { "AZM", "AZM" },
            { "AZN", "AZN" },
            { "BAD", "BAD" },
            { "BAM", "BAM" },
            { "BAN", "BAN" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BEC", "BEC" },
            { "BEF", "BEF" },
            { "BEL", "BEL" },
            { "BGL", "BGL" },
            { "BGM", "BGM" },
            { "BGN", "BGN" },
            { "BGO", "BGO" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BOL", "BOL" },
            { "BOP", "BOP" },
            { "BOV", "BOV" },
            { "BRB", "BRB" },
            { "BRC", "BRC" },
            { "BRE", "BRE" },
            { "BRN", "BRN" },
            { "BRR", "BRR" },
            { "BRZ", "BRZ" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BUK", "BUK" },
            { "BWP", "BWP" },
            { "BYB", "BYB" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHE", "CHE" },
            { "CHF", "CHF" },
            { "CHW", "CHW" },
            { "CLE", "CLE" },
            { "CLF", "CLF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "CNX", "CNX" },
            { "COP", "COP" },
            { "COU", "COU" },
            { "CRC", "CRC" },
            { "CSD", "CSD" },
            { "CSK", "CSK" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CYP", "CYP" },
            { "CZK", "CZK" },
            { "DDM", "DDM" },
            { "DEM", "DEM" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "ECS", "ECS" },
            { "ECV", "ECV" },
            { "EEK", "EEK" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ESA", "ESA" },
            { "ESB", "ESB" },
            { "ESP", "ESP" },
            { "ETB", "ETB" },
            { "FIM", "FIM" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "FRF", "FRF" },
            { "GEK", "GEK" },
            { "GEL", "GEL" },
            { "GHC", "GHC" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GNS", "GNS" },
            { "GQE", "GQE" },
            { "GRD", "GRD" },
            { "GTQ", "GTQ" },
            { "GWE", "GWE" },
            { "GWP", "GWP" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRD", "HRD" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IEP", "IEP" },
            { "ILP", "ILP" },
            { "ILR", "ILR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISJ", "ISJ" },
            { "ISK", "ISK" },
            { "ITL", "ITL" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "JPY", "\u00a5" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KRH", "KRH" },
            { "KRO", "KRO" },
            { "KRW", "\uffe6" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LSL", "LSL" },
            { "LTL", "LTL" },
            { "LTT", "LTT" },
            { "LUC", "LUC" },
            { "LUF", "LUF" },
            { "LUL", "LUL" },
            { "LVL", "LVL" },
            { "LVR", "LVR" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MAF", "MAF" },
            { "MCF", "MCF" },
            { "MDC", "MDC" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MGF", "MGF" },
            { "MKD", "MKD" },
            { "MKN", "MKN" },
            { "MLF", "MLF" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MTL", "MTL" },
            { "MTP", "MTP" },
            { "MUR", "MUR" },
            { "MVP", "MVP" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MXP", "MXP" },
            { "MXV", "MXV" },
            { "MYR", "MYR" },
            { "MZE", "MZE" },
            { "MZM", "MZM" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIC", "NIC" },
            { "NIO", "NIO" },
            { "NLG", "NLG" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEI", "PEI" },
            { "PEN", "PEN" },
            { "PES", "PES" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PLZ", "PLZ" },
            { "PTE", "PTE" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RHD", "RHD" },
            { "ROL", "ROL" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RUR", "RUR" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDD", "SDD" },
            { "SDG", "SDG" },
            { "SDP", "SDP" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SIT", "SIT" },
            { "SKK", "SKK" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SRG", "SRG" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "SUR", "SUR" },
            { "SVC", "SVC" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "THB" },
            { "TJR", "TJR" },
            { "TJS", "TJS" },
            { "TMM", "TMM" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TPE", "TPE" },
            { "TRL", "TRL" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UAK", "UAK" },
            { "UGS", "UGS" },
            { "UGX", "UGX" },
            { "USN", "USN" },
            { "USS", "USS" },
            { "UYI", "UYI" },
            { "UYP", "UYP" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEB", "VEB" },
            { "VEF", "VEF" },
            { "VNN", "VNN" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "XAG", "XAG" },
            { "XAU", "XAU" },
            { "XBA", "XBA" },
            { "XBB", "XBB" },
            { "XBC", "XBC" },
            { "XBD", "XBD" },
            { "XDR", "XDR" },
            { "XEU", "XEU" },
            { "XFO", "XFO" },
            { "XFU", "XFU" },
            { "XPD", "XPD" },
            { "XPT", "XPT" },
            { "XRE", "XRE" },
            { "XSU", "XSU" },
            { "XTS", "XTS" },
            { "XUA", "XUA" },
            { "XXX", "XXX" },
            { "YDD", "YDD" },
            { "YER", "YER" },
            { "YUD", "YUD" },
            { "YUM", "YUM" },
            { "YUN", "YUN" },
            { "YUR", "YUR" },
            { "ZAL", "ZAL" },
            { "ZAR", "ZAR" },
            { "ZMK", "ZMK" },
            { "ZMW", "ZMW" },
            { "ZRN", "ZRN" },
            { "ZRZ", "ZRZ" },
            { "ZWD", "ZWD" },
            { "ZWL", "ZWL" },
            { "ZWR", "ZWR" },
            { "adp", "\u5b89\u9053\u723e\u966a\u58eb\u7279" },
            { "aed", "\u963f\u62c9\u4f2f\u806f\u5408\u5927\u516c\u570b\u8fea\u723e\u6c57" },
            { "afa", "\u963f\u5bcc\u6c57\u5c3c (1927\u20132002)" },
            { "afn", "\u963f\u5bcc\u6c57\u5c3c" },
            { "alk", "\u963f\u723e\u5df4\u5c3c\u4e9e\u5217\u514b (1946\u20131965)" },
            { "all", "\u963f\u723e\u5df4\u5c3c\u4e9e\u5217\u514b" },
            { "amd", "\u4e9e\u7f8e\u5c3c\u4e9e\u5fb7\u62c9\u59c6" },
            { "ang", "\u8377\u5c6c\u5b89\u5730\u5217\u65af\u76fe" },
            { "aoa", "\u5b89\u54e5\u62c9\u5bec\u624e" },
            { "aok", "\u5b89\u54e5\u62c9\u5bec\u624e (1977\u20131990)" },
            { "aon", "\u5b89\u54e5\u62c9\u65b0\u5bec\u624e (1990\u20132000)" },
            { "aor", "\u5b89\u54e5\u62c9\u65b0\u8abf\u5bec\u624e (1995\u20131999)" },
            { "ara", "\u963f\u6839\u5ef7\u5967\u65af\u7279\u7d0d\u723e" },
            { "arl", "\u963f\u6839\u5ef7\u62ab\u7d22 (1970\u20131983)" },
            { "arm", "\u963f\u6839\u5ef7\u62ab\u7d22 (1881\u20131970)" },
            { "arp", "\u963f\u6839\u5ef7\u62ab\u7d22 (1983\u20131985)" },
            { "ars", "\u963f\u6839\u5ef7\u62ab\u7d22" },
            { "ats", "\u5967\u5730\u5229\u5148\u4ee4" },
            { "aud", "\u6fb3\u5e63" },
            { "awg", "\u963f\u8def\u5df4\u76fe" },
            { "azm", "\u4e9e\u585e\u62dc\u7136\u99ac\u7d0d\u7279 (1993\u20132006)" },
            { "azn", "\u4e9e\u585e\u62dc\u7136\u99ac\u7d0d\u7279" },
            { "bad", "\u6ce2\u58eb\u5c3c\u4e9e-\u8d6b\u585e\u54e5\u7dad\u7d0d\u7b2c\u7d0d\u723e" },
            { "bam", "\u6ce2\u58eb\u5c3c\u4e9e-\u8d6b\u585e\u54e5\u7dad\u7d0d\u53ef\u8f49\u63db\u99ac\u514b" },
            { "ban", "\u6ce2\u58eb\u5c3c\u4e9e-\u8d6b\u585e\u54e5\u7dad\u7d0d\u65b0\u7b2c\u7d0d\u723e" },
            { "bbd", "\u5df4\u8c9d\u591a\u5143" },
            { "bdt", "\u5b5f\u52a0\u62c9\u5854\u5361" },
            { "bec", "\u6bd4\u5229\u6642\u6cd5\u90ce\uff08\u53ef\u8f49\u63db\uff09" },
            { "bef", "\u6bd4\u5229\u6642\u6cd5\u90ce" },
            { "bel", "\u6bd4\u5229\u6642\u6cd5\u90ce\uff08\u91d1\u878d\uff09" },
            { "bgl", "\u4fdd\u52a0\u5229\u4e9e\u786c\u5217\u5f17" },
            { "bgm", "\u4fdd\u52a0\u5229\u4e9e\u793e\u6703\u9ee8\u5217\u5f17" },
            { "bgn", "\u4fdd\u52a0\u5229\u4e9e\u65b0\u5217\u5f17" },
            { "bgo", "\u4fdd\u52a0\u5229\u4e9e\u5217\u5f17 (1879\u20131952)" },
            { "bhd", "\u5df4\u6797\u7b2c\u7d0d\u723e" },
            { "bif", "\u84b2\u9686\u5730\u6cd5\u90ce" },
            { "bmd", "\u767e\u6155\u9054\u5e63" },
            { "bnd", "\u6c76\u840a\u5143" },
            { "bob", "\u73bb\u5229\u7dad\u4e9e\u8afe" },
            { "bol", "\u73bb\u5229\u7dad\u4e9e\u73bb\u5229\u7dad\u4e9e\u8afe (1863\u20131963)" },
            { "bop", "\u73bb\u5229\u7dad\u4e9e\u62ab\u7d22" },
            { "bov", "\u73bb\u5229\u7dad\u4e9e\u5e55\u591a" },
            { "brb", "\u5df4\u897f\u514b\u9b6f\u85a9\u591a\u8fb2\u74e6 (1967\u20131986)" },
            { "brc", "\u5df4\u897f\u514b\u9b6f\u8cfd\u7f85 (1986\u20131989)" },
            { "bre", "\u5df4\u897f\u514b\u9b6f\u8cfd\u7f85 (1990\u20131993)" },
            { "brl", "\u5df4\u897f\u91cc\u62c9" },
            { "brn", "\u5df4\u897f\u514b\u5982\u723e\u9054\u8fb2\u74e6" },
            { "brr", "\u5df4\u897f\u514b\u9b6f\u8cfd\u7f85 (1993\u20131994)" },
            { "brz", "\u5df4\u897f\u514b\u9b6f\u8cfd\u7f85 (1942 \u20131967)" },
            { "bsd", "\u5df4\u54c8\u99ac\u5143" },
            { "btn", "\u4e0d\u4e39\u90a3\u7279\u502b" },
            { "buk", "\u7dec\u7538\u57fa\u96c5\u7279" },
            { "bwp", "\u6ce2\u672d\u90a3\u666e\u62c9" },
            { "byb", "\u767d\u4fc4\u7f85\u65af\u65b0\u76e7\u5e03 (1994\u20131999)" },
            { "byn", "\u767d\u4fc4\u7f85\u65af\u76e7\u5e03" },
            { "byr", "\u767d\u4fc4\u7f85\u65af\u76e7\u5e03 (2000\u20132016)" },
            { "bzd", "\u8c9d\u91cc\u65af\u5143" },
            { "cad", "\u52a0\u5e63" },
            { "cdf", "\u525b\u679c\u6cd5\u90ce" },
            { "che", "\u6b50\u5143 (WIR)" },
            { "chf", "\u745e\u58eb\u6cd5\u90ce" },
            { "chw", "\u6cd5\u90ce (WIR)" },
            { "cle", "\u667a\u5229\u57c3\u65af\u5eab\u591a" },
            { "clf", "\u5361\u6797\u6cb9\u9054\u4f5b\u66fc\u8dce" },
            { "clp", "\u667a\u5229\u62ab\u7d22" },
            { "cnh", "\u4eba\u6c11\u5e63 (\u96e2\u5cb8)" },
            { "cny", "\u4eba\u6c11\u5e63" },
            { "cop", "\u54e5\u502b\u6bd4\u4e9e\u62ab\u7d22" },
            { "cou", "\u54e5\u502b\u6bd4\u4e9e\u5e63 (COU)" },
            { "crc", "\u54e5\u65af\u5927\u9ece\u52a0\u79d1\u6717" },
            { "csd", "\u820a\u585e\u723e\u7dad\u4e9e\u7b2c\u7d0d\u723e" },
            { "csk", "\u6377\u514b\u65af\u6d1b\u4f10\u514b\u786c\u514b\u6717" },
            { "cuc", "\u53e4\u5df4\u53ef\u8f49\u63db\u62ab\u7d22" },
            { "cup", "\u53e4\u5df4\u62ab\u7d22" },
            { "cve", "\u7dad\u5fb7\u89d2\u57c3\u65af\u5eab\u591a" },
            { "cyp", "\u8cfd\u666e\u52d2\u65af\u938a" },
            { "czk", "\u6377\u514b\u514b\u6717" },
            { "ddm", "\u6771\u5fb7\u5967\u65af\u7279\u99ac\u514b" },
            { "dem", "\u5fb7\u570b\u99ac\u514b" },
            { "djf", "\u5409\u5e03\u5730\u6cd5\u90ce" },
            { "dkk", "\u4e39\u9ea5\u514b\u6717" },
            { "dop", "\u591a\u660e\u5c3c\u52a0\u62ab\u7d22" },
            { "dzd", "\u963f\u723e\u53ca\u5229\u4e9e\u7b2c\u7d0d\u723e" },
            { "ecs", "\u5384\u74dc\u591a\u8607\u514b\u96f7" },
            { "ecv", "\u5384\u74dc\u591a\u723e\u7531\u91cc\u9054\u74e6\u5eb7\u65af\u5766 (UVC)" },
            { "eek", "\u611b\u6c99\u5c3c\u4e9e\u514b\u6717" },
            { "egp", "\u57c3\u53ca\u938a" },
            { "ern", "\u5384\u7acb\u7279\u91cc\u4e9e\u7d0d\u514b\u6cd5" },
            { "esa", "\u897f\u73ed\u7259\u6bd4\u585e\u5854\uff08\u6703\u8a08\u55ae\u4f4d\uff09" },
            { "esb", "\u897f\u73ed\u7259\u6bd4\u585e\u5854\uff08\u53ef\u8f49\u63db\u6703\u8a08\u55ae\u4f4d\uff09" },
            { "esp", "\u897f\u73ed\u7259\u966a\u58eb\u7279" },
            { "etb", "\u8863\u7d22\u6bd4\u4e9e\u6bd4\u723e" },
            { "eur", "\u6b50\u5143" },
            { "fim", "\u82ac\u862d\u99ac\u514b" },
            { "fjd", "\u6590\u6fdf\u5143" },
            { "fkp", "\u798f\u514b\u862d\u7fa4\u5cf6\u938a" },
            { "frf", "\u6cd5\u570b\u6cd5\u90ce" },
            { "gbp", "\u82f1\u938a" },
            { "gek", "\u55ac\u6cbb\u4e9e\u5eab\u65c1\u62c9\u91cc" },
            { "gel", "\u55ac\u6cbb\u4e9e\u62c9\u91cc" },
            { "ghc", "\u8fe6\u7d0d\u8cfd\u5730 (1979\u20132007)" },
            { "ghs", "\u8fe6\u7d0d\u585e\u5730" },
            { "gip", "\u76f4\u5e03\u7f85\u9640\u938a" },
            { "gmd", "\u7518\u6bd4\u4e9e\u9054\u62c9\u897f" },
            { "gnf", "\u5e7e\u5167\u4e9e\u6cd5\u90ce" },
            { "gns", "\u5e7e\u5167\u4e9e\u897f\u91cc" },
            { "gqe", "\u8d64\u9053\u5e7e\u5167\u4e9e\u57c3\u594e\u52d2" },
            { "grd", "\u5e0c\u81d8\u5fb7\u62c9\u514b\u99ac" },
            { "gtq", "\u74dc\u5730\u99ac\u62c9\u683c\u67e5\u723e" },
            { "gwe", "\u8461\u5c6c\u5e7e\u5167\u4e9e\u57c3\u65af\u5eab\u591a" },
            { "gwp", "\u5e7e\u5167\u4e9e\u6bd4\u7d22\u62ab\u7d22" },
            { "gyd", "\u572d\u4e9e\u90a3\u5143" },
            { "hkd", "\u6e2f\u5e63" },
            { "hnl", "\u6d2a\u90fd\u62c9\u65af\u502b\u76ae\u62c9" },
            { "hrd", "\u514b\u7f85\u57c3\u897f\u4e9e\u7b2c\u7d0d\u723e" },
            { "hrk", "\u514b\u7f85\u57c3\u897f\u4e9e\u5eab\u7d0d" },
            { "htg", "\u6d77\u5730\u53e4\u5fb7" },
            { "huf", "\u5308\u7259\u5229\u798f\u6797" },
            { "idr", "\u5370\u5c3c\u76fe" },
            { "iep", "\u611b\u723e\u862d\u938a" },
            { "ilp", "\u4ee5\u8272\u5217\u938a" },
            { "ilr", "\u4ee5\u8272\u5217\u8b1d\u514b\u723e (1980\u20131985)" },
            { "ils", "\u4ee5\u8272\u5217\u65b0\u8b1d\u514b\u723e" },
            { "inr", "\u5370\u5ea6\u76e7\u6bd4" },
            { "iqd", "\u4f0a\u62c9\u514b\u7b2c\u7d0d\u723e" },
            { "irr", "\u4f0a\u6717\u91cc\u4e9e\u723e" },
            { "isj", "\u51b0\u5cf6\u514b\u6717 (1918\u20131981)" },
            { "isk", "\u51b0\u5cf6\u514b\u6717" },
            { "itl", "\u7fa9\u5927\u5229\u91cc\u62c9" },
            { "jmd", "\u7259\u8cb7\u52a0\u5143" },
            { "jod", "\u7d04\u65e6\u7b2c\u7d0d\u723e" },
            { "jpy", "\u65e5\u5713" },
            { "kes", "\u80af\u5c3c\u4e9e\u5148\u4ee4" },
            { "kgs", "\u5409\u723e\u5409\u65af\u7d22\u59c6" },
            { "khr", "\u67ec\u57d4\u5be8\u745e\u723e" },
            { "kmf", "\u79d1\u6469\u7f85\u6cd5\u90ce" },
            { "kpw", "\u5317\u97d3\u5713" },
            { "krh", "\u5357\u97d3\u571c" },
            { "kro", "\u5357\u97d3\u5713" },
            { "krw", "\u97d3\u5713" },
            { "kwd", "\u79d1\u5a01\u7279\u7b2c\u7d0d\u723e" },
            { "kyd", "\u958b\u66fc\u7fa4\u5cf6\u5143" },
            { "kzt", "\u5361\u624e\u514b\u65af\u5766\u5766\u5409" },
            { "lak", "\u5bee\u570b\u57fa\u666e" },
            { "lbp", "\u9ece\u5df4\u5ae9\u938a" },
            { "lkr", "\u65af\u91cc\u862d\u5361\u76e7\u6bd4" },
            { "lrd", "\u8cf4\u6bd4\u745e\u4e9e\u5143" },
            { "lsl", "\u8cf4\u7d22\u6258\u6d1b\u8482" },
            { "ltl", "\u7acb\u9676\u5b9b\u7acb\u7279" },
            { "ltt", "\u7acb\u9676\u5b9b\u7279\u7f85" },
            { "luc", "\u76e7\u68ee\u5821\u53ef\u514c\u63db\u6cd5\u90ce" },
            { "luf", "\u76e7\u68ee\u5821\u6cd5\u90ce" },
            { "lul", "\u76e7\u68ee\u5821\u91d1\u878d\u6cd5\u90ce" },
            { "lvl", "\u62c9\u812b\u7dad\u4e9e\u62c9\u7279\u9280\u5e63" },
            { "lvr", "\u62c9\u812b\u7dad\u4e9e\u76e7\u5e03" },
            { "lyd", "\u5229\u6bd4\u4e9e\u7b2c\u7d0d\u723e" },
            { "mad", "\u6469\u6d1b\u54e5\u8fea\u62c9\u59c6" },
            { "maf", "\u6469\u6d1b\u54e5\u6cd5\u90ce" },
            { "mcf", "\u6469\u7d0d\u54e5\u6cd5\u90ce" },
            { "mdc", "\u6469\u723e\u591a\u74e6\u5238" },
            { "mdl", "\u6469\u675c\u96f2\u5217\u4f0a" },
            { "mga", "\u99ac\u9054\u52a0\u65af\u52a0\u963f\u91cc\u4e9e\u91cc" },
            { "mgf", "\u99ac\u9054\u52a0\u65af\u52a0\u6cd5\u90ce" },
            { "mkd", "\u99ac\u5176\u9813\u7b2c\u7d0d\u723e" },
            { "mkn", "\u99ac\u5176\u9813\u7b2c\u7d0d\u723e (1992\u20131993)" },
            { "mlf", "\u99ac\u91cc\u6cd5\u90ce" },
            { "mmk", "\u7dec\u7538\u5143" },
            { "mnt", "\u8499\u53e4\u5716\u683c\u91cc\u514b" },
            { "mop", "\u6fb3\u9580\u5143" },
            { "mro", "\u8305\u5229\u5854\u5c3c\u4e9e\u70cf\u5409\u4e9e (1973\u20132017)" },
            { "mru", "\u8305\u5229\u5854\u5c3c\u4e9e\u70cf\u5409\u4e9e" },
            { "mtl", "\u99ac\u723e\u4ed6\u91cc\u62c9" },
            { "mtp", "\u99ac\u723e\u4ed6\u938a" },
            { "mur", "\u6a21\u91cc\u897f\u65af\u76e7\u6bd4" },
            { "mvp", "\u99ac\u723e\u5730\u592b\u76e7\u6bd4" },
            { "mvr", "\u99ac\u723e\u5730\u592b\u76e7\u975e\u4e9e" },
            { "mwk", "\u99ac\u62c9\u7dad\u514b\u74e6\u67e5" },
            { "mxn", "\u58a8\u897f\u54e5\u62ab\u7d22" },
            { "mxp", "\u58a8\u897f\u54e5\u9280\u62ab\u7d22 (1861\u20131992)" },
            { "mxv", "\u58a8\u897f\u54e5\u8f49\u63db\u55ae\u4f4d (UDI)" },
            { "myr", "\u99ac\u4f86\u897f\u4e9e\u4ee4\u5409" },
            { "mze", "\u83ab\u4e09\u6bd4\u514b\u57c3\u65af\u5eab\u591a" },
            { "mzm", "\u83ab\u4e09\u6bd4\u514b\u6885\u8482\u5361\u723e (1980\u20132006)" },
            { "mzn", "\u83ab\u4e09\u6bd4\u514b\u6885\u8482\u5361\u723e" },
            { "nad", "\u7d0d\u7c73\u6bd4\u4e9e\u5143" },
            { "ngn", "\u5948\u53ca\u5229\u4e9e\u5948\u62c9" },
            { "nic", "\u5c3c\u52a0\u62c9\u74dc\u79d1\u591a\u5df4" },
            { "nio", "\u5c3c\u52a0\u62c9\u74dc\u91d1\u79d1\u591a\u5df4" },
            { "nlg", "\u8377\u862d\u76fe" },
            { "nok", "\u632a\u5a01\u514b\u6717" },
            { "npr", "\u5c3c\u6cca\u723e\u76e7\u6bd4" },
            { "nzd", "\u7d10\u897f\u862d\u5e63" },
            { "omr", "\u963f\u66fc\u91cc\u4e9e\u723e" },
            { "pab", "\u5df4\u62ff\u99ac\u5df4\u6ce2\u4e9e" },
            { "pei", "\u7955\u9b6f\u56e0\u8482" },
            { "pen", "\u79d8\u9b6f\u592a\u967d\u5e63" },
            { "pes", "\u79d8\u9b6f\u7d22\u723e (1863\u20131965)" },
            { "pgk", "\u5df4\u5e03\u4e9e\u7d10\u5e7e\u5167\u4e9e\u57fa\u90a3" },
            { "php", "\u83f2\u5f8b\u8cd3\u62ab\u7d22" },
            { "pkr", "\u5df4\u57fa\u65af\u5766\u76e7\u6bd4" },
            { "pln", "\u6ce2\u862d\u8332\u7f85\u63d0" },
            { "plz", "\u6ce2\u862d\u8332\u7f85\u63d0 (1950\u20131995)" },
            { "pte", "\u8461\u8404\u7259\u57c3\u65af\u5eab\u591a" },
            { "pyg", "\u5df4\u62c9\u572d\u74dc\u62c9\u5c3c" },
            { "qar", "\u5361\u9054\u91cc\u4e9e\u723e" },
            { "rhd", "\u7f85\u5fb7\u897f\u4e9e\u5143" },
            { "rol", "\u820a\u7f85\u99ac\u5c3c\u4e9e\u5217\u4f0a" },
            { "ron", "\u7f85\u99ac\u5c3c\u4e9e\u5217\u4f0a" },
            { "rsd", "\u585e\u723e\u7dad\u4e9e\u6234\u7d0d" },
            { "rub", "\u4fc4\u7f85\u65af\u76e7\u5e03" },
            { "rur", "\u4fc4\u7f85\u65af\u76e7\u5e03 (1991\u20131998)" },
            { "rwf", "\u76e7\u5b89\u9054\u6cd5\u90ce" },
            { "sar", "\u6c99\u70cf\u5730\u91cc\u4e9e\u723e" },
            { "sbd", "\u7d22\u7f85\u9580\u7fa4\u5cf6\u5143" },
            { "scr", "\u585e\u5e2d\u723e\u76e7\u6bd4" },
            { "sdd", "\u8607\u4e39\u7b2c\u7d0d\u723e" },
            { "sdg", "\u8607\u4e39\u938a" },
            { "sdp", "\u820a\u8607\u4e39\u938a" },
            { "sek", "\u745e\u5178\u514b\u6717" },
            { "sgd", "\u65b0\u52a0\u5761\u5e63" },
            { "shp", "\u8056\u8d6b\u52d2\u62ff\u938a" },
            { "sit", "\u65af\u6d1b\u7dad\u5c3c\u4e9e\u6258\u52d2" },
            { "skk", "\u65af\u6d1b\u4f10\u514b\u514b\u6717" },
            { "sll", "\u7345\u5b50\u5c71\u5229\u6602" },
            { "sos", "\u7d22\u99ac\u5229\u4e9e\u5148\u4ee4" },
            { "srd", "\u8607\u5229\u5357\u5143" },
            { "srg", "\u8607\u5229\u5357\u57fa\u723e" },
            { "ssp", "\u5357\u8607\u4e39\u938a" },
            { "std", "\u8056\u591a\u7f8e\u5cf6\u548c\u666e\u6797\u897f\u6bd4\u5cf6\u591a\u5e03\u62c9 (1977\u20132017)" },
            { "stn", "\u8056\u591a\u7f8e\u5cf6\u548c\u666e\u6797\u897f\u6bd4\u5cf6\u591a\u5e03\u62c9" },
            { "sur", "\u8607\u806f\u76e7\u5e03" },
            { "svc", "\u85a9\u723e\u74e6\u591a\u79d1\u90ce" },
            { "syp", "\u6558\u5229\u4e9e\u938a" },
            { "szl", "\u53f2\u74e6\u6fdf\u862d\u91cc\u6717\u5409\u5c3c" },
            { "thb", "\u6cf0\u9296" },
            { "tjr", "\u5854\u5409\u514b\u76e7\u5e03" },
            { "tjs", "\u5854\u5409\u514b\u7d22\u83ab\u5c3c" },
            { "tmm", "\u571f\u5eab\u66fc\u99ac\u7d0d\u7279 (1993\u20132009)" },
            { "tmt", "\u571f\u5eab\u66fc\u99ac\u7d0d\u7279" },
            { "tnd", "\u7a81\u5c3c\u897f\u4e9e\u7b2c\u7d0d\u723e" },
            { "top", "\u6771\u52a0\u6f58\u52a0" },
            { "tpe", "\u5e1d\u6c76\u57c3\u65af\u5eab\u591a" },
            { "trl", "\u571f\u8033\u5176\u91cc\u62c9" },
            { "try", "\u65b0\u571f\u8033\u5176\u91cc\u62c9" },
            { "ttd", "\u5343\u91cc\u9054\u53ca\u6258\u5df4\u54e5\u5143" },
            { "twd", "\u65b0\u53f0\u5e63" },
            { "tzs", "\u5766\u5c1a\u5c3c\u4e9e\u5148\u4ee4" },
            { "uah", "\u70cf\u514b\u862d\u683c\u91cc\u592b\u7d0d" },
            { "uak", "\u70cf\u514b\u862d\u5361\u672c\u74e6\u90a3\u8332" },
            { "ugs", "\u70cf\u5e72\u9054\u5148\u4ee4 (1966\u20131987)" },
            { "ugx", "\u70cf\u5e72\u9054\u5148\u4ee4" },
            { "usd", "\u7f8e\u5143" },
            { "usn", "\u7f8e\u5143\uff08\u6b21\u65e5\uff09" },
            { "uss", "\u7f8e\u5143\uff08\u7576\u65e5\uff09" },
            { "uyi", "\u70cf\u62c9\u572d\u62ab\u7d22\uff08\u6307\u6578\u55ae\u4f4d\uff09" },
            { "uyp", "\u70cf\u62c9\u572d\u62ab\u7d22 (1975\u20131993)" },
            { "uyu", "\u70cf\u62c9\u572d\u62ab\u7d22" },
            { "uzs", "\u70cf\u8332\u5225\u514b\u7d22\u59c6" },
            { "veb", "\u59d4\u5167\u745e\u62c9\u73bb\u5229\u74e6 (1871\u20132008)" },
            { "vef", "\u59d4\u5167\u745e\u62c9\u73bb\u5229\u74e6" },
            { "vnd", "\u8d8a\u5357\u76fe" },
            { "vnn", "\u8d8a\u5357\u76fe (1978\u20131985)" },
            { "vuv", "\u842c\u90a3\u675c\u74e6\u5716" },
            { "wst", "\u897f\u85a9\u6469\u4e9e\u5854\u62c9" },
            { "xaf", "\u6cd5\u90ce (CFA\u2013BEAC)" },
            { "xag", "\u767d\u9280" },
            { "xau", "\u9ec3\u91d1" },
            { "xba", "\u6b50\u6d32\u7d9c\u5408\u55ae\u4f4d" },
            { "xbb", "\u6b50\u6d32\u8ca8\u5e63\u55ae\u4f4d (XBB)" },
            { "xbc", "\u6b50\u6d32\u6703\u8a08\u55ae\u4f4d (XBC)" },
            { "xbd", "\u6b50\u6d32\u6703\u8a08\u55ae\u4f4d (XBD)" },
            { "xcd", "\u683c\u745e\u90a3\u9054\u5143" },
            { "xdr", "\u7279\u6b8a\u63d0\u6b3e\u6b0a" },
            { "xeu", "\u6b50\u6d32\u8ca8\u5e63\u55ae\u4f4d (XEU)" },
            { "xfo", "\u6cd5\u570b\u91d1\u6cd5\u90ce" },
            { "xfu", "\u6cd5\u570b\u6cd5\u90ce (UIC)" },
            { "xof", "\u6cd5\u90ce (CFA\u2013BCEAO)" },
            { "xpd", "\u5e15\u62c9\u72c4\u6602" },
            { "xpf", "\u6cd5\u90ce (CFP)" },
            { "xpt", "\u767d\u91d1" },
            { "xre", "RINET \u57fa\u91d1" },
            { "xsu", "\u8607\u514b\u96f7\u8ca8\u5e63" },
            { "xts", "\u6e2c\u8a66\u7528\u8ca8\u5e63\u4ee3\u78bc" },
            { "xua", "\u4e9e\u6d32\u958b\u767c\u9280\u884c\u8a08\u50f9\u55ae\u4f4d" },
            { "xxx", "\u672a\u77e5\u8ca8\u5e63" },
            { "ydd", "\u8449\u9580\u7b2c\u7d0d\u723e" },
            { "yer", "\u8449\u9580\u91cc\u4e9e\u723e" },
            { "yud", "\u5357\u65af\u62c9\u592b\u7b2c\u7d0d\u723e\u786c\u5e63" },
            { "yum", "\u5357\u65af\u62c9\u592b\u632a\u5a01\u4e9e\u7b2c\u7d0d\u723e" },
            { "yun", "\u5357\u65af\u62c9\u592b\u53ef\u8f49\u63db\u7b2c\u7d0d\u723e" },
            { "yur", "\u5357\u65af\u62c9\u592b\u6539\u9769\u7b2c\u7d0d\u723e (1992\u20131993)" },
            { "zal", "\u5357\u975e\u862d\u7279\uff08\u91d1\u878d\uff09" },
            { "zar", "\u5357\u975e\u862d\u7279" },
            { "zmk", "\u5c1a\u6bd4\u4e9e\u514b\u74e6\u67e5 (1968\u20132012)" },
            { "zmw", "\u5c1a\u6bd4\u4e9e\u514b\u74e6\u67e5" },
            { "zrn", "\u85a9\u4f0a\u65b0\u624e\u4f0a\u723e" },
            { "zrz", "\u85a9\u4f0a\u624e\u4f0a\u723e" },
            { "zwd", "\u8f9b\u5df4\u5a01\u5143 (1980\u20132008)" },
            { "zwl", "\u8f9b\u5df4\u5a01\u5143 (2009)" },
            { "zwr", "\u8f9b\u5df4\u5a01\u5143 (2008)" },
        };
        return data;
    }
}
