import { IrcBridge } from "../bridge/IrcBridge";
import { ProvisionRequest } from "./ProvisionRequest";
import { IrcServer } from "../irc/IrcServer";
import { IrcUser } from "../models/IrcUser";
export declare class Provisioner {
    private ircBridge;
    private enabled;
    private requestTimeoutSeconds;
    private pendingRequests;
    private linkValidator;
    private queryLinkValidator;
    private unlinkValidator;
    private roomIdValidator;
    constructor(ircBridge: IrcBridge, enabled: boolean, requestTimeoutSeconds: number);
    private createProvisionEndpoint;
    private isProvisionRequest;
    private updateBridgingState;
    /**
     *  Utility function for attempting to send a request to a matrix endpoint
     *  that might be rate-limited.
     *
     *  This function will try `attempts` times to apply function `fn` to `obj` by
     *  calling fn.apply(obj, args), with args being any arguments passed to retry
     *  after `fn`. If an error occurs, the same will be tried again after
     *  `retryDelayMs`. If an error err is thrown by `fn` and err.data.retry_after_ms
     *  is set, it will be added to that delay.
     *
     *  If the number of attempts is reached, an error is thrown.
    */
    private _retry;
    private retry;
    private userHasProvisioningPower;
    /**
     * Do a series of checks before contacting an operator for permission to create
     *  a provisioned mapping. If the operator responds with 'yes' or 'y', the mapping
     *  is created.
     * The checks done are the following:
     *  - (Matrix) Check power level of user is high enough
     *  - (IRC) Check that op's nick is actually a channel op
     *  - (Matrix) check room state to prevent route looping: don't bridge the same
     *    room-channel pair
     *  - (Matrix) update room state m.room.brdiging
    */
    private authoriseProvisioning;
    private sendToUser;
    private createAuthorisedLink;
    private removeRequest;
    private getRequest;
    private setRequest;
    handlePm(server: IrcServer, fromUser: IrcUser, text: string): Promise<void>;
    queryLink(req: ProvisionRequest): Promise<{
        operators: string[];
    }>;
    queryNetworks(): Promise<{
        servers: {
            network_id: string;
            bot_user_id: string;
            desc: string;
            icon: string | undefined;
            fields: {
                domain: string;
            };
        }[];
    }>;
    requestLink(req: ProvisionRequest): Promise<void>;
    doLink(req: ProvisionRequest, server: IrcServer, ircChannel: string, key: string | undefined, roomId: string, userId: string): Promise<void>;
    /**
     * Unlink an IRC channel from a matrix room ID
     * @param req An ExpressJS-Request-like object which triggered the action. Its body should contain
     * the parameters for this unlink action.
     * @param ignorePermissions If true, permissions are ignored (e.g. for bridge admins).
     * Otherwise, the user needs to be a Moderator in the Matrix room.
     */
    unlink(req: ProvisionRequest, ignorePermissions?: boolean): Promise<void>;
    leaveIfUnprovisioned(req: ProvisionRequest, roomId: string, server: IrcServer, ircChannel: string): Promise<void>;
    private partUnlinkedIrcClients;
    private leaveMatrixVirtuals;
    private leaveMatrixRoomIfUnprovisioned;
    listings(req: ProvisionRequest): Promise<(false | {
        matrix_room_id: string;
        remote_room_channel: unknown;
        remote_room_server: unknown;
    })[]>;
    private getLimits;
}
