#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 concurrent-output
version:              1.10.12
visibility:           public
id:                   concurrent-output-1.10.12-JpuZBJ7Vst1Ep548AJLiEg
key:                  concurrent-output-1.10.12-JpuZBJ7Vst1Ep548AJLiEg
license:              BSD-2-Clause
copyright:            2015-2020 Joey Hess, 2009 Joachim Breitner
maintainer:           Joey Hess <id@joeyh.name>
author:               Joey Hess, Joachim Breitner
stability:            Stable
synopsis:             Ungarble output from several threads or commands
description:
    Lets multiple threads and external processes concurrently output to the
    console, without it getting all garbled up.

    Built on top of that is a way of defining multiple output regions,
    which are automatically laid out on the screen and can be individually
    updated by concurrent threads. Can be used for progress displays etc.

    <<https://joeyh.name/code/concurrent-output/demo2.gif>>

category:             User Interfaces
abi:                  e5abef9bd669e691f4744165eccbdda4
exposed:              True
exposed-modules:
    System.Console.Concurrent System.Console.Concurrent.Internal
    System.Console.Regions System.Process.Concurrent

hidden-modules:       Utility.Monad Utility.Exception
import-dirs:          /usr/lib/ghc-8.10.5/site-local/concurrent-output-1.10.12
library-dirs:         /usr/lib/ghc-8.10.5/site-local/concurrent-output-1.10.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/concurrent-output-1.10.12
hs-libraries:         HSconcurrent-output-1.10.12-JpuZBJ7Vst1Ep548AJLiEg
depends:
    ansi-terminal-0.11-366lZebL4UKAFopo4Q1x1i
    async-2.2.3-6QbaQgrhqs02Gm74dJYuzp base-4.14.2.0 directory-1.3.6.0
    exceptions-0.10.4 process-1.6.9.0 stm-2.5.0.1
    terminal-size-0.3.2.1-8LMlp57ywuCIM7VIh4tqn1 text-1.2.4.1
    transformers-0.5.6.2 unix-2.7.2.2

haddock-interfaces:
    /usr/share/doc/haskell-concurrent-output/html/concurrent-output.haddock

haddock-html:         /usr/share/doc/haskell-concurrent-output/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

