const safeBuffer = require('safe-buffer').Buffer

function decodeBase64 (base64) {
  return safeBuffer.from(base64, 'base64').toString('utf8')
}

function encodeBase64 (string) {
  return safeBuffer.from(string, 'utf8').toString('base64')
}

module.exports = {
  decodeBase64: decodeBase64,
  encodeBase64: encodeBase64
}
