;; generated with `guild compile-ffi ffi/mosquitto.ffi'
;; using nyacc version 3.01.0

(define-module (ffi mosquitto)
  #:use-module ((system foreign) #:prefix ffi:)
  #:use-module (system foreign-library)
  #:use-module (mosquitto foreign cdata))

(define (foreign-pointer-search name)
  (define (flc l) (load-foreign-library (car l) #:search-path (list)))
  (let loop ((libs (list #f "libmosquitto")))
    (cond
      ((null? libs) (error "no library for ~s" name))
      ((false-if-exception (foreign-library-pointer (flc libs) name)))
      (else (loop (cdr libs))))))


;; enum mosq_err_t {
;;   MOSQ_ERR_AUTH_CONTINUE = -4,
;;   MOSQ_ERR_NO_SUBSCRIBERS = -3,
;;   MOSQ_ERR_SUB_EXISTS = -2,
;;   MOSQ_ERR_CONN_PENDING = -1,
;;   MOSQ_ERR_SUCCESS = 0,
;;   MOSQ_ERR_NOMEM = 1,
;;   MOSQ_ERR_PROTOCOL = 2,
;;   MOSQ_ERR_INVAL = 3,
;;   MOSQ_ERR_NO_CONN = 4,
;;   MOSQ_ERR_CONN_REFUSED = 5,
;;   MOSQ_ERR_NOT_FOUND = 6,
;;   MOSQ_ERR_CONN_LOST = 7,
;;   MOSQ_ERR_TLS = 8,
;;   MOSQ_ERR_PAYLOAD_SIZE = 9,
;;   MOSQ_ERR_NOT_SUPPORTED = 10,
;;   MOSQ_ERR_AUTH = 11,
;;   MOSQ_ERR_ACL_DENIED = 12,
;;   MOSQ_ERR_UNKNOWN = 13,
;;   MOSQ_ERR_ERRNO = 14,
;;   MOSQ_ERR_EAI = 15,
;;   MOSQ_ERR_PROXY = 16,
;;   MOSQ_ERR_PLUGIN_DEFER = 17,
;;   MOSQ_ERR_MALFORMED_UTF8 = 18,
;;   MOSQ_ERR_KEEPALIVE = 19,
;;   MOSQ_ERR_LOOKUP = 20,
;;   MOSQ_ERR_MALFORMED_PACKET = 21,
;;   MOSQ_ERR_DUPLICATE_PROPERTY = 22,
;;   MOSQ_ERR_TLS_HANDSHAKE = 23,
;;   MOSQ_ERR_QOS_NOT_SUPPORTED = 24,
;;   MOSQ_ERR_OVERSIZE_PACKET = 25,
;;   MOSQ_ERR_OCSP = 26,
;;   MOSQ_ERR_TIMEOUT = 27,
;;   MOSQ_ERR_RETAIN_NOT_SUPPORTED = 28,
;;   MOSQ_ERR_TOPIC_ALIAS_INVALID = 29,
;;   MOSQ_ERR_ADMINISTRATIVE_ACTION = 30,
;;   MOSQ_ERR_ALREADY_EXISTS = 31,
;; };
(define-public enum-mosq_err_t
  (name-ctype
   'enum-mosq_err_t
   (cenum '((MOSQ_ERR_AUTH_CONTINUE -4)
            (MOSQ_ERR_NO_SUBSCRIBERS -3)
            (MOSQ_ERR_SUB_EXISTS -2)
            (MOSQ_ERR_CONN_PENDING -1)
            (MOSQ_ERR_SUCCESS 0)
            (MOSQ_ERR_NOMEM 1)
            (MOSQ_ERR_PROTOCOL 2)
            (MOSQ_ERR_INVAL 3)
            (MOSQ_ERR_NO_CONN 4)
            (MOSQ_ERR_CONN_REFUSED 5)
            (MOSQ_ERR_NOT_FOUND 6)
            (MOSQ_ERR_CONN_LOST 7)
            (MOSQ_ERR_TLS 8)
            (MOSQ_ERR_PAYLOAD_SIZE 9)
            (MOSQ_ERR_NOT_SUPPORTED 10)
            (MOSQ_ERR_AUTH 11)
            (MOSQ_ERR_ACL_DENIED 12)
            (MOSQ_ERR_UNKNOWN 13)
            (MOSQ_ERR_ERRNO 14)
            (MOSQ_ERR_EAI 15)
            (MOSQ_ERR_PROXY 16)
            (MOSQ_ERR_PLUGIN_DEFER 17)
            (MOSQ_ERR_MALFORMED_UTF8 18)
            (MOSQ_ERR_KEEPALIVE 19)
            (MOSQ_ERR_LOOKUP 20)
            (MOSQ_ERR_MALFORMED_PACKET 21)
            (MOSQ_ERR_DUPLICATE_PROPERTY 22)
            (MOSQ_ERR_TLS_HANDSHAKE 23)
            (MOSQ_ERR_QOS_NOT_SUPPORTED 24)
            (MOSQ_ERR_OVERSIZE_PACKET 25)
            (MOSQ_ERR_OCSP 26)
            (MOSQ_ERR_TIMEOUT 27)
            (MOSQ_ERR_RETAIN_NOT_SUPPORTED 28)
            (MOSQ_ERR_TOPIC_ALIAS_INVALID 29)
            (MOSQ_ERR_ADMINISTRATIVE_ACTION 30)
            (MOSQ_ERR_ALREADY_EXISTS 31)))))
(define-public unwrap-enum-mosq_err_t
  (let ((numf (cenum-numf (ctype-info enum-mosq_err_t))))
    (lambda (arg) (or (numf arg) arg))))
(define-public wrap-enum-mosq_err_t
  (let ((symf (cenum-symf (ctype-info enum-mosq_err_t))))
    (lambda (arg) (or (symf arg) arg))))

;; enum mosq_opt_t {
;;   MOSQ_OPT_PROTOCOL_VERSION = 1,
;;   MOSQ_OPT_SSL_CTX = 2,
;;   MOSQ_OPT_SSL_CTX_WITH_DEFAULTS = 3,
;;   MOSQ_OPT_RECEIVE_MAXIMUM = 4,
;;   MOSQ_OPT_SEND_MAXIMUM = 5,
;;   MOSQ_OPT_TLS_KEYFORM = 6,
;;   MOSQ_OPT_TLS_ENGINE = 7,
;;   MOSQ_OPT_TLS_ENGINE_KPASS_SHA1 = 8,
;;   MOSQ_OPT_TLS_OCSP_REQUIRED = 9,
;;   MOSQ_OPT_TLS_ALPN = 10,
;;   MOSQ_OPT_TCP_NODELAY = 11,
;;   MOSQ_OPT_BIND_ADDRESS = 12,
;;   MOSQ_OPT_TLS_USE_OS_CERTS = 13,
;; };
(define-public enum-mosq_opt_t
  (name-ctype
   'enum-mosq_opt_t
   (cenum '((MOSQ_OPT_PROTOCOL_VERSION 1)
            (MOSQ_OPT_SSL_CTX 2)
            (MOSQ_OPT_SSL_CTX_WITH_DEFAULTS 3)
            (MOSQ_OPT_RECEIVE_MAXIMUM 4)
            (MOSQ_OPT_SEND_MAXIMUM 5)
            (MOSQ_OPT_TLS_KEYFORM 6)
            (MOSQ_OPT_TLS_ENGINE 7)
            (MOSQ_OPT_TLS_ENGINE_KPASS_SHA1 8)
            (MOSQ_OPT_TLS_OCSP_REQUIRED 9)
            (MOSQ_OPT_TLS_ALPN 10)
            (MOSQ_OPT_TCP_NODELAY 11)
            (MOSQ_OPT_BIND_ADDRESS 12)
            (MOSQ_OPT_TLS_USE_OS_CERTS 13)))))
(define-public unwrap-enum-mosq_opt_t
  (let ((numf (cenum-numf (ctype-info enum-mosq_opt_t))))
    (lambda (arg) (or (numf arg) arg))))
(define-public wrap-enum-mosq_opt_t
  (let ((symf (cenum-symf (ctype-info enum-mosq_opt_t))))
    (lambda (arg) (or (symf arg) arg))))

;; struct mosquitto_message {
;;   int mid;
;;   char *topic;
;;   void *payload;
;;   int payloadlen;
;;   int qos;
;;   char retain;
;; };
(define-public struct-mosquitto_message
  (name-ctype
   'struct-mosquitto_message
   (cstruct
    (list `(mid ,(cbase 'int))
          `(topic ,(cpointer (cbase 'char)))
          `(payload ,(cpointer 'void))
          `(payloadlen ,(cbase 'int))
          `(qos ,(cbase 'int))
          `(retain ,(cbase 'char))))))
(define-public struct-mosquitto_message*
  (name-ctype 'struct-mosquitto_message* (cpointer struct-mosquitto_message)))

;; typedef struct mqtt5__property mosquitto_property;
(define-public mosquitto_property*
  (name-ctype 'mosquitto_property* (cpointer 'void)))

;; int mosquitto_lib_version(int *major, int *minor, int *revision);
(define-public mosquitto_lib_version
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_lib_version")
                       (list '* '* '*)))))
    (lambda (major minor revision)
      (let ((major (cdata-arg->pointer major))
            (minor (cdata-arg->pointer minor))
            (revision (cdata-arg->pointer revision)))
        ((force ~proc) major minor revision)))))

;; int mosquitto_lib_init(void);
(define-public mosquitto_lib_init
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_lib_init")
                       (list)))))
    (lambda () (let () ((force ~proc))))))

;; int mosquitto_lib_cleanup(void);
(define-public mosquitto_lib_cleanup
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_lib_cleanup")
                       (list)))))
    (lambda () (let () ((force ~proc))))))

;; struct mosquitto *mosquitto_new(const char *id, char clean_session, void *
;;     obj);
(define-public mosquitto_new
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search "mosquitto_new")
                       (list '* ffi:int8 '*)))))
    (lambda (id clean_session obj)
      (let ((id (cdata-arg->pointer id))
            (clean_session (cdata-arg->number clean_session))
            (obj (cdata-arg->pointer obj)))
        ((force ~proc) id clean_session obj)))))

;; void mosquitto_destroy(struct mosquitto *mosq);
(define-public mosquitto_destroy
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search "mosquitto_destroy")
                       (list '*)))))
    (lambda (mosq)
      (let ((mosq (cdata-arg->pointer mosq))) ((force ~proc) mosq)))))

;; int mosquitto_reinitialise(struct mosquitto *mosq, const char *id, char 
;;     clean_session, void *obj);
(define-public mosquitto_reinitialise
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_reinitialise")
                       (list '* '* ffi:int8 '*)))))
    (lambda (mosq id clean_session obj)
      (let ((mosq (cdata-arg->pointer mosq))
            (id (cdata-arg->pointer id))
            (clean_session (cdata-arg->number clean_session))
            (obj (cdata-arg->pointer obj)))
        ((force ~proc) mosq id clean_session obj)))))

;; int mosquitto_will_set(struct mosquitto *mosq, const char *topic, int 
;;     payloadlen, const void *payload, int qos, char retain);
(define-public mosquitto_will_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_will_set")
                       (list '* '* ffi:int '* ffi:int ffi:int8)))))
    (lambda (mosq topic payloadlen payload qos retain)
      (let ((mosq (cdata-arg->pointer mosq))
            (topic (cdata-arg->pointer topic))
            (payloadlen (cdata-arg->number payloadlen))
            (payload (cdata-arg->pointer payload))
            (qos (cdata-arg->number qos))
            (retain (cdata-arg->number retain)))
        ((force ~proc) mosq topic payloadlen payload qos retain)))))

;; int mosquitto_will_set_v5(struct mosquitto *mosq, const char *topic, int 
;;     payloadlen, const void *payload, int qos, char retain, 
;;     mosquitto_property *properties);
(define-public mosquitto_will_set_v5
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_will_set_v5")
                       (list '* '* ffi:int '* ffi:int ffi:int8 '*)))))
    (lambda (mosq topic payloadlen payload qos retain properties)
      (let ((mosq (cdata-arg->pointer mosq))
            (topic (cdata-arg->pointer topic))
            (payloadlen (cdata-arg->number payloadlen))
            (payload (cdata-arg->pointer payload))
            (qos (cdata-arg->number qos))
            (retain (cdata-arg->number retain))
            (properties (cdata-arg->pointer properties mosquitto_property*)))
        ((force ~proc) mosq topic payloadlen payload qos retain properties)))))

;; int mosquitto_will_clear(struct mosquitto *mosq);
(define-public mosquitto_will_clear
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_will_clear")
                       (list '*)))))
    (lambda (mosq)
      (let ((mosq (cdata-arg->pointer mosq))) ((force ~proc) mosq)))))

;; int mosquitto_username_pw_set(struct mosquitto *mosq, const char *username, 
;;     const char *password);
(define-public mosquitto_username_pw_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_username_pw_set")
                       (list '* '* '*)))))
    (lambda (mosq username password)
      (let ((mosq (cdata-arg->pointer mosq))
            (username (cdata-arg->pointer username))
            (password (cdata-arg->pointer password)))
        ((force ~proc) mosq username password)))))

;; int mosquitto_connect(struct mosquitto *mosq, const char *host, int port, 
;;     int keepalive);
(define-public mosquitto_connect
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_connect")
                       (list '* '* ffi:int ffi:int)))))
    (lambda (mosq host port keepalive)
      (let ((mosq (cdata-arg->pointer mosq))
            (host (cdata-arg->pointer host))
            (port (cdata-arg->number port))
            (keepalive (cdata-arg->number keepalive)))
        ((force ~proc) mosq host port keepalive)))))

;; int mosquitto_connect_bind(struct mosquitto *mosq, const char *host, int 
;;     port, int keepalive, const char *bind_address);
(define-public mosquitto_connect_bind
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_connect_bind")
                       (list '* '* ffi:int ffi:int '*)))))
    (lambda (mosq host port keepalive bind_address)
      (let ((mosq (cdata-arg->pointer mosq))
            (host (cdata-arg->pointer host))
            (port (cdata-arg->number port))
            (keepalive (cdata-arg->number keepalive))
            (bind_address (cdata-arg->pointer bind_address)))
        ((force ~proc) mosq host port keepalive bind_address)))))

;; int mosquitto_connect_bind_v5(struct mosquitto *mosq, const char *host, int 
;;     port, int keepalive, const char *bind_address, const mosquitto_property 
;;     *properties);
(define-public mosquitto_connect_bind_v5
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_connect_bind_v5")
                       (list '* '* ffi:int ffi:int '* '*)))))
    (lambda (mosq host port keepalive bind_address properties)
      (let ((mosq (cdata-arg->pointer mosq))
            (host (cdata-arg->pointer host))
            (port (cdata-arg->number port))
            (keepalive (cdata-arg->number keepalive))
            (bind_address (cdata-arg->pointer bind_address))
            (properties (cdata-arg->pointer properties mosquitto_property*)))
        ((force ~proc) mosq host port keepalive bind_address properties)))))

;; int mosquitto_connect_async(struct mosquitto *mosq, const char *host, int 
;;     port, int keepalive);
(define-public mosquitto_connect_async
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_connect_async")
                       (list '* '* ffi:int ffi:int)))))
    (lambda (mosq host port keepalive)
      (let ((mosq (cdata-arg->pointer mosq))
            (host (cdata-arg->pointer host))
            (port (cdata-arg->number port))
            (keepalive (cdata-arg->number keepalive)))
        ((force ~proc) mosq host port keepalive)))))

;; int mosquitto_connect_bind_async(struct mosquitto *mosq, const char *host, 
;;     int port, int keepalive, const char *bind_address);
(define-public mosquitto_connect_bind_async
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_connect_bind_async")
                       (list '* '* ffi:int ffi:int '*)))))
    (lambda (mosq host port keepalive bind_address)
      (let ((mosq (cdata-arg->pointer mosq))
            (host (cdata-arg->pointer host))
            (port (cdata-arg->number port))
            (keepalive (cdata-arg->number keepalive))
            (bind_address (cdata-arg->pointer bind_address)))
        ((force ~proc) mosq host port keepalive bind_address)))))

;; int mosquitto_connect_srv(struct mosquitto *mosq, const char *host, int 
;;     keepalive, const char *bind_address);
(define-public mosquitto_connect_srv
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_connect_srv")
                       (list '* '* ffi:int '*)))))
    (lambda (mosq host keepalive bind_address)
      (let ((mosq (cdata-arg->pointer mosq))
            (host (cdata-arg->pointer host))
            (keepalive (cdata-arg->number keepalive))
            (bind_address (cdata-arg->pointer bind_address)))
        ((force ~proc) mosq host keepalive bind_address)))))

;; int mosquitto_reconnect(struct mosquitto *mosq);
(define-public mosquitto_reconnect
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_reconnect")
                       (list '*)))))
    (lambda (mosq)
      (let ((mosq (cdata-arg->pointer mosq))) ((force ~proc) mosq)))))

;; int mosquitto_reconnect_async(struct mosquitto *mosq);
(define-public mosquitto_reconnect_async
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_reconnect_async")
                       (list '*)))))
    (lambda (mosq)
      (let ((mosq (cdata-arg->pointer mosq))) ((force ~proc) mosq)))))

;; int mosquitto_disconnect(struct mosquitto *mosq);
(define-public mosquitto_disconnect
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_disconnect")
                       (list '*)))))
    (lambda (mosq)
      (let ((mosq (cdata-arg->pointer mosq))) ((force ~proc) mosq)))))

;; int mosquitto_disconnect_v5(struct mosquitto *mosq, int reason_code, const 
;;     mosquitto_property *properties);
(define-public mosquitto_disconnect_v5
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_disconnect_v5")
                       (list '* ffi:int '*)))))
    (lambda (mosq reason_code properties)
      (let ((mosq (cdata-arg->pointer mosq))
            (reason_code (cdata-arg->number reason_code))
            (properties (cdata-arg->pointer properties mosquitto_property*)))
        ((force ~proc) mosq reason_code properties)))))

;; int mosquitto_publish(struct mosquitto *mosq, int *mid, const char *topic, 
;;     int payloadlen, const void *payload, int qos, char retain);
(define-public mosquitto_publish
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_publish")
                       (list '* '* '* ffi:int '* ffi:int ffi:int8)))))
    (lambda (mosq mid topic payloadlen payload qos retain)
      (let ((mosq (cdata-arg->pointer mosq))
            (mid (cdata-arg->pointer mid))
            (topic (cdata-arg->pointer topic))
            (payloadlen (cdata-arg->number payloadlen))
            (payload (cdata-arg->pointer payload))
            (qos (cdata-arg->number qos))
            (retain (cdata-arg->number retain)))
        ((force ~proc) mosq mid topic payloadlen payload qos retain)))))

;; int mosquitto_publish_v5(struct mosquitto *mosq, int *mid, const char *topic
;;     , int payloadlen, const void *payload, int qos, char retain, const 
;;     mosquitto_property *properties);
(define-public mosquitto_publish_v5
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_publish_v5")
                       (list '* '* '* ffi:int '* ffi:int ffi:int8 '*)))))
    (lambda (mosq mid topic payloadlen payload qos retain properties)
      (let ((mosq (cdata-arg->pointer mosq))
            (mid (cdata-arg->pointer mid))
            (topic (cdata-arg->pointer topic))
            (payloadlen (cdata-arg->number payloadlen))
            (payload (cdata-arg->pointer payload))
            (qos (cdata-arg->number qos))
            (retain (cdata-arg->number retain))
            (properties (cdata-arg->pointer properties mosquitto_property*)))
        ((force ~proc) mosq mid topic payloadlen payload qos retain properties)))))

;; int mosquitto_subscribe(struct mosquitto *mosq, int *mid, const char *sub, 
;;     int qos);
(define-public mosquitto_subscribe
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_subscribe")
                       (list '* '* '* ffi:int)))))
    (lambda (mosq mid sub qos)
      (let ((mosq (cdata-arg->pointer mosq))
            (mid (cdata-arg->pointer mid))
            (sub (cdata-arg->pointer sub))
            (qos (cdata-arg->number qos)))
        ((force ~proc) mosq mid sub qos)))))

;; int mosquitto_subscribe_v5(struct mosquitto *mosq, int *mid, const char *sub
;;     , int qos, int options, const mosquitto_property *properties);
(define-public mosquitto_subscribe_v5
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_subscribe_v5")
                       (list '* '* '* ffi:int ffi:int '*)))))
    (lambda (mosq mid sub qos options properties)
      (let ((mosq (cdata-arg->pointer mosq))
            (mid (cdata-arg->pointer mid))
            (sub (cdata-arg->pointer sub))
            (qos (cdata-arg->number qos))
            (options (cdata-arg->number options))
            (properties (cdata-arg->pointer properties mosquitto_property*)))
        ((force ~proc) mosq mid sub qos options properties)))))

;; int mosquitto_subscribe_multiple(struct mosquitto *mosq, int *mid, int 
;;     sub_count, char *(const)*(const)sub, int qos, int options, const 
;;     mosquitto_property *properties);
(define-public mosquitto_subscribe_multiple
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_subscribe_multiple")
                       (list '* '* ffi:int '* ffi:int ffi:int '*)))))
    (lambda (mosq mid sub_count sub qos options properties)
      (let ((mosq (cdata-arg->pointer mosq))
            (mid (cdata-arg->pointer mid))
            (sub_count (cdata-arg->number sub_count))
            (sub (cdata-arg->pointer sub))
            (qos (cdata-arg->number qos))
            (options (cdata-arg->number options))
            (properties (cdata-arg->pointer properties mosquitto_property*)))
        ((force ~proc) mosq mid sub_count sub qos options properties)))))

;; int mosquitto_unsubscribe(struct mosquitto *mosq, int *mid, const char *sub)
;;     ;
(define-public mosquitto_unsubscribe
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_unsubscribe")
                       (list '* '* '*)))))
    (lambda (mosq mid sub)
      (let ((mosq (cdata-arg->pointer mosq))
            (mid (cdata-arg->pointer mid))
            (sub (cdata-arg->pointer sub)))
        ((force ~proc) mosq mid sub)))))

;; int mosquitto_unsubscribe_v5(struct mosquitto *mosq, int *mid, const char *
;;     sub, const mosquitto_property *properties);
(define-public mosquitto_unsubscribe_v5
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_unsubscribe_v5")
                       (list '* '* '* '*)))))
    (lambda (mosq mid sub properties)
      (let ((mosq (cdata-arg->pointer mosq))
            (mid (cdata-arg->pointer mid))
            (sub (cdata-arg->pointer sub))
            (properties (cdata-arg->pointer properties mosquitto_property*)))
        ((force ~proc) mosq mid sub properties)))))

;; int mosquitto_unsubscribe_multiple(struct mosquitto *mosq, int *mid, int 
;;     sub_count, char *(const)*(const)sub, const mosquitto_property *
;;     properties);
(define-public mosquitto_unsubscribe_multiple
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search
                        "mosquitto_unsubscribe_multiple")
                       (list '* '* ffi:int '* '*)))))
    (lambda (mosq mid sub_count sub properties)
      (let ((mosq (cdata-arg->pointer mosq))
            (mid (cdata-arg->pointer mid))
            (sub_count (cdata-arg->number sub_count))
            (sub (cdata-arg->pointer sub))
            (properties (cdata-arg->pointer properties mosquitto_property*)))
        ((force ~proc) mosq mid sub_count sub properties)))))

;; int mosquitto_message_copy(struct mosquitto_message *dst, const 
;;     struct mosquitto_message *src);
(define-public mosquitto_message_copy
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_message_copy")
                       (list '* '*)))))
    (lambda (dst src)
      (let ((dst (cdata-arg->pointer dst)) (src (cdata-arg->pointer src)))
        ((force ~proc) dst src)))))

;; void mosquitto_message_free(struct mosquitto_message **message);
(define-public mosquitto_message_free
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search "mosquitto_message_free")
                       (list '*)))))
    (lambda (message)
      (let ((message (cdata-arg->pointer message))) ((force ~proc) message)))))

;; void mosquitto_message_free_contents(struct mosquitto_message *message);
(define-public mosquitto_message_free_contents
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_message_free_contents")
                       (list '*)))))
    (lambda (message)
      (let ((message (cdata-arg->pointer message))) ((force ~proc) message)))))

;; int mosquitto_loop_forever(struct mosquitto *mosq, int timeout, int 
;;     max_packets);
(define-public mosquitto_loop_forever
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_loop_forever")
                       (list '* ffi:int ffi:int)))))
    (lambda (mosq timeout max_packets)
      (let ((mosq (cdata-arg->pointer mosq))
            (timeout (cdata-arg->number timeout))
            (max_packets (cdata-arg->number max_packets)))
        ((force ~proc) mosq timeout max_packets)))))

;; int mosquitto_loop_start(struct mosquitto *mosq);
(define-public mosquitto_loop_start
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_loop_start")
                       (list '*)))))
    (lambda (mosq)
      (let ((mosq (cdata-arg->pointer mosq))) ((force ~proc) mosq)))))

;; int mosquitto_loop_stop(struct mosquitto *mosq, char force);
(define-public mosquitto_loop_stop
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_loop_stop")
                       (list '* ffi:int8)))))
    (lambda (mosq force)
      (let ((mosq (cdata-arg->pointer mosq)) (force (cdata-arg->number force)))
        ((force ~proc) mosq force)))))

;; int mosquitto_loop(struct mosquitto *mosq, int timeout, int max_packets);
(define-public mosquitto_loop
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_loop")
                       (list '* ffi:int ffi:int)))))
    (lambda (mosq timeout max_packets)
      (let ((mosq (cdata-arg->pointer mosq))
            (timeout (cdata-arg->number timeout))
            (max_packets (cdata-arg->number max_packets)))
        ((force ~proc) mosq timeout max_packets)))))

;; int mosquitto_loop_read(struct mosquitto *mosq, int max_packets);
(define-public mosquitto_loop_read
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_loop_read")
                       (list '* ffi:int)))))
    (lambda (mosq max_packets)
      (let ((mosq (cdata-arg->pointer mosq))
            (max_packets (cdata-arg->number max_packets)))
        ((force ~proc) mosq max_packets)))))

;; int mosquitto_loop_write(struct mosquitto *mosq, int max_packets);
(define-public mosquitto_loop_write
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_loop_write")
                       (list '* ffi:int)))))
    (lambda (mosq max_packets)
      (let ((mosq (cdata-arg->pointer mosq))
            (max_packets (cdata-arg->number max_packets)))
        ((force ~proc) mosq max_packets)))))

;; int mosquitto_loop_misc(struct mosquitto *mosq);
(define-public mosquitto_loop_misc
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_loop_misc")
                       (list '*)))))
    (lambda (mosq)
      (let ((mosq (cdata-arg->pointer mosq))) ((force ~proc) mosq)))))

;; int mosquitto_socket(struct mosquitto *mosq);
(define-public mosquitto_socket
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_socket")
                       (list '*)))))
    (lambda (mosq)
      (let ((mosq (cdata-arg->pointer mosq))) ((force ~proc) mosq)))))

;; char mosquitto_want_write(struct mosquitto *mosq);
(define-public mosquitto_want_write
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int8
                       (foreign-pointer-search "mosquitto_want_write")
                       (list '*)))))
    (lambda (mosq)
      (let ((mosq (cdata-arg->pointer mosq))) ((force ~proc) mosq)))))

;; int mosquitto_threaded_set(struct mosquitto *mosq, char threaded);
(define-public mosquitto_threaded_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_threaded_set")
                       (list '* ffi:int8)))))
    (lambda (mosq threaded)
      (let ((mosq (cdata-arg->pointer mosq))
            (threaded (cdata-arg->number threaded)))
        ((force ~proc) mosq threaded)))))

;; int mosquitto_opts_set(struct mosquitto *mosq, enum mosq_opt_t option, void 
;;     *value);
(define-public mosquitto_opts_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_opts_set")
                       (list '* ffi:int '*)))))
    (lambda (mosq option value)
      (let ((mosq (cdata-arg->pointer mosq))
            (option (unwrap-enum-mosq_opt_t option))
            (value (cdata-arg->pointer value)))
        ((force ~proc) mosq option value)))))

;; int mosquitto_int_option(struct mosquitto *mosq, enum mosq_opt_t option, int
;;      value);
(define-public mosquitto_int_option
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_int_option")
                       (list '* ffi:int ffi:int)))))
    (lambda (mosq option value)
      (let ((mosq (cdata-arg->pointer mosq))
            (option (unwrap-enum-mosq_opt_t option))
            (value (cdata-arg->number value)))
        ((force ~proc) mosq option value)))))

;; int mosquitto_string_option(struct mosquitto *mosq, enum mosq_opt_t option, 
;;     const char *value);
(define-public mosquitto_string_option
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_string_option")
                       (list '* ffi:int '*)))))
    (lambda (mosq option value)
      (let ((mosq (cdata-arg->pointer mosq))
            (option (unwrap-enum-mosq_opt_t option))
            (value (cdata-arg->pointer value)))
        ((force ~proc) mosq option value)))))

;; int mosquitto_void_option(struct mosquitto *mosq, enum mosq_opt_t option, 
;;     void *value);
(define-public mosquitto_void_option
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_void_option")
                       (list '* ffi:int '*)))))
    (lambda (mosq option value)
      (let ((mosq (cdata-arg->pointer mosq))
            (option (unwrap-enum-mosq_opt_t option))
            (value (cdata-arg->pointer value)))
        ((force ~proc) mosq option value)))))

;; int mosquitto_reconnect_delay_set(struct mosquitto *mosq, unsigned 
;;     reconnect_delay, unsigned reconnect_delay_max, char 
;;     reconnect_exponential_backoff);
(define-public mosquitto_reconnect_delay_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_reconnect_delay_set")
                       (list '* ffi:unsigned-int ffi:unsigned-int ffi:int8)))))
    (lambda (mosq
             reconnect_delay
             reconnect_delay_max
             reconnect_exponential_backoff)
      (let ((mosq (cdata-arg->pointer mosq))
            (reconnect_delay (cdata-arg->number reconnect_delay))
            (reconnect_delay_max (cdata-arg->number reconnect_delay_max))
            (reconnect_exponential_backoff
             (cdata-arg->number reconnect_exponential_backoff)))
        ((force ~proc)
         mosq
         reconnect_delay
         reconnect_delay_max
         reconnect_exponential_backoff)))))

;; int mosquitto_max_inflight_messages_set(struct mosquitto *mosq, unsigned 
;;     max_inflight_messages);
(define-public mosquitto_max_inflight_messages_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search
                        "mosquitto_max_inflight_messages_set")
                       (list '* ffi:unsigned-int)))))
    (lambda (mosq max_inflight_messages)
      (let ((mosq (cdata-arg->pointer mosq))
            (max_inflight_messages (cdata-arg->number max_inflight_messages)))
        ((force ~proc) mosq max_inflight_messages)))))

;; void mosquitto_message_retry_set(struct mosquitto *mosq, unsigned 
;;     message_retry);
(define-public mosquitto_message_retry_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search "mosquitto_message_retry_set")
                       (list '* ffi:unsigned-int)))))
    (lambda (mosq message_retry)
      (let ((mosq (cdata-arg->pointer mosq))
            (message_retry (cdata-arg->number message_retry)))
        ((force ~proc) mosq message_retry)))))

;; void mosquitto_user_data_set(struct mosquitto *mosq, void *obj);
(define-public mosquitto_user_data_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search "mosquitto_user_data_set")
                       (list '* '*)))))
    (lambda (mosq obj)
      (let ((mosq (cdata-arg->pointer mosq)) (obj (cdata-arg->pointer obj)))
        ((force ~proc) mosq obj)))))

;; void *mosquitto_userdata(struct mosquitto *mosq);
(define-public mosquitto_userdata
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search "mosquitto_userdata")
                       (list '*)))))
    (lambda (mosq)
      (let ((mosq (cdata-arg->pointer mosq))) ((force ~proc) mosq)))))

;; int mosquitto_tls_set(struct mosquitto *mosq, const char *cafile, const char
;;      *capath, const char *certfile, const char *keyfile, int (*pw_callback)(
;;     char *buf, int size, int rwflag, void *userdata));
(define-public mosquitto_tls_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_tls_set")
                       (list '* '* '* '* '* '*)))))
    (lambda (mosq cafile capath certfile keyfile pw_callback)
      (let ((mosq (cdata-arg->pointer mosq))
            (cafile (cdata-arg->pointer cafile))
            (capath (cdata-arg->pointer capath))
            (certfile (cdata-arg->pointer certfile))
            (keyfile (cdata-arg->pointer keyfile))
            (pw_callback
             (cdata-arg->pointer
              pw_callback
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:int
                   (lambda (buf size rwflag userdata)
                     ((lambda (~ret) (cdata-arg->number ~ret))
                      (~proc buf size rwflag userdata)))
                   (list '* ffi:int ffi:int '*)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq cafile capath certfile keyfile pw_callback)))))

;; int mosquitto_tls_insecure_set(struct mosquitto *mosq, char value);
(define-public mosquitto_tls_insecure_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_tls_insecure_set")
                       (list '* ffi:int8)))))
    (lambda (mosq value)
      (let ((mosq (cdata-arg->pointer mosq)) (value (cdata-arg->number value)))
        ((force ~proc) mosq value)))))

;; int mosquitto_tls_opts_set(struct mosquitto *mosq, int cert_reqs, const char
;;      *tls_version, const char *ciphers);
(define-public mosquitto_tls_opts_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_tls_opts_set")
                       (list '* ffi:int '* '*)))))
    (lambda (mosq cert_reqs tls_version ciphers)
      (let ((mosq (cdata-arg->pointer mosq))
            (cert_reqs (cdata-arg->number cert_reqs))
            (tls_version (cdata-arg->pointer tls_version))
            (ciphers (cdata-arg->pointer ciphers)))
        ((force ~proc) mosq cert_reqs tls_version ciphers)))))

;; int mosquitto_tls_psk_set(struct mosquitto *mosq, const char *psk, const 
;;     char *identity, const char *ciphers);
(define-public mosquitto_tls_psk_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_tls_psk_set")
                       (list '* '* '* '*)))))
    (lambda (mosq psk identity ciphers)
      (let ((mosq (cdata-arg->pointer mosq))
            (psk (cdata-arg->pointer psk))
            (identity (cdata-arg->pointer identity))
            (ciphers (cdata-arg->pointer ciphers)))
        ((force ~proc) mosq psk identity ciphers)))))

;; void *mosquitto_ssl_get(struct mosquitto *mosq);
(define-public mosquitto_ssl_get
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search "mosquitto_ssl_get")
                       (list '*)))))
    (lambda (mosq)
      (let ((mosq (cdata-arg->pointer mosq))) ((force ~proc) mosq)))))

;; void mosquitto_connect_callback_set(struct mosquitto *mosq, void (*
;;     on_connect)(struct mosquitto *, void *, int));
(define-public mosquitto_connect_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_connect_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_connect)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_connect
             (cdata-arg->pointer
              on_connect
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2) (~proc arg0 arg1 arg2))
                   (list '* '* ffi:int)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_connect)))))

;; void mosquitto_connect_with_flags_callback_set(struct mosquitto *mosq, void 
;;     (*on_connect)(struct mosquitto *, void *, int, int));
(define-public mosquitto_connect_with_flags_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_connect_with_flags_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_connect)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_connect
             (cdata-arg->pointer
              on_connect
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2 arg3) (~proc arg0 arg1 arg2 arg3))
                   (list '* '* ffi:int ffi:int)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_connect)))))

;; void mosquitto_connect_v5_callback_set(struct mosquitto *mosq, void (*
;;     on_connect)(struct mosquitto *, void *, int, int, const 
;;     mosquitto_property *props));
(define-public mosquitto_connect_v5_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_connect_v5_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_connect)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_connect
             (cdata-arg->pointer
              on_connect
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2 arg3 props)
                     (let ((props (make-cdata mosquitto_property* props)))
                       (~proc arg0 arg1 arg2 arg3 props)))
                   (list '* '* ffi:int ffi:int '*)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_connect)))))

;; void mosquitto_disconnect_callback_set(struct mosquitto *mosq, void (*
;;     on_disconnect)(struct mosquitto *, void *, int));
(define-public mosquitto_disconnect_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_disconnect_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_disconnect)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_disconnect
             (cdata-arg->pointer
              on_disconnect
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2) (~proc arg0 arg1 arg2))
                   (list '* '* ffi:int)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_disconnect)))))

;; void mosquitto_disconnect_v5_callback_set(struct mosquitto *mosq, void (*
;;     on_disconnect)(struct mosquitto *, void *, int, const mosquitto_property
;;      *props));
(define-public mosquitto_disconnect_v5_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_disconnect_v5_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_disconnect)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_disconnect
             (cdata-arg->pointer
              on_disconnect
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2 props)
                     (let ((props (make-cdata mosquitto_property* props)))
                       (~proc arg0 arg1 arg2 props)))
                   (list '* '* ffi:int '*)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_disconnect)))))

;; void mosquitto_publish_callback_set(struct mosquitto *mosq, void (*
;;     on_publish)(struct mosquitto *, void *, int));
(define-public mosquitto_publish_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_publish_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_publish)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_publish
             (cdata-arg->pointer
              on_publish
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2) (~proc arg0 arg1 arg2))
                   (list '* '* ffi:int)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_publish)))))

;; void mosquitto_publish_v5_callback_set(struct mosquitto *mosq, void (*
;;     on_publish)(struct mosquitto *, void *, int, int, const 
;;     mosquitto_property *props));
(define-public mosquitto_publish_v5_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_publish_v5_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_publish)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_publish
             (cdata-arg->pointer
              on_publish
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2 arg3 props)
                     (let ((props (make-cdata mosquitto_property* props)))
                       (~proc arg0 arg1 arg2 arg3 props)))
                   (list '* '* ffi:int ffi:int '*)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_publish)))))

;; void mosquitto_message_callback_set(struct mosquitto *mosq, void (*
;;     on_message)(struct mosquitto *, void *, const struct mosquitto_message *
;;     ));
(define-public mosquitto_message_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_message_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_message)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_message
             (cdata-arg->pointer
              on_message
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2)
                     (let ((arg2 (make-cdata struct-mosquitto_message* arg2)))
                       (~proc arg0 arg1 arg2)))
                   (list '* '* '*)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_message)))))

;; void mosquitto_message_v5_callback_set(struct mosquitto *mosq, void (*
;;     on_message)(struct mosquitto *, void *, const struct mosquitto_message *
;;     , const mosquitto_property *props));
(define-public mosquitto_message_v5_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_message_v5_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_message)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_message
             (cdata-arg->pointer
              on_message
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2 props)
                     (let ((arg2 (make-cdata struct-mosquitto_message* arg2))
                           (props (make-cdata mosquitto_property* props)))
                       (~proc arg0 arg1 arg2 props)))
                   (list '* '* '* '*)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_message)))))

;; void mosquitto_subscribe_callback_set(struct mosquitto *mosq, void (*
;;     on_subscribe)(struct mosquitto *, void *, int, int, const int *));
(define-public mosquitto_subscribe_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_subscribe_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_subscribe)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_subscribe
             (cdata-arg->pointer
              on_subscribe
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2 arg3 arg4)
                     (~proc arg0 arg1 arg2 arg3 arg4))
                   (list '* '* ffi:int ffi:int '*)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_subscribe)))))

;; void mosquitto_subscribe_v5_callback_set(struct mosquitto *mosq, void (*
;;     on_subscribe)(struct mosquitto *, void *, int, int, const int *, const 
;;     mosquitto_property *props));
(define-public mosquitto_subscribe_v5_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_subscribe_v5_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_subscribe)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_subscribe
             (cdata-arg->pointer
              on_subscribe
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2 arg3 arg4 props)
                     (let ((props (make-cdata mosquitto_property* props)))
                       (~proc arg0 arg1 arg2 arg3 arg4 props)))
                   (list '* '* ffi:int ffi:int '* '*)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_subscribe)))))

;; void mosquitto_unsubscribe_callback_set(struct mosquitto *mosq, void (*
;;     on_unsubscribe)(struct mosquitto *, void *, int));
(define-public mosquitto_unsubscribe_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_unsubscribe_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_unsubscribe)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_unsubscribe
             (cdata-arg->pointer
              on_unsubscribe
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2) (~proc arg0 arg1 arg2))
                   (list '* '* ffi:int)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_unsubscribe)))))

;; void mosquitto_unsubscribe_v5_callback_set(struct mosquitto *mosq, void (*
;;     on_unsubscribe)(struct mosquitto *, void *, int, const 
;;     mosquitto_property *props));
(define-public mosquitto_unsubscribe_v5_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search
                        "mosquitto_unsubscribe_v5_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_unsubscribe)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_unsubscribe
             (cdata-arg->pointer
              on_unsubscribe
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2 props)
                     (let ((props (make-cdata mosquitto_property* props)))
                       (~proc arg0 arg1 arg2 props)))
                   (list '* '* ffi:int '*)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_unsubscribe)))))

;; void mosquitto_log_callback_set(struct mosquitto *mosq, void (*on_log)(
;;     struct mosquitto *, void *, int, const char *));
(define-public mosquitto_log_callback_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search "mosquitto_log_callback_set")
                       (list '* '*)))))
    (lambda (mosq on_log)
      (let ((mosq (cdata-arg->pointer mosq))
            (on_log
             (cdata-arg->pointer
              on_log
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:void
                   (lambda (arg0 arg1 arg2 arg3) (~proc arg0 arg1 arg2 arg3))
                   (list '* '* ffi:int '*)))
                (lambda (p) 'unused))))))
        ((force ~proc) mosq on_log)))))

;; int mosquitto_socks5_set(struct mosquitto *mosq, const char *host, int port
;;     , const char *username, const char *password);
(define-public mosquitto_socks5_set
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_socks5_set")
                       (list '* '* ffi:int '* '*)))))
    (lambda (mosq host port username password)
      (let ((mosq (cdata-arg->pointer mosq))
            (host (cdata-arg->pointer host))
            (port (cdata-arg->number port))
            (username (cdata-arg->pointer username))
            (password (cdata-arg->pointer password)))
        ((force ~proc) mosq host port username password)))))

;; const char *mosquitto_strerror(int mosq_errno);
(define-public mosquitto_strerror
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search "mosquitto_strerror")
                       (list ffi:int)))))
    (lambda (mosq_errno)
      (let ((mosq_errno (cdata-arg->number mosq_errno)))
        ((force ~proc) mosq_errno)))))

;; const char *mosquitto_connack_string(int connack_code);
(define-public mosquitto_connack_string
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search "mosquitto_connack_string")
                       (list ffi:int)))))
    (lambda (connack_code)
      (let ((connack_code (cdata-arg->number connack_code)))
        ((force ~proc) connack_code)))))

;; const char *mosquitto_reason_string(int reason_code);
(define-public mosquitto_reason_string
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search "mosquitto_reason_string")
                       (list ffi:int)))))
    (lambda (reason_code)
      (let ((reason_code (cdata-arg->number reason_code)))
        ((force ~proc) reason_code)))))

;; int mosquitto_string_to_command(const char *str, int *cmd);
(define-public mosquitto_string_to_command
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_string_to_command")
                       (list '* '*)))))
    (lambda (str cmd)
      (let ((str (cdata-arg->pointer str)) (cmd (cdata-arg->pointer cmd)))
        ((force ~proc) str cmd)))))

;; int mosquitto_sub_topic_tokenise(const char *subtopic, char ***topics, int *
;;     count);
(define-public mosquitto_sub_topic_tokenise
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_sub_topic_tokenise")
                       (list '* '* '*)))))
    (lambda (subtopic topics count)
      (let ((subtopic (cdata-arg->pointer subtopic))
            (topics (cdata-arg->pointer topics))
            (count (cdata-arg->pointer count)))
        ((force ~proc) subtopic topics count)))))

;; int mosquitto_sub_topic_tokens_free(char ***topics, int count);
(define-public mosquitto_sub_topic_tokens_free
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search
                        "mosquitto_sub_topic_tokens_free")
                       (list '* ffi:int)))))
    (lambda (topics count)
      (let ((topics (cdata-arg->pointer topics))
            (count (cdata-arg->number count)))
        ((force ~proc) topics count)))))

;; int mosquitto_topic_matches_sub(const char *sub, const char *topic, char *
;;     result);
(define-public mosquitto_topic_matches_sub
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_topic_matches_sub")
                       (list '* '* '*)))))
    (lambda (sub topic result)
      (let ((sub (cdata-arg->pointer sub))
            (topic (cdata-arg->pointer topic))
            (result (cdata-arg->pointer result)))
        ((force ~proc) sub topic result)))))

;; int mosquitto_topic_matches_sub2(const char *sub, size_t sublen, const char 
;;     *topic, size_t topiclen, char *result);
(define-public mosquitto_topic_matches_sub2
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_topic_matches_sub2")
                       (list '* ffi:size_t '* ffi:size_t '*)))))
    (lambda (sub sublen topic topiclen result)
      (let ((sub (cdata-arg->pointer sub))
            (sublen (cdata-arg->number sublen))
            (topic (cdata-arg->pointer topic))
            (topiclen (cdata-arg->number topiclen))
            (result (cdata-arg->pointer result)))
        ((force ~proc) sub sublen topic topiclen result)))))

;; int mosquitto_pub_topic_check(const char *topic);
(define-public mosquitto_pub_topic_check
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_pub_topic_check")
                       (list '*)))))
    (lambda (topic)
      (let ((topic (cdata-arg->pointer topic))) ((force ~proc) topic)))))

;; int mosquitto_pub_topic_check2(const char *topic, size_t topiclen);
(define-public mosquitto_pub_topic_check2
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_pub_topic_check2")
                       (list '* ffi:size_t)))))
    (lambda (topic topiclen)
      (let ((topic (cdata-arg->pointer topic))
            (topiclen (cdata-arg->number topiclen)))
        ((force ~proc) topic topiclen)))))

;; int mosquitto_sub_topic_check(const char *topic);
(define-public mosquitto_sub_topic_check
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_sub_topic_check")
                       (list '*)))))
    (lambda (topic)
      (let ((topic (cdata-arg->pointer topic))) ((force ~proc) topic)))))

;; int mosquitto_sub_topic_check2(const char *topic, size_t topiclen);
(define-public mosquitto_sub_topic_check2
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_sub_topic_check2")
                       (list '* ffi:size_t)))))
    (lambda (topic topiclen)
      (let ((topic (cdata-arg->pointer topic))
            (topiclen (cdata-arg->number topiclen)))
        ((force ~proc) topic topiclen)))))

;; int mosquitto_validate_utf8(const char *str, int len);
(define-public mosquitto_validate_utf8
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_validate_utf8")
                       (list '* ffi:int)))))
    (lambda (str len)
      (let ((str (cdata-arg->pointer str)) (len (cdata-arg->number len)))
        ((force ~proc) str len)))))

;; struct libmosquitto_will {
;;   char *topic;
;;   void *payload;
;;   int payloadlen;
;;   int qos;
;;   char retain;
;; };
(define-public struct-libmosquitto_will
  (name-ctype
   'struct-libmosquitto_will
   (cstruct
    (list `(topic ,(cpointer (cbase 'char)))
          `(payload ,(cpointer 'void))
          `(payloadlen ,(cbase 'int))
          `(qos ,(cbase 'int))
          `(retain ,(cbase 'char))))))
(define-public struct-libmosquitto_will*
  (name-ctype 'struct-libmosquitto_will* (cpointer struct-libmosquitto_will)))

;; struct libmosquitto_auth {
;;   char *username;
;;   char *password;
;; };
(define-public struct-libmosquitto_auth
  (name-ctype
   'struct-libmosquitto_auth
   (cstruct
    (list `(username ,(cpointer (cbase 'char)))
          `(password ,(cpointer (cbase 'char)))))))
(define-public struct-libmosquitto_auth*
  (name-ctype 'struct-libmosquitto_auth* (cpointer struct-libmosquitto_auth)))

;; struct libmosquitto_tls {
;;   char *cafile;
;;   char *capath;
;;   char *certfile;
;;   char *keyfile;
;;   char *ciphers;
;;   char *tls_version;
;;   int (*pw_callback)(char *buf, int size, int rwflag, void *userdata);
;;   int cert_reqs;
;; };
(define-public struct-libmosquitto_tls
  (name-ctype
   'struct-libmosquitto_tls
   (cstruct
    (list `(cafile ,(cpointer (cbase 'char)))
          `(capath ,(cpointer (cbase 'char)))
          `(certfile ,(cpointer (cbase 'char)))
          `(keyfile ,(cpointer (cbase 'char)))
          `(ciphers ,(cpointer (cbase 'char)))
          `(tls_version ,(cpointer (cbase 'char)))
          `(pw_callback
            ,(cpointer
              (cfunction
               (lambda (~proc)
                 (ffi:procedure->pointer
                  ffi:int
                  (lambda (buf size rwflag userdata)
                    ((lambda (~ret) (cdata-arg->number ~ret))
                     (~proc buf size rwflag userdata)))
                  (list '* ffi:int ffi:int '*)))
               (lambda (~fptr)
                 (let ((~proc (ffi:pointer->procedure
                               ffi:int
                               ~fptr
                               (list '* ffi:int ffi:int '*))))
                   (lambda (buf size rwflag userdata)
                     (let ((buf (cdata-arg->pointer buf))
                           (size (cdata-arg->number size))
                           (rwflag (cdata-arg->number rwflag))
                           (userdata (cdata-arg->pointer userdata)))
                       (~proc buf size rwflag userdata))))))))
          `(cert_reqs ,(cbase 'int))))))
(define-public struct-libmosquitto_tls*
  (name-ctype 'struct-libmosquitto_tls* (cpointer struct-libmosquitto_tls)))

;; int mosquitto_subscribe_simple(struct mosquitto_message **messages, int 
;;     msg_count, char want_retained, const char *topic, int qos, const char *
;;     host, int port, const char *client_id, int keepalive, char clean_session
;;     , const char *username, const char *password, const 
;;     struct libmosquitto_will *will, const struct libmosquitto_tls *tls);
(define-public mosquitto_subscribe_simple
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_subscribe_simple")
                       (list '*
                             ffi:int
                             ffi:int8
                             '*
                             ffi:int
                             '*
                             ffi:int
                             '*
                             ffi:int
                             ffi:int8
                             '*
                             '*
                             '*
                             '*)))))
    (lambda (messages
             msg_count
             want_retained
             topic
             qos
             host
             port
             client_id
             keepalive
             clean_session
             username
             password
             will
             tls)
      (let ((messages (cdata-arg->pointer messages))
            (msg_count (cdata-arg->number msg_count))
            (want_retained (cdata-arg->number want_retained))
            (topic (cdata-arg->pointer topic))
            (qos (cdata-arg->number qos))
            (host (cdata-arg->pointer host))
            (port (cdata-arg->number port))
            (client_id (cdata-arg->pointer client_id))
            (keepalive (cdata-arg->number keepalive))
            (clean_session (cdata-arg->number clean_session))
            (username (cdata-arg->pointer username))
            (password (cdata-arg->pointer password))
            (will (cdata-arg->pointer will))
            (tls (cdata-arg->pointer tls)))
        ((force ~proc)
         messages
         msg_count
         want_retained
         topic
         qos
         host
         port
         client_id
         keepalive
         clean_session
         username
         password
         will
         tls)))))

;; int mosquitto_subscribe_callback(int (*callback)(struct mosquitto *, void *
;;     , const struct mosquitto_message *), void *userdata, const char *topic, 
;;     int qos, const char *host, int port, const char *client_id, int 
;;     keepalive, char clean_session, const char *username, const char *
;;     password, const struct libmosquitto_will *will, const 
;;     struct libmosquitto_tls *tls);
(define-public mosquitto_subscribe_callback
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_subscribe_callback")
                       (list '*
                             '*
                             '*
                             ffi:int
                             '*
                             ffi:int
                             '*
                             ffi:int
                             ffi:int8
                             '*
                             '*
                             '*
                             '*)))))
    (lambda (callback
             userdata
             topic
             qos
             host
             port
             client_id
             keepalive
             clean_session
             username
             password
             will
             tls)
      (let ((callback
             (cdata-arg->pointer
              callback
              (cpointer
               (cfunction
                (lambda (~proc)
                  (ffi:procedure->pointer
                   ffi:int
                   (lambda (arg0 arg1 arg2)
                     (let ((arg2 (make-cdata struct-mosquitto_message* arg2)))
                       ((lambda (~ret) (cdata-arg->number ~ret))
                        (~proc arg0 arg1 arg2))))
                   (list '* '* '*)))
                (lambda (p) 'unused)))))
            (userdata (cdata-arg->pointer userdata))
            (topic (cdata-arg->pointer topic))
            (qos (cdata-arg->number qos))
            (host (cdata-arg->pointer host))
            (port (cdata-arg->number port))
            (client_id (cdata-arg->pointer client_id))
            (keepalive (cdata-arg->number keepalive))
            (clean_session (cdata-arg->number clean_session))
            (username (cdata-arg->pointer username))
            (password (cdata-arg->pointer password))
            (will (cdata-arg->pointer will))
            (tls (cdata-arg->pointer tls)))
        ((force ~proc)
         callback
         userdata
         topic
         qos
         host
         port
         client_id
         keepalive
         clean_session
         username
         password
         will
         tls)))))

;; int mosquitto_property_add_byte(mosquitto_property **proplist, int 
;;     identifier, uint8_t value);
(define-public mosquitto_property_add_byte
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_property_add_byte")
                       (list '* ffi:int ffi:uint8)))))
    (lambda (proplist identifier value)
      (let ((proplist (cdata-arg->pointer proplist))
            (identifier (cdata-arg->number identifier))
            (value (cdata-arg->number value)))
        ((force ~proc) proplist identifier value)))))

;; int mosquitto_property_add_int16(mosquitto_property **proplist, int 
;;     identifier, uint16_t value);
(define-public mosquitto_property_add_int16
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_property_add_int16")
                       (list '* ffi:int ffi:uint16)))))
    (lambda (proplist identifier value)
      (let ((proplist (cdata-arg->pointer proplist))
            (identifier (cdata-arg->number identifier))
            (value (cdata-arg->number value)))
        ((force ~proc) proplist identifier value)))))

;; int mosquitto_property_add_int32(mosquitto_property **proplist, int 
;;     identifier, uint32_t value);
(define-public mosquitto_property_add_int32
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_property_add_int32")
                       (list '* ffi:int ffi:uint32)))))
    (lambda (proplist identifier value)
      (let ((proplist (cdata-arg->pointer proplist))
            (identifier (cdata-arg->number identifier))
            (value (cdata-arg->number value)))
        ((force ~proc) proplist identifier value)))))

;; int mosquitto_property_add_varint(mosquitto_property **proplist, int 
;;     identifier, uint32_t value);
(define-public mosquitto_property_add_varint
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_property_add_varint")
                       (list '* ffi:int ffi:uint32)))))
    (lambda (proplist identifier value)
      (let ((proplist (cdata-arg->pointer proplist))
            (identifier (cdata-arg->number identifier))
            (value (cdata-arg->number value)))
        ((force ~proc) proplist identifier value)))))

;; int mosquitto_property_add_binary(mosquitto_property **proplist, int 
;;     identifier, const void *value, uint16_t len);
(define-public mosquitto_property_add_binary
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_property_add_binary")
                       (list '* ffi:int '* ffi:uint16)))))
    (lambda (proplist identifier value len)
      (let ((proplist (cdata-arg->pointer proplist))
            (identifier (cdata-arg->number identifier))
            (value (cdata-arg->pointer value))
            (len (cdata-arg->number len)))
        ((force ~proc) proplist identifier value len)))))

;; int mosquitto_property_add_string(mosquitto_property **proplist, int 
;;     identifier, const char *value);
(define-public mosquitto_property_add_string
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_property_add_string")
                       (list '* ffi:int '*)))))
    (lambda (proplist identifier value)
      (let ((proplist (cdata-arg->pointer proplist))
            (identifier (cdata-arg->number identifier))
            (value (cdata-arg->pointer value)))
        ((force ~proc) proplist identifier value)))))

;; int mosquitto_property_add_string_pair(mosquitto_property **proplist, int 
;;     identifier, const char *name, const char *value);
(define-public mosquitto_property_add_string_pair
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search
                        "mosquitto_property_add_string_pair")
                       (list '* ffi:int '* '*)))))
    (lambda (proplist identifier name value)
      (let ((proplist (cdata-arg->pointer proplist))
            (identifier (cdata-arg->number identifier))
            (name (cdata-arg->pointer name))
            (value (cdata-arg->pointer value)))
        ((force ~proc) proplist identifier name value)))))

;; int mosquitto_property_identifier(const mosquitto_property *property);
(define-public mosquitto_property_identifier
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_property_identifier")
                       (list '*)))))
    (lambda (property)
      (let ((property (cdata-arg->pointer property mosquitto_property*)))
        ((force ~proc) property)))))

;; const mosquitto_property *mosquitto_property_next(const mosquitto_property *
;;     proplist);
(define-public mosquitto_property_next
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search "mosquitto_property_next")
                       (list '*)))))
    (lambda (proplist)
      (let ((proplist (cdata-arg->pointer proplist mosquitto_property*)))
        ((lambda (~ret) (make-cdata mosquitto_property* ~ret))
         ((force ~proc) proplist))))))

;; const mosquitto_property *mosquitto_property_read_byte(const 
;;     mosquitto_property *proplist, int identifier, uint8_t *value, char 
;;     skip_first);
(define-public mosquitto_property_read_byte
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search "mosquitto_property_read_byte")
                       (list '* ffi:int '* ffi:int8)))))
    (lambda (proplist identifier value skip_first)
      (let ((proplist (cdata-arg->pointer proplist mosquitto_property*))
            (identifier (cdata-arg->number identifier))
            (value (cdata-arg->pointer value))
            (skip_first (cdata-arg->number skip_first)))
        ((lambda (~ret) (make-cdata mosquitto_property* ~ret))
         ((force ~proc) proplist identifier value skip_first))))))

;; const mosquitto_property *mosquitto_property_read_int16(const 
;;     mosquitto_property *proplist, int identifier, uint16_t *value, char 
;;     skip_first);
(define-public mosquitto_property_read_int16
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search "mosquitto_property_read_int16")
                       (list '* ffi:int '* ffi:int8)))))
    (lambda (proplist identifier value skip_first)
      (let ((proplist (cdata-arg->pointer proplist mosquitto_property*))
            (identifier (cdata-arg->number identifier))
            (value (cdata-arg->pointer value))
            (skip_first (cdata-arg->number skip_first)))
        ((lambda (~ret) (make-cdata mosquitto_property* ~ret))
         ((force ~proc) proplist identifier value skip_first))))))

;; const mosquitto_property *mosquitto_property_read_int32(const 
;;     mosquitto_property *proplist, int identifier, uint32_t *value, char 
;;     skip_first);
(define-public mosquitto_property_read_int32
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search "mosquitto_property_read_int32")
                       (list '* ffi:int '* ffi:int8)))))
    (lambda (proplist identifier value skip_first)
      (let ((proplist (cdata-arg->pointer proplist mosquitto_property*))
            (identifier (cdata-arg->number identifier))
            (value (cdata-arg->pointer value))
            (skip_first (cdata-arg->number skip_first)))
        ((lambda (~ret) (make-cdata mosquitto_property* ~ret))
         ((force ~proc) proplist identifier value skip_first))))))

;; const mosquitto_property *mosquitto_property_read_varint(const 
;;     mosquitto_property *proplist, int identifier, uint32_t *value, char 
;;     skip_first);
(define-public mosquitto_property_read_varint
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search
                        "mosquitto_property_read_varint")
                       (list '* ffi:int '* ffi:int8)))))
    (lambda (proplist identifier value skip_first)
      (let ((proplist (cdata-arg->pointer proplist mosquitto_property*))
            (identifier (cdata-arg->number identifier))
            (value (cdata-arg->pointer value))
            (skip_first (cdata-arg->number skip_first)))
        ((lambda (~ret) (make-cdata mosquitto_property* ~ret))
         ((force ~proc) proplist identifier value skip_first))))))

;; const mosquitto_property *mosquitto_property_read_binary(const 
;;     mosquitto_property *proplist, int identifier, void **value, uint16_t *
;;     len, char skip_first);
(define-public mosquitto_property_read_binary
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search
                        "mosquitto_property_read_binary")
                       (list '* ffi:int '* '* ffi:int8)))))
    (lambda (proplist identifier value len skip_first)
      (let ((proplist (cdata-arg->pointer proplist mosquitto_property*))
            (identifier (cdata-arg->number identifier))
            (value (cdata-arg->pointer value))
            (len (cdata-arg->pointer len))
            (skip_first (cdata-arg->number skip_first)))
        ((lambda (~ret) (make-cdata mosquitto_property* ~ret))
         ((force ~proc) proplist identifier value len skip_first))))))

;; const mosquitto_property *mosquitto_property_read_string(const 
;;     mosquitto_property *proplist, int identifier, char **value, char 
;;     skip_first);
(define-public mosquitto_property_read_string
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search
                        "mosquitto_property_read_string")
                       (list '* ffi:int '* ffi:int8)))))
    (lambda (proplist identifier value skip_first)
      (let ((proplist (cdata-arg->pointer proplist mosquitto_property*))
            (identifier (cdata-arg->number identifier))
            (value (cdata-arg->pointer value))
            (skip_first (cdata-arg->number skip_first)))
        ((lambda (~ret) (make-cdata mosquitto_property* ~ret))
         ((force ~proc) proplist identifier value skip_first))))))

;; const mosquitto_property *mosquitto_property_read_string_pair(const 
;;     mosquitto_property *proplist, int identifier, char **name, char **value
;;     , char skip_first);
(define-public mosquitto_property_read_string_pair
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search
                        "mosquitto_property_read_string_pair")
                       (list '* ffi:int '* '* ffi:int8)))))
    (lambda (proplist identifier name value skip_first)
      (let ((proplist (cdata-arg->pointer proplist mosquitto_property*))
            (identifier (cdata-arg->number identifier))
            (name (cdata-arg->pointer name))
            (value (cdata-arg->pointer value))
            (skip_first (cdata-arg->number skip_first)))
        ((lambda (~ret) (make-cdata mosquitto_property* ~ret))
         ((force ~proc) proplist identifier name value skip_first))))))

;; void mosquitto_property_free_all(mosquitto_property **properties);
(define-public mosquitto_property_free_all
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:void
                       (foreign-pointer-search "mosquitto_property_free_all")
                       (list '*)))))
    (lambda (properties)
      (let ((properties (cdata-arg->pointer properties)))
        ((force ~proc) properties)))))

;; int mosquitto_property_copy_all(mosquitto_property **dest, const 
;;     mosquitto_property *src);
(define-public mosquitto_property_copy_all
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_property_copy_all")
                       (list '* '*)))))
    (lambda (dest src)
      (let ((dest (cdata-arg->pointer dest))
            (src (cdata-arg->pointer src mosquitto_property*)))
        ((force ~proc) dest src)))))

;; int mosquitto_property_check_command(int command, int identifier);
(define-public mosquitto_property_check_command
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search
                        "mosquitto_property_check_command")
                       (list ffi:int ffi:int)))))
    (lambda (command identifier)
      (let ((command (cdata-arg->number command))
            (identifier (cdata-arg->number identifier)))
        ((force ~proc) command identifier)))))

;; int mosquitto_property_check_all(int command, const mosquitto_property *
;;     properties);
(define-public mosquitto_property_check_all
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search "mosquitto_property_check_all")
                       (list ffi:int '*)))))
    (lambda (command properties)
      (let ((command (cdata-arg->number command))
            (properties (cdata-arg->pointer properties mosquitto_property*)))
        ((force ~proc) command properties)))))

;; const char *mosquitto_property_identifier_to_string(int identifier);
(define-public mosquitto_property_identifier_to_string
  (let ((~proc (delay (ffi:pointer->procedure
                       '*
                       (foreign-pointer-search
                        "mosquitto_property_identifier_to_string")
                       (list ffi:int)))))
    (lambda (identifier)
      (let ((identifier (cdata-arg->number identifier)))
        ((force ~proc) identifier)))))

;; int mosquitto_string_to_property_info(const char *propname, int *identifier
;;     , int *type);
(define-public mosquitto_string_to_property_info
  (let ((~proc (delay (ffi:pointer->procedure
                       ffi:int
                       (foreign-pointer-search
                        "mosquitto_string_to_property_info")
                       (list '* '* '*)))))
    (lambda (propname identifier type)
      (let ((propname (cdata-arg->pointer propname))
            (identifier (cdata-arg->pointer identifier))
            (type (cdata-arg->pointer type)))
        ((force ~proc) propname identifier type)))))

;; access to enum symbols and #define'd constants:
(define ffi-mosquitto-symbol-tab
  '((MOSQ_OPT_TLS_USE_OS_CERTS . 13)
    (MOSQ_OPT_BIND_ADDRESS . 12)
    (MOSQ_OPT_TCP_NODELAY . 11)
    (MOSQ_OPT_TLS_ALPN . 10)
    (MOSQ_OPT_TLS_OCSP_REQUIRED . 9)
    (MOSQ_OPT_TLS_ENGINE_KPASS_SHA1 . 8)
    (MOSQ_OPT_TLS_ENGINE . 7)
    (MOSQ_OPT_TLS_KEYFORM . 6)
    (MOSQ_OPT_SEND_MAXIMUM . 5)
    (MOSQ_OPT_RECEIVE_MAXIMUM . 4)
    (MOSQ_OPT_SSL_CTX_WITH_DEFAULTS . 3)
    (MOSQ_OPT_SSL_CTX . 2)
    (MOSQ_OPT_PROTOCOL_VERSION . 1)
    (MOSQ_ERR_ALREADY_EXISTS . 31)
    (MOSQ_ERR_ADMINISTRATIVE_ACTION . 30)
    (MOSQ_ERR_TOPIC_ALIAS_INVALID . 29)
    (MOSQ_ERR_RETAIN_NOT_SUPPORTED . 28)
    (MOSQ_ERR_TIMEOUT . 27)
    (MOSQ_ERR_OCSP . 26)
    (MOSQ_ERR_OVERSIZE_PACKET . 25)
    (MOSQ_ERR_QOS_NOT_SUPPORTED . 24)
    (MOSQ_ERR_TLS_HANDSHAKE . 23)
    (MOSQ_ERR_DUPLICATE_PROPERTY . 22)
    (MOSQ_ERR_MALFORMED_PACKET . 21)
    (MOSQ_ERR_LOOKUP . 20)
    (MOSQ_ERR_KEEPALIVE . 19)
    (MOSQ_ERR_MALFORMED_UTF8 . 18)
    (MOSQ_ERR_PLUGIN_DEFER . 17)
    (MOSQ_ERR_PROXY . 16)
    (MOSQ_ERR_EAI . 15)
    (MOSQ_ERR_ERRNO . 14)
    (MOSQ_ERR_UNKNOWN . 13)
    (MOSQ_ERR_ACL_DENIED . 12)
    (MOSQ_ERR_AUTH . 11)
    (MOSQ_ERR_NOT_SUPPORTED . 10)
    (MOSQ_ERR_PAYLOAD_SIZE . 9)
    (MOSQ_ERR_TLS . 8)
    (MOSQ_ERR_CONN_LOST . 7)
    (MOSQ_ERR_NOT_FOUND . 6)
    (MOSQ_ERR_CONN_REFUSED . 5)
    (MOSQ_ERR_NO_CONN . 4)
    (MOSQ_ERR_INVAL . 3)
    (MOSQ_ERR_PROTOCOL . 2)
    (MOSQ_ERR_NOMEM . 1)
    (MOSQ_ERR_SUCCESS . 0)
    (MOSQ_ERR_CONN_PENDING . -1)
    (MOSQ_ERR_SUB_EXISTS . -2)
    (MOSQ_ERR_NO_SUBSCRIBERS . -3)
    (MOSQ_ERR_AUTH_CONTINUE . -4)
    (MQTT_PROTOCOL_V5 . 5)
    (MQTT_PROTOCOL_V311 . 4)
    (MQTT_PROTOCOL_V31 . 3)
    (MOSQ_MQTT_ID_MAX_LENGTH . 23)
    (MOSQ_LOG_ALL . 4294967295)
    (MOSQ_LOG_INTERNAL . 2147483648)
    (MOSQ_LOG_WEBSOCKETS . 128)
    (MOSQ_LOG_UNSUBSCRIBE . 64)
    (MOSQ_LOG_SUBSCRIBE . 32)
    (MOSQ_LOG_DEBUG . 16)
    (MOSQ_LOG_ERR . 8)
    (MOSQ_LOG_WARNING . 4)
    (MOSQ_LOG_NOTICE . 2)
    (MOSQ_LOG_INFO . 1)
    (MOSQ_LOG_NONE . 0)
    (LIBMOSQUITTO_VERSION_NUMBER . 2000022)
    (LIBMOSQUITTO_REVISION . 22)
    (LIBMOSQUITTO_MINOR . 0)
    (LIBMOSQUITTO_MAJOR . 2)))
(export ffi-mosquitto-symbol-tab)

(define ffi-mosquitto-symbol-val
  (lambda (k) (or (assq-ref ffi-mosquitto-symbol-tab k))))
(export ffi-mosquitto-symbol-val)

(define (unwrap~enum arg)
  (cond
    ((number? arg) arg)
    ((symbol? arg) (ffi-mosquitto-symbol-val arg))
    ((cdata? arg) (cdata-ref arg))
    (else (error "type mismatch"))))

(define ffi-mosquitto-types
  '((enum . "mosq_err_t") (enum . "mosq_opt_t") (struct . "mosquitto_message")
    (pointer . "mosquitto_property") "mosquitto_property" (struct . 
    "libmosquitto_will") (struct . "libmosquitto_auth") (struct . 
    "libmosquitto_tls")))
(export ffi-mosquitto-types)

;; --- last line ---
