/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.reporting.ReportSpec;
import org.gradle.api.reporting.internal.ReportUtilities;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.instrumentation.api.annotations.NotToBeReplacedByLazyProperty;

public abstract class ReportingExtension {
    public static final String NAME = "reporting";
    public static final String DEFAULT_REPORTS_DIR_NAME = "reports";
    private final Project project;

    @Inject
    public ReportingExtension(Project project) {
        this.project = project;
    }

    public abstract DirectoryProperty getBaseDirectory();

    @Deprecated
    public File file(String path) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(ReportingExtension.class, (String)"file(String)").replaceWith((Object)"getBaseDirectory().file(String) or getBaseDirectory().dir(String)")).willBeRemovedInGradle10().withUpgradeGuideSection(9, "reporting_extension_file")).nagUser();
        return ((RegularFile)this.getBaseDirectory().file(path).get()).getAsFile();
    }

    @Deprecated
    @NotToBeReplacedByLazyProperty(because="this method is deprecated")
    public String getApiDocTitle() {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateMethod(ReportingExtension.class, (String)"getApiDocTitle()").willBeRemovedInGradle10().withUpgradeGuideSection(9, "reporting_extension_api_doc_title")).nagUser();
        return ReportUtilities.getApiDocTitleFor(this.project);
    }

    @Incubating
    public abstract ExtensiblePolymorphicDomainObjectContainer<ReportSpec> getReports();

    @Incubating
    public void reports(Action<? super ExtensiblePolymorphicDomainObjectContainer<ReportSpec>> action) {
        action.execute(this.getReports());
    }
}

