pragma Ada_2012;

pragma Style_Checks (Off);
pragma Warnings (Off, "-gnatwu");

with Interfaces.C; use Interfaces.C;

package cmonitor_h is

  -- * Copyright (c) 2014-2021 Enrico M. Crisostomo
  -- *
  -- * This program is free software; you can redistribute it and/or modify it under
  -- * the terms of the GNU General Public License as published by the Free Software
  -- * Foundation; either version 3, or (at your option) any later version.
  -- *
  -- * This program is distributed in the hope that it will be useful, but WITHOUT
  -- * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  -- * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  -- * details.
  -- *
  -- * You should have received a copy of the GNU General Public License along with
  -- * this program.  If not, see <http://www.gnu.org/licenses/>.
  --  

  --*
  -- * @file
  -- * @brief Header of the `libfswatch` library defining the monitor types.
  -- *
  -- * @copyright Copyright (c) 2014-2016 Enrico M. Crisostomo
  -- * @license GNU General Public License v. 3.0
  -- * @author Enrico M. Crisostomo
  -- * @version 1.8.0
  --  

  --*
  --   * @brief Available monitors.
  --   *
  --   * This enumeration lists all the available monitors, where the special
  --   * ::system_default_monitor_type element refers to the platform-specific
  --   * default monitor.
  --    

   type fsw_monitor_type is 
     (system_default_monitor_type,
      fsevents_monitor_type,
      kqueue_monitor_type,
      inotify_monitor_type,
      windows_monitor_type,
      poll_monitor_type,
      fen_monitor_type)
   with Convention => C;  -- D:/M/msys64/ucrt64/include/libfswatch/c/cmonitor.h:43

  --*< System default monitor.  
  --*< macOS FSEvents monitor.  
  --*< BSD `kqueue` monitor.  
  --*< Linux `inotify` monitor.  
  --*< Windows monitor.  
  --*< `stat()`-based poll monitor.  
  --*< Solaris/Illumos monitor.  
end cmonitor_h;

pragma Style_Checks (On);
pragma Warnings (On, "-gnatwu");
