# Citing SUNDIALS

We ask users of SUNDIALS to cite the following papers in any publications
reporting work done with SUNDIALS:

```bibtex
@article{gardner2022sundials,
  title     = {Enabling new flexibility in the {SUNDIALS} suite of nonlinear and differential/algebraic equation solvers},
  author    = {Gardner, David J and Reynolds, Daniel R and Woodward, Carol S and Balos, Cody J},
  journal   = {ACM Transactions on Mathematical Software (TOMS)},
  publisher = {ACM},
  volume    = {48},
  number    = {3},
  pages     = {1--24},
  year      = {2022},
  doi       = {10.1145/3539801}
}
```

```bibtex
@article{hindmarsh2005sundials,
  title     = {{SUNDIALS}: Suite of nonlinear and differential/algebraic equation solvers},
  author    = {Hindmarsh, Alan C and Brown, Peter N and Grant, Keith E and Lee, Steven L and Serban, Radu and Shumaker, Dan E and Woodward, Carol S},
  journal   = {ACM Transactions on Mathematical Software (TOMS)},
  publisher = {ACM},
  volume    = {31},
  number    = {3},
  pages     = {363--396},
  year      = {2005},
  doi       = {10.1145/1089014.1089020}
}
```

If any GPU features of SUNDIALS were utilized, please also cite:

```bibtex
@article{balos2021enabling,
  title     = {{Enabling GPU accelerated computing in the SUNDIALS time integration library}},
  author    = {Balos, Cody J and Gardner, David J and Woodward, Carol S and Reynolds, Daniel R},
  journal   = {Parallel Computing},
  publisher = {Elsevier},
  volume    = {108},
  pages     = {102836},
  year      = {2021},
  doi       = {10.1016/j.parco.2021.102836}
}
```

When using the ARKODE package from SUNDIALS, please also cite:

```bibtex
@article{reynolds2023arkode,
  title   = {{ARKODE: A flexible IVP solver infrastructure for one-step methods}},
  author  = {Reynolds, Daniel R and Gardner, David J and Woodward, Carol S and Chinomona, Rujeko},
  journal = {ACM Transactions on Mathematical Software},
  volume  = {49},
  number  = {2},
  pages   = {1--26},
  year    = {2023},
  doi     = {10.1145/3594632}
}
```

We also ask that users cite the documentation for the package and version that
they are using rather than the combined SUNDIALS online guide:

```bibtex
@Misc{arkodeDocumentation,
  author = {Daniel R. Reynolds and David J. Gardner and Carol S. Woodward and Cody J. Balos},
  title  = {User Documentation for ARKODE},
  year   = {2025},
  note   = {v6.5.0}
}
```

```bibtex
@Misc{cvodeDocumentation,
  author = {Alan C. Hindmarsh and Radu Serban and Cody J. Balos and David J. Gardner and Daniel R. Reynolds and Carol S. Woodward},
  title  = {User Documentation for CVODE},
  year   = {2025},
  note   = {v7.5.0}
}
```

```bibtex
@Misc{cvodesDocumentation,
  author = {Alan C. Hindmarsh and Radu Serban and Cody J. Balos and David J. Gardner and Daniel R. Reynolds and Carol S. Woodward},
  title  = {User Documentation for CVODES},
  year   = {2025},
  note   = {v7.5.0}
}
```

```bibtex
@Misc{idaDocumentation,
  author = {Alan C. Hindmarsh and Radu Serban and Cody J. Balos and David J. Gardner and Daniel R. Reynolds and Carol S. Woodward},
  title  = {User Documentation for IDA},
  year   = {2025},
  note   = {v7.5.0}
}
```

```bibtex
@Misc{idasDocumentation,
  author = {Radu Serban and Cosmin Petra and Alan C. Hindmarsh and Cody J. Balos and David J. Gardner and Daniel R. Reynolds and Carol S. Woodward},
  title  = {User Documentation for IDAS},
  year   = {2025},
  note   = {v6.5.0}
}
```

```bibtex
@Misc{kinsolDocumentation,
  author = {Alan C. Hindmarsh and Radu Serban and Cody J. Balos and David J. Gardner and Daniel R. Reynolds and Carol S. Woodward},
  title  = {User Documentation for KINSOL},
  year   = {2025},
  note   = {v7.5.0}
}
```
