# @HEADER
# *****************************************************************************
#            TriBITS: Tribal Build, Integrate, and Test System
#
# Copyright 2013-2016 NTESS and the TriBITS contributors.
# SPDX-License-Identifier: BSD-3-Clause
# *****************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Seacas/SEACASNemesis clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "SEACASNemesis requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Seacas/SEACASNemesis build
## ---------------------------------------------------------------------------

set(SEACASNemesis_CXX_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/g++.exe")

set(SEACASNemesis_C_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/gcc.exe")

set(SEACASNemesis_Fortran_COMPILER "gfortran")
# Deprecated!
set(SEACASNemesis_FORTRAN_COMPILER "gfortran") 


## ---------------------------------------------------------------------------
## Compiler flags used by Seacas/SEACASNemesis build
## ---------------------------------------------------------------------------

## Give the build type
set(SEACASNemesis_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(SEACASNemesis_CXX_FLAGS [[ ]])

set(SEACASNemesis_C_FLAGS [[  -Wall -Wunused -pedantic -Wshadow -std=c11 ]])

set(SEACASNemesis_Fortran_FLAGS [[ ]])
# Deprecated
set(SEACASNemesis_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(SEACASNemesis_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(SEACASNemesis_SHARED_LIB_RPATH_COMMAND "${CMAKE_CURRENT_LIST_DIR}/../../../lib")
set(SEACASNemesis_BUILD_SHARED_LIBS "ON")

set(SEACASNemesis_LINKER ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ld.exe)
set(SEACASNemesis_AR ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(SEACASNemesis_INSTALL_DIR "${CMAKE_CURRENT_LIST_DIR}/../../..")

## List of package libraries
set(SEACASNemesis_LIBRARIES SEACASNemesis::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(SEACASNemesis_MPI_LIBRARIES "")
set(SEACASNemesis_MPI_LIBRARY_DIRS "")
set(SEACASNemesis_MPI_INCLUDE_DIRS "")
set(SEACASNemesis_MPI_EXEC "")
set(SEACASNemesis_MPI_EXEC_MAX_NUMPROCS "")
set(SEACASNemesis_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(SEACASNemesis_ENABLE_SEACASExodus ON)
set(SEACASNemesis_ENABLE_Netcdf ON)
set(SEACASNemesis_ENABLE_Pthread ON)
set(SEACASNemesis_ENABLE_HDF5 OFF)
set(SEACASNemesis_ENABLE_Pnetcdf OFF)
set(SEACASNemesis_ENABLE_MPI OFF)

# Exported cache variables
set(SEACAS_ENABLE_DEBUG "OFF")
set(HAVE_SEACAS_DEBUG "OFF")
set(SEACASExodus_ENABLE_THREADSAFE "YES")
set(EXODUS_THREADSAFE "ON")
set(SEACASIoss_ENABLE_THREADSAFE "YES")
set(IOSS_THREADSAFE "ON")

# Include configuration of dependent packages
if (NOT TARGET SEACASExodus::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASExodus/SEACASExodusConfig.cmake")
endif()
if (NOT TARGET Netcdf::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/Netcdf/NetcdfConfig.cmake")
endif()
if (NOT TARGET Pthread::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/Pthread/PthreadConfig.cmake")
endif()

# Import SEACASNemesis targets
include("${CMAKE_CURRENT_LIST_DIR}/SEACASNemesisTargets.cmake")

# Standard TriBITS-compliant external package variables
set(SEACASNemesis_IS_TRIBITS_COMPLIANT TRUE)
set(SEACASNemesis_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(SEACASNemesis_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(SEACASNemesis_EXPORTED_PACKAGE_LIBS_NAMES "nemesis")

foreach(libname IN LISTS SEACASNemesis_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE SEACASNemesis::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Seacas', then use the"
      " new namespaced target 'SEACASNemesis::${libname}', or better yet,"
      " 'SEACASNemesis::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'SEACASNemesis'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Seacas', instead link against the"
      " libraries specified by the variable 'SEACASNemesis_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
