
"""
This script is meant to be sourced inside GDB when debugging a program that
uses liblktlang. It installs Langkit's "GDB helpers": pretty-printers and
custom commands that are convenient when debugging liblktlang. Note that GDB
helpers require the Langkit Python library.
"""

import sys


sys.path.append('D:/W/B/src/build-MINGW64')


try:
    import langkit.gdb
except ImportError as exc:
    print(
        f"{__file__}: Cannot import the 'langkit.gdb' Python package: langkit"
        " GDB helpers require it",
        file=sys.stderr,
    )
else:
    
    langkit.gdb.setup(
        lib_name='liblktlang',
        astnode_names=['Lkt_Node', 'Argument', 'Base_Lexer_Case_Rule_Alt', 'Lexer_Case_Rule_Cond_Alt', 'Lexer_Case_Rule_Default_Alt', 'Base_Match_Branch', 'Match_Branch', 'Pattern_Match_Branch', 'Block_Expr_Clause', 'Block_String_Line', 'Class_Qualifier', 'Class_Qualifier_Absent', 'Class_Qualifier_Present', 'Decl', 'Base_Grammar_Rule_Decl', 'Grammar_Rule_Decl', 'Synthetic_Lexer_Decl', 'Base_Val_Decl', 'Node_Decl', 'Self_Decl', 'User_Val_Decl', 'Binding_Val_Decl', 'Enum_Lit_Decl', 'Explicitly_Typed_Decl', 'Component_Decl', 'Field_Decl', 'Fun_Param_Decl', 'Lambda_Param_Decl', 'Dyn_Var_Decl', 'Match_Val_Decl', 'Val_Decl', 'Fun_Decl', 'Env_Spec_Decl', 'Error_Decl', 'Generic_Decl', 'Grammar_Decl', 'Lexer_Decl', 'Lexer_Family_Decl', 'Synth_Fun_Decl', 'Synth_Param_Decl', 'Type_Decl', 'Any_Type_Decl', 'Enum_Class_Alt_Decl', 'Function_Type', 'Generic_Param_Type_Decl', 'Named_Type_Decl', 'Basic_Class_Decl', 'Class_Decl', 'Enum_Class_Decl', 'Enum_Type_Decl', 'Struct_Decl', 'Trait_Decl', 'Decl_Annotation', 'Decl_Annotation_Args', 'Dyn_Env_Wrapper', 'Elsif_Branch', 'Enum_Class_Case', 'Excludes_Null', 'Excludes_Null_Absent', 'Excludes_Null_Present', 'Expr', 'Any_Of', 'Array_Literal', 'Base_Call_Expr', 'Call_Expr', 'Logic_Call_Expr', 'Logic_Predicate', 'Logic_Propagate_Call', 'Bin_Op', 'Block_Expr', 'Cast_Expr', 'Dot_Expr', 'Error_On_Null', 'Generic_Instantiation', 'Grammar_Expr', 'Grammar_Cut', 'Grammar_Discard', 'Grammar_Dont_Skip', 'Grammar_List', 'Grammar_Null', 'Grammar_Opt', 'Grammar_Opt_Error', 'Grammar_Opt_Error_Group', 'Grammar_Opt_Group', 'Grammar_Or_Expr', 'Grammar_Pick', 'Grammar_Implicit_Pick', 'Grammar_Predicate', 'Grammar_Rule_Ref', 'Grammar_Skip', 'Grammar_Stop_Cut', 'Parse_Node_Expr', 'Token_Lit', 'Token_No_Case_Lit', 'Token_Pattern_Concat', 'Token_Pattern_Lit', 'Token_Ref', 'Id', 'Def_Id', 'Module_Ref_Id', 'Ref_Id', 'If_Expr', 'Isa', 'Keep_Expr', 'Lambda_Expr', 'Lit', 'Big_Num_Lit', 'Char_Lit', 'Null_Lit', 'Num_Lit', 'String_Lit', 'Block_String_Lit', 'Single_Line_String_Lit', 'Pattern_Single_Line_String_Lit', 'Logic_Assign', 'Logic_Expr', 'Logic_Propagate', 'Logic_Unify', 'Match_Expr', 'Not_Expr', 'Paren_Expr', 'Raise_Expr', 'Subscript_Expr', 'Try_Expr', 'Un_Op', 'Full_Decl', 'Grammar_List_Sep', 'Import', 'Langkit_Root', 'Lexer_Case_Rule', 'Lexer_Case_Rule_Send', 'List_Kind', 'List_Kind_One', 'List_Kind_Zero', 'Lkt_Node_Base_List', 'Argument_List', 'Base_Lexer_Case_Rule_Alt_List', 'Base_Match_Branch_List', 'Block_String_Line_List', 'Call_Expr_List', 'Decl_Annotation_List', 'Elsif_Branch_List', 'Enum_Class_Alt_Decl_List', 'Enum_Class_Case_List', 'Enum_Lit_Decl_List', 'Expr_List', 'Any_Of_List', 'Full_Decl_List', 'Decl_Block', 'Generic_Param_Decl_List', 'Fun_Param_Decl_List', 'Grammar_Expr_List', 'Grammar_Expr_List_List', 'Import_List', 'Lambda_Param_Decl_List', 'Lkt_Node_List', 'Pattern_Detail_List', 'Pattern_List', 'Ref_Id_List', 'Type_Ref_List', 'Synthetic_Type_Ref_List', 'Null_Cond_Qualifier', 'Null_Cond_Qualifier_Absent', 'Null_Cond_Qualifier_Present', 'Op', 'Op_Amp', 'Op_And', 'Op_Div', 'Op_Eq', 'Op_Gt', 'Op_Gte', 'Op_Logic_And', 'Op_Logic_Or', 'Op_Lt', 'Op_Lte', 'Op_Minus', 'Op_Mult', 'Op_Ne', 'Op_Or', 'Op_Or_Int', 'Op_Plus', 'Pattern', 'Any_Type_Pattern', 'Binding_Pattern', 'Bool_Pattern', 'Bool_Pattern_False', 'Bool_Pattern_True', 'Ellipsis_Pattern', 'Extended_Pattern', 'Filtered_Pattern', 'Integer_Pattern', 'List_Pattern', 'Not_Pattern', 'Null_Pattern', 'Or_Pattern', 'Paren_Pattern', 'Regex_Pattern', 'Tuple_Pattern', 'Type_Pattern', 'Pattern_Detail', 'Field_Pattern_Detail', 'Property_Pattern_Detail', 'Selector_Pattern_Detail', 'Selector_Call', 'Type_Ref', 'Default_List_Type_Ref', 'Function_Type_Ref', 'Generic_Type_Ref', 'Simple_Type_Ref', 'Var_Bind'],
        astnode_kinds={1: 'Argument', 2: 'Lexer_Case_Rule_Cond_Alt', 3: 'Lexer_Case_Rule_Default_Alt', 4: 'Match_Branch', 5: 'Pattern_Match_Branch', 6: 'Block_Expr_Clause', 7: 'Block_String_Line', 8: 'Class_Qualifier_Absent', 9: 'Class_Qualifier_Present', 10: 'Grammar_Rule_Decl', 11: 'Synthetic_Lexer_Decl', 12: 'Node_Decl', 13: 'Self_Decl', 14: 'Binding_Val_Decl', 15: 'Enum_Lit_Decl', 16: 'Field_Decl', 17: 'Fun_Param_Decl', 18: 'Lambda_Param_Decl', 19: 'Dyn_Var_Decl', 20: 'Match_Val_Decl', 21: 'Val_Decl', 22: 'Fun_Decl', 23: 'Env_Spec_Decl', 24: 'Error_Decl', 25: 'Generic_Decl', 26: 'Grammar_Decl', 27: 'Lexer_Decl', 28: 'Lexer_Family_Decl', 29: 'Synth_Fun_Decl', 30: 'Synth_Param_Decl', 31: 'Any_Type_Decl', 32: 'Enum_Class_Alt_Decl', 33: 'Function_Type', 34: 'Generic_Param_Type_Decl', 35: 'Class_Decl', 36: 'Enum_Class_Decl', 37: 'Enum_Type_Decl', 38: 'Struct_Decl', 39: 'Trait_Decl', 40: 'Decl_Annotation', 41: 'Decl_Annotation_Args', 42: 'Dyn_Env_Wrapper', 43: 'Elsif_Branch', 44: 'Enum_Class_Case', 45: 'Excludes_Null_Absent', 46: 'Excludes_Null_Present', 47: 'Any_Of', 48: 'Array_Literal', 49: 'Call_Expr', 50: 'Logic_Predicate', 51: 'Logic_Propagate_Call', 52: 'Bin_Op', 53: 'Block_Expr', 54: 'Cast_Expr', 55: 'Dot_Expr', 56: 'Error_On_Null', 57: 'Generic_Instantiation', 58: 'Grammar_Cut', 59: 'Grammar_Discard', 60: 'Grammar_Dont_Skip', 61: 'Grammar_List', 62: 'Grammar_Null', 63: 'Grammar_Opt', 64: 'Grammar_Opt_Error', 65: 'Grammar_Opt_Error_Group', 66: 'Grammar_Opt_Group', 67: 'Grammar_Or_Expr', 68: 'Grammar_Pick', 69: 'Grammar_Implicit_Pick', 70: 'Grammar_Predicate', 71: 'Grammar_Rule_Ref', 72: 'Grammar_Skip', 73: 'Grammar_Stop_Cut', 74: 'Parse_Node_Expr', 75: 'Token_Lit', 76: 'Token_No_Case_Lit', 77: 'Token_Pattern_Concat', 78: 'Token_Pattern_Lit', 79: 'Token_Ref', 80: 'Id', 81: 'Def_Id', 82: 'Module_Ref_Id', 83: 'Ref_Id', 84: 'If_Expr', 85: 'Isa', 86: 'Keep_Expr', 87: 'Lambda_Expr', 88: 'Big_Num_Lit', 89: 'Char_Lit', 90: 'Null_Lit', 91: 'Num_Lit', 92: 'Block_String_Lit', 93: 'Single_Line_String_Lit', 94: 'Pattern_Single_Line_String_Lit', 95: 'Logic_Assign', 96: 'Logic_Expr', 97: 'Logic_Propagate', 98: 'Logic_Unify', 99: 'Match_Expr', 100: 'Not_Expr', 101: 'Paren_Expr', 102: 'Raise_Expr', 103: 'Subscript_Expr', 104: 'Try_Expr', 105: 'Un_Op', 106: 'Full_Decl', 107: 'Grammar_List_Sep', 108: 'Import', 109: 'Langkit_Root', 110: 'Lexer_Case_Rule', 111: 'Lexer_Case_Rule_Send', 112: 'List_Kind_One', 113: 'List_Kind_Zero', 114: 'Argument_List', 115: 'Base_Lexer_Case_Rule_Alt_List', 116: 'Base_Match_Branch_List', 117: 'Block_String_Line_List', 118: 'Call_Expr_List', 119: 'Decl_Annotation_List', 120: 'Elsif_Branch_List', 121: 'Enum_Class_Alt_Decl_List', 122: 'Enum_Class_Case_List', 123: 'Enum_Lit_Decl_List', 124: 'Expr_List', 125: 'Any_Of_List', 126: 'Full_Decl_List', 127: 'Decl_Block', 128: 'Generic_Param_Decl_List', 129: 'Fun_Param_Decl_List', 130: 'Grammar_Expr_List', 131: 'Grammar_Expr_List_List', 132: 'Import_List', 133: 'Lambda_Param_Decl_List', 134: 'Lkt_Node_List', 135: 'Pattern_Detail_List', 136: 'Pattern_List', 137: 'Ref_Id_List', 138: 'Type_Ref_List', 139: 'Synthetic_Type_Ref_List', 140: 'Null_Cond_Qualifier_Absent', 141: 'Null_Cond_Qualifier_Present', 142: 'Op_Amp', 143: 'Op_And', 144: 'Op_Div', 145: 'Op_Eq', 146: 'Op_Gt', 147: 'Op_Gte', 148: 'Op_Logic_And', 149: 'Op_Logic_Or', 150: 'Op_Lt', 151: 'Op_Lte', 152: 'Op_Minus', 153: 'Op_Mult', 154: 'Op_Ne', 155: 'Op_Or', 156: 'Op_Or_Int', 157: 'Op_Plus', 158: 'Any_Type_Pattern', 159: 'Binding_Pattern', 160: 'Bool_Pattern_False', 161: 'Bool_Pattern_True', 162: 'Ellipsis_Pattern', 163: 'Extended_Pattern', 164: 'Filtered_Pattern', 165: 'Integer_Pattern', 166: 'List_Pattern', 167: 'Not_Pattern', 168: 'Null_Pattern', 169: 'Or_Pattern', 170: 'Paren_Pattern', 171: 'Regex_Pattern', 172: 'Tuple_Pattern', 173: 'Type_Pattern', 174: 'Field_Pattern_Detail', 175: 'Property_Pattern_Detail', 176: 'Selector_Pattern_Detail', 177: 'Selector_Call', 178: 'Default_List_Type_Ref', 179: 'Function_Type_Ref', 180: 'Generic_Type_Ref', 181: 'Simple_Type_Ref', 182: 'Var_Bind'},
        prefix='lkt'
    )
