--
--  Copyright (C) 2014-2022, AdaCore
--  SPDX-License-Identifier: Apache-2.0
--

--  This package provides contants to refer to Libadalang types and struct
--  members in the generic introspection API
--  (``Langkit_Support.Generic_API.Introspection``).

with Langkit_Support.Generic_API.Introspection;

package Libadalang.Generic_API.Introspection is

   package G renames Langkit_Support.Generic_API.Introspection;

   ---------------------
   -- Type references --
   ---------------------

   package Type_Refs is
         Analysis_Unit : constant G.Type_Ref :=
           G.From_Index (Self_Id, 1);
         Big_Integer : constant G.Type_Ref :=
           G.From_Index (Self_Id, 2);
         Boolean : constant G.Type_Ref :=
           G.From_Index (Self_Id, 3);
         Character_Type : constant G.Type_Ref :=
           G.From_Index (Self_Id, 4);
         Integer : constant G.Type_Ref :=
           G.From_Index (Self_Id, 5);
         Source_Location : constant G.Type_Ref :=
           G.From_Index (Self_Id, 6);
         Source_Location_Range : constant G.Type_Ref :=
           G.From_Index (Self_Id, 7);
         Text_Type : constant G.Type_Ref :=
           G.From_Index (Self_Id, 8);
         Token_Reference : constant G.Type_Ref :=
           G.From_Index (Self_Id, 9);
         Unbounded_Text_Type : constant G.Type_Ref :=
           G.From_Index (Self_Id, 10);
         Analysis_Unit_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 11);
         Call_Expr_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 12);
         Completion_Item_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 13);
         Designated_Env_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 14);
         Grammar_Rule : constant G.Type_Ref :=
           G.From_Index (Self_Id, 15);
         Lookup_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 16);
         Ref_Result_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 17);
         Aspect_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 18);
         Discriminant_Values_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 19);
         Doc_Annotation_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 20);
         Accept_Stmt_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 21);
         Ada_Node_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 22);
         Base_Formal_Param_Decl_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 23);
         Base_Type_Decl_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 24);
         Basic_Decl_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 25);
         Compilation_Unit_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 26);
         Defining_Name_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 27);
         Expr_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 28);
         Generic_Instantiation_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 29);
         Param_Spec_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 30);
         Pragma_Node_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 31);
         Type_Decl_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 32);
         Logic_Context_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 33);
         Param_Actual_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 34);
         Ref_Result_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 35);
         Shape_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 36);
         Solver_Diagnostic_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 37);
         Substitution_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 38);
         Analysis_Unit_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 39);
         Unbounded_Text_Type_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 40);
         Completion_Item_Iterator : constant G.Type_Ref :=
           G.From_Index (Self_Id, 41);
         Aspect : constant G.Type_Ref :=
           G.From_Index (Self_Id, 42);
         Completion_Item : constant G.Type_Ref :=
           G.From_Index (Self_Id, 43);
         Discrete_Range : constant G.Type_Ref :=
           G.From_Index (Self_Id, 44);
         Discriminant_Values : constant G.Type_Ref :=
           G.From_Index (Self_Id, 45);
         Doc_Annotation : constant G.Type_Ref :=
           G.From_Index (Self_Id, 46);
         Logic_Context : constant G.Type_Ref :=
           G.From_Index (Self_Id, 47);
         Param_Actual : constant G.Type_Ref :=
           G.From_Index (Self_Id, 48);
         Ref_Result : constant G.Type_Ref :=
           G.From_Index (Self_Id, 49);
         Refd_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 50);
         Shape : constant G.Type_Ref :=
           G.From_Index (Self_Id, 51);
         Solver_Diagnostic : constant G.Type_Ref :=
           G.From_Index (Self_Id, 52);
         Substitution : constant G.Type_Ref :=
           G.From_Index (Self_Id, 53);
         Ada_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 54);
         Abort_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 55);
         Abort_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 56);
         Abort_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 57);
         Abstract_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 58);
         Abstract_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 59);
         Abstract_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 60);
         Ada_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 61);
         Ada_Node_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 62);
         Abstract_State_Decl_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 63);
         Alternatives_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 64);
         Constraint_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 65);
         Decl_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 66);
         Stmt_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 67);
         Aspect_Assoc_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 68);
         Base_Assoc_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 69);
         Basic_Assoc_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 70);
         Assoc_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 71);
         Case_Expr_Alternative_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 72);
         Case_Stmt_Alternative_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 73);
         Compilation_Unit_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 74);
         Concat_Operand_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 75);
         Contract_Case_Assoc_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 76);
         Defining_Name_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 77);
         Discriminant_Spec_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 78);
         Elsif_Expr_Part_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 79);
         Elsif_Stmt_Part_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 80);
         Enum_Literal_Decl_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 81);
         Expr_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 82);
         Expr_Alternatives_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 83);
         Format_String_Chunk_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 84);
         Identifier_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 85);
         Discriminant_Choice_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 86);
         Name_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 87);
         Parent_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 88);
         Param_Spec_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 89);
         Pragma_Node_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 90);
         Select_When_Part_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 91);
         Unconstrained_Array_Index_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 92);
         Variant_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 93);
         Aliased_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 94);
         Aliased_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 95);
         Aliased_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 96);
         All_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 97);
         All_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 98);
         All_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 99);
         Array_Indices : constant G.Type_Ref :=
           G.From_Index (Self_Id, 100);
         Constrained_Array_Indices : constant G.Type_Ref :=
           G.From_Index (Self_Id, 101);
         Unconstrained_Array_Indices : constant G.Type_Ref :=
           G.From_Index (Self_Id, 102);
         Aspect_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 103);
         Aspect_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 104);
         At_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 105);
         Attribute_Def_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 106);
         Enum_Rep_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 107);
         Record_Rep_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 108);
         Aspect_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 109);
         Base_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 110);
         Contract_Case_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 111);
         Pragma_Argument_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 112);
         Base_Formal_Param_Holder : constant G.Type_Ref :=
           G.From_Index (Self_Id, 113);
         Base_Subp_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 114);
         Entry_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 115);
         Enum_Subp_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 116);
         Subp_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 117);
         Synthetic_Binary_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 118);
         Synthetic_Unary_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 119);
         Component_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 120);
         Discriminant_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 121);
         Known_Discriminant_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 122);
         Unknown_Discriminant_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 123);
         Entry_Completion_Formal_Params : constant G.Type_Ref :=
           G.From_Index (Self_Id, 124);
         Generic_Formal_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 125);
         Base_Record_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 126);
         Null_Record_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 127);
         Record_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 128);
         Basic_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 129);
         Aggregate_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 130);
         Multi_Dim_Array_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 131);
         Composite_Constraint_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 132);
         Iterated_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 133);
         Param_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 134);
         Basic_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 135);
         Abstract_State_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 136);
         Anonymous_Expr_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 137);
         Base_Formal_Param_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 138);
         Component_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 139);
         Discriminant_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 140);
         Generic_Formal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 141);
         Generic_Formal_Obj_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 142);
         Generic_Formal_Package : constant G.Type_Ref :=
           G.From_Index (Self_Id, 143);
         Generic_Formal_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 144);
         Generic_Formal_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 145);
         Param_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 146);
         Synthetic_Formal_Param_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 147);
         Base_Package_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 148);
         Generic_Package_Internal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 149);
         Package_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 150);
         Base_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 151);
         Base_Subtype_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 152);
         Discrete_Base_Subtype_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 153);
         Subtype_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 154);
         Classwide_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 155);
         Incomplete_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 156);
         Incomplete_Formal_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 157);
         Incomplete_Tagged_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 158);
         Protected_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 159);
         Task_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 160);
         Single_Task_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 161);
         Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 162);
         Anonymous_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 163);
         Synth_Anonymous_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 164);
         Concrete_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 165);
         Formal_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 166);
         Basic_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 167);
         Classic_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 168);
         Abstract_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 169);
         Formal_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 170);
         Abstract_Formal_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 171);
         Concrete_Formal_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 172);
         Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 173);
         Entry_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 174);
         Enum_Literal_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 175);
         Synthetic_Char_Enum_Lit : constant G.Type_Ref :=
           G.From_Index (Self_Id, 176);
         Generic_Subp_Internal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 177);
         Synthetic_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 178);
         Body_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 179);
         Accept_Stmt_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 180);
         Base_Subp_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 181);
         Expr_Function : constant G.Type_Ref :=
           G.From_Index (Self_Id, 182);
         Null_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 183);
         Subp_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 184);
         Subp_Renaming_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 185);
         Body_Stub : constant G.Type_Ref :=
           G.From_Index (Self_Id, 186);
         Package_Body_Stub : constant G.Type_Ref :=
           G.From_Index (Self_Id, 187);
         Protected_Body_Stub : constant G.Type_Ref :=
           G.From_Index (Self_Id, 188);
         Subp_Body_Stub : constant G.Type_Ref :=
           G.From_Index (Self_Id, 189);
         Task_Body_Stub : constant G.Type_Ref :=
           G.From_Index (Self_Id, 190);
         Entry_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 191);
         Package_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 192);
         Protected_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 193);
         Task_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 194);
         Entry_Index_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 195);
         Error_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 196);
         Exception_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 197);
         Exception_Handler : constant G.Type_Ref :=
           G.From_Index (Self_Id, 198);
         For_Loop_Var_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 199);
         Generic_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 200);
         Generic_Package_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 201);
         Generic_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 202);
         Generic_Instantiation : constant G.Type_Ref :=
           G.From_Index (Self_Id, 203);
         Generic_Package_Instantiation : constant G.Type_Ref :=
           G.From_Index (Self_Id, 204);
         Generic_Subp_Instantiation : constant G.Type_Ref :=
           G.From_Index (Self_Id, 205);
         Generic_Renaming_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 206);
         Generic_Package_Renaming_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 207);
         Generic_Subp_Renaming_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 208);
         Label_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 209);
         Named_Stmt_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 210);
         Number_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 211);
         Object_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 212);
         Extended_Return_Stmt_Object_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 213);
         No_Type_Object_Renaming_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 214);
         Package_Renaming_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 215);
         Single_Protected_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 216);
         Single_Task_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 217);
         Synthetic_Object_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 218);
         Case_Stmt_Alternative : constant G.Type_Ref :=
           G.From_Index (Self_Id, 219);
         Compilation_Unit : constant G.Type_Ref :=
           G.From_Index (Self_Id, 220);
         Component_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 221);
         Component_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 222);
         Constant_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 223);
         Constant_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 224);
         Constant_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 225);
         Constraint : constant G.Type_Ref :=
           G.From_Index (Self_Id, 226);
         Composite_Constraint : constant G.Type_Ref :=
           G.From_Index (Self_Id, 227);
         Delta_Constraint : constant G.Type_Ref :=
           G.From_Index (Self_Id, 228);
         Digits_Constraint : constant G.Type_Ref :=
           G.From_Index (Self_Id, 229);
         Range_Constraint : constant G.Type_Ref :=
           G.From_Index (Self_Id, 230);
         Declarative_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 231);
         Private_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 232);
         Public_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 233);
         Else_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 234);
         Elsif_Expr_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 235);
         Elsif_Stmt_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 236);
         Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 237);
         Abstract_State_Decl_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 238);
         Allocator : constant G.Type_Ref :=
           G.From_Index (Self_Id, 239);
         Base_Aggregate : constant G.Type_Ref :=
           G.From_Index (Self_Id, 240);
         Aggregate : constant G.Type_Ref :=
           G.From_Index (Self_Id, 241);
         Bracket_Aggregate : constant G.Type_Ref :=
           G.From_Index (Self_Id, 242);
         Delta_Aggregate : constant G.Type_Ref :=
           G.From_Index (Self_Id, 243);
         Bracket_Delta_Aggregate : constant G.Type_Ref :=
           G.From_Index (Self_Id, 244);
         Null_Record_Aggregate : constant G.Type_Ref :=
           G.From_Index (Self_Id, 245);
         Bin_Op : constant G.Type_Ref :=
           G.From_Index (Self_Id, 246);
         Relation_Op : constant G.Type_Ref :=
           G.From_Index (Self_Id, 247);
         Box_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 248);
         Case_Expr_Alternative : constant G.Type_Ref :=
           G.From_Index (Self_Id, 249);
         Concat_Op : constant G.Type_Ref :=
           G.From_Index (Self_Id, 250);
         Concat_Operand : constant G.Type_Ref :=
           G.From_Index (Self_Id, 251);
         Cond_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 252);
         Case_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 253);
         If_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 254);
         Contract_Cases : constant G.Type_Ref :=
           G.From_Index (Self_Id, 255);
         Decl_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 256);
         Format_String_Literal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 257);
         Membership_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 258);
         Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 259);
         Array_Subcomponent_Choice_Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 260);
         Attribute_Ref : constant G.Type_Ref :=
           G.From_Index (Self_Id, 261);
         Call_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 262);
         Defining_Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 263);
         Synthetic_Defining_Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 264);
         Discrete_Subtype_Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 265);
         Dotted_Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 266);
         End_Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 267);
         Explicit_Deref : constant G.Type_Ref :=
           G.From_Index (Self_Id, 268);
         Qual_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 269);
         Reduce_Attribute_Ref : constant G.Type_Ref :=
           G.From_Index (Self_Id, 270);
         Single_Tok_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 271);
         Base_Id : constant G.Type_Ref :=
           G.From_Index (Self_Id, 272);
         Char_Literal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 273);
         Identifier : constant G.Type_Ref :=
           G.From_Index (Self_Id, 274);
         Op : constant G.Type_Ref :=
           G.From_Index (Self_Id, 275);
         Op_Abs : constant G.Type_Ref :=
           G.From_Index (Self_Id, 276);
         Op_And : constant G.Type_Ref :=
           G.From_Index (Self_Id, 277);
         Op_And_Then : constant G.Type_Ref :=
           G.From_Index (Self_Id, 278);
         Op_Concat : constant G.Type_Ref :=
           G.From_Index (Self_Id, 279);
         Op_Div : constant G.Type_Ref :=
           G.From_Index (Self_Id, 280);
         Op_Double_Dot : constant G.Type_Ref :=
           G.From_Index (Self_Id, 281);
         Op_Eq : constant G.Type_Ref :=
           G.From_Index (Self_Id, 282);
         Op_Gt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 283);
         Op_Gte : constant G.Type_Ref :=
           G.From_Index (Self_Id, 284);
         Op_In : constant G.Type_Ref :=
           G.From_Index (Self_Id, 285);
         Op_Lt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 286);
         Op_Lte : constant G.Type_Ref :=
           G.From_Index (Self_Id, 287);
         Op_Minus : constant G.Type_Ref :=
           G.From_Index (Self_Id, 288);
         Op_Mod : constant G.Type_Ref :=
           G.From_Index (Self_Id, 289);
         Op_Mult : constant G.Type_Ref :=
           G.From_Index (Self_Id, 290);
         Op_Neq : constant G.Type_Ref :=
           G.From_Index (Self_Id, 291);
         Op_Not : constant G.Type_Ref :=
           G.From_Index (Self_Id, 292);
         Op_Not_In : constant G.Type_Ref :=
           G.From_Index (Self_Id, 293);
         Op_Or : constant G.Type_Ref :=
           G.From_Index (Self_Id, 294);
         Op_Or_Else : constant G.Type_Ref :=
           G.From_Index (Self_Id, 295);
         Op_Plus : constant G.Type_Ref :=
           G.From_Index (Self_Id, 296);
         Op_Pow : constant G.Type_Ref :=
           G.From_Index (Self_Id, 297);
         Op_Rem : constant G.Type_Ref :=
           G.From_Index (Self_Id, 298);
         Op_Xor : constant G.Type_Ref :=
           G.From_Index (Self_Id, 299);
         String_Literal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 300);
         Null_Literal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 301);
         Num_Literal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 302);
         Int_Literal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 303);
         Real_Literal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 304);
         Synthetic_Identifier : constant G.Type_Ref :=
           G.From_Index (Self_Id, 305);
         Target_Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 306);
         Update_Attribute_Ref : constant G.Type_Ref :=
           G.From_Index (Self_Id, 307);
         Paren_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 308);
         Quantified_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 309);
         Raise_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 310);
         Un_Op : constant G.Type_Ref :=
           G.From_Index (Self_Id, 311);
         For_Loop_Iter_Filter : constant G.Type_Ref :=
           G.From_Index (Self_Id, 312);
         Format_String_Chunk : constant G.Type_Ref :=
           G.From_Index (Self_Id, 313);
         Format_String_Tok_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 314);
         Format_String_Tok_End : constant G.Type_Ref :=
           G.From_Index (Self_Id, 315);
         Format_String_Tok_Mid : constant G.Type_Ref :=
           G.From_Index (Self_Id, 316);
         Format_String_Tok_Start : constant G.Type_Ref :=
           G.From_Index (Self_Id, 317);
         Format_String_Tok_String : constant G.Type_Ref :=
           G.From_Index (Self_Id, 318);
         Handled_Stmts : constant G.Type_Ref :=
           G.From_Index (Self_Id, 319);
         Interface_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 320);
         Interface_Kind_Limited : constant G.Type_Ref :=
           G.From_Index (Self_Id, 321);
         Interface_Kind_Protected : constant G.Type_Ref :=
           G.From_Index (Self_Id, 322);
         Interface_Kind_Synchronized : constant G.Type_Ref :=
           G.From_Index (Self_Id, 323);
         Interface_Kind_Task : constant G.Type_Ref :=
           G.From_Index (Self_Id, 324);
         Iter_Type : constant G.Type_Ref :=
           G.From_Index (Self_Id, 325);
         Iter_Type_In : constant G.Type_Ref :=
           G.From_Index (Self_Id, 326);
         Iter_Type_Of : constant G.Type_Ref :=
           G.From_Index (Self_Id, 327);
         Library_Item : constant G.Type_Ref :=
           G.From_Index (Self_Id, 328);
         Limited_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 329);
         Limited_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 330);
         Limited_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 331);
         Loop_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 332);
         For_Loop_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 333);
         While_Loop_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 334);
         Mode : constant G.Type_Ref :=
           G.From_Index (Self_Id, 335);
         Mode_Default : constant G.Type_Ref :=
           G.From_Index (Self_Id, 336);
         Mode_In : constant G.Type_Ref :=
           G.From_Index (Self_Id, 337);
         Mode_In_Out : constant G.Type_Ref :=
           G.From_Index (Self_Id, 338);
         Mode_Out : constant G.Type_Ref :=
           G.From_Index (Self_Id, 339);
         Multi_Abstract_State_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 340);
         Not_Null : constant G.Type_Ref :=
           G.From_Index (Self_Id, 341);
         Not_Null_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 342);
         Not_Null_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 343);
         Null_Component_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 344);
         Others_Designator : constant G.Type_Ref :=
           G.From_Index (Self_Id, 345);
         Overriding_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 346);
         Overriding_Not_Overriding : constant G.Type_Ref :=
           G.From_Index (Self_Id, 347);
         Overriding_Overriding : constant G.Type_Ref :=
           G.From_Index (Self_Id, 348);
         Overriding_Unspecified : constant G.Type_Ref :=
           G.From_Index (Self_Id, 349);
         Params : constant G.Type_Ref :=
           G.From_Index (Self_Id, 350);
         Paren_Abstract_State_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 351);
         Pp_Directive : constant G.Type_Ref :=
           G.From_Index (Self_Id, 352);
         Pp_Else_Directive : constant G.Type_Ref :=
           G.From_Index (Self_Id, 353);
         Pp_Elsif_Directive : constant G.Type_Ref :=
           G.From_Index (Self_Id, 354);
         Pp_End_If_Directive : constant G.Type_Ref :=
           G.From_Index (Self_Id, 355);
         Pp_If_Directive : constant G.Type_Ref :=
           G.From_Index (Self_Id, 356);
         Pp_Then_Kw : constant G.Type_Ref :=
           G.From_Index (Self_Id, 357);
         Pragma_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 358);
         Private_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 359);
         Private_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 360);
         Private_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 361);
         Protected_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 362);
         Protected_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 363);
         Protected_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 364);
         Protected_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 365);
         Quantifier : constant G.Type_Ref :=
           G.From_Index (Self_Id, 366);
         Quantifier_All : constant G.Type_Ref :=
           G.From_Index (Self_Id, 367);
         Quantifier_Some : constant G.Type_Ref :=
           G.From_Index (Self_Id, 368);
         Range_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 369);
         Renaming_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 370);
         Synthetic_Renaming_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 371);
         Reverse_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 372);
         Reverse_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 373);
         Reverse_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 374);
         Select_When_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 375);
         Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 376);
         Composite_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 377);
         Accept_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 378);
         Accept_Stmt_With_Stmts : constant G.Type_Ref :=
           G.From_Index (Self_Id, 379);
         Base_Loop_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 380);
         For_Loop_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 381);
         Loop_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 382);
         While_Loop_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 383);
         Block_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 384);
         Begin_Block : constant G.Type_Ref :=
           G.From_Index (Self_Id, 385);
         Decl_Block : constant G.Type_Ref :=
           G.From_Index (Self_Id, 386);
         Case_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 387);
         Extended_Return_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 388);
         If_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 389);
         Named_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 390);
         Select_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 391);
         Error_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 392);
         Simple_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 393);
         Abort_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 394);
         Assign_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 395);
         Call_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 396);
         Delay_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 397);
         Exit_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 398);
         Goto_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 399);
         Label : constant G.Type_Ref :=
           G.From_Index (Self_Id, 400);
         Null_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 401);
         Raise_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 402);
         Requeue_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 403);
         Return_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 404);
         Simple_Decl_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 405);
         Terminate_Alternative : constant G.Type_Ref :=
           G.From_Index (Self_Id, 406);
         Subp_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 407);
         Subp_Kind_Function : constant G.Type_Ref :=
           G.From_Index (Self_Id, 408);
         Subp_Kind_Procedure : constant G.Type_Ref :=
           G.From_Index (Self_Id, 409);
         Subunit : constant G.Type_Ref :=
           G.From_Index (Self_Id, 410);
         Synchronized_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 411);
         Synchronized_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 412);
         Synchronized_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 413);
         Tagged_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 414);
         Tagged_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 415);
         Tagged_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 416);
         Task_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 417);
         Then_Abort_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 418);
         Type_Attributes_Repository : constant G.Type_Ref :=
           G.From_Index (Self_Id, 419);
         Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 420);
         Access_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 421);
         Access_To_Subp_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 422);
         Base_Type_Access_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 423);
         Anonymous_Type_Access_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 424);
         Type_Access_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 425);
         Array_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 426);
         Derived_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 427);
         Enum_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 428);
         Formal_Discrete_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 429);
         Interface_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 430);
         Mod_Int_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 431);
         Private_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 432);
         Real_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 433);
         Decimal_Fixed_Point_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 434);
         Floating_Point_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 435);
         Ordinary_Fixed_Point_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 436);
         Record_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 437);
         Signed_Int_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 438);
         Type_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 439);
         Anonymous_Type : constant G.Type_Ref :=
           G.From_Index (Self_Id, 440);
         Enum_Lit_Synth_Type_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 441);
         Subtype_Indication : constant G.Type_Ref :=
           G.From_Index (Self_Id, 442);
         Constrained_Subtype_Indication : constant G.Type_Ref :=
           G.From_Index (Self_Id, 443);
         Discrete_Subtype_Indication : constant G.Type_Ref :=
           G.From_Index (Self_Id, 444);
         Synthetic_Type_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 445);
         Unconstrained_Array_Index : constant G.Type_Ref :=
           G.From_Index (Self_Id, 446);
         Until_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 447);
         Until_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 448);
         Until_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 449);
         Use_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 450);
         Use_Package_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 451);
         Use_Type_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 452);
         Value_Sequence : constant G.Type_Ref :=
           G.From_Index (Self_Id, 453);
         Variant : constant G.Type_Ref :=
           G.From_Index (Self_Id, 454);
         Variant_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 455);
         With_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 456);
         With_Private : constant G.Type_Ref :=
           G.From_Index (Self_Id, 457);
         With_Private_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 458);
         With_Private_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 459);
   end Type_Refs;

   Kind_To_Type : constant array (Ada_Node_Kind_Type) of G.Type_Ref :=
     (Ada_Abort_Absent => Type_Refs.Abort_Absent,
      Ada_Abort_Present => Type_Refs.Abort_Present,
      Ada_Abstract_Absent => Type_Refs.Abstract_Absent,
      Ada_Abstract_Present => Type_Refs.Abstract_Present,
      Ada_Ada_Node_List => Type_Refs.Ada_Node_List,
      Ada_Abstract_State_Decl_List => Type_Refs.Abstract_State_Decl_List,
      Ada_Alternatives_List => Type_Refs.Alternatives_List,
      Ada_Constraint_List => Type_Refs.Constraint_List,
      Ada_Decl_List => Type_Refs.Decl_List,
      Ada_Stmt_List => Type_Refs.Stmt_List,
      Ada_Aspect_Assoc_List => Type_Refs.Aspect_Assoc_List,
      Ada_Base_Assoc_List => Type_Refs.Base_Assoc_List,
      Ada_Assoc_List => Type_Refs.Assoc_List,
      Ada_Case_Expr_Alternative_List => Type_Refs.Case_Expr_Alternative_List,
      Ada_Case_Stmt_Alternative_List => Type_Refs.Case_Stmt_Alternative_List,
      Ada_Compilation_Unit_List => Type_Refs.Compilation_Unit_List,
      Ada_Concat_Operand_List => Type_Refs.Concat_Operand_List,
      Ada_Contract_Case_Assoc_List => Type_Refs.Contract_Case_Assoc_List,
      Ada_Defining_Name_List => Type_Refs.Defining_Name_List,
      Ada_Discriminant_Spec_List => Type_Refs.Discriminant_Spec_List,
      Ada_Elsif_Expr_Part_List => Type_Refs.Elsif_Expr_Part_List,
      Ada_Elsif_Stmt_Part_List => Type_Refs.Elsif_Stmt_Part_List,
      Ada_Enum_Literal_Decl_List => Type_Refs.Enum_Literal_Decl_List,
      Ada_Expr_Alternatives_List => Type_Refs.Expr_Alternatives_List,
      Ada_Format_String_Chunk_List => Type_Refs.Format_String_Chunk_List,
      Ada_Discriminant_Choice_List => Type_Refs.Discriminant_Choice_List,
      Ada_Name_List => Type_Refs.Name_List,
      Ada_Parent_List => Type_Refs.Parent_List,
      Ada_Param_Spec_List => Type_Refs.Param_Spec_List,
      Ada_Pragma_Node_List => Type_Refs.Pragma_Node_List,
      Ada_Select_When_Part_List => Type_Refs.Select_When_Part_List,
      Ada_Unconstrained_Array_Index_List => Type_Refs.Unconstrained_Array_Index_List,
      Ada_Variant_List => Type_Refs.Variant_List,
      Ada_Aliased_Absent => Type_Refs.Aliased_Absent,
      Ada_Aliased_Present => Type_Refs.Aliased_Present,
      Ada_All_Absent => Type_Refs.All_Absent,
      Ada_All_Present => Type_Refs.All_Present,
      Ada_Constrained_Array_Indices => Type_Refs.Constrained_Array_Indices,
      Ada_Unconstrained_Array_Indices => Type_Refs.Unconstrained_Array_Indices,
      Ada_Aspect_Assoc => Type_Refs.Aspect_Assoc,
      Ada_At_Clause => Type_Refs.At_Clause,
      Ada_Attribute_Def_Clause => Type_Refs.Attribute_Def_Clause,
      Ada_Enum_Rep_Clause => Type_Refs.Enum_Rep_Clause,
      Ada_Record_Rep_Clause => Type_Refs.Record_Rep_Clause,
      Ada_Aspect_Spec => Type_Refs.Aspect_Spec,
      Ada_Contract_Case_Assoc => Type_Refs.Contract_Case_Assoc,
      Ada_Pragma_Argument_Assoc => Type_Refs.Pragma_Argument_Assoc,
      Ada_Entry_Spec => Type_Refs.Entry_Spec,
      Ada_Enum_Subp_Spec => Type_Refs.Enum_Subp_Spec,
      Ada_Subp_Spec => Type_Refs.Subp_Spec,
      Ada_Synthetic_Binary_Spec => Type_Refs.Synthetic_Binary_Spec,
      Ada_Synthetic_Unary_Spec => Type_Refs.Synthetic_Unary_Spec,
      Ada_Component_List => Type_Refs.Component_List,
      Ada_Known_Discriminant_Part => Type_Refs.Known_Discriminant_Part,
      Ada_Unknown_Discriminant_Part => Type_Refs.Unknown_Discriminant_Part,
      Ada_Entry_Completion_Formal_Params => Type_Refs.Entry_Completion_Formal_Params,
      Ada_Generic_Formal_Part => Type_Refs.Generic_Formal_Part,
      Ada_Null_Record_Def => Type_Refs.Null_Record_Def,
      Ada_Record_Def => Type_Refs.Record_Def,
      Ada_Aggregate_Assoc => Type_Refs.Aggregate_Assoc,
      Ada_Multi_Dim_Array_Assoc => Type_Refs.Multi_Dim_Array_Assoc,
      Ada_Composite_Constraint_Assoc => Type_Refs.Composite_Constraint_Assoc,
      Ada_Iterated_Assoc => Type_Refs.Iterated_Assoc,
      Ada_Param_Assoc => Type_Refs.Param_Assoc,
      Ada_Abstract_State_Decl => Type_Refs.Abstract_State_Decl,
      Ada_Anonymous_Expr_Decl => Type_Refs.Anonymous_Expr_Decl,
      Ada_Component_Decl => Type_Refs.Component_Decl,
      Ada_Discriminant_Spec => Type_Refs.Discriminant_Spec,
      Ada_Generic_Formal_Obj_Decl => Type_Refs.Generic_Formal_Obj_Decl,
      Ada_Generic_Formal_Package => Type_Refs.Generic_Formal_Package,
      Ada_Generic_Formal_Subp_Decl => Type_Refs.Generic_Formal_Subp_Decl,
      Ada_Generic_Formal_Type_Decl => Type_Refs.Generic_Formal_Type_Decl,
      Ada_Param_Spec => Type_Refs.Param_Spec,
      Ada_Synthetic_Formal_Param_Decl => Type_Refs.Synthetic_Formal_Param_Decl,
      Ada_Generic_Package_Internal => Type_Refs.Generic_Package_Internal,
      Ada_Package_Decl => Type_Refs.Package_Decl,
      Ada_Discrete_Base_Subtype_Decl => Type_Refs.Discrete_Base_Subtype_Decl,
      Ada_Subtype_Decl => Type_Refs.Subtype_Decl,
      Ada_Classwide_Type_Decl => Type_Refs.Classwide_Type_Decl,
      Ada_Incomplete_Type_Decl => Type_Refs.Incomplete_Type_Decl,
      Ada_Incomplete_Formal_Type_Decl => Type_Refs.Incomplete_Formal_Type_Decl,
      Ada_Incomplete_Tagged_Type_Decl => Type_Refs.Incomplete_Tagged_Type_Decl,
      Ada_Protected_Type_Decl => Type_Refs.Protected_Type_Decl,
      Ada_Task_Type_Decl => Type_Refs.Task_Type_Decl,
      Ada_Single_Task_Type_Decl => Type_Refs.Single_Task_Type_Decl,
      Ada_Anonymous_Type_Decl => Type_Refs.Anonymous_Type_Decl,
      Ada_Synth_Anonymous_Type_Decl => Type_Refs.Synth_Anonymous_Type_Decl,
      Ada_Concrete_Type_Decl => Type_Refs.Concrete_Type_Decl,
      Ada_Formal_Type_Decl => Type_Refs.Formal_Type_Decl,
      Ada_Abstract_Subp_Decl => Type_Refs.Abstract_Subp_Decl,
      Ada_Abstract_Formal_Subp_Decl => Type_Refs.Abstract_Formal_Subp_Decl,
      Ada_Concrete_Formal_Subp_Decl => Type_Refs.Concrete_Formal_Subp_Decl,
      Ada_Subp_Decl => Type_Refs.Subp_Decl,
      Ada_Entry_Decl => Type_Refs.Entry_Decl,
      Ada_Enum_Literal_Decl => Type_Refs.Enum_Literal_Decl,
      Ada_Synthetic_Char_Enum_Lit => Type_Refs.Synthetic_Char_Enum_Lit,
      Ada_Generic_Subp_Internal => Type_Refs.Generic_Subp_Internal,
      Ada_Synthetic_Subp_Decl => Type_Refs.Synthetic_Subp_Decl,
      Ada_Accept_Stmt_Body => Type_Refs.Accept_Stmt_Body,
      Ada_Expr_Function => Type_Refs.Expr_Function,
      Ada_Null_Subp_Decl => Type_Refs.Null_Subp_Decl,
      Ada_Subp_Body => Type_Refs.Subp_Body,
      Ada_Subp_Renaming_Decl => Type_Refs.Subp_Renaming_Decl,
      Ada_Package_Body_Stub => Type_Refs.Package_Body_Stub,
      Ada_Protected_Body_Stub => Type_Refs.Protected_Body_Stub,
      Ada_Subp_Body_Stub => Type_Refs.Subp_Body_Stub,
      Ada_Task_Body_Stub => Type_Refs.Task_Body_Stub,
      Ada_Entry_Body => Type_Refs.Entry_Body,
      Ada_Package_Body => Type_Refs.Package_Body,
      Ada_Protected_Body => Type_Refs.Protected_Body,
      Ada_Task_Body => Type_Refs.Task_Body,
      Ada_Entry_Index_Spec => Type_Refs.Entry_Index_Spec,
      Ada_Error_Decl => Type_Refs.Error_Decl,
      Ada_Exception_Decl => Type_Refs.Exception_Decl,
      Ada_Exception_Handler => Type_Refs.Exception_Handler,
      Ada_For_Loop_Var_Decl => Type_Refs.For_Loop_Var_Decl,
      Ada_Generic_Package_Decl => Type_Refs.Generic_Package_Decl,
      Ada_Generic_Subp_Decl => Type_Refs.Generic_Subp_Decl,
      Ada_Generic_Package_Instantiation => Type_Refs.Generic_Package_Instantiation,
      Ada_Generic_Subp_Instantiation => Type_Refs.Generic_Subp_Instantiation,
      Ada_Generic_Package_Renaming_Decl => Type_Refs.Generic_Package_Renaming_Decl,
      Ada_Generic_Subp_Renaming_Decl => Type_Refs.Generic_Subp_Renaming_Decl,
      Ada_Label_Decl => Type_Refs.Label_Decl,
      Ada_Named_Stmt_Decl => Type_Refs.Named_Stmt_Decl,
      Ada_Number_Decl => Type_Refs.Number_Decl,
      Ada_Object_Decl => Type_Refs.Object_Decl,
      Ada_Extended_Return_Stmt_Object_Decl => Type_Refs.Extended_Return_Stmt_Object_Decl,
      Ada_No_Type_Object_Renaming_Decl => Type_Refs.No_Type_Object_Renaming_Decl,
      Ada_Package_Renaming_Decl => Type_Refs.Package_Renaming_Decl,
      Ada_Single_Protected_Decl => Type_Refs.Single_Protected_Decl,
      Ada_Single_Task_Decl => Type_Refs.Single_Task_Decl,
      Ada_Synthetic_Object_Decl => Type_Refs.Synthetic_Object_Decl,
      Ada_Case_Stmt_Alternative => Type_Refs.Case_Stmt_Alternative,
      Ada_Compilation_Unit => Type_Refs.Compilation_Unit,
      Ada_Component_Clause => Type_Refs.Component_Clause,
      Ada_Component_Def => Type_Refs.Component_Def,
      Ada_Constant_Absent => Type_Refs.Constant_Absent,
      Ada_Constant_Present => Type_Refs.Constant_Present,
      Ada_Composite_Constraint => Type_Refs.Composite_Constraint,
      Ada_Delta_Constraint => Type_Refs.Delta_Constraint,
      Ada_Digits_Constraint => Type_Refs.Digits_Constraint,
      Ada_Range_Constraint => Type_Refs.Range_Constraint,
      Ada_Declarative_Part => Type_Refs.Declarative_Part,
      Ada_Private_Part => Type_Refs.Private_Part,
      Ada_Public_Part => Type_Refs.Public_Part,
      Ada_Else_Part => Type_Refs.Else_Part,
      Ada_Elsif_Expr_Part => Type_Refs.Elsif_Expr_Part,
      Ada_Elsif_Stmt_Part => Type_Refs.Elsif_Stmt_Part,
      Ada_Abstract_State_Decl_Expr => Type_Refs.Abstract_State_Decl_Expr,
      Ada_Allocator => Type_Refs.Allocator,
      Ada_Aggregate => Type_Refs.Aggregate,
      Ada_Bracket_Aggregate => Type_Refs.Bracket_Aggregate,
      Ada_Delta_Aggregate => Type_Refs.Delta_Aggregate,
      Ada_Bracket_Delta_Aggregate => Type_Refs.Bracket_Delta_Aggregate,
      Ada_Null_Record_Aggregate => Type_Refs.Null_Record_Aggregate,
      Ada_Bin_Op => Type_Refs.Bin_Op,
      Ada_Relation_Op => Type_Refs.Relation_Op,
      Ada_Box_Expr => Type_Refs.Box_Expr,
      Ada_Case_Expr_Alternative => Type_Refs.Case_Expr_Alternative,
      Ada_Concat_Op => Type_Refs.Concat_Op,
      Ada_Concat_Operand => Type_Refs.Concat_Operand,
      Ada_Case_Expr => Type_Refs.Case_Expr,
      Ada_If_Expr => Type_Refs.If_Expr,
      Ada_Contract_Cases => Type_Refs.Contract_Cases,
      Ada_Decl_Expr => Type_Refs.Decl_Expr,
      Ada_Format_String_Literal => Type_Refs.Format_String_Literal,
      Ada_Membership_Expr => Type_Refs.Membership_Expr,
      Ada_Array_Subcomponent_Choice_Name => Type_Refs.Array_Subcomponent_Choice_Name,
      Ada_Attribute_Ref => Type_Refs.Attribute_Ref,
      Ada_Call_Expr => Type_Refs.Call_Expr,
      Ada_Defining_Name => Type_Refs.Defining_Name,
      Ada_Synthetic_Defining_Name => Type_Refs.Synthetic_Defining_Name,
      Ada_Discrete_Subtype_Name => Type_Refs.Discrete_Subtype_Name,
      Ada_Dotted_Name => Type_Refs.Dotted_Name,
      Ada_End_Name => Type_Refs.End_Name,
      Ada_Explicit_Deref => Type_Refs.Explicit_Deref,
      Ada_Qual_Expr => Type_Refs.Qual_Expr,
      Ada_Reduce_Attribute_Ref => Type_Refs.Reduce_Attribute_Ref,
      Ada_Char_Literal => Type_Refs.Char_Literal,
      Ada_Identifier => Type_Refs.Identifier,
      Ada_Op_Abs => Type_Refs.Op_Abs,
      Ada_Op_And => Type_Refs.Op_And,
      Ada_Op_And_Then => Type_Refs.Op_And_Then,
      Ada_Op_Concat => Type_Refs.Op_Concat,
      Ada_Op_Div => Type_Refs.Op_Div,
      Ada_Op_Double_Dot => Type_Refs.Op_Double_Dot,
      Ada_Op_Eq => Type_Refs.Op_Eq,
      Ada_Op_Gt => Type_Refs.Op_Gt,
      Ada_Op_Gte => Type_Refs.Op_Gte,
      Ada_Op_In => Type_Refs.Op_In,
      Ada_Op_Lt => Type_Refs.Op_Lt,
      Ada_Op_Lte => Type_Refs.Op_Lte,
      Ada_Op_Minus => Type_Refs.Op_Minus,
      Ada_Op_Mod => Type_Refs.Op_Mod,
      Ada_Op_Mult => Type_Refs.Op_Mult,
      Ada_Op_Neq => Type_Refs.Op_Neq,
      Ada_Op_Not => Type_Refs.Op_Not,
      Ada_Op_Not_In => Type_Refs.Op_Not_In,
      Ada_Op_Or => Type_Refs.Op_Or,
      Ada_Op_Or_Else => Type_Refs.Op_Or_Else,
      Ada_Op_Plus => Type_Refs.Op_Plus,
      Ada_Op_Pow => Type_Refs.Op_Pow,
      Ada_Op_Rem => Type_Refs.Op_Rem,
      Ada_Op_Xor => Type_Refs.Op_Xor,
      Ada_String_Literal => Type_Refs.String_Literal,
      Ada_Null_Literal => Type_Refs.Null_Literal,
      Ada_Int_Literal => Type_Refs.Int_Literal,
      Ada_Real_Literal => Type_Refs.Real_Literal,
      Ada_Synthetic_Identifier => Type_Refs.Synthetic_Identifier,
      Ada_Target_Name => Type_Refs.Target_Name,
      Ada_Update_Attribute_Ref => Type_Refs.Update_Attribute_Ref,
      Ada_Paren_Expr => Type_Refs.Paren_Expr,
      Ada_Quantified_Expr => Type_Refs.Quantified_Expr,
      Ada_Raise_Expr => Type_Refs.Raise_Expr,
      Ada_Un_Op => Type_Refs.Un_Op,
      Ada_For_Loop_Iter_Filter => Type_Refs.For_Loop_Iter_Filter,
      Ada_Format_String_Chunk => Type_Refs.Format_String_Chunk,
      Ada_Format_String_Tok_End => Type_Refs.Format_String_Tok_End,
      Ada_Format_String_Tok_Mid => Type_Refs.Format_String_Tok_Mid,
      Ada_Format_String_Tok_Start => Type_Refs.Format_String_Tok_Start,
      Ada_Format_String_Tok_String => Type_Refs.Format_String_Tok_String,
      Ada_Handled_Stmts => Type_Refs.Handled_Stmts,
      Ada_Interface_Kind_Limited => Type_Refs.Interface_Kind_Limited,
      Ada_Interface_Kind_Protected => Type_Refs.Interface_Kind_Protected,
      Ada_Interface_Kind_Synchronized => Type_Refs.Interface_Kind_Synchronized,
      Ada_Interface_Kind_Task => Type_Refs.Interface_Kind_Task,
      Ada_Iter_Type_In => Type_Refs.Iter_Type_In,
      Ada_Iter_Type_Of => Type_Refs.Iter_Type_Of,
      Ada_Library_Item => Type_Refs.Library_Item,
      Ada_Limited_Absent => Type_Refs.Limited_Absent,
      Ada_Limited_Present => Type_Refs.Limited_Present,
      Ada_For_Loop_Spec => Type_Refs.For_Loop_Spec,
      Ada_While_Loop_Spec => Type_Refs.While_Loop_Spec,
      Ada_Mode_Default => Type_Refs.Mode_Default,
      Ada_Mode_In => Type_Refs.Mode_In,
      Ada_Mode_In_Out => Type_Refs.Mode_In_Out,
      Ada_Mode_Out => Type_Refs.Mode_Out,
      Ada_Multi_Abstract_State_Decl => Type_Refs.Multi_Abstract_State_Decl,
      Ada_Not_Null_Absent => Type_Refs.Not_Null_Absent,
      Ada_Not_Null_Present => Type_Refs.Not_Null_Present,
      Ada_Null_Component_Decl => Type_Refs.Null_Component_Decl,
      Ada_Others_Designator => Type_Refs.Others_Designator,
      Ada_Overriding_Not_Overriding => Type_Refs.Overriding_Not_Overriding,
      Ada_Overriding_Overriding => Type_Refs.Overriding_Overriding,
      Ada_Overriding_Unspecified => Type_Refs.Overriding_Unspecified,
      Ada_Params => Type_Refs.Params,
      Ada_Paren_Abstract_State_Decl => Type_Refs.Paren_Abstract_State_Decl,
      Ada_Pp_Else_Directive => Type_Refs.Pp_Else_Directive,
      Ada_Pp_Elsif_Directive => Type_Refs.Pp_Elsif_Directive,
      Ada_Pp_End_If_Directive => Type_Refs.Pp_End_If_Directive,
      Ada_Pp_If_Directive => Type_Refs.Pp_If_Directive,
      Ada_Pp_Then_Kw => Type_Refs.Pp_Then_Kw,
      Ada_Pragma_Node => Type_Refs.Pragma_Node,
      Ada_Private_Absent => Type_Refs.Private_Absent,
      Ada_Private_Present => Type_Refs.Private_Present,
      Ada_Protected_Def => Type_Refs.Protected_Def,
      Ada_Protected_Absent => Type_Refs.Protected_Absent,
      Ada_Protected_Present => Type_Refs.Protected_Present,
      Ada_Quantifier_All => Type_Refs.Quantifier_All,
      Ada_Quantifier_Some => Type_Refs.Quantifier_Some,
      Ada_Range_Spec => Type_Refs.Range_Spec,
      Ada_Renaming_Clause => Type_Refs.Renaming_Clause,
      Ada_Synthetic_Renaming_Clause => Type_Refs.Synthetic_Renaming_Clause,
      Ada_Reverse_Absent => Type_Refs.Reverse_Absent,
      Ada_Reverse_Present => Type_Refs.Reverse_Present,
      Ada_Select_When_Part => Type_Refs.Select_When_Part,
      Ada_Accept_Stmt => Type_Refs.Accept_Stmt,
      Ada_Accept_Stmt_With_Stmts => Type_Refs.Accept_Stmt_With_Stmts,
      Ada_For_Loop_Stmt => Type_Refs.For_Loop_Stmt,
      Ada_Loop_Stmt => Type_Refs.Loop_Stmt,
      Ada_While_Loop_Stmt => Type_Refs.While_Loop_Stmt,
      Ada_Begin_Block => Type_Refs.Begin_Block,
      Ada_Decl_Block => Type_Refs.Decl_Block,
      Ada_Case_Stmt => Type_Refs.Case_Stmt,
      Ada_Extended_Return_Stmt => Type_Refs.Extended_Return_Stmt,
      Ada_If_Stmt => Type_Refs.If_Stmt,
      Ada_Named_Stmt => Type_Refs.Named_Stmt,
      Ada_Select_Stmt => Type_Refs.Select_Stmt,
      Ada_Error_Stmt => Type_Refs.Error_Stmt,
      Ada_Abort_Stmt => Type_Refs.Abort_Stmt,
      Ada_Assign_Stmt => Type_Refs.Assign_Stmt,
      Ada_Call_Stmt => Type_Refs.Call_Stmt,
      Ada_Delay_Stmt => Type_Refs.Delay_Stmt,
      Ada_Exit_Stmt => Type_Refs.Exit_Stmt,
      Ada_Goto_Stmt => Type_Refs.Goto_Stmt,
      Ada_Label => Type_Refs.Label,
      Ada_Null_Stmt => Type_Refs.Null_Stmt,
      Ada_Raise_Stmt => Type_Refs.Raise_Stmt,
      Ada_Requeue_Stmt => Type_Refs.Requeue_Stmt,
      Ada_Return_Stmt => Type_Refs.Return_Stmt,
      Ada_Simple_Decl_Stmt => Type_Refs.Simple_Decl_Stmt,
      Ada_Terminate_Alternative => Type_Refs.Terminate_Alternative,
      Ada_Subp_Kind_Function => Type_Refs.Subp_Kind_Function,
      Ada_Subp_Kind_Procedure => Type_Refs.Subp_Kind_Procedure,
      Ada_Subunit => Type_Refs.Subunit,
      Ada_Synchronized_Absent => Type_Refs.Synchronized_Absent,
      Ada_Synchronized_Present => Type_Refs.Synchronized_Present,
      Ada_Tagged_Absent => Type_Refs.Tagged_Absent,
      Ada_Tagged_Present => Type_Refs.Tagged_Present,
      Ada_Task_Def => Type_Refs.Task_Def,
      Ada_Then_Abort_Part => Type_Refs.Then_Abort_Part,
      Ada_Type_Attributes_Repository => Type_Refs.Type_Attributes_Repository,
      Ada_Access_To_Subp_Def => Type_Refs.Access_To_Subp_Def,
      Ada_Anonymous_Type_Access_Def => Type_Refs.Anonymous_Type_Access_Def,
      Ada_Type_Access_Def => Type_Refs.Type_Access_Def,
      Ada_Array_Type_Def => Type_Refs.Array_Type_Def,
      Ada_Derived_Type_Def => Type_Refs.Derived_Type_Def,
      Ada_Enum_Type_Def => Type_Refs.Enum_Type_Def,
      Ada_Formal_Discrete_Type_Def => Type_Refs.Formal_Discrete_Type_Def,
      Ada_Interface_Type_Def => Type_Refs.Interface_Type_Def,
      Ada_Mod_Int_Type_Def => Type_Refs.Mod_Int_Type_Def,
      Ada_Private_Type_Def => Type_Refs.Private_Type_Def,
      Ada_Decimal_Fixed_Point_Def => Type_Refs.Decimal_Fixed_Point_Def,
      Ada_Floating_Point_Def => Type_Refs.Floating_Point_Def,
      Ada_Ordinary_Fixed_Point_Def => Type_Refs.Ordinary_Fixed_Point_Def,
      Ada_Record_Type_Def => Type_Refs.Record_Type_Def,
      Ada_Signed_Int_Type_Def => Type_Refs.Signed_Int_Type_Def,
      Ada_Anonymous_Type => Type_Refs.Anonymous_Type,
      Ada_Enum_Lit_Synth_Type_Expr => Type_Refs.Enum_Lit_Synth_Type_Expr,
      Ada_Subtype_Indication => Type_Refs.Subtype_Indication,
      Ada_Constrained_Subtype_Indication => Type_Refs.Constrained_Subtype_Indication,
      Ada_Discrete_Subtype_Indication => Type_Refs.Discrete_Subtype_Indication,
      Ada_Synthetic_Type_Expr => Type_Refs.Synthetic_Type_Expr,
      Ada_Unconstrained_Array_Index => Type_Refs.Unconstrained_Array_Index,
      Ada_Until_Absent => Type_Refs.Until_Absent,
      Ada_Until_Present => Type_Refs.Until_Present,
      Ada_Use_Package_Clause => Type_Refs.Use_Package_Clause,
      Ada_Use_Type_Clause => Type_Refs.Use_Type_Clause,
      Ada_Value_Sequence => Type_Refs.Value_Sequence,
      Ada_Variant => Type_Refs.Variant,
      Ada_Variant_Part => Type_Refs.Variant_Part,
      Ada_With_Clause => Type_Refs.With_Clause,
      Ada_With_Private_Absent => Type_Refs.With_Private_Absent,
      Ada_With_Private_Present => Type_Refs.With_Private_Present);

   -----------------------
   -- Member references --
   -----------------------

   package Member_Refs is
         Aspect_Exists : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 1);
         Aspect_Node : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 2);
         Aspect_Value : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 3);
         Aspect_Inherited : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 4);
         Completion_Item_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 5);
         Completion_Item_Is_Dot_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 6);
         Completion_Item_Is_Visible : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 7);
         Completion_Item_Weight : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 8);
         Discrete_Range_Range_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 9);
         Discrete_Range_Low_Bound : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 10);
         Discrete_Range_High_Bound : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 11);
         Discriminant_Values_Discriminant : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 12);
         Discriminant_Values_Values : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 13);
         Doc_Annotation_Key : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 14);
         Doc_Annotation_Value : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 15);
         Logic_Context_Ref_Node : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 16);
         Logic_Context_Decl_Node : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 17);
         Param_Actual_Param : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 18);
         Param_Actual_Actual : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 19);
         Ref_Result_Ref : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 20);
         Ref_Result_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 21);
         Refd_Decl_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 22);
         Refd_Decl_Def_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 23);
         Refd_Decl_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 24);
         Shape_Components : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 25);
         Shape_Discriminants_Values : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 26);
         Solver_Diagnostic_Message_Template : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 27);
         Solver_Diagnostic_Args : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 28);
         Solver_Diagnostic_Location : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 29);
         Solver_Diagnostic_Contexts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 30);
         Solver_Diagnostic_Round : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 31);
         Substitution_From_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 32);
         Substitution_To_Value : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 33);
         Substitution_Value_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 34);
         Constrained_Array_Indices_F_List : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 35);
         Unconstrained_Array_Indices_F_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 36);
         Aspect_Assoc_F_Id : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 37);
         Aspect_Assoc_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 38);
         At_Clause_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 39);
         At_Clause_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 40);
         Attribute_Def_Clause_F_Attribute_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 41);
         Attribute_Def_Clause_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 42);
         Enum_Rep_Clause_F_Type_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 43);
         Enum_Rep_Clause_F_Aggregate : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 44);
         Record_Rep_Clause_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 45);
         Record_Rep_Clause_F_At_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 46);
         Record_Rep_Clause_F_Components : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 47);
         Aspect_Spec_F_Aspect_Assocs : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 48);
         Contract_Case_Assoc_F_Guard : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 49);
         Contract_Case_Assoc_F_Consequence : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 50);
         Pragma_Argument_Assoc_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 51);
         Pragma_Argument_Assoc_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 52);
         Entry_Spec_F_Entry_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 53);
         Entry_Spec_F_Family_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 54);
         Entry_Spec_F_Entry_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 55);
         Subp_Spec_F_Subp_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 56);
         Subp_Spec_F_Subp_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 57);
         Subp_Spec_F_Subp_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 58);
         Subp_Spec_F_Subp_Returns : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 59);
         Synthetic_Binary_Spec_F_Left_Param : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 60);
         Synthetic_Binary_Spec_F_Right_Param : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 61);
         Synthetic_Binary_Spec_F_Return_Type_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 62);
         Synthetic_Unary_Spec_F_Right_Param : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 63);
         Synthetic_Unary_Spec_F_Return_Type_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 64);
         Component_List_F_Components : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 65);
         Component_List_F_Variant_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 66);
         Known_Discriminant_Part_F_Discr_Specs : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 67);
         Entry_Completion_Formal_Params_F_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 68);
         Generic_Formal_Part_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 69);
         Base_Record_Def_F_Components : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 70);
         Aggregate_Assoc_F_Designators : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 71);
         Aggregate_Assoc_F_R_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 72);
         Composite_Constraint_Assoc_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 73);
         Composite_Constraint_Assoc_F_Constraint_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 74);
         Iterated_Assoc_F_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 75);
         Iterated_Assoc_F_Key_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 76);
         Iterated_Assoc_F_R_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 77);
         Param_Assoc_F_Designator : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 78);
         Param_Assoc_F_R_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 79);
         Basic_Decl_F_Aspects : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 80);
         Abstract_State_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 81);
         Anonymous_Expr_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 82);
         Anonymous_Expr_Decl_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 83);
         Component_Decl_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 84);
         Component_Decl_F_Component_Def : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 85);
         Component_Decl_F_Default_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 86);
         Discriminant_Spec_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 87);
         Discriminant_Spec_F_Type_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 88);
         Discriminant_Spec_F_Default_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 89);
         Generic_Formal_F_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 90);
         Param_Spec_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 91);
         Param_Spec_F_Has_Aliased : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 92);
         Param_Spec_F_Mode : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 93);
         Param_Spec_F_Type_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 94);
         Param_Spec_F_Default_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 95);
         Synthetic_Formal_Param_Decl_F_Param_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 96);
         Base_Package_Decl_F_Package_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 97);
         Base_Package_Decl_F_Public_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 98);
         Base_Package_Decl_F_Private_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 99);
         Base_Package_Decl_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 100);
         Base_Type_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 101);
         Subtype_Decl_F_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 102);
         Incomplete_Type_Decl_F_Discriminants : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 103);
         Incomplete_Formal_Type_Decl_F_Is_Tagged : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 104);
         Incomplete_Formal_Type_Decl_F_Default_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 105);
         Incomplete_Tagged_Type_Decl_F_Has_Abstract : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 106);
         Protected_Type_Decl_F_Discriminants : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 107);
         Protected_Type_Decl_F_Interfaces : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 108);
         Protected_Type_Decl_F_Definition : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 109);
         Task_Type_Decl_F_Discriminants : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 110);
         Task_Type_Decl_F_Definition : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 111);
         Type_Decl_F_Discriminants : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 112);
         Type_Decl_F_Type_Def : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 113);
         Formal_Type_Decl_F_Default_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 114);
         Classic_Subp_Decl_F_Overriding : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 115);
         Classic_Subp_Decl_F_Subp_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 116);
         Formal_Subp_Decl_F_Default_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 117);
         Entry_Decl_F_Overriding : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 118);
         Entry_Decl_F_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 119);
         Enum_Literal_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 120);
         Generic_Subp_Internal_F_Subp_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 121);
         Synthetic_Subp_Decl_F_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 122);
         Accept_Stmt_Body_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 123);
         Base_Subp_Body_F_Overriding : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 124);
         Base_Subp_Body_F_Subp_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 125);
         Expr_Function_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 126);
         Subp_Body_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 127);
         Subp_Body_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 128);
         Subp_Body_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 129);
         Subp_Renaming_Decl_F_Renames : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 130);
         Package_Body_Stub_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 131);
         Protected_Body_Stub_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 132);
         Subp_Body_Stub_F_Overriding : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 133);
         Subp_Body_Stub_F_Subp_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 134);
         Task_Body_Stub_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 135);
         Entry_Body_F_Entry_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 136);
         Entry_Body_F_Index_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 137);
         Entry_Body_F_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 138);
         Entry_Body_F_Barrier : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 139);
         Entry_Body_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 140);
         Entry_Body_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 141);
         Entry_Body_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 142);
         Package_Body_F_Package_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 143);
         Package_Body_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 144);
         Package_Body_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 145);
         Package_Body_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 146);
         Protected_Body_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 147);
         Protected_Body_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 148);
         Protected_Body_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 149);
         Task_Body_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 150);
         Task_Body_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 151);
         Task_Body_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 152);
         Task_Body_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 153);
         Entry_Index_Spec_F_Id : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 154);
         Entry_Index_Spec_F_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 155);
         Exception_Decl_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 156);
         Exception_Decl_F_Renames : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 157);
         Exception_Handler_F_Exception_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 158);
         Exception_Handler_F_Handled_Exceptions : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 159);
         Exception_Handler_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 160);
         For_Loop_Var_Decl_F_Id : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 161);
         For_Loop_Var_Decl_F_Id_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 162);
         Generic_Decl_F_Formal_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 163);
         Generic_Package_Decl_F_Package_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 164);
         Generic_Subp_Decl_F_Subp_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 165);
         Generic_Package_Instantiation_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 166);
         Generic_Package_Instantiation_F_Generic_Pkg_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 167);
         Generic_Package_Instantiation_F_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 168);
         Generic_Subp_Instantiation_F_Overriding : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 169);
         Generic_Subp_Instantiation_F_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 170);
         Generic_Subp_Instantiation_F_Subp_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 171);
         Generic_Subp_Instantiation_F_Generic_Subp_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 172);
         Generic_Subp_Instantiation_F_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 173);
         Generic_Package_Renaming_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 174);
         Generic_Package_Renaming_Decl_F_Renames : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 175);
         Generic_Subp_Renaming_Decl_F_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 176);
         Generic_Subp_Renaming_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 177);
         Generic_Subp_Renaming_Decl_F_Renames : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 178);
         Label_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 179);
         Named_Stmt_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 180);
         Number_Decl_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 181);
         Number_Decl_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 182);
         Object_Decl_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 183);
         Object_Decl_F_Has_Aliased : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 184);
         Object_Decl_F_Has_Constant : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 185);
         Object_Decl_F_Mode : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 186);
         Object_Decl_F_Type_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 187);
         Object_Decl_F_Default_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 188);
         Object_Decl_F_Renaming_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 189);
         Package_Renaming_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 190);
         Package_Renaming_Decl_F_Renames : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 191);
         Single_Protected_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 192);
         Single_Protected_Decl_F_Interfaces : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 193);
         Single_Protected_Decl_F_Definition : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 194);
         Single_Task_Decl_F_Task_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 195);
         Case_Stmt_Alternative_F_Choices : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 196);
         Case_Stmt_Alternative_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 197);
         Compilation_Unit_F_Prelude : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 198);
         Compilation_Unit_F_Body : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 199);
         Compilation_Unit_F_Pragmas : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 200);
         Component_Clause_F_Id : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 201);
         Component_Clause_F_Position : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 202);
         Component_Clause_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 203);
         Component_Def_F_Has_Aliased : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 204);
         Component_Def_F_Has_Constant : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 205);
         Component_Def_F_Type_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 206);
         Composite_Constraint_F_Constraints : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 207);
         Delta_Constraint_F_Delta : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 208);
         Delta_Constraint_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 209);
         Digits_Constraint_F_Digits : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 210);
         Digits_Constraint_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 211);
         Range_Constraint_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 212);
         Declarative_Part_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 213);
         Else_Part_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 214);
         Elsif_Expr_Part_F_Cond_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 215);
         Elsif_Expr_Part_F_Then_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 216);
         Elsif_Stmt_Part_F_Cond_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 217);
         Elsif_Stmt_Part_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 218);
         Abstract_State_Decl_Expr_F_State_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 219);
         Allocator_F_Subpool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 220);
         Allocator_F_Type_Or_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 221);
         Base_Aggregate_F_Ancestor_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 222);
         Base_Aggregate_F_Assocs : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 223);
         Bin_Op_F_Left : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 224);
         Bin_Op_F_Op : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 225);
         Bin_Op_F_Right : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 226);
         Case_Expr_Alternative_F_Choices : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 227);
         Case_Expr_Alternative_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 228);
         Concat_Op_F_First_Operand : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 229);
         Concat_Op_F_Other_Operands : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 230);
         Concat_Operand_F_Operator : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 231);
         Concat_Operand_F_Operand : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 232);
         Case_Expr_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 233);
         Case_Expr_F_Cases : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 234);
         If_Expr_F_Cond_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 235);
         If_Expr_F_Then_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 236);
         If_Expr_F_Alternatives : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 237);
         If_Expr_F_Else_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 238);
         Contract_Cases_F_Contract_Cases : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 239);
         Decl_Expr_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 240);
         Decl_Expr_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 241);
         Format_String_Literal_F_Opening_Chunk : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 242);
         Format_String_Literal_F_Mid_Exprs : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 243);
         Format_String_Literal_F_Trailing_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 244);
         Membership_Expr_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 245);
         Membership_Expr_F_Op : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 246);
         Membership_Expr_F_Membership_Exprs : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 247);
         Array_Subcomponent_Choice_Name_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 248);
         Array_Subcomponent_Choice_Name_F_Suffix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 249);
         Attribute_Ref_F_Prefix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 250);
         Attribute_Ref_F_Attribute : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 251);
         Attribute_Ref_F_Args : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 252);
         Call_Expr_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 253);
         Call_Expr_F_Suffix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 254);
         Defining_Name_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 255);
         Discrete_Subtype_Name_F_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 256);
         Dotted_Name_F_Prefix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 257);
         Dotted_Name_F_Suffix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 258);
         End_Name_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 259);
         Explicit_Deref_F_Prefix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 260);
         Qual_Expr_F_Prefix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 261);
         Qual_Expr_F_Suffix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 262);
         Reduce_Attribute_Ref_F_Prefix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 263);
         Reduce_Attribute_Ref_F_Attribute : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 264);
         Reduce_Attribute_Ref_F_Args : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 265);
         Update_Attribute_Ref_F_Prefix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 266);
         Update_Attribute_Ref_F_Attribute : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 267);
         Update_Attribute_Ref_F_Values : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 268);
         Paren_Expr_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 269);
         Quantified_Expr_F_Quantifier : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 270);
         Quantified_Expr_F_Loop_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 271);
         Quantified_Expr_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 272);
         Raise_Expr_F_Exception_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 273);
         Raise_Expr_F_Error_Message : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 274);
         Un_Op_F_Op : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 275);
         Un_Op_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 276);
         For_Loop_Iter_Filter_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 277);
         Format_String_Chunk_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 278);
         Format_String_Chunk_F_String_Tok : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 279);
         Handled_Stmts_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 280);
         Handled_Stmts_F_Exceptions : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 281);
         Library_Item_F_Has_Private : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 282);
         Library_Item_F_Item : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 283);
         For_Loop_Spec_F_Var_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 284);
         For_Loop_Spec_F_Loop_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 285);
         For_Loop_Spec_F_Has_Reverse : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 286);
         For_Loop_Spec_F_Iter_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 287);
         For_Loop_Spec_F_Iter_Filter : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 288);
         While_Loop_Spec_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 289);
         Multi_Abstract_State_Decl_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 290);
         Params_F_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 291);
         Paren_Abstract_State_Decl_F_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 292);
         Pp_Elsif_Directive_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 293);
         Pp_Elsif_Directive_F_Then_Kw : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 294);
         Pp_If_Directive_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 295);
         Pp_If_Directive_F_Then_Kw : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 296);
         Pragma_Node_F_Id : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 297);
         Pragma_Node_F_Args : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 298);
         Protected_Def_F_Public_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 299);
         Protected_Def_F_Private_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 300);
         Protected_Def_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 301);
         Range_Spec_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 302);
         Renaming_Clause_F_Renamed_Object : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 303);
         Select_When_Part_F_Cond_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 304);
         Select_When_Part_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 305);
         Accept_Stmt_F_Body_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 306);
         Accept_Stmt_F_Entry_Index_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 307);
         Accept_Stmt_F_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 308);
         Accept_Stmt_With_Stmts_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 309);
         Accept_Stmt_With_Stmts_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 310);
         Base_Loop_Stmt_F_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 311);
         Base_Loop_Stmt_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 312);
         Base_Loop_Stmt_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 313);
         Begin_Block_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 314);
         Begin_Block_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 315);
         Decl_Block_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 316);
         Decl_Block_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 317);
         Decl_Block_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 318);
         Case_Stmt_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 319);
         Case_Stmt_F_Pragmas : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 320);
         Case_Stmt_F_Alternatives : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 321);
         Extended_Return_Stmt_F_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 322);
         Extended_Return_Stmt_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 323);
         If_Stmt_F_Cond_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 324);
         If_Stmt_F_Then_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 325);
         If_Stmt_F_Alternatives : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 326);
         If_Stmt_F_Else_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 327);
         Named_Stmt_F_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 328);
         Named_Stmt_F_Stmt : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 329);
         Select_Stmt_F_Guards : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 330);
         Select_Stmt_F_Else_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 331);
         Select_Stmt_F_Then_Abort_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 332);
         Abort_Stmt_F_Names : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 333);
         Assign_Stmt_F_Dest : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 334);
         Assign_Stmt_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 335);
         Call_Stmt_F_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 336);
         Delay_Stmt_F_Has_Until : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 337);
         Delay_Stmt_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 338);
         Exit_Stmt_F_Loop_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 339);
         Exit_Stmt_F_Cond_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 340);
         Goto_Stmt_F_Label_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 341);
         Label_F_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 342);
         Raise_Stmt_F_Exception_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 343);
         Raise_Stmt_F_Error_Message : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 344);
         Requeue_Stmt_F_Call_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 345);
         Requeue_Stmt_F_Has_Abort : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 346);
         Return_Stmt_F_Return_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 347);
         Simple_Decl_Stmt_F_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 348);
         Subunit_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 349);
         Subunit_F_Body : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 350);
         Task_Def_F_Interfaces : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 351);
         Task_Def_F_Public_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 352);
         Task_Def_F_Private_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 353);
         Task_Def_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 354);
         Then_Abort_Part_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 355);
         Access_Def_F_Has_Not_Null : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 356);
         Access_To_Subp_Def_F_Has_Protected : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 357);
         Access_To_Subp_Def_F_Subp_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 358);
         Anonymous_Type_Access_Def_F_Type_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 359);
         Type_Access_Def_F_Has_All : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 360);
         Type_Access_Def_F_Has_Constant : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 361);
         Type_Access_Def_F_Subtype_Indication : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 362);
         Array_Type_Def_F_Indices : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 363);
         Array_Type_Def_F_Component_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 364);
         Derived_Type_Def_F_Has_Abstract : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 365);
         Derived_Type_Def_F_Has_Limited : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 366);
         Derived_Type_Def_F_Has_Synchronized : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 367);
         Derived_Type_Def_F_Subtype_Indication : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 368);
         Derived_Type_Def_F_Interfaces : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 369);
         Derived_Type_Def_F_Record_Extension : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 370);
         Derived_Type_Def_F_Has_With_Private : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 371);
         Enum_Type_Def_F_Enum_Literals : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 372);
         Interface_Type_Def_F_Interface_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 373);
         Interface_Type_Def_F_Interfaces : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 374);
         Mod_Int_Type_Def_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 375);
         Private_Type_Def_F_Has_Abstract : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 376);
         Private_Type_Def_F_Has_Tagged : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 377);
         Private_Type_Def_F_Has_Limited : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 378);
         Decimal_Fixed_Point_Def_F_Delta : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 379);
         Decimal_Fixed_Point_Def_F_Digits : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 380);
         Decimal_Fixed_Point_Def_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 381);
         Floating_Point_Def_F_Num_Digits : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 382);
         Floating_Point_Def_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 383);
         Ordinary_Fixed_Point_Def_F_Delta : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 384);
         Ordinary_Fixed_Point_Def_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 385);
         Record_Type_Def_F_Has_Abstract : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 386);
         Record_Type_Def_F_Has_Tagged : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 387);
         Record_Type_Def_F_Has_Limited : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 388);
         Record_Type_Def_F_Record_Def : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 389);
         Signed_Int_Type_Def_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 390);
         Anonymous_Type_F_Type_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 391);
         Subtype_Indication_F_Has_Not_Null : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 392);
         Subtype_Indication_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 393);
         Subtype_Indication_F_Constraint : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 394);
         Unconstrained_Array_Index_F_Subtype_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 395);
         Unconstrained_Array_Index_F_Lower_Bound : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 396);
         Use_Package_Clause_F_Packages : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 397);
         Use_Type_Clause_F_Has_All : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 398);
         Use_Type_Clause_F_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 399);
         Value_Sequence_F_Iter_Assoc : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 400);
         Variant_F_Choices : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 401);
         Variant_F_Components : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 402);
         Variant_Part_F_Discr_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 403);
         Variant_Part_F_Variant : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 404);
         With_Clause_F_Has_Limited : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 405);
         With_Clause_F_Has_Private : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 406);
         With_Clause_F_Packages : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 407);
         Parent : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 408);
         Parents : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 409);
         Children : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 410);
         Token_Start : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 411);
         Token_End : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 412);
         Child_Index : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 413);
         Previous_Sibling : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 414);
         Next_Sibling : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 415);
         Unit : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 416);
         Is_Ghost : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 417);
         Full_Sloc_Image : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 418);
         Completion_Item_Kind_To_Int : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 419);
         Ada_Node_P_Declarative_Scope : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 420);
         Ada_Node_P_Enclosing_Compilation_Unit : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 421);
         Ada_Node_P_Get_Uninstantiated_Node : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 422);
         Ada_Node_P_Complete : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 423);
         Ada_Node_P_Valid_Keywords : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 424);
         Ada_Node_P_Generic_Instantiations : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 425);
         Ada_Node_P_Semantic_Parent : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 426);
         Ada_Node_P_Parent_Basic_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 427);
         Ada_Node_P_Has_Spark_Mode_On : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 428);
         Ada_Node_P_Is_Subject_To_Proof : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 429);
         Ada_Node_P_Filter_Is_Imported_By : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 430);
         Ada_Node_P_Resolve_Names : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 431);
         Ada_Node_P_Nameres_Diagnostics : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 432);
         Ada_Node_P_Standard_Unit : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 433);
         Ada_Node_P_Is_Keyword : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 434);
         Ada_Node_P_Std_Entity : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 435);
         Ada_Node_P_Bool_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 436);
         Ada_Node_P_Int_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 437);
         Ada_Node_P_Universal_Int_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 438);
         Ada_Node_P_Universal_Real_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 439);
         Ada_Node_P_Std_Char_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 440);
         Ada_Node_P_Std_Wide_Char_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 441);
         Ada_Node_P_Std_Wide_Wide_Char_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 442);
         Ada_Node_P_Std_String_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 443);
         Ada_Node_P_Std_Wide_String_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 444);
         Ada_Node_P_Std_Wide_Wide_String_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 445);
         Ada_Node_P_Top_Level_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 446);
         Ada_Node_P_Choice_Match : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 447);
         Ada_Node_P_Gnat_Xref : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 448);
         Ada_Node_P_Spark_Mode_Aspect : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 449);
         Ada_Node_P_Xref_Entry_Point : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 450);
         Ada_Node_P_Matching_With_Use_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 451);
         Abort_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 452);
         Abstract_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 453);
         Assoc_List_P_Zip_With_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 454);
         Aliased_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 455);
         All_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 456);
         Aspect_Assoc_P_Is_Ghost_Code : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 457);
         Enum_Rep_Clause_P_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 458);
         Base_Assoc_P_Assoc_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 459);
         Base_Formal_Param_Holder_P_Abstract_Formal_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 460);
         Base_Formal_Param_Holder_P_Formal_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 461);
         Base_Formal_Param_Holder_P_Nb_Min_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 462);
         Base_Formal_Param_Holder_P_Nb_Max_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 463);
         Base_Formal_Param_Holder_P_Param_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 464);
         Base_Subp_Spec_P_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 465);
         Base_Subp_Spec_P_Returns : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 466);
         Base_Subp_Spec_P_Primitive_Subp_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 467);
         Base_Subp_Spec_P_Primitive_Subp_First_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 468);
         Base_Subp_Spec_P_Primitive_Subp_Tagged_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 469);
         Base_Subp_Spec_P_Return_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 470);
         Base_Subp_Spec_P_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 471);
         Basic_Assoc_P_Get_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 472);
         Basic_Decl_P_Is_Formal : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 473);
         Basic_Decl_P_Doc_Annotations : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 474);
         Basic_Decl_P_Doc : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 475);
         Basic_Decl_P_Canonical_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 476);
         Basic_Decl_P_All_Parts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 477);
         Basic_Decl_P_Get_Aspect_Assoc : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 478);
         Basic_Decl_P_Get_Aspect_Spec_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 479);
         Basic_Decl_P_Get_Aspect : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 480);
         Basic_Decl_P_Has_Aspect : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 481);
         Basic_Decl_P_Get_Pragma : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 482);
         Basic_Decl_P_Get_Representation_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 483);
         Basic_Decl_P_Get_At_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 484);
         Basic_Decl_P_Get_Annotations : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 485);
         Basic_Decl_P_Is_Ghost_Code : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 486);
         Basic_Decl_P_Is_Compilation_Unit_Root : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 487);
         Basic_Decl_P_Is_Visible : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 488);
         Basic_Decl_P_Base_Subp_Declarations : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 489);
         Basic_Decl_P_Root_Subp_Declarations : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 490);
         Basic_Decl_P_Find_All_Overrides : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 491);
         Basic_Decl_P_Defining_Names : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 492);
         Basic_Decl_P_Defining_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 493);
         Basic_Decl_P_Subp_Spec_Or_Null : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 494);
         Basic_Decl_P_Is_Subprogram : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 495);
         Basic_Decl_P_Is_Predefined_Operator : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 496);
         Basic_Decl_P_Relative_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 497);
         Basic_Decl_P_Relative_Name_Text : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 498);
         Basic_Decl_P_Body_Part_For_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 499);
         Basic_Decl_P_Most_Visible_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 500);
         Basic_Decl_P_Fully_Qualified_Name_Array : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 501);
         Basic_Decl_P_Fully_Qualified_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 502);
         Basic_Decl_P_Canonical_Fully_Qualified_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 503);
         Basic_Decl_P_Unique_Identifying_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 504);
         Basic_Decl_P_Previous_Part_For_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 505);
         Basic_Decl_P_Is_Static_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 506);
         Basic_Decl_P_Is_Imported : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 507);
         Basic_Decl_P_Type_Expression : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 508);
         Basic_Decl_P_Next_Part_For_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 509);
         Basic_Decl_P_Is_Constant_Object : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 510);
         Anonymous_Expr_Decl_P_Get_Formal : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 511);
         Base_Formal_Param_Decl_P_Formal_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 512);
         Base_Package_Decl_P_Body_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 513);
         Base_Type_Decl_P_Base_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 514);
         Base_Type_Decl_P_Attribute_Subprogram : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 515);
         Base_Type_Decl_P_Private_Completion : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 516);
         Base_Type_Decl_P_Is_Inherited_Primitive : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 517);
         Base_Type_Decl_P_Get_Record_Representation_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 518);
         Base_Type_Decl_P_Get_Enum_Representation_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 519);
         Base_Type_Decl_P_Get_Primitives : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 520);
         Base_Type_Decl_P_Is_Array_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 521);
         Base_Type_Decl_P_Find_Derived_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 522);
         Base_Type_Decl_P_Is_Scalar_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 523);
         Base_Type_Decl_P_Specific_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 524);
         Base_Type_Decl_P_Find_All_Derived_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 525);
         Base_Type_Decl_P_Comp_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 526);
         Base_Type_Decl_P_Index_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 527);
         Base_Type_Decl_P_Is_Derived_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 528);
         Base_Type_Decl_P_Is_Limited_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 529);
         Base_Type_Decl_P_Matching_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 530);
         Base_Type_Decl_P_Previous_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 531);
         Base_Type_Decl_P_Next_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 532);
         Base_Type_Decl_P_Full_View : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 533);
         Base_Type_Decl_P_Is_Definite_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 534);
         Base_Type_Decl_P_Is_Statically_Constrained : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 535);
         Base_Type_Decl_P_Discriminants_List : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 536);
         Base_Type_Decl_P_Shapes : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 537);
         Base_Type_Decl_P_Is_Record_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 538);
         Base_Type_Decl_P_Is_Real_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 539);
         Base_Type_Decl_P_Is_Float_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 540);
         Base_Type_Decl_P_Is_Fixed_Point : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 541);
         Base_Type_Decl_P_Is_Enum_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 542);
         Base_Type_Decl_P_Is_Access_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 543);
         Base_Type_Decl_P_Is_Char_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 544);
         Base_Type_Decl_P_Classwide_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 545);
         Base_Type_Decl_P_Discrete_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 546);
         Base_Type_Decl_P_Is_Discrete_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 547);
         Base_Type_Decl_P_Is_Int_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 548);
         Base_Type_Decl_P_Accessed_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 549);
         Base_Type_Decl_P_Is_Tagged_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 550);
         Base_Type_Decl_P_Is_Abstract_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 551);
         Base_Type_Decl_P_Base_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 552);
         Base_Type_Decl_P_Base_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 553);
         Base_Type_Decl_P_Is_Interface_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 554);
         Base_Type_Decl_P_Canonical_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 555);
         Base_Type_Decl_P_Is_Private : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 556);
         Base_Type_Decl_P_Root_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 557);
         Base_Subtype_Decl_P_Get_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 558);
         Basic_Subp_Decl_P_Subp_Decl_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 559);
         Classic_Subp_Decl_P_Body_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 560);
         Entry_Decl_P_Body_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 561);
         Entry_Decl_P_Accept_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 562);
         Enum_Literal_Decl_P_Enum_Rep : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 563);
         Enum_Literal_Decl_P_Enum_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 564);
         Synthetic_Char_Enum_Lit_P_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 565);
         Body_Node_P_Previous_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 566);
         Body_Node_P_Decl_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 567);
         Body_Node_P_Subunit_Root : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 568);
         Body_Stub_P_Syntactic_Fully_Qualified_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 569);
         Generic_Package_Decl_P_Body_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 570);
         Generic_Subp_Decl_P_Body_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 571);
         Generic_Instantiation_P_Designated_Generic_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 572);
         Generic_Instantiation_P_Inst_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 573);
         Object_Decl_P_Is_Statically_Constrained : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 574);
         Object_Decl_P_Private_Part_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 575);
         Object_Decl_P_Public_Part_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 576);
         Package_Renaming_Decl_P_Renamed_Package : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 577);
         Package_Renaming_Decl_P_Final_Renamed_Package : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 578);
         Compilation_Unit_P_Syntactic_Fully_Qualified_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 579);
         Compilation_Unit_P_Unit_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 580);
         Compilation_Unit_P_Withed_Units : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 581);
         Compilation_Unit_P_Imported_Units : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 582);
         Compilation_Unit_P_Unit_Dependencies : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 583);
         Compilation_Unit_P_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 584);
         Compilation_Unit_P_Is_Preelaborable : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 585);
         Compilation_Unit_P_Other_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 586);
         Compilation_Unit_P_Has_Restriction : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 587);
         Compilation_Unit_P_All_Config_Pragmas : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 588);
         Compilation_Unit_P_Config_Pragmas : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 589);
         Constant_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 590);
         Composite_Constraint_P_Is_Index_Constraint : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 591);
         Composite_Constraint_P_Is_Discriminant_Constraint : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 592);
         Composite_Constraint_P_Discriminant_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 593);
         Expr_P_Expression_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 594);
         Expr_P_Expected_Expression_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 595);
         Expr_P_Is_Dynamically_Tagged : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 596);
         Expr_P_Is_Static_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 597);
         Expr_P_Eval_As_Int : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 598);
         Expr_P_Eval_As_Int_In_Env : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 599);
         Expr_P_Eval_As_String : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 600);
         Expr_P_Eval_As_String_In_Env : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 601);
         Expr_P_Matching_Nodes : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 602);
         Expr_P_Is_Dispatching_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 603);
         Expr_P_First_Corresponding_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 604);
         Allocator_P_Get_Allocated_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 605);
         Base_Aggregate_P_Aggregate_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 606);
         Base_Aggregate_P_Is_Subaggregate : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 607);
         Base_Aggregate_P_Subaggregate_Array_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 608);
         Base_Aggregate_P_Subaggregate_Dimension : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 609);
         Concat_Op_P_Operands : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 610);
         Cond_Expr_P_Dependent_Exprs : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 611);
         Name_P_Enclosing_Defining_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 612);
         Name_P_Is_Defining : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 613);
         Name_P_Name_Is : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 614);
         Name_P_Is_Direct_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 615);
         Name_P_Is_Access_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 616);
         Name_P_Is_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 617);
         Name_P_Is_Dot_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 618);
         Name_P_All_Env_Elements : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 619);
         Name_P_Called_Subp_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 620);
         Name_P_Referenced_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 621);
         Name_P_Referenced_Defining_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 622);
         Name_P_Failsafe_Referenced_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 623);
         Name_P_Name_Designated_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 624);
         Name_P_Is_Static_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 625);
         Name_P_Name_Matches : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 626);
         Name_P_Is_Operator_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 627);
         Name_P_Is_Write_Reference : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 628);
         Name_P_Is_Static_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 629);
         Name_P_Call_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 630);
         Name_P_Relative_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 631);
         Name_P_As_Symbol_Array : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 632);
         Name_P_Canonical_Text : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 633);
         Name_P_Is_Constant : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 634);
         Call_Expr_P_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 635);
         Call_Expr_P_Is_Array_Slice : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 636);
         Defining_Name_P_Canonical_Fully_Qualified_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 637);
         Defining_Name_P_Unique_Identifying_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 638);
         Defining_Name_P_Fully_Qualified_Name_Array : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 639);
         Defining_Name_P_Fully_Qualified_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 640);
         Defining_Name_P_Basic_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 641);
         Defining_Name_P_Find_Refs : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 642);
         Defining_Name_P_Find_All_References : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 643);
         Defining_Name_P_Find_All_Calls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 644);
         Defining_Name_P_Next_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 645);
         Defining_Name_P_Previous_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 646);
         Defining_Name_P_Canonical_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 647);
         Defining_Name_P_Most_Visible_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 648);
         Defining_Name_P_All_Parts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 649);
         Defining_Name_P_Get_Aspect : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 650);
         Defining_Name_P_Has_Aspect : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 651);
         Defining_Name_P_Get_Pragma : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 652);
         Defining_Name_P_Get_Representation_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 653);
         Defining_Name_P_Get_At_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 654);
         Defining_Name_P_Get_Annotations : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 655);
         Defining_Name_P_Is_Imported : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 656);
         Defining_Name_P_Is_Ghost_Code : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 657);
         End_Name_P_Basic_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 658);
         Char_Literal_P_Denoted_Value : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 659);
         String_Literal_P_Denoted_Value : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 660);
         Int_Literal_P_Denoted_Value : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 661);
         Format_String_Chunk_P_Image_Subprogram : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 662);
         Format_String_Tok_Node_P_Denoted_Value : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 663);
         Limited_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 664);
         Not_Null_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 665);
         Pragma_Node_P_Is_Ghost_Code : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 666);
         Pragma_Node_P_Associated_Entities : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 667);
         Private_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 668);
         Protected_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 669);
         Reverse_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 670);
         Stmt_P_Is_Ghost_Code : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 671);
         Accept_Stmt_P_Corresponding_Entry : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 672);
         Subunit_P_Body_Root : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 673);
         Synchronized_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 674);
         Tagged_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 675);
         Type_Expr_P_Type_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 676);
         Type_Expr_P_Designated_Type_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 677);
         Type_Expr_P_Designated_Type_Decl_From : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 678);
         Type_Expr_P_Subtype_Constraint : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 679);
         Type_Expr_P_Discriminant_Constraints : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 680);
         Type_Expr_P_Is_Definite_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 681);
         Type_Expr_P_Is_Statically_Constrained : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 682);
         Subtype_Indication_P_Is_Static_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 683);
         Until_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 684);
         With_Private_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 685);
   end Member_Refs;

end Libadalang.Generic_API.Introspection;
