pragma Ada_2012;

pragma Style_Checks (Off);
pragma Warnings (Off, "-gnatwu");

with Interfaces.C; use Interfaces.C;
with corecrt_h;

package sys_timeb_h is

  --*
  -- * This file has no copyright assigned and is placed in the Public Domain.
  -- * This file is part of the mingw-w64 runtime package.
  -- * No warranty is given; refer to the file DISCLAIMER.PD within this package.
  --  

   type uu_timeb32 is record
      time : aliased corecrt_h.uu_time32_t;  -- D:/M/msys64/mingw64/include/sys/timeb.h:54
      millitm : aliased unsigned_short;  -- D:/M/msys64/mingw64/include/sys/timeb.h:55
      timezone : aliased short;  -- D:/M/msys64/mingw64/include/sys/timeb.h:56
      dstflag : aliased short;  -- D:/M/msys64/mingw64/include/sys/timeb.h:57
   end record
   with Convention => C_Pass_By_Copy;  -- D:/M/msys64/mingw64/include/sys/timeb.h:53

   type timeb is record
      time : aliased corecrt_h.time_t;  -- D:/M/msys64/mingw64/include/sys/timeb.h:62
      millitm : aliased unsigned_short;  -- D:/M/msys64/mingw64/include/sys/timeb.h:63
      timezone : aliased short;  -- D:/M/msys64/mingw64/include/sys/timeb.h:64
      dstflag : aliased short;  -- D:/M/msys64/mingw64/include/sys/timeb.h:65
   end record
   with Convention => C_Pass_By_Copy;  -- D:/M/msys64/mingw64/include/sys/timeb.h:61

   type uu_timeb64 is record
      time : aliased corecrt_h.uu_time64_t;  -- D:/M/msys64/mingw64/include/sys/timeb.h:70
      millitm : aliased unsigned_short;  -- D:/M/msys64/mingw64/include/sys/timeb.h:71
      timezone : aliased short;  -- D:/M/msys64/mingw64/include/sys/timeb.h:72
      dstflag : aliased short;  -- D:/M/msys64/mingw64/include/sys/timeb.h:73
   end record
   with Convention => C_Pass_By_Copy;  -- D:/M/msys64/mingw64/include/sys/timeb.h:69

   --  skipped func _ftime64

   --  skipped func _ftime32

  -- * To prevent ABI issues, the mingw-w64 runtime should not call the
  -- * _timeb and _ftime functions. Instead it should call the fixed-size variants.
  --  

   type u_timespec32 is record
      tv_sec : aliased corecrt_h.uu_time32_t;  -- D:/M/msys64/mingw64/include/sys/timeb.h:96
      tv_nsec : aliased long;  -- D:/M/msys64/mingw64/include/sys/timeb.h:97
   end record
   with Convention => C_Pass_By_Copy;  -- D:/M/msys64/mingw64/include/sys/timeb.h:95

   type u_timespec64 is record
      tv_sec : aliased corecrt_h.uu_time64_t;  -- D:/M/msys64/mingw64/include/sys/timeb.h:101
      tv_nsec : aliased long;  -- D:/M/msys64/mingw64/include/sys/timeb.h:102
   end record
   with Convention => C_Pass_By_Copy;  -- D:/M/msys64/mingw64/include/sys/timeb.h:100

  -- Seconds  
   type timespec is record
      tv_sec : aliased corecrt_h.time_t;  -- D:/M/msys64/mingw64/include/sys/timeb.h:108
      tv_nsec : aliased long;  -- D:/M/msys64/mingw64/include/sys/timeb.h:109
   end record
   with Convention => C_Pass_By_Copy;  -- D:/M/msys64/mingw64/include/sys/timeb.h:107

  -- Nanoseconds  
  -- Timer period  
   type itimerspec is record
      it_interval : aliased timespec;  -- D:/M/msys64/mingw64/include/sys/timeb.h:113
      it_value : aliased timespec;  -- D:/M/msys64/mingw64/include/sys/timeb.h:114
   end record
   with Convention => C_Pass_By_Copy;  -- D:/M/msys64/mingw64/include/sys/timeb.h:112

  -- Timer expiration  
  -- * To prevent ABI issues, the mingw-w64 runtime should not call the
  -- * ftime function. Instead it should call the fixed-size variants.
  --  

   function ftime (arg1 : access timeb) return int  -- D:/M/msys64/mingw64/include/sys/timeb.h:125
   with Import => True, 
        Convention => C, 
        External_Name => "ftime64";

end sys_timeb_h;

pragma Style_Checks (On);
pragma Warnings (On, "-gnatwu");
