#                                               -*- cmake -*-
#
#  OpenTURNSConfig.cmake(.in)
#
#  Find OpenTURNS includes and libraries
#
#  Copyright 2005-2025 Airbus-EDF-IMACS-ONERA-Phimeca
#
#  This library is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with this library.  If not, see <http://www.gnu.org/licenses/>.
#
#

# Use the following variables to compile and link against OpenTURNS:
#  OPENTURNS_FOUND              - True if OpenTURNS was found on your system
#  OPENTURNS_DEFINITIONS        - Definitions needed to build with OpenTURNS
#  OPENTURNS_INCLUDE_DIR        - Directory where OT.hxx can be found
#  OPENTURNS_INCLUDE_DIRS       - List of directories of OpenTURNS and it's dependencies
#  OPENTURNS_LIBRARY            - OpenTURNS library location
#  OPENTURNS_LIBRARIES          - List of libraries to link against
#  OPENTURNS_LIBRARY_DIRS       - List of directories containing OpenTURNS' libraries
#  OPENTURNS_ROOT_DIR           - The base directory of OpenTURNS
#  OPENTURNS_VERSION_STRING     - A human-readable string containing the version
#  OPENTURNS_VERSION_MAJOR      - The major version of OpenTURNS
#  OPENTURNS_VERSION_MINOR      - The minor version of OpenTURNS
#  OPENTURNS_VERSION_PATCH      - The patch version of OpenTURNS
#  OPENTURNS_SWIG_INCLUDE_DIRS  - Location of swig interface files
#  OPENTURNS_SWIG_DEFINITIONS   - Definitions to compile the swig generated source
#  OPENTURNS_PYTHON_MODULE_PATH - Path to the python module


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was OpenTURNSConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

####################################################################################

set ( OPENTURNS_FOUND 1 )

set ( OPENTURNS_DEFINITIONS  "-DH5_BUILT_AS_DYNAMIC_LIB" )
set_and_check ( OPENTURNS_INCLUDE_DIR        "${PACKAGE_PREFIX_DIR}/include" )
set ( OPENTURNS_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include" )
set ( OPENTURNS_LIBRARY      "OT" )
set ( OPENTURNS_LIBRARIES    "OT" )
set ( OPENTURNS_LIBRARY_DIRS "${PACKAGE_PREFIX_DIR}/lib" )
set_and_check ( OPENTURNS_ROOT_DIR   "${PACKAGE_PREFIX_DIR}" )

set ( OPENTURNS_VERSION_STRING "1.25" )
set ( OPENTURNS_VERSION_MAJOR  "1" )
set ( OPENTURNS_VERSION_MINOR  "25" )
set ( OPENTURNS_VERSION_PATCH  "" )

set (OPENTURNS_SWIG_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include/openturns/swig")
set (OPENTURNS_SWIG_DEFINITIONS   "-DSWIG_TYPE_TABLE=pyproba" )
set (OPENTURNS_PYTHON_MODULE_PATH "${PACKAGE_PREFIX_DIR}/lib/python3.12/site-packages")

# static libraries dependencies are transitive so imported targets must be defined
if (NOT ON)
  include(CMakeFindDependencyMacro)

  if ("1" STREQUAL "1")
    find_dependency(Ceres CONFIG)
  endif ()

  if ("1" STREQUAL "FALSE")
    find_dependency(CMinpack CONFIG)
  endif ()

  if ("1" STREQUAL "0")
    find_dependency(dlib CONFIG)
  endif ()

  if ("1" STREQUAL "")
    find_dependency (HMAT CONFIG)
  endif ()

  if ("1" STREQUAL "TRUE")
    find_dependency (LibXml2 CONFIG)
  endif ()

  if ("1" STREQUAL "1")
    find_dependency(NLopt CONFIG)
  endif ()

  if ("1" STREQUAL "0")
    find_dependency(Pagmo CONFIG)
  endif ()

  if ("1" STREQUAL "FALSE")
    find_dependency(primesieve CONFIG)
  endif ()

  if ("1" STREQUAL "1")
    find_dependency(Spectra CONFIG)

    # https://github.com/yixuan/spectra/pull/140
    find_dependency(Eigen3 CONFIG)
  endif ()

  if ("1" STREQUAL "1")
    find_dependency(TBB CONFIG)
  endif ()
endif ()

# Our library dependencies (contains definitions for IMPORTED targets)
include("${CMAKE_CURRENT_LIST_DIR}/OpenTURNS-Targets.cmake")

