//! This file is auto-generated by tools/update_cpu_features.zig.

const std = @import("../std.zig");
const CpuFeature = std.Target.Cpu.Feature;
const CpuModel = std.Target.Cpu.Model;

pub const Feature = enum {
    @"32bit",
    @"32s",
    @"64bit",
    d,
    div32,
    f,
    frecipe,
    la_global_with_abs,
    la_global_with_pcrel,
    la_local_with_abs,
    lam_bh,
    lamcas,
    lasx,
    lbt,
    ld_seq_sa,
    lsx,
    lvz,
    prefer_w_inst,
    relax,
    scq,
    ual,
};

pub const featureSet = CpuFeature.FeatureSetFns(Feature).featureSet;
pub const featureSetHas = CpuFeature.FeatureSetFns(Feature).featureSetHas;
pub const featureSetHasAny = CpuFeature.FeatureSetFns(Feature).featureSetHasAny;
pub const featureSetHasAll = CpuFeature.FeatureSetFns(Feature).featureSetHasAll;

pub const all_features = blk: {
    const len = @typeInfo(Feature).@"enum".fields.len;
    std.debug.assert(len <= CpuFeature.Set.needed_bit_count);
    var result: [len]CpuFeature = undefined;
    result[@intFromEnum(Feature.@"32bit")] = .{
        .llvm_name = "32bit",
        .description = "LA32 Basic Integer and Privilege Instruction Set",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.@"32s")] = .{
        .llvm_name = "32s",
        .description = "LA32 Standard Basic Instruction Extension",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.@"64bit")] = .{
        .llvm_name = "64bit",
        .description = "LA64 Basic Integer and Privilege Instruction Set",
        .dependencies = featureSet(&[_]Feature{
            .@"32s",
        }),
    };
    result[@intFromEnum(Feature.d)] = .{
        .llvm_name = "d",
        .description = "'D' (Double-Precision Floating-Point)",
        .dependencies = featureSet(&[_]Feature{
            .f,
        }),
    };
    result[@intFromEnum(Feature.div32)] = .{
        .llvm_name = "div32",
        .description = "Assume div.w[u] and mod.w[u] can handle inputs that are not sign-extended",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.f)] = .{
        .llvm_name = "f",
        .description = "'F' (Single-Precision Floating-Point)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.frecipe)] = .{
        .llvm_name = "frecipe",
        .description = "Support frecipe.{s/d} and frsqrte.{s/d} instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.la_global_with_abs)] = .{
        .llvm_name = "la-global-with-abs",
        .description = "Expand la.global as la.abs",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.la_global_with_pcrel)] = .{
        .llvm_name = "la-global-with-pcrel",
        .description = "Expand la.global as la.pcrel",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.la_local_with_abs)] = .{
        .llvm_name = "la-local-with-abs",
        .description = "Expand la.local as la.abs",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.lam_bh)] = .{
        .llvm_name = "lam-bh",
        .description = "Support amswap[_db].{b/h} and amadd[_db].{b/h} instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.lamcas)] = .{
        .llvm_name = "lamcas",
        .description = "Support amcas[_db].{b/h/w/d}",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.lasx)] = .{
        .llvm_name = "lasx",
        .description = "'LASX' (Loongson Advanced SIMD Extension)",
        .dependencies = featureSet(&[_]Feature{
            .lsx,
        }),
    };
    result[@intFromEnum(Feature.lbt)] = .{
        .llvm_name = "lbt",
        .description = "'LBT' (Loongson Binary Translation Extension)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ld_seq_sa)] = .{
        .llvm_name = "ld-seq-sa",
        .description = "Don't use a same-address load-load barrier (dbar 0x700)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.lsx)] = .{
        .llvm_name = "lsx",
        .description = "'LSX' (Loongson SIMD Extension)",
        .dependencies = featureSet(&[_]Feature{
            .d,
        }),
    };
    result[@intFromEnum(Feature.lvz)] = .{
        .llvm_name = "lvz",
        .description = "'LVZ' (Loongson Virtualization Extension)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.prefer_w_inst)] = .{
        .llvm_name = "prefer-w-inst",
        .description = "Prefer instructions with W suffix",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.relax)] = .{
        .llvm_name = "relax",
        .description = "Enable Linker relaxation",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.scq)] = .{
        .llvm_name = "scq",
        .description = "Support sc.q instruction",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ual)] = .{
        .llvm_name = "ual",
        .description = "Allow memory accesses to be unaligned",
        .dependencies = featureSet(&[_]Feature{}),
    };
    const ti = @typeInfo(Feature);
    for (&result, 0..) |*elem, i| {
        elem.index = i;
        elem.name = ti.@"enum".fields[i].name;
    }
    break :blk result;
};

pub const cpu = struct {
    pub const generic: CpuModel = .{
        .name = "generic",
        .llvm_name = "generic",
        .features = featureSet(&[_]Feature{}),
    };
    pub const generic_la32: CpuModel = .{
        .name = "generic_la32",
        .llvm_name = "generic-la32",
        .features = featureSet(&[_]Feature{
            .@"32bit",
        }),
    };
    pub const generic_la64: CpuModel = .{
        .name = "generic_la64",
        .llvm_name = "generic-la64",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .lsx,
            .ual,
        }),
    };
    pub const la464: CpuModel = .{
        .name = "la464",
        .llvm_name = "la464",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .lasx,
            .lbt,
            .lvz,
            .ual,
        }),
    };
    pub const la664: CpuModel = .{
        .name = "la664",
        .llvm_name = "la664",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .div32,
            .frecipe,
            .lam_bh,
            .lamcas,
            .lasx,
            .lbt,
            .ld_seq_sa,
            .lvz,
            .scq,
            .ual,
        }),
    };
    pub const loongarch64: CpuModel = .{
        .name = "loongarch64",
        .llvm_name = "loongarch64",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .d,
            .ual,
        }),
    };
};
