// Populate the sidebar
//
// This is a script, and not included directly in the page, to control the total size of the book.
// The TOC contains an entry for each page, so if each page includes a copy of the TOC,
// the total size of the page becomes O(n**2).
class MDBookSidebarScrollbox extends HTMLElement {
    constructor() {
        super();
    }
    connectedCallback() {
        this.innerHTML = '<ol class="chapter"><li class="chapter-item expanded "><a href="introduction.html"><strong aria-hidden="true">1.</strong> Introduction</a></li><li class="chapter-item expanded "><a href="cli.html"><strong aria-hidden="true">2.</strong> Using the Wasmtime CLI</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="cli-install.html"><strong aria-hidden="true">2.1.</strong> Installation</a></li><li class="chapter-item expanded "><a href="cli-options.html"><strong aria-hidden="true">2.2.</strong> CLI Options</a></li><li class="chapter-item expanded "><a href="cli-logging.html"><strong aria-hidden="true">2.3.</strong> CLI Logging</a></li><li class="chapter-item expanded "><a href="cli-cache.html"><strong aria-hidden="true">2.4.</strong> Cache Configuration</a></li></ol></li><li class="chapter-item expanded "><a href="lang.html"><strong aria-hidden="true">3.</strong> Using the Wasmtime API</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="lang-rust.html"><strong aria-hidden="true">3.1.</strong> Rust</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="examples-rust-hello-world.html"><strong aria-hidden="true">3.1.1.</strong> Hello, world!</a></li><li class="chapter-item expanded "><a href="examples-rust-gcd.html"><strong aria-hidden="true">3.1.2.</strong> Calculating the GCD</a></li><li class="chapter-item expanded "><a href="examples-rust-memory.html"><strong aria-hidden="true">3.1.3.</strong> Using Linear Memory</a></li><li class="chapter-item expanded "><a href="examples-rust-wasip2.html"><strong aria-hidden="true">3.1.4.</strong> WASIp2</a></li><li class="chapter-item expanded "><a href="examples-rust-linking.html"><strong aria-hidden="true">3.1.5.</strong> Linking Modules</a></li><li class="chapter-item expanded "><a href="examples-rust-debugging.html"><strong aria-hidden="true">3.1.6.</strong> Debugging</a></li><li class="chapter-item expanded "><a href="examples-rust-core-dumps.html"><strong aria-hidden="true">3.1.7.</strong> Core Dumps</a></li><li class="chapter-item expanded "><a href="examples-rust-multi-value.html"><strong aria-hidden="true">3.1.8.</strong> Using Multi-Value</a></li><li class="chapter-item expanded "><a href="examples-rust-anyref.html"><strong aria-hidden="true">3.1.9.</strong> anyref Reference Type</a></li><li class="chapter-item expanded "><a href="examples-rust-externref.html"><strong aria-hidden="true">3.1.10.</strong> externref Reference Type</a></li><li class="chapter-item expanded "><a href="examples-rust-multimemory.html"><strong aria-hidden="true">3.1.11.</strong> Multiple Memories</a></li><li class="chapter-item expanded "><a href="examples-rust-serialize.html"><strong aria-hidden="true">3.1.12.</strong> Serializing Modules</a></li><li class="chapter-item expanded "><a href="examples-rust-multithreaded-embedding.html"><strong aria-hidden="true">3.1.13.</strong> Multithreaded Embedding</a></li><li class="chapter-item expanded "><a href="examples-rust-mpk.html"><strong aria-hidden="true">3.1.14.</strong> Memory Protection Keys</a></li></ol></li><li class="chapter-item expanded "><a href="lang-c.html"><strong aria-hidden="true">3.2.</strong> C</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="examples-c-hello-world.html"><strong aria-hidden="true">3.2.1.</strong> Hello, World!</a></li><li class="chapter-item expanded "><a href="examples-c-gcd.html"><strong aria-hidden="true">3.2.2.</strong> Calculating the GCD</a></li><li class="chapter-item expanded "><a href="examples-c-memory.html"><strong aria-hidden="true">3.2.3.</strong> Using Linear Memory</a></li><li class="chapter-item expanded "><a href="examples-c-wasi.html"><strong aria-hidden="true">3.2.4.</strong> WASIp1</a></li><li class="chapter-item expanded "><a href="examples-c-linking.html"><strong aria-hidden="true">3.2.5.</strong> Linking Modules</a></li><li class="chapter-item expanded "><a href="examples-c-debugging.html"><strong aria-hidden="true">3.2.6.</strong> Debugging</a></li><li class="chapter-item expanded "><a href="examples-c-multi-value.html"><strong aria-hidden="true">3.2.7.</strong> Using Multi-Value</a></li><li class="chapter-item expanded "><a href="examples-c-anyref.html"><strong aria-hidden="true">3.2.8.</strong> anyref Reference Type</a></li><li class="chapter-item expanded "><a href="examples-c-externref.html"><strong aria-hidden="true">3.2.9.</strong> externref Reference Type</a></li><li class="chapter-item expanded "><a href="examples-c-multimemory.html"><strong aria-hidden="true">3.2.10.</strong> Multiple Memories</a></li><li class="chapter-item expanded "><a href="examples-c-serialize.html"><strong aria-hidden="true">3.2.11.</strong> Serializing Modules</a></li><li class="chapter-item expanded "><a href="examples-c-multithreaded-embedding.html"><strong aria-hidden="true">3.2.12.</strong> Multithreaded Embedding</a></li></ol></li><li class="chapter-item expanded "><a href="lang-cpp.html"><strong aria-hidden="true">3.3.</strong> C++</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="examples-cpp-hello-world.html"><strong aria-hidden="true">3.3.1.</strong> Hello, World!</a></li><li class="chapter-item expanded "><a href="examples-cpp-gcd.html"><strong aria-hidden="true">3.3.2.</strong> Calculating the GCD</a></li><li class="chapter-item expanded "><a href="examples-cpp-memory.html"><strong aria-hidden="true">3.3.3.</strong> Using Linear Memory</a></li><li class="chapter-item expanded "><a href="examples-cpp-wasi.html"><strong aria-hidden="true">3.3.4.</strong> WASIp1</a></li><li class="chapter-item expanded "><a href="examples-cpp-linking.html"><strong aria-hidden="true">3.3.5.</strong> Linking Modules</a></li><li class="chapter-item expanded "><a href="examples-cpp-multi-value.html"><strong aria-hidden="true">3.3.6.</strong> Using Multi-Value</a></li><li class="chapter-item expanded "><a href="examples-cpp-anyref.html"><strong aria-hidden="true">3.3.7.</strong> anyref Reference Type</a></li><li class="chapter-item expanded "><a href="examples-cpp-externref.html"><strong aria-hidden="true">3.3.8.</strong> externref Reference Type</a></li><li class="chapter-item expanded "><a href="examples-cpp-multimemory.html"><strong aria-hidden="true">3.3.9.</strong> Multiple Memories</a></li><li class="chapter-item expanded "><a href="examples-cpp-serialize.html"><strong aria-hidden="true">3.3.10.</strong> Serializing Modules</a></li><li class="chapter-item expanded "><a href="examples-cpp-multithreaded-embedding.html"><strong aria-hidden="true">3.3.11.</strong> Multithreaded Embedding</a></li><li class="chapter-item expanded "><a href="examples-cpp-async.html"><strong aria-hidden="true">3.3.12.</strong> Async Host Functions</a></li></ol></li><li class="chapter-item expanded "><a href="lang-python.html"><strong aria-hidden="true">3.4.</strong> Python</a></li><li class="chapter-item expanded "><a href="lang-dotnet.html"><strong aria-hidden="true">3.5.</strong> .NET</a></li><li class="chapter-item expanded "><a href="lang-go.html"><strong aria-hidden="true">3.6.</strong> Go</a></li><li class="chapter-item expanded "><a href="lang-bash.html"><strong aria-hidden="true">3.7.</strong> Bash</a></li><li class="chapter-item expanded "><a href="lang-ruby.html"><strong aria-hidden="true">3.8.</strong> Ruby</a></li><li class="chapter-item expanded "><a href="lang-elixir.html"><strong aria-hidden="true">3.9.</strong> Elixir</a></li></ol></li><li class="chapter-item expanded "><a href="examples.html"><strong aria-hidden="true">4.</strong> Further Examples</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="examples-debugging.html"><strong aria-hidden="true">4.1.</strong> Debugging WebAssembly</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="examples-debugging-native-debugger.html"><strong aria-hidden="true">4.1.1.</strong> Debugging with gdb and lldb</a></li><li class="chapter-item expanded "><a href="examples-debugging-core-dumps.html"><strong aria-hidden="true">4.1.2.</strong> Debugging with Core Dumps</a></li></ol></li><li class="chapter-item expanded "><a href="examples-profiling.html"><strong aria-hidden="true">4.2.</strong> Profiling WebAssembly</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="examples-profiling-perf.html"><strong aria-hidden="true">4.2.1.</strong> Profiling with Perf</a></li><li class="chapter-item expanded "><a href="examples-profiling-vtune.html"><strong aria-hidden="true">4.2.2.</strong> Profiling with VTune</a></li><li class="chapter-item expanded "><a href="examples-profiling-samply.html"><strong aria-hidden="true">4.2.3.</strong> Profiling with samply</a></li><li class="chapter-item expanded "><a href="examples-profiling-guest.html"><strong aria-hidden="true">4.2.4.</strong> Cross-platform Profiling</a></li></ol></li><li class="chapter-item expanded "><a href="examples-minimal.html"><strong aria-hidden="true">4.3.</strong> Building a Minimal Embedding</a></li><li class="chapter-item expanded "><a href="examples-pulley.html"><strong aria-hidden="true">4.4.</strong> Portable Interpretation</a></li><li class="chapter-item expanded "><a href="examples-pre-compiling-wasm.html"><strong aria-hidden="true">4.5.</strong> Pre-Compiling Wasm</a></li><li class="chapter-item expanded "><a href="examples-fast-execution.html"><strong aria-hidden="true">4.6.</strong> Fast Execution</a></li><li class="chapter-item expanded "><a href="examples-fast-instantiation.html"><strong aria-hidden="true">4.7.</strong> Fast Instantiation</a></li><li class="chapter-item expanded "><a href="examples-fast-compilation.html"><strong aria-hidden="true">4.8.</strong> Fast Compilation</a></li><li class="chapter-item expanded "><a href="examples-interrupting-wasm.html"><strong aria-hidden="true">4.9.</strong> Interrupting Execution</a></li><li class="chapter-item expanded "><a href="examples-deterministic-wasm-execution.html"><strong aria-hidden="true">4.10.</strong> Deterministic Execution</a></li><li class="chapter-item expanded "><a href="wmemcheck.html"><strong aria-hidden="true">4.11.</strong> Checking Guests&#39; Memory Accesses</a></li></ol></li><li class="chapter-item expanded "><a href="stability.html"><strong aria-hidden="true">5.</strong> Stability</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="stability-release.html"><strong aria-hidden="true">5.1.</strong> Release Process</a></li><li class="chapter-item expanded "><a href="stability-tiers.html"><strong aria-hidden="true">5.2.</strong> Tiers of support</a></li><li class="chapter-item expanded "><a href="stability-platform-support.html"><strong aria-hidden="true">5.3.</strong> Platform Support</a></li><li class="chapter-item expanded "><a href="stability-wasm-proposals.html"><strong aria-hidden="true">5.4.</strong> Wasm Proposals</a></li></ol></li><li class="chapter-item expanded "><a href="security.html"><strong aria-hidden="true">6.</strong> Security</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="security-disclosure.html"><strong aria-hidden="true">6.1.</strong> Disclosure Policy</a></li><li class="chapter-item expanded "><a href="security-what-is-considered-a-security-vulnerability.html"><strong aria-hidden="true">6.2.</strong> What is considered a security bug?</a></li><li class="chapter-item expanded "><a href="security-vulnerability-runbook.html"><strong aria-hidden="true">6.3.</strong> Vulnerability runbook</a></li></ol></li><li class="chapter-item expanded "><a href="contributing.html"><strong aria-hidden="true">7.</strong> Contributing</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="contributing-architecture.html"><strong aria-hidden="true">7.1.</strong> Architecture</a></li><li class="chapter-item expanded "><a href="contributing-building.html"><strong aria-hidden="true">7.2.</strong> Building</a></li><li class="chapter-item expanded "><a href="contributing-testing.html"><strong aria-hidden="true">7.3.</strong> Testing</a></li><li class="chapter-item expanded "><a href="contributing-fuzzing.html"><strong aria-hidden="true">7.4.</strong> Fuzzing</a></li><li class="chapter-item expanded "><a href="contributing-ci.html"><strong aria-hidden="true">7.5.</strong> CI</a></li><li class="chapter-item expanded "><a href="contributing-reducing-test-cases.html"><strong aria-hidden="true">7.6.</strong> Reducing Test Cases</a></li><li class="chapter-item expanded "><a href="contributing-cross-compiling.html"><strong aria-hidden="true">7.7.</strong> Cross Compiling</a></li><li class="chapter-item expanded "><a href="contributing-coding-guidelines.html"><strong aria-hidden="true">7.8.</strong> Coding Guidelines</a></li><li class="chapter-item expanded "><a href="contributing-development-process.html"><strong aria-hidden="true">7.9.</strong> Development Process</a></li><li class="chapter-item expanded "><a href="contributing-rfc-process.html"><strong aria-hidden="true">7.10.</strong> RFC Process</a></li><li class="chapter-item expanded "><a href="contributing-implementing-wasm-proposals.html"><strong aria-hidden="true">7.11.</strong> Implementing Wasm Proposals</a></li><li class="chapter-item expanded "><a href="contributing-maintainer-guidelines.html"><strong aria-hidden="true">7.12.</strong> Maintainer Guidelines</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="contributing-code-review.html"><strong aria-hidden="true">7.12.1.</strong> Code Review</a></li><li class="chapter-item expanded "><a href="contributing-release-process.html"><strong aria-hidden="true">7.12.2.</strong> Release Process</a></li></ol></li><li class="chapter-item expanded "><a href="contributing-conditional-compilation.html"><strong aria-hidden="true">7.13.</strong> Conditional Compilation</a></li><li class="chapter-item expanded "><a href="contributing-governance.html"><strong aria-hidden="true">7.14.</strong> Governance</a></li><li class="chapter-item expanded "><a href="contributing-coc.html"><strong aria-hidden="true">7.15.</strong> Code of Conduct</a></li></ol></li></ol>';
        // Set the current, active page, and reveal it if it's hidden
        let current_page = document.location.href.toString().split("#")[0].split("?")[0];
        if (current_page.endsWith("/")) {
            current_page += "index.html";
        }
        var links = Array.prototype.slice.call(this.querySelectorAll("a"));
        var l = links.length;
        for (var i = 0; i < l; ++i) {
            var link = links[i];
            var href = link.getAttribute("href");
            if (href && !href.startsWith("#") && !/^(?:[a-z+]+:)?\/\//.test(href)) {
                link.href = path_to_root + href;
            }
            // The "index" page is supposed to alias the first chapter in the book.
            if (link.href === current_page || (i === 0 && path_to_root === "" && current_page.endsWith("/index.html"))) {
                link.classList.add("active");
                var parent = link.parentElement;
                if (parent && parent.classList.contains("chapter-item")) {
                    parent.classList.add("expanded");
                }
                while (parent) {
                    if (parent.tagName === "LI" && parent.previousElementSibling) {
                        if (parent.previousElementSibling.classList.contains("chapter-item")) {
                            parent.previousElementSibling.classList.add("expanded");
                        }
                    }
                    parent = parent.parentElement;
                }
            }
        }
        // Track and set sidebar scroll position
        this.addEventListener('click', function(e) {
            if (e.target.tagName === 'A') {
                sessionStorage.setItem('sidebar-scroll', this.scrollTop);
            }
        }, { passive: true });
        var sidebarScrollTop = sessionStorage.getItem('sidebar-scroll');
        sessionStorage.removeItem('sidebar-scroll');
        if (sidebarScrollTop) {
            // preserve sidebar scroll position when navigating via links within sidebar
            this.scrollTop = sidebarScrollTop;
        } else {
            // scroll sidebar to current active section when navigating via "next/previous chapter" buttons
            var activeSection = document.querySelector('#sidebar .active');
            if (activeSection) {
                activeSection.scrollIntoView({ block: 'center' });
            }
        }
        // Toggle buttons
        var sidebarAnchorToggles = document.querySelectorAll('#sidebar a.toggle');
        function toggleSection(ev) {
            ev.currentTarget.parentElement.classList.toggle('expanded');
        }
        Array.from(sidebarAnchorToggles).forEach(function (el) {
            el.addEventListener('click', toggleSection);
        });
    }
}
window.customElements.define("mdbook-sidebar-scrollbox", MDBookSidebarScrollbox);
