/* ============================================================================
 * Freetype GL - A C OpenGL Freetype engine
 * Platform:    Any
 * WWW:         http://code.google.com/p/freetype-gl/
 * ----------------------------------------------------------------------------
 * Copyright 2011,2012 Nicolas P. Rougier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY NICOLAS P. ROUGIER ''AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL NICOLAS P. ROUGIER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of Nicolas P. Rougier.
 * ===============================================================================
 */
#include <stddef.h>
#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  wchar_t charcode;
  float kerning;
} kerning_t;

typedef struct {
  wchar_t charcode;
  int width, height;
  int offset_x, offset_y;
  float advance_x, advance_y;
  float s0, t0, s1, t1;
  size_t kerning_count;
  kerning_t kerning[1];
} texture_glyph_t;

typedef struct {
  size_t tex_width;
  size_t tex_height;
  size_t tex_depth;
  unsigned char tex_data[65536];
  float size;
  float height;
  float linegap;
  float ascender;
  float descender;
  size_t glyphs_count;
  texture_glyph_t glyphs[96];
} texture_font_t;

texture_font_t font_data = {
    256, 256, 1,
    {0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   0,   168, 255, 255, 180, 0,   0,   102, 255, 255,
     255, 255, 41,  0,   0,   38,  255, 255, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  255, 255, 201, 0,   0,   0,   0,   0,   115, 255, 255, 92,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   84,  255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  150, 221, 248, 238, 185, 75,  0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 255, 101, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   9,   99,  178, 226, 246, 248, 229, 179, 95,  6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   70,  255, 255, 255, 255, 69,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   52,  233, 255, 255, 163, 4,   0,   4,   164, 255, 255, 232, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   249, 255, 255, 234, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 255, 62,  0,   108, 248, 248,
     248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 108, 0,   12,  156, 234, 234, 156, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   213, 255, 255, 161, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   0,   168, 255, 255, 180, 0,   0,   81,  255, 255, 255, 255, 20,  0,   0,   18,  255, 255, 255, 255, 81,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   68,  255, 255, 155, 0,   0,   0,   0,   0,   162, 255, 255, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   63,  241, 255, 255, 255, 255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   46,  254, 255, 225, 5,   0,   0,   0,   0,   0,   0,   0,   0,   50,  220, 255, 255, 255, 255, 255, 255, 255, 255,
     208, 33,  0,   0,   0,   0,   0,   0,   0,   0,   50,  255, 255, 255, 255, 49,  0,   0,   0,   0,   0,   0,   0,   0,   70,  243, 255, 255, 143, 1,   0,   0,   0,   1,   145, 255, 255, 242, 68,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   223, 255, 255, 206, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255,
     255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 253, 20,  0,   112, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 112, 0,   136, 255, 255, 255, 255,
     138, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   67,  255, 255, 255, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   0,   168, 255, 255, 180,
     0,   0,   60,  255, 255, 255, 253, 2,   0,   0,   1,   251, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   113, 255, 255, 109, 0,   0,   0,   0,   0,   209, 255, 249, 5,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   20,  234, 255, 255, 255, 254, 255, 255, 255, 255, 97,  0,   0,   0,   0,   0,   170,
     255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   0,   31,  236, 255, 255, 255, 255, 254, 255, 255, 255, 255, 255, 218, 10,  0,   0,   0,   0,   0,   0,   0,   29,  255, 255, 255, 255, 28,  0,
     0,   0,   0,   0,   0,   0,   61,  247, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   153, 255, 255, 246, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196,
     255, 255, 178, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 255, 201,
     0,   0,   112, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 112, 0,   213, 255, 255, 255, 255, 216, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 255, 201,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   0,   168, 255, 255, 180, 0,   0,   39,  255, 255, 255, 234, 0,   0,   0,   0,   233, 255, 255, 255, 40,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   159, 255, 255, 63,  0,   0,   0,   0,   5,   249, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   51,  145, 255, 255, 153, 88,  64,  23,
     0,   0,   0,   0,   0,   124, 255, 255, 239, 79,  9,   35,  185, 255, 255, 226, 3,   0,   0,   0,   42,  253, 255, 228, 7,   0,   0,   0,   0,   0,   0,   0,   0,   161, 255, 255, 255, 184, 54,
     9,   14,  74,  215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   9,   255, 255, 255, 255, 8,   0,   0,   0,   0,   0,   0,   45,  240, 255, 255, 174, 2,   0,   0,   0,   0,   0,   0,
     0,   3,   175, 255, 255, 239, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 150, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   214, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     236, 255, 255, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  252, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   168, 255, 255, 180, 0,   0,   18,  255, 255, 255, 214, 0,   0,   0,   0,   212, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 17,  0,   0,   0,   0,   46,
     255, 255, 161, 0,   0,   0,   0,   0,   0,   0,   0,   15,  133, 232, 255, 255, 255, 255, 255, 255, 255, 255, 216, 136, 33,  0,   0,   198, 255, 255, 111, 0,   0,   0,   16,  246, 255, 255, 52,
     0,   0,   0,   166, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   4,   242, 255, 255, 202, 4,   0,   0,   0,   0,   26,  236, 255, 255, 199, 0,   0,   0,   0,   0,   0,   0,   0,   244,
     255, 255, 244, 0,   0,   0,   0,   0,   0,   12,  218, 255, 255, 217, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  218, 255, 255, 217, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   141, 255, 255, 122, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   9,
     252, 255, 255, 255, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   213, 255, 255, 255, 255, 216, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     135, 255, 255, 234, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 180, 0,   0,   1,   252, 255, 255, 193, 0,   0,   0,   0,   192,
     255, 255, 253, 2,   0,   0,   0,   0,   0,   0,   0,   0,   2,   246, 255, 228, 0,   0,   0,   0,   0,   93,  255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   45,  224, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 179, 0,   0,   238, 255, 255, 30,  0,   0,   0,   0,   182, 255, 255, 96,  0,   0,   38,  253, 255, 231, 8,   0,   0,   0,   0,   0,   0,   0,   0,   28,  255,
     255, 255, 114, 0,   0,   0,   0,   0,   0,   165, 255, 255, 235, 0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 223, 0,   0,   0,   0,   0,   0,   160, 255, 255, 249, 49,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   50,  249, 255, 255, 160, 0,   0,   0,   0,   0,   0,   74,  20,  0,   0,   0,   0,   0,   113, 255, 255, 94,  0,   0,   0,   0,   0,   18,  77,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 200, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   136, 255, 255, 255, 255, 138, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   235, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   168, 255, 255, 180, 0,   0,   0,   233, 255, 255, 172, 0,   0,   0,   0,   172, 255, 255, 235, 0,   0,   0,   0,   0,   0,   0,   0,   0,   39,  255, 255, 182, 0,
     0,   0,   0,   0,   139, 255, 255, 68,  0,   0,   0,   0,   0,   0,   23,  230, 255, 255, 255, 238, 203, 255, 255, 181, 172, 225, 255, 255, 255, 67,  0,   0,   251, 255, 254, 5,   0,   0,   0,
     0,   155, 255, 255, 111, 0,   0,   161, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   156, 255, 255, 236, 0,   0,   0,   0,
     0,   0,   0,   0,   204, 255, 255, 203, 0,   0,   0,   0,   0,   64,  255, 255, 255, 134, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 255, 255, 255, 63,  0,   0,   0,
     0,   2,   247, 253, 200, 127, 53,  1,   0,   86,  255, 255, 66,  0,   2,   55,  128, 200, 253, 252, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   109, 255, 255, 255, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  156, 234, 234, 157, 12,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   95,  255, 255, 252, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 180, 0,   0,   0,   212, 255, 255, 151,
     0,   0,   0,   0,   151, 255, 255, 214, 0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 136, 0,   0,   0,   0,   0,   186, 255, 255, 21,  0,   0,   0,   0,   0,   0,   148, 255, 255,
     255, 135, 5,   84,  255, 255, 88,  0,   0,   40,  127, 182, 0,   0,   0,   239, 255, 254, 6,   0,   0,   0,   0,   158, 255, 255, 99,  0,   34,  251, 255, 234, 10,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   1,   245, 255, 255, 148, 0,   0,   0,   0,   0,   4,   218, 255, 255, 186, 0,   0,   0,   0,   0,   0,   0,   0,   183, 255, 255, 182, 0,   0,   0,   0,   2,   207, 255, 255, 230,
     12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  232, 255, 255, 207, 2,   0,   0,   0,   32,  255, 255, 255, 255, 255, 234, 162, 137, 255, 255, 126, 167, 236, 255, 255,
     255, 255, 255, 37,  0,   7,   248, 248, 248, 248, 248, 248, 248, 251, 255, 255, 251, 248, 248, 248, 248, 248, 248, 248, 0,   0,   162, 255, 255, 246, 14,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   203, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 180, 0,   0,   0,   191, 255, 255, 130, 0,   0,   0,   0,   131, 255, 255, 194, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     129, 255, 255, 90,  0,   0,   0,   0,   0,   233, 255, 231, 0,   0,   0,   0,   0,   0,   1,   235, 255, 255, 179, 0,   0,   84,  255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   202, 255,
     255, 32,  0,   0,   0,   0,   185, 255, 255, 63,  0,   156, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   169, 255, 255, 238, 15,  0,   0,   0,   0,   122, 255, 255, 255,
     78,  0,   0,   0,   0,   0,   0,   0,   0,   163, 255, 255, 162, 0,   0,   0,   0,   78,  255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115, 255,
     255, 255, 78,  0,   0,   0,   71,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 73,  0,   8,   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 0,   0,   218, 255, 255, 158, 0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   72,  165, 215, 242, 240, 212, 156, 59,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 180, 0,   0,
     0,   170, 255, 255, 110, 0,   0,   0,   0,   110, 255, 255, 174, 0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32,
     0,   20,  255, 255, 255, 102, 0,   0,   84,  255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   129, 255, 255, 116, 0,   0,   0,   19,  248, 255, 240, 9,   31,  250, 255, 237, 12,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 150, 0,   0,   2,   129, 255, 255, 255, 169, 0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 142, 0,   0,   0,   0,
     187, 255, 255, 243, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  245, 255, 255, 186, 0,   0,   0,   35,  105, 124, 144, 163, 182, 201, 223, 255, 255, 255,
     255, 220, 200, 181, 162, 143, 124, 105, 35,  0,   8,   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   20,  255, 255, 255, 50,  0,   0,   0,   0,
     0,   0,   0,   0,   25,  187, 255, 255, 255, 255, 255, 255, 255, 255, 166, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 211, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   23,  255, 255, 255, 95,  0,   0,   84,  255, 255, 88,  0,   0,   0,   0,   0,
     0,   0,   0,   24,  239, 255, 243, 87,  15,  42,  192, 255, 255, 131, 0,   152, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 89,  44,  198,
     255, 255, 255, 190, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   160, 255, 255, 254, 27,  0,   0,   0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 198, 0,   0,   0,   0,   0,   0,   0,   0,   19,  222, 255, 255, 255, 255, 254, 255, 255, 255, 255, 255, 203, 8,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  249, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168,
     255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   15,  178, 255, 255, 204, 0,   0,   0,   0,   0,   0,   115, 180, 180, 180, 189, 255, 255, 235, 180, 180, 180, 180, 180, 223, 255, 255, 199,
     180, 180, 180, 180, 22,  0,   4,   247, 255, 255, 146, 0,   0,   84,  255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  249, 255, 255, 255, 255, 255, 255, 190, 6,   28,  249, 255,
     239, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  233, 255, 255, 248, 251, 255, 255, 255, 160, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   103, 255, 255, 255, 79,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   0,
     68,  254, 255, 193, 234, 255, 250, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   186, 255, 255, 255, 178, 56,  8,   10,  62,  187, 255, 255, 255, 157, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 240, 11,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   42,  217, 255, 255, 255, 204, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   65,  255, 255, 155, 0,   0,   0,   0,   0,   181, 255, 255, 31,  0,   0,   0,   0,   0,   0,   0,   186, 255, 255, 247, 56,  0,   84,  255, 255, 88,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,  187, 252, 255, 255, 227, 125, 7,   0,   147, 255, 255, 129, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   68,
     255, 255, 255, 255, 255, 236, 90,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 250, 11,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  252, 255, 255, 171, 0,   0,   0,   0,   0,   0,   0,   22,  231, 255, 255, 74,  120, 255, 255, 225, 18,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   1,   149, 237, 237, 149, 1,   0,   0,   0,   0,   0,   71,  255, 255, 255, 154, 1,   0,   0,   0,   0,
     2,   165, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   227, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   168, 255, 255, 180, 0,   0,   0,   0,   0,   0,   83,  243, 255, 255, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   117, 255, 255, 104, 0,   0,   0,   0,
     0,   231, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   69,  255, 255, 255, 250, 141, 114, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  33,  22,  0,   0,
     0,   25,  247, 255, 241, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  205, 255, 255, 255, 255, 241, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   217, 255, 255, 218, 0,   0,   0,
     0,   0,   0,   1,   185, 255, 255, 217, 1,   13,  238, 255, 255, 178, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,
     0,   78,  255, 255, 255, 255, 77,  0,   0,   0,   0,   0,   193, 255, 255, 225, 10,  0,   0,   0,   0,   0,   0,   15,  231, 255, 255, 171, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,
     255, 255, 254, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 180, 0,   0,   0,   0,   2,   135, 255, 255, 255,
     247, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 53,  0,   0,   0,   0,   26,  255, 255, 185, 0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 255,
     255, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   106, 249, 255, 255, 255, 255, 255, 255, 150, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   253, 255, 255, 169, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   174, 255, 255, 252, 7,   0,   0,   0,   0,   0,   120, 255, 255, 255, 107, 0,   0,   126, 255, 255, 255, 116, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 255, 114, 0,   0,   0,   0,   23,  254, 255, 255, 125, 0,
     0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 249, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 180, 0,   0,   0,   18,  185, 255, 255, 255, 171, 148, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 250,
     7,   0,   0,   0,   0,   77,  255, 255, 134, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  234, 255, 255, 255, 255, 255, 241, 153, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   22,  245, 255, 244, 20,  0,   0,   27,  77,  88,  61,  5,   0,   0,   0,   0,   0,   0,   134, 255, 255, 255, 248, 109, 201, 255, 255, 255, 99,  0,   0,   0,   0,   0,
     222, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255,
     255, 255, 32,  0,   0,   0,   0,   56,  251, 255, 255, 240, 12,  0,   0,   16,  241, 255, 255, 250, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,
     0,   0,   0,   0,   0,   0,   78,  255, 255, 255, 255, 77,  0,   0,   0,   0,   95,  255, 255, 255, 43,  0,   0,   0,   0,   0,   0,   0,   0,   48,  255, 255, 255, 80,  0,   0,   0,   0,   0,
     0,   0,   0,   45,  255, 255, 255, 75,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 180, 0,   0,   46,  222,
     255, 255, 255, 156, 3,   144, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 207, 0,   0,   0,   0,   0,   128, 255, 255, 83,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   14,  120, 225, 255, 255, 255, 255, 255, 255, 179, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   138, 255, 255, 138, 0,   28,  179, 255, 255, 255, 255, 234,
     95,  0,   0,   0,   0,   98,  255, 255, 255, 238, 50,  0,   29,  234, 255, 255, 248, 55,  0,   0,   0,   43,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  255, 255, 255,
     126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 45,  0,   0,   0,   0,   97,  238, 255, 255, 141, 0,   0,   0,   0,   133,
     255, 255, 241, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   1,   149, 238, 238, 149, 1,   0,   0,   0,   0,   155,
     255, 255, 243, 2,   0,   0,   0,   0,   0,   0,   0,   0,   3,   244, 255, 255, 146, 0,   0,   0,   0,   0,   0,   0,   0,   153, 255, 255, 220, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 180, 0,   0,   52,  248, 255, 254, 125, 0,   0,   144, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   66,  255, 255, 157, 0,   0,   0,   0,   0,   179, 255, 255, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   118, 255, 255, 255, 255, 255, 255, 246, 88,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  243, 255, 246, 22,  21,  225, 255, 255, 255, 255, 255, 255, 255, 113, 0,   0,   15,  238, 255, 255, 250, 63,  0,   0,   0,   65,  252, 255, 255,
     229, 24,  0,   0,   121, 255, 255, 255, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   119, 255, 255, 255, 56,  0,   0,   0,   0,   0,   15,  133, 241, 32,  0,   0,   0,   0,   20,  237, 144, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120,
     255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 201, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   201, 255, 255, 186,
     0,   0,   0,   0,   0,   0,   0,   16,  244, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255,
     180, 0,   0,   0,   102, 247, 87,  0,   0,   0,   144, 255, 255, 204, 0,   0,   0,   0,   32,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 170, 218, 255, 255, 255, 253, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 143, 0,   161, 255, 255,
     188, 35,  8,   88,  247, 255, 250, 39,  0,   101, 255, 255, 255, 155, 0,   0,   0,   0,   0,   116, 255, 255, 255, 197, 6,   4,   224, 255, 255, 205, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   47,  255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 255, 255, 46,  0,   0,   0,   0,   0,   0,   0,   12,  0,
     0,   0,   0,   0,   0,   12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   230, 255, 255, 174, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   173, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   113, 255, 255, 245, 17,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 180, 0,   0,   0,   0,   35,  0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   0,
     0,   32,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 88,  2,   126,
     254, 255, 255, 214, 0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  241, 255, 247, 25,  15,  249, 255, 245, 19,  0,   0,   0,   130, 255, 255, 145, 0,   165, 255, 255, 255, 48,  0,   0,   0,
     0,   0,   0,   170, 255, 255, 255, 152, 94,  255, 255, 255, 102, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  255, 255, 255, 138, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     56,  134, 200, 228, 249, 238, 211, 151, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   254, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   147, 255, 255, 253, 0,   0,   0,   0,   0,   0,   1,   219, 255, 255, 155, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   168, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   0,   0,   31,  248, 248, 248, 248, 255, 255, 255, 248, 248, 248, 248, 248, 250, 255, 255,
     252, 248, 248, 248, 248, 178, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 88,  0,   0,   147, 255, 255, 255, 43,  0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 147,
     0,   70,  255, 255, 182, 0,   0,   0,   0,   51,  255, 255, 210, 0,   198, 255, 255, 252, 6,   0,   0,   0,   0,   0,   0,   12,  213, 255, 255, 255, 239, 255, 255, 225, 6,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   11,  254, 255, 255, 166, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 254, 10,  0,   0,   0,   0,
     0,   52,  124, 186, 222, 241, 250, 235, 204, 150, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  194, 255, 255, 255, 255, 255, 255, 255, 255, 255, 178, 18,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   11,  255, 255, 255, 138, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   136, 255, 255, 255, 9,   0,   0,   0,   0,   0,   73,  255, 255, 255, 47,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255,
     255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   5,   248, 255, 228, 0,   0,   0,   0,   0,   112, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,
     255, 255, 88,  0,   0,   47,  255, 255, 255, 82,  0,   0,   0,   0,   0,   0,   0,   14,  239, 255, 249, 28,  0,   100, 255, 255, 147, 0,   0,   0,   0,   15,  255, 255, 241, 0,   201, 255, 255,
     243, 0,   0,   0,   0,   0,   0,   0,   0,   38,  241, 255, 255, 255, 255, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 210, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 223, 0,   0,   0,   0,   76,  198, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 198, 39,  0,   0,   0,   0,
     0,   4,   138, 254, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 214, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  255, 255, 255, 130, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   128, 255, 255, 255, 20,  0,   0,   0,   0,   0,   181, 255, 255, 194, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   46,  255, 255, 177, 0,   0,   0,
     0,   0,   164, 255, 255, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 88,  0,   0,   32,  255, 255, 255, 87,  0,   0,   0,   0,   0,   0,   0,
     124, 255, 255, 152, 0,   0,   107, 255, 255, 138, 0,   0,   0,   0,   7,   255, 255, 250, 0,   182, 255, 255, 255, 25,  0,   0,   0,   0,   0,   0,   0,   0,   79,  254, 255, 255, 255, 186, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   178, 255, 255, 249, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  252, 255, 255, 178,
     0,   0,   15,  166, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 237, 48,  0,   0,   0,   0,   97,  255, 255, 255, 252, 165, 76,  22,  1,   17,  89,  222, 255, 255, 255, 166,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 29,  0,   0,   0,   0,   35,  254,
     255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 233, 233, 128, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   144, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 127, 0,   0,   0,   0,   0,   217, 255, 251, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   84,  255, 255, 88,  0,   0,   86,  255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   12,  236, 255, 250, 31,  0,   0,   90,  255, 255, 151, 0,   0,   0,   0,   20,  255, 255,
     234, 0,   136, 255, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   68,  247, 255, 255, 255, 189, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 75,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 110, 0,   0,   8,   205, 255, 255, 248, 164, 89,  32,  7,   0,   25,  95,  219, 255, 255,
     255, 215, 6,   0,   0,   0,   0,   167, 255, 198, 44,  0,   0,   0,   0,   0,   0,   20,  221, 255, 255, 254, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  255, 255, 255,
     131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 255, 20,  0,   0,   0,   0,   142, 255, 255, 229, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 55,  0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   143, 255,
     255, 76,  0,   0,   0,   0,   14,  254, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  110, 14,  0,   0,   0,   0,   84,  255, 255, 88,  0,   26,  221, 255, 255, 238, 5,   0,   0,
     0,   0,   0,   0,   119, 255, 255, 157, 0,   0,   0,   44,  255, 255, 193, 0,   0,   0,   0,   61,  255, 255, 189, 0,   59,  255, 255, 255, 244, 48,  0,   0,   0,   0,   0,   1,   104, 249, 255,
     255, 255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  255, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     155, 255, 255, 255, 36,  0,   0,   0,   31,  232, 147, 20,  0,   0,   0,   0,   0,   0,   0,   13,  203, 255, 255, 255, 85,  0,   0,   0,   0,   8,   115, 5,   0,   0,   0,   0,   0,   0,   0,
     0,   81,  255, 255, 255, 118, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  255, 255, 255, 138, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   136, 255, 255, 255, 9,   0,
     0,   0,   10,  239, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   109, 255, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 25,  0,   0,   0,   0,   65,  255, 255, 157, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   116, 255, 247, 177, 105, 53,  19,  87,  255, 255, 137, 134, 238, 255, 255, 255, 118, 0,   0,   0,   0,   0,   0,   10,  234, 255, 251, 35,  0,   0,   0,   1,   217, 255, 251, 35,  0,
     0,   0,   152, 255, 255, 111, 0,   0,   194, 255, 255, 255, 241, 109, 19,  2,   26,  94,  200, 255, 255, 255, 240, 218, 255, 255, 254, 73,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   199, 255, 255, 239, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  241, 255, 255, 199, 0,   0,   0,   0,   0,   9,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   56,  255, 255, 255, 154, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   249, 255, 255, 166, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   1,   253, 255, 255, 150, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 254, 0,   0,   0,   0,   102, 255, 255, 250, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   109, 255, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   0,   0,   0,
     0,   0,   0,   239, 255, 230, 0,   0,   0,   0,   0,   118, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     163, 1,   0,   0,   0,   0,   0,   0,   114, 255, 255, 161, 0,   0,   0,   0,   0,   88,  255, 255, 213, 75,  48,  128, 254, 255, 226, 13,  0,   0,   32,  235, 255, 255, 255, 255, 255, 253, 255,
     255, 255, 255, 255, 222, 42,  40,  244, 255, 255, 237, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   107, 255, 255, 255, 91,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   247, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   226, 255, 255, 185, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   226, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   174,
     255, 255, 228, 0,   0,   0,   0,   209, 255, 255, 166, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,
     255, 255, 255, 255, 54,  0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 179, 0,   0,   0,   0,   0,   170, 255, 255, 55,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   78,  239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 229, 101, 0,   0,   0,   0,   0,   0,   0,   8,   231, 255, 253, 39,  0,   0,   0,   0,   0,
     0,   136, 255, 255, 255, 255, 255, 255, 238, 54,  0,   0,   0,   0,   36,  207, 255, 255, 255, 255, 255, 255, 255, 255, 249, 140, 16,  0,   0,   96,  255, 255, 255, 202, 6,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   5,   219, 255, 255, 225, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   226, 255, 255, 220, 6,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   249, 255, 255, 171, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   232, 255, 255, 179, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   188, 255, 255, 201, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   201, 255, 255, 190, 0,   0,   0,   62,  255, 255, 255, 58,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 234, 234, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204,
     0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 129, 0,   0,   0,   0,   0,   222, 255, 252, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  82,  146, 189, 221, 236, 248, 255, 255,
     210, 143, 73,  5,   0,   0,   0,   0,   0,   0,   0,   0,   109, 255, 255, 166, 0,   0,   0,   0,   0,   0,   0,   0,   73,  185, 238, 249, 222, 148, 27,  0,   0,   0,   0,   0,   0,   2,   83,
     167, 222, 244, 246, 223, 187, 111, 27,  0,   0,   0,   0,   0,   163, 255, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   79,  255, 255, 255, 124, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   126, 255, 255, 255, 79,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   45,  255, 255, 255, 125, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  253, 255, 255, 145, 0,   0,   0,   0,   128, 233, 233, 128, 0,   0,   0,   0,   0,   148, 255, 255, 243, 2,   0,   0,   0,   0,   0,
     0,   0,   0,   3,   244, 255, 255, 153, 0,   0,   0,   170, 255, 255, 206, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   178, 255, 255, 245, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  245, 255, 255, 178, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   165, 255, 255, 252, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   69,  255, 255, 255, 87,  0,
     0,   0,   57,  255, 255, 255, 255, 55,  0,   0,   0,   0,   84,  255, 255, 255, 44,  0,   0,   0,   0,   0,   0,   0,   0,   48,  255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   123, 232, 241, 168, 9,   0,   0,   0,   0,   0,   0,   0,
     0,   144, 255, 255, 204, 0,   0,   1,   252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   84,  255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  121, 182, 222, 244, 252, 242, 222, 151, 0,   0,   0,   52,  255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  227, 255, 255,
     208, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   209, 255, 255, 227, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   133, 255, 255, 255, 135,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 246, 15,  0,   0,   0,   109, 255, 255, 255, 255, 108, 0,   0,   0,   0,   15,  251, 255, 255, 126,
     0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 253, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   51,  251, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  255, 255, 255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   19,  255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   37,  177, 255, 255, 255, 255, 255, 255, 255, 255, 216, 0,   0,   0,   52,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 40,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  245, 255, 255, 162, 1,   0,   0,   0,   0,   0,   0,   0,   1,   162, 255, 255, 245, 56,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   40,  103, 208, 255, 255, 255, 148, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  252,
     255, 255, 154, 0,   0,   0,   0,   109, 255, 255, 255, 255, 108, 0,   0,   0,   0,   0,   176, 255, 255, 225, 10,  0,   0,   0,   0,   0,   0,   14,  231, 255, 255, 190, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   213, 255, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  255, 255, 255, 255, 146, 0,   0,
     0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   40,  255, 255, 255, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  245, 255, 255, 255, 255, 255, 255, 252, 255, 255, 216, 0,   0,   0,   50,
     248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 251, 255, 255, 255, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   73,  250, 255, 255, 139, 0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 250, 71,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  248, 248, 249, 255, 255, 255, 255,
     251, 182, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   205, 255, 255, 245, 26,  0,   0,   0,   0,   55,  255, 255, 255, 255, 54,  0,   0,   0,   0,
     0,   53,  255, 255, 255, 153, 1,   0,   0,   0,   0,   2,   164, 255, 255, 255, 67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   138, 255, 255, 255, 255, 212, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  255, 255, 255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   60,  255, 255, 255, 19,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   87,  253, 255, 255, 255, 202, 112, 44,  16,  0,   8,   35,  73,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   178, 255, 255,
     200, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   78,  246, 255, 255, 132, 0,   0,   0,   0,   0,   131, 255, 255,
     245, 77,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 233, 131, 61,  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   146, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   127, 234, 234, 127, 0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 177, 55,  8,   10,  61,  186, 255, 255, 255, 181, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   58,  253, 255, 255, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 233,
     241, 168, 9,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   81,  255, 255, 250, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     12,  104, 178, 226, 247, 246, 227, 180, 108, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   39,  246, 255, 255, 245, 93,  1,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  253, 255, 255, 95,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  234, 255, 255, 155, 3,   0,   2,   152, 255, 255, 233, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255,
     255, 255, 255, 255, 255, 255, 255, 228, 106, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 179, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   11,  209, 255, 255, 255, 255, 254, 255, 255, 255, 255, 255, 218, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  218, 255, 255, 192,
     255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,
     102, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  235, 255, 255, 255, 255, 255, 255, 255, 255, 238, 92,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   190, 255, 255, 246, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   138, 255, 255, 237, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   12,  32,  73,  144, 236, 255, 255, 255, 181, 6,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   58,  248, 255, 255, 217, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  174, 255, 255, 255, 255, 255, 255, 255,
     255, 181, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   147, 255, 255, 208, 128, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   122, 255, 255, 205, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   113, 255, 255, 255, 255, 255, 253, 254, 255, 255, 255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  255, 255, 255, 123, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   237, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   22,  121, 193, 230, 249, 234, 205, 133, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  169, 255, 255, 255, 146, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  236, 255, 255, 239, 40,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  161, 215, 242, 242, 215, 161, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   66,
     254, 255, 255, 69,  128, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144,
     255, 255, 204, 0,   0,   143, 255, 255, 182, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   51,  253, 255, 255, 244, 123, 34,  2,   2,   37,  127, 245, 255, 255, 253,
     50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 231, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   99,  255, 255, 254, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   113, 243, 255, 255, 255, 255, 255, 255, 255, 251, 135, 6,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   200, 255, 255, 250, 28,
     0,   0,   0,   0,   0,   0,   0,   0,   23,  221, 255, 255, 248, 63,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  224, 255, 255, 166, 0,   128, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   164, 255, 255, 158, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 252, 57,  0,   0,   0,   0,   0,   0,   59,  252, 255, 255, 165, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   244, 255, 255, 145,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   206, 255, 255, 186, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   147, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 175, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  255, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   13,  206, 255, 255, 254, 87,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   156, 255, 255, 229, 18,  0,   128, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   144, 255, 255, 204, 0,   0,   184, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   235, 255, 255, 171, 0,   0,   0,   0,   0,   0,
     0,   0,   173, 255, 255, 233, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   66,  255, 255, 255, 66,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  255, 255, 255, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  255, 255, 255, 229, 103, 26,  1,   14,  78,  202,
     255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     30,  255, 255, 255, 139, 0,   0,   0,   0,   0,   0,   6,   188, 255, 255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   3,   91,  214, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   73,  255, 255, 254, 70,  0,   0,   128, 255, 255, 212, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   205, 255, 255, 112, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   255, 255, 255, 121, 0,   0,   0,   0,   0,   0,   0,   0,   121, 255, 255, 254, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     121, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   167, 255, 255, 228, 4,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   234, 255, 255, 219, 25,  0,   0,   0,   0,   0,   3,   167, 255, 255, 253, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  255, 255, 255, 148, 0,   0,   0,   0,   0,   2,   168, 255, 255, 255, 127, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   95,  217, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   17,  229, 255, 255, 148, 0,   0,   0,   128, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   225, 255, 255, 201, 197, 229, 244, 251, 236, 210, 152, 71,  0,   0,   0,   0,   0,   0,   1,   252, 255, 255, 133, 0,
     0,   0,   0,   0,   0,   0,   0,   126, 255, 255, 251, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 233, 0,   0,   50,  155, 215, 244, 242, 219, 160, 74,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  250, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  255, 255, 255, 64,  0,   0,
     0,   0,   0,   0,   0,   6,   215, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   43,  255, 255, 255, 128, 0,   0,   0,   0,   0,   146, 255, 255, 255, 145, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   5,   99,  220, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   165, 255, 255, 216, 9,   0,   0,   0,   128, 255, 255,
     212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   246, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 208, 49,  0,   0,   0,   0,   0,   210, 255, 255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   188, 255, 255, 207, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   200, 255, 255, 212, 1,   124, 254, 255, 255, 255, 255, 255, 255, 255, 194, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 251,
     26,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 214, 0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 251, 23,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 255, 89,  0,   0,   0,   0,   122, 255, 255,
     255, 162, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   103, 224, 255, 255, 255, 255, 197, 74,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   82,  255, 255, 251, 53,  0,   0,   0,   0,   128, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   182, 255, 255, 255, 255, 254, 252, 255, 255, 255, 255, 255, 255, 249, 80,  0,   0,   0,   0,
     126, 255, 255, 254, 53,  0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 200, 111, 255, 255, 255, 255, 252, 255, 255,
     255, 255, 255, 224, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   230, 255, 255, 173, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   218, 255,
     255, 153, 0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   237, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   220, 255, 255, 252, 18,  0,   0,   0,   98,  255, 255, 255, 178, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   7,   107, 226, 255, 255, 255, 255, 188, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  234, 255, 255, 127, 0,   0,   0,
     0,   0,   128, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   80,  90,  51,  19,  1,   0,   12,  52,  120, 225, 255, 255, 255, 247, 48,  0,   0,   0,   16,  233, 255, 255, 226, 45,  0,   0,   0,   0,   52,  236, 255, 255, 219, 9,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   241, 255, 255, 227, 247, 255, 167, 64,  12,  0,   19,  86,  211, 255, 255, 255, 179, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     88,  255, 255, 255, 67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 152, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   89,  119, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  179, 255, 255, 255, 155, 0,   0,   0,
     77,  252, 255, 255, 194, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   111, 229, 255, 255, 255, 255, 179, 55,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   173, 255, 255, 201, 4,   0,   0,   0,   0,   0,   128, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  172, 255, 255,
     255, 190, 0,   0,   0,   0,   69,  250, 255, 255, 247, 129, 13,  9,   122, 248, 255, 255, 231, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   250, 255, 255, 255, 248, 80,  0,
     0,   0,   0,   0,   0,   10,  193, 255, 255, 255, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 217, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   251, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 199, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   112, 255, 247, 176, 103, 53,  16,  2,   0,   14,  56,  127, 229, 255, 255, 255, 227, 22,  0,   0,   0,   231, 255, 255, 255, 251, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
     217, 0,   0,   0,   0,   0,   10,  115, 231, 255, 255, 255, 253, 169, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   91,  255, 255, 245,
     38,  0,   0,   0,   0,   0,   0,   128, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   217, 255, 255, 255, 36,  0,   0,   0,   0,   79,  245, 255, 255, 255, 237, 232, 255, 255, 255,
     196, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   253, 255, 255, 255, 98,  0,   0,   0,   0,   0,   0,   0,   0,   32,  252, 255, 255, 144, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   48,  255, 255, 255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   237, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     163, 255, 255, 222, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 255, 254, 253, 255, 255, 255, 255, 255, 255, 228,
     40,  0,   0,   0,   0,   236, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 0,   0,   0,   12,  119, 234, 255, 255, 255, 251, 160, 39,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  238, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 212, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  255, 255, 255, 250, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   105, 255, 255, 255, 105, 0,   0,   0,   0,   0,   43,  214, 255, 255, 255, 255, 255, 255, 112, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   243, 255,
     255, 217, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   188, 255, 255, 203, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 246, 17,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   209, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   224, 255, 255, 237, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   63,  222, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 157, 16,  0,   0,   0,   0,   0,   236, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 224, 0,   1,   122, 236, 255, 255, 255, 248, 151, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     181, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   79,  255, 255, 255, 210, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  255, 255, 255, 135, 0,   0,   0,   0,   15,  149, 251, 255, 255,
     255, 255, 255, 255, 236, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   229, 255, 255, 157, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   138, 255, 255, 232, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   18,  246, 255, 255, 159, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   150, 255, 255, 251, 30,  0,   0,   0,   0,
     0,   0,   0,   0,   110, 255, 255, 255, 249, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   64,  132, 181, 218, 239, 249, 250, 235, 215,
     167, 110, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 255, 156, 26,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 238, 26,  0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 212, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   123, 255, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   18,  255, 255, 255, 150, 0,   0,   0,   47,  225, 255, 255, 255, 180, 79,  174, 255, 255, 255, 255, 180, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   207, 255, 255, 153, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 246, 0,   0,   0,   0,   0,   0,   0,   0,   0,   117, 255, 255, 255, 54,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  255, 255, 255, 191, 10,  0,   0,   0,   0,   0,   0,   93,  251, 255, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   6,   245, 255, 255, 255, 239, 130, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   206, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   167, 255,
     255, 255, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  255, 255, 255, 133, 0,   0,   42,  240,
     255, 255, 242, 85,  0,   0,   0,   55,  204, 255, 255, 255, 206, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 179, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     130, 255, 255, 234, 0,   0,   0,   0,   0,   0,   0,   0,   2,   222, 255, 255, 205, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   187, 255, 255,
     255, 213, 91,  25,  4,   19,  73,  177, 255, 244, 226, 255, 255, 236, 0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   22,  138, 243, 255,
     255, 255, 244, 140, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   210, 255, 255, 220, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  255, 255, 255, 108, 0,   5,   212, 255, 255, 242, 51,  0,   0,   0,   0,   0,   4,   142, 255, 255, 255, 178, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   109, 255, 255, 235, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   161, 255, 255, 213, 0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 255, 100,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  226, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 99,  205, 255, 255, 218, 0,   8,   210,
     86,  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   248, 248,
     248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 0,   0,   0,   0,   19,  134, 241, 255, 255, 255, 247, 149, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   201, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 252, 255, 255, 254, 248, 248, 248, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   9,   251, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 255,
     49,  0,   94,  255, 255, 255, 95,  0,   0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 255, 74,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  254, 255, 255, 78,  0,   0,   0,   0,
     0,   0,   0,   0,   1,   222, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   185, 255, 255, 240, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   26,  194, 255, 255, 255, 255, 255, 255, 255, 251, 111, 0,   218, 255, 255, 195, 0,   8,   255, 255, 214, 90,  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   17,  129, 239, 255, 255, 255, 251, 159, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   156, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255, 253, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  229, 255, 255, 226, 1,   0,   179, 255, 255, 224, 2,   0,   0,   0,   0,   0,   0,   0,   0,   7,   230,
     255, 255, 173, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 214, 6,   0,   0,   0,   0,   0,   0,   0,   78,  255, 255, 255, 91,  0,   0,   0,   0,   0,   0,   0,   38,
     254, 255, 255, 145, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  157, 213, 236, 236, 208, 144, 41,  0,   0,   238, 255,
     255, 159, 0,   8,   255, 255, 255, 255, 217, 94,  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  126, 237, 255, 255, 255, 253, 169, 47,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   117, 255, 255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 61,  0,   0,   0,   0,   0,   0,   0,   0,   0,   15,
     185, 255, 255, 255, 103, 0,   0,   226, 255, 255, 159, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   159, 255, 255, 225, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  255, 255,
     255, 166, 3,   0,   0,   0,   0,   0,   32,  228, 255, 255, 230, 6,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 255, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  255, 255, 255, 116, 0,   0,   78,  201, 255, 255, 255, 255, 220, 98,  4,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  122, 235, 255, 255, 255, 255, 179, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   173, 255, 255, 76,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 206, 120, 65,  22,  5,   0,   9,   48,  119, 227, 255, 255, 255, 189, 4,   0,   0,   239, 255, 255, 140, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   143, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   157, 255, 255, 255, 201, 76,  13,  1,   27,  108, 234, 255, 255, 255, 89,  0,   0,   0,   0,
     0,   0,   0,   12,  241, 255, 255, 191, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   72,  255, 255, 255, 61,  0,   0,   0,   0,   69,  193, 255, 255, 255, 255, 223, 102, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,
     118, 233, 255, 255, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 212, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 223, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255,
     251, 255, 255, 255, 255, 255, 255, 199, 16,  0,   0,   0,   221, 255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 255, 213, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   7,   184, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 139, 0,   0,   0,   0,   0,   0,   0,   0,   106, 255, 255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   151, 255, 255, 240, 5,   0,   0,   0,   0,   0,   0,   60,  184, 255, 255,
     255, 255, 226, 106, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  114, 231, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 244, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 242, 130, 4,   0,   0,   0,   0,   178, 255, 255, 229, 6,
     0,   0,   0,   0,   0,   0,   0,   0,   21,  243, 255, 255, 158, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   142, 252, 255, 255, 255, 255, 255, 255, 255, 242, 109, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   213, 255, 255, 232, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   8,   235, 255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  175, 254, 255, 255, 255, 228, 110, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   8,   110, 228, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255,
     255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  78,  142, 186, 223, 240, 252, 242, 224, 180, 121, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,
     93,  161, 203, 234, 247, 251, 236, 215, 165, 102, 14,  0,   0,   0,   0,   0,   0,   97,  255, 255, 255, 138, 0,   0,   0,   0,   0,   0,   0,   8,   181, 255, 255, 255, 66,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  135, 207, 235, 249, 231, 193, 120, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   66,  255, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   129, 255, 255, 255, 58,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   44,  166, 252, 255, 255, 255, 231, 114, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   105, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  171, 249, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 254, 157, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     5,   216, 255, 255, 255, 183, 75,  19,  0,   2,   30,  98,  215, 255, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   65,  248, 255, 255, 185, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  157, 250, 255, 255, 255, 233, 118, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 255, 255, 255, 255, 252, 255, 255, 255, 255, 255, 255, 216, 27,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   45,  135, 197, 235, 250, 235, 207, 151, 59,  1,   0,   0,   0,   0,   0,   0,   0,   0,   41,  235, 255, 255, 255, 255, 255, 253, 254, 255, 255, 255, 255, 255, 200, 12,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  253, 255, 255, 251, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  104, 175, 210,
     232, 251, 244, 230, 197, 156, 91,  21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   94,  246, 255, 255, 245, 36,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  165, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,
     0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 252, 241, 229, 198, 159, 95,  20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     10,  237, 255, 230, 157, 91,  45,  12,  0,   3,   34,  100, 215, 255, 255, 255, 192, 1,   0,   0,   0,   0,   0,   0,   0,   31,  177, 255, 255, 255, 255, 255, 255, 255, 255, 255, 190, 31,  0,
     0,   0,   0,   0,   0,   0,   0,   32,  189, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 143, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 255, 255, 97,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  170, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 160, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   75,  33,  7,   0,   14,  43,  111, 203, 255, 255, 255, 253, 83,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  136, 242, 255,
     255, 255, 243, 0,   92,  255, 255, 255, 255, 255, 255, 251, 231, 211, 176, 108, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 248,
     141, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  73,  2,   0,   0,   0,   0,   0,   0,   0,   0,   6,   178, 255, 255, 255,
     64,  0,   0,   0,   0,   0,   0,   65,  237, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 241, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  142, 198, 233, 248, 247, 229, 187,
     124, 27,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   188, 255, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 250,
     255, 255, 255, 255, 255, 255, 252, 255, 255, 255, 255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 252, 255, 255, 255, 255, 255, 255, 244,
     83,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  145, 246, 255, 255, 255, 241, 133, 19,  0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     181, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
     248, 248, 170, 0,   0,   0,   92,  255, 255, 255, 250, 248, 248, 248, 248, 249, 255, 255, 255, 255, 255, 255, 255, 198, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  246, 255, 255, 136, 0,   0,   0,   0,   0,   60,  246, 255, 255, 248, 165, 70,  28,  2,   15,  52,
     140, 242, 255, 255, 236, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  251,
     255, 255, 255, 255, 249, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   134, 255, 255, 255, 255, 227, 132, 53,  19,  0,   8,   40,  92,  171, 247, 243, 21,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 255, 255, 255, 255, 255, 177, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  155, 249,
     255, 255, 255, 239, 129, 17,  0,   0,   0,   92,  255, 255, 255, 250, 248, 248, 255, 255, 255, 255, 255, 255, 255, 254, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   3,
     30,  79,  168, 254, 255, 255, 255, 139, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   198, 255, 255, 164, 0,   0,   0,   0,   23,  232, 255, 255, 212, 43,  0,   0,   0,   0,   0,   0,   0,   34,  204, 255, 255, 207, 2,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   99,  255, 255, 216, 235, 255, 255, 91,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   106, 255, 255, 255, 255, 142, 11,  0,   0,   0,   0,   0,   0,   0,   0,   21,  67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   155, 224, 244, 253, 246, 222,
     182, 121, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   43,  165, 252, 255, 255, 255, 237, 125, 15,  0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   4,
     24,  60,  129, 218, 255, 255, 255, 255, 163, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   82,  254, 255, 255, 242, 6,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   209, 255, 255, 159, 0,   0,   0,   0,   156, 255, 255, 209, 12,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   18,  216, 255, 255, 105, 0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   182, 255, 255, 159, 173, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   43,  247, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   51,  174,
     254, 255, 255, 255, 235, 121, 13,  0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   4,   106, 247, 255, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   173, 255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   7,   242, 255, 255, 125, 0,   0,   0,   47,  253, 255, 237, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  253, 255, 230, 3,   0,   0,   60,  255,
     255, 255, 251, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 50,  0,   0,   0,   0,   0,   0,   0,   0,   16,  249, 255, 255, 95,  105, 255, 255, 246, 12,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   185, 255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  112, 185, 216, 240, 250,
     237, 208, 164, 96,  20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  183, 255, 255, 255, 255, 232, 117, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255,
     255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   62,  242, 255, 255, 252, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 255, 89,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   106, 255, 255, 255, 55,  0,   0,   0,   170, 255, 255,
     113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 70,  0,   0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 26,  32,  255, 255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,   44,  255, 255, 255, 229, 14,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  159, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,
     193, 255, 255, 255, 255, 230, 113, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 255, 255, 255, 196, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,
     255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   89,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   62,  245, 255, 255, 190, 0,   0,   0,   13,  246, 255, 228, 7,   0,   0,   0,   26,  142, 218, 247, 244, 216, 167, 91,  8,   0,   58,  255, 255,
     160, 0,   0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 206, 0,   0,   213, 255, 255, 170,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   150, 255, 255, 255, 123, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  239, 255, 255,
     255, 255, 255, 255, 254, 255, 255, 255, 255, 255, 123, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 227, 109, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   199, 255, 255, 255, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   93,  247, 255, 255, 228, 28,  0,   0,
     0,   93,  255, 255, 136, 0,   0,   0,   64,  237, 255, 255, 255, 255, 255, 255, 255, 154, 0,   1,   226, 255, 216, 0,   0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  247, 255, 255, 129, 0,   0,   135, 255, 255, 244, 9,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 253, 25,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  244, 255, 255, 255, 218, 113, 36,  7,   3,   31,  90,  180, 252, 244, 18,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   8,   255, 225, 105, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     96,  255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 238, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   154, 255, 255, 255, 222, 36,  0,   0,   0,   0,   165, 255, 255, 54,  0,   0,   39,  241, 255, 255, 255, 253, 255, 255, 255, 255,
     156, 0,   0,   171, 255, 253, 11,  0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   87,  255, 255, 255, 52,  0,
     0,   57,  255, 255, 255, 81,  0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 211, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,
     234, 255, 255, 255, 153, 9,   0,   0,   0,   0,   0,   0,   0,   40,  95,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   101, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  251, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   82,  255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  212, 255, 255, 255, 191,
     22,  0,   0,   0,   0,   0,   212, 255, 238, 1,   0,   0,   188, 255, 255, 216, 52,  2,   27,  183, 255, 255, 156, 0,   0,   125, 255, 255, 52,  0,   60,  255, 255, 255, 104, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   170, 255, 255, 230, 1,   0,   0,   2,   233, 255, 255, 165, 0,   0,   0,   0,   0,   0,   0,   69,  255, 255, 255,
     157, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 255, 163, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   210, 255, 255, 254, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   1,   20,  68,  159, 253, 255, 255, 155, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   44,  235, 255, 255, 253, 131, 3,   0,   0,   0,   0,   0,   7,   251, 255, 195, 0,   0,   52,  255, 255, 249, 38,  0,
     0,   0,   152, 255, 255, 156, 0,   0,   96,  255, 255, 71,  0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   244,
     255, 255, 154, 0,   0,   0,   0,   157, 255, 255, 241, 6,   0,   0,   0,   0,   0,   0,   89,  255, 255, 255, 123, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   43,  255, 255, 255, 228, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,
     255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   161, 255, 255, 255, 55,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 0,   0,   0,   0,   92,  255, 255, 255, 250, 248, 248, 248,
     248, 248, 254, 255, 255, 255, 255, 209, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  223, 255,
     255, 242, 73,  0,   0,   0,   0,   0,   0,   0,   44,  255, 255, 152, 0,   0,   140, 255, 255, 170, 0,   0,   0,   0,   152, 255, 255, 156, 0,   0,   83,  255, 255, 85,  0,   60,  255, 255, 255,
     104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 77,  0,   0,   0,   0,   78,  255, 255, 255, 76,  0,   0,   0,   0,   0,
     0,   107, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 73,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 116, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   102, 255, 255, 249, 58,  0,   0,   0,   0,   0,   0,   0,   0,   62,  255, 255, 124, 0,   0,   196,
     255, 255, 96,  0,   0,   0,   0,   152, 255, 255, 156, 0,   0,   70,  255, 255, 99,  0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   164, 255, 255, 246, 9,   0,   0,   0,   0,   9,   246, 255, 255, 159, 0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 95,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   1,   236, 255, 255, 247, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 255, 91,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 228, 0,   0,   0,   0,   92,  255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 172, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 112, 0,   0,   237, 255, 255, 52,  0,   0,   0,   0,   152, 255, 255, 156, 0,   0,   73,  255, 255, 96,
     0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   240, 255, 255, 179, 0,   0,   0,   0,   0,   0,   178, 255, 255, 237,
     4,   0,   0,   0,   0,   0,   108, 255, 255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 177, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,
     92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 98,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196,
     255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   7,   26,  71,  155, 250, 255, 255, 245, 78,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   215, 255, 255, 82,  0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  255,
     255, 99,  0,   0,   252, 255, 255, 31,  0,   0,   0,   0,   155, 255, 255, 156, 0,   0,   79,  255, 255, 87,  0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   75,  255, 255, 255, 102, 0,   0,   0,   0,   0,   0,   99,  255, 255, 255, 70,  0,   0,   0,   0,   0,   93,  255, 255, 255, 119, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130,
     255, 255, 255, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  234, 255, 255, 245, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   224, 244, 244, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 96,  0,   4,   255, 255, 255, 26,  0,   0,   0,   0,   165, 255, 255, 156, 0,
     0,   93,  255, 255, 66,  0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   158, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 154, 0,   0,   0,   0,   0,   75,  255, 255, 255, 146, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   136, 255, 255, 255, 80,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,
     0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     78,  255, 255, 255, 167, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   82,  255, 255, 110, 0,   0,   248, 255, 255, 39,  0,   0,   0,   0,   191, 255, 255, 156, 0,   0,   117, 255, 255, 35,  0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 116, 0,   0,   0,   0,   0,   4,   237, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 234, 3,   0,   0,   0,   0,   33,  255, 255, 255, 194, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   154, 255, 255, 255, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,
     255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   176, 255, 255, 255, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   229, 255, 255, 243, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   67,  255, 255, 124, 0,   0,   218, 255, 255, 77,  0,   0,   0,   2,
     237, 255, 255, 168, 0,   0,   153, 255, 242, 2,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 116, 0,   0,   0,   0,   0,   69,  255, 255, 255, 249, 248,
     248, 248, 248, 248, 248, 248, 248, 249, 255, 255, 255, 65,  0,   0,   0,   0,   0,   236, 255, 255, 243, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     169, 255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255,
     255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   229, 255, 255, 244, 4,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   181, 255, 255, 255, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   51,  255, 255, 154, 0,   0,   166, 255, 255, 157, 0,   0,   0,   72,  255, 255, 255, 200, 0,   0,   213, 255, 186, 0,   0,   60,  255, 255, 255, 251, 248,
     248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 112, 0,   0,   0,   0,   0,   152, 255, 255, 249, 14,  0,   0,   0,   0,   0,   0,   0,   0,   15,  250, 255, 255, 149, 0,   0,   0,   0,   0,
     179, 255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   180, 255, 255, 255, 30,  0,   0,   0,   0,   0,   0,   217, 248, 248, 248, 248, 248,
     248, 248, 89,  0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 191, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   169, 255, 255, 255, 46,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   163, 240, 223, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  254, 255, 201, 0,   0,   86,  255, 255,
     253, 99,  9,   50,  222, 255, 153, 255, 252, 58,  86,  255, 255, 101, 0,   0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   232,
     255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   186, 255, 255, 230, 1,   0,   0,   0,   0,   87,  255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   170, 255, 255, 255, 38,  0,   0,   0,   0,   0,   0,   224, 255, 255, 255, 255, 255, 255, 255, 92,  0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 128, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   188, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   109,
     255, 255, 255, 244, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 246, 6,   0,   4,   217, 255, 255, 255, 255, 255, 255, 212, 14,  250, 255, 255, 255, 255, 234, 13,  0,   0,   60,
     255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  255, 255, 255, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 255,
     60,  0,   0,   0,   0,   6,   234, 255, 255, 255, 87,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   155, 255, 255, 255, 49,  0,   0,   0,   0,   0,   0,   224,
     255, 255, 255, 255, 255, 255, 255, 92,  0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255,
     255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  231, 255, 255, 251, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255,
     224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   239, 255, 255, 245, 5,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   161, 255, 255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255,
     81,  0,   0,   51,  243, 255, 255, 255, 255, 240, 41,  0,   150, 255, 255, 255, 254, 89,  0,   0,   0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   146, 255, 255, 254, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  254, 255, 255, 144, 0,   0,   0,   0,   0,   111, 255, 255, 255, 238, 50,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 70,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 92,  0,   92,  255, 255, 255, 76,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   157, 255, 255, 255, 166,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   91,  255, 255, 255, 182, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   161, 255, 255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   85,  255, 255, 174, 0,   0,   0,   40,  170, 232, 228, 169, 35,  0,   0,   10,  158, 233, 210, 86,
     0,   0,   0,   0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   228, 255, 255, 198, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   203, 255, 255, 226, 1,   0,   0,   0,   0,   1,   194, 255, 255, 255, 238, 87,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   100, 255, 255, 255, 109, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 92,  0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 96,  0,   0,   0,   0,   0,
     0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 242, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  238, 255,
     255, 255, 77,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 255, 243, 15,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   7,   237, 255, 254, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   123, 255, 255, 255, 55,  0,   0,   0,   0,   0,   29,  219, 255, 255, 255,
     255, 199, 110, 42,  15,  0,   4,   31,  70,  122, 182, 233, 0,   0,   0,   52,  255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 92,  0,   92,  255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   31,  167, 255,
     255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   11,  57,  143, 247, 255, 255, 255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   163, 241, 224, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 204, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 255, 37,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   44,  255, 255, 255, 138, 0,   0,   0,   0,   0,   0,   23,  207, 255, 255, 255, 255, 255, 255, 255, 252, 255, 255, 255, 255, 255, 244, 0,   0,   0,   7,   247,
     255, 255, 223, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 92,  0,   92,  255, 255, 255, 250, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 250, 255, 255, 255, 96,
     0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   1,   16,  39,  97,  167, 249, 255, 255, 255, 254, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 170, 0,   0,   0,   92,  255, 255, 255, 250, 248, 248, 248, 248, 248, 251, 255,
     255, 255, 255, 255, 255, 205, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   15,  230, 255, 255, 175, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 104, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   222, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   219, 255, 255, 221, 0,   0,   0,   0,   0,
     0,   0,   5,   111, 236, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 0,   0,   0,   0,   169, 255, 255, 255, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  255, 255, 255,
     92,  0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 250, 248, 252, 255, 255,
     255, 255, 255, 255, 255, 243, 83,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 148, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   83,  255, 255, 255, 192, 39,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   5,   65,  0,   0,   0,   0,   0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  255, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 255, 50,  0,   0,   0,   0,   0,   0,   0,   0,   11,  78,  151, 203, 225, 246, 252, 243, 223, 194, 150, 93,  20,
     0,   0,   0,   0,   77,  255, 255, 255, 177, 0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 92,  0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 244, 138, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   92,  255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 246, 228, 187, 123, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 255, 248, 169, 85,  38,  14,  5,   18,  50,  94,  160, 234, 220, 0,   0,   0,   0,   0,   60,  255, 255,
     255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   209, 255, 255, 255, 87,  0,   0,   0,   0,   0,   0,   0,
     0,   64,  255, 255, 255, 92,  0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255,
     255, 255, 253, 237, 219, 197, 143, 77,  14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   151, 248, 248, 248, 248, 248, 254, 255, 255, 254, 248, 248, 248, 248, 248, 135, 0,   0,   0,   0,   0,   0,   0,   0,   122,
     252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 0,   0,   0,   0,   0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204,
     255, 255, 255, 255, 34,  0,   0,   0,   0,   0,   0,   0,   0,   58,  255, 255, 255, 255, 204, 0,   92,  255, 255, 255, 244, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255,
     84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255, 255, 247, 84,  0,   0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 92,  0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   224, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   106, 255, 255, 255, 167, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  199, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 216, 88,  0,   0,   0,
     0,   0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255,
     255, 204, 0,   92,  255, 255, 255, 255, 128, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 178,
     82,  25,  2,   5,   24,  68,  150, 255, 255, 255, 92,  0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,
     23,  105, 183, 218, 242, 244, 219, 182, 100, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  250, 255,
     255, 207, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255,
     255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   53,  135, 191, 227, 242, 240, 224, 187, 135, 57,  1,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   204, 255, 255, 255, 255, 138, 0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 204, 0,   92,  255, 255, 255, 255, 237, 12,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   240, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 92,  0,   92,  255, 255, 255, 76,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   0,   4,   116, 245, 255, 255, 255, 255, 255, 255, 255, 255, 240, 96,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   25,  230, 255, 255, 235, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 255, 255, 190, 0,   0,   0,   0,   0,   0,   0,
     0,   217, 255, 255, 255, 255, 204, 0,   92,  255, 255, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   85,  232, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 64,  0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,
     0,   0,   4,   178, 255, 255, 255, 255, 255, 255, 254, 255, 255, 255, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,
     6,   197, 255, 255, 251, 66,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255,
     255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,
     0,   0,   144, 255, 255, 255, 255, 255, 255, 255, 252, 238, 221, 179, 126, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  105, 183, 218, 242, 244, 219, 182, 100, 18,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 252, 235, 255, 241, 1,   0,   0,   0,   0,   0,   0,   15,  254, 255, 223, 255, 255, 204, 0,   92,  255, 255, 255, 255, 255, 228, 6,   0,
     0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  88,  172, 214, 240, 252, 243, 228, 198, 162, 110, 52,  1,   0,   0,
     92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   0,   157, 255, 255, 255, 252, 147, 50,  10,  6,   38,  126, 242, 255, 255, 255,
     121, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 183,
     32,  0,   0,   0,   0,   0,   0,   0,   0,   4,   116, 245, 255, 255, 255, 255, 255, 255, 255, 255, 240, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 252, 181, 255, 255, 39,  0,
     0,   0,   0,   0,   0,   66,  255, 255, 166, 255, 255, 204, 0,   92,  255, 255, 221, 234, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 84,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255,
     255, 255, 96,  0,   0,   0,   63,  255, 255, 255, 245, 65,  0,   0,   0,   0,   0,   0,   39,  228, 255, 255, 251, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,
     0,   0,   0,   0,   98,  255, 255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208,
     0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 248, 248, 248, 248, 253, 255, 255, 255, 255, 255, 255, 242, 53,  0,   0,   0,   0,   0,   0,   4,   178, 255, 255, 255, 255, 255, 255, 254,
     255, 255, 255, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 252, 125, 255, 255, 91,  0,   0,   0,   0,   0,   0,   119, 255, 255, 110, 255, 255, 204, 0,   92,  255, 255, 212,
     123, 255, 255, 218, 2,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 84,  0,   96,  255, 255, 255, 255, 255, 255, 254, 242, 228, 196, 148, 78,  5,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   0,   203, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,
     0,   0,   62,  254, 255, 255, 178, 0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   0,   0,   53,  248, 255, 255, 203, 8,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   1,   19,
     66,  150, 247, 255, 255, 255, 234, 18,  0,   0,   0,   0,   0,   157, 255, 255, 255, 252, 147, 50,  10,  6,   38,  126, 242, 255, 255, 255, 121, 0,   0,   0,   0,   0,   0,   0,   204, 255, 252,
     70,  255, 255, 143, 0,   0,   0,   0,   0,   0,   172, 255, 255, 53,  255, 255, 204, 0,   92,  255, 255, 212, 16,  242, 255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 84,  0,
     96,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   44,  255, 255, 255, 213, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 254, 30,  0,   0,   0,   0,   0,   0,   0,   0,   224,
     255, 255, 196, 0,   0,   0,   0,   22,  227, 255, 255, 233, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   40,  227, 255, 255, 255, 139, 0,   0,   0,   0,   63,  255, 255, 255, 245,
     65,  0,   0,   0,   0,   0,   0,   39,  228, 255, 255, 251, 39,  0,   0,   0,   0,   0,   0,   204, 255, 252, 16,  254, 255, 196, 0,   0,   0,   0,   0,   0,   225, 255, 235, 16,  255, 255, 204,
     0,   92,  255, 255, 212, 0,   138, 255, 255, 206, 0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 84,  0,   96,  255, 255, 255, 250, 248, 248, 250, 255, 255, 255, 255, 255, 255, 255, 157, 1,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   128, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   79,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   4,   191, 255, 255, 250, 61,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255,
     52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,
     0,   0,   0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 230, 0,   0,   0,   0,   203, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   62,  254, 255, 255, 177, 0,   0,   0,   0,
     0,   0,   204, 255, 252, 0,   215, 255, 244, 3,   0,   0,   0,   0,   22,  255, 255, 180, 16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   25,  248, 255, 255, 72,  0,   0,   0,   0,   0,   0,
     240, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,   0,   0,   6,   34,  87,  181, 255, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   196, 255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  252, 255, 255, 193, 0,   0,   0,   0,
     0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   143, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 40,  0,   0,   44,
     255, 255, 255, 213, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 254, 30,  0,   0,   0,   0,   0,   204, 255, 252, 0,   159, 255, 255, 44,  0,   0,   0,   0,   74,  255, 255,
     123, 16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   152, 255, 255, 193, 0,   0,   0,   0,   0,   0,   240, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,
     92,  253, 255, 255, 241, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 96,  0,   0,   239, 255,
     255, 230, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   210, 255, 255, 239, 0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   91,  255, 255, 255, 156, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,
     0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,
     144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   134, 255, 255, 255, 69,  0,   0,   128, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   79,  255, 255,
     255, 115, 0,   0,   0,   0,   0,   204, 255, 252, 0,   104, 255, 255, 97,  0,   0,   0,   0,   127, 255, 255, 66,  16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   35,  252, 255, 255, 58,
     0,   0,   0,   0,   0,   240, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   158, 255, 255, 255, 90,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  255, 255, 255, 193, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   177, 255, 255,
     255, 28,  0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   40,  245, 255, 255, 199, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255,
     255, 86,  0,   0,   196, 255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  252, 255, 255, 192, 0,   0,   0,   0,   0,   204, 255, 252, 0,   48,  255, 255, 149, 0,   0,
     0,   0,   180, 255, 253, 12,  16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   0,   167, 255, 255, 179, 0,   0,   0,   0,   0,   240, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,   0,
     0,   0,   0,   0,   0,   0,   65,  255, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   0,   29,  119, 177, 222, 240, 252, 245, 233, 207, 174, 124, 67,  6,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   56,  255, 255, 255, 159, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255, 255, 63,  0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 5,   205, 255, 255,
     251, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,
     0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   117, 255, 255, 255, 72,  0,   0,   239, 255, 255, 230, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   210, 255, 255, 239, 0,   0,   0,   0,   0,   204, 255, 252, 0,   3,   245, 255, 201, 0,   0,   0,   0,   232, 255, 209, 0,   16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,
     0,   47,  255, 255, 254, 45,  0,   0,   0,   0,   240, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 175, 0,   0,   0,   0,   0,   0,
     19,  156, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 95,  0,   0,   0,   0,   0,   0,   0,   0,   69,  255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   131, 255, 255, 255, 77,  0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 136, 255, 255, 255, 255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   146, 255, 255, 255, 49,  0,   26,  255, 255, 255, 193, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   177, 255, 255, 255, 28,  0,   0,   0,   0,   204, 255, 252, 0,   0,
     193, 255, 248, 5,   0,   0,   29,  255, 255, 152, 0,   16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   0,   0,   182, 255, 255, 165, 0,   0,   0,   0,   240, 255, 255, 84,  0,   96,  255,
     255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   9,   255, 255, 255, 186, 0,   0,   0,   0,   0,   30,  219, 255, 255, 255, 255, 255, 255, 251, 255, 255, 255, 255, 255, 255, 255, 50,  0,
     0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   121, 255, 255, 255, 90,  0,   0,   0,   0,   0,   0,   0,   224, 255, 255,
     235, 253, 255, 255, 255, 255, 244, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216,
     255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   212, 255, 255, 242, 4,   0,   56,  255, 255, 255, 159, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255, 255, 63,  0,   0,   0,   0,   204, 255, 252, 0,   0,   138, 255, 255, 50,  0,   0,   82,  255, 255, 96,  0,   16,  255, 255, 204, 0,   92,
     255, 255, 212, 0,   0,   0,   0,   61,  255, 255, 252, 34,  0,   0,   0,   240, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   26,  255, 255, 255, 168, 0,
     0,   0,   0,   3,   203, 255, 255, 255, 192, 88,  31,  3,   0,   9,   37,  80,  142, 212, 255, 203, 0,   0,   0,   0,   0,   0,   0,   0,   0,   89,  255, 255, 255, 126, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 255, 255, 227, 117, 255, 255, 255, 185, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,
     0,   0,   0,   0,   0,   0,   77,  255, 255, 255, 170, 0,   0,   69,  255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 77,  0,   0,   0,   0,
     204, 255, 252, 0,   0,   82,  255, 255, 102, 0,   0,   135, 255, 255, 39,  0,   16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   0,   0,   0,   196, 255, 255, 151, 0,   0,   0,   240, 255,
     255, 84,  0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 255, 121, 0,   0,   0,   0,   88,  255, 255, 255, 141, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   45,  55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 90,  0,   0,   0,   0,   0,
     0,   0,   224, 255, 255, 255, 200, 24,  0,   166, 255, 255, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   58,  237, 255, 255, 254, 46,  0,   0,   81,  255, 255, 255,
     133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   121, 255, 255, 255, 90,  0,   0,   0,   0,   204, 255, 252, 0,   0,   27,  255, 255, 154, 0,   0,   188, 255, 237, 1,   0,   16,
     255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   0,   0,   0,   76,  255, 255, 247, 24,  0,   0,   240, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   179,
     255, 255, 255, 40,  0,   0,   0,   0,   170, 255, 255, 232, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 143,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 215, 8,   0,   0,   22,  237, 255, 255, 236, 21,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116,
     255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255,
     255, 255, 20,  0,   0,   2,   14,  39,  88,  172, 253, 255, 255, 255, 133, 0,   0,   0,   89,  255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255,
     100, 0,   0,   0,   0,   204, 255, 252, 0,   0,   0,   227, 255, 207, 0,   1,   239, 255, 182, 0,   0,   16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   0,   0,   0,   1,   210, 255, 255,
     137, 0,   0,   240, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   117, 255, 255, 255, 172, 0,   0,   0,   0,   0,   206, 255, 255, 176, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   147, 255, 255, 255, 62,
     0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   0,   96,  255, 255, 255, 167, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 32,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 150, 1,   0,   0,
     0,   80,  255, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 94,  0,   0,   0,   0,   204, 255, 252, 0,   0,   0,   172, 255, 250, 8,   37,  255,
     255, 125, 0,   0,   16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   0,   0,   0,   0,   90,  255, 255, 242, 16,  0,   240, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,   0,   0,   5,
     34,  92,  192, 255, 255, 255, 223, 22,  0,   0,   0,   0,   0,   217, 255, 255, 173, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     25,  255, 255, 255, 193, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   178, 255, 255, 255, 27,  0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   0,   0,   189,
     255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255,
     255, 255, 31,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,
     0,   0,   0,   144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 218, 83,  0,   0,   0,   0,   0,   68,  255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   131, 255, 255, 255, 84,  0,   0,   0,   0,   204, 255, 252, 0,   0,   0,   116, 255, 255, 55,  90,  255, 255, 69,  0,   0,   16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   0,   0,
     0,   0,   3,   222, 255, 255, 123, 0,   240, 255, 255, 84,  0,   96,  255, 255, 255, 250, 248, 248, 249, 255, 255, 255, 255, 255, 255, 202, 28,  0,   0,   0,   0,   0,   0,   198, 255, 255, 222,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   238, 255, 255, 229, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     212, 255, 255, 238, 0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   0,   0,   36,  247, 255, 255, 227, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   143, 255, 255, 255, 16,  0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 248, 248, 248, 247, 237, 221, 192, 138, 69,  1,
     0,   0,   0,   0,   0,   0,   55,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   147, 255, 255, 255, 64,  0,   0,   0,   0,   204, 255, 252, 0,   0,   0,   61,
     255, 255, 107, 143, 255, 253, 14,  0,   0,   16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 234, 9,   240, 255, 255, 84,  0,   96,  255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 221, 106, 3,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 255, 90,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  253, 255, 255, 191, 0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,
     0,   0,   0,   0,   0,   120, 255, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   174, 255, 255, 248, 0,   0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255,
     208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  255, 255, 255, 193, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   178, 255, 255, 255, 34,  0,   0,   0,   0,   204, 255, 252, 0,   0,   0,   9,   251, 255, 160, 196, 255, 211, 0,   0,   0,   16,  255, 255, 204, 0,   92,  255, 255,
     212, 0,   0,   0,   0,   0,   0,   0,   8,   232, 255, 255, 109, 240, 255, 255, 84,  0,   96,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   58,  255, 255, 255, 245, 89,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   126, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   82,  255, 255, 255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   0,   0,   0,   4,   209, 255, 255, 254, 59,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  240, 255, 255, 191, 0,   0,   116, 255, 255, 255, 52,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   238, 255, 255, 229, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   212, 255, 255, 246, 4,   0,   0,   0,   0,   204, 255,
     252, 0,   0,   0,   0,   206, 255, 219, 245, 255, 155, 0,   0,   0,   16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 225, 243, 255, 255, 84,
     0,   96,  255, 255, 255, 72,  0,   0,   0,   14,  233, 255, 255, 233, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   178, 255, 255, 255, 255, 190, 66,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   44,  255, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   183, 255, 255, 254, 27,  0,   0,   0,   0,   0,   0,   0,   0,
     224, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   54,  253, 255, 255, 215, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 111, 0,   0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   151, 248, 248, 248,
     248, 248, 254, 255, 255, 254, 248, 248, 248, 248, 248, 135, 0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 35,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  253, 255, 255, 196, 0,   0,   0,   0,   0,   204, 255, 252, 0,   0,   0,   0,   150, 255, 255, 255, 255, 98,  0,   0,   0,   16,  255, 255,
     204, 0,   92,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   14,  240, 255, 255, 255, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   102, 255, 255, 255, 147, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   19,  209, 255, 255, 255, 255, 255, 213, 118, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   203, 255, 255, 255, 97,
     0,   0,   0,   0,   0,   0,   0,   0,   62,  254, 255, 255, 174, 0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 131,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 254, 255, 255, 229, 10,  0,   0,   116, 255, 255,
     255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 140, 0,   144, 255, 255, 255,
     20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   126, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   82,  255, 255, 255, 129, 0,   0,
     0,   0,   0,   204, 255, 252, 0,   0,   0,   0,   95,  255, 255, 255, 255, 41,  0,   0,   0,   16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   134, 255,
     255, 255, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   2,   209, 255, 255, 252, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  167, 255, 255, 255, 255, 255, 255, 251,
     176, 71,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  255, 255, 255, 243, 61,  0,   0,   0,   0,   0,   0,   39,  227, 255, 255, 249, 36,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   12,  225, 255, 255, 250, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     84,  229, 150, 87,  40,  8,   0,   5,   34,  96,  200, 255, 255, 255, 251, 73,  0,   0,   0,   116, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 140, 0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     44,  255, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   183, 255, 255, 255, 42,  0,   0,   0,   0,   0,   204, 255, 252, 0,   0,   0,   0,   39,  255, 255, 255, 239, 1,   0,
     0,   0,   16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  247, 255, 255, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   66,
     255, 255, 255, 196, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   69,  200, 255, 255, 255, 255, 255, 255, 255, 204, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   157, 255, 255, 255, 250, 142, 46,  8,   6,   39,  126, 241, 255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   75,  255, 255, 255, 201, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 255, 255, 251, 255, 255, 255, 255, 255, 255, 248, 92,  0,   0,
     0,   0,   116, 255, 255, 255, 249, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 151, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   203, 255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,   62,  254, 255,
     255, 189, 0,   0,   0,   0,   0,   0,   204, 255, 252, 0,   0,   0,   0,   1,   238, 255, 255, 184, 0,   0,   0,   0,   16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   149, 255, 255, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   177, 255, 255, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     55,  154, 241, 255, 255, 255, 255, 255, 255, 157, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   181, 255, 255, 255, 255, 255, 255, 254, 255, 255, 255, 255, 255, 142, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   82,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 198, 47,  0,   0,   0,   0,   0,   116, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   63,  255, 255, 255, 243, 61,  0,   0,   0,   0,   0,   0,   39,  227, 255, 255, 253, 57,  0,   0,   0,   0,   0,   0,   204, 255, 252, 0,   0,   0,   0,   0,   184,
     255, 255, 128, 0,   0,   0,   0,   16,  255, 255, 204, 0,   92,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  251, 255, 255, 255, 84,  0,   96,  255, 255, 255, 72,  0,
     0,   0,   0,   0,   0,   37,  250, 255, 255, 232, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  93,  200, 255, 255, 255, 255, 255, 181, 1,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   4,   121, 246, 255, 255, 255, 255, 255, 255, 255, 255, 237, 91,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 196, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   23,  238, 255, 255, 244, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  140, 192, 224, 243, 252, 247, 230, 198, 138, 57,
     0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   157, 255, 255, 255, 250, 142, 46,  8,   6,   39,
     126, 241, 255, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 255, 145, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  195, 255, 255, 255, 255, 102, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  108, 185, 220, 244, 244, 219, 181,
     98,  15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   181, 255, 255, 255, 255, 255, 255, 254, 255, 255, 255, 255, 255, 162, 2,   0,   0,   0,   0,   4,   255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 244, 0,   27,  244, 255, 255, 207, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   198, 255, 255, 229, 13,  0,   96,
     255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   16,  235, 255, 255, 252, 46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   128, 255, 255, 255, 213,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   50,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 49,  0,   230,
     255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 231, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   121, 246, 255,
     255, 255, 255, 255, 255, 255, 255, 251, 118, 2,   0,   0,   0,   0,   0,   4,   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 244, 0,   0,   119,
     255, 255, 255, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 89,  0,   0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   106, 255, 255, 255, 194,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 255, 22,  0,   31,  248, 255, 255, 216, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   2,   214, 255, 255, 245, 25,  0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   0,   221, 255, 255,
     236, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  246, 255, 255, 220, 0,   0,   195, 255, 255, 141, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   132, 255, 255, 199, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  108, 185, 220, 244, 247, 243, 255, 255, 253, 46,  0,   0,   0,   0,   0,   0,   3,   248,
     248, 248, 248, 248, 248, 248, 248, 254, 255, 255, 254, 248, 248, 248, 248, 248, 248, 248, 236, 0,   0,   6,   217, 255, 255, 235, 16,  0,   0,   0,   0,   0,   0,   0,   0,   13,  230, 255, 255,
     190, 0,   0,   0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   3,   212, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   109, 255, 255, 255, 49,  0,   0,   144, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 133, 0,   0,   0,   0,   0,   0,   144, 255, 255,
     255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   0,   138, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255,
     255, 137, 0,   0,   160, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   159, 255, 255, 167, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  255, 255, 255, 191, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   70,  255, 255, 255, 146, 0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 250, 42,  0,   0,   0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   71,  255, 255, 255, 231, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 255, 47,  0,   0,   21,  242, 255, 255, 216, 3,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   3,   218, 255, 255, 236, 15,  0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144,
     0,   0,   54,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 52,  0,   0,   125, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   186, 255, 255, 134, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 140, 0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   177, 255, 255, 255, 127, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   174, 255, 255, 251, 43,  0,   0,   0,   0,   0,   0,
     38,  250, 255, 255, 139, 0,   0,   0,   0,   96,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   181, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   121, 255, 255, 255, 21,  0,   0,   0,   128, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  255, 255, 255, 114, 0,   0,   0,   0,   0,
     0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   0,   0,   225, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   3,   236, 255, 255, 223, 0,   0,   0,   90,  255, 255, 241, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   213, 255, 255, 102, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 140, 0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  245, 255, 255, 254, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  246, 255, 255, 188, 0,   0,   0,   0,   0,   0,   183, 255, 255, 228, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   211, 255, 255, 212, 0,   0,   0,   0,   13,  234, 255,
     255, 217, 3,   0,   0,   0,   0,   0,   0,   0,   0,   4,   221, 255, 255, 225, 7,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     32,  255, 255, 255, 144, 0,   0,   0,   142, 255, 255, 255, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 140, 0,   0,   0,   55,  255, 255, 255, 19,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   239, 255, 255, 70,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   151, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
     248, 248, 248, 252, 255, 255, 255, 125, 0,   244, 255, 255, 252, 248, 248, 248, 248, 248, 248, 89,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105,
     255, 255, 255, 254, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 255, 81,
     0,   0,   0,   0,   78,  255, 255, 255, 87,  0,   0,   0,   0,   0,   170, 255, 255, 205, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  99,  15,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   156, 255, 255, 255, 113, 0,   0,   0,   0,   0,   112, 255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 95,  0,
     0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   0,   0,   58,  255, 255, 255, 129, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 56,  0,   0,   0,   20,  255, 255, 255, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  255, 255, 255, 38,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   217, 255, 255, 227, 14,  0,   244, 255, 255, 156, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 164, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   220, 255, 255, 222, 8,   0,   0,   7,   220, 255, 255, 188, 0,   0,   0,   0,   0,   0,   62,  255, 255,
     255, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 248, 188, 122, 73,  33,  9,   0,   1,   15,  53,  119, 221, 255, 255, 255, 205, 4,   0,   0,
     0,   0,   0,   7,   224, 255, 255, 217, 3,   0,   0,   0,   0,   0,   0,   6,   224, 255, 255, 211, 2,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   0,   0,   1,   228, 255, 255, 209, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   223, 255, 255, 226, 1,   0,   0,   0,   0,   241, 255,
     255, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  255, 255, 254, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 74,  0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   3,   170, 255, 255, 255, 202, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   75,  255, 255, 255, 124, 0,   0,   122, 255, 255, 250, 40,  0,   0,   0,   0,   0,   0,   0,   209, 255, 255, 166, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   60,  255, 255, 255, 255, 255, 255, 255, 252, 254, 255, 255, 255, 255, 255, 255, 210, 21,  0,   0,   0,   0,   0,   0,   0,   96,  255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   105, 255,
     255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   0,   0,   0,   146, 255, 255,
     255, 34,  0,   0,   0,   0,   0,   0,   0,   0,   48,  255, 255, 255, 143, 0,   0,   0,   0,   0,   206, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,
     255, 255, 229, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  252, 255, 255, 160, 0,   0,   0,   244, 255, 255,
     156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   149, 255, 226, 24,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   179, 255, 255, 245, 28,  28,  244, 255, 255, 137, 0,   0,   0,   0,   0,
     0,   0,   0,   102, 255, 255, 249, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 244, 132,
     8,   0,   0,   0,   0,   0,   0,   0,   0,   2,   213, 255, 255, 218, 3,   0,   0,   0,   0,   7,   227, 255, 255, 194, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   0,   0,   0,   62,  255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 255, 59,  0,   0,
     0,   0,   0,   171, 255, 255, 153, 0,   0,   0,   0,   0,   206, 252, 252, 226, 0,   0,   0,   0,   0,   90,  255, 255, 197, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   213, 255, 255, 229, 16,  0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   34,  247, 255, 255, 167, 167, 255, 255, 227, 11,  0,   0,   0,   0,   0,   0,   0,   0,   10,  239, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   10,  79,  136, 181, 211, 235, 245, 253, 247, 232, 206, 158, 95,  12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 94,  0,   0,
     0,   0,   109, 255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   0,
     0,   0,   2,   231, 255, 255, 194, 0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 228, 1,   0,   0,   0,   0,   0,   136, 255, 255, 186, 0,   0,   0,   0,   23,  254, 255, 255, 255, 44,
     0,   0,   0,   0,   117, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   134, 255, 255, 255, 77,  0,   0,
     0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 255, 255, 255, 255, 255, 85,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 229, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   199, 255, 255, 218, 3,   0,   0,   9,   230, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   0,   0,   0,   0,   150, 255, 255, 252, 21,  0,   0,   0,   0,   0,   0,   32,  255, 255,
     255, 146, 0,   0,   0,   0,   0,   0,   101, 255, 255, 220, 0,   0,   0,   0,   91,  255, 255, 255, 255, 114, 0,   0,   0,   0,   144, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   51,  251, 255, 255, 164, 0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255,
     255, 255, 255, 255, 255, 255, 255, 248, 0,   186, 255, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   224, 255, 255, 255, 255, 186, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  254, 255, 255, 86,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   198, 255, 178, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,
     255, 255, 255, 95,  0,   0,   114, 255, 255, 252, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255,
     255, 255, 144, 0,   0,   0,   0,   0,   66,  255, 255, 255, 99,  0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   66,  255, 255, 250, 2,   0,   0,   0,   159,
     255, 234, 218, 255, 185, 0,   0,   0,   0,   171, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   211, 255, 255,
     232, 19,  0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 0,   36,  244, 255, 255, 254, 47,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255,
     255, 255, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   181, 255, 255, 194, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255,
     255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 219, 3,   10,  233, 255, 255, 157, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   0,   0,   0,   0,   3,   234, 255, 255, 179, 0,   0,   0,   0,
     0,   0,   192, 255, 255, 231, 2,   0,   0,   0,   0,   0,   0,   31,  255, 255, 255, 30,  0,   0,   0,   228, 255, 184, 166, 255, 246, 8,   0,   0,   0,   197, 255, 255, 68,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 255, 255, 82,  0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,
     0,   0,   85,  248, 248, 248, 248, 248, 248, 252, 255, 255, 248, 0,   0,   90,  255, 255, 255, 182, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255,
     255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   73,  255,
     255, 255, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   179, 255, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   49,  254, 255, 255, 95,  118, 255, 255, 247, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   32,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   154, 255, 255, 247, 11,  0,   0,   0,   0,   19,  252, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   2,   249, 255, 255,
     59,  0,   0,   41,  255, 255, 131, 113, 255, 255, 69,  0,   0,   0,   226, 255, 255, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     48,  250, 255, 255, 169, 0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   134,
     255, 255, 255, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   30,  246, 255, 255, 255, 255, 241, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   219, 255, 255, 155, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   42,  254, 255, 244, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 220, 235, 255, 255, 138, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   70,  255, 255,
     255, 83,  0,   0,   0,   0,   95,  255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   217, 255, 255, 89,  0,   0,   110, 255, 255, 73,  52,  255, 255, 140, 0,   0,   2,   251, 255, 253,
     5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   207, 255, 255, 234, 21,  0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   155, 255, 255, 216, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   170, 255, 255, 214, 246, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   113, 255, 255, 245, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   158, 255, 253, 68,  250, 255, 200, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  251, 255, 255, 255, 255, 239, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   4,   237, 255, 255, 164, 0,   0,   0,   0,   175, 255, 255, 233, 3,   0,   0,   0,   0,   0,   0,
     0,   0,   182, 255, 255, 119, 0,   0,   178, 255, 251, 14,  2,   239, 255, 210, 0,   0,   26,  255, 255, 227, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   125, 255, 255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255,
     248, 0,   0,   0,   0,   2,   154, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   63,  255, 255, 255, 64,  134, 255, 255, 254, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  244, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   26,  249, 255, 178, 0,   155, 255, 255, 79,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255,
     119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 144, 0,   0,   0,   0,
     0,   0,   0,   158, 255, 255, 239, 4,   0,   0,   9,   245, 255, 255, 153, 0,   0,   0,   0,   0,   0,   0,   0,   0,   147, 255, 255, 144, 0,   4,   242, 255, 198, 0,   0,   175, 255, 255, 25,
     0,   54,  255, 255, 195, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   44,  249, 255, 255, 173, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   102, 128, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   209, 255, 255, 175, 0,   14,  235, 255, 255, 201, 1,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   153, 255, 255, 220, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   138, 255, 255, 67,  0,   32,  250, 255, 210, 2,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  246, 255, 255, 234, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   141, 255,
     255, 255, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  255, 255, 255, 141, 0,   0,   0,   0,   0,   0,   0,   74,  255, 255, 255, 67,  0,   0,   77,  255, 255, 255, 68,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 168, 0,   60,  255, 255, 130, 0,   0,   103, 255, 255, 95,  0,   81,  255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   3,   203, 255, 255, 237, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 249, 36,  0,   0,   108, 255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   45,  255, 255, 255, 75,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  241, 255, 211, 0,   0,   0,   154, 255, 255, 91,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 255, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  255, 255, 255,
     127, 0,   0,   0,   0,   0,   0,   0,   6,   239, 255, 255, 144, 0,   0,   152, 255, 255, 236, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 192, 0,   127, 255, 255, 62,  0,
     0,   30,  255, 255, 165, 0,   108, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   121, 255, 255, 255, 91,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  237, 255, 255, 141, 0,   0,   0,   5,
     218, 255, 255, 232, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   117, 255, 255, 101, 0,   0,   0,   31,
     250, 255, 220, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   113, 255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   71,  255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   162, 255, 255, 215, 0,   0,   226, 255,
     255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  255, 255, 215, 0,   193, 255, 244, 5,   0,   0,   0,   213, 255, 232, 1,   135, 255, 255, 98,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  248, 255, 255, 178, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   150, 255, 255, 236, 16,  0,   0,   0,   0,   82,  255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,
     255, 255, 254, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   228, 255, 237, 9,   0,   0,   0,   0,   153, 255, 255, 102, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   117, 255, 255, 255, 70,  0,   0,   0,   0,   0,   0,   0,   0,   78,  255, 255, 255, 28,  44,  255, 255, 255, 71,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   254, 255, 236, 9,
     249, 255, 182, 0,   0,   0,   0,   140, 255, 255, 45,  160, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   200, 255, 255, 239, 26,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  252, 255, 255, 107,
     0,   0,   0,   0,   0,   0,   197, 255, 255, 250, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   227, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  255, 255, 135,
     0,   0,   0,   0,   0,   30,  249, 255, 227, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   23,  255, 255, 255, 185, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   194, 255, 255, 254, 15,  0,   0,   0,   0,   0,   0,   0,   0,   7,   242, 255,
     255, 92,  112, 255, 255, 238, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 253, 66,  255, 255, 114, 0,   0,   0,   0,   67,  255, 255, 109, 186, 255, 255, 33,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 213, 4,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 183, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   124, 255, 255, 240, 11,  0,   0,   0,   0,   0,   0,   0,   1,   213, 255, 251, 28,  0,   0,   0,   0,   0,   0,   152, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   203, 255, 255, 253, 52,  0,   0,   0,
     0,   0,   0,   0,   0,   55,  254, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 153, 174, 255, 255, 159, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   193, 255, 255, 134, 255, 255, 46,  0,   0,   0,   0,   6,   243, 255, 169, 210, 255, 252, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  246, 255,
     255, 182, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   87,
     255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   171, 255, 255, 255, 78,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  249, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,
     77,  255, 255, 169, 0,   0,   0,   0,   0,   0,   0,   30,  249, 255, 234, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   99,  255, 255, 255, 219, 27,  0,   0,   0,   0,   0,   0,   24,  218, 255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   82,  255, 255, 214, 235, 255, 255, 75,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   158, 255, 255, 199, 255, 233, 1,   0,   0,   0,   0,   0,   177, 255, 222, 233,
     255, 225, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   196, 255, 255, 241, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255,
     255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  226, 255, 255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  250, 255, 255, 220,
     7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 211, 0,   0,   0,   0,   0,   0,   0,   194, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   0,   151, 255, 255, 125, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   201, 255,
     255, 255, 236, 118, 38,  5,   3,   31,  109, 233, 255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   244, 255, 255, 255, 255, 240, 6,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   123, 255, 255, 250, 255, 166, 0,   0,   0,   0,   0,   0,   104, 255, 254, 252, 255, 192, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   111, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   130, 255, 255, 252, 42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255, 255, 121, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 64,  0,
     0,   0,   0,   0,   55,  255, 255, 203, 0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  249, 255, 240, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216,
     255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  224, 255, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 200, 17,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   170, 255, 255, 255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 255, 98,  0,   0,   0,   0,   0,
     0,   31,  255, 255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  245, 255, 255, 186, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  247, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   20,  240, 255, 255, 243, 26,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   203, 255, 255, 172, 0,   0,   0,   0,   0,   174, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   150, 255, 255, 137, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   25,  180, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 150, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  255, 255, 255, 255, 78,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,  255, 255, 255, 255, 30,  0,   0,   0,   0,   0,   0,   0,   214, 255, 255, 255, 128, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   1,   192, 255, 255, 243, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 204, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   173, 255, 255, 240, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 255, 165, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     95,  255, 255, 252, 28,  0,   0,   0,   38,  253, 255, 231, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  248, 255, 245, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,  137, 200, 230, 248, 244, 225, 187, 122, 32,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  246, 255, 255, 242, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  255, 255, 255, 218, 0,
     0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   235, 255, 255, 133, 0,   0,   0,   153, 255, 255, 127, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   2,   243, 255, 255, 255, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 236, 0,   244, 255, 255, 156, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  99,  161, 209, 236, 251, 244, 229, 190, 137, 47,
     0,   0,   0,   0,   0,   236, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   135, 255, 255, 233, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
     248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 69,  0,   0,   0,   0,   0,   0,   0,   56,  131, 193, 224, 243, 251, 241, 217, 184, 133, 70,  6,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  186, 244, 188, 16,  0,   0,   0,   4,   255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 244, 0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   62,  176, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 165, 13,  0,   0,   0,   236, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  252, 255, 255, 93,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   64,  154, 207, 236, 250, 243, 226, 200, 148, 73,  0,   0,   0,   0,   0,   0,   0,   0,   72,  152, 212, 236, 249, 230, 195, 125, 31,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   54,
     194, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 137, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 236, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   106, 255, 255, 255, 113, 0,   0,   0,   4,   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 244, 0,   244, 255, 255, 156,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   143, 255, 255, 255, 255, 255, 255, 252,
     255, 255, 255, 255, 255, 255, 186, 1,   0,   0,   236, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 255, 201, 0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  177, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 0,   0,
     0,   0,   0,   0,   47,  198, 255, 255, 255, 255, 255, 255, 255, 255, 248, 135, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   0,   0,   0,   102, 249, 255, 255, 255, 255, 255, 255, 252, 255, 255, 255, 255, 255, 39,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   136, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255,
     255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  250, 252, 187, 112, 57,  15,  0,   4,   45,  142, 252, 255, 255, 255, 84,  0,   0,   236, 255, 255, 144, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   67,  255, 255, 255, 52,
     0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 255, 255, 255, 253, 254, 255, 255, 255, 61,  0,   0,   0,   0,   0,   68,  243, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 180,
     6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   84,  255, 255, 255, 255, 201, 96,  34,  7,   0,   14,  54,  115, 190, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 236, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 255, 112, 0,   0,   0,   224, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  26,
     0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 255, 176, 0,   0,   236, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   213, 255, 255, 161, 0,   0,   0,   0,   0,   0,   0,   43,  255, 255, 255, 236, 97,  24,  1,   3,   19,
     55,  104, 4,   0,   0,   0,   0,   40,  246, 255, 255, 245, 135, 48,  7,   1,   23,  90,  213, 255, 255, 255, 145, 0,   0,   0,   0,   0,   0,   0,   0,   0,   39,  139, 201, 234, 252, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  242, 255, 255, 253, 109, 0,   0,   0,   0,   0,   0,   0,   0,   0,   3,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  186, 245, 188, 15,  0,   0,
     0,   224, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   205, 255, 255, 232, 0,   0,   236, 255,
     255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   121, 255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   204, 255, 255, 239, 48,  0,   0,   0,   0,   0,
     0,   10,  194, 255, 255, 255, 51,  0,   0,   0,   0,   0,   0,   5,   145, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   140, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     164, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   244, 255, 255, 252, 248, 248, 248, 248, 248, 248, 89,  0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 253, 1,   0,   236, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   33,  204, 243, 165, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 241, 1,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 91,  0,   0,   0,   0,   0,   0,   0,   0,   36,  253, 255, 255, 169, 0,   0,   0,   0,   0,   0,   168, 255, 255, 255,
     255, 255, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   241, 255, 255, 227, 4,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   224, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,
     0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255,
     255, 11,  0,   236, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   150, 255, 255, 255, 70,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   187, 255, 255, 210, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   181, 255, 255, 225, 2,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 243, 4,   0,   0,   0,   0,   90,  255, 255, 255, 220, 86,  17,  0,   13,  77,  208, 255, 255, 255, 159, 89,  53,  17,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  255, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   164, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 12,  0,   236, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   180, 255, 255, 255, 99,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   243, 255, 255, 153, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 255, 52,  0,   0,   0,   0,
     207, 255, 255, 232, 22,  0,   0,   0,   0,   0,   11,  216, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 71,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   163, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  93,  159, 199, 230, 243, 253, 255,
     255, 255, 255, 255, 255, 255, 12,  0,   236, 255, 255, 144, 0,   1,   81,  168, 221, 245, 241, 214, 148, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255,
     61,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   201, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  255,
     255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 79,  0,   0,   0,   23,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   98,  255, 255, 253, 25,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   136, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     51,  147, 214, 241, 244, 219, 162, 72,  0,   0,   155, 255, 255, 236, 0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 172, 0,   0,   0,   224, 255, 255, 156, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   139, 246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 12,  0,   236, 255, 255, 144, 28,  192, 255, 255, 255,
     255, 255, 255, 255, 254, 151, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  205, 242, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115,
     149, 177, 206, 234, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   0,   76,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     98,  0,   0,   0,   64,  255, 255, 255, 63,  0,   0,   0,   0,   0,   0,   0,   38,  255, 255, 255, 78,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   154, 255,
     255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   148, 254, 255, 255, 255, 255, 255, 255, 255, 180, 22,  137, 255, 255, 236, 0,   0,   0,
     20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 172, 0,   0,   0,   224, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  202, 255, 255, 255, 255,
     255, 255, 255, 254, 248, 248, 248, 251, 255, 255, 255, 12,  0,   236, 255, 255, 162, 214, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 174, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100,
     0,   0,   0,   93,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 104, 0,   0,   0,   81,  255, 255, 255, 43,  0,   0,   0,   0,   0,   0,   0,   20,
     255, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   157, 255, 255, 255, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   3,   171, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 208, 133, 255, 255, 236, 0,   0,   0,   19,  248, 248, 248, 248, 248, 248, 248, 248, 255, 255, 255, 172, 0,   0,   0,   224,
     255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 253, 174, 92,  41,  12,  1,   0,   0,   0,   120, 255, 255, 255, 12,  0,   236, 255, 255, 255,
     255, 248, 138, 48,  8,   2,   30,  116, 242, 255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   236, 248, 248, 248, 248, 248, 254, 255, 255, 254, 248, 248, 248, 248, 248, 248, 248, 96,  0,   0,   0,   97,  255, 255, 255, 250, 248, 248, 248, 248, 248, 248, 248, 248, 248,
     248, 248, 248, 248, 248, 100, 0,   0,   0,   65,  255, 255, 255, 57,  0,   0,   0,   0,   0,   0,   0,   35,  255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 255, 255, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 240, 112, 28,  1,   10,  57,  157, 254, 255, 255, 255,
     255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 156, 0,   0,   51,  144, 210, 235, 250, 234, 196, 131, 27,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  247,
     255, 255, 251, 73,  0,   0,   0,   0,   0,   0,   0,   0,   121, 255, 255, 255, 12,  0,   236, 255, 255, 255, 248, 63,  0,   0,   0,   0,   0,   0,   44,  240, 255, 255, 243, 20,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   78,  255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  255, 255, 255, 114, 0,   0,   0,
     0,   0,   0,   0,   92,  255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   118, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   20,  243, 255, 255, 240, 42,  0,   0,   0,   0,   0,   0,   91,  255, 255, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255,
     172, 0,   0,   0,   224, 255, 255, 156, 7,   146, 254, 255, 255, 255, 255, 255, 255, 255, 249, 105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   85,
     248, 248, 248, 248, 248, 248, 252, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   65,  255, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 12,
     0,   236, 255, 255, 255, 141, 0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 255, 111, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  255, 255, 255, 118, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   201, 255, 255, 226, 19,  0,   0,   0,   0,   0,   9,   211, 255, 255, 242, 6,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 122, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 109, 0,   0,   0,   0,   0,   0,
     0,   0,   169, 255, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 156, 162, 255, 255, 255, 255, 253, 255, 255, 255,
     255, 255, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   86,  255, 255, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 12,  0,   236, 255, 255, 255, 44,  0,   0,   0,   0,   0,   0,   0,   0,   10,  246, 255,
     255, 197, 0,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255,
     255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   246, 255, 255, 165, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   87,  255,
     255, 255, 219, 90,  24,  3,   18,  78,  206, 255, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   248, 255, 255, 216, 1,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   198, 255, 255, 245, 9,   0,   0,   0,   0,   0,   0,   0,   0,   66,  255, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 238, 255, 255, 200, 83,  20,  1,   9,   64,  186, 255, 255, 255, 240, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   74,  255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   60,
     255, 255, 255, 255, 12,  0,   236, 255, 255, 237, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   183, 255, 255, 246, 3,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     236, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   159, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 199, 8,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   247, 255, 255, 182, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   4,   248, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 255, 255, 153, 1,   0,
     0,   0,   0,   0,   2,   173, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   30,  255, 255, 255, 196, 2,   0,   0,   0,   0,   0,   0,   49,  232, 255, 255, 255, 255, 12,  0,   236, 255, 255, 199, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   141, 255, 255, 255, 39,  0,   0,   0,   87,  145, 165, 186, 206, 237, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   74,  255, 255, 255, 118, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   6,   131, 250, 255, 255, 255, 255, 255, 255, 255, 255, 169, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  249, 255,
     255, 248, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   11,  0,   41,  255, 255, 255, 138, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   214, 255, 255, 236, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 255, 210, 4,   0,   0,   0,   0,   0,   0,   0,   33,  254, 255, 255, 162, 0,   204, 255, 255, 144, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   201, 255, 255, 255, 178, 56,  13,  0,
     15,  64,  153, 250, 255, 217, 255, 255, 255, 12,  0,   236, 255, 255, 178, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   196, 255, 255, 250, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  21,  0,   0,   0,   0,   0,   0,   0,   69,  234, 255, 245, 233, 245, 232, 204, 146, 51,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 255, 255, 182, 84,  25,  3,   0,   11,  43,  89,  150, 228, 92,  0,   62,  255,
     255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   189, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255,
     255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 200, 0,   204, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   62,  251, 255, 255, 255, 255, 255, 252, 255, 255, 255, 255, 196, 24,  253, 255, 255, 12,  0,   236, 255, 255, 168, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   101, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  233, 255, 255, 254, 176, 78,  22,  2,   0,   10,  38,  77,  135,
     203, 255, 60,  0,   0,   0,   0,   0,   0,   74,  251, 255, 212, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   124, 254, 255, 255, 255, 255, 255, 254, 252, 255, 255, 255, 255, 255, 92,  0,   76,  255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   178, 255, 255, 236,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 253, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   186, 255, 255, 217, 0,   204,
     255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  243,
     255, 255, 255, 255, 255, 255, 255, 255, 168, 11,  0,   214, 255, 255, 12,  0,   236, 255, 255, 169, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 255, 255, 255, 71,  0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   45,  223, 255, 255, 255, 255, 255, 253, 253, 255, 255, 255, 255, 255, 255, 60,  0,   0,   0,   0,   0,   4,   226, 255, 255, 41,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  211, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 85,  0,   77,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,
     0,   0,   224, 255, 255, 219, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   204, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  132, 203, 240, 251, 234, 211, 148, 61,  0,   0,   0,   159, 255, 255, 12,  0,   236,
     255, 255, 179, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 57,  0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  157, 251, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 221, 38,  0,   0,   0,   0,   0,   38,  255, 255, 248, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   72,  143, 203, 229, 248, 251, 240, 214, 177, 120, 43,  0,   0,   63,  255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   180, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 192, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176,
     255, 255, 224, 0,   204, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255,
     36,  0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  118, 185, 224, 244, 251, 240, 216, 178, 124, 56,  0,   0,   0,   0,   0,   0,   0,   29,  255, 255, 255,
     149, 35,  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   44,  255, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   194, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 179, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   204, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 255, 255, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   236, 255, 255, 242, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   187, 255, 255, 243, 2,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 32,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 255, 255, 254, 248, 248, 248, 247, 235, 212, 162, 75,  1,   0,   0,   0,   52,  255,
     255, 92,  0,   28,  167, 236, 233, 173, 39,  0,   0,   0,   98,  210, 247, 226, 146, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   249, 255, 255, 179, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   231, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   176, 255, 255, 224, 0,   204, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 255, 255, 255, 255,
     248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,
     12,  248, 255, 255, 192, 0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 20,  0,   0,   51,  144, 210, 235, 250, 234, 196, 131, 27,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   21,  201, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 19,  0,   0,   52,  255, 255, 133, 20,  220, 255, 255, 255, 255, 235, 31,  0,   133, 255, 255, 255, 255, 255,
     207, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   201, 255, 255, 243, 7,   0,   0,   0,   0,   0,   0,   0,   0,   34,  255, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   204, 255, 255, 144, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   102, 140, 161, 181, 202, 240, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 255, 159, 0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255,
     255, 61,  7,   145, 254, 255, 255, 255, 255, 255, 255, 255, 249, 105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     197, 1,   0,   52,  255, 255, 174, 149, 255, 255, 255, 255, 255, 255, 168, 58,  255, 255, 254, 255, 255, 255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255,
     255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 176, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   204, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 255, 253, 81,  0,   0,
     0,   0,   0,   0,   45,  242, 255, 255, 241, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 102, 160, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 255, 94,  0,   0,
     0,   0,   0,   0,   0,   158, 255, 255, 223, 97,  30,  5,   0,   0,   0,   0,   7,   26,  70,  181, 255, 255, 255, 78,  0,   52,  255, 255, 239, 249, 127, 12,  18,  178, 255, 255, 249, 206, 245,
     89,  6,   29,  209, 255, 255, 197, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  246, 255, 255, 239, 41,  0,   0,   0,   0,   0,   0,   55,  246, 255, 255, 255, 236, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   204, 255, 255,
     144, 0,   0,   0,   0,   0,   0,   0,   0,   2,   163, 255, 255, 255, 166, 3,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 255, 255, 252, 150, 53,  8,   1,   28,  114, 241, 255, 255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   224, 255, 255, 229, 255, 255, 200, 83,  20,  1,   9,   64,  186, 255, 255, 255, 240, 12,  0,   0,   0,   0,   0,   99,  255, 255, 232, 23,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   5,   224, 255, 255, 150, 0,   52,  255, 255, 255, 184, 0,   0,   0,   23,  250, 255, 255, 255, 114, 0,   0,   0,   78,  255, 255, 250, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   121, 255, 255, 255, 240, 114, 29,  2,   6,   45,  132, 245, 255, 255, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,
     224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   204, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   1,   159, 255, 255, 255, 163, 3,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255,
     90,  210, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 169, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 255, 255, 153, 1,   0,   0,   0,   0,   0,   2,   173,
     255, 255, 255, 100, 0,   0,   0,   0,   0,   204, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   171, 255, 255, 176, 0,   52,  255, 255, 255, 98,  0,   0,   0,   0,
     198, 255, 255, 253, 17,  0,   0,   0,   21,  255, 255, 255, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   178, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 211, 119,
     255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255,
     224, 0,   204, 255, 255, 144, 0,   0,   0,   0,   0,   0,   1,   155, 255, 255, 255, 160, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 253, 14,  23,  182, 255, 255, 255, 255, 255, 255, 255, 253, 148, 4,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 255, 210, 4,   0,   0,   0,   0,   0,   0,   0,   33,  254, 255, 255, 162, 0,   0,   0,   0,   0,   249, 255, 255, 94,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   187, 255, 255, 163, 0,   52,  255, 255, 255, 52,  0,   0,   0,   0,   161, 255, 255, 215, 0,   0,   0,   0,   0,   250, 255, 255, 50,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   155, 254, 255, 255, 255, 255, 255, 255, 255, 185, 24,  56,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255,
     255, 172, 0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   204, 255, 255, 144, 0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 157,
     2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   236, 255, 206, 0,   0,   0,   73,  164, 220, 245, 242, 215, 148, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 32,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 255, 92,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   216, 255, 255, 200, 0,   0,   0,   0,   0,   248, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  248, 255, 255, 127, 0,   52,  255, 255, 255,
     24,  0,   0,   0,   0,   145, 255, 255, 183, 0,   0,   0,   0,   0,   240, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  150, 215, 242, 245, 220,
     165, 76,  0,   0,   12,  254, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   176, 255, 255, 224, 0,   204, 255, 255, 144, 0,   0,   0,   0,   0,   147, 255, 255, 255, 154, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196,
     255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 253, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   186, 255, 255, 217, 0,   0,   0,   0,   0,   210, 255, 255,
     219, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  206, 255, 255, 255, 44,  0,   52,  255, 255, 255, 6,   0,   0,   0,   0,   140, 255, 255, 163, 0,   0,   0,   0,   0,   236, 255, 255,
     64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   204, 255, 255, 144, 0,   0,   0,   0,   143, 255,
     255, 255, 151, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 253, 7,   0,   0,   29,  137, 208, 241,
     241, 214, 148, 52,  0,   0,   0,   0,   0,   0,   216, 255, 255, 25,  0,   0,   5,   80,  172, 216, 242, 248, 234, 213, 173, 86,  0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 32,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 219,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   0,   0,   0,   0,   117, 255, 255, 255, 223, 106, 39,  5,   0,   0,   11,  41,  89,  163, 248, 255, 255, 255, 159, 0,
     0,   52,  255, 255, 254, 0,   0,   0,   0,   0,   140, 255, 255, 155, 0,   0,   0,   0,   0,   236, 255, 255, 64,  0,   0,   0,   0,   0,   0,   16,  104, 178, 222, 244, 244, 221, 173, 95,  8,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 172, 0,   0,   0,   224, 255, 255, 176, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   204, 255, 255, 144, 0,   0,   0,   138, 255, 255, 255, 148, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 39,  0,   84,  247, 255, 255, 255, 255, 255, 255, 254, 151, 6,   0,   0,   0,   0,   216, 255, 255, 52,  0,   40,  212,
     255, 255, 255, 255, 255, 255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   51,  147, 214, 241, 241,
     207, 132, 24,  0,   0,   7,   253, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 192, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   0,   0,
     0,   0,   5,   198, 255, 255, 255, 255, 255, 255, 250, 254, 255, 255, 255, 255, 255, 255, 255, 182, 12,  0,   0,   52,  255, 255, 249, 0,   0,   0,   0,   0,   140, 255, 255, 152, 0,   0,   0,
     0,   0,   236, 255, 255, 64,  0,   0,   0,   0,   0,   107, 236, 255, 255, 255, 255, 255, 255, 255, 255, 224, 79,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   229, 255, 255, 168, 0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   204, 255, 255, 144, 0,
     0,   133, 255, 255, 255, 145, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 73,  83,
     254, 255, 255, 255, 253, 255, 255, 255, 255, 255, 174, 3,   0,   0,   0,   216, 255, 255, 80,  43,  237, 255, 255, 255, 255, 253, 255, 255, 255, 255, 31,  0,   24,  156, 156, 156, 156, 156, 156,
     199, 255, 255, 255, 168, 156, 156, 156, 156, 156, 156, 0,   0,   0,   0,   5,   148, 254, 255, 255, 255, 255, 255, 255, 243, 75,  0,   39,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   224, 255, 255, 179, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   0,   0,   0,   0,   0,   11,  156, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     229, 107, 3,   0,   0,   0,   52,  255, 255, 248, 0,   0,   0,   0,   0,   140, 255, 255, 152, 0,   0,   0,   0,   0,   236, 255, 255, 64,  0,   0,   0,   3,   154, 255, 255, 255, 255, 255, 254,
     255, 255, 255, 255, 255, 254, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   246, 255, 255, 149, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 144, 0,   110, 255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 131, 236, 244, 131, 45,  7,   2,   30,  117, 242, 255, 255, 255, 115, 0,   0,   0,   216, 255,
     255, 123, 222, 255, 234, 122, 46,  9,   1,   24,  59,  131, 171, 0,   0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   3,   171, 255,
     255, 255, 255, 255, 253, 255, 255, 255, 252, 75,  73,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255,
     255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   36,  121, 182, 223, 242, 252, 247, 236, 216, 179, 135, 64,  4,   0,   0,   0,   0,   0,   52,  255, 255, 248, 0,   0,   0,   0,   0,   140, 255,
     255, 152, 0,   0,   0,   0,   0,   236, 255, 255, 64,  0,   0,   0,   132, 255, 255, 255, 230, 109, 33,  4,   5,   37,  116, 236, 255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255, 255, 111, 0,   0,   0,   0,   0,   0,   0,   25,  112, 179, 222, 242, 252, 242, 225, 189, 143, 78,  10,  0,   0,   0,
     204, 255, 255, 144, 77,  253, 255, 255, 194, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,
     236, 255, 255, 255, 245, 53,  0,   0,   0,   0,   0,   0,   45,  240, 255, 255, 243, 20,  0,   0,   216, 255, 255, 252, 255, 194, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   114, 255, 255, 255, 240, 112, 28,  1,   10,  57,  157, 254, 233, 130, 255, 255, 236, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 248, 0,   0,   0,   0,   0,   140, 255, 255, 152, 0,   0,   0,   0,   0,   236, 255, 255, 64,  0,   0,   55,  253, 255, 255,
     207, 18,  0,   0,   0,   0,   0,   0,   24,  215, 255, 255, 243, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  204, 255, 255, 255, 39,
     0,   0,   0,   0,   0,   1,   126, 246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 242, 103, 0,   0,   204, 255, 255, 192, 244, 255, 255, 255, 255, 86,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255,
     111, 0,   0,   216, 255, 255, 255, 225, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   20,  243, 255, 255, 240, 42,  0,   0,   0,   0,   0,   0,   91,  255, 255, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   176, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   180, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 248, 0,   0,
     0,   0,   0,   140, 255, 255, 152, 0,   0,   0,   0,   0,   236, 255, 255, 64,  0,   0,   176, 255, 255, 248, 35,  0,   0,   0,   0,   0,   0,   0,   0,   45,  252, 255, 255, 150, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   65,  144, 88,  41,  21,  5,   0,   21,  89,  215, 255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 255, 255, 252, 255, 255, 255, 255,
     255, 255, 67,  0,   0,   204, 255, 255, 255, 255, 255, 253, 255, 255, 245, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,
     0,   0,   0,   0,   0,   236, 255, 255, 255, 34,  0,   0,   0,   0,   0,   0,   0,   0,   10,  246, 255, 255, 197, 0,   0,   216, 255, 255, 255, 102, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   0,   111, 255, 255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   0,   169, 255, 255,
     255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   3,   241, 255,
     124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 248, 0,   0,   0,   0,   0,   140, 255, 255, 152, 0,   0,   0,   0,   0,   236, 255, 255, 64,  0,
     26,  253, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 246, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 252, 255, 255, 255,
     255, 255, 221, 22,  0,   0,   0,   0,   0,   64,  255, 255, 255, 211, 89,  27,  1,   0,   12,  50,  102, 170, 243, 217, 1,   0,   0,   204, 255, 255, 255, 239, 98,  74,  253, 255, 255, 224, 21,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 232, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 246, 3,   0,   216, 255, 255, 254, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     176, 255, 255, 224, 0,   0,   198, 255, 255, 245, 9,   0,   0,   0,   0,   0,   0,   0,   0,   66,  255, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   54,  255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,
     255, 255, 248, 0,   0,   0,   0,   0,   140, 255, 255, 152, 0,   0,   0,   0,   0,   236, 255, 255, 64,  0,   88,  255, 255, 255, 78,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   89,  255,
     255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 25,  0,   0,   0,   0,   0,   0,   149, 255, 255, 233, 14,  0,   0,   0,
     0,   0,   0,   0,   0,   9,   39,  0,   0,   0,   204, 255, 255, 216, 25,  0,   0,   115, 255, 255, 255, 193, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255,
     255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 197, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 255, 39,  0,   216, 255, 255, 217, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   4,   247, 255, 255, 182, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   4,   248, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   0,   0,   0,   0,
     0,   0,   119, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 248, 0,   0,   0,   0,   0,   140, 255, 255, 152, 0,   0,   0,   0,   0,
     236, 255, 255, 64,  0,   142, 255, 255, 255, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   39,  255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  124, 175, 215, 231,
     245, 251, 236, 204, 147, 56,  0,   0,   0,   0,   0,   0,   0,   0,   177, 255, 255, 186, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 184, 0,   0,   0,
     0,   160, 255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 183, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 58,  0,   216, 255, 255, 194, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   41,  255, 255, 255, 138, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   214, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   224,
     255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   52,  255, 255, 248, 0,   0,   0,   0,   0,   140, 255, 255, 152, 0,   0,   0,   0,   0,   236, 255, 255, 64,  0,   167, 255, 255, 253, 1,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   7,   255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   161, 255, 255,
     234, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 184, 0,   0,   0,   0,   7,   198, 255, 255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 255, 255, 255, 72,  0,   216, 255, 255, 184,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   62,  255, 255, 255, 109, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   189, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224,
     0,   0,   0,   0,   0,   0,   8,   244, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 248, 0,   0,   0,   0,   0,   140, 255, 255, 152,
     0,   0,   0,   0,   0,   236, 255, 255, 64,  0,   184, 255, 255, 241, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   250, 255, 255, 175, 0,   53,  255, 255, 255, 117, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 255, 255, 44,  0,   0,   0,   0,   0,   89,  255, 255, 255, 192, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255,
     255, 184, 0,   0,   0,   0,   0,   23,  226, 255, 255, 250, 63,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255,
     255, 181, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 255, 255, 255, 71,  0,   216, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   76,  255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   178, 255, 255, 236, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   6,   55,  105, 155, 205, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 12,  0,   0,   0,   0,   0,   0,   52,  255, 255, 248, 0,   0,   0,   0,   0,   140, 255, 255, 152, 0,   0,   0,   0,   0,   236, 255, 255, 64,  0,   183, 255, 255, 242, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   251, 255, 255, 174, 0,   0,   214, 255, 255, 209, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   221, 255, 255, 205, 0,   0,   0,   0,
     0,   0,   4,   204, 255, 255, 255, 251, 168, 65,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 184, 0,   0,   0,   0,   0,   0,   49,  245, 255, 255, 235, 32,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 191, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 57,
     0,   216, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   77,  255,
     255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   176, 255, 255, 224, 0,   72,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   52,  255, 255, 248, 0,   0,   0,   0,
     0,   140, 255, 255, 152, 0,   0,   0,   0,   0,   236, 255, 255, 64,  0,   165, 255, 255, 254, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 156, 0,   0,   120, 255,
     255, 255, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 111, 0,   0,   0,   0,   0,   0,   0,   20,  190, 255, 255, 255, 255, 255, 225, 130, 32,  0,   0,   0,   0,
     0,   0,   0,   204, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   84,  254, 255, 255, 208, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,
     0,   0,   0,   236, 255, 255, 216, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 36,  0,   216, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   63,  255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   180, 255, 255, 236,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   69,  248, 248, 248, 248, 248, 255, 255, 255, 251, 248,
     248, 248, 248, 248, 248, 248, 248, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 255,
     255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  255, 255, 255, 130, 0,   0,   28,  253, 255, 255, 137, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 250,
     21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   89,  214, 255, 255, 255, 255, 255, 254, 177, 54,  0,   0,   0,   0,   0,   204, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   128, 255,
     255, 255, 171, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 250, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     187, 255, 255, 243, 2,   0,   216, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255,
     255, 224, 0,   44,  255, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   194, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   247, 255, 255, 46,  0,   0,   0,
     0,   0,   2,   242, 255, 255, 252, 10,  0,   0,   0,   0,   0,   24,  255, 255, 246, 3,   0,   0,   79,  255, 255, 255, 82,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   91,  255, 255, 255,
     74,  0,   0,   0,   187, 255, 255, 226, 1,   0,   0,   0,   0,   0,   0,   0,   0,   4,   235, 255, 255, 178, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   75,  178, 252, 255, 255,
     255, 255, 254, 159, 11,  0,   0,   0,   204, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   1,   172, 255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248,
     0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 255, 66,  0,   0,   0,   0,   0,   0,   0,   0,   11,  248, 255, 255, 192, 0,   0,   216, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 224, 0,   5,   249, 255, 255, 179, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   231, 255, 255, 236, 0,   0,   92,  255, 255, 255, 171, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 91,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,
     255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 90,  0,   0,   0,   0,   0,   46,  255, 255, 255, 255, 61,  0,   0,   0,   0,   0,   71,  255, 255, 198,
     0,   0,   0,   17,  248, 255, 255, 165, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   174, 255, 255, 249, 16,  0,   0,   0,   92,  255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,
     76,  255, 255, 255, 83,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  117, 219, 255, 255, 255, 255, 202, 9,   0,   0,   204, 255, 255, 184, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   11,  207, 255, 255, 254, 80,  0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 255, 168, 0,   0,   0,   0,
     0,   0,   0,   0,   113, 255, 255, 255, 105, 0,   0,   216, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   176, 255, 255, 224, 0,   0,   201, 255, 255, 243, 7,   0,   0,   0,   0,   0,   0,   0,   0,   34,  255, 255, 255, 236, 0,   0,   0,   165, 255, 255, 255, 92,  0,   0,   0,   0,
     0,   0,   0,   0,   93,  255, 255, 255, 163, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255,
     255, 135, 0,   0,   0,   0,   0,   104, 255, 255, 255, 255, 116, 0,   0,   0,   0,   0,   118, 255, 255, 147, 0,   0,   0,   0,   158, 255, 255, 250, 40,  0,   0,   0,   0,   0,   0,   0,   0,
     46,  252, 255, 255, 159, 0,   0,   0,   0,   10,  243, 255, 255, 157, 0,   0,   0,   0,   0,   0,   0,   0,   167, 255, 255, 238, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   1,   84,  224, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 255, 254, 87,  0,   0,   0,   0,   0,   0,   43,  241, 255, 255, 241, 17,  0,   0,   216, 255, 255, 184, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   179, 255, 255, 224, 0,   0,   116, 255, 255, 255, 106, 0,   0,   0,
     0,   0,   0,   0,   0,   131, 255, 255, 255, 236, 0,   0,   0,   14,  223, 255, 255, 240, 29,  0,   0,   0,   0,   0,   0,   29,  240, 255, 255, 221, 13,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   20,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   99,  255, 255, 180, 0,   0,   0,   0,   0,   161, 255, 230, 248, 255, 171, 0,   0,   0,   0,
     0,   165, 255, 255, 96,  0,   0,   0,   0,   38,  246, 255, 255, 212, 21,  0,   0,   0,   0,   0,   0,   23,  216, 255, 255, 249, 42,  0,   0,   0,   0,   0,   159, 255, 255, 240, 7,   0,   0,
     0,   0,   0,   0,   13,  245, 255, 255, 150, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  229, 255, 255, 222, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 255,
     255, 253, 153, 55,  9,   1,   27,  112, 241, 255, 255, 255, 109, 0,   0,   0,   216, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 224, 0,   0,   24,  246, 255, 255, 239, 41,  0,   0,   0,   0,   0,   0,   55,  246, 255, 255, 255, 236, 0,   0,   0,   0,   58,  252, 255,
     255, 188, 1,   0,   0,   0,   0,   1,   189, 255, 255, 251, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   48,  255, 255, 225, 0,   0,   0,   0,   0,   218, 255, 172, 202, 255, 226, 0,   0,   0,   0,   0,   212, 255, 255, 45,  0,   0,   0,   0,   0,   102, 255, 255, 255, 233, 112, 34,
     4,   4,   35,  114, 235, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   65,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   95,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   51,
     156, 156, 156, 156, 156, 156, 216, 255, 255, 252, 156, 156, 156, 156, 156, 156, 131, 0,   236, 255, 255, 136, 214, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 169, 2,   0,   0,   0,   216,
     255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   215, 255, 255, 224, 0,   0,   0,   121, 255,
     255, 255, 240, 114, 29,  2,   6,   45,  132, 245, 255, 255, 255, 255, 236, 0,   0,   0,   0,   0,   126, 255, 255, 255, 110, 0,   0,   0,   0,   111, 255, 255, 255, 122, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   248, 255, 255, 15,  0,   0,   0,   20,  255, 255, 124, 150, 255,
     255, 25,  0,   0,   0,   7,   251, 255, 246, 3,   0,   0,   0,   0,   0,   0,   123, 255, 255, 255, 255, 255, 254, 254, 255, 255, 255, 255, 255, 137, 1,   0,   0,   0,   0,   0,   0,   1,   224,
     255, 255, 176, 0,   0,   0,   0,   0,   0,   186, 255, 255, 217, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   134, 255, 255, 247, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 216,
     0,   236, 255, 255, 135, 25,  186, 255, 255, 255, 255, 255, 255, 255, 253, 148, 4,   0,   0,   0,   0,   216, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   217,
     255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   251, 255, 255, 224, 0,   0,   0,   4,   178, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 214, 137, 255, 255, 236, 0,   0,
     0,   0,   0,   3,   195, 255, 255, 246, 40,  0,   0,   41,  247, 255, 255, 191, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 124, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   202, 255, 255, 59,  0,   0,   0,   77,  255, 255, 75,  99,  255, 255, 80,  0,   0,   0,   50,  255, 255, 199, 0,   0,   0,   0,   0,   0,   0,   0,
     83,  226, 255, 255, 255, 255, 255, 255, 255, 255, 230, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 249, 18,  0,   0,   0,   0,   25,  252, 255, 255, 123, 0,   0,   0,   0,
     0,   0,   0,   0,   4,   103, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  227, 255, 255, 200, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   84,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 216, 0,   236, 255, 255, 153, 0,   0,   75,  165, 221, 245, 242, 215, 148, 50,  0,   0,
     0,   0,   0,   0,   216, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   201, 255, 255, 214, 0,   0,   0,   0,   0,   0,   0,   0,   0,   73,  255, 255, 255, 224,
     0,   0,   0,   0,   7,   155, 254, 255, 255, 255, 255, 255, 255, 255, 188, 26,  136, 255, 255, 236, 0,   0,   0,   0,   0,   0,   31,  239, 255, 255, 203, 4,   4,   204, 255, 255, 237, 27,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 104, 0,   0,   0,   134,
     255, 255, 27,  48,  255, 255, 135, 0,   0,   0,   97,  255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   97,  176, 223, 246, 244, 221, 174, 99,  11,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   37,  255, 255, 255, 104, 0,   0,   0,   0,   113, 255, 255, 254, 30,  0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 246, 179, 109, 59,  19,  2,   0,   8,   44,  113, 228,
     255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   236, 255, 255, 163, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   163, 255, 255, 253, 30,  0,   0,   0,   0,   0,   0,   0,   0,   183, 255, 255, 255, 224, 0,   0,   0,   0,   0,   0,   54,  150, 215, 242, 245, 221, 167, 78,  0,   0,   153,
     255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   87,  255, 255, 255, 128, 129, 255, 255, 255, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255,
     255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 255, 255, 148, 0,   0,   0,   192, 255, 234, 0,   4,   247, 255, 190, 0,   0,   0,   144, 255, 255, 97,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   198, 255, 255, 196, 0,   0,   0,   0,   205, 255, 255, 189,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 255, 255, 255, 254, 251, 255, 255, 255, 255, 255, 255, 168, 0,   0,   0,   49,  255, 255, 255, 121, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   129, 255, 255, 255, 44,  0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  139, 191, 228, 243, 142, 0,   100, 255, 255, 255, 170, 1,   0,   0,   0,   0,   0,   0,   114,
     255, 255, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   163, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 251, 251, 255,
     255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  255, 255,
     193, 0,   0,   4,   245, 255, 186, 0,   0,   201, 255, 242, 2,   0,   0,   191, 255, 255, 46,  0,   0,   0,   0,   208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 254, 31,  0,   0,   36,  255, 255, 255, 95,  0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   217, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 245, 126, 2,   0,   0,   0,   0,   203, 255, 255, 219, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   219, 255, 255, 205, 0,   0,   120, 255, 255, 112, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     31,  194, 255, 255, 255, 255, 255, 144, 0,   12,  240, 255, 255, 255, 181, 60,  7,   0,   17,  73,  178, 255, 255, 232, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   164, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   12,  219, 255, 255, 255, 255, 214, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   20,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   249, 255, 238, 0,   0,   50,  255, 255, 135, 0,   0,   148, 255, 255, 44,  0,   0,   238, 255,
     247, 4,   0,   0,   0,   0,   208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  248, 255, 255, 119, 0,   0,
     119, 255, 255, 244, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   64,  133, 183, 217, 238, 249, 252, 240, 218, 173, 107, 21,  0,   0,   0,   0,   0,   0,   101, 255, 255, 255, 63,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  255, 255, 255, 110, 0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 164, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  229, 255, 255, 255, 255, 255, 255, 141, 0,   0,   94,  255, 255, 255, 255, 255, 255,
     252, 255, 255, 255, 255, 162, 104, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     62,  255, 255, 255, 255, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   205, 255, 255, 25,  0,   106, 255, 255, 78,  0,   0,   94,  255, 255, 99,  0,   28,  255, 255, 200, 0,   0,   0,   0,   0,   201, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
     248, 252, 255, 255, 255, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   171, 255, 255, 205, 0,   0,   200, 255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  242, 255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 250, 20,  0,   0,
     120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   144, 255, 255, 255, 209, 88,  29,  3,   0,   0,   0,   0,   104, 249, 255, 255, 255, 255, 255, 255, 255, 254, 146, 7,   62,  255, 255, 224, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   15,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   154, 255, 255, 66,  0,   156, 255, 255, 21,  0,   0,   39,  255, 255,
     150, 0,   72,  255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  228, 255, 255, 187, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,
     255, 255, 255, 31,  26,  254, 255, 255, 67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 243, 228, 191, 140, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   153, 255, 255, 246, 15,  0,   0,   0,   0,   0,   0,   0,   0,   3,   233, 255, 255, 176, 0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236,
     255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   221, 255, 255, 231, 14,  0,   0,   0,   0,   0,   0,   0,   0,
     27,  130, 196, 235, 250, 237, 211, 145, 51,  0,   0,   21,  255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 236, 0,   0,   0,   0,
     0,   0,   0,   0,   79,  255, 255, 255, 255, 255, 254, 71,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   253, 255, 255, 167, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   103, 255, 255, 107, 0,   203, 255, 220, 0,   0,   0,   1,   239, 255, 202, 0,   113, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   4,   193, 255, 255, 223, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   233, 255, 255, 107, 103, 255, 255, 226, 2,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   144, 255, 255, 255, 255, 255, 195, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   51,  255, 255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255,
     255, 81,  0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   250, 255, 255, 158, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   26,  236, 255, 255, 207, 208, 255, 255, 231, 21,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   210, 255, 255, 242, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,  255, 255, 148, 3,   247, 255, 163, 0,
     0,   0,   0,   186, 255, 248, 5,   152, 255, 255, 46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 246, 48,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   143, 255, 255, 175, 178, 255, 255, 134, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 255, 255, 255, 255, 230, 20,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   163, 255, 255, 236, 6,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   236, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 144, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255,
     236, 0,   0,   0,   0,   0,   0,   1,   188, 255, 255, 248, 43,  45,  248, 255, 255, 179, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 255, 255,
     208, 64,  8,   0,   0,   10,  36,  63,  0,   0,   0,   0,   0,   7,   250, 255, 181, 42,  255, 255, 106, 0,   0,   0,   0,   131, 255, 255, 46,  189, 255, 247, 4,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 255, 91,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  255, 255, 235, 242, 255, 255, 40,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   3,   30,  91,  214, 255, 255, 255, 146, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   102, 255, 255, 255, 47,  0,   0,   0,   0,   0,
     0,   10,  243, 255, 255, 147, 0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 236, 0,   0,   0,   0,   0,   0,   118, 255, 255, 255, 113, 0,   0,   116, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  229, 255, 255, 255, 255, 254, 238, 247, 255, 255, 240, 0,   0,   0,   0,   0,   0,   207, 255, 213,
     90,  255, 255, 49,  0,   0,   0,   0,   77,  255, 255, 89,  225, 255, 200, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  245, 255, 255, 144, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   210, 255, 255, 255, 255, 201, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  233, 255, 255, 224, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  243, 255, 255, 146, 0,   0,   0,   0,   0,   0,   89,  255, 255, 255, 52,  0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255,
     144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   164, 255, 255, 236, 0,   0,   0,   0,   0,   51,  250, 255, 255, 189, 1,   0,   0,   2,   193, 255, 255, 247, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   47,  222, 255, 255, 255, 255, 255, 255, 255, 255, 240, 0,   0,   0,   0,   0,   0,   156, 255, 244, 137, 255, 244, 3,   0,   0,   0,   0,   22,  255, 255, 136, 253, 255, 149, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  220, 255, 255, 191, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 255, 107,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 251, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   154, 255, 255, 237,
     7,   0,   0,   0,   0,   0,   180, 255, 255, 213, 0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 236, 0,   0,   0,   0,   11,  217, 255, 255, 239, 29,  0,
     0,   0,   0,   32,  241, 255, 255, 210, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  106, 184, 230, 248, 248, 232, 210, 165, 111, 0,   0,   0,   0,
     0,   0,   106, 255, 255, 209, 255, 191, 0,   0,   0,   0,   0,   0,   223, 255, 214, 255, 255, 98,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   182, 255, 255, 226, 21,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     144, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 89,  0,   0,   0,   0,   19,  250, 255, 255, 118, 0,   0,   0,   0,   0,   120, 255,
     255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   157, 255, 255, 255, 91,  0,   0,   0,   0,   0,   0,   96,  255, 255, 255, 146, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  255, 255, 255, 255, 134, 0,   0,   0,   0,   0,   0,   169, 255, 255,
     255, 255, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 248, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   206, 255, 255, 188, 0,   0,   0,   0,   105, 255, 255, 253, 26,  0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   85,  255, 255,
     255, 169, 0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 255, 255, 74,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   8,   251, 255, 255, 255, 77,  0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 247, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   78,  254, 255,
     255, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  161, 223, 248, 243, 208, 151, 77,  7,   0,   0,   0,   0,   0,   0,   11,  163, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   144, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 254, 33,  0,   0,   0,   196, 255, 255, 184, 0,   0,   0,
     0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   7,   255, 255, 255, 141, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  239, 255, 255, 229, 18,  0,   0,   0,   0,   0,   0,   0,   0,   21,  233, 255, 255, 233, 23,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   209, 255, 255, 255, 21,  0,   0,   0,   0,
     0,   0,   59,  255, 255, 255, 201, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  240, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   146, 255, 255, 255, 255, 255,
     255, 255, 255, 240, 158, 80,  22,  0,   24,  105, 227, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   13,  243, 255, 255, 129, 0,   0,   31,  254, 255, 255, 89,  0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   62,  255, 255, 255, 119, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2,   193, 255, 255, 254, 70,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 255, 182, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     12,  212, 255, 255, 196, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   155, 255, 255, 222, 1,   0,   118, 255, 255,
     241, 9,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  211, 255, 255, 255, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   170, 255, 255, 229, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255,
     224, 102, 23,  0,   25,  85,  163, 242, 255, 255, 255, 255, 255, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 4,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,  255, 255, 255, 58,  0,   203, 255, 255, 155, 0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   24,  66,  138, 238, 255, 255, 255, 160, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   117, 255, 255, 249, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   157, 8,   0,   0,   0,   0,   0,   0,   8,   82,  154, 211, 245, 248, 223, 159, 51,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 255, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   207, 255, 255,
     141, 26,  254, 255, 255, 61,  0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 242, 128, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   66,  252, 255, 255, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255,
     255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 212, 97,  255, 255, 221, 1,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 135,
     16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   29,  234, 255, 255, 155, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 212, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   14,  244, 255, 254, 171, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 234, 114, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   202, 255, 255, 200, 7,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   160, 255, 255, 255, 239, 140, 67,  24,  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   157, 255, 255, 254, 255, 254, 33,  0,   0,   0,   0,   0,   0,   0,
     0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   10,
     34,  75,  148, 242, 255, 255, 255, 150, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 255, 251, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   127, 242, 255, 255, 255, 255, 255, 255, 156, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   54,  255, 255, 255, 255, 193, 0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  215, 255, 255, 255, 47,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  134, 255, 255, 255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 98,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   65,  255, 255, 255, 118, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   114, 234, 255, 255, 255, 255, 255,
     255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 245, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 141, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   150, 255, 255, 255, 243, 149, 76,  34,  11,  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   228, 255, 255,
     164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  255, 255, 255,
     217, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   71,  255, 255, 255, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255,
     255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   171, 255, 255, 222, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   141, 255, 255, 255, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  252, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120,
     255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   6,   196, 255, 255, 233, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   27,  0,   0,   12,  68,  198, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   12,  255, 252, 244, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   250, 255, 255, 158, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 255, 255, 255, 172, 8,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   222, 255, 255, 230, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 4,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   8,   193, 229, 247, 250, 229, 174, 77,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255, 255,
     209, 86,  28,  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  230, 255, 255, 255, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160,
     255, 255, 252, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255,
     112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   32,  196, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  232, 255, 255, 225, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   62,  141, 193, 229, 244, 142, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2,   29,  88,  211, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 255, 255, 255, 255, 231, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   144, 255, 255, 255, 255, 255, 196, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 244, 229, 193, 141, 62,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 112, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
    40.000000f, 53.090000f, 0.000000f, 42.250000f, -10.840000f, 96, {{L'\0', 0, 0, 0, 0, 0.000000f, 0.000000f, 0.011719f, 0.011719f, 0.015625f, 0.015625f, 0, {}},
                                                                     {L' ', 0, 0, 0, 0, 24.000000f, 0.000000f, 0.023438f, 0.003906f, 0.023438f, 0.003906f, 0, {}},
                                                                     {L'!', 6, 29, 9, 29, 24.000000f, 0.000000f, 0.027344f, 0.003906f, 0.050781f, 0.117188f, 0, {}},
                                                                     {L'"', 14, 10, 5, 29, 24.000000f, 0.000000f, 0.054688f, 0.003906f, 0.109375f, 0.042969f, 0, {}},
                                                                     {L'#', 24, 29, 0, 29, 24.000000f, 0.000000f, 0.113281f, 0.003906f, 0.207031f, 0.117188f, 0, {}},
                                                                     {L'$', 18, 33, 3, 31, 24.000000f, 0.000000f, 0.210938f, 0.003906f, 0.281250f, 0.132812f, 0, {}},
                                                                     {L'%', 24, 29, 0, 29, 24.000000f, 0.000000f, 0.285156f, 0.003906f, 0.378906f, 0.117188f, 0, {}},
                                                                     {L'&', 23, 29, 1, 29, 24.000000f, 0.000000f, 0.382812f, 0.003906f, 0.472656f, 0.117188f, 0, {}},
                                                                     {L'\'', 6, 10, 9, 29, 24.000000f, 0.000000f, 0.476562f, 0.003906f, 0.500000f, 0.042969f, 0, {}},
                                                                     {L'(', 14, 35, 5, 29, 24.000000f, 0.000000f, 0.503906f, 0.003906f, 0.558594f, 0.140625f, 0, {}},
                                                                     {L')', 14, 35, 5, 29, 24.000000f, 0.000000f, 0.562500f, 0.003906f, 0.617188f, 0.140625f, 0, {}},
                                                                     {L'*', 20, 19, 2, 31, 24.000000f, 0.000000f, 0.621094f, 0.003906f, 0.699219f, 0.078125f, 0, {}},
                                                                     {L'+', 19, 18, 2, 23, 24.000000f, 0.000000f, 0.703125f, 0.003906f, 0.777344f, 0.074219f, 0, {}},
                                                                     {L',', 8, 11, 8, 5, 24.000000f, 0.000000f, 0.781250f, 0.003906f, 0.812500f, 0.046875f, 0, {}},
                                                                     {L'-', 14, 3, 5, 12, 24.000000f, 0.000000f, 0.816406f, 0.003906f, 0.871094f, 0.015625f, 0, {}},
                                                                     {L'.', 6, 7, 9, 7, 24.000000f, 0.000000f, 0.875000f, 0.003906f, 0.898438f, 0.031250f, 0, {}},
                                                                     {L'/', 16, 29, 4, 29, 24.000000f, 0.000000f, 0.902344f, 0.003906f, 0.964844f, 0.117188f, 0, {}},
                                                                     {L'0', 20, 29, 2, 29, 24.000000f, 0.000000f, 0.816406f, 0.035156f, 0.894531f, 0.148438f, 0, {}},
                                                                     {L'1', 11, 29, 4, 29, 24.000000f, 0.000000f, 0.054688f, 0.046875f, 0.097656f, 0.160156f, 0, {}},
                                                                     {L'2', 18, 29, 3, 29, 24.000000f, 0.000000f, 0.703125f, 0.078125f, 0.773438f, 0.191406f, 0, {}},
                                                                     {L'3', 19, 29, 2, 29, 24.000000f, 0.000000f, 0.621094f, 0.082031f, 0.695312f, 0.195312f, 0, {}},
                                                                     {L'4', 21, 29, 1, 29, 24.000000f, 0.000000f, 0.898438f, 0.121094f, 0.980469f, 0.234375f, 0, {}},
                                                                     {L'5', 18, 29, 3, 29, 24.000000f, 0.000000f, 0.101562f, 0.121094f, 0.171875f, 0.234375f, 0, {}},
                                                                     {L'6', 18, 29, 3, 29, 24.000000f, 0.000000f, 0.285156f, 0.121094f, 0.355469f, 0.234375f, 0, {}},
                                                                     {L'7', 20, 29, 2, 29, 24.000000f, 0.000000f, 0.359375f, 0.121094f, 0.437500f, 0.234375f, 0, {}},
                                                                     {L'8', 18, 29, 3, 29, 24.000000f, 0.000000f, 0.175781f, 0.136719f, 0.246094f, 0.250000f, 0, {}},
                                                                     {L'9', 18, 29, 3, 29, 24.000000f, 0.000000f, 0.476562f, 0.144531f, 0.546875f, 0.257812f, 0, {}},
                                                                     {L':', 6, 22, 9, 22, 24.000000f, 0.000000f, 0.781250f, 0.050781f, 0.804688f, 0.136719f, 0, {}},
                                                                     {L';', 7, 27, 8, 22, 24.000000f, 0.000000f, 0.023438f, 0.121094f, 0.050781f, 0.226562f, 0, {}},
                                                                     {L'<', 19, 21, 2, 25, 24.000000f, 0.000000f, 0.777344f, 0.152344f, 0.851562f, 0.234375f, 0, {}},
                                                                     {L'=', 19, 11, 2, 20, 24.000000f, 0.000000f, 0.699219f, 0.195312f, 0.773438f, 0.238281f, 0, {}},
                                                                     {L'>', 19, 21, 2, 25, 24.000000f, 0.000000f, 0.550781f, 0.199219f, 0.625000f, 0.281250f, 0, {}},
                                                                     {L'?', 18, 29, 3, 29, 24.000000f, 0.000000f, 0.003906f, 0.230469f, 0.074219f, 0.343750f, 0, {}},
                                                                     {L'@', 24, 33, 0, 29, 24.000000f, 0.000000f, 0.078125f, 0.238281f, 0.171875f, 0.367188f, 0, {}},
                                                                     {L'A', 24, 29, 0, 29, 24.000000f, 0.000000f, 0.250000f, 0.238281f, 0.343750f, 0.351562f, 0, {}},
                                                                     {L'B', 21, 29, 2, 29, 24.000000f, 0.000000f, 0.855469f, 0.238281f, 0.937500f, 0.351562f, 0, {}},
                                                                     {L'C', 22, 29, 2, 29, 24.000000f, 0.000000f, 0.347656f, 0.238281f, 0.433594f, 0.351562f, 0, {}},
                                                                     {L'D', 21, 29, 2, 29, 24.000000f, 0.000000f, 0.628906f, 0.242188f, 0.710938f, 0.355469f, 0, {}},
                                                                     {L'E', 17, 29, 4, 29, 24.000000f, 0.000000f, 0.777344f, 0.238281f, 0.843750f, 0.351562f, 0, {}},
                                                                     {L'F', 18, 29, 4, 29, 24.000000f, 0.000000f, 0.175781f, 0.253906f, 0.246094f, 0.367188f, 0, {}},
                                                                     {L'G', 20, 29, 2, 29, 24.000000f, 0.000000f, 0.437500f, 0.261719f, 0.515625f, 0.375000f, 0, {}},
                                                                     {L'H', 20, 29, 2, 29, 24.000000f, 0.000000f, 0.519531f, 0.285156f, 0.597656f, 0.398438f, 0, {}},
                                                                     {L'I', 16, 29, 4, 29, 24.000000f, 0.000000f, 0.003906f, 0.347656f, 0.066406f, 0.460938f, 0, {}},
                                                                     {L'J', 18, 29, 2, 29, 24.000000f, 0.000000f, 0.847656f, 0.355469f, 0.917969f, 0.468750f, 0, {}},
                                                                     {L'K', 20, 29, 4, 29, 24.000000f, 0.000000f, 0.714844f, 0.355469f, 0.792969f, 0.468750f, 0, {}},
                                                                     {L'L', 17, 29, 4, 29, 24.000000f, 0.000000f, 0.921875f, 0.355469f, 0.988281f, 0.468750f, 0, {}},
                                                                     {L'M', 20, 29, 2, 29, 24.000000f, 0.000000f, 0.250000f, 0.355469f, 0.328125f, 0.468750f, 0, {}},
                                                                     {L'N', 20, 29, 2, 29, 24.000000f, 0.000000f, 0.332031f, 0.355469f, 0.410156f, 0.468750f, 0, {}},
                                                                     {L'O', 22, 29, 1, 29, 24.000000f, 0.000000f, 0.601562f, 0.359375f, 0.687500f, 0.472656f, 0, {}},
                                                                     {L'P', 19, 29, 3, 29, 24.000000f, 0.000000f, 0.070312f, 0.371094f, 0.144531f, 0.484375f, 0, {}},
                                                                     {L'Q', 22, 37, 1, 29, 24.000000f, 0.000000f, 0.148438f, 0.371094f, 0.234375f, 0.515625f, 0, {}},
                                                                     {L'R', 20, 29, 3, 29, 24.000000f, 0.000000f, 0.414062f, 0.378906f, 0.492188f, 0.492188f, 0, {}},
                                                                     {L'S', 20, 29, 2, 29, 24.000000f, 0.000000f, 0.496094f, 0.402344f, 0.574219f, 0.515625f, 0, {}},
                                                                     {L'T', 21, 29, 1, 29, 24.000000f, 0.000000f, 0.238281f, 0.472656f, 0.320312f, 0.585938f, 0, {}},
                                                                     {L'U', 20, 29, 2, 29, 24.000000f, 0.000000f, 0.691406f, 0.472656f, 0.769531f, 0.585938f, 0, {}},
                                                                     {L'V', 24, 29, 0, 29, 24.000000f, 0.000000f, 0.773438f, 0.472656f, 0.867188f, 0.585938f, 0, {}},
                                                                     {L'W', 24, 29, 0, 29, 24.000000f, 0.000000f, 0.871094f, 0.472656f, 0.964844f, 0.585938f, 0, {}},
                                                                     {L'X', 22, 29, 1, 29, 24.000000f, 0.000000f, 0.324219f, 0.472656f, 0.410156f, 0.585938f, 0, {}},
                                                                     {L'Y', 24, 29, 0, 29, 24.000000f, 0.000000f, 0.578125f, 0.476562f, 0.671875f, 0.589844f, 0, {}},
                                                                     {L'Z', 21, 29, 1, 29, 24.000000f, 0.000000f, 0.003906f, 0.488281f, 0.085938f, 0.601562f, 0, {}},
                                                                     {L'[', 11, 35, 8, 29, 24.000000f, 0.000000f, 0.089844f, 0.488281f, 0.132812f, 0.625000f, 0, {}},
                                                                     {L'\\', 16, 29, 4, 29, 24.000000f, 0.000000f, 0.414062f, 0.496094f, 0.476562f, 0.609375f, 0, {}},
                                                                     {L']', 11, 35, 5, 29, 24.000000f, 0.000000f, 0.136719f, 0.519531f, 0.179688f, 0.656250f, 0, {}},
                                                                     {L'^', 20, 18, 2, 29, 24.000000f, 0.000000f, 0.480469f, 0.519531f, 0.558594f, 0.589844f, 0, {}},
                                                                     {L'_', 26, 3, -1, -3, 24.000000f, 0.000000f, 0.675781f, 0.589844f, 0.777344f, 0.601562f, 0, {}},
                                                                     {L'`', 8, 7, 8, 31, 24.000000f, 0.000000f, 0.183594f, 0.519531f, 0.214844f, 0.546875f, 0, {}},
                                                                     {L'a', 19, 22, 2, 22, 24.000000f, 0.000000f, 0.218750f, 0.589844f, 0.292969f, 0.675781f, 0, {}},
                                                                     {L'b', 19, 31, 3, 31, 24.000000f, 0.000000f, 0.296875f, 0.589844f, 0.371094f, 0.710938f, 0, {}},
                                                                     {L'c', 18, 22, 3, 22, 24.000000f, 0.000000f, 0.781250f, 0.589844f, 0.851562f, 0.675781f, 0, {}},
                                                                     {L'd', 19, 31, 2, 31, 24.000000f, 0.000000f, 0.855469f, 0.589844f, 0.929688f, 0.710938f, 0, {}},
                                                                     {L'e', 20, 22, 2, 22, 24.000000f, 0.000000f, 0.562500f, 0.593750f, 0.640625f, 0.679688f, 0, {}},
                                                                     {L'f', 19, 31, 3, 31, 24.000000f, 0.000000f, 0.480469f, 0.593750f, 0.554688f, 0.714844f, 0, {}},
                                                                     {L'g', 21, 32, 1, 22, 24.000000f, 0.000000f, 0.644531f, 0.605469f, 0.726562f, 0.730469f, 0, {}},
                                                                     {L'h', 18, 31, 3, 31, 24.000000f, 0.000000f, 0.003906f, 0.605469f, 0.074219f, 0.726562f, 0, {}},
                                                                     {L'i', 18, 31, 3, 31, 24.000000f, 0.000000f, 0.375000f, 0.613281f, 0.445312f, 0.734375f, 0, {}},
                                                                     {L'j', 15, 41, 2, 31, 24.000000f, 0.000000f, 0.933594f, 0.589844f, 0.992188f, 0.750000f, 0, {}},
                                                                     {L'k', 19, 31, 4, 31, 24.000000f, 0.000000f, 0.078125f, 0.660156f, 0.152344f, 0.781250f, 0, {}},
                                                                     {L'l', 18, 31, 3, 31, 24.000000f, 0.000000f, 0.156250f, 0.679688f, 0.226562f, 0.800781f, 0, {}},
                                                                     {L'm', 22, 22, 1, 22, 24.000000f, 0.000000f, 0.730469f, 0.679688f, 0.816406f, 0.765625f, 0, {}},
                                                                     {L'n', 18, 22, 3, 22, 24.000000f, 0.000000f, 0.558594f, 0.683594f, 0.628906f, 0.769531f, 0, {}},
                                                                     {L'o', 20, 22, 2, 22, 24.000000f, 0.000000f, 0.820312f, 0.714844f, 0.898438f, 0.800781f, 0, {}},
                                                                     {L'p', 19, 32, 3, 22, 24.000000f, 0.000000f, 0.230469f, 0.714844f, 0.304688f, 0.839844f, 0, {}},
                                                                     {L'q', 19, 32, 2, 22, 24.000000f, 0.000000f, 0.449219f, 0.718750f, 0.523438f, 0.843750f, 0, {}},
                                                                     {L'r', 16, 22, 5, 22, 24.000000f, 0.000000f, 0.308594f, 0.714844f, 0.371094f, 0.800781f, 0, {}},
                                                                     {L's', 18, 22, 3, 22, 24.000000f, 0.000000f, 0.003906f, 0.730469f, 0.074219f, 0.816406f, 0, {}},
                                                                     {L't', 19, 28, 2, 28, 24.000000f, 0.000000f, 0.632812f, 0.734375f, 0.707031f, 0.843750f, 0, {}},
                                                                     {L'u', 18, 22, 3, 22, 24.000000f, 0.000000f, 0.375000f, 0.738281f, 0.445312f, 0.824219f, 0, {}},
                                                                     {L'v', 22, 22, 1, 22, 24.000000f, 0.000000f, 0.902344f, 0.753906f, 0.988281f, 0.839844f, 0, {}},
                                                                     {L'w', 26, 22, -1, 22, 24.000000f, 0.000000f, 0.710938f, 0.769531f, 0.812500f, 0.855469f, 0, {}},
                                                                     {L'x', 22, 22, 1, 22, 24.000000f, 0.000000f, 0.527344f, 0.773438f, 0.613281f, 0.859375f, 0, {}},
                                                                     {L'y', 22, 32, 1, 22, 24.000000f, 0.000000f, 0.078125f, 0.804688f, 0.164062f, 0.929688f, 0, {}},
                                                                     {L'z', 18, 22, 3, 22, 24.000000f, 0.000000f, 0.816406f, 0.804688f, 0.886719f, 0.890625f, 0, {}},
                                                                     {L'{', 16, 35, 4, 29, 24.000000f, 0.000000f, 0.308594f, 0.804688f, 0.371094f, 0.941406f, 0, {}},
                                                                     {L'|', 4, 41, 10, 31, 24.000000f, 0.000000f, 0.167969f, 0.804688f, 0.183594f, 0.964844f, 0, {}},
                                                                     {L'}', 16, 35, 4, 29, 24.000000f, 0.000000f, 0.003906f, 0.820312f, 0.066406f, 0.957031f, 0, {}},
                                                                     {L'~', 19, 7, 2, 18, 24.000000f, 0.000000f, 0.890625f, 0.843750f, 0.964844f, 0.871094f, 0, {}}, }};
#ifdef __cplusplus
}
#endif
