
/*
 * Copyright 2017-2018 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 */
#ifndef __FUSEMAP_H__
#define __FUSEMAP_H__

#include "fsl_device_registers.h"

/* Fuse Word LOCK_CFG0 Index 0 */
#define OTP_LOCK_CFG0_FUSE_IDX (0u)

#define OTP_LOCK_CFG0_FUSE_VALUE()   (OCOTP->OTP_SHADOW[OTP_LOCK_CFG0_FUSE_IDX])
#define OTP_BOOT_CFG_LOCK_FUSE_IDX   (0u)
#define OTP_BOOT_CFG_LOCK_FUSE_SHIFT (0u)
#define OTP_BOOT_CFG_LOCK_FUSE_MASK  (0x7u)
#define OTP_BOOT_CFG_LOCK_FUSE_WIDTH (3u)
#define OTP_BOOT_CFG_LOCK_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_BOOT_CFG_LOCK_FUSE_IDX] & OTP_BOOT_CFG_LOCK_FUSE_MASK) >> OTP_BOOT_CFG_LOCK_FUSE_SHIFT)

#define OTP_SEC_BOOT_CFG_LOCK_FUSE_IDX   (0u)
#define OTP_SEC_BOOT_CFG_LOCK_FUSE_SHIFT (3u)
#define OTP_SEC_BOOT_CFG_LOCK_FUSE_MASK  (0x38u)
#define OTP_SEC_BOOT_CFG_LOCK_FUSE_WIDTH (3u)
#define OTP_SEC_BOOT_CFG_LOCK_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_SEC_BOOT_CFG_LOCK_FUSE_IDX] & OTP_SEC_BOOT_CFG_LOCK_FUSE_MASK) >> \
     OTP_SEC_BOOT_CFG_LOCK_FUSE_SHIFT)

#define OTP_DCFG_CC_SOCU_LOCK_FUSE_IDX   (0u)
#define OTP_DCFG_CC_SOCU_LOCK_FUSE_SHIFT (6u)
#define OTP_DCFG_CC_SOCU_LOCK_FUSE_MASK  (0x1C0u)
#define OTP_DCFG_CC_SOCU_LOCK_FUSE_WIDTH (3u)
#define OTP_DCFG_CC_SOCU_LOCK_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_DCFG_CC_SOCU_LOCK_FUSE_IDX] & OTP_DCFG_CC_SOCU_LOCK_FUSE_MASK) >> \
     OTP_DCFG_CC_SOCU_LOCK_FUSE_SHIFT)

#define OTP_DCFG_CC_SOCU_NS_LOCK_FUSE_IDX   (0u)
#define OTP_DCFG_CC_SOCU_NS_LOCK_FUSE_SHIFT (9u)
#define OTP_DCFG_CC_SOCU_NS_LOCK_FUSE_MASK  (0xE00u)
#define OTP_DCFG_CC_SOCU_NS_LOCK_FUSE_WIDTH (3u)
#define OTP_DCFG_CC_SOCU_NS_LOCK_FUSE_VALUE()                                                       \
    ((OCOTP->OTP_SHADOW[OTP_DCFG_CC_SOCU_NS_LOCK_FUSE_IDX] & OTP_DCFG_CC_SOCU_NS_LOCK_FUSE_MASK) >> \
     OTP_DCFG_CC_SOCU_NS_LOCK_FUSE_SHIFT)

#define OTP_LOCK_CFG_LOCK_FUSE_IDX   (0u)
#define OTP_LOCK_CFG_LOCK_FUSE_SHIFT (12u)
#define OTP_LOCK_CFG_LOCK_FUSE_MASK  (0x7000u)
#define OTP_LOCK_CFG_LOCK_FUSE_WIDTH (3u)
#define OTP_LOCK_CFG_LOCK_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_LOCK_CFG_LOCK_FUSE_IDX] & OTP_LOCK_CFG_LOCK_FUSE_MASK) >> OTP_LOCK_CFG_LOCK_FUSE_SHIFT)

/* Fuse Word LOCK_CFG1 Index 1 */
#define OTP_LOCK_CFG1_FUSE_IDX (1u)

#define OTP_LOCK_CFG1_FUSE_VALUE()   (OCOTP->OTP_SHADOW[OTP_LOCK_CFG1_FUSE_IDX])
#define OTP_CUST_KEY_LOCK_FUSE_IDX   (1u)
#define OTP_CUST_KEY_LOCK_FUSE_SHIFT (0u)
#define OTP_CUST_KEY_LOCK_FUSE_MASK  (0x7u)
#define OTP_CUST_KEY_LOCK_FUSE_WIDTH (3u)
#define OTP_CUST_KEY_LOCK_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_CUST_KEY_LOCK_FUSE_IDX] & OTP_CUST_KEY_LOCK_FUSE_MASK) >> OTP_CUST_KEY_LOCK_FUSE_SHIFT)

#define OTP_PRINCE_CFG_FUSE_IDX   (1u)
#define OTP_PRINCE_CFG_FUSE_SHIFT (3u)
#define OTP_PRINCE_CFG_FUSE_MASK  (0x38u)
#define OTP_PRINCE_CFG_FUSE_WIDTH (3u)
#define OTP_PRINCE_CFG_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_PRINCE_CFG_FUSE_IDX] & OTP_PRINCE_CFG_FUSE_MASK) >> OTP_PRINCE_CFG_FUSE_SHIFT)

#define OTP_KEYSTORE_CFG_LOCK_FUSE_IDX   (1u)
#define OTP_KEYSTORE_CFG_LOCK_FUSE_SHIFT (6u)
#define OTP_KEYSTORE_CFG_LOCK_FUSE_MASK  (0x1C0u)
#define OTP_KEYSTORE_CFG_LOCK_FUSE_WIDTH (3u)
#define OTP_KEYSTORE_CFG_LOCK_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_KEYSTORE_CFG_LOCK_FUSE_IDX] & OTP_KEYSTORE_CFG_LOCK_FUSE_MASK) >> \
     OTP_KEYSTORE_CFG_LOCK_FUSE_SHIFT)

#define OTP_LIFECYCLE_LOCK_FUSE_IDX   (1u)
#define OTP_LIFECYCLE_LOCK_FUSE_SHIFT (9u)
#define OTP_LIFECYCLE_LOCK_FUSE_MASK  (0xE00u)
#define OTP_LIFECYCLE_LOCK_FUSE_WIDTH (3u)
#define OTP_LIFECYCLE_LOCK_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_LIFECYCLE_LOCK_FUSE_IDX] & OTP_LIFECYCLE_LOCK_FUSE_MASK) >> OTP_LIFECYCLE_LOCK_FUSE_SHIFT)

#define OTP_CRC_HI_LOCK_FUSE_IDX   (1u)
#define OTP_CRC_HI_LOCK_FUSE_SHIFT (12u)
#define OTP_CRC_HI_LOCK_FUSE_MASK  (0x7000u)
#define OTP_CRC_HI_LOCK_FUSE_WIDTH (3u)
#define OTP_CRC_HI_LOCK_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_CRC_HI_LOCK_FUSE_IDX] & OTP_CRC_HI_LOCK_FUSE_MASK) >> OTP_CRC_HI_LOCK_FUSE_SHIFT)

/* Fuse Word LOCK_CFG2 Index 2 */
#define OTP_LOCK_CFG2_FUSE_IDX (2u)

#define OTP_LOCK_CFG2_FUSE_VALUE()    (OCOTP->OTP_SHADOW[OTP_LOCK_CFG2_FUSE_IDX])
#define OTP_OTP_SHARE_LOCK_FUSE_IDX   (2u)
#define OTP_OTP_SHARE_LOCK_FUSE_SHIFT (0u)
#define OTP_OTP_SHARE_LOCK_FUSE_MASK  (0x7u)
#define OTP_OTP_SHARE_LOCK_FUSE_WIDTH (3u)
#define OTP_OTP_SHARE_LOCK_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_OTP_SHARE_LOCK_FUSE_IDX] & OTP_OTP_SHARE_LOCK_FUSE_MASK) >> OTP_OTP_SHARE_LOCK_FUSE_SHIFT)

#define OTP_ROM_PATCH_LOCK_FUSE_IDX   (2u)
#define OTP_ROM_PATCH_LOCK_FUSE_SHIFT (3u)
#define OTP_ROM_PATCH_LOCK_FUSE_MASK  (0x38u)
#define OTP_ROM_PATCH_LOCK_FUSE_WIDTH (3u)
#define OTP_ROM_PATCH_LOCK_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_ROM_PATCH_LOCK_FUSE_IDX] & OTP_ROM_PATCH_LOCK_FUSE_MASK) >> OTP_ROM_PATCH_LOCK_FUSE_SHIFT)

#define OTP_NXP_KEY_LOCK_FUSE_IDX   (2u)
#define OTP_NXP_KEY_LOCK_FUSE_SHIFT (6u)
#define OTP_NXP_KEY_LOCK_FUSE_MASK  (0x1C0u)
#define OTP_NXP_KEY_LOCK_FUSE_WIDTH (3u)
#define OTP_NXP_KEY_LOCK_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_NXP_KEY_LOCK_FUSE_IDX] & OTP_NXP_KEY_LOCK_FUSE_MASK) >> OTP_NXP_KEY_LOCK_FUSE_SHIFT)

#define OTP_CRC_LO_LOCK_FUSE_IDX   (2u)
#define OTP_CRC_LO_LOCK_FUSE_SHIFT (9u)
#define OTP_CRC_LO_LOCK_FUSE_MASK  (0xE00u)
#define OTP_CRC_LO_LOCK_FUSE_WIDTH (3u)
#define OTP_CRC_LO_LOCK_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_CRC_LO_LOCK_FUSE_IDX] & OTP_CRC_LO_LOCK_FUSE_MASK) >> OTP_CRC_LO_LOCK_FUSE_SHIFT)

#define OTP_COMMON_LOCK_FUSE_IDX   (2u)
#define OTP_COMMON_LOCK_FUSE_SHIFT (12u)
#define OTP_COMMON_LOCK_FUSE_MASK  (0x7000u)
#define OTP_COMMON_LOCK_FUSE_WIDTH (3u)
#define OTP_COMMON_LOCK_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_COMMON_LOCK_FUSE_IDX] & OTP_COMMON_LOCK_FUSE_MASK) >> OTP_COMMON_LOCK_FUSE_SHIFT)

/* Fuse Word TRIM_CFG0 Index 3 */
#define OTP_TRIM_CFG0_FUSE_IDX (3u)

#define OTP_TSENS_CAU_MIN_FUSE_IDX   (3u)
#define OTP_TSENS_CAU_MIN_FUSE_SHIFT (0u)
#define OTP_TSENS_CAU_MIN_FUSE_MASK  (0x3FFu)
#define OTP_TSENS_CAU_MIN_FUSE_WIDTH (10u)

#define OTP_TSENS_CAU_MAX_FUSE_IDX   (3u)
#define OTP_TSENS_CAU_MAX_FUSE_SHIFT (10u)
#define OTP_TSENS_CAU_MAX_FUSE_MASK  (0xFFC00u)
#define OTP_TSENS_CAU_MAX_FUSE_WIDTH (10u)

#define OTP_V11_SENS_MIN_FUSE_IDX   (3u)
#define OTP_V11_SENS_MIN_FUSE_SHIFT (20u)
#define OTP_V11_SENS_MIN_FUSE_MASK  (0x3FF00000u)
#define OTP_V11_SENS_MIN_FUSE_WIDTH (10u)

/* Fuse Word TRIM_CFG1 Index 4 */
#define OTP_TRIM_CFG1_FUSE_IDX (4u)

#define OTP_V11_SENS_MAX_FUSE_IDX   (4u)
#define OTP_V11_SENS_MAX_FUSE_SHIFT (0u)
#define OTP_V11_SENS_MAX_FUSE_MASK  (0x3FFu)
#define OTP_V11_SENS_MAX_FUSE_WIDTH (10u)

#define OTP_V18_SENS_MIN_FUSE_IDX   (4u)
#define OTP_V18_SENS_MIN_FUSE_SHIFT (10u)
#define OTP_V18_SENS_MIN_FUSE_MASK  (0xFFC00u)
#define OTP_V18_SENS_MIN_FUSE_WIDTH (10u)

#define OTP_V18_SENS_MAX_FUSE_IDX   (4u)
#define OTP_V18_SENS_MAX_FUSE_SHIFT (20u)
#define OTP_V18_SENS_MAX_FUSE_MASK  (0x3FF00000u)
#define OTP_V18_SENS_MAX_FUSE_WIDTH (10u)

/* Fuse Word CFG_STATE Index 5 */
#define OTP_CFG_STATE_FUSE_IDX (5u)

#define OTP_GDET_VALID_FUSE_IDX   (5u)
#define OTP_GDET_VALID_FUSE_SHIFT (0u)
#define OTP_GDET_VALID_FUSE_MASK  (0x1u)
#define OTP_GDET_VALID_FUSE_WIDTH (1u)

#define OTP_GDET_RESET_DIS_FUSE_IDX   (5u)
#define OTP_GDET_RESET_DIS_FUSE_SHIFT (1u)
#define OTP_GDET_RESET_DIS_FUSE_MASK  (0xEu)
#define OTP_GDET_RESET_DIS_FUSE_WIDTH (3u)

#define OTP_DTRNG_VALID_FUSE_IDX   (5u)
#define OTP_DTRNG_VALID_FUSE_SHIFT (4u)
#define OTP_DTRNG_VALID_FUSE_MASK  (0x10u)
#define OTP_DTRNG_VALID_FUSE_WIDTH (1u)

#define OTP_DIS_ROM_HIDING_FUSE_IDX   (5u)
#define OTP_DIS_ROM_HIDING_FUSE_SHIFT (5u)
#define OTP_DIS_ROM_HIDING_FUSE_MASK  (0x1E0u)
#define OTP_DIS_ROM_HIDING_FUSE_WIDTH (4u)

#define OTP_TSENS_CAU_VALID_FUSE_IDX   (5u)
#define OTP_TSENS_CAU_VALID_FUSE_SHIFT (9u)
#define OTP_TSENS_CAU_VALID_FUSE_MASK  (0x200u)
#define OTP_TSENS_CAU_VALID_FUSE_WIDTH (1u)

#define OTP_V11_SENS_VALID_FUSE_IDX   (5u)
#define OTP_V11_SENS_VALID_FUSE_SHIFT (10u)
#define OTP_V11_SENS_VALID_FUSE_MASK  (0x400u)
#define OTP_V11_SENS_VALID_FUSE_WIDTH (1u)

#define OTP_V18_SENS_VALID_FUSE_IDX   (5u)
#define OTP_V18_SENS_VALID_FUSE_SHIFT (11u)
#define OTP_V18_SENS_VALID_FUSE_MASK  (0x800u)
#define OTP_V18_SENS_VALID_FUSE_WIDTH (1u)

#define OTP_RCAL_VALUE_FUSE_IDX   (5u)
#define OTP_RCAL_VALUE_FUSE_SHIFT (12u)
#define OTP_RCAL_VALUE_FUSE_MASK  (0x7F000u)
#define OTP_RCAL_VALUE_FUSE_WIDTH (7u)

#define OTP_RCAL_VALID_FUSE_IDX   (5u)
#define OTP_RCAL_VALID_FUSE_SHIFT (19u)
#define OTP_RCAL_VALID_FUSE_MASK  (0x80000u)
#define OTP_RCAL_VALID_FUSE_WIDTH (1u)

#define OTP_DISABLE_15_4_FUSE_IDX   (5u)
#define OTP_DISABLE_15_4_FUSE_SHIFT (20u)
#define OTP_DISABLE_15_4_FUSE_MASK  (0x100000u)
#define OTP_DISABLE_15_4_FUSE_WIDTH (1u)

/* Fuse Word ITRC_CHIP_RESET_SEL0 Index 6 */
#define OTP_ITRC_CHIP_RESET_SEL0_FUSE_IDX (6u)

/* Fuse Word ITRC_CHIP_RESET_SEL1 Index 7 */
#define OTP_ITRC_CHIP_RESET_SEL1_FUSE_IDX (7u)

/* Fuse Word SYSCTL0_PRODUCT_ID Index 9 */
#define OTP_SYSCTL0_PRODUCT_ID_FUSE_IDX (9u)

#define OTP_SYSCTL0_PRODUCT_ID_FUSE_IDX   (9u)
#define OTP_SYSCTL0_PRODUCT_ID_FUSE_SHIFT (0u)
#define OTP_SYSCTL0_PRODUCT_ID_FUSE_MASK  (0xFFFFu)
#define OTP_SYSCTL0_PRODUCT_ID_FUSE_WIDTH (16u)

/* Fuse Word SYSOSC_ST Index 10 */
#define OTP_SYSOSC_ST_FUSE_IDX (10u)

#define OTP_SYSOSC_ST_31_0_FUSE_IDX   (10u)
#define OTP_SYSOSC_ST_31_0_FUSE_SHIFT (0u)
#define OTP_SYSOSC_ST_31_0_FUSE_MASK  (0xFFFFFFFFu)
#define OTP_SYSOSC_ST_31_0_FUSE_WIDTH (32u)

/* Fuse Word SYSCTL0_AUTOCLKGATEOVERRIDE0 Index 11 */
#define OTP_SYSCTL0_AUTOCLKGATEOVERRIDE0_FUSE_IDX (11u)

/* Fuse Word SYSCTL0_AUTOCLKGATEOVERRIDE1 Index 12 */
#define OTP_SYSCTL0_AUTOCLKGATEOVERRIDE1_FUSE_IDX (12u)

#define OTP_SYSCTL0_AUTOCLKGATEOVERRIDE1_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_SYSCTL0_AUTOCLKGATEOVERRIDE1_FUSE_IDX])
/* Fuse Word BOOT_CFG0 Index 15 */
#define OTP_BOOT_CFG0_FUSE_IDX (15u)

#define OTP_BOOT_CFG0_FUSE_VALUE()         (OCOTP->OTP_SHADOW[OTP_BOOT_CFG0_FUSE_IDX])
#define OTP_PRIMARY_BOOT_SOURCE_FUSE_IDX   (15u)
#define OTP_PRIMARY_BOOT_SOURCE_FUSE_SHIFT (0u)
#define OTP_PRIMARY_BOOT_SOURCE_FUSE_MASK  (0xFu)
#define OTP_PRIMARY_BOOT_SOURCE_FUSE_WIDTH (4u)
#define OTP_PRIMARY_BOOT_SOURCE_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_PRIMARY_BOOT_SOURCE_FUSE_IDX] & OTP_PRIMARY_BOOT_SOURCE_FUSE_MASK) >> \
     OTP_PRIMARY_BOOT_SOURCE_FUSE_SHIFT)

#define OTP_DEFAULT_ISP_MODE_FUSE_IDX   (15u)
#define OTP_DEFAULT_ISP_MODE_FUSE_SHIFT (4u)
#define OTP_DEFAULT_ISP_MODE_FUSE_MASK  (0x70u)
#define OTP_DEFAULT_ISP_MODE_FUSE_WIDTH (3u)
#define OTP_DEFAULT_ISP_MODE_FUSE_VALUE()                                                   \
    ((OCOTP->OTP_SHADOW[OTP_DEFAULT_ISP_MODE_FUSE_IDX] & OTP_DEFAULT_ISP_MODE_FUSE_MASK) >> \
     OTP_DEFAULT_ISP_MODE_FUSE_SHIFT)

#define OTP_BOOT_CLK_SPEED_FUSE_IDX   (15u)
#define OTP_BOOT_CLK_SPEED_FUSE_SHIFT (7u)
#define OTP_BOOT_CLK_SPEED_FUSE_MASK  (0x80u)
#define OTP_BOOT_CLK_SPEED_FUSE_WIDTH (1u)
#define OTP_BOOT_CLK_SPEED_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_BOOT_CLK_SPEED_FUSE_IDX] & OTP_BOOT_CLK_SPEED_FUSE_MASK) >> OTP_BOOT_CLK_SPEED_FUSE_SHIFT)

#define OTP_STOP_ON_FAILURE_FUSE_IDX   (15u)
#define OTP_STOP_ON_FAILURE_FUSE_SHIFT (10u)
#define OTP_STOP_ON_FAILURE_FUSE_MASK  (0x400u)
#define OTP_STOP_ON_FAILURE_FUSE_WIDTH (1u)
#define OTP_STOP_ON_FAILURE_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_STOP_ON_FAILURE_FUSE_IDX] & OTP_STOP_ON_FAILURE_FUSE_MASK) >> \
     OTP_STOP_ON_FAILURE_FUSE_SHIFT)

#define OTP_22_PRINCE_GCM_ROUNDS_FUSE_IDX   (15u)
#define OTP_22_PRINCE_GCM_ROUNDS_FUSE_SHIFT (11u)
#define OTP_22_PRINCE_GCM_ROUNDS_FUSE_MASK  (0x800u)
#define OTP_22_PRINCE_GCM_ROUNDS_FUSE_WIDTH (1u)
#define OTP_22_PRINCE_GCM_ROUNDS_FUSE_VALUE()                                                       \
    ((OCOTP->OTP_SHADOW[OTP_22_PRINCE_GCM_ROUNDS_FUSE_IDX] & OTP_22_PRINCE_GCM_ROUNDS_FUSE_MASK) >> \
     OTP_22_PRINCE_GCM_ROUNDS_FUSE_SHIFT)

#define OTP_TZM_IMAGE_TYPE_FUSE_IDX   (15u)
#define OTP_TZM_IMAGE_TYPE_FUSE_SHIFT (12u)
#define OTP_TZM_IMAGE_TYPE_FUSE_MASK  (0x3000u)
#define OTP_TZM_IMAGE_TYPE_FUSE_WIDTH (2u)
#define OTP_TZM_IMAGE_TYPE_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_TZM_IMAGE_TYPE_FUSE_IDX] & OTP_TZM_IMAGE_TYPE_FUSE_MASK) >> OTP_TZM_IMAGE_TYPE_FUSE_SHIFT)

#define OTP_PSA_BSTATE_SKIP_FUSE_IDX   (15u)
#define OTP_PSA_BSTATE_SKIP_FUSE_SHIFT (14u)
#define OTP_PSA_BSTATE_SKIP_FUSE_MASK  (0x4000u)
#define OTP_PSA_BSTATE_SKIP_FUSE_WIDTH (1u)
#define OTP_PSA_BSTATE_SKIP_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_PSA_BSTATE_SKIP_FUSE_IDX] & OTP_PSA_BSTATE_SKIP_FUSE_MASK) >> \
     OTP_PSA_BSTATE_SKIP_FUSE_SHIFT)

#define OTP_PSA_BSTATE_INC_KEYS_FUSE_IDX   (15u)
#define OTP_PSA_BSTATE_INC_KEYS_FUSE_SHIFT (15u)
#define OTP_PSA_BSTATE_INC_KEYS_FUSE_MASK  (0x8000u)
#define OTP_PSA_BSTATE_INC_KEYS_FUSE_WIDTH (1u)
#define OTP_PSA_BSTATE_INC_KEYS_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_PSA_BSTATE_INC_KEYS_FUSE_IDX] & OTP_PSA_BSTATE_INC_KEYS_FUSE_MASK) >> \
     OTP_PSA_BSTATE_INC_KEYS_FUSE_SHIFT)

#define OTP_REDUNDANT_SPI_PORT_FUSE_IDX   (15u)
#define OTP_REDUNDANT_SPI_PORT_FUSE_SHIFT (16u)
#define OTP_REDUNDANT_SPI_PORT_FUSE_MASK  (0x70000u)
#define OTP_REDUNDANT_SPI_PORT_FUSE_WIDTH (3u)
#define OTP_REDUNDANT_SPI_PORT_FUSE_VALUE()                                                     \
    ((OCOTP->OTP_SHADOW[OTP_REDUNDANT_SPI_PORT_FUSE_IDX] & OTP_REDUNDANT_SPI_PORT_FUSE_MASK) >> \
     OTP_REDUNDANT_SPI_PORT_FUSE_SHIFT)

#define OTP_SECURE_BOOT_EN_FUSE_IDX   (15u)
#define OTP_SECURE_BOOT_EN_FUSE_SHIFT (19u)
#define OTP_SECURE_BOOT_EN_FUSE_MASK  (0x180000u)
#define OTP_SECURE_BOOT_EN_FUSE_WIDTH (2u)
#define OTP_SECURE_BOOT_EN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_SECURE_BOOT_EN_FUSE_IDX] & OTP_SECURE_BOOT_EN_FUSE_MASK) >> OTP_SECURE_BOOT_EN_FUSE_SHIFT)

#define OTP_DICE_INC_OTP_FUSE_IDX   (15u)
#define OTP_DICE_INC_OTP_FUSE_SHIFT (22u)
#define OTP_DICE_INC_OTP_FUSE_MASK  (0x400000u)
#define OTP_DICE_INC_OTP_FUSE_WIDTH (1u)
#define OTP_DICE_INC_OTP_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DICE_INC_OTP_FUSE_IDX] & OTP_DICE_INC_OTP_FUSE_MASK) >> OTP_DICE_INC_OTP_FUSE_SHIFT)

#define OTP_DICE_SKIP_FUSE_IDX   (15u)
#define OTP_DICE_SKIP_FUSE_SHIFT (23u)
#define OTP_DICE_SKIP_FUSE_MASK  (0x800000u)
#define OTP_DICE_SKIP_FUSE_WIDTH (1u)
#define OTP_DICE_SKIP_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DICE_SKIP_FUSE_IDX] & OTP_DICE_SKIP_FUSE_MASK) >> OTP_DICE_SKIP_FUSE_SHIFT)

#define OTP_BOOT_FAIL_PORT_FUSE_IDX   (15u)
#define OTP_BOOT_FAIL_PORT_FUSE_SHIFT (24u)
#define OTP_BOOT_FAIL_PORT_FUSE_MASK  (0x7000000u)
#define OTP_BOOT_FAIL_PORT_FUSE_WIDTH (3u)
#define OTP_BOOT_FAIL_PORT_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_BOOT_FAIL_PORT_FUSE_IDX] & OTP_BOOT_FAIL_PORT_FUSE_MASK) >> OTP_BOOT_FAIL_PORT_FUSE_SHIFT)

#define OTP_BOOT_FAIL_PIN_FUSE_IDX   (15u)
#define OTP_BOOT_FAIL_PIN_FUSE_SHIFT (27u)
#define OTP_BOOT_FAIL_PIN_FUSE_MASK  (0xF8000000u)
#define OTP_BOOT_FAIL_PIN_FUSE_WIDTH (5u)
#define OTP_BOOT_FAIL_PIN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_BOOT_FAIL_PIN_FUSE_IDX] & OTP_BOOT_FAIL_PIN_FUSE_MASK) >> OTP_BOOT_FAIL_PIN_FUSE_SHIFT)

/* Fuse Word BOOT_CFG1 Index 16 */
#define OTP_BOOT_CFG1_FUSE_IDX (16u)

#define OTP_BOOT_CFG1_FUSE_VALUE()        (OCOTP->OTP_SHADOW[OTP_BOOT_CFG1_FUSE_IDX])
#define OTP_QSPI_AUTO_PROBE_EN_FUSE_IDX   (16u)
#define OTP_QSPI_AUTO_PROBE_EN_FUSE_SHIFT (0u)
#define OTP_QSPI_AUTO_PROBE_EN_FUSE_MASK  (0x1u)
#define OTP_QSPI_AUTO_PROBE_EN_FUSE_WIDTH (1u)
#define OTP_QSPI_AUTO_PROBE_EN_FUSE_VALUE()                                                     \
    ((OCOTP->OTP_SHADOW[OTP_QSPI_AUTO_PROBE_EN_FUSE_IDX] & OTP_QSPI_AUTO_PROBE_EN_FUSE_MASK) >> \
     OTP_QSPI_AUTO_PROBE_EN_FUSE_SHIFT)

#define OTP_QSPI_PROBE_TYPE_FUSE_IDX   (16u)
#define OTP_QSPI_PROBE_TYPE_FUSE_SHIFT (1u)
#define OTP_QSPI_PROBE_TYPE_FUSE_MASK  (0xEu)
#define OTP_QSPI_PROBE_TYPE_FUSE_WIDTH (3u)
#define OTP_QSPI_PROBE_TYPE_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_QSPI_PROBE_TYPE_FUSE_IDX] & OTP_QSPI_PROBE_TYPE_FUSE_MASK) >> \
     OTP_QSPI_PROBE_TYPE_FUSE_SHIFT)

#define OTP_QSPI_FLASH_TYPE_FUSE_IDX   (16u)
#define OTP_QSPI_FLASH_TYPE_FUSE_SHIFT (4u)
#define OTP_QSPI_FLASH_TYPE_FUSE_MASK  (0x70u)
#define OTP_QSPI_FLASH_TYPE_FUSE_WIDTH (3u)
#define OTP_QSPI_FLASH_TYPE_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_QSPI_FLASH_TYPE_FUSE_IDX] & OTP_QSPI_FLASH_TYPE_FUSE_MASK) >> \
     OTP_QSPI_FLASH_TYPE_FUSE_SHIFT)

#define OTP_QSPI_DUMMY_CYCLES_FUSE_IDX   (16u)
#define OTP_QSPI_DUMMY_CYCLES_FUSE_SHIFT (7u)
#define OTP_QSPI_DUMMY_CYCLES_FUSE_MASK  (0x780u)
#define OTP_QSPI_DUMMY_CYCLES_FUSE_WIDTH (4u)
#define OTP_QSPI_DUMMY_CYCLES_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_QSPI_DUMMY_CYCLES_FUSE_IDX] & OTP_QSPI_DUMMY_CYCLES_FUSE_MASK) >> \
     OTP_QSPI_DUMMY_CYCLES_FUSE_SHIFT)

#define OTP_QSPI_FREQUENCY_FUSE_IDX   (16u)
#define OTP_QSPI_FREQUENCY_FUSE_SHIFT (11u)
#define OTP_QSPI_FREQUENCY_FUSE_MASK  (0x3800u)
#define OTP_QSPI_FREQUENCY_FUSE_WIDTH (3u)
#define OTP_QSPI_FREQUENCY_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_QSPI_FREQUENCY_FUSE_IDX] & OTP_QSPI_FREQUENCY_FUSE_MASK) >> OTP_QSPI_FREQUENCY_FUSE_SHIFT)

#define OTP_QSPI_RESET_PIN_ENABLE_FUSE_IDX   (16u)
#define OTP_QSPI_RESET_PIN_ENABLE_FUSE_SHIFT (14u)
#define OTP_QSPI_RESET_PIN_ENABLE_FUSE_MASK  (0x4000u)
#define OTP_QSPI_RESET_PIN_ENABLE_FUSE_WIDTH (1u)
#define OTP_QSPI_RESET_PIN_ENABLE_FUSE_VALUE()                                                        \
    ((OCOTP->OTP_SHADOW[OTP_QSPI_RESET_PIN_ENABLE_FUSE_IDX] & OTP_QSPI_RESET_PIN_ENABLE_FUSE_MASK) >> \
     OTP_QSPI_RESET_PIN_ENABLE_FUSE_SHIFT)

#define OTP_QSPI_RESET_PIN_FUSE_IDX   (16u)
#define OTP_QSPI_RESET_PIN_FUSE_SHIFT (15u)
#define OTP_QSPI_RESET_PIN_FUSE_MASK  (0x7F8000u)
#define OTP_QSPI_RESET_PIN_FUSE_WIDTH (8u)
#define OTP_QSPI_RESET_PIN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_QSPI_RESET_PIN_FUSE_IDX] & OTP_QSPI_RESET_PIN_FUSE_MASK) >> OTP_QSPI_RESET_PIN_FUSE_SHIFT)

#define OTP_QSPI_HOLD_TIME_FUSE_IDX   (16u)
#define OTP_QSPI_HOLD_TIME_FUSE_SHIFT (23u)
#define OTP_QSPI_HOLD_TIME_FUSE_MASK  (0x1800000u)
#define OTP_QSPI_HOLD_TIME_FUSE_WIDTH (2u)
#define OTP_QSPI_HOLD_TIME_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_QSPI_HOLD_TIME_FUSE_IDX] & OTP_QSPI_HOLD_TIME_FUSE_MASK) >> OTP_QSPI_HOLD_TIME_FUSE_SHIFT)

#define OTP_QSPI_PWR_HOLD_TIME_FUSE_IDX   (16u)
#define OTP_QSPI_PWR_HOLD_TIME_FUSE_SHIFT (25u)
#define OTP_QSPI_PWR_HOLD_TIME_FUSE_MASK  (0x1E000000u)
#define OTP_QSPI_PWR_HOLD_TIME_FUSE_WIDTH (4u)
#define OTP_QSPI_PWR_HOLD_TIME_FUSE_VALUE()                                                     \
    ((OCOTP->OTP_SHADOW[OTP_QSPI_PWR_HOLD_TIME_FUSE_IDX] & OTP_QSPI_PWR_HOLD_TIME_FUSE_MASK) >> \
     OTP_QSPI_PWR_HOLD_TIME_FUSE_SHIFT)

/* Fuse Word BOOT_CFG2 Index 17 */
#define OTP_BOOT_CFG2_FUSE_IDX (17u)

#define OTP_BOOT_CFG2_FUSE_VALUE()     (OCOTP->OTP_SHADOW[OTP_BOOT_CFG2_FUSE_IDX])
#define OTP_QSPI_IMAGE_SIZE_FUSE_IDX   (17u)
#define OTP_QSPI_IMAGE_SIZE_FUSE_SHIFT (0u)
#define OTP_QSPI_IMAGE_SIZE_FUSE_MASK  (0xFu)
#define OTP_QSPI_IMAGE_SIZE_FUSE_WIDTH (4u)
#define OTP_QSPI_IMAGE_SIZE_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_QSPI_IMAGE_SIZE_FUSE_IDX] & OTP_QSPI_IMAGE_SIZE_FUSE_MASK) >> \
     OTP_QSPI_IMAGE_SIZE_FUSE_SHIFT)

#define OTP_QSPI_DELAY_CELL_NUM_FUSE_IDX   (17u)
#define OTP_QSPI_DELAY_CELL_NUM_FUSE_SHIFT (4u)
#define OTP_QSPI_DELAY_CELL_NUM_FUSE_MASK  (0x7F0u)
#define OTP_QSPI_DELAY_CELL_NUM_FUSE_WIDTH (7u)
#define OTP_QSPI_DELAY_CELL_NUM_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_QSPI_DELAY_CELL_NUM_FUSE_IDX] & OTP_QSPI_DELAY_CELL_NUM_FUSE_MASK) >> \
     OTP_QSPI_DELAY_CELL_NUM_FUSE_SHIFT)

#define OTP_QSPI_IMAGE_OFFSET_FUSE_IDX   (17u)
#define OTP_QSPI_IMAGE_OFFSET_FUSE_SHIFT (11u)
#define OTP_QSPI_IMAGE_OFFSET_FUSE_MASK  (0x1FF800u)
#define OTP_QSPI_IMAGE_OFFSET_FUSE_WIDTH (10u)
#define OTP_QSPI_IMAGE_OFFSET_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_QSPI_IMAGE_OFFSET_FUSE_IDX] & OTP_QSPI_IMAGE_OFFSET_FUSE_MASK) >> \
     OTP_QSPI_IMAGE_OFFSET_FUSE_SHIFT)

/* Fuse Word BOOT_CFG3 Index 18 */
#define OTP_BOOT_CFG3_FUSE_IDX (18u)

#define OTP_BOOT_CFG3_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_BOOT_CFG3_FUSE_IDX])
#define OTP_ROTK0_USAGE_FUSE_IDX   (18u)
#define OTP_ROTK0_USAGE_FUSE_SHIFT (0u)
#define OTP_ROTK0_USAGE_FUSE_MASK  (0x7u)
#define OTP_ROTK0_USAGE_FUSE_WIDTH (3u)
#define OTP_ROTK0_USAGE_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_ROTK0_USAGE_FUSE_IDX] & OTP_ROTK0_USAGE_FUSE_MASK) >> OTP_ROTK0_USAGE_FUSE_SHIFT)

#define OTP_ROTK1_USAGE_FUSE_IDX   (18u)
#define OTP_ROTK1_USAGE_FUSE_SHIFT (3u)
#define OTP_ROTK1_USAGE_FUSE_MASK  (0x38u)
#define OTP_ROTK1_USAGE_FUSE_WIDTH (3u)
#define OTP_ROTK1_USAGE_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_ROTK1_USAGE_FUSE_IDX] & OTP_ROTK1_USAGE_FUSE_MASK) >> OTP_ROTK1_USAGE_FUSE_SHIFT)

#define OTP_ROTK2_USAGE_FUSE_IDX   (18u)
#define OTP_ROTK2_USAGE_FUSE_SHIFT (6u)
#define OTP_ROTK2_USAGE_FUSE_MASK  (0x1C0u)
#define OTP_ROTK2_USAGE_FUSE_WIDTH (3u)
#define OTP_ROTK2_USAGE_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_ROTK2_USAGE_FUSE_IDX] & OTP_ROTK2_USAGE_FUSE_MASK) >> OTP_ROTK2_USAGE_FUSE_SHIFT)

#define OTP_ROTK3_USAGE_FUSE_IDX   (18u)
#define OTP_ROTK3_USAGE_FUSE_SHIFT (9u)
#define OTP_ROTK3_USAGE_FUSE_MASK  (0xE00u)
#define OTP_ROTK3_USAGE_FUSE_WIDTH (3u)
#define OTP_ROTK3_USAGE_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_ROTK3_USAGE_FUSE_IDX] & OTP_ROTK3_USAGE_FUSE_MASK) >> OTP_ROTK3_USAGE_FUSE_SHIFT)

#define OTP_ITRC_ZEROIZE_FUSE_IDX   (18u)
#define OTP_ITRC_ZEROIZE_FUSE_SHIFT (12u)
#define OTP_ITRC_ZEROIZE_FUSE_MASK  (0x3000u)
#define OTP_ITRC_ZEROIZE_FUSE_WIDTH (2u)
#define OTP_ITRC_ZEROIZE_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_ITRC_ZEROIZE_FUSE_IDX] & OTP_ITRC_ZEROIZE_FUSE_MASK) >> OTP_ITRC_ZEROIZE_FUSE_SHIFT)

#define OTP_PRINCE_ENABLE_FUSE_IDX   (18u)
#define OTP_PRINCE_ENABLE_FUSE_SHIFT (14u)
#define OTP_PRINCE_ENABLE_FUSE_MASK  (0x4000u)
#define OTP_PRINCE_ENABLE_FUSE_WIDTH (1u)
#define OTP_PRINCE_ENABLE_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_PRINCE_ENABLE_FUSE_IDX] & OTP_PRINCE_ENABLE_FUSE_MASK) >> OTP_PRINCE_ENABLE_FUSE_SHIFT)

#define OTP_ENF_CNSA_FUSE_IDX   (18u)
#define OTP_ENF_CNSA_FUSE_SHIFT (15u)
#define OTP_ENF_CNSA_FUSE_MASK  (0x18000u)
#define OTP_ENF_CNSA_FUSE_WIDTH (2u)
#define OTP_ENF_CNSA_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_ENF_CNSA_FUSE_IDX] & OTP_ENF_CNSA_FUSE_MASK) >> OTP_ENF_CNSA_FUSE_SHIFT)

#define OTP_ENABLE_CRC_CHECK_FUSE_IDX   (18u)
#define OTP_ENABLE_CRC_CHECK_FUSE_SHIFT (17u)
#define OTP_ENABLE_CRC_CHECK_FUSE_MASK  (0x60000u)
#define OTP_ENABLE_CRC_CHECK_FUSE_WIDTH (2u)
#define OTP_ENABLE_CRC_CHECK_FUSE_VALUE()                                                   \
    ((OCOTP->OTP_SHADOW[OTP_ENABLE_CRC_CHECK_FUSE_IDX] & OTP_ENABLE_CRC_CHECK_FUSE_MASK) >> \
     OTP_ENABLE_CRC_CHECK_FUSE_SHIFT)

#define OTP_USE_PUF_FUSE_IDX   (18u)
#define OTP_USE_PUF_FUSE_SHIFT (19u)
#define OTP_USE_PUF_FUSE_MASK  (0x80000u)
#define OTP_USE_PUF_FUSE_WIDTH (1u)
#define OTP_USE_PUF_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_USE_PUF_FUSE_IDX] & OTP_USE_PUF_FUSE_MASK) >> OTP_USE_PUF_FUSE_SHIFT)

#define OTP_PUF_BLOCK_ENROLL_FUSE_IDX   (18u)
#define OTP_PUF_BLOCK_ENROLL_FUSE_SHIFT (20u)
#define OTP_PUF_BLOCK_ENROLL_FUSE_MASK  (0x100000u)
#define OTP_PUF_BLOCK_ENROLL_FUSE_WIDTH (1u)
#define OTP_PUF_BLOCK_ENROLL_FUSE_VALUE()                                                   \
    ((OCOTP->OTP_SHADOW[OTP_PUF_BLOCK_ENROLL_FUSE_IDX] & OTP_PUF_BLOCK_ENROLL_FUSE_MASK) >> \
     OTP_PUF_BLOCK_ENROLL_FUSE_SHIFT)

#define OTP_PUF_BLOCK_SET_KEY_FUSE_IDX   (18u)
#define OTP_PUF_BLOCK_SET_KEY_FUSE_SHIFT (21u)
#define OTP_PUF_BLOCK_SET_KEY_FUSE_MASK  (0x200000u)
#define OTP_PUF_BLOCK_SET_KEY_FUSE_WIDTH (1u)
#define OTP_PUF_BLOCK_SET_KEY_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_PUF_BLOCK_SET_KEY_FUSE_IDX] & OTP_PUF_BLOCK_SET_KEY_FUSE_MASK) >> \
     OTP_PUF_BLOCK_SET_KEY_FUSE_SHIFT)

#define OTP_FIPS_KDF_STEN_FUSE_IDX   (18u)
#define OTP_FIPS_KDF_STEN_FUSE_SHIFT (22u)
#define OTP_FIPS_KDF_STEN_FUSE_MASK  (0x400000u)
#define OTP_FIPS_KDF_STEN_FUSE_WIDTH (1u)
#define OTP_FIPS_KDF_STEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_FIPS_KDF_STEN_FUSE_IDX] & OTP_FIPS_KDF_STEN_FUSE_MASK) >> OTP_FIPS_KDF_STEN_FUSE_SHIFT)

#define OTP_FIPS_CMAC_STEN_FUSE_IDX   (18u)
#define OTP_FIPS_CMAC_STEN_FUSE_SHIFT (23u)
#define OTP_FIPS_CMAC_STEN_FUSE_MASK  (0x800000u)
#define OTP_FIPS_CMAC_STEN_FUSE_WIDTH (1u)
#define OTP_FIPS_CMAC_STEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_FIPS_CMAC_STEN_FUSE_IDX] & OTP_FIPS_CMAC_STEN_FUSE_MASK) >> OTP_FIPS_CMAC_STEN_FUSE_SHIFT)

#define OTP_FIPS_DRBG_STEN_FUSE_IDX   (18u)
#define OTP_FIPS_DRBG_STEN_FUSE_SHIFT (24u)
#define OTP_FIPS_DRBG_STEN_FUSE_MASK  (0x1000000u)
#define OTP_FIPS_DRBG_STEN_FUSE_WIDTH (1u)
#define OTP_FIPS_DRBG_STEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_FIPS_DRBG_STEN_FUSE_IDX] & OTP_FIPS_DRBG_STEN_FUSE_MASK) >> OTP_FIPS_DRBG_STEN_FUSE_SHIFT)

#define OTP_FIPS_ECDSA_STEN_FUSE_IDX   (18u)
#define OTP_FIPS_ECDSA_STEN_FUSE_SHIFT (25u)
#define OTP_FIPS_ECDSA_STEN_FUSE_MASK  (0x2000000u)
#define OTP_FIPS_ECDSA_STEN_FUSE_WIDTH (1u)
#define OTP_FIPS_ECDSA_STEN_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_FIPS_ECDSA_STEN_FUSE_IDX] & OTP_FIPS_ECDSA_STEN_FUSE_MASK) >> \
     OTP_FIPS_ECDSA_STEN_FUSE_SHIFT)

#define OTP_FIPS_AES_STEN_FUSE_IDX   (18u)
#define OTP_FIPS_AES_STEN_FUSE_SHIFT (26u)
#define OTP_FIPS_AES_STEN_FUSE_MASK  (0x4000000u)
#define OTP_FIPS_AES_STEN_FUSE_WIDTH (1u)
#define OTP_FIPS_AES_STEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_FIPS_AES_STEN_FUSE_IDX] & OTP_FIPS_AES_STEN_FUSE_MASK) >> OTP_FIPS_AES_STEN_FUSE_SHIFT)

#define OTP_FIPS_SHA_STEN_FUSE_IDX   (18u)
#define OTP_FIPS_SHA_STEN_FUSE_SHIFT (27u)
#define OTP_FIPS_SHA_STEN_FUSE_MASK  (0x8000000u)
#define OTP_FIPS_SHA_STEN_FUSE_WIDTH (1u)
#define OTP_FIPS_SHA_STEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_FIPS_SHA_STEN_FUSE_IDX] & OTP_FIPS_SHA_STEN_FUSE_MASK) >> OTP_FIPS_SHA_STEN_FUSE_SHIFT)

#define OTP_SKIP_PM_SIGN_VERIFCATION_FUSE_IDX   (18u)
#define OTP_SKIP_PM_SIGN_VERIFCATION_FUSE_SHIFT (28u)
#define OTP_SKIP_PM_SIGN_VERIFCATION_FUSE_MASK  (0x30000000u)
#define OTP_SKIP_PM_SIGN_VERIFCATION_FUSE_WIDTH (2u)
#define OTP_SKIP_PM_SIGN_VERIFCATION_FUSE_VALUE()                                                           \
    ((OCOTP->OTP_SHADOW[OTP_SKIP_PM_SIGN_VERIFCATION_FUSE_IDX] & OTP_SKIP_PM_SIGN_VERIFCATION_FUSE_MASK) >> \
     OTP_SKIP_PM_SIGN_VERIFCATION_FUSE_SHIFT)

/* Fuse Word BOOT_CFG4 Index 19 */
#define OTP_BOOT_CFG4_FUSE_IDX (19u)

#define OTP_BOOT_CFG4_FUSE_VALUE()     (OCOTP->OTP_SHADOW[OTP_BOOT_CFG4_FUSE_IDX])
#define OTP_RECOVERY_OFFSET_FUSE_IDX   (19u)
#define OTP_RECOVERY_OFFSET_FUSE_SHIFT (0u)
#define OTP_RECOVERY_OFFSET_FUSE_MASK  (0xFFFFFFFFu)
#define OTP_RECOVERY_OFFSET_FUSE_WIDTH (32u)
#define OTP_RECOVERY_OFFSET_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_RECOVERY_OFFSET_FUSE_IDX] & OTP_RECOVERY_OFFSET_FUSE_MASK) >> \
     OTP_RECOVERY_OFFSET_FUSE_SHIFT)

/* Fuse Word BOOT_CFG5 Index 20 */
#define OTP_BOOT_CFG5_FUSE_IDX (20u)

#define OTP_BOOT_CFG5_FUSE_VALUE()          (OCOTP->OTP_SHADOW[OTP_BOOT_CFG5_FUSE_IDX])
#define OTP_KEY_STORE_START_ADDR_FUSE_IDX   (20u)
#define OTP_KEY_STORE_START_ADDR_FUSE_SHIFT (0u)
#define OTP_KEY_STORE_START_ADDR_FUSE_MASK  (0xFFFFFFFFu)
#define OTP_KEY_STORE_START_ADDR_FUSE_WIDTH (32u)
#define OTP_KEY_STORE_START_ADDR_FUSE_VALUE()                                                       \
    ((OCOTP->OTP_SHADOW[OTP_KEY_STORE_START_ADDR_FUSE_IDX] & OTP_KEY_STORE_START_ADDR_FUSE_MASK) >> \
     OTP_KEY_STORE_START_ADDR_FUSE_SHIFT)

/* Fuse Word BOOT_CFG6 Index 21 */
#define OTP_BOOT_CFG6_FUSE_IDX (21u)

#define OTP_BOOT_CFG6_FUSE_VALUE()        (OCOTP->OTP_SHADOW[OTP_BOOT_CFG6_FUSE_IDX])
#define OTP_KEY_STORE_END_ADDR_FUSE_IDX   (21u)
#define OTP_KEY_STORE_END_ADDR_FUSE_SHIFT (0u)
#define OTP_KEY_STORE_END_ADDR_FUSE_MASK  (0xFFFFFFFFu)
#define OTP_KEY_STORE_END_ADDR_FUSE_WIDTH (32u)
#define OTP_KEY_STORE_END_ADDR_FUSE_VALUE()                                                     \
    ((OCOTP->OTP_SHADOW[OTP_KEY_STORE_END_ADDR_FUSE_IDX] & OTP_KEY_STORE_END_ADDR_FUSE_MASK) >> \
     OTP_KEY_STORE_END_ADDR_FUSE_SHIFT)

/* Fuse Word SEC_BOOT_CFG0 Index 22 */
#define OTP_SEC_BOOT_CFG0_FUSE_IDX (22u)

#define OTP_SEC_BOOT_CFG0_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_SEC_BOOT_CFG0_FUSE_IDX])
#define OTP_REVOKE_ROOTKEY_FUSE_IDX    (22u)
#define OTP_REVOKE_ROOTKEY_FUSE_SHIFT  (0u)
#define OTP_REVOKE_ROOTKEY_FUSE_MASK   (0xFu)
#define OTP_REVOKE_ROOTKEY_FUSE_WIDTH  (4u)
#define OTP_REVOKE_ROOTKEY_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_REVOKE_ROOTKEY_FUSE_IDX] & OTP_REVOKE_ROOTKEY_FUSE_MASK) >> OTP_REVOKE_ROOTKEY_FUSE_SHIFT)

#define OTP_FA_MODE_EN_FUSE_IDX   (22u)
#define OTP_FA_MODE_EN_FUSE_SHIFT (4u)
#define OTP_FA_MODE_EN_FUSE_MASK  (0x10u)
#define OTP_FA_MODE_EN_FUSE_WIDTH (1u)
#define OTP_FA_MODE_EN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_FA_MODE_EN_FUSE_IDX] & OTP_FA_MODE_EN_FUSE_MASK) >> OTP_FA_MODE_EN_FUSE_SHIFT)

#define OTP_DICE_SKIP_CSR_FUSE_IDX   (22u)
#define OTP_DICE_SKIP_CSR_FUSE_SHIFT (4u)
#define OTP_DICE_SKIP_CSR_FUSE_MASK  (0x10u)
#define OTP_DICE_SKIP_CSR_FUSE_WIDTH (1u)
#define OTP_DICE_SKIP_CSR_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DICE_SKIP_CSR_FUSE_IDX] & OTP_DICE_SKIP_CSR_FUSE_MASK) >> OTP_DICE_SKIP_CSR_FUSE_SHIFT)

/* Fuse Word SEC_BOOT_CFG1 Index 23 */
#define OTP_SEC_BOOT_CFG1_FUSE_IDX (23u)

#define OTP_SEC_BOOT_CFG1_FUSE_VALUE()  (OCOTP->OTP_SHADOW[OTP_SEC_BOOT_CFG1_FUSE_IDX])
#define OTP_DAP_VENDOR_USAGE_FUSE_IDX   (23u)
#define OTP_DAP_VENDOR_USAGE_FUSE_SHIFT (0u)
#define OTP_DAP_VENDOR_USAGE_FUSE_MASK  (0xFFFFu)
#define OTP_DAP_VENDOR_USAGE_FUSE_WIDTH (16u)
#define OTP_DAP_VENDOR_USAGE_FUSE_VALUE()                                                   \
    ((OCOTP->OTP_SHADOW[OTP_DAP_VENDOR_USAGE_FUSE_IDX] & OTP_DAP_VENDOR_USAGE_FUSE_MASK) >> \
     OTP_DAP_VENDOR_USAGE_FUSE_SHIFT)

/* Fuse Word SEC_BOOT_CFG2 Index 24 */
#define OTP_SEC_BOOT_CFG2_FUSE_IDX (24u)

#define OTP_SEC_BOOT_CFG2_FUSE_VALUE()     (OCOTP->OTP_SHADOW[OTP_SEC_BOOT_CFG2_FUSE_IDX])
#define OTP_REVOKE_IMG_KEY_15_0_FUSE_IDX   (24u)
#define OTP_REVOKE_IMG_KEY_15_0_FUSE_SHIFT (0u)
#define OTP_REVOKE_IMG_KEY_15_0_FUSE_MASK  (0xFFFFu)
#define OTP_REVOKE_IMG_KEY_15_0_FUSE_WIDTH (16u)
#define OTP_REVOKE_IMG_KEY_15_0_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_REVOKE_IMG_KEY_15_0_FUSE_IDX] & OTP_REVOKE_IMG_KEY_15_0_FUSE_MASK) >> \
     OTP_REVOKE_IMG_KEY_15_0_FUSE_SHIFT)

/* Fuse Word SEC_BOOT_CFG3 Index 25 */
#define OTP_SEC_BOOT_CFG3_FUSE_IDX (25u)

#define OTP_SEC_BOOT_CFG3_FUSE_VALUE()      (OCOTP->OTP_SHADOW[OTP_SEC_BOOT_CFG3_FUSE_IDX])
#define OTP_REVOKE_IMG_KEY_31_16_FUSE_IDX   (25u)
#define OTP_REVOKE_IMG_KEY_31_16_FUSE_SHIFT (0u)
#define OTP_REVOKE_IMG_KEY_31_16_FUSE_MASK  (0xFFFFu)
#define OTP_REVOKE_IMG_KEY_31_16_FUSE_WIDTH (16u)
#define OTP_REVOKE_IMG_KEY_31_16_FUSE_VALUE()                                                       \
    ((OCOTP->OTP_SHADOW[OTP_REVOKE_IMG_KEY_31_16_FUSE_IDX] & OTP_REVOKE_IMG_KEY_31_16_FUSE_MASK) >> \
     OTP_REVOKE_IMG_KEY_31_16_FUSE_SHIFT)

/* Fuse Word SEC_BOOT_CFG4 Index 26 */
#define OTP_SEC_BOOT_CFG4_FUSE_IDX (26u)

#define OTP_SEC_BOOT_CFG4_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_SEC_BOOT_CFG4_FUSE_IDX])
/* Fuse Word SEC_BOOT_CFG5 Index 27 */
#define OTP_SEC_BOOT_CFG5_FUSE_IDX (27u)

#define OTP_SEC_BOOT_CFG5_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_SEC_BOOT_CFG5_FUSE_IDX])
/* Fuse Word SEC_BOOT_CFG6 Index 28 */
#define OTP_SEC_BOOT_CFG6_FUSE_IDX (28u)

#define OTP_SEC_BOOT_CFG6_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_SEC_BOOT_CFG6_FUSE_IDX])
/* Fuse Word SEC_BOOT_CFG7 Index 29 */
#define OTP_SEC_BOOT_CFG7_FUSE_IDX (29u)

#define OTP_SEC_BOOT_CFG7_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_SEC_BOOT_CFG7_FUSE_IDX])
/* Fuse Word SEC_BOOT_CFG8 Index 30 */
#define OTP_SEC_BOOT_CFG8_FUSE_IDX (30u)

#define OTP_SEC_BOOT_CFG8_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_SEC_BOOT_CFG8_FUSE_IDX])
/* Fuse Word DCFG_CC_SOCU_NS Index 31 */
#define OTP_DCFG_CC_SOCU_NS_FUSE_IDX (31u)

#define OTP_DCFG_CC_SOCU_NS_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_DCFG_CC_SOCU_NS_FUSE_IDX])
#define OTP_CRC8_NS_FUSE_IDX             (31u)
#define OTP_CRC8_NS_FUSE_SHIFT           (0u)
#define OTP_CRC8_NS_FUSE_MASK            (0xFFu)
#define OTP_CRC8_NS_FUSE_WIDTH           (8u)
#define OTP_CRC8_NS_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_CRC8_NS_FUSE_IDX] & OTP_CRC8_NS_FUSE_MASK) >> OTP_CRC8_NS_FUSE_SHIFT)

#define OTP_DFLT_NIDEN_NS_FUSE_IDX   (31u)
#define OTP_DFLT_NIDEN_NS_FUSE_SHIFT (8u)
#define OTP_DFLT_NIDEN_NS_FUSE_MASK  (0x100u)
#define OTP_DFLT_NIDEN_NS_FUSE_WIDTH (1u)
#define OTP_DFLT_NIDEN_NS_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_NIDEN_NS_FUSE_IDX] & OTP_DFLT_NIDEN_NS_FUSE_MASK) >> OTP_DFLT_NIDEN_NS_FUSE_SHIFT)

#define OTP_DFLT_DBGEN_NS_FUSE_IDX   (31u)
#define OTP_DFLT_DBGEN_NS_FUSE_SHIFT (9u)
#define OTP_DFLT_DBGEN_NS_FUSE_MASK  (0x200u)
#define OTP_DFLT_DBGEN_NS_FUSE_WIDTH (1u)
#define OTP_DFLT_DBGEN_NS_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_DBGEN_NS_FUSE_IDX] & OTP_DFLT_DBGEN_NS_FUSE_MASK) >> OTP_DFLT_DBGEN_NS_FUSE_SHIFT)

#define OTP_DFLT_SPNIDEN_NS_FUSE_IDX   (31u)
#define OTP_DFLT_SPNIDEN_NS_FUSE_SHIFT (10u)
#define OTP_DFLT_SPNIDEN_NS_FUSE_MASK  (0x400u)
#define OTP_DFLT_SPNIDEN_NS_FUSE_WIDTH (1u)
#define OTP_DFLT_SPNIDEN_NS_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_SPNIDEN_NS_FUSE_IDX] & OTP_DFLT_SPNIDEN_NS_FUSE_MASK) >> \
     OTP_DFLT_SPNIDEN_NS_FUSE_SHIFT)

#define OTP_DFLT_SPIDEN_NS_FUSE_IDX   (31u)
#define OTP_DFLT_SPIDEN_NS_FUSE_SHIFT (11u)
#define OTP_DFLT_SPIDEN_NS_FUSE_MASK  (0x800u)
#define OTP_DFLT_SPIDEN_NS_FUSE_WIDTH (1u)
#define OTP_DFLT_SPIDEN_NS_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_SPIDEN_NS_FUSE_IDX] & OTP_DFLT_SPIDEN_NS_FUSE_MASK) >> OTP_DFLT_SPIDEN_NS_FUSE_SHIFT)

#define OTP_DFLT_TAPEN_NS_FUSE_IDX   (31u)
#define OTP_DFLT_TAPEN_NS_FUSE_SHIFT (12u)
#define OTP_DFLT_TAPEN_NS_FUSE_MASK  (0x1000u)
#define OTP_DFLT_TAPEN_NS_FUSE_WIDTH (1u)
#define OTP_DFLT_TAPEN_NS_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_TAPEN_NS_FUSE_IDX] & OTP_DFLT_TAPEN_NS_FUSE_MASK) >> OTP_DFLT_TAPEN_NS_FUSE_SHIFT)

#define OTP_DFLT_CPU1NIDEN_NS_FUSE_IDX   (31u)
#define OTP_DFLT_CPU1NIDEN_NS_FUSE_SHIFT (13u)
#define OTP_DFLT_CPU1NIDEN_NS_FUSE_MASK  (0x2000u)
#define OTP_DFLT_CPU1NIDEN_NS_FUSE_WIDTH (1u)
#define OTP_DFLT_CPU1NIDEN_NS_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_CPU1NIDEN_NS_FUSE_IDX] & OTP_DFLT_CPU1NIDEN_NS_FUSE_MASK) >> \
     OTP_DFLT_CPU1NIDEN_NS_FUSE_SHIFT)

#define OTP_DFLT_CPU1DBGEN_NS_FUSE_IDX   (31u)
#define OTP_DFLT_CPU1DBGEN_NS_FUSE_SHIFT (14u)
#define OTP_DFLT_CPU1DBGEN_NS_FUSE_MASK  (0x4000u)
#define OTP_DFLT_CPU1DBGEN_NS_FUSE_WIDTH (1u)
#define OTP_DFLT_CPU1DBGEN_NS_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_CPU1DBGEN_NS_FUSE_IDX] & OTP_DFLT_CPU1DBGEN_NS_FUSE_MASK) >> \
     OTP_DFLT_CPU1DBGEN_NS_FUSE_SHIFT)

#define OTP_DFLT_CPU2NIDEN_NS_FUSE_IDX   (31u)
#define OTP_DFLT_CPU2NIDEN_NS_FUSE_SHIFT (15u)
#define OTP_DFLT_CPU2NIDEN_NS_FUSE_MASK  (0x8000u)
#define OTP_DFLT_CPU2NIDEN_NS_FUSE_WIDTH (1u)
#define OTP_DFLT_CPU2NIDEN_NS_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_CPU2NIDEN_NS_FUSE_IDX] & OTP_DFLT_CPU2NIDEN_NS_FUSE_MASK) >> \
     OTP_DFLT_CPU2NIDEN_NS_FUSE_SHIFT)

#define OTP_DFLT_CPU2DBGEN_NS_FUSE_IDX   (31u)
#define OTP_DFLT_CPU2DBGEN_NS_FUSE_SHIFT (16u)
#define OTP_DFLT_CPU2DBGEN_NS_FUSE_MASK  (0x10000u)
#define OTP_DFLT_CPU2DBGEN_NS_FUSE_WIDTH (1u)
#define OTP_DFLT_CPU2DBGEN_NS_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_CPU2DBGEN_NS_FUSE_IDX] & OTP_DFLT_CPU2DBGEN_NS_FUSE_MASK) >> \
     OTP_DFLT_CPU2DBGEN_NS_FUSE_SHIFT)

#define OTP_DFLT_ISPCMDEN_NS_FUSE_IDX   (31u)
#define OTP_DFLT_ISPCMDEN_NS_FUSE_SHIFT (17u)
#define OTP_DFLT_ISPCMDEN_NS_FUSE_MASK  (0x20000u)
#define OTP_DFLT_ISPCMDEN_NS_FUSE_WIDTH (1u)
#define OTP_DFLT_ISPCMDEN_NS_FUSE_VALUE()                                                   \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_ISPCMDEN_NS_FUSE_IDX] & OTP_DFLT_ISPCMDEN_NS_FUSE_MASK) >> \
     OTP_DFLT_ISPCMDEN_NS_FUSE_SHIFT)

#define OTP_DFLT_FACMDEN_NS_FUSE_IDX   (31u)
#define OTP_DFLT_FACMDEN_NS_FUSE_SHIFT (18u)
#define OTP_DFLT_FACMDEN_NS_FUSE_MASK  (0x40000u)
#define OTP_DFLT_FACMDEN_NS_FUSE_WIDTH (1u)
#define OTP_DFLT_FACMDEN_NS_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_FACMDEN_NS_FUSE_IDX] & OTP_DFLT_FACMDEN_NS_FUSE_MASK) >> \
     OTP_DFLT_FACMDEN_NS_FUSE_SHIFT)

#define OTP_PINNED_NIDEN_NS_FUSE_IDX   (31u)
#define OTP_PINNED_NIDEN_NS_FUSE_SHIFT (19u)
#define OTP_PINNED_NIDEN_NS_FUSE_MASK  (0x80000u)
#define OTP_PINNED_NIDEN_NS_FUSE_WIDTH (1u)
#define OTP_PINNED_NIDEN_NS_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_NIDEN_NS_FUSE_IDX] & OTP_PINNED_NIDEN_NS_FUSE_MASK) >> \
     OTP_PINNED_NIDEN_NS_FUSE_SHIFT)

#define OTP_PINNED_DBGEN_NS_FUSE_IDX   (31u)
#define OTP_PINNED_DBGEN_NS_FUSE_SHIFT (20u)
#define OTP_PINNED_DBGEN_NS_FUSE_MASK  (0x100000u)
#define OTP_PINNED_DBGEN_NS_FUSE_WIDTH (1u)
#define OTP_PINNED_DBGEN_NS_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_DBGEN_NS_FUSE_IDX] & OTP_PINNED_DBGEN_NS_FUSE_MASK) >> \
     OTP_PINNED_DBGEN_NS_FUSE_SHIFT)

#define OTP_PINNED_SPNIDEN_NS_FUSE_IDX   (31u)
#define OTP_PINNED_SPNIDEN_NS_FUSE_SHIFT (21u)
#define OTP_PINNED_SPNIDEN_NS_FUSE_MASK  (0x200000u)
#define OTP_PINNED_SPNIDEN_NS_FUSE_WIDTH (1u)
#define OTP_PINNED_SPNIDEN_NS_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_SPNIDEN_NS_FUSE_IDX] & OTP_PINNED_SPNIDEN_NS_FUSE_MASK) >> \
     OTP_PINNED_SPNIDEN_NS_FUSE_SHIFT)

#define OTP_PINNED_SPIDEN_NS_FUSE_IDX   (31u)
#define OTP_PINNED_SPIDEN_NS_FUSE_SHIFT (22u)
#define OTP_PINNED_SPIDEN_NS_FUSE_MASK  (0x400000u)
#define OTP_PINNED_SPIDEN_NS_FUSE_WIDTH (1u)
#define OTP_PINNED_SPIDEN_NS_FUSE_VALUE()                                                   \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_SPIDEN_NS_FUSE_IDX] & OTP_PINNED_SPIDEN_NS_FUSE_MASK) >> \
     OTP_PINNED_SPIDEN_NS_FUSE_SHIFT)

#define OTP_PINNED_TAPEN_NS_FUSE_IDX   (31u)
#define OTP_PINNED_TAPEN_NS_FUSE_SHIFT (23u)
#define OTP_PINNED_TAPEN_NS_FUSE_MASK  (0x800000u)
#define OTP_PINNED_TAPEN_NS_FUSE_WIDTH (1u)
#define OTP_PINNED_TAPEN_NS_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_TAPEN_NS_FUSE_IDX] & OTP_PINNED_TAPEN_NS_FUSE_MASK) >> \
     OTP_PINNED_TAPEN_NS_FUSE_SHIFT)

#define OTP_PINNED_CPU1NIDEN_NS_FUSE_IDX   (31u)
#define OTP_PINNED_CPU1NIDEN_NS_FUSE_SHIFT (24u)
#define OTP_PINNED_CPU1NIDEN_NS_FUSE_MASK  (0x1000000u)
#define OTP_PINNED_CPU1NIDEN_NS_FUSE_WIDTH (1u)
#define OTP_PINNED_CPU1NIDEN_NS_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_CPU1NIDEN_NS_FUSE_IDX] & OTP_PINNED_CPU1NIDEN_NS_FUSE_MASK) >> \
     OTP_PINNED_CPU1NIDEN_NS_FUSE_SHIFT)

#define OTP_PINNED_CPU1DBGEN_NS_FUSE_IDX   (31u)
#define OTP_PINNED_CPU1DBGEN_NS_FUSE_SHIFT (25u)
#define OTP_PINNED_CPU1DBGEN_NS_FUSE_MASK  (0x2000000u)
#define OTP_PINNED_CPU1DBGEN_NS_FUSE_WIDTH (1u)
#define OTP_PINNED_CPU1DBGEN_NS_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_CPU1DBGEN_NS_FUSE_IDX] & OTP_PINNED_CPU1DBGEN_NS_FUSE_MASK) >> \
     OTP_PINNED_CPU1DBGEN_NS_FUSE_SHIFT)

#define OTP_PINNED_CPU2NIDEN_NS_FUSE_IDX   (31u)
#define OTP_PINNED_CPU2NIDEN_NS_FUSE_SHIFT (26u)
#define OTP_PINNED_CPU2NIDEN_NS_FUSE_MASK  (0x4000000u)
#define OTP_PINNED_CPU2NIDEN_NS_FUSE_WIDTH (1u)
#define OTP_PINNED_CPU2NIDEN_NS_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_CPU2NIDEN_NS_FUSE_IDX] & OTP_PINNED_CPU2NIDEN_NS_FUSE_MASK) >> \
     OTP_PINNED_CPU2NIDEN_NS_FUSE_SHIFT)

#define OTP_PINNED_CPU2DBGEN_NS_FUSE_IDX   (31u)
#define OTP_PINNED_CPU2DBGEN_NS_FUSE_SHIFT (27u)
#define OTP_PINNED_CPU2DBGEN_NS_FUSE_MASK  (0x8000000u)
#define OTP_PINNED_CPU2DBGEN_NS_FUSE_WIDTH (1u)
#define OTP_PINNED_CPU2DBGEN_NS_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_CPU2DBGEN_NS_FUSE_IDX] & OTP_PINNED_CPU2DBGEN_NS_FUSE_MASK) >> \
     OTP_PINNED_CPU2DBGEN_NS_FUSE_SHIFT)

#define OTP_PINNED_ISPCMDEN_NS_FUSE_IDX   (31u)
#define OTP_PINNED_ISPCMDEN_NS_FUSE_SHIFT (28u)
#define OTP_PINNED_ISPCMDEN_NS_FUSE_MASK  (0x10000000u)
#define OTP_PINNED_ISPCMDEN_NS_FUSE_WIDTH (1u)
#define OTP_PINNED_ISPCMDEN_NS_FUSE_VALUE()                                                     \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_ISPCMDEN_NS_FUSE_IDX] & OTP_PINNED_ISPCMDEN_NS_FUSE_MASK) >> \
     OTP_PINNED_ISPCMDEN_NS_FUSE_SHIFT)

#define OTP_PINNED_FACMDEN_NS_FUSE_IDX   (31u)
#define OTP_PINNED_FACMDEN_NS_FUSE_SHIFT (29u)
#define OTP_PINNED_FACMDEN_NS_FUSE_MASK  (0x20000000u)
#define OTP_PINNED_FACMDEN_NS_FUSE_WIDTH (1u)
#define OTP_PINNED_FACMDEN_NS_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_FACMDEN_NS_FUSE_IDX] & OTP_PINNED_FACMDEN_NS_FUSE_MASK) >> \
     OTP_PINNED_FACMDEN_NS_FUSE_SHIFT)

#define OTP_FORCE_UUID_MATCH_NS_FUSE_IDX   (31u)
#define OTP_FORCE_UUID_MATCH_NS_FUSE_SHIFT (30u)
#define OTP_FORCE_UUID_MATCH_NS_FUSE_MASK  (0x40000000u)
#define OTP_FORCE_UUID_MATCH_NS_FUSE_WIDTH (1u)
#define OTP_FORCE_UUID_MATCH_NS_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_FORCE_UUID_MATCH_NS_FUSE_IDX] & OTP_FORCE_UUID_MATCH_NS_FUSE_MASK) >> \
     OTP_FORCE_UUID_MATCH_NS_FUSE_SHIFT)

/* Fuse Word USB_ID Index 32 */
#define OTP_USB_ID_FUSE_IDX (32u)

#define OTP_USB_VID_FUSE_IDX   (32u)
#define OTP_USB_VID_FUSE_SHIFT (0u)
#define OTP_USB_VID_FUSE_MASK  (0xFFFFu)
#define OTP_USB_VID_FUSE_WIDTH (16u)

#define OTP_USB_PID_FUSE_IDX   (32u)
#define OTP_USB_PID_FUSE_SHIFT (16u)
#define OTP_USB_PID_FUSE_MASK  (0xFFFF0000u)
#define OTP_USB_PID_FUSE_WIDTH (16u)

/* Fuse Word DCFG_CC_SOCU Index 33 */
#define OTP_DCFG_CC_SOCU_FUSE_IDX (33u)

#define OTP_DCFG_CC_SOCU_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_DCFG_CC_SOCU_FUSE_IDX])
#define OTP_CRC8_FUSE_IDX             (33u)
#define OTP_CRC8_FUSE_SHIFT           (0u)
#define OTP_CRC8_FUSE_MASK            (0xFFu)
#define OTP_CRC8_FUSE_WIDTH           (8u)
#define OTP_CRC8_FUSE_VALUE()         ((OCOTP->OTP_SHADOW[OTP_CRC8_FUSE_IDX] & OTP_CRC8_FUSE_MASK) >> OTP_CRC8_FUSE_SHIFT)

#define OTP_DFLT_NIDEN_FUSE_IDX   (33u)
#define OTP_DFLT_NIDEN_FUSE_SHIFT (8u)
#define OTP_DFLT_NIDEN_FUSE_MASK  (0x100u)
#define OTP_DFLT_NIDEN_FUSE_WIDTH (1u)
#define OTP_DFLT_NIDEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_NIDEN_FUSE_IDX] & OTP_DFLT_NIDEN_FUSE_MASK) >> OTP_DFLT_NIDEN_FUSE_SHIFT)

#define OTP_DFLT_DBGEN_FUSE_IDX   (33u)
#define OTP_DFLT_DBGEN_FUSE_SHIFT (9u)
#define OTP_DFLT_DBGEN_FUSE_MASK  (0x200u)
#define OTP_DFLT_DBGEN_FUSE_WIDTH (1u)
#define OTP_DFLT_DBGEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_DBGEN_FUSE_IDX] & OTP_DFLT_DBGEN_FUSE_MASK) >> OTP_DFLT_DBGEN_FUSE_SHIFT)

#define OTP_DFLT_SPNIDEN_FUSE_IDX   (33u)
#define OTP_DFLT_SPNIDEN_FUSE_SHIFT (10u)
#define OTP_DFLT_SPNIDEN_FUSE_MASK  (0x400u)
#define OTP_DFLT_SPNIDEN_FUSE_WIDTH (1u)
#define OTP_DFLT_SPNIDEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_SPNIDEN_FUSE_IDX] & OTP_DFLT_SPNIDEN_FUSE_MASK) >> OTP_DFLT_SPNIDEN_FUSE_SHIFT)

#define OTP_DFLT_SPIDEN_FUSE_IDX   (33u)
#define OTP_DFLT_SPIDEN_FUSE_SHIFT (11u)
#define OTP_DFLT_SPIDEN_FUSE_MASK  (0x800u)
#define OTP_DFLT_SPIDEN_FUSE_WIDTH (1u)
#define OTP_DFLT_SPIDEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_SPIDEN_FUSE_IDX] & OTP_DFLT_SPIDEN_FUSE_MASK) >> OTP_DFLT_SPIDEN_FUSE_SHIFT)

#define OTP_DFLT_TAPEN_FUSE_IDX   (33u)
#define OTP_DFLT_TAPEN_FUSE_SHIFT (12u)
#define OTP_DFLT_TAPEN_FUSE_MASK  (0x1000u)
#define OTP_DFLT_TAPEN_FUSE_WIDTH (1u)
#define OTP_DFLT_TAPEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_TAPEN_FUSE_IDX] & OTP_DFLT_TAPEN_FUSE_MASK) >> OTP_DFLT_TAPEN_FUSE_SHIFT)

#define OTP_DFLT_CPU1NIDEN_FUSE_IDX   (33u)
#define OTP_DFLT_CPU1NIDEN_FUSE_SHIFT (13u)
#define OTP_DFLT_CPU1NIDEN_FUSE_MASK  (0x2000u)
#define OTP_DFLT_CPU1NIDEN_FUSE_WIDTH (1u)
#define OTP_DFLT_CPU1NIDEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_CPU1NIDEN_FUSE_IDX] & OTP_DFLT_CPU1NIDEN_FUSE_MASK) >> OTP_DFLT_CPU1NIDEN_FUSE_SHIFT)

#define OTP_DFLT_CPU1DBGEN_FUSE_IDX   (33u)
#define OTP_DFLT_CPU1DBGEN_FUSE_SHIFT (14u)
#define OTP_DFLT_CPU1DBGEN_FUSE_MASK  (0x4000u)
#define OTP_DFLT_CPU1DBGEN_FUSE_WIDTH (1u)
#define OTP_DFLT_CPU1DBGEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_CPU1DBGEN_FUSE_IDX] & OTP_DFLT_CPU1DBGEN_FUSE_MASK) >> OTP_DFLT_CPU1DBGEN_FUSE_SHIFT)

#define OTP_DFLT_CPU2NIDEN_FUSE_IDX   (33u)
#define OTP_DFLT_CPU2NIDEN_FUSE_SHIFT (15u)
#define OTP_DFLT_CPU2NIDEN_FUSE_MASK  (0x8000u)
#define OTP_DFLT_CPU2NIDEN_FUSE_WIDTH (1u)
#define OTP_DFLT_CPU2NIDEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_CPU2NIDEN_FUSE_IDX] & OTP_DFLT_CPU2NIDEN_FUSE_MASK) >> OTP_DFLT_CPU2NIDEN_FUSE_SHIFT)

#define OTP_DFLT_CPU2DBGEN_FUSE_IDX   (33u)
#define OTP_DFLT_CPU2DBGEN_FUSE_SHIFT (16u)
#define OTP_DFLT_CPU2DBGEN_FUSE_MASK  (0x10000u)
#define OTP_DFLT_CPU2DBGEN_FUSE_WIDTH (1u)
#define OTP_DFLT_CPU2DBGEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_CPU2DBGEN_FUSE_IDX] & OTP_DFLT_CPU2DBGEN_FUSE_MASK) >> OTP_DFLT_CPU2DBGEN_FUSE_SHIFT)

#define OTP_DFLT_ISPCMDEN_FUSE_IDX   (33u)
#define OTP_DFLT_ISPCMDEN_FUSE_SHIFT (17u)
#define OTP_DFLT_ISPCMDEN_FUSE_MASK  (0x20000u)
#define OTP_DFLT_ISPCMDEN_FUSE_WIDTH (1u)
#define OTP_DFLT_ISPCMDEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_ISPCMDEN_FUSE_IDX] & OTP_DFLT_ISPCMDEN_FUSE_MASK) >> OTP_DFLT_ISPCMDEN_FUSE_SHIFT)

#define OTP_DFLT_FACMDEN_FUSE_IDX   (33u)
#define OTP_DFLT_FACMDEN_FUSE_SHIFT (18u)
#define OTP_DFLT_FACMDEN_FUSE_MASK  (0x40000u)
#define OTP_DFLT_FACMDEN_FUSE_WIDTH (1u)
#define OTP_DFLT_FACMDEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_FACMDEN_FUSE_IDX] & OTP_DFLT_FACMDEN_FUSE_MASK) >> OTP_DFLT_FACMDEN_FUSE_SHIFT)

#define OTP_PINNED_NIDEN_FUSE_IDX   (33u)
#define OTP_PINNED_NIDEN_FUSE_SHIFT (19u)
#define OTP_PINNED_NIDEN_FUSE_MASK  (0x80000u)
#define OTP_PINNED_NIDEN_FUSE_WIDTH (1u)
#define OTP_PINNED_NIDEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_NIDEN_FUSE_IDX] & OTP_PINNED_NIDEN_FUSE_MASK) >> OTP_PINNED_NIDEN_FUSE_SHIFT)

#define OTP_PINNED_DBGEN_FUSE_IDX   (33u)
#define OTP_PINNED_DBGEN_FUSE_SHIFT (20u)
#define OTP_PINNED_DBGEN_FUSE_MASK  (0x100000u)
#define OTP_PINNED_DBGEN_FUSE_WIDTH (1u)
#define OTP_PINNED_DBGEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_DBGEN_FUSE_IDX] & OTP_PINNED_DBGEN_FUSE_MASK) >> OTP_PINNED_DBGEN_FUSE_SHIFT)

#define OTP_PINNED_SPNIDEN_FUSE_IDX   (33u)
#define OTP_PINNED_SPNIDEN_FUSE_SHIFT (21u)
#define OTP_PINNED_SPNIDEN_FUSE_MASK  (0x200000u)
#define OTP_PINNED_SPNIDEN_FUSE_WIDTH (1u)
#define OTP_PINNED_SPNIDEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_SPNIDEN_FUSE_IDX] & OTP_PINNED_SPNIDEN_FUSE_MASK) >> OTP_PINNED_SPNIDEN_FUSE_SHIFT)

#define OTP_PINNED_SPIDEN_FUSE_IDX   (33u)
#define OTP_PINNED_SPIDEN_FUSE_SHIFT (22u)
#define OTP_PINNED_SPIDEN_FUSE_MASK  (0x400000u)
#define OTP_PINNED_SPIDEN_FUSE_WIDTH (1u)
#define OTP_PINNED_SPIDEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_SPIDEN_FUSE_IDX] & OTP_PINNED_SPIDEN_FUSE_MASK) >> OTP_PINNED_SPIDEN_FUSE_SHIFT)

#define OTP_PINNED_TAPEN_FUSE_IDX   (33u)
#define OTP_PINNED_TAPEN_FUSE_SHIFT (23u)
#define OTP_PINNED_TAPEN_FUSE_MASK  (0x800000u)
#define OTP_PINNED_TAPEN_FUSE_WIDTH (1u)
#define OTP_PINNED_TAPEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_TAPEN_FUSE_IDX] & OTP_PINNED_TAPEN_FUSE_MASK) >> OTP_PINNED_TAPEN_FUSE_SHIFT)

#define OTP_PINNED_CPU1NIDEN_FUSE_IDX   (33u)
#define OTP_PINNED_CPU1NIDEN_FUSE_SHIFT (24u)
#define OTP_PINNED_CPU1NIDEN_FUSE_MASK  (0x1000000u)
#define OTP_PINNED_CPU1NIDEN_FUSE_WIDTH (1u)
#define OTP_PINNED_CPU1NIDEN_FUSE_VALUE()                                                   \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_CPU1NIDEN_FUSE_IDX] & OTP_PINNED_CPU1NIDEN_FUSE_MASK) >> \
     OTP_PINNED_CPU1NIDEN_FUSE_SHIFT)

#define OTP_PINNED_CPU1DBGEN_FUSE_IDX   (33u)
#define OTP_PINNED_CPU1DBGEN_FUSE_SHIFT (25u)
#define OTP_PINNED_CPU1DBGEN_FUSE_MASK  (0x2000000u)
#define OTP_PINNED_CPU1DBGEN_FUSE_WIDTH (1u)
#define OTP_PINNED_CPU1DBGEN_FUSE_VALUE()                                                   \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_CPU1DBGEN_FUSE_IDX] & OTP_PINNED_CPU1DBGEN_FUSE_MASK) >> \
     OTP_PINNED_CPU1DBGEN_FUSE_SHIFT)

#define OTP_PINNED_CPU2NIDEN_FUSE_IDX   (33u)
#define OTP_PINNED_CPU2NIDEN_FUSE_SHIFT (26u)
#define OTP_PINNED_CPU2NIDEN_FUSE_MASK  (0x4000000u)
#define OTP_PINNED_CPU2NIDEN_FUSE_WIDTH (1u)
#define OTP_PINNED_CPU2NIDEN_FUSE_VALUE()                                                   \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_CPU2NIDEN_FUSE_IDX] & OTP_PINNED_CPU2NIDEN_FUSE_MASK) >> \
     OTP_PINNED_CPU2NIDEN_FUSE_SHIFT)

#define OTP_PINNED_CPU2DBGEN_FUSE_IDX   (33u)
#define OTP_PINNED_CPU2DBGEN_FUSE_SHIFT (27u)
#define OTP_PINNED_CPU2DBGEN_FUSE_MASK  (0x8000000u)
#define OTP_PINNED_CPU2DBGEN_FUSE_WIDTH (1u)
#define OTP_PINNED_CPU2DBGEN_FUSE_VALUE()                                                   \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_CPU2DBGEN_FUSE_IDX] & OTP_PINNED_CPU2DBGEN_FUSE_MASK) >> \
     OTP_PINNED_CPU2DBGEN_FUSE_SHIFT)

#define OTP_PINNED_ISPCMDEN_FUSE_IDX   (33u)
#define OTP_PINNED_ISPCMDEN_FUSE_SHIFT (28u)
#define OTP_PINNED_ISPCMDEN_FUSE_MASK  (0x10000000u)
#define OTP_PINNED_ISPCMDEN_FUSE_WIDTH (1u)
#define OTP_PINNED_ISPCMDEN_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_ISPCMDEN_FUSE_IDX] & OTP_PINNED_ISPCMDEN_FUSE_MASK) >> \
     OTP_PINNED_ISPCMDEN_FUSE_SHIFT)

#define OTP_PINNED_FACMDEN_FUSE_IDX   (33u)
#define OTP_PINNED_FACMDEN_FUSE_SHIFT (29u)
#define OTP_PINNED_FACMDEN_FUSE_MASK  (0x20000000u)
#define OTP_PINNED_FACMDEN_FUSE_WIDTH (1u)
#define OTP_PINNED_FACMDEN_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_FACMDEN_FUSE_IDX] & OTP_PINNED_FACMDEN_FUSE_MASK) >> OTP_PINNED_FACMDEN_FUSE_SHIFT)

#define OTP_FORCE_UUID_MATCH_FUSE_IDX   (33u)
#define OTP_FORCE_UUID_MATCH_FUSE_SHIFT (30u)
#define OTP_FORCE_UUID_MATCH_FUSE_MASK  (0x40000000u)
#define OTP_FORCE_UUID_MATCH_FUSE_WIDTH (1u)
#define OTP_FORCE_UUID_MATCH_FUSE_VALUE()                                                   \
    ((OCOTP->OTP_SHADOW[OTP_FORCE_UUID_MATCH_FUSE_IDX] & OTP_FORCE_UUID_MATCH_FUSE_MASK) >> \
     OTP_FORCE_UUID_MATCH_FUSE_SHIFT)

/* Fuse Word DCFG_CC_SOCU_AP Index 34 */
#define OTP_DCFG_CC_SOCU_AP_FUSE_IDX (34u)

#define OTP_DCFG_CC_SOCU_AP_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_DCFG_CC_SOCU_AP_FUSE_IDX])
#define OTP_CRC8_AP_FUSE_IDX             (34u)
#define OTP_CRC8_AP_FUSE_SHIFT           (0u)
#define OTP_CRC8_AP_FUSE_MASK            (0xFFu)
#define OTP_CRC8_AP_FUSE_WIDTH           (8u)
#define OTP_CRC8_AP_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_CRC8_AP_FUSE_IDX] & OTP_CRC8_AP_FUSE_MASK) >> OTP_CRC8_AP_FUSE_SHIFT)

#define OTP_DFLT_NIDEN_AP_FUSE_IDX   (34u)
#define OTP_DFLT_NIDEN_AP_FUSE_SHIFT (8u)
#define OTP_DFLT_NIDEN_AP_FUSE_MASK  (0x100u)
#define OTP_DFLT_NIDEN_AP_FUSE_WIDTH (1u)
#define OTP_DFLT_NIDEN_AP_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_NIDEN_AP_FUSE_IDX] & OTP_DFLT_NIDEN_AP_FUSE_MASK) >> OTP_DFLT_NIDEN_AP_FUSE_SHIFT)

#define OTP_DFLT_DBGEN_AP_FUSE_IDX   (34u)
#define OTP_DFLT_DBGEN_AP_FUSE_SHIFT (9u)
#define OTP_DFLT_DBGEN_AP_FUSE_MASK  (0x200u)
#define OTP_DFLT_DBGEN_AP_FUSE_WIDTH (1u)
#define OTP_DFLT_DBGEN_AP_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_DBGEN_AP_FUSE_IDX] & OTP_DFLT_DBGEN_AP_FUSE_MASK) >> OTP_DFLT_DBGEN_AP_FUSE_SHIFT)

#define OTP_DFLT_SPNIDEN_AP_FUSE_IDX   (34u)
#define OTP_DFLT_SPNIDEN_AP_FUSE_SHIFT (10u)
#define OTP_DFLT_SPNIDEN_AP_FUSE_MASK  (0x400u)
#define OTP_DFLT_SPNIDEN_AP_FUSE_WIDTH (1u)
#define OTP_DFLT_SPNIDEN_AP_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_SPNIDEN_AP_FUSE_IDX] & OTP_DFLT_SPNIDEN_AP_FUSE_MASK) >> \
     OTP_DFLT_SPNIDEN_AP_FUSE_SHIFT)

#define OTP_DFLT_SPIDEN_AP_FUSE_IDX   (34u)
#define OTP_DFLT_SPIDEN_AP_FUSE_SHIFT (11u)
#define OTP_DFLT_SPIDEN_AP_FUSE_MASK  (0x800u)
#define OTP_DFLT_SPIDEN_AP_FUSE_WIDTH (1u)
#define OTP_DFLT_SPIDEN_AP_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_SPIDEN_AP_FUSE_IDX] & OTP_DFLT_SPIDEN_AP_FUSE_MASK) >> OTP_DFLT_SPIDEN_AP_FUSE_SHIFT)

#define OTP_DFLT_TAPEN_AP_FUSE_IDX   (34u)
#define OTP_DFLT_TAPEN_AP_FUSE_SHIFT (12u)
#define OTP_DFLT_TAPEN_AP_FUSE_MASK  (0x1000u)
#define OTP_DFLT_TAPEN_AP_FUSE_WIDTH (1u)
#define OTP_DFLT_TAPEN_AP_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_TAPEN_AP_FUSE_IDX] & OTP_DFLT_TAPEN_AP_FUSE_MASK) >> OTP_DFLT_TAPEN_AP_FUSE_SHIFT)

#define OTP_DFLT_CPU1NIDEN_AP_FUSE_IDX   (34u)
#define OTP_DFLT_CPU1NIDEN_AP_FUSE_SHIFT (13u)
#define OTP_DFLT_CPU1NIDEN_AP_FUSE_MASK  (0x2000u)
#define OTP_DFLT_CPU1NIDEN_AP_FUSE_WIDTH (1u)
#define OTP_DFLT_CPU1NIDEN_AP_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_CPU1NIDEN_AP_FUSE_IDX] & OTP_DFLT_CPU1NIDEN_AP_FUSE_MASK) >> \
     OTP_DFLT_CPU1NIDEN_AP_FUSE_SHIFT)

#define OTP_DFLT_CPU1DBGEN_AP_FUSE_IDX   (34u)
#define OTP_DFLT_CPU1DBGEN_AP_FUSE_SHIFT (14u)
#define OTP_DFLT_CPU1DBGEN_AP_FUSE_MASK  (0x4000u)
#define OTP_DFLT_CPU1DBGEN_AP_FUSE_WIDTH (1u)
#define OTP_DFLT_CPU1DBGEN_AP_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_CPU1DBGEN_AP_FUSE_IDX] & OTP_DFLT_CPU1DBGEN_AP_FUSE_MASK) >> \
     OTP_DFLT_CPU1DBGEN_AP_FUSE_SHIFT)

#define OTP_DFLT_CPU2NIDEN_AP_FUSE_IDX   (34u)
#define OTP_DFLT_CPU2NIDEN_AP_FUSE_SHIFT (15u)
#define OTP_DFLT_CPU2NIDEN_AP_FUSE_MASK  (0x8000u)
#define OTP_DFLT_CPU2NIDEN_AP_FUSE_WIDTH (1u)
#define OTP_DFLT_CPU2NIDEN_AP_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_CPU2NIDEN_AP_FUSE_IDX] & OTP_DFLT_CPU2NIDEN_AP_FUSE_MASK) >> \
     OTP_DFLT_CPU2NIDEN_AP_FUSE_SHIFT)

#define OTP_DFLT_CPU2DBGEN_AP_FUSE_IDX   (34u)
#define OTP_DFLT_CPU2DBGEN_AP_FUSE_SHIFT (16u)
#define OTP_DFLT_CPU2DBGEN_AP_FUSE_MASK  (0x10000u)
#define OTP_DFLT_CPU2DBGEN_AP_FUSE_WIDTH (1u)
#define OTP_DFLT_CPU2DBGEN_AP_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_CPU2DBGEN_AP_FUSE_IDX] & OTP_DFLT_CPU2DBGEN_AP_FUSE_MASK) >> \
     OTP_DFLT_CPU2DBGEN_AP_FUSE_SHIFT)

#define OTP_DFLT_ISPCMDEN_AP_FUSE_IDX   (34u)
#define OTP_DFLT_ISPCMDEN_AP_FUSE_SHIFT (17u)
#define OTP_DFLT_ISPCMDEN_AP_FUSE_MASK  (0x20000u)
#define OTP_DFLT_ISPCMDEN_AP_FUSE_WIDTH (1u)
#define OTP_DFLT_ISPCMDEN_AP_FUSE_VALUE()                                                   \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_ISPCMDEN_AP_FUSE_IDX] & OTP_DFLT_ISPCMDEN_AP_FUSE_MASK) >> \
     OTP_DFLT_ISPCMDEN_AP_FUSE_SHIFT)

#define OTP_DFLT_FACMDEN_AP_FUSE_IDX   (34u)
#define OTP_DFLT_FACMDEN_AP_FUSE_SHIFT (18u)
#define OTP_DFLT_FACMDEN_AP_FUSE_MASK  (0x40000u)
#define OTP_DFLT_FACMDEN_AP_FUSE_WIDTH (1u)
#define OTP_DFLT_FACMDEN_AP_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_DFLT_FACMDEN_AP_FUSE_IDX] & OTP_DFLT_FACMDEN_AP_FUSE_MASK) >> \
     OTP_DFLT_FACMDEN_AP_FUSE_SHIFT)

#define OTP_PINNED_NIDEN_AP_FUSE_IDX   (34u)
#define OTP_PINNED_NIDEN_AP_FUSE_SHIFT (19u)
#define OTP_PINNED_NIDEN_AP_FUSE_MASK  (0x80000u)
#define OTP_PINNED_NIDEN_AP_FUSE_WIDTH (1u)
#define OTP_PINNED_NIDEN_AP_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_NIDEN_AP_FUSE_IDX] & OTP_PINNED_NIDEN_AP_FUSE_MASK) >> \
     OTP_PINNED_NIDEN_AP_FUSE_SHIFT)

#define OTP_PINNED_DBGEN_AP_FUSE_IDX   (34u)
#define OTP_PINNED_DBGEN_AP_FUSE_SHIFT (20u)
#define OTP_PINNED_DBGEN_AP_FUSE_MASK  (0x100000u)
#define OTP_PINNED_DBGEN_AP_FUSE_WIDTH (1u)
#define OTP_PINNED_DBGEN_AP_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_DBGEN_AP_FUSE_IDX] & OTP_PINNED_DBGEN_AP_FUSE_MASK) >> \
     OTP_PINNED_DBGEN_AP_FUSE_SHIFT)

#define OTP_PINNED_SPNIDEN_AP_FUSE_IDX   (34u)
#define OTP_PINNED_SPNIDEN_AP_FUSE_SHIFT (21u)
#define OTP_PINNED_SPNIDEN_AP_FUSE_MASK  (0x200000u)
#define OTP_PINNED_SPNIDEN_AP_FUSE_WIDTH (1u)
#define OTP_PINNED_SPNIDEN_AP_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_SPNIDEN_AP_FUSE_IDX] & OTP_PINNED_SPNIDEN_AP_FUSE_MASK) >> \
     OTP_PINNED_SPNIDEN_AP_FUSE_SHIFT)

#define OTP_PINNED_SPIDEN_AP_FUSE_IDX   (34u)
#define OTP_PINNED_SPIDEN_AP_FUSE_SHIFT (22u)
#define OTP_PINNED_SPIDEN_AP_FUSE_MASK  (0x400000u)
#define OTP_PINNED_SPIDEN_AP_FUSE_WIDTH (1u)
#define OTP_PINNED_SPIDEN_AP_FUSE_VALUE()                                                   \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_SPIDEN_AP_FUSE_IDX] & OTP_PINNED_SPIDEN_AP_FUSE_MASK) >> \
     OTP_PINNED_SPIDEN_AP_FUSE_SHIFT)

#define OTP_PINNED_TAPEN_AP_FUSE_IDX   (34u)
#define OTP_PINNED_TAPEN_AP_FUSE_SHIFT (23u)
#define OTP_PINNED_TAPEN_AP_FUSE_MASK  (0x800000u)
#define OTP_PINNED_TAPEN_AP_FUSE_WIDTH (1u)
#define OTP_PINNED_TAPEN_AP_FUSE_VALUE()                                                  \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_TAPEN_AP_FUSE_IDX] & OTP_PINNED_TAPEN_AP_FUSE_MASK) >> \
     OTP_PINNED_TAPEN_AP_FUSE_SHIFT)

#define OTP_PINNED_CPU1NIDEN_AP_FUSE_IDX   (34u)
#define OTP_PINNED_CPU1NIDEN_AP_FUSE_SHIFT (24u)
#define OTP_PINNED_CPU1NIDEN_AP_FUSE_MASK  (0x1000000u)
#define OTP_PINNED_CPU1NIDEN_AP_FUSE_WIDTH (1u)
#define OTP_PINNED_CPU1NIDEN_AP_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_CPU1NIDEN_AP_FUSE_IDX] & OTP_PINNED_CPU1NIDEN_AP_FUSE_MASK) >> \
     OTP_PINNED_CPU1NIDEN_AP_FUSE_SHIFT)

#define OTP_PINNED_CPU1DBGEN_AP_FUSE_IDX   (34u)
#define OTP_PINNED_CPU1DBGEN_AP_FUSE_SHIFT (25u)
#define OTP_PINNED_CPU1DBGEN_AP_FUSE_MASK  (0x2000000u)
#define OTP_PINNED_CPU1DBGEN_AP_FUSE_WIDTH (1u)
#define OTP_PINNED_CPU1DBGEN_AP_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_CPU1DBGEN_AP_FUSE_IDX] & OTP_PINNED_CPU1DBGEN_AP_FUSE_MASK) >> \
     OTP_PINNED_CPU1DBGEN_AP_FUSE_SHIFT)

#define OTP_PINNED_CPU2NIDEN_AP_FUSE_IDX   (34u)
#define OTP_PINNED_CPU2NIDEN_AP_FUSE_SHIFT (26u)
#define OTP_PINNED_CPU2NIDEN_AP_FUSE_MASK  (0x4000000u)
#define OTP_PINNED_CPU2NIDEN_AP_FUSE_WIDTH (1u)
#define OTP_PINNED_CPU2NIDEN_AP_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_CPU2NIDEN_AP_FUSE_IDX] & OTP_PINNED_CPU2NIDEN_AP_FUSE_MASK) >> \
     OTP_PINNED_CPU2NIDEN_AP_FUSE_SHIFT)

#define OTP_PINNED_CPU2DBGEN_AP_FUSE_IDX   (34u)
#define OTP_PINNED_CPU2DBGEN_AP_FUSE_SHIFT (27u)
#define OTP_PINNED_CPU2DBGEN_AP_FUSE_MASK  (0x8000000u)
#define OTP_PINNED_CPU2DBGEN_AP_FUSE_WIDTH (1u)
#define OTP_PINNED_CPU2DBGEN_AP_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_CPU2DBGEN_AP_FUSE_IDX] & OTP_PINNED_CPU2DBGEN_AP_FUSE_MASK) >> \
     OTP_PINNED_CPU2DBGEN_AP_FUSE_SHIFT)

#define OTP_PINNED_ISPCMDEN_AP_FUSE_IDX   (34u)
#define OTP_PINNED_ISPCMDEN_AP_FUSE_SHIFT (28u)
#define OTP_PINNED_ISPCMDEN_AP_FUSE_MASK  (0x10000000u)
#define OTP_PINNED_ISPCMDEN_AP_FUSE_WIDTH (1u)
#define OTP_PINNED_ISPCMDEN_AP_FUSE_VALUE()                                                     \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_ISPCMDEN_AP_FUSE_IDX] & OTP_PINNED_ISPCMDEN_AP_FUSE_MASK) >> \
     OTP_PINNED_ISPCMDEN_AP_FUSE_SHIFT)

#define OTP_PINNED_FACMDEN_AP_FUSE_IDX   (34u)
#define OTP_PINNED_FACMDEN_AP_FUSE_SHIFT (29u)
#define OTP_PINNED_FACMDEN_AP_FUSE_MASK  (0x20000000u)
#define OTP_PINNED_FACMDEN_AP_FUSE_WIDTH (1u)
#define OTP_PINNED_FACMDEN_AP_FUSE_VALUE()                                                    \
    ((OCOTP->OTP_SHADOW[OTP_PINNED_FACMDEN_AP_FUSE_IDX] & OTP_PINNED_FACMDEN_AP_FUSE_MASK) >> \
     OTP_PINNED_FACMDEN_AP_FUSE_SHIFT)

#define OTP_FORCE_UUID_MATCH_AP_FUSE_IDX   (34u)
#define OTP_FORCE_UUID_MATCH_AP_FUSE_SHIFT (30u)
#define OTP_FORCE_UUID_MATCH_AP_FUSE_MASK  (0x40000000u)
#define OTP_FORCE_UUID_MATCH_AP_FUSE_WIDTH (1u)
#define OTP_FORCE_UUID_MATCH_AP_FUSE_VALUE()                                                      \
    ((OCOTP->OTP_SHADOW[OTP_FORCE_UUID_MATCH_AP_FUSE_IDX] & OTP_FORCE_UUID_MATCH_AP_FUSE_MASK) >> \
     OTP_FORCE_UUID_MATCH_AP_FUSE_SHIFT)

/* Fuse Word PRINCE_GCM_IV_STORE_START_ADDR Index 35 */
#define OTP_PRINCE_GCM_IV_STORE_START_ADDR_FUSE_IDX (35u)

#define OTP_PRINCE_GCM_IV_STORE_START_ADDR_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_PRINCE_GCM_IV_STORE_START_ADDR_FUSE_IDX])
/* Fuse Word PRINCE_GCM_IV_STORE_END_ADDR Index 36 */
#define OTP_PRINCE_GCM_IV_STORE_END_ADDR_FUSE_IDX (36u)

#define OTP_PRINCE_GCM_IV_STORE_END_ADDR_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_PRINCE_GCM_IV_STORE_END_ADDR_FUSE_IDX])
/* Fuse Word PRINCE_GCM_REG0_START_ADDR Index 37 */
#define OTP_PRINCE_GCM_REG0_START_ADDR_FUSE_IDX (37u)

#define OTP_PRINCE_GCM_REG0_START_ADDR_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_PRINCE_GCM_REG0_START_ADDR_FUSE_IDX])
#define OTP_IPED_REG0_START_ADDR_FUSE_IDX           (37u)
#define OTP_IPED_REG0_START_ADDR_FUSE_SHIFT         (0u)
#define OTP_IPED_REG0_START_ADDR_FUSE_MASK          (0xFFFFFFu)
#define OTP_IPED_REG0_START_ADDR_FUSE_WIDTH         (24u)
#define OTP_IPED_REG0_START_ADDR_FUSE_VALUE()                                                       \
    ((OCOTP->OTP_SHADOW[OTP_IPED_REG0_START_ADDR_FUSE_IDX] & OTP_IPED_REG0_START_ADDR_FUSE_MASK) >> \
     OTP_IPED_REG0_START_ADDR_FUSE_SHIFT)

#define OTP_ENABLE_REG0_FUSE_IDX   (37u)
#define OTP_ENABLE_REG0_FUSE_SHIFT (30u)
#define OTP_ENABLE_REG0_FUSE_MASK  (0xC0000000u)
#define OTP_ENABLE_REG0_FUSE_WIDTH (2u)
#define OTP_ENABLE_REG0_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_ENABLE_REG0_FUSE_IDX] & OTP_ENABLE_REG0_FUSE_MASK) >> OTP_ENABLE_REG0_FUSE_SHIFT)

/* Fuse Word PRINCE_GCM_REG0_END_ADDR Index 38 */
#define OTP_PRINCE_GCM_REG0_END_ADDR_FUSE_IDX (38u)

#define OTP_PRINCE_GCM_REG0_END_ADDR_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_PRINCE_GCM_REG0_END_ADDR_FUSE_IDX])

/* Fuse Word PRINCE_GCM_REG1_START_ADDR Index 39 */
#define OTP_PRINCE_GCM_REG1_START_ADDR_FUSE_IDX (39u)

#define OTP_PRINCE_GCM_REG1_START_ADDR_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_PRINCE_GCM_REG1_START_ADDR_FUSE_IDX])
#define OTP_IPED_REG1_START_ADDR_FUSE_IDX           (39u)
#define OTP_IPED_REG1_START_ADDR_FUSE_SHIFT         (0u)
#define OTP_IPED_REG1_START_ADDR_FUSE_MASK          (0xFFFFFFu)
#define OTP_IPED_REG1_START_ADDR_FUSE_WIDTH         (24u)
#define OTP_IPED_REG1_START_ADDR_FUSE_VALUE()                                                       \
    ((OCOTP->OTP_SHADOW[OTP_IPED_REG1_START_ADDR_FUSE_IDX] & OTP_IPED_REG1_START_ADDR_FUSE_MASK) >> \
     OTP_IPED_REG1_START_ADDR_FUSE_SHIFT)

#define OTP_ENABLE_REG1_FUSE_IDX   (39u)
#define OTP_ENABLE_REG1_FUSE_SHIFT (30u)
#define OTP_ENABLE_REG1_FUSE_MASK  (0xC0000000u)
#define OTP_ENABLE_REG1_FUSE_WIDTH (2u)
#define OTP_ENABLE_REG1_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_ENABLE_REG1_FUSE_IDX] & OTP_ENABLE_REG1_FUSE_MASK) >> OTP_ENABLE_REG1_FUSE_SHIFT)

/* Fuse Word PRINCE_GCM_REG1_END_ADDR Index 40 */
#define OTP_PRINCE_GCM_REG1_END_ADDR_FUSE_IDX (40u)

#define OTP_PRINCE_GCM_REG1_END_ADDR_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_PRINCE_GCM_REG1_END_ADDR_FUSE_IDX])

/* Fuse Word PRINCE_GCM_REG2_START_ADDR Index 41 */
#define OTP_PRINCE_GCM_REG2_START_ADDR_FUSE_IDX (41u)

#define OTP_PRINCE_GCM_REG2_START_ADDR_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_PRINCE_GCM_REG2_START_ADDR_FUSE_IDX])
#define OTP_IPED_REG2_START_ADDR_FUSE_IDX           (41u)
#define OTP_IPED_REG2_START_ADDR_FUSE_SHIFT         (0u)
#define OTP_IPED_REG2_START_ADDR_FUSE_MASK          (0xFFFFFFu)
#define OTP_IPED_REG2_START_ADDR_FUSE_WIDTH         (24u)
#define OTP_IPED_REG2_START_ADDR_FUSE_VALUE()                                                       \
    ((OCOTP->OTP_SHADOW[OTP_IPED_REG2_START_ADDR_FUSE_IDX] & OTP_IPED_REG2_START_ADDR_FUSE_MASK) >> \
     OTP_IPED_REG2_START_ADDR_FUSE_SHIFT)

#define OTP_ENABLE_REG2_FUSE_IDX   (41u)
#define OTP_ENABLE_REG2_FUSE_SHIFT (30u)
#define OTP_ENABLE_REG2_FUSE_MASK  (0xC0000000u)
#define OTP_ENABLE_REG2_FUSE_WIDTH (2u)
#define OTP_ENABLE_REG2_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_ENABLE_REG2_FUSE_IDX] & OTP_ENABLE_REG2_FUSE_MASK) >> OTP_ENABLE_REG2_FUSE_SHIFT)

/* Fuse Word PRINCE_GCM_REG2_END_ADDR Index 42 */
#define OTP_PRINCE_GCM_REG2_END_ADDR_FUSE_IDX (42u)

#define OTP_PRINCE_GCM_REG2_END_ADDR_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_PRINCE_GCM_REG2_END_ADDR_FUSE_IDX])

/* Fuse Word PRINCE_GCM_REG3_START_ADDR Index 43 */
#define OTP_PRINCE_GCM_REG3_START_ADDR_FUSE_IDX (43u)

#define OTP_PRINCE_GCM_REG3_START_ADDR_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_PRINCE_GCM_REG3_START_ADDR_FUSE_IDX])
#define OTP_IPED_REG3_START_ADDR_FUSE_IDX           (43u)
#define OTP_IPED_REG3_START_ADDR_FUSE_SHIFT         (0u)
#define OTP_IPED_REG3_START_ADDR_FUSE_MASK          (0xFFFFFFu)
#define OTP_IPED_REG3_START_ADDR_FUSE_WIDTH         (24u)
#define OTP_IPED_REG3_START_ADDR_FUSE_VALUE()                                                       \
    ((OCOTP->OTP_SHADOW[OTP_IPED_REG3_START_ADDR_FUSE_IDX] & OTP_IPED_REG3_START_ADDR_FUSE_MASK) >> \
     OTP_IPED_REG3_START_ADDR_FUSE_SHIFT)

#define OTP_ENABLE_REG3_FUSE_IDX   (43u)
#define OTP_ENABLE_REG3_FUSE_SHIFT (30u)
#define OTP_ENABLE_REG3_FUSE_MASK  (0xC0000000u)
#define OTP_ENABLE_REG3_FUSE_WIDTH (2u)
#define OTP_ENABLE_REG3_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_ENABLE_REG3_FUSE_IDX] & OTP_ENABLE_REG3_FUSE_MASK) >> OTP_ENABLE_REG3_FUSE_SHIFT)

/* Fuse Word PRINCE_GCM_REG3_END_ADDR Index 44 */
#define OTP_PRINCE_GCM_REG3_END_ADDR_FUSE_IDX (44u)

#define OTP_PRINCE_GCM_REG3_END_ADDR_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_PRINCE_GCM_REG3_END_ADDR_FUSE_IDX])

/* Fuse Word LIFE_CYCLE_STATE Index 45 */
#define OTP_LIFE_CYCLE_STATE_FUSE_IDX (45u)

#define OTP_LIFE_CYCLE_STATE_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_LIFE_CYCLE_STATE_FUSE_IDX])
#define OTP_LCS_FUSE_IDX                  (45u)
#define OTP_LCS_FUSE_SHIFT                (0u)
#define OTP_LCS_FUSE_MASK                 (0xFFu)
#define OTP_LCS_FUSE_WIDTH                (8u)
#define OTP_LCS_FUSE_VALUE()              ((OCOTP->OTP_SHADOW[OTP_LCS_FUSE_IDX] & OTP_LCS_FUSE_MASK) >> OTP_LCS_FUSE_SHIFT)

#define OTP_LCS_REDUNDANT_FUSE_IDX   (45u)
#define OTP_LCS_REDUNDANT_FUSE_SHIFT (8u)
#define OTP_LCS_REDUNDANT_FUSE_MASK  (0xFF00u)
#define OTP_LCS_REDUNDANT_FUSE_WIDTH (8u)
#define OTP_LCS_REDUNDANT_FUSE_VALUE() \
    ((OCOTP->OTP_SHADOW[OTP_LCS_REDUNDANT_FUSE_IDX] & OTP_LCS_REDUNDANT_FUSE_MASK) >> OTP_LCS_REDUNDANT_FUSE_SHIFT)

/* Fuse Word UUID[31:0] Index 46 */
#define OTP_UUID_31_0_FUSE_IDX (46u)

/* Fuse Word UUID[63:32] Index 47 */
#define OTP_UUID_63_32_FUSE_IDX (47u)

/* Fuse Word UUID[95:64] Index 48 */
#define OTP_UUID_95_64_FUSE_IDX (48u)

/* Fuse Word UUID[127:96] Index 49 */
#define OTP_UUID_127_96_FUSE_IDX (49u)

/* Fuse Word RO_PUF[31:0] Index 50 */
#define OTP_RO_PUF_31_0_FUSE_IDX (50u)

/* Fuse Word RO_PUF[63:32] Index 51 */
#define OTP_RO_PUF_63_32_FUSE_IDX (51u)

/* Fuse Word RO_PUF[95:64] Index 52 */
#define OTP_RO_PUF_95_64_FUSE_IDX (52u)

/* Fuse Word RO_PUF[127:96] Index 53 */
#define OTP_RO_PUF_127_96_FUSE_IDX (53u)

/* Fuse Word RO_PUF[159:128] Index 54 */
#define OTP_RO_PUF_159_128_FUSE_IDX (54u)

/* Fuse Word RO_PUF[191:160] Index 55 */
#define OTP_RO_PUF_191_160_FUSE_IDX (55u)

/* Fuse Word RO_PUF[223:192] Index 56 */
#define OTP_RO_PUF_223_192_FUSE_IDX (56u)

/* Fuse Word RO_PUF[255:224] Index 57 */
#define OTP_RO_PUF_255_224_FUSE_IDX (57u)

/* Fuse Word RO_PUF[287:256] Index 58 */
#define OTP_RO_PUF_287_256_FUSE_IDX (58u)

/* Fuse Word RO_PUF[319:288] Index 59 */
#define OTP_RO_PUF_319_288_FUSE_IDX (59u)

/* Fuse Word RO_PUF[351:320] Index 60 */
#define OTP_RO_PUF_351_320_FUSE_IDX (60u)

/* Fuse Word RO_PUF[383:352] Index 61 */
#define OTP_RO_PUF_383_352_FUSE_IDX (61u)

/* Fuse Word RO_PUF[415:384] Index 62 */
#define OTP_RO_PUF_415_384_FUSE_IDX (62u)

/* Fuse Word RO_PUF[447:416] Index 63 */
#define OTP_RO_PUF_447_416_FUSE_IDX (63u)

/* Fuse Word RO_PUF[479:448] Index 64 */
#define OTP_RO_PUF_479_448_FUSE_IDX (64u)

/* Fuse Word RO_PUF[511:480] Index 65 */
#define OTP_RO_PUF_511_480_FUSE_IDX (65u)

/* Fuse Word RO_PUF[543:512] Index 66 */
#define OTP_RO_PUF_543_512_FUSE_IDX (66u)

/* Fuse Word RO_PUF[575:544] Index 67 */
#define OTP_RO_PUF_575_544_FUSE_IDX (67u)

/* Fuse Word RO_PUF[607:576] Index 68 */
#define OTP_RO_PUF_607_576_FUSE_IDX (68u)

/* Fuse Word RO_PUF[639:608] Index 69 */
#define OTP_RO_PUF_639_608_FUSE_IDX (69u)

/* Fuse Word RO_PUF[671:640] Index 70 */
#define OTP_RO_PUF_671_640_FUSE_IDX (70u)

/* Fuse Word RO_PUF[703:672] Index 71 */
#define OTP_RO_PUF_703_672_FUSE_IDX (71u)

/* Fuse Word RO_PUF[735:704] Index 72 */
#define OTP_RO_PUF_735_704_FUSE_IDX (72u)

/* Fuse Word RO_PUF[767:736] Index 73 */
#define OTP_RO_PUF_767_736_FUSE_IDX (73u)

/* Fuse Word RO_PUF[799:768] Index 74 */
#define OTP_RO_PUF_799_768_FUSE_IDX (74u)

/* Fuse Word RO_PUF[831:800] Index 75 */
#define OTP_RO_PUF_831_800_FUSE_IDX (75u)

/* Fuse Word OTP_SHARE1[31:0] Index 76 */
#define OTP_OTP_SHARE1_31_0_FUSE_IDX (76u)

#define OTP_OTP_SHARE1_31_0_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE1_31_0_FUSE_IDX])
/* Fuse Word OTP_SHARE1[63:32] Index 77 */
#define OTP_OTP_SHARE1_63_32_FUSE_IDX (77u)

#define OTP_OTP_SHARE1_63_32_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE1_63_32_FUSE_IDX])
/* Fuse Word OTP_SHARE1[95:64] Index 78 */
#define OTP_OTP_SHARE1_95_64_FUSE_IDX (78u)

#define OTP_OTP_SHARE1_95_64_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE1_95_64_FUSE_IDX])
/* Fuse Word OTP_SHARE1[127:96] Index 79 */
#define OTP_OTP_SHARE1_127_96_FUSE_IDX (79u)

#define OTP_OTP_SHARE1_127_96_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE1_127_96_FUSE_IDX])
/* Fuse Word OTP_SHARE1[159:128] Index 80 */
#define OTP_OTP_SHARE1_159_128_FUSE_IDX (80u)

#define OTP_OTP_SHARE1_159_128_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE1_159_128_FUSE_IDX])
/* Fuse Word OTP_SHARE1[191:160] Index 81 */
#define OTP_OTP_SHARE1_191_160_FUSE_IDX (81u)

#define OTP_OTP_SHARE1_191_160_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE1_191_160_FUSE_IDX])
/* Fuse Word OTP_SHARE1[223:192] Index 82 */
#define OTP_OTP_SHARE1_223_192_FUSE_IDX (82u)

#define OTP_OTP_SHARE1_223_192_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE1_223_192_FUSE_IDX])
/* Fuse Word OTP_SHARE1[255:224] Index 83 */
#define OTP_OTP_SHARE1_255_224_FUSE_IDX (83u)

#define OTP_OTP_SHARE1_255_224_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE1_255_224_FUSE_IDX])
/* Fuse Word OTP_SHARE2[31:0] Index 84 */
#define OTP_OTP_SHARE2_31_0_FUSE_IDX (84u)

#define OTP_OTP_SHARE2_31_0_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE2_31_0_FUSE_IDX])
/* Fuse Word OTP_SHARE2[63:32] Index 85 */
#define OTP_OTP_SHARE2_63_32_FUSE_IDX (85u)

#define OTP_OTP_SHARE2_63_32_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE2_63_32_FUSE_IDX])
/* Fuse Word OTP_SHARE2[95:64] Index 86 */
#define OTP_OTP_SHARE2_95_64_FUSE_IDX (86u)

#define OTP_OTP_SHARE2_95_64_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE2_95_64_FUSE_IDX])
/* Fuse Word OTP_SHARE2[127:96] Index 87 */
#define OTP_OTP_SHARE2_127_96_FUSE_IDX (87u)

#define OTP_OTP_SHARE2_127_96_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE2_127_96_FUSE_IDX])
/* Fuse Word OTP_SHARE2[159:128] Index 88 */
#define OTP_OTP_SHARE2_159_128_FUSE_IDX (88u)

#define OTP_OTP_SHARE2_159_128_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE2_159_128_FUSE_IDX])
/* Fuse Word OTP_SHARE2[191:160] Index 89 */
#define OTP_OTP_SHARE2_191_160_FUSE_IDX (89u)

#define OTP_OTP_SHARE2_191_160_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE2_191_160_FUSE_IDX])
/* Fuse Word OTP_SHARE2[223:192] Index 90 */
#define OTP_OTP_SHARE2_223_192_FUSE_IDX (90u)

#define OTP_OTP_SHARE2_223_192_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE2_223_192_FUSE_IDX])
/* Fuse Word OTP_SHARE2[255:224] Index 91 */
#define OTP_OTP_SHARE2_255_224_FUSE_IDX (91u)

#define OTP_OTP_SHARE2_255_224_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_OTP_SHARE2_255_224_FUSE_IDX])
/* Fuse Word CUST_SK_MK[31:0] Index 92 */
#define OTP_CUST_SK_MK_31_0_FUSE_IDX (92u)

#define OTP_CUST_SK_MK_31_0_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_CUST_SK_MK_31_0_FUSE_IDX])
/* Fuse Word CUST_SK_MK[63:32] Index 93 */
#define OTP_CUST_SK_MK_63_32_FUSE_IDX (93u)

#define OTP_CUST_SK_MK_63_32_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_CUST_SK_MK_63_32_FUSE_IDX])
/* Fuse Word CUST_SK_MK[95:64] Index 94 */
#define OTP_CUST_SK_MK_95_64_FUSE_IDX (94u)

#define OTP_CUST_SK_MK_95_64_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_CUST_SK_MK_95_64_FUSE_IDX])
/* Fuse Word CUST_SK_MK[127:96] Index 95 */
#define OTP_CUST_SK_MK_127_96_FUSE_IDX (95u)

#define OTP_CUST_SK_MK_127_96_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_CUST_SK_MK_127_96_FUSE_IDX])
/* Fuse Word CUST_SK_MK[159:128] Index 96 */
#define OTP_CUST_SK_MK_159_128_FUSE_IDX (96u)

#define OTP_CUST_SK_MK_159_128_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_CUST_SK_MK_159_128_FUSE_IDX])
/* Fuse Word CUST_SK_MK[191:160] Index 97 */
#define OTP_CUST_SK_MK_191_160_FUSE_IDX (97u)

#define OTP_CUST_SK_MK_191_160_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_CUST_SK_MK_191_160_FUSE_IDX])
/* Fuse Word CUST_SK_MK[223:192] Index 98 */
#define OTP_CUST_SK_MK_223_192_FUSE_IDX (98u)

#define OTP_CUST_SK_MK_223_192_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_CUST_SK_MK_223_192_FUSE_IDX])
/* Fuse Word CUST_SK_MK[255:224] Index 99 */
#define OTP_CUST_SK_MK_255_224_FUSE_IDX (99u)

#define OTP_CUST_SK_MK_255_224_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_CUST_SK_MK_255_224_FUSE_IDX])
/* Fuse Word CUST_SK_MK[287:256] Index 100 */
#define OTP_CUST_SK_MK_287_256_FUSE_IDX (100u)

#define OTP_CUST_SK_MK_287_256_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_CUST_SK_MK_287_256_FUSE_IDX])
/* Fuse Word CUST_SK_MK[319:288] Index 101 */
#define OTP_CUST_SK_MK_319_288_FUSE_IDX (101u)

#define OTP_CUST_SK_MK_319_288_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_CUST_SK_MK_319_288_FUSE_IDX])
/* Fuse Word CUST_SK_MK[351:320] Index 102 */
#define OTP_CUST_SK_MK_351_320_FUSE_IDX (102u)

#define OTP_CUST_SK_MK_351_320_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_CUST_SK_MK_351_320_FUSE_IDX])
/* Fuse Word CUST_SK_MK[383:352] Index 103 */
#define OTP_CUST_SK_MK_383_352_FUSE_IDX (103u)

#define OTP_CUST_SK_MK_383_352_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_CUST_SK_MK_383_352_FUSE_IDX])
/* Fuse Word RKTH[383:352] Index 104 */
#define OTP_RKTH_383_352_FUSE_IDX (104u)

#define OTP_RKTH_383_352_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_RKTH_383_352_FUSE_IDX])
/* Fuse Word RKTH[351:320] Index 105 */
#define OTP_RKTH_351_320_FUSE_IDX (105u)

#define OTP_RKTH_351_320_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_RKTH_351_320_FUSE_IDX])
/* Fuse Word RKTH[319:288] Index 106 */
#define OTP_RKTH_319_288_FUSE_IDX (106u)

#define OTP_RKTH_319_288_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_RKTH_319_288_FUSE_IDX])
/* Fuse Word RKTH[287:256] Index 107 */
#define OTP_RKTH_287_256_FUSE_IDX (107u)

#define OTP_RKTH_287_256_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_RKTH_287_256_FUSE_IDX])
/* Fuse Word RKTH[255:224] Index 108 */
#define OTP_RKTH_255_224_FUSE_IDX (108u)

#define OTP_RKTH_255_224_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_RKTH_255_224_FUSE_IDX])
/* Fuse Word RKTH[223:192] Index 109 */
#define OTP_RKTH_223_192_FUSE_IDX (109u)

#define OTP_RKTH_223_192_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_RKTH_223_192_FUSE_IDX])
/* Fuse Word RKTH[191:160] Index 110 */
#define OTP_RKTH_191_160_FUSE_IDX (110u)

#define OTP_RKTH_191_160_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_RKTH_191_160_FUSE_IDX])
/* Fuse Word RKTH[159:128] Index 111 */
#define OTP_RKTH_159_128_FUSE_IDX (111u)

#define OTP_RKTH_159_128_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_RKTH_159_128_FUSE_IDX])
/* Fuse Word RKTH[127:96] Index 112 */
#define OTP_RKTH_127_96_FUSE_IDX (112u)

#define OTP_RKTH_127_96_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_RKTH_127_96_FUSE_IDX])
/* Fuse Word RKTH[95:64] Index 113 */
#define OTP_RKTH_95_64_FUSE_IDX (113u)

#define OTP_RKTH_95_64_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_RKTH_95_64_FUSE_IDX])
/* Fuse Word RKTH[63:32] Index 114 */
#define OTP_RKTH_63_32_FUSE_IDX (114u)

#define OTP_RKTH_63_32_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_RKTH_63_32_FUSE_IDX])
/* Fuse Word RKTH[31:0] Index 115 */
#define OTP_RKTH_31_0_FUSE_IDX (115u)

#define OTP_RKTH_31_0_FUSE_VALUE() (OCOTP->OTP_SHADOW[OTP_RKTH_31_0_FUSE_IDX])
/* Fuse Word NXP_WIFI_SK_MK[31:0] Index 116 */
#define OTP_NXP_WIFI_SK_MK_31_0_FUSE_IDX (116u)

/* Fuse Word NXP_WIFI_SK_MK[63:32] Index 117 */
#define OTP_NXP_WIFI_SK_MK_63_32_FUSE_IDX (117u)

/* Fuse Word NXP_WIFI_SK_MK[95:64] Index 118 */
#define OTP_NXP_WIFI_SK_MK_95_64_FUSE_IDX (118u)

/* Fuse Word NXP_WIFI_SK_MK[127:96] Index 119 */
#define OTP_NXP_WIFI_SK_MK_127_96_FUSE_IDX (119u)

/* Fuse Word NXP_WIFI_SK_MK[159:128] Index 120 */
#define OTP_NXP_WIFI_SK_MK_159_128_FUSE_IDX (120u)

/* Fuse Word NXP_WIFI_SK_MK[191:160] Index 121 */
#define OTP_NXP_WIFI_SK_MK_191_160_FUSE_IDX (121u)

/* Fuse Word NXP_WIFI_SK_MK[223:192] Index 122 */
#define OTP_NXP_WIFI_SK_MK_223_192_FUSE_IDX (122u)

/* Fuse Word NXP_WIFI_SK_MK[255:224] Index 123 */
#define OTP_NXP_WIFI_SK_MK_255_224_FUSE_IDX (123u)

/* Fuse Word NXP_WIFI_SK_MK[287:256] Index 124 */
#define OTP_NXP_WIFI_SK_MK_287_256_FUSE_IDX (124u)

/* Fuse Word NXP_WIFI_SK_MK[319:288] Index 125 */
#define OTP_NXP_WIFI_SK_MK_319_288_FUSE_IDX (125u)

/* Fuse Word NXP_WIFI_SK_MK[351:320] Index 126 */
#define OTP_NXP_WIFI_SK_MK_351_320_FUSE_IDX (126u)

/* Fuse Word NXP_WIFI_SK_MK[383:352] Index 127 */
#define OTP_NXP_WIFI_SK_MK_383_352_FUSE_IDX (127u)

/* Fuse Word DTRNG_CFG[31:0] Index 128 */
#define OTP_DTRNG_CFG_31_0_FUSE_IDX (128u)

/* Fuse Word DTRNG_CFG[63:32] Index 129 */
#define OTP_DTRNG_CFG_63_32_FUSE_IDX (129u)

/* Fuse Word DTRNG_CFG[95:64] Index 130 */
#define OTP_DTRNG_CFG_95_64_FUSE_IDX (130u)

/* Fuse Word DTRNG_CFG[127:96] Index 131 */
#define OTP_DTRNG_CFG_127_96_FUSE_IDX (131u)

/* Fuse Word DTRNG_CFG[159:128] Index 132 */
#define OTP_DTRNG_CFG_159_128_FUSE_IDX (132u)

/* Fuse Word DTRNG_CFG[191:160] Index 133 */
#define OTP_DTRNG_CFG_191_160_FUSE_IDX (133u)

/* Fuse Word DTRNG_CFG[223:192] Index 134 */
#define OTP_DTRNG_CFG_223_192_FUSE_IDX (134u)

/* Fuse Word DTRNG_CFG[255:224] Index 135 */
#define OTP_DTRNG_CFG_255_224_FUSE_IDX (135u)

/* Fuse Word DTRNG_CFG[287:256] Index 136 */
#define OTP_DTRNG_CFG_287_256_FUSE_IDX (136u)

/* Fuse Word DTRNG_CFG[319:288] Index 137 */
#define OTP_DTRNG_CFG_319_288_FUSE_IDX (137u)

/* Fuse Word DTRNG_CFG[351:320] Index 138 */
#define OTP_DTRNG_CFG_351_320_FUSE_IDX (138u)

/* Fuse Word DTRNG_CFG[383:352] Index 139 */
#define OTP_DTRNG_CFG_383_352_FUSE_IDX (139u)

/* Fuse Word DTRNG_CFG[415:384] Index 140 */
#define OTP_DTRNG_CFG_415_384_FUSE_IDX (140u)

/* Fuse Word DTRNG_CFG[447:416] Index 141 */
#define OTP_DTRNG_CFG_447_416_FUSE_IDX (141u)

/* Fuse Word DTRNG_CFG[479:448] Index 142 */
#define OTP_DTRNG_CFG_479_448_FUSE_IDX (142u)

/* Fuse Word DTRNG_CFG[511:480] Index 143 */
#define OTP_DTRNG_CFG_511_480_FUSE_IDX (143u)

/* Fuse Word DTRNG_CFG[543:512] Index 144 */
#define OTP_DTRNG_CFG_543_512_FUSE_IDX (144u)

/* Fuse Word DTRNG_CFG[575:544] Index 145 */
#define OTP_DTRNG_CFG_575_544_FUSE_IDX (145u)

/* Fuse Word DTRNG_CFG[607:576] Index 146 */
#define OTP_DTRNG_CFG_607_576_FUSE_IDX (146u)

/* Fuse Word DTRNG_CFG[639:608] Index 147 */
#define OTP_DTRNG_CFG_639_608_FUSE_IDX (147u)

/* Fuse Word DTRNG_CFG[671:640] Index 148 */
#define OTP_DTRNG_CFG_671_640_FUSE_IDX (148u)

/* Fuse Word GDET_CFG[31:0] Index 149 */
#define OTP_GDET_CFG_31_0_FUSE_IDX (149u)

/* Fuse Word GDET_CFG[63:32] Index 150 */
#define OTP_GDET_CFG_63_32_FUSE_IDX (150u)

/* Fuse Word GDET_CFG[95:64] Index 151 */
#define OTP_GDET_CFG_95_64_FUSE_IDX (151u)

/* Fuse Word GDET_CFG[127:96] Index 152 */
#define OTP_GDET_CFG_127_96_FUSE_IDX (152u)

/* Fuse Word GDET_CFG[159:128] Index 153 */
#define OTP_GDET_CFG_159_128_FUSE_IDX (153u)

/* Fuse Word GDET_CFG[191:160] Index 154 */
#define OTP_GDET_CFG_191_160_FUSE_IDX (154u)

/* Fuse Word GDET_TRIM0 Index 155 */
#define OTP_GDET_TRIM0_FUSE_IDX (155u)

#define OTP_GDET_TRIM0_31_0_FUSE_IDX   (155u)
#define OTP_GDET_TRIM0_31_0_FUSE_SHIFT (0u)
#define OTP_GDET_TRIM0_31_0_FUSE_MASK  (0xFFFFFFFFu)
#define OTP_GDET_TRIM0_31_0_FUSE_WIDTH (32u)

/* Fuse Word USER_ECC_0 Index 156 */
#define OTP_USER_ECC_0_FUSE_IDX (156u)

/* Fuse Word USER_ECC_1 Index 157 */
#define OTP_USER_ECC_1_FUSE_IDX (157u)

/* Fuse Word USER_ECC_2 Index 158 */
#define OTP_USER_ECC_2_FUSE_IDX (158u)

/* Fuse Word USER_ECC_3 Index 159 */
#define OTP_USER_ECC_3_FUSE_IDX (159u)

/* Fuse Word USER_ECC_4 Index 160 */
#define OTP_USER_ECC_4_FUSE_IDX (160u)

/* Fuse Word USER_ECC_5 Index 161 */
#define OTP_USER_ECC_5_FUSE_IDX (161u)

/* Fuse Word USER_ECC_6 Index 162 */
#define OTP_USER_ECC_6_FUSE_IDX (162u)

/* Fuse Word USER_ECC_7 Index 163 */
#define OTP_USER_ECC_7_FUSE_IDX (163u)

/* Fuse Word ROM_PATCH_DATA0 Index 164 */
#define OTP_ROM_PATCH_DATA0_FUSE_IDX (164u)

/* Fuse Word ROM_PATCH_DATA1 Index 165 */
#define OTP_ROM_PATCH_DATA1_FUSE_IDX (165u)

/* Fuse Word ROM_PATCH_DATA2 Index 166 */
#define OTP_ROM_PATCH_DATA2_FUSE_IDX (166u)

/* Fuse Word ROM_PATCH_DATA3 Index 167 */
#define OTP_ROM_PATCH_DATA3_FUSE_IDX (167u)

/* Fuse Word ROM_PATCH_DATA4 Index 168 */
#define OTP_ROM_PATCH_DATA4_FUSE_IDX (168u)

/* Fuse Word ROM_PATCH_DATA5 Index 169 */
#define OTP_ROM_PATCH_DATA5_FUSE_IDX (169u)

/* Fuse Word ROM_PATCH_DATA6 Index 170 */
#define OTP_ROM_PATCH_DATA6_FUSE_IDX (170u)

/* Fuse Word ROM_PATCH_DATA7 Index 171 */
#define OTP_ROM_PATCH_DATA7_FUSE_IDX (171u)

/* Fuse Word ROM_PATCH_DATA8 Index 172 */
#define OTP_ROM_PATCH_DATA8_FUSE_IDX (172u)

/* Fuse Word ROM_PATCH_DATA9 Index 173 */
#define OTP_ROM_PATCH_DATA9_FUSE_IDX (173u)

/* Fuse Word ROM_PATCH_DATA10 Index 174 */
#define OTP_ROM_PATCH_DATA10_FUSE_IDX (174u)

/* Fuse Word ROM_PATCH_DATA11 Index 175 */
#define OTP_ROM_PATCH_DATA11_FUSE_IDX (175u)

/* Fuse Word ROM_PATCH_DATA12 Index 176 */
#define OTP_ROM_PATCH_DATA12_FUSE_IDX (176u)

/* Fuse Word ROM_PATCH_DATA13 Index 177 */
#define OTP_ROM_PATCH_DATA13_FUSE_IDX (177u)

/* Fuse Word ROM_PATCH_DATA14 Index 178 */
#define OTP_ROM_PATCH_DATA14_FUSE_IDX (178u)

/* Fuse Word ROM_PATCH_DATA15 Index 179 */
#define OTP_ROM_PATCH_DATA15_FUSE_IDX (179u)

/* Fuse Word ROM_PATCH_DATA16 Index 180 */
#define OTP_ROM_PATCH_DATA16_FUSE_IDX (180u)

/* Fuse Word ROM_PATCH_DATA17 Index 181 */
#define OTP_ROM_PATCH_DATA17_FUSE_IDX (181u)

/* Fuse Word ROM_PATCH_DATA18 Index 182 */
#define OTP_ROM_PATCH_DATA18_FUSE_IDX (182u)

/* Fuse Word ROM_PATCH_DATA19 Index 183 */
#define OTP_ROM_PATCH_DATA19_FUSE_IDX (183u)

/* Fuse Word ROM_PATCH_DATA20 Index 184 */
#define OTP_ROM_PATCH_DATA20_FUSE_IDX (184u)

/* Fuse Word ROM_PATCH_DATA21 Index 185 */
#define OTP_ROM_PATCH_DATA21_FUSE_IDX (185u)

/* Fuse Word ROM_PATCH_DATA22 Index 186 */
#define OTP_ROM_PATCH_DATA22_FUSE_IDX (186u)

/* Fuse Word ROM_PATCH_DATA23 Index 187 */
#define OTP_ROM_PATCH_DATA23_FUSE_IDX (187u)

/* Fuse Word ROM_PATCH_DATA24 Index 188 */
#define OTP_ROM_PATCH_DATA24_FUSE_IDX (188u)

/* Fuse Word ROM_PATCH_DATA25 Index 189 */
#define OTP_ROM_PATCH_DATA25_FUSE_IDX (189u)

/* Fuse Word ROM_PATCH_DATA26 Index 190 */
#define OTP_ROM_PATCH_DATA26_FUSE_IDX (190u)

/* Fuse Word ROM_PATCH_DATA27 Index 191 */
#define OTP_ROM_PATCH_DATA27_FUSE_IDX (191u)

/* Fuse Word ROM_PATCH_DATA28 Index 192 */
#define OTP_ROM_PATCH_DATA28_FUSE_IDX (192u)

/* Fuse Word ROM_PATCH_DATA29 Index 193 */
#define OTP_ROM_PATCH_DATA29_FUSE_IDX (193u)

/* Fuse Word ROM_PATCH_DATA30 Index 194 */
#define OTP_ROM_PATCH_DATA30_FUSE_IDX (194u)

/* Fuse Word ROM_PATCH_DATA31 Index 195 */
#define OTP_ROM_PATCH_DATA31_FUSE_IDX (195u)

/* Fuse Word ROM_PATCH_DATA32 Index 196 */
#define OTP_ROM_PATCH_DATA32_FUSE_IDX (196u)

/* Fuse Word ROM_PATCH_DATA33 Index 197 */
#define OTP_ROM_PATCH_DATA33_FUSE_IDX (197u)

/* Fuse Word ROM_PATCH_DATA34 Index 198 */
#define OTP_ROM_PATCH_DATA34_FUSE_IDX (198u)

/* Fuse Word ROM_PATCH_DATA35 Index 199 */
#define OTP_ROM_PATCH_DATA35_FUSE_IDX (199u)

/* Fuse Word ROM_PATCH_DATA36 Index 200 */
#define OTP_ROM_PATCH_DATA36_FUSE_IDX (200u)

/* Fuse Word ROM_PATCH_DATA37 Index 201 */
#define OTP_ROM_PATCH_DATA37_FUSE_IDX (201u)

/* Fuse Word ROM_PATCH_DATA38 Index 202 */
#define OTP_ROM_PATCH_DATA38_FUSE_IDX (202u)

/* Fuse Word ROM_PATCH_DATA39 Index 203 */
#define OTP_ROM_PATCH_DATA39_FUSE_IDX (203u)

/* Fuse Word ROM_PATCH_DATA40 Index 204 */
#define OTP_ROM_PATCH_DATA40_FUSE_IDX (204u)

/* Fuse Word ROM_PATCH_DATA41 Index 205 */
#define OTP_ROM_PATCH_DATA41_FUSE_IDX (205u)

/* Fuse Word ROM_PATCH_DATA42 Index 206 */
#define OTP_ROM_PATCH_DATA42_FUSE_IDX (206u)

/* Fuse Word ROM_PATCH_DATA43 Index 207 */
#define OTP_ROM_PATCH_DATA43_FUSE_IDX (207u)

/* Fuse Word ROM_PATCH_DATA44 Index 208 */
#define OTP_ROM_PATCH_DATA44_FUSE_IDX (208u)

/* Fuse Word ROM_PATCH_DATA45 Index 209 */
#define OTP_ROM_PATCH_DATA45_FUSE_IDX (209u)

/* Fuse Word ROM_PATCH_DATA46 Index 210 */
#define OTP_ROM_PATCH_DATA46_FUSE_IDX (210u)

/* Fuse Word ROM_PATCH_DATA47 Index 211 */
#define OTP_ROM_PATCH_DATA47_FUSE_IDX (211u)

/* Fuse Word ROM_PATCH_DATA48 Index 212 */
#define OTP_ROM_PATCH_DATA48_FUSE_IDX (212u)

/* Fuse Word ROM_PATCH_DATA49 Index 213 */
#define OTP_ROM_PATCH_DATA49_FUSE_IDX (213u)

/* Fuse Word ROM_PATCH_DATA50 Index 214 */
#define OTP_ROM_PATCH_DATA50_FUSE_IDX (214u)

/* Fuse Word ROM_PATCH_DATA51 Index 215 */
#define OTP_ROM_PATCH_DATA51_FUSE_IDX (215u)

/* Fuse Word ROM_PATCH_DATA52 Index 216 */
#define OTP_ROM_PATCH_DATA52_FUSE_IDX (216u)

/* Fuse Word ROM_PATCH_DATA53 Index 217 */
#define OTP_ROM_PATCH_DATA53_FUSE_IDX (217u)

/* Fuse Word ROM_PATCH_DATA54 Index 218 */
#define OTP_ROM_PATCH_DATA54_FUSE_IDX (218u)

/* Fuse Word ROM_PATCH_DATA55 Index 219 */
#define OTP_ROM_PATCH_DATA55_FUSE_IDX (219u)

/* Fuse Word ROM_PATCH_DATA56 Index 220 */
#define OTP_ROM_PATCH_DATA56_FUSE_IDX (220u)

/* Fuse Word ROM_PATCH_DATA57 Index 221 */
#define OTP_ROM_PATCH_DATA57_FUSE_IDX (221u)

/* Fuse Word ROM_PATCH_DATA58 Index 222 */
#define OTP_ROM_PATCH_DATA58_FUSE_IDX (222u)

/* Fuse Word ROM_PATCH_DATA59 Index 223 */
#define OTP_ROM_PATCH_DATA59_FUSE_IDX (223u)

/* Fuse Word ROM_PATCH_DATA60 Index 224 */
#define OTP_ROM_PATCH_DATA60_FUSE_IDX (224u)

/* Fuse Word ROM_PATCH_DATA61 Index 225 */
#define OTP_ROM_PATCH_DATA61_FUSE_IDX (225u)

/* Fuse Word ROM_PATCH_DATA62 Index 226 */
#define OTP_ROM_PATCH_DATA62_FUSE_IDX (226u)

/* Fuse Word ROM_PATCH_DATA63 Index 227 */
#define OTP_ROM_PATCH_DATA63_FUSE_IDX (227u)

/* Fuse Word ROM_PATCH_DATA64 Index 228 */
#define OTP_ROM_PATCH_DATA64_FUSE_IDX (228u)

/* Fuse Word ROM_PATCH_DATA65 Index 229 */
#define OTP_ROM_PATCH_DATA65_FUSE_IDX (229u)

/* Fuse Word ROM_PATCH_DATA66 Index 230 */
#define OTP_ROM_PATCH_DATA66_FUSE_IDX (230u)

/* Fuse Word ROM_PATCH_DATA67 Index 231 */
#define OTP_ROM_PATCH_DATA67_FUSE_IDX (231u)

/* Fuse Word ROM_PATCH_DATA68 Index 232 */
#define OTP_ROM_PATCH_DATA68_FUSE_IDX (232u)

/* Fuse Word ROM_PATCH_DATA69 Index 233 */
#define OTP_ROM_PATCH_DATA69_FUSE_IDX (233u)

/* Fuse Word ROM_PATCH_DATA70 Index 234 */
#define OTP_ROM_PATCH_DATA70_FUSE_IDX (234u)

/* Fuse Word ROM_PATCH_DATA71 Index 235 */
#define OTP_ROM_PATCH_DATA71_FUSE_IDX (235u)

/* Fuse Word ROM_PATCH_DATA72 Index 236 */
#define OTP_ROM_PATCH_DATA72_FUSE_IDX (236u)

/* Fuse Word ROM_PATCH_DATA73 Index 237 */
#define OTP_ROM_PATCH_DATA73_FUSE_IDX (237u)

/* Fuse Word ROM_PATCH_DATA74 Index 238 */
#define OTP_ROM_PATCH_DATA74_FUSE_IDX (238u)

/* Fuse Word ROM_PATCH_DATA75 Index 239 */
#define OTP_ROM_PATCH_DATA75_FUSE_IDX (239u)

/* Fuse Word ROM_PATCH_DATA76 Index 240 */
#define OTP_ROM_PATCH_DATA76_FUSE_IDX (240u)

/* Fuse Word ROM_PATCH_DATA77 Index 241 */
#define OTP_ROM_PATCH_DATA77_FUSE_IDX (241u)

/* Fuse Word ROM_PATCH_DATA78 Index 242 */
#define OTP_ROM_PATCH_DATA78_FUSE_IDX (242u)

/* Fuse Word ROM_PATCH_DATA79 Index 243 */
#define OTP_ROM_PATCH_DATA79_FUSE_IDX (243u)

/* Fuse Word ROM_PATCH_DATA80 Index 244 */
#define OTP_ROM_PATCH_DATA80_FUSE_IDX (244u)

/* Fuse Word ROM_PATCH_DATA81 Index 245 */
#define OTP_ROM_PATCH_DATA81_FUSE_IDX (245u)

/* Fuse Word ROM_PATCH_DATA82 Index 246 */
#define OTP_ROM_PATCH_DATA82_FUSE_IDX (246u)

/* Fuse Word ROM_PATCH_DATA83 Index 247 */
#define OTP_ROM_PATCH_DATA83_FUSE_IDX (247u)

/* Fuse Word ROM_PATCH_DATA84 Index 248 */
#define OTP_ROM_PATCH_DATA84_FUSE_IDX (248u)

/* Fuse Word ROM_PATCH_DATA85 Index 249 */
#define OTP_ROM_PATCH_DATA85_FUSE_IDX (249u)

/* Fuse Word ROM_PATCH_DATA86 Index 250 */
#define OTP_ROM_PATCH_DATA86_FUSE_IDX (250u)

/* Fuse Word ROM_PATCH_DATA87 Index 251 */
#define OTP_ROM_PATCH_DATA87_FUSE_IDX (251u)

/* Fuse Word ROM_PATCH_DATA88 Index 252 */
#define OTP_ROM_PATCH_DATA88_FUSE_IDX (252u)

/* Fuse Word ROM_PATCH_DATA89 Index 253 */
#define OTP_ROM_PATCH_DATA89_FUSE_IDX (253u)

/* Fuse Word ROM_PATCH_DATA90 Index 254 */
#define OTP_ROM_PATCH_DATA90_FUSE_IDX (254u)

/* Fuse Word ROM_PATCH_DATA91 Index 255 */
#define OTP_ROM_PATCH_DATA91_FUSE_IDX (255u)

/* Fuse Word ROM_PATCH_DATA92 Index 256 */
#define OTP_ROM_PATCH_DATA92_FUSE_IDX (256u)

/* Fuse Word ROM_PATCH_DATA93 Index 257 */
#define OTP_ROM_PATCH_DATA93_FUSE_IDX (257u)

/* Fuse Word ROM_PATCH_DATA94 Index 258 */
#define OTP_ROM_PATCH_DATA94_FUSE_IDX (258u)

/* Fuse Word ROM_PATCH_DATA95 Index 259 */
#define OTP_ROM_PATCH_DATA95_FUSE_IDX (259u)

/* Fuse Word ROM_PATCH_DATA96 Index 260 */
#define OTP_ROM_PATCH_DATA96_FUSE_IDX (260u)

/* Fuse Word ROM_PATCH_DATA97 Index 261 */
#define OTP_ROM_PATCH_DATA97_FUSE_IDX (261u)

/* Fuse Word ROM_PATCH_DATA98 Index 262 */
#define OTP_ROM_PATCH_DATA98_FUSE_IDX (262u)

/* Fuse Word ROM_PATCH_DATA99 Index 263 */
#define OTP_ROM_PATCH_DATA99_FUSE_IDX (263u)

/* Fuse Word ROM_PATCH_DATA100 Index 264 */
#define OTP_ROM_PATCH_DATA100_FUSE_IDX (264u)

/* Fuse Word ROM_PATCH_DATA101 Index 265 */
#define OTP_ROM_PATCH_DATA101_FUSE_IDX (265u)

/* Fuse Word ROM_PATCH_DATA102 Index 266 */
#define OTP_ROM_PATCH_DATA102_FUSE_IDX (266u)

/* Fuse Word ROM_PATCH_DATA103 Index 267 */
#define OTP_ROM_PATCH_DATA103_FUSE_IDX (267u)

/* Fuse Word ROM_PATCH_DATA104 Index 268 */
#define OTP_ROM_PATCH_DATA104_FUSE_IDX (268u)

/* Fuse Word ROM_PATCH_DATA105 Index 269 */
#define OTP_ROM_PATCH_DATA105_FUSE_IDX (269u)

/* Fuse Word ROM_PATCH_DATA106 Index 270 */
#define OTP_ROM_PATCH_DATA106_FUSE_IDX (270u)

/* Fuse Word ROM_PATCH_DATA107 Index 271 */
#define OTP_ROM_PATCH_DATA107_FUSE_IDX (271u)

/* Fuse Word ROM_PATCH_DATA108 Index 272 */
#define OTP_ROM_PATCH_DATA108_FUSE_IDX (272u)

/* Fuse Word ROM_PATCH_DATA109 Index 273 */
#define OTP_ROM_PATCH_DATA109_FUSE_IDX (273u)

/* Fuse Word ROM_PATCH_DATA110 Index 274 */
#define OTP_ROM_PATCH_DATA110_FUSE_IDX (274u)

/* Fuse Word ROM_PATCH_DATA111 Index 275 */
#define OTP_ROM_PATCH_DATA111_FUSE_IDX (275u)

/* Fuse Word ROM_PATCH_DATA112 Index 276 */
#define OTP_ROM_PATCH_DATA112_FUSE_IDX (276u)

/* Fuse Word ROM_PATCH_DATA113 Index 277 */
#define OTP_ROM_PATCH_DATA113_FUSE_IDX (277u)

/* Fuse Word ROM_PATCH_DATA114 Index 278 */
#define OTP_ROM_PATCH_DATA114_FUSE_IDX (278u)

/* Fuse Word ROM_PATCH_DATA115 Index 279 */
#define OTP_ROM_PATCH_DATA115_FUSE_IDX (279u)

/* Fuse Word ROM_PATCH_DATA116 Index 280 */
#define OTP_ROM_PATCH_DATA116_FUSE_IDX (280u)

/* Fuse Word ROM_PATCH_DATA117 Index 281 */
#define OTP_ROM_PATCH_DATA117_FUSE_IDX (281u)

/* Fuse Word ROM_PATCH_DATA118 Index 282 */
#define OTP_ROM_PATCH_DATA118_FUSE_IDX (282u)

/* Fuse Word ROM_PATCH_DATA119 Index 283 */
#define OTP_ROM_PATCH_DATA119_FUSE_IDX (283u)

/* Fuse Word ROM_PATCH_DATA120 Index 284 */
#define OTP_ROM_PATCH_DATA120_FUSE_IDX (284u)

/* Fuse Word ROM_PATCH_DATA121 Index 285 */
#define OTP_ROM_PATCH_DATA121_FUSE_IDX (285u)

/* Fuse Word ROM_PATCH_DATA122 Index 286 */
#define OTP_ROM_PATCH_DATA122_FUSE_IDX (286u)

/* Fuse Word ROM_PATCH_DATA123 Index 287 */
#define OTP_ROM_PATCH_DATA123_FUSE_IDX (287u)

/* Fuse Word ROM_PATCH_DATA124 Index 288 */
#define OTP_ROM_PATCH_DATA124_FUSE_IDX (288u)

/* Fuse Word ROM_PATCH_DATA125 Index 289 */
#define OTP_ROM_PATCH_DATA125_FUSE_IDX (289u)

/* Fuse Word ROM_PATCH_DATA126 Index 290 */
#define OTP_ROM_PATCH_DATA126_FUSE_IDX (290u)

/* Fuse Word ROM_PATCH_DATA127 Index 291 */
#define OTP_ROM_PATCH_DATA127_FUSE_IDX (291u)

/* Fuse Word CERTIFICATE0[31:0] Index 292 */
#define OTP_CERTIFICATE0_31_0_FUSE_IDX (292u)

/* Fuse Word CERTIFICATE0[63:32] Index 293 */
#define OTP_CERTIFICATE0_63_32_FUSE_IDX (293u)

/* Fuse Word CERTIFICATE0[95:64] Index 294 */
#define OTP_CERTIFICATE0_95_64_FUSE_IDX (294u)

/* Fuse Word CERTIFICATE0[127:96] Index 295 */
#define OTP_CERTIFICATE0_127_96_FUSE_IDX (295u)

/* Fuse Word CERTIFICATE0[159:128] Index 296 */
#define OTP_CERTIFICATE0_159_128_FUSE_IDX (296u)

/* Fuse Word CERTIFICATE0[191:160] Index 297 */
#define OTP_CERTIFICATE0_191_160_FUSE_IDX (297u)

/* Fuse Word CERTIFICATE0[223:192] Index 298 */
#define OTP_CERTIFICATE0_223_192_FUSE_IDX (298u)

/* Fuse Word CERTIFICATE0[255:224] Index 299 */
#define OTP_CERTIFICATE0_255_224_FUSE_IDX (299u)

/* Fuse Word CERTIFICATE0[287:256] Index 300 */
#define OTP_CERTIFICATE0_287_256_FUSE_IDX (300u)

/* Fuse Word CERTIFICATE0[319:288] Index 301 */
#define OTP_CERTIFICATE0_319_288_FUSE_IDX (301u)

/* Fuse Word CERTIFICATE0[351:320] Index 302 */
#define OTP_CERTIFICATE0_351_320_FUSE_IDX (302u)

/* Fuse Word CERTIFICATE0[383:352] Index 303 */
#define OTP_CERTIFICATE0_383_352_FUSE_IDX (303u)

/* Fuse Word CERTIFICATE0[415:384] Index 304 */
#define OTP_CERTIFICATE0_415_384_FUSE_IDX (304u)

/* Fuse Word CERTIFICATE0[447:416] Index 305 */
#define OTP_CERTIFICATE0_447_416_FUSE_IDX (305u)

/* Fuse Word CERTIFICATE0[479:448] Index 306 */
#define OTP_CERTIFICATE0_479_448_FUSE_IDX (306u)

/* Fuse Word CERTIFICATE0[511:480] Index 307 */
#define OTP_CERTIFICATE0_511_480_FUSE_IDX (307u)

/* Fuse Word CERTIFICATE0[543:512] Index 308 */
#define OTP_CERTIFICATE0_543_512_FUSE_IDX (308u)

/* Fuse Word CERTIFICATE0[575:544] Index 309 */
#define OTP_CERTIFICATE0_575_544_FUSE_IDX (309u)

/* Fuse Word CERTIFICATE0[607:576] Index 310 */
#define OTP_CERTIFICATE0_607_576_FUSE_IDX (310u)

/* Fuse Word CERTIFICATE0[639:608] Index 311 */
#define OTP_CERTIFICATE0_639_608_FUSE_IDX (311u)

/* Fuse Word CERTIFICATE0[671:640] Index 312 */
#define OTP_CERTIFICATE0_671_640_FUSE_IDX (312u)

/* Fuse Word CERTIFICATE0[703:672] Index 313 */
#define OTP_CERTIFICATE0_703_672_FUSE_IDX (313u)

/* Fuse Word CERTIFICATE0[735:704] Index 314 */
#define OTP_CERTIFICATE0_735_704_FUSE_IDX (314u)

/* Fuse Word CRC0 Index 360 */
#define OTP_CRC0_FUSE_IDX (360u)

/* Fuse Word CRC1 Index 361 */
#define OTP_CRC1_FUSE_IDX (361u)

/* Fuse Word CRC2 Index 362 */
#define OTP_CRC2_FUSE_IDX (362u)

/* Fuse Word CRC3 Index 363 */
#define OTP_CRC3_FUSE_IDX (363u)

/* Fuse Word CRC4 Index 364 */
#define OTP_CRC4_FUSE_IDX (364u)

/* Fuse Word CRC5 Index 365 */
#define OTP_CRC5_FUSE_IDX (365u)

/* Fuse Word CRC6 Index 366 */
#define OTP_CRC6_FUSE_IDX (366u)

/* Fuse Word CRC7 Index 367 */
#define OTP_CRC7_FUSE_IDX (367u)

/* Fuse Word NT_FW_VER0 Index 368 */
#define OTP_NT_FW_VER0_FUSE_IDX (368u)

#define OTP_NT_FW_VER_15_0_FUSE_IDX   (368u)
#define OTP_NT_FW_VER_15_0_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_15_0_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_15_0_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER1 Index 369 */
#define OTP_NT_FW_VER1_FUSE_IDX (369u)

#define OTP_NT_FW_VER_31_16_FUSE_IDX   (369u)
#define OTP_NT_FW_VER_31_16_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_31_16_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_31_16_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER2 Index 370 */
#define OTP_NT_FW_VER2_FUSE_IDX (370u)

#define OTP_NT_FW_VER_47_32_FUSE_IDX   (370u)
#define OTP_NT_FW_VER_47_32_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_47_32_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_47_32_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER3 Index 371 */
#define OTP_NT_FW_VER3_FUSE_IDX (371u)

#define OTP_NT_FW_VER_63_48_FUSE_IDX   (371u)
#define OTP_NT_FW_VER_63_48_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_63_48_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_63_48_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER4 Index 372 */
#define OTP_NT_FW_VER4_FUSE_IDX (372u)

#define OTP_NT_FW_VER_79_64_FUSE_IDX   (372u)
#define OTP_NT_FW_VER_79_64_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_79_64_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_79_64_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER5 Index 373 */
#define OTP_NT_FW_VER5_FUSE_IDX (373u)

#define OTP_NT_FW_VER_95_80_FUSE_IDX   (373u)
#define OTP_NT_FW_VER_95_80_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_95_80_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_95_80_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER6 Index 374 */
#define OTP_NT_FW_VER6_FUSE_IDX (374u)

#define OTP_NT_FW_VER_111_96_FUSE_IDX   (374u)
#define OTP_NT_FW_VER_111_96_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_111_96_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_111_96_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER7 Index 375 */
#define OTP_NT_FW_VER7_FUSE_IDX (375u)

#define OTP_NT_FW_VER_127_112_FUSE_IDX   (375u)
#define OTP_NT_FW_VER_127_112_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_127_112_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_127_112_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER8 Index 376 */
#define OTP_NT_FW_VER8_FUSE_IDX (376u)

#define OTP_NT_FW_VER_143_128_FUSE_IDX   (376u)
#define OTP_NT_FW_VER_143_128_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_143_128_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_143_128_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER9 Index 377 */
#define OTP_NT_FW_VER9_FUSE_IDX (377u)

#define OTP_NT_FW_VER_159_144_FUSE_IDX   (377u)
#define OTP_NT_FW_VER_159_144_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_159_144_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_159_144_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER10 Index 378 */
#define OTP_NT_FW_VER10_FUSE_IDX (378u)

#define OTP_NT_FW_VER_175_160_FUSE_IDX   (378u)
#define OTP_NT_FW_VER_175_160_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_175_160_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_175_160_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER11 Index 379 */
#define OTP_NT_FW_VER11_FUSE_IDX (379u)

#define OTP_NT_FW_VER_191_176_FUSE_IDX   (379u)
#define OTP_NT_FW_VER_191_176_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_191_176_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_191_176_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER12 Index 380 */
#define OTP_NT_FW_VER12_FUSE_IDX (380u)

#define OTP_NT_FW_VER_207_192_FUSE_IDX   (380u)
#define OTP_NT_FW_VER_207_192_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_207_192_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_207_192_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER13 Index 381 */
#define OTP_NT_FW_VER13_FUSE_IDX (381u)

#define OTP_NT_FW_VER_223_208_FUSE_IDX   (381u)
#define OTP_NT_FW_VER_223_208_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_223_208_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_223_208_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER14 Index 382 */
#define OTP_NT_FW_VER14_FUSE_IDX (382u)

#define OTP_NT_FW_VER_239_224_FUSE_IDX   (382u)
#define OTP_NT_FW_VER_239_224_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_239_224_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_239_224_FUSE_WIDTH (16u)

/* Fuse Word NT_FW_VER15 Index 383 */
#define OTP_NT_FW_VER15_FUSE_IDX (383u)

#define OTP_NT_FW_VER_255_240_FUSE_IDX   (383u)
#define OTP_NT_FW_VER_255_240_FUSE_SHIFT (0u)
#define OTP_NT_FW_VER_255_240_FUSE_MASK  (0xFFFFu)
#define OTP_NT_FW_VER_255_240_FUSE_WIDTH (16u)

/* Fuse Word TZ_FW_VER0 Index 384 */
#define OTP_TZ_FW_VER0_FUSE_IDX (384u)

#define OTP_TZ_FW_VER_15_0_FUSE_IDX   (384u)
#define OTP_TZ_FW_VER_15_0_FUSE_SHIFT (0u)
#define OTP_TZ_FW_VER_15_0_FUSE_MASK  (0xFFFFu)
#define OTP_TZ_FW_VER_15_0_FUSE_WIDTH (16u)

/* Fuse Word TZ_FW_VER1 Index 385 */
#define OTP_TZ_FW_VER1_FUSE_IDX (385u)

#define OTP_TZ_FW_VER_31_16_FUSE_IDX   (385u)
#define OTP_TZ_FW_VER_31_16_FUSE_SHIFT (0u)
#define OTP_TZ_FW_VER_31_16_FUSE_MASK  (0xFFFFu)
#define OTP_TZ_FW_VER_31_16_FUSE_WIDTH (16u)

/* Fuse Word TZ_FW_VER2 Index 386 */
#define OTP_TZ_FW_VER2_FUSE_IDX (386u)

#define OTP_TZ_FW_VER_47_32_FUSE_IDX   (386u)
#define OTP_TZ_FW_VER_47_32_FUSE_SHIFT (0u)
#define OTP_TZ_FW_VER_47_32_FUSE_MASK  (0xFFFFu)
#define OTP_TZ_FW_VER_47_32_FUSE_WIDTH (16u)

/* Fuse Word TZ_FW_VER3 Index 387 */
#define OTP_TZ_FW_VER3_FUSE_IDX (387u)

#define OTP_TZ_FW_VER_63_48_FUSE_IDX   (387u)
#define OTP_TZ_FW_VER_63_48_FUSE_SHIFT (0u)
#define OTP_TZ_FW_VER_63_48_FUSE_MASK  (0xFFFFu)
#define OTP_TZ_FW_VER_63_48_FUSE_WIDTH (16u)

/* Fuse Word WIFI_FW_VER0 Index 388 */
#define OTP_WIFI_FW_VER0_FUSE_IDX (388u)

#define OTP_WIFI_FW_VER_15_0_FUSE_IDX   (388u)
#define OTP_WIFI_FW_VER_15_0_FUSE_SHIFT (0u)
#define OTP_WIFI_FW_VER_15_0_FUSE_MASK  (0xFFFFu)
#define OTP_WIFI_FW_VER_15_0_FUSE_WIDTH (16u)

/* Fuse Word WIFI_FW_VER1 Index 389 */
#define OTP_WIFI_FW_VER1_FUSE_IDX (389u)

#define OTP_WIFI_FW_VER_31_16_FUSE_IDX   (389u)
#define OTP_WIFI_FW_VER_31_16_FUSE_SHIFT (0u)
#define OTP_WIFI_FW_VER_31_16_FUSE_MASK  (0xFFFFu)
#define OTP_WIFI_FW_VER_31_16_FUSE_WIDTH (16u)

/* Fuse Word WIFI_FW_VER2 Index 390 */
#define OTP_WIFI_FW_VER2_FUSE_IDX (390u)

#define OTP_WIFI_FW_VER_47_32_FUSE_IDX   (390u)
#define OTP_WIFI_FW_VER_47_32_FUSE_SHIFT (0u)
#define OTP_WIFI_FW_VER_47_32_FUSE_MASK  (0xFFFFu)
#define OTP_WIFI_FW_VER_47_32_FUSE_WIDTH (16u)

/* Fuse Word WIFI_FW_VER3 Index 391 */
#define OTP_WIFI_FW_VER3_FUSE_IDX (391u)

#define OTP_WIFI_FW_VER_63_48_FUSE_IDX   (391u)
#define OTP_WIFI_FW_VER_63_48_FUSE_SHIFT (0u)
#define OTP_WIFI_FW_VER_63_48_FUSE_MASK  (0xFFFFu)
#define OTP_WIFI_FW_VER_63_48_FUSE_WIDTH (16u)

/* Fuse Word BLE_FW_VER0 Index 392 */
#define OTP_BLE_FW_VER0_FUSE_IDX (392u)

#define OTP_BLE_FW_VER_15_0_FUSE_IDX   (392u)
#define OTP_BLE_FW_VER_15_0_FUSE_SHIFT (0u)
#define OTP_BLE_FW_VER_15_0_FUSE_MASK  (0xFFFFu)
#define OTP_BLE_FW_VER_15_0_FUSE_WIDTH (16u)

/* Fuse Word BLE_FW_VER1 Index 393 */
#define OTP_BLE_FW_VER1_FUSE_IDX (393u)

#define OTP_BLE_FW_VER_31_16_FUSE_IDX   (393u)
#define OTP_BLE_FW_VER_31_16_FUSE_SHIFT (0u)
#define OTP_BLE_FW_VER_31_16_FUSE_MASK  (0xFFFFu)
#define OTP_BLE_FW_VER_31_16_FUSE_WIDTH (16u)

/* Fuse Word BLE_FW_VER2 Index 394 */
#define OTP_BLE_FW_VER2_FUSE_IDX (394u)

#define OTP_BLE_FW_VER_47_32_FUSE_IDX   (394u)
#define OTP_BLE_FW_VER_47_32_FUSE_SHIFT (0u)
#define OTP_BLE_FW_VER_47_32_FUSE_MASK  (0xFFFFu)
#define OTP_BLE_FW_VER_47_32_FUSE_WIDTH (16u)

/* Fuse Word BLE_FW_VER3 Index 395 */
#define OTP_BLE_FW_VER3_FUSE_IDX (395u)

#define OTP_BLE_FW_VER_63_48_FUSE_IDX   (395u)
#define OTP_BLE_FW_VER_63_48_FUSE_SHIFT (0u)
#define OTP_BLE_FW_VER_63_48_FUSE_MASK  (0xFFFFu)
#define OTP_BLE_FW_VER_63_48_FUSE_WIDTH (16u)

/* Fuse Word 15_4_FW_VER0 Index 396 */
#define OTP_15_4_FW_VER0_FUSE_IDX (396u)

#define OTP_15_4_FW_VER_15_0_FUSE_IDX   (396u)
#define OTP_15_4_FW_VER_15_0_FUSE_SHIFT (0u)
#define OTP_15_4_FW_VER_15_0_FUSE_MASK  (0xFFFFu)
#define OTP_15_4_FW_VER_15_0_FUSE_WIDTH (16u)

/* Fuse Word 15_4_FW_VER1 Index 397 */
#define OTP_15_4_FW_VER1_FUSE_IDX (397u)

#define OTP_15_4_FW_VER_31_16_FUSE_IDX   (397u)
#define OTP_15_4_FW_VER_31_16_FUSE_SHIFT (0u)
#define OTP_15_4_FW_VER_31_16_FUSE_MASK  (0xFFFFu)
#define OTP_15_4_FW_VER_31_16_FUSE_WIDTH (16u)

/* Fuse Word 15_4_FW_VER2 Index 398 */
#define OTP_15_4_FW_VER2_FUSE_IDX (398u)

#define OTP_15_4_FW_VER_47_32_FUSE_IDX   (398u)
#define OTP_15_4_FW_VER_47_32_FUSE_SHIFT (0u)
#define OTP_15_4_FW_VER_47_32_FUSE_MASK  (0xFFFFu)
#define OTP_15_4_FW_VER_47_32_FUSE_WIDTH (16u)

/* Fuse Word 15_4_FW_VER3 Index 399 */
#define OTP_15_4_FW_VER3_FUSE_IDX (399u)

#define OTP_15_4_FW_VER_63_48_FUSE_IDX   (399u)
#define OTP_15_4_FW_VER_63_48_FUSE_SHIFT (0u)
#define OTP_15_4_FW_VER_63_48_FUSE_MASK  (0xFFFFu)
#define OTP_15_4_FW_VER_63_48_FUSE_WIDTH (16u)

/* Fuse Word USER_RED_0 Index 400 */
#define OTP_USER_RED_0_FUSE_IDX (400u)

/* Fuse Word USER_RED_1 Index 401 */
#define OTP_USER_RED_1_FUSE_IDX (401u)

/* Fuse Word USER_RED_2 Index 402 */
#define OTP_USER_RED_2_FUSE_IDX (402u)

/* Fuse Word USER_RED_3 Index 403 */
#define OTP_USER_RED_3_FUSE_IDX (403u)

/* Fuse Word ROLLBACK_COUNTER_0 Index 404 */
#define OTP_ROLLBACK_COUNTER_0_FUSE_IDX (404u)

#define OTP_ROLLBACK_COUNTER_FUSE_IDX   (404u)
#define OTP_ROLLBACK_COUNTER_FUSE_SHIFT (0u)
#define OTP_ROLLBACK_COUNTER_FUSE_MASK  (0xFFFFFFFFu)
#define OTP_ROLLBACK_COUNTER_FUSE_WIDTH (32u)

/* Fuse Word ROLLBACK_COUNTER_1 Index 405 */
#define OTP_ROLLBACK_COUNTER_1_FUSE_IDX (405u)

#define OTP_ROLLBACK_COUNTER_FUSE_IDX_1 (405u)
#define OTP_ROLLBACK_COUNTER_FUSE_SHIFT (0u)
#define OTP_ROLLBACK_COUNTER_FUSE_MASK  (0xFFFFFFFFu)
#define OTP_ROLLBACK_COUNTER_FUSE_WIDTH (32u)

/* Fuse Word ROLLBACK_COUNTER_2 Index 406 */
#define OTP_ROLLBACK_COUNTER_2_FUSE_IDX (406u)

#define OTP_ROLLBACK_COUNTER_FUSE_IDX_2 (406u)
#define OTP_ROLLBACK_COUNTER_FUSE_SHIFT (0u)
#define OTP_ROLLBACK_COUNTER_FUSE_MASK  (0xFFFFFFFFu)
#define OTP_ROLLBACK_COUNTER_FUSE_WIDTH (32u)

/* Fuse Word ROLLBACK_COUNTER_3 Index 407 */
#define OTP_ROLLBACK_COUNTER_3_FUSE_IDX (407u)

#define OTP_ROLLBACK_COUNTER_FUSE_IDX_3 (407u)
#define OTP_ROLLBACK_COUNTER_FUSE_SHIFT (0u)
#define OTP_ROLLBACK_COUNTER_FUSE_MASK  (0xFFFFFFFFu)
#define OTP_ROLLBACK_COUNTER_FUSE_WIDTH (32u)

#define OTP_FUSEMAP_SIZE (420u)

#endif // __FUSEMAP_H__
