/*
** ###################################################################
**     Processors:          RW612ETA2I
**                          RW612HNA2I
**                          RW612UKA2I
**
**     Compilers:           GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**                          Keil ARM C/C++ Compiler
**                          MCUXpresso Compiler
**
**     Reference manual:    RW61X User manual Rev. 0.95, June 2022
**     Version:             rev. 1.0, 2021-03-16
**     Build:               b240411
**
**     Abstract:
**         CMSIS Peripheral Access Layer for RW612
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2024 NXP
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2021-03-16)
**         Initial version.
**
** ###################################################################
*/

/*!
 * @file RW612.h
 * @version 1.0
 * @date 2021-03-16
 * @brief CMSIS Peripheral Access Layer for RW612
 *
 * CMSIS Peripheral Access Layer for RW612
 */

#if !defined(RW612_H_)
#define RW612_H_                                 /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0100U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000U

/* ----------------------------------------------------------------------------
   --
   ---------------------------------------------------------------------------- */

/* global Backward compatibility */
#define MRT0_IRQn                                MRT_IRQn
#define MRT0_IRQHandler                          MRT_IRQHandler
#define MRT0_DriverIRQHandler                    MRT_DriverIRQHandler
#define MRT1_IRQn                                GFMRT_IRQn
#define MRT1_IRQHandler                          GFMRT_IRQHandler
#define MRT1_DriverIRQHandler                    GFMRT_DriverIRQHandler
#define DMIC0_IRQn                               DMIC_IRQn
#define DMIC0_IRQHandler                         DMIC_IRQHandler
#define DMIC0_DriverIRQHandler                   DMIC_DriverIRQHandler
#define WFD_IRQn                                 WKDEEPSLEEP_IRQn
#define WFD_IRQHandler                           WKDEEPSLEEP_IRQHandler
#define WFD_DriverIRQHandler                     WKDEEPSLEEP_DriverIRQHandler
#define HWVAD0_IRQn                              HWVAD_IRQn
#define HWVAD0_IRQHandler                        HWVAD_IRQHandler
#define HWVAD0_DriverIRQHandler                  HWVAD_DriverIRQHandler
#define OS_EVENT_IRQn                            OS_EVENT_TIMER_IRQn
#define OS_EVENT_IRQHandler                      OS_EVENT_TIMER_IRQHandler
#define OS_EVENT_DriverIRQHandler                OS_EVENT_TIMER_DriverIRQHandler
#define SDU_IRQn                                 SDIO_IRQn
#define SDU_IRQHandler                           SDIO_IRQHandler
#define SDU_DriverIRQHandler                     SDIO_DriverIRQHandler
#define LCDIC_IRQn                               LCD_IRQn
#define LCDIC_IRQHandler                         LCD_IRQHandler
#define LCDIC_DriverIRQHandler                   LCD_DriverIRQHandler
#define CAPT_PULSE_IRQn                          CAPTIMER_IRQn
#define CAPT_PULSE_IRQHandler                    CAPTIMER_IRQHandler
#define CAPT_PULSE_DriverIRQHandler              CAPTIMER_DriverIRQHandler
#define WL_MCI_WAKEUP_DONE0_IRQn                 W2MWKUP_DONE0_IRQn
#define WL_MCI_WAKEUP_DONE0_IRQHandler           W2MWKUP_DONE0_IRQHandler
#define WL_MCI_WAKEUP_DONE0_DriverIRQHandler     W2MWKUP_DONE0_DriverIRQHandler
#define WL_MCI_WAKEUP_DONE1_IRQn                 W2MWKUP_DONE1_IRQn
#define WL_MCI_WAKEUP_DONE1_IRQHandler           W2MWKUP_DONE1_IRQHandler
#define WL_MCI_WAKEUP_DONE1_DriverIRQHandler     W2MWKUP_DONE1_DriverIRQHandler
#define WL_MCI_WAKEUP_DONE2_IRQn                 W2MWKUP_DONE2_IRQn
#define WL_MCI_WAKEUP_DONE2_IRQHandler           W2MWKUP_DONE2_IRQHandler
#define WL_MCI_WAKEUP_DONE2_DriverIRQHandler     W2MWKUP_DONE2_DriverIRQHandler
#define WL_MCI_WAKEUP_DONE3_IRQn                 W2MWKUP_DONE3_IRQn
#define WL_MCI_WAKEUP_DONE3_IRQHandler           W2MWKUP_DONE3_IRQHandler
#define WL_MCI_WAKEUP_DONE3_DriverIRQHandler     W2MWKUP_DONE3_DriverIRQHandler
#define WL_MCI_WAKEUP_DONE4_IRQn                 W2MWKUP_DONE4_IRQn
#define WL_MCI_WAKEUP_DONE4_IRQHandler           W2MWKUP_DONE4_IRQHandler
#define WL_MCI_WAKEUP_DONE4_DriverIRQHandler     W2MWKUP_DONE4_DriverIRQHandler
#define WL_MCI_WAKEUP_DONE5_IRQn                 W2MWKUP_DONE5_IRQn
#define WL_MCI_WAKEUP_DONE5_IRQHandler           W2MWKUP_DONE5_IRQHandler
#define WL_MCI_WAKEUP_DONE5_DriverIRQHandler     W2MWKUP_DONE5_DriverIRQHandler
#define WL_MCI_WAKEUP_DONE6_IRQn                 W2MWKUP_DONE6_IRQn
#define WL_MCI_WAKEUP_DONE6_IRQHandler           W2MWKUP_DONE6_IRQHandler
#define WL_MCI_WAKEUP_DONE6_DriverIRQHandler     W2MWKUP_DONE6_DriverIRQHandler
#define WL_MCI_WAKEUP_DONE7_IRQn                 W2MWKUP_DONE7_IRQn
#define WL_MCI_WAKEUP_DONE7_IRQHandler           W2MWKUP_DONE7_IRQHandler
#define WL_MCI_WAKEUP_DONE7_DriverIRQHandler     W2MWKUP_DONE7_DriverIRQHandler
#define WL_MCI_WAKEUP0_IRQn                      W2MWKUP0_IRQn
#define WL_MCI_WAKEUP0_IRQHandler                W2MWKUP0_IRQHandler
#define WL_MCI_WAKEUP0_DriverIRQHandler          W2MWKUP0_DriverIRQHandler
#define WL_MCI_WAKEUP1_IRQn                      W2MWKUP1_IRQn
#define WL_MCI_WAKEUP1_IRQHandler                W2MWKUP1_IRQHandler
#define WL_MCI_WAKEUP1_DriverIRQHandler          W2MWKUP1_DriverIRQHandler
#define BLE_MCI_WAKEUP_DONE0_IRQn                B2MWKUP_DONE0_IRQn
#define BLE_MCI_WAKEUP_DONE0_IRQHandler          B2MWKUP_DONE0_IRQHandler
#define BLE_MCI_WAKEUP_DONE0_DriverIRQHandler    B2MWKUP_DONE0_DriverIRQHandler
#define BLE_MCI_WAKEUP_DONE1_IRQn                B2MWKUP_DONE1_IRQn
#define BLE_MCI_WAKEUP_DONE1_IRQHandler          B2MWKUP_DONE1_IRQHandler
#define BLE_MCI_WAKEUP_DONE1_DriverIRQHandler    B2MWKUP_DONE1_DriverIRQHandler
#define BLE_MCI_WAKEUP_DONE2_IRQn                B2MWKUP_DONE2_IRQn
#define BLE_MCI_WAKEUP_DONE2_IRQHandler          B2MWKUP_DONE2_IRQHandler
#define BLE_MCI_WAKEUP_DONE2_DriverIRQHandler    B2MWKUP_DONE2_DriverIRQHandler
#define BLE_MCI_WAKEUP_DONE3_IRQn                B2MWKUP_DONE3_IRQn
#define BLE_MCI_WAKEUP_DONE3_IRQHandler          B2MWKUP_DONE3_IRQHandler
#define BLE_MCI_WAKEUP_DONE3_DriverIRQHandler    B2MWKUP_DONE3_DriverIRQHandler
#define BLE_MCI_WAKEUP_DONE4_IRQn                B2MWKUP_DONE4_IRQn
#define BLE_MCI_WAKEUP_DONE4_IRQHandler          B2MWKUP_DONE4_IRQHandler
#define BLE_MCI_WAKEUP_DONE4_DriverIRQHandler    B2MWKUP_DONE4_DriverIRQHandler
#define BLE_MCI_WAKEUP_DONE5_IRQn                B2MWKUP_DONE5_IRQn
#define BLE_MCI_WAKEUP_DONE5_IRQHandler          B2MWKUP_DONE5_IRQHandler
#define BLE_MCI_WAKEUP_DONE5_DriverIRQHandler    B2MWKUP_DONE5_DriverIRQHandler
#define BLE_MCI_WAKEUP_DONE6_IRQn                B2MWKUP_DONE6_IRQn
#define BLE_MCI_WAKEUP_DONE6_IRQHandler          B2MWKUP_DONE6_IRQHandler
#define BLE_MCI_WAKEUP_DONE6_DriverIRQHandler    B2MWKUP_DONE6_DriverIRQHandler
#define BLE_MCI_WAKEUP_DONE7_IRQn                B2MWKUP_DONE7_IRQn
#define BLE_MCI_WAKEUP_DONE7_IRQHandler          B2MWKUP_DONE7_IRQHandler
#define BLE_MCI_WAKEUP_DONE7_DriverIRQHandler    B2MWKUP_DONE7_DriverIRQHandler
#define BLE_MCI_WAKEUP0_IRQn                     B2MWKUP0_IRQn
#define BLE_MCI_WAKEUP0_IRQHandler               B2MWKUP0_IRQHandler
#define BLE_MCI_WAKEUP0_DriverIRQHandler         B2MWKUP0_DriverIRQHandler
#define BLE_MCI_WAKEUP1_IRQn                     B2MWKUP1_IRQn
#define BLE_MCI_WAKEUP1_IRQHandler               B2MWKUP1_IRQHandler
#define BLE_MCI_WAKEUP1_DriverIRQHandler         B2MWKUP1_DriverIRQHandler
#define ELS_GDET_IRQ_IRQn                        ELS_GDET_IRQn
#define ELS_GDET_IRQ_IRQHandler                  ELS_GDET_IRQHandler
#define ELS_GDET_IRQ_DriverIRQHandler            ELS_GDET_DriverIRQHandler
#define ELS_GDET_ERR_IRQn                        ELS_GDET_UM_IRQn
#define ELS_GDET_ERR_IRQHandler                  ELS_GDET_UM_IRQHandler
#define ELS_GDET_ERR_DriverIRQHandler            ELS_GDET_UM_DriverIRQHandler
#define PKC_IRQn                                 PKC_INT_IRQn
#define PKC_IRQHandler                           PKC_INT_IRQHandler
#define PKC_DriverIRQHandler                     PKC_INT_DriverIRQHandler
#define CDOG_IRQn                                CDOG_INT_IRQn
#define CDOG_IRQHandler                          CDOG_INT_IRQHandler
#define CDOG_DriverIRQHandler                    CDOG_INT_DriverIRQHandler
#define GAU_GPDAC_INT_FUNC11_IRQn                GAU_DAC_IRQn
#define GAU_GPDAC_INT_FUNC11_IRQHandler          GAU_DAC_IRQHandler
#define GAU_GPDAC_INT_FUNC11_DriverIRQHandler    GAU_DAC_DriverIRQHandler
#define GAU_ACOMP_INT_WKUP11_IRQn                GAU_ACOMP_WKUP_IRQn
#define GAU_ACOMP_INT_WKUP11_IRQHandler          GAU_ACOMP_WKUP_IRQHandler
#define GAU_ACOMP_INT_WKUP11_DriverIRQHandler    GAU_ACOMP_WKUP_DriverIRQHandler
#define GAU_ACOMP_INT_FUNC11_IRQn                GAU_ACOMP_IRQn
#define GAU_ACOMP_INT_FUNC11_IRQHandler          GAU_ACOMP_IRQHandler
#define GAU_ACOMP_INT_FUNC11_DriverIRQHandler    GAU_ACOMP_DriverIRQHandler
#define GAU_GPADC1_INT_FUNC11_IRQn               GAU_ADC1_IRQn
#define GAU_GPADC1_INT_FUNC11_IRQHandler         GAU_ADC1_IRQHandler
#define GAU_GPADC1_INT_FUNC11_DriverIRQHandler   GAU_ADC1_DriverIRQHandler
#define GAU_GPADC0_INT_FUNC11_IRQn               GAU_ADC0_IRQn
#define GAU_GPADC0_INT_FUNC11_IRQHandler         GAU_ADC0_IRQHandler
#define GAU_GPADC0_INT_FUNC11_DriverIRQHandler   GAU_ADC0_DriverIRQHandler
#define OCOTP_IRQn                               OTP_IRQn
#define OCOTP_IRQHandler                         OTP_IRQHandler
#define OCOTP_DriverIRQHandler                   OTP_DriverIRQHandler
#define BOD_1_85_INT_IRQn                        PMIP_IRQn
#define BOD_1_85_INT_IRQHandler                  PMIP_IRQHandler
#define BOD_1_85_INT_DriverIRQHandler            PMIP_DriverIRQHandler
#define BOD_1_85_NEG_IRQn                        PMIP_CHANGE_IRQn
#define BOD_1_85_NEG_IRQHandler                  PMIP_CHANGE_IRQHandler
#define BOD_1_85_NEG_DriverIRQHandler            PMIP_CHANGE_DriverIRQHandler
#define AHB_MEM_ACC_CHECKER_VIO_INT_C_OR_IRQn               ACC_C_INT_IRQn
#define AHB_MEM_ACC_CHECKER_VIO_INT_C_OR_IRQHandler         ACC_C_INT_IRQHandler
#define AHB_MEM_ACC_CHECKER_VIO_INT_C_OR_DriverIRQHandler   ACC_C_INT_DriverIRQHandler
#define AHB_MEM_ACC_CHECKER_VIO_INT_S_OR_IRQn               ACC_S_INT_IRQn
#define AHB_MEM_ACC_CHECKER_VIO_INT_S_OR_IRQHandler         ACC_S_INT_IRQHandler
#define AHB_MEM_ACC_CHECKER_VIO_INT_S_OR_DriverIRQHandler   ACC_S_INT_DriverIRQHandler
#define WL_ACC_INT_IRQn                          WACC_IRQn
#define WL_ACC_INT_IRQHandler                    WACC_IRQHandler
#define WL_ACC_INT_DriverIRQHandler              WACC_DriverIRQHandler
#define BLE_ACC_INT_IRQn                         BACC_IRQn
#define BLE_ACC_INT_IRQHandler                   BACC_IRQHandler
#define BLE_ACC_INT_DriverIRQHandler             BACC_DriverIRQHandler



/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 145                /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  NonMaskableInt_IRQn          = -14,              /**< Non Maskable Interrupt */
  HardFault_IRQn               = -13,              /**< Cortex-M33 SV Hard Fault Interrupt */
  MemoryManagement_IRQn        = -12,              /**< Cortex-M33 Memory Management Interrupt */
  BusFault_IRQn                = -11,              /**< Cortex-M33 Bus Fault Interrupt */
  UsageFault_IRQn              = -10,              /**< Cortex-M33 Usage Fault Interrupt */
  SecureFault_IRQn             = -9,               /**< Cortex-M33 Secure Fault Interrupt */
  SVCall_IRQn                  = -5,               /**< Cortex-M33 SV Call Interrupt */
  DebugMonitor_IRQn            = -4,               /**< Cortex-M33 Debug Monitor Interrupt */
  PendSV_IRQn                  = -2,               /**< Cortex-M33 Pend SV Interrupt */
  SysTick_IRQn                 = -1,               /**< Cortex-M33 System Tick Interrupt */

  /* Device specific interrupts */
  WDT0_IRQn                    = 0,                /**< Windowed watchdog timer 0 (WDT0)(Cortex-M33 watchdog) */
  DMA0_IRQn                    = 1,                /**< Direct memory access (DMA) controller 0 (secure or Cortex-M33 DMA) */
  GPIO_INTA_IRQn               = 2,                /**< GPIO interrupt A */
  GPIO_INTB_IRQn               = 3,                /**< GPIO interrupt B */
  PIN_INT0_IRQn                = 4,                /**< Pin interrupt 0 or pattern match engine slice 0 */
  PIN_INT1_IRQn                = 5,                /**< Pin interrupt 1 or pattern match engine slice 1 */
  PIN_INT2_IRQn                = 6,                /**< Pin interrupt 2 or pattern match engine slice 2 */
  PIN_INT3_IRQn                = 7,                /**< Pin interrupt 3 or pattern match engine slice 3 */
  UTICK_IRQn                   = 8,                /**< Micro-tick Timer (UTICK) */
  MRT_IRQn                     = 9,                /**< Multi-Rate Timer (MRT). Global MRT interrupts */
  CTIMER0_IRQn                 = 10,               /**< Standard counter/timer CTIMER0 */
  CTIMER1_IRQn                 = 11,               /**< Standard counter/timer CTIMER1 */
  SCT0_IRQn                    = 12,               /**< SCTimer/PWM */
  CTIMER3_IRQn                 = 13,               /**< Standard counter/timer CTIMER3 */
  FLEXCOMM0_IRQn               = 14,               /**< Flexcomm Interface 0 (USART, SPI, I2C, I2S) */
  FLEXCOMM1_IRQn               = 15,               /**< Flexcomm Interface 1 (USART, SPI, I2C, I2S) */
  FLEXCOMM2_IRQn               = 16,               /**< Flexcomm Interface 2 (USART, SPI, I2C, I2S) */
  FLEXCOMM3_IRQn               = 17,               /**< Flexcomm Interface 3 (USART, SPI, I2C, I2S) */
  Reserved34_IRQn              = 18,               /**< Reserved interrupt */
  Reserved35_IRQn              = 19,               /**< Reserved interrupt */
  FLEXCOMM14_IRQn              = 20,               /**< Flexcomm Interface 14 (USART, SPI, I2C, I2S) */
  Reserved37_IRQn              = 21,               /**< Reserved interrupt */
  Reserved38_IRQn              = 22,               /**< Reserved interrupt */
  GFMRT_IRQn                   = 23,               /**< Free Multi-rate timer (GFMRT). Global MRT interrupts */
  Reserved40_IRQn              = 24,               /**< Reserved interrupt */
  DMIC_IRQn                    = 25,               /**< Digital microphone (DMIC) and DMIC subsystem */
  WKDEEPSLEEP_IRQn             = 26,               /**< Wake-up from deep sleep */
  HYPERVISOR_IRQn              = 27,               /**< Hypervisor service software interrupt */
  SECUREVIOLATION_IRQn         = 28,               /**< Secure violation */
  HWVAD_IRQn                   = 29,               /**< Hardware Voice Activity Detector */
  Reserved46_IRQn              = 30,               /**< Reserved interrupt */
  Reserved47_IRQn              = 31,               /**< Reserved interrupt */
  RTC_IRQn                     = 32,               /**< RTC alarm and wake-up */
  Reserved49_IRQn              = 33,               /**< Reserved interrupt */
  Reserved50_IRQn              = 34,               /**< Reserved interrupt */
  PIN_INT4_IRQn                = 35,               /**< Pin interrupt 4 or pattern match engine slice 4 */
  PIN_INT5_IRQn                = 36,               /**< Pin interrupt 5 or pattern match engine slice 5 */
  PIN_INT6_IRQn                = 37,               /**< Pin interrupt 6 or pattern match engine slice 6 */
  PIN_INT7_IRQn                = 38,               /**< Pin interrupt 7 or pattern match engine slice 7 */
  CTIMER2_IRQn                 = 39,               /**< Standard counter/timer CTIMER2 */
  CTIMER4_IRQn                 = 40,               /**< Standard counter/timer CTIMER4 */
  OS_EVENT_TIMER_IRQn          = 41,               /**< OS event timer 0 */
  FLEXSPI_IRQn                 = 42,               /**< FLEXSPI interface */
  Reserved59_IRQn              = 43,               /**< Reserved interrupt */
  Reserved60_IRQn              = 44,               /**< Reserved interrupt */
  Reserved61_IRQn              = 45,               /**< Reserved interrupt */
  SDIO_IRQn                    = 46,               /**< The secure digital interface */
  SGPIO_INTA_IRQn              = 47,               /**< Secure GPIO interrupt A */
  SGPIO_INTB_IRQn              = 48,               /**< Secure GPIO interrupt B */
  Reserved65_IRQn              = 49,               /**< Reserved interrupt */
  USB_IRQn                     = 50,               /**< High-speed USB device/host */
  Reserved67_IRQn              = 51,               /**< Reserved interrupt */
  Reserved68_IRQn              = 52,               /**< Reserved interrupt */
  Reserved69_IRQn              = 53,               /**< Reserved interrupt */
  DMA1_IRQn                    = 54,               /**< DMA controller 1 (non-secure or HiFi 4 DMA) */
  PUF_IRQn                     = 55,               /**< Physical Unclonable Function */
  POWERQUAD_IRQn               = 56,               /**< PowerQuad math coprocessor */
  Reserved73_IRQn              = 57,               /**< Reserved interrupt */
  Reserved74_IRQn              = 58,               /**< Reserved interrupt */
  Reserved75_IRQn              = 59,               /**< Reserved interrupt */
  Reserved76_IRQn              = 60,               /**< Reserved interrupt */
  LCD_IRQn                     = 61,               /**< LCDIC */
  CAPTIMER_IRQn                = 62,               /**< Capture timer */
  Reserved79_IRQn              = 63,               /**< Reserved interrupt */
  W2MWKUP_DONE0_IRQn           = 64,               /**< Wi-Fi to MCU, wakeup done 0 */
  W2MWKUP_DONE1_IRQn           = 65,               /**< Wi-Fi to MCU, wakeup done 1 */
  W2MWKUP_DONE2_IRQn           = 66,               /**< Wi-Fi to MCU, wakeup done 2 */
  W2MWKUP_DONE3_IRQn           = 67,               /**< Wi-Fi to MCU, wakeup done 3 */
  W2MWKUP_DONE4_IRQn           = 68,               /**< Wi-Fi to MCU, wakeup done 4 */
  W2MWKUP_DONE5_IRQn           = 69,               /**< Wi-Fi to MCU, wakeup done 5 */
  W2MWKUP_DONE6_IRQn           = 70,               /**< Wi-Fi to MCU, wakeup done 6 */
  W2MWKUP_DONE7_IRQn           = 71,               /**< Wi-Fi to MCU, wakeup done 7 */
  W2MWKUP0_IRQn                = 72,               /**< Wi-Fi to MCU, wakeup signal 0 */
  W2MWKUP1_IRQn                = 73,               /**< Wi-Fi to MCU, wakueup signal 1 */
  WL_MCI_INT0_IRQn             = 74,               /**< Wi-Fi to MCU interrupt 0 */
  WL_MCI_INT1_IRQn             = 75,               /**< Reserved for Wi-Fi to MCU */
  WL_MCI_INT2_IRQn             = 76,               /**< Reserved for Wi-Fi to MCU */
  WL_MCI_INT3_IRQn             = 77,               /**< Reserved for Wi-Fi to MCU */
  WL_MCI_INT4_IRQn             = 78,               /**< Reserved for Wi-Fi to MCU */
  WL_MCI_INT5_IRQn             = 79,               /**< Reserved for Wi-Fi to MCU */
  WL_MCI_INT6_IRQn             = 80,               /**< Reserved for Wi-Fi to MCU */
  WL_MCI_INT7_IRQn             = 81,               /**< Reserved for Wi-Fi to MCU */
  B2MWKUP_DONE0_IRQn           = 82,               /**< Bluetooth LE/802.15.4 radio to MCU, wakeup done 0 */
  B2MWKUP_DONE1_IRQn           = 83,               /**< Bluetooth LE/802.15.4 radio to MCU, wakeup done 1 */
  B2MWKUP_DONE2_IRQn           = 84,               /**< Bluetooth LE/802.15.4 radio to MCU, wakeup done 2 */
  B2MWKUP_DONE3_IRQn           = 85,               /**< Bluetooth LE/802.15.4 radio to MCU, wakeup done 3 */
  B2MWKUP_DONE4_IRQn           = 86,               /**< Bluetooth LE/802.15.4 radio to MCU, wakeup done 4 */
  B2MWKUP_DONE5_IRQn           = 87,               /**< Bluetooth LE/802.15.4 radio to MCU, wakeup done 5 */
  B2MWKUP_DONE6_IRQn           = 88,               /**< Bluetooth LE/802.15.4 radio to MCU, wakeup done 6 */
  B2MWKUP_DONE7_IRQn           = 89,               /**< Bluetooth LE/802.15.4 radio to MCU, wakeup done 7 */
  B2MWKUP0_IRQn                = 90,               /**< Bluetooth LE/802.15.4 radio to MCU, wakeup signal 0 */
  B2MWKUP1_IRQn                = 91,               /**< Bluetooth LE/802.15.4 radio to MCU, wakeup signal 1 */
  BLE_MCI_INT0_IRQn            = 92,               /**< Bluetooth LE/802.15.4 radio to MCU interrupt 0 */
  BLE_MCI_INT1_IRQn            = 93,               /**< Reserved for Bluetooth LE/802.15.4 radio to MCU */
  BLE_MCI_INT2_IRQn            = 94,               /**< Reserved for Bluetooth LE/802.15.4 radio to MCU */
  BLE_MCI_INT3_IRQn            = 95,               /**< Reserved for Bluetooth LE/802.15.4 radio to MCU */
  BLE_MCI_INT4_IRQn            = 96,               /**< Reserved for Bluetooth LE/802.15.4 radio to MCU */
  BLE_MCI_INT5_IRQn            = 97,               /**< Reserved for Bluetooth LE/802.15.4 radio to MCU */
  BLE_MCI_INT6_IRQn            = 98,               /**< Reserved for Bluetooth LE/802.15.4 radio to MCU */
  BLE_MCI_INT7_IRQn            = 99,               /**< Reserved for Bluetooth LE/802.15.4 radio to MCU */
  PIN0_INT_IRQn                = 100,              /**< From AON GPIO */
  PIN1_INT_IRQn                = 101,              /**< From AON GPIO */
  ELS_IRQn                     = 102,              /**< EdgeLock subsystem (ELS) */
  ELS_GDET_IRQn                = 103,              /**< ELS IRQ line for GDET error */
  ELS_GDET_UM_IRQn             = 104,              /**< ELS un-gated latched error */
  PKC_INT_IRQn                 = 105,              /**< Public key crypto-processor (PKC) interrupt */
  PKC_ERR_IRQn                 = 106,              /**< PKC error */
  CDOG_INT_IRQn                = 107,              /**< Code watch dog timmer interrupt */
  GAU_DAC_IRQn                 = 108,              /**< General analog unit (GAU) digital to analog converter (DAC) */
  GAU_ACOMP_WKUP_IRQn          = 109,              /**< GAU analog comparator (ACOMP) wake-up */
  GAU_ACOMP_IRQn               = 110,              /**< GAU analog comparator */
  GAU_ADC1_IRQn                = 111,              /**< GAU analog to digital converter 1 (ADC1) */
  GAU_ADC0_IRQn                = 112,              /**< GAU analog to digital converter 0 (ADC0) */
  USIM_IRQn                    = 113,              /**< Universal subscriber identity module (USIM) interface */
  OTP_IRQn                     = 114,              /**< One time programmable (OTP) memory interrupt */
  ENET_IRQn                    = 115,              /**< Etheret interrupt */
  ENET_TIMER_IRQn              = 116,              /**< Ethernet timer interrupt */
  PMIP_IRQn                    = 117,              /**< Power management IP (PMIP) */
  PMIP_CHANGE_IRQn             = 118,              /**< PMIP change from 1 to 0 */
  ITRC_IRQn                    = 119,              /**< Intrusion and tamper response controller (ITRC) interrupt request */
  Reserved136_IRQn             = 120,              /**< Reserved interrupt */
  Reserved137_IRQn             = 121,              /**< Reserved interrupt */
  Reserved138_IRQn             = 122,              /**< Reserved interrupt */
  TRNG_IRQn                    = 123,              /**< TRNG interrupt request */
  ACC_C_INT_IRQn               = 124,              /**< AHB memory access checker - Cortex-M33 code bus */
  ACC_S_INT_IRQn               = 125,              /**< AHB memory access checker - Cortex-M33 sys bus */
  WACC_IRQn                    = 126,              /**< Wi-Fi accessed during power off */
  BACC_IRQn                    = 127,              /**< Bluetooth LE/802.15.4 radio accessed during power off */
  GDMA_IRQn                    = 128               /**< General purpose direct memory access (GDMA) interrupt */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Cortex M33 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M33 Core Configuration
 * @{
 */

#define __MPU_PRESENT                  1         /**< Defines if an MPU is present or not */
#define __NVIC_PRIO_BITS               3         /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig         0         /**< Vendor specific implementation of SysTickConfig is defined */
#define __FPU_PRESENT                  1         /**< Defines if an FPU is present or not */
#define __DSP_PRESENT                  0         /**< Defines if Armv8-M Mainline core supports DSP instructions */
#define __SAUREGION_PRESENT            1         /**< Defines if an SAU is present or not */

#include "core_cm33.h"                 /* Core Peripheral Access Layer */
#include "system_RW612.h"              /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */


/* ----------------------------------------------------------------------------
   -- Mapping Information
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Mapping_Information Mapping Information
 * @{
 */

/** Mapping Information */
/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief The enumeration of dac channel trigger sources.
 */

typedef enum _dac_channel_trigger_source
{
    kDAC_TriggerSourceCtimer1Match2 = 0U,          /**< Use CTimer1 match 2 as trigger source. */
    kDAC_TriggerSourceCtimer1Match1 = 1U,          /**< Use CTimer1 match 1 as trigger source. */
    kDAC_TriggerSourceGpio50        = 2U,          /**< Use GPIO50 as trigger source. */
    kDAC_TriggerSourceGpio55        = 3U,          /**< Use GPIO55 as trigger source. */
} dac_channel_trigger_source_t;

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief ADC trigger source, including software trigger and multiple hardware trigger sources.
 */

typedef enum _adc_trigger_source
{
    kADC_TriggerSourceCtimer        = 0U,          /**< Hardware trigger, trigger source 0:CTimer3_match1 for ADC0, CTimer3_match2 for ADC1. */
    kADC_TriggerSourceAcomp         = 1U,          /**< Hardware trigger, trigger source 1: ACOMP0 for ADC0, ACMP1 for ADC1. */
    kADC_TriggerSourceGpio50        = 2U,          /**< Hardware trigger, trigger source 2: GPIO50. */
    kADC_TriggerSourceGpio55        = 3U,          /**< Hardware trigger, trigger source 3: GPIO55. */
    kADC_TriggerSourceSoftware      = 4U,          /**< Software trigger. */
} adc_trigger_source_t;


/*!
 * @}
 */ /* end of group Mapping_Information */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ACOMP Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ACOMP_Peripheral_Access_Layer ACOMP Peripheral Access Layer
 * @{
 */

/** ACOMP - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL0;                             /**< ACOMP0 Control Register, offset: 0x0 */
  __IO uint32_t CTRL1;                             /**< ACOMP1 Control Register, offset: 0x4 */
  __I  uint32_t STATUS0;                           /**< ACOMP0 Status Register, offset: 0x8 */
  __I  uint32_t STATUS1;                           /**< ACOMP1 Status Register, offset: 0xC */
  __IO uint32_t ROUTE0;                            /**< ACOMP0 Route Register, offset: 0x10 */
  __IO uint32_t ROUTE1;                            /**< ACOMP1 Route Register, offset: 0x14 */
  __I  uint32_t ISR0;                              /**< ACOMP0 Interrupt Status Register, offset: 0x18 */
  __I  uint32_t ISR1;                              /**< ACOMP1 Interrupt Status Register, offset: 0x1C */
  __IO uint32_t IMR0;                              /**< ACOMP0 Interrupt Mask Register, offset: 0x20 */
  __IO uint32_t IMR1;                              /**< ACOMP1 Interrupt Mask Register, offset: 0x24 */
  __I  uint32_t IRSR0;                             /**< ACOMP0 Interrupt Raw Status Register, offset: 0x28 */
  __I  uint32_t IRSR1;                             /**< ACOMP1 Interrupt Raw Status Register, offset: 0x2C */
  __IO uint32_t ICR0;                              /**< ACOMP0 Interrupt Clear Register, offset: 0x30 */
  __IO uint32_t ICR1;                              /**< ACOMP1 Interrupt Clear Register, offset: 0x34 */
  __IO uint32_t RST0;                              /**< ACOMP0 Soft Reset Register, offset: 0x38 */
  __IO uint32_t RST1;                              /**< ACOMP1 Soft Reset Register, offset: 0x3C */
       uint8_t RESERVED_0[8];
  __IO uint32_t CLK;                               /**< Clock Register, offset: 0x48 */
} ACOMP_Type;

/* ----------------------------------------------------------------------------
   -- ACOMP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ACOMP_Register_Masks ACOMP Register Masks
 * @{
 */

/*! @name CTRL0 - ACOMP0 Control Register */
/*! @{ */

#define ACOMP_CTRL0_EN_MASK                      (0x1U)
#define ACOMP_CTRL0_EN_SHIFT                     (0U)
/*! EN - ACOMP0 enable
 *  0b0..
 *  0b1..
 */
#define ACOMP_CTRL0_EN(x)                        (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_EN_SHIFT)) & ACOMP_CTRL0_EN_MASK)

#define ACOMP_CTRL0_GPIOINV_MASK                 (0x2U)
#define ACOMP_CTRL0_GPIOINV_SHIFT                (1U)
/*! GPIOINV - Enable/Disable inversion of ACOMP0 output to GPIO.
 *  0b0..do not invert ACOMP0 output
 *  0b1..invert ACOMP0 output
 */
#define ACOMP_CTRL0_GPIOINV(x)                   (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_GPIOINV_SHIFT)) & ACOMP_CTRL0_GPIOINV_MASK)

#define ACOMP_CTRL0_WARMTIME_MASK                (0xCU)
#define ACOMP_CTRL0_WARMTIME_SHIFT               (2U)
/*! WARMTIME - Set ACOMP0 Warm-Up time
 *  0b00..1 us
 *  0b01..2 us
 *  0b10..4 us
 *  0b11..8 us
 */
#define ACOMP_CTRL0_WARMTIME(x)                  (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_WARMTIME_SHIFT)) & ACOMP_CTRL0_WARMTIME_MASK)

#define ACOMP_CTRL0_HYST_SELN_MASK               (0x70U)
#define ACOMP_CTRL0_HYST_SELN_SHIFT              (4U)
/*! HYST_SELN - Select ACOMP0 negative hysteresis voltage level.
 *  0b000..no hysteresis
 *  0b001..-10 mV hysteresis
 *  0b010..-20 mV hysteresis
 *  0b011..-30 mV hysteresis
 *  0b100..-40 mV hysteresis
 *  0b101..-50 mV hysteresis
 *  0b110..-60 mV hysteresis
 *  0b111..-70 mV hysteresis
 */
#define ACOMP_CTRL0_HYST_SELN(x)                 (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_HYST_SELN_SHIFT)) & ACOMP_CTRL0_HYST_SELN_MASK)

#define ACOMP_CTRL0_HYST_SELP_MASK               (0x380U)
#define ACOMP_CTRL0_HYST_SELP_SHIFT              (7U)
/*! HYST_SELP - Select ACOMP0 positive hysteresis voltage level.
 *  0b000..No hysteresis
 *  0b001..+10 mV hysteresis
 *  0b010..+20 mV hysteresis
 *  0b011..+30 mV hysteresis
 *  0b100..+40 mV hysteresis
 *  0b101..+50 mV hysteresis
 *  0b110..+60 mV hysteresis
 *  0b111..+70 mV hysteresis
 */
#define ACOMP_CTRL0_HYST_SELP(x)                 (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_HYST_SELP_SHIFT)) & ACOMP_CTRL0_HYST_SELP_MASK)

#define ACOMP_CTRL0_BIAS_PROG_MASK               (0xC00U)
#define ACOMP_CTRL0_BIAS_PROG_SHIFT              (10U)
/*! BIAS_PROG - ACOMP0 bias current control bits or response time control bits.
 *  0b00..power mode1 (fast response mode)
 *  0b01..power mode2 (medium response mode)
 *  0b10..power mode3 (slow response mode)
 *  0b11..Reserved
 */
#define ACOMP_CTRL0_BIAS_PROG(x)                 (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_BIAS_PROG_SHIFT)) & ACOMP_CTRL0_BIAS_PROG_MASK)

#define ACOMP_CTRL0_LEVEL_SEL_MASK               (0x3F000U)
#define ACOMP_CTRL0_LEVEL_SEL_SHIFT              (12U)
/*! LEVEL_SEL - Scaling factor select bits for VIO reference level.
 *  0b000000..Scaling factor=0.25
 *  0b010000..Scaling factor= 0.5
 *  0b100000..Scaling factor= 0.75
 *  0b110000..Scaling factor= 1
 */
#define ACOMP_CTRL0_LEVEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_LEVEL_SEL_SHIFT)) & ACOMP_CTRL0_LEVEL_SEL_MASK)

#define ACOMP_CTRL0_NEG_SEL_MASK                 (0x3C0000U)
#define ACOMP_CTRL0_NEG_SEL_SHIFT                (18U)
/*! NEG_SEL - ACOMP0 negative input select bits.
 *  0b0000..acomp_ch<0>
 *  0b0001..acomp_ch<1>
 *  0b0010..acomp_ch<2>
 *  0b0011..acomp_ch<3>
 *  0b0100..acomp_ch<4>
 *  0b0101..acomp_ch<5>
 *  0b0110..acomp_ch<6>
 *  0b0111..acomp_ch<7>
 *  0b1000..
 *  0b1001..
 *  0b1010..
 *  0b1011..
 *  0b1100..vio*scaling factor
 *  0b1101..vio*scaling factor
 *  0b1110..vio*scaling factor
 *  0b1111..vio*scaling factor
 */
#define ACOMP_CTRL0_NEG_SEL(x)                   (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_NEG_SEL_SHIFT)) & ACOMP_CTRL0_NEG_SEL_MASK)

#define ACOMP_CTRL0_POS_SEL_MASK                 (0x3C00000U)
#define ACOMP_CTRL0_POS_SEL_SHIFT                (22U)
/*! POS_SEL - ACOMP0 positive input select bits.
 *  0b0000..acomp_ch<0>
 *  0b0001..acomp_ch<1>
 *  0b0010..acomp_ch<2>
 *  0b0011..acomp_ch<3>
 *  0b0100..acomp_ch<4>
 *  0b0101..acomp_ch<5>
 *  0b0110..acomp_ch<6>
 *  0b0111..acomp_ch<7>
 *  0b1000..
 *  0b1001..
 */
#define ACOMP_CTRL0_POS_SEL(x)                   (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_POS_SEL_SHIFT)) & ACOMP_CTRL0_POS_SEL_MASK)

#define ACOMP_CTRL0_MUXEN_MASK                   (0x4000000U)
#define ACOMP_CTRL0_MUXEN_SHIFT                  (26U)
/*! MUXEN - ACOMP0 input MUX enable bit.
 *  0b0..disable input mux
 *  0b1..enable input mux
 */
#define ACOMP_CTRL0_MUXEN(x)                     (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_MUXEN_SHIFT)) & ACOMP_CTRL0_MUXEN_MASK)

#define ACOMP_CTRL0_INACT_VAL_MASK               (0x8000000U)
#define ACOMP_CTRL0_INACT_VAL_SHIFT              (27U)
/*! INACT_VAL - Set output value when ACOMP0 is inactive.
 *  0b0..output 0 when ACOMP0 is inactive
 *  0b1..output 1 when ACOMP0 is inactive
 */
#define ACOMP_CTRL0_INACT_VAL(x)                 (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_INACT_VAL_SHIFT)) & ACOMP_CTRL0_INACT_VAL_MASK)

#define ACOMP_CTRL0_RIE_MASK                     (0x10000000U)
#define ACOMP_CTRL0_RIE_SHIFT                    (28U)
/*! RIE - ACOMP0 enable/disable rising edge triggered edge pulse.
 *  0b0..
 *  0b1..
 */
#define ACOMP_CTRL0_RIE(x)                       (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_RIE_SHIFT)) & ACOMP_CTRL0_RIE_MASK)

#define ACOMP_CTRL0_FIE_MASK                     (0x20000000U)
#define ACOMP_CTRL0_FIE_SHIFT                    (29U)
/*! FIE - ACOMP0 enable/disable falling edge triggered edge pulse.
 *  0b0..
 *  0b1..
 */
#define ACOMP_CTRL0_FIE(x)                       (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_FIE_SHIFT)) & ACOMP_CTRL0_FIE_MASK)

#define ACOMP_CTRL0_INT_ACT_HI_MASK              (0x40000000U)
#define ACOMP_CTRL0_INT_ACT_HI_SHIFT             (30U)
/*! INT_ACT_HI - ACOMP0 interrupt active mode select.
 *  0b0..Low level or falling edge triggered interrupt
 *  0b1..High level or rising edge triggered interrupt
 */
#define ACOMP_CTRL0_INT_ACT_HI(x)                (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_INT_ACT_HI_SHIFT)) & ACOMP_CTRL0_INT_ACT_HI_MASK)

#define ACOMP_CTRL0_EDGE_LEVL_SEL_MASK           (0x80000000U)
#define ACOMP_CTRL0_EDGE_LEVL_SEL_SHIFT          (31U)
/*! EDGE_LEVL_SEL - ACOMP0 interrupt type select.
 *  0b0..level triggered interrupt
 *  0b1..edge triggered interrupt
 */
#define ACOMP_CTRL0_EDGE_LEVL_SEL(x)             (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL0_EDGE_LEVL_SEL_SHIFT)) & ACOMP_CTRL0_EDGE_LEVL_SEL_MASK)
/*! @} */

/*! @name CTRL1 - ACOMP1 Control Register */
/*! @{ */

#define ACOMP_CTRL1_EN_MASK                      (0x1U)
#define ACOMP_CTRL1_EN_SHIFT                     (0U)
/*! EN - ACOMP1 enable bit.
 *  0b0..
 *  0b1..
 */
#define ACOMP_CTRL1_EN(x)                        (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_EN_SHIFT)) & ACOMP_CTRL1_EN_MASK)

#define ACOMP_CTRL1_GPIOINV_MASK                 (0x2U)
#define ACOMP_CTRL1_GPIOINV_SHIFT                (1U)
/*! GPIOINV - Enable/disable inversion of ACOMP1 output to GPIO.
 *  0b0..do not invert ACOMP1 output
 *  0b1..invert ACOMP1 output
 */
#define ACOMP_CTRL1_GPIOINV(x)                   (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_GPIOINV_SHIFT)) & ACOMP_CTRL1_GPIOINV_MASK)

#define ACOMP_CTRL1_WARMTIME_MASK                (0xCU)
#define ACOMP_CTRL1_WARMTIME_SHIFT               (2U)
/*! WARMTIME - Set ACOMP1 warm-up time.
 *  0b00..1 us
 *  0b01..2 us
 *  0b10..4 us
 *  0b11..8 us
 */
#define ACOMP_CTRL1_WARMTIME(x)                  (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_WARMTIME_SHIFT)) & ACOMP_CTRL1_WARMTIME_MASK)

#define ACOMP_CTRL1_HYST_SELN_MASK               (0x70U)
#define ACOMP_CTRL1_HYST_SELN_SHIFT              (4U)
/*! HYST_SELN - Select ACOMP1 negative hysteresis voltage level.
 *  0b000..No hysteresis
 *  0b001..-10 mV hysteresis
 *  0b010..-20 mV hysteresis
 *  0b011..-30 mV hysteresis
 *  0b100..-40 mV hysteresis
 *  0b101..-50 mV hysteresis
 *  0b110..-60 mV hysteresis
 *  0b111..-70 mV hysteresis
 */
#define ACOMP_CTRL1_HYST_SELN(x)                 (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_HYST_SELN_SHIFT)) & ACOMP_CTRL1_HYST_SELN_MASK)

#define ACOMP_CTRL1_HYST_SELP_MASK               (0x380U)
#define ACOMP_CTRL1_HYST_SELP_SHIFT              (7U)
/*! HYST_SELP - Select ACOMP1 positive hysteresis voltage level.
 *  0b000..No hysteresis
 *  0b001..+10 mV hysteresis
 *  0b010..+20 mV hysteresis
 *  0b011..+30 mV hysteresis
 *  0b100..+40 mV hysteresis
 *  0b101..+50 mV hysteresis
 *  0b110..+60 mV hysteresis
 *  0b111..+70 mV hysteresis
 */
#define ACOMP_CTRL1_HYST_SELP(x)                 (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_HYST_SELP_SHIFT)) & ACOMP_CTRL1_HYST_SELP_MASK)

#define ACOMP_CTRL1_BIAS_PROG_MASK               (0xC00U)
#define ACOMP_CTRL1_BIAS_PROG_SHIFT              (10U)
/*! BIAS_PROG - ACOMP1 bias current control bits Or response time control bits.
 *  0b00..power mode1 (fast response mode)
 *  0b01..power mode2 (Medium response mode)
 *  0b10..power mode3 (slow response mode)
 *  0b11..Reserved
 */
#define ACOMP_CTRL1_BIAS_PROG(x)                 (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_BIAS_PROG_SHIFT)) & ACOMP_CTRL1_BIAS_PROG_MASK)

#define ACOMP_CTRL1_LEVEL_SEL_MASK               (0x3F000U)
#define ACOMP_CTRL1_LEVEL_SEL_SHIFT              (12U)
/*! LEVEL_SEL - Scaling factor select bits for vio reference level.
 *  0b000000..Scaling factor=0.25
 *  0b010000..Scaling factor= 0.5
 *  0b100000..Scaling factor= 0.75
 *  0b110000..Scaling factor= 1
 */
#define ACOMP_CTRL1_LEVEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_LEVEL_SEL_SHIFT)) & ACOMP_CTRL1_LEVEL_SEL_MASK)

#define ACOMP_CTRL1_NEG_SEL_MASK                 (0x3C0000U)
#define ACOMP_CTRL1_NEG_SEL_SHIFT                (18U)
/*! NEG_SEL - ACOMP1 negative input select
 *  0b0000..acomp_ch<0>
 *  0b0001..acomp_ch<1>
 *  0b0010..acomp_ch<2>
 *  0b0011..acomp_ch<3>
 *  0b0100..acomp_ch<4>
 *  0b0101..acomp_ch<5>
 *  0b0110..acomp_ch<6>
 *  0b0111..acomp_ch<7>
 *  0b1000..
 *  0b1001..
 *  0b1010..
 *  0b1011..
 *  0b1100..vio*scaling factor
 *  0b1101..vio*scaling factor
 *  0b1110..vio*scaling factor
 *  0b1111..vio*scaling factor
 */
#define ACOMP_CTRL1_NEG_SEL(x)                   (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_NEG_SEL_SHIFT)) & ACOMP_CTRL1_NEG_SEL_MASK)

#define ACOMP_CTRL1_POS_SEL_MASK                 (0x3C00000U)
#define ACOMP_CTRL1_POS_SEL_SHIFT                (22U)
/*! POS_SEL - ACOMP1 positive input select
 *  0b0000..acomp_ch<0>
 *  0b0001..acomp_ch<1>
 *  0b0010..acomp_ch<2>
 *  0b0011..acomp_ch<3>
 *  0b0100..acomp_ch<4>
 *  0b0101..acomp_ch<5>
 *  0b0110..acomp_ch<6>
 *  0b0111..acomp_ch<7>
 *  0b1000..
 *  0b1001..
 */
#define ACOMP_CTRL1_POS_SEL(x)                   (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_POS_SEL_SHIFT)) & ACOMP_CTRL1_POS_SEL_MASK)

#define ACOMP_CTRL1_MUXEN_MASK                   (0x4000000U)
#define ACOMP_CTRL1_MUXEN_SHIFT                  (26U)
/*! MUXEN - ACOMP1 input MUX enable
 *  0b0..disable input mux
 *  0b1..enable input mux
 */
#define ACOMP_CTRL1_MUXEN(x)                     (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_MUXEN_SHIFT)) & ACOMP_CTRL1_MUXEN_MASK)

#define ACOMP_CTRL1_INACT_VAL_MASK               (0x8000000U)
#define ACOMP_CTRL1_INACT_VAL_SHIFT              (27U)
/*! INACT_VAL - Set output value when ACOMP1 is inactive.
 *  0b0..output 0 when ACOMP1 is inactive
 *  0b1..output 1 when ACOMP1 is inactive
 */
#define ACOMP_CTRL1_INACT_VAL(x)                 (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_INACT_VAL_SHIFT)) & ACOMP_CTRL1_INACT_VAL_MASK)

#define ACOMP_CTRL1_RIE_MASK                     (0x10000000U)
#define ACOMP_CTRL1_RIE_SHIFT                    (28U)
/*! RIE - ACOMP1 enable/disable rising edge triggered edge pulse.
 *  0b0..
 *  0b1..
 */
#define ACOMP_CTRL1_RIE(x)                       (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_RIE_SHIFT)) & ACOMP_CTRL1_RIE_MASK)

#define ACOMP_CTRL1_FIE_MASK                     (0x20000000U)
#define ACOMP_CTRL1_FIE_SHIFT                    (29U)
/*! FIE - ACOMP1 enable/disable falling edge triggered edge pulse.
 *  0b0..
 *  0b1..
 */
#define ACOMP_CTRL1_FIE(x)                       (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_FIE_SHIFT)) & ACOMP_CTRL1_FIE_MASK)

#define ACOMP_CTRL1_INT_ACT_HI_MASK              (0x40000000U)
#define ACOMP_CTRL1_INT_ACT_HI_SHIFT             (30U)
/*! INT_ACT_HI - ACOMP1 interrupt active mode select.
 *  0b0..Low level or falling edge triggered interrupt
 *  0b1..High level or rising edge triggered interrupt
 */
#define ACOMP_CTRL1_INT_ACT_HI(x)                (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_INT_ACT_HI_SHIFT)) & ACOMP_CTRL1_INT_ACT_HI_MASK)

#define ACOMP_CTRL1_EDGE_LEVL_SEL_MASK           (0x80000000U)
#define ACOMP_CTRL1_EDGE_LEVL_SEL_SHIFT          (31U)
/*! EDGE_LEVL_SEL - ACOMP1 interrupt type select.
 *  0b0..level triggered interrupt
 *  0b1..edge triggered interrupt
 */
#define ACOMP_CTRL1_EDGE_LEVL_SEL(x)             (((uint32_t)(((uint32_t)(x)) << ACOMP_CTRL1_EDGE_LEVL_SEL_SHIFT)) & ACOMP_CTRL1_EDGE_LEVL_SEL_MASK)
/*! @} */

/*! @name STATUS0 - ACOMP0 Status Register */
/*! @{ */

#define ACOMP_STATUS0_ACT_MASK                   (0x1U)
#define ACOMP_STATUS0_ACT_SHIFT                  (0U)
/*! ACT - ACOMP0 active status.
 *  0b0..ACOMP0 is inactive
 *  0b1..ACOMP0 is active
 */
#define ACOMP_STATUS0_ACT(x)                     (((uint32_t)(((uint32_t)(x)) << ACOMP_STATUS0_ACT_SHIFT)) & ACOMP_STATUS0_ACT_MASK)

#define ACOMP_STATUS0_OUT_MASK                   (0x2U)
#define ACOMP_STATUS0_OUT_SHIFT                  (1U)
/*! OUT - ACOMP0 comparison output value. */
#define ACOMP_STATUS0_OUT(x)                     (((uint32_t)(((uint32_t)(x)) << ACOMP_STATUS0_OUT_SHIFT)) & ACOMP_STATUS0_OUT_MASK)
/*! @} */

/*! @name STATUS1 - ACOMP1 Status Register */
/*! @{ */

#define ACOMP_STATUS1_ACT_MASK                   (0x1U)
#define ACOMP_STATUS1_ACT_SHIFT                  (0U)
/*! ACT - ACOMP1 active status.
 *  0b0..ACOMP1 is inactive
 *  0b1..ACOMP1 is active
 */
#define ACOMP_STATUS1_ACT(x)                     (((uint32_t)(((uint32_t)(x)) << ACOMP_STATUS1_ACT_SHIFT)) & ACOMP_STATUS1_ACT_MASK)

#define ACOMP_STATUS1_OUT_MASK                   (0x2U)
#define ACOMP_STATUS1_OUT_SHIFT                  (1U)
/*! OUT - ACOMP1 comparison output value. */
#define ACOMP_STATUS1_OUT(x)                     (((uint32_t)(((uint32_t)(x)) << ACOMP_STATUS1_OUT_SHIFT)) & ACOMP_STATUS1_OUT_MASK)
/*! @} */

/*! @name ROUTE0 - ACOMP0 Route Register */
/*! @{ */

#define ACOMP_ROUTE0_OUTSEL_MASK                 (0x1U)
#define ACOMP_ROUTE0_OUTSEL_SHIFT                (0U)
/*! OUTSEL - Select ACOMP0 synchronous or asynchronous output to pin.
 *  0b0..Synchronous output
 *  0b1..Asynchronous output
 */
#define ACOMP_ROUTE0_OUTSEL(x)                   (((uint32_t)(((uint32_t)(x)) << ACOMP_ROUTE0_OUTSEL_SHIFT)) & ACOMP_ROUTE0_OUTSEL_MASK)

#define ACOMP_ROUTE0_PE_MASK                     (0x2U)
#define ACOMP_ROUTE0_PE_SHIFT                    (1U)
/*! PE - Enable/disable ACOMP0 output to pin.
 *  0b0..
 *  0b1..
 */
#define ACOMP_ROUTE0_PE(x)                       (((uint32_t)(((uint32_t)(x)) << ACOMP_ROUTE0_PE_SHIFT)) & ACOMP_ROUTE0_PE_MASK)
/*! @} */

/*! @name ROUTE1 - ACOMP1 Route Register */
/*! @{ */

#define ACOMP_ROUTE1_OUTSEL_MASK                 (0x1U)
#define ACOMP_ROUTE1_OUTSEL_SHIFT                (0U)
/*! OUTSEL - Select ACOMP1 synchronous or asynchronous output to pin
 *  0b0..Synchronous output
 *  0b1..Asynchronous output
 */
#define ACOMP_ROUTE1_OUTSEL(x)                   (((uint32_t)(((uint32_t)(x)) << ACOMP_ROUTE1_OUTSEL_SHIFT)) & ACOMP_ROUTE1_OUTSEL_MASK)

#define ACOMP_ROUTE1_PE_MASK                     (0x2U)
#define ACOMP_ROUTE1_PE_SHIFT                    (1U)
/*! PE - Enable/disable ACOMP1 output to pin
 *  0b0..
 *  0b1..
 */
#define ACOMP_ROUTE1_PE(x)                       (((uint32_t)(((uint32_t)(x)) << ACOMP_ROUTE1_PE_SHIFT)) & ACOMP_ROUTE1_PE_MASK)
/*! @} */

/*! @name ISR0 - ACOMP0 Interrupt Status Register */
/*! @{ */

#define ACOMP_ISR0_OUT_INT_MASK                  (0x1U)
#define ACOMP_ISR0_OUT_INT_SHIFT                 (0U)
/*! OUT_INT - ACOMP0 Synchronized Output Interrupt */
#define ACOMP_ISR0_OUT_INT(x)                    (((uint32_t)(((uint32_t)(x)) << ACOMP_ISR0_OUT_INT_SHIFT)) & ACOMP_ISR0_OUT_INT_MASK)

#define ACOMP_ISR0_OUTA_INT_MASK                 (0x2U)
#define ACOMP_ISR0_OUTA_INT_SHIFT                (1U)
/*! OUTA_INT - ACOMP0 Asynchronized Output Interrupt */
#define ACOMP_ISR0_OUTA_INT(x)                   (((uint32_t)(((uint32_t)(x)) << ACOMP_ISR0_OUTA_INT_SHIFT)) & ACOMP_ISR0_OUTA_INT_MASK)
/*! @} */

/*! @name ISR1 - ACOMP1 Interrupt Status Register */
/*! @{ */

#define ACOMP_ISR1_OUT_INT_MASK                  (0x1U)
#define ACOMP_ISR1_OUT_INT_SHIFT                 (0U)
/*! OUT_INT - ACOMP1 Synchronized Output Interrupt */
#define ACOMP_ISR1_OUT_INT(x)                    (((uint32_t)(((uint32_t)(x)) << ACOMP_ISR1_OUT_INT_SHIFT)) & ACOMP_ISR1_OUT_INT_MASK)

#define ACOMP_ISR1_OUTA_INT_MASK                 (0x2U)
#define ACOMP_ISR1_OUTA_INT_SHIFT                (1U)
/*! OUTA_INT - ACOMP1 Asynchronized Output Interrupt */
#define ACOMP_ISR1_OUTA_INT(x)                   (((uint32_t)(((uint32_t)(x)) << ACOMP_ISR1_OUTA_INT_SHIFT)) & ACOMP_ISR1_OUTA_INT_MASK)
/*! @} */

/*! @name IMR0 - ACOMP0 Interrupt Mask Register */
/*! @{ */

#define ACOMP_IMR0_OUT_INT_MASK_MASK             (0x1U)
#define ACOMP_IMR0_OUT_INT_MASK_SHIFT            (0U)
/*! OUT_INT_MASK - Mask Synchronized Interrupt */
#define ACOMP_IMR0_OUT_INT_MASK(x)               (((uint32_t)(((uint32_t)(x)) << ACOMP_IMR0_OUT_INT_MASK_SHIFT)) & ACOMP_IMR0_OUT_INT_MASK_MASK)

#define ACOMP_IMR0_OUTA_INT_MASK_MASK            (0x2U)
#define ACOMP_IMR0_OUTA_INT_MASK_SHIFT           (1U)
/*! OUTA_INT_MASK - Mask Asynchronized Interrupt */
#define ACOMP_IMR0_OUTA_INT_MASK(x)              (((uint32_t)(((uint32_t)(x)) << ACOMP_IMR0_OUTA_INT_MASK_SHIFT)) & ACOMP_IMR0_OUTA_INT_MASK_MASK)
/*! @} */

/*! @name IMR1 - ACOMP1 Interrupt Mask Register */
/*! @{ */

#define ACOMP_IMR1_OUT_INT_MASK_MASK             (0x1U)
#define ACOMP_IMR1_OUT_INT_MASK_SHIFT            (0U)
/*! OUT_INT_MASK - Mask Synchronized Interrupt */
#define ACOMP_IMR1_OUT_INT_MASK(x)               (((uint32_t)(((uint32_t)(x)) << ACOMP_IMR1_OUT_INT_MASK_SHIFT)) & ACOMP_IMR1_OUT_INT_MASK_MASK)

#define ACOMP_IMR1_OUTA_INT_MASK_MASK            (0x2U)
#define ACOMP_IMR1_OUTA_INT_MASK_SHIFT           (1U)
/*! OUTA_INT_MASK - Mask Asynchronized Interrupt */
#define ACOMP_IMR1_OUTA_INT_MASK(x)              (((uint32_t)(((uint32_t)(x)) << ACOMP_IMR1_OUTA_INT_MASK_SHIFT)) & ACOMP_IMR1_OUTA_INT_MASK_MASK)
/*! @} */

/*! @name IRSR0 - ACOMP0 Interrupt Raw Status Register */
/*! @{ */

#define ACOMP_IRSR0_OUT_INT_RAW_MASK             (0x1U)
#define ACOMP_IRSR0_OUT_INT_RAW_SHIFT            (0U)
/*! OUT_INT_RAW - Raw Mask Synchronized Interrupt */
#define ACOMP_IRSR0_OUT_INT_RAW(x)               (((uint32_t)(((uint32_t)(x)) << ACOMP_IRSR0_OUT_INT_RAW_SHIFT)) & ACOMP_IRSR0_OUT_INT_RAW_MASK)

#define ACOMP_IRSR0_OUTA_INT_RAW_MASK            (0x2U)
#define ACOMP_IRSR0_OUTA_INT_RAW_SHIFT           (1U)
/*! OUTA_INT_RAW - Raw Mask Asynchronized Interrupt */
#define ACOMP_IRSR0_OUTA_INT_RAW(x)              (((uint32_t)(((uint32_t)(x)) << ACOMP_IRSR0_OUTA_INT_RAW_SHIFT)) & ACOMP_IRSR0_OUTA_INT_RAW_MASK)
/*! @} */

/*! @name IRSR1 - ACOMP1 Interrupt Raw Status Register */
/*! @{ */

#define ACOMP_IRSR1_OUT_INT_RAW_MASK             (0x1U)
#define ACOMP_IRSR1_OUT_INT_RAW_SHIFT            (0U)
/*! OUT_INT_RAW - Raw Mask Synchronized Interrupt */
#define ACOMP_IRSR1_OUT_INT_RAW(x)               (((uint32_t)(((uint32_t)(x)) << ACOMP_IRSR1_OUT_INT_RAW_SHIFT)) & ACOMP_IRSR1_OUT_INT_RAW_MASK)

#define ACOMP_IRSR1_OUTA_INT_RAW_MASK            (0x2U)
#define ACOMP_IRSR1_OUTA_INT_RAW_SHIFT           (1U)
/*! OUTA_INT_RAW - Raw Mask Asynchronized Interrupt */
#define ACOMP_IRSR1_OUTA_INT_RAW(x)              (((uint32_t)(((uint32_t)(x)) << ACOMP_IRSR1_OUTA_INT_RAW_SHIFT)) & ACOMP_IRSR1_OUTA_INT_RAW_MASK)
/*! @} */

/*! @name ICR0 - ACOMP0 Interrupt Clear Register */
/*! @{ */

#define ACOMP_ICR0_OUT_INT_CLR_MASK              (0x1U)
#define ACOMP_ICR0_OUT_INT_CLR_SHIFT             (0U)
/*! OUT_INT_CLR - ACOMP0 syncrhonized output interrupt flag clear signal. */
#define ACOMP_ICR0_OUT_INT_CLR(x)                (((uint32_t)(((uint32_t)(x)) << ACOMP_ICR0_OUT_INT_CLR_SHIFT)) & ACOMP_ICR0_OUT_INT_CLR_MASK)

#define ACOMP_ICR0_OUTA_INT_CLR_MASK             (0x2U)
#define ACOMP_ICR0_OUTA_INT_CLR_SHIFT            (1U)
/*! OUTA_INT_CLR - ACOMP0 asyncrhonized output interrupt flag clear signal. */
#define ACOMP_ICR0_OUTA_INT_CLR(x)               (((uint32_t)(((uint32_t)(x)) << ACOMP_ICR0_OUTA_INT_CLR_SHIFT)) & ACOMP_ICR0_OUTA_INT_CLR_MASK)
/*! @} */

/*! @name ICR1 - ACOMP1 Interrupt Clear Register */
/*! @{ */

#define ACOMP_ICR1_OUT_INT_CLR_MASK              (0x1U)
#define ACOMP_ICR1_OUT_INT_CLR_SHIFT             (0U)
/*! OUT_INT_CLR - ACOMP1 syncrhonized output interrupt flag clear signal. */
#define ACOMP_ICR1_OUT_INT_CLR(x)                (((uint32_t)(((uint32_t)(x)) << ACOMP_ICR1_OUT_INT_CLR_SHIFT)) & ACOMP_ICR1_OUT_INT_CLR_MASK)

#define ACOMP_ICR1_OUTA_INT_CLR_MASK             (0x2U)
#define ACOMP_ICR1_OUTA_INT_CLR_SHIFT            (1U)
/*! OUTA_INT_CLR - ACOMP1 asyncrhonized output interrupt flag clear signal. */
#define ACOMP_ICR1_OUTA_INT_CLR(x)               (((uint32_t)(((uint32_t)(x)) << ACOMP_ICR1_OUTA_INT_CLR_SHIFT)) & ACOMP_ICR1_OUTA_INT_CLR_MASK)
/*! @} */

/*! @name RST0 - ACOMP0 Soft Reset Register */
/*! @{ */

#define ACOMP_RST0_SOFT_RST_MASK                 (0x1U)
#define ACOMP_RST0_SOFT_RST_SHIFT                (0U)
/*! SOFT_RST - Soft Reset for ACOMP0 (active high)
 *  0b0..no action
 *  0b1..
 */
#define ACOMP_RST0_SOFT_RST(x)                   (((uint32_t)(((uint32_t)(x)) << ACOMP_RST0_SOFT_RST_SHIFT)) & ACOMP_RST0_SOFT_RST_MASK)
/*! @} */

/*! @name RST1 - ACOMP1 Soft Reset Register */
/*! @{ */

#define ACOMP_RST1_SOFT_RST_MASK                 (0x1U)
#define ACOMP_RST1_SOFT_RST_SHIFT                (0U)
/*! SOFT_RST - Soft Reset for ACOMP1 (active high)
 *  0b0..no action
 *  0b1..
 */
#define ACOMP_RST1_SOFT_RST(x)                   (((uint32_t)(((uint32_t)(x)) << ACOMP_RST1_SOFT_RST_SHIFT)) & ACOMP_RST1_SOFT_RST_MASK)
/*! @} */

/*! @name CLK - Clock Register */
/*! @{ */

#define ACOMP_CLK_SOFT_CLK_RST_MASK              (0x2U)
#define ACOMP_CLK_SOFT_CLK_RST_SHIFT             (1U)
/*! SOFT_CLK_RST - soft reset for clock divider
 *  0b0..no action
 *  0b1..
 */
#define ACOMP_CLK_SOFT_CLK_RST(x)                (((uint32_t)(((uint32_t)(x)) << ACOMP_CLK_SOFT_CLK_RST_SHIFT)) & ACOMP_CLK_SOFT_CLK_RST_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ACOMP_Register_Masks */


/* ACOMP - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral GAU_ACOMP base address */
  #define GAU_ACOMP_BASE                           (0x50038400u)
  /** Peripheral GAU_ACOMP base address */
  #define GAU_ACOMP_BASE_NS                        (0x40038400u)
  /** Peripheral GAU_ACOMP base pointer */
  #define GAU_ACOMP                                ((ACOMP_Type *)GAU_ACOMP_BASE)
  /** Peripheral GAU_ACOMP base pointer */
  #define GAU_ACOMP_NS                             ((ACOMP_Type *)GAU_ACOMP_BASE_NS)
  /** Array initializer of ACOMP peripheral base addresses */
  #define ACOMP_BASE_ADDRS                         { GAU_ACOMP_BASE }
  /** Array initializer of ACOMP peripheral base pointers */
  #define ACOMP_BASE_PTRS                          { GAU_ACOMP }
  /** Array initializer of ACOMP peripheral base addresses */
  #define ACOMP_BASE_ADDRS_NS                      { GAU_ACOMP_BASE_NS }
  /** Array initializer of ACOMP peripheral base pointers */
  #define ACOMP_BASE_PTRS_NS                       { GAU_ACOMP_NS }
#else
  /** Peripheral GAU_ACOMP base address */
  #define GAU_ACOMP_BASE                           (0x40038400u)
  /** Peripheral GAU_ACOMP base pointer */
  #define GAU_ACOMP                                ((ACOMP_Type *)GAU_ACOMP_BASE)
  /** Array initializer of ACOMP peripheral base addresses */
  #define ACOMP_BASE_ADDRS                         { GAU_ACOMP_BASE }
  /** Array initializer of ACOMP peripheral base pointers */
  #define ACOMP_BASE_PTRS                          { GAU_ACOMP }
#endif
/** Interrupt vectors for the ACOMP peripheral type */
#define ACOMP_FUNC_IRQS                          { GAU_ACOMP_IRQn }
#define ACOMP_WAKE_IRQS                          { GAU_ACOMP_WKUP_IRQn }

/*!
 * @}
 */ /* end of group ACOMP_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __IO uint32_t ADC_REG_CMD;                       /**< ADC Command Register, offset: 0x0 */
  __IO uint32_t ADC_REG_GENERAL;                   /**< ADC General Register, offset: 0x4 */
  __IO uint32_t ADC_REG_CONFIG;                    /**< ADC Configuration Register, offset: 0x8 */
  __IO uint32_t ADC_REG_INTERVAL;                  /**< ADC Interval Register, offset: 0xC */
  __IO uint32_t ADC_REG_ANA;                       /**< ADC ANA Register, offset: 0x10 */
       uint8_t RESERVED_0[4];
  __IO uint32_t ADC_REG_SCN1;                      /**< ADC Conversion Sequence 1 Register, offset: 0x18 */
  __IO uint32_t ADC_REG_SCN2;                      /**< ADC Conversion Sequence 2 Register, offset: 0x1C */
  __IO uint32_t ADC_REG_RESULT_BUF;                /**< ADC Result Buffer Register, offset: 0x20 */
       uint8_t RESERVED_1[4];
  __IO uint32_t ADC_REG_DMAR;                      /**< ADC DMAR Register, offset: 0x28 */
  __I  uint32_t ADC_REG_STATUS;                    /**< ADC Status Register, offset: 0x2C */
  __I  uint32_t ADC_REG_ISR;                       /**< ADC ISR Register, offset: 0x30 */
  __IO uint32_t ADC_REG_IMR;                       /**< ADC IMR Register, offset: 0x34 */
  __I  uint32_t ADC_REG_IRSR;                      /**< ADC IRSR Register, offset: 0x38 */
  __IO uint32_t ADC_REG_ICR;                       /**< ADC ICR Register, offset: 0x3C */
       uint8_t RESERVED_2[4];
  __I  uint32_t ADC_REG_RESULT;                    /**< ADC Result Register, offset: 0x44 */
  __I  uint32_t ADC_REG_RAW_RESULT;                /**< ADC Raw Result Register, offset: 0x48 */
  __IO uint32_t ADC_REG_OFFSET_CAL;                /**< ADC Offset Calibration Register, offset: 0x4C */
  __IO uint32_t ADC_REG_GAIN_CAL;                  /**< ADC Gain Calibration Register, offset: 0x50 */
  __IO uint32_t ADC_REG_TEST;                      /**< ADC Test Register, offset: 0x54 */
  __IO uint32_t ADC_REG_AUDIO;                     /**< ADC Audio Register, offset: 0x58 */
  __IO uint32_t ADC_REG_VOICE_DET;                 /**< ADC Voice Detect Register, offset: 0x5C */
  __IO uint32_t ADC_REG_RSVD;                      /**< ADC Reserved Register, offset: 0x60 */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name ADC_REG_CMD - ADC Command Register */
/*! @{ */

#define ADC_ADC_REG_CMD_CONV_START_MASK          (0x1U)
#define ADC_ADC_REG_CMD_CONV_START_SHIFT         (0U)
/*! CONV_START - converaion control bit. */
#define ADC_ADC_REG_CMD_CONV_START(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CMD_CONV_START_SHIFT)) & ADC_ADC_REG_CMD_CONV_START_MASK)

#define ADC_ADC_REG_CMD_SOFT_RST_MASK            (0x2U)
#define ADC_ADC_REG_CMD_SOFT_RST_SHIFT           (1U)
/*! SOFT_RST - user reset the whole block */
#define ADC_ADC_REG_CMD_SOFT_RST(x)              (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CMD_SOFT_RST_SHIFT)) & ADC_ADC_REG_CMD_SOFT_RST_MASK)

#define ADC_ADC_REG_CMD_SOFT_CLK_RST_MASK        (0x4U)
#define ADC_ADC_REG_CMD_SOFT_CLK_RST_SHIFT       (2U)
/*! SOFT_CLK_RST - user reset clock */
#define ADC_ADC_REG_CMD_SOFT_CLK_RST(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CMD_SOFT_CLK_RST_SHIFT)) & ADC_ADC_REG_CMD_SOFT_CLK_RST_MASK)
/*! @} */

/*! @name ADC_REG_GENERAL - ADC General Register */
/*! @{ */

#define ADC_ADC_REG_GENERAL_GPADC_MASTER_MASK    (0x1U)
#define ADC_ADC_REG_GENERAL_GPADC_MASTER_SHIFT   (0U)
/*! GPADC_MASTER - play as master or slave in dual mode, master is the only controller of when slave start */
#define ADC_ADC_REG_GENERAL_GPADC_MASTER(x)      (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_GENERAL_GPADC_MASTER_SHIFT)) & ADC_ADC_REG_GENERAL_GPADC_MASTER_MASK)

#define ADC_ADC_REG_GENERAL_GLOBAL_EN_MASK       (0x2U)
#define ADC_ADC_REG_GENERAL_GLOBAL_EN_SHIFT      (1U)
/*! GLOBAL_EN - ADC enable/disable */
#define ADC_ADC_REG_GENERAL_GLOBAL_EN(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_GENERAL_GLOBAL_EN_SHIFT)) & ADC_ADC_REG_GENERAL_GLOBAL_EN_MASK)

#define ADC_ADC_REG_GENERAL_FORCE_CLK_ON_MASK    (0x4U)
#define ADC_ADC_REG_GENERAL_FORCE_CLK_ON_SHIFT   (2U)
/*! FORCE_CLK_ON - override the gpadc_mclk_en from outside */
#define ADC_ADC_REG_GENERAL_FORCE_CLK_ON(x)      (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_GENERAL_FORCE_CLK_ON_SHIFT)) & ADC_ADC_REG_GENERAL_FORCE_CLK_ON_MASK)

#define ADC_ADC_REG_GENERAL_CLK_ANA64M_INV_MASK  (0x8U)
#define ADC_ADC_REG_GENERAL_CLK_ANA64M_INV_SHIFT (3U)
/*! CLK_ANA64M_INV - analog clock 64M inverted */
#define ADC_ADC_REG_GENERAL_CLK_ANA64M_INV(x)    (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_GENERAL_CLK_ANA64M_INV_SHIFT)) & ADC_ADC_REG_GENERAL_CLK_ANA64M_INV_MASK)

#define ADC_ADC_REG_GENERAL_CLK_ANA2M_INV_MASK   (0x10U)
#define ADC_ADC_REG_GENERAL_CLK_ANA2M_INV_SHIFT  (4U)
/*! CLK_ANA2M_INV - analog clock 2M inverted */
#define ADC_ADC_REG_GENERAL_CLK_ANA2M_INV(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_GENERAL_CLK_ANA2M_INV_SHIFT)) & ADC_ADC_REG_GENERAL_CLK_ANA2M_INV_MASK)

#define ADC_ADC_REG_GENERAL_ADC_CAL_EN_MASK      (0x20U)
#define ADC_ADC_REG_GENERAL_ADC_CAL_EN_SHIFT     (5U)
/*! ADC_CAL_EN - calibration enable, auto cleared after calibration done */
#define ADC_ADC_REG_GENERAL_ADC_CAL_EN(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_GENERAL_ADC_CAL_EN_SHIFT)) & ADC_ADC_REG_GENERAL_ADC_CAL_EN_MASK)

#define ADC_ADC_REG_GENERAL_CLK_DIV_RATIO_MASK   (0x3F00U)
#define ADC_ADC_REG_GENERAL_CLK_DIV_RATIO_SHIFT  (8U)
/*! CLK_DIV_RATIO - analog 64M clock division ratio */
#define ADC_ADC_REG_GENERAL_CLK_DIV_RATIO(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_GENERAL_CLK_DIV_RATIO_SHIFT)) & ADC_ADC_REG_GENERAL_CLK_DIV_RATIO_MASK)
/*! @} */

/*! @name ADC_REG_CONFIG - ADC Configuration Register */
/*! @{ */

#define ADC_ADC_REG_CONFIG_TRIGGER_SEL_MASK      (0xFU)
#define ADC_ADC_REG_CONFIG_TRIGGER_SEL_SHIFT     (0U)
/*! TRIGGER_SEL - External trigger source select bits
 *  0b0000..ctimer3 match1 in ADC0 module, ctimer3 match2 in ADC1 module
 *  0b0001..acomparator 0 out in ADC0 module, acomparator 1 out in ADC1 module
 *  0b0010..GPIO50
 *  0b0011..GPIO55
 */
#define ADC_ADC_REG_CONFIG_TRIGGER_SEL(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CONFIG_TRIGGER_SEL_SHIFT)) & ADC_ADC_REG_CONFIG_TRIGGER_SEL_MASK)

#define ADC_ADC_REG_CONFIG_TRIGGER_EN_MASK       (0x10U)
#define ADC_ADC_REG_CONFIG_TRIGGER_EN_SHIFT      (4U)
/*! TRIGGER_EN - External elevel trigger enable bit, support gpadc_trigger/gpadc_data_valid handshake */
#define ADC_ADC_REG_CONFIG_TRIGGER_EN(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CONFIG_TRIGGER_EN_SHIFT)) & ADC_ADC_REG_CONFIG_TRIGGER_EN_MASK)

#define ADC_ADC_REG_CONFIG_DUAL_MODE_MASK        (0x20U)
#define ADC_ADC_REG_CONFIG_DUAL_MODE_SHIFT       (5U)
/*! DUAL_MODE - dual mode select */
#define ADC_ADC_REG_CONFIG_DUAL_MODE(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CONFIG_DUAL_MODE_SHIFT)) & ADC_ADC_REG_CONFIG_DUAL_MODE_MASK)

#define ADC_ADC_REG_CONFIG_SINGLE_DUAL_MASK      (0x40U)
#define ADC_ADC_REG_CONFIG_SINGLE_DUAL_SHIFT     (6U)
/*! SINGLE_DUAL - work mode select */
#define ADC_ADC_REG_CONFIG_SINGLE_DUAL(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CONFIG_SINGLE_DUAL_SHIFT)) & ADC_ADC_REG_CONFIG_SINGLE_DUAL_MASK)

#define ADC_ADC_REG_CONFIG_CONT_CONV_EN_MASK     (0x100U)
#define ADC_ADC_REG_CONFIG_CONT_CONV_EN_SHIFT    (8U)
/*! CONT_CONV_EN - To enable continuous conversion */
#define ADC_ADC_REG_CONFIG_CONT_CONV_EN(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CONFIG_CONT_CONV_EN_SHIFT)) & ADC_ADC_REG_CONFIG_CONT_CONV_EN_MASK)

#define ADC_ADC_REG_CONFIG_DATA_FORMAT_SEL_MASK  (0x200U)
#define ADC_ADC_REG_CONFIG_DATA_FORMAT_SEL_SHIFT (9U)
/*! DATA_FORMAT_SEL - set data format for the final data */
#define ADC_ADC_REG_CONFIG_DATA_FORMAT_SEL(x)    (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CONFIG_DATA_FORMAT_SEL_SHIFT)) & ADC_ADC_REG_CONFIG_DATA_FORMAT_SEL_MASK)

#define ADC_ADC_REG_CONFIG_CAL_VREF_SEL_MASK     (0x400U)
#define ADC_ADC_REG_CONFIG_CAL_VREF_SEL_SHIFT    (10U)
/*! CAL_VREF_SEL - select input reference channel for gain calibration */
#define ADC_ADC_REG_CONFIG_CAL_VREF_SEL(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CONFIG_CAL_VREF_SEL_SHIFT)) & ADC_ADC_REG_CONFIG_CAL_VREF_SEL_MASK)

#define ADC_ADC_REG_CONFIG_CAL_DATA_RST_MASK     (0x800U)
#define ADC_ADC_REG_CONFIG_CAL_DATA_RST_SHIFT    (11U)
/*! CAL_DATA_RST - reset the self calibration data. */
#define ADC_ADC_REG_CONFIG_CAL_DATA_RST(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CONFIG_CAL_DATA_RST_SHIFT)) & ADC_ADC_REG_CONFIG_CAL_DATA_RST_MASK)

#define ADC_ADC_REG_CONFIG_CAL_DATA_SEL_MASK     (0x1000U)
#define ADC_ADC_REG_CONFIG_CAL_DATA_SEL_SHIFT    (12U)
/*! CAL_DATA_SEL - select calibration data source. */
#define ADC_ADC_REG_CONFIG_CAL_DATA_SEL(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CONFIG_CAL_DATA_SEL_SHIFT)) & ADC_ADC_REG_CONFIG_CAL_DATA_SEL_MASK)

#define ADC_ADC_REG_CONFIG_AVG_SEL_MASK          (0xE000U)
#define ADC_ADC_REG_CONFIG_AVG_SEL_SHIFT         (13U)
/*! AVG_SEL - moving average length */
#define ADC_ADC_REG_CONFIG_AVG_SEL(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CONFIG_AVG_SEL_SHIFT)) & ADC_ADC_REG_CONFIG_AVG_SEL_MASK)

#define ADC_ADC_REG_CONFIG_SCAN_LENGTH_MASK      (0xF0000U)
#define ADC_ADC_REG_CONFIG_SCAN_LENGTH_SHIFT     (16U)
/*! SCAN_LENGTH - scan converation length, actual length is scan_length+1. */
#define ADC_ADC_REG_CONFIG_SCAN_LENGTH(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CONFIG_SCAN_LENGTH_SHIFT)) & ADC_ADC_REG_CONFIG_SCAN_LENGTH_MASK)

#define ADC_ADC_REG_CONFIG_PWR_MODE_MASK         (0x100000U)
#define ADC_ADC_REG_CONFIG_PWR_MODE_SHIFT        (20U)
/*! PWR_MODE - ADC power mode select. */
#define ADC_ADC_REG_CONFIG_PWR_MODE(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_CONFIG_PWR_MODE_SHIFT)) & ADC_ADC_REG_CONFIG_PWR_MODE_MASK)
/*! @} */

/*! @name ADC_REG_INTERVAL - ADC Interval Register */
/*! @{ */

#define ADC_ADC_REG_INTERVAL_WARMUP_TIME_MASK    (0x1FU)
#define ADC_ADC_REG_INTERVAL_WARMUP_TIME_SHIFT   (0U)
/*! WARMUP_TIME - warmup time, should be set equal to or higher than 1uS. */
#define ADC_ADC_REG_INTERVAL_WARMUP_TIME(x)      (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_INTERVAL_WARMUP_TIME_SHIFT)) & ADC_ADC_REG_INTERVAL_WARMUP_TIME_MASK)

#define ADC_ADC_REG_INTERVAL_BYPASS_WARMUP_MASK  (0x20U)
#define ADC_ADC_REG_INTERVAL_BYPASS_WARMUP_SHIFT (5U)
/*! BYPASS_WARMUP - Bypass warmup state inside adc. */
#define ADC_ADC_REG_INTERVAL_BYPASS_WARMUP(x)    (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_INTERVAL_BYPASS_WARMUP_SHIFT)) & ADC_ADC_REG_INTERVAL_BYPASS_WARMUP_MASK)
/*! @} */

/*! @name ADC_REG_ANA - ADC ANA Register */
/*! @{ */

#define ADC_ADC_REG_ANA_TSEXT_SEL_MASK           (0x1U)
#define ADC_ADC_REG_ANA_TSEXT_SEL_SHIFT          (0U)
/*! TSEXT_SEL - temperature sensor diode select */
#define ADC_ADC_REG_ANA_TSEXT_SEL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ANA_TSEXT_SEL_SHIFT)) & ADC_ADC_REG_ANA_TSEXT_SEL_MASK)

#define ADC_ADC_REG_ANA_TS_EN_MASK               (0x2U)
#define ADC_ADC_REG_ANA_TS_EN_SHIFT              (1U)
/*! TS_EN - temperature sensor enable, only enable when channel source is temperature sensor */
#define ADC_ADC_REG_ANA_TS_EN(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ANA_TS_EN_SHIFT)) & ADC_ADC_REG_ANA_TS_EN_MASK)

#define ADC_ADC_REG_ANA_VREF_SCF_BYPASS_MASK     (0x4U)
#define ADC_ADC_REG_ANA_VREF_SCF_BYPASS_SHIFT    (2U)
/*! VREF_SCF_BYPASS - adc voltage reference buffer sc-filter bypass */
#define ADC_ADC_REG_ANA_VREF_SCF_BYPASS(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ANA_VREF_SCF_BYPASS_SHIFT)) & ADC_ADC_REG_ANA_VREF_SCF_BYPASS_MASK)

#define ADC_ADC_REG_ANA_VREF_CHOP_EN_MASK        (0x8U)
#define ADC_ADC_REG_ANA_VREF_CHOP_EN_SHIFT       (3U)
/*! VREF_CHOP_EN - adc voltage reference buffer chopper enable */
#define ADC_ADC_REG_ANA_VREF_CHOP_EN(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ANA_VREF_CHOP_EN_SHIFT)) & ADC_ADC_REG_ANA_VREF_CHOP_EN_MASK)

#define ADC_ADC_REG_ANA_VREF_SEL_MASK            (0x30U)
#define ADC_ADC_REG_ANA_VREF_SEL_SHIFT           (4U)
/*! VREF_SEL - adc reference voltage select. */
#define ADC_ADC_REG_ANA_VREF_SEL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ANA_VREF_SEL_SHIFT)) & ADC_ADC_REG_ANA_VREF_SEL_MASK)

#define ADC_ADC_REG_ANA_SINGLEDIFF_MASK          (0x400U)
#define ADC_ADC_REG_ANA_SINGLEDIFF_SHIFT         (10U)
/*! SINGLEDIFF - Select single ended or differential input. */
#define ADC_ADC_REG_ANA_SINGLEDIFF(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ANA_SINGLEDIFF_SHIFT)) & ADC_ADC_REG_ANA_SINGLEDIFF_MASK)

#define ADC_ADC_REG_ANA_INBUF_GAIN_MASK          (0x1800U)
#define ADC_ADC_REG_ANA_INBUF_GAIN_SHIFT         (11U)
/*! INBUF_GAIN - adc gain control. Also select input voltage range. */
#define ADC_ADC_REG_ANA_INBUF_GAIN(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ANA_INBUF_GAIN_SHIFT)) & ADC_ADC_REG_ANA_INBUF_GAIN_MASK)

#define ADC_ADC_REG_ANA_INBUF_CHOP_EN_MASK       (0x2000U)
#define ADC_ADC_REG_ANA_INBUF_CHOP_EN_SHIFT      (13U)
/*! INBUF_CHOP_EN - Input buffer chopper enable */
#define ADC_ADC_REG_ANA_INBUF_CHOP_EN(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ANA_INBUF_CHOP_EN_SHIFT)) & ADC_ADC_REG_ANA_INBUF_CHOP_EN_MASK)

#define ADC_ADC_REG_ANA_INBUF_EN_MASK            (0x4000U)
#define ADC_ADC_REG_ANA_INBUF_EN_SHIFT           (14U)
/*! INBUF_EN - gpadc input gain buffer enable bit. */
#define ADC_ADC_REG_ANA_INBUF_EN(x)              (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ANA_INBUF_EN_SHIFT)) & ADC_ADC_REG_ANA_INBUF_EN_MASK)

#define ADC_ADC_REG_ANA_CHOP_EN_MASK             (0x8000U)
#define ADC_ADC_REG_ANA_CHOP_EN_SHIFT            (15U)
/*! CHOP_EN - adc chopper/auto-zero(only in 12bit mode) enable */
#define ADC_ADC_REG_ANA_CHOP_EN(x)               (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ANA_CHOP_EN_SHIFT)) & ADC_ADC_REG_ANA_CHOP_EN_MASK)

#define ADC_ADC_REG_ANA_BIAS_SEL_MASK            (0x10000U)
#define ADC_ADC_REG_ANA_BIAS_SEL_SHIFT           (16U)
/*! BIAS_SEL - adc analog portion low power mode select. Half the biasing current for modulator when enabled. */
#define ADC_ADC_REG_ANA_BIAS_SEL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ANA_BIAS_SEL_SHIFT)) & ADC_ADC_REG_ANA_BIAS_SEL_MASK)

#define ADC_ADC_REG_ANA_RES_SEL_MASK             (0x60000U)
#define ADC_ADC_REG_ANA_RES_SEL_SHIFT            (17U)
/*! RES_SEL - adc resolution/data rate select */
#define ADC_ADC_REG_ANA_RES_SEL(x)               (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ANA_RES_SEL_SHIFT)) & ADC_ADC_REG_ANA_RES_SEL_MASK)
/*! @} */

/*! @name ADC_REG_SCN1 - ADC Conversion Sequence 1 Register */
/*! @{ */

#define ADC_ADC_REG_SCN1_SCAN_CH_0_MASK          (0xFU)
#define ADC_ADC_REG_SCN1_SCAN_CH_0_SHIFT         (0U)
/*! SCAN_CH_0 - amux source 0 */
#define ADC_ADC_REG_SCN1_SCAN_CH_0(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN1_SCAN_CH_0_SHIFT)) & ADC_ADC_REG_SCN1_SCAN_CH_0_MASK)

#define ADC_ADC_REG_SCN1_SCAN_CH_1_MASK          (0xF0U)
#define ADC_ADC_REG_SCN1_SCAN_CH_1_SHIFT         (4U)
/*! SCAN_CH_1 - amux source 1 */
#define ADC_ADC_REG_SCN1_SCAN_CH_1(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN1_SCAN_CH_1_SHIFT)) & ADC_ADC_REG_SCN1_SCAN_CH_1_MASK)

#define ADC_ADC_REG_SCN1_SCAN_CH_2_MASK          (0xF00U)
#define ADC_ADC_REG_SCN1_SCAN_CH_2_SHIFT         (8U)
/*! SCAN_CH_2 - amux source 2 */
#define ADC_ADC_REG_SCN1_SCAN_CH_2(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN1_SCAN_CH_2_SHIFT)) & ADC_ADC_REG_SCN1_SCAN_CH_2_MASK)

#define ADC_ADC_REG_SCN1_SCAN_CH_3_MASK          (0xF000U)
#define ADC_ADC_REG_SCN1_SCAN_CH_3_SHIFT         (12U)
/*! SCAN_CH_3 - amux source 3 */
#define ADC_ADC_REG_SCN1_SCAN_CH_3(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN1_SCAN_CH_3_SHIFT)) & ADC_ADC_REG_SCN1_SCAN_CH_3_MASK)

#define ADC_ADC_REG_SCN1_SCAN_CH_4_MASK          (0xF0000U)
#define ADC_ADC_REG_SCN1_SCAN_CH_4_SHIFT         (16U)
/*! SCAN_CH_4 - amux source 4 */
#define ADC_ADC_REG_SCN1_SCAN_CH_4(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN1_SCAN_CH_4_SHIFT)) & ADC_ADC_REG_SCN1_SCAN_CH_4_MASK)

#define ADC_ADC_REG_SCN1_SCAN_CH_5_MASK          (0xF00000U)
#define ADC_ADC_REG_SCN1_SCAN_CH_5_SHIFT         (20U)
/*! SCAN_CH_5 - amux source 5 */
#define ADC_ADC_REG_SCN1_SCAN_CH_5(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN1_SCAN_CH_5_SHIFT)) & ADC_ADC_REG_SCN1_SCAN_CH_5_MASK)

#define ADC_ADC_REG_SCN1_SCAN_CH_6_MASK          (0xF000000U)
#define ADC_ADC_REG_SCN1_SCAN_CH_6_SHIFT         (24U)
/*! SCAN_CH_6 - amux source 6 */
#define ADC_ADC_REG_SCN1_SCAN_CH_6(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN1_SCAN_CH_6_SHIFT)) & ADC_ADC_REG_SCN1_SCAN_CH_6_MASK)

#define ADC_ADC_REG_SCN1_SCAN_CH_7_MASK          (0xF0000000U)
#define ADC_ADC_REG_SCN1_SCAN_CH_7_SHIFT         (28U)
/*! SCAN_CH_7 - amux source 7 */
#define ADC_ADC_REG_SCN1_SCAN_CH_7(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN1_SCAN_CH_7_SHIFT)) & ADC_ADC_REG_SCN1_SCAN_CH_7_MASK)
/*! @} */

/*! @name ADC_REG_SCN2 - ADC Conversion Sequence 2 Register */
/*! @{ */

#define ADC_ADC_REG_SCN2_SCAN_CH_8_MASK          (0xFU)
#define ADC_ADC_REG_SCN2_SCAN_CH_8_SHIFT         (0U)
/*! SCAN_CH_8 - amux source 8 */
#define ADC_ADC_REG_SCN2_SCAN_CH_8(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN2_SCAN_CH_8_SHIFT)) & ADC_ADC_REG_SCN2_SCAN_CH_8_MASK)

#define ADC_ADC_REG_SCN2_SCAN_CH_9_MASK          (0xF0U)
#define ADC_ADC_REG_SCN2_SCAN_CH_9_SHIFT         (4U)
/*! SCAN_CH_9 - amux source 9 */
#define ADC_ADC_REG_SCN2_SCAN_CH_9(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN2_SCAN_CH_9_SHIFT)) & ADC_ADC_REG_SCN2_SCAN_CH_9_MASK)

#define ADC_ADC_REG_SCN2_SCAN_CH_10_MASK         (0xF00U)
#define ADC_ADC_REG_SCN2_SCAN_CH_10_SHIFT        (8U)
/*! SCAN_CH_10 - amux source 10 */
#define ADC_ADC_REG_SCN2_SCAN_CH_10(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN2_SCAN_CH_10_SHIFT)) & ADC_ADC_REG_SCN2_SCAN_CH_10_MASK)

#define ADC_ADC_REG_SCN2_SCAN_CH_11_MASK         (0xF000U)
#define ADC_ADC_REG_SCN2_SCAN_CH_11_SHIFT        (12U)
/*! SCAN_CH_11 - amux source 11 */
#define ADC_ADC_REG_SCN2_SCAN_CH_11(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN2_SCAN_CH_11_SHIFT)) & ADC_ADC_REG_SCN2_SCAN_CH_11_MASK)

#define ADC_ADC_REG_SCN2_SCAN_CH_12_MASK         (0xF0000U)
#define ADC_ADC_REG_SCN2_SCAN_CH_12_SHIFT        (16U)
/*! SCAN_CH_12 - amux source 12 */
#define ADC_ADC_REG_SCN2_SCAN_CH_12(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN2_SCAN_CH_12_SHIFT)) & ADC_ADC_REG_SCN2_SCAN_CH_12_MASK)

#define ADC_ADC_REG_SCN2_SCAN_CH_13_MASK         (0xF00000U)
#define ADC_ADC_REG_SCN2_SCAN_CH_13_SHIFT        (20U)
/*! SCAN_CH_13 - amux source 13 */
#define ADC_ADC_REG_SCN2_SCAN_CH_13(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN2_SCAN_CH_13_SHIFT)) & ADC_ADC_REG_SCN2_SCAN_CH_13_MASK)

#define ADC_ADC_REG_SCN2_SCAN_CH_14_MASK         (0xF000000U)
#define ADC_ADC_REG_SCN2_SCAN_CH_14_SHIFT        (24U)
/*! SCAN_CH_14 - amux source 14 */
#define ADC_ADC_REG_SCN2_SCAN_CH_14(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN2_SCAN_CH_14_SHIFT)) & ADC_ADC_REG_SCN2_SCAN_CH_14_MASK)

#define ADC_ADC_REG_SCN2_SCAN_CH_15_MASK         (0xF0000000U)
#define ADC_ADC_REG_SCN2_SCAN_CH_15_SHIFT        (28U)
/*! SCAN_CH_15 - amux source 15 */
#define ADC_ADC_REG_SCN2_SCAN_CH_15(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_SCN2_SCAN_CH_15_SHIFT)) & ADC_ADC_REG_SCN2_SCAN_CH_15_MASK)
/*! @} */

/*! @name ADC_REG_RESULT_BUF - ADC Result Buffer Register */
/*! @{ */

#define ADC_ADC_REG_RESULT_BUF_WIDTH_SEL_MASK    (0x1U)
#define ADC_ADC_REG_RESULT_BUF_WIDTH_SEL_SHIFT   (0U)
/*! WIDTH_SEL - adc finial result fifo data packed format select, must set scan_length as even when choose 32-bits */
#define ADC_ADC_REG_RESULT_BUF_WIDTH_SEL(x)      (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_RESULT_BUF_WIDTH_SEL_SHIFT)) & ADC_ADC_REG_RESULT_BUF_WIDTH_SEL_MASK)
/*! @} */

/*! @name ADC_REG_DMAR - ADC DMAR Register */
/*! @{ */

#define ADC_ADC_REG_DMAR_DMA_EN_MASK             (0x1U)
#define ADC_ADC_REG_DMAR_DMA_EN_SHIFT            (0U)
/*! DMA_EN - dma enbale */
#define ADC_ADC_REG_DMAR_DMA_EN(x)               (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_DMAR_DMA_EN_SHIFT)) & ADC_ADC_REG_DMAR_DMA_EN_MASK)

#define ADC_ADC_REG_DMAR_FIFO_THL_MASK           (0x6U)
#define ADC_ADC_REG_DMAR_FIFO_THL_SHIFT          (1U)
/*! FIFO_THL - fifo threshold */
#define ADC_ADC_REG_DMAR_FIFO_THL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_DMAR_FIFO_THL_SHIFT)) & ADC_ADC_REG_DMAR_FIFO_THL_MASK)
/*! @} */

/*! @name ADC_REG_STATUS - ADC Status Register */
/*! @{ */

#define ADC_ADC_REG_STATUS_ACT_MASK              (0x1U)
#define ADC_ADC_REG_STATUS_ACT_SHIFT             (0U)
/*! ACT - adc status */
#define ADC_ADC_REG_STATUS_ACT(x)                (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_STATUS_ACT_SHIFT)) & ADC_ADC_REG_STATUS_ACT_MASK)

#define ADC_ADC_REG_STATUS_FIFO_NE_MASK          (0x2U)
#define ADC_ADC_REG_STATUS_FIFO_NE_SHIFT         (1U)
/*! FIFO_NE - fifo not empty status */
#define ADC_ADC_REG_STATUS_FIFO_NE(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_STATUS_FIFO_NE_SHIFT)) & ADC_ADC_REG_STATUS_FIFO_NE_MASK)

#define ADC_ADC_REG_STATUS_FIFO_FULL_MASK        (0x4U)
#define ADC_ADC_REG_STATUS_FIFO_FULL_SHIFT       (2U)
/*! FIFO_FULL - fifo full status */
#define ADC_ADC_REG_STATUS_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_STATUS_FIFO_FULL_SHIFT)) & ADC_ADC_REG_STATUS_FIFO_FULL_MASK)

#define ADC_ADC_REG_STATUS_FIFO_DATA_COUNT_MASK  (0x1F8U)
#define ADC_ADC_REG_STATUS_FIFO_DATA_COUNT_SHIFT (3U)
/*! FIFO_DATA_COUNT - fifo data number */
#define ADC_ADC_REG_STATUS_FIFO_DATA_COUNT(x)    (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_STATUS_FIFO_DATA_COUNT_SHIFT)) & ADC_ADC_REG_STATUS_FIFO_DATA_COUNT_MASK)
/*! @} */

/*! @name ADC_REG_ISR - ADC ISR Register */
/*! @{ */

#define ADC_ADC_REG_ISR_RDY_MASK                 (0x1U)
#define ADC_ADC_REG_ISR_RDY_SHIFT                (0U)
/*! RDY - Conversion data ready interrupt flag */
#define ADC_ADC_REG_ISR_RDY(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ISR_RDY_SHIFT)) & ADC_ADC_REG_ISR_RDY_MASK)

#define ADC_ADC_REG_ISR_GAINSAT_MASK             (0x2U)
#define ADC_ADC_REG_ISR_GAINSAT_SHIFT            (1U)
/*! GAINSAT - Gain correction saturation interrupt flag */
#define ADC_ADC_REG_ISR_GAINSAT(x)               (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ISR_GAINSAT_SHIFT)) & ADC_ADC_REG_ISR_GAINSAT_MASK)

#define ADC_ADC_REG_ISR_OFFSAT_MASK              (0x4U)
#define ADC_ADC_REG_ISR_OFFSAT_SHIFT             (2U)
/*! OFFSAT - Offset correction saturation interrupt flag */
#define ADC_ADC_REG_ISR_OFFSAT(x)                (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ISR_OFFSAT_SHIFT)) & ADC_ADC_REG_ISR_OFFSAT_MASK)

#define ADC_ADC_REG_ISR_DATASAT_NEG_MASK         (0x8U)
#define ADC_ADC_REG_ISR_DATASAT_NEG_SHIFT        (3U)
/*! DATASAT_NEG - ADC data negative side saturation interrupt flag */
#define ADC_ADC_REG_ISR_DATASAT_NEG(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ISR_DATASAT_NEG_SHIFT)) & ADC_ADC_REG_ISR_DATASAT_NEG_MASK)

#define ADC_ADC_REG_ISR_DATASAT_POS_MASK         (0x10U)
#define ADC_ADC_REG_ISR_DATASAT_POS_SHIFT        (4U)
/*! DATASAT_POS - ADC data positive side saturation interrupt flag */
#define ADC_ADC_REG_ISR_DATASAT_POS(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ISR_DATASAT_POS_SHIFT)) & ADC_ADC_REG_ISR_DATASAT_POS_MASK)

#define ADC_ADC_REG_ISR_FIFO_OVERRUN_MASK        (0x20U)
#define ADC_ADC_REG_ISR_FIFO_OVERRUN_SHIFT       (5U)
/*! FIFO_OVERRUN - FIFO overrun interrupt flag */
#define ADC_ADC_REG_ISR_FIFO_OVERRUN(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ISR_FIFO_OVERRUN_SHIFT)) & ADC_ADC_REG_ISR_FIFO_OVERRUN_MASK)

#define ADC_ADC_REG_ISR_FIFO_UNDERRUN_MASK       (0x40U)
#define ADC_ADC_REG_ISR_FIFO_UNDERRUN_SHIFT      (6U)
/*! FIFO_UNDERRUN - FIFO underrun interrupt flag */
#define ADC_ADC_REG_ISR_FIFO_UNDERRUN(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ISR_FIFO_UNDERRUN_SHIFT)) & ADC_ADC_REG_ISR_FIFO_UNDERRUN_MASK)
/*! @} */

/*! @name ADC_REG_IMR - ADC IMR Register */
/*! @{ */

#define ADC_ADC_REG_IMR_RDY_MASK_MASK            (0x1U)
#define ADC_ADC_REG_IMR_RDY_MASK_SHIFT           (0U)
/*! RDY_MASK - write 1 mask */
#define ADC_ADC_REG_IMR_RDY_MASK(x)              (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IMR_RDY_MASK_SHIFT)) & ADC_ADC_REG_IMR_RDY_MASK_MASK)

#define ADC_ADC_REG_IMR_GAINSAT_MASK_MASK        (0x2U)
#define ADC_ADC_REG_IMR_GAINSAT_MASK_SHIFT       (1U)
/*! GAINSAT_MASK - write 1 mask */
#define ADC_ADC_REG_IMR_GAINSAT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IMR_GAINSAT_MASK_SHIFT)) & ADC_ADC_REG_IMR_GAINSAT_MASK_MASK)

#define ADC_ADC_REG_IMR_OFFSAT_MASK_MASK         (0x4U)
#define ADC_ADC_REG_IMR_OFFSAT_MASK_SHIFT        (2U)
/*! OFFSAT_MASK - write 1 mask */
#define ADC_ADC_REG_IMR_OFFSAT_MASK(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IMR_OFFSAT_MASK_SHIFT)) & ADC_ADC_REG_IMR_OFFSAT_MASK_MASK)

#define ADC_ADC_REG_IMR_DATASAT_NEG_MASK_MASK    (0x8U)
#define ADC_ADC_REG_IMR_DATASAT_NEG_MASK_SHIFT   (3U)
/*! DATASAT_NEG_MASK - write 1 mask */
#define ADC_ADC_REG_IMR_DATASAT_NEG_MASK(x)      (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IMR_DATASAT_NEG_MASK_SHIFT)) & ADC_ADC_REG_IMR_DATASAT_NEG_MASK_MASK)

#define ADC_ADC_REG_IMR_DATASAT_POS_MASK_MASK    (0x10U)
#define ADC_ADC_REG_IMR_DATASAT_POS_MASK_SHIFT   (4U)
/*! DATASAT_POS_MASK - write 1 mask */
#define ADC_ADC_REG_IMR_DATASAT_POS_MASK(x)      (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IMR_DATASAT_POS_MASK_SHIFT)) & ADC_ADC_REG_IMR_DATASAT_POS_MASK_MASK)

#define ADC_ADC_REG_IMR_FIFO_OVERRUN_MASK_MASK   (0x20U)
#define ADC_ADC_REG_IMR_FIFO_OVERRUN_MASK_SHIFT  (5U)
/*! FIFO_OVERRUN_MASK - write 1 mask */
#define ADC_ADC_REG_IMR_FIFO_OVERRUN_MASK(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IMR_FIFO_OVERRUN_MASK_SHIFT)) & ADC_ADC_REG_IMR_FIFO_OVERRUN_MASK_MASK)

#define ADC_ADC_REG_IMR_FIFO_UNDERRUN_MASK_MASK  (0x40U)
#define ADC_ADC_REG_IMR_FIFO_UNDERRUN_MASK_SHIFT (6U)
/*! FIFO_UNDERRUN_MASK - write 1 mask */
#define ADC_ADC_REG_IMR_FIFO_UNDERRUN_MASK(x)    (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IMR_FIFO_UNDERRUN_MASK_SHIFT)) & ADC_ADC_REG_IMR_FIFO_UNDERRUN_MASK_MASK)
/*! @} */

/*! @name ADC_REG_IRSR - ADC IRSR Register */
/*! @{ */

#define ADC_ADC_REG_IRSR_RDY_RAW_MASK            (0x1U)
#define ADC_ADC_REG_IRSR_RDY_RAW_SHIFT           (0U)
/*! RDY_RAW - The corresponding flag will be captured into this register regardless the interrupt
 *    mask. Will be cleared only when int_clr is asserted.
 */
#define ADC_ADC_REG_IRSR_RDY_RAW(x)              (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IRSR_RDY_RAW_SHIFT)) & ADC_ADC_REG_IRSR_RDY_RAW_MASK)

#define ADC_ADC_REG_IRSR_GAINSAT_RAW_MASK        (0x2U)
#define ADC_ADC_REG_IRSR_GAINSAT_RAW_SHIFT       (1U)
/*! GAINSAT_RAW - The corresponding flag will be captured into this register regardless the
 *    interrupt mask. Will be cleared only when int_clr is asserted.
 */
#define ADC_ADC_REG_IRSR_GAINSAT_RAW(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IRSR_GAINSAT_RAW_SHIFT)) & ADC_ADC_REG_IRSR_GAINSAT_RAW_MASK)

#define ADC_ADC_REG_IRSR_OFFSAT_RAW_MASK         (0x4U)
#define ADC_ADC_REG_IRSR_OFFSAT_RAW_SHIFT        (2U)
/*! OFFSAT_RAW - The corresponding flag will be captured into this register regardless the interrupt
 *    mask. Will be cleared only when int_clr is asserted.
 */
#define ADC_ADC_REG_IRSR_OFFSAT_RAW(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IRSR_OFFSAT_RAW_SHIFT)) & ADC_ADC_REG_IRSR_OFFSAT_RAW_MASK)

#define ADC_ADC_REG_IRSR_DATASAT_NEG_RAW_MASK    (0x8U)
#define ADC_ADC_REG_IRSR_DATASAT_NEG_RAW_SHIFT   (3U)
/*! DATASAT_NEG_RAW - The corresponding flag will be captured into this register regardless the
 *    interrupt mask. Will be cleared only when int_clr is asserted.
 */
#define ADC_ADC_REG_IRSR_DATASAT_NEG_RAW(x)      (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IRSR_DATASAT_NEG_RAW_SHIFT)) & ADC_ADC_REG_IRSR_DATASAT_NEG_RAW_MASK)

#define ADC_ADC_REG_IRSR_DATASAT_POS_RAW_MASK    (0x10U)
#define ADC_ADC_REG_IRSR_DATASAT_POS_RAW_SHIFT   (4U)
/*! DATASAT_POS_RAW - The corresponding flag will be captured into this register regardless the
 *    interrupt mask. Will be cleared only when int_clr is asserted.
 */
#define ADC_ADC_REG_IRSR_DATASAT_POS_RAW(x)      (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IRSR_DATASAT_POS_RAW_SHIFT)) & ADC_ADC_REG_IRSR_DATASAT_POS_RAW_MASK)

#define ADC_ADC_REG_IRSR_FIFO_OVERRUN_RAW_MASK   (0x20U)
#define ADC_ADC_REG_IRSR_FIFO_OVERRUN_RAW_SHIFT  (5U)
/*! FIFO_OVERRUN_RAW - The corresponding flag will be captured into this register regardless the
 *    interrupt mask. Will be cleared only when int_clr is asserted.
 */
#define ADC_ADC_REG_IRSR_FIFO_OVERRUN_RAW(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IRSR_FIFO_OVERRUN_RAW_SHIFT)) & ADC_ADC_REG_IRSR_FIFO_OVERRUN_RAW_MASK)

#define ADC_ADC_REG_IRSR_FIFO_UNDERRUN_RAW_MASK  (0x40U)
#define ADC_ADC_REG_IRSR_FIFO_UNDERRUN_RAW_SHIFT (6U)
/*! FIFO_UNDERRUN_RAW - The corresponding flag will be captured into this register regardless the
 *    interrupt mask. Will be cleared only when int_clr is asserted.
 */
#define ADC_ADC_REG_IRSR_FIFO_UNDERRUN_RAW(x)    (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_IRSR_FIFO_UNDERRUN_RAW_SHIFT)) & ADC_ADC_REG_IRSR_FIFO_UNDERRUN_RAW_MASK)
/*! @} */

/*! @name ADC_REG_ICR - ADC ICR Register */
/*! @{ */

#define ADC_ADC_REG_ICR_RDY_CLR_MASK             (0x1U)
#define ADC_ADC_REG_ICR_RDY_CLR_SHIFT            (0U)
/*! RDY_CLR - Write 1 to clear both adc_reg_irsr and adc_reg_isr */
#define ADC_ADC_REG_ICR_RDY_CLR(x)               (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ICR_RDY_CLR_SHIFT)) & ADC_ADC_REG_ICR_RDY_CLR_MASK)

#define ADC_ADC_REG_ICR_GAINSAT_CLR_MASK         (0x2U)
#define ADC_ADC_REG_ICR_GAINSAT_CLR_SHIFT        (1U)
/*! GAINSAT_CLR - Write 1 to clear both adc_reg_irsr and adc_reg_isr */
#define ADC_ADC_REG_ICR_GAINSAT_CLR(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ICR_GAINSAT_CLR_SHIFT)) & ADC_ADC_REG_ICR_GAINSAT_CLR_MASK)

#define ADC_ADC_REG_ICR_OFFSAT_CLR_MASK          (0x4U)
#define ADC_ADC_REG_ICR_OFFSAT_CLR_SHIFT         (2U)
/*! OFFSAT_CLR - Write 1 to clear both adc_reg_irsr and adc_reg_isr */
#define ADC_ADC_REG_ICR_OFFSAT_CLR(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ICR_OFFSAT_CLR_SHIFT)) & ADC_ADC_REG_ICR_OFFSAT_CLR_MASK)

#define ADC_ADC_REG_ICR_DATASAT_NEG_CLR_MASK     (0x8U)
#define ADC_ADC_REG_ICR_DATASAT_NEG_CLR_SHIFT    (3U)
/*! DATASAT_NEG_CLR - Write 1 to clear both adc_reg_irsr and adc_reg_isr */
#define ADC_ADC_REG_ICR_DATASAT_NEG_CLR(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ICR_DATASAT_NEG_CLR_SHIFT)) & ADC_ADC_REG_ICR_DATASAT_NEG_CLR_MASK)

#define ADC_ADC_REG_ICR_DATASAT_POS_CLR_MASK     (0x10U)
#define ADC_ADC_REG_ICR_DATASAT_POS_CLR_SHIFT    (4U)
/*! DATASAT_POS_CLR - Write 1 to clear both adc_reg_irsr and adc_reg_isr */
#define ADC_ADC_REG_ICR_DATASAT_POS_CLR(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ICR_DATASAT_POS_CLR_SHIFT)) & ADC_ADC_REG_ICR_DATASAT_POS_CLR_MASK)

#define ADC_ADC_REG_ICR_FIFO_OVERRUN_CLR_MASK    (0x20U)
#define ADC_ADC_REG_ICR_FIFO_OVERRUN_CLR_SHIFT   (5U)
/*! FIFO_OVERRUN_CLR - Write 1 to clear both adc_reg_irsr and adc_reg_isr */
#define ADC_ADC_REG_ICR_FIFO_OVERRUN_CLR(x)      (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ICR_FIFO_OVERRUN_CLR_SHIFT)) & ADC_ADC_REG_ICR_FIFO_OVERRUN_CLR_MASK)

#define ADC_ADC_REG_ICR_FIFO_UNDERRUN_CLR_MASK   (0x40U)
#define ADC_ADC_REG_ICR_FIFO_UNDERRUN_CLR_SHIFT  (6U)
/*! FIFO_UNDERRUN_CLR - Write 1 to clear both adc_reg_irsr and adc_reg_isr */
#define ADC_ADC_REG_ICR_FIFO_UNDERRUN_CLR(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_ICR_FIFO_UNDERRUN_CLR_SHIFT)) & ADC_ADC_REG_ICR_FIFO_UNDERRUN_CLR_MASK)
/*! @} */

/*! @name ADC_REG_RESULT - ADC Result Register */
/*! @{ */

#define ADC_ADC_REG_RESULT_DATA_MASK             (0xFFFFFFFFU)
#define ADC_ADC_REG_RESULT_DATA_SHIFT            (0U)
/*! DATA - ADC finial conversion result data, after calibratiob and signed/unsigned process */
#define ADC_ADC_REG_RESULT_DATA(x)               (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_RESULT_DATA_SHIFT)) & ADC_ADC_REG_RESULT_DATA_MASK)
/*! @} */

/*! @name ADC_REG_RAW_RESULT - ADC Raw Result Register */
/*! @{ */

#define ADC_ADC_REG_RAW_RESULT_RAW_DATA_MASK     (0x3FFFFFU)
#define ADC_ADC_REG_RAW_RESULT_RAW_DATA_SHIFT    (0U)
/*! RAW_DATA - ADC Raw data in signed 22bit format */
#define ADC_ADC_REG_RAW_RESULT_RAW_DATA(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_RAW_RESULT_RAW_DATA_SHIFT)) & ADC_ADC_REG_RAW_RESULT_RAW_DATA_MASK)
/*! @} */

/*! @name ADC_REG_OFFSET_CAL - ADC Offset Calibration Register */
/*! @{ */

#define ADC_ADC_REG_OFFSET_CAL_OFFSET_CAL_MASK   (0xFFFFU)
#define ADC_ADC_REG_OFFSET_CAL_OFFSET_CAL_SHIFT  (0U)
/*! OFFSET_CAL - ADC self offset calibration value. 16-bit signed . */
#define ADC_ADC_REG_OFFSET_CAL_OFFSET_CAL(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_OFFSET_CAL_OFFSET_CAL_SHIFT)) & ADC_ADC_REG_OFFSET_CAL_OFFSET_CAL_MASK)

#define ADC_ADC_REG_OFFSET_CAL_OFFSET_CAL_USR_MASK (0xFFFF0000U)
#define ADC_ADC_REG_OFFSET_CAL_OFFSET_CAL_USR_SHIFT (16U)
/*! OFFSET_CAL_USR - User offset calibration data. 16-bit signed. */
#define ADC_ADC_REG_OFFSET_CAL_OFFSET_CAL_USR(x) (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_OFFSET_CAL_OFFSET_CAL_USR_SHIFT)) & ADC_ADC_REG_OFFSET_CAL_OFFSET_CAL_USR_MASK)
/*! @} */

/*! @name ADC_REG_GAIN_CAL - ADC Gain Calibration Register */
/*! @{ */

#define ADC_ADC_REG_GAIN_CAL_GAIN_CAL_MASK       (0xFFFFU)
#define ADC_ADC_REG_GAIN_CAL_GAIN_CAL_SHIFT      (0U)
/*! GAIN_CAL - ADC self gain calibration value. 16-bit signed. */
#define ADC_ADC_REG_GAIN_CAL_GAIN_CAL(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_GAIN_CAL_GAIN_CAL_SHIFT)) & ADC_ADC_REG_GAIN_CAL_GAIN_CAL_MASK)

#define ADC_ADC_REG_GAIN_CAL_GAIN_CAL_USR_MASK   (0xFFFF0000U)
#define ADC_ADC_REG_GAIN_CAL_GAIN_CAL_USR_SHIFT  (16U)
/*! GAIN_CAL_USR - ADC user gain calibration value. 16-bit signed. */
#define ADC_ADC_REG_GAIN_CAL_GAIN_CAL_USR(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_GAIN_CAL_GAIN_CAL_USR_SHIFT)) & ADC_ADC_REG_GAIN_CAL_GAIN_CAL_USR_MASK)
/*! @} */

/*! @name ADC_REG_TEST - ADC Test Register */
/*! @{ */

#define ADC_ADC_REG_TEST_TEST_EN_MASK            (0x1U)
#define ADC_ADC_REG_TEST_TEST_EN_SHIFT           (0U)
/*! TEST_EN - Analog test enable. */
#define ADC_ADC_REG_TEST_TEST_EN(x)              (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_TEST_TEST_EN_SHIFT)) & ADC_ADC_REG_TEST_TEST_EN_MASK)

#define ADC_ADC_REG_TEST_TEST_SEL_MASK           (0xEU)
#define ADC_ADC_REG_TEST_TEST_SEL_SHIFT          (1U)
/*! TEST_SEL - test_sel */
#define ADC_ADC_REG_TEST_TEST_SEL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_TEST_TEST_SEL_SHIFT)) & ADC_ADC_REG_TEST_TEST_SEL_MASK)
/*! @} */

/*! @name ADC_REG_AUDIO - ADC Audio Register */
/*! @{ */

#define ADC_ADC_REG_AUDIO_EN_MASK                (0x1U)
#define ADC_ADC_REG_AUDIO_EN_SHIFT               (0U)
/*! EN - Audio enable. */
#define ADC_ADC_REG_AUDIO_EN(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_AUDIO_EN_SHIFT)) & ADC_ADC_REG_AUDIO_EN_MASK)

#define ADC_ADC_REG_AUDIO_PGA_GAIN_MASK          (0x38U)
#define ADC_ADC_REG_AUDIO_PGA_GAIN_SHIFT         (3U)
/*! PGA_GAIN - Audio PGA voltage gain select */
#define ADC_ADC_REG_AUDIO_PGA_GAIN(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_AUDIO_PGA_GAIN_SHIFT)) & ADC_ADC_REG_AUDIO_PGA_GAIN_MASK)

#define ADC_ADC_REG_AUDIO_PGA_CM_MASK            (0x1C0U)
#define ADC_ADC_REG_AUDIO_PGA_CM_SHIFT           (6U)
/*! PGA_CM - Audio PGA output common mode control */
#define ADC_ADC_REG_AUDIO_PGA_CM(x)              (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_AUDIO_PGA_CM_SHIFT)) & ADC_ADC_REG_AUDIO_PGA_CM_MASK)

#define ADC_ADC_REG_AUDIO_PGA_CHOP_EN_MASK       (0x200U)
#define ADC_ADC_REG_AUDIO_PGA_CHOP_EN_SHIFT      (9U)
/*! PGA_CHOP_EN - Audio PGA chopper enable. */
#define ADC_ADC_REG_AUDIO_PGA_CHOP_EN(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_AUDIO_PGA_CHOP_EN_SHIFT)) & ADC_ADC_REG_AUDIO_PGA_CHOP_EN_MASK)
/*! @} */

/*! @name ADC_REG_VOICE_DET - ADC Voice Detect Register */
/*! @{ */

#define ADC_ADC_REG_VOICE_DET_DET_EN_MASK        (0x1U)
#define ADC_ADC_REG_VOICE_DET_DET_EN_SHIFT       (0U)
/*! DET_EN - Voice level detection enable select */
#define ADC_ADC_REG_VOICE_DET_DET_EN(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_VOICE_DET_DET_EN_SHIFT)) & ADC_ADC_REG_VOICE_DET_DET_EN_MASK)

#define ADC_ADC_REG_VOICE_DET_LEVEL_SEL_MASK     (0xEU)
#define ADC_ADC_REG_VOICE_DET_LEVEL_SEL_SHIFT    (1U)
/*! LEVEL_SEL - Voice level selection. */
#define ADC_ADC_REG_VOICE_DET_LEVEL_SEL(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_VOICE_DET_LEVEL_SEL_SHIFT)) & ADC_ADC_REG_VOICE_DET_LEVEL_SEL_MASK)
/*! @} */

/*! @name ADC_REG_RSVD - ADC Reserved Register */
/*! @{ */

#define ADC_ADC_REG_RSVD_UNUSED_RESERVED_ADC_CONTROL_BITS_MASK (0xFFFFU)
#define ADC_ADC_REG_RSVD_UNUSED_RESERVED_ADC_CONTROL_BITS_SHIFT (0U)
/*! UNUSED_RESERVED_ADC_CONTROL_BITS - unused_Reserved_ADC_control_bits */
#define ADC_ADC_REG_RSVD_UNUSED_RESERVED_ADC_CONTROL_BITS(x) (((uint32_t)(((uint32_t)(x)) << ADC_ADC_REG_RSVD_UNUSED_RESERVED_ADC_CONTROL_BITS_SHIFT)) & ADC_ADC_REG_RSVD_UNUSED_RESERVED_ADC_CONTROL_BITS_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral GAU_GPADC0 base address */
  #define GAU_GPADC0_BASE                          (0x50038000u)
  /** Peripheral GAU_GPADC0 base address */
  #define GAU_GPADC0_BASE_NS                       (0x40038000u)
  /** Peripheral GAU_GPADC0 base pointer */
  #define GAU_GPADC0                               ((ADC_Type *)GAU_GPADC0_BASE)
  /** Peripheral GAU_GPADC0 base pointer */
  #define GAU_GPADC0_NS                            ((ADC_Type *)GAU_GPADC0_BASE_NS)
  /** Peripheral GAU_GPADC1 base address */
  #define GAU_GPADC1_BASE                          (0x50038100u)
  /** Peripheral GAU_GPADC1 base address */
  #define GAU_GPADC1_BASE_NS                       (0x40038100u)
  /** Peripheral GAU_GPADC1 base pointer */
  #define GAU_GPADC1                               ((ADC_Type *)GAU_GPADC1_BASE)
  /** Peripheral GAU_GPADC1 base pointer */
  #define GAU_GPADC1_NS                            ((ADC_Type *)GAU_GPADC1_BASE_NS)
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS                           { GAU_GPADC0_BASE, GAU_GPADC1_BASE }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS                            { GAU_GPADC0, GAU_GPADC1 }
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS_NS                        { GAU_GPADC0_BASE_NS, GAU_GPADC1_BASE_NS }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS_NS                         { GAU_GPADC0_NS, GAU_GPADC1_NS }
#else
  /** Peripheral GAU_GPADC0 base address */
  #define GAU_GPADC0_BASE                          (0x40038000u)
  /** Peripheral GAU_GPADC0 base pointer */
  #define GAU_GPADC0                               ((ADC_Type *)GAU_GPADC0_BASE)
  /** Peripheral GAU_GPADC1 base address */
  #define GAU_GPADC1_BASE                          (0x40038100u)
  /** Peripheral GAU_GPADC1 base pointer */
  #define GAU_GPADC1                               ((ADC_Type *)GAU_GPADC1_BASE)
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS                           { GAU_GPADC0_BASE, GAU_GPADC1_BASE }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS                            { GAU_GPADC0, GAU_GPADC1 }
#endif
/** Interrupt vectors for the ADC peripheral type */
#define ADC_IRQS                                 { GAU_ADC0_IRQn, GAU_ADC1_IRQn }
/* Backward compatibility */
#define kADC_TriggerSourceGpt                    kADC_TriggerSourceCtimer
#define kADC_TriggerSourceGpio40                 kADC_TriggerSourceGpio50
#define kADC_TriggerSourceGpio41                 kADC_TriggerSourceGpio55


/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AHB_SECURE_CTRL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AHB_SECURE_CTRL_Peripheral_Access_Layer AHB_SECURE_CTRL Peripheral Access Layer
 * @{
 */

/** AHB_SECURE_CTRL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t BOOTROM0_MEM_RULE[4];              /**< 0x03000000-0x0303FFFF part0..0x03000000-0x0303FFFF part3, array offset: 0x10, array step: 0x4 */
  struct {                                         /* offset: 0x20, array step: 0xB0 */
         uint8_t RESERVED_0[16];
    __IO uint32_t REGION0_MEM_RULE[4];               /**< 0x08000000--0x080FFFFF..0x48300000--0x483FFFFF, array offset: 0x30, array step: index*0xB0, index2*0x4 */
    __IO uint32_t REGION1_MEM_RULE;                  /**< 0x08400000--0x087FFFFF..0x48400000--0x487FFFFF, array offset: 0x40, array step: 0xB0 */
         uint8_t RESERVED_1[12];
    __IO uint32_t REGION2_MEM_RULE;                  /**< 0x08800000--0x08FFFFFF..0x48800000--0x48FFFFFF, array offset: 0x50, array step: 0xB0 */
         uint8_t RESERVED_2[12];
    __IO uint32_t REGION3_MEM_RULE;                  /**< 0x09000000--0x09FFFFFF..0x49000000--0x49FFFFFF, array offset: 0x60, array step: 0xB0 */
         uint8_t RESERVED_3[12];
    __IO uint32_t REGION4_MEM_RULE;                  /**< 0x0A000000--0x0BFFFFFF..0x4A000000--0x4BFFFFFF, array offset: 0x70, array step: 0xB0 */
         uint8_t RESERVED_4[12];
    __IO uint32_t REGION5_MEM_RULE[4];               /**< 0x0C000000--0x0C0FFFFF..0x4C300000--0x4C3FFFFF, array offset: 0x80, array step: index*0xB0, index2*0x4 */
    __IO uint32_t REGION6_MEM_RULE;                  /**< 0x0C400000--0x0C7FFFFF..0x4C400000--0x4C7FFFFF, array offset: 0x90, array step: 0xB0 */
         uint8_t RESERVED_5[12];
    __IO uint32_t REGION7_MEM_RULE;                  /**< 0x0C800000--0x0CFFFFFF..0x4C800000--0x4CFFFFFF, array offset: 0xA0, array step: 0xB0 */
         uint8_t RESERVED_6[12];
    __IO uint32_t REGION8_MEM_RULE;                  /**< 0x0D000000~0x0DFFFFFFF..0x4D000000~0x4DFFFFFFF, array offset: 0xB0, array step: 0xB0 */
         uint8_t RESERVED_7[12];
    __IO uint32_t REGION9_MEM_RULE;                  /**< 0x0E000000~0x0FFFFFFF..0x4E000000~0x4FFFFFFF, array offset: 0xC0, array step: 0xB0 */
         uint8_t RESERVED_8[12];
  } FLEXSPI_RULES[3];
       uint8_t RESERVED_1[16];
  __IO uint32_t RAM00_RULE[4];                     /**< 0x20000000--0x2000FFFF part0..0x20000000--0x2000FFFF part3, array offset: 0x240, array step: 0x4 */
  __IO uint32_t RAM01_RULE[4];                     /**< 0x20010000--0x2001FFFF part0..0x20010000--0x2001FFFF part3, array offset: 0x250, array step: 0x4 */
       uint8_t RESERVED_2[16];
  __IO uint32_t RAM02_RULE[4];                     /**< 0x20020000--0x2002FFFF part0..0x20020000--0x2002FFFF part3, array offset: 0x270, array step: 0x4 */
  __IO uint32_t RAM03_RULE[4];                     /**< 0x20030000--0x2003FFFF part0..0x20030000--0x2003FFFF part3, array offset: 0x280, array step: 0x4 */
       uint8_t RESERVED_3[16];
  __IO uint32_t RAM04_RULE[4];                     /**< 0x20040000--0x2004FFFF part0..0x20040000--0x2004FFFF part3, array offset: 0x2A0, array step: 0x4 */
  __IO uint32_t RAM05_RULE[4];                     /**< 0x20050000--0x2005FFFF part0..0x20050000--0x2005FFFF part3, array offset: 0x2B0, array step: 0x4 */
       uint8_t RESERVED_4[16];
  __IO uint32_t RAM06_RULE[4];                     /**< 0x20060000--0x2006FFFF part0..0x20060000--0x2006FFFF part3, array offset: 0x2D0, array step: 0x4 */
  __IO uint32_t RAM07_RULE[4];                     /**< 0x20070000--0x2007FFFF part0..0x20070000--0x2007FFFF part3, array offset: 0x2E0, array step: 0x4 */
       uint8_t RESERVED_5[16];
  __IO uint32_t RAM08_RULE[4];                     /**< 0x20080000--0x2008FFFF part0..0x20080000--0x2008FFFF part3, array offset: 0x300, array step: 0x4 */
  __IO uint32_t RAM09_RULE[4];                     /**< 0x20090000--0x2009FFFF part0..0x20090000--0x2009FFFF part3, array offset: 0x310, array step: 0x4 */
  __IO uint32_t RAM10_RULE[4];                     /**< 0x200A0000--0x200AFFFF part0..0x200A0000--0x200AFFFF part3, array offset: 0x320, array step: 0x4 */
  __IO uint32_t RAM11_RULE[4];                     /**< 0x200B0000--0x200BFFFF part0..0x200B0000--0x200BFFFF part3, array offset: 0x330, array step: 0x4 */
       uint8_t RESERVED_6[16];
  __IO uint32_t RAM12_RULE[4];                     /**< 0x200C0000--0x200CFFFF part0..0x200C0000--0x200CFFFF part3, array offset: 0x350, array step: 0x4 */
  __IO uint32_t RAM13_RULE[4];                     /**< 0x200D0000--0x200DFFFF part0..0x200D0000--0x200DFFFF part3, array offset: 0x360, array step: 0x4 */
  __IO uint32_t RAM14_RULE[4];                     /**< 0x200E0000--0x200EFFFF part0..0x200E0000--0x200EFFFF part3, array offset: 0x370, array step: 0x4 */
  __IO uint32_t RAM15_RULE[4];                     /**< 0x200F0000--0x200FFFFF part0..0x200F0000--0x200FFFFF part3, array offset: 0x380, array step: 0x4 */
       uint8_t RESERVED_7[16];
  __IO uint32_t RAM16_RULE[4];                     /**< 0x20100000--0x2010FFFF part0..0x20100000--0x2010FFFF part3, array offset: 0x3A0, array step: 0x4 */
  __IO uint32_t RAM17_RULE[4];                     /**< 0x20011000--0x20011FFF part0..0x20011000--0x20011FFF part3, array offset: 0x3B0, array step: 0x4 */
  __IO uint32_t RAM18_RULE[4];                     /**< 0x20012000--0x20012FFF part0..0x20012000--0x20012FFF part3, array offset: 0x3C0, array step: 0x4 */
       uint8_t RESERVED_8[16];
  __IO uint32_t APB_GRP0_MEM_RULE0;                /**< 0x4000000--0x40007FFF, offset: 0x3E0 */
  __IO uint32_t APB_GRP0_MEM_RULE1;                /**< 0x40008000~0x4000FFFF, offset: 0x3E4 */
  __IO uint32_t APB_GRP0_MEM_RULE2;                /**< 0x40010000--0x40017FFF, offset: 0x3E8 */
  __IO uint32_t APB_GRP0_MEM_RULE3;                /**< 0x40018000--0x4001FFFF, offset: 0x3EC */
  __IO uint32_t APB_GRP1_MEM_RULE0;                /**< 0x40020000--0x40027FFF, offset: 0x3F0 */
  __IO uint32_t APB_GRP1_MEM_RULE1;                /**< 0x40028000--0x4002FFFF, offset: 0x3F4 */
  __IO uint32_t APB_GRP1_MEM_RULE2;                /**< 0x40030000--0x40037FFF, offset: 0x3F8 */
  __IO uint32_t APB_GRP1_MEM_RULE3;                /**< 0x40038000--0x4003FFFF, offset: 0x3FC */
  __IO uint32_t AHB_PERIPH0_SLAVE_RULE;            /**< 0x40100000--0x4011FFFF, offset: 0x400 */
       uint8_t RESERVED_9[12];
  __IO uint32_t AHB_PERIPH1_SLAVE_RULE;            /**< 0x40120000--0x40127FFF, offset: 0x410 */
       uint8_t RESERVED_10[28];
  __IO uint32_t AIPS_BRIDGE_MEM_RULE0;             /**< 0x4013 0000 ~0x4013 7FFF, offset: 0x430 */
  __IO uint32_t AIPS_BRIDGE_MEM_RULE1;             /**< 0x4013 8000 ~0x4013 FFFF, offset: 0x434 */
       uint8_t RESERVED_11[8];
  __IO uint32_t AHB_PERIPH2_SLAVE_RULE;            /**< 0x40140000--0x4014FFFF, offset: 0x440 */
       uint8_t RESERVED_12[12];
  __IO uint32_t SECURITY_CTRL_MEM_RULE;            /**< 0x40148000--0x4014BFFF, offset: 0x450 */
       uint8_t RESERVED_13[12];
  __IO uint32_t AHB_PERIPH3_SLAVE_RULE;            /**< the memory map is 0x40150000--0x40158FFF, offset: 0x460 */
       uint8_t RESERVED_14[12];
  __IO uint32_t AON_MEM_RULE;                      /**< 0x4015C000--0x4015FFFF, offset: 0x470 */
       uint8_t RESERVED_15[12];
  __IO uint32_t WLAN_S0_SLAVE_RULE;                /**< 0x41000000-0x4137FFFF, 3.5MB, offset: 0x480 */
       uint8_t RESERVED_16[12];
  __IO uint32_t WLAN_S1_MEM_RULE[4];               /**< 0x41380000-0x413FFFFF, part0..0x41380000-0x413FFFFF, part3, array offset: 0x490, array step: 0x4 */
  __IO uint32_t BLE_S0_SLAVE_RULE;                 /**< 0x44000000-0x443BFFFF, offset: 0x4A0 */
       uint8_t RESERVED_17[12];
  __IO uint32_t BLE_S1_MEM_RULE[4];                /**< 0x443C0000-0x443FFFFF part0..0x443C0000-0x443FFFFF part3, array offset: 0x4B0, array step: 0x4 */
       uint8_t RESERVED_18[16];
  __IO uint32_t SOC_TOP_MEM_RULE[4];               /**< 0x45000000-0x4500FFFF part0..0x45000000-0x4500FFFF part3, array offset: 0x4D0, array step: 0x4 */
       uint8_t RESERVED_19[2336];
  __I  uint32_t SEC_VIO_ADDR[20];                  /**< most recent security violation address for AHB layer n, array offset: 0xE00, array step: 0x4 */
       uint8_t RESERVED_20[48];
  __I  uint32_t SEC_VIO_MISC_INFO[20];             /**< most recent security violation miscellaneous information for AHB layer n, array offset: 0xE80, array step: 0x4 */
       uint8_t RESERVED_21[48];
  __IO uint32_t SEC_VIO_INFO_VALID;                /**< security violation address/information registers valid flags, offset: 0xF00 */
       uint8_t RESERVED_22[124];
  __IO uint32_t SEC_GPIO_MASK0;                    /**< Secure GPIO mask for port 0 pins. This register is used to block leakage of Secure interface (GPIOs, I2C, UART configured as secure peripherals) pin states to non-secure world., offset: 0xF80 */
  __IO uint32_t SEC_GPIO_MASK1;                    /**< Secure GPIO mask for port 1 pins., offset: 0xF84 */
       uint8_t RESERVED_23[52];
  __IO uint32_t SEC_MASK_LOCK;                     /**< sec_gp_reg write-lock bits, offset: 0xFBC */
       uint8_t RESERVED_24[16];
  __IO uint32_t MASTER_SEC_LEVEL;                  /**< master secure level register, offset: 0xFD0 */
  __IO uint32_t MASTER_SEC_LEVEL_ANTI_POL;         /**< master secure level anti-pole register, offset: 0xFD4 */
       uint8_t RESERVED_25[20];
  __IO uint32_t CM33_LOCK_REG;                     /**< m33 lock control register, offset: 0xFEC */
       uint8_t RESERVED_26[8];
  __IO uint32_t MISC_CTRL_DP_REG;                  /**< secure control duplicate register, offset: 0xFF8 */
  __IO uint32_t MISC_CTRL_REG;                     /**< secure control register, offset: 0xFFC */
} AHB_SECURE_CTRL_Type;

/* ----------------------------------------------------------------------------
   -- AHB_SECURE_CTRL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AHB_SECURE_CTRL_Register_Masks AHB_SECURE_CTRL Register Masks
 * @{
 */

/*! @name BOOTROM0_MEM_RULE - 0x03000000-0x0303FFFF part0..0x03000000-0x0303FFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_BOOTROM0_MEM_RULE */
#define AHB_SECURE_CTRL_BOOTROM0_MEM_RULE_COUNT  (4U)

/*! @name FLEXSPI_RULES_REGION0_MEM_RULE - 0x08000000--0x080FFFFF..0x48300000--0x483FFFFF */
/*! @{ */

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_COUNT (3U)

/* The count of AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION0_MEM_RULE_COUNT2 (4U)

/*! @name FLEXSPI_RULES_REGION1_MEM_RULE - 0x08400000--0x087FFFFF..0x48400000--0x487FFFFF */
/*! @{ */

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION1_MEM_RULE_COUNT (3U)

/*! @name FLEXSPI_RULES_REGION2_MEM_RULE - 0x08800000--0x08FFFFFF..0x48800000--0x48FFFFFF */
/*! @{ */

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION2_MEM_RULE_COUNT (3U)

/*! @name FLEXSPI_RULES_REGION3_MEM_RULE - 0x09000000--0x09FFFFFF..0x49000000--0x49FFFFFF */
/*! @{ */

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION3_MEM_RULE_COUNT (3U)

/*! @name FLEXSPI_RULES_REGION4_MEM_RULE - 0x0A000000--0x0BFFFFFF..0x4A000000--0x4BFFFFFF */
/*! @{ */

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION4_MEM_RULE_COUNT (3U)

/*! @name FLEXSPI_RULES_REGION5_MEM_RULE - 0x0C000000--0x0C0FFFFF..0x4C300000--0x4C3FFFFF */
/*! @{ */

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_COUNT (3U)

/* The count of AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION5_MEM_RULE_COUNT2 (4U)

/*! @name FLEXSPI_RULES_REGION6_MEM_RULE - 0x0C400000--0x0C7FFFFF..0x4C400000--0x4C7FFFFF */
/*! @{ */

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION6_MEM_RULE_COUNT (3U)

/*! @name FLEXSPI_RULES_REGION7_MEM_RULE - 0x0C800000--0x0CFFFFFF..0x4C800000--0x4CFFFFFF */
/*! @{ */

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION7_MEM_RULE_COUNT (3U)

/*! @name FLEXSPI_RULES_REGION8_MEM_RULE - 0x0D000000~0x0DFFFFFFF..0x4D000000~0x4DFFFFFFF */
/*! @{ */

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION8_MEM_RULE_COUNT (3U)

/*! @name FLEXSPI_RULES_REGION9_MEM_RULE - 0x0E000000~0x0FFFFFFF..0x4E000000~0x4FFFFFFF */
/*! @{ */

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE */
#define AHB_SECURE_CTRL_FLEXSPI_RULES_REGION9_MEM_RULE_COUNT (3U)

/*! @name RAM00_RULE - 0x20000000--0x2000FFFF part0..0x20000000--0x2000FFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM00_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM00_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM00_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM00_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM00_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM00_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM00_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM00_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM00_RULE */
#define AHB_SECURE_CTRL_RAM00_RULE_COUNT         (4U)

/*! @name RAM01_RULE - 0x20010000--0x2001FFFF part0..0x20010000--0x2001FFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM01_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM01_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM01_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM01_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM01_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM01_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM01_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM01_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM01_RULE */
#define AHB_SECURE_CTRL_RAM01_RULE_COUNT         (4U)

/*! @name RAM02_RULE - 0x20020000--0x2002FFFF part0..0x20020000--0x2002FFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM02_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM02_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM02_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM02_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM02_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM02_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM02_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM02_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM02_RULE */
#define AHB_SECURE_CTRL_RAM02_RULE_COUNT         (4U)

/*! @name RAM03_RULE - 0x20030000--0x2003FFFF part0..0x20030000--0x2003FFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM03_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM03_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM03_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM03_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM03_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM03_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM03_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM03_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM03_RULE */
#define AHB_SECURE_CTRL_RAM03_RULE_COUNT         (4U)

/*! @name RAM04_RULE - 0x20040000--0x2004FFFF part0..0x20040000--0x2004FFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM04_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM04_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM04_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM04_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM04_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM04_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM04_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM04_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM04_RULE */
#define AHB_SECURE_CTRL_RAM04_RULE_COUNT         (4U)

/*! @name RAM05_RULE - 0x20050000--0x2005FFFF part0..0x20050000--0x2005FFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM05_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM05_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM05_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM05_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM05_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM05_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM05_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM05_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM05_RULE */
#define AHB_SECURE_CTRL_RAM05_RULE_COUNT         (4U)

/*! @name RAM06_RULE - 0x20060000--0x2006FFFF part0..0x20060000--0x2006FFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM06_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM06_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM06_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM06_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM06_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM06_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM06_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM06_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM06_RULE */
#define AHB_SECURE_CTRL_RAM06_RULE_COUNT         (4U)

/*! @name RAM07_RULE - 0x20070000--0x2007FFFF part0..0x20070000--0x2007FFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM07_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM07_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM07_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM07_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM07_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM07_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM07_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM07_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM07_RULE */
#define AHB_SECURE_CTRL_RAM07_RULE_COUNT         (4U)

/*! @name RAM08_RULE - 0x20080000--0x2008FFFF part0..0x20080000--0x2008FFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM08_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM08_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM08_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM08_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM08_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM08_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM08_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM08_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM08_RULE */
#define AHB_SECURE_CTRL_RAM08_RULE_COUNT         (4U)

/*! @name RAM09_RULE - 0x20090000--0x2009FFFF part0..0x20090000--0x2009FFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM09_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM09_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM09_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM09_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM09_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM09_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM09_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM09_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM09_RULE */
#define AHB_SECURE_CTRL_RAM09_RULE_COUNT         (4U)

/*! @name RAM10_RULE - 0x200A0000--0x200AFFFF part0..0x200A0000--0x200AFFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM10_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM10_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM10_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM10_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM10_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM10_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM10_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM10_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM10_RULE */
#define AHB_SECURE_CTRL_RAM10_RULE_COUNT         (4U)

/*! @name RAM11_RULE - 0x200B0000--0x200BFFFF part0..0x200B0000--0x200BFFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM11_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM11_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM11_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM11_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM11_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM11_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM11_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM11_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM11_RULE */
#define AHB_SECURE_CTRL_RAM11_RULE_COUNT         (4U)

/*! @name RAM12_RULE - 0x200C0000--0x200CFFFF part0..0x200C0000--0x200CFFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM12_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM12_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM12_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM12_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM12_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM12_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM12_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM12_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM12_RULE */
#define AHB_SECURE_CTRL_RAM12_RULE_COUNT         (4U)

/*! @name RAM13_RULE - 0x200D0000--0x200DFFFF part0..0x200D0000--0x200DFFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM13_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM13_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM13_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM13_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM13_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM13_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM13_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM13_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM13_RULE */
#define AHB_SECURE_CTRL_RAM13_RULE_COUNT         (4U)

/*! @name RAM14_RULE - 0x200E0000--0x200EFFFF part0..0x200E0000--0x200EFFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM14_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM14_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM14_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM14_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM14_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM14_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM14_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM14_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM14_RULE */
#define AHB_SECURE_CTRL_RAM14_RULE_COUNT         (4U)

/*! @name RAM15_RULE - 0x200F0000--0x200FFFFF part0..0x200F0000--0x200FFFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM15_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM15_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM15_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM15_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM15_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM15_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM15_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM15_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM15_RULE */
#define AHB_SECURE_CTRL_RAM15_RULE_COUNT         (4U)

/*! @name RAM16_RULE - 0x20100000--0x2010FFFF part0..0x20100000--0x2010FFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM16_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM16_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM16_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM16_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM16_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM16_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM16_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM16_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM16_RULE */
#define AHB_SECURE_CTRL_RAM16_RULE_COUNT         (4U)

/*! @name RAM17_RULE - 0x20011000--0x20011FFF part0..0x20011000--0x20011FFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM17_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM17_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM17_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM17_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM17_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM17_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM17_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM17_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM17_RULE */
#define AHB_SECURE_CTRL_RAM17_RULE_COUNT         (4U)

/*! @name RAM18_RULE - 0x20012000--0x20012FFF part0..0x20012000--0x20012FFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_RAM18_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_RAM18_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_RAM18_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_RAM18_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_RAM18_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_RAM18_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_RAM18_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_RAM18_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM18_RULE */
#define AHB_SECURE_CTRL_RAM18_RULE_COUNT         (4U)

/*! @name APB_GRP0_MEM_RULE0 - 0x4000000--0x40007FFF */
/*! @{ */

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_RSTCTL0_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_RSTCTL0_RULE0_SHIFT (0U)
/*! RSTCTL0_RULE0 - 0x4000 0000--0x4000 0FFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_RSTCTL0_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_RSTCTL0_RULE0_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_RSTCTL0_RULE0_MASK)

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_CLKCTL0_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_CLKCTL0_RULE1_SHIFT (4U)
/*! CLKCTL0_RULE1 - 0x4000 1000--0x4000 1FFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_CLKCTL0_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_CLKCTL0_RULE1_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_CLKCTL0_RULE1_MASK)

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_SYSCTL0_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_SYSCTL0_RULE2_SHIFT (8U)
/*! SYSCTL0_RULE2 - 0x4000 2000--0x4000 2FFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_SYSCTL0_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_SYSCTL0_RULE2_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_SYSCTL0_RULE2_MASK)

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_SYSCTL2_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_SYSCTL2_RULE3_SHIFT (12U)
/*! SYSCTL2_RULE3 - 0x4000 3000--0x4000 3FFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_SYSCTL2_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_SYSCTL2_RULE3_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_SYSCTL2_RULE3_MASK)

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_IOCON_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_IOCON_RULE4_SHIFT (16U)
/*! IOCON_RULE4 - 0x4000 4000--0x4000 4FFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_IOCON_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_IOCON_RULE4_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_IOCON_RULE4_MASK)

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_PUFCTRL_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_PUFCTRL_RULE6_SHIFT (24U)
/*! PUFCTRL_RULE6 - 0x4000 6000--0x4000 6FFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_PUFCTRL_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_PUFCTRL_RULE6_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_PUFCTRL_RULE6_MASK)

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_ELS_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_ELS_RULE7_SHIFT (28U)
/*! ELS_RULE7 - 0x4000 7000--0x4000 7FFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_ELS_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_ELS_RULE7_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE0_ELS_RULE7_MASK)
/*! @} */

/*! @name APB_GRP0_MEM_RULE1 - 0x40008000~0x4000FFFF */
/*! @{ */

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_USIM_RULE8_MASK (0x3U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_USIM_RULE8_SHIFT (0U)
/*! USIM_RULE8 - 0x4000 8000--0x4000 8FFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_USIM_RULE8(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_USIM_RULE8_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_USIM_RULE8_MASK)

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_PKC_RULE9_MASK (0x30U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_PKC_RULE9_SHIFT (4U)
/*! PKC_RULE9 - 0x4000 9000--0x4000 9FFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_PKC_RULE9(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_PKC_RULE9_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_PKC_RULE9_MASK)

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_OCOTP_RULE10_MASK (0x300U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_OCOTP_RULE10_SHIFT (8U)
/*! OCOTP_RULE10 - 0x4000 A000--0x4000 AFFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_OCOTP_RULE10(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_OCOTP_RULE10_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_OCOTP_RULE10_MASK)

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_OCOTP_ADAP_RULE11_MASK (0x3000U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_OCOTP_ADAP_RULE11_SHIFT (12U)
/*! OCOTP_ADAP_RULE11 - 0x4000 A000--0x4000 AFFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_OCOTP_ADAP_RULE11(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_OCOTP_ADAP_RULE11_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_OCOTP_ADAP_RULE11_MASK)

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_WWDT0_RULE14_MASK (0x3000000U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_WWDT0_RULE14_SHIFT (24U)
/*! WWDT0_RULE14 - 0x4000 E000--0x4000 EFFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_WWDT0_RULE14(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_WWDT0_RULE14_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_WWDT0_RULE14_MASK)

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_UTICK_RULE15_MASK (0x30000000U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_UTICK_RULE15_SHIFT (28U)
/*! UTICK_RULE15 - 0x4000 F000--0x4000 FFFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_UTICK_RULE15(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_UTICK_RULE15_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE1_UTICK_RULE15_MASK)
/*! @} */

/*! @name APB_GRP0_MEM_RULE2 - 0x40010000--0x40017FFF */
/*! @{ */

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE2_TRNG_RULE20_MASK (0x30000U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE2_TRNG_RULE20_SHIFT (16U)
/*! TRNG_RULE20 - 0x4001 4000--0x4001 4FFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE2_TRNG_RULE20(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE2_TRNG_RULE20_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE2_TRNG_RULE20_MASK)
/*! @} */

/*! @name APB_GRP0_MEM_RULE3 - 0x40018000--0x4001FFFF */
/*! @{ */

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE3_C0_DOMAIN_TESTCON_RULE27_MASK (0x3000U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE3_C0_DOMAIN_TESTCON_RULE27_SHIFT (12U)
/*! C0_DOMAIN_TESTCON_RULE27 - 0x4001 B000--0x4001 BFFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE3_C0_DOMAIN_TESTCON_RULE27(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE3_C0_DOMAIN_TESTCON_RULE27_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE3_C0_DOMAIN_TESTCON_RULE27_MASK)

#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE3_C0AON_DOMAIN_TESTCON_RULE28_MASK (0x30000U)
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE3_C0AON_DOMAIN_TESTCON_RULE28_SHIFT (16U)
/*! C0AON_DOMAIN_TESTCON_RULE28 - 0x4001 C000--0x4001 CFFF */
#define AHB_SECURE_CTRL_APB_GRP0_MEM_RULE3_C0AON_DOMAIN_TESTCON_RULE28(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP0_MEM_RULE3_C0AON_DOMAIN_TESTCON_RULE28_SHIFT)) & AHB_SECURE_CTRL_APB_GRP0_MEM_RULE3_C0AON_DOMAIN_TESTCON_RULE28_MASK)
/*! @} */

/*! @name APB_GRP1_MEM_RULE0 - 0x40020000--0x40027FFF */
/*! @{ */

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_RSTCTL1_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_RSTCTL1_RULE0_SHIFT (0U)
/*! RSTCTL1_RULE0 - 0x4002 0000--0x4002 0FFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_RSTCTL1_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_RSTCTL1_RULE0_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_RSTCTL1_RULE0_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_CLKCTL1_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_CLKCTL1_RULE1_SHIFT (4U)
/*! CLKCTL1_RULE1 - 0x4002 1000--0x4002 1FFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_CLKCTL1_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_CLKCTL1_RULE1_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_CLKCTL1_RULE1_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_SYSCTL1_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_SYSCTL1_RULE2_SHIFT (8U)
/*! SYSCTL1_RULE2 - 0x4002 2000--0x4002 2FFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_SYSCTL1_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_SYSCTL1_RULE2_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_SYSCTL1_RULE2_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_ITRC_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_ITRC_RULE4_SHIFT (16U)
/*! ITRC_RULE4 - 0x4002 4000--0x4002 4FFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_ITRC_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_ITRC_RULE4_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_ITRC_RULE4_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_GPIO_INTR_CTRL_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_GPIO_INTR_CTRL_RULE5_SHIFT (20U)
/*! GPIO_INTR_CTRL_RULE5 - 0x4002 5000--0x4002 5FFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_GPIO_INTR_CTRL_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_GPIO_INTR_CTRL_RULE5_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_GPIO_INTR_CTRL_RULE5_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_PERIPH_INPUT_MUX_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_PERIPH_INPUT_MUX_RULE6_SHIFT (24U)
/*! PERIPH_INPUT_MUX_RULE6 - 0x4002 6000--0x4002 6FFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_PERIPH_INPUT_MUX_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_PERIPH_INPUT_MUX_RULE6_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE0_PERIPH_INPUT_MUX_RULE6_MASK)
/*! @} */

/*! @name APB_GRP1_MEM_RULE1 - 0x40028000--0x4002FFFF */
/*! @{ */

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT0_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT0_RULE0_SHIFT (0U)
/*! CT32BIT0_RULE0 - 0x4002 8000--0x4002 8FFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT0_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT0_RULE0_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT0_RULE0_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT1_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT1_RULE1_SHIFT (4U)
/*! CT32BIT1_RULE1 - 0x4002 9000--0x4002 9FFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT1_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT1_RULE1_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT1_RULE1_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT2_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT2_RULE2_SHIFT (8U)
/*! CT32BIT2_RULE2 - 0x4002 A000--0x4002 AFFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT2_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT2_RULE2_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT2_RULE2_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT3_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT3_RULE3_SHIFT (12U)
/*! CT32BIT3_RULE3 - 0x4002 B000--0x4002 BFFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT3_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT3_RULE3_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_CT32BIT3_RULE3_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_MRT_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_MRT_RULE5_SHIFT (20U)
/*! MRT_RULE5 - 0x4002 D000--0x4002 DFFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_MRT_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_MRT_RULE5_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_MRT_RULE5_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_FREQME_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_FREQME_RULE7_SHIFT (28U)
/*! FREQME_RULE7 - 0x4002 F000--0x4002 FFFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_FREQME_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_FREQME_RULE7_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE1_FREQME_RULE7_MASK)
/*! @} */

/*! @name APB_GRP1_MEM_RULE2 - 0x40030000--0x40037FFF */
/*! @{ */

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_RTC_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_RTC_RULE0_SHIFT (0U)
/*! RTC_RULE0 - 0x4003 0000--0x4003 0FFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_RTC_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_RTC_RULE0_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_RTC_RULE0_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_PMU_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_PMU_RULE1_SHIFT (4U)
/*! PMU_RULE1 - 0x4003 1000--0x4003 1FFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_PMU_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_PMU_RULE1_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_PMU_RULE1_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_FLASH_CACHE0_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_FLASH_CACHE0_RULE3_SHIFT (12U)
/*! FLASH_CACHE0_RULE3 - 0x4003 3000--0x4003 3FFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_FLASH_CACHE0_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_FLASH_CACHE0_RULE3_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_FLASH_CACHE0_RULE3_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_FLASH_CACHE1_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_FLASH_CACHE1_RULE4_SHIFT (16U)
/*! FLASH_CACHE1_RULE4 - 0x4003 4000--0x4003 4FFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_FLASH_CACHE1_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_FLASH_CACHE1_RULE4_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE2_FLASH_CACHE1_RULE4_MASK)
/*! @} */

/*! @name APB_GRP1_MEM_RULE3 - 0x40038000--0x4003FFFF */
/*! @{ */

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_GAU_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_GAU_RULE0_SHIFT (0U)
/*! GAU_RULE0 - 0x4003 8000--0x4003 8FFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_GAU_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_GAU_RULE0_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_GAU_RULE0_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_RF_SYSCON_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_RF_SYSCON_RULE3_SHIFT (12U)
/*! RF_SYSCON_RULE3 - 0x4003 B000--0x4003 BFFF */
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_RF_SYSCON_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_RF_SYSCON_RULE3_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_RF_SYSCON_RULE3_MASK)

#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_FREEMRT_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_FREEMRT_RULE7_SHIFT (28U)
#define AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_FREEMRT_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_FREEMRT_RULE7_SHIFT)) & AHB_SECURE_CTRL_APB_GRP1_MEM_RULE3_FREEMRT_RULE7_MASK)
/*! @} */

/*! @name AHB_PERIPH0_SLAVE_RULE - 0x40100000--0x4011FFFF */
/*! @{ */

#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_HSGPIO_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_HSGPIO_RULE0_SHIFT (0U)
/*! HSGPIO_RULE0 - 0x40100000--0x40103FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_HSGPIO_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_HSGPIO_RULE0_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_HSGPIO_RULE0_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DMA0_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DMA0_RULE1_SHIFT (4U)
/*! DMA0_RULE1 - 0x40104000--0x40104FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DMA0_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DMA0_RULE1_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DMA0_RULE1_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DMA1_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DMA1_RULE2_SHIFT (8U)
/*! DMA1_RULE2 - 0x40105000--0x40105FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DMA1_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DMA1_RULE2_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DMA1_RULE2_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM0_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM0_RULE3_SHIFT (12U)
/*! FLEXCOMM0_RULE3 - 0x40106000--0x40106FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM0_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM0_RULE3_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM0_RULE3_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM1_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM1_RULE4_SHIFT (16U)
/*! FLEXCOMM1_RULE4 - 0x40107000--0x40107FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM1_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM1_RULE4_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM1_RULE4_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM2_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM2_RULE5_SHIFT (20U)
/*! FLEXCOMM2_RULE5 - 0x40108000--0x40108FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM2_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM2_RULE5_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM2_RULE5_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM3_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM3_RULE6_SHIFT (24U)
/*! FLEXCOMM3_RULE6 - 0x40109000--0x40109FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM3_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM3_RULE6_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_FLEXCOMM3_RULE6_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DEBUG_MAILBOX_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DEBUG_MAILBOX_RULE7_SHIFT (28U)
/*! DEBUG_MAILBOX_RULE7 - 0x4010F000--0x4010FFFF */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DEBUG_MAILBOX_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DEBUG_MAILBOX_RULE7_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE_DEBUG_MAILBOX_RULE7_MASK)
/*! @} */

/*! @name AHB_PERIPH1_SLAVE_RULE - 0x40120000--0x40127FFF */
/*! @{ */

#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_CRC_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_CRC_RULE0_SHIFT (0U)
/*! CRC_RULE0 - 0x40120000--0x40120FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_CRC_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_CRC_RULE0_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_CRC_RULE0_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_DMIC_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_DMIC_RULE1_SHIFT (4U)
/*! DMIC_RULE1 - 0x40121000--0x40121FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_DMIC_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_DMIC_RULE1_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_DMIC_RULE1_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_FLEXCOMM4_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_FLEXCOMM4_RULE2_SHIFT (8U)
/*! FLEXCOMM4_RULE2 - 0x40122000--0x40122FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_FLEXCOMM4_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_FLEXCOMM4_RULE2_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_FLEXCOMM4_RULE2_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_FLEXCOMM14_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_FLEXCOMM14_RULE6_SHIFT (24U)
/*! FLEXCOMM14_RULE6 - 0x40126000--0x40126FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_FLEXCOMM14_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_FLEXCOMM14_RULE6_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE_FLEXCOMM14_RULE6_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_MEM_RULE0 - 0x4013 0000 ~0x4013 7FFF */
/*! @{ */

#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE0_OSPI_AND_OTFAD_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE0_OSPI_AND_OTFAD_RULE4_SHIFT (16U)
/*! OSPI_AND_OTFAD_RULE4 - 0x4013 4000--0x4013 4FFF */
#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE0_OSPI_AND_OTFAD_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE0_OSPI_AND_OTFAD_RULE4_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE0_OSPI_AND_OTFAD_RULE4_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_MEM_RULE1 - 0x4013 8000 ~0x4013 FFFF */
/*! @{ */

#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ENET_MASK (0x3U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ENET_SHIFT (0U)
/*! ENET - 0x4013 8000--0x4013 8FFF */
#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ENET(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ENET_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ENET_MASK)

#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_OSTIMER_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_OSTIMER_RULE3_SHIFT (12U)
/*! OSTIMER_RULE3 - 0x4013 B000--0x4013 BFFF */
#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_OSTIMER_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_OSTIMER_RULE3_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_OSTIMER_RULE3_MASK)

#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ROM_CTRL_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ROM_CTRL_RULE4_SHIFT (16U)
/*! ROM_CTRL_RULE4 - 0x4013 C000--0x4013 CFFF */
#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ROM_CTRL_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ROM_CTRL_RULE4_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ROM_CTRL_RULE4_MASK)

#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_MTR_TEST_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_MTR_TEST_RULE6_SHIFT (24U)
/*! MTR_TEST_RULE6 - 0x4013 E000--0x4013 EFFF */
#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_MTR_TEST_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_MTR_TEST_RULE6_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_MTR_TEST_RULE6_MASK)

#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ATX_TEST_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ATX_TEST_RULE7_SHIFT (28U)
/*! ATX_TEST_RULE7 - 0x4013 F000--0x4013 FFFF */
#define AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ATX_TEST_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ATX_TEST_RULE7_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE_MEM_RULE1_ATX_TEST_RULE7_MASK)
/*! @} */

/*! @name AHB_PERIPH2_SLAVE_RULE - 0x40140000--0x4014FFFF */
/*! @{ */

#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_USBOTG_MASK (0x3U)
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_USBOTG_SHIFT (0U)
/*! USBOTG - 0x40145000--0x40145FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_USBOTG(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_USBOTG_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_USBOTG_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_SCT_MASK (0x30U)
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_SCT_SHIFT (4U)
/*! SCT - 0x40146000--0x40146FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_SCT(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_SCT_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_SCT_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_GDMA_MASK (0x300U)
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_GDMA_SHIFT (8U)
/*! GDMA - 0x4014E000--0x4014EFFF */
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_GDMA(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_GDMA_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_GDMA_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_CDOG_MASK (0x30000U)
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_CDOG_SHIFT (16U)
/*! CDOG - 0x4014C000--0x4014C7FF */
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_CDOG(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_CDOG_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE_CDOG_MASK)
/*! @} */

/*! @name SECURITY_CTRL_MEM_RULE - 0x40148000--0x4014BFFF */
/*! @{ */

#define AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_SECURITY_CTRL_MEM_RULE_RULE3_MASK)
/*! @} */

/*! @name AHB_PERIPH3_SLAVE_RULE - the memory map is 0x40150000--0x40158FFF */
/*! @{ */

#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_PQ_COPRO_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_PQ_COPRO_RULE0_SHIFT (0U)
/*! PQ_COPRO_RULE0 - 0x40150000--0x40150FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_PQ_COPRO_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_PQ_COPRO_RULE0_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_PQ_COPRO_RULE0_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_SECURE_GPIO_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_SECURE_GPIO_RULE1_SHIFT (4U)
/*! SECURE_GPIO_RULE1 - 0x40154000--0x40157FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_SECURE_GPIO_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_SECURE_GPIO_RULE1_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_SECURE_GPIO_RULE1_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_SDIO_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_SDIO_RULE2_SHIFT (8U)
/*! SDIO_RULE2 - 0x40158000--0x40158FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_SDIO_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_SDIO_RULE2_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_SDIO_RULE2_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_HPU_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_HPU_RULE3_SHIFT (12U)
/*! HPU_RULE3 - 0x40154000--0x40157FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_HPU_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_HPU_RULE3_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_HPU_RULE3_MASK)

#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_PKC_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_PKC_RULE4_SHIFT (16U)
/*! PKC_RULE4 - 0x40158000--0x40158FFF */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_PKC_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_PKC_RULE4_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE_PKC_RULE4_MASK)
/*! @} */

/*! @name AON_MEM_RULE - 0x4015C000--0x4015FFFF */
/*! @{ */

#define AHB_SECURE_CTRL_AON_MEM_RULE_RULE0_MASK  (0x3U)
#define AHB_SECURE_CTRL_AON_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_AON_MEM_RULE_RULE0(x)    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AON_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_AON_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_AON_MEM_RULE_RULE1_MASK  (0x30U)
#define AHB_SECURE_CTRL_AON_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_AON_MEM_RULE_RULE1(x)    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AON_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_AON_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_AON_MEM_RULE_RULE2_MASK  (0x300U)
#define AHB_SECURE_CTRL_AON_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_AON_MEM_RULE_RULE2(x)    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AON_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_AON_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_AON_MEM_RULE_RULE3_MASK  (0x3000U)
#define AHB_SECURE_CTRL_AON_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_AON_MEM_RULE_RULE3(x)    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AON_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_AON_MEM_RULE_RULE3_MASK)
/*! @} */

/*! @name WLAN_S0_SLAVE_RULE - 0x41000000-0x4137FFFF, 3.5MB */
/*! @{ */

#define AHB_SECURE_CTRL_WLAN_S0_SLAVE_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_WLAN_S0_SLAVE_RULE_RULE0_SHIFT (0U)
/*! RULE0 - 0x41000000-0x4137FFFF, 3.5MB */
#define AHB_SECURE_CTRL_WLAN_S0_SLAVE_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_WLAN_S0_SLAVE_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_WLAN_S0_SLAVE_RULE_RULE0_MASK)
/*! @} */

/*! @name WLAN_S1_MEM_RULE - 0x41380000-0x413FFFFF, part0..0x41380000-0x413FFFFF, part3 */
/*! @{ */

#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_WLAN_S1_MEM_RULE */
#define AHB_SECURE_CTRL_WLAN_S1_MEM_RULE_COUNT   (4U)

/*! @name BLE_S0_SLAVE_RULE - 0x44000000-0x443BFFFF */
/*! @{ */

#define AHB_SECURE_CTRL_BLE_S0_SLAVE_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_BLE_S0_SLAVE_RULE_RULE0_SHIFT (0U)
/*! RULE0 - 0x44000000-0x443BFFFF */
#define AHB_SECURE_CTRL_BLE_S0_SLAVE_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BLE_S0_SLAVE_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_BLE_S0_SLAVE_RULE_RULE0_MASK)
/*! @} */

/*! @name BLE_S1_MEM_RULE - 0x443C0000-0x443FFFFF part0..0x443C0000-0x443FFFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_BLE_S1_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_BLE_S1_MEM_RULE */
#define AHB_SECURE_CTRL_BLE_S1_MEM_RULE_COUNT    (4U)

/*! @name SOC_TOP_MEM_RULE - 0x45000000-0x4500FFFF part0..0x45000000-0x4500FFFF part3 */
/*! @{ */

#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE0_MASK)

#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE1_MASK)

#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE2_MASK)

#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE3_MASK)

#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE4_MASK)

#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE5_MASK)

#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE6_MASK)

#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule0. it can be set when check_reg's write_lock is '0' */
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SOC_TOP_MEM_RULE */
#define AHB_SECURE_CTRL_SOC_TOP_MEM_RULE_COUNT   (4U)

/*! @name SEC_VIO_ADDR - most recent security violation address for AHB layer n */
/*! @{ */

#define AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_ADDR_MASK (0xFFFFFFFFU)
#define AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_ADDR_SHIFT (0U)
/*! SEC_VIO_ADDR - security violation address for AHB layer */
#define AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_ADDR(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_ADDR_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_ADDR_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_VIO_ADDR */
#define AHB_SECURE_CTRL_SEC_VIO_ADDR_COUNT       (20U)

/*! @name SEC_VIO_MISC_INFO - most recent security violation miscellaneous information for AHB layer n */
/*! @{ */

#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_SHIFT (0U)
/*! SEC_VIO_INFO_WRITE - security violation access read/write indicator, 0: read, 1: write */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_SHIFT (1U)
/*! SEC_VIO_INFO_DATA_ACCESS - security violation access data/code indicator, 0: code, 1 */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_MASK (0xF0U)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_SHIFT (4U)
/*! SEC_VIO_INFO_MASTER_SEC_LEVEL - bit [5:4]: master sec level and privilege level bit [7:6]: anti-pol value for master sec level and privilege level */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_MASK (0xF00U)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SHIFT (8U)
/*! SEC_VIO_INFO_MASTER - security violation master number */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_VIO_MISC_INFO */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_COUNT  (20U)

/*! @name SEC_VIO_INFO_VALID - security violation address/information registers valid flags */
/*! @{ */

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_SHIFT (0U)
/*! VIO_INFO_VALID0 - violation information valid flag for AHB layer 0. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_SHIFT (1U)
/*! VIO_INFO_VALID1 - violation information valid flag for AHB layer 1. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_MASK (0x4U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_SHIFT (2U)
/*! VIO_INFO_VALID2 - violation information valid flag for AHB layer 2. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_MASK (0x8U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_SHIFT (3U)
/*! VIO_INFO_VALID3 - violation information valid flag for AHB layer 3. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_MASK (0x10U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_SHIFT (4U)
/*! VIO_INFO_VALID4 - violation information valid flag for AHB layer 4. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_MASK (0x20U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_SHIFT (5U)
/*! VIO_INFO_VALID5 - violation information valid flag for AHB layer 5. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_MASK (0x40U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_SHIFT (6U)
/*! VIO_INFO_VALID6 - violation information valid flag for AHB layer 6. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_MASK (0x80U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_SHIFT (7U)
/*! VIO_INFO_VALID7 - violation information valid flag for AHB layer 7. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_MASK (0x100U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_SHIFT (8U)
/*! VIO_INFO_VALID8 - violation information valid flag for AHB layer 8. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_MASK (0x200U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_SHIFT (9U)
/*! VIO_INFO_VALID9 - violation information valid flag for AHB layer 9. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_MASK (0x400U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_SHIFT (10U)
/*! VIO_INFO_VALID10 - violation information valid flag for AHB layer 10. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_MASK (0x800U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_SHIFT (11U)
/*! VIO_INFO_VALID11 - violation information valid flag for AHB layer 11. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_MASK (0x1000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_SHIFT (12U)
/*! VIO_INFO_VALID12 - violation information valid flag for AHB layer 12. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID12(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_MASK (0x2000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_SHIFT (13U)
/*! VIO_INFO_VALID13 - violation information valid flag for AHB layer 13. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID13(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_MASK (0x4000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_SHIFT (14U)
/*! VIO_INFO_VALID14 - violation information valid flag for AHB layer 14. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID14(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_MASK (0x8000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_SHIFT (15U)
/*! VIO_INFO_VALID15 - violation information valid flag for AHB layer 15. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID15(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_MASK (0x10000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_SHIFT (16U)
/*! VIO_INFO_VALID16 - violation information valid flag for AHB layer 16. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID16(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_MASK (0x20000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_SHIFT (17U)
/*! VIO_INFO_VALID17 - violation information valid flag for AHB layer 17. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID17(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_MASK (0x40000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_SHIFT (18U)
/*! VIO_INFO_VALID18 - violation information valid flag for AHB layer 18. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID18(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_MASK)

#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID19_MASK (0x80000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID19_SHIFT (19U)
/*! VIO_INFO_VALID19 - violation information valid flag for AHB layer 19. 0: not valid. 1: valid (violation occurred). Write 1 to clear. */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID19(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID19_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID19_MASK)
/*! @} */

/*! @name SEC_GPIO_MASK0 - Secure GPIO mask for port 0 pins. This register is used to block leakage of Secure interface (GPIOs, I2C, UART configured as secure peripherals) pin states to non-secure world. */
/*! @{ */

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK_SHIFT (0U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK_SHIFT (1U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK_MASK (0x4U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK_SHIFT (2U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK_MASK (0x8U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK_SHIFT (3U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK_MASK (0x10U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK_SHIFT (4U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK_MASK (0x20U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK_SHIFT (5U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK_MASK (0x40U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK_SHIFT (6U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK_MASK (0x80U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK_SHIFT (7U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK_MASK (0x100U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK_SHIFT (8U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK_MASK (0x200U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK_SHIFT (9U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK_MASK (0x400U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK_SHIFT (10U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK_MASK (0x800U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK_SHIFT (11U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK_MASK (0x1000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK_SHIFT (12U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK_MASK (0x2000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK_SHIFT (13U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK_MASK (0x4000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK_SHIFT (14U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK_MASK (0x8000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK_SHIFT (15U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK_MASK (0x10000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK_SHIFT (16U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK_MASK (0x20000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK_SHIFT (17U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK_MASK (0x40000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK_SHIFT (18U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK_MASK (0x80000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK_SHIFT (19U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK_MASK (0x100000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK_SHIFT (20U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK_MASK (0x200000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK_SHIFT (21U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK_MASK (0x400000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK_SHIFT (22U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK_MASK (0x800000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK_SHIFT (23U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK_MASK (0x1000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK_SHIFT (24U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK_MASK (0x2000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK_SHIFT (25U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK_MASK (0x4000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK_SHIFT (26U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK_MASK (0x8000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK_SHIFT (27U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK_MASK (0x10000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK_SHIFT (28U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK_MASK (0x20000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK_SHIFT (29U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK_MASK (0x40000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK_SHIFT (30U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK_MASK (0x80000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK_SHIFT (31U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK_MASK)
/*! @} */

/*! @name SEC_GPIO_MASK1 - Secure GPIO mask for port 1 pins. */
/*! @{ */

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK_SHIFT (0U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK_SHIFT (1U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK_MASK (0x4U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK_SHIFT (2U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK_MASK (0x8U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK_SHIFT (3U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK_MASK (0x10U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK_SHIFT (4U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK_MASK (0x20U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK_SHIFT (5U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK_MASK (0x40U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK_SHIFT (6U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK_MASK (0x80U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK_SHIFT (7U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK_MASK (0x100U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK_SHIFT (8U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK_MASK (0x200U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK_SHIFT (9U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK_MASK (0x400U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK_SHIFT (10U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK_MASK (0x800U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK_SHIFT (11U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK_MASK (0x1000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK_SHIFT (12U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK_MASK (0x2000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK_SHIFT (13U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK_MASK (0x4000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK_SHIFT (14U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK_MASK (0x8000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK_SHIFT (15U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK_MASK (0x10000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK_SHIFT (16U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK_MASK (0x20000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK_SHIFT (17U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK_MASK (0x40000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK_SHIFT (18U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK_MASK (0x80000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK_SHIFT (19U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK_MASK (0x100000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK_SHIFT (20U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK_MASK (0x200000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK_SHIFT (21U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK_MASK (0x400000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK_SHIFT (22U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK_MASK (0x800000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK_SHIFT (23U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK_MASK (0x1000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK_SHIFT (24U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK_MASK (0x2000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK_SHIFT (25U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK_MASK (0x4000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK_SHIFT (26U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK_MASK (0x8000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK_SHIFT (27U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK_MASK (0x10000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK_SHIFT (28U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK_MASK (0x20000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK_SHIFT (29U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK_MASK (0x40000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK_SHIFT (30U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK_MASK)

#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK_MASK (0x80000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK_SHIFT (31U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK_MASK)
/*! @} */

/*! @name SEC_MASK_LOCK - sec_gp_reg write-lock bits */
/*! @{ */

#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GP_REG0_LOCK_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GP_REG0_LOCK_SHIFT (0U)
/*! SEC_GP_REG0_LOCK - 2'b10: sec_reg_reg0 can be written. All other values: sec_reg_reg0 can't be written. */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GP_REG0_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GP_REG0_LOCK_SHIFT)) & AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GP_REG0_LOCK_MASK)

#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GP_REG1_LOCK_MASK (0xCU)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GP_REG1_LOCK_SHIFT (2U)
/*! SEC_GP_REG1_LOCK - 2'b10: sec_reg_reg1 can be written. All other values: sec_reg_reg1 can't be written. */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GP_REG1_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GP_REG1_LOCK_SHIFT)) & AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GP_REG1_LOCK_MASK)
/*! @} */

/*! @name MASTER_SEC_LEVEL - master secure level register */
/*! @{ */

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_POWERQUAD_MASK (0x30U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_POWERQUAD_SHIFT (4U)
/*! POWERQUAD - master secure level control. */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_POWERQUAD(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_POWERQUAD_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_POWERQUAD_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA0_MASK (0xC0U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA0_SHIFT (6U)
/*! DMA0 - master secure level control. */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA0_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA0_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA1_MASK (0x300U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA1_SHIFT (8U)
/*! DMA1 - master secure level control. */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA1_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA1_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ELS_MASK (0xC00U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ELS_SHIFT (10U)
/*! ELS - master secure level control. */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ELS(x)  (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ELS_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ELS_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USB_MASK (0x3000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USB_SHIFT (12U)
/*! USB - master secure level control. */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USB(x)  (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USB_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USB_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PKC_MASK (0xC000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PKC_SHIFT (14U)
/*! PKC - master secure level control. */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PKC(x)  (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PKC_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PKC_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO_MASK (0x30000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO_SHIFT (16U)
/*! SDIO - master secure level control. */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ENET_MASK (0xC0000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ENET_SHIFT (18U)
/*! ENET - master secure level control. */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ENET(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ENET_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ENET_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_GDMA_MASK (0x300000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_GDMA_SHIFT (20U)
/*! GDMA - master secure level control. */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_GDMA(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_GDMA_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_GDMA_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_MASK (0xC0000000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_SHIFT (30U)
/*! MASTER_SEC_LEVEL_LOCK - master_sec_reg write-lock. When 2'b10, this register can be written.
 *    With any other value, this register can't be written.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_MASK)
/*! @} */

/*! @name MASTER_SEC_LEVEL_ANTI_POL - master secure level anti-pole register */
/*! @{ */

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_POWERQUAD_MASK (0x30U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_POWERQUAD_SHIFT (4U)
/*! POWERQUAD - master secure level control anti-pole value (i.e It must be written with the
 *    inverted value of the corresponding field in master_sec_reg).
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_POWERQUAD(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_POWERQUAD_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_POWERQUAD_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_DMA0_MASK (0xC0U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_DMA0_SHIFT (6U)
/*! DMA0 - master secure level control anti-pole value (i.e It must be written with the inverted
 *    value of the corresponding field in master_sec_reg).
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_DMA0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_DMA0_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_DMA0_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_DMA1_MASK (0x300U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_DMA1_SHIFT (8U)
/*! DMA1 - master secure level control anti-pole value (i.e It must be written with the inverted
 *    value of the corresponding field in master_sec_reg).
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_DMA1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_DMA1_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_DMA1_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_ELS_MASK (0xC00U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_ELS_SHIFT (10U)
/*! ELS - master secure level control anti-pole value (i.e It must be written with the inverted
 *    value of the corresponding field in master_sec_reg).
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_ELS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_ELS_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_ELS_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_USB_MASK (0x3000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_USB_SHIFT (12U)
/*! USB - master secure level control anti-pole value (i.e It must be written with the inverted
 *    value of the corresponding field in master_sec_reg).
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_USB(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_USB_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_USB_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_PKC_MASK (0xC000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_PKC_SHIFT (14U)
/*! PKC - master secure level control anti-pole value (i.e It must be written with the inverted
 *    value of the corresponding field in master_sec_reg).
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_PKC(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_PKC_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_PKC_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_SDIO_MASK (0x30000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_SDIO_SHIFT (16U)
/*! SDIO - master secure level control anti-pole value (i.e It must be written with the inverted
 *    value of the corresponding field in master_sec_reg).
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_SDIO(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_SDIO_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_SDIO_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_ENET_MASK (0xC0000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_ENET_SHIFT (18U)
/*! ENET - master secure level control anti-pole value (i.e It must be written with the inverted
 *    value of the corresponding field in master_sec_reg).
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_ENET(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_ENET_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_ENET_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_GDMA_MASK (0x300000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_GDMA_SHIFT (20U)
/*! GDMA - master secure level control anti-pole value (i.e It must be written with the inverted
 *    value of the corresponding field in master_sec_reg).
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_GDMA(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_GDMA_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_GDMA_MASK)

#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_MASTER_SEC_LEVEL_ANTIPOL_LOCK_MASK (0xC0000000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_MASTER_SEC_LEVEL_ANTIPOL_LOCK_SHIFT (30U)
/*! MASTER_SEC_LEVEL_ANTIPOL_LOCK - master_sec_antipol_reg register write-lock. When 2'b10, this
 *    register can be written. With any other value, this register can't be written.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_MASTER_SEC_LEVEL_ANTIPOL_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_MASTER_SEC_LEVEL_ANTIPOL_LOCK_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_ANTI_POL_MASTER_SEC_LEVEL_ANTIPOL_LOCK_MASK)
/*! @} */

/*! @name CM33_LOCK_REG - m33 lock control register */
/*! @{ */

#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_VTOR_MASK (0x3U)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_VTOR_SHIFT (0U)
/*! LOCK_NS_VTOR - 2'b10: m33 LOCKNSVTOR is 0. All other values: m33 LOCKNSVTOR is 1 */
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_VTOR(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_VTOR_SHIFT)) & AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_VTOR_MASK)

#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_MPU_MASK (0xCU)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_MPU_SHIFT (2U)
/*! LOCK_NS_MPU - 2'b10:m33 LOCKNSMPU is 0. All other values: m33 LOCKNSMPU is 1 */
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_MPU(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_MPU_SHIFT)) & AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_MPU_MASK)

#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_VTAIRCR_MASK (0x30U)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_VTAIRCR_SHIFT (4U)
/*! LOCK_S_VTAIRCR - 2'b10:m33 LOCKSVTAURCR is 0. All other values: m33 LOCKSVTAURCR is 1 */
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_VTAIRCR(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_VTAIRCR_SHIFT)) & AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_VTAIRCR_MASK)

#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_MPU_MASK (0xC0U)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_MPU_SHIFT (6U)
/*! LOCK_S_MPU - 2'b10:m33 LOCKSMPU is 0. All other values: m33 LOCKSMPU is 1 */
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_MPU(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_MPU_SHIFT)) & AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_MPU_MASK)

#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_SAU_MASK (0x300U)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_SAU_SHIFT (8U)
/*! LOCK_SAU - 2'b10:m33 LOCKSAU is 0. All other values: m33 LOCKSAU is 1 */
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_SAU(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_SAU_SHIFT)) & AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_SAU_MASK)

#define AHB_SECURE_CTRL_CM33_LOCK_REG_M33_LOCK_REG_LOCK_MASK (0xC0000000U)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_M33_LOCK_REG_LOCK_SHIFT (30U)
/*! M33_LOCK_REG_LOCK - 2'b10: this register can be written. All other values: this register can't be written */
#define AHB_SECURE_CTRL_CM33_LOCK_REG_M33_LOCK_REG_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CM33_LOCK_REG_M33_LOCK_REG_LOCK_SHIFT)) & AHB_SECURE_CTRL_CM33_LOCK_REG_M33_LOCK_REG_LOCK_MASK)
/*! @} */

/*! @name MISC_CTRL_DP_REG - secure control duplicate register */
/*! @{ */

#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK_MASK (0x3U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK_SHIFT (0U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK_MASK)

#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_MASK (0xCU)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_SHIFT (2U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_MASK)

#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_MASK (0x30U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_SHIFT (4U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_MASK)

#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_MASK (0xC0U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_SHIFT (6U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_MASK)

#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_MASK (0x300U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_SHIFT (8U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_MASK)

#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE_MASK (0xC00U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE_SHIFT (10U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE_MASK)

#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS_MASK (0xC000U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS_SHIFT (14U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS_MASK)
/*! @} */

/*! @name MISC_CTRL_REG - secure control register */
/*! @{ */

#define AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK_MASK (0x3U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK_SHIFT (0U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK_MASK)

#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_MASK (0xCU)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_SHIFT (2U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_MASK)

#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_MASK (0x30U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_SHIFT (4U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_MASK)

#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_MASK (0xC0U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_SHIFT (6U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_MASK)

#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_MASK (0x300U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_SHIFT (8U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_MASK)

#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_STRICT_MODE_MASK (0xC00U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_STRICT_MODE_SHIFT (10U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_STRICT_MODE(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_STRICT_MODE_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_STRICT_MODE_MASK)

#define AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS_MASK (0xC000U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS_SHIFT (14U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group AHB_SECURE_CTRL_Register_Masks */


/* AHB_SECURE_CTRL - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral AHB_SECURE_CTRL base address */
  #define AHB_SECURE_CTRL_BASE                     (0x50148000u)
  /** Peripheral AHB_SECURE_CTRL base address */
  #define AHB_SECURE_CTRL_BASE_NS                  (0x40148000u)
  /** Peripheral AHB_SECURE_CTRL base pointer */
  #define AHB_SECURE_CTRL                          ((AHB_SECURE_CTRL_Type *)AHB_SECURE_CTRL_BASE)
  /** Peripheral AHB_SECURE_CTRL base pointer */
  #define AHB_SECURE_CTRL_NS                       ((AHB_SECURE_CTRL_Type *)AHB_SECURE_CTRL_BASE_NS)
  /** Array initializer of AHB_SECURE_CTRL peripheral base addresses */
  #define AHB_SECURE_CTRL_BASE_ADDRS               { AHB_SECURE_CTRL_BASE }
  /** Array initializer of AHB_SECURE_CTRL peripheral base pointers */
  #define AHB_SECURE_CTRL_BASE_PTRS                { AHB_SECURE_CTRL }
  /** Array initializer of AHB_SECURE_CTRL peripheral base addresses */
  #define AHB_SECURE_CTRL_BASE_ADDRS_NS            { AHB_SECURE_CTRL_BASE_NS }
  /** Array initializer of AHB_SECURE_CTRL peripheral base pointers */
  #define AHB_SECURE_CTRL_BASE_PTRS_NS             { AHB_SECURE_CTRL_NS }
#else
  /** Peripheral AHB_SECURE_CTRL base address */
  #define AHB_SECURE_CTRL_BASE                     (0x40148000u)
  /** Peripheral AHB_SECURE_CTRL base pointer */
  #define AHB_SECURE_CTRL                          ((AHB_SECURE_CTRL_Type *)AHB_SECURE_CTRL_BASE)
  /** Array initializer of AHB_SECURE_CTRL peripheral base addresses */
  #define AHB_SECURE_CTRL_BASE_ADDRS               { AHB_SECURE_CTRL_BASE }
  /** Array initializer of AHB_SECURE_CTRL peripheral base pointers */
  #define AHB_SECURE_CTRL_BASE_PTRS                { AHB_SECURE_CTRL }
#endif

/*!
 * @}
 */ /* end of group AHB_SECURE_CTRL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AON_SOC_CIU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AON_SOC_CIU_Peripheral_Access_Layer AON_SOC_CIU Peripheral Access Layer
 * @{
 */

/** AON_SOC_CIU - Register Layout Typedef */
typedef struct {
  __IO uint32_t PAD_CONFIG0;                       /**< ", offset: 0x0 */
       uint8_t RESERVED_0[12];
  __IO uint32_t PAD_PWRDOWN_CTRL2;                 /**< Pad Power-down Control 2, offset: 0x10 */
       uint8_t RESERVED_1[60];
  __IO uint32_t SR_CONFIG1;                        /**< GPIO Slew Rate control, offset: 0x50 */
       uint8_t RESERVED_2[32];
  __IO uint32_t PAD_PU_PD_EN1;                     /**< Pad Pull-up Pull-down Enable2, offset: 0x74 */
       uint8_t RESERVED_3[20];
  __IO uint32_t PAD_SLP_EN0;                       /**< Pad Sleep Mode Enable, offset: 0x8C */
       uint8_t RESERVED_4[8];
  __IO uint32_t PAD_SLP_VAL0;                      /**< Pad Sleep Mode Value, offset: 0x98 */
       uint8_t RESERVED_5[112];
  __IO uint32_t RST_SW;                            /**< Reset Controls for SOC_RESET_GEN, offset: 0x10C */
       uint8_t RESERVED_6[32];
  __I  uint32_t STRAP_FINISH_STATUS;               /**< SOC Strap Finish Status, offset: 0x130 */
       uint8_t RESERVED_7[8];
  __IO uint32_t SOC_OTP_CONTROL;                   /**< Power Switch (1.8v) Control for SOC OTP, offset: 0x13C */
       uint8_t RESERVED_8[196];
  __IO uint32_t PAD_AON_VREG_VSENSOR_CTRL;         /**< AON Vsensor and Vreg Pad Control, offset: 0x204 */
       uint8_t RESERVED_9[632];
  __I  uint32_t STRAP_RDBK;                        /**< Strap Readback, offset: 0x480 */
  __IO uint32_t STRAP_SW;                          /**< Software Strap Override, offset: 0x484 */
       uint8_t RESERVED_10[120];
  __IO uint32_t PAD_SLP_PU_PD_DIS0;                /**< Pad Sleep Pullup and Pulldown Disable1, offset: 0x500 */
       uint8_t RESERVED_11[52];
  __IO uint32_t MCI_IOMUX_EN0;                     /**< mci_iomux_enable control for GPIO[27:22], offset: 0x538 */
} AON_SOC_CIU_Type;

/* ----------------------------------------------------------------------------
   -- AON_SOC_CIU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AON_SOC_CIU_Register_Masks AON_SOC_CIU Register Masks
 * @{
 */

/*! @name PAD_CONFIG0 - " */
/*! @{ */

#define AON_SOC_CIU_PAD_CONFIG0_PAD_PWRDOWN_LATCH_MASK (0x2U)
#define AON_SOC_CIU_PAD_CONFIG0_PAD_PWRDOWN_LATCH_SHIFT (1U)
/*! PAD_PWRDOWN_LATCH - Enables the pd_sel latching */
#define AON_SOC_CIU_PAD_CONFIG0_PAD_PWRDOWN_LATCH(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_CONFIG0_PAD_PWRDOWN_LATCH_SHIFT)) & AON_SOC_CIU_PAD_CONFIG0_PAD_PWRDOWN_LATCH_MASK)

#define AON_SOC_CIU_PAD_CONFIG0_XOSC_OD_EN_MASK  (0x20000U)
#define AON_SOC_CIU_PAD_CONFIG0_XOSC_OD_EN_SHIFT (17U)
/*! XOSC_OD_EN - Crystal Oscillator Enable Output Open-Drain Enable for GPIO[0] */
#define AON_SOC_CIU_PAD_CONFIG0_XOSC_OD_EN(x)    (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_CONFIG0_XOSC_OD_EN_SHIFT)) & AON_SOC_CIU_PAD_CONFIG0_XOSC_OD_EN_MASK)

#define AON_SOC_CIU_PAD_CONFIG0_XOSC_ENA_PAD_SEL_MASK (0x80000000U)
#define AON_SOC_CIU_PAD_CONFIG0_XOSC_ENA_PAD_SEL_SHIFT (31U)
/*! XOSC_ENA_PAD_SEL - xosc_ena_pads selection from CAU or mci_top */
#define AON_SOC_CIU_PAD_CONFIG0_XOSC_ENA_PAD_SEL(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_CONFIG0_XOSC_ENA_PAD_SEL_SHIFT)) & AON_SOC_CIU_PAD_CONFIG0_XOSC_ENA_PAD_SEL_MASK)
/*! @} */

/*! @name PAD_PWRDOWN_CTRL2 - Pad Power-down Control 2 */
/*! @{ */

#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO22_PD_SEL_MASK (0x7U)
#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO22_PD_SEL_SHIFT (0U)
/*! GPIO22_PD_SEL - Power Down Output Value for GPIO[22] Pad */
#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO22_PD_SEL(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO22_PD_SEL_SHIFT)) & AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO22_PD_SEL_MASK)

#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO23_PD_SEL_MASK (0x70U)
#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO23_PD_SEL_SHIFT (4U)
/*! GPIO23_PD_SEL - Power Down Output Value for GPIO[23] Pad */
#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO23_PD_SEL(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO23_PD_SEL_SHIFT)) & AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO23_PD_SEL_MASK)

#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO24_PD_SEL_MASK (0x700U)
#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO24_PD_SEL_SHIFT (8U)
/*! GPIO24_PD_SEL - Power Down Output Value for GPIO[24] Pad */
#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO24_PD_SEL(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO24_PD_SEL_SHIFT)) & AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO24_PD_SEL_MASK)

#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO25_PD_SEL_MASK (0x7000U)
#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO25_PD_SEL_SHIFT (12U)
/*! GPIO25_PD_SEL - Power Down Output Value for GPIO[25] Pad */
#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO25_PD_SEL(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO25_PD_SEL_SHIFT)) & AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO25_PD_SEL_MASK)

#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO26_PD_SEL_MASK (0x70000U)
#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO26_PD_SEL_SHIFT (16U)
/*! GPIO26_PD_SEL - Power Down Output Value for GPIO[26] Pad */
#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO26_PD_SEL(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO26_PD_SEL_SHIFT)) & AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO26_PD_SEL_MASK)

#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO27_PD_SEL_MASK (0x700000U)
#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO27_PD_SEL_SHIFT (20U)
/*! GPIO27_PD_SEL - Power Down Output Value for GPIO[27] Pad */
#define AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO27_PD_SEL(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO27_PD_SEL_SHIFT)) & AON_SOC_CIU_PAD_PWRDOWN_CTRL2_GPIO27_PD_SEL_MASK)
/*! @} */

/*! @name SR_CONFIG1 - GPIO Slew Rate control */
/*! @{ */

#define AON_SOC_CIU_SR_CONFIG1_GPIO22_SR_MASK    (0x3000U)
#define AON_SOC_CIU_SR_CONFIG1_GPIO22_SR_SHIFT   (12U)
/*! GPIO22_SR - Slew Rate Control for GPIO[22] */
#define AON_SOC_CIU_SR_CONFIG1_GPIO22_SR(x)      (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_SR_CONFIG1_GPIO22_SR_SHIFT)) & AON_SOC_CIU_SR_CONFIG1_GPIO22_SR_MASK)

#define AON_SOC_CIU_SR_CONFIG1_GPIO23_SR_MASK    (0xC000U)
#define AON_SOC_CIU_SR_CONFIG1_GPIO23_SR_SHIFT   (14U)
/*! GPIO23_SR - Slew Rate Control for GPIO[23] */
#define AON_SOC_CIU_SR_CONFIG1_GPIO23_SR(x)      (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_SR_CONFIG1_GPIO23_SR_SHIFT)) & AON_SOC_CIU_SR_CONFIG1_GPIO23_SR_MASK)

#define AON_SOC_CIU_SR_CONFIG1_GPIO24_SR_MASK    (0x30000U)
#define AON_SOC_CIU_SR_CONFIG1_GPIO24_SR_SHIFT   (16U)
/*! GPIO24_SR - Slew Rate Control for GPIO[24] */
#define AON_SOC_CIU_SR_CONFIG1_GPIO24_SR(x)      (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_SR_CONFIG1_GPIO24_SR_SHIFT)) & AON_SOC_CIU_SR_CONFIG1_GPIO24_SR_MASK)

#define AON_SOC_CIU_SR_CONFIG1_GPIO25_SR_MASK    (0xC0000U)
#define AON_SOC_CIU_SR_CONFIG1_GPIO25_SR_SHIFT   (18U)
/*! GPIO25_SR - Slew Rate Control for GPIO[25] */
#define AON_SOC_CIU_SR_CONFIG1_GPIO25_SR(x)      (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_SR_CONFIG1_GPIO25_SR_SHIFT)) & AON_SOC_CIU_SR_CONFIG1_GPIO25_SR_MASK)

#define AON_SOC_CIU_SR_CONFIG1_GPIO26_SR_MASK    (0x300000U)
#define AON_SOC_CIU_SR_CONFIG1_GPIO26_SR_SHIFT   (20U)
/*! GPIO26_SR - Slew Rate Control for GPIO[26] */
#define AON_SOC_CIU_SR_CONFIG1_GPIO26_SR(x)      (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_SR_CONFIG1_GPIO26_SR_SHIFT)) & AON_SOC_CIU_SR_CONFIG1_GPIO26_SR_MASK)

#define AON_SOC_CIU_SR_CONFIG1_GPIO27_SR_MASK    (0xC00000U)
#define AON_SOC_CIU_SR_CONFIG1_GPIO27_SR_SHIFT   (22U)
/*! GPIO27_SR - Slew Rate Control for GPIO[27] */
#define AON_SOC_CIU_SR_CONFIG1_GPIO27_SR(x)      (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_SR_CONFIG1_GPIO27_SR_SHIFT)) & AON_SOC_CIU_SR_CONFIG1_GPIO27_SR_MASK)
/*! @} */

/*! @name PAD_PU_PD_EN1 - Pad Pull-up Pull-down Enable2 */
/*! @{ */

#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO22_PU_PD_EN_MASK (0x3000U)
#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO22_PU_PD_EN_SHIFT (12U)
/*! GPIO22_PU_PD_EN - Internal Pd and Internal Pu Config for GPIO[22] */
#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO22_PU_PD_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_PU_PD_EN1_GPIO22_PU_PD_EN_SHIFT)) & AON_SOC_CIU_PAD_PU_PD_EN1_GPIO22_PU_PD_EN_MASK)

#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO23_PU_PD_EN_MASK (0xC000U)
#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO23_PU_PD_EN_SHIFT (14U)
/*! GPIO23_PU_PD_EN - Internal Pd and Internal Pu Config for GPIO[23] */
#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO23_PU_PD_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_PU_PD_EN1_GPIO23_PU_PD_EN_SHIFT)) & AON_SOC_CIU_PAD_PU_PD_EN1_GPIO23_PU_PD_EN_MASK)

#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO24_PU_PD_EN_MASK (0x30000U)
#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO24_PU_PD_EN_SHIFT (16U)
/*! GPIO24_PU_PD_EN - Internal Pd and Internal Pu Config for GPIO[24] */
#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO24_PU_PD_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_PU_PD_EN1_GPIO24_PU_PD_EN_SHIFT)) & AON_SOC_CIU_PAD_PU_PD_EN1_GPIO24_PU_PD_EN_MASK)

#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO25_PU_PD_EN_MASK (0xC0000U)
#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO25_PU_PD_EN_SHIFT (18U)
/*! GPIO25_PU_PD_EN - Internal Pd and Internal Pu Config for GPIO[25] */
#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO25_PU_PD_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_PU_PD_EN1_GPIO25_PU_PD_EN_SHIFT)) & AON_SOC_CIU_PAD_PU_PD_EN1_GPIO25_PU_PD_EN_MASK)

#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO26_PU_PD_EN_MASK (0x300000U)
#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO26_PU_PD_EN_SHIFT (20U)
/*! GPIO26_PU_PD_EN - Internal Pd and Internal Pu Config for GPIO[26] */
#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO26_PU_PD_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_PU_PD_EN1_GPIO26_PU_PD_EN_SHIFT)) & AON_SOC_CIU_PAD_PU_PD_EN1_GPIO26_PU_PD_EN_MASK)

#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO27_PU_PD_EN_MASK (0xC00000U)
#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO27_PU_PD_EN_SHIFT (22U)
/*! GPIO27_PU_PD_EN - Internal Pd and Internal Pu Config for GPIO[27] */
#define AON_SOC_CIU_PAD_PU_PD_EN1_GPIO27_PU_PD_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_PU_PD_EN1_GPIO27_PU_PD_EN_SHIFT)) & AON_SOC_CIU_PAD_PU_PD_EN1_GPIO27_PU_PD_EN_MASK)
/*! @} */

/*! @name PAD_SLP_EN0 - Pad Sleep Mode Enable */
/*! @{ */

#define AON_SOC_CIU_PAD_SLP_EN0_GPIO22_SLP_EN_MASK (0x400000U)
#define AON_SOC_CIU_PAD_SLP_EN0_GPIO22_SLP_EN_SHIFT (22U)
/*! GPIO22_SLP_EN - Enable Forcing GPIO[22] Output During Sleep */
#define AON_SOC_CIU_PAD_SLP_EN0_GPIO22_SLP_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_EN0_GPIO22_SLP_EN_SHIFT)) & AON_SOC_CIU_PAD_SLP_EN0_GPIO22_SLP_EN_MASK)

#define AON_SOC_CIU_PAD_SLP_EN0_GPIO23_SLP_EN_MASK (0x800000U)
#define AON_SOC_CIU_PAD_SLP_EN0_GPIO23_SLP_EN_SHIFT (23U)
/*! GPIO23_SLP_EN - Enable Forcing GPIO[23] Output During Sleep */
#define AON_SOC_CIU_PAD_SLP_EN0_GPIO23_SLP_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_EN0_GPIO23_SLP_EN_SHIFT)) & AON_SOC_CIU_PAD_SLP_EN0_GPIO23_SLP_EN_MASK)

#define AON_SOC_CIU_PAD_SLP_EN0_GPIO24_SLP_EN_MASK (0x1000000U)
#define AON_SOC_CIU_PAD_SLP_EN0_GPIO24_SLP_EN_SHIFT (24U)
/*! GPIO24_SLP_EN - Enable Forcing GPIO[24] Output During Sleep */
#define AON_SOC_CIU_PAD_SLP_EN0_GPIO24_SLP_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_EN0_GPIO24_SLP_EN_SHIFT)) & AON_SOC_CIU_PAD_SLP_EN0_GPIO24_SLP_EN_MASK)

#define AON_SOC_CIU_PAD_SLP_EN0_GPIO25_SLP_EN_MASK (0x2000000U)
#define AON_SOC_CIU_PAD_SLP_EN0_GPIO25_SLP_EN_SHIFT (25U)
/*! GPIO25_SLP_EN - Enable Forcing GPIO[25] Output During Sleep */
#define AON_SOC_CIU_PAD_SLP_EN0_GPIO25_SLP_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_EN0_GPIO25_SLP_EN_SHIFT)) & AON_SOC_CIU_PAD_SLP_EN0_GPIO25_SLP_EN_MASK)

#define AON_SOC_CIU_PAD_SLP_EN0_GPIO26_SLP_EN_MASK (0x4000000U)
#define AON_SOC_CIU_PAD_SLP_EN0_GPIO26_SLP_EN_SHIFT (26U)
/*! GPIO26_SLP_EN - Enable Forcing GPIO[26] Output During Sleep */
#define AON_SOC_CIU_PAD_SLP_EN0_GPIO26_SLP_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_EN0_GPIO26_SLP_EN_SHIFT)) & AON_SOC_CIU_PAD_SLP_EN0_GPIO26_SLP_EN_MASK)

#define AON_SOC_CIU_PAD_SLP_EN0_GPIO27_SLP_EN_MASK (0x8000000U)
#define AON_SOC_CIU_PAD_SLP_EN0_GPIO27_SLP_EN_SHIFT (27U)
/*! GPIO27_SLP_EN - Enable Forcing GPIO[27] Output During Sleep */
#define AON_SOC_CIU_PAD_SLP_EN0_GPIO27_SLP_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_EN0_GPIO27_SLP_EN_SHIFT)) & AON_SOC_CIU_PAD_SLP_EN0_GPIO27_SLP_EN_MASK)
/*! @} */

/*! @name PAD_SLP_VAL0 - Pad Sleep Mode Value */
/*! @{ */

#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO22_SLP_VAL_MASK (0x400000U)
#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO22_SLP_VAL_SHIFT (22U)
/*! GPIO22_SLP_VAL - Force GPIO[22] Output During Sleep */
#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO22_SLP_VAL(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_VAL0_GPIO22_SLP_VAL_SHIFT)) & AON_SOC_CIU_PAD_SLP_VAL0_GPIO22_SLP_VAL_MASK)

#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO23_SLP_VAL_MASK (0x800000U)
#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO23_SLP_VAL_SHIFT (23U)
/*! GPIO23_SLP_VAL - Force GPIO[23] Output During Sleep */
#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO23_SLP_VAL(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_VAL0_GPIO23_SLP_VAL_SHIFT)) & AON_SOC_CIU_PAD_SLP_VAL0_GPIO23_SLP_VAL_MASK)

#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO24_SLP_VAL_MASK (0x1000000U)
#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO24_SLP_VAL_SHIFT (24U)
/*! GPIO24_SLP_VAL - Force GPIO[24] Output During Sleep */
#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO24_SLP_VAL(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_VAL0_GPIO24_SLP_VAL_SHIFT)) & AON_SOC_CIU_PAD_SLP_VAL0_GPIO24_SLP_VAL_MASK)

#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO25_SLP_VAL_MASK (0x2000000U)
#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO25_SLP_VAL_SHIFT (25U)
/*! GPIO25_SLP_VAL - Force GPIO[25] Output During Sleep */
#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO25_SLP_VAL(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_VAL0_GPIO25_SLP_VAL_SHIFT)) & AON_SOC_CIU_PAD_SLP_VAL0_GPIO25_SLP_VAL_MASK)

#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO26_SLP_VAL_MASK (0x4000000U)
#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO26_SLP_VAL_SHIFT (26U)
/*! GPIO26_SLP_VAL - Force GPIO[26] Output During Sleep */
#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO26_SLP_VAL(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_VAL0_GPIO26_SLP_VAL_SHIFT)) & AON_SOC_CIU_PAD_SLP_VAL0_GPIO26_SLP_VAL_MASK)

#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO27_SLP_VAL_MASK (0x8000000U)
#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO27_SLP_VAL_SHIFT (27U)
/*! GPIO27_SLP_VAL - Force GPIO[27] Output During Sleep */
#define AON_SOC_CIU_PAD_SLP_VAL0_GPIO27_SLP_VAL(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_VAL0_GPIO27_SLP_VAL_SHIFT)) & AON_SOC_CIU_PAD_SLP_VAL0_GPIO27_SLP_VAL_MASK)
/*! @} */

/*! @name RST_SW - Reset Controls for SOC_RESET_GEN */
/*! @{ */

#define AON_SOC_CIU_RST_SW_BUCK_REG_RST_MASK     (0x200U)
#define AON_SOC_CIU_RST_SW_BUCK_REG_RST_SHIFT    (9U)
/*! BUCK_REG_RST - config reg SW reset for BUCK18 and BUCK11, active high */
#define AON_SOC_CIU_RST_SW_BUCK_REG_RST(x)       (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_RST_SW_BUCK_REG_RST_SHIFT)) & AON_SOC_CIU_RST_SW_BUCK_REG_RST_MASK)

#define AON_SOC_CIU_RST_SW_SOCAON_ITRC_CHIP_RSTB_EN_MASK (0x1000000U)
#define AON_SOC_CIU_RST_SW_SOCAON_ITRC_CHIP_RSTB_EN_SHIFT (24U)
/*! SOCAON_ITRC_CHIP_RSTB_EN - Default the itrc chip reset can reset SOCAON (jtag), SW can disable this if not required */
#define AON_SOC_CIU_RST_SW_SOCAON_ITRC_CHIP_RSTB_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_RST_SW_SOCAON_ITRC_CHIP_RSTB_EN_SHIFT)) & AON_SOC_CIU_RST_SW_SOCAON_ITRC_CHIP_RSTB_EN_MASK)

#define AON_SOC_CIU_RST_SW_AON_SOCCIU_RSTB_MASK  (0x2000000U)
#define AON_SOC_CIU_RST_SW_AON_SOCCIU_RSTB_SHIFT (25U)
/*! AON_SOCCIU_RSTB - reset for the aon socciu registers. It gets auto clear */
#define AON_SOC_CIU_RST_SW_AON_SOCCIU_RSTB(x)    (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_RST_SW_AON_SOCCIU_RSTB_SHIFT)) & AON_SOC_CIU_RST_SW_AON_SOCCIU_RSTB_MASK)
/*! @} */

/*! @name STRAP_FINISH_STATUS - SOC Strap Finish Status */
/*! @{ */

#define AON_SOC_CIU_STRAP_FINISH_STATUS_STRAP_FINISH_MASK (0x1U)
#define AON_SOC_CIU_STRAP_FINISH_STATUS_STRAP_FINISH_SHIFT (0U)
/*! STRAP_FINISH - Strap Finish status from strap logic. */
#define AON_SOC_CIU_STRAP_FINISH_STATUS_STRAP_FINISH(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_FINISH_STATUS_STRAP_FINISH_SHIFT)) & AON_SOC_CIU_STRAP_FINISH_STATUS_STRAP_FINISH_MASK)
/*! @} */

/*! @name SOC_OTP_CONTROL - Power Switch (1.8v) Control for SOC OTP */
/*! @{ */

#define AON_SOC_CIU_SOC_OTP_CONTROL_SOC_OTP_PSW18_PD_MASK (0x1U)
#define AON_SOC_CIU_SOC_OTP_CONTROL_SOC_OTP_PSW18_PD_SHIFT (0U)
/*! SOC_OTP_PSW18_PD - Power-Down control for the 1.8V Power-Switch for OTPs on SOC side */
#define AON_SOC_CIU_SOC_OTP_CONTROL_SOC_OTP_PSW18_PD(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_SOC_OTP_CONTROL_SOC_OTP_PSW18_PD_SHIFT)) & AON_SOC_CIU_SOC_OTP_CONTROL_SOC_OTP_PSW18_PD_MASK)
/*! @} */

/*! @name PAD_AON_VREG_VSENSOR_CTRL - AON Vsensor and Vreg Pad Control */
/*! @{ */

#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VIO_REG_ENB_MASK (0x1U)
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VIO_REG_ENB_SHIFT (0U)
/*! VIO_REG_ENB - VIO_AON Pad Regulator */
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VIO_REG_ENB(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VIO_REG_ENB_SHIFT)) & AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VIO_REG_ENB_MASK)

#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VIO_REG_CTRL_EN_MASK (0x2U)
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VIO_REG_CTRL_EN_SHIFT (1U)
/*! VIO_REG_CTRL_EN - VIO reg control enable function */
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VIO_REG_CTRL_EN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VIO_REG_CTRL_EN_SHIFT)) & AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VIO_REG_CTRL_EN_MASK)

#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_BYPASS_MASK (0x10U)
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_BYPASS_SHIFT (4U)
/*! VSENSOR_BYPASS - Active High Enable Signal for Bypass Mode */
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_BYPASS(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_BYPASS_SHIFT)) & AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_BYPASS_MASK)

#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_V18EN_12_IN_MASK (0x20U)
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_V18EN_12_IN_SHIFT (5U)
/*! VSENSOR_V18EN_12_IN - Bypass Value when Vsensor_Bypass Bit Set */
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_V18EN_12_IN(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_V18EN_12_IN_SHIFT)) & AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_V18EN_12_IN_MASK)

#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_DISABLE_12_MASK (0x40U)
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_DISABLE_12_SHIFT (6U)
/*! VSENSOR_DISABLE_12 - Vsensor AON disable */
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_DISABLE_12(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_DISABLE_12_SHIFT)) & AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_DISABLE_12_MASK)

#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_CLK_12_MASK (0x80U)
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_CLK_12_SHIFT (7U)
/*! VSENSOR_CLK_12 - Vsensor AON Clock */
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_CLK_12(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_CLK_12_SHIFT)) & AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_CLK_12_MASK)

#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_TE_MASK (0x100U)
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_TE_SHIFT (8U)
/*! VSENSOR_TE - Vsensor AON Test Enable */
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_TE(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_TE_SHIFT)) & AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_TE_MASK)

#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_TEST_MASK (0xE00U)
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_TEST_SHIFT (9U)
/*! VSENSOR_TEST - Vsensor AON Test Point Mux Selection */
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_TEST(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_TEST_SHIFT)) & AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_TEST_MASK)

#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_VTHRESH_MASK (0x1000U)
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_VTHRESH_SHIFT (12U)
/*! VSENSOR_VTHRESH - Vsensor AON Detection Threshold */
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_VTHRESH(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_VTHRESH_SHIFT)) & AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_VTHRESH_MASK)

#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_V25EN_CORE_MASK (0x2000U)
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_V25EN_CORE_SHIFT (13U)
/*! V25EN_CORE - V25EN_CORE */
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_V25EN_CORE(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_V25EN_CORE_SHIFT)) & AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_V25EN_CORE_MASK)

#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_DETECT_MASK (0x4000U)
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_DETECT_SHIFT (14U)
/*! VSENSOR_DETECT - VIO_AON_Vsensor_Detect_V18 Status */
#define AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_DETECT(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_DETECT_SHIFT)) & AON_SOC_CIU_PAD_AON_VREG_VSENSOR_CTRL_VSENSOR_DETECT_MASK)
/*! @} */

/*! @name STRAP_RDBK - Strap Readback */
/*! @{ */

#define AON_SOC_CIU_STRAP_RDBK_MODE_MASK         (0xFU)
#define AON_SOC_CIU_STRAP_RDBK_MODE_SHIFT        (0U)
/*! MODE - Boot Options: */
#define AON_SOC_CIU_STRAP_RDBK_MODE(x)           (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_RDBK_MODE_SHIFT)) & AON_SOC_CIU_STRAP_RDBK_MODE_MASK)

#define AON_SOC_CIU_STRAP_RDBK_REF_CLK_DETECT_MASK (0x10U)
#define AON_SOC_CIU_STRAP_RDBK_REF_CLK_DETECT_SHIFT (4U)
/*! REF_CLK_DETECT - ref_clk_detect (reserved) */
#define AON_SOC_CIU_STRAP_RDBK_REF_CLK_DETECT(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_RDBK_REF_CLK_DETECT_SHIFT)) & AON_SOC_CIU_STRAP_RDBK_REF_CLK_DETECT_MASK)

#define AON_SOC_CIU_STRAP_RDBK_XOSC_SEL_MASK     (0x60U)
#define AON_SOC_CIU_STRAP_RDBK_XOSC_SEL_SHIFT    (5U)
/*! XOSC_SEL - Crystal Osc Enable */
#define AON_SOC_CIU_STRAP_RDBK_XOSC_SEL(x)       (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_RDBK_XOSC_SEL_SHIFT)) & AON_SOC_CIU_STRAP_RDBK_XOSC_SEL_MASK)

#define AON_SOC_CIU_STRAP_RDBK_VTOR_SEL_MASK     (0x80U)
#define AON_SOC_CIU_STRAP_RDBK_VTOR_SEL_SHIFT    (7U)
/*! VTOR_SEL - Strap bit to select secure VTOR base addr of CM33 */
#define AON_SOC_CIU_STRAP_RDBK_VTOR_SEL(x)       (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_RDBK_VTOR_SEL_SHIFT)) & AON_SOC_CIU_STRAP_RDBK_VTOR_SEL_MASK)

#define AON_SOC_CIU_STRAP_RDBK_DIS_KEY_ROT_DBG_MASK (0x100U)
#define AON_SOC_CIU_STRAP_RDBK_DIS_KEY_ROT_DBG_SHIFT (8U)
/*! DIS_KEY_ROT_DBG - dis_key_rot_dbg */
#define AON_SOC_CIU_STRAP_RDBK_DIS_KEY_ROT_DBG(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_RDBK_DIS_KEY_ROT_DBG_SHIFT)) & AON_SOC_CIU_STRAP_RDBK_DIS_KEY_ROT_DBG_MASK)

#define AON_SOC_CIU_STRAP_RDBK_DAP_USE_JTAG_MASK (0x800U)
#define AON_SOC_CIU_STRAP_RDBK_DAP_USE_JTAG_SHIFT (11U)
/*! DAP_USE_JTAG - 1 (Default): DAP uses JTAG */
#define AON_SOC_CIU_STRAP_RDBK_DAP_USE_JTAG(x)   (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_RDBK_DAP_USE_JTAG_SHIFT)) & AON_SOC_CIU_STRAP_RDBK_DAP_USE_JTAG_MASK)

#define AON_SOC_CIU_STRAP_RDBK_QFN_BOND_MASK     (0x4000U)
#define AON_SOC_CIU_STRAP_RDBK_QFN_BOND_SHIFT    (14U)
/*! QFN_BOND - Bond Strap Value */
#define AON_SOC_CIU_STRAP_RDBK_QFN_BOND(x)       (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_RDBK_QFN_BOND_SHIFT)) & AON_SOC_CIU_STRAP_RDBK_QFN_BOND_MASK)

#define AON_SOC_CIU_STRAP_RDBK_REF_CLK_RATE_MASK (0xF00000U)
#define AON_SOC_CIU_STRAP_RDBK_REF_CLK_RATE_SHIFT (20U)
/*! REF_CLK_RATE - CAU Reference Clock Rate */
#define AON_SOC_CIU_STRAP_RDBK_REF_CLK_RATE(x)   (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_RDBK_REF_CLK_RATE_SHIFT)) & AON_SOC_CIU_STRAP_RDBK_REF_CLK_RATE_MASK)
/*! @} */

/*! @name STRAP_SW - Software Strap Override */
/*! @{ */

#define AON_SOC_CIU_STRAP_SW_MODE_MASK           (0xFU)
#define AON_SOC_CIU_STRAP_SW_MODE_SHIFT          (0U)
/*! MODE - Below are the modes selected based on the value of this field: */
#define AON_SOC_CIU_STRAP_SW_MODE(x)             (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_SW_MODE_SHIFT)) & AON_SOC_CIU_STRAP_SW_MODE_MASK)

#define AON_SOC_CIU_STRAP_SW_XOSC_SEL_MASK       (0x60U)
#define AON_SOC_CIU_STRAP_SW_XOSC_SEL_SHIFT      (5U)
/*! XOSC_SEL - Crystal Osc Enable */
#define AON_SOC_CIU_STRAP_SW_XOSC_SEL(x)         (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_SW_XOSC_SEL_SHIFT)) & AON_SOC_CIU_STRAP_SW_XOSC_SEL_MASK)

#define AON_SOC_CIU_STRAP_SW_QFN_BOND_MASK       (0x4000U)
#define AON_SOC_CIU_STRAP_SW_QFN_BOND_SHIFT      (14U)
/*! QFN_BOND - Bond Type */
#define AON_SOC_CIU_STRAP_SW_QFN_BOND(x)         (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_SW_QFN_BOND_SHIFT)) & AON_SOC_CIU_STRAP_SW_QFN_BOND_MASK)

#define AON_SOC_CIU_STRAP_SW_REF_CLK_RATE_MASK   (0xF00000U)
#define AON_SOC_CIU_STRAP_SW_REF_CLK_RATE_SHIFT  (20U)
/*! REF_CLK_RATE - CAU Reference Clock Rate */
#define AON_SOC_CIU_STRAP_SW_REF_CLK_RATE(x)     (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_SW_REF_CLK_RATE_SHIFT)) & AON_SOC_CIU_STRAP_SW_REF_CLK_RATE_MASK)

#define AON_SOC_CIU_STRAP_SW_ENABLE_MASK         (0x80000000U)
#define AON_SOC_CIU_STRAP_SW_ENABLE_SHIFT        (31U)
/*! ENABLE - Software Strap Mode Enable */
#define AON_SOC_CIU_STRAP_SW_ENABLE(x)           (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_STRAP_SW_ENABLE_SHIFT)) & AON_SOC_CIU_STRAP_SW_ENABLE_MASK)
/*! @} */

/*! @name PAD_SLP_PU_PD_DIS0 - Pad Sleep Pullup and Pulldown Disable1 */
/*! @{ */

#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO22_PU_PD_DIS_MASK (0x400000U)
#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO22_PU_PD_DIS_SHIFT (22U)
/*! GPIO22_PU_PD_DIS - Internal Pd and Internal Pu Disable for GPIO[22] During Sleep Mode */
#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO22_PU_PD_DIS(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO22_PU_PD_DIS_SHIFT)) & AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO22_PU_PD_DIS_MASK)

#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO23_PU_PD_DIS_MASK (0x800000U)
#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO23_PU_PD_DIS_SHIFT (23U)
/*! GPIO23_PU_PD_DIS - Internal Pd and Internal Pu Disable for GPIO[23] During Sleep Mode */
#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO23_PU_PD_DIS(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO23_PU_PD_DIS_SHIFT)) & AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO23_PU_PD_DIS_MASK)

#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO24_PU_PD_DIS_MASK (0x1000000U)
#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO24_PU_PD_DIS_SHIFT (24U)
/*! GPIO24_PU_PD_DIS - Internal Pd and Internal Pu Disable for GPIO[24] During Sleep Mode */
#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO24_PU_PD_DIS(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO24_PU_PD_DIS_SHIFT)) & AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO24_PU_PD_DIS_MASK)

#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO25_PU_PD_DIS_MASK (0x2000000U)
#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO25_PU_PD_DIS_SHIFT (25U)
/*! GPIO25_PU_PD_DIS - Internal Pd and Internal Pu Disable for GPIO[25] During Sleep Mode */
#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO25_PU_PD_DIS(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO25_PU_PD_DIS_SHIFT)) & AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO25_PU_PD_DIS_MASK)

#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO26_PU_PD_DIS_MASK (0x4000000U)
#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO26_PU_PD_DIS_SHIFT (26U)
/*! GPIO26_PU_PD_DIS - Internal Pd and Internal Pu Disable for GPIO[26] During Sleep Mode */
#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO26_PU_PD_DIS(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO26_PU_PD_DIS_SHIFT)) & AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO26_PU_PD_DIS_MASK)

#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO27_PU_PD_DIS_MASK (0x8000000U)
#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO27_PU_PD_DIS_SHIFT (27U)
/*! GPIO27_PU_PD_DIS - Internal Pd and Internal Pu Disable for GPIO[27] During Sleep Mode */
#define AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO27_PU_PD_DIS(x) (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO27_PU_PD_DIS_SHIFT)) & AON_SOC_CIU_PAD_SLP_PU_PD_DIS0_GPIO27_PU_PD_DIS_MASK)
/*! @} */

/*! @name MCI_IOMUX_EN0 - mci_iomux_enable control for GPIO[27:22] */
/*! @{ */

#define AON_SOC_CIU_MCI_IOMUX_EN0_EN_27_22_MASK  (0xFC00000U)
#define AON_SOC_CIU_MCI_IOMUX_EN0_EN_27_22_SHIFT (22U)
/*! EN_27_22 - Bitwise enable control for mci_io_mux GPIO[27:22] */
#define AON_SOC_CIU_MCI_IOMUX_EN0_EN_27_22(x)    (((uint32_t)(((uint32_t)(x)) << AON_SOC_CIU_MCI_IOMUX_EN0_EN_27_22_SHIFT)) & AON_SOC_CIU_MCI_IOMUX_EN0_EN_27_22_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group AON_SOC_CIU_Register_Masks */


/* AON_SOC_CIU - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral AON_SOC_CIU base address */
  #define AON_SOC_CIU_BASE                         (0x55000800u)
  /** Peripheral AON_SOC_CIU base address */
  #define AON_SOC_CIU_BASE_NS                      (0x45000800u)
  /** Peripheral AON_SOC_CIU base pointer */
  #define AON_SOC_CIU                              ((AON_SOC_CIU_Type *)AON_SOC_CIU_BASE)
  /** Peripheral AON_SOC_CIU base pointer */
  #define AON_SOC_CIU_NS                           ((AON_SOC_CIU_Type *)AON_SOC_CIU_BASE_NS)
  /** Array initializer of AON_SOC_CIU peripheral base addresses */
  #define AON_SOC_CIU_BASE_ADDRS                   { AON_SOC_CIU_BASE }
  /** Array initializer of AON_SOC_CIU peripheral base pointers */
  #define AON_SOC_CIU_BASE_PTRS                    { AON_SOC_CIU }
  /** Array initializer of AON_SOC_CIU peripheral base addresses */
  #define AON_SOC_CIU_BASE_ADDRS_NS                { AON_SOC_CIU_BASE_NS }
  /** Array initializer of AON_SOC_CIU peripheral base pointers */
  #define AON_SOC_CIU_BASE_PTRS_NS                 { AON_SOC_CIU_NS }
#else
  /** Peripheral AON_SOC_CIU base address */
  #define AON_SOC_CIU_BASE                         (0x45000800u)
  /** Peripheral AON_SOC_CIU base pointer */
  #define AON_SOC_CIU                              ((AON_SOC_CIU_Type *)AON_SOC_CIU_BASE)
  /** Array initializer of AON_SOC_CIU peripheral base addresses */
  #define AON_SOC_CIU_BASE_ADDRS                   { AON_SOC_CIU_BASE }
  /** Array initializer of AON_SOC_CIU peripheral base pointers */
  #define AON_SOC_CIU_BASE_PTRS                    { AON_SOC_CIU }
#endif

/*!
 * @}
 */ /* end of group AON_SOC_CIU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- APU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup APU_Peripheral_Access_Layer APU Peripheral Access Layer
 * @{
 */

/** APU - Register Layout Typedef */
typedef struct {
  __I  uint32_t APU_IP_REVISION;                   /**< APU IP revision, offset: 0x0 */
  __IO uint32_t CTRL;                              /**< Control, offset: 0x4 */
  __IO uint32_t TIMER_PWR_MODE;                    /**< Timer Power Mode, offset: 0x8 */
  __IO uint32_t PWR_CTRL;                          /**< Power Control, offset: 0xC */
  __IO uint32_t PLL_CTRL;                          /**< PLL Control, offset: 0x10 */
  __IO uint32_t PLL_DIS_CNT;                       /**< PLL Disable Count, offset: 0x14 */
  __IO uint32_t STABLE_CNT;                        /**< Stable Count, offset: 0x18 */
  __IO uint32_t CPU1_HOST_WKUP_MASK;               /**< CPU1 Host Wakeup Mask, offset: 0x1C */
  __IO uint32_t CPU1_HOST_WKUP_POL;                /**< CPU1 Host Wakeup Polarity, offset: 0x20 */
  __I  uint32_t CAL_WIN_CNT;                       /**< Calibration Window Count, offset: 0x24 */
  __I  uint32_t AUTO_10US;                         /**< Auto 10us, offset: 0x28 */
  __I  uint32_t ACC_CNT;                           /**< Accumulation Count, offset: 0x2C */
  __IO uint32_t CAL_WIN_SIZE;                      /**< Calibration Window Size, offset: 0x30 */
  __I  uint32_t SLP_CLK_TIMER;                     /**< Sleep Clock Timer, offset: 0x34 */
  __I  uint32_t STATUS_RD;                         /**< Status Read, offset: 0x38 */
  __IO uint32_t STABLE_CNT2;                       /**< Stable Count 2, offset: 0x3C */
  __IO uint32_t DYN_PLL_MASK;                      /**< Dynamic PLL Mask, offset: 0x40 */
  __I  uint32_t TESTBUS_RD1;                       /**< Testbus Read 1, offset: 0x44 */
  __I  uint32_t TESTBUS_RD2;                       /**< Testbus Read 2, offset: 0x48 */
  __IO uint32_t GENERIC_TIMER_CNT;                 /**< Generic Timer Count, offset: 0x4C */
  __IO uint32_t CPU1_HOST_WKUP_CTRL;               /**< CPU1 Host Wakeup Control, offset: 0x50 */
  __IO uint32_t DYN_PLL_CLK_EXT_CTRL;              /**< Dynamic PLL Clock Ext Control, offset: 0x54 */
  __IO uint32_t GENERIC_SLP_START_VAL;             /**< Generic Sleep Start Value, offset: 0x58 */
  __IO uint32_t DLY_HOST_CTRL;                     /**< Delay Host Control, offset: 0x5C */
  __I  uint32_t HOST_WKUP_CNT;                     /**< Host Wakeup Count, offset: 0x60 */
  __IO uint32_t CPU2_HOST_WKUP_MASK;               /**< CPU2 Host Wakeup Mask, offset: 0x64 */
  __IO uint32_t CPU2_HOST_WKUP_POL;                /**< CPU2 Host Wakeup Polarity, offset: 0x68 */
  __IO uint32_t CPU2_HOST_WKUP_CTRL;               /**< CPU2 Host Wakeup Control, offset: 0x6C */
  __IO uint32_t CPU2_CTRL;                         /**< CPU2 Control, offset: 0x70 */
  __IO uint32_t WLAN_PWR_CTRL_DLY;                 /**< Wlan domain FSM Power Control Delay, offset: 0x74 */
  __I  uint32_t STATUS2;                           /**< Status 2, offset: 0x78 */
  __IO uint32_t WLAN_PWR_CTRL_DLY2;                /**< Wlan domain FSM Power Control Delay 2, offset: 0x7C */
  __IO uint32_t WL_CTRL;                           /**< WLAN Control, offset: 0x80 */
  __IO uint32_t WL_WKUP_MASK;                      /**< WLAN Wakeup Mask, offset: 0x84 */
  __I  uint32_t WL_STATUS;                         /**< WLAN Status, offset: 0x88 */
  __I  uint32_t WL_ALARM_RD;                       /**< WLAN Alarm Readback, offset: 0x8C */
  __IO uint32_t WL_BCN_XP_ALARM;                   /**< WLAN Beacon Alarm, offset: 0x90 */
  __IO uint32_t WL_BCN_INTR_ALARM;                 /**< WLAN Beacon Interrupt Alarm, offset: 0x94 */
  __IO uint32_t WL_HOST_INTR_ALARM;                /**< WLAN Host Interrupt Alarm, offset: 0x98 */
  __IO uint32_t WL_BCN_PLL_ALARM;                  /**< WLAN Beacon PLL Alarm, offset: 0x9C */
  __IO uint32_t TSF_REF_FACTOR;                    /**< TSF Reference Factor, offset: 0xA0 */
  __IO uint32_t TSF_SLEEP_FACTOR;                  /**< TSF Sleep Factor, offset: 0xA4 */
  __IO uint32_t BBUD_UDR_ISO_CNT;                  /**< BBUD UDR ISO Count, offset: 0xA8 */
  __IO uint32_t WL_DVFS_CTRL;                      /**< WLAN DVFS Control, offset: 0xAC */
  __IO uint32_t WL_CTRL2;                          /**< WLAN Control 2, offset: 0xB0 */
  __IO uint32_t WL_WKUP_MASK2;                     /**< WLAN Wakeup Mask 2, offset: 0xB4 */
  __I  uint32_t WL_STATUS2;                        /**< WLAN Status 2, offset: 0xB8 */
  __I  uint32_t WL_ALARM_RD2;                      /**< WLAN Alarm Readback 2, offset: 0xBC */
  __IO uint32_t WL_BCN_XP_ALARM2;                  /**< WLAN Beacon XP Alarm 2, offset: 0xC0 */
  __IO uint32_t WL_BCN_INTR_ALARM2;                /**< WLAN Beacon Interrupt Alarm 2, offset: 0xC4 */
  __IO uint32_t WL_HOST_INTR_ALARM2;               /**< WLAN Host Interrupt Alarm 2, offset: 0xC8 */
  __IO uint32_t WL_BCN_PLL_ALARM2;                 /**< WLAN Beacon PLL Alarm 2, offset: 0xCC */
  __IO uint32_t WLCOMN_PWR_CTRL;                   /**< WLAN Comm Powerup Control, offset: 0xD0 */
  __I  uint32_t WLCOMN_STATUS;                     /**< WLAN Comm Status, offset: 0xD4 */
       uint8_t RESERVED_0[8];
  __IO uint32_t BT_CTRL;                           /**< Bluetooth Control, offset: 0xE0 */
  __IO uint32_t BT_WKUP_MASK;                      /**< Bluetooth Wakeup Mask, offset: 0xE4 */
  __I  uint32_t BT_STATUS;                         /**< Bluetooth Status, offset: 0xE8 */
  __IO uint32_t BT_CKEN_CTRL;                      /**< Bluetooth Clock Enable Control, offset: 0xEC */
  __IO uint32_t BT_RESRC_CTRL;                     /**< Bluetooth RESRC Control, offset: 0xF0 */
  __IO uint32_t BT_DVFS_CTRL;                      /**< Bluetooth DVFS Control, offset: 0xF4 */
       uint8_t RESERVED_1[8];
  __IO uint32_t FM_CTRL;                           /**< FM Control, offset: 0x100 */
  __IO uint32_t FM_WKUP_MASK;                      /**< FM Wakeup Mask, offset: 0x104 */
  __I  uint32_t FM_STATUS;                         /**< FM Status, offset: 0x108 */
  __IO uint32_t FM_CKEN_CTRL;                      /**< FM Clock Enable Control, offset: 0x10C */
  __IO uint32_t FM_RESRC_CTRL;                     /**< FM RESRC Control, offset: 0x110 */
  __IO uint32_t FM_DVFS_CTRL;                      /**< FM DVFS Control, offset: 0x114 */
       uint8_t RESERVED_2[8];
  __IO uint32_t USB_PWR_CTRL_DLY;                  /**< USB FSM Power Control Delay, offset: 0x120 */
  __IO uint32_t USB_PWR_CTRL_DLY2;                 /**< USB FSM Power Control Delay 2, offset: 0x124 */
  __IO uint32_t WLCOMN_PWR_CTRL_DLY;               /**< Wlan common domain FSM Power Control Delay, offset: 0x128 */
  __IO uint32_t WLCOMN_PWR_CTRL_DLY2;              /**< Wlan common domain FSM Power Control Delay 2, offset: 0x12C */
       uint8_t RESERVED_3[16];
  __IO uint32_t BLE_CTRL;                          /**< BLE Control, offset: 0x140 */
  __IO uint32_t BLE_WKUP_MASK;                     /**< BLE Wakeup Mask, offset: 0x144 */
  __I  uint32_t BLE_STATUS;                        /**< BLE Status, offset: 0x148 */
       uint8_t RESERVED_4[20];
  __IO uint32_t NFC_CTRL;                          /**< NFC Control, offset: 0x160 */
  __IO uint32_t NFC_WKUP_MASK;                     /**< NFC Wakeup Mask, offset: 0x164 */
  __I  uint32_t NFC_STATUS;                        /**< NFC Status, offset: 0x168 */
  __IO uint32_t NFC_CKEN_CTRL;                     /**< NFC Clock Enable Control, offset: 0x16C */
  __IO uint32_t NFC_RESRC_CTRL;                    /**< NFC RESRC Control, offset: 0x170 */
  __IO uint32_t NFC_DVFS_CTRL;                     /**< NFC DVFS Control, offset: 0x174 */
       uint8_t RESERVED_5[8];
  __IO uint32_t FP4_CTRL;                          /**< FP4(15.4) Control, offset: 0x180 */
  __IO uint32_t FP4_WKUP_MASK;                     /**< FP4 Wakeup Mask, offset: 0x184 */
  __I  uint32_t FP4_STATUS;                        /**< FP4 Status, offset: 0x188 */
  __IO uint32_t FP4_CKEN_CTRL;                     /**< FP4 Clock Enable Control, offset: 0x18C */
  __IO uint32_t FP4_RESRC_CTRL;                    /**< FP4 RESRC Control, offset: 0x190 */
  __IO uint32_t FP4_DVFS_CTRL;                     /**< FP4 DVFS Control, offset: 0x194 */
  __IO uint32_t CPU2_FP4_HOST_WKUP_MASK;           /**< CPU2 15.4 Host Wakeup Mask, offset: 0x198 */
  __IO uint32_t CPU2_FP4_HOST_WKUP_POL;            /**< CPU2 15.4 Host Wakeup Polarity, offset: 0x19C */
  __IO uint32_t CPU2_FP4_HOST_WKUP_CTRL;           /**< CPU2 15.4 Host Wakeup Control, offset: 0x1A0 */
  __IO uint32_t HW_IP_ACTIVE_INDEX_CTRL;           /**< HW IP active index Control, offset: 0x1A4 */
  __IO uint32_t HW_IP_INACTIVE_INDEX_CTRL;         /**< HW IP inactive Control, offset: 0x1A8 */
  __IO uint32_t HW_IP_DYNAMIC_CLK_SWITCH_CTRL;     /**< HW IP dynamic clock switching contrl, offset: 0x1AC */
  __IO uint32_t IHB_CTRL;                          /**< IHB Control, offset: 0x1B0 */
  __IO uint32_t IHB_WKUP_MASK;                     /**< IHB Wakeup Mask, offset: 0x1B4 */
  __IO uint32_t CPU2_IHB_WKUP_MASK;                /**< CPU2 IHB Wakeup Mask, offset: 0x1B8 */
  __I  uint32_t IHB_STATUS;                        /**< IHB Status, offset: 0x1BC */
  __IO uint32_t USB_CTRL;                          /**< USB Control, offset: 0x1C0 */
  __IO uint32_t USB_WKUP_MASK;                     /**< USB Wakeup Mask, offset: 0x1C4 */
  __I  uint32_t USB_STATUS;                        /**< USB Status, offset: 0x1C8 */
       uint8_t RESERVED_6[52];
  __IO uint32_t CPU1_DVFS_CTRL;                    /**< CPU1 DVFS Control, offset: 0x200 */
  __IO uint32_t CPU1_FREQ_REG1;                    /**< CPU1 Frequency 1, offset: 0x204 */
  __IO uint32_t CPU1_FREQ_REG2;                    /**< CPU1 Frequency 2, offset: 0x208 */
  __IO uint32_t CPU1_PLL_EN_REG;                   /**< CPU1 PLL Enable, offset: 0x20C */
  __IO uint32_t CPU1_VOL_REG1;                     /**< CPU1 Voltage 1, offset: 0x210 */
  __IO uint32_t CPU1_VOL_REG2;                     /**< CPU1 Voltage 2, offset: 0x214 */
  __IO uint32_t CPU1_VOL_REG3;                     /**< CPU1 Voltage 3, offset: 0x218 */
  __IO uint32_t CPU1_VOL_REG4;                     /**< CPU1 Voltage 4, offset: 0x21C */
  __IO uint32_t CPU2_DVFS_CTRL;                    /**< CPU2 DVFS Control, offset: 0x220 */
  __IO uint32_t CPU2_FREQ_REG1;                    /**< CPU2 Frequency 1, offset: 0x224 */
  __IO uint32_t CPU2_FREQ_REG2;                    /**< CPU2 Frequency 2, offset: 0x228 */
  __IO uint32_t CPU2_PLL_EN_REG;                   /**< CPU2 PLL Enable, offset: 0x22C */
  __IO uint32_t CPU2_VOL_REG1;                     /**< CPU2 Voltage 1, offset: 0x230 */
  __IO uint32_t CPU2_VOL_REG2;                     /**< CPU2 Voltage 2, offset: 0x234 */
  __IO uint32_t CPU2_VOL_REG3;                     /**< CPU2 Voltage 3, offset: 0x238 */
  __IO uint32_t CPU2_VOL_REG4;                     /**< CPU2 Voltage 4, offset: 0x23C */
  __IO uint32_t SYS_FREQ_REG1;                     /**< System Frequency 1, offset: 0x240 */
  __IO uint32_t SYS_FREQ_REG2;                     /**< System Frequency 2, offset: 0x244 */
  __IO uint32_t SYS_PLL_EN_REG;                    /**< System PLL Enable, offset: 0x248 */
  __IO uint32_t SYS_VOL_REG1;                      /**< System Voltage 1, offset: 0x24C */
  __IO uint32_t SYS_VOL_REG2;                      /**< System Voltage 2, offset: 0x250 */
  __IO uint32_t SYS_VOL_REG3;                      /**< System Voltage 3, offset: 0x254 */
  __IO uint32_t SYS_VOL_REG4;                      /**< System Voltage 4, offset: 0x258 */
  __IO uint32_t DVFS_CTRL;                         /**< DVFS Control, offset: 0x25C */
  __IO uint32_t PARTIAL_DVFS_CTRL;                 /**< Partial DVFS Control, offset: 0x260 */
  __IO uint32_t DVFS_TIMER;                        /**< DVFS Timer, offset: 0x264 */
       uint8_t RESERVED_7[8];
  __IO uint32_t AHB1_FREQ_REG1;                    /**< AHB1 Frequency 1, offset: 0x270 */
  __IO uint32_t AHB1_FREQ_REG2;                    /**< AHB1 Frequency 2, offset: 0x274 */
  __IO uint32_t AHB1_PLL_EN_REG;                   /**< AHB1 PLL Enable, offset: 0x278 */
  __IO uint32_t AHB1_VOL_REG1;                     /**< AHB1 Voltage 1, offset: 0x27C */
  __IO uint32_t AHB1_VOL_REG2;                     /**< AHB1 Voltage 2, offset: 0x280 */
  __IO uint32_t AHB1_VOL_REG3;                     /**< AHB1 Voltage 3, offset: 0x284 */
  __IO uint32_t AHB1_VOL_REG4;                     /**< AHB1 Voltage 4, offset: 0x288 */
       uint8_t RESERVED_8[12];
  __I  uint32_t DVFS_STATUS;                       /**< DVFS Status, offset: 0x298 */
  __IO uint32_t DVFS_DBG_CTRL;                     /**< DVFS Debug Control, offset: 0x29C */
  __IO uint32_t DVFS_DBG_PATTERN_DATA;             /**< DVFS Debug Pattern Data, offset: 0x2A0 */
  __I  uint32_t DVFS_DBG_REG0;                     /**< DVFS Debug 0, offset: 0x2A4 */
  __I  uint32_t DVFS_DBG_REG1;                     /**< DVFS Debug 1, offset: 0x2A8 */
  __I  uint32_t DVFS_DBG_REG2;                     /**< DVFS Debug 2, offset: 0x2AC */
  __I  uint32_t DVFS_DBG_REG3;                     /**< DVFS Debug 3, offset: 0x2B0 */
  __I  uint32_t DVFS_DBG_REG4;                     /**< DVFS Debug 4, offset: 0x2B4 */
  __I  uint32_t DVFS_DBG_REG5;                     /**< DVFS Debug 5, offset: 0x2B8 */
  __I  uint32_t DVFS_DBG_STATUS;                   /**< DVFS Debug Status, offset: 0x2BC */
  __IO uint32_t DVFS_DBG_PATTERN_MASK;             /**< DVFS Debug Patter Mask, offset: 0x2C0 */
       uint8_t RESERVED_9[52];
  __IO uint32_t DVFS_PMIC_TIMER;                   /**< DVFS PMIC Timer, offset: 0x2F8 */
  __IO uint32_t DVFS_PMIC_MAP;                     /**< DVFS PMIC Map, offset: 0x2FC */
  __IO uint32_t LDO_CTRL;                          /**< LDO Control, offset: 0x300 */
  __IO uint32_t LDO_BACKUP_LVL_MAP1;               /**< LDO Backup Level Map 1, offset: 0x304 */
  __IO uint32_t LDO_BACKUP_LVL_MAP2;               /**< LDO Backup Level Map 2, offset: 0x308 */
  __I  uint32_t LDO_STATUS;                        /**< LDO Status, offset: 0x30C */
  __IO uint32_t RC32_CAL_CTRL;                     /**< RC32 Calibration Control, offset: 0x310 */
  __IO uint32_t RC32_CAL_SLPCLK_TIMER;             /**< RC32 Calibration Sleep Clock Timer, offset: 0x314 */
  __I  uint32_t RC32CAL_SLPCLK_CNT_RD;             /**< RC32 Calibration Sleep Clock Count Read, offset: 0x318 */
       uint8_t RESERVED_10[28];
  __IO uint32_t TSTBUS_DATA;                       /**< Testbus Data, offset: 0x338 */
  __IO uint32_t TST_CTRL;                          /**< Test Control, offset: 0x33C */
  __IO uint32_t BCA_LTE_CTRL;                      /**< BCA LTE Control, offset: 0x340 */
  __IO uint32_t BCA_LTE_TIMER1;                    /**< BCA LTE Timer 1, offset: 0x344 */
  __IO uint32_t BCA_LTE_TIMER2;                    /**< BCA LTE Timer 2, offset: 0x348 */
  __IO uint32_t BCA_MWS_WKUP_TIMER;                /**< BCA MWS Wakeup Timer, offset: 0x34C */
  __IO uint32_t BT2_CTRL;                          /**< Bluetooth 2 Control, offset: 0x350 */
  __IO uint32_t BT2_WKUP_MASK;                     /**< Bluetooth 2 Wakeup Mask, offset: 0x354 */
  __I  uint32_t BT2_STATUS;                        /**< Bluetooth 2 Status, offset: 0x358 */
  __IO uint32_t BT2_CKEN_CTRL;                     /**< Bluetooth 2 Clock Enable Control, offset: 0x35C */
  __IO uint32_t BT2_RESRC_CTRL;                    /**< Bluetooth 2 RESRC Control, offset: 0x360 */
  __IO uint32_t BT2_DVFS_CTRL;                     /**< Bluetooth 2 DVFS Control, offset: 0x364 */
  __IO uint32_t BLE2_CTRL;                         /**< BLE 2 Control, offset: 0x368 */
  __IO uint32_t BLE2_WKUP_MASK;                    /**< BLE 2 Wakeup Mask, offset: 0x36C */
  __I  uint32_t BLE2_STATUS;                       /**< BLE 2 Status, offset: 0x370 */
       uint8_t RESERVED_11[12];
  __I  uint32_t LMU_IP_REVISION;                   /**< LMU IP Revision, offset: 0x380 */
  __IO uint32_t LMU_CPU1_STA_CFG;                  /**< LMU CPU1 STA Configuration, offset: 0x384 */
  __I  uint32_t LMU_CPU1_STA_STATUS1;              /**< LMU CPU1 STA Status 1, offset: 0x388 */
  __I  uint32_t LMU_CPU1_STA_STATUS2;              /**< LMU CPU1 STA Status 2, offset: 0x38C */
       uint8_t RESERVED_12[8];
  __IO uint32_t LMU_CPU1_DYN_CTRL;                 /**< LMU CPU1 Dynamic Control, offset: 0x398 */
  __I  uint32_t LMU_CPU1_DYN_STATUS;               /**< LMU CPU1 Dynamic Status, offset: 0x39C */
       uint8_t RESERVED_13[8];
  __IO uint32_t LMU_CPU2_STA_CFG;                  /**< LMU CPU2 STA Configuration, offset: 0x3A8 */
  __I  uint32_t LMU_CPU2_STA_STATUS1;              /**< LMU CPU2 STA Status 1, offset: 0x3AC */
  __IO uint32_t LMU_CPU3_STA_CFG;                  /**< LMU CPU3 STA Configuration, offset: 0x3B0 */
  __I  uint32_t LMU_CPU3_STA_STATUS1;              /**< LMU CPU3 STA Status 1, offset: 0x3B4 */
  __IO uint32_t LMU_G2BIST_CTRL;                   /**< LMU G2BIST Control, offset: 0x3B8 */
  __I  uint32_t LMU_STATUS;                        /**< LMU Status, offset: 0x3BC */
  __IO uint32_t LMU_STA_CFG_MASK;                  /**< LMU STA Configuration Mask, offset: 0x3C0 */
  __I  uint32_t LMU_CPU2_STA_STATUS2;              /**< LMU CPU2 STA Status 2, offset: 0x3C4 */
  __I  uint32_t LMU_CPU3_STA_STATUS2;              /**< LMU CPU3 STA Status 2, offset: 0x3C8 */
       uint8_t RESERVED_14[4];
  __IO uint32_t CPU3_HOST_WKUP_MASK;               /**< CPU3 Host Wakeup Mask, offset: 0x3D0 */
  __IO uint32_t CPU3_HOST_WKUP_POL;                /**< CPU3 Host Wakeup Polarity, offset: 0x3D4 */
  __IO uint32_t CPU3_HOST_WKUP_CTRL;               /**< CPU3 Host Wakeup Control, offset: 0x3D8 */
  __IO uint32_t CPU3_CTRL;                         /**< CPU3 Control, offset: 0x3DC */
  __IO uint32_t CPU3_DVFS_CTRL;                    /**< CPU3 DVFS Control, offset: 0x3E0 */
  __IO uint32_t CPU3_FREQ_REG1;                    /**< CPU3 Frequency 1, offset: 0x3E4 */
  __IO uint32_t CPU3_FREQ_REG2;                    /**< CPU3 Frequency 2, offset: 0x3E8 */
  __IO uint32_t CPU3_PLL_EN_REG;                   /**< CPU3 PLL Enable, offset: 0x3EC */
  __IO uint32_t CPU3_VOL_REG1;                     /**< CPU3 Voltage 1, offset: 0x3F0 */
  __IO uint32_t CPU3_VOL_REG2;                     /**< CPU3 Voltage 2, offset: 0x3F4 */
  __IO uint32_t CPU3_VOL_REG3;                     /**< CPU3 Voltage 3, offset: 0x3F8 */
  __IO uint32_t CPU3_VOL_REG4;                     /**< CPU3 Voltage 4, offset: 0x3FC */
} APU_Type;

/* ----------------------------------------------------------------------------
   -- APU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup APU_Register_Masks APU Register Masks
 * @{
 */

/*! @name APU_IP_REVISION - APU IP revision */
/*! @{ */

#define APU_APU_IP_REVISION_IP_REV_MASK          (0xFFFFU)
#define APU_APU_IP_REVISION_IP_REV_SHIFT         (0U)
/*! IP_REV - IP revision */
#define APU_APU_IP_REVISION_IP_REV(x)            (((uint32_t)(((uint32_t)(x)) << APU_APU_IP_REVISION_IP_REV_SHIFT)) & APU_APU_IP_REVISION_IP_REV_MASK)
/*! @} */

/*! @name CTRL - Control */
/*! @{ */

#define APU_CTRL_CPU1_PD_MASK_MASK               (0x1U)
#define APU_CTRL_CPU1_PD_MASK_SHIFT              (0U)
/*! CPU1_PD_MASK - CPU1 Pd Mask */
#define APU_CTRL_CPU1_PD_MASK(x)                 (((uint32_t)(((uint32_t)(x)) << APU_CTRL_CPU1_PD_MASK_SHIFT)) & APU_CTRL_CPU1_PD_MASK_MASK)

#define APU_CTRL_FW_CPU1_PD_MASK                 (0x2U)
#define APU_CTRL_FW_CPU1_PD_SHIFT                (1U)
/*! FW_CPU1_PD - FW CPU1 Pd */
#define APU_CTRL_FW_CPU1_PD(x)                   (((uint32_t)(((uint32_t)(x)) << APU_CTRL_FW_CPU1_PD_SHIFT)) & APU_CTRL_FW_CPU1_PD_MASK)

#define APU_CTRL_WLCOMN_USE_NOM_PWR_BYP_MASK     (0x8U)
#define APU_CTRL_WLCOMN_USE_NOM_PWR_BYP_SHIFT    (3U)
/*! WLCOMN_USE_NOM_PWR_BYP - WLAN comman domain uses nominal voltage */
#define APU_CTRL_WLCOMN_USE_NOM_PWR_BYP(x)       (((uint32_t)(((uint32_t)(x)) << APU_CTRL_WLCOMN_USE_NOM_PWR_BYP_SHIFT)) & APU_CTRL_WLCOMN_USE_NOM_PWR_BYP_MASK)

#define APU_CTRL_APU_SUBSYS1_HOST_MASK           (0x70U)
#define APU_CTRL_APU_SUBSYS1_HOST_SHIFT          (4U)
/*! APU_SUBSYS1_HOST - APU Subsystem1 Host */
#define APU_CTRL_APU_SUBSYS1_HOST(x)             (((uint32_t)(((uint32_t)(x)) << APU_CTRL_APU_SUBSYS1_HOST_SHIFT)) & APU_CTRL_APU_SUBSYS1_HOST_MASK)

#define APU_CTRL_APU_CAL_DONE_CLEAR_METHOD_MASK  (0x80U)
#define APU_CTRL_APU_CAL_DONE_CLEAR_METHOD_SHIFT (7U)
/*! APU_CAL_DONE_CLEAR_METHOD - 1- use falling edge of apu_sw_acc_rst to clear the apu_cal_done after FW polls the apu_cal_done = 1 */
#define APU_CTRL_APU_CAL_DONE_CLEAR_METHOD(x)    (((uint32_t)(((uint32_t)(x)) << APU_CTRL_APU_CAL_DONE_CLEAR_METHOD_SHIFT)) & APU_CTRL_APU_CAL_DONE_CLEAR_METHOD_MASK)

#define APU_CTRL_ENTER_ALL_SLEEP_MODE_MASK       (0x100U)
#define APU_CTRL_ENTER_ALL_SLEEP_MODE_SHIFT      (8U)
/*! ENTER_ALL_SLEEP_MODE - Enter All Sleep Mode */
#define APU_CTRL_ENTER_ALL_SLEEP_MODE(x)         (((uint32_t)(((uint32_t)(x)) << APU_CTRL_ENTER_ALL_SLEEP_MODE_SHIFT)) & APU_CTRL_ENTER_ALL_SLEEP_MODE_MASK)

#define APU_CTRL_USE_HOST_INTR_SLP_MASK          (0x200U)
#define APU_CTRL_USE_HOST_INTR_SLP_SHIFT         (9U)
/*! USE_HOST_INTR_SLP - Use Host Interrupt Sleep */
#define APU_CTRL_USE_HOST_INTR_SLP(x)            (((uint32_t)(((uint32_t)(x)) << APU_CTRL_USE_HOST_INTR_SLP_SHIFT)) & APU_CTRL_USE_HOST_INTR_SLP_MASK)

#define APU_CTRL_APU_ALLOW_AUTO_LOAD_MASK        (0x400U)
#define APU_CTRL_APU_ALLOW_AUTO_LOAD_SHIFT       (10U)
/*! APU_ALLOW_AUTO_LOAD - APU Allow Auto load */
#define APU_CTRL_APU_ALLOW_AUTO_LOAD(x)          (((uint32_t)(((uint32_t)(x)) << APU_CTRL_APU_ALLOW_AUTO_LOAD_SHIFT)) & APU_CTRL_APU_ALLOW_AUTO_LOAD_MASK)

#define APU_CTRL_APU_AUTO_CALIBRATE_MASK         (0x800U)
#define APU_CTRL_APU_AUTO_CALIBRATE_SHIFT        (11U)
/*! APU_AUTO_CALIBRATE - APU Auto Calibrate */
#define APU_CTRL_APU_AUTO_CALIBRATE(x)           (((uint32_t)(((uint32_t)(x)) << APU_CTRL_APU_AUTO_CALIBRATE_SHIFT)) & APU_CTRL_APU_AUTO_CALIBRATE_MASK)

#define APU_CTRL_APU_NO_TBTT_RESET_MASK          (0x1000U)
#define APU_CTRL_APU_NO_TBTT_RESET_SHIFT         (12U)
/*! APU_NO_TBTT_RESET - APU No TBTT Reset */
#define APU_CTRL_APU_NO_TBTT_RESET(x)            (((uint32_t)(((uint32_t)(x)) << APU_CTRL_APU_NO_TBTT_RESET_SHIFT)) & APU_CTRL_APU_NO_TBTT_RESET_MASK)

#define APU_CTRL_SW_TIMER_LD_MASK                (0x2000U)
#define APU_CTRL_SW_TIMER_LD_SHIFT               (13U)
/*! SW_TIMER_LD - SW Timer */
#define APU_CTRL_SW_TIMER_LD(x)                  (((uint32_t)(((uint32_t)(x)) << APU_CTRL_SW_TIMER_LD_SHIFT)) & APU_CTRL_SW_TIMER_LD_MASK)

#define APU_CTRL_RST_APU_SLPCLK_TIMER_MASK       (0x4000U)
#define APU_CTRL_RST_APU_SLPCLK_TIMER_SHIFT      (14U)
/*! RST_APU_SLPCLK_TIMER - Reset APU Sleep Clock Timer */
#define APU_CTRL_RST_APU_SLPCLK_TIMER(x)         (((uint32_t)(((uint32_t)(x)) << APU_CTRL_RST_APU_SLPCLK_TIMER_SHIFT)) & APU_CTRL_RST_APU_SLPCLK_TIMER_MASK)

#define APU_CTRL_APU_SW_ACC_RST_MASK             (0x8000U)
#define APU_CTRL_APU_SW_ACC_RST_SHIFT            (15U)
/*! APU_SW_ACC_RST - APU SW ACC Reset */
#define APU_CTRL_APU_SW_ACC_RST(x)               (((uint32_t)(((uint32_t)(x)) << APU_CTRL_APU_SW_ACC_RST_SHIFT)) & APU_CTRL_APU_SW_ACC_RST_MASK)

#define APU_CTRL_SDU_SLP_RDY_MASK_MASK           (0x20000U)
#define APU_CTRL_SDU_SLP_RDY_MASK_SHIFT          (17U)
/*! SDU_SLP_RDY_MASK - SDU Sleep Ready Mask */
#define APU_CTRL_SDU_SLP_RDY_MASK(x)             (((uint32_t)(((uint32_t)(x)) << APU_CTRL_SDU_SLP_RDY_MASK_SHIFT)) & APU_CTRL_SDU_SLP_RDY_MASK_MASK)

#define APU_CTRL_IPS_CP15_SLEEP_MASK_MASK        (0x200000U)
#define APU_CTRL_IPS_CP15_SLEEP_MASK_SHIFT       (21U)
/*! IPS_CP15_SLEEP_MASK - IPS CP15 Sleep Mask */
#define APU_CTRL_IPS_CP15_SLEEP_MASK(x)          (((uint32_t)(((uint32_t)(x)) << APU_CTRL_IPS_CP15_SLEEP_MASK_SHIFT)) & APU_CTRL_IPS_CP15_SLEEP_MASK_MASK)

#define APU_CTRL_FW_IPS_CP15_SLEEP_MASK          (0x400000U)
#define APU_CTRL_FW_IPS_CP15_SLEEP_SHIFT         (22U)
/*! FW_IPS_CP15_SLEEP - FW IPS CP15 Sleep */
#define APU_CTRL_FW_IPS_CP15_SLEEP(x)            (((uint32_t)(((uint32_t)(x)) << APU_CTRL_FW_IPS_CP15_SLEEP_SHIFT)) & APU_CTRL_FW_IPS_CP15_SLEEP_MASK)

#define APU_CTRL_CP_15_SLEEP_MASK_MASK           (0x800000U)
#define APU_CTRL_CP_15_SLEEP_MASK_SHIFT          (23U)
/*! CP_15_SLEEP_MASK - CP15 Sleep Mask */
#define APU_CTRL_CP_15_SLEEP_MASK(x)             (((uint32_t)(((uint32_t)(x)) << APU_CTRL_CP_15_SLEEP_MASK_SHIFT)) & APU_CTRL_CP_15_SLEEP_MASK_MASK)

#define APU_CTRL_FW_CP15_SLEEP_MASK              (0x1000000U)
#define APU_CTRL_FW_CP15_SLEEP_SHIFT             (24U)
/*! FW_CP15_SLEEP - FW CP15 Sleep */
#define APU_CTRL_FW_CP15_SLEEP(x)                (((uint32_t)(((uint32_t)(x)) << APU_CTRL_FW_CP15_SLEEP_SHIFT)) & APU_CTRL_FW_CP15_SLEEP_MASK)

#define APU_CTRL_CPU1_MSG_RDY_MASK_MASK          (0x2000000U)
#define APU_CTRL_CPU1_MSG_RDY_MASK_SHIFT         (25U)
/*! CPU1_MSG_RDY_MASK - CPU1 Message Ready Mask */
#define APU_CTRL_CPU1_MSG_RDY_MASK(x)            (((uint32_t)(((uint32_t)(x)) << APU_CTRL_CPU1_MSG_RDY_MASK_SHIFT)) & APU_CTRL_CPU1_MSG_RDY_MASK_MASK)
/*! @} */

/*! @name TIMER_PWR_MODE - Timer Power Mode */
/*! @{ */

#define APU_TIMER_PWR_MODE_MCI_XP_REQ_MASK_MASK  (0x1U)
#define APU_TIMER_PWR_MODE_MCI_XP_REQ_MASK_SHIFT (0U)
/*! MCI_XP_REQ_MASK - MCI XP Request Mask */
#define APU_TIMER_PWR_MODE_MCI_XP_REQ_MASK(x)    (((uint32_t)(((uint32_t)(x)) << APU_TIMER_PWR_MODE_MCI_XP_REQ_MASK_SHIFT)) & APU_TIMER_PWR_MODE_MCI_XP_REQ_MASK_MASK)

#define APU_TIMER_PWR_MODE_SLP_CLK_TIMER_EN_MASK (0x10U)
#define APU_TIMER_PWR_MODE_SLP_CLK_TIMER_EN_SHIFT (4U)
/*! SLP_CLK_TIMER_EN - free running sleep clock timer enable */
#define APU_TIMER_PWR_MODE_SLP_CLK_TIMER_EN(x)   (((uint32_t)(((uint32_t)(x)) << APU_TIMER_PWR_MODE_SLP_CLK_TIMER_EN_SHIFT)) & APU_TIMER_PWR_MODE_SLP_CLK_TIMER_EN_MASK)

#define APU_TIMER_PWR_MODE_WL_BCN_ALARM_TIMER_EN_MASK (0x20U)
#define APU_TIMER_PWR_MODE_WL_BCN_ALARM_TIMER_EN_SHIFT (5U)
/*! WL_BCN_ALARM_TIMER_EN - WLAN beacon alarm timer enable */
#define APU_TIMER_PWR_MODE_WL_BCN_ALARM_TIMER_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_TIMER_PWR_MODE_WL_BCN_ALARM_TIMER_EN_SHIFT)) & APU_TIMER_PWR_MODE_WL_BCN_ALARM_TIMER_EN_MASK)

#define APU_TIMER_PWR_MODE_WL2_BCN_ALARM_TIMER_EN_MASK (0x40U)
#define APU_TIMER_PWR_MODE_WL2_BCN_ALARM_TIMER_EN_SHIFT (6U)
/*! WL2_BCN_ALARM_TIMER_EN - WLAN2 beacon alarm timer enable */
#define APU_TIMER_PWR_MODE_WL2_BCN_ALARM_TIMER_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_TIMER_PWR_MODE_WL2_BCN_ALARM_TIMER_EN_SHIFT)) & APU_TIMER_PWR_MODE_WL2_BCN_ALARM_TIMER_EN_MASK)

#define APU_TIMER_PWR_MODE_DIS_GATED_SLP_CLK_MASK (0x80U)
#define APU_TIMER_PWR_MODE_DIS_GATED_SLP_CLK_SHIFT (7U)
/*! DIS_GATED_SLP_CLK - Disable Gated Sleep Clock */
#define APU_TIMER_PWR_MODE_DIS_GATED_SLP_CLK(x)  (((uint32_t)(((uint32_t)(x)) << APU_TIMER_PWR_MODE_DIS_GATED_SLP_CLK_SHIFT)) & APU_TIMER_PWR_MODE_DIS_GATED_SLP_CLK_MASK)

#define APU_TIMER_PWR_MODE_XP_OPT_EN_MASK        (0x1000U)
#define APU_TIMER_PWR_MODE_XP_OPT_EN_SHIFT       (12U)
/*! XP_OPT_EN - Set to 1 to enable the sleep FSM to look for wakeup req after power shutdown and before reference clock shutdown. */
#define APU_TIMER_PWR_MODE_XP_OPT_EN(x)          (((uint32_t)(((uint32_t)(x)) << APU_TIMER_PWR_MODE_XP_OPT_EN_SHIFT)) & APU_TIMER_PWR_MODE_XP_OPT_EN_MASK)

#define APU_TIMER_PWR_MODE_DIS_APU_INTR_ON_WAKEUP_MASK (0x2000U)
#define APU_TIMER_PWR_MODE_DIS_APU_INTR_ON_WAKEUP_SHIFT (13U)
/*! DIS_APU_INTR_ON_WAKEUP - Disable APU Interrupt on Wakeup */
#define APU_TIMER_PWR_MODE_DIS_APU_INTR_ON_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << APU_TIMER_PWR_MODE_DIS_APU_INTR_ON_WAKEUP_SHIFT)) & APU_TIMER_PWR_MODE_DIS_APU_INTR_ON_WAKEUP_MASK)

#define APU_TIMER_PWR_MODE_SOC_XOSC_PWR_ON_MASK  (0x20000U)
#define APU_TIMER_PWR_MODE_SOC_XOSC_PWR_ON_SHIFT (17U)
/*! SOC_XOSC_PWR_ON - SoC XOSC Power on */
#define APU_TIMER_PWR_MODE_SOC_XOSC_PWR_ON(x)    (((uint32_t)(((uint32_t)(x)) << APU_TIMER_PWR_MODE_SOC_XOSC_PWR_ON_SHIFT)) & APU_TIMER_PWR_MODE_SOC_XOSC_PWR_ON_MASK)

#define APU_TIMER_PWR_MODE_ENA_FAST_WKUP_MASK    (0x40000U)
#define APU_TIMER_PWR_MODE_ENA_FAST_WKUP_SHIFT   (18U)
/*! ENA_FAST_WKUP - Enable Fast Wakeup */
#define APU_TIMER_PWR_MODE_ENA_FAST_WKUP(x)      (((uint32_t)(((uint32_t)(x)) << APU_TIMER_PWR_MODE_ENA_FAST_WKUP_SHIFT)) & APU_TIMER_PWR_MODE_ENA_FAST_WKUP_MASK)

#define APU_TIMER_PWR_MODE_GENERIC_TIMER_EN_MASK (0x200000U)
#define APU_TIMER_PWR_MODE_GENERIC_TIMER_EN_SHIFT (21U)
/*! GENERIC_TIMER_EN - Enable sleep timer to generate interrupt when value matches generic timer value. Debug only */
#define APU_TIMER_PWR_MODE_GENERIC_TIMER_EN(x)   (((uint32_t)(((uint32_t)(x)) << APU_TIMER_PWR_MODE_GENERIC_TIMER_EN_SHIFT)) & APU_TIMER_PWR_MODE_GENERIC_TIMER_EN_MASK)

#define APU_TIMER_PWR_MODE_GENERIC_TIMER_BYPASS_MASK (0x400000U)
#define APU_TIMER_PWR_MODE_GENERIC_TIMER_BYPASS_SHIFT (22U)
/*! GENERIC_TIMER_BYPASS - When set to 1, generic_alarm_en2 will be used for generic_alarm_en1 */
#define APU_TIMER_PWR_MODE_GENERIC_TIMER_BYPASS(x) (((uint32_t)(((uint32_t)(x)) << APU_TIMER_PWR_MODE_GENERIC_TIMER_BYPASS_SHIFT)) & APU_TIMER_PWR_MODE_GENERIC_TIMER_BYPASS_MASK)

#define APU_TIMER_PWR_MODE_XOSC_ON_WHILE_SLEEP_MASK (0x800000U)
#define APU_TIMER_PWR_MODE_XOSC_ON_WHILE_SLEEP_SHIFT (23U)
/*! XOSC_ON_WHILE_SLEEP - XOSC On While Sleep */
#define APU_TIMER_PWR_MODE_XOSC_ON_WHILE_SLEEP(x) (((uint32_t)(((uint32_t)(x)) << APU_TIMER_PWR_MODE_XOSC_ON_WHILE_SLEEP_SHIFT)) & APU_TIMER_PWR_MODE_XOSC_ON_WHILE_SLEEP_MASK)

#define APU_TIMER_PWR_MODE_USE_HSIC_SLP_SYNC_MASK (0x1000000U)
#define APU_TIMER_PWR_MODE_USE_HSIC_SLP_SYNC_SHIFT (24U)
/*! USE_HSIC_SLP_SYNC - Use HSIC Sleep Sync */
#define APU_TIMER_PWR_MODE_USE_HSIC_SLP_SYNC(x)  (((uint32_t)(((uint32_t)(x)) << APU_TIMER_PWR_MODE_USE_HSIC_SLP_SYNC_SHIFT)) & APU_TIMER_PWR_MODE_USE_HSIC_SLP_SYNC_MASK)
/*! @} */

/*! @name PWR_CTRL - Power Control */
/*! @{ */

#define APU_PWR_CTRL_APU_PD_CTRL_EN_MASK         (0x1U)
#define APU_PWR_CTRL_APU_PD_CTRL_EN_SHIFT        (0U)
/*! APU_PD_CTRL_EN - APU power domain control enable */
#define APU_PWR_CTRL_APU_PD_CTRL_EN(x)           (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_APU_PD_CTRL_EN_SHIFT)) & APU_PWR_CTRL_APU_PD_CTRL_EN_MASK)

#define APU_PWR_CTRL_APU_SW_PD_EN_MASK           (0x2U)
#define APU_PWR_CTRL_APU_SW_PD_EN_SHIFT          (1U)
/*! APU_SW_PD_EN - APU switch power down enable */
#define APU_PWR_CTRL_APU_SW_PD_EN(x)             (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_APU_SW_PD_EN_SHIFT)) & APU_PWR_CTRL_APU_SW_PD_EN_MASK)

#define APU_PWR_CTRL_APU_UDR_FIREWALL_BAR_EN_MASK (0x4U)
#define APU_PWR_CTRL_APU_UDR_FIREWALL_BAR_EN_SHIFT (2U)
/*! APU_UDR_FIREWALL_BAR_EN - APU UDR enable */
#define APU_PWR_CTRL_APU_UDR_FIREWALL_BAR_EN(x)  (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_APU_UDR_FIREWALL_BAR_EN_SHIFT)) & APU_PWR_CTRL_APU_UDR_FIREWALL_BAR_EN_MASK)

#define APU_PWR_CTRL_APU_ISO_CELL_EN_MASK        (0x8U)
#define APU_PWR_CTRL_APU_ISO_CELL_EN_SHIFT       (3U)
/*! APU_ISO_CELL_EN - APU isolation enable */
#define APU_PWR_CTRL_APU_ISO_CELL_EN(x)          (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_APU_ISO_CELL_EN_SHIFT)) & APU_PWR_CTRL_APU_ISO_CELL_EN_MASK)

#define APU_PWR_CTRL_DLY_UDR2ISO_MASK            (0x10U)
#define APU_PWR_CTRL_DLY_UDR2ISO_SHIFT           (4U)
/*! DLY_UDR2ISO - UDR firewall_bar to isolation delay enable */
#define APU_PWR_CTRL_DLY_UDR2ISO(x)              (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_DLY_UDR2ISO_SHIFT)) & APU_PWR_CTRL_DLY_UDR2ISO_MASK)

#define APU_PWR_CTRL_ISO_ENABLE_REFCK_MASK       (0x20U)
#define APU_PWR_CTRL_ISO_ENABLE_REFCK_SHIFT      (5U)
/*! ISO_ENABLE_REFCK - ISO Enable Reference Clock */
#define APU_PWR_CTRL_ISO_ENABLE_REFCK(x)         (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_ISO_ENABLE_REFCK_SHIFT)) & APU_PWR_CTRL_ISO_ENABLE_REFCK_MASK)

#define APU_PWR_CTRL_NON_UDR_RSTB_EN_MASK        (0x40U)
#define APU_PWR_CTRL_NON_UDR_RSTB_EN_SHIFT       (6U)
/*! NON_UDR_RSTB_EN - APU non-UDR reset enable */
#define APU_PWR_CTRL_NON_UDR_RSTB_EN(x)          (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_NON_UDR_RSTB_EN_SHIFT)) & APU_PWR_CTRL_NON_UDR_RSTB_EN_MASK)

#define APU_PWR_CTRL_XOSC_OFF_DURING_POWER_OFF_MASK (0x80U)
#define APU_PWR_CTRL_XOSC_OFF_DURING_POWER_OFF_SHIFT (7U)
/*! XOSC_OFF_DURING_POWER_OFF - XOSC Off During Power Off */
#define APU_PWR_CTRL_XOSC_OFF_DURING_POWER_OFF(x) (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_XOSC_OFF_DURING_POWER_OFF_SHIFT)) & APU_PWR_CTRL_XOSC_OFF_DURING_POWER_OFF_MASK)

#define APU_PWR_CTRL_SRAM_PD_EN_MASK             (0x100U)
#define APU_PWR_CTRL_SRAM_PD_EN_SHIFT            (8U)
/*! SRAM_PD_EN - APU SRAM power down enable */
#define APU_PWR_CTRL_SRAM_PD_EN(x)               (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_SRAM_PD_EN_SHIFT)) & APU_PWR_CTRL_SRAM_PD_EN_MASK)

#define APU_PWR_CTRL_CLK_DIV_RESETB_ENABLE_MASK  (0x200U)
#define APU_PWR_CTRL_CLK_DIV_RESETB_ENABLE_SHIFT (9U)
/*! CLK_DIV_RESETB_ENABLE - CLK_DIV_RESETB Enable */
#define APU_PWR_CTRL_CLK_DIV_RESETB_ENABLE(x)    (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_CLK_DIV_RESETB_ENABLE_SHIFT)) & APU_PWR_CTRL_CLK_DIV_RESETB_ENABLE_MASK)

#define APU_PWR_CTRL_CLK_DIV_RESETB_REFCLK_MASK  (0x400U)
#define APU_PWR_CTRL_CLK_DIV_RESETB_REFCLK_SHIFT (10U)
/*! CLK_DIV_RESETB_REFCLK - CLK_DIV_RESETB Reference Clock */
#define APU_PWR_CTRL_CLK_DIV_RESETB_REFCLK(x)    (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_CLK_DIV_RESETB_REFCLK_SHIFT)) & APU_PWR_CTRL_CLK_DIV_RESETB_REFCLK_MASK)

#define APU_PWR_CTRL_SOC_USE_NOM_VOL_BYP_MASK    (0x800U)
#define APU_PWR_CTRL_SOC_USE_NOM_VOL_BYP_SHIFT   (11U)
/*! SOC_USE_NOM_VOL_BYP - SoC Use Nominal Vol Bypass */
#define APU_PWR_CTRL_SOC_USE_NOM_VOL_BYP(x)      (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_SOC_USE_NOM_VOL_BYP_SHIFT)) & APU_PWR_CTRL_SOC_USE_NOM_VOL_BYP_MASK)

#define APU_PWR_CTRL_SOC_USE_UNSYNC_VOL_LVL_MASK (0x1000U)
#define APU_PWR_CTRL_SOC_USE_UNSYNC_VOL_LVL_SHIFT (12U)
/*! SOC_USE_UNSYNC_VOL_LVL - SoC Use unSync Vol Level */
#define APU_PWR_CTRL_SOC_USE_UNSYNC_VOL_LVL(x)   (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_SOC_USE_UNSYNC_VOL_LVL_SHIFT)) & APU_PWR_CTRL_SOC_USE_UNSYNC_VOL_LVL_MASK)

#define APU_PWR_CTRL_RFU_IN_WLAN_DOMAIN_MASK     (0x2000U)
#define APU_PWR_CTRL_RFU_IN_WLAN_DOMAIN_SHIFT    (13U)
/*! RFU_IN_WLAN_DOMAIN - RFU WLAN mode */
#define APU_PWR_CTRL_RFU_IN_WLAN_DOMAIN(x)       (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_RFU_IN_WLAN_DOMAIN_SHIFT)) & APU_PWR_CTRL_RFU_IN_WLAN_DOMAIN_MASK)

#define APU_PWR_CTRL_DLY_NON_UDR_RSTB_MASK       (0x4000U)
#define APU_PWR_CTRL_DLY_NON_UDR_RSTB_SHIFT      (14U)
/*! DLY_NON_UDR_RSTB - Delay non-UDR RSTb */
#define APU_PWR_CTRL_DLY_NON_UDR_RSTB(x)         (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_DLY_NON_UDR_RSTB_SHIFT)) & APU_PWR_CTRL_DLY_NON_UDR_RSTB_MASK)

#define APU_PWR_CTRL_PCIE_P_REQ_MASK_FOR_SLPFSM_MASK (0x8000U)
#define APU_PWR_CTRL_PCIE_P_REQ_MASK_FOR_SLPFSM_SHIFT (15U)
/*! PCIE_P_REQ_MASK_FOR_SLPFSM - Mask pcie_p_req and pcie_xp_req for slp_fsm */
#define APU_PWR_CTRL_PCIE_P_REQ_MASK_FOR_SLPFSM(x) (((uint32_t)(((uint32_t)(x)) << APU_PWR_CTRL_PCIE_P_REQ_MASK_FOR_SLPFSM_SHIFT)) & APU_PWR_CTRL_PCIE_P_REQ_MASK_FOR_SLPFSM_MASK)
/*! @} */

/*! @name PLL_CTRL - PLL Control */
/*! @{ */

#define APU_PLL_CTRL_DIS_APU_PLL_EN0_MASK        (0x1U)
#define APU_PLL_CTRL_DIS_APU_PLL_EN0_SHIFT       (0U)
/*! DIS_APU_PLL_EN0 - When set to 1, apu_pll_en[0]=0 (pll0 is Tcpu in Skyhawk) */
#define APU_PLL_CTRL_DIS_APU_PLL_EN0(x)          (((uint32_t)(((uint32_t)(x)) << APU_PLL_CTRL_DIS_APU_PLL_EN0_SHIFT)) & APU_PLL_CTRL_DIS_APU_PLL_EN0_MASK)

#define APU_PLL_CTRL_DIS_APU_PLL_EN1_MASK        (0x2U)
#define APU_PLL_CTRL_DIS_APU_PLL_EN1_SHIFT       (1U)
/*! DIS_APU_PLL_EN1 - When set to 1, apu_pll_en[1]=0 (pll1 is Tsoc in Skyhawk) */
#define APU_PLL_CTRL_DIS_APU_PLL_EN1(x)          (((uint32_t)(((uint32_t)(x)) << APU_PLL_CTRL_DIS_APU_PLL_EN1_SHIFT)) & APU_PLL_CTRL_DIS_APU_PLL_EN1_MASK)

#define APU_PLL_CTRL_FW_USE_PLL0_MASK            (0x10U)
#define APU_PLL_CTRL_FW_USE_PLL0_SHIFT           (4U)
/*! FW_USE_PLL0 - When set to 1, FW controls pll_en[0] value (pll0 is Tcpu in Skyhawk) */
#define APU_PLL_CTRL_FW_USE_PLL0(x)              (((uint32_t)(((uint32_t)(x)) << APU_PLL_CTRL_FW_USE_PLL0_SHIFT)) & APU_PLL_CTRL_FW_USE_PLL0_MASK)

#define APU_PLL_CTRL_FW_PLL0_EN_SET_MASK         (0x20U)
#define APU_PLL_CTRL_FW_PLL0_EN_SET_SHIFT        (5U)
/*! FW_PLL0_EN_SET - Fw sets pll_en[0] value when apu_pll_ctrl[4] = 1, */
#define APU_PLL_CTRL_FW_PLL0_EN_SET(x)           (((uint32_t)(((uint32_t)(x)) << APU_PLL_CTRL_FW_PLL0_EN_SET_SHIFT)) & APU_PLL_CTRL_FW_PLL0_EN_SET_MASK)

#define APU_PLL_CTRL_FW_USE_PLL1_MASK            (0x100U)
#define APU_PLL_CTRL_FW_USE_PLL1_SHIFT           (8U)
/*! FW_USE_PLL1 - When set to 1, FW controls pll_en[1] value (pll0 is Tcpu in Skyhawk) */
#define APU_PLL_CTRL_FW_USE_PLL1(x)              (((uint32_t)(((uint32_t)(x)) << APU_PLL_CTRL_FW_USE_PLL1_SHIFT)) & APU_PLL_CTRL_FW_USE_PLL1_MASK)

#define APU_PLL_CTRL_FW_PLL1_EN_SET_MASK         (0x200U)
#define APU_PLL_CTRL_FW_PLL1_EN_SET_SHIFT        (9U)
/*! FW_PLL1_EN_SET - Fw sets pll_en[1] value when apu_pll_ctrl[4] = 1, */
#define APU_PLL_CTRL_FW_PLL1_EN_SET(x)           (((uint32_t)(((uint32_t)(x)) << APU_PLL_CTRL_FW_PLL1_EN_SET_SHIFT)) & APU_PLL_CTRL_FW_PLL1_EN_SET_MASK)
/*! @} */

/*! @name PLL_DIS_CNT - PLL Disable Count */
/*! @{ */

#define APU_PLL_DIS_CNT_PLL_DIS_CNT_MASK         (0xFFFFU)
#define APU_PLL_DIS_CNT_PLL_DIS_CNT_SHIFT        (0U)
/*! PLL_DIS_CNT - PLL disable count in reference clocks */
#define APU_PLL_DIS_CNT_PLL_DIS_CNT(x)           (((uint32_t)(((uint32_t)(x)) << APU_PLL_DIS_CNT_PLL_DIS_CNT_SHIFT)) & APU_PLL_DIS_CNT_PLL_DIS_CNT_MASK)
/*! @} */

/*! @name STABLE_CNT - Stable Count */
/*! @{ */

#define APU_STABLE_CNT_XOSC_STABLE_CNT_MASK      (0xFFFFU)
#define APU_STABLE_CNT_XOSC_STABLE_CNT_SHIFT     (0U)
/*! XOSC_STABLE_CNT - XOSC stable count in sleep clocks after APU asserts xosc_en */
#define APU_STABLE_CNT_XOSC_STABLE_CNT(x)        (((uint32_t)(((uint32_t)(x)) << APU_STABLE_CNT_XOSC_STABLE_CNT_SHIFT)) & APU_STABLE_CNT_XOSC_STABLE_CNT_MASK)

#define APU_STABLE_CNT_PLL_STABLE_CNT_MASK       (0xFFFF0000U)
#define APU_STABLE_CNT_PLL_STABLE_CNT_SHIFT      (16U)
/*! PLL_STABLE_CNT - PLL stable count in sleep clocks after APU asserts pll_en */
#define APU_STABLE_CNT_PLL_STABLE_CNT(x)         (((uint32_t)(((uint32_t)(x)) << APU_STABLE_CNT_PLL_STABLE_CNT_SHIFT)) & APU_STABLE_CNT_PLL_STABLE_CNT_MASK)
/*! @} */

/*! @name CPU1_HOST_WKUP_MASK - CPU1 Host Wakeup Mask */
/*! @{ */

#define APU_CPU1_HOST_WKUP_MASK_HOST_WKUP_MASK_MASK (0xFFFFU)
#define APU_CPU1_HOST_WKUP_MASK_HOST_WKUP_MASK_SHIFT (0U)
/*! HOST_WKUP_MASK - Host Wakeup Mask */
#define APU_CPU1_HOST_WKUP_MASK_HOST_WKUP_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU1_HOST_WKUP_MASK_HOST_WKUP_MASK_SHIFT)) & APU_CPU1_HOST_WKUP_MASK_HOST_WKUP_MASK_MASK)
/*! @} */

/*! @name CPU1_HOST_WKUP_POL - CPU1 Host Wakeup Polarity */
/*! @{ */

#define APU_CPU1_HOST_WKUP_POL_HOST_WKUP_POL_MASK (0xFFFFU)
#define APU_CPU1_HOST_WKUP_POL_HOST_WKUP_POL_SHIFT (0U)
/*! HOST_WKUP_POL - Host Wakeup Polarity */
#define APU_CPU1_HOST_WKUP_POL_HOST_WKUP_POL(x)  (((uint32_t)(((uint32_t)(x)) << APU_CPU1_HOST_WKUP_POL_HOST_WKUP_POL_SHIFT)) & APU_CPU1_HOST_WKUP_POL_HOST_WKUP_POL_MASK)
/*! @} */

/*! @name CAL_WIN_CNT - Calibration Window Count */
/*! @{ */

#define APU_CAL_WIN_CNT_APU_CAL_WIN_CNT_MASK     (0xFFFFFFFFU)
#define APU_CAL_WIN_CNT_APU_CAL_WIN_CNT_SHIFT    (0U)
/*! APU_CAL_WIN_CNT - Number of calibration clocks elapsed during calibration window */
#define APU_CAL_WIN_CNT_APU_CAL_WIN_CNT(x)       (((uint32_t)(((uint32_t)(x)) << APU_CAL_WIN_CNT_APU_CAL_WIN_CNT_SHIFT)) & APU_CAL_WIN_CNT_APU_CAL_WIN_CNT_MASK)
/*! @} */

/*! @name AUTO_10US - Auto 10us */
/*! @{ */

#define APU_AUTO_10US_APU_AUTO_10US_MASK         (0xFFFFFFFFU)
#define APU_AUTO_10US_APU_AUTO_10US_SHIFT        (0U)
/*! APU_AUTO_10US - auto alarm value loaded during auto calibration */
#define APU_AUTO_10US_APU_AUTO_10US(x)           (((uint32_t)(((uint32_t)(x)) << APU_AUTO_10US_APU_AUTO_10US_SHIFT)) & APU_AUTO_10US_APU_AUTO_10US_MASK)
/*! @} */

/*! @name ACC_CNT - Accumulation Count */
/*! @{ */

#define APU_ACC_CNT_APU_ACC_CNT_MASK             (0xFFFFFFFFU)
#define APU_ACC_CNT_APU_ACC_CNT_SHIFT            (0U)
/*! APU_ACC_CNT - number of sleep clocks elapsed during the calibration window */
#define APU_ACC_CNT_APU_ACC_CNT(x)               (((uint32_t)(((uint32_t)(x)) << APU_ACC_CNT_APU_ACC_CNT_SHIFT)) & APU_ACC_CNT_APU_ACC_CNT_MASK)
/*! @} */

/*! @name CAL_WIN_SIZE - Calibration Window Size */
/*! @{ */

#define APU_CAL_WIN_SIZE_APU_CAL_WIN_SIZE_MASK   (0xFFFFFFFFU)
#define APU_CAL_WIN_SIZE_APU_CAL_WIN_SIZE_SHIFT  (0U)
/*! APU_CAL_WIN_SIZE - calibration window size in number of calibration clocks. */
#define APU_CAL_WIN_SIZE_APU_CAL_WIN_SIZE(x)     (((uint32_t)(((uint32_t)(x)) << APU_CAL_WIN_SIZE_APU_CAL_WIN_SIZE_SHIFT)) & APU_CAL_WIN_SIZE_APU_CAL_WIN_SIZE_MASK)
/*! @} */

/*! @name SLP_CLK_TIMER - Sleep Clock Timer */
/*! @{ */

#define APU_SLP_CLK_TIMER_APU_SLP_CLK_TIMER_MASK (0xFFFFFFFFU)
#define APU_SLP_CLK_TIMER_APU_SLP_CLK_TIMER_SHIFT (0U)
/*! APU_SLP_CLK_TIMER - reads back the current value of the free running sleep clock counter. */
#define APU_SLP_CLK_TIMER_APU_SLP_CLK_TIMER(x)   (((uint32_t)(((uint32_t)(x)) << APU_SLP_CLK_TIMER_APU_SLP_CLK_TIMER_SHIFT)) & APU_SLP_CLK_TIMER_APU_SLP_CLK_TIMER_MASK)
/*! @} */

/*! @name STATUS_RD - Status Read */
/*! @{ */

#define APU_STATUS_RD_CALIBRATION_STATUS_MASK    (0x1U)
#define APU_STATUS_RD_CALIBRATION_STATUS_SHIFT   (0U)
/*! CALIBRATION_STATUS - Calibration Status */
#define APU_STATUS_RD_CALIBRATION_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_CALIBRATION_STATUS_SHIFT)) & APU_STATUS_RD_CALIBRATION_STATUS_MASK)

#define APU_STATUS_RD_APU_PLL_STABLE_0_MASK      (0x2U)
#define APU_STATUS_RD_APU_PLL_STABLE_0_SHIFT     (1U)
/*! APU_PLL_STABLE_0 - T1 PLL stable */
#define APU_STATUS_RD_APU_PLL_STABLE_0(x)        (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_APU_PLL_STABLE_0_SHIFT)) & APU_STATUS_RD_APU_PLL_STABLE_0_MASK)

#define APU_STATUS_RD_APU_PLL_STABLE_1_MASK      (0x4U)
#define APU_STATUS_RD_APU_PLL_STABLE_1_SHIFT     (2U)
/*! APU_PLL_STABLE_1 - APU PLL Stable[1] */
#define APU_STATUS_RD_APU_PLL_STABLE_1(x)        (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_APU_PLL_STABLE_1_SHIFT)) & APU_STATUS_RD_APU_PLL_STABLE_1_MASK)

#define APU_STATUS_RD_APU_XOSC_STABLE_MASK       (0x8U)
#define APU_STATUS_RD_APU_XOSC_STABLE_SHIFT      (3U)
/*! APU_XOSC_STABLE - APU XOSC Stable */
#define APU_STATUS_RD_APU_XOSC_STABLE(x)         (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_APU_XOSC_STABLE_SHIFT)) & APU_STATUS_RD_APU_XOSC_STABLE_MASK)

#define APU_STATUS_RD_APU_BT2_CLK_EN_MASK        (0x10U)
#define APU_STATUS_RD_APU_BT2_CLK_EN_SHIFT       (4U)
/*! APU_BT2_CLK_EN - APU Bluetooth2 Clock Enable */
#define APU_STATUS_RD_APU_BT2_CLK_EN(x)          (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_APU_BT2_CLK_EN_SHIFT)) & APU_STATUS_RD_APU_BT2_CLK_EN_MASK)

#define APU_STATUS_RD_APU_MAC_CLK_EN2_MASK       (0x20U)
#define APU_STATUS_RD_APU_MAC_CLK_EN2_SHIFT      (5U)
/*! APU_MAC_CLK_EN2 - APU MAC Clock Enable 2 */
#define APU_STATUS_RD_APU_MAC_CLK_EN2(x)         (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_APU_MAC_CLK_EN2_SHIFT)) & APU_STATUS_RD_APU_MAC_CLK_EN2_MASK)

#define APU_STATUS_RD_APU_BT_CLK_EN_MASK         (0x40U)
#define APU_STATUS_RD_APU_BT_CLK_EN_SHIFT        (6U)
/*! APU_BT_CLK_EN - APU Bluetooth Clock Enable */
#define APU_STATUS_RD_APU_BT_CLK_EN(x)           (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_APU_BT_CLK_EN_SHIFT)) & APU_STATUS_RD_APU_BT_CLK_EN_MASK)

#define APU_STATUS_RD_APU_MAC_CLK_EN1_MASK       (0x80U)
#define APU_STATUS_RD_APU_MAC_CLK_EN1_SHIFT      (7U)
/*! APU_MAC_CLK_EN1 - APU MAC Clock Enable 1 */
#define APU_STATUS_RD_APU_MAC_CLK_EN1(x)         (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_APU_MAC_CLK_EN1_SHIFT)) & APU_STATUS_RD_APU_MAC_CLK_EN1_MASK)

#define APU_STATUS_RD_APU_SYS_CLK_EN_MASK        (0x100U)
#define APU_STATUS_RD_APU_SYS_CLK_EN_SHIFT       (8U)
/*! APU_SYS_CLK_EN - APU System Clock Enable */
#define APU_STATUS_RD_APU_SYS_CLK_EN(x)          (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_APU_SYS_CLK_EN_SHIFT)) & APU_STATUS_RD_APU_SYS_CLK_EN_MASK)

#define APU_STATUS_RD_APU_SOC_CLK_EN3_MASK       (0x200U)
#define APU_STATUS_RD_APU_SOC_CLK_EN3_SHIFT      (9U)
/*! APU_SOC_CLK_EN3 - APU SoC Clock Enable 3 */
#define APU_STATUS_RD_APU_SOC_CLK_EN3(x)         (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_APU_SOC_CLK_EN3_SHIFT)) & APU_STATUS_RD_APU_SOC_CLK_EN3_MASK)

#define APU_STATUS_RD_APU_SOC_CLK_EN2_MASK       (0x400U)
#define APU_STATUS_RD_APU_SOC_CLK_EN2_SHIFT      (10U)
/*! APU_SOC_CLK_EN2 - APU SoC Clock Enable 2 */
#define APU_STATUS_RD_APU_SOC_CLK_EN2(x)         (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_APU_SOC_CLK_EN2_SHIFT)) & APU_STATUS_RD_APU_SOC_CLK_EN2_MASK)

#define APU_STATUS_RD_APU_SOC_CLK_EN1_MASK       (0x800U)
#define APU_STATUS_RD_APU_SOC_CLK_EN1_SHIFT      (11U)
/*! APU_SOC_CLK_EN1 - APU SoC Clock Enable 1 */
#define APU_STATUS_RD_APU_SOC_CLK_EN1(x)         (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_APU_SOC_CLK_EN1_SHIFT)) & APU_STATUS_RD_APU_SOC_CLK_EN1_MASK)

#define APU_STATUS_RD_APU_SLEEP_FSM_STATE_MASK   (0xF000U)
#define APU_STATUS_RD_APU_SLEEP_FSM_STATE_SHIFT  (12U)
/*! APU_SLEEP_FSM_STATE - APU Sleep FSM State */
#define APU_STATUS_RD_APU_SLEEP_FSM_STATE(x)     (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_APU_SLEEP_FSM_STATE_SHIFT)) & APU_STATUS_RD_APU_SLEEP_FSM_STATE_MASK)

#define APU_STATUS_RD_HOST_WKUP_AFTER_MASK_MASK  (0xFFFF0000U)
#define APU_STATUS_RD_HOST_WKUP_AFTER_MASK_SHIFT (16U)
/*! HOST_WKUP_AFTER_MASK - Host Wakeup After Mask */
#define APU_STATUS_RD_HOST_WKUP_AFTER_MASK(x)    (((uint32_t)(((uint32_t)(x)) << APU_STATUS_RD_HOST_WKUP_AFTER_MASK_SHIFT)) & APU_STATUS_RD_HOST_WKUP_AFTER_MASK_MASK)
/*! @} */

/*! @name STABLE_CNT2 - Stable Count 2 */
/*! @{ */

#define APU_STABLE_CNT2_PLL2_STBL_CNT_MASK       (0xFFFFU)
#define APU_STABLE_CNT2_PLL2_STBL_CNT_SHIFT      (0U)
/*! PLL2_STBL_CNT - T3 stable count in reference clocks */
#define APU_STABLE_CNT2_PLL2_STBL_CNT(x)         (((uint32_t)(((uint32_t)(x)) << APU_STABLE_CNT2_PLL2_STBL_CNT_SHIFT)) & APU_STABLE_CNT2_PLL2_STBL_CNT_MASK)
/*! @} */

/*! @name DYN_PLL_MASK - Dynamic PLL Mask */
/*! @{ */

#define APU_DYN_PLL_MASK_BT_PLL_REQ_MASK_MASK    (0x20U)
#define APU_DYN_PLL_MASK_BT_PLL_REQ_MASK_SHIFT   (5U)
/*! BT_PLL_REQ_MASK - When mask =0, bt_pll_req treated as pll_req */
#define APU_DYN_PLL_MASK_BT_PLL_REQ_MASK(x)      (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_MASK_BT_PLL_REQ_MASK_SHIFT)) & APU_DYN_PLL_MASK_BT_PLL_REQ_MASK_MASK)

#define APU_DYN_PLL_MASK_BRF_PLL_REQ_MASK_MASK   (0x40U)
#define APU_DYN_PLL_MASK_BRF_PLL_REQ_MASK_SHIFT  (6U)
/*! BRF_PLL_REQ_MASK - When mask =0, brf_pll_req treated as pll_req */
#define APU_DYN_PLL_MASK_BRF_PLL_REQ_MASK(x)     (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_MASK_BRF_PLL_REQ_MASK_SHIFT)) & APU_DYN_PLL_MASK_BRF_PLL_REQ_MASK_MASK)

#define APU_DYN_PLL_MASK_BT_AES_CLK_REQ_MASK_MASK (0x80U)
#define APU_DYN_PLL_MASK_BT_AES_CLK_REQ_MASK_SHIFT (7U)
/*! BT_AES_CLK_REQ_MASK - When mask is 0, bt_aes_clk_req is treated as pll_req of bt_aes_nco_mode =0 */
#define APU_DYN_PLL_MASK_BT_AES_CLK_REQ_MASK(x)  (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_MASK_BT_AES_CLK_REQ_MASK_SHIFT)) & APU_DYN_PLL_MASK_BT_AES_CLK_REQ_MASK_MASK)

#define APU_DYN_PLL_MASK_BT_CLK_REQ_PLL_REQ_MASK_MASK (0x100U)
#define APU_DYN_PLL_MASK_BT_CLK_REQ_PLL_REQ_MASK_SHIFT (8U)
/*! BT_CLK_REQ_PLL_REQ_MASK - When mask is 0, bt_clk_req is treated as pll_req if soc_use_ref_only = 0 */
#define APU_DYN_PLL_MASK_BT_CLK_REQ_PLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_MASK_BT_CLK_REQ_PLL_REQ_MASK_SHIFT)) & APU_DYN_PLL_MASK_BT_CLK_REQ_PLL_REQ_MASK_MASK)

#define APU_DYN_PLL_MASK_BT_SLP_RDY_PLL_REQ_MASK_MASK (0x200U)
#define APU_DYN_PLL_MASK_BT_SLP_RDY_PLL_REQ_MASK_SHIFT (9U)
/*! BT_SLP_RDY_PLL_REQ_MASK - When mask is 0, !bt_slp_rdy is treated as pll_req if soc_use_ref_only = 0 */
#define APU_DYN_PLL_MASK_BT_SLP_RDY_PLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_MASK_BT_SLP_RDY_PLL_REQ_MASK_SHIFT)) & APU_DYN_PLL_MASK_BT_SLP_RDY_PLL_REQ_MASK_MASK)

#define APU_DYN_PLL_MASK_BLE_SLP_RDY_PLL_REQ_MASK_MASK (0x400U)
#define APU_DYN_PLL_MASK_BLE_SLP_RDY_PLL_REQ_MASK_SHIFT (10U)
/*! BLE_SLP_RDY_PLL_REQ_MASK - When mask is 0, !ble_slp_rdy is treated as pll_req if soc_use_ref_only = 0 */
#define APU_DYN_PLL_MASK_BLE_SLP_RDY_PLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_MASK_BLE_SLP_RDY_PLL_REQ_MASK_SHIFT)) & APU_DYN_PLL_MASK_BLE_SLP_RDY_PLL_REQ_MASK_MASK)

#define APU_DYN_PLL_MASK_CPU2_CP15_PLL_REQ_MASK_MASK (0x800U)
#define APU_DYN_PLL_MASK_CPU2_CP15_PLL_REQ_MASK_SHIFT (11U)
/*! CPU2_CP15_PLL_REQ_MASK - When mask is 0, !cpu2_cp15_sleep is treated as pll_req if soc_use_ref_only = 0 */
#define APU_DYN_PLL_MASK_CPU2_CP15_PLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_MASK_CPU2_CP15_PLL_REQ_MASK_SHIFT)) & APU_DYN_PLL_MASK_CPU2_CP15_PLL_REQ_MASK_MASK)

#define APU_DYN_PLL_MASK_SD_CLK_SWITCH_OK_MASK_MASK (0x1000U)
#define APU_DYN_PLL_MASK_SD_CLK_SWITCH_OK_MASK_SHIFT (12U)
/*! SD_CLK_SWITCH_OK_MASK - SD Clock Switch Ok Mask */
#define APU_DYN_PLL_MASK_SD_CLK_SWITCH_OK_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_MASK_SD_CLK_SWITCH_OK_MASK_SHIFT)) & APU_DYN_PLL_MASK_SD_CLK_SWITCH_OK_MASK_MASK)

#define APU_DYN_PLL_MASK_GEN_TIMER_WKUP_PLL_REQ_MASK_MASK (0x2000U)
#define APU_DYN_PLL_MASK_GEN_TIMER_WKUP_PLL_REQ_MASK_SHIFT (13U)
/*! GEN_TIMER_WKUP_PLL_REQ_MASK - When mask is 0, gen_timer_wkup_wkup is treated as pll_req if soc_use_ref_only = 0 */
#define APU_DYN_PLL_MASK_GEN_TIMER_WKUP_PLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_MASK_GEN_TIMER_WKUP_PLL_REQ_MASK_SHIFT)) & APU_DYN_PLL_MASK_GEN_TIMER_WKUP_PLL_REQ_MASK_MASK)

#define APU_DYN_PLL_MASK_FULL_SLP_MASK_MASK      (0x4000U)
#define APU_DYN_PLL_MASK_FULL_SLP_MASK_SHIFT     (14U)
/*! FULL_SLP_MASK - Full Sleep Mask */
#define APU_DYN_PLL_MASK_FULL_SLP_MASK(x)        (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_MASK_FULL_SLP_MASK_SHIFT)) & APU_DYN_PLL_MASK_FULL_SLP_MASK_MASK)

#define APU_DYN_PLL_MASK_HOST_WKUP_PLL_REQ_MASK_MASK (0xFFFF0000U)
#define APU_DYN_PLL_MASK_HOST_WKUP_PLL_REQ_MASK_SHIFT (16U)
/*! HOST_WKUP_PLL_REQ_MASK - When mask is 0, host_wkup is treated as pll_req if soc_use_ref_only = 0 */
#define APU_DYN_PLL_MASK_HOST_WKUP_PLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_MASK_HOST_WKUP_PLL_REQ_MASK_SHIFT)) & APU_DYN_PLL_MASK_HOST_WKUP_PLL_REQ_MASK_MASK)
/*! @} */

/*! @name TESTBUS_RD1 - Testbus Read 1 */
/*! @{ */

#define APU_TESTBUS_RD1_TIMER_CNTR_MASK          (0xFFFFU)
#define APU_TESTBUS_RD1_TIMER_CNTR_SHIFT         (0U)
/*! TIMER_CNTR - DVFS internal counter */
#define APU_TESTBUS_RD1_TIMER_CNTR(x)            (((uint32_t)(((uint32_t)(x)) << APU_TESTBUS_RD1_TIMER_CNTR_SHIFT)) & APU_TESTBUS_RD1_TIMER_CNTR_MASK)

#define APU_TESTBUS_RD1_DVFS_TIMER_MASK          (0xFFFF0000U)
#define APU_TESTBUS_RD1_DVFS_TIMER_SHIFT         (16U)
/*! DVFS_TIMER - DVFS timer */
#define APU_TESTBUS_RD1_DVFS_TIMER(x)            (((uint32_t)(((uint32_t)(x)) << APU_TESTBUS_RD1_DVFS_TIMER_SHIFT)) & APU_TESTBUS_RD1_DVFS_TIMER_MASK)
/*! @} */

/*! @name TESTBUS_RD2 - Testbus Read 2 */
/*! @{ */

#define APU_TESTBUS_RD2_APU_TESTBUS_RD2_MASK     (0xFFFFFFFFU)
#define APU_TESTBUS_RD2_APU_TESTBUS_RD2_SHIFT    (0U)
/*! APU_TESTBUS_RD2 - Last 8 FSM state changes are stored in the register */
#define APU_TESTBUS_RD2_APU_TESTBUS_RD2(x)       (((uint32_t)(((uint32_t)(x)) << APU_TESTBUS_RD2_APU_TESTBUS_RD2_SHIFT)) & APU_TESTBUS_RD2_APU_TESTBUS_RD2_MASK)
/*! @} */

/*! @name GENERIC_TIMER_CNT - Generic Timer Count */
/*! @{ */

#define APU_GENERIC_TIMER_CNT_GENERIC_TIMER_CNT_MASK (0xFFFFFFFFU)
#define APU_GENERIC_TIMER_CNT_GENERIC_TIMER_CNT_SHIFT (0U)
/*! GENERIC_TIMER_CNT - Generic Timer Count */
#define APU_GENERIC_TIMER_CNT_GENERIC_TIMER_CNT(x) (((uint32_t)(((uint32_t)(x)) << APU_GENERIC_TIMER_CNT_GENERIC_TIMER_CNT_SHIFT)) & APU_GENERIC_TIMER_CNT_GENERIC_TIMER_CNT_MASK)
/*! @} */

/*! @name CPU1_HOST_WKUP_CTRL - CPU1 Host Wakeup Control */
/*! @{ */

#define APU_CPU1_HOST_WKUP_CTRL_HOST_WKUP_CTRL_MASK (0xFFFFU)
#define APU_CPU1_HOST_WKUP_CTRL_HOST_WKUP_CTRL_SHIFT (0U)
/*! HOST_WKUP_CTRL - Host Wakeup Control */
#define APU_CPU1_HOST_WKUP_CTRL_HOST_WKUP_CTRL(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU1_HOST_WKUP_CTRL_HOST_WKUP_CTRL_SHIFT)) & APU_CPU1_HOST_WKUP_CTRL_HOST_WKUP_CTRL_MASK)

#define APU_CPU1_HOST_WKUP_CTRL_HOST_INTR_MASK_MASK (0xFFFF0000U)
#define APU_CPU1_HOST_WKUP_CTRL_HOST_INTR_MASK_SHIFT (16U)
/*! HOST_INTR_MASK - Host Interrupt Mask */
#define APU_CPU1_HOST_WKUP_CTRL_HOST_INTR_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU1_HOST_WKUP_CTRL_HOST_INTR_MASK_SHIFT)) & APU_CPU1_HOST_WKUP_CTRL_HOST_INTR_MASK_MASK)
/*! @} */

/*! @name DYN_PLL_CLK_EXT_CTRL - Dynamic PLL Clock Ext Control */
/*! @{ */

#define APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK1_EXT_EN_MASK (0x1U)
#define APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK1_EXT_EN_SHIFT (0U)
/*! SOC_CLK1_EXT_EN - SoC Clock 1 Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK1_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK1_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK1_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK2_EXT_EN_MASK (0x2U)
#define APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK2_EXT_EN_SHIFT (1U)
/*! SOC_CLK2_EXT_EN - SoC Clock 2 Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK2_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK2_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK2_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK3_EXT_EN_MASK (0x4U)
#define APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK3_EXT_EN_SHIFT (2U)
/*! SOC_CLK3_EXT_EN - SoC Clock 3 Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK3_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK3_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_SOC_CLK3_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_CPU1_PLL_EXT_EN_MASK (0x10U)
#define APU_DYN_PLL_CLK_EXT_CTRL_CPU1_PLL_EXT_EN_SHIFT (4U)
/*! CPU1_PLL_EXT_EN - CPU1 PLL Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_CPU1_PLL_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_CPU1_PLL_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_CPU1_PLL_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_CPU1_INACTIVE_EXT_EN_MASK (0x20U)
#define APU_DYN_PLL_CLK_EXT_CTRL_CPU1_INACTIVE_EXT_EN_SHIFT (5U)
/*! CPU1_INACTIVE_EXT_EN - CPU1 Inactive Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_CPU1_INACTIVE_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_CPU1_INACTIVE_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_CPU1_INACTIVE_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_CPU2_PLL_EXT_EN_MASK (0x40U)
#define APU_DYN_PLL_CLK_EXT_CTRL_CPU2_PLL_EXT_EN_SHIFT (6U)
/*! CPU2_PLL_EXT_EN - CPU2 PLL Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_CPU2_PLL_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_CPU2_PLL_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_CPU2_PLL_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_CPU2_INACTIVE_EXT_EN_MASK (0x80U)
#define APU_DYN_PLL_CLK_EXT_CTRL_CPU2_INACTIVE_EXT_EN_SHIFT (7U)
/*! CPU2_INACTIVE_EXT_EN - CPU2 Inactive Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_CPU2_INACTIVE_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_CPU2_INACTIVE_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_CPU2_INACTIVE_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_T1_EXT_EN_MASK  (0x100U)
#define APU_DYN_PLL_CLK_EXT_CTRL_T1_EXT_EN_SHIFT (8U)
/*! T1_EXT_EN - T1 Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_T1_EXT_EN(x)    (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_T1_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_T1_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_T3_EXT_EN_MASK  (0x200U)
#define APU_DYN_PLL_CLK_EXT_CTRL_T3_EXT_EN_SHIFT (9U)
/*! T3_EXT_EN - T3 Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_T3_EXT_EN(x)    (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_T3_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_T3_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_DVFS_T1_EXT_EN_MASK (0x400U)
#define APU_DYN_PLL_CLK_EXT_CTRL_DVFS_T1_EXT_EN_SHIFT (10U)
/*! DVFS_T1_EXT_EN - DVFS T1 Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_DVFS_T1_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_DVFS_T1_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_DVFS_T1_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_CPU3_PLL_EXT_EN_MASK (0x800U)
#define APU_DYN_PLL_CLK_EXT_CTRL_CPU3_PLL_EXT_EN_SHIFT (11U)
/*! CPU3_PLL_EXT_EN - CPU3 PLL Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_CPU3_PLL_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_CPU3_PLL_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_CPU3_PLL_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_CPU3_INACTIVE_EXT_EN_MASK (0x1000U)
#define APU_DYN_PLL_CLK_EXT_CTRL_CPU3_INACTIVE_EXT_EN_SHIFT (12U)
/*! CPU3_INACTIVE_EXT_EN - CPU3 Inactive Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_CPU3_INACTIVE_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_CPU3_INACTIVE_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_CPU3_INACTIVE_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_BT2_AES_CLK_EXT_EN_MASK (0x10000000U)
#define APU_DYN_PLL_CLK_EXT_CTRL_BT2_AES_CLK_EXT_EN_SHIFT (28U)
/*! BT2_AES_CLK_EXT_EN - BLuetooth2 AES Clock Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_BT2_AES_CLK_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_BT2_AES_CLK_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_BT2_AES_CLK_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_BT2_AES_PLL_EXT_EN_MASK (0x20000000U)
#define APU_DYN_PLL_CLK_EXT_CTRL_BT2_AES_PLL_EXT_EN_SHIFT (29U)
/*! BT2_AES_PLL_EXT_EN - Bluetooth2 AES PLL Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_BT2_AES_PLL_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_BT2_AES_PLL_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_BT2_AES_PLL_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_BT_AES_CLK_EXT_EN_MASK (0x40000000U)
#define APU_DYN_PLL_CLK_EXT_CTRL_BT_AES_CLK_EXT_EN_SHIFT (30U)
/*! BT_AES_CLK_EXT_EN - BLuetooth AES Clock Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_BT_AES_CLK_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_BT_AES_CLK_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_BT_AES_CLK_EXT_EN_MASK)

#define APU_DYN_PLL_CLK_EXT_CTRL_BT_AES_PLL_EXT_EN_MASK (0x80000000U)
#define APU_DYN_PLL_CLK_EXT_CTRL_BT_AES_PLL_EXT_EN_SHIFT (31U)
/*! BT_AES_PLL_EXT_EN - Bluetooth AES PLL Ext Enable */
#define APU_DYN_PLL_CLK_EXT_CTRL_BT_AES_PLL_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_DYN_PLL_CLK_EXT_CTRL_BT_AES_PLL_EXT_EN_SHIFT)) & APU_DYN_PLL_CLK_EXT_CTRL_BT_AES_PLL_EXT_EN_MASK)
/*! @} */

/*! @name GENERIC_SLP_START_VAL - Generic Sleep Start Value */
/*! @{ */

#define APU_GENERIC_SLP_START_VAL_GENERIC_SLP_START_VAL_MASK (0xFFFFFFFFU)
#define APU_GENERIC_SLP_START_VAL_GENERIC_SLP_START_VAL_SHIFT (0U)
/*! GENERIC_SLP_START_VAL - Generic Sleep Start Value */
#define APU_GENERIC_SLP_START_VAL_GENERIC_SLP_START_VAL(x) (((uint32_t)(((uint32_t)(x)) << APU_GENERIC_SLP_START_VAL_GENERIC_SLP_START_VAL_SHIFT)) & APU_GENERIC_SLP_START_VAL_GENERIC_SLP_START_VAL_MASK)
/*! @} */

/*! @name DLY_HOST_CTRL - Delay Host Control */
/*! @{ */

#define APU_DLY_HOST_CTRL_DLY_HOST_WKUP_EN_MASK  (0x1U)
#define APU_DLY_HOST_CTRL_DLY_HOST_WKUP_EN_SHIFT (0U)
/*! DLY_HOST_WKUP_EN - Delay Host Wakeup Enable */
#define APU_DLY_HOST_CTRL_DLY_HOST_WKUP_EN(x)    (((uint32_t)(((uint32_t)(x)) << APU_DLY_HOST_CTRL_DLY_HOST_WKUP_EN_SHIFT)) & APU_DLY_HOST_CTRL_DLY_HOST_WKUP_EN_MASK)

#define APU_DLY_HOST_CTRL_HOST_WKUP_SEL_MASK     (0x78U)
#define APU_DLY_HOST_CTRL_HOST_WKUP_SEL_SHIFT    (3U)
/*! HOST_WKUP_SEL - selects which host wakeup to be delayed out of 16 hosts */
#define APU_DLY_HOST_CTRL_HOST_WKUP_SEL(x)       (((uint32_t)(((uint32_t)(x)) << APU_DLY_HOST_CTRL_HOST_WKUP_SEL_SHIFT)) & APU_DLY_HOST_CTRL_HOST_WKUP_SEL_MASK)

#define APU_DLY_HOST_CTRL_RST_HOST_WKUP_CNT_MASK (0x80U)
#define APU_DLY_HOST_CTRL_RST_HOST_WKUP_CNT_SHIFT (7U)
/*! RST_HOST_WKUP_CNT - Reset Host Wakeup Count */
#define APU_DLY_HOST_CTRL_RST_HOST_WKUP_CNT(x)   (((uint32_t)(((uint32_t)(x)) << APU_DLY_HOST_CTRL_RST_HOST_WKUP_CNT_SHIFT)) & APU_DLY_HOST_CTRL_RST_HOST_WKUP_CNT_MASK)

#define APU_DLY_HOST_CTRL_DLY_HOST_WKUP_CNT_MASK (0xFFFFFF00U)
#define APU_DLY_HOST_CTRL_DLY_HOST_WKUP_CNT_SHIFT (8U)
/*! DLY_HOST_WKUP_CNT - Number of sleep clocks to delay host wakeup interrupt */
#define APU_DLY_HOST_CTRL_DLY_HOST_WKUP_CNT(x)   (((uint32_t)(((uint32_t)(x)) << APU_DLY_HOST_CTRL_DLY_HOST_WKUP_CNT_SHIFT)) & APU_DLY_HOST_CTRL_DLY_HOST_WKUP_CNT_MASK)
/*! @} */

/*! @name HOST_WKUP_CNT - Host Wakeup Count */
/*! @{ */

#define APU_HOST_WKUP_CNT_HOST_WKUP_DLY_CNT_MASK (0xFFFFFFU)
#define APU_HOST_WKUP_CNT_HOST_WKUP_DLY_CNT_SHIFT (0U)
/*! HOST_WKUP_DLY_CNT - Host Wakeup Delay Count */
#define APU_HOST_WKUP_CNT_HOST_WKUP_DLY_CNT(x)   (((uint32_t)(((uint32_t)(x)) << APU_HOST_WKUP_CNT_HOST_WKUP_DLY_CNT_SHIFT)) & APU_HOST_WKUP_CNT_HOST_WKUP_DLY_CNT_MASK)
/*! @} */

/*! @name CPU2_HOST_WKUP_MASK - CPU2 Host Wakeup Mask */
/*! @{ */

#define APU_CPU2_HOST_WKUP_MASK_HOST_WKUP_MASK_MASK (0xFFFFU)
#define APU_CPU2_HOST_WKUP_MASK_HOST_WKUP_MASK_SHIFT (0U)
/*! HOST_WKUP_MASK - Host Wakeup Mask */
#define APU_CPU2_HOST_WKUP_MASK_HOST_WKUP_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_HOST_WKUP_MASK_HOST_WKUP_MASK_SHIFT)) & APU_CPU2_HOST_WKUP_MASK_HOST_WKUP_MASK_MASK)
/*! @} */

/*! @name CPU2_HOST_WKUP_POL - CPU2 Host Wakeup Polarity */
/*! @{ */

#define APU_CPU2_HOST_WKUP_POL_HOST_WKUP_POL_MASK (0xFFFFU)
#define APU_CPU2_HOST_WKUP_POL_HOST_WKUP_POL_SHIFT (0U)
/*! HOST_WKUP_POL - Host Wakeup Polarity */
#define APU_CPU2_HOST_WKUP_POL_HOST_WKUP_POL(x)  (((uint32_t)(((uint32_t)(x)) << APU_CPU2_HOST_WKUP_POL_HOST_WKUP_POL_SHIFT)) & APU_CPU2_HOST_WKUP_POL_HOST_WKUP_POL_MASK)
/*! @} */

/*! @name CPU2_HOST_WKUP_CTRL - CPU2 Host Wakeup Control */
/*! @{ */

#define APU_CPU2_HOST_WKUP_CTRL_HOST_WKUP_CTRL_MASK (0xFFFFU)
#define APU_CPU2_HOST_WKUP_CTRL_HOST_WKUP_CTRL_SHIFT (0U)
/*! HOST_WKUP_CTRL - Host Wakeup Control */
#define APU_CPU2_HOST_WKUP_CTRL_HOST_WKUP_CTRL(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_HOST_WKUP_CTRL_HOST_WKUP_CTRL_SHIFT)) & APU_CPU2_HOST_WKUP_CTRL_HOST_WKUP_CTRL_MASK)

#define APU_CPU2_HOST_WKUP_CTRL_HOST_INTR_MASK_MASK (0xFFFF0000U)
#define APU_CPU2_HOST_WKUP_CTRL_HOST_INTR_MASK_SHIFT (16U)
/*! HOST_INTR_MASK - Host Interrupt Mask */
#define APU_CPU2_HOST_WKUP_CTRL_HOST_INTR_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_HOST_WKUP_CTRL_HOST_INTR_MASK_SHIFT)) & APU_CPU2_HOST_WKUP_CTRL_HOST_INTR_MASK_MASK)
/*! @} */

/*! @name CPU2_CTRL - CPU2 Control */
/*! @{ */

#define APU_CPU2_CTRL_CPU2_MSG_RDY_MASK_MASK     (0x1U)
#define APU_CPU2_CTRL_CPU2_MSG_RDY_MASK_SHIFT    (0U)
/*! CPU2_MSG_RDY_MASK - CPU2 Message Ready Mask */
#define APU_CPU2_CTRL_CPU2_MSG_RDY_MASK(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU2_CTRL_CPU2_MSG_RDY_MASK_SHIFT)) & APU_CPU2_CTRL_CPU2_MSG_RDY_MASK_MASK)

#define APU_CPU2_CTRL_CPU2_CP15_SLP_BYPASS_VAL_MASK (0x4U)
#define APU_CPU2_CTRL_CPU2_CP15_SLP_BYPASS_VAL_SHIFT (2U)
/*! CPU2_CP15_SLP_BYPASS_VAL - CPU2 CP15 Sleep Bypass Value */
#define APU_CPU2_CTRL_CPU2_CP15_SLP_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_CTRL_CPU2_CP15_SLP_BYPASS_VAL_SHIFT)) & APU_CPU2_CTRL_CPU2_CP15_SLP_BYPASS_VAL_MASK)

#define APU_CPU2_CTRL_CPU2_CP15_SLP_BYPASS_EN_MASK (0x8U)
#define APU_CPU2_CTRL_CPU2_CP15_SLP_BYPASS_EN_SHIFT (3U)
/*! CPU2_CP15_SLP_BYPASS_EN - CPU2 CP15 Sleep Bypass Enable */
#define APU_CPU2_CTRL_CPU2_CP15_SLP_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_CTRL_CPU2_CP15_SLP_BYPASS_EN_SHIFT)) & APU_CPU2_CTRL_CPU2_CP15_SLP_BYPASS_EN_MASK)

#define APU_CPU2_CTRL_SOC_USE_REF_ONLY_MASK      (0x10U)
#define APU_CPU2_CTRL_SOC_USE_REF_ONLY_SHIFT     (4U)
/*! SOC_USE_REF_ONLY - SoC Use Ref Only */
#define APU_CPU2_CTRL_SOC_USE_REF_ONLY(x)        (((uint32_t)(((uint32_t)(x)) << APU_CPU2_CTRL_SOC_USE_REF_ONLY_SHIFT)) & APU_CPU2_CTRL_SOC_USE_REF_ONLY_MASK)

#define APU_CPU2_CTRL_GENERIC_TIMER_EN2_MASK     (0x20U)
#define APU_CPU2_CTRL_GENERIC_TIMER_EN2_SHIFT    (5U)
/*! GENERIC_TIMER_EN2 - Generic Timer Enable 2 */
#define APU_CPU2_CTRL_GENERIC_TIMER_EN2(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU2_CTRL_GENERIC_TIMER_EN2_SHIFT)) & APU_CPU2_CTRL_GENERIC_TIMER_EN2_MASK)

#define APU_CPU2_CTRL_APU_SUBSYS2_HOST_MASK      (0x70000U)
#define APU_CPU2_CTRL_APU_SUBSYS2_HOST_SHIFT     (16U)
/*! APU_SUBSYS2_HOST - APU Subsystem 2 Host */
#define APU_CPU2_CTRL_APU_SUBSYS2_HOST(x)        (((uint32_t)(((uint32_t)(x)) << APU_CPU2_CTRL_APU_SUBSYS2_HOST_SHIFT)) & APU_CPU2_CTRL_APU_SUBSYS2_HOST_MASK)
/*! @} */

/*! @name WLAN_PWR_CTRL_DLY - Wlan domain FSM Power Control Delay */
/*! @{ */

#define APU_WLAN_PWR_CTRL_DLY_PWR_CTRL_DLY_MASK  (0xFFFFFFFFU)
#define APU_WLAN_PWR_CTRL_DLY_PWR_CTRL_DLY_SHIFT (0U)
/*! PWR_CTRL_DLY - Wlan domain FSM Power Control Delay */
#define APU_WLAN_PWR_CTRL_DLY_PWR_CTRL_DLY(x)    (((uint32_t)(((uint32_t)(x)) << APU_WLAN_PWR_CTRL_DLY_PWR_CTRL_DLY_SHIFT)) & APU_WLAN_PWR_CTRL_DLY_PWR_CTRL_DLY_MASK)
/*! @} */

/*! @name STATUS2 - Status 2 */
/*! @{ */

#define APU_STATUS2_CPU1_MSG_RDY_INT_MASK        (0x1U)
#define APU_STATUS2_CPU1_MSG_RDY_INT_SHIFT       (0U)
/*! CPU1_MSG_RDY_INT - CPU1 Message Ready */
#define APU_STATUS2_CPU1_MSG_RDY_INT(x)          (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_CPU1_MSG_RDY_INT_SHIFT)) & APU_STATUS2_CPU1_MSG_RDY_INT_MASK)

#define APU_STATUS2_CPU2_MSG_RDY_INT_MASK        (0x2U)
#define APU_STATUS2_CPU2_MSG_RDY_INT_SHIFT       (1U)
/*! CPU2_MSG_RDY_INT - CPU2 Message Ready */
#define APU_STATUS2_CPU2_MSG_RDY_INT(x)          (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_CPU2_MSG_RDY_INT_SHIFT)) & APU_STATUS2_CPU2_MSG_RDY_INT_MASK)

#define APU_STATUS2_CPU3_MSG_RDY_INT_MASK        (0x4U)
#define APU_STATUS2_CPU3_MSG_RDY_INT_SHIFT       (2U)
/*! CPU3_MSG_RDY_INT - CPU3 Message Ready */
#define APU_STATUS2_CPU3_MSG_RDY_INT(x)          (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_CPU3_MSG_RDY_INT_SHIFT)) & APU_STATUS2_CPU3_MSG_RDY_INT_MASK)

#define APU_STATUS2_LMU_G2BIST_FINISH_MASK       (0x8U)
#define APU_STATUS2_LMU_G2BIST_FINISH_SHIFT      (3U)
/*! LMU_G2BIST_FINISH - LMU G2BIST finish */
#define APU_STATUS2_LMU_G2BIST_FINISH(x)         (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_LMU_G2BIST_FINISH_SHIFT)) & APU_STATUS2_LMU_G2BIST_FINISH_MASK)

#define APU_STATUS2_APU_BT_AES_CLK_EN_MASK       (0x10U)
#define APU_STATUS2_APU_BT_AES_CLK_EN_SHIFT      (4U)
/*! APU_BT_AES_CLK_EN - BT AES Clk enable */
#define APU_STATUS2_APU_BT_AES_CLK_EN(x)         (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_BT_AES_CLK_EN_SHIFT)) & APU_STATUS2_APU_BT_AES_CLK_EN_MASK)

#define APU_STATUS2_APU_BT2_AES_CLK_EN_MASK      (0x20U)
#define APU_STATUS2_APU_BT2_AES_CLK_EN_SHIFT     (5U)
/*! APU_BT2_AES_CLK_EN - BT2 AES Clk enable */
#define APU_STATUS2_APU_BT2_AES_CLK_EN(x)        (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_BT2_AES_CLK_EN_SHIFT)) & APU_STATUS2_APU_BT2_AES_CLK_EN_MASK)

#define APU_STATUS2_APU_BT_AES_CLK_SEL_MASK      (0x40U)
#define APU_STATUS2_APU_BT_AES_CLK_SEL_SHIFT     (6U)
/*! APU_BT_AES_CLK_SEL - BT AES clk select */
#define APU_STATUS2_APU_BT_AES_CLK_SEL(x)        (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_BT_AES_CLK_SEL_SHIFT)) & APU_STATUS2_APU_BT_AES_CLK_SEL_MASK)

#define APU_STATUS2_APU_BT2_AES_CLK_SEL_MASK     (0x80U)
#define APU_STATUS2_APU_BT2_AES_CLK_SEL_SHIFT    (7U)
/*! APU_BT2_AES_CLK_SEL - BT2 AES clk select */
#define APU_STATUS2_APU_BT2_AES_CLK_SEL(x)       (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_BT2_AES_CLK_SEL_SHIFT)) & APU_STATUS2_APU_BT2_AES_CLK_SEL_MASK)

#define APU_STATUS2_APU_BRF_CLK_EN_MASK          (0x100U)
#define APU_STATUS2_APU_BRF_CLK_EN_SHIFT         (8U)
/*! APU_BRF_CLK_EN - BRF clk enable */
#define APU_STATUS2_APU_BRF_CLK_EN(x)            (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_BRF_CLK_EN_SHIFT)) & APU_STATUS2_APU_BRF_CLK_EN_MASK)

#define APU_STATUS2_APU_BRF2_CLK_EN_MASK         (0x200U)
#define APU_STATUS2_APU_BRF2_CLK_EN_SHIFT        (9U)
/*! APU_BRF2_CLK_EN - BRF2 clk enable */
#define APU_STATUS2_APU_BRF2_CLK_EN(x)           (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_BRF2_CLK_EN_SHIFT)) & APU_STATUS2_APU_BRF2_CLK_EN_MASK)

#define APU_STATUS2_APU_INTR_BT_WAKEUP_MASK      (0x400U)
#define APU_STATUS2_APU_INTR_BT_WAKEUP_SHIFT     (10U)
/*! APU_INTR_BT_WAKEUP - APU BT2 wakeup interrupt */
#define APU_STATUS2_APU_INTR_BT_WAKEUP(x)        (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_INTR_BT_WAKEUP_SHIFT)) & APU_STATUS2_APU_INTR_BT_WAKEUP_MASK)

#define APU_STATUS2_APU_INTR_BT2_WAKEUP_MASK     (0x800U)
#define APU_STATUS2_APU_INTR_BT2_WAKEUP_SHIFT    (11U)
/*! APU_INTR_BT2_WAKEUP - APU BT2 wakeup interrupt */
#define APU_STATUS2_APU_INTR_BT2_WAKEUP(x)       (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_INTR_BT2_WAKEUP_SHIFT)) & APU_STATUS2_APU_INTR_BT2_WAKEUP_MASK)

#define APU_STATUS2_APU_BBUD_CLK_EN1_MASK        (0x1000U)
#define APU_STATUS2_APU_BBUD_CLK_EN1_SHIFT       (12U)
/*! APU_BBUD_CLK_EN1 - bbud2 clk enable */
#define APU_STATUS2_APU_BBUD_CLK_EN1(x)          (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_BBUD_CLK_EN1_SHIFT)) & APU_STATUS2_APU_BBUD_CLK_EN1_MASK)

#define APU_STATUS2_APU_BBUD_CLK_EN2_MASK        (0x2000U)
#define APU_STATUS2_APU_BBUD_CLK_EN2_SHIFT       (13U)
/*! APU_BBUD_CLK_EN2 - bbud1 clk enable */
#define APU_STATUS2_APU_BBUD_CLK_EN2(x)          (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_BBUD_CLK_EN2_SHIFT)) & APU_STATUS2_APU_BBUD_CLK_EN2_MASK)

#define APU_STATUS2_APU_WL_RF_CLK_EN1_MASK       (0x4000U)
#define APU_STATUS2_APU_WL_RF_CLK_EN1_SHIFT      (14U)
/*! APU_WL_RF_CLK_EN1 - WLAN RFU1 clk enable */
#define APU_STATUS2_APU_WL_RF_CLK_EN1(x)         (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_WL_RF_CLK_EN1_SHIFT)) & APU_STATUS2_APU_WL_RF_CLK_EN1_MASK)

#define APU_STATUS2_APU_WL_RF_CLK_EN2_MASK       (0x8000U)
#define APU_STATUS2_APU_WL_RF_CLK_EN2_SHIFT      (15U)
/*! APU_WL_RF_CLK_EN2 - WLAN RFU1 clk enable */
#define APU_STATUS2_APU_WL_RF_CLK_EN2(x)         (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_WL_RF_CLK_EN2_SHIFT)) & APU_STATUS2_APU_WL_RF_CLK_EN2_MASK)

#define APU_STATUS2_APU_CAU_BT_ACTIVE_MASK       (0x10000U)
#define APU_STATUS2_APU_CAU_BT_ACTIVE_SHIFT      (16U)
/*! APU_CAU_BT_ACTIVE - APU CAU Bluetooth Active */
#define APU_STATUS2_APU_CAU_BT_ACTIVE(x)         (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_CAU_BT_ACTIVE_SHIFT)) & APU_STATUS2_APU_CAU_BT_ACTIVE_MASK)

#define APU_STATUS2_APU_SOC_CAU_LDO_XOSC_EN_MASK (0x20000U)
#define APU_STATUS2_APU_SOC_CAU_LDO_XOSC_EN_SHIFT (17U)
/*! APU_SOC_CAU_LDO_XOSC_EN - APU SoC CAU LOD XOSC Enable */
#define APU_STATUS2_APU_SOC_CAU_LDO_XOSC_EN(x)   (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_SOC_CAU_LDO_XOSC_EN_SHIFT)) & APU_STATUS2_APU_SOC_CAU_LDO_XOSC_EN_MASK)

#define APU_STATUS2_PCIE_P_REQ_MASK              (0x40000U)
#define APU_STATUS2_PCIE_P_REQ_SHIFT             (18U)
/*! PCIE_P_REQ - PCIe P req */
#define APU_STATUS2_PCIE_P_REQ(x)                (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_PCIE_P_REQ_SHIFT)) & APU_STATUS2_PCIE_P_REQ_MASK)

#define APU_STATUS2_PCIE_XP_REQ_MASK             (0x80000U)
#define APU_STATUS2_PCIE_XP_REQ_SHIFT            (19U)
/*! PCIE_XP_REQ - PCIe XP req */
#define APU_STATUS2_PCIE_XP_REQ(x)               (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_PCIE_XP_REQ_SHIFT)) & APU_STATUS2_PCIE_XP_REQ_MASK)

#define APU_STATUS2_BCA_CLK_REQ_MASK             (0x100000U)
#define APU_STATUS2_BCA_CLK_REQ_SHIFT            (20U)
/*! BCA_CLK_REQ - BCA Clock Request */
#define APU_STATUS2_BCA_CLK_REQ(x)               (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_BCA_CLK_REQ_SHIFT)) & APU_STATUS2_BCA_CLK_REQ_MASK)

#define APU_STATUS2_BCA_CLK_EN_MASK              (0x200000U)
#define APU_STATUS2_BCA_CLK_EN_SHIFT             (21U)
/*! BCA_CLK_EN - APU BCA Clock Enable */
#define APU_STATUS2_BCA_CLK_EN(x)                (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_BCA_CLK_EN_SHIFT)) & APU_STATUS2_BCA_CLK_EN_MASK)

#define APU_STATUS2_BCA_SLNA_ON_MASK             (0x400000U)
#define APU_STATUS2_BCA_SLNA_ON_SHIFT            (22U)
/*! BCA_SLNA_ON - BCA SLNA On */
#define APU_STATUS2_BCA_SLNA_ON(x)               (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_BCA_SLNA_ON_SHIFT)) & APU_STATUS2_BCA_SLNA_ON_MASK)

#define APU_STATUS2_BT_CLK_REQ_MASK              (0x800000U)
#define APU_STATUS2_BT_CLK_REQ_SHIFT             (23U)
/*! BT_CLK_REQ - BT clk req */
#define APU_STATUS2_BT_CLK_REQ(x)                (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_BT_CLK_REQ_SHIFT)) & APU_STATUS2_BT_CLK_REQ_MASK)

#define APU_STATUS2_BT2_CLK_REQ_MASK             (0x1000000U)
#define APU_STATUS2_BT2_CLK_REQ_SHIFT            (24U)
/*! BT2_CLK_REQ - BT2 clk req */
#define APU_STATUS2_BT2_CLK_REQ(x)               (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_BT2_CLK_REQ_SHIFT)) & APU_STATUS2_BT2_CLK_REQ_MASK)

#define APU_STATUS2_APU_DVFS_CLK_SEL_MASK        (0x2000000U)
#define APU_STATUS2_APU_DVFS_CLK_SEL_SHIFT       (25U)
/*! APU_DVFS_CLK_SEL - APU DVFS Clock Select */
#define APU_STATUS2_APU_DVFS_CLK_SEL(x)          (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_DVFS_CLK_SEL_SHIFT)) & APU_STATUS2_APU_DVFS_CLK_SEL_MASK)

#define APU_STATUS2_APU_INTR_WLAN_WAKEUP2_MASK   (0x4000000U)
#define APU_STATUS2_APU_INTR_WLAN_WAKEUP2_SHIFT  (26U)
/*! APU_INTR_WLAN_WAKEUP2 - APU wlan2 wakeup interrupt */
#define APU_STATUS2_APU_INTR_WLAN_WAKEUP2(x)     (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_INTR_WLAN_WAKEUP2_SHIFT)) & APU_STATUS2_APU_INTR_WLAN_WAKEUP2_MASK)

#define APU_STATUS2_APU_INTR_WLAN_WAKEUP1_MASK   (0x8000000U)
#define APU_STATUS2_APU_INTR_WLAN_WAKEUP1_SHIFT  (27U)
/*! APU_INTR_WLAN_WAKEUP1 - APU wlan1 wakeup interrupt */
#define APU_STATUS2_APU_INTR_WLAN_WAKEUP1(x)     (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_APU_INTR_WLAN_WAKEUP1_SHIFT)) & APU_STATUS2_APU_INTR_WLAN_WAKEUP1_MASK)

#define APU_STATUS2_AMU1_CP15_SLEEP_MASK         (0x10000000U)
#define APU_STATUS2_AMU1_CP15_SLEEP_SHIFT        (28U)
/*! AMU1_CP15_SLEEP - CPU1 CP15 Sleep */
#define APU_STATUS2_AMU1_CP15_SLEEP(x)           (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_AMU1_CP15_SLEEP_SHIFT)) & APU_STATUS2_AMU1_CP15_SLEEP_MASK)

#define APU_STATUS2_AMU2_CP15_SLEEP_MASK         (0x20000000U)
#define APU_STATUS2_AMU2_CP15_SLEEP_SHIFT        (29U)
/*! AMU2_CP15_SLEEP - CPU2 CP15 Sleep */
#define APU_STATUS2_AMU2_CP15_SLEEP(x)           (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_AMU2_CP15_SLEEP_SHIFT)) & APU_STATUS2_AMU2_CP15_SLEEP_MASK)

#define APU_STATUS2_AMU3_CP15_SLEEP_MASK         (0x40000000U)
#define APU_STATUS2_AMU3_CP15_SLEEP_SHIFT        (30U)
/*! AMU3_CP15_SLEEP - CPU3 CP15 Sleep */
#define APU_STATUS2_AMU3_CP15_SLEEP(x)           (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_AMU3_CP15_SLEEP_SHIFT)) & APU_STATUS2_AMU3_CP15_SLEEP_MASK)

#define APU_STATUS2_CPU1_APU_PD_MASK             (0x80000000U)
#define APU_STATUS2_CPU1_APU_PD_SHIFT            (31U)
/*! CPU1_APU_PD - CPU1 to APU powerdown */
#define APU_STATUS2_CPU1_APU_PD(x)               (((uint32_t)(((uint32_t)(x)) << APU_STATUS2_CPU1_APU_PD_SHIFT)) & APU_STATUS2_CPU1_APU_PD_MASK)
/*! @} */

/*! @name WLAN_PWR_CTRL_DLY2 - Wlan domain FSM Power Control Delay 2 */
/*! @{ */

#define APU_WLAN_PWR_CTRL_DLY2_PWR_CTRL_DLY2_MASK (0xFFFFFFFFU)
#define APU_WLAN_PWR_CTRL_DLY2_PWR_CTRL_DLY2_SHIFT (0U)
/*! PWR_CTRL_DLY2 - WLAN domain FSM power control delay 2 */
#define APU_WLAN_PWR_CTRL_DLY2_PWR_CTRL_DLY2(x)  (((uint32_t)(((uint32_t)(x)) << APU_WLAN_PWR_CTRL_DLY2_PWR_CTRL_DLY2_SHIFT)) & APU_WLAN_PWR_CTRL_DLY2_PWR_CTRL_DLY2_MASK)
/*! @} */

/*! @name WL_CTRL - WLAN Control */
/*! @{ */

#define APU_WL_CTRL_WL_SLP_RDY_MASK              (0x1U)
#define APU_WL_CTRL_WL_SLP_RDY_SHIFT             (0U)
/*! WL_SLP_RDY - WLAN Sleep Ready */
#define APU_WL_CTRL_WL_SLP_RDY(x)                (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_WL_SLP_RDY_SHIFT)) & APU_WL_CTRL_WL_SLP_RDY_MASK)

#define APU_WL_CTRL_WL_SLP_RDYMASK_MASK          (0x2U)
#define APU_WL_CTRL_WL_SLP_RDYMASK_SHIFT         (1U)
/*! WL_SLP_RDYMASK - WLAN Sleep Ready Mask */
#define APU_WL_CTRL_WL_SLP_RDYMASK(x)            (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_WL_SLP_RDYMASK_SHIFT)) & APU_WL_CTRL_WL_SLP_RDYMASK_MASK)

#define APU_WL_CTRL_WL_SLP_RDY_FW_MASK           (0x4U)
#define APU_WL_CTRL_WL_SLP_RDY_FW_SHIFT          (2U)
/*! WL_SLP_RDY_FW - WLAN Sleep Ready Firmware */
#define APU_WL_CTRL_WL_SLP_RDY_FW(x)             (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_WL_SLP_RDY_FW_SHIFT)) & APU_WL_CTRL_WL_SLP_RDY_FW_MASK)

#define APU_WL_CTRL_IDLE2ISO_DLY_EN_MASK         (0x20U)
#define APU_WL_CTRL_IDLE2ISO_DLY_EN_SHIFT        (5U)
/*! IDLE2ISO_DLY_EN - Delay from idle to iso to ensure delay from bbud_non_udr_rst_b =0 to wlan_iso_en = 1 */
#define APU_WL_CTRL_IDLE2ISO_DLY_EN(x)           (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_IDLE2ISO_DLY_EN_SHIFT)) & APU_WL_CTRL_IDLE2ISO_DLY_EN_MASK)

#define APU_WL_CTRL_APU_WKUP_WLRF_RX_MASK        (0x40U)
#define APU_WL_CTRL_APU_WKUP_WLRF_RX_SHIFT       (6U)
/*! APU_WKUP_WLRF_RX - APU Wakeup WL RF Rx */
#define APU_WL_CTRL_APU_WKUP_WLRF_RX(x)          (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_APU_WKUP_WLRF_RX_SHIFT)) & APU_WL_CTRL_APU_WKUP_WLRF_RX_MASK)

#define APU_WL_CTRL_USE_WL_INTR_SLP_MASK         (0x80U)
#define APU_WL_CTRL_USE_WL_INTR_SLP_SHIFT        (7U)
/*! USE_WL_INTR_SLP - Use WLAN Interrupt Sleep */
#define APU_WL_CTRL_USE_WL_INTR_SLP(x)           (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_USE_WL_INTR_SLP_SHIFT)) & APU_WL_CTRL_USE_WL_INTR_SLP_MASK)

#define APU_WL_CTRL_WL_USE_NOM_PWR_BYP_MASK      (0x200U)
#define APU_WL_CTRL_WL_USE_NOM_PWR_BYP_SHIFT     (9U)
/*! WL_USE_NOM_PWR_BYP - WLAN Use Nominal Power Bypass */
#define APU_WL_CTRL_WL_USE_NOM_PWR_BYP(x)        (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_WL_USE_NOM_PWR_BYP_SHIFT)) & APU_WL_CTRL_WL_USE_NOM_PWR_BYP_MASK)

#define APU_WL_CTRL_USE_WL_PWR_RDY_FOR_WLRF_CLK_MASK (0x400U)
#define APU_WL_CTRL_USE_WL_PWR_RDY_FOR_WLRF_CLK_SHIFT (10U)
/*! USE_WL_PWR_RDY_FOR_WLRF_CLK - Use WLAN Power Ready for WL RF Clock */
#define APU_WL_CTRL_USE_WL_PWR_RDY_FOR_WLRF_CLK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_USE_WL_PWR_RDY_FOR_WLRF_CLK_SHIFT)) & APU_WL_CTRL_USE_WL_PWR_RDY_FOR_WLRF_CLK_MASK)

#define APU_WL_CTRL_APU_FW_RST_PE_MASK           (0x8000U)
#define APU_WL_CTRL_APU_FW_RST_PE_SHIFT          (15U)
/*! APU_FW_RST_PE - APU FW Reset PE */
#define APU_WL_CTRL_APU_FW_RST_PE(x)             (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_APU_FW_RST_PE_SHIFT)) & APU_WL_CTRL_APU_FW_RST_PE_MASK)

#define APU_WL_CTRL_APU_TSF_UPD_CNT_MASK         (0x1F0000U)
#define APU_WL_CTRL_APU_TSF_UPD_CNT_SHIFT        (16U)
/*! APU_TSF_UPD_CNT - APU TSF Update Count */
#define APU_WL_CTRL_APU_TSF_UPD_CNT(x)           (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_APU_TSF_UPD_CNT_SHIFT)) & APU_WL_CTRL_APU_TSF_UPD_CNT_MASK)

#define APU_WL_CTRL_APU_TSF_AUTO_UPDATE_MASK     (0x200000U)
#define APU_WL_CTRL_APU_TSF_AUTO_UPDATE_SHIFT    (21U)
/*! APU_TSF_AUTO_UPDATE - APU TSF Auto Update */
#define APU_WL_CTRL_APU_TSF_AUTO_UPDATE(x)       (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_APU_TSF_AUTO_UPDATE_SHIFT)) & APU_WL_CTRL_APU_TSF_AUTO_UPDATE_MASK)

#define APU_WL_CTRL_APU_WLAN_RF_MUX_SEL_MASK     (0x400000U)
#define APU_WL_CTRL_APU_WLAN_RF_MUX_SEL_SHIFT    (22U)
/*! APU_WLAN_RF_MUX_SEL - APU WLAN RF Mux Select */
#define APU_WL_CTRL_APU_WLAN_RF_MUX_SEL(x)       (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_APU_WLAN_RF_MUX_SEL_SHIFT)) & APU_WL_CTRL_APU_WLAN_RF_MUX_SEL_MASK)

#define APU_WL_CTRL_FW_FORCE_WL_PWRUP_MASK       (0x1000000U)
#define APU_WL_CTRL_FW_FORCE_WL_PWRUP_SHIFT      (24U)
/*! FW_FORCE_WL_PWRUP - FW Force WLAN Powerup */
#define APU_WL_CTRL_FW_FORCE_WL_PWRUP(x)         (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_FW_FORCE_WL_PWRUP_SHIFT)) & APU_WL_CTRL_FW_FORCE_WL_PWRUP_MASK)

#define APU_WL_CTRL_WLAN_USE_UNSYNC_PWR_LVL_MASK (0x2000000U)
#define APU_WL_CTRL_WLAN_USE_UNSYNC_PWR_LVL_SHIFT (25U)
/*! WLAN_USE_UNSYNC_PWR_LVL - WLAN Use Unsync Power Level */
#define APU_WL_CTRL_WLAN_USE_UNSYNC_PWR_LVL(x)   (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_WLAN_USE_UNSYNC_PWR_LVL_SHIFT)) & APU_WL_CTRL_WLAN_USE_UNSYNC_PWR_LVL_MASK)

#define APU_WL_CTRL_WL_HOST_SLP_RDY_MASK         (0x80000000U)
#define APU_WL_CTRL_WL_HOST_SLP_RDY_SHIFT        (31U)
/*! WL_HOST_SLP_RDY - WLAN Host Sleep Ready */
#define APU_WL_CTRL_WL_HOST_SLP_RDY(x)           (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL_WL_HOST_SLP_RDY_SHIFT)) & APU_WL_CTRL_WL_HOST_SLP_RDY_MASK)
/*! @} */

/*! @name WL_WKUP_MASK - WLAN Wakeup Mask */
/*! @{ */

#define APU_WL_WKUP_MASK_WL_BCN_TIMER_WKUP_MASK_MASK (0x1U)
#define APU_WL_WKUP_MASK_WL_BCN_TIMER_WKUP_MASK_SHIFT (0U)
/*! WL_BCN_TIMER_WKUP_MASK - WLAN Beacon Timer Wakeup Mask */
#define APU_WL_WKUP_MASK_WL_BCN_TIMER_WKUP_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK_WL_BCN_TIMER_WKUP_MASK_SHIFT)) & APU_WL_WKUP_MASK_WL_BCN_TIMER_WKUP_MASK_MASK)

#define APU_WL_WKUP_MASK_BBUD_T2_PLL_REQ_MASK_MASK (0x2U)
#define APU_WL_WKUP_MASK_BBUD_T2_PLL_REQ_MASK_SHIFT (1U)
/*! BBUD_T2_PLL_REQ_MASK - BBUD T2 PLL Request Mask */
#define APU_WL_WKUP_MASK_BBUD_T2_PLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK_BBUD_T2_PLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK_BBUD_T2_PLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK_WL_RF_PLL_REQ_MASK_MASK (0x4U)
#define APU_WL_WKUP_MASK_WL_RF_PLL_REQ_MASK_SHIFT (2U)
/*! WL_RF_PLL_REQ_MASK - WLAN RF PLL Request Mask */
#define APU_WL_WKUP_MASK_WL_RF_PLL_REQ_MASK(x)   (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK_WL_RF_PLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK_WL_RF_PLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK_BCA_MWS_WKUP_XP_MASK_MASK (0x8U)
#define APU_WL_WKUP_MASK_BCA_MWS_WKUP_XP_MASK_SHIFT (3U)
/*! BCA_MWS_WKUP_XP_MASK - BCA MWS Wakeup XP Mask */
#define APU_WL_WKUP_MASK_BCA_MWS_WKUP_XP_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK_BCA_MWS_WKUP_XP_MASK_SHIFT)) & APU_WL_WKUP_MASK_BCA_MWS_WKUP_XP_MASK_MASK)

#define APU_WL_WKUP_MASK_WL_RF_PLL_DYNPLL_REQ_MASK_MASK (0x100U)
#define APU_WL_WKUP_MASK_WL_RF_PLL_DYNPLL_REQ_MASK_SHIFT (8U)
/*! WL_RF_PLL_DYNPLL_REQ_MASK - When mask = 0, wl_rf_pll_req is treated as pll_req */
#define APU_WL_WKUP_MASK_WL_RF_PLL_DYNPLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK_WL_RF_PLL_DYNPLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK_WL_RF_PLL_DYNPLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK_WL_HOST_DYNPLL_REQ_MASK_MASK (0x200U)
#define APU_WL_WKUP_MASK_WL_HOST_DYNPLL_REQ_MASK_SHIFT (9U)
/*! WL_HOST_DYNPLL_REQ_MASK - When mask = 0, wlan_host_wkup is treated as pll_req */
#define APU_WL_WKUP_MASK_WL_HOST_DYNPLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK_WL_HOST_DYNPLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK_WL_HOST_DYNPLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK_WL_TIMER_DYNPLL_REQ_MASK_MASK (0x400U)
#define APU_WL_WKUP_MASK_WL_TIMER_DYNPLL_REQ_MASK_SHIFT (10U)
/*! WL_TIMER_DYNPLL_REQ_MASK - When mask = 0, wlan_timer_xpp req is treated as pll_req */
#define APU_WL_WKUP_MASK_WL_TIMER_DYNPLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK_WL_TIMER_DYNPLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK_WL_TIMER_DYNPLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK_WL_SLP_RDY_DYNPLL_REQ_MASK_MASK (0x800U)
#define APU_WL_WKUP_MASK_WL_SLP_RDY_DYNPLL_REQ_MASK_SHIFT (11U)
/*! WL_SLP_RDY_DYNPLL_REQ_MASK - When mask = 0, !wl_slp_rdy is treated as pll_req */
#define APU_WL_WKUP_MASK_WL_SLP_RDY_DYNPLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK_WL_SLP_RDY_DYNPLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK_WL_SLP_RDY_DYNPLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK_IHB_WL_XPP_DYNPLL_REQ_MASK_MASK (0x1000U)
#define APU_WL_WKUP_MASK_IHB_WL_XPP_DYNPLL_REQ_MASK_SHIFT (12U)
/*! IHB_WL_XPP_DYNPLL_REQ_MASK - When mask = 0, ihb_wl_xpp_req is treated as pll_req */
#define APU_WL_WKUP_MASK_IHB_WL_XPP_DYNPLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK_IHB_WL_XPP_DYNPLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK_IHB_WL_XPP_DYNPLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK_WL_HOST_MAP_MASK        (0xFFFF0000U)
#define APU_WL_WKUP_MASK_WL_HOST_MAP_SHIFT       (16U)
/*! WL_HOST_MAP - WLAN Host Map */
#define APU_WL_WKUP_MASK_WL_HOST_MAP(x)          (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK_WL_HOST_MAP_SHIFT)) & APU_WL_WKUP_MASK_WL_HOST_MAP_MASK)
/*! @} */

/*! @name WL_STATUS - WLAN Status */
/*! @{ */

#define APU_WL_STATUS_APU_MAC_CLK_EN_MASK        (0x1U)
#define APU_WL_STATUS_APU_MAC_CLK_EN_SHIFT       (0U)
/*! APU_MAC_CLK_EN - APU MAC Clock Enable */
#define APU_WL_STATUS_APU_MAC_CLK_EN(x)          (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_MAC_CLK_EN_SHIFT)) & APU_WL_STATUS_APU_MAC_CLK_EN_MASK)

#define APU_WL_STATUS_APU_BBUD_CLK_EN_MASK       (0x2U)
#define APU_WL_STATUS_APU_BBUD_CLK_EN_SHIFT      (1U)
/*! APU_BBUD_CLK_EN - APU BBUD Clock Enable */
#define APU_WL_STATUS_APU_BBUD_CLK_EN(x)         (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_BBUD_CLK_EN_SHIFT)) & APU_WL_STATUS_APU_BBUD_CLK_EN_MASK)

#define APU_WL_STATUS_APU_WL_RF_CLK_EN_MASK      (0x4U)
#define APU_WL_STATUS_APU_WL_RF_CLK_EN_SHIFT     (2U)
/*! APU_WL_RF_CLK_EN - APU WLAN Ref Clock Enable */
#define APU_WL_STATUS_APU_WL_RF_CLK_EN(x)        (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_WL_RF_CLK_EN_SHIFT)) & APU_WL_STATUS_APU_WL_RF_CLK_EN_MASK)

#define APU_WL_STATUS_APU_WL_SLP_RDY_AFTER_MASK_MASK (0x8U)
#define APU_WL_STATUS_APU_WL_SLP_RDY_AFTER_MASK_SHIFT (3U)
/*! APU_WL_SLP_RDY_AFTER_MASK - APU WLAN Sleep Ready After Mask */
#define APU_WL_STATUS_APU_WL_SLP_RDY_AFTER_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_WL_SLP_RDY_AFTER_MASK_SHIFT)) & APU_WL_STATUS_APU_WL_SLP_RDY_AFTER_MASK_MASK)

#define APU_WL_STATUS_APU_WL_RF_CTRL_MASK        (0x30U)
#define APU_WL_STATUS_APU_WL_RF_CTRL_SHIFT       (4U)
/*! APU_WL_RF_CTRL - APU WLAN RF Control for PE1/PE2 */
#define APU_WL_STATUS_APU_WL_RF_CTRL(x)          (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_WL_RF_CTRL_SHIFT)) & APU_WL_STATUS_APU_WL_RF_CTRL_MASK)

#define APU_WL_STATUS_APU_PLL1_EN_MASK           (0x40U)
#define APU_WL_STATUS_APU_PLL1_EN_SHIFT          (6U)
/*! APU_PLL1_EN - APU PLL1 Enable */
#define APU_WL_STATUS_APU_PLL1_EN(x)             (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_PLL1_EN_SHIFT)) & APU_WL_STATUS_APU_PLL1_EN_MASK)

#define APU_WL_STATUS_APU_PLL3_EN_MASK           (0x80U)
#define APU_WL_STATUS_APU_PLL3_EN_SHIFT          (7U)
/*! APU_PLL3_EN - APU PLL3 Enable */
#define APU_WL_STATUS_APU_PLL3_EN(x)             (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_PLL3_EN_SHIFT)) & APU_WL_STATUS_APU_PLL3_EN_MASK)

#define APU_WL_STATUS_BCA_MWS_WKUP_XP_MASK       (0x100U)
#define APU_WL_STATUS_BCA_MWS_WKUP_XP_SHIFT      (8U)
/*! BCA_MWS_WKUP_XP - BCA MWS Wakeup XP */
#define APU_WL_STATUS_BCA_MWS_WKUP_XP(x)         (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_BCA_MWS_WKUP_XP_SHIFT)) & APU_WL_STATUS_BCA_MWS_WKUP_XP_MASK)

#define APU_WL_STATUS_APU_RTDP_WU_RSTB_MASK      (0x200U)
#define APU_WL_STATUS_APU_RTDP_WU_RSTB_SHIFT     (9U)
/*! APU_RTDP_WU_RSTB - APU RTDP WU RSTb */
#define APU_WL_STATUS_APU_RTDP_WU_RSTB(x)        (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_RTDP_WU_RSTB_SHIFT)) & APU_WL_STATUS_APU_RTDP_WU_RSTB_MASK)

#define APU_WL_STATUS_APU_BBUD_NON_UDR_RST_B_MASK (0x400U)
#define APU_WL_STATUS_APU_BBUD_NON_UDR_RST_B_SHIFT (10U)
/*! APU_BBUD_NON_UDR_RST_B - APU BBUD non-UDR RSTb */
#define APU_WL_STATUS_APU_BBUD_NON_UDR_RST_B(x)  (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_BBUD_NON_UDR_RST_B_SHIFT)) & APU_WL_STATUS_APU_BBUD_NON_UDR_RST_B_MASK)

#define APU_WL_STATUS_APU_WL_ST_MASK             (0xF000U)
#define APU_WL_STATUS_APU_WL_ST_SHIFT            (12U)
/*! APU_WL_ST - APU WLAN St */
#define APU_WL_STATUS_APU_WL_ST(x)               (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_WL_ST_SHIFT)) & APU_WL_STATUS_APU_WL_ST_MASK)

#define APU_WL_STATUS_APU_WLAN_SWITCH_PD_MASK    (0x10000U)
#define APU_WL_STATUS_APU_WLAN_SWITCH_PD_SHIFT   (16U)
/*! APU_WLAN_SWITCH_PD - APU WLAN Switch Pd */
#define APU_WL_STATUS_APU_WLAN_SWITCH_PD(x)      (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_WLAN_SWITCH_PD_SHIFT)) & APU_WL_STATUS_APU_WLAN_SWITCH_PD_MASK)

#define APU_WL_STATUS_APU_WLAN_UDR_FIREWALL_B_MASK (0x20000U)
#define APU_WL_STATUS_APU_WLAN_UDR_FIREWALL_B_SHIFT (17U)
/*! APU_WLAN_UDR_FIREWALL_B - APU WLAN UDR Firewall b */
#define APU_WL_STATUS_APU_WLAN_UDR_FIREWALL_B(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_WLAN_UDR_FIREWALL_B_SHIFT)) & APU_WL_STATUS_APU_WLAN_UDR_FIREWALL_B_MASK)

#define APU_WL_STATUS_APU_WLAN_CLK_DIV_RSTB_MASK (0x40000U)
#define APU_WL_STATUS_APU_WLAN_CLK_DIV_RSTB_SHIFT (18U)
/*! APU_WLAN_CLK_DIV_RSTB - APU WLAN Clock Div RSTb */
#define APU_WL_STATUS_APU_WLAN_CLK_DIV_RSTB(x)   (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_WLAN_CLK_DIV_RSTB_SHIFT)) & APU_WL_STATUS_APU_WLAN_CLK_DIV_RSTB_MASK)

#define APU_WL_STATUS_APU_WLAN_ISO_EN_MASK       (0x80000U)
#define APU_WL_STATUS_APU_WLAN_ISO_EN_SHIFT      (19U)
/*! APU_WLAN_ISO_EN - APU WLAN ISO Enable */
#define APU_WL_STATUS_APU_WLAN_ISO_EN(x)         (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_WLAN_ISO_EN_SHIFT)) & APU_WL_STATUS_APU_WLAN_ISO_EN_MASK)

#define APU_WL_STATUS_APU_WLAN_SRAM_PD_MASK      (0x100000U)
#define APU_WL_STATUS_APU_WLAN_SRAM_PD_SHIFT     (20U)
/*! APU_WLAN_SRAM_PD - APU WLAN SRAM Enable */
#define APU_WL_STATUS_APU_WLAN_SRAM_PD(x)        (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_APU_WLAN_SRAM_PD_SHIFT)) & APU_WL_STATUS_APU_WLAN_SRAM_PD_MASK)

#define APU_WL_STATUS_WLAN_VOL_REACHED_MASK      (0x200000U)
#define APU_WL_STATUS_WLAN_VOL_REACHED_SHIFT     (21U)
/*! WLAN_VOL_REACHED - WLAN Volume Reached */
#define APU_WL_STATUS_WLAN_VOL_REACHED(x)        (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_WLAN_VOL_REACHED_SHIFT)) & APU_WL_STATUS_WLAN_VOL_REACHED_MASK)

#define APU_WL_STATUS_SOC_VOL_REACHED_MASK       (0x400000U)
#define APU_WL_STATUS_SOC_VOL_REACHED_SHIFT      (22U)
/*! SOC_VOL_REACHED - SoC Volume Reached */
#define APU_WL_STATUS_SOC_VOL_REACHED(x)         (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_SOC_VOL_REACHED_SHIFT)) & APU_WL_STATUS_SOC_VOL_REACHED_MASK)

#define APU_WL_STATUS_WL_PWR_RDY_MASK            (0x800000U)
#define APU_WL_STATUS_WL_PWR_RDY_SHIFT           (23U)
/*! WL_PWR_RDY - WLAN Power Ready */
#define APU_WL_STATUS_WL_PWR_RDY(x)              (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_WL_PWR_RDY_SHIFT)) & APU_WL_STATUS_WL_PWR_RDY_MASK)

#define APU_WL_STATUS_WL_HOST_INTR_REF_MASK      (0x1000000U)
#define APU_WL_STATUS_WL_HOST_INTR_REF_SHIFT     (24U)
/*! WL_HOST_INTR_REF - WLAN Host Interrupt Reference */
#define APU_WL_STATUS_WL_HOST_INTR_REF(x)        (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_WL_HOST_INTR_REF_SHIFT)) & APU_WL_STATUS_WL_HOST_INTR_REF_MASK)

#define APU_WL_STATUS_WLAN_HOST_WKUP_MASK        (0x2000000U)
#define APU_WL_STATUS_WLAN_HOST_WKUP_SHIFT       (25U)
/*! WLAN_HOST_WKUP - WLAN Host Wakeup */
#define APU_WL_STATUS_WLAN_HOST_WKUP(x)          (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_WLAN_HOST_WKUP_SHIFT)) & APU_WL_STATUS_WLAN_HOST_WKUP_MASK)

#define APU_WL_STATUS_WL_TIMER_INTR_MASK         (0x4000000U)
#define APU_WL_STATUS_WL_TIMER_INTR_SHIFT        (26U)
/*! WL_TIMER_INTR - WLAN Timer Interrupt */
#define APU_WL_STATUS_WL_TIMER_INTR(x)           (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_WL_TIMER_INTR_SHIFT)) & APU_WL_STATUS_WL_TIMER_INTR_MASK)

#define APU_WL_STATUS_TIMER_XPP_WAKEUP_MASK      (0x8000000U)
#define APU_WL_STATUS_TIMER_XPP_WAKEUP_SHIFT     (27U)
/*! TIMER_XPP_WAKEUP - Timer XPP Wakeup */
#define APU_WL_STATUS_TIMER_XPP_WAKEUP(x)        (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_TIMER_XPP_WAKEUP_SHIFT)) & APU_WL_STATUS_TIMER_XPP_WAKEUP_MASK)

#define APU_WL_STATUS_TIMER_WAKEUP_MASK          (0x10000000U)
#define APU_WL_STATUS_TIMER_WAKEUP_SHIFT         (28U)
/*! TIMER_WAKEUP - Timer Wakeup */
#define APU_WL_STATUS_TIMER_WAKEUP(x)            (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_TIMER_WAKEUP_SHIFT)) & APU_WL_STATUS_TIMER_WAKEUP_MASK)

#define APU_WL_STATUS_WLRF_PLL_REQ_MASK          (0x20000000U)
#define APU_WL_STATUS_WLRF_PLL_REQ_SHIFT         (29U)
/*! WLRF_PLL_REQ - WL RF PLL Request */
#define APU_WL_STATUS_WLRF_PLL_REQ(x)            (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_WLRF_PLL_REQ_SHIFT)) & APU_WL_STATUS_WLRF_PLL_REQ_MASK)

#define APU_WL_STATUS_BBUD_T2_PLL_REQ_MASK       (0x40000000U)
#define APU_WL_STATUS_BBUD_T2_PLL_REQ_SHIFT      (30U)
/*! BBUD_T2_PLL_REQ - BBUD T2 PLL Request */
#define APU_WL_STATUS_BBUD_T2_PLL_REQ(x)         (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_BBUD_T2_PLL_REQ_SHIFT)) & APU_WL_STATUS_BBUD_T2_PLL_REQ_MASK)

#define APU_WL_STATUS_BCA_CLK_REQ_MASK           (0x80000000U)
#define APU_WL_STATUS_BCA_CLK_REQ_SHIFT          (31U)
/*! BCA_CLK_REQ - BCA Clock Request */
#define APU_WL_STATUS_BCA_CLK_REQ(x)             (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS_BCA_CLK_REQ_SHIFT)) & APU_WL_STATUS_BCA_CLK_REQ_MASK)
/*! @} */

/*! @name WL_ALARM_RD - WLAN Alarm Readback */
/*! @{ */

#define APU_WL_ALARM_RD_APU_WL_ALARM_RD_MASK     (0xFFFFFFFFU)
#define APU_WL_ALARM_RD_APU_WL_ALARM_RD_SHIFT    (0U)
/*! APU_WL_ALARM_RD - reads back current beacon timer alarm value */
#define APU_WL_ALARM_RD_APU_WL_ALARM_RD(x)       (((uint32_t)(((uint32_t)(x)) << APU_WL_ALARM_RD_APU_WL_ALARM_RD_SHIFT)) & APU_WL_ALARM_RD_APU_WL_ALARM_RD_MASK)
/*! @} */

/*! @name WL_BCN_XP_ALARM - WLAN Beacon Alarm */
/*! @{ */

#define APU_WL_BCN_XP_ALARM_WL_BCN_XP_ALARM_MASK (0xFFFFFFFFU)
#define APU_WL_BCN_XP_ALARM_WL_BCN_XP_ALARM_SHIFT (0U)
/*! WL_BCN_XP_ALARM - number of sleep clocks until WLAN beacon timer requests for reference clock and power */
#define APU_WL_BCN_XP_ALARM_WL_BCN_XP_ALARM(x)   (((uint32_t)(((uint32_t)(x)) << APU_WL_BCN_XP_ALARM_WL_BCN_XP_ALARM_SHIFT)) & APU_WL_BCN_XP_ALARM_WL_BCN_XP_ALARM_MASK)
/*! @} */

/*! @name WL_BCN_INTR_ALARM - WLAN Beacon Interrupt Alarm */
/*! @{ */

#define APU_WL_BCN_INTR_ALARM_WL_BCN_INTR_ALARM_MASK (0xFFFFFFFFU)
#define APU_WL_BCN_INTR_ALARM_WL_BCN_INTR_ALARM_SHIFT (0U)
/*! WL_BCN_INTR_ALARM - number of ref clocks after WLAN beacon timer request to firmware wakeup */
#define APU_WL_BCN_INTR_ALARM_WL_BCN_INTR_ALARM(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_BCN_INTR_ALARM_WL_BCN_INTR_ALARM_SHIFT)) & APU_WL_BCN_INTR_ALARM_WL_BCN_INTR_ALARM_MASK)
/*! @} */

/*! @name WL_HOST_INTR_ALARM - WLAN Host Interrupt Alarm */
/*! @{ */

#define APU_WL_HOST_INTR_ALARM_WL_HOST_INTR_ALARM_MASK (0xFFFFFFFFU)
#define APU_WL_HOST_INTR_ALARM_WL_HOST_INTR_ALARM_SHIFT (0U)
/*! WL_HOST_INTR_ALARM - number of ref clocks after WLAN host request to firmware wakeup */
#define APU_WL_HOST_INTR_ALARM_WL_HOST_INTR_ALARM(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_HOST_INTR_ALARM_WL_HOST_INTR_ALARM_SHIFT)) & APU_WL_HOST_INTR_ALARM_WL_HOST_INTR_ALARM_MASK)
/*! @} */

/*! @name WL_BCN_PLL_ALARM - WLAN Beacon PLL Alarm */
/*! @{ */

#define APU_WL_BCN_PLL_ALARM_WL_BCN_PLL_ALARM_MASK (0xFFFFFFFFU)
#define APU_WL_BCN_PLL_ALARM_WL_BCN_PLL_ALARM_SHIFT (0U)
/*! WL_BCN_PLL_ALARM - number of sleep clocks until WLAN beacon timer requests for reference clock, power, and PLL */
#define APU_WL_BCN_PLL_ALARM_WL_BCN_PLL_ALARM(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_BCN_PLL_ALARM_WL_BCN_PLL_ALARM_SHIFT)) & APU_WL_BCN_PLL_ALARM_WL_BCN_PLL_ALARM_MASK)
/*! @} */

/*! @name TSF_REF_FACTOR - TSF Reference Factor */
/*! @{ */

#define APU_TSF_REF_FACTOR_TSF_REF_FACTOR_MASK   (0x7FFFFU)
#define APU_TSF_REF_FACTOR_TSF_REF_FACTOR_SHIFT  (0U)
/*! TSF_REF_FACTOR - number of 1us in 1 reference clock */
#define APU_TSF_REF_FACTOR_TSF_REF_FACTOR(x)     (((uint32_t)(((uint32_t)(x)) << APU_TSF_REF_FACTOR_TSF_REF_FACTOR_SHIFT)) & APU_TSF_REF_FACTOR_TSF_REF_FACTOR_MASK)
/*! @} */

/*! @name TSF_SLEEP_FACTOR - TSF Sleep Factor */
/*! @{ */

#define APU_TSF_SLEEP_FACTOR_TSF_SLEEP_FACTOR_MASK (0xFFFFFFFU)
#define APU_TSF_SLEEP_FACTOR_TSF_SLEEP_FACTOR_SHIFT (0U)
/*! TSF_SLEEP_FACTOR - number of 1us in 1 sleep clock */
#define APU_TSF_SLEEP_FACTOR_TSF_SLEEP_FACTOR(x) (((uint32_t)(((uint32_t)(x)) << APU_TSF_SLEEP_FACTOR_TSF_SLEEP_FACTOR_SHIFT)) & APU_TSF_SLEEP_FACTOR_TSF_SLEEP_FACTOR_MASK)
/*! @} */

/*! @name BBUD_UDR_ISO_CNT - BBUD UDR ISO Count */
/*! @{ */

#define APU_BBUD_UDR_ISO_CNT_BBUD_UDR_ASSERT_CNT_MASK (0x1FFFU)
#define APU_BBUD_UDR_ISO_CNT_BBUD_UDR_ASSERT_CNT_SHIFT (0U)
/*! BBUD_UDR_ASSERT_CNT - number of reference clocks before bbud_non_udr_rst de-assertion after bbud_clk_en is asserted */
#define APU_BBUD_UDR_ISO_CNT_BBUD_UDR_ASSERT_CNT(x) (((uint32_t)(((uint32_t)(x)) << APU_BBUD_UDR_ISO_CNT_BBUD_UDR_ASSERT_CNT_SHIFT)) & APU_BBUD_UDR_ISO_CNT_BBUD_UDR_ASSERT_CNT_MASK)

#define APU_BBUD_UDR_ISO_CNT_BBUD_CLK_ASSERT_CNT_MASK (0x1FFF0000U)
#define APU_BBUD_UDR_ISO_CNT_BBUD_CLK_ASSERT_CNT_SHIFT (16U)
/*! BBUD_CLK_ASSERT_CNT - number of reference clocks before bbud_iso_en de-assertion after bbud_non_udr_rst de-asserts */
#define APU_BBUD_UDR_ISO_CNT_BBUD_CLK_ASSERT_CNT(x) (((uint32_t)(((uint32_t)(x)) << APU_BBUD_UDR_ISO_CNT_BBUD_CLK_ASSERT_CNT_SHIFT)) & APU_BBUD_UDR_ISO_CNT_BBUD_CLK_ASSERT_CNT_MASK)
/*! @} */

/*! @name WL_DVFS_CTRL - WLAN DVFS Control */
/*! @{ */

#define APU_WL_DVFS_CTRL_WLAN_VOL_VAL_MASK       (0x7FU)
#define APU_WL_DVFS_CTRL_WLAN_VOL_VAL_SHIFT      (0U)
/*! WLAN_VOL_VAL - WLAN Vol Value */
#define APU_WL_DVFS_CTRL_WLAN_VOL_VAL(x)         (((uint32_t)(((uint32_t)(x)) << APU_WL_DVFS_CTRL_WLAN_VOL_VAL_SHIFT)) & APU_WL_DVFS_CTRL_WLAN_VOL_VAL_MASK)
/*! @} */

/*! @name WL_CTRL2 - WLAN Control 2 */
/*! @{ */

#define APU_WL_CTRL2_WL_SLP_RDY_MASK             (0x1U)
#define APU_WL_CTRL2_WL_SLP_RDY_SHIFT            (0U)
/*! WL_SLP_RDY - WLAN Sleep Ready */
#define APU_WL_CTRL2_WL_SLP_RDY(x)               (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_WL_SLP_RDY_SHIFT)) & APU_WL_CTRL2_WL_SLP_RDY_MASK)

#define APU_WL_CTRL2_WL_SLP_RDYMASK_MASK         (0x2U)
#define APU_WL_CTRL2_WL_SLP_RDYMASK_SHIFT        (1U)
/*! WL_SLP_RDYMASK - WLAN Sleep Ready Mask */
#define APU_WL_CTRL2_WL_SLP_RDYMASK(x)           (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_WL_SLP_RDYMASK_SHIFT)) & APU_WL_CTRL2_WL_SLP_RDYMASK_MASK)

#define APU_WL_CTRL2_WL_SLP_RDY_FW_MASK          (0x4U)
#define APU_WL_CTRL2_WL_SLP_RDY_FW_SHIFT         (2U)
/*! WL_SLP_RDY_FW - WLAN Sleep Ready Firmware */
#define APU_WL_CTRL2_WL_SLP_RDY_FW(x)            (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_WL_SLP_RDY_FW_SHIFT)) & APU_WL_CTRL2_WL_SLP_RDY_FW_MASK)

#define APU_WL_CTRL2_IDLE2ISO_DLY_EN_MASK        (0x20U)
#define APU_WL_CTRL2_IDLE2ISO_DLY_EN_SHIFT       (5U)
/*! IDLE2ISO_DLY_EN - Delay from idle to iso to ensure delay from bbud_non_udr_rst_b =0 to wlan_iso_en = 1 */
#define APU_WL_CTRL2_IDLE2ISO_DLY_EN(x)          (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_IDLE2ISO_DLY_EN_SHIFT)) & APU_WL_CTRL2_IDLE2ISO_DLY_EN_MASK)

#define APU_WL_CTRL2_APU_WKUP_WLRF_RX_MASK       (0x40U)
#define APU_WL_CTRL2_APU_WKUP_WLRF_RX_SHIFT      (6U)
/*! APU_WKUP_WLRF_RX - APU Wakeup WL RF Rx */
#define APU_WL_CTRL2_APU_WKUP_WLRF_RX(x)         (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_APU_WKUP_WLRF_RX_SHIFT)) & APU_WL_CTRL2_APU_WKUP_WLRF_RX_MASK)

#define APU_WL_CTRL2_USE_WL_INTR_SLP_MASK        (0x80U)
#define APU_WL_CTRL2_USE_WL_INTR_SLP_SHIFT       (7U)
/*! USE_WL_INTR_SLP - Use WLAN Interrupt Sleep */
#define APU_WL_CTRL2_USE_WL_INTR_SLP(x)          (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_USE_WL_INTR_SLP_SHIFT)) & APU_WL_CTRL2_USE_WL_INTR_SLP_MASK)

#define APU_WL_CTRL2_WL_USE_NOM_PWR_BYP_MASK     (0x200U)
#define APU_WL_CTRL2_WL_USE_NOM_PWR_BYP_SHIFT    (9U)
/*! WL_USE_NOM_PWR_BYP - Use nom_pwr_lvl from dvfs for wl_pwr_lvl_reached */
#define APU_WL_CTRL2_WL_USE_NOM_PWR_BYP(x)       (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_WL_USE_NOM_PWR_BYP_SHIFT)) & APU_WL_CTRL2_WL_USE_NOM_PWR_BYP_MASK)

#define APU_WL_CTRL2_USE_WL_PWR_RDY_FOR_WLRF_CLK_MASK (0x400U)
#define APU_WL_CTRL2_USE_WL_PWR_RDY_FOR_WLRF_CLK_SHIFT (10U)
/*! USE_WL_PWR_RDY_FOR_WLRF_CLK - Use WLAN Power Ready for WL RF Clock */
#define APU_WL_CTRL2_USE_WL_PWR_RDY_FOR_WLRF_CLK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_USE_WL_PWR_RDY_FOR_WLRF_CLK_SHIFT)) & APU_WL_CTRL2_USE_WL_PWR_RDY_FOR_WLRF_CLK_MASK)

#define APU_WL_CTRL2_APU_FW_RST_PE_MASK          (0x8000U)
#define APU_WL_CTRL2_APU_FW_RST_PE_SHIFT         (15U)
/*! APU_FW_RST_PE - APU FW Reset PE */
#define APU_WL_CTRL2_APU_FW_RST_PE(x)            (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_APU_FW_RST_PE_SHIFT)) & APU_WL_CTRL2_APU_FW_RST_PE_MASK)

#define APU_WL_CTRL2_APU_TSF_UPD_CNT_MASK        (0x1F0000U)
#define APU_WL_CTRL2_APU_TSF_UPD_CNT_SHIFT       (16U)
/*! APU_TSF_UPD_CNT - APU TSF Update Count */
#define APU_WL_CTRL2_APU_TSF_UPD_CNT(x)          (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_APU_TSF_UPD_CNT_SHIFT)) & APU_WL_CTRL2_APU_TSF_UPD_CNT_MASK)

#define APU_WL_CTRL2_APU_TSF_AUTO_UPDATE_MASK    (0x200000U)
#define APU_WL_CTRL2_APU_TSF_AUTO_UPDATE_SHIFT   (21U)
/*! APU_TSF_AUTO_UPDATE - APU TSF Auto Update */
#define APU_WL_CTRL2_APU_TSF_AUTO_UPDATE(x)      (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_APU_TSF_AUTO_UPDATE_SHIFT)) & APU_WL_CTRL2_APU_TSF_AUTO_UPDATE_MASK)

#define APU_WL_CTRL2_APU_WLAN_RF_MUX_SEL_MASK    (0x400000U)
#define APU_WL_CTRL2_APU_WLAN_RF_MUX_SEL_SHIFT   (22U)
/*! APU_WLAN_RF_MUX_SEL - APU WLAN RF Mux Select */
#define APU_WL_CTRL2_APU_WLAN_RF_MUX_SEL(x)      (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_APU_WLAN_RF_MUX_SEL_SHIFT)) & APU_WL_CTRL2_APU_WLAN_RF_MUX_SEL_MASK)

#define APU_WL_CTRL2_FW_FORCE_WL_PWRUP_MASK      (0x1000000U)
#define APU_WL_CTRL2_FW_FORCE_WL_PWRUP_SHIFT     (24U)
/*! FW_FORCE_WL_PWRUP - FW Force WLAN Powerup */
#define APU_WL_CTRL2_FW_FORCE_WL_PWRUP(x)        (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_FW_FORCE_WL_PWRUP_SHIFT)) & APU_WL_CTRL2_FW_FORCE_WL_PWRUP_MASK)

#define APU_WL_CTRL2_WLAN_USE_UNSYNC_PWR_LVL_MASK (0x2000000U)
#define APU_WL_CTRL2_WLAN_USE_UNSYNC_PWR_LVL_SHIFT (25U)
/*! WLAN_USE_UNSYNC_PWR_LVL - WLAN Use Unsync Power Level */
#define APU_WL_CTRL2_WLAN_USE_UNSYNC_PWR_LVL(x)  (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_WLAN_USE_UNSYNC_PWR_LVL_SHIFT)) & APU_WL_CTRL2_WLAN_USE_UNSYNC_PWR_LVL_MASK)

#define APU_WL_CTRL2_WL_HOST_SLP_RDY_MASK        (0x80000000U)
#define APU_WL_CTRL2_WL_HOST_SLP_RDY_SHIFT       (31U)
/*! WL_HOST_SLP_RDY - WLAN Host Sleep Ready */
#define APU_WL_CTRL2_WL_HOST_SLP_RDY(x)          (((uint32_t)(((uint32_t)(x)) << APU_WL_CTRL2_WL_HOST_SLP_RDY_SHIFT)) & APU_WL_CTRL2_WL_HOST_SLP_RDY_MASK)
/*! @} */

/*! @name WL_WKUP_MASK2 - WLAN Wakeup Mask 2 */
/*! @{ */

#define APU_WL_WKUP_MASK2_WL_BCN_TIMER_WKUP_MASK_MASK (0x1U)
#define APU_WL_WKUP_MASK2_WL_BCN_TIMER_WKUP_MASK_SHIFT (0U)
/*! WL_BCN_TIMER_WKUP_MASK - WLAN Beacon Timer Wakeup Mask */
#define APU_WL_WKUP_MASK2_WL_BCN_TIMER_WKUP_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK2_WL_BCN_TIMER_WKUP_MASK_SHIFT)) & APU_WL_WKUP_MASK2_WL_BCN_TIMER_WKUP_MASK_MASK)

#define APU_WL_WKUP_MASK2_BBUD_T2_PLL_REQ_MASK_MASK (0x2U)
#define APU_WL_WKUP_MASK2_BBUD_T2_PLL_REQ_MASK_SHIFT (1U)
/*! BBUD_T2_PLL_REQ_MASK - BBUD T2 PLL Request Mask */
#define APU_WL_WKUP_MASK2_BBUD_T2_PLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK2_BBUD_T2_PLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK2_BBUD_T2_PLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK2_WL_RF_PLL_REQ_MASK_MASK (0x4U)
#define APU_WL_WKUP_MASK2_WL_RF_PLL_REQ_MASK_SHIFT (2U)
/*! WL_RF_PLL_REQ_MASK - WLAN RF PLL Request Mask */
#define APU_WL_WKUP_MASK2_WL_RF_PLL_REQ_MASK(x)  (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK2_WL_RF_PLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK2_WL_RF_PLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK2_BCA_MWS_WKUP_XP_MASK_MASK (0x8U)
#define APU_WL_WKUP_MASK2_BCA_MWS_WKUP_XP_MASK_SHIFT (3U)
/*! BCA_MWS_WKUP_XP_MASK - BCA MWS Wakeup XP Mask */
#define APU_WL_WKUP_MASK2_BCA_MWS_WKUP_XP_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK2_BCA_MWS_WKUP_XP_MASK_SHIFT)) & APU_WL_WKUP_MASK2_BCA_MWS_WKUP_XP_MASK_MASK)

#define APU_WL_WKUP_MASK2_WL_RF_PLL_DYNPLL_REQ_MASK_MASK (0x100U)
#define APU_WL_WKUP_MASK2_WL_RF_PLL_DYNPLL_REQ_MASK_SHIFT (8U)
/*! WL_RF_PLL_DYNPLL_REQ_MASK - When mask = 0, wl_rf_pll_req is treated as pll_req */
#define APU_WL_WKUP_MASK2_WL_RF_PLL_DYNPLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK2_WL_RF_PLL_DYNPLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK2_WL_RF_PLL_DYNPLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK2_WL_HOST_DYNPLL_REQ_MASK_MASK (0x200U)
#define APU_WL_WKUP_MASK2_WL_HOST_DYNPLL_REQ_MASK_SHIFT (9U)
/*! WL_HOST_DYNPLL_REQ_MASK - When mask = 0, wlan_host_wkup is treated as pll_req */
#define APU_WL_WKUP_MASK2_WL_HOST_DYNPLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK2_WL_HOST_DYNPLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK2_WL_HOST_DYNPLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK2_WL_TIMER_DYNPLL_REQ_MASK_MASK (0x400U)
#define APU_WL_WKUP_MASK2_WL_TIMER_DYNPLL_REQ_MASK_SHIFT (10U)
/*! WL_TIMER_DYNPLL_REQ_MASK - When mask = 0, wlan_timer_xpp req is treated as pll_req */
#define APU_WL_WKUP_MASK2_WL_TIMER_DYNPLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK2_WL_TIMER_DYNPLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK2_WL_TIMER_DYNPLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK2_WL_SLP_RDY_DYNPLL_REQ_MASK_MASK (0x800U)
#define APU_WL_WKUP_MASK2_WL_SLP_RDY_DYNPLL_REQ_MASK_SHIFT (11U)
/*! WL_SLP_RDY_DYNPLL_REQ_MASK - When mask = 0, !wl_slp_rdy is treated as pll_req */
#define APU_WL_WKUP_MASK2_WL_SLP_RDY_DYNPLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK2_WL_SLP_RDY_DYNPLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK2_WL_SLP_RDY_DYNPLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK2_IHB_WL_XPP_DYNPLL_REQ_MASK_MASK (0x1000U)
#define APU_WL_WKUP_MASK2_IHB_WL_XPP_DYNPLL_REQ_MASK_SHIFT (12U)
/*! IHB_WL_XPP_DYNPLL_REQ_MASK - When mask = 0, ihb_wl_xpp_req is treated as pll_req */
#define APU_WL_WKUP_MASK2_IHB_WL_XPP_DYNPLL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK2_IHB_WL_XPP_DYNPLL_REQ_MASK_SHIFT)) & APU_WL_WKUP_MASK2_IHB_WL_XPP_DYNPLL_REQ_MASK_MASK)

#define APU_WL_WKUP_MASK2_WL_HOST_MAP_MASK       (0xFFFF0000U)
#define APU_WL_WKUP_MASK2_WL_HOST_MAP_SHIFT      (16U)
/*! WL_HOST_MAP - WLAN Host Map */
#define APU_WL_WKUP_MASK2_WL_HOST_MAP(x)         (((uint32_t)(((uint32_t)(x)) << APU_WL_WKUP_MASK2_WL_HOST_MAP_SHIFT)) & APU_WL_WKUP_MASK2_WL_HOST_MAP_MASK)
/*! @} */

/*! @name WL_STATUS2 - WLAN Status 2 */
/*! @{ */

#define APU_WL_STATUS2_APU_MAC_CLK_EN_MASK       (0x1U)
#define APU_WL_STATUS2_APU_MAC_CLK_EN_SHIFT      (0U)
/*! APU_MAC_CLK_EN - APU MAC Clock Enable */
#define APU_WL_STATUS2_APU_MAC_CLK_EN(x)         (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_MAC_CLK_EN_SHIFT)) & APU_WL_STATUS2_APU_MAC_CLK_EN_MASK)

#define APU_WL_STATUS2_APU_BBUD_CLK_EN_MASK      (0x2U)
#define APU_WL_STATUS2_APU_BBUD_CLK_EN_SHIFT     (1U)
/*! APU_BBUD_CLK_EN - APU BBUD Clock Enable */
#define APU_WL_STATUS2_APU_BBUD_CLK_EN(x)        (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_BBUD_CLK_EN_SHIFT)) & APU_WL_STATUS2_APU_BBUD_CLK_EN_MASK)

#define APU_WL_STATUS2_APU_WL_RF_CLK_EN_MASK     (0x4U)
#define APU_WL_STATUS2_APU_WL_RF_CLK_EN_SHIFT    (2U)
/*! APU_WL_RF_CLK_EN - APU WLAN Ref Clock Enable */
#define APU_WL_STATUS2_APU_WL_RF_CLK_EN(x)       (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_WL_RF_CLK_EN_SHIFT)) & APU_WL_STATUS2_APU_WL_RF_CLK_EN_MASK)

#define APU_WL_STATUS2_APU_WL_SLP_RDY_AFTER_MASK_MASK (0x8U)
#define APU_WL_STATUS2_APU_WL_SLP_RDY_AFTER_MASK_SHIFT (3U)
/*! APU_WL_SLP_RDY_AFTER_MASK - APU WLAN Sleep Ready After Mask */
#define APU_WL_STATUS2_APU_WL_SLP_RDY_AFTER_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_WL_SLP_RDY_AFTER_MASK_SHIFT)) & APU_WL_STATUS2_APU_WL_SLP_RDY_AFTER_MASK_MASK)

#define APU_WL_STATUS2_APU_WL_RF_CTRL_MASK       (0x30U)
#define APU_WL_STATUS2_APU_WL_RF_CTRL_SHIFT      (4U)
/*! APU_WL_RF_CTRL - APU WLAN RF Control */
#define APU_WL_STATUS2_APU_WL_RF_CTRL(x)         (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_WL_RF_CTRL_SHIFT)) & APU_WL_STATUS2_APU_WL_RF_CTRL_MASK)

#define APU_WL_STATUS2_APU_PLL1_EN_MASK          (0x40U)
#define APU_WL_STATUS2_APU_PLL1_EN_SHIFT         (6U)
/*! APU_PLL1_EN - APU PLL1 Enable */
#define APU_WL_STATUS2_APU_PLL1_EN(x)            (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_PLL1_EN_SHIFT)) & APU_WL_STATUS2_APU_PLL1_EN_MASK)

#define APU_WL_STATUS2_APU_PLL3_EN_MASK          (0x80U)
#define APU_WL_STATUS2_APU_PLL3_EN_SHIFT         (7U)
/*! APU_PLL3_EN - APU PLL3 Enable */
#define APU_WL_STATUS2_APU_PLL3_EN(x)            (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_PLL3_EN_SHIFT)) & APU_WL_STATUS2_APU_PLL3_EN_MASK)

#define APU_WL_STATUS2_BCA_MWS_WKUP_XP_MASK      (0x100U)
#define APU_WL_STATUS2_BCA_MWS_WKUP_XP_SHIFT     (8U)
/*! BCA_MWS_WKUP_XP - BCA MWS Wakeup XP */
#define APU_WL_STATUS2_BCA_MWS_WKUP_XP(x)        (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_BCA_MWS_WKUP_XP_SHIFT)) & APU_WL_STATUS2_BCA_MWS_WKUP_XP_MASK)

#define APU_WL_STATUS2_APU_RTDP_WU_RSTB_MASK     (0x200U)
#define APU_WL_STATUS2_APU_RTDP_WU_RSTB_SHIFT    (9U)
/*! APU_RTDP_WU_RSTB - APU RTDP WU RSTb */
#define APU_WL_STATUS2_APU_RTDP_WU_RSTB(x)       (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_RTDP_WU_RSTB_SHIFT)) & APU_WL_STATUS2_APU_RTDP_WU_RSTB_MASK)

#define APU_WL_STATUS2_APU_BBUD_NON_UDR_RST_B_MASK (0x400U)
#define APU_WL_STATUS2_APU_BBUD_NON_UDR_RST_B_SHIFT (10U)
/*! APU_BBUD_NON_UDR_RST_B - APU BBUD non-UDR RSTb */
#define APU_WL_STATUS2_APU_BBUD_NON_UDR_RST_B(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_BBUD_NON_UDR_RST_B_SHIFT)) & APU_WL_STATUS2_APU_BBUD_NON_UDR_RST_B_MASK)

#define APU_WL_STATUS2_APU_WL_ST_MASK            (0xF000U)
#define APU_WL_STATUS2_APU_WL_ST_SHIFT           (12U)
/*! APU_WL_ST - APU WLAN St */
#define APU_WL_STATUS2_APU_WL_ST(x)              (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_WL_ST_SHIFT)) & APU_WL_STATUS2_APU_WL_ST_MASK)

#define APU_WL_STATUS2_APU_WLAN_SWITCH_PD_MASK   (0x10000U)
#define APU_WL_STATUS2_APU_WLAN_SWITCH_PD_SHIFT  (16U)
/*! APU_WLAN_SWITCH_PD - APU WLAN Switch Pd */
#define APU_WL_STATUS2_APU_WLAN_SWITCH_PD(x)     (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_WLAN_SWITCH_PD_SHIFT)) & APU_WL_STATUS2_APU_WLAN_SWITCH_PD_MASK)

#define APU_WL_STATUS2_APU_WLAN_UDR_FIREWALL_B_MASK (0x20000U)
#define APU_WL_STATUS2_APU_WLAN_UDR_FIREWALL_B_SHIFT (17U)
/*! APU_WLAN_UDR_FIREWALL_B - APU WLAN UDR Firewall b */
#define APU_WL_STATUS2_APU_WLAN_UDR_FIREWALL_B(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_WLAN_UDR_FIREWALL_B_SHIFT)) & APU_WL_STATUS2_APU_WLAN_UDR_FIREWALL_B_MASK)

#define APU_WL_STATUS2_APU_WLAN_CLK_DIV_RSTB_MASK (0x40000U)
#define APU_WL_STATUS2_APU_WLAN_CLK_DIV_RSTB_SHIFT (18U)
/*! APU_WLAN_CLK_DIV_RSTB - APU WLAN Clock Div RSTb */
#define APU_WL_STATUS2_APU_WLAN_CLK_DIV_RSTB(x)  (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_WLAN_CLK_DIV_RSTB_SHIFT)) & APU_WL_STATUS2_APU_WLAN_CLK_DIV_RSTB_MASK)

#define APU_WL_STATUS2_APU_WLAN_ISO_EN_MASK      (0x80000U)
#define APU_WL_STATUS2_APU_WLAN_ISO_EN_SHIFT     (19U)
/*! APU_WLAN_ISO_EN - APU WLAN ISO Enable */
#define APU_WL_STATUS2_APU_WLAN_ISO_EN(x)        (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_WLAN_ISO_EN_SHIFT)) & APU_WL_STATUS2_APU_WLAN_ISO_EN_MASK)

#define APU_WL_STATUS2_APU_WLAN_SRAM_PD_MASK     (0x100000U)
#define APU_WL_STATUS2_APU_WLAN_SRAM_PD_SHIFT    (20U)
/*! APU_WLAN_SRAM_PD - APU WLAN SRAM Pd */
#define APU_WL_STATUS2_APU_WLAN_SRAM_PD(x)       (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_APU_WLAN_SRAM_PD_SHIFT)) & APU_WL_STATUS2_APU_WLAN_SRAM_PD_MASK)

#define APU_WL_STATUS2_WLAN_VOL_REACHED_MASK     (0x200000U)
#define APU_WL_STATUS2_WLAN_VOL_REACHED_SHIFT    (21U)
/*! WLAN_VOL_REACHED - WLAN Volume Reached */
#define APU_WL_STATUS2_WLAN_VOL_REACHED(x)       (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_WLAN_VOL_REACHED_SHIFT)) & APU_WL_STATUS2_WLAN_VOL_REACHED_MASK)

#define APU_WL_STATUS2_SOC_VOL_REACHED_MASK      (0x400000U)
#define APU_WL_STATUS2_SOC_VOL_REACHED_SHIFT     (22U)
/*! SOC_VOL_REACHED - SoC Volume Reached */
#define APU_WL_STATUS2_SOC_VOL_REACHED(x)        (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_SOC_VOL_REACHED_SHIFT)) & APU_WL_STATUS2_SOC_VOL_REACHED_MASK)

#define APU_WL_STATUS2_WL_PWR_RDY_MASK           (0x800000U)
#define APU_WL_STATUS2_WL_PWR_RDY_SHIFT          (23U)
/*! WL_PWR_RDY - WLAN Power Ready */
#define APU_WL_STATUS2_WL_PWR_RDY(x)             (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_WL_PWR_RDY_SHIFT)) & APU_WL_STATUS2_WL_PWR_RDY_MASK)

#define APU_WL_STATUS2_WL_HOST_INTR_REF_MASK     (0x1000000U)
#define APU_WL_STATUS2_WL_HOST_INTR_REF_SHIFT    (24U)
/*! WL_HOST_INTR_REF - WLAN Host Interrupt Reference */
#define APU_WL_STATUS2_WL_HOST_INTR_REF(x)       (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_WL_HOST_INTR_REF_SHIFT)) & APU_WL_STATUS2_WL_HOST_INTR_REF_MASK)

#define APU_WL_STATUS2_WLAN_HOST_WKUP_MASK       (0x2000000U)
#define APU_WL_STATUS2_WLAN_HOST_WKUP_SHIFT      (25U)
/*! WLAN_HOST_WKUP - WLAN Host Wakeup */
#define APU_WL_STATUS2_WLAN_HOST_WKUP(x)         (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_WLAN_HOST_WKUP_SHIFT)) & APU_WL_STATUS2_WLAN_HOST_WKUP_MASK)

#define APU_WL_STATUS2_WL_TIMER_INTR_MASK        (0x4000000U)
#define APU_WL_STATUS2_WL_TIMER_INTR_SHIFT       (26U)
/*! WL_TIMER_INTR - WLAN Timer Interrupt */
#define APU_WL_STATUS2_WL_TIMER_INTR(x)          (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_WL_TIMER_INTR_SHIFT)) & APU_WL_STATUS2_WL_TIMER_INTR_MASK)

#define APU_WL_STATUS2_TIMER_XPP_WAKEUP_MASK     (0x8000000U)
#define APU_WL_STATUS2_TIMER_XPP_WAKEUP_SHIFT    (27U)
/*! TIMER_XPP_WAKEUP - Timer XPP Wakeup */
#define APU_WL_STATUS2_TIMER_XPP_WAKEUP(x)       (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_TIMER_XPP_WAKEUP_SHIFT)) & APU_WL_STATUS2_TIMER_XPP_WAKEUP_MASK)

#define APU_WL_STATUS2_TIMER_WAKEUP_MASK         (0x10000000U)
#define APU_WL_STATUS2_TIMER_WAKEUP_SHIFT        (28U)
/*! TIMER_WAKEUP - Timer Wakeup */
#define APU_WL_STATUS2_TIMER_WAKEUP(x)           (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_TIMER_WAKEUP_SHIFT)) & APU_WL_STATUS2_TIMER_WAKEUP_MASK)

#define APU_WL_STATUS2_WLRF_PLL_REQ_MASK         (0x20000000U)
#define APU_WL_STATUS2_WLRF_PLL_REQ_SHIFT        (29U)
/*! WLRF_PLL_REQ - WLAN RF PLL Request */
#define APU_WL_STATUS2_WLRF_PLL_REQ(x)           (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_WLRF_PLL_REQ_SHIFT)) & APU_WL_STATUS2_WLRF_PLL_REQ_MASK)

#define APU_WL_STATUS2_BBUD_T2_PLL_REQ_MASK      (0x40000000U)
#define APU_WL_STATUS2_BBUD_T2_PLL_REQ_SHIFT     (30U)
/*! BBUD_T2_PLL_REQ - BBUD T2 PLL Request */
#define APU_WL_STATUS2_BBUD_T2_PLL_REQ(x)        (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_BBUD_T2_PLL_REQ_SHIFT)) & APU_WL_STATUS2_BBUD_T2_PLL_REQ_MASK)

#define APU_WL_STATUS2_BCA_CLK_REQ_MASK          (0x80000000U)
#define APU_WL_STATUS2_BCA_CLK_REQ_SHIFT         (31U)
/*! BCA_CLK_REQ - BCA Clock Request */
#define APU_WL_STATUS2_BCA_CLK_REQ(x)            (((uint32_t)(((uint32_t)(x)) << APU_WL_STATUS2_BCA_CLK_REQ_SHIFT)) & APU_WL_STATUS2_BCA_CLK_REQ_MASK)
/*! @} */

/*! @name WL_ALARM_RD2 - WLAN Alarm Readback 2 */
/*! @{ */

#define APU_WL_ALARM_RD2_APU_WL_ALARM_RD_MASK    (0xFFFFFFFFU)
#define APU_WL_ALARM_RD2_APU_WL_ALARM_RD_SHIFT   (0U)
/*! APU_WL_ALARM_RD - reads back current beacon timer alarm value */
#define APU_WL_ALARM_RD2_APU_WL_ALARM_RD(x)      (((uint32_t)(((uint32_t)(x)) << APU_WL_ALARM_RD2_APU_WL_ALARM_RD_SHIFT)) & APU_WL_ALARM_RD2_APU_WL_ALARM_RD_MASK)
/*! @} */

/*! @name WL_BCN_XP_ALARM2 - WLAN Beacon XP Alarm 2 */
/*! @{ */

#define APU_WL_BCN_XP_ALARM2_WL_BCN_XP_ALARM_MASK (0xFFFFFFFFU)
#define APU_WL_BCN_XP_ALARM2_WL_BCN_XP_ALARM_SHIFT (0U)
/*! WL_BCN_XP_ALARM - number of sleep clocks until WLAN beacon timer requests for reference clock and power */
#define APU_WL_BCN_XP_ALARM2_WL_BCN_XP_ALARM(x)  (((uint32_t)(((uint32_t)(x)) << APU_WL_BCN_XP_ALARM2_WL_BCN_XP_ALARM_SHIFT)) & APU_WL_BCN_XP_ALARM2_WL_BCN_XP_ALARM_MASK)
/*! @} */

/*! @name WL_BCN_INTR_ALARM2 - WLAN Beacon Interrupt Alarm 2 */
/*! @{ */

#define APU_WL_BCN_INTR_ALARM2_WL_BCN_INTR_ALARM_MASK (0xFFFFFFFFU)
#define APU_WL_BCN_INTR_ALARM2_WL_BCN_INTR_ALARM_SHIFT (0U)
/*! WL_BCN_INTR_ALARM - number of ref clocks after WLAN beacon timer request to firmware wakeup */
#define APU_WL_BCN_INTR_ALARM2_WL_BCN_INTR_ALARM(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_BCN_INTR_ALARM2_WL_BCN_INTR_ALARM_SHIFT)) & APU_WL_BCN_INTR_ALARM2_WL_BCN_INTR_ALARM_MASK)
/*! @} */

/*! @name WL_HOST_INTR_ALARM2 - WLAN Host Interrupt Alarm 2 */
/*! @{ */

#define APU_WL_HOST_INTR_ALARM2_WL_HOST_INTR_ALARM_MASK (0xFFFFFFFFU)
#define APU_WL_HOST_INTR_ALARM2_WL_HOST_INTR_ALARM_SHIFT (0U)
/*! WL_HOST_INTR_ALARM - number of ref clocks after WLAN host request to firmware wakeup */
#define APU_WL_HOST_INTR_ALARM2_WL_HOST_INTR_ALARM(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_HOST_INTR_ALARM2_WL_HOST_INTR_ALARM_SHIFT)) & APU_WL_HOST_INTR_ALARM2_WL_HOST_INTR_ALARM_MASK)
/*! @} */

/*! @name WL_BCN_PLL_ALARM2 - WLAN Beacon PLL Alarm 2 */
/*! @{ */

#define APU_WL_BCN_PLL_ALARM2_WL_BCN_PLL_ALARM_MASK (0xFFFFFFFFU)
#define APU_WL_BCN_PLL_ALARM2_WL_BCN_PLL_ALARM_SHIFT (0U)
/*! WL_BCN_PLL_ALARM - number of sleep clocks until WLAN beacon timer requests for reference clock, power, and PLL */
#define APU_WL_BCN_PLL_ALARM2_WL_BCN_PLL_ALARM(x) (((uint32_t)(((uint32_t)(x)) << APU_WL_BCN_PLL_ALARM2_WL_BCN_PLL_ALARM_SHIFT)) & APU_WL_BCN_PLL_ALARM2_WL_BCN_PLL_ALARM_MASK)
/*! @} */

/*! @name WLCOMN_PWR_CTRL - WLAN Comm Powerup Control */
/*! @{ */

#define APU_WLCOMN_PWR_CTRL_WLCOMN_UDR_ASSERT_CNT_MASK (0xFFU)
#define APU_WLCOMN_PWR_CTRL_WLCOMN_UDR_ASSERT_CNT_SHIFT (0U)
/*! WLCOMN_UDR_ASSERT_CNT - WL COMM UDR Assert Count */
#define APU_WLCOMN_PWR_CTRL_WLCOMN_UDR_ASSERT_CNT(x) (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_PWR_CTRL_WLCOMN_UDR_ASSERT_CNT_SHIFT)) & APU_WLCOMN_PWR_CTRL_WLCOMN_UDR_ASSERT_CNT_MASK)

#define APU_WLCOMN_PWR_CTRL_USE_WLCOMN_PWR_RDY_FOR_WL_MASK (0x100U)
#define APU_WLCOMN_PWR_CTRL_USE_WLCOMN_PWR_RDY_FOR_WL_SHIFT (8U)
/*! USE_WLCOMN_PWR_RDY_FOR_WL - Use WL COMM Power Ready fro WLAN */
#define APU_WLCOMN_PWR_CTRL_USE_WLCOMN_PWR_RDY_FOR_WL(x) (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_PWR_CTRL_USE_WLCOMN_PWR_RDY_FOR_WL_SHIFT)) & APU_WLCOMN_PWR_CTRL_USE_WLCOMN_PWR_RDY_FOR_WL_MASK)

#define APU_WLCOMN_PWR_CTRL_USE_DEEPSLEEP_FOR_SYS_CLK_EN_MASK (0x200U)
#define APU_WLCOMN_PWR_CTRL_USE_DEEPSLEEP_FOR_SYS_CLK_EN_SHIFT (9U)
/*! USE_DEEPSLEEP_FOR_SYS_CLK_EN - Use Deep Sleep for SYS_CLK Enable */
#define APU_WLCOMN_PWR_CTRL_USE_DEEPSLEEP_FOR_SYS_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_PWR_CTRL_USE_DEEPSLEEP_FOR_SYS_CLK_EN_SHIFT)) & APU_WLCOMN_PWR_CTRL_USE_DEEPSLEEP_FOR_SYS_CLK_EN_MASK)

#define APU_WLCOMN_PWR_CTRL_IDLE2ISO_DLY_EN_MASK (0x400U)
#define APU_WLCOMN_PWR_CTRL_IDLE2ISO_DLY_EN_SHIFT (10U)
/*! IDLE2ISO_DLY_EN - wlcomn FSM state delay enable. When 1, use wlcomn_pwr_ctrl_dly and wlcomn_pwr_ctrl_dly2. When 0, no delay. */
#define APU_WLCOMN_PWR_CTRL_IDLE2ISO_DLY_EN(x)   (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_PWR_CTRL_IDLE2ISO_DLY_EN_SHIFT)) & APU_WLCOMN_PWR_CTRL_IDLE2ISO_DLY_EN_MASK)

#define APU_WLCOMN_PWR_CTRL_CPU_VINITHI_MASK     (0x8000U)
#define APU_WLCOMN_PWR_CTRL_CPU_VINITHI_SHIFT    (15U)
/*! CPU_VINITHI - CPU to CPU Delay */
#define APU_WLCOMN_PWR_CTRL_CPU_VINITHI(x)       (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_PWR_CTRL_CPU_VINITHI_SHIFT)) & APU_WLCOMN_PWR_CTRL_CPU_VINITHI_MASK)

#define APU_WLCOMN_PWR_CTRL_WLCOMN_PWRUP_CNT_MASK (0xFFFF0000U)
#define APU_WLCOMN_PWR_CTRL_WLCOMN_PWRUP_CNT_SHIFT (16U)
/*! WLCOMN_PWRUP_CNT - number of reference clocks after soc_pwr_rdy to push wlcomn power up */
#define APU_WLCOMN_PWR_CTRL_WLCOMN_PWRUP_CNT(x)  (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_PWR_CTRL_WLCOMN_PWRUP_CNT_SHIFT)) & APU_WLCOMN_PWR_CTRL_WLCOMN_PWRUP_CNT_MASK)
/*! @} */

/*! @name WLCOMN_STATUS - WLAN Comm Status */
/*! @{ */

#define APU_WLCOMN_STATUS_START_WLCOMN_WKUP_REFCK_MASK (0x400U)
#define APU_WLCOMN_STATUS_START_WLCOMN_WKUP_REFCK_SHIFT (10U)
/*! START_WLCOMN_WKUP_REFCK - WLCOMN FSM start ip wake up */
#define APU_WLCOMN_STATUS_START_WLCOMN_WKUP_REFCK(x) (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_STATUS_START_WLCOMN_WKUP_REFCK_SHIFT)) & APU_WLCOMN_STATUS_START_WLCOMN_WKUP_REFCK_MASK)

#define APU_WLCOMN_STATUS_ENTER_CPU1_SUB_DSLP_REFCK_MASK (0x800U)
#define APU_WLCOMN_STATUS_ENTER_CPU1_SUB_DSLP_REFCK_SHIFT (11U)
/*! ENTER_CPU1_SUB_DSLP_REFCK - WLCOMN FSM enter ip power down */
#define APU_WLCOMN_STATUS_ENTER_CPU1_SUB_DSLP_REFCK(x) (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_STATUS_ENTER_CPU1_SUB_DSLP_REFCK_SHIFT)) & APU_WLCOMN_STATUS_ENTER_CPU1_SUB_DSLP_REFCK_MASK)

#define APU_WLCOMN_STATUS_APU_WLCOMN_ST_MASK     (0xF000U)
#define APU_WLCOMN_STATUS_APU_WLCOMN_ST_SHIFT    (12U)
/*! APU_WLCOMN_ST - APU WLAN COMN St */
#define APU_WLCOMN_STATUS_APU_WLCOMN_ST(x)       (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_STATUS_APU_WLCOMN_ST_SHIFT)) & APU_WLCOMN_STATUS_APU_WLCOMN_ST_MASK)

#define APU_WLCOMN_STATUS_APU_WLCOMN_SWITCH_PD_MASK (0x10000U)
#define APU_WLCOMN_STATUS_APU_WLCOMN_SWITCH_PD_SHIFT (16U)
/*! APU_WLCOMN_SWITCH_PD - APU WLAN COMN Switch Pd */
#define APU_WLCOMN_STATUS_APU_WLCOMN_SWITCH_PD(x) (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_STATUS_APU_WLCOMN_SWITCH_PD_SHIFT)) & APU_WLCOMN_STATUS_APU_WLCOMN_SWITCH_PD_MASK)

#define APU_WLCOMN_STATUS_APU_WLCOMN_UDR_FIREWALL_B_MASK (0x20000U)
#define APU_WLCOMN_STATUS_APU_WLCOMN_UDR_FIREWALL_B_SHIFT (17U)
/*! APU_WLCOMN_UDR_FIREWALL_B - APU WLAN COMN UDR Firewall b */
#define APU_WLCOMN_STATUS_APU_WLCOMN_UDR_FIREWALL_B(x) (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_STATUS_APU_WLCOMN_UDR_FIREWALL_B_SHIFT)) & APU_WLCOMN_STATUS_APU_WLCOMN_UDR_FIREWALL_B_MASK)

#define APU_WLCOMN_STATUS_APU_WLCOMN_CLK_DIV_RSTB_MASK (0x40000U)
#define APU_WLCOMN_STATUS_APU_WLCOMN_CLK_DIV_RSTB_SHIFT (18U)
/*! APU_WLCOMN_CLK_DIV_RSTB - APU WLAN COMN Clock Div RSTb */
#define APU_WLCOMN_STATUS_APU_WLCOMN_CLK_DIV_RSTB(x) (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_STATUS_APU_WLCOMN_CLK_DIV_RSTB_SHIFT)) & APU_WLCOMN_STATUS_APU_WLCOMN_CLK_DIV_RSTB_MASK)

#define APU_WLCOMN_STATUS_APU_WLCOMN_ISO_EN_MASK (0x80000U)
#define APU_WLCOMN_STATUS_APU_WLCOMN_ISO_EN_SHIFT (19U)
/*! APU_WLCOMN_ISO_EN - APU WLAN COMN ISO Enable */
#define APU_WLCOMN_STATUS_APU_WLCOMN_ISO_EN(x)   (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_STATUS_APU_WLCOMN_ISO_EN_SHIFT)) & APU_WLCOMN_STATUS_APU_WLCOMN_ISO_EN_MASK)
/*! @} */

/*! @name BT_CTRL - Bluetooth Control */
/*! @{ */

#define APU_BT_CTRL_BT_SLP_RDY_MASK              (0x1U)
#define APU_BT_CTRL_BT_SLP_RDY_SHIFT             (0U)
/*! BT_SLP_RDY - Bluetooth Sleep Ready */
#define APU_BT_CTRL_BT_SLP_RDY(x)                (((uint32_t)(((uint32_t)(x)) << APU_BT_CTRL_BT_SLP_RDY_SHIFT)) & APU_BT_CTRL_BT_SLP_RDY_MASK)

#define APU_BT_CTRL_BT_SLP_RDYMASK_MASK          (0x2U)
#define APU_BT_CTRL_BT_SLP_RDYMASK_SHIFT         (1U)
/*! BT_SLP_RDYMASK - Bluetoot Sleep Ready Mask */
#define APU_BT_CTRL_BT_SLP_RDYMASK(x)            (((uint32_t)(((uint32_t)(x)) << APU_BT_CTRL_BT_SLP_RDYMASK_SHIFT)) & APU_BT_CTRL_BT_SLP_RDYMASK_MASK)

#define APU_BT_CTRL_BT_SLP_RDY_FW_MASK           (0x4U)
#define APU_BT_CTRL_BT_SLP_RDY_FW_SHIFT          (2U)
/*! BT_SLP_RDY_FW - Bluetooth Sleep Ready FW */
#define APU_BT_CTRL_BT_SLP_RDY_FW(x)             (((uint32_t)(((uint32_t)(x)) << APU_BT_CTRL_BT_SLP_RDY_FW_SHIFT)) & APU_BT_CTRL_BT_SLP_RDY_FW_MASK)

#define APU_BT_CTRL_BTU_CLK_NCO_MODE_SEL_EN_MASK (0x8U)
#define APU_BT_CTRL_BTU_CLK_NCO_MODE_SEL_EN_SHIFT (3U)
/*! BTU_CLK_NCO_MODE_SEL_EN - 0- disable the btu_clk_nco_mode from CIU2, keep the bt_clk_req as XP wakeup source */
#define APU_BT_CTRL_BTU_CLK_NCO_MODE_SEL_EN(x)   (((uint32_t)(((uint32_t)(x)) << APU_BT_CTRL_BTU_CLK_NCO_MODE_SEL_EN_SHIFT)) & APU_BT_CTRL_BTU_CLK_NCO_MODE_SEL_EN_MASK)

#define APU_BT_CTRL_USE_BT_INTR_SLP_MASK         (0x80U)
#define APU_BT_CTRL_USE_BT_INTR_SLP_SHIFT        (7U)
/*! USE_BT_INTR_SLP - Use Bluetooth interrupt Sleep */
#define APU_BT_CTRL_USE_BT_INTR_SLP(x)           (((uint32_t)(((uint32_t)(x)) << APU_BT_CTRL_USE_BT_INTR_SLP_SHIFT)) & APU_BT_CTRL_USE_BT_INTR_SLP_MASK)

#define APU_BT_CTRL_BT_CLK_SYNC_MODE_SEL1_MASK   (0x4000000U)
#define APU_BT_CTRL_BT_CLK_SYNC_MODE_SEL1_SHIFT  (26U)
/*! BT_CLK_SYNC_MODE_SEL1 - Bluetooth Clock Sync Mode Select 1 */
#define APU_BT_CTRL_BT_CLK_SYNC_MODE_SEL1(x)     (((uint32_t)(((uint32_t)(x)) << APU_BT_CTRL_BT_CLK_SYNC_MODE_SEL1_SHIFT)) & APU_BT_CTRL_BT_CLK_SYNC_MODE_SEL1_MASK)

#define APU_BT_CTRL_USE_GLITCH_FREE_BT_CLK_REQ_MASK (0x8000000U)
#define APU_BT_CTRL_USE_GLITCH_FREE_BT_CLK_REQ_SHIFT (27U)
/*! USE_GLITCH_FREE_BT_CLK_REQ - Use Glitch-Free Bluetooth Clock Request */
#define APU_BT_CTRL_USE_GLITCH_FREE_BT_CLK_REQ(x) (((uint32_t)(((uint32_t)(x)) << APU_BT_CTRL_USE_GLITCH_FREE_BT_CLK_REQ_SHIFT)) & APU_BT_CTRL_USE_GLITCH_FREE_BT_CLK_REQ_MASK)

#define APU_BT_CTRL_BRF_CLK_SYNC_MODE_SEL_MASK   (0x10000000U)
#define APU_BT_CTRL_BRF_CLK_SYNC_MODE_SEL_SHIFT  (28U)
/*! BRF_CLK_SYNC_MODE_SEL - BRF Clock Sync Mode Select */
#define APU_BT_CTRL_BRF_CLK_SYNC_MODE_SEL(x)     (((uint32_t)(((uint32_t)(x)) << APU_BT_CTRL_BRF_CLK_SYNC_MODE_SEL_SHIFT)) & APU_BT_CTRL_BRF_CLK_SYNC_MODE_SEL_MASK)

#define APU_BT_CTRL_BT_CLK_SYNC_MODE_SEL0_MASK   (0x20000000U)
#define APU_BT_CTRL_BT_CLK_SYNC_MODE_SEL0_SHIFT  (29U)
/*! BT_CLK_SYNC_MODE_SEL0 - Bluetooth Clock Sync Mode Select 0 */
#define APU_BT_CTRL_BT_CLK_SYNC_MODE_SEL0(x)     (((uint32_t)(((uint32_t)(x)) << APU_BT_CTRL_BT_CLK_SYNC_MODE_SEL0_SHIFT)) & APU_BT_CTRL_BT_CLK_SYNC_MODE_SEL0_MASK)

#define APU_BT_CTRL_BT_PLL_SYNC_MODE_SEL_MASK    (0x40000000U)
#define APU_BT_CTRL_BT_PLL_SYNC_MODE_SEL_SHIFT   (30U)
/*! BT_PLL_SYNC_MODE_SEL - Bluetooth PLL Sync Mode Select */
#define APU_BT_CTRL_BT_PLL_SYNC_MODE_SEL(x)      (((uint32_t)(((uint32_t)(x)) << APU_BT_CTRL_BT_PLL_SYNC_MODE_SEL_SHIFT)) & APU_BT_CTRL_BT_PLL_SYNC_MODE_SEL_MASK)

#define APU_BT_CTRL_BT_HOST_SLP_RDY_MASK         (0x80000000U)
#define APU_BT_CTRL_BT_HOST_SLP_RDY_SHIFT        (31U)
/*! BT_HOST_SLP_RDY - Bluetooth Host Sleep Ready */
#define APU_BT_CTRL_BT_HOST_SLP_RDY(x)           (((uint32_t)(((uint32_t)(x)) << APU_BT_CTRL_BT_HOST_SLP_RDY_SHIFT)) & APU_BT_CTRL_BT_HOST_SLP_RDY_MASK)
/*! @} */

/*! @name BT_WKUP_MASK - Bluetooth Wakeup Mask */
/*! @{ */

#define APU_BT_WKUP_MASK_BCA_CLK_REQ_MASK_MASK   (0x1U)
#define APU_BT_WKUP_MASK_BCA_CLK_REQ_MASK_SHIFT  (0U)
/*! BCA_CLK_REQ_MASK - BCA Clock Request Mask */
#define APU_BT_WKUP_MASK_BCA_CLK_REQ_MASK(x)     (((uint32_t)(((uint32_t)(x)) << APU_BT_WKUP_MASK_BCA_CLK_REQ_MASK_SHIFT)) & APU_BT_WKUP_MASK_BCA_CLK_REQ_MASK_MASK)

#define APU_BT_WKUP_MASK_BT_CLK_REQ_MASK_MASK    (0x2U)
#define APU_BT_WKUP_MASK_BT_CLK_REQ_MASK_SHIFT   (1U)
/*! BT_CLK_REQ_MASK - Bluetooth Clock Request Mask */
#define APU_BT_WKUP_MASK_BT_CLK_REQ_MASK(x)      (((uint32_t)(((uint32_t)(x)) << APU_BT_WKUP_MASK_BT_CLK_REQ_MASK_SHIFT)) & APU_BT_WKUP_MASK_BT_CLK_REQ_MASK_MASK)

#define APU_BT_WKUP_MASK_BT_WB_ACTIVE_REQ_MASK_MASK (0x4U)
#define APU_BT_WKUP_MASK_BT_WB_ACTIVE_REQ_MASK_SHIFT (2U)
/*! BT_WB_ACTIVE_REQ_MASK - Bluetooth WB Active Request Mask */
#define APU_BT_WKUP_MASK_BT_WB_ACTIVE_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_BT_WKUP_MASK_BT_WB_ACTIVE_REQ_MASK_SHIFT)) & APU_BT_WKUP_MASK_BT_WB_ACTIVE_REQ_MASK_MASK)

#define APU_BT_WKUP_MASK_BT_INTR_MASK_MASK       (0x8U)
#define APU_BT_WKUP_MASK_BT_INTR_MASK_SHIFT      (3U)
/*! BT_INTR_MASK - Bluetooth Interrupt Mask */
#define APU_BT_WKUP_MASK_BT_INTR_MASK(x)         (((uint32_t)(((uint32_t)(x)) << APU_BT_WKUP_MASK_BT_INTR_MASK_SHIFT)) & APU_BT_WKUP_MASK_BT_INTR_MASK_MASK)

#define APU_BT_WKUP_MASK_BT_PLL_REQ_MASK_MASK    (0x10U)
#define APU_BT_WKUP_MASK_BT_PLL_REQ_MASK_SHIFT   (4U)
/*! BT_PLL_REQ_MASK - Bluetooth PLL Request Mask */
#define APU_BT_WKUP_MASK_BT_PLL_REQ_MASK(x)      (((uint32_t)(((uint32_t)(x)) << APU_BT_WKUP_MASK_BT_PLL_REQ_MASK_SHIFT)) & APU_BT_WKUP_MASK_BT_PLL_REQ_MASK_MASK)

#define APU_BT_WKUP_MASK_BRF_PLL_REQ_MASK_MASK   (0x20U)
#define APU_BT_WKUP_MASK_BRF_PLL_REQ_MASK_SHIFT  (5U)
/*! BRF_PLL_REQ_MASK - BRF PLL Request Mask */
#define APU_BT_WKUP_MASK_BRF_PLL_REQ_MASK(x)     (((uint32_t)(((uint32_t)(x)) << APU_BT_WKUP_MASK_BRF_PLL_REQ_MASK_SHIFT)) & APU_BT_WKUP_MASK_BRF_PLL_REQ_MASK_MASK)

#define APU_BT_WKUP_MASK_BT_HOST_MAP_MASK        (0xFFFF0000U)
#define APU_BT_WKUP_MASK_BT_HOST_MAP_SHIFT       (16U)
/*! BT_HOST_MAP - Bluetooth Host Map */
#define APU_BT_WKUP_MASK_BT_HOST_MAP(x)          (((uint32_t)(((uint32_t)(x)) << APU_BT_WKUP_MASK_BT_HOST_MAP_SHIFT)) & APU_BT_WKUP_MASK_BT_HOST_MAP_MASK)
/*! @} */

/*! @name BT_STATUS - Bluetooth Status */
/*! @{ */

#define APU_BT_STATUS_APU_BT_CLK_EN_MASK         (0x1U)
#define APU_BT_STATUS_APU_BT_CLK_EN_SHIFT        (0U)
/*! APU_BT_CLK_EN - APU Bluetooth Clock Enable */
#define APU_BT_STATUS_APU_BT_CLK_EN(x)           (((uint32_t)(((uint32_t)(x)) << APU_BT_STATUS_APU_BT_CLK_EN_SHIFT)) & APU_BT_STATUS_APU_BT_CLK_EN_MASK)

#define APU_BT_STATUS_APU_BRF_CLK_EN_MASK        (0x2U)
#define APU_BT_STATUS_APU_BRF_CLK_EN_SHIFT       (1U)
/*! APU_BRF_CLK_EN - APU BRF Clock Enable */
#define APU_BT_STATUS_APU_BRF_CLK_EN(x)          (((uint32_t)(((uint32_t)(x)) << APU_BT_STATUS_APU_BRF_CLK_EN_SHIFT)) & APU_BT_STATUS_APU_BRF_CLK_EN_MASK)

#define APU_BT_STATUS_BT_ACTIVE_SLPCK_MASK       (0x4U)
#define APU_BT_STATUS_BT_ACTIVE_SLPCK_SHIFT      (2U)
/*! BT_ACTIVE_SLPCK - Bluetooth Active Sleep Clock */
#define APU_BT_STATUS_BT_ACTIVE_SLPCK(x)         (((uint32_t)(((uint32_t)(x)) << APU_BT_STATUS_BT_ACTIVE_SLPCK_SHIFT)) & APU_BT_STATUS_BT_ACTIVE_SLPCK_MASK)

#define APU_BT_STATUS_BT_HOST_WKUP_MASK          (0x10U)
#define APU_BT_STATUS_BT_HOST_WKUP_SHIFT         (4U)
/*! BT_HOST_WKUP - Bluetooth Host Wakeup */
#define APU_BT_STATUS_BT_HOST_WKUP(x)            (((uint32_t)(((uint32_t)(x)) << APU_BT_STATUS_BT_HOST_WKUP_SHIFT)) & APU_BT_STATUS_BT_HOST_WKUP_MASK)

#define APU_BT_STATUS_BT_INTERRUPT_MASK          (0x20U)
#define APU_BT_STATUS_BT_INTERRUPT_SHIFT         (5U)
/*! BT_INTERRUPT - Bluetooth Interrupt */
#define APU_BT_STATUS_BT_INTERRUPT(x)            (((uint32_t)(((uint32_t)(x)) << APU_BT_STATUS_BT_INTERRUPT_SHIFT)) & APU_BT_STATUS_BT_INTERRUPT_MASK)

#define APU_BT_STATUS_BT_PLL_REQ_MASK            (0x40U)
#define APU_BT_STATUS_BT_PLL_REQ_SHIFT           (6U)
/*! BT_PLL_REQ - Bluetooth PLL Request */
#define APU_BT_STATUS_BT_PLL_REQ(x)              (((uint32_t)(((uint32_t)(x)) << APU_BT_STATUS_BT_PLL_REQ_SHIFT)) & APU_BT_STATUS_BT_PLL_REQ_MASK)

#define APU_BT_STATUS_BT_CLK_REQ_MASK            (0x80U)
#define APU_BT_STATUS_BT_CLK_REQ_SHIFT           (7U)
/*! BT_CLK_REQ - Bluetooth Clock Request */
#define APU_BT_STATUS_BT_CLK_REQ(x)              (((uint32_t)(((uint32_t)(x)) << APU_BT_STATUS_BT_CLK_REQ_SHIFT)) & APU_BT_STATUS_BT_CLK_REQ_MASK)

#define APU_BT_STATUS_BRF_PLL_REQ_MASK           (0x100U)
#define APU_BT_STATUS_BRF_PLL_REQ_SHIFT          (8U)
/*! BRF_PLL_REQ - BRF PLL Request */
#define APU_BT_STATUS_BRF_PLL_REQ(x)             (((uint32_t)(((uint32_t)(x)) << APU_BT_STATUS_BRF_PLL_REQ_SHIFT)) & APU_BT_STATUS_BRF_PLL_REQ_MASK)

#define APU_BT_STATUS_BT_WIDEBAND_ACTIVE_MASK    (0x200U)
#define APU_BT_STATUS_BT_WIDEBAND_ACTIVE_SHIFT   (9U)
/*! BT_WIDEBAND_ACTIVE - Bluetooth Wideband Active */
#define APU_BT_STATUS_BT_WIDEBAND_ACTIVE(x)      (((uint32_t)(((uint32_t)(x)) << APU_BT_STATUS_BT_WIDEBAND_ACTIVE_SHIFT)) & APU_BT_STATUS_BT_WIDEBAND_ACTIVE_MASK)

#define APU_BT_STATUS_HOST_WKUP_IN_MASK          (0xFFFF0000U)
#define APU_BT_STATUS_HOST_WKUP_IN_SHIFT         (16U)
/*! HOST_WKUP_IN - Host Wakeup In */
#define APU_BT_STATUS_HOST_WKUP_IN(x)            (((uint32_t)(((uint32_t)(x)) << APU_BT_STATUS_HOST_WKUP_IN_SHIFT)) & APU_BT_STATUS_HOST_WKUP_IN_MASK)
/*! @} */

/*! @name BT_CKEN_CTRL - Bluetooth Clock Enable Control */
/*! @{ */

#define APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_PWR_MASK  (0x1U)
#define APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_PWR_SHIFT (0U)
/*! BT_CLK_EN_VAL_PWR - control value for bt_clk_en when power ready */
#define APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_PWR(x)    (((uint32_t)(((uint32_t)(x)) << APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_PWR_SHIFT)) & APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_PWR_MASK)

#define APU_BT_CKEN_CTRL_BL_CLK_EN_SEL_PWR_MASK  (0x2U)
#define APU_BT_CKEN_CTRL_BL_CLK_EN_SEL_PWR_SHIFT (1U)
/*! BL_CLK_EN_SEL_PWR - selection for bt_clk_en when power ready */
#define APU_BT_CKEN_CTRL_BL_CLK_EN_SEL_PWR(x)    (((uint32_t)(((uint32_t)(x)) << APU_BT_CKEN_CTRL_BL_CLK_EN_SEL_PWR_SHIFT)) & APU_BT_CKEN_CTRL_BL_CLK_EN_SEL_PWR_MASK)

#define APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_XOSC_MASK (0x4U)
#define APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_XOSC_SHIFT (2U)
/*! BT_CLK_EN_VAL_XOSC - control value for bt_clk_en when XOSC ready */
#define APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_XOSC(x)   (((uint32_t)(((uint32_t)(x)) << APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_XOSC_SHIFT)) & APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_XOSC_MASK)

#define APU_BT_CKEN_CTRL_BT_CLK_EN_SEL_XOSC_MASK (0x8U)
#define APU_BT_CKEN_CTRL_BT_CLK_EN_SEL_XOSC_SHIFT (3U)
/*! BT_CLK_EN_SEL_XOSC - selection for bt_clk_en when XOSC ready */
#define APU_BT_CKEN_CTRL_BT_CLK_EN_SEL_XOSC(x)   (((uint32_t)(((uint32_t)(x)) << APU_BT_CKEN_CTRL_BT_CLK_EN_SEL_XOSC_SHIFT)) & APU_BT_CKEN_CTRL_BT_CLK_EN_SEL_XOSC_MASK)

#define APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_MASK      (0x10U)
#define APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_SHIFT     (4U)
/*! BT_CLK_EN_VAL - control value for bt_clk_en when PLL ready */
#define APU_BT_CKEN_CTRL_BT_CLK_EN_VAL(x)        (((uint32_t)(((uint32_t)(x)) << APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_SHIFT)) & APU_BT_CKEN_CTRL_BT_CLK_EN_VAL_MASK)

#define APU_BT_CKEN_CTRL_BT_CLK_EN_SEL_MASK      (0x20U)
#define APU_BT_CKEN_CTRL_BT_CLK_EN_SEL_SHIFT     (5U)
/*! BT_CLK_EN_SEL - selection for bt_clk_en when PLL ready */
#define APU_BT_CKEN_CTRL_BT_CLK_EN_SEL(x)        (((uint32_t)(((uint32_t)(x)) << APU_BT_CKEN_CTRL_BT_CLK_EN_SEL_SHIFT)) & APU_BT_CKEN_CTRL_BT_CLK_EN_SEL_MASK)
/*! @} */

/*! @name BT_RESRC_CTRL - Bluetooth RESRC Control */
/*! @{ */

#define APU_BT_RESRC_CTRL_FW_PWR_REQ_MASK        (0x1U)
#define APU_BT_RESRC_CTRL_FW_PWR_REQ_SHIFT       (0U)
/*! FW_PWR_REQ - override hw power request */
#define APU_BT_RESRC_CTRL_FW_PWR_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_BT_RESRC_CTRL_FW_PWR_REQ_SHIFT)) & APU_BT_RESRC_CTRL_FW_PWR_REQ_MASK)

#define APU_BT_RESRC_CTRL_FW_PWR_REQ_VAL_MASK    (0x2U)
#define APU_BT_RESRC_CTRL_FW_PWR_REQ_VAL_SHIFT   (1U)
/*! FW_PWR_REQ_VAL - override value when apu_bt_resrc_ctrl[0] is set */
#define APU_BT_RESRC_CTRL_FW_PWR_REQ_VAL(x)      (((uint32_t)(((uint32_t)(x)) << APU_BT_RESRC_CTRL_FW_PWR_REQ_VAL_SHIFT)) & APU_BT_RESRC_CTRL_FW_PWR_REQ_VAL_MASK)

#define APU_BT_RESRC_CTRL_FW_XOSC_REQ_MASK       (0x4U)
#define APU_BT_RESRC_CTRL_FW_XOSC_REQ_SHIFT      (2U)
/*! FW_XOSC_REQ - override hw xosc request */
#define APU_BT_RESRC_CTRL_FW_XOSC_REQ(x)         (((uint32_t)(((uint32_t)(x)) << APU_BT_RESRC_CTRL_FW_XOSC_REQ_SHIFT)) & APU_BT_RESRC_CTRL_FW_XOSC_REQ_MASK)

#define APU_BT_RESRC_CTRL_FW_XOSC_REQ_VAL_MASK   (0x8U)
#define APU_BT_RESRC_CTRL_FW_XOSC_REQ_VAL_SHIFT  (3U)
/*! FW_XOSC_REQ_VAL - override value when apu_bt_resrc_ctrl[2] is set */
#define APU_BT_RESRC_CTRL_FW_XOSC_REQ_VAL(x)     (((uint32_t)(((uint32_t)(x)) << APU_BT_RESRC_CTRL_FW_XOSC_REQ_VAL_SHIFT)) & APU_BT_RESRC_CTRL_FW_XOSC_REQ_VAL_MASK)

#define APU_BT_RESRC_CTRL_FW_XP_REQ_MASK         (0x10U)
#define APU_BT_RESRC_CTRL_FW_XP_REQ_SHIFT        (4U)
/*! FW_XP_REQ - override hw xosc + pwr request */
#define APU_BT_RESRC_CTRL_FW_XP_REQ(x)           (((uint32_t)(((uint32_t)(x)) << APU_BT_RESRC_CTRL_FW_XP_REQ_SHIFT)) & APU_BT_RESRC_CTRL_FW_XP_REQ_MASK)

#define APU_BT_RESRC_CTRL_FW_XP_REQ_VAL_MASK     (0x20U)
#define APU_BT_RESRC_CTRL_FW_XP_REQ_VAL_SHIFT    (5U)
/*! FW_XP_REQ_VAL - override value when apu_bt_resrc_ctrl[4] is set */
#define APU_BT_RESRC_CTRL_FW_XP_REQ_VAL(x)       (((uint32_t)(((uint32_t)(x)) << APU_BT_RESRC_CTRL_FW_XP_REQ_VAL_SHIFT)) & APU_BT_RESRC_CTRL_FW_XP_REQ_VAL_MASK)

#define APU_BT_RESRC_CTRL_FW_SB_REQ_MASK         (0x40U)
#define APU_BT_RESRC_CTRL_FW_SB_REQ_SHIFT        (6U)
/*! FW_SB_REQ - override hw xosc + pwr + pll sb request */
#define APU_BT_RESRC_CTRL_FW_SB_REQ(x)           (((uint32_t)(((uint32_t)(x)) << APU_BT_RESRC_CTRL_FW_SB_REQ_SHIFT)) & APU_BT_RESRC_CTRL_FW_SB_REQ_MASK)

#define APU_BT_RESRC_CTRL_FW_SB_REQ_VAL_MASK     (0x80U)
#define APU_BT_RESRC_CTRL_FW_SB_REQ_VAL_SHIFT    (7U)
/*! FW_SB_REQ_VAL - override value when apu_bt_resrc_ctrl[6] is set */
#define APU_BT_RESRC_CTRL_FW_SB_REQ_VAL(x)       (((uint32_t)(((uint32_t)(x)) << APU_BT_RESRC_CTRL_FW_SB_REQ_VAL_SHIFT)) & APU_BT_RESRC_CTRL_FW_SB_REQ_VAL_MASK)

#define APU_BT_RESRC_CTRL_FW_IPWAKE_REQ_MASK     (0x100U)
#define APU_BT_RESRC_CTRL_FW_IPWAKE_REQ_SHIFT    (8U)
/*! FW_IPWAKE_REQ - override hw xosc + pwr + pll ipwake request */
#define APU_BT_RESRC_CTRL_FW_IPWAKE_REQ(x)       (((uint32_t)(((uint32_t)(x)) << APU_BT_RESRC_CTRL_FW_IPWAKE_REQ_SHIFT)) & APU_BT_RESRC_CTRL_FW_IPWAKE_REQ_MASK)

#define APU_BT_RESRC_CTRL_FW_IPWAKE_REQ_VAL_MASK (0x200U)
#define APU_BT_RESRC_CTRL_FW_IPWAKE_REQ_VAL_SHIFT (9U)
/*! FW_IPWAKE_REQ_VAL - override value when apu_bt_resrc_ctrl[8] is set */
#define APU_BT_RESRC_CTRL_FW_IPWAKE_REQ_VAL(x)   (((uint32_t)(((uint32_t)(x)) << APU_BT_RESRC_CTRL_FW_IPWAKE_REQ_VAL_SHIFT)) & APU_BT_RESRC_CTRL_FW_IPWAKE_REQ_VAL_MASK)

#define APU_BT_RESRC_CTRL_FW_ALLWAKE_REQ_MASK    (0x400U)
#define APU_BT_RESRC_CTRL_FW_ALLWAKE_REQ_SHIFT   (10U)
/*! FW_ALLWAKE_REQ - firmware override hw xosc + pwr + pll allwake request */
#define APU_BT_RESRC_CTRL_FW_ALLWAKE_REQ(x)      (((uint32_t)(((uint32_t)(x)) << APU_BT_RESRC_CTRL_FW_ALLWAKE_REQ_SHIFT)) & APU_BT_RESRC_CTRL_FW_ALLWAKE_REQ_MASK)

#define APU_BT_RESRC_CTRL_FW_ALLWAKE_REQ_VAL_MASK (0x800U)
#define APU_BT_RESRC_CTRL_FW_ALLWAKE_REQ_VAL_SHIFT (11U)
/*! FW_ALLWAKE_REQ_VAL - firmware override value when apu_bt_resrc_ctrl[10] is set */
#define APU_BT_RESRC_CTRL_FW_ALLWAKE_REQ_VAL(x)  (((uint32_t)(((uint32_t)(x)) << APU_BT_RESRC_CTRL_FW_ALLWAKE_REQ_VAL_SHIFT)) & APU_BT_RESRC_CTRL_FW_ALLWAKE_REQ_VAL_MASK)
/*! @} */

/*! @name BT_DVFS_CTRL - Bluetooth DVFS Control */
/*! @{ */

#define APU_BT_DVFS_CTRL_BT_VOL_VAL_MASK         (0x7FU)
#define APU_BT_DVFS_CTRL_BT_VOL_VAL_SHIFT        (0U)
/*! BT_VOL_VAL - Blueooth Vol Value */
#define APU_BT_DVFS_CTRL_BT_VOL_VAL(x)           (((uint32_t)(((uint32_t)(x)) << APU_BT_DVFS_CTRL_BT_VOL_VAL_SHIFT)) & APU_BT_DVFS_CTRL_BT_VOL_VAL_MASK)
/*! @} */

/*! @name FM_CTRL - FM Control */
/*! @{ */

#define APU_FM_CTRL_FM_SLP_RDY_MASK              (0x1U)
#define APU_FM_CTRL_FM_SLP_RDY_SHIFT             (0U)
/*! FM_SLP_RDY - FM Sleep Delay */
#define APU_FM_CTRL_FM_SLP_RDY(x)                (((uint32_t)(((uint32_t)(x)) << APU_FM_CTRL_FM_SLP_RDY_SHIFT)) & APU_FM_CTRL_FM_SLP_RDY_MASK)

#define APU_FM_CTRL_FM_SLP_RDYMASK_MASK          (0x2U)
#define APU_FM_CTRL_FM_SLP_RDYMASK_SHIFT         (1U)
/*! FM_SLP_RDYMASK - FM Sleep Ready Mask */
#define APU_FM_CTRL_FM_SLP_RDYMASK(x)            (((uint32_t)(((uint32_t)(x)) << APU_FM_CTRL_FM_SLP_RDYMASK_SHIFT)) & APU_FM_CTRL_FM_SLP_RDYMASK_MASK)

#define APU_FM_CTRL_FM_SLP_RDY_FW_MASK           (0x4U)
#define APU_FM_CTRL_FM_SLP_RDY_FW_SHIFT          (2U)
/*! FM_SLP_RDY_FW - FM Sleep Ready FW */
#define APU_FM_CTRL_FM_SLP_RDY_FW(x)             (((uint32_t)(((uint32_t)(x)) << APU_FM_CTRL_FM_SLP_RDY_FW_SHIFT)) & APU_FM_CTRL_FM_SLP_RDY_FW_MASK)

#define APU_FM_CTRL_FM_PRESENT_MASK              (0x8U)
#define APU_FM_CTRL_FM_PRESENT_SHIFT             (3U)
/*! FM_PRESENT - FM Present */
#define APU_FM_CTRL_FM_PRESENT(x)                (((uint32_t)(((uint32_t)(x)) << APU_FM_CTRL_FM_PRESENT_SHIFT)) & APU_FM_CTRL_FM_PRESENT_MASK)

#define APU_FM_CTRL_FM_DYN_VOL_EN_MASK           (0x10U)
#define APU_FM_CTRL_FM_DYN_VOL_EN_SHIFT          (4U)
/*! FM_DYN_VOL_EN - FM Dynamic Vol Enable */
#define APU_FM_CTRL_FM_DYN_VOL_EN(x)             (((uint32_t)(((uint32_t)(x)) << APU_FM_CTRL_FM_DYN_VOL_EN_SHIFT)) & APU_FM_CTRL_FM_DYN_VOL_EN_MASK)

#define APU_FM_CTRL_FM_CLK_SYNC_MODE_SEL_MASK    (0x20U)
#define APU_FM_CTRL_FM_CLK_SYNC_MODE_SEL_SHIFT   (5U)
/*! FM_CLK_SYNC_MODE_SEL - FM Clock Sync Mode Select */
#define APU_FM_CTRL_FM_CLK_SYNC_MODE_SEL(x)      (((uint32_t)(((uint32_t)(x)) << APU_FM_CTRL_FM_CLK_SYNC_MODE_SEL_SHIFT)) & APU_FM_CTRL_FM_CLK_SYNC_MODE_SEL_MASK)

#define APU_FM_CTRL_USE_FM_INTR_SLP_MASK         (0x80U)
#define APU_FM_CTRL_USE_FM_INTR_SLP_SHIFT        (7U)
/*! USE_FM_INTR_SLP - Use FM Interrupt Sleep */
#define APU_FM_CTRL_USE_FM_INTR_SLP(x)           (((uint32_t)(((uint32_t)(x)) << APU_FM_CTRL_USE_FM_INTR_SLP_SHIFT)) & APU_FM_CTRL_USE_FM_INTR_SLP_MASK)

#define APU_FM_CTRL_FM_HOST_SLP_RDY_MASK         (0x80000000U)
#define APU_FM_CTRL_FM_HOST_SLP_RDY_SHIFT        (31U)
/*! FM_HOST_SLP_RDY - FM Host Sleep Ready */
#define APU_FM_CTRL_FM_HOST_SLP_RDY(x)           (((uint32_t)(((uint32_t)(x)) << APU_FM_CTRL_FM_HOST_SLP_RDY_SHIFT)) & APU_FM_CTRL_FM_HOST_SLP_RDY_MASK)
/*! @} */

/*! @name FM_WKUP_MASK - FM Wakeup Mask */
/*! @{ */

#define APU_FM_WKUP_MASK_FM_CLK_REQ_MASK_MASK    (0x1U)
#define APU_FM_WKUP_MASK_FM_CLK_REQ_MASK_SHIFT   (0U)
/*! FM_CLK_REQ_MASK - FM Clock Request Mask */
#define APU_FM_WKUP_MASK_FM_CLK_REQ_MASK(x)      (((uint32_t)(((uint32_t)(x)) << APU_FM_WKUP_MASK_FM_CLK_REQ_MASK_SHIFT)) & APU_FM_WKUP_MASK_FM_CLK_REQ_MASK_MASK)

#define APU_FM_WKUP_MASK_FM_INTR_MASK_MASK       (0x2U)
#define APU_FM_WKUP_MASK_FM_INTR_MASK_SHIFT      (1U)
/*! FM_INTR_MASK - FM Interrupt Mask */
#define APU_FM_WKUP_MASK_FM_INTR_MASK(x)         (((uint32_t)(((uint32_t)(x)) << APU_FM_WKUP_MASK_FM_INTR_MASK_SHIFT)) & APU_FM_WKUP_MASK_FM_INTR_MASK_MASK)

#define APU_FM_WKUP_MASK_FM_PRESENT_MASK_MASK    (0x4U)
#define APU_FM_WKUP_MASK_FM_PRESENT_MASK_SHIFT   (2U)
/*! FM_PRESENT_MASK - FM Present Mask */
#define APU_FM_WKUP_MASK_FM_PRESENT_MASK(x)      (((uint32_t)(((uint32_t)(x)) << APU_FM_WKUP_MASK_FM_PRESENT_MASK_SHIFT)) & APU_FM_WKUP_MASK_FM_PRESENT_MASK_MASK)

#define APU_FM_WKUP_MASK_FM_HOST_MAP_MASK        (0xFFFF0000U)
#define APU_FM_WKUP_MASK_FM_HOST_MAP_SHIFT       (16U)
/*! FM_HOST_MAP - FM to host-HOST Delay */
#define APU_FM_WKUP_MASK_FM_HOST_MAP(x)          (((uint32_t)(((uint32_t)(x)) << APU_FM_WKUP_MASK_FM_HOST_MAP_SHIFT)) & APU_FM_WKUP_MASK_FM_HOST_MAP_MASK)
/*! @} */

/*! @name FM_STATUS - FM Status */
/*! @{ */

#define APU_FM_STATUS_APU_FM_CLK_EN_MASK         (0x1U)
#define APU_FM_STATUS_APU_FM_CLK_EN_SHIFT        (0U)
/*! APU_FM_CLK_EN - APU FM Clock Enable */
#define APU_FM_STATUS_APU_FM_CLK_EN(x)           (((uint32_t)(((uint32_t)(x)) << APU_FM_STATUS_APU_FM_CLK_EN_SHIFT)) & APU_FM_STATUS_APU_FM_CLK_EN_MASK)

#define APU_FM_STATUS_SOC_CLK_EN2_MASK           (0x2U)
#define APU_FM_STATUS_SOC_CLK_EN2_SHIFT          (1U)
/*! SOC_CLK_EN2 - SoC Clock Enable 2 */
#define APU_FM_STATUS_SOC_CLK_EN2(x)             (((uint32_t)(((uint32_t)(x)) << APU_FM_STATUS_SOC_CLK_EN2_SHIFT)) & APU_FM_STATUS_SOC_CLK_EN2_MASK)

#define APU_FM_STATUS_XOSC_STABLE_REFCK_MASK     (0x4U)
#define APU_FM_STATUS_XOSC_STABLE_REFCK_SHIFT    (2U)
/*! XOSC_STABLE_REFCK - XOSC Stable Ref Clock */
#define APU_FM_STATUS_XOSC_STABLE_REFCK(x)       (((uint32_t)(((uint32_t)(x)) << APU_FM_STATUS_XOSC_STABLE_REFCK_SHIFT)) & APU_FM_STATUS_XOSC_STABLE_REFCK_MASK)

#define APU_FM_STATUS_FM_HOST_WKUP_MASK          (0x10U)
#define APU_FM_STATUS_FM_HOST_WKUP_SHIFT         (4U)
/*! FM_HOST_WKUP - FM Host Wakeup */
#define APU_FM_STATUS_FM_HOST_WKUP(x)            (((uint32_t)(((uint32_t)(x)) << APU_FM_STATUS_FM_HOST_WKUP_SHIFT)) & APU_FM_STATUS_FM_HOST_WKUP_MASK)

#define APU_FM_STATUS_FM_INTR_MASK               (0x20U)
#define APU_FM_STATUS_FM_INTR_SHIFT              (5U)
/*! FM_INTR - FM Interrupt */
#define APU_FM_STATUS_FM_INTR(x)                 (((uint32_t)(((uint32_t)(x)) << APU_FM_STATUS_FM_INTR_SHIFT)) & APU_FM_STATUS_FM_INTR_MASK)

#define APU_FM_STATUS_FM_CLK_REQ_MASK            (0x40U)
#define APU_FM_STATUS_FM_CLK_REQ_SHIFT           (6U)
/*! FM_CLK_REQ - FM Clock Request */
#define APU_FM_STATUS_FM_CLK_REQ(x)              (((uint32_t)(((uint32_t)(x)) << APU_FM_STATUS_FM_CLK_REQ_SHIFT)) & APU_FM_STATUS_FM_CLK_REQ_MASK)

#define APU_FM_STATUS_FM_PRESENT_MASK            (0x80U)
#define APU_FM_STATUS_FM_PRESENT_SHIFT           (7U)
/*! FM_PRESENT - FM Present */
#define APU_FM_STATUS_FM_PRESENT(x)              (((uint32_t)(((uint32_t)(x)) << APU_FM_STATUS_FM_PRESENT_SHIFT)) & APU_FM_STATUS_FM_PRESENT_MASK)

#define APU_FM_STATUS_HOST_WKUP_IN_MASK          (0xFFFF0000U)
#define APU_FM_STATUS_HOST_WKUP_IN_SHIFT         (16U)
/*! HOST_WKUP_IN - Host Wakeup Interrupt */
#define APU_FM_STATUS_HOST_WKUP_IN(x)            (((uint32_t)(((uint32_t)(x)) << APU_FM_STATUS_HOST_WKUP_IN_SHIFT)) & APU_FM_STATUS_HOST_WKUP_IN_MASK)
/*! @} */

/*! @name FM_CKEN_CTRL - FM Clock Enable Control */
/*! @{ */

#define APU_FM_CKEN_CTRL_FM_CLK_EN_PWR_VAL_MASK  (0x1U)
#define APU_FM_CKEN_CTRL_FM_CLK_EN_PWR_VAL_SHIFT (0U)
/*! FM_CLK_EN_PWR_VAL - control value for fm_clk_en when power ready */
#define APU_FM_CKEN_CTRL_FM_CLK_EN_PWR_VAL(x)    (((uint32_t)(((uint32_t)(x)) << APU_FM_CKEN_CTRL_FM_CLK_EN_PWR_VAL_SHIFT)) & APU_FM_CKEN_CTRL_FM_CLK_EN_PWR_VAL_MASK)

#define APU_FM_CKEN_CTRL_FM_CLK_EN_PWR_SEL_MASK  (0x2U)
#define APU_FM_CKEN_CTRL_FM_CLK_EN_PWR_SEL_SHIFT (1U)
/*! FM_CLK_EN_PWR_SEL - selection for fm_clk_en when power ready */
#define APU_FM_CKEN_CTRL_FM_CLK_EN_PWR_SEL(x)    (((uint32_t)(((uint32_t)(x)) << APU_FM_CKEN_CTRL_FM_CLK_EN_PWR_SEL_SHIFT)) & APU_FM_CKEN_CTRL_FM_CLK_EN_PWR_SEL_MASK)

#define APU_FM_CKEN_CTRL_FM_CLK_EN_XOSC_VAL_MASK (0x4U)
#define APU_FM_CKEN_CTRL_FM_CLK_EN_XOSC_VAL_SHIFT (2U)
/*! FM_CLK_EN_XOSC_VAL - control value for fm_clk_en when xosc is ready */
#define APU_FM_CKEN_CTRL_FM_CLK_EN_XOSC_VAL(x)   (((uint32_t)(((uint32_t)(x)) << APU_FM_CKEN_CTRL_FM_CLK_EN_XOSC_VAL_SHIFT)) & APU_FM_CKEN_CTRL_FM_CLK_EN_XOSC_VAL_MASK)

#define APU_FM_CKEN_CTRL_FM_CLK_EN_XOSC_SEL_MASK (0x8U)
#define APU_FM_CKEN_CTRL_FM_CLK_EN_XOSC_SEL_SHIFT (3U)
/*! FM_CLK_EN_XOSC_SEL - selection for fm_clk_en when XOSC ready */
#define APU_FM_CKEN_CTRL_FM_CLK_EN_XOSC_SEL(x)   (((uint32_t)(((uint32_t)(x)) << APU_FM_CKEN_CTRL_FM_CLK_EN_XOSC_SEL_SHIFT)) & APU_FM_CKEN_CTRL_FM_CLK_EN_XOSC_SEL_MASK)

#define APU_FM_CKEN_CTRL_FM_CLK_EN_PLL_VAL_MASK  (0x10U)
#define APU_FM_CKEN_CTRL_FM_CLK_EN_PLL_VAL_SHIFT (4U)
/*! FM_CLK_EN_PLL_VAL - control value for fm_clk_en when PLL ready */
#define APU_FM_CKEN_CTRL_FM_CLK_EN_PLL_VAL(x)    (((uint32_t)(((uint32_t)(x)) << APU_FM_CKEN_CTRL_FM_CLK_EN_PLL_VAL_SHIFT)) & APU_FM_CKEN_CTRL_FM_CLK_EN_PLL_VAL_MASK)

#define APU_FM_CKEN_CTRL_FM_CLK_EN_PLL_SEL_MASK  (0x20U)
#define APU_FM_CKEN_CTRL_FM_CLK_EN_PLL_SEL_SHIFT (5U)
/*! FM_CLK_EN_PLL_SEL - selection for fm_clk_en when PLL ready */
#define APU_FM_CKEN_CTRL_FM_CLK_EN_PLL_SEL(x)    (((uint32_t)(((uint32_t)(x)) << APU_FM_CKEN_CTRL_FM_CLK_EN_PLL_SEL_SHIFT)) & APU_FM_CKEN_CTRL_FM_CLK_EN_PLL_SEL_MASK)
/*! @} */

/*! @name FM_RESRC_CTRL - FM RESRC Control */
/*! @{ */

#define APU_FM_RESRC_CTRL_FM_PWR_REQ_MASK        (0x1U)
#define APU_FM_RESRC_CTRL_FM_PWR_REQ_SHIFT       (0U)
/*! FM_PWR_REQ - override hw power request */
#define APU_FM_RESRC_CTRL_FM_PWR_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_FM_RESRC_CTRL_FM_PWR_REQ_SHIFT)) & APU_FM_RESRC_CTRL_FM_PWR_REQ_MASK)

#define APU_FM_RESRC_CTRL_FM_PWR_REQ_VAL_MASK    (0x2U)
#define APU_FM_RESRC_CTRL_FM_PWR_REQ_VAL_SHIFT   (1U)
/*! FM_PWR_REQ_VAL - override value when apu_fm_resrc_ctrl[0] is set */
#define APU_FM_RESRC_CTRL_FM_PWR_REQ_VAL(x)      (((uint32_t)(((uint32_t)(x)) << APU_FM_RESRC_CTRL_FM_PWR_REQ_VAL_SHIFT)) & APU_FM_RESRC_CTRL_FM_PWR_REQ_VAL_MASK)

#define APU_FM_RESRC_CTRL_FM_XOSC_REQ_MASK       (0x4U)
#define APU_FM_RESRC_CTRL_FM_XOSC_REQ_SHIFT      (2U)
/*! FM_XOSC_REQ - override hw xosc request */
#define APU_FM_RESRC_CTRL_FM_XOSC_REQ(x)         (((uint32_t)(((uint32_t)(x)) << APU_FM_RESRC_CTRL_FM_XOSC_REQ_SHIFT)) & APU_FM_RESRC_CTRL_FM_XOSC_REQ_MASK)

#define APU_FM_RESRC_CTRL_FM_XOSC_REQ_VAL_MASK   (0x8U)
#define APU_FM_RESRC_CTRL_FM_XOSC_REQ_VAL_SHIFT  (3U)
/*! FM_XOSC_REQ_VAL - override value when apu_fm_resrc_ctrl[2] is set */
#define APU_FM_RESRC_CTRL_FM_XOSC_REQ_VAL(x)     (((uint32_t)(((uint32_t)(x)) << APU_FM_RESRC_CTRL_FM_XOSC_REQ_VAL_SHIFT)) & APU_FM_RESRC_CTRL_FM_XOSC_REQ_VAL_MASK)

#define APU_FM_RESRC_CTRL_FM_XP_REQ_MASK         (0x10U)
#define APU_FM_RESRC_CTRL_FM_XP_REQ_SHIFT        (4U)
/*! FM_XP_REQ - override hw xosc + pwr request */
#define APU_FM_RESRC_CTRL_FM_XP_REQ(x)           (((uint32_t)(((uint32_t)(x)) << APU_FM_RESRC_CTRL_FM_XP_REQ_SHIFT)) & APU_FM_RESRC_CTRL_FM_XP_REQ_MASK)

#define APU_FM_RESRC_CTRL_FM_XP_REQ_VAL_MASK     (0x20U)
#define APU_FM_RESRC_CTRL_FM_XP_REQ_VAL_SHIFT    (5U)
/*! FM_XP_REQ_VAL - override value when apu_fm_resrc_ctrl[4] is set */
#define APU_FM_RESRC_CTRL_FM_XP_REQ_VAL(x)       (((uint32_t)(((uint32_t)(x)) << APU_FM_RESRC_CTRL_FM_XP_REQ_VAL_SHIFT)) & APU_FM_RESRC_CTRL_FM_XP_REQ_VAL_MASK)

#define APU_FM_RESRC_CTRL_FM_SB_REQ_MASK         (0x40U)
#define APU_FM_RESRC_CTRL_FM_SB_REQ_SHIFT        (6U)
/*! FM_SB_REQ - override hw xosc + pwr + pll sb request */
#define APU_FM_RESRC_CTRL_FM_SB_REQ(x)           (((uint32_t)(((uint32_t)(x)) << APU_FM_RESRC_CTRL_FM_SB_REQ_SHIFT)) & APU_FM_RESRC_CTRL_FM_SB_REQ_MASK)

#define APU_FM_RESRC_CTRL_FM_SB_REQ_VAL_MASK     (0x80U)
#define APU_FM_RESRC_CTRL_FM_SB_REQ_VAL_SHIFT    (7U)
/*! FM_SB_REQ_VAL - override value when apu_fm_resrc_ctrl[6] is set */
#define APU_FM_RESRC_CTRL_FM_SB_REQ_VAL(x)       (((uint32_t)(((uint32_t)(x)) << APU_FM_RESRC_CTRL_FM_SB_REQ_VAL_SHIFT)) & APU_FM_RESRC_CTRL_FM_SB_REQ_VAL_MASK)

#define APU_FM_RESRC_CTRL_FM_IPWAKE_REQ_MASK     (0x100U)
#define APU_FM_RESRC_CTRL_FM_IPWAKE_REQ_SHIFT    (8U)
/*! FM_IPWAKE_REQ - override hw xosc + pwr + pll ipwake request */
#define APU_FM_RESRC_CTRL_FM_IPWAKE_REQ(x)       (((uint32_t)(((uint32_t)(x)) << APU_FM_RESRC_CTRL_FM_IPWAKE_REQ_SHIFT)) & APU_FM_RESRC_CTRL_FM_IPWAKE_REQ_MASK)

#define APU_FM_RESRC_CTRL_FM_IPWAKE_REQ_VAL_MASK (0x200U)
#define APU_FM_RESRC_CTRL_FM_IPWAKE_REQ_VAL_SHIFT (9U)
/*! FM_IPWAKE_REQ_VAL - override value when apu_fm_resrc_ctrl[8] is set */
#define APU_FM_RESRC_CTRL_FM_IPWAKE_REQ_VAL(x)   (((uint32_t)(((uint32_t)(x)) << APU_FM_RESRC_CTRL_FM_IPWAKE_REQ_VAL_SHIFT)) & APU_FM_RESRC_CTRL_FM_IPWAKE_REQ_VAL_MASK)

#define APU_FM_RESRC_CTRL_FM_ALLWAKE_REQ_MASK    (0x400U)
#define APU_FM_RESRC_CTRL_FM_ALLWAKE_REQ_SHIFT   (10U)
/*! FM_ALLWAKE_REQ - firmware override hw xosc + pwr + pll allwake request */
#define APU_FM_RESRC_CTRL_FM_ALLWAKE_REQ(x)      (((uint32_t)(((uint32_t)(x)) << APU_FM_RESRC_CTRL_FM_ALLWAKE_REQ_SHIFT)) & APU_FM_RESRC_CTRL_FM_ALLWAKE_REQ_MASK)

#define APU_FM_RESRC_CTRL_FM_ALLWAKE_REQ_VAL_MASK (0x800U)
#define APU_FM_RESRC_CTRL_FM_ALLWAKE_REQ_VAL_SHIFT (11U)
/*! FM_ALLWAKE_REQ_VAL - firmware override value when apu_fm_resrc_ctrl[10] is set */
#define APU_FM_RESRC_CTRL_FM_ALLWAKE_REQ_VAL(x)  (((uint32_t)(((uint32_t)(x)) << APU_FM_RESRC_CTRL_FM_ALLWAKE_REQ_VAL_SHIFT)) & APU_FM_RESRC_CTRL_FM_ALLWAKE_REQ_VAL_MASK)
/*! @} */

/*! @name FM_DVFS_CTRL - FM DVFS Control */
/*! @{ */

#define APU_FM_DVFS_CTRL_FM_VOL_VAL_MASK         (0x7FU)
#define APU_FM_DVFS_CTRL_FM_VOL_VAL_SHIFT        (0U)
/*! FM_VOL_VAL - FM Vol Value */
#define APU_FM_DVFS_CTRL_FM_VOL_VAL(x)           (((uint32_t)(((uint32_t)(x)) << APU_FM_DVFS_CTRL_FM_VOL_VAL_SHIFT)) & APU_FM_DVFS_CTRL_FM_VOL_VAL_MASK)
/*! @} */

/*! @name USB_PWR_CTRL_DLY - USB FSM Power Control Delay */
/*! @{ */

#define APU_USB_PWR_CTRL_DLY_PWR_CTRL_DLY_MASK   (0xFFFFFFFFU)
#define APU_USB_PWR_CTRL_DLY_PWR_CTRL_DLY_SHIFT  (0U)
/*! PWR_CTRL_DLY - USB FSM Power Control Delay */
#define APU_USB_PWR_CTRL_DLY_PWR_CTRL_DLY(x)     (((uint32_t)(((uint32_t)(x)) << APU_USB_PWR_CTRL_DLY_PWR_CTRL_DLY_SHIFT)) & APU_USB_PWR_CTRL_DLY_PWR_CTRL_DLY_MASK)
/*! @} */

/*! @name USB_PWR_CTRL_DLY2 - USB FSM Power Control Delay 2 */
/*! @{ */

#define APU_USB_PWR_CTRL_DLY2_PWR_CTRL_DLY2_MASK (0xFFFFFFFFU)
#define APU_USB_PWR_CTRL_DLY2_PWR_CTRL_DLY2_SHIFT (0U)
/*! PWR_CTRL_DLY2 - USB FSM Power Control Delay 2 */
#define APU_USB_PWR_CTRL_DLY2_PWR_CTRL_DLY2(x)   (((uint32_t)(((uint32_t)(x)) << APU_USB_PWR_CTRL_DLY2_PWR_CTRL_DLY2_SHIFT)) & APU_USB_PWR_CTRL_DLY2_PWR_CTRL_DLY2_MASK)
/*! @} */

/*! @name WLCOMN_PWR_CTRL_DLY - Wlan common domain FSM Power Control Delay */
/*! @{ */

#define APU_WLCOMN_PWR_CTRL_DLY_PWR_CTRL_DLY_MASK (0xFFFFFFFFU)
#define APU_WLCOMN_PWR_CTRL_DLY_PWR_CTRL_DLY_SHIFT (0U)
/*! PWR_CTRL_DLY - WLAN COMN FSM power control delay */
#define APU_WLCOMN_PWR_CTRL_DLY_PWR_CTRL_DLY(x)  (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_PWR_CTRL_DLY_PWR_CTRL_DLY_SHIFT)) & APU_WLCOMN_PWR_CTRL_DLY_PWR_CTRL_DLY_MASK)
/*! @} */

/*! @name WLCOMN_PWR_CTRL_DLY2 - Wlan common domain FSM Power Control Delay 2 */
/*! @{ */

#define APU_WLCOMN_PWR_CTRL_DLY2_PWR_CTRL_DLY2_MASK (0xFFFFFFFFU)
#define APU_WLCOMN_PWR_CTRL_DLY2_PWR_CTRL_DLY2_SHIFT (0U)
/*! PWR_CTRL_DLY2 - WLAN COMN FSM power control delay */
#define APU_WLCOMN_PWR_CTRL_DLY2_PWR_CTRL_DLY2(x) (((uint32_t)(((uint32_t)(x)) << APU_WLCOMN_PWR_CTRL_DLY2_PWR_CTRL_DLY2_SHIFT)) & APU_WLCOMN_PWR_CTRL_DLY2_PWR_CTRL_DLY2_MASK)
/*! @} */

/*! @name BLE_CTRL - BLE Control */
/*! @{ */

#define APU_BLE_CTRL_BLE_SLP_RDY_MASK            (0x1U)
#define APU_BLE_CTRL_BLE_SLP_RDY_SHIFT           (0U)
/*! BLE_SLP_RDY - BLE Sleep Ready */
#define APU_BLE_CTRL_BLE_SLP_RDY(x)              (((uint32_t)(((uint32_t)(x)) << APU_BLE_CTRL_BLE_SLP_RDY_SHIFT)) & APU_BLE_CTRL_BLE_SLP_RDY_MASK)

#define APU_BLE_CTRL_BLE_SLP_RDYMASK_MASK        (0x2U)
#define APU_BLE_CTRL_BLE_SLP_RDYMASK_SHIFT       (1U)
/*! BLE_SLP_RDYMASK - BLE Sleep Ready Mask */
#define APU_BLE_CTRL_BLE_SLP_RDYMASK(x)          (((uint32_t)(((uint32_t)(x)) << APU_BLE_CTRL_BLE_SLP_RDYMASK_SHIFT)) & APU_BLE_CTRL_BLE_SLP_RDYMASK_MASK)

#define APU_BLE_CTRL_BLE_SLP_RDY_FW_MASK         (0x4U)
#define APU_BLE_CTRL_BLE_SLP_RDY_FW_SHIFT        (2U)
/*! BLE_SLP_RDY_FW - BLE Sleep Ready FW */
#define APU_BLE_CTRL_BLE_SLP_RDY_FW(x)           (((uint32_t)(((uint32_t)(x)) << APU_BLE_CTRL_BLE_SLP_RDY_FW_SHIFT)) & APU_BLE_CTRL_BLE_SLP_RDY_FW_MASK)

#define APU_BLE_CTRL_BLE_MODE_EN_MASK            (0x8U)
#define APU_BLE_CTRL_BLE_MODE_EN_SHIFT           (3U)
/*! BLE_MODE_EN - BLE Mode Enable */
#define APU_BLE_CTRL_BLE_MODE_EN(x)              (((uint32_t)(((uint32_t)(x)) << APU_BLE_CTRL_BLE_MODE_EN_SHIFT)) & APU_BLE_CTRL_BLE_MODE_EN_MASK)

#define APU_BLE_CTRL_BT_AES_NCO_MODE_MASK        (0x8000U)
#define APU_BLE_CTRL_BT_AES_NCO_MODE_SHIFT       (15U)
/*! BT_AES_NCO_MODE - Bluetooth AES NCO Mode */
#define APU_BLE_CTRL_BT_AES_NCO_MODE(x)          (((uint32_t)(((uint32_t)(x)) << APU_BLE_CTRL_BT_AES_NCO_MODE_SHIFT)) & APU_BLE_CTRL_BT_AES_NCO_MODE_MASK)

#define APU_BLE_CTRL_BLE_XP_REQ_MASK             (0x80000000U)
#define APU_BLE_CTRL_BLE_XP_REQ_SHIFT            (31U)
/*! BLE_XP_REQ - BLE XP Request */
#define APU_BLE_CTRL_BLE_XP_REQ(x)               (((uint32_t)(((uint32_t)(x)) << APU_BLE_CTRL_BLE_XP_REQ_SHIFT)) & APU_BLE_CTRL_BLE_XP_REQ_MASK)
/*! @} */

/*! @name BLE_WKUP_MASK - BLE Wakeup Mask */
/*! @{ */

#define APU_BLE_WKUP_MASK_BT_AES_CLK_REQ_MASK_MASK (0x8U)
#define APU_BLE_WKUP_MASK_BT_AES_CLK_REQ_MASK_SHIFT (3U)
/*! BT_AES_CLK_REQ_MASK - Bluetooth AES Clock Request Mask */
#define APU_BLE_WKUP_MASK_BT_AES_CLK_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_BLE_WKUP_MASK_BT_AES_CLK_REQ_MASK_SHIFT)) & APU_BLE_WKUP_MASK_BT_AES_CLK_REQ_MASK_MASK)

#define APU_BLE_WKUP_MASK_LBC_XP_REQ_MASK_MASK   (0x10U)
#define APU_BLE_WKUP_MASK_LBC_XP_REQ_MASK_SHIFT  (4U)
/*! LBC_XP_REQ_MASK - LBC XP Request Mask */
#define APU_BLE_WKUP_MASK_LBC_XP_REQ_MASK(x)     (((uint32_t)(((uint32_t)(x)) << APU_BLE_WKUP_MASK_LBC_XP_REQ_MASK_SHIFT)) & APU_BLE_WKUP_MASK_LBC_XP_REQ_MASK_MASK)
/*! @} */

/*! @name BLE_STATUS - BLE Status */
/*! @{ */

#define APU_BLE_STATUS_APU_BT_AES_CLK_EN_MASK    (0x1U)
#define APU_BLE_STATUS_APU_BT_AES_CLK_EN_SHIFT   (0U)
/*! APU_BT_AES_CLK_EN - APU Bluetooth AES Clock Enable */
#define APU_BLE_STATUS_APU_BT_AES_CLK_EN(x)      (((uint32_t)(((uint32_t)(x)) << APU_BLE_STATUS_APU_BT_AES_CLK_EN_SHIFT)) & APU_BLE_STATUS_APU_BT_AES_CLK_EN_MASK)

#define APU_BLE_STATUS_BT_AES_CLK_SEL_MASK       (0x2U)
#define APU_BLE_STATUS_BT_AES_CLK_SEL_SHIFT      (1U)
/*! BT_AES_CLK_SEL - Bluetooth AES Clock Select */
#define APU_BLE_STATUS_BT_AES_CLK_SEL(x)         (((uint32_t)(((uint32_t)(x)) << APU_BLE_STATUS_BT_AES_CLK_SEL_SHIFT)) & APU_BLE_STATUS_BT_AES_CLK_SEL_MASK)

#define APU_BLE_STATUS_XOSC_STABLE_REFCK_MASK    (0x4U)
#define APU_BLE_STATUS_XOSC_STABLE_REFCK_SHIFT   (2U)
/*! XOSC_STABLE_REFCK - XOSC Stable Ref Clock */
#define APU_BLE_STATUS_XOSC_STABLE_REFCK(x)      (((uint32_t)(((uint32_t)(x)) << APU_BLE_STATUS_XOSC_STABLE_REFCK_SHIFT)) & APU_BLE_STATUS_XOSC_STABLE_REFCK_MASK)

#define APU_BLE_STATUS_T1_STABLE_MASK            (0x8U)
#define APU_BLE_STATUS_T1_STABLE_SHIFT           (3U)
/*! T1_STABLE - T1 Delay */
#define APU_BLE_STATUS_T1_STABLE(x)              (((uint32_t)(((uint32_t)(x)) << APU_BLE_STATUS_T1_STABLE_SHIFT)) & APU_BLE_STATUS_T1_STABLE_MASK)

#define APU_BLE_STATUS_BT_INTERRUPT_MASK         (0x10U)
#define APU_BLE_STATUS_BT_INTERRUPT_SHIFT        (4U)
/*! BT_INTERRUPT - Bluetooth Interrupt */
#define APU_BLE_STATUS_BT_INTERRUPT(x)           (((uint32_t)(((uint32_t)(x)) << APU_BLE_STATUS_BT_INTERRUPT_SHIFT)) & APU_BLE_STATUS_BT_INTERRUPT_MASK)

#define APU_BLE_STATUS_BLE_XP_REQ_MASK           (0x20U)
#define APU_BLE_STATUS_BLE_XP_REQ_SHIFT          (5U)
/*! BLE_XP_REQ - BLE XP Request */
#define APU_BLE_STATUS_BLE_XP_REQ(x)             (((uint32_t)(((uint32_t)(x)) << APU_BLE_STATUS_BLE_XP_REQ_SHIFT)) & APU_BLE_STATUS_BLE_XP_REQ_MASK)

#define APU_BLE_STATUS_BT_AES_NCO_MODE_MASK      (0x40U)
#define APU_BLE_STATUS_BT_AES_NCO_MODE_SHIFT     (6U)
/*! BT_AES_NCO_MODE - Blueooth AES NCO Mode */
#define APU_BLE_STATUS_BT_AES_NCO_MODE(x)        (((uint32_t)(((uint32_t)(x)) << APU_BLE_STATUS_BT_AES_NCO_MODE_SHIFT)) & APU_BLE_STATUS_BT_AES_NCO_MODE_MASK)

#define APU_BLE_STATUS_LBC_XP_REQ_MASK           (0x100U)
#define APU_BLE_STATUS_LBC_XP_REQ_SHIFT          (8U)
/*! LBC_XP_REQ - LBC XP Request */
#define APU_BLE_STATUS_LBC_XP_REQ(x)             (((uint32_t)(((uint32_t)(x)) << APU_BLE_STATUS_LBC_XP_REQ_SHIFT)) & APU_BLE_STATUS_LBC_XP_REQ_MASK)

#define APU_BLE_STATUS_BT_AES_CLK_REQ_MASK       (0x200U)
#define APU_BLE_STATUS_BT_AES_CLK_REQ_SHIFT      (9U)
/*! BT_AES_CLK_REQ - Bluetooth AES Clock Request Mask */
#define APU_BLE_STATUS_BT_AES_CLK_REQ(x)         (((uint32_t)(((uint32_t)(x)) << APU_BLE_STATUS_BT_AES_CLK_REQ_SHIFT)) & APU_BLE_STATUS_BT_AES_CLK_REQ_MASK)
/*! @} */

/*! @name NFC_CTRL - NFC Control */
/*! @{ */

#define APU_NFC_CTRL_NFC_SLP_RDY_MASK            (0x1U)
#define APU_NFC_CTRL_NFC_SLP_RDY_SHIFT           (0U)
/*! NFC_SLP_RDY - NFC Sleep Ready */
#define APU_NFC_CTRL_NFC_SLP_RDY(x)              (((uint32_t)(((uint32_t)(x)) << APU_NFC_CTRL_NFC_SLP_RDY_SHIFT)) & APU_NFC_CTRL_NFC_SLP_RDY_MASK)

#define APU_NFC_CTRL_NFC_SLP_RDYMASK_MASK        (0x2U)
#define APU_NFC_CTRL_NFC_SLP_RDYMASK_SHIFT       (1U)
/*! NFC_SLP_RDYMASK - NFC Sleep Ready Mask */
#define APU_NFC_CTRL_NFC_SLP_RDYMASK(x)          (((uint32_t)(((uint32_t)(x)) << APU_NFC_CTRL_NFC_SLP_RDYMASK_SHIFT)) & APU_NFC_CTRL_NFC_SLP_RDYMASK_MASK)

#define APU_NFC_CTRL_NFC_SLP_RDY_FW_MASK         (0x4U)
#define APU_NFC_CTRL_NFC_SLP_RDY_FW_SHIFT        (2U)
/*! NFC_SLP_RDY_FW - NFC Sleep Ready FW */
#define APU_NFC_CTRL_NFC_SLP_RDY_FW(x)           (((uint32_t)(((uint32_t)(x)) << APU_NFC_CTRL_NFC_SLP_RDY_FW_SHIFT)) & APU_NFC_CTRL_NFC_SLP_RDY_FW_MASK)

#define APU_NFC_CTRL_USE_NFC_REF_ONLY_MASK       (0x8U)
#define APU_NFC_CTRL_USE_NFC_REF_ONLY_SHIFT      (3U)
/*! USE_NFC_REF_ONLY - Use NFC Reference Only */
#define APU_NFC_CTRL_USE_NFC_REF_ONLY(x)         (((uint32_t)(((uint32_t)(x)) << APU_NFC_CTRL_USE_NFC_REF_ONLY_SHIFT)) & APU_NFC_CTRL_USE_NFC_REF_ONLY_MASK)

#define APU_NFC_CTRL_USE_NFC_INTR_SLP_MASK       (0x10U)
#define APU_NFC_CTRL_USE_NFC_INTR_SLP_SHIFT      (4U)
/*! USE_NFC_INTR_SLP - Use NFC Interrupt Sleep */
#define APU_NFC_CTRL_USE_NFC_INTR_SLP(x)         (((uint32_t)(((uint32_t)(x)) << APU_NFC_CTRL_USE_NFC_INTR_SLP_SHIFT)) & APU_NFC_CTRL_USE_NFC_INTR_SLP_MASK)

#define APU_NFC_CTRL_NFC_USE_SOC_PWR_SEQ_MASK    (0x20U)
#define APU_NFC_CTRL_NFC_USE_SOC_PWR_SEQ_SHIFT   (5U)
/*! NFC_USE_SOC_PWR_SEQ - Use SoC power sequence for NFC as well */
#define APU_NFC_CTRL_NFC_USE_SOC_PWR_SEQ(x)      (((uint32_t)(((uint32_t)(x)) << APU_NFC_CTRL_NFC_USE_SOC_PWR_SEQ_SHIFT)) & APU_NFC_CTRL_NFC_USE_SOC_PWR_SEQ_MASK)

#define APU_NFC_CTRL_FW_CLR_NFC_INTR_MASK        (0x80U)
#define APU_NFC_CTRL_FW_CLR_NFC_INTR_SHIFT       (7U)
/*! FW_CLR_NFC_INTR - FW Clear NFC Interrupt */
#define APU_NFC_CTRL_FW_CLR_NFC_INTR(x)          (((uint32_t)(((uint32_t)(x)) << APU_NFC_CTRL_FW_CLR_NFC_INTR_SHIFT)) & APU_NFC_CTRL_FW_CLR_NFC_INTR_MASK)

#define APU_NFC_CTRL_NFC_USE_CPU2_SUBSLP_MASK    (0x100U)
#define APU_NFC_CTRL_NFC_USE_CPU2_SUBSLP_SHIFT   (8U)
/*! NFC_USE_CPU2_SUBSLP - Use CPU2 subsystem sleep for NFC power down */
#define APU_NFC_CTRL_NFC_USE_CPU2_SUBSLP(x)      (((uint32_t)(((uint32_t)(x)) << APU_NFC_CTRL_NFC_USE_CPU2_SUBSLP_SHIFT)) & APU_NFC_CTRL_NFC_USE_CPU2_SUBSLP_MASK)

#define APU_NFC_CTRL_NFC_USE_NOM_PWR_BYP_MASK    (0x200U)
#define APU_NFC_CTRL_NFC_USE_NOM_PWR_BYP_SHIFT   (9U)
/*! NFC_USE_NOM_PWR_BYP - Use nom_pwr_lvl from dvfs for nfc_pwr_lvl_reached */
#define APU_NFC_CTRL_NFC_USE_NOM_PWR_BYP(x)      (((uint32_t)(((uint32_t)(x)) << APU_NFC_CTRL_NFC_USE_NOM_PWR_BYP_SHIFT)) & APU_NFC_CTRL_NFC_USE_NOM_PWR_BYP_MASK)

#define APU_NFC_CTRL_FW_FORCE_NFC_PWRUP_MASK     (0x1000000U)
#define APU_NFC_CTRL_FW_FORCE_NFC_PWRUP_SHIFT    (24U)
/*! FW_FORCE_NFC_PWRUP - FW Force NFC Powerup */
#define APU_NFC_CTRL_FW_FORCE_NFC_PWRUP(x)       (((uint32_t)(((uint32_t)(x)) << APU_NFC_CTRL_FW_FORCE_NFC_PWRUP_SHIFT)) & APU_NFC_CTRL_FW_FORCE_NFC_PWRUP_MASK)

#define APU_NFC_CTRL_NFC_USE_UNSYNC_PWR_LVL_MASK (0x2000000U)
#define APU_NFC_CTRL_NFC_USE_UNSYNC_PWR_LVL_SHIFT (25U)
/*! NFC_USE_UNSYNC_PWR_LVL - NFC Use Unsync Power Level */
#define APU_NFC_CTRL_NFC_USE_UNSYNC_PWR_LVL(x)   (((uint32_t)(((uint32_t)(x)) << APU_NFC_CTRL_NFC_USE_UNSYNC_PWR_LVL_SHIFT)) & APU_NFC_CTRL_NFC_USE_UNSYNC_PWR_LVL_MASK)

#define APU_NFC_CTRL_NFC_HOST_SLP_RDY_MASK       (0x80000000U)
#define APU_NFC_CTRL_NFC_HOST_SLP_RDY_SHIFT      (31U)
/*! NFC_HOST_SLP_RDY - NFC Host Sleep Ready */
#define APU_NFC_CTRL_NFC_HOST_SLP_RDY(x)         (((uint32_t)(((uint32_t)(x)) << APU_NFC_CTRL_NFC_HOST_SLP_RDY_SHIFT)) & APU_NFC_CTRL_NFC_HOST_SLP_RDY_MASK)
/*! @} */

/*! @name NFC_WKUP_MASK - NFC Wakeup Mask */
/*! @{ */

#define APU_NFC_WKUP_MASK_NFC_P_WKUP_MASK_MASK   (0x1U)
#define APU_NFC_WKUP_MASK_NFC_P_WKUP_MASK_SHIFT  (0U)
/*! NFC_P_WKUP_MASK - NFC P Wakeup Mask */
#define APU_NFC_WKUP_MASK_NFC_P_WKUP_MASK(x)     (((uint32_t)(((uint32_t)(x)) << APU_NFC_WKUP_MASK_NFC_P_WKUP_MASK_SHIFT)) & APU_NFC_WKUP_MASK_NFC_P_WKUP_MASK_MASK)

#define APU_NFC_WKUP_MASK_NFC_XP_WKUP_MASK_MASK  (0x2U)
#define APU_NFC_WKUP_MASK_NFC_XP_WKUP_MASK_SHIFT (1U)
/*! NFC_XP_WKUP_MASK - NFC XP Wakeup Mask */
#define APU_NFC_WKUP_MASK_NFC_XP_WKUP_MASK(x)    (((uint32_t)(((uint32_t)(x)) << APU_NFC_WKUP_MASK_NFC_XP_WKUP_MASK_SHIFT)) & APU_NFC_WKUP_MASK_NFC_XP_WKUP_MASK_MASK)

#define APU_NFC_WKUP_MASK_NFC_INT_WKUP_MASK_MASK (0x4U)
#define APU_NFC_WKUP_MASK_NFC_INT_WKUP_MASK_SHIFT (2U)
/*! NFC_INT_WKUP_MASK - NFC Interrupt Wakeup Mask */
#define APU_NFC_WKUP_MASK_NFC_INT_WKUP_MASK(x)   (((uint32_t)(((uint32_t)(x)) << APU_NFC_WKUP_MASK_NFC_INT_WKUP_MASK_SHIFT)) & APU_NFC_WKUP_MASK_NFC_INT_WKUP_MASK_MASK)

#define APU_NFC_WKUP_MASK_NFC_HOST_MAP_MASK      (0xFFFF0000U)
#define APU_NFC_WKUP_MASK_NFC_HOST_MAP_SHIFT     (16U)
/*! NFC_HOST_MAP - NFC Host Map */
#define APU_NFC_WKUP_MASK_NFC_HOST_MAP(x)        (((uint32_t)(((uint32_t)(x)) << APU_NFC_WKUP_MASK_NFC_HOST_MAP_SHIFT)) & APU_NFC_WKUP_MASK_NFC_HOST_MAP_MASK)
/*! @} */

/*! @name NFC_STATUS - NFC Status */
/*! @{ */

#define APU_NFC_STATUS_APU_NFC_AHBCLK_EN_MASK    (0x1U)
#define APU_NFC_STATUS_APU_NFC_AHBCLK_EN_SHIFT   (0U)
/*! APU_NFC_AHBCLK_EN - APU NFC AHB Clock Enable */
#define APU_NFC_STATUS_APU_NFC_AHBCLK_EN(x)      (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_APU_NFC_AHBCLK_EN_SHIFT)) & APU_NFC_STATUS_APU_NFC_AHBCLK_EN_MASK)

#define APU_NFC_STATUS_NFC_INT_MASK              (0x2U)
#define APU_NFC_STATUS_NFC_INT_SHIFT             (1U)
/*! NFC_INT - NFC Interrupt */
#define APU_NFC_STATUS_NFC_INT(x)                (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_NFC_INT_SHIFT)) & APU_NFC_STATUS_NFC_INT_MASK)

#define APU_NFC_STATUS_NFC_XP_REQ_MASK           (0x4U)
#define APU_NFC_STATUS_NFC_XP_REQ_SHIFT          (2U)
/*! NFC_XP_REQ - NFC XP Req */
#define APU_NFC_STATUS_NFC_XP_REQ(x)             (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_NFC_XP_REQ_SHIFT)) & APU_NFC_STATUS_NFC_XP_REQ_MASK)

#define APU_NFC_STATUS_NFC_P_REQ_MASK            (0x8U)
#define APU_NFC_STATUS_NFC_P_REQ_SHIFT           (3U)
/*! NFC_P_REQ - NFC P Req */
#define APU_NFC_STATUS_NFC_P_REQ(x)              (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_NFC_P_REQ_SHIFT)) & APU_NFC_STATUS_NFC_P_REQ_MASK)

#define APU_NFC_STATUS_APU_NFC_SWITCH_PD_AON_MASK (0x10U)
#define APU_NFC_STATUS_APU_NFC_SWITCH_PD_AON_SHIFT (4U)
/*! APU_NFC_SWITCH_PD_AON - APU NFC Switch PD AON */
#define APU_NFC_STATUS_APU_NFC_SWITCH_PD_AON(x)  (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_APU_NFC_SWITCH_PD_AON_SHIFT)) & APU_NFC_STATUS_APU_NFC_SWITCH_PD_AON_MASK)

#define APU_NFC_STATUS_APU_NFC_UDR_FIREWALL_B_AON_MASK (0x20U)
#define APU_NFC_STATUS_APU_NFC_UDR_FIREWALL_B_AON_SHIFT (5U)
/*! APU_NFC_UDR_FIREWALL_B_AON - APU NFC UDR Firewall B AON */
#define APU_NFC_STATUS_APU_NFC_UDR_FIREWALL_B_AON(x) (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_APU_NFC_UDR_FIREWALL_B_AON_SHIFT)) & APU_NFC_STATUS_APU_NFC_UDR_FIREWALL_B_AON_MASK)

#define APU_NFC_STATUS_APU_NFC_CLK_DIV_RSTB_AON_MASK (0x40U)
#define APU_NFC_STATUS_APU_NFC_CLK_DIV_RSTB_AON_SHIFT (6U)
/*! APU_NFC_CLK_DIV_RSTB_AON - APU NFC Clock Divider RSTb AON */
#define APU_NFC_STATUS_APU_NFC_CLK_DIV_RSTB_AON(x) (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_APU_NFC_CLK_DIV_RSTB_AON_SHIFT)) & APU_NFC_STATUS_APU_NFC_CLK_DIV_RSTB_AON_MASK)

#define APU_NFC_STATUS_APU_NFC_ISO_EN_AON_MASK   (0x80U)
#define APU_NFC_STATUS_APU_NFC_ISO_EN_AON_SHIFT  (7U)
/*! APU_NFC_ISO_EN_AON - APU NFC ISO Enable AON */
#define APU_NFC_STATUS_APU_NFC_ISO_EN_AON(x)     (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_APU_NFC_ISO_EN_AON_SHIFT)) & APU_NFC_STATUS_APU_NFC_ISO_EN_AON_MASK)

#define APU_NFC_STATUS_APU_NFC_SRAM_PD_AON_MASK  (0x100U)
#define APU_NFC_STATUS_APU_NFC_SRAM_PD_AON_SHIFT (8U)
/*! APU_NFC_SRAM_PD_AON - APU NFC SRAM PD AON */
#define APU_NFC_STATUS_APU_NFC_SRAM_PD_AON(x)    (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_APU_NFC_SRAM_PD_AON_SHIFT)) & APU_NFC_STATUS_APU_NFC_SRAM_PD_AON_MASK)

#define APU_NFC_STATUS_NFC_VOL_REACHED_MASK      (0x200U)
#define APU_NFC_STATUS_NFC_VOL_REACHED_SHIFT     (9U)
/*! NFC_VOL_REACHED - NFC Vol Reached */
#define APU_NFC_STATUS_NFC_VOL_REACHED(x)        (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_NFC_VOL_REACHED_SHIFT)) & APU_NFC_STATUS_NFC_VOL_REACHED_MASK)

#define APU_NFC_STATUS_SOC_VOL_REACHED_MASK      (0x400U)
#define APU_NFC_STATUS_SOC_VOL_REACHED_SHIFT     (10U)
/*! SOC_VOL_REACHED - SoC Vol Reached */
#define APU_NFC_STATUS_SOC_VOL_REACHED(x)        (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_SOC_VOL_REACHED_SHIFT)) & APU_NFC_STATUS_SOC_VOL_REACHED_MASK)

#define APU_NFC_STATUS_NFC_PWR_RDY_MASK          (0x800U)
#define APU_NFC_STATUS_NFC_PWR_RDY_SHIFT         (11U)
/*! NFC_PWR_RDY - NFC Power ready */
#define APU_NFC_STATUS_NFC_PWR_RDY(x)            (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_NFC_PWR_RDY_SHIFT)) & APU_NFC_STATUS_NFC_PWR_RDY_MASK)

#define APU_NFC_STATUS_APU_NFC_ST_MASK           (0x7000U)
#define APU_NFC_STATUS_APU_NFC_ST_SHIFT          (12U)
/*! APU_NFC_ST - APU NFC St */
#define APU_NFC_STATUS_APU_NFC_ST(x)             (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_APU_NFC_ST_SHIFT)) & APU_NFC_STATUS_APU_NFC_ST_MASK)

#define APU_NFC_STATUS_HOST_WKUP_IN_MASK         (0xFFFF0000U)
#define APU_NFC_STATUS_HOST_WKUP_IN_SHIFT        (16U)
/*! HOST_WKUP_IN - Host Wakeup Interrupt */
#define APU_NFC_STATUS_HOST_WKUP_IN(x)           (((uint32_t)(((uint32_t)(x)) << APU_NFC_STATUS_HOST_WKUP_IN_SHIFT)) & APU_NFC_STATUS_HOST_WKUP_IN_MASK)
/*! @} */

/*! @name NFC_CKEN_CTRL - NFC Clock Enable Control */
/*! @{ */

#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_PWR_VAL_MASK (0x1U)
#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_PWR_VAL_SHIFT (0U)
/*! NFC_CLK_EN_PWR_VAL - control value for nfc_clk_en when power ready */
#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_PWR_VAL(x)  (((uint32_t)(((uint32_t)(x)) << APU_NFC_CKEN_CTRL_NFC_CLK_EN_PWR_VAL_SHIFT)) & APU_NFC_CKEN_CTRL_NFC_CLK_EN_PWR_VAL_MASK)

#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_PWR_SEL_MASK (0x2U)
#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_PWR_SEL_SHIFT (1U)
/*! NFC_CLK_EN_PWR_SEL - selection for nfc_cm3_clk_en when power ready */
#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_PWR_SEL(x)  (((uint32_t)(((uint32_t)(x)) << APU_NFC_CKEN_CTRL_NFC_CLK_EN_PWR_SEL_SHIFT)) & APU_NFC_CKEN_CTRL_NFC_CLK_EN_PWR_SEL_MASK)

#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_XOSC_VAL_MASK (0x4U)
#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_XOSC_VAL_SHIFT (2U)
/*! NFC_CLK_EN_XOSC_VAL - Control value for nfc_cm3_clk_en when XOSC ready */
#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_XOSC_VAL(x) (((uint32_t)(((uint32_t)(x)) << APU_NFC_CKEN_CTRL_NFC_CLK_EN_XOSC_VAL_SHIFT)) & APU_NFC_CKEN_CTRL_NFC_CLK_EN_XOSC_VAL_MASK)

#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_XOSC_SEL_MASK (0x8U)
#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_XOSC_SEL_SHIFT (3U)
/*! NFC_CLK_EN_XOSC_SEL - selection for nfc_cm3_clk_en when XOSC ready */
#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_XOSC_SEL(x) (((uint32_t)(((uint32_t)(x)) << APU_NFC_CKEN_CTRL_NFC_CLK_EN_XOSC_SEL_SHIFT)) & APU_NFC_CKEN_CTRL_NFC_CLK_EN_XOSC_SEL_MASK)

#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_PLL_VAL_MASK (0x10U)
#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_PLL_VAL_SHIFT (4U)
/*! NFC_CLK_EN_PLL_VAL - NFC Clock Enable PLL Value */
#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_PLL_VAL(x)  (((uint32_t)(((uint32_t)(x)) << APU_NFC_CKEN_CTRL_NFC_CLK_EN_PLL_VAL_SHIFT)) & APU_NFC_CKEN_CTRL_NFC_CLK_EN_PLL_VAL_MASK)

#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_PLL_SEL_MASK (0x20U)
#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_PLL_SEL_SHIFT (5U)
/*! NFC_CLK_EN_PLL_SEL - selection for nfc_cm3_clk_en when PLL ready */
#define APU_NFC_CKEN_CTRL_NFC_CLK_EN_PLL_SEL(x)  (((uint32_t)(((uint32_t)(x)) << APU_NFC_CKEN_CTRL_NFC_CLK_EN_PLL_SEL_SHIFT)) & APU_NFC_CKEN_CTRL_NFC_CLK_EN_PLL_SEL_MASK)
/*! @} */

/*! @name NFC_RESRC_CTRL - NFC RESRC Control */
/*! @{ */

#define APU_NFC_RESRC_CTRL_NFC_PWR_REQ_MASK      (0x1U)
#define APU_NFC_RESRC_CTRL_NFC_PWR_REQ_SHIFT     (0U)
/*! NFC_PWR_REQ - override hw power request */
#define APU_NFC_RESRC_CTRL_NFC_PWR_REQ(x)        (((uint32_t)(((uint32_t)(x)) << APU_NFC_RESRC_CTRL_NFC_PWR_REQ_SHIFT)) & APU_NFC_RESRC_CTRL_NFC_PWR_REQ_MASK)

#define APU_NFC_RESRC_CTRL_NFC_PWR_REQ_VAL_MASK  (0x2U)
#define APU_NFC_RESRC_CTRL_NFC_PWR_REQ_VAL_SHIFT (1U)
/*! NFC_PWR_REQ_VAL - override value when apu_nfc_resrc_ctrl[0] is set */
#define APU_NFC_RESRC_CTRL_NFC_PWR_REQ_VAL(x)    (((uint32_t)(((uint32_t)(x)) << APU_NFC_RESRC_CTRL_NFC_PWR_REQ_VAL_SHIFT)) & APU_NFC_RESRC_CTRL_NFC_PWR_REQ_VAL_MASK)

#define APU_NFC_RESRC_CTRL_NFC_XOSC_REQ_MASK     (0x4U)
#define APU_NFC_RESRC_CTRL_NFC_XOSC_REQ_SHIFT    (2U)
/*! NFC_XOSC_REQ - override hw xosc request */
#define APU_NFC_RESRC_CTRL_NFC_XOSC_REQ(x)       (((uint32_t)(((uint32_t)(x)) << APU_NFC_RESRC_CTRL_NFC_XOSC_REQ_SHIFT)) & APU_NFC_RESRC_CTRL_NFC_XOSC_REQ_MASK)

#define APU_NFC_RESRC_CTRL_NFC_XOSC_REQ_VAL_MASK (0x8U)
#define APU_NFC_RESRC_CTRL_NFC_XOSC_REQ_VAL_SHIFT (3U)
/*! NFC_XOSC_REQ_VAL - override value when apu_nfc_resrc_ctrl[2] is set */
#define APU_NFC_RESRC_CTRL_NFC_XOSC_REQ_VAL(x)   (((uint32_t)(((uint32_t)(x)) << APU_NFC_RESRC_CTRL_NFC_XOSC_REQ_VAL_SHIFT)) & APU_NFC_RESRC_CTRL_NFC_XOSC_REQ_VAL_MASK)

#define APU_NFC_RESRC_CTRL_NFC_XP_REQ_MASK       (0x10U)
#define APU_NFC_RESRC_CTRL_NFC_XP_REQ_SHIFT      (4U)
/*! NFC_XP_REQ - override hw xosc + pwr request */
#define APU_NFC_RESRC_CTRL_NFC_XP_REQ(x)         (((uint32_t)(((uint32_t)(x)) << APU_NFC_RESRC_CTRL_NFC_XP_REQ_SHIFT)) & APU_NFC_RESRC_CTRL_NFC_XP_REQ_MASK)

#define APU_NFC_RESRC_CTRL_NFC_XP_REQ_VAL_MASK   (0x20U)
#define APU_NFC_RESRC_CTRL_NFC_XP_REQ_VAL_SHIFT  (5U)
/*! NFC_XP_REQ_VAL - override value when apu_nfc_resrc_ctrl[4] is set */
#define APU_NFC_RESRC_CTRL_NFC_XP_REQ_VAL(x)     (((uint32_t)(((uint32_t)(x)) << APU_NFC_RESRC_CTRL_NFC_XP_REQ_VAL_SHIFT)) & APU_NFC_RESRC_CTRL_NFC_XP_REQ_VAL_MASK)

#define APU_NFC_RESRC_CTRL_NFC_SB_REQ_MASK       (0x40U)
#define APU_NFC_RESRC_CTRL_NFC_SB_REQ_SHIFT      (6U)
/*! NFC_SB_REQ - override hw xosc + pwr + pll sb request */
#define APU_NFC_RESRC_CTRL_NFC_SB_REQ(x)         (((uint32_t)(((uint32_t)(x)) << APU_NFC_RESRC_CTRL_NFC_SB_REQ_SHIFT)) & APU_NFC_RESRC_CTRL_NFC_SB_REQ_MASK)

#define APU_NFC_RESRC_CTRL_NFC_SB_REQ_VAL_MASK   (0x80U)
#define APU_NFC_RESRC_CTRL_NFC_SB_REQ_VAL_SHIFT  (7U)
/*! NFC_SB_REQ_VAL - override value when apu_nfc_resrc_ctrl[6] is set */
#define APU_NFC_RESRC_CTRL_NFC_SB_REQ_VAL(x)     (((uint32_t)(((uint32_t)(x)) << APU_NFC_RESRC_CTRL_NFC_SB_REQ_VAL_SHIFT)) & APU_NFC_RESRC_CTRL_NFC_SB_REQ_VAL_MASK)

#define APU_NFC_RESRC_CTRL_NFC_IPWAKE_REQ_MASK   (0x100U)
#define APU_NFC_RESRC_CTRL_NFC_IPWAKE_REQ_SHIFT  (8U)
/*! NFC_IPWAKE_REQ - override hw xosc + pwr + pll ipwake request */
#define APU_NFC_RESRC_CTRL_NFC_IPWAKE_REQ(x)     (((uint32_t)(((uint32_t)(x)) << APU_NFC_RESRC_CTRL_NFC_IPWAKE_REQ_SHIFT)) & APU_NFC_RESRC_CTRL_NFC_IPWAKE_REQ_MASK)

#define APU_NFC_RESRC_CTRL_NFC_IPWAKE_REQ_VAL_MASK (0x200U)
#define APU_NFC_RESRC_CTRL_NFC_IPWAKE_REQ_VAL_SHIFT (9U)
/*! NFC_IPWAKE_REQ_VAL - override value when apu_nfc_resrc_ctrl[8] is set */
#define APU_NFC_RESRC_CTRL_NFC_IPWAKE_REQ_VAL(x) (((uint32_t)(((uint32_t)(x)) << APU_NFC_RESRC_CTRL_NFC_IPWAKE_REQ_VAL_SHIFT)) & APU_NFC_RESRC_CTRL_NFC_IPWAKE_REQ_VAL_MASK)

#define APU_NFC_RESRC_CTRL_NFC_ALLWAKE_REQ_MASK  (0x400U)
#define APU_NFC_RESRC_CTRL_NFC_ALLWAKE_REQ_SHIFT (10U)
/*! NFC_ALLWAKE_REQ - firmware override hw xosc + pwr + pll allwake request */
#define APU_NFC_RESRC_CTRL_NFC_ALLWAKE_REQ(x)    (((uint32_t)(((uint32_t)(x)) << APU_NFC_RESRC_CTRL_NFC_ALLWAKE_REQ_SHIFT)) & APU_NFC_RESRC_CTRL_NFC_ALLWAKE_REQ_MASK)

#define APU_NFC_RESRC_CTRL_NFC_ALLWAKE_REQ_VAL_MASK (0x800U)
#define APU_NFC_RESRC_CTRL_NFC_ALLWAKE_REQ_VAL_SHIFT (11U)
/*! NFC_ALLWAKE_REQ_VAL - firmware override value when apu_nfc_resrc_ctrl[10] is set */
#define APU_NFC_RESRC_CTRL_NFC_ALLWAKE_REQ_VAL(x) (((uint32_t)(((uint32_t)(x)) << APU_NFC_RESRC_CTRL_NFC_ALLWAKE_REQ_VAL_SHIFT)) & APU_NFC_RESRC_CTRL_NFC_ALLWAKE_REQ_VAL_MASK)
/*! @} */

/*! @name NFC_DVFS_CTRL - NFC DVFS Control */
/*! @{ */

#define APU_NFC_DVFS_CTRL_NFC_VOL_VAL_MASK       (0x7FU)
#define APU_NFC_DVFS_CTRL_NFC_VOL_VAL_SHIFT      (0U)
/*! NFC_VOL_VAL - NFC Vol Value */
#define APU_NFC_DVFS_CTRL_NFC_VOL_VAL(x)         (((uint32_t)(((uint32_t)(x)) << APU_NFC_DVFS_CTRL_NFC_VOL_VAL_SHIFT)) & APU_NFC_DVFS_CTRL_NFC_VOL_VAL_MASK)
/*! @} */

/*! @name FP4_CTRL - FP4(15.4) Control */
/*! @{ */

#define APU_FP4_CTRL_FP4_SLP_RDY_MASK            (0x1U)
#define APU_FP4_CTRL_FP4_SLP_RDY_SHIFT           (0U)
/*! FP4_SLP_RDY - FP4 Sleep Ready */
#define APU_FP4_CTRL_FP4_SLP_RDY(x)              (((uint32_t)(((uint32_t)(x)) << APU_FP4_CTRL_FP4_SLP_RDY_SHIFT)) & APU_FP4_CTRL_FP4_SLP_RDY_MASK)

#define APU_FP4_CTRL_FP4_SLP_RDYMASK_MASK        (0x2U)
#define APU_FP4_CTRL_FP4_SLP_RDYMASK_SHIFT       (1U)
/*! FP4_SLP_RDYMASK - FP4 Sleep Ready Mask */
#define APU_FP4_CTRL_FP4_SLP_RDYMASK(x)          (((uint32_t)(((uint32_t)(x)) << APU_FP4_CTRL_FP4_SLP_RDYMASK_SHIFT)) & APU_FP4_CTRL_FP4_SLP_RDYMASK_MASK)

#define APU_FP4_CTRL_FP4_SLP_RDY_FW_MASK         (0x4U)
#define APU_FP4_CTRL_FP4_SLP_RDY_FW_SHIFT        (2U)
/*! FP4_SLP_RDY_FW - Bluetooth Sleep Ready FW */
#define APU_FP4_CTRL_FP4_SLP_RDY_FW(x)           (((uint32_t)(((uint32_t)(x)) << APU_FP4_CTRL_FP4_SLP_RDY_FW_SHIFT)) & APU_FP4_CTRL_FP4_SLP_RDY_FW_MASK)

#define APU_FP4_CTRL_USE_FP4_INTR_SLP_MASK       (0x80U)
#define APU_FP4_CTRL_USE_FP4_INTR_SLP_SHIFT      (7U)
/*! USE_FP4_INTR_SLP - Use 15.4 interrupt Sleep */
#define APU_FP4_CTRL_USE_FP4_INTR_SLP(x)         (((uint32_t)(((uint32_t)(x)) << APU_FP4_CTRL_USE_FP4_INTR_SLP_SHIFT)) & APU_FP4_CTRL_USE_FP4_INTR_SLP_MASK)

#define APU_FP4_CTRL_FP4_CLK_SYNC_MODE_SEL1_MASK (0x4000000U)
#define APU_FP4_CTRL_FP4_CLK_SYNC_MODE_SEL1_SHIFT (26U)
/*! FP4_CLK_SYNC_MODE_SEL1 - FP4 Clock Sync Mode Select 1 */
#define APU_FP4_CTRL_FP4_CLK_SYNC_MODE_SEL1(x)   (((uint32_t)(((uint32_t)(x)) << APU_FP4_CTRL_FP4_CLK_SYNC_MODE_SEL1_SHIFT)) & APU_FP4_CTRL_FP4_CLK_SYNC_MODE_SEL1_MASK)

#define APU_FP4_CTRL_USE_GLITCH_FREE_FP4_CLK_REQ_MASK (0x8000000U)
#define APU_FP4_CTRL_USE_GLITCH_FREE_FP4_CLK_REQ_SHIFT (27U)
/*! USE_GLITCH_FREE_FP4_CLK_REQ - Use Glitch-Free FP4 Clock Request */
#define APU_FP4_CTRL_USE_GLITCH_FREE_FP4_CLK_REQ(x) (((uint32_t)(((uint32_t)(x)) << APU_FP4_CTRL_USE_GLITCH_FREE_FP4_CLK_REQ_SHIFT)) & APU_FP4_CTRL_USE_GLITCH_FREE_FP4_CLK_REQ_MASK)

#define APU_FP4_CTRL_FRF_CLK_SYNC_MODE_SEL_MASK  (0x10000000U)
#define APU_FP4_CTRL_FRF_CLK_SYNC_MODE_SEL_SHIFT (28U)
/*! FRF_CLK_SYNC_MODE_SEL - FRF Clock Sync Mode Select */
#define APU_FP4_CTRL_FRF_CLK_SYNC_MODE_SEL(x)    (((uint32_t)(((uint32_t)(x)) << APU_FP4_CTRL_FRF_CLK_SYNC_MODE_SEL_SHIFT)) & APU_FP4_CTRL_FRF_CLK_SYNC_MODE_SEL_MASK)

#define APU_FP4_CTRL_FP4_CLK_SYNC_MODE_SEL0_MASK (0x20000000U)
#define APU_FP4_CTRL_FP4_CLK_SYNC_MODE_SEL0_SHIFT (29U)
/*! FP4_CLK_SYNC_MODE_SEL0 - FP4 Clock Sync Mode Select 0 */
#define APU_FP4_CTRL_FP4_CLK_SYNC_MODE_SEL0(x)   (((uint32_t)(((uint32_t)(x)) << APU_FP4_CTRL_FP4_CLK_SYNC_MODE_SEL0_SHIFT)) & APU_FP4_CTRL_FP4_CLK_SYNC_MODE_SEL0_MASK)

#define APU_FP4_CTRL_FRF_PLL_SYNC_MODE_SEL_MASK  (0x40000000U)
#define APU_FP4_CTRL_FRF_PLL_SYNC_MODE_SEL_SHIFT (30U)
/*! FRF_PLL_SYNC_MODE_SEL - FRF PLL Sync Mode Select */
#define APU_FP4_CTRL_FRF_PLL_SYNC_MODE_SEL(x)    (((uint32_t)(((uint32_t)(x)) << APU_FP4_CTRL_FRF_PLL_SYNC_MODE_SEL_SHIFT)) & APU_FP4_CTRL_FRF_PLL_SYNC_MODE_SEL_MASK)

#define APU_FP4_CTRL_FP4_HOST_SLP_RDY_MASK       (0x80000000U)
#define APU_FP4_CTRL_FP4_HOST_SLP_RDY_SHIFT      (31U)
/*! FP4_HOST_SLP_RDY - FP4 Host Sleep Ready */
#define APU_FP4_CTRL_FP4_HOST_SLP_RDY(x)         (((uint32_t)(((uint32_t)(x)) << APU_FP4_CTRL_FP4_HOST_SLP_RDY_SHIFT)) & APU_FP4_CTRL_FP4_HOST_SLP_RDY_MASK)
/*! @} */

/*! @name FP4_WKUP_MASK - FP4 Wakeup Mask */
/*! @{ */

#define APU_FP4_WKUP_MASK_FP4_CLK_REQ_MASK_MASK  (0x1U)
#define APU_FP4_WKUP_MASK_FP4_CLK_REQ_MASK_SHIFT (0U)
/*! FP4_CLK_REQ_MASK - FP4 Clock Request Mask */
#define APU_FP4_WKUP_MASK_FP4_CLK_REQ_MASK(x)    (((uint32_t)(((uint32_t)(x)) << APU_FP4_WKUP_MASK_FP4_CLK_REQ_MASK_SHIFT)) & APU_FP4_WKUP_MASK_FP4_CLK_REQ_MASK_MASK)

#define APU_FP4_WKUP_MASK_FP4_INTERRUPT_MASK_MASK (0x2U)
#define APU_FP4_WKUP_MASK_FP4_INTERRUPT_MASK_SHIFT (1U)
/*! FP4_INTERRUPT_MASK - FP4 Interrupt Mask */
#define APU_FP4_WKUP_MASK_FP4_INTERRUPT_MASK(x)  (((uint32_t)(((uint32_t)(x)) << APU_FP4_WKUP_MASK_FP4_INTERRUPT_MASK_SHIFT)) & APU_FP4_WKUP_MASK_FP4_INTERRUPT_MASK_MASK)

#define APU_FP4_WKUP_MASK_FRF_PLL_REQ_MASK_MASK  (0x4U)
#define APU_FP4_WKUP_MASK_FRF_PLL_REQ_MASK_SHIFT (2U)
/*! FRF_PLL_REQ_MASK - FRF PLL Request Mask */
#define APU_FP4_WKUP_MASK_FRF_PLL_REQ_MASK(x)    (((uint32_t)(((uint32_t)(x)) << APU_FP4_WKUP_MASK_FRF_PLL_REQ_MASK_SHIFT)) & APU_FP4_WKUP_MASK_FRF_PLL_REQ_MASK_MASK)

#define APU_FP4_WKUP_MASK_FP4_PLL_REQ_MASK_MASK  (0x8U)
#define APU_FP4_WKUP_MASK_FP4_PLL_REQ_MASK_SHIFT (3U)
/*! FP4_PLL_REQ_MASK - 15.4 PLL Request Mask */
#define APU_FP4_WKUP_MASK_FP4_PLL_REQ_MASK(x)    (((uint32_t)(((uint32_t)(x)) << APU_FP4_WKUP_MASK_FP4_PLL_REQ_MASK_SHIFT)) & APU_FP4_WKUP_MASK_FP4_PLL_REQ_MASK_MASK)

#define APU_FP4_WKUP_MASK_FP4_HOST_MAP_MASK      (0xFFFF0000U)
#define APU_FP4_WKUP_MASK_FP4_HOST_MAP_SHIFT     (16U)
/*! FP4_HOST_MAP - 15.4 Host Map */
#define APU_FP4_WKUP_MASK_FP4_HOST_MAP(x)        (((uint32_t)(((uint32_t)(x)) << APU_FP4_WKUP_MASK_FP4_HOST_MAP_SHIFT)) & APU_FP4_WKUP_MASK_FP4_HOST_MAP_MASK)
/*! @} */

/*! @name FP4_STATUS - FP4 Status */
/*! @{ */

#define APU_FP4_STATUS_APU_FP4_CLK_EN_MASK       (0x1U)
#define APU_FP4_STATUS_APU_FP4_CLK_EN_SHIFT      (0U)
/*! APU_FP4_CLK_EN - APU FP4 Clock Enable */
#define APU_FP4_STATUS_APU_FP4_CLK_EN(x)         (((uint32_t)(((uint32_t)(x)) << APU_FP4_STATUS_APU_FP4_CLK_EN_SHIFT)) & APU_FP4_STATUS_APU_FP4_CLK_EN_MASK)

#define APU_FP4_STATUS_APU_FRF_CLK_EN_MASK       (0x2U)
#define APU_FP4_STATUS_APU_FRF_CLK_EN_SHIFT      (1U)
/*! APU_FRF_CLK_EN - APU FRF Clock Enable */
#define APU_FP4_STATUS_APU_FRF_CLK_EN(x)         (((uint32_t)(((uint32_t)(x)) << APU_FP4_STATUS_APU_FRF_CLK_EN_SHIFT)) & APU_FP4_STATUS_APU_FRF_CLK_EN_MASK)

#define APU_FP4_STATUS_FP4_ACTIVE_SLPCK_MASK     (0x4U)
#define APU_FP4_STATUS_FP4_ACTIVE_SLPCK_SHIFT    (2U)
/*! FP4_ACTIVE_SLPCK - FP4 Active Sleep Clock */
#define APU_FP4_STATUS_FP4_ACTIVE_SLPCK(x)       (((uint32_t)(((uint32_t)(x)) << APU_FP4_STATUS_FP4_ACTIVE_SLPCK_SHIFT)) & APU_FP4_STATUS_FP4_ACTIVE_SLPCK_MASK)

#define APU_FP4_STATUS_BT_HOST_WKUP_MASK         (0x8U)
#define APU_FP4_STATUS_BT_HOST_WKUP_SHIFT        (3U)
/*! BT_HOST_WKUP - Bluetooth Host Wakeup */
#define APU_FP4_STATUS_BT_HOST_WKUP(x)           (((uint32_t)(((uint32_t)(x)) << APU_FP4_STATUS_BT_HOST_WKUP_SHIFT)) & APU_FP4_STATUS_BT_HOST_WKUP_MASK)

#define APU_FP4_STATUS_FP4_INTERRUPT_MASK        (0x10U)
#define APU_FP4_STATUS_FP4_INTERRUPT_SHIFT       (4U)
/*! FP4_INTERRUPT - FP4 Interrupt */
#define APU_FP4_STATUS_FP4_INTERRUPT(x)          (((uint32_t)(((uint32_t)(x)) << APU_FP4_STATUS_FP4_INTERRUPT_SHIFT)) & APU_FP4_STATUS_FP4_INTERRUPT_MASK)

#define APU_FP4_STATUS_FP4_PLL_REQ_MASK          (0x20U)
#define APU_FP4_STATUS_FP4_PLL_REQ_SHIFT         (5U)
/*! FP4_PLL_REQ - FP4 PLL Request */
#define APU_FP4_STATUS_FP4_PLL_REQ(x)            (((uint32_t)(((uint32_t)(x)) << APU_FP4_STATUS_FP4_PLL_REQ_SHIFT)) & APU_FP4_STATUS_FP4_PLL_REQ_MASK)

#define APU_FP4_STATUS_FP4_CLK_REQ_MASK          (0x40U)
#define APU_FP4_STATUS_FP4_CLK_REQ_SHIFT         (6U)
/*! FP4_CLK_REQ - FP4 Clock Request */
#define APU_FP4_STATUS_FP4_CLK_REQ(x)            (((uint32_t)(((uint32_t)(x)) << APU_FP4_STATUS_FP4_CLK_REQ_SHIFT)) & APU_FP4_STATUS_FP4_CLK_REQ_MASK)

#define APU_FP4_STATUS_FRF_PLL_REQ_MASK          (0x80U)
#define APU_FP4_STATUS_FRF_PLL_REQ_SHIFT         (7U)
/*! FRF_PLL_REQ - FRF PLL Request */
#define APU_FP4_STATUS_FRF_PLL_REQ(x)            (((uint32_t)(((uint32_t)(x)) << APU_FP4_STATUS_FRF_PLL_REQ_SHIFT)) & APU_FP4_STATUS_FRF_PLL_REQ_MASK)

#define APU_FP4_STATUS_HOST_WKUP_IN_MASK         (0xFFFF0000U)
#define APU_FP4_STATUS_HOST_WKUP_IN_SHIFT        (16U)
/*! HOST_WKUP_IN - Host Wakeup In */
#define APU_FP4_STATUS_HOST_WKUP_IN(x)           (((uint32_t)(((uint32_t)(x)) << APU_FP4_STATUS_HOST_WKUP_IN_SHIFT)) & APU_FP4_STATUS_HOST_WKUP_IN_MASK)
/*! @} */

/*! @name FP4_CKEN_CTRL - FP4 Clock Enable Control */
/*! @{ */

#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_PWR_MASK (0x1U)
#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_PWR_SHIFT (0U)
/*! FP4_CLK_EN_VAL_PWR - control value for fp4_clk_en when power ready */
#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_PWR(x)  (((uint32_t)(((uint32_t)(x)) << APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_PWR_SHIFT)) & APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_PWR_MASK)

#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_PWR_MASK (0x2U)
#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_PWR_SHIFT (1U)
/*! FP4_CLK_EN_SEL_PWR - selection for fp4_clk_en when power ready */
#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_PWR(x)  (((uint32_t)(((uint32_t)(x)) << APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_PWR_SHIFT)) & APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_PWR_MASK)

#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_XOSC_MASK (0x4U)
#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_XOSC_SHIFT (2U)
/*! FP4_CLK_EN_VAL_XOSC - control value for fp4_clk_en when XOSC ready */
#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_XOSC(x) (((uint32_t)(((uint32_t)(x)) << APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_XOSC_SHIFT)) & APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_XOSC_MASK)

#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_XOSC_MASK (0x8U)
#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_XOSC_SHIFT (3U)
/*! FP4_CLK_EN_SEL_XOSC - selection for fp4_clk_en when XOSC ready */
#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_XOSC(x) (((uint32_t)(((uint32_t)(x)) << APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_XOSC_SHIFT)) & APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_XOSC_MASK)

#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_MASK    (0x10U)
#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_SHIFT   (4U)
/*! FP4_CLK_EN_VAL - control value for fp4_clk_en when PLL ready */
#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL(x)      (((uint32_t)(((uint32_t)(x)) << APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_SHIFT)) & APU_FP4_CKEN_CTRL_FP4_CLK_EN_VAL_MASK)

#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_MASK    (0x20U)
#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_SHIFT   (5U)
/*! FP4_CLK_EN_SEL - selection for fp4_clk_en when PLL ready */
#define APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL(x)      (((uint32_t)(((uint32_t)(x)) << APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_SHIFT)) & APU_FP4_CKEN_CTRL_FP4_CLK_EN_SEL_MASK)
/*! @} */

/*! @name FP4_RESRC_CTRL - FP4 RESRC Control */
/*! @{ */

#define APU_FP4_RESRC_CTRL_FW_PWR_REQ_MASK       (0x1U)
#define APU_FP4_RESRC_CTRL_FW_PWR_REQ_SHIFT      (0U)
/*! FW_PWR_REQ - override hw power request */
#define APU_FP4_RESRC_CTRL_FW_PWR_REQ(x)         (((uint32_t)(((uint32_t)(x)) << APU_FP4_RESRC_CTRL_FW_PWR_REQ_SHIFT)) & APU_FP4_RESRC_CTRL_FW_PWR_REQ_MASK)

#define APU_FP4_RESRC_CTRL_FW_PWR_REQ_VAL_MASK   (0x2U)
#define APU_FP4_RESRC_CTRL_FW_PWR_REQ_VAL_SHIFT  (1U)
/*! FW_PWR_REQ_VAL - override value when apu_fp4_resrc_ctrl[0] is set */
#define APU_FP4_RESRC_CTRL_FW_PWR_REQ_VAL(x)     (((uint32_t)(((uint32_t)(x)) << APU_FP4_RESRC_CTRL_FW_PWR_REQ_VAL_SHIFT)) & APU_FP4_RESRC_CTRL_FW_PWR_REQ_VAL_MASK)

#define APU_FP4_RESRC_CTRL_FW_XOSC_REQ_MASK      (0x4U)
#define APU_FP4_RESRC_CTRL_FW_XOSC_REQ_SHIFT     (2U)
/*! FW_XOSC_REQ - override hw xosc request */
#define APU_FP4_RESRC_CTRL_FW_XOSC_REQ(x)        (((uint32_t)(((uint32_t)(x)) << APU_FP4_RESRC_CTRL_FW_XOSC_REQ_SHIFT)) & APU_FP4_RESRC_CTRL_FW_XOSC_REQ_MASK)

#define APU_FP4_RESRC_CTRL_FW_XOSC_REQ_VAL_MASK  (0x8U)
#define APU_FP4_RESRC_CTRL_FW_XOSC_REQ_VAL_SHIFT (3U)
/*! FW_XOSC_REQ_VAL - override value when apu_fp4_resrc_ctrl[2] is set */
#define APU_FP4_RESRC_CTRL_FW_XOSC_REQ_VAL(x)    (((uint32_t)(((uint32_t)(x)) << APU_FP4_RESRC_CTRL_FW_XOSC_REQ_VAL_SHIFT)) & APU_FP4_RESRC_CTRL_FW_XOSC_REQ_VAL_MASK)

#define APU_FP4_RESRC_CTRL_FW_XP_REQ_MASK        (0x10U)
#define APU_FP4_RESRC_CTRL_FW_XP_REQ_SHIFT       (4U)
/*! FW_XP_REQ - override hw xosc + pwr request */
#define APU_FP4_RESRC_CTRL_FW_XP_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_FP4_RESRC_CTRL_FW_XP_REQ_SHIFT)) & APU_FP4_RESRC_CTRL_FW_XP_REQ_MASK)

#define APU_FP4_RESRC_CTRL_FW_XP_REQ_VAL_MASK    (0x20U)
#define APU_FP4_RESRC_CTRL_FW_XP_REQ_VAL_SHIFT   (5U)
/*! FW_XP_REQ_VAL - override value when apu_fp4_resrc_ctrl[4] is set */
#define APU_FP4_RESRC_CTRL_FW_XP_REQ_VAL(x)      (((uint32_t)(((uint32_t)(x)) << APU_FP4_RESRC_CTRL_FW_XP_REQ_VAL_SHIFT)) & APU_FP4_RESRC_CTRL_FW_XP_REQ_VAL_MASK)

#define APU_FP4_RESRC_CTRL_FW_SB_REQ_MASK        (0x40U)
#define APU_FP4_RESRC_CTRL_FW_SB_REQ_SHIFT       (6U)
/*! FW_SB_REQ - override hw xosc + pwr + pll sb request */
#define APU_FP4_RESRC_CTRL_FW_SB_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_FP4_RESRC_CTRL_FW_SB_REQ_SHIFT)) & APU_FP4_RESRC_CTRL_FW_SB_REQ_MASK)

#define APU_FP4_RESRC_CTRL_FW_SB_REQ_VAL_MASK    (0x80U)
#define APU_FP4_RESRC_CTRL_FW_SB_REQ_VAL_SHIFT   (7U)
/*! FW_SB_REQ_VAL - override value when apu_fp4_resrc_ctrl[6] is set */
#define APU_FP4_RESRC_CTRL_FW_SB_REQ_VAL(x)      (((uint32_t)(((uint32_t)(x)) << APU_FP4_RESRC_CTRL_FW_SB_REQ_VAL_SHIFT)) & APU_FP4_RESRC_CTRL_FW_SB_REQ_VAL_MASK)

#define APU_FP4_RESRC_CTRL_FW_IPWAKE_REQ_MASK    (0x100U)
#define APU_FP4_RESRC_CTRL_FW_IPWAKE_REQ_SHIFT   (8U)
/*! FW_IPWAKE_REQ - override hw xosc + pwr + pll ipwake request */
#define APU_FP4_RESRC_CTRL_FW_IPWAKE_REQ(x)      (((uint32_t)(((uint32_t)(x)) << APU_FP4_RESRC_CTRL_FW_IPWAKE_REQ_SHIFT)) & APU_FP4_RESRC_CTRL_FW_IPWAKE_REQ_MASK)

#define APU_FP4_RESRC_CTRL_FW_IPWAKE_REQ_VAL_MASK (0x200U)
#define APU_FP4_RESRC_CTRL_FW_IPWAKE_REQ_VAL_SHIFT (9U)
/*! FW_IPWAKE_REQ_VAL - override value when apu_fp4_resrc_ctrl[8] is set */
#define APU_FP4_RESRC_CTRL_FW_IPWAKE_REQ_VAL(x)  (((uint32_t)(((uint32_t)(x)) << APU_FP4_RESRC_CTRL_FW_IPWAKE_REQ_VAL_SHIFT)) & APU_FP4_RESRC_CTRL_FW_IPWAKE_REQ_VAL_MASK)

#define APU_FP4_RESRC_CTRL_FW_ALLWAKE_REQ_MASK   (0x400U)
#define APU_FP4_RESRC_CTRL_FW_ALLWAKE_REQ_SHIFT  (10U)
/*! FW_ALLWAKE_REQ - firmware override hw xosc + pwr + pll allwake request */
#define APU_FP4_RESRC_CTRL_FW_ALLWAKE_REQ(x)     (((uint32_t)(((uint32_t)(x)) << APU_FP4_RESRC_CTRL_FW_ALLWAKE_REQ_SHIFT)) & APU_FP4_RESRC_CTRL_FW_ALLWAKE_REQ_MASK)

#define APU_FP4_RESRC_CTRL_FW_ALLWAKE_REQ_VAL_MASK (0x800U)
#define APU_FP4_RESRC_CTRL_FW_ALLWAKE_REQ_VAL_SHIFT (11U)
/*! FW_ALLWAKE_REQ_VAL - firmware override value when apu_fp4_resrc_ctrl[10] is set */
#define APU_FP4_RESRC_CTRL_FW_ALLWAKE_REQ_VAL(x) (((uint32_t)(((uint32_t)(x)) << APU_FP4_RESRC_CTRL_FW_ALLWAKE_REQ_VAL_SHIFT)) & APU_FP4_RESRC_CTRL_FW_ALLWAKE_REQ_VAL_MASK)
/*! @} */

/*! @name FP4_DVFS_CTRL - FP4 DVFS Control */
/*! @{ */

#define APU_FP4_DVFS_CTRL_FP4_VOL_VAL_MASK       (0x7FU)
#define APU_FP4_DVFS_CTRL_FP4_VOL_VAL_SHIFT      (0U)
/*! FP4_VOL_VAL - FP4 Vol Value */
#define APU_FP4_DVFS_CTRL_FP4_VOL_VAL(x)         (((uint32_t)(((uint32_t)(x)) << APU_FP4_DVFS_CTRL_FP4_VOL_VAL_SHIFT)) & APU_FP4_DVFS_CTRL_FP4_VOL_VAL_MASK)
/*! @} */

/*! @name CPU2_FP4_HOST_WKUP_MASK - CPU2 15.4 Host Wakeup Mask */
/*! @{ */

#define APU_CPU2_FP4_HOST_WKUP_MASK_HOST_WKUP_MASK_MASK (0xFFFFU)
#define APU_CPU2_FP4_HOST_WKUP_MASK_HOST_WKUP_MASK_SHIFT (0U)
/*! HOST_WKUP_MASK - Host Wakeup Mask */
#define APU_CPU2_FP4_HOST_WKUP_MASK_HOST_WKUP_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_FP4_HOST_WKUP_MASK_HOST_WKUP_MASK_SHIFT)) & APU_CPU2_FP4_HOST_WKUP_MASK_HOST_WKUP_MASK_MASK)
/*! @} */

/*! @name CPU2_FP4_HOST_WKUP_POL - CPU2 15.4 Host Wakeup Polarity */
/*! @{ */

#define APU_CPU2_FP4_HOST_WKUP_POL_HOST_WKUP_POL_MASK (0xFFFFU)
#define APU_CPU2_FP4_HOST_WKUP_POL_HOST_WKUP_POL_SHIFT (0U)
/*! HOST_WKUP_POL - Host Wakeup Polarity */
#define APU_CPU2_FP4_HOST_WKUP_POL_HOST_WKUP_POL(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_FP4_HOST_WKUP_POL_HOST_WKUP_POL_SHIFT)) & APU_CPU2_FP4_HOST_WKUP_POL_HOST_WKUP_POL_MASK)
/*! @} */

/*! @name CPU2_FP4_HOST_WKUP_CTRL - CPU2 15.4 Host Wakeup Control */
/*! @{ */

#define APU_CPU2_FP4_HOST_WKUP_CTRL_HOST_WKUP_CTRL_MASK (0xFFFFU)
#define APU_CPU2_FP4_HOST_WKUP_CTRL_HOST_WKUP_CTRL_SHIFT (0U)
/*! HOST_WKUP_CTRL - Host Wakeup Control */
#define APU_CPU2_FP4_HOST_WKUP_CTRL_HOST_WKUP_CTRL(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_FP4_HOST_WKUP_CTRL_HOST_WKUP_CTRL_SHIFT)) & APU_CPU2_FP4_HOST_WKUP_CTRL_HOST_WKUP_CTRL_MASK)

#define APU_CPU2_FP4_HOST_WKUP_CTRL_HOST_INTR_MASK_MASK (0xFFFF0000U)
#define APU_CPU2_FP4_HOST_WKUP_CTRL_HOST_INTR_MASK_SHIFT (16U)
/*! HOST_INTR_MASK - Host Interrupt Mask */
#define APU_CPU2_FP4_HOST_WKUP_CTRL_HOST_INTR_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_FP4_HOST_WKUP_CTRL_HOST_INTR_MASK_SHIFT)) & APU_CPU2_FP4_HOST_WKUP_CTRL_HOST_INTR_MASK_MASK)
/*! @} */

/*! @name HW_IP_ACTIVE_INDEX_CTRL - HW IP active index Control */
/*! @{ */

#define APU_HW_IP_ACTIVE_INDEX_CTRL_MASTERX_ACTIVE_INDEX_MASK (0xFFFFFFFFU)
#define APU_HW_IP_ACTIVE_INDEX_CTRL_MASTERX_ACTIVE_INDEX_SHIFT (0U)
/*! MASTERX_ACTIVE_INDEX - master0-7 Active Index[3:0] */
#define APU_HW_IP_ACTIVE_INDEX_CTRL_MASTERX_ACTIVE_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_HW_IP_ACTIVE_INDEX_CTRL_MASTERX_ACTIVE_INDEX_SHIFT)) & APU_HW_IP_ACTIVE_INDEX_CTRL_MASTERX_ACTIVE_INDEX_MASK)
/*! @} */

/*! @name HW_IP_INACTIVE_INDEX_CTRL - HW IP inactive Control */
/*! @{ */

#define APU_HW_IP_INACTIVE_INDEX_CTRL_MASTERX_INACTIVE_INDEX_MASK (0xFFFFFFFFU)
#define APU_HW_IP_INACTIVE_INDEX_CTRL_MASTERX_INACTIVE_INDEX_SHIFT (0U)
/*! MASTERX_INACTIVE_INDEX - master0-7 inactive Index[3:0] */
#define APU_HW_IP_INACTIVE_INDEX_CTRL_MASTERX_INACTIVE_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_HW_IP_INACTIVE_INDEX_CTRL_MASTERX_INACTIVE_INDEX_SHIFT)) & APU_HW_IP_INACTIVE_INDEX_CTRL_MASTERX_INACTIVE_INDEX_MASK)
/*! @} */

/*! @name HW_IP_DYNAMIC_CLK_SWITCH_CTRL - HW IP dynamic clock switching contrl */
/*! @{ */

#define APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_APU_IDLE_BYPASS_EN_MASK (0xFFU)
#define APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_APU_IDLE_BYPASS_EN_SHIFT (0U)
/*! MASTERX_APU_IDLE_BYPASS_EN - 1-FW bypasses hw_ip_idle; 0 - use hw_ip_idle */
#define APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_APU_IDLE_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_APU_IDLE_BYPASS_EN_SHIFT)) & APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_APU_IDLE_BYPASS_EN_MASK)

#define APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_APU_IDLE_BYPASS_VAL_MASK (0xFF00U)
#define APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_APU_IDLE_BYPASS_VAL_SHIFT (8U)
/*! MASTERX_APU_IDLE_BYPASS_VAL - idle bypass val */
#define APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_APU_IDLE_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_APU_IDLE_BYPASS_VAL_SHIFT)) & APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_APU_IDLE_BYPASS_VAL_MASK)

#define APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_ACTIVE_INDEX_BYPASS_EN_MASK (0xFF0000U)
#define APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_ACTIVE_INDEX_BYPASS_EN_SHIFT (16U)
/*! MASTERX_ACTIVE_INDEX_BYPASS_EN - 1- use masterx_active-index from register hw_ip_active_index_ctrl; 0-use active index from HW latched version */
#define APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_ACTIVE_INDEX_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_ACTIVE_INDEX_BYPASS_EN_SHIFT)) & APU_HW_IP_DYNAMIC_CLK_SWITCH_CTRL_MASTERX_ACTIVE_INDEX_BYPASS_EN_MASK)
/*! @} */

/*! @name IHB_CTRL - IHB Control */
/*! @{ */

#define APU_IHB_CTRL_IHB_VOL_REQ_AS_P_REQ_MASK   (0x1U)
#define APU_IHB_CTRL_IHB_VOL_REQ_AS_P_REQ_SHIFT  (0U)
/*! IHB_VOL_REQ_AS_P_REQ - IHB Vol Request as P Request */
#define APU_IHB_CTRL_IHB_VOL_REQ_AS_P_REQ(x)     (((uint32_t)(((uint32_t)(x)) << APU_IHB_CTRL_IHB_VOL_REQ_AS_P_REQ_SHIFT)) & APU_IHB_CTRL_IHB_VOL_REQ_AS_P_REQ_MASK)

#define APU_IHB_CTRL_IHB_VOL_REQ_AS_XP_REQ_MASK  (0x2U)
#define APU_IHB_CTRL_IHB_VOL_REQ_AS_XP_REQ_SHIFT (1U)
/*! IHB_VOL_REQ_AS_XP_REQ - IHB Vol Request as XP Request */
#define APU_IHB_CTRL_IHB_VOL_REQ_AS_XP_REQ(x)    (((uint32_t)(((uint32_t)(x)) << APU_IHB_CTRL_IHB_VOL_REQ_AS_XP_REQ_SHIFT)) & APU_IHB_CTRL_IHB_VOL_REQ_AS_XP_REQ_MASK)

#define APU_IHB_CTRL_IHB_CLK_REQ_AS_XP_REQ_MASK  (0x4U)
#define APU_IHB_CTRL_IHB_CLK_REQ_AS_XP_REQ_SHIFT (2U)
/*! IHB_CLK_REQ_AS_XP_REQ - IHB Clock Request as XP Request */
#define APU_IHB_CTRL_IHB_CLK_REQ_AS_XP_REQ(x)    (((uint32_t)(((uint32_t)(x)) << APU_IHB_CTRL_IHB_CLK_REQ_AS_XP_REQ_SHIFT)) & APU_IHB_CTRL_IHB_CLK_REQ_AS_XP_REQ_MASK)

#define APU_IHB_CTRL_IHB_CLK_REQ_AS_XPP_REQ_MASK (0x8U)
#define APU_IHB_CTRL_IHB_CLK_REQ_AS_XPP_REQ_SHIFT (3U)
/*! IHB_CLK_REQ_AS_XPP_REQ - IHB Clock Request as XPP Request */
#define APU_IHB_CTRL_IHB_CLK_REQ_AS_XPP_REQ(x)   (((uint32_t)(((uint32_t)(x)) << APU_IHB_CTRL_IHB_CLK_REQ_AS_XPP_REQ_SHIFT)) & APU_IHB_CTRL_IHB_CLK_REQ_AS_XPP_REQ_MASK)

#define APU_IHB_CTRL_IHB_VOL_VAL_MASK            (0x7F0000U)
#define APU_IHB_CTRL_IHB_VOL_VAL_SHIFT           (16U)
/*! IHB_VOL_VAL - Voltage value needed for Bluetooth function */
#define APU_IHB_CTRL_IHB_VOL_VAL(x)              (((uint32_t)(((uint32_t)(x)) << APU_IHB_CTRL_IHB_VOL_VAL_SHIFT)) & APU_IHB_CTRL_IHB_VOL_VAL_MASK)
/*! @} */

/*! @name IHB_WKUP_MASK - IHB Wakeup Mask */
/*! @{ */

#define APU_IHB_WKUP_MASK_IHB_HI_VOL_REQ_MASK_MASK (0x1U)
#define APU_IHB_WKUP_MASK_IHB_HI_VOL_REQ_MASK_SHIFT (0U)
/*! IHB_HI_VOL_REQ_MASK - IHB High Vol Request Mask */
#define APU_IHB_WKUP_MASK_IHB_HI_VOL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_IHB_WKUP_MASK_IHB_HI_VOL_REQ_MASK_SHIFT)) & APU_IHB_WKUP_MASK_IHB_HI_VOL_REQ_MASK_MASK)

#define APU_IHB_WKUP_MASK_IHB_LO_VOL_REQ_MASK_MASK (0x2U)
#define APU_IHB_WKUP_MASK_IHB_LO_VOL_REQ_MASK_SHIFT (1U)
/*! IHB_LO_VOL_REQ_MASK - IHB Low Vol Request Mask */
#define APU_IHB_WKUP_MASK_IHB_LO_VOL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_IHB_WKUP_MASK_IHB_LO_VOL_REQ_MASK_SHIFT)) & APU_IHB_WKUP_MASK_IHB_LO_VOL_REQ_MASK_MASK)

#define APU_IHB_WKUP_MASK_IHB_CLK_REQ_MASK_MASK  (0x4U)
#define APU_IHB_WKUP_MASK_IHB_CLK_REQ_MASK_SHIFT (2U)
/*! IHB_CLK_REQ_MASK - IHB Clock Request Mask */
#define APU_IHB_WKUP_MASK_IHB_CLK_REQ_MASK(x)    (((uint32_t)(((uint32_t)(x)) << APU_IHB_WKUP_MASK_IHB_CLK_REQ_MASK_SHIFT)) & APU_IHB_WKUP_MASK_IHB_CLK_REQ_MASK_MASK)

#define APU_IHB_WKUP_MASK_IHB_WL_WKUP_REQ_MASK_MASK (0x8U)
#define APU_IHB_WKUP_MASK_IHB_WL_WKUP_REQ_MASK_SHIFT (3U)
/*! IHB_WL_WKUP_REQ_MASK - IHB WLAN Wakeup Request Mask */
#define APU_IHB_WKUP_MASK_IHB_WL_WKUP_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_IHB_WKUP_MASK_IHB_WL_WKUP_REQ_MASK_SHIFT)) & APU_IHB_WKUP_MASK_IHB_WL_WKUP_REQ_MASK_MASK)

#define APU_IHB_WKUP_MASK_CPU1_IHB_PMU_WKUP_MASK_MASK (0x10U)
#define APU_IHB_WKUP_MASK_CPU1_IHB_PMU_WKUP_MASK_SHIFT (4U)
/*! CPU1_IHB_PMU_WKUP_MASK - CPU1 IHB PMU Wakeup Mask */
#define APU_IHB_WKUP_MASK_CPU1_IHB_PMU_WKUP_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_IHB_WKUP_MASK_CPU1_IHB_PMU_WKUP_MASK_SHIFT)) & APU_IHB_WKUP_MASK_CPU1_IHB_PMU_WKUP_MASK_MASK)
/*! @} */

/*! @name CPU2_IHB_WKUP_MASK - CPU2 IHB Wakeup Mask */
/*! @{ */

#define APU_CPU2_IHB_WKUP_MASK_CPU2_IHB_PMU_WKUP_MASK_MASK (0x1U)
#define APU_CPU2_IHB_WKUP_MASK_CPU2_IHB_PMU_WKUP_MASK_SHIFT (0U)
/*! CPU2_IHB_PMU_WKUP_MASK - CPU2 IHB PMU Wakeup Mask */
#define APU_CPU2_IHB_WKUP_MASK_CPU2_IHB_PMU_WKUP_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_IHB_WKUP_MASK_CPU2_IHB_PMU_WKUP_MASK_SHIFT)) & APU_CPU2_IHB_WKUP_MASK_CPU2_IHB_PMU_WKUP_MASK_MASK)
/*! @} */

/*! @name IHB_STATUS - IHB Status */
/*! @{ */

#define APU_IHB_STATUS_IHB_STATUS_MASK           (0xFFFFFFFFU)
#define APU_IHB_STATUS_IHB_STATUS_SHIFT          (0U)
/*! IHB_STATUS - IHB Status */
#define APU_IHB_STATUS_IHB_STATUS(x)             (((uint32_t)(((uint32_t)(x)) << APU_IHB_STATUS_IHB_STATUS_SHIFT)) & APU_IHB_STATUS_IHB_STATUS_MASK)
/*! @} */

/*! @name USB_CTRL - USB Control */
/*! @{ */

#define APU_USB_CTRL_USB_PWR_DWN_MASK_MASK       (0x1U)
#define APU_USB_CTRL_USB_PWR_DWN_MASK_SHIFT      (0U)
/*! USB_PWR_DWN_MASK - USB Power Down Mask */
#define APU_USB_CTRL_USB_PWR_DWN_MASK(x)         (((uint32_t)(((uint32_t)(x)) << APU_USB_CTRL_USB_PWR_DWN_MASK_SHIFT)) & APU_USB_CTRL_USB_PWR_DWN_MASK_MASK)

#define APU_USB_CTRL_USE_CLK_SEL_ACK_AS_USB_PWR_DWN_MASK (0x10U)
#define APU_USB_CTRL_USE_CLK_SEL_ACK_AS_USB_PWR_DWN_SHIFT (4U)
/*! USE_CLK_SEL_ACK_AS_USB_PWR_DWN - Use Clock Select Ack as USB Power Down */
#define APU_USB_CTRL_USE_CLK_SEL_ACK_AS_USB_PWR_DWN(x) (((uint32_t)(((uint32_t)(x)) << APU_USB_CTRL_USE_CLK_SEL_ACK_AS_USB_PWR_DWN_SHIFT)) & APU_USB_CTRL_USE_CLK_SEL_ACK_AS_USB_PWR_DWN_MASK)

#define APU_USB_CTRL_IDLE2ISO_DLY_EN_MASK        (0x20U)
#define APU_USB_CTRL_IDLE2ISO_DLY_EN_SHIFT       (5U)
/*! IDLE2ISO_DLY_EN - USB FSM state counter enable. When set to 1, use usb_pwr_ctrl_dly and usb_pwr_ctrl_dly2. When set to 0, no delay */
#define APU_USB_CTRL_IDLE2ISO_DLY_EN(x)          (((uint32_t)(((uint32_t)(x)) << APU_USB_CTRL_IDLE2ISO_DLY_EN_SHIFT)) & APU_USB_CTRL_IDLE2ISO_DLY_EN_MASK)

#define APU_USB_CTRL_USB_USE_NOM_PWR_BYP_MASK    (0x200U)
#define APU_USB_CTRL_USB_USE_NOM_PWR_BYP_SHIFT   (9U)
/*! USB_USE_NOM_PWR_BYP - USB Use Nominal Power Bypass */
#define APU_USB_CTRL_USB_USE_NOM_PWR_BYP(x)      (((uint32_t)(((uint32_t)(x)) << APU_USB_CTRL_USB_USE_NOM_PWR_BYP_SHIFT)) & APU_USB_CTRL_USB_USE_NOM_PWR_BYP_MASK)

#define APU_USB_CTRL_FW_FORCE_USB_PWRUP_MASK     (0x1000000U)
#define APU_USB_CTRL_FW_FORCE_USB_PWRUP_SHIFT    (24U)
/*! FW_FORCE_USB_PWRUP - FW Force USB Powerup */
#define APU_USB_CTRL_FW_FORCE_USB_PWRUP(x)       (((uint32_t)(((uint32_t)(x)) << APU_USB_CTRL_FW_FORCE_USB_PWRUP_SHIFT)) & APU_USB_CTRL_FW_FORCE_USB_PWRUP_MASK)

#define APU_USB_CTRL_USB_USE_UNSYNC_VOL_LVL_MASK (0x2000000U)
#define APU_USB_CTRL_USB_USE_UNSYNC_VOL_LVL_SHIFT (25U)
/*! USB_USE_UNSYNC_VOL_LVL - USB Use Unsync Vol Level */
#define APU_USB_CTRL_USB_USE_UNSYNC_VOL_LVL(x)   (((uint32_t)(((uint32_t)(x)) << APU_USB_CTRL_USB_USE_UNSYNC_VOL_LVL_SHIFT)) & APU_USB_CTRL_USB_USE_UNSYNC_VOL_LVL_MASK)

#define APU_USB_CTRL_USB_CLK_SEL_ACK_EXT_EN_MASK (0x80000000U)
#define APU_USB_CTRL_USB_CLK_SEL_ACK_EXT_EN_SHIFT (31U)
/*! USB_CLK_SEL_ACK_EXT_EN - USB Clock Select Ack Ext Enable */
#define APU_USB_CTRL_USB_CLK_SEL_ACK_EXT_EN(x)   (((uint32_t)(((uint32_t)(x)) << APU_USB_CTRL_USB_CLK_SEL_ACK_EXT_EN_SHIFT)) & APU_USB_CTRL_USB_CLK_SEL_ACK_EXT_EN_MASK)
/*! @} */

/*! @name USB_WKUP_MASK - USB Wakeup Mask */
/*! @{ */

#define APU_USB_WKUP_MASK_USB_P_REQ_MASK_MASK    (0x1U)
#define APU_USB_WKUP_MASK_USB_P_REQ_MASK_SHIFT   (0U)
/*! USB_P_REQ_MASK - USB P Request Mask */
#define APU_USB_WKUP_MASK_USB_P_REQ_MASK(x)      (((uint32_t)(((uint32_t)(x)) << APU_USB_WKUP_MASK_USB_P_REQ_MASK_SHIFT)) & APU_USB_WKUP_MASK_USB_P_REQ_MASK_MASK)

#define APU_USB_WKUP_MASK_USB_AXI_CLK_REQ_MASK_MASK (0x2U)
#define APU_USB_WKUP_MASK_USB_AXI_CLK_REQ_MASK_SHIFT (1U)
/*! USB_AXI_CLK_REQ_MASK - USB AXI Clock Request Mask */
#define APU_USB_WKUP_MASK_USB_AXI_CLK_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_USB_WKUP_MASK_USB_AXI_CLK_REQ_MASK_SHIFT)) & APU_USB_WKUP_MASK_USB_AXI_CLK_REQ_MASK_MASK)

#define APU_USB_WKUP_MASK_USB_CLK_SEL_REQ_MASK_MASK (0x4U)
#define APU_USB_WKUP_MASK_USB_CLK_SEL_REQ_MASK_SHIFT (2U)
/*! USB_CLK_SEL_REQ_MASK - USB Clock Select Request Mask */
#define APU_USB_WKUP_MASK_USB_CLK_SEL_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_USB_WKUP_MASK_USB_CLK_SEL_REQ_MASK_SHIFT)) & APU_USB_WKUP_MASK_USB_CLK_SEL_REQ_MASK_MASK)
/*! @} */

/*! @name USB_STATUS - USB Status */
/*! @{ */

#define APU_USB_STATUS_USB_P_REQ_MASK            (0x1U)
#define APU_USB_STATUS_USB_P_REQ_SHIFT           (0U)
/*! USB_P_REQ - USB P Request */
#define APU_USB_STATUS_USB_P_REQ(x)              (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_USB_P_REQ_SHIFT)) & APU_USB_STATUS_USB_P_REQ_MASK)

#define APU_USB_STATUS_APU_USB_P_ACK_MASK        (0x2U)
#define APU_USB_STATUS_APU_USB_P_ACK_SHIFT       (1U)
/*! APU_USB_P_ACK - APU USB P Ack */
#define APU_USB_STATUS_APU_USB_P_ACK(x)          (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_APU_USB_P_ACK_SHIFT)) & APU_USB_STATUS_APU_USB_P_ACK_MASK)

#define APU_USB_STATUS_USB_CLK_SEL_REQ_MASK      (0x4U)
#define APU_USB_STATUS_USB_CLK_SEL_REQ_SHIFT     (2U)
/*! USB_CLK_SEL_REQ - USB Clock Select Request */
#define APU_USB_STATUS_USB_CLK_SEL_REQ(x)        (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_USB_CLK_SEL_REQ_SHIFT)) & APU_USB_STATUS_USB_CLK_SEL_REQ_MASK)

#define APU_USB_STATUS_APU_USB_CLK_SEL_ACK_MASK  (0x8U)
#define APU_USB_STATUS_APU_USB_CLK_SEL_ACK_SHIFT (3U)
/*! APU_USB_CLK_SEL_ACK - APU USB Clock Select Ack */
#define APU_USB_STATUS_APU_USB_CLK_SEL_ACK(x)    (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_APU_USB_CLK_SEL_ACK_SHIFT)) & APU_USB_STATUS_APU_USB_CLK_SEL_ACK_MASK)

#define APU_USB_STATUS_USB_AXI_CLK_REQ_MASK      (0x10U)
#define APU_USB_STATUS_USB_AXI_CLK_REQ_SHIFT     (4U)
/*! USB_AXI_CLK_REQ - USB AXI Clock Request */
#define APU_USB_STATUS_USB_AXI_CLK_REQ(x)        (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_USB_AXI_CLK_REQ_SHIFT)) & APU_USB_STATUS_USB_AXI_CLK_REQ_MASK)

#define APU_USB_STATUS_APU_USB_AXI_CLK_ACK_MASK  (0x20U)
#define APU_USB_STATUS_APU_USB_AXI_CLK_ACK_SHIFT (5U)
/*! APU_USB_AXI_CLK_ACK - APU USB AXI Clock Ack */
#define APU_USB_STATUS_APU_USB_AXI_CLK_ACK(x)    (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_APU_USB_AXI_CLK_ACK_SHIFT)) & APU_USB_STATUS_APU_USB_AXI_CLK_ACK_MASK)

#define APU_USB_STATUS_SOC_PWR_RDY_MASK          (0x40U)
#define APU_USB_STATUS_SOC_PWR_RDY_SHIFT         (6U)
/*! SOC_PWR_RDY - SOC Power Ready */
#define APU_USB_STATUS_SOC_PWR_RDY(x)            (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_SOC_PWR_RDY_SHIFT)) & APU_USB_STATUS_SOC_PWR_RDY_MASK)

#define APU_USB_STATUS_APU_USB_SWITCH_PD_MASK    (0x80U)
#define APU_USB_STATUS_APU_USB_SWITCH_PD_SHIFT   (7U)
/*! APU_USB_SWITCH_PD - APU USB Switch Power Down */
#define APU_USB_STATUS_APU_USB_SWITCH_PD(x)      (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_APU_USB_SWITCH_PD_SHIFT)) & APU_USB_STATUS_APU_USB_SWITCH_PD_MASK)

#define APU_USB_STATUS_USB_CLK_SEL_ACK_EXT_EN_MASK (0x100U)
#define APU_USB_STATUS_USB_CLK_SEL_ACK_EXT_EN_SHIFT (8U)
/*! USB_CLK_SEL_ACK_EXT_EN - extension enable for the usb_clk_sel_ack */
#define APU_USB_STATUS_USB_CLK_SEL_ACK_EXT_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_USB_CLK_SEL_ACK_EXT_EN_SHIFT)) & APU_USB_STATUS_USB_CLK_SEL_ACK_EXT_EN_MASK)

#define APU_USB_STATUS_APU_USB_AXI_CLK_EN_MASK   (0x200U)
#define APU_USB_STATUS_APU_USB_AXI_CLK_EN_SHIFT  (9U)
/*! APU_USB_AXI_CLK_EN - APU USB AXI Clock Enable */
#define APU_USB_STATUS_APU_USB_AXI_CLK_EN(x)     (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_APU_USB_AXI_CLK_EN_SHIFT)) & APU_USB_STATUS_APU_USB_AXI_CLK_EN_MASK)

#define APU_USB_STATUS_XOSC_STABLE_REFCK_MASK    (0x400U)
#define APU_USB_STATUS_XOSC_STABLE_REFCK_SHIFT   (10U)
/*! XOSC_STABLE_REFCK - OSC clock stable on ref clock domain */
#define APU_USB_STATUS_XOSC_STABLE_REFCK(x)      (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_XOSC_STABLE_REFCK_SHIFT)) & APU_USB_STATUS_XOSC_STABLE_REFCK_MASK)

#define APU_USB_STATUS_APU_USB_CLK_SEL_MASK      (0x800U)
#define APU_USB_STATUS_APU_USB_CLK_SEL_SHIFT     (11U)
/*! APU_USB_CLK_SEL - APU USB Clock Select */
#define APU_USB_STATUS_APU_USB_CLK_SEL(x)        (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_APU_USB_CLK_SEL_SHIFT)) & APU_USB_STATUS_APU_USB_CLK_SEL_MASK)

#define APU_USB_STATUS_USB_VOL_LVL_REACHED_MASK  (0x1000U)
#define APU_USB_STATUS_USB_VOL_LVL_REACHED_SHIFT (12U)
/*! USB_VOL_LVL_REACHED - USB Vol Level Reached */
#define APU_USB_STATUS_USB_VOL_LVL_REACHED(x)    (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_USB_VOL_LVL_REACHED_SHIFT)) & APU_USB_STATUS_USB_VOL_LVL_REACHED_MASK)

#define APU_USB_STATUS_DVFS_NOM_VOL_LVL_REACHED_MASK (0x2000U)
#define APU_USB_STATUS_DVFS_NOM_VOL_LVL_REACHED_SHIFT (13U)
/*! DVFS_NOM_VOL_LVL_REACHED - DVFS Nominal Vol Level Reached */
#define APU_USB_STATUS_DVFS_NOM_VOL_LVL_REACHED(x) (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_DVFS_NOM_VOL_LVL_REACHED_SHIFT)) & APU_USB_STATUS_DVFS_NOM_VOL_LVL_REACHED_MASK)

#define APU_USB_STATUS_DVFS_USB_VOL_LVL_REACHED_MASK (0x4000U)
#define APU_USB_STATUS_DVFS_USB_VOL_LVL_REACHED_SHIFT (14U)
/*! DVFS_USB_VOL_LVL_REACHED - DVFS USB Vol Level Reached */
#define APU_USB_STATUS_DVFS_USB_VOL_LVL_REACHED(x) (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_DVFS_USB_VOL_LVL_REACHED_SHIFT)) & APU_USB_STATUS_DVFS_USB_VOL_LVL_REACHED_MASK)

#define APU_USB_STATUS_USB_PWR_DWN_MASK          (0x8000U)
#define APU_USB_STATUS_USB_PWR_DWN_SHIFT         (15U)
/*! USB_PWR_DWN - USB Power Down */
#define APU_USB_STATUS_USB_PWR_DWN(x)            (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_USB_PWR_DWN_SHIFT)) & APU_USB_STATUS_USB_PWR_DWN_MASK)

#define APU_USB_STATUS_APU_USB_ST_MASK           (0xF0000U)
#define APU_USB_STATUS_APU_USB_ST_SHIFT          (16U)
/*! APU_USB_ST - APU USB St */
#define APU_USB_STATUS_APU_USB_ST(x)             (((uint32_t)(((uint32_t)(x)) << APU_USB_STATUS_APU_USB_ST_SHIFT)) & APU_USB_STATUS_APU_USB_ST_MASK)
/*! @} */

/*! @name CPU1_DVFS_CTRL - CPU1 DVFS Control */
/*! @{ */

#define APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_INDEX_MASK (0xFU)
#define APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_INDEX_SHIFT (0U)
/*! CPU1_ACTIVE_INDEX - CPU1 Active Index */
#define APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_INDEX(x)  (((uint32_t)(((uint32_t)(x)) << APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_INDEX_SHIFT)) & APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_INDEX_MASK)

#define APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_INDEX_MASK (0xF0U)
#define APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_INDEX_SHIFT (4U)
/*! CPU1_INACTIVE_INDEX - CPU1 Inactive Index */
#define APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_INDEX_SHIFT)) & APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_INDEX_MASK)

#define APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_SYS_INDEX_MASK (0xF00U)
#define APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_SYS_INDEX_SHIFT (8U)
/*! CPU1_ACTIVE_SYS_INDEX - CPU1 Active System Index */
#define APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_SYS_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_SYS_INDEX_SHIFT)) & APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_SYS_INDEX_MASK)

#define APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_SYS_INDEX_MASK (0xF000U)
#define APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_SYS_INDEX_SHIFT (12U)
/*! CPU1_INACTIVE_SYS_INDEX - CPU1 Inactive System Index */
#define APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_SYS_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_SYS_INDEX_SHIFT)) & APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_SYS_INDEX_MASK)

#define APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_AHB1_INDEX_MASK (0xF0000U)
#define APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_AHB1_INDEX_SHIFT (16U)
/*! CPU1_ACTIVE_AHB1_INDEX - CPU1 Active AHB1 Index */
#define APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_AHB1_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_AHB1_INDEX_SHIFT)) & APU_CPU1_DVFS_CTRL_CPU1_ACTIVE_AHB1_INDEX_MASK)

#define APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_AHB1_INDEX_MASK (0xF00000U)
#define APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_AHB1_INDEX_SHIFT (20U)
/*! CPU1_INACTIVE_AHB1_INDEX - CPU1 Inactive AHB1 Index */
#define APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_AHB1_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_AHB1_INDEX_SHIFT)) & APU_CPU1_DVFS_CTRL_CPU1_INACTIVE_AHB1_INDEX_MASK)

#define APU_CPU1_DVFS_CTRL_PCIE_VOL_HOST_WKUP_DEP_MASK (0x20000000U)
#define APU_CPU1_DVFS_CTRL_PCIE_VOL_HOST_WKUP_DEP_SHIFT (29U)
/*! PCIE_VOL_HOST_WKUP_DEP - PCIe Vol Host Wakeup Dep */
#define APU_CPU1_DVFS_CTRL_PCIE_VOL_HOST_WKUP_DEP(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU1_DVFS_CTRL_PCIE_VOL_HOST_WKUP_DEP_SHIFT)) & APU_CPU1_DVFS_CTRL_PCIE_VOL_HOST_WKUP_DEP_MASK)

#define APU_CPU1_DVFS_CTRL_PCIE_VOL_FLR_DEP_MASK (0x40000000U)
#define APU_CPU1_DVFS_CTRL_PCIE_VOL_FLR_DEP_SHIFT (30U)
/*! PCIE_VOL_FLR_DEP - PCIe Vol Flr Dep */
#define APU_CPU1_DVFS_CTRL_PCIE_VOL_FLR_DEP(x)   (((uint32_t)(((uint32_t)(x)) << APU_CPU1_DVFS_CTRL_PCIE_VOL_FLR_DEP_SHIFT)) & APU_CPU1_DVFS_CTRL_PCIE_VOL_FLR_DEP_MASK)

#define APU_CPU1_DVFS_CTRL_PCIE_VOL_HOST_SLP_DEP_MASK (0x80000000U)
#define APU_CPU1_DVFS_CTRL_PCIE_VOL_HOST_SLP_DEP_SHIFT (31U)
/*! PCIE_VOL_HOST_SLP_DEP - PCIe Vol Host Sleep Dep */
#define APU_CPU1_DVFS_CTRL_PCIE_VOL_HOST_SLP_DEP(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU1_DVFS_CTRL_PCIE_VOL_HOST_SLP_DEP_SHIFT)) & APU_CPU1_DVFS_CTRL_PCIE_VOL_HOST_SLP_DEP_MASK)
/*! @} */

/*! @name CPU1_FREQ_REG1 - CPU1 Frequency 1 */
/*! @{ */

#define APU_CPU1_FREQ_REG1_CPU1_FREQ_REG1_MASK   (0xFFFFFFFFU)
#define APU_CPU1_FREQ_REG1_CPU1_FREQ_REG1_SHIFT  (0U)
/*! CPU1_FREQ_REG1 - CPU1 Frequency 1 */
#define APU_CPU1_FREQ_REG1_CPU1_FREQ_REG1(x)     (((uint32_t)(((uint32_t)(x)) << APU_CPU1_FREQ_REG1_CPU1_FREQ_REG1_SHIFT)) & APU_CPU1_FREQ_REG1_CPU1_FREQ_REG1_MASK)
/*! @} */

/*! @name CPU1_FREQ_REG2 - CPU1 Frequency 2 */
/*! @{ */

#define APU_CPU1_FREQ_REG2_CPU1_FREQ_REG2_MASK   (0xFFFFFFFFU)
#define APU_CPU1_FREQ_REG2_CPU1_FREQ_REG2_SHIFT  (0U)
/*! CPU1_FREQ_REG2 - CPU1 Frequency 2 */
#define APU_CPU1_FREQ_REG2_CPU1_FREQ_REG2(x)     (((uint32_t)(((uint32_t)(x)) << APU_CPU1_FREQ_REG2_CPU1_FREQ_REG2_SHIFT)) & APU_CPU1_FREQ_REG2_CPU1_FREQ_REG2_MASK)
/*! @} */

/*! @name CPU1_PLL_EN_REG - CPU1 PLL Enable */
/*! @{ */

#define APU_CPU1_PLL_EN_REG_CPU1_PLL_EN_REG_MASK (0xFFFFFFFFU)
#define APU_CPU1_PLL_EN_REG_CPU1_PLL_EN_REG_SHIFT (0U)
/*! CPU1_PLL_EN_REG - CPU1 PLL Enable */
#define APU_CPU1_PLL_EN_REG_CPU1_PLL_EN_REG(x)   (((uint32_t)(((uint32_t)(x)) << APU_CPU1_PLL_EN_REG_CPU1_PLL_EN_REG_SHIFT)) & APU_CPU1_PLL_EN_REG_CPU1_PLL_EN_REG_MASK)
/*! @} */

/*! @name CPU1_VOL_REG1 - CPU1 Voltage 1 */
/*! @{ */

#define APU_CPU1_VOL_REG1_CPU1_VOL_REG1_MASK     (0xFFFFFFFFU)
#define APU_CPU1_VOL_REG1_CPU1_VOL_REG1_SHIFT    (0U)
/*! CPU1_VOL_REG1 - CPU1 Voltage 1 */
#define APU_CPU1_VOL_REG1_CPU1_VOL_REG1(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU1_VOL_REG1_CPU1_VOL_REG1_SHIFT)) & APU_CPU1_VOL_REG1_CPU1_VOL_REG1_MASK)
/*! @} */

/*! @name CPU1_VOL_REG2 - CPU1 Voltage 2 */
/*! @{ */

#define APU_CPU1_VOL_REG2_CPU1_VOL_REG2_MASK     (0xFFFFFFFFU)
#define APU_CPU1_VOL_REG2_CPU1_VOL_REG2_SHIFT    (0U)
/*! CPU1_VOL_REG2 - CPU1 Voltage 2 */
#define APU_CPU1_VOL_REG2_CPU1_VOL_REG2(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU1_VOL_REG2_CPU1_VOL_REG2_SHIFT)) & APU_CPU1_VOL_REG2_CPU1_VOL_REG2_MASK)
/*! @} */

/*! @name CPU1_VOL_REG3 - CPU1 Voltage 3 */
/*! @{ */

#define APU_CPU1_VOL_REG3_CPU1_VOL_REG3_MASK     (0xFFFFFFFFU)
#define APU_CPU1_VOL_REG3_CPU1_VOL_REG3_SHIFT    (0U)
/*! CPU1_VOL_REG3 - CPU1 Voltage 3 */
#define APU_CPU1_VOL_REG3_CPU1_VOL_REG3(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU1_VOL_REG3_CPU1_VOL_REG3_SHIFT)) & APU_CPU1_VOL_REG3_CPU1_VOL_REG3_MASK)
/*! @} */

/*! @name CPU1_VOL_REG4 - CPU1 Voltage 4 */
/*! @{ */

#define APU_CPU1_VOL_REG4_CPU1_VOL_REG4_MASK     (0xFFFFFFFFU)
#define APU_CPU1_VOL_REG4_CPU1_VOL_REG4_SHIFT    (0U)
/*! CPU1_VOL_REG4 - CPU1 Voltage 4 */
#define APU_CPU1_VOL_REG4_CPU1_VOL_REG4(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU1_VOL_REG4_CPU1_VOL_REG4_SHIFT)) & APU_CPU1_VOL_REG4_CPU1_VOL_REG4_MASK)
/*! @} */

/*! @name CPU2_DVFS_CTRL - CPU2 DVFS Control */
/*! @{ */

#define APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_INDEX_MASK (0xFU)
#define APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_INDEX_SHIFT (0U)
/*! CPU2_ACTIVE_INDEX - CPU2 Active Index */
#define APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_INDEX(x)  (((uint32_t)(((uint32_t)(x)) << APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_INDEX_SHIFT)) & APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_INDEX_MASK)

#define APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_INDEX_MASK (0xF0U)
#define APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_INDEX_SHIFT (4U)
/*! CPU2_INACTIVE_INDEX - CPU2 Inactive Index */
#define APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_INDEX_SHIFT)) & APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_INDEX_MASK)

#define APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_SYS_INDEX_MASK (0xF00U)
#define APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_SYS_INDEX_SHIFT (8U)
/*! CPU2_ACTIVE_SYS_INDEX - CPU2 Active System Index */
#define APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_SYS_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_SYS_INDEX_SHIFT)) & APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_SYS_INDEX_MASK)

#define APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_SYS_INDEX_MASK (0xF000U)
#define APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_SYS_INDEX_SHIFT (12U)
/*! CPU2_INACTIVE_SYS_INDEX - CPU2 Inactive System Index */
#define APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_SYS_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_SYS_INDEX_SHIFT)) & APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_SYS_INDEX_MASK)

#define APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_AHB1_INDEX_MASK (0xF0000U)
#define APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_AHB1_INDEX_SHIFT (16U)
/*! CPU2_ACTIVE_AHB1_INDEX - CPU2 Active AHB1 Index */
#define APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_AHB1_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_AHB1_INDEX_SHIFT)) & APU_CPU2_DVFS_CTRL_CPU2_ACTIVE_AHB1_INDEX_MASK)

#define APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_AHB1_INDEX_MASK (0xF00000U)
#define APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_AHB1_INDEX_SHIFT (20U)
/*! CPU2_INACTIVE_AHB1_INDEX - CPU2 Inactive AHB1 Index */
#define APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_AHB1_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_AHB1_INDEX_SHIFT)) & APU_CPU2_DVFS_CTRL_CPU2_INACTIVE_AHB1_INDEX_MASK)

#define APU_CPU2_DVFS_CTRL_CPU2_AHB1_INDEX_SEL_METHOD_MASK (0x1000000U)
#define APU_CPU2_DVFS_CTRL_CPU2_AHB1_INDEX_SEL_METHOD_SHIFT (24U)
/*! CPU2_AHB1_INDEX_SEL_METHOD - CPU2 AHB1 index select method */
#define APU_CPU2_DVFS_CTRL_CPU2_AHB1_INDEX_SEL_METHOD(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU2_DVFS_CTRL_CPU2_AHB1_INDEX_SEL_METHOD_SHIFT)) & APU_CPU2_DVFS_CTRL_CPU2_AHB1_INDEX_SEL_METHOD_MASK)

#define APU_CPU2_DVFS_CTRL_UART_VOL_VAL_MASK     (0xFE000000U)
#define APU_CPU2_DVFS_CTRL_UART_VOL_VAL_SHIFT    (25U)
/*! UART_VOL_VAL - UART Vol Value */
#define APU_CPU2_DVFS_CTRL_UART_VOL_VAL(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU2_DVFS_CTRL_UART_VOL_VAL_SHIFT)) & APU_CPU2_DVFS_CTRL_UART_VOL_VAL_MASK)
/*! @} */

/*! @name CPU2_FREQ_REG1 - CPU2 Frequency 1 */
/*! @{ */

#define APU_CPU2_FREQ_REG1_CPU2_FREQ_REG1_MASK   (0xFFFFFFFFU)
#define APU_CPU2_FREQ_REG1_CPU2_FREQ_REG1_SHIFT  (0U)
/*! CPU2_FREQ_REG1 - CPU2 Frequency 1 */
#define APU_CPU2_FREQ_REG1_CPU2_FREQ_REG1(x)     (((uint32_t)(((uint32_t)(x)) << APU_CPU2_FREQ_REG1_CPU2_FREQ_REG1_SHIFT)) & APU_CPU2_FREQ_REG1_CPU2_FREQ_REG1_MASK)
/*! @} */

/*! @name CPU2_FREQ_REG2 - CPU2 Frequency 2 */
/*! @{ */

#define APU_CPU2_FREQ_REG2_CPU2_FREQ_REG2_MASK   (0xFFFFFFFFU)
#define APU_CPU2_FREQ_REG2_CPU2_FREQ_REG2_SHIFT  (0U)
/*! CPU2_FREQ_REG2 - CPU2Frequency 2 */
#define APU_CPU2_FREQ_REG2_CPU2_FREQ_REG2(x)     (((uint32_t)(((uint32_t)(x)) << APU_CPU2_FREQ_REG2_CPU2_FREQ_REG2_SHIFT)) & APU_CPU2_FREQ_REG2_CPU2_FREQ_REG2_MASK)
/*! @} */

/*! @name CPU2_PLL_EN_REG - CPU2 PLL Enable */
/*! @{ */

#define APU_CPU2_PLL_EN_REG_CPU2_PLL_EN_REG_MASK (0xFFFFFFFFU)
#define APU_CPU2_PLL_EN_REG_CPU2_PLL_EN_REG_SHIFT (0U)
/*! CPU2_PLL_EN_REG - CPU2 PLL Enable */
#define APU_CPU2_PLL_EN_REG_CPU2_PLL_EN_REG(x)   (((uint32_t)(((uint32_t)(x)) << APU_CPU2_PLL_EN_REG_CPU2_PLL_EN_REG_SHIFT)) & APU_CPU2_PLL_EN_REG_CPU2_PLL_EN_REG_MASK)
/*! @} */

/*! @name CPU2_VOL_REG1 - CPU2 Voltage 1 */
/*! @{ */

#define APU_CPU2_VOL_REG1_CPU2_VOL_REG1_MASK     (0xFFFFFFFFU)
#define APU_CPU2_VOL_REG1_CPU2_VOL_REG1_SHIFT    (0U)
/*! CPU2_VOL_REG1 - CPU2 Voltage 1 */
#define APU_CPU2_VOL_REG1_CPU2_VOL_REG1(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU2_VOL_REG1_CPU2_VOL_REG1_SHIFT)) & APU_CPU2_VOL_REG1_CPU2_VOL_REG1_MASK)
/*! @} */

/*! @name CPU2_VOL_REG2 - CPU2 Voltage 2 */
/*! @{ */

#define APU_CPU2_VOL_REG2_CPU2_VOL_REG2_MASK     (0xFFFFFFFFU)
#define APU_CPU2_VOL_REG2_CPU2_VOL_REG2_SHIFT    (0U)
/*! CPU2_VOL_REG2 - CPU2 Voltage 2 */
#define APU_CPU2_VOL_REG2_CPU2_VOL_REG2(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU2_VOL_REG2_CPU2_VOL_REG2_SHIFT)) & APU_CPU2_VOL_REG2_CPU2_VOL_REG2_MASK)
/*! @} */

/*! @name CPU2_VOL_REG3 - CPU2 Voltage 3 */
/*! @{ */

#define APU_CPU2_VOL_REG3_CPU2_VOL_REG3_MASK     (0xFFFFFFFFU)
#define APU_CPU2_VOL_REG3_CPU2_VOL_REG3_SHIFT    (0U)
/*! CPU2_VOL_REG3 - CPU2 Voltage 3 */
#define APU_CPU2_VOL_REG3_CPU2_VOL_REG3(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU2_VOL_REG3_CPU2_VOL_REG3_SHIFT)) & APU_CPU2_VOL_REG3_CPU2_VOL_REG3_MASK)
/*! @} */

/*! @name CPU2_VOL_REG4 - CPU2 Voltage 4 */
/*! @{ */

#define APU_CPU2_VOL_REG4_CPU2_VOL_REG4_MASK     (0xFFFFFFFFU)
#define APU_CPU2_VOL_REG4_CPU2_VOL_REG4_SHIFT    (0U)
/*! CPU2_VOL_REG4 - CPU2 Voltage 4 */
#define APU_CPU2_VOL_REG4_CPU2_VOL_REG4(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU2_VOL_REG4_CPU2_VOL_REG4_SHIFT)) & APU_CPU2_VOL_REG4_CPU2_VOL_REG4_MASK)
/*! @} */

/*! @name SYS_FREQ_REG1 - System Frequency 1 */
/*! @{ */

#define APU_SYS_FREQ_REG1_SYS_FREQ_REG1_MASK     (0xFFFFFFFFU)
#define APU_SYS_FREQ_REG1_SYS_FREQ_REG1_SHIFT    (0U)
/*! SYS_FREQ_REG1 - System Frequency 1 */
#define APU_SYS_FREQ_REG1_SYS_FREQ_REG1(x)       (((uint32_t)(((uint32_t)(x)) << APU_SYS_FREQ_REG1_SYS_FREQ_REG1_SHIFT)) & APU_SYS_FREQ_REG1_SYS_FREQ_REG1_MASK)
/*! @} */

/*! @name SYS_FREQ_REG2 - System Frequency 2 */
/*! @{ */

#define APU_SYS_FREQ_REG2_SYS_FREQ_REG2_MASK     (0xFFFFFFFFU)
#define APU_SYS_FREQ_REG2_SYS_FREQ_REG2_SHIFT    (0U)
/*! SYS_FREQ_REG2 - System Frequency 2 */
#define APU_SYS_FREQ_REG2_SYS_FREQ_REG2(x)       (((uint32_t)(((uint32_t)(x)) << APU_SYS_FREQ_REG2_SYS_FREQ_REG2_SHIFT)) & APU_SYS_FREQ_REG2_SYS_FREQ_REG2_MASK)
/*! @} */

/*! @name SYS_PLL_EN_REG - System PLL Enable */
/*! @{ */

#define APU_SYS_PLL_EN_REG_SYS_PLL_EN_REG_MASK   (0xFFFFFFFFU)
#define APU_SYS_PLL_EN_REG_SYS_PLL_EN_REG_SHIFT  (0U)
/*! SYS_PLL_EN_REG - System PLL Enable */
#define APU_SYS_PLL_EN_REG_SYS_PLL_EN_REG(x)     (((uint32_t)(((uint32_t)(x)) << APU_SYS_PLL_EN_REG_SYS_PLL_EN_REG_SHIFT)) & APU_SYS_PLL_EN_REG_SYS_PLL_EN_REG_MASK)
/*! @} */

/*! @name SYS_VOL_REG1 - System Voltage 1 */
/*! @{ */

#define APU_SYS_VOL_REG1_SYS_VOL_REG1_MASK       (0xFFFFFFFFU)
#define APU_SYS_VOL_REG1_SYS_VOL_REG1_SHIFT      (0U)
/*! SYS_VOL_REG1 - System Voltage 1 */
#define APU_SYS_VOL_REG1_SYS_VOL_REG1(x)         (((uint32_t)(((uint32_t)(x)) << APU_SYS_VOL_REG1_SYS_VOL_REG1_SHIFT)) & APU_SYS_VOL_REG1_SYS_VOL_REG1_MASK)
/*! @} */

/*! @name SYS_VOL_REG2 - System Voltage 2 */
/*! @{ */

#define APU_SYS_VOL_REG2_SYS_VOL_REG2_MASK       (0xFFFFFFFFU)
#define APU_SYS_VOL_REG2_SYS_VOL_REG2_SHIFT      (0U)
/*! SYS_VOL_REG2 - System Voltage 2 */
#define APU_SYS_VOL_REG2_SYS_VOL_REG2(x)         (((uint32_t)(((uint32_t)(x)) << APU_SYS_VOL_REG2_SYS_VOL_REG2_SHIFT)) & APU_SYS_VOL_REG2_SYS_VOL_REG2_MASK)
/*! @} */

/*! @name SYS_VOL_REG3 - System Voltage 3 */
/*! @{ */

#define APU_SYS_VOL_REG3_SYS_VOL_REG3_MASK       (0xFFFFFFFFU)
#define APU_SYS_VOL_REG3_SYS_VOL_REG3_SHIFT      (0U)
/*! SYS_VOL_REG3 - System Voltage 3 */
#define APU_SYS_VOL_REG3_SYS_VOL_REG3(x)         (((uint32_t)(((uint32_t)(x)) << APU_SYS_VOL_REG3_SYS_VOL_REG3_SHIFT)) & APU_SYS_VOL_REG3_SYS_VOL_REG3_MASK)
/*! @} */

/*! @name SYS_VOL_REG4 - System Voltage 4 */
/*! @{ */

#define APU_SYS_VOL_REG4_SYS_VOL_REG4_MASK       (0xFFFFFFFFU)
#define APU_SYS_VOL_REG4_SYS_VOL_REG4_SHIFT      (0U)
/*! SYS_VOL_REG4 - System Voltage 4 */
#define APU_SYS_VOL_REG4_SYS_VOL_REG4(x)         (((uint32_t)(((uint32_t)(x)) << APU_SYS_VOL_REG4_SYS_VOL_REG4_SHIFT)) & APU_SYS_VOL_REG4_SYS_VOL_REG4_MASK)
/*! @} */

/*! @name DVFS_CTRL - DVFS Control */
/*! @{ */

#define APU_DVFS_CTRL_DVFS_HOST_VOL_VAL_MASK     (0x7FU)
#define APU_DVFS_CTRL_DVFS_HOST_VOL_VAL_SHIFT    (0U)
/*! DVFS_HOST_VOL_VAL - DVFS Host Vol Value */
#define APU_DVFS_CTRL_DVFS_HOST_VOL_VAL(x)       (((uint32_t)(((uint32_t)(x)) << APU_DVFS_CTRL_DVFS_HOST_VOL_VAL_SHIFT)) & APU_DVFS_CTRL_DVFS_HOST_VOL_VAL_MASK)

#define APU_DVFS_CTRL_DVFS_EAS_VOL_MASK          (0x3F80U)
#define APU_DVFS_CTRL_DVFS_EAS_VOL_SHIFT         (7U)
/*! DVFS_EAS_VOL - DVFS EAS Vol */
#define APU_DVFS_CTRL_DVFS_EAS_VOL(x)            (((uint32_t)(((uint32_t)(x)) << APU_DVFS_CTRL_DVFS_EAS_VOL_SHIFT)) & APU_DVFS_CTRL_DVFS_EAS_VOL_MASK)

#define APU_DVFS_CTRL_DVFS_CLK_SWITCH_EN_MASK    (0x4000U)
#define APU_DVFS_CTRL_DVFS_CLK_SWITCH_EN_SHIFT   (14U)
/*! DVFS_CLK_SWITCH_EN - DVFS Clock Switch Enable */
#define APU_DVFS_CTRL_DVFS_CLK_SWITCH_EN(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_CTRL_DVFS_CLK_SWITCH_EN_SHIFT)) & APU_DVFS_CTRL_DVFS_CLK_SWITCH_EN_MASK)

#define APU_DVFS_CTRL_DVFS_DYN_CLK_EN_MASK       (0x8000U)
#define APU_DVFS_CTRL_DVFS_DYN_CLK_EN_SHIFT      (15U)
/*! DVFS_DYN_CLK_EN - DVFS Dynamic Clock Enable */
#define APU_DVFS_CTRL_DVFS_DYN_CLK_EN(x)         (((uint32_t)(((uint32_t)(x)) << APU_DVFS_CTRL_DVFS_DYN_CLK_EN_SHIFT)) & APU_DVFS_CTRL_DVFS_DYN_CLK_EN_MASK)

#define APU_DVFS_CTRL_DVFS_MODE_MASK             (0x10000U)
#define APU_DVFS_CTRL_DVFS_MODE_SHIFT            (16U)
/*! DVFS_MODE - DVFS Mode 0: only use partial_dvfs_vol(default) */
#define APU_DVFS_CTRL_DVFS_MODE(x)               (((uint32_t)(((uint32_t)(x)) << APU_DVFS_CTRL_DVFS_MODE_SHIFT)) & APU_DVFS_CTRL_DVFS_MODE_MASK)

#define APU_DVFS_CTRL_EN_FASTER_DYN_CLK_MASK     (0x20000U)
#define APU_DVFS_CTRL_EN_FASTER_DYN_CLK_SHIFT    (17U)
/*! EN_FASTER_DYN_CLK - Enable Faster Dynamic Clock */
#define APU_DVFS_CTRL_EN_FASTER_DYN_CLK(x)       (((uint32_t)(((uint32_t)(x)) << APU_DVFS_CTRL_EN_FASTER_DYN_CLK_SHIFT)) & APU_DVFS_CTRL_EN_FASTER_DYN_CLK_MASK)

#define APU_DVFS_CTRL_DVFS_EAS_VOL_DIS_MASK      (0x40000U)
#define APU_DVFS_CTRL_DVFS_EAS_VOL_DIS_SHIFT     (18U)
/*! DVFS_EAS_VOL_DIS - DVFS EAS Vol Disable */
#define APU_DVFS_CTRL_DVFS_EAS_VOL_DIS(x)        (((uint32_t)(((uint32_t)(x)) << APU_DVFS_CTRL_DVFS_EAS_VOL_DIS_SHIFT)) & APU_DVFS_CTRL_DVFS_EAS_VOL_DIS_MASK)

#define APU_DVFS_CTRL_SW_LOCK_GUARD_DIS_MASK     (0x80000U)
#define APU_DVFS_CTRL_SW_LOCK_GUARD_DIS_SHIFT    (19U)
/*! SW_LOCK_GUARD_DIS - SW Lock Guard Disable */
#define APU_DVFS_CTRL_SW_LOCK_GUARD_DIS(x)       (((uint32_t)(((uint32_t)(x)) << APU_DVFS_CTRL_SW_LOCK_GUARD_DIS_SHIFT)) & APU_DVFS_CTRL_SW_LOCK_GUARD_DIS_MASK)

#define APU_DVFS_CTRL_EN_FASTER_DVFS_MASK        (0x100000U)
#define APU_DVFS_CTRL_EN_FASTER_DVFS_SHIFT       (20U)
/*! EN_FASTER_DVFS - Enable Faster DVFS */
#define APU_DVFS_CTRL_EN_FASTER_DVFS(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_CTRL_EN_FASTER_DVFS_SHIFT)) & APU_DVFS_CTRL_EN_FASTER_DVFS_MASK)

#define APU_DVFS_CTRL_UPDATE_BUCK_EN_MASK        (0x200000U)
#define APU_DVFS_CTRL_UPDATE_BUCK_EN_SHIFT       (21U)
/*! UPDATE_BUCK_EN - to enable the forcing buck value when the resolution is not aligned */
#define APU_DVFS_CTRL_UPDATE_BUCK_EN(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_CTRL_UPDATE_BUCK_EN_SHIFT)) & APU_DVFS_CTRL_UPDATE_BUCK_EN_MASK)

#define APU_DVFS_CTRL_INACTIVE_ACK_EXT_EN_MASK   (0x1000000U)
#define APU_DVFS_CTRL_INACTIVE_ACK_EXT_EN_SHIFT  (24U)
/*! INACTIVE_ACK_EXT_EN - Inactive Ack Ext Enable */
#define APU_DVFS_CTRL_INACTIVE_ACK_EXT_EN(x)     (((uint32_t)(((uint32_t)(x)) << APU_DVFS_CTRL_INACTIVE_ACK_EXT_EN_SHIFT)) & APU_DVFS_CTRL_INACTIVE_ACK_EXT_EN_MASK)

#define APU_DVFS_CTRL_SDIO_VOL_VAL_MASK          (0xFE000000U)
#define APU_DVFS_CTRL_SDIO_VOL_VAL_SHIFT         (25U)
/*! SDIO_VOL_VAL - SDIO Vol Value */
#define APU_DVFS_CTRL_SDIO_VOL_VAL(x)            (((uint32_t)(((uint32_t)(x)) << APU_DVFS_CTRL_SDIO_VOL_VAL_SHIFT)) & APU_DVFS_CTRL_SDIO_VOL_VAL_MASK)
/*! @} */

/*! @name PARTIAL_DVFS_CTRL - Partial DVFS Control */
/*! @{ */

#define APU_PARTIAL_DVFS_CTRL_PARTIAL_DVFS_VOL_MASK (0x7FU)
#define APU_PARTIAL_DVFS_CTRL_PARTIAL_DVFS_VOL_SHIFT (0U)
/*! PARTIAL_DVFS_VOL - Partial DVFS Vol */
#define APU_PARTIAL_DVFS_CTRL_PARTIAL_DVFS_VOL(x) (((uint32_t)(((uint32_t)(x)) << APU_PARTIAL_DVFS_CTRL_PARTIAL_DVFS_VOL_SHIFT)) & APU_PARTIAL_DVFS_CTRL_PARTIAL_DVFS_VOL_MASK)

#define APU_PARTIAL_DVFS_CTRL_STATIC_PLL_EN_MASK (0x80U)
#define APU_PARTIAL_DVFS_CTRL_STATIC_PLL_EN_SHIFT (7U)
/*! STATIC_PLL_EN - Static PLL Enable */
#define APU_PARTIAL_DVFS_CTRL_STATIC_PLL_EN(x)   (((uint32_t)(((uint32_t)(x)) << APU_PARTIAL_DVFS_CTRL_STATIC_PLL_EN_SHIFT)) & APU_PARTIAL_DVFS_CTRL_STATIC_PLL_EN_MASK)

#define APU_PARTIAL_DVFS_CTRL_STATIC_DVFS_FREQ_MASK (0xF00U)
#define APU_PARTIAL_DVFS_CTRL_STATIC_DVFS_FREQ_SHIFT (8U)
/*! STATIC_DVFS_FREQ - Static DVFS Frequency */
#define APU_PARTIAL_DVFS_CTRL_STATIC_DVFS_FREQ(x) (((uint32_t)(((uint32_t)(x)) << APU_PARTIAL_DVFS_CTRL_STATIC_DVFS_FREQ_SHIFT)) & APU_PARTIAL_DVFS_CTRL_STATIC_DVFS_FREQ_MASK)

#define APU_PARTIAL_DVFS_CTRL_VOL_RESOLUTION_REF_MASK (0x1F0000U)
#define APU_PARTIAL_DVFS_CTRL_VOL_RESOLUTION_REF_SHIFT (16U)
/*! VOL_RESOLUTION_REF - Vol Resolution Ref */
#define APU_PARTIAL_DVFS_CTRL_VOL_RESOLUTION_REF(x) (((uint32_t)(((uint32_t)(x)) << APU_PARTIAL_DVFS_CTRL_VOL_RESOLUTION_REF_SHIFT)) & APU_PARTIAL_DVFS_CTRL_VOL_RESOLUTION_REF_MASK)

#define APU_PARTIAL_DVFS_CTRL_VOL_RESOLUTION_SLP_MASK (0x3E00000U)
#define APU_PARTIAL_DVFS_CTRL_VOL_RESOLUTION_SLP_SHIFT (21U)
/*! VOL_RESOLUTION_SLP - Vol Resolution Sleep */
#define APU_PARTIAL_DVFS_CTRL_VOL_RESOLUTION_SLP(x) (((uint32_t)(((uint32_t)(x)) << APU_PARTIAL_DVFS_CTRL_VOL_RESOLUTION_SLP_SHIFT)) & APU_PARTIAL_DVFS_CTRL_VOL_RESOLUTION_SLP_MASK)

#define APU_PARTIAL_DVFS_CTRL_BYPASS_DVFS_FSM_MASK (0x80000000U)
#define APU_PARTIAL_DVFS_CTRL_BYPASS_DVFS_FSM_SHIFT (31U)
/*! BYPASS_DVFS_FSM - Bypass DVFS FSM */
#define APU_PARTIAL_DVFS_CTRL_BYPASS_DVFS_FSM(x) (((uint32_t)(((uint32_t)(x)) << APU_PARTIAL_DVFS_CTRL_BYPASS_DVFS_FSM_SHIFT)) & APU_PARTIAL_DVFS_CTRL_BYPASS_DVFS_FSM_MASK)
/*! @} */

/*! @name DVFS_TIMER - DVFS Timer */
/*! @{ */

#define APU_DVFS_TIMER_SLP_CNT_MASK              (0xFFFFU)
#define APU_DVFS_TIMER_SLP_CNT_SHIFT             (0U)
/*! SLP_CNT - Sleep Count */
#define APU_DVFS_TIMER_SLP_CNT(x)                (((uint32_t)(((uint32_t)(x)) << APU_DVFS_TIMER_SLP_CNT_SHIFT)) & APU_DVFS_TIMER_SLP_CNT_MASK)

#define APU_DVFS_TIMER_REF_CNT_MASK              (0xFFFF0000U)
#define APU_DVFS_TIMER_REF_CNT_SHIFT             (16U)
/*! REF_CNT - Reference Count */
#define APU_DVFS_TIMER_REF_CNT(x)                (((uint32_t)(((uint32_t)(x)) << APU_DVFS_TIMER_REF_CNT_SHIFT)) & APU_DVFS_TIMER_REF_CNT_MASK)
/*! @} */

/*! @name AHB1_FREQ_REG1 - AHB1 Frequency 1 */
/*! @{ */

#define APU_AHB1_FREQ_REG1_AHB1_FREQ_REG1_MASK   (0xFFFFFFFFU)
#define APU_AHB1_FREQ_REG1_AHB1_FREQ_REG1_SHIFT  (0U)
/*! AHB1_FREQ_REG1 - AHB1 Frequency 1 */
#define APU_AHB1_FREQ_REG1_AHB1_FREQ_REG1(x)     (((uint32_t)(((uint32_t)(x)) << APU_AHB1_FREQ_REG1_AHB1_FREQ_REG1_SHIFT)) & APU_AHB1_FREQ_REG1_AHB1_FREQ_REG1_MASK)
/*! @} */

/*! @name AHB1_FREQ_REG2 - AHB1 Frequency 2 */
/*! @{ */

#define APU_AHB1_FREQ_REG2_AHB1_FREQ_REG2_MASK   (0xFFFFFFFFU)
#define APU_AHB1_FREQ_REG2_AHB1_FREQ_REG2_SHIFT  (0U)
/*! AHB1_FREQ_REG2 - AHB1 Frequency 2 */
#define APU_AHB1_FREQ_REG2_AHB1_FREQ_REG2(x)     (((uint32_t)(((uint32_t)(x)) << APU_AHB1_FREQ_REG2_AHB1_FREQ_REG2_SHIFT)) & APU_AHB1_FREQ_REG2_AHB1_FREQ_REG2_MASK)
/*! @} */

/*! @name AHB1_PLL_EN_REG - AHB1 PLL Enable */
/*! @{ */

#define APU_AHB1_PLL_EN_REG_AHB1_PLL_EN_REG_MASK (0xFFFFFFFFU)
#define APU_AHB1_PLL_EN_REG_AHB1_PLL_EN_REG_SHIFT (0U)
/*! AHB1_PLL_EN_REG - AHB1 PLL Enable */
#define APU_AHB1_PLL_EN_REG_AHB1_PLL_EN_REG(x)   (((uint32_t)(((uint32_t)(x)) << APU_AHB1_PLL_EN_REG_AHB1_PLL_EN_REG_SHIFT)) & APU_AHB1_PLL_EN_REG_AHB1_PLL_EN_REG_MASK)
/*! @} */

/*! @name AHB1_VOL_REG1 - AHB1 Voltage 1 */
/*! @{ */

#define APU_AHB1_VOL_REG1_AHB1_VOL_REG1_MASK     (0xFFFFFFFFU)
#define APU_AHB1_VOL_REG1_AHB1_VOL_REG1_SHIFT    (0U)
/*! AHB1_VOL_REG1 - AHB1 Voltage 1 */
#define APU_AHB1_VOL_REG1_AHB1_VOL_REG1(x)       (((uint32_t)(((uint32_t)(x)) << APU_AHB1_VOL_REG1_AHB1_VOL_REG1_SHIFT)) & APU_AHB1_VOL_REG1_AHB1_VOL_REG1_MASK)
/*! @} */

/*! @name AHB1_VOL_REG2 - AHB1 Voltage 2 */
/*! @{ */

#define APU_AHB1_VOL_REG2_AHB1_VOL_REG2_MASK     (0xFFFFFFFFU)
#define APU_AHB1_VOL_REG2_AHB1_VOL_REG2_SHIFT    (0U)
/*! AHB1_VOL_REG2 - AHB1 Voltage 2 */
#define APU_AHB1_VOL_REG2_AHB1_VOL_REG2(x)       (((uint32_t)(((uint32_t)(x)) << APU_AHB1_VOL_REG2_AHB1_VOL_REG2_SHIFT)) & APU_AHB1_VOL_REG2_AHB1_VOL_REG2_MASK)
/*! @} */

/*! @name AHB1_VOL_REG3 - AHB1 Voltage 3 */
/*! @{ */

#define APU_AHB1_VOL_REG3_AHB1_VOL_REG3_MASK     (0xFFFFFFFFU)
#define APU_AHB1_VOL_REG3_AHB1_VOL_REG3_SHIFT    (0U)
/*! AHB1_VOL_REG3 - AHB1 Voltage 3 */
#define APU_AHB1_VOL_REG3_AHB1_VOL_REG3(x)       (((uint32_t)(((uint32_t)(x)) << APU_AHB1_VOL_REG3_AHB1_VOL_REG3_SHIFT)) & APU_AHB1_VOL_REG3_AHB1_VOL_REG3_MASK)
/*! @} */

/*! @name AHB1_VOL_REG4 - AHB1 Voltage 4 */
/*! @{ */

#define APU_AHB1_VOL_REG4_AHB1_VOL_REG4_MASK     (0xFFFFFFFFU)
#define APU_AHB1_VOL_REG4_AHB1_VOL_REG4_SHIFT    (0U)
/*! AHB1_VOL_REG4 - AHB1 Voltage 4 */
#define APU_AHB1_VOL_REG4_AHB1_VOL_REG4(x)       (((uint32_t)(((uint32_t)(x)) << APU_AHB1_VOL_REG4_AHB1_VOL_REG4_SHIFT)) & APU_AHB1_VOL_REG4_AHB1_VOL_REG4_MASK)
/*! @} */

/*! @name DVFS_STATUS - DVFS Status */
/*! @{ */

#define APU_DVFS_STATUS_SYS_LOCK_FREQ_MASK       (0x1U)
#define APU_DVFS_STATUS_SYS_LOCK_FREQ_SHIFT      (0U)
/*! SYS_LOCK_FREQ - System Lock Frequency */
#define APU_DVFS_STATUS_SYS_LOCK_FREQ(x)         (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_SYS_LOCK_FREQ_SHIFT)) & APU_DVFS_STATUS_SYS_LOCK_FREQ_MASK)

#define APU_DVFS_STATUS_CPU2_LOCK_FREQ_MASK      (0x2U)
#define APU_DVFS_STATUS_CPU2_LOCK_FREQ_SHIFT     (1U)
/*! CPU2_LOCK_FREQ - CPU2 Lock Frequency */
#define APU_DVFS_STATUS_CPU2_LOCK_FREQ(x)        (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_CPU2_LOCK_FREQ_SHIFT)) & APU_DVFS_STATUS_CPU2_LOCK_FREQ_MASK)

#define APU_DVFS_STATUS_CPU1_LOCK_FREQ_MASK      (0x4U)
#define APU_DVFS_STATUS_CPU1_LOCK_FREQ_SHIFT     (2U)
/*! CPU1_LOCK_FREQ - CPU1 Lock Frequency */
#define APU_DVFS_STATUS_CPU1_LOCK_FREQ(x)        (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_CPU1_LOCK_FREQ_SHIFT)) & APU_DVFS_STATUS_CPU1_LOCK_FREQ_MASK)

#define APU_DVFS_STATUS_LOCK_FREQ_REQ_MASK       (0x8U)
#define APU_DVFS_STATUS_LOCK_FREQ_REQ_SHIFT      (3U)
/*! LOCK_FREQ_REQ - Lock Frequency Request */
#define APU_DVFS_STATUS_LOCK_FREQ_REQ(x)         (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_LOCK_FREQ_REQ_SHIFT)) & APU_DVFS_STATUS_LOCK_FREQ_REQ_MASK)

#define APU_DVFS_STATUS_SYS_LOCK_VOL_MASK        (0x10U)
#define APU_DVFS_STATUS_SYS_LOCK_VOL_SHIFT       (4U)
/*! SYS_LOCK_VOL - System Lock Vol */
#define APU_DVFS_STATUS_SYS_LOCK_VOL(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_SYS_LOCK_VOL_SHIFT)) & APU_DVFS_STATUS_SYS_LOCK_VOL_MASK)

#define APU_DVFS_STATUS_CPU2_LOCK_VOL_MASK       (0x20U)
#define APU_DVFS_STATUS_CPU2_LOCK_VOL_SHIFT      (5U)
/*! CPU2_LOCK_VOL - CPU2 Lock Vol */
#define APU_DVFS_STATUS_CPU2_LOCK_VOL(x)         (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_CPU2_LOCK_VOL_SHIFT)) & APU_DVFS_STATUS_CPU2_LOCK_VOL_MASK)

#define APU_DVFS_STATUS_CPU1_LOCK_VOL_MASK       (0x40U)
#define APU_DVFS_STATUS_CPU1_LOCK_VOL_SHIFT      (6U)
/*! CPU1_LOCK_VOL - CPU1 Lock Vol */
#define APU_DVFS_STATUS_CPU1_LOCK_VOL(x)         (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_CPU1_LOCK_VOL_SHIFT)) & APU_DVFS_STATUS_CPU1_LOCK_VOL_MASK)

#define APU_DVFS_STATUS_LOCK_VOL_REQ_MASK        (0x80U)
#define APU_DVFS_STATUS_LOCK_VOL_REQ_SHIFT       (7U)
/*! LOCK_VOL_REQ - Lock Vol Request */
#define APU_DVFS_STATUS_LOCK_VOL_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_LOCK_VOL_REQ_SHIFT)) & APU_DVFS_STATUS_LOCK_VOL_REQ_MASK)

#define APU_DVFS_STATUS_SYS_FREQ_CTRL_MASK       (0xF00U)
#define APU_DVFS_STATUS_SYS_FREQ_CTRL_SHIFT      (8U)
/*! SYS_FREQ_CTRL - System Frequency Control */
#define APU_DVFS_STATUS_SYS_FREQ_CTRL(x)         (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_SYS_FREQ_CTRL_SHIFT)) & APU_DVFS_STATUS_SYS_FREQ_CTRL_MASK)

#define APU_DVFS_STATUS_CPU2_FREQ_CTRL_MASK      (0xF000U)
#define APU_DVFS_STATUS_CPU2_FREQ_CTRL_SHIFT     (12U)
/*! CPU2_FREQ_CTRL - CPU2 Frequency Control */
#define APU_DVFS_STATUS_CPU2_FREQ_CTRL(x)        (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_CPU2_FREQ_CTRL_SHIFT)) & APU_DVFS_STATUS_CPU2_FREQ_CTRL_MASK)

#define APU_DVFS_STATUS_CPU1_FREQ_CTRL_MASK      (0xF0000U)
#define APU_DVFS_STATUS_CPU1_FREQ_CTRL_SHIFT     (16U)
/*! CPU1_FREQ_CTRL - CPU1 Frequency Control */
#define APU_DVFS_STATUS_CPU1_FREQ_CTRL(x)        (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_CPU1_FREQ_CTRL_SHIFT)) & APU_DVFS_STATUS_CPU1_FREQ_CTRL_MASK)

#define APU_DVFS_STATUS_SOC_POWER_LVL_REACHED_MASK (0x100000U)
#define APU_DVFS_STATUS_SOC_POWER_LVL_REACHED_SHIFT (20U)
/*! SOC_POWER_LVL_REACHED - SoC Power Level Reached */
#define APU_DVFS_STATUS_SOC_POWER_LVL_REACHED(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_SOC_POWER_LVL_REACHED_SHIFT)) & APU_DVFS_STATUS_SOC_POWER_LVL_REACHED_MASK)

#define APU_DVFS_STATUS_USB_VOL_LVL_REACHED_MASK (0x200000U)
#define APU_DVFS_STATUS_USB_VOL_LVL_REACHED_SHIFT (21U)
/*! USB_VOL_LVL_REACHED - USB Vol Level Reached */
#define APU_DVFS_STATUS_USB_VOL_LVL_REACHED(x)   (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_USB_VOL_LVL_REACHED_SHIFT)) & APU_DVFS_STATUS_USB_VOL_LVL_REACHED_MASK)

#define APU_DVFS_STATUS_PCIE_VOL_LVL_REACHED_MASK (0x400000U)
#define APU_DVFS_STATUS_PCIE_VOL_LVL_REACHED_SHIFT (22U)
/*! PCIE_VOL_LVL_REACHED - PCIe Vol Level Reached */
#define APU_DVFS_STATUS_PCIE_VOL_LVL_REACHED(x)  (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_PCIE_VOL_LVL_REACHED_SHIFT)) & APU_DVFS_STATUS_PCIE_VOL_LVL_REACHED_MASK)

#define APU_DVFS_STATUS_APU_BUCK_LVL_CTRL_MASK   (0x3F800000U)
#define APU_DVFS_STATUS_APU_BUCK_LVL_CTRL_SHIFT  (23U)
/*! APU_BUCK_LVL_CTRL - APU BUCK Level Control */
#define APU_DVFS_STATUS_APU_BUCK_LVL_CTRL(x)     (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_APU_BUCK_LVL_CTRL_SHIFT)) & APU_DVFS_STATUS_APU_BUCK_LVL_CTRL_MASK)

#define APU_DVFS_STATUS_SW_FREQ_GAURD_MASK       (0x40000000U)
#define APU_DVFS_STATUS_SW_FREQ_GAURD_SHIFT      (30U)
/*! SW_FREQ_GAURD - SW Frequency Guard */
#define APU_DVFS_STATUS_SW_FREQ_GAURD(x)         (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_SW_FREQ_GAURD_SHIFT)) & APU_DVFS_STATUS_SW_FREQ_GAURD_MASK)

#define APU_DVFS_STATUS_SW_LOCK_GAURD_MASK       (0x80000000U)
#define APU_DVFS_STATUS_SW_LOCK_GAURD_SHIFT      (31U)
/*! SW_LOCK_GAURD - SW Lock Guard */
#define APU_DVFS_STATUS_SW_LOCK_GAURD(x)         (((uint32_t)(((uint32_t)(x)) << APU_DVFS_STATUS_SW_LOCK_GAURD_SHIFT)) & APU_DVFS_STATUS_SW_LOCK_GAURD_MASK)
/*! @} */

/*! @name DVFS_DBG_CTRL - DVFS Debug Control */
/*! @{ */

#define APU_DVFS_DBG_CTRL_DVFS_DBG_MODE_MASK     (0x1U)
#define APU_DVFS_DBG_CTRL_DVFS_DBG_MODE_SHIFT    (0U)
/*! DVFS_DBG_MODE - DVFS Debug Mode */
#define APU_DVFS_DBG_CTRL_DVFS_DBG_MODE(x)       (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_CTRL_DVFS_DBG_MODE_SHIFT)) & APU_DVFS_DBG_CTRL_DVFS_DBG_MODE_MASK)

#define APU_DVFS_DBG_CTRL_START_TRIGGER_MASK     (0x2U)
#define APU_DVFS_DBG_CTRL_START_TRIGGER_SHIFT    (1U)
/*! START_TRIGGER - Start Trigger */
#define APU_DVFS_DBG_CTRL_START_TRIGGER(x)       (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_CTRL_START_TRIGGER_SHIFT)) & APU_DVFS_DBG_CTRL_START_TRIGGER_MASK)

#define APU_DVFS_DBG_CTRL_END_TRIGGER_MASK       (0x4U)
#define APU_DVFS_DBG_CTRL_END_TRIGGER_SHIFT      (2U)
/*! END_TRIGGER - End Trigger */
#define APU_DVFS_DBG_CTRL_END_TRIGGER(x)         (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_CTRL_END_TRIGGER_SHIFT)) & APU_DVFS_DBG_CTRL_END_TRIGGER_MASK)

#define APU_DVFS_DBG_CTRL_DBG_VOL_SEL_MASK       (0x70U)
#define APU_DVFS_DBG_CTRL_DBG_VOL_SEL_SHIFT      (4U)
/*! DBG_VOL_SEL - Debug Vol Select */
#define APU_DVFS_DBG_CTRL_DBG_VOL_SEL(x)         (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_CTRL_DBG_VOL_SEL_SHIFT)) & APU_DVFS_DBG_CTRL_DBG_VOL_SEL_MASK)

#define APU_DVFS_DBG_CTRL_DBG_SLP_TIMER_SEL_MASK (0x300U)
#define APU_DVFS_DBG_CTRL_DBG_SLP_TIMER_SEL_SHIFT (8U)
/*! DBG_SLP_TIMER_SEL - Debug Sleep Timer Select */
#define APU_DVFS_DBG_CTRL_DBG_SLP_TIMER_SEL(x)   (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_CTRL_DBG_SLP_TIMER_SEL_SHIFT)) & APU_DVFS_DBG_CTRL_DBG_SLP_TIMER_SEL_MASK)

#define APU_DVFS_DBG_CTRL_DVFS_CLK_SEL_FW_BYPASS_MASK (0x1000U)
#define APU_DVFS_DBG_CTRL_DVFS_CLK_SEL_FW_BYPASS_SHIFT (12U)
/*! DVFS_CLK_SEL_FW_BYPASS - DVFS Clock Select FW Bypass */
#define APU_DVFS_DBG_CTRL_DVFS_CLK_SEL_FW_BYPASS(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_CTRL_DVFS_CLK_SEL_FW_BYPASS_SHIFT)) & APU_DVFS_DBG_CTRL_DVFS_CLK_SEL_FW_BYPASS_MASK)

#define APU_DVFS_DBG_CTRL_DVFS_CLK_SEL_FW_VAL_MASK (0x2000U)
#define APU_DVFS_DBG_CTRL_DVFS_CLK_SEL_FW_VAL_SHIFT (13U)
/*! DVFS_CLK_SEL_FW_VAL - DVFS Clock Select FW Value */
#define APU_DVFS_DBG_CTRL_DVFS_CLK_SEL_FW_VAL(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_CTRL_DVFS_CLK_SEL_FW_VAL_SHIFT)) & APU_DVFS_DBG_CTRL_DVFS_CLK_SEL_FW_VAL_MASK)

#define APU_DVFS_DBG_CTRL_BUCK_EFF_MODE_FIX_MASK (0x8000U)
#define APU_DVFS_DBG_CTRL_BUCK_EFF_MODE_FIX_SHIFT (15U)
/*! BUCK_EFF_MODE_FIX - BUCK Efficiency Mode Fix */
#define APU_DVFS_DBG_CTRL_BUCK_EFF_MODE_FIX(x)   (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_CTRL_BUCK_EFF_MODE_FIX_SHIFT)) & APU_DVFS_DBG_CTRL_BUCK_EFF_MODE_FIX_MASK)

#define APU_DVFS_DBG_CTRL_SD_CLK_SWITCH_OK_MASK_MASK (0x10000U)
#define APU_DVFS_DBG_CTRL_SD_CLK_SWITCH_OK_MASK_SHIFT (16U)
/*! SD_CLK_SWITCH_OK_MASK - SD Clock Switch Ok Mask */
#define APU_DVFS_DBG_CTRL_SD_CLK_SWITCH_OK_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_CTRL_SD_CLK_SWITCH_OK_MASK_SHIFT)) & APU_DVFS_DBG_CTRL_SD_CLK_SWITCH_OK_MASK_MASK)
/*! @} */

/*! @name DVFS_DBG_PATTERN_DATA - DVFS Debug Pattern Data */
/*! @{ */

#define APU_DVFS_DBG_PATTERN_DATA_VOL_REQ_MASK   (0x1FU)
#define APU_DVFS_DBG_PATTERN_DATA_VOL_REQ_SHIFT  (0U)
/*! VOL_REQ - Vol Request */
#define APU_DVFS_DBG_PATTERN_DATA_VOL_REQ(x)     (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_PATTERN_DATA_VOL_REQ_SHIFT)) & APU_DVFS_DBG_PATTERN_DATA_VOL_REQ_MASK)

#define APU_DVFS_DBG_PATTERN_DATA_SYS_FREQ_CTRL_MASK (0x1E0U)
#define APU_DVFS_DBG_PATTERN_DATA_SYS_FREQ_CTRL_SHIFT (5U)
/*! SYS_FREQ_CTRL - System Frequency Control */
#define APU_DVFS_DBG_PATTERN_DATA_SYS_FREQ_CTRL(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_PATTERN_DATA_SYS_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_PATTERN_DATA_SYS_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_PATTERN_DATA_CPU2_FREQ_CTRL_MASK (0x1E00U)
#define APU_DVFS_DBG_PATTERN_DATA_CPU2_FREQ_CTRL_SHIFT (9U)
/*! CPU2_FREQ_CTRL - CPU2 Frequency Control */
#define APU_DVFS_DBG_PATTERN_DATA_CPU2_FREQ_CTRL(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_PATTERN_DATA_CPU2_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_PATTERN_DATA_CPU2_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_PATTERN_DATA_CPU1_FREQ_CTRL_MASK (0x1E000U)
#define APU_DVFS_DBG_PATTERN_DATA_CPU1_FREQ_CTRL_SHIFT (13U)
/*! CPU1_FREQ_CTRL - CPU1 Frequency Control */
#define APU_DVFS_DBG_PATTERN_DATA_CPU1_FREQ_CTRL(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_PATTERN_DATA_CPU1_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_PATTERN_DATA_CPU1_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_PATTERN_DATA_APU_BUCK_LVL_CTRL_MASK (0x3E0000U)
#define APU_DVFS_DBG_PATTERN_DATA_APU_BUCK_LVL_CTRL_SHIFT (17U)
/*! APU_BUCK_LVL_CTRL - APU BUCK Level Control */
#define APU_DVFS_DBG_PATTERN_DATA_APU_BUCK_LVL_CTRL(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_PATTERN_DATA_APU_BUCK_LVL_CTRL_SHIFT)) & APU_DVFS_DBG_PATTERN_DATA_APU_BUCK_LVL_CTRL_MASK)

#define APU_DVFS_DBG_PATTERN_DATA_SW_VOL_REQ_MASK (0x7C00000U)
#define APU_DVFS_DBG_PATTERN_DATA_SW_VOL_REQ_SHIFT (22U)
/*! SW_VOL_REQ - SW Vol Request */
#define APU_DVFS_DBG_PATTERN_DATA_SW_VOL_REQ(x)  (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_PATTERN_DATA_SW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_PATTERN_DATA_SW_VOL_REQ_MASK)

#define APU_DVFS_DBG_PATTERN_DATA_HW_VOL_REQ_MASK (0xF8000000U)
#define APU_DVFS_DBG_PATTERN_DATA_HW_VOL_REQ_SHIFT (27U)
/*! HW_VOL_REQ - HW Vol Request */
#define APU_DVFS_DBG_PATTERN_DATA_HW_VOL_REQ(x)  (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_PATTERN_DATA_HW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_PATTERN_DATA_HW_VOL_REQ_MASK)
/*! @} */

/*! @name DVFS_DBG_REG0 - DVFS Debug 0 */
/*! @{ */

#define APU_DVFS_DBG_REG0_VOL_REQ_MASK           (0x1FU)
#define APU_DVFS_DBG_REG0_VOL_REQ_SHIFT          (0U)
/*! VOL_REQ - Vol Request */
#define APU_DVFS_DBG_REG0_VOL_REQ(x)             (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG0_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG0_VOL_REQ_MASK)

#define APU_DVFS_DBG_REG0_SYS_FREQ_CTRL_MASK     (0x1E0U)
#define APU_DVFS_DBG_REG0_SYS_FREQ_CTRL_SHIFT    (5U)
/*! SYS_FREQ_CTRL - System Frequency Control */
#define APU_DVFS_DBG_REG0_SYS_FREQ_CTRL(x)       (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG0_SYS_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG0_SYS_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG0_CPU2_FREQ_CTRL_MASK    (0x1E00U)
#define APU_DVFS_DBG_REG0_CPU2_FREQ_CTRL_SHIFT   (9U)
/*! CPU2_FREQ_CTRL - CPU2 Frequency Control */
#define APU_DVFS_DBG_REG0_CPU2_FREQ_CTRL(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG0_CPU2_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG0_CPU2_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG0_CPU1_FREQ_CTRL_MASK    (0x1E000U)
#define APU_DVFS_DBG_REG0_CPU1_FREQ_CTRL_SHIFT   (13U)
/*! CPU1_FREQ_CTRL - CPU1 Frequency Control */
#define APU_DVFS_DBG_REG0_CPU1_FREQ_CTRL(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG0_CPU1_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG0_CPU1_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG0_APU_BUCK_LVL_CTRL_MASK (0x3E0000U)
#define APU_DVFS_DBG_REG0_APU_BUCK_LVL_CTRL_SHIFT (17U)
/*! APU_BUCK_LVL_CTRL - APU BUCK Level Control */
#define APU_DVFS_DBG_REG0_APU_BUCK_LVL_CTRL(x)   (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG0_APU_BUCK_LVL_CTRL_SHIFT)) & APU_DVFS_DBG_REG0_APU_BUCK_LVL_CTRL_MASK)

#define APU_DVFS_DBG_REG0_SW_VOL_REQ_MASK        (0x7C00000U)
#define APU_DVFS_DBG_REG0_SW_VOL_REQ_SHIFT       (22U)
/*! SW_VOL_REQ - SW Vol Request */
#define APU_DVFS_DBG_REG0_SW_VOL_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG0_SW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG0_SW_VOL_REQ_MASK)

#define APU_DVFS_DBG_REG0_HW_VOL_REQ_MASK        (0xF8000000U)
#define APU_DVFS_DBG_REG0_HW_VOL_REQ_SHIFT       (27U)
/*! HW_VOL_REQ - HW Vol Request */
#define APU_DVFS_DBG_REG0_HW_VOL_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG0_HW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG0_HW_VOL_REQ_MASK)
/*! @} */

/*! @name DVFS_DBG_REG1 - DVFS Debug 1 */
/*! @{ */

#define APU_DVFS_DBG_REG1_VOL_REQ_MASK           (0x1FU)
#define APU_DVFS_DBG_REG1_VOL_REQ_SHIFT          (0U)
/*! VOL_REQ - Vol Request */
#define APU_DVFS_DBG_REG1_VOL_REQ(x)             (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG1_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG1_VOL_REQ_MASK)

#define APU_DVFS_DBG_REG1_SYS_FREQ_CTRL_MASK     (0x1E0U)
#define APU_DVFS_DBG_REG1_SYS_FREQ_CTRL_SHIFT    (5U)
/*! SYS_FREQ_CTRL - System Frequency Control */
#define APU_DVFS_DBG_REG1_SYS_FREQ_CTRL(x)       (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG1_SYS_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG1_SYS_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG1_CPU2_FREQ_CTRL_MASK    (0x1E00U)
#define APU_DVFS_DBG_REG1_CPU2_FREQ_CTRL_SHIFT   (9U)
/*! CPU2_FREQ_CTRL - CPU2 Frequency Control */
#define APU_DVFS_DBG_REG1_CPU2_FREQ_CTRL(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG1_CPU2_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG1_CPU2_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG1_CPU1_FREQ_CTRL_MASK    (0x1E000U)
#define APU_DVFS_DBG_REG1_CPU1_FREQ_CTRL_SHIFT   (13U)
/*! CPU1_FREQ_CTRL - CPU1 Frequency Control */
#define APU_DVFS_DBG_REG1_CPU1_FREQ_CTRL(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG1_CPU1_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG1_CPU1_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG1_APU_BUCK_LVL_CTRL_MASK (0x3E0000U)
#define APU_DVFS_DBG_REG1_APU_BUCK_LVL_CTRL_SHIFT (17U)
/*! APU_BUCK_LVL_CTRL - APU BUCK Level Control */
#define APU_DVFS_DBG_REG1_APU_BUCK_LVL_CTRL(x)   (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG1_APU_BUCK_LVL_CTRL_SHIFT)) & APU_DVFS_DBG_REG1_APU_BUCK_LVL_CTRL_MASK)

#define APU_DVFS_DBG_REG1_SW_VOL_REQ_MASK        (0x7C00000U)
#define APU_DVFS_DBG_REG1_SW_VOL_REQ_SHIFT       (22U)
/*! SW_VOL_REQ - SW Vol Request */
#define APU_DVFS_DBG_REG1_SW_VOL_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG1_SW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG1_SW_VOL_REQ_MASK)

#define APU_DVFS_DBG_REG1_HW_VOL_REQ_MASK        (0xF8000000U)
#define APU_DVFS_DBG_REG1_HW_VOL_REQ_SHIFT       (27U)
/*! HW_VOL_REQ - HW Vol Request */
#define APU_DVFS_DBG_REG1_HW_VOL_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG1_HW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG1_HW_VOL_REQ_MASK)
/*! @} */

/*! @name DVFS_DBG_REG2 - DVFS Debug 2 */
/*! @{ */

#define APU_DVFS_DBG_REG2_VOL_REQ_MASK           (0x1FU)
#define APU_DVFS_DBG_REG2_VOL_REQ_SHIFT          (0U)
/*! VOL_REQ - Vol Request */
#define APU_DVFS_DBG_REG2_VOL_REQ(x)             (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG2_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG2_VOL_REQ_MASK)

#define APU_DVFS_DBG_REG2_SYS_FREQ_CTRL_MASK     (0x1E0U)
#define APU_DVFS_DBG_REG2_SYS_FREQ_CTRL_SHIFT    (5U)
/*! SYS_FREQ_CTRL - System Frequency Control */
#define APU_DVFS_DBG_REG2_SYS_FREQ_CTRL(x)       (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG2_SYS_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG2_SYS_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG2_CPU2_FREQ_CTRL_MASK    (0x1E00U)
#define APU_DVFS_DBG_REG2_CPU2_FREQ_CTRL_SHIFT   (9U)
/*! CPU2_FREQ_CTRL - CPU2 Frequency Control */
#define APU_DVFS_DBG_REG2_CPU2_FREQ_CTRL(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG2_CPU2_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG2_CPU2_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG2_CPU1_FREQ_CTRL_MASK    (0x1E000U)
#define APU_DVFS_DBG_REG2_CPU1_FREQ_CTRL_SHIFT   (13U)
/*! CPU1_FREQ_CTRL - CPU1 Frequency Control */
#define APU_DVFS_DBG_REG2_CPU1_FREQ_CTRL(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG2_CPU1_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG2_CPU1_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG2_APU_BUCK_LVL_CTRL_MASK (0x3E0000U)
#define APU_DVFS_DBG_REG2_APU_BUCK_LVL_CTRL_SHIFT (17U)
/*! APU_BUCK_LVL_CTRL - APU BUCK Level Control */
#define APU_DVFS_DBG_REG2_APU_BUCK_LVL_CTRL(x)   (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG2_APU_BUCK_LVL_CTRL_SHIFT)) & APU_DVFS_DBG_REG2_APU_BUCK_LVL_CTRL_MASK)

#define APU_DVFS_DBG_REG2_SW_VOL_REQ_MASK        (0x7C00000U)
#define APU_DVFS_DBG_REG2_SW_VOL_REQ_SHIFT       (22U)
/*! SW_VOL_REQ - SW Vol Request */
#define APU_DVFS_DBG_REG2_SW_VOL_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG2_SW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG2_SW_VOL_REQ_MASK)

#define APU_DVFS_DBG_REG2_HW_VOL_REQ_MASK        (0xF8000000U)
#define APU_DVFS_DBG_REG2_HW_VOL_REQ_SHIFT       (27U)
/*! HW_VOL_REQ - HW Vol Request */
#define APU_DVFS_DBG_REG2_HW_VOL_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG2_HW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG2_HW_VOL_REQ_MASK)
/*! @} */

/*! @name DVFS_DBG_REG3 - DVFS Debug 3 */
/*! @{ */

#define APU_DVFS_DBG_REG3_VOL_REQ_MASK           (0x1FU)
#define APU_DVFS_DBG_REG3_VOL_REQ_SHIFT          (0U)
/*! VOL_REQ - Vol Request */
#define APU_DVFS_DBG_REG3_VOL_REQ(x)             (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG3_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG3_VOL_REQ_MASK)

#define APU_DVFS_DBG_REG3_SYS_FREQ_CTRL_MASK     (0x1E0U)
#define APU_DVFS_DBG_REG3_SYS_FREQ_CTRL_SHIFT    (5U)
/*! SYS_FREQ_CTRL - System Frequency Control */
#define APU_DVFS_DBG_REG3_SYS_FREQ_CTRL(x)       (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG3_SYS_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG3_SYS_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG3_CPU2_FREQ_CTRL_MASK    (0x1E00U)
#define APU_DVFS_DBG_REG3_CPU2_FREQ_CTRL_SHIFT   (9U)
/*! CPU2_FREQ_CTRL - CPU2 Frequency Control */
#define APU_DVFS_DBG_REG3_CPU2_FREQ_CTRL(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG3_CPU2_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG3_CPU2_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG3_CPU1_FREQ_CTRL_MASK    (0x1E000U)
#define APU_DVFS_DBG_REG3_CPU1_FREQ_CTRL_SHIFT   (13U)
/*! CPU1_FREQ_CTRL - CPU1 Frequency Control */
#define APU_DVFS_DBG_REG3_CPU1_FREQ_CTRL(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG3_CPU1_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG3_CPU1_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG3_APU_BUCK_LVL_CTRL_MASK (0x3E0000U)
#define APU_DVFS_DBG_REG3_APU_BUCK_LVL_CTRL_SHIFT (17U)
/*! APU_BUCK_LVL_CTRL - APU BUCK Level Control */
#define APU_DVFS_DBG_REG3_APU_BUCK_LVL_CTRL(x)   (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG3_APU_BUCK_LVL_CTRL_SHIFT)) & APU_DVFS_DBG_REG3_APU_BUCK_LVL_CTRL_MASK)

#define APU_DVFS_DBG_REG3_SW_VOL_REQ_MASK        (0x7C00000U)
#define APU_DVFS_DBG_REG3_SW_VOL_REQ_SHIFT       (22U)
/*! SW_VOL_REQ - SW Vol Request */
#define APU_DVFS_DBG_REG3_SW_VOL_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG3_SW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG3_SW_VOL_REQ_MASK)

#define APU_DVFS_DBG_REG3_HW_VOL_REQ_MASK        (0xF8000000U)
#define APU_DVFS_DBG_REG3_HW_VOL_REQ_SHIFT       (27U)
/*! HW_VOL_REQ - HW Vol Request */
#define APU_DVFS_DBG_REG3_HW_VOL_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG3_HW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG3_HW_VOL_REQ_MASK)
/*! @} */

/*! @name DVFS_DBG_REG4 - DVFS Debug 4 */
/*! @{ */

#define APU_DVFS_DBG_REG4_VOL_REQ_MASK           (0x1FU)
#define APU_DVFS_DBG_REG4_VOL_REQ_SHIFT          (0U)
/*! VOL_REQ - Vol Request */
#define APU_DVFS_DBG_REG4_VOL_REQ(x)             (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG4_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG4_VOL_REQ_MASK)

#define APU_DVFS_DBG_REG4_SYS_FREQ_CTRL_MASK     (0x1E0U)
#define APU_DVFS_DBG_REG4_SYS_FREQ_CTRL_SHIFT    (5U)
/*! SYS_FREQ_CTRL - System Frequency Control */
#define APU_DVFS_DBG_REG4_SYS_FREQ_CTRL(x)       (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG4_SYS_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG4_SYS_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG4_CPU2_FREQ_CTRL_MASK    (0x1E00U)
#define APU_DVFS_DBG_REG4_CPU2_FREQ_CTRL_SHIFT   (9U)
/*! CPU2_FREQ_CTRL - CPU2 Frequency Control */
#define APU_DVFS_DBG_REG4_CPU2_FREQ_CTRL(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG4_CPU2_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG4_CPU2_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG4_CPU1_FREQ_CTRL_MASK    (0x1E000U)
#define APU_DVFS_DBG_REG4_CPU1_FREQ_CTRL_SHIFT   (13U)
/*! CPU1_FREQ_CTRL - CPU1 Frequency Control */
#define APU_DVFS_DBG_REG4_CPU1_FREQ_CTRL(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG4_CPU1_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG4_CPU1_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG4_APU_BUCK_LVL_CTRL_MASK (0x3E0000U)
#define APU_DVFS_DBG_REG4_APU_BUCK_LVL_CTRL_SHIFT (17U)
/*! APU_BUCK_LVL_CTRL - APU BUCK Level Control */
#define APU_DVFS_DBG_REG4_APU_BUCK_LVL_CTRL(x)   (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG4_APU_BUCK_LVL_CTRL_SHIFT)) & APU_DVFS_DBG_REG4_APU_BUCK_LVL_CTRL_MASK)

#define APU_DVFS_DBG_REG4_SW_VOL_REQ_MASK        (0x7C00000U)
#define APU_DVFS_DBG_REG4_SW_VOL_REQ_SHIFT       (22U)
/*! SW_VOL_REQ - SW Vol Request */
#define APU_DVFS_DBG_REG4_SW_VOL_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG4_SW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG4_SW_VOL_REQ_MASK)

#define APU_DVFS_DBG_REG4_HW_VOL_REQ_MASK        (0xF8000000U)
#define APU_DVFS_DBG_REG4_HW_VOL_REQ_SHIFT       (27U)
/*! HW_VOL_REQ - HW Vol Request */
#define APU_DVFS_DBG_REG4_HW_VOL_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG4_HW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG4_HW_VOL_REQ_MASK)
/*! @} */

/*! @name DVFS_DBG_REG5 - DVFS Debug 5 */
/*! @{ */

#define APU_DVFS_DBG_REG5_VOL_REQ_MASK           (0x1FU)
#define APU_DVFS_DBG_REG5_VOL_REQ_SHIFT          (0U)
/*! VOL_REQ - Vol Request */
#define APU_DVFS_DBG_REG5_VOL_REQ(x)             (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG5_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG5_VOL_REQ_MASK)

#define APU_DVFS_DBG_REG5_SYS_FREQ_CTRL_MASK     (0x1E0U)
#define APU_DVFS_DBG_REG5_SYS_FREQ_CTRL_SHIFT    (5U)
/*! SYS_FREQ_CTRL - System Frequency Control */
#define APU_DVFS_DBG_REG5_SYS_FREQ_CTRL(x)       (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG5_SYS_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG5_SYS_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG5_CPU2_FREQ_CTRL_MASK    (0x1E00U)
#define APU_DVFS_DBG_REG5_CPU2_FREQ_CTRL_SHIFT   (9U)
/*! CPU2_FREQ_CTRL - CPU2 Frequency Control */
#define APU_DVFS_DBG_REG5_CPU2_FREQ_CTRL(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG5_CPU2_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG5_CPU2_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG5_CPU1_FREQ_CTRL_MASK    (0x1E000U)
#define APU_DVFS_DBG_REG5_CPU1_FREQ_CTRL_SHIFT   (13U)
/*! CPU1_FREQ_CTRL - CPU1 Frequency Control */
#define APU_DVFS_DBG_REG5_CPU1_FREQ_CTRL(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG5_CPU1_FREQ_CTRL_SHIFT)) & APU_DVFS_DBG_REG5_CPU1_FREQ_CTRL_MASK)

#define APU_DVFS_DBG_REG5_APU_BUCK_LVL_CTRL_MASK (0x3E0000U)
#define APU_DVFS_DBG_REG5_APU_BUCK_LVL_CTRL_SHIFT (17U)
/*! APU_BUCK_LVL_CTRL - APU BUCK Level Control */
#define APU_DVFS_DBG_REG5_APU_BUCK_LVL_CTRL(x)   (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG5_APU_BUCK_LVL_CTRL_SHIFT)) & APU_DVFS_DBG_REG5_APU_BUCK_LVL_CTRL_MASK)

#define APU_DVFS_DBG_REG5_SW_VOL_REQ_MASK        (0x7C00000U)
#define APU_DVFS_DBG_REG5_SW_VOL_REQ_SHIFT       (22U)
/*! SW_VOL_REQ - SW Vol Request */
#define APU_DVFS_DBG_REG5_SW_VOL_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG5_SW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG5_SW_VOL_REQ_MASK)

#define APU_DVFS_DBG_REG5_HW_VOL_REQ_MASK        (0xF8000000U)
#define APU_DVFS_DBG_REG5_HW_VOL_REQ_SHIFT       (27U)
/*! HW_VOL_REQ - HW Vol Request */
#define APU_DVFS_DBG_REG5_HW_VOL_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_REG5_HW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_REG5_HW_VOL_REQ_MASK)
/*! @} */

/*! @name DVFS_DBG_STATUS - DVFS Debug Status */
/*! @{ */

#define APU_DVFS_DBG_STATUS_DVFS_DBG_LOG_DONE_MASK (0x1U)
#define APU_DVFS_DBG_STATUS_DVFS_DBG_LOG_DONE_SHIFT (0U)
/*! DVFS_DBG_LOG_DONE - DVFS Debug Log Done */
#define APU_DVFS_DBG_STATUS_DVFS_DBG_LOG_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_DVFS_DBG_LOG_DONE_SHIFT)) & APU_DVFS_DBG_STATUS_DVFS_DBG_LOG_DONE_MASK)

#define APU_DVFS_DBG_STATUS_BUCK_LVL_REACHED_MASK (0x3EU)
#define APU_DVFS_DBG_STATUS_BUCK_LVL_REACHED_SHIFT (1U)
/*! BUCK_LVL_REACHED - voltage corresponding to PMIC code 0x2 */
#define APU_DVFS_DBG_STATUS_BUCK_LVL_REACHED(x)  (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_BUCK_LVL_REACHED_SHIFT)) & APU_DVFS_DBG_STATUS_BUCK_LVL_REACHED_MASK)

#define APU_DVFS_DBG_STATUS_KEEP_DVFS_LVL_ACTIVE_MASK (0x40U)
#define APU_DVFS_DBG_STATUS_KEEP_DVFS_LVL_ACTIVE_SHIFT (6U)
/*! KEEP_DVFS_LVL_ACTIVE - Keep DVFS Level Active */
#define APU_DVFS_DBG_STATUS_KEEP_DVFS_LVL_ACTIVE(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_KEEP_DVFS_LVL_ACTIVE_SHIFT)) & APU_DVFS_DBG_STATUS_KEEP_DVFS_LVL_ACTIVE_MASK)

#define APU_DVFS_DBG_STATUS_RESET_COUNTER_SYNCED_MASK (0x80U)
#define APU_DVFS_DBG_STATUS_RESET_COUNTER_SYNCED_SHIFT (7U)
/*! RESET_COUNTER_SYNCED - voltage corresponding to PMIC code 0x3 */
#define APU_DVFS_DBG_STATUS_RESET_COUNTER_SYNCED(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_RESET_COUNTER_SYNCED_SHIFT)) & APU_DVFS_DBG_STATUS_RESET_COUNTER_SYNCED_MASK)

#define APU_DVFS_DBG_STATUS_SW_LOCK_GAURD_EN_MASK (0x100U)
#define APU_DVFS_DBG_STATUS_SW_LOCK_GAURD_EN_SHIFT (8U)
/*! SW_LOCK_GAURD_EN - SW Lock Guard Enable */
#define APU_DVFS_DBG_STATUS_SW_LOCK_GAURD_EN(x)  (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_SW_LOCK_GAURD_EN_SHIFT)) & APU_DVFS_DBG_STATUS_SW_LOCK_GAURD_EN_MASK)

#define APU_DVFS_DBG_STATUS_DVFS_CLK_SEL_DVFSCK_MASK (0x200U)
#define APU_DVFS_DBG_STATUS_DVFS_CLK_SEL_DVFSCK_SHIFT (9U)
/*! DVFS_CLK_SEL_DVFSCK - DVFS Clock Select DVFSCK */
#define APU_DVFS_DBG_STATUS_DVFS_CLK_SEL_DVFSCK(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_DVFS_CLK_SEL_DVFSCK_SHIFT)) & APU_DVFS_DBG_STATUS_DVFS_CLK_SEL_DVFSCK_MASK)

#define APU_DVFS_DBG_STATUS_EAS_SEL_MASK         (0x400U)
#define APU_DVFS_DBG_STATUS_EAS_SEL_SHIFT        (10U)
/*! EAS_SEL - EAS Select */
#define APU_DVFS_DBG_STATUS_EAS_SEL(x)           (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_EAS_SEL_SHIFT)) & APU_DVFS_DBG_STATUS_EAS_SEL_MASK)

#define APU_DVFS_DBG_STATUS_SW_FREQ_GAURD_EN_MASK (0x800U)
#define APU_DVFS_DBG_STATUS_SW_FREQ_GAURD_EN_SHIFT (11U)
/*! SW_FREQ_GAURD_EN - SW Frequency Guard Enable */
#define APU_DVFS_DBG_STATUS_SW_FREQ_GAURD_EN(x)  (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_SW_FREQ_GAURD_EN_SHIFT)) & APU_DVFS_DBG_STATUS_SW_FREQ_GAURD_EN_MASK)

#define APU_DVFS_DBG_STATUS_PMIC_TIMER_DONE_REG_MASK (0x1000U)
#define APU_DVFS_DBG_STATUS_PMIC_TIMER_DONE_REG_SHIFT (12U)
/*! PMIC_TIMER_DONE_REG - PMIC Timer Done */
#define APU_DVFS_DBG_STATUS_PMIC_TIMER_DONE_REG(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_PMIC_TIMER_DONE_REG_SHIFT)) & APU_DVFS_DBG_STATUS_PMIC_TIMER_DONE_REG_MASK)

#define APU_DVFS_DBG_STATUS_WLAN_VOL_LVL_REACHED_MASK (0x8000U)
#define APU_DVFS_DBG_STATUS_WLAN_VOL_LVL_REACHED_SHIFT (15U)
/*! WLAN_VOL_LVL_REACHED - WLAN Vol Level Reached */
#define APU_DVFS_DBG_STATUS_WLAN_VOL_LVL_REACHED(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_WLAN_VOL_LVL_REACHED_SHIFT)) & APU_DVFS_DBG_STATUS_WLAN_VOL_LVL_REACHED_MASK)

#define APU_DVFS_DBG_STATUS_NFC_VOL_LVL_REACHED_MASK (0x10000U)
#define APU_DVFS_DBG_STATUS_NFC_VOL_LVL_REACHED_SHIFT (16U)
/*! NFC_VOL_LVL_REACHED - NFC Vol Level Reached */
#define APU_DVFS_DBG_STATUS_NFC_VOL_LVL_REACHED(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_NFC_VOL_LVL_REACHED_SHIFT)) & APU_DVFS_DBG_STATUS_NFC_VOL_LVL_REACHED_MASK)

#define APU_DVFS_DBG_STATUS_NOM_VOL_LVL_REACHED_MASK (0x20000U)
#define APU_DVFS_DBG_STATUS_NOM_VOL_LVL_REACHED_SHIFT (17U)
/*! NOM_VOL_LVL_REACHED - Nominal Vol Level Reached */
#define APU_DVFS_DBG_STATUS_NOM_VOL_LVL_REACHED(x) (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_NOM_VOL_LVL_REACHED_SHIFT)) & APU_DVFS_DBG_STATUS_NOM_VOL_LVL_REACHED_MASK)

#define APU_DVFS_DBG_STATUS_VOL_REQ_MASK         (0x3C0000U)
#define APU_DVFS_DBG_STATUS_VOL_REQ_SHIFT        (18U)
/*! VOL_REQ - Vol Request */
#define APU_DVFS_DBG_STATUS_VOL_REQ(x)           (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_VOL_REQ_SHIFT)) & APU_DVFS_DBG_STATUS_VOL_REQ_MASK)

#define APU_DVFS_DBG_STATUS_SW_VOL_REQ_MASK      (0x7C00000U)
#define APU_DVFS_DBG_STATUS_SW_VOL_REQ_SHIFT     (22U)
/*! SW_VOL_REQ - SW Vol Request */
#define APU_DVFS_DBG_STATUS_SW_VOL_REQ(x)        (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_SW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_STATUS_SW_VOL_REQ_MASK)

#define APU_DVFS_DBG_STATUS_HW_VOL_REQ_MASK      (0xF8000000U)
#define APU_DVFS_DBG_STATUS_HW_VOL_REQ_SHIFT     (27U)
/*! HW_VOL_REQ - HW Vol Request */
#define APU_DVFS_DBG_STATUS_HW_VOL_REQ(x)        (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_STATUS_HW_VOL_REQ_SHIFT)) & APU_DVFS_DBG_STATUS_HW_VOL_REQ_MASK)
/*! @} */

/*! @name DVFS_DBG_PATTERN_MASK - DVFS Debug Patter Mask */
/*! @{ */

#define APU_DVFS_DBG_PATTERN_MASK_MASK_MASK      (0xFFFFFFFFU)
#define APU_DVFS_DBG_PATTERN_MASK_MASK_SHIFT     (0U)
/*! MASK - Mask to Delay */
#define APU_DVFS_DBG_PATTERN_MASK_MASK(x)        (((uint32_t)(((uint32_t)(x)) << APU_DVFS_DBG_PATTERN_MASK_MASK_SHIFT)) & APU_DVFS_DBG_PATTERN_MASK_MASK_MASK)
/*! @} */

/*! @name DVFS_PMIC_TIMER - DVFS PMIC Timer */
/*! @{ */

#define APU_DVFS_PMIC_TIMER_REF_CNT_MASK         (0xFFFFU)
#define APU_DVFS_PMIC_TIMER_REF_CNT_SHIFT        (0U)
/*! REF_CNT - Reference Count */
#define APU_DVFS_PMIC_TIMER_REF_CNT(x)           (((uint32_t)(((uint32_t)(x)) << APU_DVFS_PMIC_TIMER_REF_CNT_SHIFT)) & APU_DVFS_PMIC_TIMER_REF_CNT_MASK)

#define APU_DVFS_PMIC_TIMER_SLP_CNT_MASK         (0xF0000U)
#define APU_DVFS_PMIC_TIMER_SLP_CNT_SHIFT        (16U)
/*! SLP_CNT - Sleep Counts */
#define APU_DVFS_PMIC_TIMER_SLP_CNT(x)           (((uint32_t)(((uint32_t)(x)) << APU_DVFS_PMIC_TIMER_SLP_CNT_SHIFT)) & APU_DVFS_PMIC_TIMER_SLP_CNT_MASK)

#define APU_DVFS_PMIC_TIMER_ACTIVE_CNT_MASK      (0xFFF00000U)
#define APU_DVFS_PMIC_TIMER_ACTIVE_CNT_SHIFT     (20U)
/*! ACTIVE_CNT - Active Count */
#define APU_DVFS_PMIC_TIMER_ACTIVE_CNT(x)        (((uint32_t)(((uint32_t)(x)) << APU_DVFS_PMIC_TIMER_ACTIVE_CNT_SHIFT)) & APU_DVFS_PMIC_TIMER_ACTIVE_CNT_MASK)
/*! @} */

/*! @name DVFS_PMIC_MAP - DVFS PMIC Map */
/*! @{ */

#define APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC0_MASK (0x7FU)
#define APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC0_SHIFT (0U)
/*! DVFS_VOL_FOR_PMIC0 - DVFS Vol for PMIC 0 */
#define APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC0(x)  (((uint32_t)(((uint32_t)(x)) << APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC0_SHIFT)) & APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC0_MASK)

#define APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC1_MASK (0x7F00U)
#define APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC1_SHIFT (8U)
/*! DVFS_VOL_FOR_PMIC1 - DVFS Vol for PMIC 1 */
#define APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC1(x)  (((uint32_t)(((uint32_t)(x)) << APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC1_SHIFT)) & APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC1_MASK)

#define APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC2_MASK (0x7F0000U)
#define APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC2_SHIFT (16U)
/*! DVFS_VOL_FOR_PMIC2 - DVFS Vol for PMIC 2 */
#define APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC2(x)  (((uint32_t)(((uint32_t)(x)) << APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC2_SHIFT)) & APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC2_MASK)

#define APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC3_MASK (0x7F000000U)
#define APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC3_SHIFT (24U)
/*! DVFS_VOL_FOR_PMIC3 - DVFS Vol for PMIC 3 */
#define APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC3(x)  (((uint32_t)(((uint32_t)(x)) << APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC3_SHIFT)) & APU_DVFS_PMIC_MAP_DVFS_VOL_FOR_PMIC3_MASK)

#define APU_DVFS_PMIC_MAP_USE_PMIC_TIMER_MASK    (0x80000000U)
#define APU_DVFS_PMIC_MAP_USE_PMIC_TIMER_SHIFT   (31U)
/*! USE_PMIC_TIMER - Use PMIC Timer */
#define APU_DVFS_PMIC_MAP_USE_PMIC_TIMER(x)      (((uint32_t)(((uint32_t)(x)) << APU_DVFS_PMIC_MAP_USE_PMIC_TIMER_SHIFT)) & APU_DVFS_PMIC_MAP_USE_PMIC_TIMER_MASK)
/*! @} */

/*! @name LDO_CTRL - LDO Control */
/*! @{ */

#define APU_LDO_CTRL_MAIN_DELAY_CNT_EN_MASK      (0x1U)
#define APU_LDO_CTRL_MAIN_DELAY_CNT_EN_SHIFT     (0U)
/*! MAIN_DELAY_CNT_EN - Main Delay Count Enable */
#define APU_LDO_CTRL_MAIN_DELAY_CNT_EN(x)        (((uint32_t)(((uint32_t)(x)) << APU_LDO_CTRL_MAIN_DELAY_CNT_EN_SHIFT)) & APU_LDO_CTRL_MAIN_DELAY_CNT_EN_MASK)

#define APU_LDO_CTRL_BACKUP_DELAY_CNT_EN_MASK    (0x2U)
#define APU_LDO_CTRL_BACKUP_DELAY_CNT_EN_SHIFT   (1U)
/*! BACKUP_DELAY_CNT_EN - Backup Delay Count Enable */
#define APU_LDO_CTRL_BACKUP_DELAY_CNT_EN(x)      (((uint32_t)(((uint32_t)(x)) << APU_LDO_CTRL_BACKUP_DELAY_CNT_EN_SHIFT)) & APU_LDO_CTRL_BACKUP_DELAY_CNT_EN_MASK)

#define APU_LDO_CTRL_MAIN_DELAY_COUNTER_VAL_MASK (0x30U)
#define APU_LDO_CTRL_MAIN_DELAY_COUNTER_VAL_SHIFT (4U)
/*! MAIN_DELAY_COUNTER_VAL - Main Delay Counter Value */
#define APU_LDO_CTRL_MAIN_DELAY_COUNTER_VAL(x)   (((uint32_t)(((uint32_t)(x)) << APU_LDO_CTRL_MAIN_DELAY_COUNTER_VAL_SHIFT)) & APU_LDO_CTRL_MAIN_DELAY_COUNTER_VAL_MASK)

#define APU_LDO_CTRL_BACKUP_DELAY_COUNTER_VAL_MASK (0xFF00U)
#define APU_LDO_CTRL_BACKUP_DELAY_COUNTER_VAL_SHIFT (8U)
/*! BACKUP_DELAY_COUNTER_VAL - Backup Delay Counter Value */
#define APU_LDO_CTRL_BACKUP_DELAY_COUNTER_VAL(x) (((uint32_t)(((uint32_t)(x)) << APU_LDO_CTRL_BACKUP_DELAY_COUNTER_VAL_SHIFT)) & APU_LDO_CTRL_BACKUP_DELAY_COUNTER_VAL_MASK)

#define APU_LDO_CTRL_USE_XOSC_EN_AS_SEL_MASK     (0x40000000U)
#define APU_LDO_CTRL_USE_XOSC_EN_AS_SEL_SHIFT    (30U)
/*! USE_XOSC_EN_AS_SEL - Use XOSC Enable as Select */
#define APU_LDO_CTRL_USE_XOSC_EN_AS_SEL(x)       (((uint32_t)(((uint32_t)(x)) << APU_LDO_CTRL_USE_XOSC_EN_AS_SEL_SHIFT)) & APU_LDO_CTRL_USE_XOSC_EN_AS_SEL_MASK)

#define APU_LDO_CTRL_KEEP_LDO_MAIN_WHILE_SLP_MASK (0x80000000U)
#define APU_LDO_CTRL_KEEP_LDO_MAIN_WHILE_SLP_SHIFT (31U)
/*! KEEP_LDO_MAIN_WHILE_SLP - Keep LDO Main While Sleep */
#define APU_LDO_CTRL_KEEP_LDO_MAIN_WHILE_SLP(x)  (((uint32_t)(((uint32_t)(x)) << APU_LDO_CTRL_KEEP_LDO_MAIN_WHILE_SLP_SHIFT)) & APU_LDO_CTRL_KEEP_LDO_MAIN_WHILE_SLP_MASK)
/*! @} */

/*! @name LDO_BACKUP_LVL_MAP1 - LDO Backup Level Map 1 */
/*! @{ */

#define APU_LDO_BACKUP_LVL_MAP1_LDO_BACKUP_LVL_MAP1_MASK (0xFFFFFFFFU)
#define APU_LDO_BACKUP_LVL_MAP1_LDO_BACKUP_LVL_MAP1_SHIFT (0U)
/*! LDO_BACKUP_LVL_MAP1 - LDO Backup Level Map 1 */
#define APU_LDO_BACKUP_LVL_MAP1_LDO_BACKUP_LVL_MAP1(x) (((uint32_t)(((uint32_t)(x)) << APU_LDO_BACKUP_LVL_MAP1_LDO_BACKUP_LVL_MAP1_SHIFT)) & APU_LDO_BACKUP_LVL_MAP1_LDO_BACKUP_LVL_MAP1_MASK)
/*! @} */

/*! @name LDO_BACKUP_LVL_MAP2 - LDO Backup Level Map 2 */
/*! @{ */

#define APU_LDO_BACKUP_LVL_MAP2_LDO_BACKUP_LVL_MAP2_MASK (0xFFFFFFFFU)
#define APU_LDO_BACKUP_LVL_MAP2_LDO_BACKUP_LVL_MAP2_SHIFT (0U)
/*! LDO_BACKUP_LVL_MAP2 - LDO Backup Level Map 2 */
#define APU_LDO_BACKUP_LVL_MAP2_LDO_BACKUP_LVL_MAP2(x) (((uint32_t)(((uint32_t)(x)) << APU_LDO_BACKUP_LVL_MAP2_LDO_BACKUP_LVL_MAP2_SHIFT)) & APU_LDO_BACKUP_LVL_MAP2_LDO_BACKUP_LVL_MAP2_MASK)
/*! @} */

/*! @name LDO_STATUS - LDO Status */
/*! @{ */

#define APU_LDO_STATUS_LDO_BACKUP_LVL_MASK       (0x7U)
#define APU_LDO_STATUS_LDO_BACKUP_LVL_SHIFT      (0U)
/*! LDO_BACKUP_LVL - LDO Backup Level */
#define APU_LDO_STATUS_LDO_BACKUP_LVL(x)         (((uint32_t)(((uint32_t)(x)) << APU_LDO_STATUS_LDO_BACKUP_LVL_SHIFT)) & APU_LDO_STATUS_LDO_BACKUP_LVL_MASK)

#define APU_LDO_STATUS_LDO_MAIN_LVL_MASK         (0xF0U)
#define APU_LDO_STATUS_LDO_MAIN_LVL_SHIFT        (4U)
/*! LDO_MAIN_LVL - LDO Main Level */
#define APU_LDO_STATUS_LDO_MAIN_LVL(x)           (((uint32_t)(((uint32_t)(x)) << APU_LDO_STATUS_LDO_MAIN_LVL_SHIFT)) & APU_LDO_STATUS_LDO_MAIN_LVL_MASK)

#define APU_LDO_STATUS_MAIN_PD_DELAY_CNT_MASK    (0x300U)
#define APU_LDO_STATUS_MAIN_PD_DELAY_CNT_SHIFT   (8U)
/*! MAIN_PD_DELAY_CNT - Main Powerdown Delay Count */
#define APU_LDO_STATUS_MAIN_PD_DELAY_CNT(x)      (((uint32_t)(((uint32_t)(x)) << APU_LDO_STATUS_MAIN_PD_DELAY_CNT_SHIFT)) & APU_LDO_STATUS_MAIN_PD_DELAY_CNT_MASK)

#define APU_LDO_STATUS_MAIN_PD_DELAY_CNT_MET_MASK (0x400U)
#define APU_LDO_STATUS_MAIN_PD_DELAY_CNT_MET_SHIFT (10U)
/*! MAIN_PD_DELAY_CNT_MET - Main Powerdown Delay Count Met */
#define APU_LDO_STATUS_MAIN_PD_DELAY_CNT_MET(x)  (((uint32_t)(((uint32_t)(x)) << APU_LDO_STATUS_MAIN_PD_DELAY_CNT_MET_SHIFT)) & APU_LDO_STATUS_MAIN_PD_DELAY_CNT_MET_MASK)

#define APU_LDO_STATUS_LDO_MAIN_PD_MASK          (0x800U)
#define APU_LDO_STATUS_LDO_MAIN_PD_SHIFT         (11U)
/*! LDO_MAIN_PD - LDO Main Powerdown */
#define APU_LDO_STATUS_LDO_MAIN_PD(x)            (((uint32_t)(((uint32_t)(x)) << APU_LDO_STATUS_LDO_MAIN_PD_SHIFT)) & APU_LDO_STATUS_LDO_MAIN_PD_MASK)

#define APU_LDO_STATUS_ACTIVE_SEL_MASK           (0x1000U)
#define APU_LDO_STATUS_ACTIVE_SEL_SHIFT          (12U)
/*! ACTIVE_SEL - Active Select */
#define APU_LDO_STATUS_ACTIVE_SEL(x)             (((uint32_t)(((uint32_t)(x)) << APU_LDO_STATUS_ACTIVE_SEL_SHIFT)) & APU_LDO_STATUS_ACTIVE_SEL_MASK)

#define APU_LDO_STATUS_BACK_DELAY_CNT_MET_MASK   (0x2000U)
#define APU_LDO_STATUS_BACK_DELAY_CNT_MET_SHIFT  (13U)
/*! BACK_DELAY_CNT_MET - Back Delay Count Met */
#define APU_LDO_STATUS_BACK_DELAY_CNT_MET(x)     (((uint32_t)(((uint32_t)(x)) << APU_LDO_STATUS_BACK_DELAY_CNT_MET_SHIFT)) & APU_LDO_STATUS_BACK_DELAY_CNT_MET_MASK)

#define APU_LDO_STATUS_D_LDO_BACKUP_EN_MASK      (0x4000U)
#define APU_LDO_STATUS_D_LDO_BACKUP_EN_SHIFT     (14U)
/*! D_LDO_BACKUP_EN - D LDO Backup Enable */
#define APU_LDO_STATUS_D_LDO_BACKUP_EN(x)        (((uint32_t)(((uint32_t)(x)) << APU_LDO_STATUS_D_LDO_BACKUP_EN_SHIFT)) & APU_LDO_STATUS_D_LDO_BACKUP_EN_MASK)

#define APU_LDO_STATUS_LDO_BACKUP_EN_MASK        (0x8000U)
#define APU_LDO_STATUS_LDO_BACKUP_EN_SHIFT       (15U)
/*! LDO_BACKUP_EN - LDO Backup Enable */
#define APU_LDO_STATUS_LDO_BACKUP_EN(x)          (((uint32_t)(((uint32_t)(x)) << APU_LDO_STATUS_LDO_BACKUP_EN_SHIFT)) & APU_LDO_STATUS_LDO_BACKUP_EN_MASK)

#define APU_LDO_STATUS_BACKUP_DELAY_CNT_MASK     (0xFF0000U)
#define APU_LDO_STATUS_BACKUP_DELAY_CNT_SHIFT    (16U)
/*! BACKUP_DELAY_CNT - Backup Delay Count (to check testbus) */
#define APU_LDO_STATUS_BACKUP_DELAY_CNT(x)       (((uint32_t)(((uint32_t)(x)) << APU_LDO_STATUS_BACKUP_DELAY_CNT_SHIFT)) & APU_LDO_STATUS_BACKUP_DELAY_CNT_MASK)

#define APU_LDO_STATUS_BKUP_LVL2_SEL_MASK        (0x1000000U)
#define APU_LDO_STATUS_BKUP_LVL2_SEL_SHIFT       (24U)
/*! BKUP_LVL2_SEL - Backup Level 2 Select */
#define APU_LDO_STATUS_BKUP_LVL2_SEL(x)          (((uint32_t)(((uint32_t)(x)) << APU_LDO_STATUS_BKUP_LVL2_SEL_SHIFT)) & APU_LDO_STATUS_BKUP_LVL2_SEL_MASK)

#define APU_LDO_STATUS_BKUP_LVL1_SEL_MASK        (0x2000000U)
#define APU_LDO_STATUS_BKUP_LVL1_SEL_SHIFT       (25U)
/*! BKUP_LVL1_SEL - Backup Level 1 Select */
#define APU_LDO_STATUS_BKUP_LVL1_SEL(x)          (((uint32_t)(((uint32_t)(x)) << APU_LDO_STATUS_BKUP_LVL1_SEL_SHIFT)) & APU_LDO_STATUS_BKUP_LVL1_SEL_MASK)
/*! @} */

/*! @name RC32_CAL_CTRL - RC32 Calibration Control */
/*! @{ */

#define APU_RC32_CAL_CTRL_RC32_FULL_CAL_EN_MASK  (0x1U)
#define APU_RC32_CAL_CTRL_RC32_FULL_CAL_EN_SHIFT (0U)
/*! RC32_FULL_CAL_EN - RC32 Full Calibration Enable */
#define APU_RC32_CAL_CTRL_RC32_FULL_CAL_EN(x)    (((uint32_t)(((uint32_t)(x)) << APU_RC32_CAL_CTRL_RC32_FULL_CAL_EN_SHIFT)) & APU_RC32_CAL_CTRL_RC32_FULL_CAL_EN_MASK)

#define APU_RC32_CAL_CTRL_RC32_PARTIAL_CAL_EN_MASK (0x2U)
#define APU_RC32_CAL_CTRL_RC32_PARTIAL_CAL_EN_SHIFT (1U)
/*! RC32_PARTIAL_CAL_EN - RC32 Partial Calibration Enable */
#define APU_RC32_CAL_CTRL_RC32_PARTIAL_CAL_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_RC32_CAL_CTRL_RC32_PARTIAL_CAL_EN_SHIFT)) & APU_RC32_CAL_CTRL_RC32_PARTIAL_CAL_EN_MASK)

#define APU_RC32_CAL_CTRL_RC32_PARTIAL_CAL_EN_ON_BT_WKUP_MASK (0x4U)
#define APU_RC32_CAL_CTRL_RC32_PARTIAL_CAL_EN_ON_BT_WKUP_SHIFT (2U)
/*! RC32_PARTIAL_CAL_EN_ON_BT_WKUP - RC32 Partial Calibration Enable on Bluetooth Wakeup */
#define APU_RC32_CAL_CTRL_RC32_PARTIAL_CAL_EN_ON_BT_WKUP(x) (((uint32_t)(((uint32_t)(x)) << APU_RC32_CAL_CTRL_RC32_PARTIAL_CAL_EN_ON_BT_WKUP_SHIFT)) & APU_RC32_CAL_CTRL_RC32_PARTIAL_CAL_EN_ON_BT_WKUP_MASK)

#define APU_RC32_CAL_CTRL_USE_RC32_CAL_DONE_MASK (0x8U)
#define APU_RC32_CAL_CTRL_USE_RC32_CAL_DONE_SHIFT (3U)
/*! USE_RC32_CAL_DONE - Use RC32 Calibration Done */
#define APU_RC32_CAL_CTRL_USE_RC32_CAL_DONE(x)   (((uint32_t)(((uint32_t)(x)) << APU_RC32_CAL_CTRL_USE_RC32_CAL_DONE_SHIFT)) & APU_RC32_CAL_CTRL_USE_RC32_CAL_DONE_MASK)

#define APU_RC32_CAL_CTRL_RC32_CAL_VOL_VAL_MASK  (0x7F0U)
#define APU_RC32_CAL_CTRL_RC32_CAL_VOL_VAL_SHIFT (4U)
/*! RC32_CAL_VOL_VAL - RC32 Calibration Vol Value */
#define APU_RC32_CAL_CTRL_RC32_CAL_VOL_VAL(x)    (((uint32_t)(((uint32_t)(x)) << APU_RC32_CAL_CTRL_RC32_CAL_VOL_VAL_SHIFT)) & APU_RC32_CAL_CTRL_RC32_CAL_VOL_VAL_MASK)
/*! @} */

/*! @name RC32_CAL_SLPCLK_TIMER - RC32 Calibration Sleep Clock Timer */
/*! @{ */

#define APU_RC32_CAL_SLPCLK_TIMER_RC32_CAL_SLPCLK_TIMER_MASK (0xFFFFFFFFU)
#define APU_RC32_CAL_SLPCLK_TIMER_RC32_CAL_SLPCLK_TIMER_SHIFT (0U)
/*! RC32_CAL_SLPCLK_TIMER - RC32 Calibration Sleep Clock Timer */
#define APU_RC32_CAL_SLPCLK_TIMER_RC32_CAL_SLPCLK_TIMER(x) (((uint32_t)(((uint32_t)(x)) << APU_RC32_CAL_SLPCLK_TIMER_RC32_CAL_SLPCLK_TIMER_SHIFT)) & APU_RC32_CAL_SLPCLK_TIMER_RC32_CAL_SLPCLK_TIMER_MASK)
/*! @} */

/*! @name RC32CAL_SLPCLK_CNT_RD - RC32 Calibration Sleep Clock Count Read */
/*! @{ */

#define APU_RC32CAL_SLPCLK_CNT_RD_RC32CAL_SLPCLK_CNT_RD_MASK (0xFFFFFFFFU)
#define APU_RC32CAL_SLPCLK_CNT_RD_RC32CAL_SLPCLK_CNT_RD_SHIFT (0U)
/*! RC32CAL_SLPCLK_CNT_RD - RC32 Calibration Sleep Clock Count Read */
#define APU_RC32CAL_SLPCLK_CNT_RD_RC32CAL_SLPCLK_CNT_RD(x) (((uint32_t)(((uint32_t)(x)) << APU_RC32CAL_SLPCLK_CNT_RD_RC32CAL_SLPCLK_CNT_RD_SHIFT)) & APU_RC32CAL_SLPCLK_CNT_RD_RC32CAL_SLPCLK_CNT_RD_MASK)
/*! @} */

/*! @name TSTBUS_DATA - Testbus Data */
/*! @{ */

#define APU_TSTBUS_DATA_TSTBUS_DATA_MASK         (0xFFFFFFFFU)
#define APU_TSTBUS_DATA_TSTBUS_DATA_SHIFT        (0U)
/*! TSTBUS_DATA - Testbus Data */
#define APU_TSTBUS_DATA_TSTBUS_DATA(x)           (((uint32_t)(((uint32_t)(x)) << APU_TSTBUS_DATA_TSTBUS_DATA_SHIFT)) & APU_TSTBUS_DATA_TSTBUS_DATA_MASK)
/*! @} */

/*! @name TST_CTRL - Test Control */
/*! @{ */

#define APU_TST_CTRL_BT_BLE_TST_CTRL_MASK        (0x1U)
#define APU_TST_CTRL_BT_BLE_TST_CTRL_SHIFT       (0U)
/*! BT_BLE_TST_CTRL - Bluetooth BLE Test Control */
#define APU_TST_CTRL_BT_BLE_TST_CTRL(x)          (((uint32_t)(((uint32_t)(x)) << APU_TST_CTRL_BT_BLE_TST_CTRL_SHIFT)) & APU_TST_CTRL_BT_BLE_TST_CTRL_MASK)

#define APU_TST_CTRL_FM_TST_CTRL_MASK            (0x2U)
#define APU_TST_CTRL_FM_TST_CTRL_SHIFT           (1U)
/*! FM_TST_CTRL - FM Test Control */
#define APU_TST_CTRL_FM_TST_CTRL(x)              (((uint32_t)(((uint32_t)(x)) << APU_TST_CTRL_FM_TST_CTRL_SHIFT)) & APU_TST_CTRL_FM_TST_CTRL_MASK)

#define APU_TST_CTRL_NFC_TST_CTRL_MASK           (0x4U)
#define APU_TST_CTRL_NFC_TST_CTRL_SHIFT          (2U)
/*! NFC_TST_CTRL - NFC Test Control */
#define APU_TST_CTRL_NFC_TST_CTRL(x)             (((uint32_t)(((uint32_t)(x)) << APU_TST_CTRL_NFC_TST_CTRL_SHIFT)) & APU_TST_CTRL_NFC_TST_CTRL_MASK)

#define APU_TST_CTRL_CPU2_CP15_SLP_CTRL_MASK     (0x8U)
#define APU_TST_CTRL_CPU2_CP15_SLP_CTRL_SHIFT    (3U)
/*! CPU2_CP15_SLP_CTRL - CPU2 CP15 Sleep Control */
#define APU_TST_CTRL_CPU2_CP15_SLP_CTRL(x)       (((uint32_t)(((uint32_t)(x)) << APU_TST_CTRL_CPU2_CP15_SLP_CTRL_SHIFT)) & APU_TST_CTRL_CPU2_CP15_SLP_CTRL_MASK)

#define APU_TST_CTRL_WLAN_TST_CTRL_MASK          (0x10U)
#define APU_TST_CTRL_WLAN_TST_CTRL_SHIFT         (4U)
/*! WLAN_TST_CTRL - WLAN Test Control */
#define APU_TST_CTRL_WLAN_TST_CTRL(x)            (((uint32_t)(((uint32_t)(x)) << APU_TST_CTRL_WLAN_TST_CTRL_SHIFT)) & APU_TST_CTRL_WLAN_TST_CTRL_MASK)

#define APU_TST_CTRL_CPU1_CP15_SLP_CTRL_MASK     (0x20U)
#define APU_TST_CTRL_CPU1_CP15_SLP_CTRL_SHIFT    (5U)
/*! CPU1_CP15_SLP_CTRL - CPU1 CP15 Sleep Control */
#define APU_TST_CTRL_CPU1_CP15_SLP_CTRL(x)       (((uint32_t)(((uint32_t)(x)) << APU_TST_CTRL_CPU1_CP15_SLP_CTRL_SHIFT)) & APU_TST_CTRL_CPU1_CP15_SLP_CTRL_MASK)

#define APU_TST_CTRL_CPU2_HOST_TST_CTRL_MASK     (0xF80U)
#define APU_TST_CTRL_CPU2_HOST_TST_CTRL_SHIFT    (7U)
/*! CPU2_HOST_TST_CTRL - CPU2 Host Test Control */
#define APU_TST_CTRL_CPU2_HOST_TST_CTRL(x)       (((uint32_t)(((uint32_t)(x)) << APU_TST_CTRL_CPU2_HOST_TST_CTRL_SHIFT)) & APU_TST_CTRL_CPU2_HOST_TST_CTRL_MASK)

#define APU_TST_CTRL_TEST_MUX_SEL_SHIFT_BIT_MASK (0xF000U)
#define APU_TST_CTRL_TEST_MUX_SEL_SHIFT_BIT_SHIFT (12U)
/*! TEST_MUX_SEL_SHIFT_BIT - Test MUX Select Shift */
#define APU_TST_CTRL_TEST_MUX_SEL_SHIFT_BIT(x)   (((uint32_t)(((uint32_t)(x)) << APU_TST_CTRL_TEST_MUX_SEL_SHIFT_BIT_SHIFT)) & APU_TST_CTRL_TEST_MUX_SEL_SHIFT_BIT_MASK)

#define APU_TST_CTRL_APU_TESTBUS_SEL_MASK        (0x1F0000U)
#define APU_TST_CTRL_APU_TESTBUS_SEL_SHIFT       (16U)
/*! APU_TESTBUS_SEL - APU Testbus Select */
#define APU_TST_CTRL_APU_TESTBUS_SEL(x)          (((uint32_t)(((uint32_t)(x)) << APU_TST_CTRL_APU_TESTBUS_SEL_SHIFT)) & APU_TST_CTRL_APU_TESTBUS_SEL_MASK)

#define APU_TST_CTRL_APU_REG_SUBTEST_SEL_MASK    (0x600000U)
#define APU_TST_CTRL_APU_REG_SUBTEST_SEL_SHIFT   (21U)
/*! APU_REG_SUBTEST_SEL - APU Reg Subtest Select */
#define APU_TST_CTRL_APU_REG_SUBTEST_SEL(x)      (((uint32_t)(((uint32_t)(x)) << APU_TST_CTRL_APU_REG_SUBTEST_SEL_SHIFT)) & APU_TST_CTRL_APU_REG_SUBTEST_SEL_MASK)

#define APU_TST_CTRL_USE_SOC_APU_SUBTEST_MASK    (0x800000U)
#define APU_TST_CTRL_USE_SOC_APU_SUBTEST_SHIFT   (23U)
/*! USE_SOC_APU_SUBTEST - Use SoC APU Subtest */
#define APU_TST_CTRL_USE_SOC_APU_SUBTEST(x)      (((uint32_t)(((uint32_t)(x)) << APU_TST_CTRL_USE_SOC_APU_SUBTEST_SHIFT)) & APU_TST_CTRL_USE_SOC_APU_SUBTEST_MASK)

#define APU_TST_CTRL_HOST_TST_CTRL_MASK          (0x3000000U)
#define APU_TST_CTRL_HOST_TST_CTRL_SHIFT         (24U)
/*! HOST_TST_CTRL - Host Test Control */
#define APU_TST_CTRL_HOST_TST_CTRL(x)            (((uint32_t)(((uint32_t)(x)) << APU_TST_CTRL_HOST_TST_CTRL_SHIFT)) & APU_TST_CTRL_HOST_TST_CTRL_MASK)

#define APU_TST_CTRL_CPU1_HOST_TST_CTRL_MASK     (0x70000000U)
#define APU_TST_CTRL_CPU1_HOST_TST_CTRL_SHIFT    (28U)
/*! CPU1_HOST_TST_CTRL - CPU1 Host Test Control */
#define APU_TST_CTRL_CPU1_HOST_TST_CTRL(x)       (((uint32_t)(((uint32_t)(x)) << APU_TST_CTRL_CPU1_HOST_TST_CTRL_SHIFT)) & APU_TST_CTRL_CPU1_HOST_TST_CTRL_MASK)
/*! @} */

/*! @name BCA_LTE_CTRL - BCA LTE Control */
/*! @{ */

#define APU_BCA_LTE_CTRL_LTE_CNT_START_MASK      (0x1U)
#define APU_BCA_LTE_CTRL_LTE_CNT_START_SHIFT     (0U)
/*! LTE_CNT_START - LTE Count Start */
#define APU_BCA_LTE_CTRL_LTE_CNT_START(x)        (((uint32_t)(((uint32_t)(x)) << APU_BCA_LTE_CTRL_LTE_CNT_START_SHIFT)) & APU_BCA_LTE_CTRL_LTE_CNT_START_MASK)

#define APU_BCA_LTE_CTRL_LTE_TMR1_INT_MASK       (0x2U)
#define APU_BCA_LTE_CTRL_LTE_TMR1_INT_SHIFT      (1U)
/*! LTE_TMR1_INT - LTE TMR1 Interrupt */
#define APU_BCA_LTE_CTRL_LTE_TMR1_INT(x)         (((uint32_t)(((uint32_t)(x)) << APU_BCA_LTE_CTRL_LTE_TMR1_INT_SHIFT)) & APU_BCA_LTE_CTRL_LTE_TMR1_INT_MASK)

#define APU_BCA_LTE_CTRL_LTE_TMR2_INT_MASK       (0x4U)
#define APU_BCA_LTE_CTRL_LTE_TMR2_INT_SHIFT      (2U)
/*! LTE_TMR2_INT - LTE TMR2 Interrupt */
#define APU_BCA_LTE_CTRL_LTE_TMR2_INT(x)         (((uint32_t)(((uint32_t)(x)) << APU_BCA_LTE_CTRL_LTE_TMR2_INT_SHIFT)) & APU_BCA_LTE_CTRL_LTE_TMR2_INT_MASK)

#define APU_BCA_LTE_CTRL_LTE_TMR1_CNT_FREEZE_MASK (0x8U)
#define APU_BCA_LTE_CTRL_LTE_TMR1_CNT_FREEZE_SHIFT (3U)
/*! LTE_TMR1_CNT_FREEZE - LTE TMR1 Count Freeze */
#define APU_BCA_LTE_CTRL_LTE_TMR1_CNT_FREEZE(x)  (((uint32_t)(((uint32_t)(x)) << APU_BCA_LTE_CTRL_LTE_TMR1_CNT_FREEZE_SHIFT)) & APU_BCA_LTE_CTRL_LTE_TMR1_CNT_FREEZE_MASK)

#define APU_BCA_LTE_CTRL_LTE_TMR2_CNT_FREEZE_MASK (0x10U)
#define APU_BCA_LTE_CTRL_LTE_TMR2_CNT_FREEZE_SHIFT (4U)
/*! LTE_TMR2_CNT_FREEZE - LTE TMR2 Count Freeze */
#define APU_BCA_LTE_CTRL_LTE_TMR2_CNT_FREEZE(x)  (((uint32_t)(((uint32_t)(x)) << APU_BCA_LTE_CTRL_LTE_TMR2_CNT_FREEZE_SHIFT)) & APU_BCA_LTE_CTRL_LTE_TMR2_CNT_FREEZE_MASK)

#define APU_BCA_LTE_CTRL_BCA_LTE_CLK_BYP_MASK    (0x80U)
#define APU_BCA_LTE_CTRL_BCA_LTE_CLK_BYP_SHIFT   (7U)
/*! BCA_LTE_CLK_BYP - BCA LTE Clock Bypass */
#define APU_BCA_LTE_CTRL_BCA_LTE_CLK_BYP(x)      (((uint32_t)(((uint32_t)(x)) << APU_BCA_LTE_CTRL_BCA_LTE_CLK_BYP_SHIFT)) & APU_BCA_LTE_CTRL_BCA_LTE_CLK_BYP_MASK)

#define APU_BCA_LTE_CTRL_BCA_WL_LTE_COEX_EN_MASK (0x8000U)
#define APU_BCA_LTE_CTRL_BCA_WL_LTE_COEX_EN_SHIFT (15U)
/*! BCA_WL_LTE_COEX_EN - BCA WLAN LTE Coexistence Enable */
#define APU_BCA_LTE_CTRL_BCA_WL_LTE_COEX_EN(x)   (((uint32_t)(((uint32_t)(x)) << APU_BCA_LTE_CTRL_BCA_WL_LTE_COEX_EN_SHIFT)) & APU_BCA_LTE_CTRL_BCA_WL_LTE_COEX_EN_MASK)

#define APU_BCA_LTE_CTRL_BCA_BT_LTE_COEX_EN_MASK (0x10000U)
#define APU_BCA_LTE_CTRL_BCA_BT_LTE_COEX_EN_SHIFT (16U)
/*! BCA_BT_LTE_COEX_EN - BCA Bluetooth LTE Coexistence Enable */
#define APU_BCA_LTE_CTRL_BCA_BT_LTE_COEX_EN(x)   (((uint32_t)(((uint32_t)(x)) << APU_BCA_LTE_CTRL_BCA_BT_LTE_COEX_EN_SHIFT)) & APU_BCA_LTE_CTRL_BCA_BT_LTE_COEX_EN_MASK)

#define APU_BCA_LTE_CTRL_USE_SLNA_WHILE_BT_MASK  (0x100000U)
#define APU_BCA_LTE_CTRL_USE_SLNA_WHILE_BT_SHIFT (20U)
/*! USE_SLNA_WHILE_BT - Use sLNA While Bluetooth */
#define APU_BCA_LTE_CTRL_USE_SLNA_WHILE_BT(x)    (((uint32_t)(((uint32_t)(x)) << APU_BCA_LTE_CTRL_USE_SLNA_WHILE_BT_SHIFT)) & APU_BCA_LTE_CTRL_USE_SLNA_WHILE_BT_MASK)

#define APU_BCA_LTE_CTRL_BCA_FORCE_ON_WHILE_BT_MASK (0x40000000U)
#define APU_BCA_LTE_CTRL_BCA_FORCE_ON_WHILE_BT_SHIFT (30U)
/*! BCA_FORCE_ON_WHILE_BT - BCA Force on While Bluetooth */
#define APU_BCA_LTE_CTRL_BCA_FORCE_ON_WHILE_BT(x) (((uint32_t)(((uint32_t)(x)) << APU_BCA_LTE_CTRL_BCA_FORCE_ON_WHILE_BT_SHIFT)) & APU_BCA_LTE_CTRL_BCA_FORCE_ON_WHILE_BT_MASK)

#define APU_BCA_LTE_CTRL_BCA_CLK_FW_EN_MASK      (0x80000000U)
#define APU_BCA_LTE_CTRL_BCA_CLK_FW_EN_SHIFT     (31U)
/*! BCA_CLK_FW_EN - BCA Clock FW Enable */
#define APU_BCA_LTE_CTRL_BCA_CLK_FW_EN(x)        (((uint32_t)(((uint32_t)(x)) << APU_BCA_LTE_CTRL_BCA_CLK_FW_EN_SHIFT)) & APU_BCA_LTE_CTRL_BCA_CLK_FW_EN_MASK)
/*! @} */

/*! @name BCA_LTE_TIMER1 - BCA LTE Timer 1 */
/*! @{ */

#define APU_BCA_LTE_TIMER1_BCA_LTE_TIMER1_MASK   (0xFFFFFFFFU)
#define APU_BCA_LTE_TIMER1_BCA_LTE_TIMER1_SHIFT  (0U)
/*! BCA_LTE_TIMER1 - BCA LTE Timer 1 */
#define APU_BCA_LTE_TIMER1_BCA_LTE_TIMER1(x)     (((uint32_t)(((uint32_t)(x)) << APU_BCA_LTE_TIMER1_BCA_LTE_TIMER1_SHIFT)) & APU_BCA_LTE_TIMER1_BCA_LTE_TIMER1_MASK)
/*! @} */

/*! @name BCA_LTE_TIMER2 - BCA LTE Timer 2 */
/*! @{ */

#define APU_BCA_LTE_TIMER2_BCA_LTE_TIMER2_MASK   (0xFFFFFFFFU)
#define APU_BCA_LTE_TIMER2_BCA_LTE_TIMER2_SHIFT  (0U)
/*! BCA_LTE_TIMER2 - BCA LTE Timer 2 */
#define APU_BCA_LTE_TIMER2_BCA_LTE_TIMER2(x)     (((uint32_t)(((uint32_t)(x)) << APU_BCA_LTE_TIMER2_BCA_LTE_TIMER2_SHIFT)) & APU_BCA_LTE_TIMER2_BCA_LTE_TIMER2_MASK)
/*! @} */

/*! @name BCA_MWS_WKUP_TIMER - BCA MWS Wakeup Timer */
/*! @{ */

#define APU_BCA_MWS_WKUP_TIMER_BCA_MWS_TIMER_MASK (0xFFFFU)
#define APU_BCA_MWS_WKUP_TIMER_BCA_MWS_TIMER_SHIFT (0U)
/*! BCA_MWS_TIMER - BCA MWS Timer */
#define APU_BCA_MWS_WKUP_TIMER_BCA_MWS_TIMER(x)  (((uint32_t)(((uint32_t)(x)) << APU_BCA_MWS_WKUP_TIMER_BCA_MWS_TIMER_SHIFT)) & APU_BCA_MWS_WKUP_TIMER_BCA_MWS_TIMER_MASK)

#define APU_BCA_MWS_WKUP_TIMER_BCA_BCN_WKUP_CNT_MASK (0xF0000000U)
#define APU_BCA_MWS_WKUP_TIMER_BCA_BCN_WKUP_CNT_SHIFT (28U)
/*! BCA_BCN_WKUP_CNT - BCA Beacon Wakeup Count */
#define APU_BCA_MWS_WKUP_TIMER_BCA_BCN_WKUP_CNT(x) (((uint32_t)(((uint32_t)(x)) << APU_BCA_MWS_WKUP_TIMER_BCA_BCN_WKUP_CNT_SHIFT)) & APU_BCA_MWS_WKUP_TIMER_BCA_BCN_WKUP_CNT_MASK)
/*! @} */

/*! @name BT2_CTRL - Bluetooth 2 Control */
/*! @{ */

#define APU_BT2_CTRL_BT_SLP_RDY_MASK             (0x1U)
#define APU_BT2_CTRL_BT_SLP_RDY_SHIFT            (0U)
/*! BT_SLP_RDY - Bluetooth Sleep Ready */
#define APU_BT2_CTRL_BT_SLP_RDY(x)               (((uint32_t)(((uint32_t)(x)) << APU_BT2_CTRL_BT_SLP_RDY_SHIFT)) & APU_BT2_CTRL_BT_SLP_RDY_MASK)

#define APU_BT2_CTRL_BT_SLP_RDYMASK_MASK         (0x2U)
#define APU_BT2_CTRL_BT_SLP_RDYMASK_SHIFT        (1U)
/*! BT_SLP_RDYMASK - Bluetoot Sleep Ready Mask */
#define APU_BT2_CTRL_BT_SLP_RDYMASK(x)           (((uint32_t)(((uint32_t)(x)) << APU_BT2_CTRL_BT_SLP_RDYMASK_SHIFT)) & APU_BT2_CTRL_BT_SLP_RDYMASK_MASK)

#define APU_BT2_CTRL_BT_SLP_RDY_FW_MASK          (0x4U)
#define APU_BT2_CTRL_BT_SLP_RDY_FW_SHIFT         (2U)
/*! BT_SLP_RDY_FW - Bluetooth Sleep Ready FW */
#define APU_BT2_CTRL_BT_SLP_RDY_FW(x)            (((uint32_t)(((uint32_t)(x)) << APU_BT2_CTRL_BT_SLP_RDY_FW_SHIFT)) & APU_BT2_CTRL_BT_SLP_RDY_FW_MASK)

#define APU_BT2_CTRL_BTU_CLK_NCO_MODE_SEL_EN_MASK (0x8U)
#define APU_BT2_CTRL_BTU_CLK_NCO_MODE_SEL_EN_SHIFT (3U)
/*! BTU_CLK_NCO_MODE_SEL_EN - 1- ignore the btu_clk_nco_mode from CIU2, keep the bt_clk_req as XP wakeup source */
#define APU_BT2_CTRL_BTU_CLK_NCO_MODE_SEL_EN(x)  (((uint32_t)(((uint32_t)(x)) << APU_BT2_CTRL_BTU_CLK_NCO_MODE_SEL_EN_SHIFT)) & APU_BT2_CTRL_BTU_CLK_NCO_MODE_SEL_EN_MASK)

#define APU_BT2_CTRL_USE_BT_INTR_SLP_MASK        (0x80U)
#define APU_BT2_CTRL_USE_BT_INTR_SLP_SHIFT       (7U)
/*! USE_BT_INTR_SLP - Use Bluetooth interrupt Sleep */
#define APU_BT2_CTRL_USE_BT_INTR_SLP(x)          (((uint32_t)(((uint32_t)(x)) << APU_BT2_CTRL_USE_BT_INTR_SLP_SHIFT)) & APU_BT2_CTRL_USE_BT_INTR_SLP_MASK)

#define APU_BT2_CTRL_BT_CLK_SYNC_MODE_SEL1_MASK  (0x4000000U)
#define APU_BT2_CTRL_BT_CLK_SYNC_MODE_SEL1_SHIFT (26U)
/*! BT_CLK_SYNC_MODE_SEL1 - Bluetooth Clock Sync Mode Select 1 */
#define APU_BT2_CTRL_BT_CLK_SYNC_MODE_SEL1(x)    (((uint32_t)(((uint32_t)(x)) << APU_BT2_CTRL_BT_CLK_SYNC_MODE_SEL1_SHIFT)) & APU_BT2_CTRL_BT_CLK_SYNC_MODE_SEL1_MASK)

#define APU_BT2_CTRL_USE_GLITCH_FREE_BT_CLK_REQ_MASK (0x8000000U)
#define APU_BT2_CTRL_USE_GLITCH_FREE_BT_CLK_REQ_SHIFT (27U)
/*! USE_GLITCH_FREE_BT_CLK_REQ - Use Glitch-Free Bluetooth Clock Request */
#define APU_BT2_CTRL_USE_GLITCH_FREE_BT_CLK_REQ(x) (((uint32_t)(((uint32_t)(x)) << APU_BT2_CTRL_USE_GLITCH_FREE_BT_CLK_REQ_SHIFT)) & APU_BT2_CTRL_USE_GLITCH_FREE_BT_CLK_REQ_MASK)

#define APU_BT2_CTRL_BRF_CLK_SYNC_MODE_SEL_MASK  (0x10000000U)
#define APU_BT2_CTRL_BRF_CLK_SYNC_MODE_SEL_SHIFT (28U)
/*! BRF_CLK_SYNC_MODE_SEL - BRF Clock Sync Mode Select */
#define APU_BT2_CTRL_BRF_CLK_SYNC_MODE_SEL(x)    (((uint32_t)(((uint32_t)(x)) << APU_BT2_CTRL_BRF_CLK_SYNC_MODE_SEL_SHIFT)) & APU_BT2_CTRL_BRF_CLK_SYNC_MODE_SEL_MASK)

#define APU_BT2_CTRL_BT_CLK_SYNC_MODE_SEL0_MASK  (0x20000000U)
#define APU_BT2_CTRL_BT_CLK_SYNC_MODE_SEL0_SHIFT (29U)
/*! BT_CLK_SYNC_MODE_SEL0 - Bluetooth Clock Sync Mode Select 0 */
#define APU_BT2_CTRL_BT_CLK_SYNC_MODE_SEL0(x)    (((uint32_t)(((uint32_t)(x)) << APU_BT2_CTRL_BT_CLK_SYNC_MODE_SEL0_SHIFT)) & APU_BT2_CTRL_BT_CLK_SYNC_MODE_SEL0_MASK)

#define APU_BT2_CTRL_BT_PLL_SYNC_MODE_SEL_MASK   (0x40000000U)
#define APU_BT2_CTRL_BT_PLL_SYNC_MODE_SEL_SHIFT  (30U)
/*! BT_PLL_SYNC_MODE_SEL - Bluetooth PLL Sync Mode Select */
#define APU_BT2_CTRL_BT_PLL_SYNC_MODE_SEL(x)     (((uint32_t)(((uint32_t)(x)) << APU_BT2_CTRL_BT_PLL_SYNC_MODE_SEL_SHIFT)) & APU_BT2_CTRL_BT_PLL_SYNC_MODE_SEL_MASK)

#define APU_BT2_CTRL_BT_HOST_SLP_RDY_MASK        (0x80000000U)
#define APU_BT2_CTRL_BT_HOST_SLP_RDY_SHIFT       (31U)
/*! BT_HOST_SLP_RDY - Bluetooth Host Sleep Ready */
#define APU_BT2_CTRL_BT_HOST_SLP_RDY(x)          (((uint32_t)(((uint32_t)(x)) << APU_BT2_CTRL_BT_HOST_SLP_RDY_SHIFT)) & APU_BT2_CTRL_BT_HOST_SLP_RDY_MASK)
/*! @} */

/*! @name BT2_WKUP_MASK - Bluetooth 2 Wakeup Mask */
/*! @{ */

#define APU_BT2_WKUP_MASK_BCA_CLK_REQ_MASK_MASK  (0x1U)
#define APU_BT2_WKUP_MASK_BCA_CLK_REQ_MASK_SHIFT (0U)
/*! BCA_CLK_REQ_MASK - BCA Clock Request Mask */
#define APU_BT2_WKUP_MASK_BCA_CLK_REQ_MASK(x)    (((uint32_t)(((uint32_t)(x)) << APU_BT2_WKUP_MASK_BCA_CLK_REQ_MASK_SHIFT)) & APU_BT2_WKUP_MASK_BCA_CLK_REQ_MASK_MASK)

#define APU_BT2_WKUP_MASK_BT_CLK_REQ_MASK_MASK   (0x2U)
#define APU_BT2_WKUP_MASK_BT_CLK_REQ_MASK_SHIFT  (1U)
/*! BT_CLK_REQ_MASK - Bluetooth Clock Request Mask */
#define APU_BT2_WKUP_MASK_BT_CLK_REQ_MASK(x)     (((uint32_t)(((uint32_t)(x)) << APU_BT2_WKUP_MASK_BT_CLK_REQ_MASK_SHIFT)) & APU_BT2_WKUP_MASK_BT_CLK_REQ_MASK_MASK)

#define APU_BT2_WKUP_MASK_BT_WB_ACTIVE_REQ_MASK_MASK (0x4U)
#define APU_BT2_WKUP_MASK_BT_WB_ACTIVE_REQ_MASK_SHIFT (2U)
/*! BT_WB_ACTIVE_REQ_MASK - Bluetooth WB Active Request Mask */
#define APU_BT2_WKUP_MASK_BT_WB_ACTIVE_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_BT2_WKUP_MASK_BT_WB_ACTIVE_REQ_MASK_SHIFT)) & APU_BT2_WKUP_MASK_BT_WB_ACTIVE_REQ_MASK_MASK)

#define APU_BT2_WKUP_MASK_BT_INTR_MASK_MASK      (0x8U)
#define APU_BT2_WKUP_MASK_BT_INTR_MASK_SHIFT     (3U)
/*! BT_INTR_MASK - Bluetooth Interrupt Mask */
#define APU_BT2_WKUP_MASK_BT_INTR_MASK(x)        (((uint32_t)(((uint32_t)(x)) << APU_BT2_WKUP_MASK_BT_INTR_MASK_SHIFT)) & APU_BT2_WKUP_MASK_BT_INTR_MASK_MASK)

#define APU_BT2_WKUP_MASK_BT_PLL_REQ_MASK_MASK   (0x10U)
#define APU_BT2_WKUP_MASK_BT_PLL_REQ_MASK_SHIFT  (4U)
/*! BT_PLL_REQ_MASK - Bluetooth PLL Request Mask */
#define APU_BT2_WKUP_MASK_BT_PLL_REQ_MASK(x)     (((uint32_t)(((uint32_t)(x)) << APU_BT2_WKUP_MASK_BT_PLL_REQ_MASK_SHIFT)) & APU_BT2_WKUP_MASK_BT_PLL_REQ_MASK_MASK)

#define APU_BT2_WKUP_MASK_BRF_PLL_REQ_MASK_MASK  (0x20U)
#define APU_BT2_WKUP_MASK_BRF_PLL_REQ_MASK_SHIFT (5U)
/*! BRF_PLL_REQ_MASK - BRF PLL Request Mask */
#define APU_BT2_WKUP_MASK_BRF_PLL_REQ_MASK(x)    (((uint32_t)(((uint32_t)(x)) << APU_BT2_WKUP_MASK_BRF_PLL_REQ_MASK_SHIFT)) & APU_BT2_WKUP_MASK_BRF_PLL_REQ_MASK_MASK)

#define APU_BT2_WKUP_MASK_BT_HOST_MAP_MASK       (0xFFFF0000U)
#define APU_BT2_WKUP_MASK_BT_HOST_MAP_SHIFT      (16U)
/*! BT_HOST_MAP - Bluetooth Host Map */
#define APU_BT2_WKUP_MASK_BT_HOST_MAP(x)         (((uint32_t)(((uint32_t)(x)) << APU_BT2_WKUP_MASK_BT_HOST_MAP_SHIFT)) & APU_BT2_WKUP_MASK_BT_HOST_MAP_MASK)
/*! @} */

/*! @name BT2_STATUS - Bluetooth 2 Status */
/*! @{ */

#define APU_BT2_STATUS_APU_BT_CLK_EN_MASK        (0x1U)
#define APU_BT2_STATUS_APU_BT_CLK_EN_SHIFT       (0U)
/*! APU_BT_CLK_EN - APU Bluetooth Clock Enable */
#define APU_BT2_STATUS_APU_BT_CLK_EN(x)          (((uint32_t)(((uint32_t)(x)) << APU_BT2_STATUS_APU_BT_CLK_EN_SHIFT)) & APU_BT2_STATUS_APU_BT_CLK_EN_MASK)

#define APU_BT2_STATUS_APU_BRF_CLK_EN_MASK       (0x2U)
#define APU_BT2_STATUS_APU_BRF_CLK_EN_SHIFT      (1U)
/*! APU_BRF_CLK_EN - APU BRF Clock Enable */
#define APU_BT2_STATUS_APU_BRF_CLK_EN(x)         (((uint32_t)(((uint32_t)(x)) << APU_BT2_STATUS_APU_BRF_CLK_EN_SHIFT)) & APU_BT2_STATUS_APU_BRF_CLK_EN_MASK)

#define APU_BT2_STATUS_BT_ACTIVE_SLPCK_MASK      (0x4U)
#define APU_BT2_STATUS_BT_ACTIVE_SLPCK_SHIFT     (2U)
/*! BT_ACTIVE_SLPCK - Bluetooth Active Sleep Clock */
#define APU_BT2_STATUS_BT_ACTIVE_SLPCK(x)        (((uint32_t)(((uint32_t)(x)) << APU_BT2_STATUS_BT_ACTIVE_SLPCK_SHIFT)) & APU_BT2_STATUS_BT_ACTIVE_SLPCK_MASK)

#define APU_BT2_STATUS_BT_HOST_WKUP_MASK         (0x10U)
#define APU_BT2_STATUS_BT_HOST_WKUP_SHIFT        (4U)
/*! BT_HOST_WKUP - Bluetooth Host Wakeup */
#define APU_BT2_STATUS_BT_HOST_WKUP(x)           (((uint32_t)(((uint32_t)(x)) << APU_BT2_STATUS_BT_HOST_WKUP_SHIFT)) & APU_BT2_STATUS_BT_HOST_WKUP_MASK)

#define APU_BT2_STATUS_BT_INTERRUPT_MASK         (0x20U)
#define APU_BT2_STATUS_BT_INTERRUPT_SHIFT        (5U)
/*! BT_INTERRUPT - Bluetooth Interrupt */
#define APU_BT2_STATUS_BT_INTERRUPT(x)           (((uint32_t)(((uint32_t)(x)) << APU_BT2_STATUS_BT_INTERRUPT_SHIFT)) & APU_BT2_STATUS_BT_INTERRUPT_MASK)

#define APU_BT2_STATUS_BT_PLL_REQ_MASK           (0x40U)
#define APU_BT2_STATUS_BT_PLL_REQ_SHIFT          (6U)
/*! BT_PLL_REQ - Bluetooth PLL Request */
#define APU_BT2_STATUS_BT_PLL_REQ(x)             (((uint32_t)(((uint32_t)(x)) << APU_BT2_STATUS_BT_PLL_REQ_SHIFT)) & APU_BT2_STATUS_BT_PLL_REQ_MASK)

#define APU_BT2_STATUS_BT_CLK_REQ_MASK           (0x80U)
#define APU_BT2_STATUS_BT_CLK_REQ_SHIFT          (7U)
/*! BT_CLK_REQ - Bluetooth Clock Request */
#define APU_BT2_STATUS_BT_CLK_REQ(x)             (((uint32_t)(((uint32_t)(x)) << APU_BT2_STATUS_BT_CLK_REQ_SHIFT)) & APU_BT2_STATUS_BT_CLK_REQ_MASK)

#define APU_BT2_STATUS_BRF_PLL_REQ_MASK          (0x100U)
#define APU_BT2_STATUS_BRF_PLL_REQ_SHIFT         (8U)
/*! BRF_PLL_REQ - BRF PLL Request */
#define APU_BT2_STATUS_BRF_PLL_REQ(x)            (((uint32_t)(((uint32_t)(x)) << APU_BT2_STATUS_BRF_PLL_REQ_SHIFT)) & APU_BT2_STATUS_BRF_PLL_REQ_MASK)

#define APU_BT2_STATUS_BT_WIDEBAND_ACTIVE_MASK   (0x200U)
#define APU_BT2_STATUS_BT_WIDEBAND_ACTIVE_SHIFT  (9U)
/*! BT_WIDEBAND_ACTIVE - Bluetooth Wideband Active */
#define APU_BT2_STATUS_BT_WIDEBAND_ACTIVE(x)     (((uint32_t)(((uint32_t)(x)) << APU_BT2_STATUS_BT_WIDEBAND_ACTIVE_SHIFT)) & APU_BT2_STATUS_BT_WIDEBAND_ACTIVE_MASK)

#define APU_BT2_STATUS_HOST_WKUP_IN_MASK         (0xFFFF0000U)
#define APU_BT2_STATUS_HOST_WKUP_IN_SHIFT        (16U)
/*! HOST_WKUP_IN - Host Wakeup In */
#define APU_BT2_STATUS_HOST_WKUP_IN(x)           (((uint32_t)(((uint32_t)(x)) << APU_BT2_STATUS_HOST_WKUP_IN_SHIFT)) & APU_BT2_STATUS_HOST_WKUP_IN_MASK)
/*! @} */

/*! @name BT2_CKEN_CTRL - Bluetooth 2 Clock Enable Control */
/*! @{ */

#define APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_PWR_MASK (0x1U)
#define APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_PWR_SHIFT (0U)
/*! BT_CLK_EN_VAL_PWR - control value for bt_clk_en when power ready */
#define APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_PWR(x)   (((uint32_t)(((uint32_t)(x)) << APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_PWR_SHIFT)) & APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_PWR_MASK)

#define APU_BT2_CKEN_CTRL_BL_CLK_EN_SEL_PWR_MASK (0x2U)
#define APU_BT2_CKEN_CTRL_BL_CLK_EN_SEL_PWR_SHIFT (1U)
/*! BL_CLK_EN_SEL_PWR - selection for bt_clk_en when power ready */
#define APU_BT2_CKEN_CTRL_BL_CLK_EN_SEL_PWR(x)   (((uint32_t)(((uint32_t)(x)) << APU_BT2_CKEN_CTRL_BL_CLK_EN_SEL_PWR_SHIFT)) & APU_BT2_CKEN_CTRL_BL_CLK_EN_SEL_PWR_MASK)

#define APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_XOSC_MASK (0x4U)
#define APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_XOSC_SHIFT (2U)
/*! BT_CLK_EN_VAL_XOSC - control value for bt_clk_en when XOSC ready */
#define APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_XOSC(x)  (((uint32_t)(((uint32_t)(x)) << APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_XOSC_SHIFT)) & APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_XOSC_MASK)

#define APU_BT2_CKEN_CTRL_BT_CLK_EN_SEL_XOSC_MASK (0x8U)
#define APU_BT2_CKEN_CTRL_BT_CLK_EN_SEL_XOSC_SHIFT (3U)
/*! BT_CLK_EN_SEL_XOSC - selection for bt_clk_en when XOSC ready */
#define APU_BT2_CKEN_CTRL_BT_CLK_EN_SEL_XOSC(x)  (((uint32_t)(((uint32_t)(x)) << APU_BT2_CKEN_CTRL_BT_CLK_EN_SEL_XOSC_SHIFT)) & APU_BT2_CKEN_CTRL_BT_CLK_EN_SEL_XOSC_MASK)

#define APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_MASK     (0x10U)
#define APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_SHIFT    (4U)
/*! BT_CLK_EN_VAL - control value for bt_clk_en when PLL ready */
#define APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL(x)       (((uint32_t)(((uint32_t)(x)) << APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_SHIFT)) & APU_BT2_CKEN_CTRL_BT_CLK_EN_VAL_MASK)

#define APU_BT2_CKEN_CTRL_BT_CLK_EN_SEL_MASK     (0x20U)
#define APU_BT2_CKEN_CTRL_BT_CLK_EN_SEL_SHIFT    (5U)
/*! BT_CLK_EN_SEL - selection for bt_clk_en when PLL ready */
#define APU_BT2_CKEN_CTRL_BT_CLK_EN_SEL(x)       (((uint32_t)(((uint32_t)(x)) << APU_BT2_CKEN_CTRL_BT_CLK_EN_SEL_SHIFT)) & APU_BT2_CKEN_CTRL_BT_CLK_EN_SEL_MASK)
/*! @} */

/*! @name BT2_RESRC_CTRL - Bluetooth 2 RESRC Control */
/*! @{ */

#define APU_BT2_RESRC_CTRL_FW_PWR_REQ_MASK       (0x1U)
#define APU_BT2_RESRC_CTRL_FW_PWR_REQ_SHIFT      (0U)
/*! FW_PWR_REQ - override hw power request */
#define APU_BT2_RESRC_CTRL_FW_PWR_REQ(x)         (((uint32_t)(((uint32_t)(x)) << APU_BT2_RESRC_CTRL_FW_PWR_REQ_SHIFT)) & APU_BT2_RESRC_CTRL_FW_PWR_REQ_MASK)

#define APU_BT2_RESRC_CTRL_FW_PWR_REQ_VAL_MASK   (0x2U)
#define APU_BT2_RESRC_CTRL_FW_PWR_REQ_VAL_SHIFT  (1U)
/*! FW_PWR_REQ_VAL - override value when apu_bt_resrc_ctrl[0] is set */
#define APU_BT2_RESRC_CTRL_FW_PWR_REQ_VAL(x)     (((uint32_t)(((uint32_t)(x)) << APU_BT2_RESRC_CTRL_FW_PWR_REQ_VAL_SHIFT)) & APU_BT2_RESRC_CTRL_FW_PWR_REQ_VAL_MASK)

#define APU_BT2_RESRC_CTRL_FW_XOSC_REQ_MASK      (0x4U)
#define APU_BT2_RESRC_CTRL_FW_XOSC_REQ_SHIFT     (2U)
/*! FW_XOSC_REQ - override hw xosc request */
#define APU_BT2_RESRC_CTRL_FW_XOSC_REQ(x)        (((uint32_t)(((uint32_t)(x)) << APU_BT2_RESRC_CTRL_FW_XOSC_REQ_SHIFT)) & APU_BT2_RESRC_CTRL_FW_XOSC_REQ_MASK)

#define APU_BT2_RESRC_CTRL_FW_XOSC_REQ_VAL_MASK  (0x8U)
#define APU_BT2_RESRC_CTRL_FW_XOSC_REQ_VAL_SHIFT (3U)
/*! FW_XOSC_REQ_VAL - override value when apu_bt_resrc_ctrl[2] is set */
#define APU_BT2_RESRC_CTRL_FW_XOSC_REQ_VAL(x)    (((uint32_t)(((uint32_t)(x)) << APU_BT2_RESRC_CTRL_FW_XOSC_REQ_VAL_SHIFT)) & APU_BT2_RESRC_CTRL_FW_XOSC_REQ_VAL_MASK)

#define APU_BT2_RESRC_CTRL_FW_XP_REQ_MASK        (0x10U)
#define APU_BT2_RESRC_CTRL_FW_XP_REQ_SHIFT       (4U)
/*! FW_XP_REQ - override hw xosc + pwr request */
#define APU_BT2_RESRC_CTRL_FW_XP_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_BT2_RESRC_CTRL_FW_XP_REQ_SHIFT)) & APU_BT2_RESRC_CTRL_FW_XP_REQ_MASK)

#define APU_BT2_RESRC_CTRL_FW_XP_REQ_VAL_MASK    (0x20U)
#define APU_BT2_RESRC_CTRL_FW_XP_REQ_VAL_SHIFT   (5U)
/*! FW_XP_REQ_VAL - override value when apu_bt_resrc_ctrl[4] is set */
#define APU_BT2_RESRC_CTRL_FW_XP_REQ_VAL(x)      (((uint32_t)(((uint32_t)(x)) << APU_BT2_RESRC_CTRL_FW_XP_REQ_VAL_SHIFT)) & APU_BT2_RESRC_CTRL_FW_XP_REQ_VAL_MASK)

#define APU_BT2_RESRC_CTRL_FW_SB_REQ_MASK        (0x40U)
#define APU_BT2_RESRC_CTRL_FW_SB_REQ_SHIFT       (6U)
/*! FW_SB_REQ - override hw xosc + pwr + pll sb request */
#define APU_BT2_RESRC_CTRL_FW_SB_REQ(x)          (((uint32_t)(((uint32_t)(x)) << APU_BT2_RESRC_CTRL_FW_SB_REQ_SHIFT)) & APU_BT2_RESRC_CTRL_FW_SB_REQ_MASK)

#define APU_BT2_RESRC_CTRL_FW_SB_REQ_VAL_MASK    (0x80U)
#define APU_BT2_RESRC_CTRL_FW_SB_REQ_VAL_SHIFT   (7U)
/*! FW_SB_REQ_VAL - override value when apu_bt_resrc_ctrl[6] is set */
#define APU_BT2_RESRC_CTRL_FW_SB_REQ_VAL(x)      (((uint32_t)(((uint32_t)(x)) << APU_BT2_RESRC_CTRL_FW_SB_REQ_VAL_SHIFT)) & APU_BT2_RESRC_CTRL_FW_SB_REQ_VAL_MASK)

#define APU_BT2_RESRC_CTRL_FW_IPWAKE_REQ_MASK    (0x100U)
#define APU_BT2_RESRC_CTRL_FW_IPWAKE_REQ_SHIFT   (8U)
/*! FW_IPWAKE_REQ - override hw xosc + pwr + pll ipwake request */
#define APU_BT2_RESRC_CTRL_FW_IPWAKE_REQ(x)      (((uint32_t)(((uint32_t)(x)) << APU_BT2_RESRC_CTRL_FW_IPWAKE_REQ_SHIFT)) & APU_BT2_RESRC_CTRL_FW_IPWAKE_REQ_MASK)

#define APU_BT2_RESRC_CTRL_FW_IPWAKE_REQ_VAL_MASK (0x200U)
#define APU_BT2_RESRC_CTRL_FW_IPWAKE_REQ_VAL_SHIFT (9U)
/*! FW_IPWAKE_REQ_VAL - override value when apu_bt_resrc_ctrl[8] is set */
#define APU_BT2_RESRC_CTRL_FW_IPWAKE_REQ_VAL(x)  (((uint32_t)(((uint32_t)(x)) << APU_BT2_RESRC_CTRL_FW_IPWAKE_REQ_VAL_SHIFT)) & APU_BT2_RESRC_CTRL_FW_IPWAKE_REQ_VAL_MASK)

#define APU_BT2_RESRC_CTRL_FW_ALLWAKE_REQ_MASK   (0x400U)
#define APU_BT2_RESRC_CTRL_FW_ALLWAKE_REQ_SHIFT  (10U)
/*! FW_ALLWAKE_REQ - firmware override hw xosc + pwr + pll allwake request */
#define APU_BT2_RESRC_CTRL_FW_ALLWAKE_REQ(x)     (((uint32_t)(((uint32_t)(x)) << APU_BT2_RESRC_CTRL_FW_ALLWAKE_REQ_SHIFT)) & APU_BT2_RESRC_CTRL_FW_ALLWAKE_REQ_MASK)

#define APU_BT2_RESRC_CTRL_FW_ALLWAKE_REQ_VAL_MASK (0x800U)
#define APU_BT2_RESRC_CTRL_FW_ALLWAKE_REQ_VAL_SHIFT (11U)
/*! FW_ALLWAKE_REQ_VAL - firmware override value when apu_bt_resrc_ctrl[10] is set */
#define APU_BT2_RESRC_CTRL_FW_ALLWAKE_REQ_VAL(x) (((uint32_t)(((uint32_t)(x)) << APU_BT2_RESRC_CTRL_FW_ALLWAKE_REQ_VAL_SHIFT)) & APU_BT2_RESRC_CTRL_FW_ALLWAKE_REQ_VAL_MASK)
/*! @} */

/*! @name BT2_DVFS_CTRL - Bluetooth 2 DVFS Control */
/*! @{ */

#define APU_BT2_DVFS_CTRL_BT_VOL_VAL_MASK        (0x7FU)
#define APU_BT2_DVFS_CTRL_BT_VOL_VAL_SHIFT       (0U)
/*! BT_VOL_VAL - Blueooth Vol Value */
#define APU_BT2_DVFS_CTRL_BT_VOL_VAL(x)          (((uint32_t)(((uint32_t)(x)) << APU_BT2_DVFS_CTRL_BT_VOL_VAL_SHIFT)) & APU_BT2_DVFS_CTRL_BT_VOL_VAL_MASK)
/*! @} */

/*! @name BLE2_CTRL - BLE 2 Control */
/*! @{ */

#define APU_BLE2_CTRL_BLE_SLP_RDY_MASK           (0x1U)
#define APU_BLE2_CTRL_BLE_SLP_RDY_SHIFT          (0U)
/*! BLE_SLP_RDY - BLE Sleep Ready */
#define APU_BLE2_CTRL_BLE_SLP_RDY(x)             (((uint32_t)(((uint32_t)(x)) << APU_BLE2_CTRL_BLE_SLP_RDY_SHIFT)) & APU_BLE2_CTRL_BLE_SLP_RDY_MASK)

#define APU_BLE2_CTRL_BLE_SLP_RDYMASK_MASK       (0x2U)
#define APU_BLE2_CTRL_BLE_SLP_RDYMASK_SHIFT      (1U)
/*! BLE_SLP_RDYMASK - BLE Sleep Ready Mask */
#define APU_BLE2_CTRL_BLE_SLP_RDYMASK(x)         (((uint32_t)(((uint32_t)(x)) << APU_BLE2_CTRL_BLE_SLP_RDYMASK_SHIFT)) & APU_BLE2_CTRL_BLE_SLP_RDYMASK_MASK)

#define APU_BLE2_CTRL_BLE_SLP_RDY_FW_MASK        (0x4U)
#define APU_BLE2_CTRL_BLE_SLP_RDY_FW_SHIFT       (2U)
/*! BLE_SLP_RDY_FW - BLE Sleep Ready FW */
#define APU_BLE2_CTRL_BLE_SLP_RDY_FW(x)          (((uint32_t)(((uint32_t)(x)) << APU_BLE2_CTRL_BLE_SLP_RDY_FW_SHIFT)) & APU_BLE2_CTRL_BLE_SLP_RDY_FW_MASK)

#define APU_BLE2_CTRL_BLE_MODE_EN_MASK           (0x8U)
#define APU_BLE2_CTRL_BLE_MODE_EN_SHIFT          (3U)
/*! BLE_MODE_EN - BLE Mode Enable */
#define APU_BLE2_CTRL_BLE_MODE_EN(x)             (((uint32_t)(((uint32_t)(x)) << APU_BLE2_CTRL_BLE_MODE_EN_SHIFT)) & APU_BLE2_CTRL_BLE_MODE_EN_MASK)

#define APU_BLE2_CTRL_BT_AES_NCO_MODE_MASK       (0x8000U)
#define APU_BLE2_CTRL_BT_AES_NCO_MODE_SHIFT      (15U)
/*! BT_AES_NCO_MODE - Bluetooth AES NCO Mode */
#define APU_BLE2_CTRL_BT_AES_NCO_MODE(x)         (((uint32_t)(((uint32_t)(x)) << APU_BLE2_CTRL_BT_AES_NCO_MODE_SHIFT)) & APU_BLE2_CTRL_BT_AES_NCO_MODE_MASK)

#define APU_BLE2_CTRL_BLE_XP_REQ_MASK            (0x80000000U)
#define APU_BLE2_CTRL_BLE_XP_REQ_SHIFT           (31U)
/*! BLE_XP_REQ - BLE XP Request */
#define APU_BLE2_CTRL_BLE_XP_REQ(x)              (((uint32_t)(((uint32_t)(x)) << APU_BLE2_CTRL_BLE_XP_REQ_SHIFT)) & APU_BLE2_CTRL_BLE_XP_REQ_MASK)
/*! @} */

/*! @name BLE2_WKUP_MASK - BLE 2 Wakeup Mask */
/*! @{ */

#define APU_BLE2_WKUP_MASK_BT_AES_CLK_REQ_MASK_MASK (0x8U)
#define APU_BLE2_WKUP_MASK_BT_AES_CLK_REQ_MASK_SHIFT (3U)
/*! BT_AES_CLK_REQ_MASK - Bluetooth AES Clock Request Mask */
#define APU_BLE2_WKUP_MASK_BT_AES_CLK_REQ_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_BLE2_WKUP_MASK_BT_AES_CLK_REQ_MASK_SHIFT)) & APU_BLE2_WKUP_MASK_BT_AES_CLK_REQ_MASK_MASK)

#define APU_BLE2_WKUP_MASK_LBC_XP_REQ_MASK_MASK  (0x10U)
#define APU_BLE2_WKUP_MASK_LBC_XP_REQ_MASK_SHIFT (4U)
/*! LBC_XP_REQ_MASK - LBC XP Request Mask */
#define APU_BLE2_WKUP_MASK_LBC_XP_REQ_MASK(x)    (((uint32_t)(((uint32_t)(x)) << APU_BLE2_WKUP_MASK_LBC_XP_REQ_MASK_SHIFT)) & APU_BLE2_WKUP_MASK_LBC_XP_REQ_MASK_MASK)
/*! @} */

/*! @name BLE2_STATUS - BLE 2 Status */
/*! @{ */

#define APU_BLE2_STATUS_APU_BT_AES_CLK_EN_MASK   (0x1U)
#define APU_BLE2_STATUS_APU_BT_AES_CLK_EN_SHIFT  (0U)
/*! APU_BT_AES_CLK_EN - APU Bluetooth AES Clock Enable */
#define APU_BLE2_STATUS_APU_BT_AES_CLK_EN(x)     (((uint32_t)(((uint32_t)(x)) << APU_BLE2_STATUS_APU_BT_AES_CLK_EN_SHIFT)) & APU_BLE2_STATUS_APU_BT_AES_CLK_EN_MASK)

#define APU_BLE2_STATUS_BT_AES_CLK_SEL_MASK      (0x2U)
#define APU_BLE2_STATUS_BT_AES_CLK_SEL_SHIFT     (1U)
/*! BT_AES_CLK_SEL - Bluetooth AES Clock Select */
#define APU_BLE2_STATUS_BT_AES_CLK_SEL(x)        (((uint32_t)(((uint32_t)(x)) << APU_BLE2_STATUS_BT_AES_CLK_SEL_SHIFT)) & APU_BLE2_STATUS_BT_AES_CLK_SEL_MASK)

#define APU_BLE2_STATUS_XOSC_STABLE_REFCK_MASK   (0x4U)
#define APU_BLE2_STATUS_XOSC_STABLE_REFCK_SHIFT  (2U)
/*! XOSC_STABLE_REFCK - XOSC Stable Ref Clock */
#define APU_BLE2_STATUS_XOSC_STABLE_REFCK(x)     (((uint32_t)(((uint32_t)(x)) << APU_BLE2_STATUS_XOSC_STABLE_REFCK_SHIFT)) & APU_BLE2_STATUS_XOSC_STABLE_REFCK_MASK)

#define APU_BLE2_STATUS_T1_STABLE_MASK           (0x8U)
#define APU_BLE2_STATUS_T1_STABLE_SHIFT          (3U)
/*! T1_STABLE - T1 Delay */
#define APU_BLE2_STATUS_T1_STABLE(x)             (((uint32_t)(((uint32_t)(x)) << APU_BLE2_STATUS_T1_STABLE_SHIFT)) & APU_BLE2_STATUS_T1_STABLE_MASK)

#define APU_BLE2_STATUS_BT_INTERRUPT_MASK        (0x10U)
#define APU_BLE2_STATUS_BT_INTERRUPT_SHIFT       (4U)
/*! BT_INTERRUPT - Bluetooth Interrupt */
#define APU_BLE2_STATUS_BT_INTERRUPT(x)          (((uint32_t)(((uint32_t)(x)) << APU_BLE2_STATUS_BT_INTERRUPT_SHIFT)) & APU_BLE2_STATUS_BT_INTERRUPT_MASK)

#define APU_BLE2_STATUS_BLE_XP_REQ_MASK          (0x20U)
#define APU_BLE2_STATUS_BLE_XP_REQ_SHIFT         (5U)
/*! BLE_XP_REQ - BLE XP Request */
#define APU_BLE2_STATUS_BLE_XP_REQ(x)            (((uint32_t)(((uint32_t)(x)) << APU_BLE2_STATUS_BLE_XP_REQ_SHIFT)) & APU_BLE2_STATUS_BLE_XP_REQ_MASK)

#define APU_BLE2_STATUS_BT_AES_NCO_MODE_MASK     (0x40U)
#define APU_BLE2_STATUS_BT_AES_NCO_MODE_SHIFT    (6U)
/*! BT_AES_NCO_MODE - Blueooth AES NCO Mode */
#define APU_BLE2_STATUS_BT_AES_NCO_MODE(x)       (((uint32_t)(((uint32_t)(x)) << APU_BLE2_STATUS_BT_AES_NCO_MODE_SHIFT)) & APU_BLE2_STATUS_BT_AES_NCO_MODE_MASK)

#define APU_BLE2_STATUS_LBC_XP_REQ_MASK          (0x100U)
#define APU_BLE2_STATUS_LBC_XP_REQ_SHIFT         (8U)
/*! LBC_XP_REQ - LBC XP Request */
#define APU_BLE2_STATUS_LBC_XP_REQ(x)            (((uint32_t)(((uint32_t)(x)) << APU_BLE2_STATUS_LBC_XP_REQ_SHIFT)) & APU_BLE2_STATUS_LBC_XP_REQ_MASK)

#define APU_BLE2_STATUS_BT_AES_CLK_REQ_MASK      (0x200U)
#define APU_BLE2_STATUS_BT_AES_CLK_REQ_SHIFT     (9U)
/*! BT_AES_CLK_REQ - Bluetooth AES Clock Request Mask */
#define APU_BLE2_STATUS_BT_AES_CLK_REQ(x)        (((uint32_t)(((uint32_t)(x)) << APU_BLE2_STATUS_BT_AES_CLK_REQ_SHIFT)) & APU_BLE2_STATUS_BT_AES_CLK_REQ_MASK)
/*! @} */

/*! @name LMU_IP_REVISION - LMU IP Revision */
/*! @{ */

#define APU_LMU_IP_REVISION_IP_REV_MASK          (0xFFFFU)
#define APU_LMU_IP_REVISION_IP_REV_SHIFT         (0U)
/*! IP_REV - IP Revision */
#define APU_LMU_IP_REVISION_IP_REV(x)            (((uint32_t)(((uint32_t)(x)) << APU_LMU_IP_REVISION_IP_REV_SHIFT)) & APU_LMU_IP_REVISION_IP_REV_MASK)
/*! @} */

/*! @name LMU_CPU1_STA_CFG - LMU CPU1 STA Configuration */
/*! @{ */

#define APU_LMU_CPU1_STA_CFG_BANK0_STA_OFF_EN_MASK (0x1U)
#define APU_LMU_CPU1_STA_CFG_BANK0_STA_OFF_EN_SHIFT (0U)
/*! BANK0_STA_OFF_EN - Bank0 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK0_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK0_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK0_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED15_MASK     (0x2U)
#define APU_LMU_CPU1_STA_CFG_RESERVED15_SHIFT    (1U)
/*! RESERVED15 - Reserved 15 */
#define APU_LMU_CPU1_STA_CFG_RESERVED15(x)       (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED15_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED15_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK1_STA_OFF_EN_MASK (0x4U)
#define APU_LMU_CPU1_STA_CFG_BANK1_STA_OFF_EN_SHIFT (2U)
/*! BANK1_STA_OFF_EN - Bank1 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK1_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK1_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK1_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED14_MASK     (0x8U)
#define APU_LMU_CPU1_STA_CFG_RESERVED14_SHIFT    (3U)
/*! RESERVED14 - Reserved 14 */
#define APU_LMU_CPU1_STA_CFG_RESERVED14(x)       (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED14_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED14_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK2_STA_OFF_EN_MASK (0x10U)
#define APU_LMU_CPU1_STA_CFG_BANK2_STA_OFF_EN_SHIFT (4U)
/*! BANK2_STA_OFF_EN - Bank2 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK2_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK2_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK2_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED13_MASK     (0x20U)
#define APU_LMU_CPU1_STA_CFG_RESERVED13_SHIFT    (5U)
/*! RESERVED13 - Reserved 13 */
#define APU_LMU_CPU1_STA_CFG_RESERVED13(x)       (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED13_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED13_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK3_STA_OFF_EN_MASK (0x40U)
#define APU_LMU_CPU1_STA_CFG_BANK3_STA_OFF_EN_SHIFT (6U)
/*! BANK3_STA_OFF_EN - Bank3 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK3_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK3_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK3_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED12_MASK     (0x80U)
#define APU_LMU_CPU1_STA_CFG_RESERVED12_SHIFT    (7U)
/*! RESERVED12 - Reserved 12 */
#define APU_LMU_CPU1_STA_CFG_RESERVED12(x)       (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED12_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED12_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK4_STA_OFF_EN_MASK (0x100U)
#define APU_LMU_CPU1_STA_CFG_BANK4_STA_OFF_EN_SHIFT (8U)
/*! BANK4_STA_OFF_EN - Bank4 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK4_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK4_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK4_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED11_MASK     (0x200U)
#define APU_LMU_CPU1_STA_CFG_RESERVED11_SHIFT    (9U)
/*! RESERVED11 - Reserved 11 */
#define APU_LMU_CPU1_STA_CFG_RESERVED11(x)       (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED11_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED11_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK5_STA_OFF_EN_MASK (0x400U)
#define APU_LMU_CPU1_STA_CFG_BANK5_STA_OFF_EN_SHIFT (10U)
/*! BANK5_STA_OFF_EN - Bank5 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK5_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK5_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK5_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED10_MASK     (0x800U)
#define APU_LMU_CPU1_STA_CFG_RESERVED10_SHIFT    (11U)
/*! RESERVED10 - Reserved 10 */
#define APU_LMU_CPU1_STA_CFG_RESERVED10(x)       (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED10_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED10_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK6_STA_OFF_EN_MASK (0x1000U)
#define APU_LMU_CPU1_STA_CFG_BANK6_STA_OFF_EN_SHIFT (12U)
/*! BANK6_STA_OFF_EN - Bank6 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK6_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK6_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK6_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED9_MASK      (0x2000U)
#define APU_LMU_CPU1_STA_CFG_RESERVED9_SHIFT     (13U)
/*! RESERVED9 - Reserved 9 */
#define APU_LMU_CPU1_STA_CFG_RESERVED9(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED9_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED9_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK7_STA_OFF_EN_MASK (0x4000U)
#define APU_LMU_CPU1_STA_CFG_BANK7_STA_OFF_EN_SHIFT (14U)
/*! BANK7_STA_OFF_EN - Bank7 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK7_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK7_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK7_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED8_MASK      (0x8000U)
#define APU_LMU_CPU1_STA_CFG_RESERVED8_SHIFT     (15U)
/*! RESERVED8 - Reserved 8 */
#define APU_LMU_CPU1_STA_CFG_RESERVED8(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED8_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED8_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK8_STA_OFF_EN_MASK (0x10000U)
#define APU_LMU_CPU1_STA_CFG_BANK8_STA_OFF_EN_SHIFT (16U)
/*! BANK8_STA_OFF_EN - Bank8 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK8_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK8_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK8_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED7_MASK      (0x20000U)
#define APU_LMU_CPU1_STA_CFG_RESERVED7_SHIFT     (17U)
/*! RESERVED7 - Reserved 7 */
#define APU_LMU_CPU1_STA_CFG_RESERVED7(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED7_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED7_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK9_STA_OFF_EN_MASK (0x40000U)
#define APU_LMU_CPU1_STA_CFG_BANK9_STA_OFF_EN_SHIFT (18U)
/*! BANK9_STA_OFF_EN - Bank9 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK9_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK9_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK9_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED6_MASK      (0x80000U)
#define APU_LMU_CPU1_STA_CFG_RESERVED6_SHIFT     (19U)
/*! RESERVED6 - Reserved 6 */
#define APU_LMU_CPU1_STA_CFG_RESERVED6(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED6_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED6_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK10_STA_OFF_EN_MASK (0x100000U)
#define APU_LMU_CPU1_STA_CFG_BANK10_STA_OFF_EN_SHIFT (20U)
/*! BANK10_STA_OFF_EN - Bank10 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK10_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK10_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK10_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED5_MASK      (0x200000U)
#define APU_LMU_CPU1_STA_CFG_RESERVED5_SHIFT     (21U)
/*! RESERVED5 - Reserved 5 */
#define APU_LMU_CPU1_STA_CFG_RESERVED5(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED5_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED5_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK11_STA_OFF_EN_MASK (0x400000U)
#define APU_LMU_CPU1_STA_CFG_BANK11_STA_OFF_EN_SHIFT (22U)
/*! BANK11_STA_OFF_EN - Bank11 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK11_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK11_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK11_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED4_MASK      (0x800000U)
#define APU_LMU_CPU1_STA_CFG_RESERVED4_SHIFT     (23U)
/*! RESERVED4 - Reserved 4 */
#define APU_LMU_CPU1_STA_CFG_RESERVED4(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED4_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED4_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK12_STA_OFF_EN_MASK (0x1000000U)
#define APU_LMU_CPU1_STA_CFG_BANK12_STA_OFF_EN_SHIFT (24U)
/*! BANK12_STA_OFF_EN - Bank12 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK12_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK12_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK12_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED3_MASK      (0x2000000U)
#define APU_LMU_CPU1_STA_CFG_RESERVED3_SHIFT     (25U)
/*! RESERVED3 - Reserved 3 */
#define APU_LMU_CPU1_STA_CFG_RESERVED3(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED3_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED3_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK13_STA_OFF_EN_MASK (0x4000000U)
#define APU_LMU_CPU1_STA_CFG_BANK13_STA_OFF_EN_SHIFT (26U)
/*! BANK13_STA_OFF_EN - Bank13 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK13_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK13_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK13_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED2_MASK      (0x8000000U)
#define APU_LMU_CPU1_STA_CFG_RESERVED2_SHIFT     (27U)
/*! RESERVED2 - Reserved 2 */
#define APU_LMU_CPU1_STA_CFG_RESERVED2(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED2_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED2_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK14_STA_OFF_EN_MASK (0x10000000U)
#define APU_LMU_CPU1_STA_CFG_BANK14_STA_OFF_EN_SHIFT (28U)
/*! BANK14_STA_OFF_EN - Bank14 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK14_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK14_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK14_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED1_MASK      (0x20000000U)
#define APU_LMU_CPU1_STA_CFG_RESERVED1_SHIFT     (29U)
/*! RESERVED1 - Reserved 1 */
#define APU_LMU_CPU1_STA_CFG_RESERVED1(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED1_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED1_MASK)

#define APU_LMU_CPU1_STA_CFG_BANK15_STA_OFF_EN_MASK (0x40000000U)
#define APU_LMU_CPU1_STA_CFG_BANK15_STA_OFF_EN_SHIFT (30U)
/*! BANK15_STA_OFF_EN - Bank15 STA Off Enable */
#define APU_LMU_CPU1_STA_CFG_BANK15_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_BANK15_STA_OFF_EN_SHIFT)) & APU_LMU_CPU1_STA_CFG_BANK15_STA_OFF_EN_MASK)

#define APU_LMU_CPU1_STA_CFG_RESERVED0_MASK      (0x80000000U)
#define APU_LMU_CPU1_STA_CFG_RESERVED0_SHIFT     (31U)
/*! RESERVED0 - Reserved 0 */
#define APU_LMU_CPU1_STA_CFG_RESERVED0(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_CFG_RESERVED0_SHIFT)) & APU_LMU_CPU1_STA_CFG_RESERVED0_MASK)
/*! @} */

/*! @name LMU_CPU1_STA_STATUS1 - LMU CPU1 STA Status 1 */
/*! @{ */

#define APU_LMU_CPU1_STA_STATUS1_BANK0_FSM_ST_REP_DONE_MASK (0x1U)
#define APU_LMU_CPU1_STA_STATUS1_BANK0_FSM_ST_REP_DONE_SHIFT (0U)
/*! BANK0_FSM_ST_REP_DONE - Bank0 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS1_BANK0_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK0_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK0_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK0_FSM_ST_MASK (0xEU)
#define APU_LMU_CPU1_STA_STATUS1_BANK0_FSM_ST_SHIFT (1U)
/*! BANK0_FSM_ST - Bank0 FSM St */
#define APU_LMU_CPU1_STA_STATUS1_BANK0_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK0_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK0_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK1_FSM_ST_REP_DONE_MASK (0x10U)
#define APU_LMU_CPU1_STA_STATUS1_BANK1_FSM_ST_REP_DONE_SHIFT (4U)
/*! BANK1_FSM_ST_REP_DONE - Bank1FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS1_BANK1_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK1_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK1_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK1_FSM_ST_MASK (0xE0U)
#define APU_LMU_CPU1_STA_STATUS1_BANK1_FSM_ST_SHIFT (5U)
/*! BANK1_FSM_ST - Bank1 FSM St */
#define APU_LMU_CPU1_STA_STATUS1_BANK1_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK1_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK1_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK2_FSM_ST_REP_DONE_MASK (0x100U)
#define APU_LMU_CPU1_STA_STATUS1_BANK2_FSM_ST_REP_DONE_SHIFT (8U)
/*! BANK2_FSM_ST_REP_DONE - Bank2 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS1_BANK2_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK2_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK2_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK2_FSM_ST_MASK (0xE00U)
#define APU_LMU_CPU1_STA_STATUS1_BANK2_FSM_ST_SHIFT (9U)
/*! BANK2_FSM_ST - Bank2 FSM St */
#define APU_LMU_CPU1_STA_STATUS1_BANK2_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK2_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK2_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK3_FSM_ST_REP_DONE_MASK (0x1000U)
#define APU_LMU_CPU1_STA_STATUS1_BANK3_FSM_ST_REP_DONE_SHIFT (12U)
/*! BANK3_FSM_ST_REP_DONE - Bank3 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS1_BANK3_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK3_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK3_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK3_FSM_ST_MASK (0xE000U)
#define APU_LMU_CPU1_STA_STATUS1_BANK3_FSM_ST_SHIFT (13U)
/*! BANK3_FSM_ST - Bank3 FSM St */
#define APU_LMU_CPU1_STA_STATUS1_BANK3_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK3_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK3_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK4_FSM_ST_REP_DONE_MASK (0x10000U)
#define APU_LMU_CPU1_STA_STATUS1_BANK4_FSM_ST_REP_DONE_SHIFT (16U)
/*! BANK4_FSM_ST_REP_DONE - Bank4 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS1_BANK4_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK4_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK4_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK4_FSM_ST_MASK (0xE0000U)
#define APU_LMU_CPU1_STA_STATUS1_BANK4_FSM_ST_SHIFT (17U)
/*! BANK4_FSM_ST - Bank4 FSM St */
#define APU_LMU_CPU1_STA_STATUS1_BANK4_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK4_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK4_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK5_FSM_ST_REP_DONE_MASK (0x100000U)
#define APU_LMU_CPU1_STA_STATUS1_BANK5_FSM_ST_REP_DONE_SHIFT (20U)
/*! BANK5_FSM_ST_REP_DONE - Bank5 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS1_BANK5_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK5_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK5_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK5_FSM_ST_MASK (0xE00000U)
#define APU_LMU_CPU1_STA_STATUS1_BANK5_FSM_ST_SHIFT (21U)
/*! BANK5_FSM_ST - Bank5 FSM St */
#define APU_LMU_CPU1_STA_STATUS1_BANK5_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK5_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK5_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK6_FSM_ST_REP_DONE_MASK (0x1000000U)
#define APU_LMU_CPU1_STA_STATUS1_BANK6_FSM_ST_REP_DONE_SHIFT (24U)
/*! BANK6_FSM_ST_REP_DONE - Bank6 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS1_BANK6_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK6_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK6_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK6_FSM_ST_MASK (0xE000000U)
#define APU_LMU_CPU1_STA_STATUS1_BANK6_FSM_ST_SHIFT (25U)
/*! BANK6_FSM_ST - Bank6 FSM St */
#define APU_LMU_CPU1_STA_STATUS1_BANK6_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK6_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK6_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK7_FSM_ST_REP_DONE_MASK (0x10000000U)
#define APU_LMU_CPU1_STA_STATUS1_BANK7_FSM_ST_REP_DONE_SHIFT (28U)
/*! BANK7_FSM_ST_REP_DONE - Bank7 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS1_BANK7_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK7_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK7_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS1_BANK7_FSM_ST_MASK (0xE0000000U)
#define APU_LMU_CPU1_STA_STATUS1_BANK7_FSM_ST_SHIFT (29U)
/*! BANK7_FSM_ST - Bank7 FSM St */
#define APU_LMU_CPU1_STA_STATUS1_BANK7_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS1_BANK7_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS1_BANK7_FSM_ST_MASK)
/*! @} */

/*! @name LMU_CPU1_STA_STATUS2 - LMU CPU1 STA Status 2 */
/*! @{ */

#define APU_LMU_CPU1_STA_STATUS2_BANK8_FSM_ST_REP_DONE_MASK (0x1U)
#define APU_LMU_CPU1_STA_STATUS2_BANK8_FSM_ST_REP_DONE_SHIFT (0U)
/*! BANK8_FSM_ST_REP_DONE - Bank8 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS2_BANK8_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK8_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK8_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK8_FSM_ST_MASK (0xEU)
#define APU_LMU_CPU1_STA_STATUS2_BANK8_FSM_ST_SHIFT (1U)
/*! BANK8_FSM_ST - Bank8 FSM St */
#define APU_LMU_CPU1_STA_STATUS2_BANK8_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK8_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK8_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK9_FSM_ST_REP_DONE_MASK (0x10U)
#define APU_LMU_CPU1_STA_STATUS2_BANK9_FSM_ST_REP_DONE_SHIFT (4U)
/*! BANK9_FSM_ST_REP_DONE - Bank9 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS2_BANK9_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK9_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK9_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK9_FSM_ST_MASK (0xE0U)
#define APU_LMU_CPU1_STA_STATUS2_BANK9_FSM_ST_SHIFT (5U)
/*! BANK9_FSM_ST - Bank9 FSM St */
#define APU_LMU_CPU1_STA_STATUS2_BANK9_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK9_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK9_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK10_FSM_ST_REP_DONE_MASK (0x100U)
#define APU_LMU_CPU1_STA_STATUS2_BANK10_FSM_ST_REP_DONE_SHIFT (8U)
/*! BANK10_FSM_ST_REP_DONE - Bank10 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS2_BANK10_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK10_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK10_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK10_FSM_ST_MASK (0xE00U)
#define APU_LMU_CPU1_STA_STATUS2_BANK10_FSM_ST_SHIFT (9U)
/*! BANK10_FSM_ST - Bank10 FSM St */
#define APU_LMU_CPU1_STA_STATUS2_BANK10_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK10_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK10_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK11_FSM_ST_REP_DONE_MASK (0x1000U)
#define APU_LMU_CPU1_STA_STATUS2_BANK11_FSM_ST_REP_DONE_SHIFT (12U)
/*! BANK11_FSM_ST_REP_DONE - Bank11 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS2_BANK11_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK11_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK11_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK11_FSM_ST_MASK (0xE000U)
#define APU_LMU_CPU1_STA_STATUS2_BANK11_FSM_ST_SHIFT (13U)
/*! BANK11_FSM_ST - Bank11 FSM St */
#define APU_LMU_CPU1_STA_STATUS2_BANK11_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK11_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK11_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK12_FSM_ST_REP_DONE_MASK (0x10000U)
#define APU_LMU_CPU1_STA_STATUS2_BANK12_FSM_ST_REP_DONE_SHIFT (16U)
/*! BANK12_FSM_ST_REP_DONE - Bank12 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS2_BANK12_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK12_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK12_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK12_FSM_ST_MASK (0xE0000U)
#define APU_LMU_CPU1_STA_STATUS2_BANK12_FSM_ST_SHIFT (17U)
/*! BANK12_FSM_ST - Bank12 FSM St */
#define APU_LMU_CPU1_STA_STATUS2_BANK12_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK12_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK12_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK13_FSM_ST_REP_DONE_MASK (0x100000U)
#define APU_LMU_CPU1_STA_STATUS2_BANK13_FSM_ST_REP_DONE_SHIFT (20U)
/*! BANK13_FSM_ST_REP_DONE - Bank13 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS2_BANK13_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK13_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK13_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK13_FSM_ST_MASK (0xE00000U)
#define APU_LMU_CPU1_STA_STATUS2_BANK13_FSM_ST_SHIFT (21U)
/*! BANK13_FSM_ST - Bank13 FSM St */
#define APU_LMU_CPU1_STA_STATUS2_BANK13_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK13_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK13_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK14_FSM_ST_REP_DONE_MASK (0x1000000U)
#define APU_LMU_CPU1_STA_STATUS2_BANK14_FSM_ST_REP_DONE_SHIFT (24U)
/*! BANK14_FSM_ST_REP_DONE - Bank14 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS2_BANK14_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK14_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK14_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK14_FSM_ST_MASK (0xE000000U)
#define APU_LMU_CPU1_STA_STATUS2_BANK14_FSM_ST_SHIFT (25U)
/*! BANK14_FSM_ST - Bank14 FSM St */
#define APU_LMU_CPU1_STA_STATUS2_BANK14_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK14_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK14_FSM_ST_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK15_FSM_ST_REP_DONE_MASK (0x10000000U)
#define APU_LMU_CPU1_STA_STATUS2_BANK15_FSM_ST_REP_DONE_SHIFT (28U)
/*! BANK15_FSM_ST_REP_DONE - Bank15 FSM St Rep Done */
#define APU_LMU_CPU1_STA_STATUS2_BANK15_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK15_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK15_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU1_STA_STATUS2_BANK15_FSM_ST_MASK (0xE0000000U)
#define APU_LMU_CPU1_STA_STATUS2_BANK15_FSM_ST_SHIFT (29U)
/*! BANK15_FSM_ST - Bank15 FSM St */
#define APU_LMU_CPU1_STA_STATUS2_BANK15_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_STA_STATUS2_BANK15_FSM_ST_SHIFT)) & APU_LMU_CPU1_STA_STATUS2_BANK15_FSM_ST_MASK)
/*! @} */

/*! @name LMU_CPU1_DYN_CTRL - LMU CPU1 Dynamic Control */
/*! @{ */

#define APU_LMU_CPU1_DYN_CTRL_BANK0_DYN_MODE_EN_MASK (0x1U)
#define APU_LMU_CPU1_DYN_CTRL_BANK0_DYN_MODE_EN_SHIFT (0U)
/*! BANK0_DYN_MODE_EN - Bank0 Dynamic Mode Enable */
#define APU_LMU_CPU1_DYN_CTRL_BANK0_DYN_MODE_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_CTRL_BANK0_DYN_MODE_EN_SHIFT)) & APU_LMU_CPU1_DYN_CTRL_BANK0_DYN_MODE_EN_MASK)

#define APU_LMU_CPU1_DYN_CTRL_BANK0_DYN_PD_MASK  (0x2U)
#define APU_LMU_CPU1_DYN_CTRL_BANK0_DYN_PD_SHIFT (1U)
/*! BANK0_DYN_PD - Bank0 Dynamic Powerdown */
#define APU_LMU_CPU1_DYN_CTRL_BANK0_DYN_PD(x)    (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_CTRL_BANK0_DYN_PD_SHIFT)) & APU_LMU_CPU1_DYN_CTRL_BANK0_DYN_PD_MASK)

#define APU_LMU_CPU1_DYN_CTRL_RESERVED3_MASK     (0xCU)
#define APU_LMU_CPU1_DYN_CTRL_RESERVED3_SHIFT    (2U)
/*! RESERVED3 - Reserved 3 */
#define APU_LMU_CPU1_DYN_CTRL_RESERVED3(x)       (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_CTRL_RESERVED3_SHIFT)) & APU_LMU_CPU1_DYN_CTRL_RESERVED3_MASK)

#define APU_LMU_CPU1_DYN_CTRL_BANK1_DYN_MODE_EN_MASK (0x10U)
#define APU_LMU_CPU1_DYN_CTRL_BANK1_DYN_MODE_EN_SHIFT (4U)
/*! BANK1_DYN_MODE_EN - Bank1 Dynamic Mode Enable */
#define APU_LMU_CPU1_DYN_CTRL_BANK1_DYN_MODE_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_CTRL_BANK1_DYN_MODE_EN_SHIFT)) & APU_LMU_CPU1_DYN_CTRL_BANK1_DYN_MODE_EN_MASK)

#define APU_LMU_CPU1_DYN_CTRL_BANK1_DYN_PD_MASK  (0x20U)
#define APU_LMU_CPU1_DYN_CTRL_BANK1_DYN_PD_SHIFT (5U)
/*! BANK1_DYN_PD - Bank1 Dynamic Powerdown */
#define APU_LMU_CPU1_DYN_CTRL_BANK1_DYN_PD(x)    (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_CTRL_BANK1_DYN_PD_SHIFT)) & APU_LMU_CPU1_DYN_CTRL_BANK1_DYN_PD_MASK)

#define APU_LMU_CPU1_DYN_CTRL_RESERVED2_MASK     (0xC0U)
#define APU_LMU_CPU1_DYN_CTRL_RESERVED2_SHIFT    (6U)
/*! RESERVED2 - Reserved 2 */
#define APU_LMU_CPU1_DYN_CTRL_RESERVED2(x)       (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_CTRL_RESERVED2_SHIFT)) & APU_LMU_CPU1_DYN_CTRL_RESERVED2_MASK)

#define APU_LMU_CPU1_DYN_CTRL_BANK2_DYN_MODE_EN_MASK (0x100U)
#define APU_LMU_CPU1_DYN_CTRL_BANK2_DYN_MODE_EN_SHIFT (8U)
/*! BANK2_DYN_MODE_EN - Bank2 Dynamic Mode Enable */
#define APU_LMU_CPU1_DYN_CTRL_BANK2_DYN_MODE_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_CTRL_BANK2_DYN_MODE_EN_SHIFT)) & APU_LMU_CPU1_DYN_CTRL_BANK2_DYN_MODE_EN_MASK)

#define APU_LMU_CPU1_DYN_CTRL_BANK2_DYN_PD_MASK  (0x200U)
#define APU_LMU_CPU1_DYN_CTRL_BANK2_DYN_PD_SHIFT (9U)
/*! BANK2_DYN_PD - Bank2 Dynamic Powerdown */
#define APU_LMU_CPU1_DYN_CTRL_BANK2_DYN_PD(x)    (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_CTRL_BANK2_DYN_PD_SHIFT)) & APU_LMU_CPU1_DYN_CTRL_BANK2_DYN_PD_MASK)

#define APU_LMU_CPU1_DYN_CTRL_RESERVED1_MASK     (0xC00U)
#define APU_LMU_CPU1_DYN_CTRL_RESERVED1_SHIFT    (10U)
/*! RESERVED1 - Reserved 1 */
#define APU_LMU_CPU1_DYN_CTRL_RESERVED1(x)       (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_CTRL_RESERVED1_SHIFT)) & APU_LMU_CPU1_DYN_CTRL_RESERVED1_MASK)

#define APU_LMU_CPU1_DYN_CTRL_BANK3_DYN_MODE_EN_MASK (0x1000U)
#define APU_LMU_CPU1_DYN_CTRL_BANK3_DYN_MODE_EN_SHIFT (12U)
/*! BANK3_DYN_MODE_EN - Bank3 Dynamic Mode Enable */
#define APU_LMU_CPU1_DYN_CTRL_BANK3_DYN_MODE_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_CTRL_BANK3_DYN_MODE_EN_SHIFT)) & APU_LMU_CPU1_DYN_CTRL_BANK3_DYN_MODE_EN_MASK)

#define APU_LMU_CPU1_DYN_CTRL_BANK3_DYN_PD_MASK  (0x2000U)
#define APU_LMU_CPU1_DYN_CTRL_BANK3_DYN_PD_SHIFT (13U)
/*! BANK3_DYN_PD - Bank3 Dynamic Powerdown */
#define APU_LMU_CPU1_DYN_CTRL_BANK3_DYN_PD(x)    (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_CTRL_BANK3_DYN_PD_SHIFT)) & APU_LMU_CPU1_DYN_CTRL_BANK3_DYN_PD_MASK)

#define APU_LMU_CPU1_DYN_CTRL_RESERVED0_MASK     (0xFFFFC000U)
#define APU_LMU_CPU1_DYN_CTRL_RESERVED0_SHIFT    (14U)
/*! RESERVED0 - Reserved 0 */
#define APU_LMU_CPU1_DYN_CTRL_RESERVED0(x)       (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_CTRL_RESERVED0_SHIFT)) & APU_LMU_CPU1_DYN_CTRL_RESERVED0_MASK)
/*! @} */

/*! @name LMU_CPU1_DYN_STATUS - LMU CPU1 Dynamic Status */
/*! @{ */

#define APU_LMU_CPU1_DYN_STATUS_BANK0_DYN_REP_REQ_MASK (0x1U)
#define APU_LMU_CPU1_DYN_STATUS_BANK0_DYN_REP_REQ_SHIFT (0U)
/*! BANK0_DYN_REP_REQ - Bank0 Dynamic Rep Request */
#define APU_LMU_CPU1_DYN_STATUS_BANK0_DYN_REP_REQ(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_STATUS_BANK0_DYN_REP_REQ_SHIFT)) & APU_LMU_CPU1_DYN_STATUS_BANK0_DYN_REP_REQ_MASK)

#define APU_LMU_CPU1_DYN_STATUS_BANK0_DYN_REP_MASK (0x2U)
#define APU_LMU_CPU1_DYN_STATUS_BANK0_DYN_REP_SHIFT (1U)
/*! BANK0_DYN_REP - Bank0 Dynamic Rep */
#define APU_LMU_CPU1_DYN_STATUS_BANK0_DYN_REP(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_STATUS_BANK0_DYN_REP_SHIFT)) & APU_LMU_CPU1_DYN_STATUS_BANK0_DYN_REP_MASK)

#define APU_LMU_CPU1_DYN_STATUS_BANK0_FSM_ST_MASK (0xCU)
#define APU_LMU_CPU1_DYN_STATUS_BANK0_FSM_ST_SHIFT (2U)
/*! BANK0_FSM_ST - Bank0 FSM St */
#define APU_LMU_CPU1_DYN_STATUS_BANK0_FSM_ST(x)  (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_STATUS_BANK0_FSM_ST_SHIFT)) & APU_LMU_CPU1_DYN_STATUS_BANK0_FSM_ST_MASK)

#define APU_LMU_CPU1_DYN_STATUS_BANK1_DYN_REP_REQ_MASK (0x10U)
#define APU_LMU_CPU1_DYN_STATUS_BANK1_DYN_REP_REQ_SHIFT (4U)
/*! BANK1_DYN_REP_REQ - Bank1 Dynamic Rep Request */
#define APU_LMU_CPU1_DYN_STATUS_BANK1_DYN_REP_REQ(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_STATUS_BANK1_DYN_REP_REQ_SHIFT)) & APU_LMU_CPU1_DYN_STATUS_BANK1_DYN_REP_REQ_MASK)

#define APU_LMU_CPU1_DYN_STATUS_BANK1_DYN_REP_MASK (0x20U)
#define APU_LMU_CPU1_DYN_STATUS_BANK1_DYN_REP_SHIFT (5U)
/*! BANK1_DYN_REP - Bank1 Dynamic Rep */
#define APU_LMU_CPU1_DYN_STATUS_BANK1_DYN_REP(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_STATUS_BANK1_DYN_REP_SHIFT)) & APU_LMU_CPU1_DYN_STATUS_BANK1_DYN_REP_MASK)

#define APU_LMU_CPU1_DYN_STATUS_BANK1_FSM_ST_MASK (0xC0U)
#define APU_LMU_CPU1_DYN_STATUS_BANK1_FSM_ST_SHIFT (6U)
/*! BANK1_FSM_ST - Bank1 FSM St */
#define APU_LMU_CPU1_DYN_STATUS_BANK1_FSM_ST(x)  (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_STATUS_BANK1_FSM_ST_SHIFT)) & APU_LMU_CPU1_DYN_STATUS_BANK1_FSM_ST_MASK)

#define APU_LMU_CPU1_DYN_STATUS_BANK2_DYN_REP_REQ_MASK (0x100U)
#define APU_LMU_CPU1_DYN_STATUS_BANK2_DYN_REP_REQ_SHIFT (8U)
/*! BANK2_DYN_REP_REQ - Bank2 Dynamic Rep Request */
#define APU_LMU_CPU1_DYN_STATUS_BANK2_DYN_REP_REQ(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_STATUS_BANK2_DYN_REP_REQ_SHIFT)) & APU_LMU_CPU1_DYN_STATUS_BANK2_DYN_REP_REQ_MASK)

#define APU_LMU_CPU1_DYN_STATUS_BANK2_DYN_REP_MASK (0x200U)
#define APU_LMU_CPU1_DYN_STATUS_BANK2_DYN_REP_SHIFT (9U)
/*! BANK2_DYN_REP - Bank2 Dynamic Rep */
#define APU_LMU_CPU1_DYN_STATUS_BANK2_DYN_REP(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_STATUS_BANK2_DYN_REP_SHIFT)) & APU_LMU_CPU1_DYN_STATUS_BANK2_DYN_REP_MASK)

#define APU_LMU_CPU1_DYN_STATUS_BANK2_FSM_ST_MASK (0xC00U)
#define APU_LMU_CPU1_DYN_STATUS_BANK2_FSM_ST_SHIFT (10U)
/*! BANK2_FSM_ST - Bank2 FSM St */
#define APU_LMU_CPU1_DYN_STATUS_BANK2_FSM_ST(x)  (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_STATUS_BANK2_FSM_ST_SHIFT)) & APU_LMU_CPU1_DYN_STATUS_BANK2_FSM_ST_MASK)

#define APU_LMU_CPU1_DYN_STATUS_BANK3_DYN_REP_REQ_MASK (0x1000U)
#define APU_LMU_CPU1_DYN_STATUS_BANK3_DYN_REP_REQ_SHIFT (12U)
/*! BANK3_DYN_REP_REQ - Bank3 Dynamic Rep Request */
#define APU_LMU_CPU1_DYN_STATUS_BANK3_DYN_REP_REQ(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_STATUS_BANK3_DYN_REP_REQ_SHIFT)) & APU_LMU_CPU1_DYN_STATUS_BANK3_DYN_REP_REQ_MASK)

#define APU_LMU_CPU1_DYN_STATUS_BANK3_DYN_REP_MASK (0x2000U)
#define APU_LMU_CPU1_DYN_STATUS_BANK3_DYN_REP_SHIFT (13U)
/*! BANK3_DYN_REP - Bank3 Dynamic Rep */
#define APU_LMU_CPU1_DYN_STATUS_BANK3_DYN_REP(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_STATUS_BANK3_DYN_REP_SHIFT)) & APU_LMU_CPU1_DYN_STATUS_BANK3_DYN_REP_MASK)

#define APU_LMU_CPU1_DYN_STATUS_BANK3_FSM_ST_MASK (0xC000U)
#define APU_LMU_CPU1_DYN_STATUS_BANK3_FSM_ST_SHIFT (14U)
/*! BANK3_FSM_ST - Bank3 FSM St */
#define APU_LMU_CPU1_DYN_STATUS_BANK3_FSM_ST(x)  (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU1_DYN_STATUS_BANK3_FSM_ST_SHIFT)) & APU_LMU_CPU1_DYN_STATUS_BANK3_FSM_ST_MASK)
/*! @} */

/*! @name LMU_CPU2_STA_CFG - LMU CPU2 STA Configuration */
/*! @{ */

#define APU_LMU_CPU2_STA_CFG_BANK0_STA_OFF_EN_MASK (0x1U)
#define APU_LMU_CPU2_STA_CFG_BANK0_STA_OFF_EN_SHIFT (0U)
/*! BANK0_STA_OFF_EN - Bank0 STA Off Enable */
#define APU_LMU_CPU2_STA_CFG_BANK0_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_BANK0_STA_OFF_EN_SHIFT)) & APU_LMU_CPU2_STA_CFG_BANK0_STA_OFF_EN_MASK)

#define APU_LMU_CPU2_STA_CFG_RESERVED7_MASK      (0x2U)
#define APU_LMU_CPU2_STA_CFG_RESERVED7_SHIFT     (1U)
/*! RESERVED7 - Reserved 7 */
#define APU_LMU_CPU2_STA_CFG_RESERVED7(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_RESERVED7_SHIFT)) & APU_LMU_CPU2_STA_CFG_RESERVED7_MASK)

#define APU_LMU_CPU2_STA_CFG_BANK1_STA_OFF_EN_MASK (0x4U)
#define APU_LMU_CPU2_STA_CFG_BANK1_STA_OFF_EN_SHIFT (2U)
/*! BANK1_STA_OFF_EN - Bank1 STA Off Enable */
#define APU_LMU_CPU2_STA_CFG_BANK1_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_BANK1_STA_OFF_EN_SHIFT)) & APU_LMU_CPU2_STA_CFG_BANK1_STA_OFF_EN_MASK)

#define APU_LMU_CPU2_STA_CFG_RESERVED6_MASK      (0x8U)
#define APU_LMU_CPU2_STA_CFG_RESERVED6_SHIFT     (3U)
/*! RESERVED6 - Reserved 6 */
#define APU_LMU_CPU2_STA_CFG_RESERVED6(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_RESERVED6_SHIFT)) & APU_LMU_CPU2_STA_CFG_RESERVED6_MASK)

#define APU_LMU_CPU2_STA_CFG_BANK2_STA_OFF_EN_MASK (0x10U)
#define APU_LMU_CPU2_STA_CFG_BANK2_STA_OFF_EN_SHIFT (4U)
/*! BANK2_STA_OFF_EN - Bank2 STA Off Enable */
#define APU_LMU_CPU2_STA_CFG_BANK2_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_BANK2_STA_OFF_EN_SHIFT)) & APU_LMU_CPU2_STA_CFG_BANK2_STA_OFF_EN_MASK)

#define APU_LMU_CPU2_STA_CFG_RESERVED5_MASK      (0x20U)
#define APU_LMU_CPU2_STA_CFG_RESERVED5_SHIFT     (5U)
/*! RESERVED5 - Reserved 5 */
#define APU_LMU_CPU2_STA_CFG_RESERVED5(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_RESERVED5_SHIFT)) & APU_LMU_CPU2_STA_CFG_RESERVED5_MASK)

#define APU_LMU_CPU2_STA_CFG_BANK3_STA_OFF_EN_MASK (0x40U)
#define APU_LMU_CPU2_STA_CFG_BANK3_STA_OFF_EN_SHIFT (6U)
/*! BANK3_STA_OFF_EN - Bank3 STA Off Enable */
#define APU_LMU_CPU2_STA_CFG_BANK3_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_BANK3_STA_OFF_EN_SHIFT)) & APU_LMU_CPU2_STA_CFG_BANK3_STA_OFF_EN_MASK)

#define APU_LMU_CPU2_STA_CFG_RESERVED4_MASK      (0x80U)
#define APU_LMU_CPU2_STA_CFG_RESERVED4_SHIFT     (7U)
/*! RESERVED4 - Reserved 4 */
#define APU_LMU_CPU2_STA_CFG_RESERVED4(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_RESERVED4_SHIFT)) & APU_LMU_CPU2_STA_CFG_RESERVED4_MASK)

#define APU_LMU_CPU2_STA_CFG_BANK4_STA_OFF_EN_MASK (0x100U)
#define APU_LMU_CPU2_STA_CFG_BANK4_STA_OFF_EN_SHIFT (8U)
/*! BANK4_STA_OFF_EN - Bank4 STA Off Enable */
#define APU_LMU_CPU2_STA_CFG_BANK4_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_BANK4_STA_OFF_EN_SHIFT)) & APU_LMU_CPU2_STA_CFG_BANK4_STA_OFF_EN_MASK)

#define APU_LMU_CPU2_STA_CFG_RESERVED3_MASK      (0x200U)
#define APU_LMU_CPU2_STA_CFG_RESERVED3_SHIFT     (9U)
/*! RESERVED3 - Reserved 3 */
#define APU_LMU_CPU2_STA_CFG_RESERVED3(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_RESERVED3_SHIFT)) & APU_LMU_CPU2_STA_CFG_RESERVED3_MASK)

#define APU_LMU_CPU2_STA_CFG_BANK5_STA_OFF_EN_MASK (0x400U)
#define APU_LMU_CPU2_STA_CFG_BANK5_STA_OFF_EN_SHIFT (10U)
/*! BANK5_STA_OFF_EN - Bank5 STA Off Enable */
#define APU_LMU_CPU2_STA_CFG_BANK5_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_BANK5_STA_OFF_EN_SHIFT)) & APU_LMU_CPU2_STA_CFG_BANK5_STA_OFF_EN_MASK)

#define APU_LMU_CPU2_STA_CFG_RESERVED2_MASK      (0x800U)
#define APU_LMU_CPU2_STA_CFG_RESERVED2_SHIFT     (11U)
/*! RESERVED2 - Reserved 2 */
#define APU_LMU_CPU2_STA_CFG_RESERVED2(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_RESERVED2_SHIFT)) & APU_LMU_CPU2_STA_CFG_RESERVED2_MASK)

#define APU_LMU_CPU2_STA_CFG_BANK6_STA_OFF_EN_MASK (0x1000U)
#define APU_LMU_CPU2_STA_CFG_BANK6_STA_OFF_EN_SHIFT (12U)
/*! BANK6_STA_OFF_EN - Bank6 STA Off Enable */
#define APU_LMU_CPU2_STA_CFG_BANK6_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_BANK6_STA_OFF_EN_SHIFT)) & APU_LMU_CPU2_STA_CFG_BANK6_STA_OFF_EN_MASK)

#define APU_LMU_CPU2_STA_CFG_RESERVED1_MASK      (0x2000U)
#define APU_LMU_CPU2_STA_CFG_RESERVED1_SHIFT     (13U)
/*! RESERVED1 - Reserved 1 */
#define APU_LMU_CPU2_STA_CFG_RESERVED1(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_RESERVED1_SHIFT)) & APU_LMU_CPU2_STA_CFG_RESERVED1_MASK)

#define APU_LMU_CPU2_STA_CFG_BANK7_STA_OFF_EN_MASK (0x4000U)
#define APU_LMU_CPU2_STA_CFG_BANK7_STA_OFF_EN_SHIFT (14U)
/*! BANK7_STA_OFF_EN - Bank7 STA Off Enable */
#define APU_LMU_CPU2_STA_CFG_BANK7_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_BANK7_STA_OFF_EN_SHIFT)) & APU_LMU_CPU2_STA_CFG_BANK7_STA_OFF_EN_MASK)

#define APU_LMU_CPU2_STA_CFG_RESERVED0_MASK      (0xFFFF8000U)
#define APU_LMU_CPU2_STA_CFG_RESERVED0_SHIFT     (15U)
/*! RESERVED0 - Reserved 0 */
#define APU_LMU_CPU2_STA_CFG_RESERVED0(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_CFG_RESERVED0_SHIFT)) & APU_LMU_CPU2_STA_CFG_RESERVED0_MASK)
/*! @} */

/*! @name LMU_CPU2_STA_STATUS1 - LMU CPU2 STA Status 1 */
/*! @{ */

#define APU_LMU_CPU2_STA_STATUS1_BANK0_FSM_ST_REP_DONE_MASK (0x1U)
#define APU_LMU_CPU2_STA_STATUS1_BANK0_FSM_ST_REP_DONE_SHIFT (0U)
/*! BANK0_FSM_ST_REP_DONE - Bank0 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS1_BANK0_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK0_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK0_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK0_FSM_ST_MASK (0xEU)
#define APU_LMU_CPU2_STA_STATUS1_BANK0_FSM_ST_SHIFT (1U)
/*! BANK0_FSM_ST - Bank0 FSM St */
#define APU_LMU_CPU2_STA_STATUS1_BANK0_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK0_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK0_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK1_FSM_ST_REP_DONE_MASK (0x10U)
#define APU_LMU_CPU2_STA_STATUS1_BANK1_FSM_ST_REP_DONE_SHIFT (4U)
/*! BANK1_FSM_ST_REP_DONE - Bank1 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS1_BANK1_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK1_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK1_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK1_FSM_ST_MASK (0xE0U)
#define APU_LMU_CPU2_STA_STATUS1_BANK1_FSM_ST_SHIFT (5U)
/*! BANK1_FSM_ST - Bank1 FSM St */
#define APU_LMU_CPU2_STA_STATUS1_BANK1_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK1_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK1_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK2_FSM_ST_REP_DONE_MASK (0x100U)
#define APU_LMU_CPU2_STA_STATUS1_BANK2_FSM_ST_REP_DONE_SHIFT (8U)
/*! BANK2_FSM_ST_REP_DONE - Bank2 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS1_BANK2_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK2_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK2_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK2_FSM_ST_MASK (0xE00U)
#define APU_LMU_CPU2_STA_STATUS1_BANK2_FSM_ST_SHIFT (9U)
/*! BANK2_FSM_ST - Bank2FSM St */
#define APU_LMU_CPU2_STA_STATUS1_BANK2_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK2_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK2_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK3_FSM_ST_REP_DONE_MASK (0x1000U)
#define APU_LMU_CPU2_STA_STATUS1_BANK3_FSM_ST_REP_DONE_SHIFT (12U)
/*! BANK3_FSM_ST_REP_DONE - Bank3 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS1_BANK3_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK3_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK3_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK3_FSM_ST_MASK (0xE000U)
#define APU_LMU_CPU2_STA_STATUS1_BANK3_FSM_ST_SHIFT (13U)
/*! BANK3_FSM_ST - Bank3 FSM St */
#define APU_LMU_CPU2_STA_STATUS1_BANK3_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK3_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK3_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK4_FSM_ST_REP_DONE_MASK (0x10000U)
#define APU_LMU_CPU2_STA_STATUS1_BANK4_FSM_ST_REP_DONE_SHIFT (16U)
/*! BANK4_FSM_ST_REP_DONE - Bank4 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS1_BANK4_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK4_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK4_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK4_FSM_ST_MASK (0xE0000U)
#define APU_LMU_CPU2_STA_STATUS1_BANK4_FSM_ST_SHIFT (17U)
/*! BANK4_FSM_ST - Bank4 FSM St */
#define APU_LMU_CPU2_STA_STATUS1_BANK4_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK4_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK4_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK5_FSM_ST_REP_DONE_MASK (0x100000U)
#define APU_LMU_CPU2_STA_STATUS1_BANK5_FSM_ST_REP_DONE_SHIFT (20U)
/*! BANK5_FSM_ST_REP_DONE - Bank5 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS1_BANK5_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK5_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK5_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK5_FSM_ST_MASK (0xE00000U)
#define APU_LMU_CPU2_STA_STATUS1_BANK5_FSM_ST_SHIFT (21U)
/*! BANK5_FSM_ST - Bank5 FSM St */
#define APU_LMU_CPU2_STA_STATUS1_BANK5_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK5_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK5_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK6_FSM_ST_REP_DONE_MASK (0x1000000U)
#define APU_LMU_CPU2_STA_STATUS1_BANK6_FSM_ST_REP_DONE_SHIFT (24U)
/*! BANK6_FSM_ST_REP_DONE - Bank6 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS1_BANK6_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK6_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK6_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK6_FSM_ST_MASK (0xE000000U)
#define APU_LMU_CPU2_STA_STATUS1_BANK6_FSM_ST_SHIFT (25U)
/*! BANK6_FSM_ST - Bank6 FSM St */
#define APU_LMU_CPU2_STA_STATUS1_BANK6_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK6_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK6_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK7_FSM_ST_REP_DONE_MASK (0x10000000U)
#define APU_LMU_CPU2_STA_STATUS1_BANK7_FSM_ST_REP_DONE_SHIFT (28U)
/*! BANK7_FSM_ST_REP_DONE - Bank7 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS1_BANK7_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK7_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK7_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS1_BANK7_FSM_ST_MASK (0xE0000000U)
#define APU_LMU_CPU2_STA_STATUS1_BANK7_FSM_ST_SHIFT (29U)
/*! BANK7_FSM_ST - Bank7 FSM St */
#define APU_LMU_CPU2_STA_STATUS1_BANK7_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS1_BANK7_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS1_BANK7_FSM_ST_MASK)
/*! @} */

/*! @name LMU_CPU3_STA_CFG - LMU CPU3 STA Configuration */
/*! @{ */

#define APU_LMU_CPU3_STA_CFG_BANK0_STA_OFF_EN_MASK (0x1U)
#define APU_LMU_CPU3_STA_CFG_BANK0_STA_OFF_EN_SHIFT (0U)
/*! BANK0_STA_OFF_EN - Bank0 STA Off Enable */
#define APU_LMU_CPU3_STA_CFG_BANK0_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_BANK0_STA_OFF_EN_SHIFT)) & APU_LMU_CPU3_STA_CFG_BANK0_STA_OFF_EN_MASK)

#define APU_LMU_CPU3_STA_CFG_RESERVED7_MASK      (0x2U)
#define APU_LMU_CPU3_STA_CFG_RESERVED7_SHIFT     (1U)
/*! RESERVED7 - Reserved 7 */
#define APU_LMU_CPU3_STA_CFG_RESERVED7(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_RESERVED7_SHIFT)) & APU_LMU_CPU3_STA_CFG_RESERVED7_MASK)

#define APU_LMU_CPU3_STA_CFG_BANK1_STA_OFF_EN_MASK (0x4U)
#define APU_LMU_CPU3_STA_CFG_BANK1_STA_OFF_EN_SHIFT (2U)
/*! BANK1_STA_OFF_EN - Bank1 STA Off Enable */
#define APU_LMU_CPU3_STA_CFG_BANK1_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_BANK1_STA_OFF_EN_SHIFT)) & APU_LMU_CPU3_STA_CFG_BANK1_STA_OFF_EN_MASK)

#define APU_LMU_CPU3_STA_CFG_RESERVED6_MASK      (0x8U)
#define APU_LMU_CPU3_STA_CFG_RESERVED6_SHIFT     (3U)
/*! RESERVED6 - Reserved 6 */
#define APU_LMU_CPU3_STA_CFG_RESERVED6(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_RESERVED6_SHIFT)) & APU_LMU_CPU3_STA_CFG_RESERVED6_MASK)

#define APU_LMU_CPU3_STA_CFG_BANK2_STA_OFF_EN_MASK (0x10U)
#define APU_LMU_CPU3_STA_CFG_BANK2_STA_OFF_EN_SHIFT (4U)
/*! BANK2_STA_OFF_EN - Bank2 STA Off Enable */
#define APU_LMU_CPU3_STA_CFG_BANK2_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_BANK2_STA_OFF_EN_SHIFT)) & APU_LMU_CPU3_STA_CFG_BANK2_STA_OFF_EN_MASK)

#define APU_LMU_CPU3_STA_CFG_RESERVED5_MASK      (0x20U)
#define APU_LMU_CPU3_STA_CFG_RESERVED5_SHIFT     (5U)
/*! RESERVED5 - Reserved 5 */
#define APU_LMU_CPU3_STA_CFG_RESERVED5(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_RESERVED5_SHIFT)) & APU_LMU_CPU3_STA_CFG_RESERVED5_MASK)

#define APU_LMU_CPU3_STA_CFG_BANK3_STA_OFF_EN_MASK (0x40U)
#define APU_LMU_CPU3_STA_CFG_BANK3_STA_OFF_EN_SHIFT (6U)
/*! BANK3_STA_OFF_EN - Bank3 STA Off Enable */
#define APU_LMU_CPU3_STA_CFG_BANK3_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_BANK3_STA_OFF_EN_SHIFT)) & APU_LMU_CPU3_STA_CFG_BANK3_STA_OFF_EN_MASK)

#define APU_LMU_CPU3_STA_CFG_RESERVED4_MASK      (0x80U)
#define APU_LMU_CPU3_STA_CFG_RESERVED4_SHIFT     (7U)
/*! RESERVED4 - Reserved 4 */
#define APU_LMU_CPU3_STA_CFG_RESERVED4(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_RESERVED4_SHIFT)) & APU_LMU_CPU3_STA_CFG_RESERVED4_MASK)

#define APU_LMU_CPU3_STA_CFG_BANK4_STA_OFF_EN_MASK (0x100U)
#define APU_LMU_CPU3_STA_CFG_BANK4_STA_OFF_EN_SHIFT (8U)
/*! BANK4_STA_OFF_EN - Bank4 STA Off Enable */
#define APU_LMU_CPU3_STA_CFG_BANK4_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_BANK4_STA_OFF_EN_SHIFT)) & APU_LMU_CPU3_STA_CFG_BANK4_STA_OFF_EN_MASK)

#define APU_LMU_CPU3_STA_CFG_RESERVED3_MASK      (0x200U)
#define APU_LMU_CPU3_STA_CFG_RESERVED3_SHIFT     (9U)
/*! RESERVED3 - Reserved 3 */
#define APU_LMU_CPU3_STA_CFG_RESERVED3(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_RESERVED3_SHIFT)) & APU_LMU_CPU3_STA_CFG_RESERVED3_MASK)

#define APU_LMU_CPU3_STA_CFG_BANK5_STA_OFF_EN_MASK (0x400U)
#define APU_LMU_CPU3_STA_CFG_BANK5_STA_OFF_EN_SHIFT (10U)
/*! BANK5_STA_OFF_EN - Bank5 STA Off Enable */
#define APU_LMU_CPU3_STA_CFG_BANK5_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_BANK5_STA_OFF_EN_SHIFT)) & APU_LMU_CPU3_STA_CFG_BANK5_STA_OFF_EN_MASK)

#define APU_LMU_CPU3_STA_CFG_RESERVED2_MASK      (0x800U)
#define APU_LMU_CPU3_STA_CFG_RESERVED2_SHIFT     (11U)
/*! RESERVED2 - Reserved 2 */
#define APU_LMU_CPU3_STA_CFG_RESERVED2(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_RESERVED2_SHIFT)) & APU_LMU_CPU3_STA_CFG_RESERVED2_MASK)

#define APU_LMU_CPU3_STA_CFG_BANK6_STA_OFF_EN_MASK (0x1000U)
#define APU_LMU_CPU3_STA_CFG_BANK6_STA_OFF_EN_SHIFT (12U)
/*! BANK6_STA_OFF_EN - Bank6 STA Off Enable */
#define APU_LMU_CPU3_STA_CFG_BANK6_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_BANK6_STA_OFF_EN_SHIFT)) & APU_LMU_CPU3_STA_CFG_BANK6_STA_OFF_EN_MASK)

#define APU_LMU_CPU3_STA_CFG_RESERVED1_MASK      (0x2000U)
#define APU_LMU_CPU3_STA_CFG_RESERVED1_SHIFT     (13U)
/*! RESERVED1 - Reserved 1 */
#define APU_LMU_CPU3_STA_CFG_RESERVED1(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_RESERVED1_SHIFT)) & APU_LMU_CPU3_STA_CFG_RESERVED1_MASK)

#define APU_LMU_CPU3_STA_CFG_BANK7_STA_OFF_EN_MASK (0x4000U)
#define APU_LMU_CPU3_STA_CFG_BANK7_STA_OFF_EN_SHIFT (14U)
/*! BANK7_STA_OFF_EN - Bank7 STA Off Enable */
#define APU_LMU_CPU3_STA_CFG_BANK7_STA_OFF_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_BANK7_STA_OFF_EN_SHIFT)) & APU_LMU_CPU3_STA_CFG_BANK7_STA_OFF_EN_MASK)

#define APU_LMU_CPU3_STA_CFG_RESERVED0_MASK      (0xFFFF8000U)
#define APU_LMU_CPU3_STA_CFG_RESERVED0_SHIFT     (15U)
/*! RESERVED0 - Reserved 0 */
#define APU_LMU_CPU3_STA_CFG_RESERVED0(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_CFG_RESERVED0_SHIFT)) & APU_LMU_CPU3_STA_CFG_RESERVED0_MASK)
/*! @} */

/*! @name LMU_CPU3_STA_STATUS1 - LMU CPU3 STA Status 1 */
/*! @{ */

#define APU_LMU_CPU3_STA_STATUS1_BANK0_FSM_ST_REP_DONE_MASK (0x1U)
#define APU_LMU_CPU3_STA_STATUS1_BANK0_FSM_ST_REP_DONE_SHIFT (0U)
/*! BANK0_FSM_ST_REP_DONE - Bank0 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS1_BANK0_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK0_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK0_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK0_FSM_ST_MASK (0xEU)
#define APU_LMU_CPU3_STA_STATUS1_BANK0_FSM_ST_SHIFT (1U)
/*! BANK0_FSM_ST - Bank0 FSM St */
#define APU_LMU_CPU3_STA_STATUS1_BANK0_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK0_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK0_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK1_FSM_ST_REP_DONE_MASK (0x10U)
#define APU_LMU_CPU3_STA_STATUS1_BANK1_FSM_ST_REP_DONE_SHIFT (4U)
/*! BANK1_FSM_ST_REP_DONE - Bank1 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS1_BANK1_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK1_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK1_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK1_FSM_ST_MASK (0xE0U)
#define APU_LMU_CPU3_STA_STATUS1_BANK1_FSM_ST_SHIFT (5U)
/*! BANK1_FSM_ST - Bank1 FSM St */
#define APU_LMU_CPU3_STA_STATUS1_BANK1_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK1_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK1_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK2_FSM_ST_REP_DONE_MASK (0x100U)
#define APU_LMU_CPU3_STA_STATUS1_BANK2_FSM_ST_REP_DONE_SHIFT (8U)
/*! BANK2_FSM_ST_REP_DONE - Bank2 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS1_BANK2_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK2_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK2_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK2_FSM_ST_MASK (0xE00U)
#define APU_LMU_CPU3_STA_STATUS1_BANK2_FSM_ST_SHIFT (9U)
/*! BANK2_FSM_ST - Bank2FSM St */
#define APU_LMU_CPU3_STA_STATUS1_BANK2_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK2_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK2_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK3_FSM_ST_REP_DONE_MASK (0x1000U)
#define APU_LMU_CPU3_STA_STATUS1_BANK3_FSM_ST_REP_DONE_SHIFT (12U)
/*! BANK3_FSM_ST_REP_DONE - Bank3 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS1_BANK3_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK3_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK3_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK3_FSM_ST_MASK (0xE000U)
#define APU_LMU_CPU3_STA_STATUS1_BANK3_FSM_ST_SHIFT (13U)
/*! BANK3_FSM_ST - Bank3 FSM St */
#define APU_LMU_CPU3_STA_STATUS1_BANK3_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK3_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK3_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK4_FSM_ST_REP_DONE_MASK (0x10000U)
#define APU_LMU_CPU3_STA_STATUS1_BANK4_FSM_ST_REP_DONE_SHIFT (16U)
/*! BANK4_FSM_ST_REP_DONE - Bank4 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS1_BANK4_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK4_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK4_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK4_FSM_ST_MASK (0xE0000U)
#define APU_LMU_CPU3_STA_STATUS1_BANK4_FSM_ST_SHIFT (17U)
/*! BANK4_FSM_ST - Bank4 FSM St */
#define APU_LMU_CPU3_STA_STATUS1_BANK4_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK4_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK4_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK5_FSM_ST_REP_DONE_MASK (0x100000U)
#define APU_LMU_CPU3_STA_STATUS1_BANK5_FSM_ST_REP_DONE_SHIFT (20U)
/*! BANK5_FSM_ST_REP_DONE - Bank5 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS1_BANK5_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK5_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK5_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK5_FSM_ST_MASK (0xE00000U)
#define APU_LMU_CPU3_STA_STATUS1_BANK5_FSM_ST_SHIFT (21U)
/*! BANK5_FSM_ST - Bank5 FSM St */
#define APU_LMU_CPU3_STA_STATUS1_BANK5_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK5_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK5_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK6_FSM_ST_REP_DONE_MASK (0x1000000U)
#define APU_LMU_CPU3_STA_STATUS1_BANK6_FSM_ST_REP_DONE_SHIFT (24U)
/*! BANK6_FSM_ST_REP_DONE - Bank6 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS1_BANK6_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK6_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK6_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK6_FSM_ST_MASK (0xE000000U)
#define APU_LMU_CPU3_STA_STATUS1_BANK6_FSM_ST_SHIFT (25U)
/*! BANK6_FSM_ST - Bank6 FSM St */
#define APU_LMU_CPU3_STA_STATUS1_BANK6_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK6_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK6_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK7_FSM_ST_REP_DONE_MASK (0x10000000U)
#define APU_LMU_CPU3_STA_STATUS1_BANK7_FSM_ST_REP_DONE_SHIFT (28U)
/*! BANK7_FSM_ST_REP_DONE - Bank7 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS1_BANK7_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK7_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK7_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS1_BANK7_FSM_ST_MASK (0xE0000000U)
#define APU_LMU_CPU3_STA_STATUS1_BANK7_FSM_ST_SHIFT (29U)
/*! BANK7_FSM_ST - Bank7 FSM St */
#define APU_LMU_CPU3_STA_STATUS1_BANK7_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS1_BANK7_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS1_BANK7_FSM_ST_MASK)
/*! @} */

/*! @name LMU_G2BIST_CTRL - LMU G2BIST Control */
/*! @{ */

#define APU_LMU_G2BIST_CTRL_LMU_G2BIST_MODE_MASK (0x1FU)
#define APU_LMU_G2BIST_CTRL_LMU_G2BIST_MODE_SHIFT (0U)
/*! LMU_G2BIST_MODE - 1 = fuse load mode, default mode when powered up. All repairable memories will be repaired by g2bist engine */
#define APU_LMU_G2BIST_CTRL_LMU_G2BIST_MODE(x)   (((uint32_t)(((uint32_t)(x)) << APU_LMU_G2BIST_CTRL_LMU_G2BIST_MODE_SHIFT)) & APU_LMU_G2BIST_CTRL_LMU_G2BIST_MODE_MASK)

#define APU_LMU_G2BIST_CTRL_DISABLE_STA_REPAIR_MASK (0x20000000U)
#define APU_LMU_G2BIST_CTRL_DISABLE_STA_REPAIR_SHIFT (29U)
/*! DISABLE_STA_REPAIR - 1= disable static memory repair */
#define APU_LMU_G2BIST_CTRL_DISABLE_STA_REPAIR(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_G2BIST_CTRL_DISABLE_STA_REPAIR_SHIFT)) & APU_LMU_G2BIST_CTRL_DISABLE_STA_REPAIR_MASK)

#define APU_LMU_G2BIST_CTRL_DISABLE_DYN_REPAIR_MASK (0x40000000U)
#define APU_LMU_G2BIST_CTRL_DISABLE_DYN_REPAIR_SHIFT (30U)
/*! DISABLE_DYN_REPAIR - 1= disable dynamic memory repair */
#define APU_LMU_G2BIST_CTRL_DISABLE_DYN_REPAIR(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_G2BIST_CTRL_DISABLE_DYN_REPAIR_SHIFT)) & APU_LMU_G2BIST_CTRL_DISABLE_DYN_REPAIR_MASK)
/*! @} */

/*! @name LMU_STATUS - LMU Status */
/*! @{ */

#define APU_LMU_STATUS_REPAIR_FSM_ST_MASK        (0xFU)
#define APU_LMU_STATUS_REPAIR_FSM_ST_SHIFT       (0U)
/*! REPAIR_FSM_ST - Repair FSM St */
#define APU_LMU_STATUS_REPAIR_FSM_ST(x)          (((uint32_t)(((uint32_t)(x)) << APU_LMU_STATUS_REPAIR_FSM_ST_SHIFT)) & APU_LMU_STATUS_REPAIR_FSM_ST_MASK)

#define APU_LMU_STATUS_NXT_ST_MASK               (0xF0U)
#define APU_LMU_STATUS_NXT_ST_SHIFT              (4U)
/*! NXT_ST - NXT St */
#define APU_LMU_STATUS_NXT_ST(x)                 (((uint32_t)(((uint32_t)(x)) << APU_LMU_STATUS_NXT_ST_SHIFT)) & APU_LMU_STATUS_NXT_ST_MASK)

#define APU_LMU_STATUS_LMU_G2BIST_MODE_MASK      (0xF00U)
#define APU_LMU_STATUS_LMU_G2BIST_MODE_SHIFT     (8U)
/*! LMU_G2BIST_MODE - LMU_g to BIST Mode */
#define APU_LMU_STATUS_LMU_G2BIST_MODE(x)        (((uint32_t)(((uint32_t)(x)) << APU_LMU_STATUS_LMU_G2BIST_MODE_SHIFT)) & APU_LMU_STATUS_LMU_G2BIST_MODE_MASK)

#define APU_LMU_STATUS_LMU_G2BIST_PWRDMN_RPR_REQ_MASK (0xFF000U)
#define APU_LMU_STATUS_LMU_G2BIST_PWRDMN_RPR_REQ_SHIFT (12U)
/*! LMU_G2BIST_PWRDMN_RPR_REQ - LMU_g to BIST Powerdown RPR Request */
#define APU_LMU_STATUS_LMU_G2BIST_PWRDMN_RPR_REQ(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_STATUS_LMU_G2BIST_PWRDMN_RPR_REQ_SHIFT)) & APU_LMU_STATUS_LMU_G2BIST_PWRDMN_RPR_REQ_MASK)

#define APU_LMU_STATUS_LMU_G2BIST_START_MASK     (0x100000U)
#define APU_LMU_STATUS_LMU_G2BIST_START_SHIFT    (20U)
/*! LMU_G2BIST_START - LMU_g to BIST Start */
#define APU_LMU_STATUS_LMU_G2BIST_START(x)       (((uint32_t)(((uint32_t)(x)) << APU_LMU_STATUS_LMU_G2BIST_START_SHIFT)) & APU_LMU_STATUS_LMU_G2BIST_START_MASK)
/*! @} */

/*! @name LMU_STA_CFG_MASK - LMU STA Configuration Mask */
/*! @{ */

#define APU_LMU_STA_CFG_MASK_STA_CFG_MASK_MASK   (0xFFU)
#define APU_LMU_STA_CFG_MASK_STA_CFG_MASK_SHIFT  (0U)
/*! STA_CFG_MASK - STA Configuration Mask */
#define APU_LMU_STA_CFG_MASK_STA_CFG_MASK(x)     (((uint32_t)(((uint32_t)(x)) << APU_LMU_STA_CFG_MASK_STA_CFG_MASK_SHIFT)) & APU_LMU_STA_CFG_MASK_STA_CFG_MASK_MASK)
/*! @} */

/*! @name LMU_CPU2_STA_STATUS2 - LMU CPU2 STA Status 2 */
/*! @{ */

#define APU_LMU_CPU2_STA_STATUS2_BANK8_FSM_ST_REP_DONE_MASK (0x1U)
#define APU_LMU_CPU2_STA_STATUS2_BANK8_FSM_ST_REP_DONE_SHIFT (0U)
/*! BANK8_FSM_ST_REP_DONE - Bank8 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS2_BANK8_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK8_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK8_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK8_FSM_ST_MASK (0xEU)
#define APU_LMU_CPU2_STA_STATUS2_BANK8_FSM_ST_SHIFT (1U)
/*! BANK8_FSM_ST - Bank8 FSM St */
#define APU_LMU_CPU2_STA_STATUS2_BANK8_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK8_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK8_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK9_FSM_ST_REP_DONE_MASK (0x10U)
#define APU_LMU_CPU2_STA_STATUS2_BANK9_FSM_ST_REP_DONE_SHIFT (4U)
/*! BANK9_FSM_ST_REP_DONE - Bank9 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS2_BANK9_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK9_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK9_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK9_FSM_ST_MASK (0xE0U)
#define APU_LMU_CPU2_STA_STATUS2_BANK9_FSM_ST_SHIFT (5U)
/*! BANK9_FSM_ST - Bank9 FSM St */
#define APU_LMU_CPU2_STA_STATUS2_BANK9_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK9_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK9_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK10_FSM_ST_REP_DONE_MASK (0x100U)
#define APU_LMU_CPU2_STA_STATUS2_BANK10_FSM_ST_REP_DONE_SHIFT (8U)
/*! BANK10_FSM_ST_REP_DONE - Bank10 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS2_BANK10_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK10_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK10_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK10_FSM_ST_MASK (0xE00U)
#define APU_LMU_CPU2_STA_STATUS2_BANK10_FSM_ST_SHIFT (9U)
/*! BANK10_FSM_ST - Bank10 FSM St */
#define APU_LMU_CPU2_STA_STATUS2_BANK10_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK10_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK10_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK11_FSM_ST_REP_DONE_MASK (0x1000U)
#define APU_LMU_CPU2_STA_STATUS2_BANK11_FSM_ST_REP_DONE_SHIFT (12U)
/*! BANK11_FSM_ST_REP_DONE - Bank11 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS2_BANK11_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK11_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK11_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK11_FSM_ST_MASK (0xE000U)
#define APU_LMU_CPU2_STA_STATUS2_BANK11_FSM_ST_SHIFT (13U)
/*! BANK11_FSM_ST - Bank11 FSM St */
#define APU_LMU_CPU2_STA_STATUS2_BANK11_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK11_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK11_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK12_FSM_ST_REP_DONE_MASK (0x10000U)
#define APU_LMU_CPU2_STA_STATUS2_BANK12_FSM_ST_REP_DONE_SHIFT (16U)
/*! BANK12_FSM_ST_REP_DONE - Bank12 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS2_BANK12_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK12_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK12_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK12_FSM_ST_MASK (0xE0000U)
#define APU_LMU_CPU2_STA_STATUS2_BANK12_FSM_ST_SHIFT (17U)
/*! BANK12_FSM_ST - Bank12 FSM St */
#define APU_LMU_CPU2_STA_STATUS2_BANK12_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK12_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK12_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK13_FSM_ST_REP_DONE_MASK (0x100000U)
#define APU_LMU_CPU2_STA_STATUS2_BANK13_FSM_ST_REP_DONE_SHIFT (20U)
/*! BANK13_FSM_ST_REP_DONE - Bank13 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS2_BANK13_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK13_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK13_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK13_FSM_ST_MASK (0xE00000U)
#define APU_LMU_CPU2_STA_STATUS2_BANK13_FSM_ST_SHIFT (21U)
/*! BANK13_FSM_ST - Bank13 FSM St */
#define APU_LMU_CPU2_STA_STATUS2_BANK13_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK13_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK13_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK14_FSM_ST_REP_DONE_MASK (0x1000000U)
#define APU_LMU_CPU2_STA_STATUS2_BANK14_FSM_ST_REP_DONE_SHIFT (24U)
/*! BANK14_FSM_ST_REP_DONE - Bank14 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS2_BANK14_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK14_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK14_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK14_FSM_ST_MASK (0xE000000U)
#define APU_LMU_CPU2_STA_STATUS2_BANK14_FSM_ST_SHIFT (25U)
/*! BANK14_FSM_ST - Bank14 FSM St */
#define APU_LMU_CPU2_STA_STATUS2_BANK14_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK14_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK14_FSM_ST_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK15_FSM_ST_REP_DONE_MASK (0x10000000U)
#define APU_LMU_CPU2_STA_STATUS2_BANK15_FSM_ST_REP_DONE_SHIFT (28U)
/*! BANK15_FSM_ST_REP_DONE - Bank15 FSM St Rep Done */
#define APU_LMU_CPU2_STA_STATUS2_BANK15_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK15_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK15_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU2_STA_STATUS2_BANK15_FSM_ST_MASK (0xE0000000U)
#define APU_LMU_CPU2_STA_STATUS2_BANK15_FSM_ST_SHIFT (29U)
/*! BANK15_FSM_ST - Bank15 FSM St */
#define APU_LMU_CPU2_STA_STATUS2_BANK15_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU2_STA_STATUS2_BANK15_FSM_ST_SHIFT)) & APU_LMU_CPU2_STA_STATUS2_BANK15_FSM_ST_MASK)
/*! @} */

/*! @name LMU_CPU3_STA_STATUS2 - LMU CPU3 STA Status 2 */
/*! @{ */

#define APU_LMU_CPU3_STA_STATUS2_BANK8_FSM_ST_REP_DONE_MASK (0x1U)
#define APU_LMU_CPU3_STA_STATUS2_BANK8_FSM_ST_REP_DONE_SHIFT (0U)
/*! BANK8_FSM_ST_REP_DONE - Bank8 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS2_BANK8_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK8_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK8_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK8_FSM_ST_MASK (0xEU)
#define APU_LMU_CPU3_STA_STATUS2_BANK8_FSM_ST_SHIFT (1U)
/*! BANK8_FSM_ST - Bank8 FSM St */
#define APU_LMU_CPU3_STA_STATUS2_BANK8_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK8_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK8_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK9_FSM_ST_REP_DONE_MASK (0x10U)
#define APU_LMU_CPU3_STA_STATUS2_BANK9_FSM_ST_REP_DONE_SHIFT (4U)
/*! BANK9_FSM_ST_REP_DONE - Bank9 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS2_BANK9_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK9_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK9_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK9_FSM_ST_MASK (0xE0U)
#define APU_LMU_CPU3_STA_STATUS2_BANK9_FSM_ST_SHIFT (5U)
/*! BANK9_FSM_ST - Bank9 FSM St */
#define APU_LMU_CPU3_STA_STATUS2_BANK9_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK9_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK9_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK10_FSM_ST_REP_DONE_MASK (0x100U)
#define APU_LMU_CPU3_STA_STATUS2_BANK10_FSM_ST_REP_DONE_SHIFT (8U)
/*! BANK10_FSM_ST_REP_DONE - Bank10 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS2_BANK10_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK10_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK10_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK10_FSM_ST_MASK (0xE00U)
#define APU_LMU_CPU3_STA_STATUS2_BANK10_FSM_ST_SHIFT (9U)
/*! BANK10_FSM_ST - Bank10 FSM St */
#define APU_LMU_CPU3_STA_STATUS2_BANK10_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK10_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK10_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK11_FSM_ST_REP_DONE_MASK (0x1000U)
#define APU_LMU_CPU3_STA_STATUS2_BANK11_FSM_ST_REP_DONE_SHIFT (12U)
/*! BANK11_FSM_ST_REP_DONE - Bank11 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS2_BANK11_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK11_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK11_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK11_FSM_ST_MASK (0xE000U)
#define APU_LMU_CPU3_STA_STATUS2_BANK11_FSM_ST_SHIFT (13U)
/*! BANK11_FSM_ST - Bank11 FSM St */
#define APU_LMU_CPU3_STA_STATUS2_BANK11_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK11_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK11_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK12_FSM_ST_REP_DONE_MASK (0x10000U)
#define APU_LMU_CPU3_STA_STATUS2_BANK12_FSM_ST_REP_DONE_SHIFT (16U)
/*! BANK12_FSM_ST_REP_DONE - Bank12 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS2_BANK12_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK12_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK12_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK12_FSM_ST_MASK (0xE0000U)
#define APU_LMU_CPU3_STA_STATUS2_BANK12_FSM_ST_SHIFT (17U)
/*! BANK12_FSM_ST - Bank12 FSM St */
#define APU_LMU_CPU3_STA_STATUS2_BANK12_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK12_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK12_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK13_FSM_ST_REP_DONE_MASK (0x100000U)
#define APU_LMU_CPU3_STA_STATUS2_BANK13_FSM_ST_REP_DONE_SHIFT (20U)
/*! BANK13_FSM_ST_REP_DONE - Bank13 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS2_BANK13_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK13_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK13_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK13_FSM_ST_MASK (0xE00000U)
#define APU_LMU_CPU3_STA_STATUS2_BANK13_FSM_ST_SHIFT (21U)
/*! BANK13_FSM_ST - Bank13 FSM St */
#define APU_LMU_CPU3_STA_STATUS2_BANK13_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK13_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK13_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK14_FSM_ST_REP_DONE_MASK (0x1000000U)
#define APU_LMU_CPU3_STA_STATUS2_BANK14_FSM_ST_REP_DONE_SHIFT (24U)
/*! BANK14_FSM_ST_REP_DONE - Bank14 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS2_BANK14_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK14_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK14_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK14_FSM_ST_MASK (0xE000000U)
#define APU_LMU_CPU3_STA_STATUS2_BANK14_FSM_ST_SHIFT (25U)
/*! BANK14_FSM_ST - Bank14 FSM St */
#define APU_LMU_CPU3_STA_STATUS2_BANK14_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK14_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK14_FSM_ST_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK15_FSM_ST_REP_DONE_MASK (0x10000000U)
#define APU_LMU_CPU3_STA_STATUS2_BANK15_FSM_ST_REP_DONE_SHIFT (28U)
/*! BANK15_FSM_ST_REP_DONE - Bank15 FSM St Rep Done */
#define APU_LMU_CPU3_STA_STATUS2_BANK15_FSM_ST_REP_DONE(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK15_FSM_ST_REP_DONE_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK15_FSM_ST_REP_DONE_MASK)

#define APU_LMU_CPU3_STA_STATUS2_BANK15_FSM_ST_MASK (0xE0000000U)
#define APU_LMU_CPU3_STA_STATUS2_BANK15_FSM_ST_SHIFT (29U)
/*! BANK15_FSM_ST - Bank15 FSM St */
#define APU_LMU_CPU3_STA_STATUS2_BANK15_FSM_ST(x) (((uint32_t)(((uint32_t)(x)) << APU_LMU_CPU3_STA_STATUS2_BANK15_FSM_ST_SHIFT)) & APU_LMU_CPU3_STA_STATUS2_BANK15_FSM_ST_MASK)
/*! @} */

/*! @name CPU3_HOST_WKUP_MASK - CPU3 Host Wakeup Mask */
/*! @{ */

#define APU_CPU3_HOST_WKUP_MASK_HOST_WKUP_MASK_MASK (0xFFFFU)
#define APU_CPU3_HOST_WKUP_MASK_HOST_WKUP_MASK_SHIFT (0U)
/*! HOST_WKUP_MASK - Host Wakeup Mask */
#define APU_CPU3_HOST_WKUP_MASK_HOST_WKUP_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU3_HOST_WKUP_MASK_HOST_WKUP_MASK_SHIFT)) & APU_CPU3_HOST_WKUP_MASK_HOST_WKUP_MASK_MASK)
/*! @} */

/*! @name CPU3_HOST_WKUP_POL - CPU3 Host Wakeup Polarity */
/*! @{ */

#define APU_CPU3_HOST_WKUP_POL_HOST_WKUP_POL_MASK (0xFFFFU)
#define APU_CPU3_HOST_WKUP_POL_HOST_WKUP_POL_SHIFT (0U)
/*! HOST_WKUP_POL - Host Wakeup Polarity */
#define APU_CPU3_HOST_WKUP_POL_HOST_WKUP_POL(x)  (((uint32_t)(((uint32_t)(x)) << APU_CPU3_HOST_WKUP_POL_HOST_WKUP_POL_SHIFT)) & APU_CPU3_HOST_WKUP_POL_HOST_WKUP_POL_MASK)
/*! @} */

/*! @name CPU3_HOST_WKUP_CTRL - CPU3 Host Wakeup Control */
/*! @{ */

#define APU_CPU3_HOST_WKUP_CTRL_HOST_WKUP_CTRL_MASK (0xFFFFU)
#define APU_CPU3_HOST_WKUP_CTRL_HOST_WKUP_CTRL_SHIFT (0U)
/*! HOST_WKUP_CTRL - Host Wakeup Control */
#define APU_CPU3_HOST_WKUP_CTRL_HOST_WKUP_CTRL(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU3_HOST_WKUP_CTRL_HOST_WKUP_CTRL_SHIFT)) & APU_CPU3_HOST_WKUP_CTRL_HOST_WKUP_CTRL_MASK)

#define APU_CPU3_HOST_WKUP_CTRL_HOST_INTR_MASK_MASK (0xFFFF0000U)
#define APU_CPU3_HOST_WKUP_CTRL_HOST_INTR_MASK_SHIFT (16U)
/*! HOST_INTR_MASK - Host Interrupt Mask */
#define APU_CPU3_HOST_WKUP_CTRL_HOST_INTR_MASK(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU3_HOST_WKUP_CTRL_HOST_INTR_MASK_SHIFT)) & APU_CPU3_HOST_WKUP_CTRL_HOST_INTR_MASK_MASK)
/*! @} */

/*! @name CPU3_CTRL - CPU3 Control */
/*! @{ */

#define APU_CPU3_CTRL_CPU3_MSG_RDY_MASK_MASK     (0x1U)
#define APU_CPU3_CTRL_CPU3_MSG_RDY_MASK_SHIFT    (0U)
/*! CPU3_MSG_RDY_MASK - CPU3 Message Ready Mask */
#define APU_CPU3_CTRL_CPU3_MSG_RDY_MASK(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU3_CTRL_CPU3_MSG_RDY_MASK_SHIFT)) & APU_CPU3_CTRL_CPU3_MSG_RDY_MASK_MASK)

#define APU_CPU3_CTRL_CPU3_CP15_SLP_BYPASS_VAL_MASK (0x4U)
#define APU_CPU3_CTRL_CPU3_CP15_SLP_BYPASS_VAL_SHIFT (2U)
/*! CPU3_CP15_SLP_BYPASS_VAL - CPU3 CP15 Sleep Bypass Value */
#define APU_CPU3_CTRL_CPU3_CP15_SLP_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU3_CTRL_CPU3_CP15_SLP_BYPASS_VAL_SHIFT)) & APU_CPU3_CTRL_CPU3_CP15_SLP_BYPASS_VAL_MASK)

#define APU_CPU3_CTRL_CPU3_CP15_SLP_BYPASS_EN_MASK (0x8U)
#define APU_CPU3_CTRL_CPU3_CP15_SLP_BYPASS_EN_SHIFT (3U)
/*! CPU3_CP15_SLP_BYPASS_EN - CPU3 CP15 Sleep Bypass Enable */
#define APU_CPU3_CTRL_CPU3_CP15_SLP_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU3_CTRL_CPU3_CP15_SLP_BYPASS_EN_SHIFT)) & APU_CPU3_CTRL_CPU3_CP15_SLP_BYPASS_EN_MASK)

#define APU_CPU3_CTRL_SOC_USE_REF_ONLY_MASK      (0x10U)
#define APU_CPU3_CTRL_SOC_USE_REF_ONLY_SHIFT     (4U)
/*! SOC_USE_REF_ONLY - SoC Use Ref Only */
#define APU_CPU3_CTRL_SOC_USE_REF_ONLY(x)        (((uint32_t)(((uint32_t)(x)) << APU_CPU3_CTRL_SOC_USE_REF_ONLY_SHIFT)) & APU_CPU3_CTRL_SOC_USE_REF_ONLY_MASK)

#define APU_CPU3_CTRL_GENERIC_TIMER_EN2_MASK     (0x20U)
#define APU_CPU3_CTRL_GENERIC_TIMER_EN2_SHIFT    (5U)
/*! GENERIC_TIMER_EN2 - Generic Timer Enable 2 */
#define APU_CPU3_CTRL_GENERIC_TIMER_EN2(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU3_CTRL_GENERIC_TIMER_EN2_SHIFT)) & APU_CPU3_CTRL_GENERIC_TIMER_EN2_MASK)

#define APU_CPU3_CTRL_APU_SUBSYS3_HOST_MASK      (0x70000U)
#define APU_CPU3_CTRL_APU_SUBSYS3_HOST_SHIFT     (16U)
/*! APU_SUBSYS3_HOST - APU Subsystem 2 Host */
#define APU_CPU3_CTRL_APU_SUBSYS3_HOST(x)        (((uint32_t)(((uint32_t)(x)) << APU_CPU3_CTRL_APU_SUBSYS3_HOST_SHIFT)) & APU_CPU3_CTRL_APU_SUBSYS3_HOST_MASK)
/*! @} */

/*! @name CPU3_DVFS_CTRL - CPU3 DVFS Control */
/*! @{ */

#define APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_INDEX_MASK (0xFU)
#define APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_INDEX_SHIFT (0U)
/*! CPU3_ACTIVE_INDEX - CPU3 Active Index */
#define APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_INDEX(x)  (((uint32_t)(((uint32_t)(x)) << APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_INDEX_SHIFT)) & APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_INDEX_MASK)

#define APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_INDEX_MASK (0xF0U)
#define APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_INDEX_SHIFT (4U)
/*! CPU3_INACTIVE_INDEX - CPU3 Inactive Index */
#define APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_INDEX_SHIFT)) & APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_INDEX_MASK)

#define APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_SYS_INDEX_MASK (0xF00U)
#define APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_SYS_INDEX_SHIFT (8U)
/*! CPU3_ACTIVE_SYS_INDEX - CPU3 Active System Index */
#define APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_SYS_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_SYS_INDEX_SHIFT)) & APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_SYS_INDEX_MASK)

#define APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_SYS_INDEX_MASK (0xF000U)
#define APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_SYS_INDEX_SHIFT (12U)
/*! CPU3_INACTIVE_SYS_INDEX - CPU3 Inactive System Index */
#define APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_SYS_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_SYS_INDEX_SHIFT)) & APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_SYS_INDEX_MASK)

#define APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_AHB1_INDEX_MASK (0xF0000U)
#define APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_AHB1_INDEX_SHIFT (16U)
/*! CPU3_ACTIVE_AHB1_INDEX - CPU3 Active AHB1 Index */
#define APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_AHB1_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_AHB1_INDEX_SHIFT)) & APU_CPU3_DVFS_CTRL_CPU3_ACTIVE_AHB1_INDEX_MASK)

#define APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_AHB1_INDEX_MASK (0xF00000U)
#define APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_AHB1_INDEX_SHIFT (20U)
/*! CPU3_INACTIVE_AHB1_INDEX - CPU3 Inactive AHB1 Index */
#define APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_AHB1_INDEX(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_AHB1_INDEX_SHIFT)) & APU_CPU3_DVFS_CTRL_CPU3_INACTIVE_AHB1_INDEX_MASK)

#define APU_CPU3_DVFS_CTRL_CPU3_AHB1_INDEX_SEL_METHOD_MASK (0x1000000U)
#define APU_CPU3_DVFS_CTRL_CPU3_AHB1_INDEX_SEL_METHOD_SHIFT (24U)
/*! CPU3_AHB1_INDEX_SEL_METHOD - CPU3 AHB1 index select method */
#define APU_CPU3_DVFS_CTRL_CPU3_AHB1_INDEX_SEL_METHOD(x) (((uint32_t)(((uint32_t)(x)) << APU_CPU3_DVFS_CTRL_CPU3_AHB1_INDEX_SEL_METHOD_SHIFT)) & APU_CPU3_DVFS_CTRL_CPU3_AHB1_INDEX_SEL_METHOD_MASK)

#define APU_CPU3_DVFS_CTRL_UART_VOL_VAL_MASK     (0xFE000000U)
#define APU_CPU3_DVFS_CTRL_UART_VOL_VAL_SHIFT    (25U)
/*! UART_VOL_VAL - UART Vol Value */
#define APU_CPU3_DVFS_CTRL_UART_VOL_VAL(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU3_DVFS_CTRL_UART_VOL_VAL_SHIFT)) & APU_CPU3_DVFS_CTRL_UART_VOL_VAL_MASK)
/*! @} */

/*! @name CPU3_FREQ_REG1 - CPU3 Frequency 1 */
/*! @{ */

#define APU_CPU3_FREQ_REG1_CPU3_FREQ_REG1_MASK   (0xFFFFFFFFU)
#define APU_CPU3_FREQ_REG1_CPU3_FREQ_REG1_SHIFT  (0U)
/*! CPU3_FREQ_REG1 - CPU3 Frequency 1 */
#define APU_CPU3_FREQ_REG1_CPU3_FREQ_REG1(x)     (((uint32_t)(((uint32_t)(x)) << APU_CPU3_FREQ_REG1_CPU3_FREQ_REG1_SHIFT)) & APU_CPU3_FREQ_REG1_CPU3_FREQ_REG1_MASK)
/*! @} */

/*! @name CPU3_FREQ_REG2 - CPU3 Frequency 2 */
/*! @{ */

#define APU_CPU3_FREQ_REG2_CPU3_FREQ_REG2_MASK   (0xFFFFFFFFU)
#define APU_CPU3_FREQ_REG2_CPU3_FREQ_REG2_SHIFT  (0U)
/*! CPU3_FREQ_REG2 - CPU3Frequency 2 */
#define APU_CPU3_FREQ_REG2_CPU3_FREQ_REG2(x)     (((uint32_t)(((uint32_t)(x)) << APU_CPU3_FREQ_REG2_CPU3_FREQ_REG2_SHIFT)) & APU_CPU3_FREQ_REG2_CPU3_FREQ_REG2_MASK)
/*! @} */

/*! @name CPU3_PLL_EN_REG - CPU3 PLL Enable */
/*! @{ */

#define APU_CPU3_PLL_EN_REG_CPU3_PLL_EN_REG_MASK (0xFFFFFFFFU)
#define APU_CPU3_PLL_EN_REG_CPU3_PLL_EN_REG_SHIFT (0U)
/*! CPU3_PLL_EN_REG - CPU3 PLL Enable */
#define APU_CPU3_PLL_EN_REG_CPU3_PLL_EN_REG(x)   (((uint32_t)(((uint32_t)(x)) << APU_CPU3_PLL_EN_REG_CPU3_PLL_EN_REG_SHIFT)) & APU_CPU3_PLL_EN_REG_CPU3_PLL_EN_REG_MASK)
/*! @} */

/*! @name CPU3_VOL_REG1 - CPU3 Voltage 1 */
/*! @{ */

#define APU_CPU3_VOL_REG1_CPU3_VOL_REG1_MASK     (0xFFFFFFFFU)
#define APU_CPU3_VOL_REG1_CPU3_VOL_REG1_SHIFT    (0U)
/*! CPU3_VOL_REG1 - CPU3 Voltage 1 */
#define APU_CPU3_VOL_REG1_CPU3_VOL_REG1(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU3_VOL_REG1_CPU3_VOL_REG1_SHIFT)) & APU_CPU3_VOL_REG1_CPU3_VOL_REG1_MASK)
/*! @} */

/*! @name CPU3_VOL_REG2 - CPU3 Voltage 2 */
/*! @{ */

#define APU_CPU3_VOL_REG2_CPU3_VOL_REG2_MASK     (0xFFFFFFFFU)
#define APU_CPU3_VOL_REG2_CPU3_VOL_REG2_SHIFT    (0U)
/*! CPU3_VOL_REG2 - CPU3 Voltage 2 */
#define APU_CPU3_VOL_REG2_CPU3_VOL_REG2(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU3_VOL_REG2_CPU3_VOL_REG2_SHIFT)) & APU_CPU3_VOL_REG2_CPU3_VOL_REG2_MASK)
/*! @} */

/*! @name CPU3_VOL_REG3 - CPU3 Voltage 3 */
/*! @{ */

#define APU_CPU3_VOL_REG3_CPU3_VOL_REG3_MASK     (0xFFFFFFFFU)
#define APU_CPU3_VOL_REG3_CPU3_VOL_REG3_SHIFT    (0U)
/*! CPU3_VOL_REG3 - CPU3 Voltage 3 */
#define APU_CPU3_VOL_REG3_CPU3_VOL_REG3(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU3_VOL_REG3_CPU3_VOL_REG3_SHIFT)) & APU_CPU3_VOL_REG3_CPU3_VOL_REG3_MASK)
/*! @} */

/*! @name CPU3_VOL_REG4 - CPU3 Voltage 4 */
/*! @{ */

#define APU_CPU3_VOL_REG4_CPU3_VOL_REG4_MASK     (0xFFFFFFFFU)
#define APU_CPU3_VOL_REG4_CPU3_VOL_REG4_SHIFT    (0U)
/*! CPU3_VOL_REG4 - CPU3 Voltage 4 */
#define APU_CPU3_VOL_REG4_CPU3_VOL_REG4(x)       (((uint32_t)(((uint32_t)(x)) << APU_CPU3_VOL_REG4_CPU3_VOL_REG4_SHIFT)) & APU_CPU3_VOL_REG4_CPU3_VOL_REG4_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group APU_Register_Masks */


/* APU - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral APU0 base address */
  #define APU0_BASE                                (0x51258400u)
  /** Peripheral APU0 base address */
  #define APU0_BASE_NS                             (0x41258400u)
  /** Peripheral APU0 base pointer */
  #define APU0                                     ((APU_Type *)APU0_BASE)
  /** Peripheral APU0 base pointer */
  #define APU0_NS                                  ((APU_Type *)APU0_BASE_NS)
  /** Peripheral APU1 base address */
  #define APU1_BASE                                (0x54258400u)
  /** Peripheral APU1 base address */
  #define APU1_BASE_NS                             (0x44258400u)
  /** Peripheral APU1 base pointer */
  #define APU1                                     ((APU_Type *)APU1_BASE)
  /** Peripheral APU1 base pointer */
  #define APU1_NS                                  ((APU_Type *)APU1_BASE_NS)
  /** Array initializer of APU peripheral base addresses */
  #define APU_BASE_ADDRS                           { APU0_BASE, APU1_BASE }
  /** Array initializer of APU peripheral base pointers */
  #define APU_BASE_PTRS                            { APU0, APU1 }
  /** Array initializer of APU peripheral base addresses */
  #define APU_BASE_ADDRS_NS                        { APU0_BASE_NS, APU1_BASE_NS }
  /** Array initializer of APU peripheral base pointers */
  #define APU_BASE_PTRS_NS                         { APU0_NS, APU1_NS }
#else
  /** Peripheral APU0 base address */
  #define APU0_BASE                                (0x41258400u)
  /** Peripheral APU0 base pointer */
  #define APU0                                     ((APU_Type *)APU0_BASE)
  /** Peripheral APU1 base address */
  #define APU1_BASE                                (0x44258400u)
  /** Peripheral APU1 base pointer */
  #define APU1                                     ((APU_Type *)APU1_BASE)
  /** Array initializer of APU peripheral base addresses */
  #define APU_BASE_ADDRS                           { APU0_BASE, APU1_BASE }
  /** Array initializer of APU peripheral base pointers */
  #define APU_BASE_PTRS                            { APU0, APU1 }
#endif

/*!
 * @}
 */ /* end of group APU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- BG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BG_Peripheral_Access_Layer BG Peripheral Access Layer
 * @{
 */

/** BG - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< Control Register, offset: 0x0 */
  __I  uint32_t STATUS;                            /**< Status Register, offset: 0x4 */
} BG_Type;

/* ----------------------------------------------------------------------------
   -- BG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BG_Register_Masks BG Register Masks
 * @{
 */

/*! @name CTRL - Control Register */
/*! @{ */

#define BG_CTRL_PD_MASK                          (0x1U)
#define BG_CTRL_PD_SHIFT                         (0U)
/*! PD - Bandgap power down.
 *  0b1..Power down
 *  0b0..Power up
 */
#define BG_CTRL_PD(x)                            (((uint32_t)(((uint32_t)(x)) << BG_CTRL_PD_SHIFT)) & BG_CTRL_PD_MASK)

#define BG_CTRL_RES_TRIM_MASK                    (0xF0U)
#define BG_CTRL_RES_TRIM_SHIFT                   (4U)
/*! RES_TRIM - 1.2V voltage reference resistor trim.
 *  0b0000..1.159V
 *  0b0001..1.163V
 *  0b0010..1.168V
 *  0b0011..1.172V
 *  0b0100..1.177V
 *  0b0101..1.181V
 *  0b0110..1.186V
 *  0b0111..1.190V
 *  0b1000..1.194V
 *  0b1001..1.199V
 *  0b1010..1.204V
 *  0b1011..1.208V
 *  0b1100..1.213V
 *  0b1101..1.217V
 *  0b1110..1.222V
 *  0b1111..1.226V
 */
#define BG_CTRL_RES_TRIM(x)                      (((uint32_t)(((uint32_t)(x)) << BG_CTRL_RES_TRIM_SHIFT)) & BG_CTRL_RES_TRIM_MASK)
/*! @} */

/*! @name STATUS - Status Register */
/*! @{ */

#define BG_STATUS_RDY_MASK                       (0x1U)
#define BG_STATUS_RDY_SHIFT                      (0U)
/*! RDY - 1'b1 indicates BG ready flag. */
#define BG_STATUS_RDY(x)                         (((uint32_t)(((uint32_t)(x)) << BG_STATUS_RDY_SHIFT)) & BG_STATUS_RDY_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group BG_Register_Masks */


/* BG - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral GAU_BG base address */
  #define GAU_BG_BASE                              (0x50038700u)
  /** Peripheral GAU_BG base address */
  #define GAU_BG_BASE_NS                           (0x40038700u)
  /** Peripheral GAU_BG base pointer */
  #define GAU_BG                                   ((BG_Type *)GAU_BG_BASE)
  /** Peripheral GAU_BG base pointer */
  #define GAU_BG_NS                                ((BG_Type *)GAU_BG_BASE_NS)
  /** Array initializer of BG peripheral base addresses */
  #define BG_BASE_ADDRS                            { GAU_BG_BASE }
  /** Array initializer of BG peripheral base pointers */
  #define BG_BASE_PTRS                             { GAU_BG }
  /** Array initializer of BG peripheral base addresses */
  #define BG_BASE_ADDRS_NS                         { GAU_BG_BASE_NS }
  /** Array initializer of BG peripheral base pointers */
  #define BG_BASE_PTRS_NS                          { GAU_BG_NS }
#else
  /** Peripheral GAU_BG base address */
  #define GAU_BG_BASE                              (0x40038700u)
  /** Peripheral GAU_BG base pointer */
  #define GAU_BG                                   ((BG_Type *)GAU_BG_BASE)
  /** Array initializer of BG peripheral base addresses */
  #define BG_BASE_ADDRS                            { GAU_BG_BASE }
  /** Array initializer of BG peripheral base pointers */
  #define BG_BASE_PTRS                             { GAU_BG }
#endif

/*!
 * @}
 */ /* end of group BG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- BLEAPU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BLEAPU_Peripheral_Access_Layer BLEAPU Peripheral Access Layer
 * @{
 */

/** BLEAPU - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[8];
  __IO uint32_t SOCBTAPU_APU_BYPASS0;              /**< APU Bypass0, offset: 0x8 */
  __IO uint32_t SOCBTAPU_APU_PWR_CTRL_BYPASS0;     /**< APU power control Bypass Register 0, offset: 0xC */
       uint8_t RESERVED_1[12];
  __IO uint32_t SOCBTAPU_APU_BYPASS1;              /**< APU Bypass Register 1, offset: 0x1C */
  __IO uint32_t SOCBTAPU_APU_BYPASS2;              /**< APU Bypass Register 2, offset: 0x20 */
  __IO uint32_t SOCBTAPU_APU_BYPASS3;              /**< APU Bypass Register 3, offset: 0x24 */
  __IO uint32_t SOCBTAPU_APU_CTRL;                 /**< APU Control, offset: 0x28 */
  __I  uint32_t SOCBTAPU_APU_STATUS;               /**< APU Status Register, offset: 0x2C */
  __IO uint32_t SOCBTAPU_CPU1_LMU_STA_BYPASS0;     /**< LMU static bank control byapss0 Register, offset: 0x30 */
  __IO uint32_t SOCBTAPU_CPU1_LMU_STA_BYPASS1;     /**< LMU static bank control byapss1 Register, offset: 0x34 */
  __IO uint32_t SOCBTAPU_CPU1_LMU_STA_BYPASS2;     /**< LMU static bank byapss2 Register, offset: 0x38 */
  __IO uint32_t SOCBTAPU_LMU_DYN_BYPASS0;          /**< LMU dynamic bank control byapss0 Register, offset: 0x3C */
  __IO uint32_t SOCBTAPU_LMU_G2BIST_CTRL_BYPASS;   /**< LMU G2Bist control bypass Register, offset: 0x40 */
       uint8_t RESERVED_2[12];
  __IO uint32_t SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS; /**< LMU G2Bist control bypass Register for CPU1, offset: 0x50 */
       uint8_t RESERVED_3[8];
  __IO uint32_t SOCBTAPU_APU_PWR_CTRL_BYPASS5;     /**< ", offset: 0x5C */
       uint8_t RESERVED_4[8];
  __IO uint32_t SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0;  /**< LMU static bank control byapss0 Register for smu1 hybrid banks mem, offset: 0x68 */
  __IO uint32_t SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1;  /**< LMU static bank control byapss1 Register for smu1 hybrid banks mem, offset: 0x6C */
  __IO uint32_t SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2;  /**< LMU static bank control byapss2 Register for smu1 hybrid banks mem, offset: 0x70 */
       uint8_t RESERVED_5[8];
  __IO uint32_t SOCBTAPU_APU_ECO_CTRL;             /**< APU ECO Control, offset: 0x7C */
  __IO uint32_t SOCBTAPU_GPIO_WKUP_CTRL0;          /**< ", offset: 0x80 */
  __IO uint32_t SOCBTAPU_GPIO_WKUP_CTRL1;          /**< ", offset: 0x84 */
  __IO uint32_t SOCBTAPU_GPIO_WKUP_CTRL2;          /**< ", offset: 0x88 */
  __IO uint32_t SOCBTAPU_GPIO_WKUP_CTRL3;          /**< ", offset: 0x8C */
  __IO uint32_t SOCBTAPU_HOST_WKUP_MODE;           /**< ", offset: 0x90 */
  __IO uint32_t SOCBTAPU_T3_CLK_DIV_EN_BYPASS;     /**< ", offset: 0x94 */
  __IO uint32_t SOCBTAPU_LDO_LV_CTRL2;             /**< LV LDO Control 2, offset: 0x98 */
  __IO uint32_t SOCBTAPU_CAU_BYPASS;               /**< CAU Bypass, offset: 0x9C */
       uint8_t RESERVED_6[4];
  __IO uint32_t SOCBTAPU_MEM_PWDN2;                /**< Memory Powerdown Control, offset: 0xA4 */
       uint8_t RESERVED_7[8];
  __IO uint32_t SOCBTAPU_HOST_WKUP_SOURCE;         /**< Host Wakeup Source Control, offset: 0xB0 */
} BLEAPU_Type;

/* ----------------------------------------------------------------------------
   -- BLEAPU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BLEAPU_Register_Masks BLEAPU Register Masks
 * @{
 */

/*! @name SOCBTAPU_APU_BYPASS0 - APU Bypass0 */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_EN_MASK (0x1U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_EN_SHIFT (0U)
/*! C2P_XOSC_EN_BYPASS_EN - C2p_Xosc_En_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_EN_MASK (0x2U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_EN_SHIFT (1U)
/*! TBG_TCPU_PDB_BYPASS_EN - TCPU_Pdb_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_EN_MASK (0x4U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_EN_SHIFT (2U)
/*! TBG_BBU1_CLK_EN_BYPASS_EN - TBG512_320_176_BBU1_Clk_En_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_EN_MASK (0x8U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_EN_SHIFT (3U)
/*! TBG_T2_PDB_BYPASS_EN - tbg t2_Pdb_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_EN_MASK (0x10U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_EN_SHIFT (4U)
/*! TBG_MAC1_CLK_EN_BYPASS_EN - TBG512_320_176_MAC1_Clk_En_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_EN_MASK (0x20U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_EN_SHIFT (5U)
/*! TBG_SOC_CLK_EN_BYPASS_EN - TBG512_320_176_SoC_Clk_En_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_EN_MASK (0x40U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_EN_SHIFT (6U)
/*! TBG_BBU2_CLK_EN_BYPASS_EN - TBG512_320_176_BBU2_Clk_En_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_EN_MASK (0x80U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_EN_SHIFT (7U)
/*! TBG_MAC2_CLK_EN_BYPASS_EN - TBG512_320_176_MAC2_Clk_En_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_EN_MASK (0x400U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_EN_SHIFT (10U)
/*! TX_PE_BYPASS_EN - BBU_Rx_Pe_Bypass Enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_EN_MASK (0x800U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_EN_SHIFT (11U)
/*! RX_PE_BYPASS_EN - BBU_Rx_Pe_Bypass Enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_EN_MASK (0x1000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_EN_SHIFT (12U)
/*! RFU_PE1_BYPASS_EN - RFU_PE1_Bypass Enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_EN_MASK (0x2000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_EN_SHIFT (13U)
/*! RFU_PE2_BYPASS_EN - RFU_PE2_Bypass Enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_EN_MASK (0x4000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_EN_SHIFT (14U)
/*! RFU_PA_PE_A_BYPASS_EN - RFU_PA_PE_A_Bypass Enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_EN_MASK (0x8000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_EN_SHIFT (15U)
/*! RFU_PA_PE_G_BYPASS_EN - RFU_PA_PE_G_Bypass Enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_VAL_MASK (0x10000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_VAL_SHIFT (16U)
/*! C2P_XOSC_EN_BYPASS_VAL - C2p_Xosc_En Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_VAL_MASK (0x20000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_VAL_SHIFT (17U)
/*! TBG_TCPU_PDB_BYPASS_VAL - TCPU_Pdb Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_VAL_MASK (0x40000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_VAL_SHIFT (18U)
/*! TBG_BBU1_CLK_EN_BYPASS_VAL - TBG512_320_176_BBU1_Clk_En Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_VAL_MASK (0x80000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_VAL_SHIFT (19U)
/*! TBG_T2_PDB_BYPASS_VAL - TBF176_Pdb Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_VAL_MASK (0x100000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_VAL_SHIFT (20U)
/*! TBG_MAC1_CLK_EN_BYPASS_VAL - TBG512_320_176_MAC1_Clk_En Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_VAL_MASK (0x200000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_VAL_SHIFT (21U)
/*! TBG_SOC_CLK_EN_BYPASS_VAL - TBG512_320_176_SoC_Clk_En Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_VAL_MASK (0x400000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_VAL_SHIFT (22U)
/*! TBG_BBU2_CLK_EN_BYPASS_VAL - TBG512_320_176_BBU2_Clk_En Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_VAL_MASK (0x800000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_VAL_SHIFT (23U)
/*! TBG_MAC2_CLK_EN_BYPASS_VAL - TBG512_320_176_MAC2_Clk_En Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_VAL_MASK (0x4000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_VAL_SHIFT (26U)
/*! TX_PE_BYPASS_VAL - Tx_Pe Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_VAL_MASK (0x8000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_VAL_SHIFT (27U)
/*! RX_PE_BYPASS_VAL - Rx_Pe Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_VAL_MASK (0x10000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_VAL_SHIFT (28U)
/*! RFU_PE1_BYPASS_VAL - RFU PE1 Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_VAL_MASK (0x20000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_VAL_SHIFT (29U)
/*! RFU_PE2_BYPASS_VAL - RFU PE2 Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_VAL_MASK (0x40000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_VAL_SHIFT (30U)
/*! RFU_PA_PE_A_BYPASS_VAL - RFU PA_PE_A Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_VAL_MASK (0x80000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_VAL_SHIFT (31U)
/*! RFU_PA_PE_G_BYPASS_VAL - RFU PA_PE_G Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_PWR_CTRL_BYPASS0 - APU power control Bypass Register 0 */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_VAL_MASK (0x1U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_VAL_SHIFT (0U)
/*! SOC_PSW_BYPASS_VAL - SoC Power Switch Control */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_EN_MASK (0x2U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_EN_SHIFT (1U)
/*! SOC_PSW_BYPASS_EN - SoC Power Switch Control Enable */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_VAL_MASK (0x4U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_VAL_SHIFT (2U)
/*! SOC_FWBAR_BYPASS_VAL - SoC Firewallbar Control */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_EN_MASK (0x8U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_EN_SHIFT (3U)
/*! SOC_FWBAR_BYPASS_EN - SoC Firewallbar Control Enable */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_VAL_MASK (0x10U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_VAL_SHIFT (4U)
/*! SOC_ISO_EN_BYPASS_VAL - SoC Isolation Cell Control */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_EN_MASK (0x20U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_EN_SHIFT (5U)
/*! SOC_ISO_EN_BYPASS_EN - SoC Isolation Cell Control Enable */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_VAL_MASK (0x40U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_VAL_SHIFT (6U)
/*! SOC_CLK_DIV_RSTB_BYPASS_VAL - Firmware Bypass Value for SoC Dlk_Div_Rstb (active low signal) */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_EN_MASK (0x80U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_EN_SHIFT (7U)
/*! SOC_CLK_DIV_RSTB_BYPASS_EN - Firmware Bypass SoC Clk_Div_Rstb from APU */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_VAL_MASK (0x100U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_VAL_SHIFT (8U)
/*! SOC_NON_UDR_RST_BYPASS_VAL - Firmware Bypass Value for SoC non udr rst (active low signal) */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_EN_MASK (0x200U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_EN_SHIFT (9U)
/*! SOC_NON_UDR_RST_BYPASS_EN - Firmware Bypass SoC non udr rst from APU (used for brf sif only in KF2) */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_EN_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_BYPASS1 - APU Bypass Register 1 */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_EN_MASK (0x40U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_EN_SHIFT (6U)
/*! SOC_CAU_XOSC_EN_BP_EN - Firmware Bypass Xosc_En to CAU and other parts of the chip including pads */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_VAL_MASK (0x80U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_VAL_SHIFT (7U)
/*! SOC_CAU_XOSC_EN_BP_VAL - Firmware Bypass Xosc_En Value for SoC_CAU_Xosc_En_Bp_En */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_RXPE_DYN_BYPASS_MASK (0x100U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_RXPE_DYN_BYPASS_SHIFT (8U)
/*! RXPE_DYN_BYPASS - Rxpe_Dyn_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_RXPE_DYN_BYPASS(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_RXPE_DYN_BYPASS_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_RXPE_DYN_BYPASS_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_PE1_DYN_BYPASS_MASK (0x200U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_PE1_DYN_BYPASS_SHIFT (9U)
/*! PE1_DYN_BYPASS - PE1_Dyn_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_PE1_DYN_BYPASS(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_PE1_DYN_BYPASS_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_PE1_DYN_BYPASS_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_PLL_OVERRIDE_BYPASS_MASK (0x400U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_PLL_OVERRIDE_BYPASS_SHIFT (10U)
/*! PLL_OVERRIDE_BYPASS - PLL Override Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_PLL_OVERRIDE_BYPASS(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_PLL_OVERRIDE_BYPASS_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_PLL_OVERRIDE_BYPASS_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_EN_MASK (0x40000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_EN_SHIFT (18U)
/*! BCA_CLK_EN_BYPASS_EN - Firmware Bypass BCA_Clk_En */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_VAL_MASK (0x80000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_VAL_SHIFT (19U)
/*! BCA_CLK_EN_BYPASS_VAL - Firmware Bypass Value for BCA_Clk_En (active high signal) */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_EN_MASK (0x4000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_EN_SHIFT (26U)
/*! SLNA_CLK_EN_BYPASS_EN - Firmware Bypass for SLNA_Clk_En */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_VAL_MASK (0x8000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_VAL_SHIFT (27U)
/*! SLNA_CLK_EN_BYPASS_VAL - Firmware Bypass Value for SLNA_Clk_En (active high signal) */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_BYPASS2 - APU Bypass Register 2 */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_EN_MASK (0x100U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_EN_SHIFT (8U)
/*! TBG_T3_PDB_BYPASS_EN - Firmware Bypass for T3_pdb pll */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_VAL_MASK (0x200U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_VAL_SHIFT (9U)
/*! TBG_T3_PDB_BYPASS_VAL - T3_Pdb Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_EN_MASK (0x400U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_EN_SHIFT (10U)
/*! T3_PI1_PDB_BYPASS_EN - Firmware Bypass for TBG256 aiu_pi1 */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_VAL_MASK (0x800U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_VAL_SHIFT (11U)
/*! T3_PI1_PDB_BYPASS_VAL - Firmware Bypass Value for TBG256 aiu pi1 */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_EN_MASK (0x1000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_EN_SHIFT (12U)
/*! T3_PI2_PDB_BYPASS_EN - Firmware Bypass for TBG256 aiu_pi2 */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_VAL_MASK (0x2000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_VAL_SHIFT (13U)
/*! T3_PI2_PDB_BYPASS_VAL - Firmware Bypass Value for TBG256 aiu_pi2 */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_EN_MASK (0x2000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_EN_SHIFT (25U)
/*! TBG_T1_STABLE_BYPASS_EN - Firmware Bypass enable for T1 pll_stable signal from APU */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_VAL_MASK (0x4000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_VAL_SHIFT (26U)
/*! TBG_T1_STABLE_BYPASS_VAL - Firmware Bypass value for T1 pll_stable signal from APU */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_EN_MASK (0x8000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_EN_SHIFT (27U)
/*! PMIC_DVSC_CTRL_BYPASS_EN - Firmware Bypass enable for pmic dvsc ctrl from APU */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_VAL_MASK (0x30000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_VAL_SHIFT (28U)
/*! PMIC_DVSC_CTRL_BYPASS_VAL - Firmware Bypass value for pmic dvsc ctrl from APU (default high power WLAN ode) */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_BYPASS3 - APU Bypass Register 3 */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_EN_MASK (0x10U)
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_EN_SHIFT (4U)
/*! SYS_CLK_EN_BYPASS_EN - Firmware Bypass for sys clock domain clock enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_VAL_MASK (0x20U)
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_VAL_SHIFT (5U)
/*! SYS_CLK_EN_BYPASS_VAL - Firmware Bypass Value for sys clock domain clock enable(active high signal) */
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_EN_MASK (0x4000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_EN_SHIFT (14U)
/*! SPSRAM_RST_BYPASS_EN - Firmware Bypass for Single power SRAM reset enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_VAL_MASK (0x8000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_VAL_SHIFT (15U)
/*! SPSRAM_RST_BYPASS_VAL - Firmware Bypass Value for single power sram reset(active low signal) */
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_EN_MASK (0x10000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_EN_SHIFT (16U)
/*! SLNA_BBUD_BRF_BYPASS_EN - Firmware Bypass for apu mux control of SLNA gain from bbud/brf */
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_VAL_MASK (0x20000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_VAL_SHIFT (17U)
/*! SLNA_BBUD_BRF_BYPASS_VAL - Firmware Bypass Value for apu mux control of SLNA gain from bbud/brf */
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_CTRL - APU Control */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_CTRL_APU_REFCLK_DIV_SEL_MASK (0xFU)
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_REFCLK_DIV_SEL_SHIFT (0U)
/*! APU_REFCLK_DIV_SEL - APU Reference Clock Divider Select */
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_REFCLK_DIV_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_APU_REFCLK_DIV_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_APU_REFCLK_DIV_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU_WAKEUP_MASK (0x10U)
#define BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU_WAKEUP_SHIFT (4U)
/*! FORCE_BTU_WAKEUP - Force BTU Wakeup */
#define BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU_WAKEUP_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU_WAKEUP_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_ISU_WKUP_IN_USE_MASK (0x40U)
#define BLEAPU_SOCBTAPU_APU_CTRL_ISU_WKUP_IN_USE_SHIFT (6U)
/*! ISU_WKUP_IN_USE - APU Wakeup */
#define BLEAPU_SOCBTAPU_APU_CTRL_ISU_WKUP_IN_USE(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_ISU_WKUP_IN_USE_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_ISU_WKUP_IN_USE_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_MASK (0x80U)
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_SHIFT (7U)
/*! APU_HOST_WKUP - APU Wakeup triggered by CPU2 */
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_BRF_INT_WAKEUP_MASK (0x100U)
#define BLEAPU_SOCBTAPU_APU_CTRL_BRF_INT_WAKEUP_SHIFT (8U)
/*! BRF_INT_WAKEUP - APU Wakeup */
#define BLEAPU_SOCBTAPU_APU_CTRL_BRF_INT_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_BRF_INT_WAKEUP_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_BRF_INT_WAKEUP_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MASK (0x200U)
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_SHIFT (9U)
/*! SOC_PA_PE_EN - PA_PE control from SoC to RFU SoC_PA_PE Input */
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_A_EN_MASK (0x400U)
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_A_EN_SHIFT (10U)
/*! SOC_PA_PE_A_EN - PA_PE_A control from SoC to Pad */
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_A_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_A_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_A_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_G_EN_MASK (0x800U)
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_G_EN_SHIFT (11U)
/*! SOC_PA_PE_G_EN - PA_PE_G control from SoC to Pad */
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_G_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_G_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_G_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_RFU_2G_SRAM_PD_METHOD_SEL_MASK (0x1000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_RFU_2G_SRAM_PD_METHOD_SEL_SHIFT (12U)
/*! RFU_2G_SRAM_PD_METHOD_SEL - Choose apu signal to use for SRAM PD of RFU 2G memories */
#define BLEAPU_SOCBTAPU_APU_CTRL_RFU_2G_SRAM_PD_METHOD_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_RFU_2G_SRAM_PD_METHOD_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_RFU_2G_SRAM_PD_METHOD_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_BRF_SRAM_PD_METHOD_SEL_MASK (0x2000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_BRF_SRAM_PD_METHOD_SEL_SHIFT (13U)
/*! BRF_SRAM_PD_METHOD_SEL - Choose apu signal to use for SRAM PD of BRF memories */
#define BLEAPU_SOCBTAPU_APU_CTRL_BRF_SRAM_PD_METHOD_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_BRF_SRAM_PD_METHOD_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_BRF_SRAM_PD_METHOD_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_LMU_BYPASS_MASK (0x8000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_LMU_BYPASS_SHIFT (15U)
/*! LMU_BYPASS - LMU global bypass bit */
#define BLEAPU_SOCBTAPU_APU_CTRL_LMU_BYPASS(x)   (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_LMU_BYPASS_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_LMU_BYPASS_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MAC2_MASK (0x10000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MAC2_SHIFT (16U)
/*! SOC_PA_PE_EN_MAC2 - PA_PE control from MAC2 to RFU SoC_PA_PE Input */
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MAC2(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MAC2_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MAC2_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_RFU_5G_SRAM_PD_METHOD_SEL_MASK (0x20000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_RFU_5G_SRAM_PD_METHOD_SEL_SHIFT (17U)
/*! RFU_5G_SRAM_PD_METHOD_SEL - Choose apu signal to use for SRAM PD of RFU 5G memories */
#define BLEAPU_SOCBTAPU_APU_CTRL_RFU_5G_SRAM_PD_METHOD_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_RFU_5G_SRAM_PD_METHOD_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_RFU_5G_SRAM_PD_METHOD_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU1_MASK (0x40000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU1_SHIFT (18U)
/*! APU_HOST_WKUP_CPU1 - APU Wakeup triggered by CPU1 */
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU1(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU1_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU1_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU3_MASK (0x80000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU3_SHIFT (19U)
/*! APU_HOST_WKUP_CPU3 - APU Wakeup triggered by CPU3 */
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU3(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU3_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU3_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU2_WAKEUP_MASK (0x100000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU2_WAKEUP_SHIFT (20U)
/*! FORCE_BTU2_WAKEUP - Force BTU2 Wakeup */
#define BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU2_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU2_WAKEUP_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU2_WAKEUP_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_STATUS - APU Status Register */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_STATUS_BRF_CLK_TBG_SEL_MASK (0x1U)
#define BLEAPU_SOCBTAPU_APU_STATUS_BRF_CLK_TBG_SEL_SHIFT (0U)
/*! BRF_CLK_TBG_SEL - Monitor BRF_Clk_TBG_Sel */
#define BLEAPU_SOCBTAPU_APU_STATUS_BRF_CLK_TBG_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_STATUS_BRF_CLK_TBG_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_STATUS_BRF_CLK_TBG_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_STATUS_BTU_CLK_TBG_SEL_MASK (0x2U)
#define BLEAPU_SOCBTAPU_APU_STATUS_BTU_CLK_TBG_SEL_SHIFT (1U)
/*! BTU_CLK_TBG_SEL - Monitor BTU_Clk_TBG_Sel */
#define BLEAPU_SOCBTAPU_APU_STATUS_BTU_CLK_TBG_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_STATUS_BTU_CLK_TBG_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_STATUS_BTU_CLK_TBG_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_T3_REF_SEL_MASK (0x4U)
#define BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_T3_REF_SEL_SHIFT (2U)
/*! SOC_CLK_T3_REF_SEL - Monitor SoC_Clk_T3_Ref_Sel */
#define BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_T3_REF_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_T3_REF_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_T3_REF_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_TBG_SEL_MASK (0x8U)
#define BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_TBG_SEL_SHIFT (3U)
/*! SOC_CLK_TBG_SEL - Monitor SoC_Clk_TBG_Sel */
#define BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_TBG_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_TBG_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_TBG_SEL_MASK)
/*! @} */

/*! @name SOCBTAPU_CPU1_LMU_STA_BYPASS0 - LMU static bank control byapss0 Register */
/*! @{ */

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN_MASK (0xFFU)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN_SHIFT (0U)
/*! LMU_STA_BANKS_ISO_EN_BP_EN - Firmware Bypass enable for lmu static banks iso_en */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL_MASK (0xFF00U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL_SHIFT (8U)
/*! LMU_STA_BANKS_ISO_EN_BP_VAL - Firmware Bypass value for lmu static banks iso_en */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN_MASK (0xFF0000U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN_SHIFT (16U)
/*! LMU_STA_BANKS_PSW_EN_BP_EN - Firmware Bypass enable for lmu static banks psw_en */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL_MASK (0xFF000000U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL_SHIFT (24U)
/*! LMU_STA_BANKS_PSW_EN_BP_VAL - Firmware Bypass value for lmu static banks psw_en */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_CPU1_LMU_STA_BYPASS1 - LMU static bank control byapss1 Register */
/*! @{ */

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN_MASK (0xFFU)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN_SHIFT (0U)
/*! LMU_STA_BANKS_SRAM_PD_BP_EN - Firmware Bypass enable for lmu static banks sram_pd */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL_MASK (0xFF00U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL_SHIFT (8U)
/*! LMU_STA_BANKS_SRAM_PD_BP_VAL - Firmware Bypass value for lmu static banks sram_pd */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN_MASK (0xFF0000U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN_SHIFT (16U)
/*! LMU_STA_BANKS_FNRST_BP_EN - Firmware Bypass enable for lmu static banks fnrst */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL_MASK (0xFF000000U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL_SHIFT (24U)
/*! LMU_STA_BANKS_FNRST_BP_VAL - Firmware Bypass value for lmu static banks fnrst */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_CPU1_LMU_STA_BYPASS2 - LMU static bank byapss2 Register */
/*! @{ */

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK (0xFFU)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT (0U)
/*! LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN - Firmware Bypass enable for lmu static banks vddmc_sw_pd_ctrl */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK (0xFF00U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT (8U)
/*! LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL - Firmware Bypass value for lmu static banks vddmc_sw_pd_ctrl */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_LMU_DYN_BYPASS0 - LMU dynamic bank control byapss0 Register */
/*! @{ */

#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK (0x7U)
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT (0U)
/*! LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_EN - Firmware Bypass enable for lmu dynamic banks vddmc_sw_pd_ctrl */
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK (0x700U)
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT (8U)
/*! LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_VAL - Firmware Bypass value for lmu dynamic banks vddmc_sw_pd_ctrl */
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_EN_MASK (0x70000U)
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_EN_SHIFT (16U)
/*! LMU_DYN_BANKS_FNRST_BP_EN - Firmware Bypass enable for lmu dynamic banks fnrst */
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_VAL_MASK (0x7000000U)
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_VAL_SHIFT (24U)
/*! LMU_DYN_BANKS_FNRST_BP_VAL - Firmware Bypass value for lmu dynamic banks fnrst */
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_SRAM_FNRST_USE_WLAN_FNRST_MASK (0x80000000U)
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_SRAM_FNRST_USE_WLAN_FNRST_SHIFT (31U)
/*! LMU_DYN_BANKS_SRAM_FNRST_USE_WLAN_FNRST - 1: By default WLAN_SRAM_FNRST is used for SMU off domain banks */
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_SRAM_FNRST_USE_WLAN_FNRST(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_SRAM_FNRST_USE_WLAN_FNRST_SHIFT)) & BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_SRAM_FNRST_USE_WLAN_FNRST_MASK)
/*! @} */

/*! @name SOCBTAPU_LMU_G2BIST_CTRL_BYPASS - LMU G2Bist control bypass Register */
/*! @{ */

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_EN_MASK (0x1U)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_EN_SHIFT (0U)
/*! LMU_G2BIST_MODE_BYPASS_EN - Firmware Bypass enable for lmu g2bist mode */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_VAL_MASK (0x3EU)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_VAL_SHIFT (1U)
/*! LMU_G2BIST_MODE_BYPASS_VAL - Firmware Bypass value for lmu g2bist mode */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_EN_MASK (0x1000000U)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_EN_SHIFT (24U)
/*! LMU_G2BIST_START_BP_EN - Firmware Bypass enable for lmu g2bist start */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_VAL_MASK (0x2000000U)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_VAL_SHIFT (25U)
/*! LMU_G2BIST_START_BP_VAL - Firmware Bypass value for lmu g2bist start */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_EN_MASK (0x4000000U)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_EN_SHIFT (26U)
/*! LMU_G2BIST_CLK_EN_BP_EN - Firmware Bypass enable for lmu g2bist clock en */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_VAL_MASK (0x8000000U)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_VAL_SHIFT (27U)
/*! LMU_G2BIST_CLK_EN_BP_VAL - Firmware Bypass value for lmu g2bist clock en */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_G2BIST_STATUS_MASK (0xF0000000U)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_G2BIST_STATUS_SHIFT (28U)
/*! G2BIST_STATUS - g2bist status */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_G2BIST_STATUS(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_G2BIST_STATUS_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_G2BIST_STATUS_MASK)
/*! @} */

/*! @name SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS - LMU G2Bist control bypass Register for CPU1 */
/*! @{ */

#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_EN_MASK (0x1U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_EN_SHIFT (0U)
/*! LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_EN - Firmware Bypass enable for CPU1 static banks lmu powerdomain repair request */
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_VAL_MASK (0xFFF0U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_VAL_SHIFT (4U)
/*! LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_VAL - Firmware Bypass value for CPU1 static banks lmu powerdomain repair request */
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_EN_MASK (0x100000U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_EN_SHIFT (20U)
/*! LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_EN - Firmware Bypass enable for SMU1 dynamic banks lmu powerdomain repair request */
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_VAL_MASK (0xF000000U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_VAL_SHIFT (24U)
/*! LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_VAL - Firmware Bypass value for SMU1 dynamic banks lmu powerdomain repair request */
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_PWR_CTRL_BYPASS5 - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_VAL_MASK (0x1000U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_VAL_SHIFT (12U)
/*! CPU1_VINITHI_BYPASS_VAL - Firmware Bypass Value for CPU1 Vinithi (default boot from ROM) */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_EN_MASK (0x2000U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_EN_SHIFT (13U)
/*! CPU1_VINITHI_BYPASS_EN - Firmware Bypass enable for CPU1 Vinithi */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_EN_MASK)
/*! @} */

/*! @name SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0 - LMU static bank control byapss0 Register for smu1 hybrid banks mem */
/*! @{ */

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_EN_MASK (0xFFU)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_EN_SHIFT (0U)
/*! LMU_HYBRID_BANKS_ISO_EN_BP_EN - Firmware Bypass enable for lmu static banks iso_en */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_VAL_MASK (0xFF00U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_VAL_SHIFT (8U)
/*! LMU_HYBRID_BANKS_ISO_EN_BP_VAL - Firmware Bypass value for lmu static banks iso_en */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_EN_MASK (0xFF0000U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_EN_SHIFT (16U)
/*! LMU_HYBRID_BANKS_PSW_EN_BP_EN - Firmware Bypass enable for lmu static banks psw_en */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_VAL_MASK (0xFF000000U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_VAL_SHIFT (24U)
/*! LMU_HYBRID_BANKS_PSW_EN_BP_VAL - Firmware Bypass value for lmu static banks psw_en */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1 - LMU static bank control byapss1 Register for smu1 hybrid banks mem */
/*! @{ */

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_EN_MASK (0xFFU)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_EN_SHIFT (0U)
/*! LMU_HYBRID_BANKS_SRAM_PD_BP_EN - Firmware Bypass enable for lmu static banks sram_pd */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_VAL_MASK (0xFF00U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_VAL_SHIFT (8U)
/*! LMU_HYBRID_BANKS_SRAM_PD_BP_VAL - Firmware Bypass value for lmu static banks sram_pd */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_EN_MASK (0xFF0000U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_EN_SHIFT (16U)
/*! LMU_HYBRID_BANKS_FNRST_BP_EN - Firmware Bypass enable for lmu static banks fnrst */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_VAL_MASK (0xFF000000U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_VAL_SHIFT (24U)
/*! LMU_HYBRID_BANKS_FNRST_BP_VAL - Firmware Bypass value for lmu static banks fnrst */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2 - LMU static bank control byapss2 Register for smu1 hybrid banks mem */
/*! @{ */

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK (0xFFU)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT (0U)
/*! LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_EN - Firmware Bypass enable for lmu static banks vddmc_sw_pd_ctrl */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK (0xFF00U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT (8U)
/*! LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_VAL - Firmware Bypass value for lmu static banks vddmc_sw_pd_ctrl */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_ECO_CTRL - APU ECO Control */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_ECO_CTRL_ECO_BITS_MASK (0xFFFFFFFFU)
#define BLEAPU_SOCBTAPU_APU_ECO_CTRL_ECO_BITS_SHIFT (0U)
/*! ECO_BITS - Reserved for ECOs */
#define BLEAPU_SOCBTAPU_APU_ECO_CTRL_ECO_BITS(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_ECO_CTRL_ECO_BITS_SHIFT)) & BLEAPU_SOCBTAPU_APU_ECO_CTRL_ECO_BITS_MASK)
/*! @} */

/*! @name SOCBTAPU_GPIO_WKUP_CTRL0 - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL0_P2C_WKUP_SELECT_MASK (0xFFFFFFFFU)
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL0_P2C_WKUP_SELECT_SHIFT (0U)
/*! P2C_WKUP_SELECT - [07:00]: Mux 1 of 32 p2c_pad_wkup input pins to APU wakeup input [0] */
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL0_P2C_WKUP_SELECT(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL0_P2C_WKUP_SELECT_SHIFT)) & BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL0_P2C_WKUP_SELECT_MASK)
/*! @} */

/*! @name SOCBTAPU_GPIO_WKUP_CTRL1 - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL1_P2C_WKUP_SELECT_MASK (0xFFFFFFFFU)
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL1_P2C_WKUP_SELECT_SHIFT (0U)
/*! P2C_WKUP_SELECT - [07:00]: Mux 1 of 32 p2c_pad_wkup input pins to APU wakeup input [4] */
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL1_P2C_WKUP_SELECT(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL1_P2C_WKUP_SELECT_SHIFT)) & BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL1_P2C_WKUP_SELECT_MASK)
/*! @} */

/*! @name SOCBTAPU_GPIO_WKUP_CTRL2 - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL2_P2C_WKUP_SELECT_MASK (0xFFFFFFFFU)
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL2_P2C_WKUP_SELECT_SHIFT (0U)
/*! P2C_WKUP_SELECT - [07:00]: Mux 1 of 32 p2c_pad_wkup input pins to APU wakeup input [8] */
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL2_P2C_WKUP_SELECT(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL2_P2C_WKUP_SELECT_SHIFT)) & BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL2_P2C_WKUP_SELECT_MASK)
/*! @} */

/*! @name SOCBTAPU_GPIO_WKUP_CTRL3 - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL3_P2C_WKUP_SELECT_MASK (0xFFFFFFFFU)
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL3_P2C_WKUP_SELECT_SHIFT (0U)
/*! P2C_WKUP_SELECT - [07:00]: Mux 1 of 32 p2c_pad_wkup input pins to APU wakeup input [12] */
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL3_P2C_WKUP_SELECT(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL3_P2C_WKUP_SELECT_SHIFT)) & BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL3_P2C_WKUP_SELECT_MASK)
/*! @} */

/*! @name SOCBTAPU_HOST_WKUP_MODE - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_HOST_WKUP_MODE_GPIO_SEL_MASK (0xFFFFU)
#define BLEAPU_SOCBTAPU_HOST_WKUP_MODE_GPIO_SEL_SHIFT (0U)
/*! GPIO_SEL - GPIO select */
#define BLEAPU_SOCBTAPU_HOST_WKUP_MODE_GPIO_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_HOST_WKUP_MODE_GPIO_SEL_SHIFT)) & BLEAPU_SOCBTAPU_HOST_WKUP_MODE_GPIO_SEL_MASK)
/*! @} */

/*! @name SOCBTAPU_T3_CLK_DIV_EN_BYPASS - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_EN_MASK (0x1U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_EN_SHIFT (0U)
/*! T3_SOC_256_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_VAL_MASK (0x2U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_VAL_SHIFT (1U)
/*! T3_SOC_256_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_EN_MASK (0x4U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_EN_SHIFT (2U)
/*! T3_SOC_320_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_VAL_MASK (0x8U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_VAL_SHIFT (3U)
/*! T3_SOC_320_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_EN_MASK (0x10U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_EN_SHIFT (4U)
/*! T3_SOC_365P7_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_VAL_MASK (0x20U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_VAL_SHIFT (5U)
/*! T3_SOC_365P7_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_EN_MASK (0x40U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_EN_SHIFT (6U)
/*! T3_SOC_426_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_VAL_MASK (0x80U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_VAL_SHIFT (7U)
/*! T3_SOC_426_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_EN_MASK (0x100U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_EN_SHIFT (8U)
/*! T3_SOC_512_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_VAL_MASK (0x200U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_VAL_SHIFT (9U)
/*! T3_SOC_512_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_EN_MASK (0x400U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_EN_SHIFT (10U)
/*! T3_213P3_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_VAL_MASK (0x800U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_VAL_SHIFT (11U)
/*! T3_213P3_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_EN_MASK (0x1000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_EN_SHIFT (12U)
/*! T3_MAC1_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_VAL_MASK (0x2000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_VAL_SHIFT (13U)
/*! T3_MAC1_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_EN_MASK (0x4000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_EN_SHIFT (14U)
/*! T3_MAC2_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_VAL_MASK (0x8000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_VAL_SHIFT (15U)
/*! T3_MAC2_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_EN_MASK (0x10000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_EN_SHIFT (16U)
/*! T3_BBUD_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_VAL_MASK (0x20000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_VAL_SHIFT (17U)
/*! T3_BBUD_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_EN_MASK (0x40000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_EN_SHIFT (18U)
/*! TCPU_CPU_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_VAL_MASK (0x80000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_VAL_SHIFT (19U)
/*! TCPU_CPU_CLK_DIV_EN_BYPASS_VAL - bypass value for tcpu cpu_clk_en */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_LDO_LV_CTRL2 - LV LDO Control 2 */
/*! @{ */

#define BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_VAL_MASK (0x10U)
#define BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_VAL_SHIFT (4U)
/*! LDO_GLU_XOSC_VAL - XOSC_EN value for ldo control logic set by FW */
#define BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_VAL_SHIFT)) & BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_VAL_MASK)

#define BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_BYPASS_EN_MASK (0x20U)
#define BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_BYPASS_EN_SHIFT (5U)
/*! LDO_GLU_XOSC_BYPASS_EN - XOSC_EN control bypass for ldo control logic */
#define BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_BYPASS_EN_MASK)
/*! @} */

/*! @name SOCBTAPU_CAU_BYPASS - CAU Bypass */
/*! @{ */

#define BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_VAL_MASK (0x1U)
#define BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_VAL_SHIFT (0U)
/*! PHY_REF_CLK_BYPASS_VAL - bypass value for phy ref clk enable */
#define BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_EN_MASK (0x2U)
#define BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_EN_SHIFT (1U)
/*! PHY_REF_CLK_BYPASS_EN - bypass enable for phy ref clk enable */
#define BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_VAL_MASK (0x4U)
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_VAL_SHIFT (2U)
/*! BT_CLK_BYPASS_VAL - bypass value for bt clk enable */
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_EN_MASK (0x8U)
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_EN_SHIFT (3U)
/*! BT_CLK_BYPASS_EN - bypass enable for bt clk enable */
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_VAL_MASK (0x40U)
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_VAL_SHIFT (6U)
/*! BRF_CLK_BYPASS_VAL - bypass value for brf clk */
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_EN_MASK (0x80U)
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_EN_SHIFT (7U)
/*! BRF_CLK_BYPASS_EN - bypass enable for brf clk */
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_EN_MASK)
/*! @} */

/*! @name SOCBTAPU_MEM_PWDN2 - Memory Powerdown Control */
/*! @{ */

#define BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_VAL_MASK (0x2U)
#define BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_VAL_SHIFT (1U)
/*! OTP_BYPASS_VAL - Firmware Bypass Value for OTP Power Down */
#define BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_EN_MASK (0x20000U)
#define BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_EN_SHIFT (17U)
/*! OTP_BYPASS_EN - Firmware Bypass Enable for OTP Power Down */
#define BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_EN_MASK)
/*! @} */

/*! @name SOCBTAPU_HOST_WKUP_SOURCE - Host Wakeup Source Control */
/*! @{ */

#define BLEAPU_SOCBTAPU_HOST_WKUP_SOURCE_ENABLE_MASK (0xFFFFU)
#define BLEAPU_SOCBTAPU_HOST_WKUP_SOURCE_ENABLE_SHIFT (0U)
/*! ENABLE - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_HOST_WKUP_SOURCE_ENABLE(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_HOST_WKUP_SOURCE_ENABLE_SHIFT)) & BLEAPU_SOCBTAPU_HOST_WKUP_SOURCE_ENABLE_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group BLEAPU_Register_Masks */


/* BLEAPU - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral BLEAPU base address */
  #define BLEAPU_BASE                              (0x54258000u)
  /** Peripheral BLEAPU base address */
  #define BLEAPU_BASE_NS                           (0x44258000u)
  /** Peripheral BLEAPU base pointer */
  #define BLEAPU                                   ((BLEAPU_Type *)BLEAPU_BASE)
  /** Peripheral BLEAPU base pointer */
  #define BLEAPU_NS                                ((BLEAPU_Type *)BLEAPU_BASE_NS)
  /** Array initializer of BLEAPU peripheral base addresses */
  #define BLEAPU_BASE_ADDRS                        { BLEAPU_BASE }
  /** Array initializer of BLEAPU peripheral base pointers */
  #define BLEAPU_BASE_PTRS                         { BLEAPU }
  /** Array initializer of BLEAPU peripheral base addresses */
  #define BLEAPU_BASE_ADDRS_NS                     { BLEAPU_BASE_NS }
  /** Array initializer of BLEAPU peripheral base pointers */
  #define BLEAPU_BASE_PTRS_NS                      { BLEAPU_NS }
#else
  /** Peripheral BLEAPU base address */
  #define BLEAPU_BASE                              (0x44258000u)
  /** Peripheral BLEAPU base pointer */
  #define BLEAPU                                   ((BLEAPU_Type *)BLEAPU_BASE)
  /** Array initializer of BLEAPU peripheral base addresses */
  #define BLEAPU_BASE_ADDRS                        { BLEAPU_BASE }
  /** Array initializer of BLEAPU peripheral base pointers */
  #define BLEAPU_BASE_PTRS                         { BLEAPU }
#endif

/*!
 * @}
 */ /* end of group BLEAPU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- BUCK11 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BUCK11_Peripheral_Access_Layer BUCK11 Peripheral Access Layer
 * @{
 */

/** BUCK11 - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[64];
  __I  uint8_t BUCK_BYPASS_SOC_CTRL_ONE_RO_REG;    /**< offset: 0x40 */
  __I  uint8_t BUCK_BYPASS_SOC_CTRL_TWO_RO_REG;    /**< offset: 0x41 */
  __I  uint8_t REG_RO_ONE_REG;                     /**< offset: 0x42 */
  __I  uint8_t REG_RO_TWO_REG;                     /**< offset: 0x43 */
  __I  uint8_t REG_RO_THREE_REG;                   /**< offset: 0x44 */
  __I  uint8_t REG_RO_FOUR_REG;                    /**< offset: 0x45 */
  __IO uint8_t SYS_CTRL_REG;                       /**< offset: 0x46 */
  __IO uint8_t BUCK_BYPASS_SOC_CTRL_ONE_RW_REG;    /**< offset: 0x47 */
  __IO uint8_t BUCK_BYPASS_SOC_CTRL_TWO_RW_REG;    /**< offset: 0x48 */
  __IO uint8_t BUCK_CTRL_ONE_REG;                  /**< offset: 0x49 */
  __IO uint8_t BUCK_CTRL_TWO_REG;                  /**< offset: 0x4A */
  __IO uint8_t BUCK_CTRL_THREE_REG;                /**< offset: 0x4B */
  __IO uint8_t BUCK_CTRL_FOUR_REG;                 /**< offset: 0x4C */
  __IO uint8_t BUCK_CTRL_FIVE_REG;                 /**< offset: 0x4D */
  __IO uint8_t BUCK_CTRL_SIX_REG;                  /**< offset: 0x4E */
  __IO uint8_t BUCK_CTRL_SEVEN_REG;                /**< offset: 0x4F */
  __IO uint8_t BUCK_CTRL_EIGHT_REG;                /**< offset: 0x50 */
  __IO uint8_t BUCK_CTRL_NINE_REG;                 /**< offset: 0x51 */
  __IO uint8_t BUCK_CTRL_TEN_REG;                  /**< offset: 0x52 */
  __IO uint8_t BUCK_CTRL_ELEVEN_REG;               /**< offset: 0x53 */
  __IO uint8_t BUCK_CTRL_TWELVE_REG;               /**< offset: 0x54 */
  __IO uint8_t BUCK_CTRL_THIRTEEN_REG;             /**< offset: 0x55 */
  __IO uint8_t BUCK_CTRL_FOURTEEN_REG;             /**< offset: 0x56 */
  __IO uint8_t BUCK_CTRL_FIFTEEN_REG;              /**< offset: 0x57 */
  __IO uint8_t BUCK_CTRL_SIXTEEN_REG;              /**< offset: 0x58 */
  __IO uint8_t BUCK_CTRL_SEVENTEEN_REG;            /**< offset: 0x59 */
  __IO uint8_t BUCK_CTRL_EIGHTEEN_REG;             /**< offset: 0x5A */
  __IO uint8_t BUCK_CTRL_NINTEEN_REG;              /**< offset: 0x5B */
  __IO uint8_t BUCK_CTRL_TWENTY_REG;               /**< offset: 0x5C */
} BUCK11_Type;

/* ----------------------------------------------------------------------------
   -- BUCK11 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BUCK11_Register_Masks BUCK11 Register Masks
 * @{
 */

/*! @name BUCK_BYPASS_SOC_CTRL_ONE_RO_REG -  */
/*! @{ */

#define BUCK11_BUCK_BYPASS_SOC_CTRL_ONE_RO_REG_BUCK_BYPASS_SOC_CTRL_ONE_RO_MASK (0xFFU)
#define BUCK11_BUCK_BYPASS_SOC_CTRL_ONE_RO_REG_BUCK_BYPASS_SOC_CTRL_ONE_RO_SHIFT (0U)
/*! BUCK_BYPASS_SOC_CTRL_ONE_RO - BUCK_BYPASS_SOC_CTRL_ONE_RO */
#define BUCK11_BUCK_BYPASS_SOC_CTRL_ONE_RO_REG_BUCK_BYPASS_SOC_CTRL_ONE_RO(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_BYPASS_SOC_CTRL_ONE_RO_REG_BUCK_BYPASS_SOC_CTRL_ONE_RO_SHIFT)) & BUCK11_BUCK_BYPASS_SOC_CTRL_ONE_RO_REG_BUCK_BYPASS_SOC_CTRL_ONE_RO_MASK)
/*! @} */

/*! @name BUCK_BYPASS_SOC_CTRL_TWO_RO_REG -  */
/*! @{ */

#define BUCK11_BUCK_BYPASS_SOC_CTRL_TWO_RO_REG_BUCK_BYPASS_SOC_CTRL_TWO_RO_MASK (0xFFU)
#define BUCK11_BUCK_BYPASS_SOC_CTRL_TWO_RO_REG_BUCK_BYPASS_SOC_CTRL_TWO_RO_SHIFT (0U)
/*! BUCK_BYPASS_SOC_CTRL_TWO_RO - BUCK_BYPASS_SOC_CTRL_TWO_RO */
#define BUCK11_BUCK_BYPASS_SOC_CTRL_TWO_RO_REG_BUCK_BYPASS_SOC_CTRL_TWO_RO(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_BYPASS_SOC_CTRL_TWO_RO_REG_BUCK_BYPASS_SOC_CTRL_TWO_RO_SHIFT)) & BUCK11_BUCK_BYPASS_SOC_CTRL_TWO_RO_REG_BUCK_BYPASS_SOC_CTRL_TWO_RO_MASK)
/*! @} */

/*! @name REG_RO_ONE_REG -  */
/*! @{ */

#define BUCK11_REG_RO_ONE_REG_REG_RO_ONE_MASK    (0xFFU)
#define BUCK11_REG_RO_ONE_REG_REG_RO_ONE_SHIFT   (0U)
/*! REG_RO_ONE - REG_RO_ONE */
#define BUCK11_REG_RO_ONE_REG_REG_RO_ONE(x)      (((uint8_t)(((uint8_t)(x)) << BUCK11_REG_RO_ONE_REG_REG_RO_ONE_SHIFT)) & BUCK11_REG_RO_ONE_REG_REG_RO_ONE_MASK)
/*! @} */

/*! @name REG_RO_TWO_REG -  */
/*! @{ */

#define BUCK11_REG_RO_TWO_REG_REG_RO_TWO_MASK    (0xFFU)
#define BUCK11_REG_RO_TWO_REG_REG_RO_TWO_SHIFT   (0U)
/*! REG_RO_TWO - REG_RO_TWO */
#define BUCK11_REG_RO_TWO_REG_REG_RO_TWO(x)      (((uint8_t)(((uint8_t)(x)) << BUCK11_REG_RO_TWO_REG_REG_RO_TWO_SHIFT)) & BUCK11_REG_RO_TWO_REG_REG_RO_TWO_MASK)
/*! @} */

/*! @name REG_RO_THREE_REG -  */
/*! @{ */

#define BUCK11_REG_RO_THREE_REG_REG_RO_THREE_MASK (0xFFU)
#define BUCK11_REG_RO_THREE_REG_REG_RO_THREE_SHIFT (0U)
/*! REG_RO_THREE - REG_RO_THREE */
#define BUCK11_REG_RO_THREE_REG_REG_RO_THREE(x)  (((uint8_t)(((uint8_t)(x)) << BUCK11_REG_RO_THREE_REG_REG_RO_THREE_SHIFT)) & BUCK11_REG_RO_THREE_REG_REG_RO_THREE_MASK)
/*! @} */

/*! @name REG_RO_FOUR_REG -  */
/*! @{ */

#define BUCK11_REG_RO_FOUR_REG_REG_RO_FOUR_MASK  (0xFFU)
#define BUCK11_REG_RO_FOUR_REG_REG_RO_FOUR_SHIFT (0U)
/*! REG_RO_FOUR - REG_RO_FOUR */
#define BUCK11_REG_RO_FOUR_REG_REG_RO_FOUR(x)    (((uint8_t)(((uint8_t)(x)) << BUCK11_REG_RO_FOUR_REG_REG_RO_FOUR_SHIFT)) & BUCK11_REG_RO_FOUR_REG_REG_RO_FOUR_MASK)
/*! @} */

/*! @name SYS_CTRL_REG -  */
/*! @{ */

#define BUCK11_SYS_CTRL_REG_REG_SYS_CTRL_MASK    (0xFFU)
#define BUCK11_SYS_CTRL_REG_REG_SYS_CTRL_SHIFT   (0U)
/*! REG_SYS_CTRL - REG_SYS_CTRL */
#define BUCK11_SYS_CTRL_REG_REG_SYS_CTRL(x)      (((uint8_t)(((uint8_t)(x)) << BUCK11_SYS_CTRL_REG_REG_SYS_CTRL_SHIFT)) & BUCK11_SYS_CTRL_REG_REG_SYS_CTRL_MASK)
/*! @} */

/*! @name BUCK_BYPASS_SOC_CTRL_ONE_RW_REG -  */
/*! @{ */

#define BUCK11_BUCK_BYPASS_SOC_CTRL_ONE_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_ONE_RW_MASK (0xFFU)
#define BUCK11_BUCK_BYPASS_SOC_CTRL_ONE_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_ONE_RW_SHIFT (0U)
/*! REG_BUCK_BYPASS_SOC_CTRL_ONE_RW - REG_BUCK_BYPASS_SOC_CTRL_ONE_RW */
#define BUCK11_BUCK_BYPASS_SOC_CTRL_ONE_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_ONE_RW(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_BYPASS_SOC_CTRL_ONE_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_ONE_RW_SHIFT)) & BUCK11_BUCK_BYPASS_SOC_CTRL_ONE_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_ONE_RW_MASK)
/*! @} */

/*! @name BUCK_BYPASS_SOC_CTRL_TWO_RW_REG -  */
/*! @{ */

#define BUCK11_BUCK_BYPASS_SOC_CTRL_TWO_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_TWO_RW_MASK (0xFFU)
#define BUCK11_BUCK_BYPASS_SOC_CTRL_TWO_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_TWO_RW_SHIFT (0U)
/*! REG_BUCK_BYPASS_SOC_CTRL_TWO_RW - REG_BUCK_BYPASS_SOC_CTRL_TWO_RW */
#define BUCK11_BUCK_BYPASS_SOC_CTRL_TWO_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_TWO_RW(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_BYPASS_SOC_CTRL_TWO_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_TWO_RW_SHIFT)) & BUCK11_BUCK_BYPASS_SOC_CTRL_TWO_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_TWO_RW_MASK)
/*! @} */

/*! @name BUCK_CTRL_ONE_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_ONE_REG_REG_BUCK_CTRL_ONE_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_ONE_REG_REG_BUCK_CTRL_ONE_SHIFT (0U)
/*! REG_BUCK_CTRL_ONE - REG_BUCK_CTRL_ONE */
#define BUCK11_BUCK_CTRL_ONE_REG_REG_BUCK_CTRL_ONE(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_ONE_REG_REG_BUCK_CTRL_ONE_SHIFT)) & BUCK11_BUCK_CTRL_ONE_REG_REG_BUCK_CTRL_ONE_MASK)
/*! @} */

/*! @name BUCK_CTRL_TWO_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_TWO_REG_REG_BUCK_CTRL_TWO_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_TWO_REG_REG_BUCK_CTRL_TWO_SHIFT (0U)
/*! REG_BUCK_CTRL_TWO - REG_BUCK_CTRL_TWO */
#define BUCK11_BUCK_CTRL_TWO_REG_REG_BUCK_CTRL_TWO(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_TWO_REG_REG_BUCK_CTRL_TWO_SHIFT)) & BUCK11_BUCK_CTRL_TWO_REG_REG_BUCK_CTRL_TWO_MASK)
/*! @} */

/*! @name BUCK_CTRL_THREE_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_THREE_REG_REG_BUCK_CTRL_THREE_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_THREE_REG_REG_BUCK_CTRL_THREE_SHIFT (0U)
/*! REG_BUCK_CTRL_THREE - REG_BUCK_CTRL_THREE */
#define BUCK11_BUCK_CTRL_THREE_REG_REG_BUCK_CTRL_THREE(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_THREE_REG_REG_BUCK_CTRL_THREE_SHIFT)) & BUCK11_BUCK_CTRL_THREE_REG_REG_BUCK_CTRL_THREE_MASK)
/*! @} */

/*! @name BUCK_CTRL_FOUR_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_FOUR_REG_REG_BUCK_CTRL_FOUR_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_FOUR_REG_REG_BUCK_CTRL_FOUR_SHIFT (0U)
/*! REG_BUCK_CTRL_FOUR - REG_BUCK_CTRL_FOUR */
#define BUCK11_BUCK_CTRL_FOUR_REG_REG_BUCK_CTRL_FOUR(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_FOUR_REG_REG_BUCK_CTRL_FOUR_SHIFT)) & BUCK11_BUCK_CTRL_FOUR_REG_REG_BUCK_CTRL_FOUR_MASK)
/*! @} */

/*! @name BUCK_CTRL_FIVE_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_FIVE_REG_REG_BUCK_CTRL_FIVE_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_FIVE_REG_REG_BUCK_CTRL_FIVE_SHIFT (0U)
/*! REG_BUCK_CTRL_FIVE - REG_BUCK_CTRL_FIVE */
#define BUCK11_BUCK_CTRL_FIVE_REG_REG_BUCK_CTRL_FIVE(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_FIVE_REG_REG_BUCK_CTRL_FIVE_SHIFT)) & BUCK11_BUCK_CTRL_FIVE_REG_REG_BUCK_CTRL_FIVE_MASK)
/*! @} */

/*! @name BUCK_CTRL_SIX_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_SIX_REG_REG_BUCK_CTRL_SIX_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_SIX_REG_REG_BUCK_CTRL_SIX_SHIFT (0U)
/*! REG_BUCK_CTRL_SIX - REG_BUCK_CTRL_SIX */
#define BUCK11_BUCK_CTRL_SIX_REG_REG_BUCK_CTRL_SIX(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_SIX_REG_REG_BUCK_CTRL_SIX_SHIFT)) & BUCK11_BUCK_CTRL_SIX_REG_REG_BUCK_CTRL_SIX_MASK)
/*! @} */

/*! @name BUCK_CTRL_SEVEN_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_SEVEN_REG_REG_BUCK_CTRL_SEVEN_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_SEVEN_REG_REG_BUCK_CTRL_SEVEN_SHIFT (0U)
/*! REG_BUCK_CTRL_SEVEN - REG_BUCK_CTRL_SEVEN */
#define BUCK11_BUCK_CTRL_SEVEN_REG_REG_BUCK_CTRL_SEVEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_SEVEN_REG_REG_BUCK_CTRL_SEVEN_SHIFT)) & BUCK11_BUCK_CTRL_SEVEN_REG_REG_BUCK_CTRL_SEVEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_EIGHT_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_EIGHT_REG_REG_BUCK_CTRL_EIGHT_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_EIGHT_REG_REG_BUCK_CTRL_EIGHT_SHIFT (0U)
/*! REG_BUCK_CTRL_EIGHT - REG_BUCK_CTRL_EIGHT */
#define BUCK11_BUCK_CTRL_EIGHT_REG_REG_BUCK_CTRL_EIGHT(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_EIGHT_REG_REG_BUCK_CTRL_EIGHT_SHIFT)) & BUCK11_BUCK_CTRL_EIGHT_REG_REG_BUCK_CTRL_EIGHT_MASK)
/*! @} */

/*! @name BUCK_CTRL_NINE_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_NINE_REG_REG_BUCK_CTRL_NINE_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_NINE_REG_REG_BUCK_CTRL_NINE_SHIFT (0U)
/*! REG_BUCK_CTRL_NINE - REG_BUCK_CTRL_NINE */
#define BUCK11_BUCK_CTRL_NINE_REG_REG_BUCK_CTRL_NINE(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_NINE_REG_REG_BUCK_CTRL_NINE_SHIFT)) & BUCK11_BUCK_CTRL_NINE_REG_REG_BUCK_CTRL_NINE_MASK)
/*! @} */

/*! @name BUCK_CTRL_TEN_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_TEN_REG_REG_BUCK_CTRL_TEN_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_TEN_REG_REG_BUCK_CTRL_TEN_SHIFT (0U)
/*! REG_BUCK_CTRL_TEN - REG_BUCK_CTRL_TEN */
#define BUCK11_BUCK_CTRL_TEN_REG_REG_BUCK_CTRL_TEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_TEN_REG_REG_BUCK_CTRL_TEN_SHIFT)) & BUCK11_BUCK_CTRL_TEN_REG_REG_BUCK_CTRL_TEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_ELEVEN_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_ELEVEN_REG_REG_BUCK_CTRL_ELEVEN_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_ELEVEN_REG_REG_BUCK_CTRL_ELEVEN_SHIFT (0U)
/*! REG_BUCK_CTRL_ELEVEN - REG_BUCK_CTRL_ELEVEN */
#define BUCK11_BUCK_CTRL_ELEVEN_REG_REG_BUCK_CTRL_ELEVEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_ELEVEN_REG_REG_BUCK_CTRL_ELEVEN_SHIFT)) & BUCK11_BUCK_CTRL_ELEVEN_REG_REG_BUCK_CTRL_ELEVEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_TWELVE_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_TWELVE_REG_REG_BUCK_CTRL_TWELVE_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_TWELVE_REG_REG_BUCK_CTRL_TWELVE_SHIFT (0U)
/*! REG_BUCK_CTRL_TWELVE - REG_BUCK_CTRL_TWELVE */
#define BUCK11_BUCK_CTRL_TWELVE_REG_REG_BUCK_CTRL_TWELVE(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_TWELVE_REG_REG_BUCK_CTRL_TWELVE_SHIFT)) & BUCK11_BUCK_CTRL_TWELVE_REG_REG_BUCK_CTRL_TWELVE_MASK)
/*! @} */

/*! @name BUCK_CTRL_THIRTEEN_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_THIRTEEN_REG_REG_BUCK_CTRL_THIRTEEN_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_THIRTEEN_REG_REG_BUCK_CTRL_THIRTEEN_SHIFT (0U)
/*! REG_BUCK_CTRL_THIRTEEN - REG_BUCK_CTRL_THIRTEEN */
#define BUCK11_BUCK_CTRL_THIRTEEN_REG_REG_BUCK_CTRL_THIRTEEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_THIRTEEN_REG_REG_BUCK_CTRL_THIRTEEN_SHIFT)) & BUCK11_BUCK_CTRL_THIRTEEN_REG_REG_BUCK_CTRL_THIRTEEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_FOURTEEN_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_FOURTEEN_REG_REG_BUCK_CTRL_FOURTEEN_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_FOURTEEN_REG_REG_BUCK_CTRL_FOURTEEN_SHIFT (0U)
/*! REG_BUCK_CTRL_FOURTEEN - REG_BUCK_CTRL_FOURTEEN */
#define BUCK11_BUCK_CTRL_FOURTEEN_REG_REG_BUCK_CTRL_FOURTEEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_FOURTEEN_REG_REG_BUCK_CTRL_FOURTEEN_SHIFT)) & BUCK11_BUCK_CTRL_FOURTEEN_REG_REG_BUCK_CTRL_FOURTEEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_FIFTEEN_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_FIFTEEN_REG_REG_BUCK_CTRL_FIFTEEN_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_FIFTEEN_REG_REG_BUCK_CTRL_FIFTEEN_SHIFT (0U)
/*! REG_BUCK_CTRL_FIFTEEN - REG_BUCK_CTRL_FIFTEEN */
#define BUCK11_BUCK_CTRL_FIFTEEN_REG_REG_BUCK_CTRL_FIFTEEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_FIFTEEN_REG_REG_BUCK_CTRL_FIFTEEN_SHIFT)) & BUCK11_BUCK_CTRL_FIFTEEN_REG_REG_BUCK_CTRL_FIFTEEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_SIXTEEN_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_SIXTEEN_REG_REG_BUCK_CTRL_SIXTEEN_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_SIXTEEN_REG_REG_BUCK_CTRL_SIXTEEN_SHIFT (0U)
/*! REG_BUCK_CTRL_SIXTEEN - REG_BUCK_CTRL_SIXTEEN */
#define BUCK11_BUCK_CTRL_SIXTEEN_REG_REG_BUCK_CTRL_SIXTEEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_SIXTEEN_REG_REG_BUCK_CTRL_SIXTEEN_SHIFT)) & BUCK11_BUCK_CTRL_SIXTEEN_REG_REG_BUCK_CTRL_SIXTEEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_SEVENTEEN_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_SEVENTEEN_REG_REG_BUCK_CTRL_SEVENTEEN_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_SEVENTEEN_REG_REG_BUCK_CTRL_SEVENTEEN_SHIFT (0U)
/*! REG_BUCK_CTRL_SEVENTEEN - REG_BUCK_CTRL_SEVENTEEN */
#define BUCK11_BUCK_CTRL_SEVENTEEN_REG_REG_BUCK_CTRL_SEVENTEEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_SEVENTEEN_REG_REG_BUCK_CTRL_SEVENTEEN_SHIFT)) & BUCK11_BUCK_CTRL_SEVENTEEN_REG_REG_BUCK_CTRL_SEVENTEEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_EIGHTEEN_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_EIGHTEEN_REG_EXT_BG_CAL_CODE_MASK (0xFU)
#define BUCK11_BUCK_CTRL_EIGHTEEN_REG_EXT_BG_CAL_CODE_SHIFT (0U)
/*! EXT_BG_CAL_CODE - External calibration code for BG */
#define BUCK11_BUCK_CTRL_EIGHTEEN_REG_EXT_BG_CAL_CODE(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_EIGHTEEN_REG_EXT_BG_CAL_CODE_SHIFT)) & BUCK11_BUCK_CTRL_EIGHTEEN_REG_EXT_BG_CAL_CODE_MASK)

#define BUCK11_BUCK_CTRL_EIGHTEEN_REG_SEL_BG_CAL_CODE_MASK (0x10U)
#define BUCK11_BUCK_CTRL_EIGHTEEN_REG_SEL_BG_CAL_CODE_SHIFT (4U)
/*! SEL_BG_CAL_CODE - Select internal or external calibration code for BG */
#define BUCK11_BUCK_CTRL_EIGHTEEN_REG_SEL_BG_CAL_CODE(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_EIGHTEEN_REG_SEL_BG_CAL_CODE_SHIFT)) & BUCK11_BUCK_CTRL_EIGHTEEN_REG_SEL_BG_CAL_CODE_MASK)

#define BUCK11_BUCK_CTRL_EIGHTEEN_REG_SHORT_C11_ENB_MASK (0x20U)
#define BUCK11_BUCK_CTRL_EIGHTEEN_REG_SHORT_C11_ENB_SHIFT (5U)
/*! SHORT_C11_ENB - Short switch enable signal for internal C11 */
#define BUCK11_BUCK_CTRL_EIGHTEEN_REG_SHORT_C11_ENB(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_EIGHTEEN_REG_SHORT_C11_ENB_SHIFT)) & BUCK11_BUCK_CTRL_EIGHTEEN_REG_SHORT_C11_ENB_MASK)

#define BUCK11_BUCK_CTRL_EIGHTEEN_REG_LPBG_TRIM_MASK (0xC0U)
#define BUCK11_BUCK_CTRL_EIGHTEEN_REG_LPBG_TRIM_SHIFT (6U)
/*! LPBG_TRIM - Bandgap temperature curve trimming */
#define BUCK11_BUCK_CTRL_EIGHTEEN_REG_LPBG_TRIM(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_EIGHTEEN_REG_LPBG_TRIM_SHIFT)) & BUCK11_BUCK_CTRL_EIGHTEEN_REG_LPBG_TRIM_MASK)
/*! @} */

/*! @name BUCK_CTRL_NINTEEN_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_NINTEEN_REG_REG_BUCK_CTRL_NINTEEN_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_NINTEEN_REG_REG_BUCK_CTRL_NINTEEN_SHIFT (0U)
/*! REG_BUCK_CTRL_NINTEEN - REG_BUCK_CTRL_NINTEEN */
#define BUCK11_BUCK_CTRL_NINTEEN_REG_REG_BUCK_CTRL_NINTEEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_NINTEEN_REG_REG_BUCK_CTRL_NINTEEN_SHIFT)) & BUCK11_BUCK_CTRL_NINTEEN_REG_REG_BUCK_CTRL_NINTEEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_TWENTY_REG -  */
/*! @{ */

#define BUCK11_BUCK_CTRL_TWENTY_REG_REG_BUCK_CTRL_TWENTY_MASK (0xFFU)
#define BUCK11_BUCK_CTRL_TWENTY_REG_REG_BUCK_CTRL_TWENTY_SHIFT (0U)
/*! REG_BUCK_CTRL_TWENTY - REG_BUCK_CTRL_TWENTY */
#define BUCK11_BUCK_CTRL_TWENTY_REG_REG_BUCK_CTRL_TWENTY(x) (((uint8_t)(((uint8_t)(x)) << BUCK11_BUCK_CTRL_TWENTY_REG_REG_BUCK_CTRL_TWENTY_SHIFT)) & BUCK11_BUCK_CTRL_TWENTY_REG_REG_BUCK_CTRL_TWENTY_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group BUCK11_Register_Masks */


/* BUCK11 - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral BUCK11 base address */
  #define BUCK11_BASE                              (0x55002000u)
  /** Peripheral BUCK11 base address */
  #define BUCK11_BASE_NS                           (0x45002000u)
  /** Peripheral BUCK11 base pointer */
  #define BUCK11                                   ((BUCK11_Type *)BUCK11_BASE)
  /** Peripheral BUCK11 base pointer */
  #define BUCK11_NS                                ((BUCK11_Type *)BUCK11_BASE_NS)
  /** Array initializer of BUCK11 peripheral base addresses */
  #define BUCK11_BASE_ADDRS                        { BUCK11_BASE }
  /** Array initializer of BUCK11 peripheral base pointers */
  #define BUCK11_BASE_PTRS                         { BUCK11 }
  /** Array initializer of BUCK11 peripheral base addresses */
  #define BUCK11_BASE_ADDRS_NS                     { BUCK11_BASE_NS }
  /** Array initializer of BUCK11 peripheral base pointers */
  #define BUCK11_BASE_PTRS_NS                      { BUCK11_NS }
#else
  /** Peripheral BUCK11 base address */
  #define BUCK11_BASE                              (0x45002000u)
  /** Peripheral BUCK11 base pointer */
  #define BUCK11                                   ((BUCK11_Type *)BUCK11_BASE)
  /** Array initializer of BUCK11 peripheral base addresses */
  #define BUCK11_BASE_ADDRS                        { BUCK11_BASE }
  /** Array initializer of BUCK11 peripheral base pointers */
  #define BUCK11_BASE_PTRS                         { BUCK11 }
#endif

/*!
 * @}
 */ /* end of group BUCK11_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- BUCK18 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BUCK18_Peripheral_Access_Layer BUCK18 Peripheral Access Layer
 * @{
 */

/** BUCK18 - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[96];
  __I  uint8_t BUCK_BYPASS_SOC_CTRL_ONE_RO_REG;    /**< offset: 0x60 */
  __I  uint8_t BUCK_BYPASS_SOC_CTRL_TWO_RO_REG;    /**< offset: 0x61 */
  __I  uint8_t REG_RO_ONE_REG;                     /**< offset: 0x62 */
  __I  uint8_t REG_RO_TWO_REG;                     /**< offset: 0x63 */
  __I  uint8_t REG_RO_THREE_REG;                   /**< offset: 0x64 */
  __I  uint8_t REG_RO_FOUR_REG;                    /**< offset: 0x65 */
  __IO uint8_t SYS_CTRL_REG;                       /**< offset: 0x66 */
  __IO uint8_t BUCK_BYPASS_SOC_CTRL_ONE_RW_REG;    /**< offset: 0x67 */
  __IO uint8_t BUCK_BYPASS_SOC_CTRL_TWO_RW_REG;    /**< offset: 0x68 */
  __IO uint8_t BUCK_CTRL_ONE_REG;                  /**< offset: 0x69 */
  __IO uint8_t BUCK_CTRL_TWO_REG;                  /**< offset: 0x6A */
  __IO uint8_t BUCK_CTRL_THREE_REG;                /**< offset: 0x6B */
  __IO uint8_t BUCK_CTRL_FOUR_REG;                 /**< offset: 0x6C */
  __IO uint8_t BUCK_CTRL_FIVE_REG;                 /**< offset: 0x6D */
  __IO uint8_t BUCK_CTRL_SIX_REG;                  /**< offset: 0x6E */
  __IO uint8_t BUCK_CTRL_SEVEN_REG;                /**< offset: 0x6F */
  __IO uint8_t BUCK_CTRL_EIGHT_REG;                /**< offset: 0x70 */
  __IO uint8_t BUCK_CTRL_NINE_REG;                 /**< offset: 0x71 */
  __IO uint8_t BUCK_CTRL_TEN_REG;                  /**< offset: 0x72 */
  __IO uint8_t BUCK_CTRL_ELEVEN_REG;               /**< offset: 0x73 */
  __IO uint8_t BUCK_CTRL_TWELVE_REG;               /**< offset: 0x74 */
  __IO uint8_t BUCK_CTRL_THIRTEEN_REG;             /**< offset: 0x75 */
  __IO uint8_t BUCK_CTRL_FOURTEEN_REG;             /**< offset: 0x76 */
  __IO uint8_t BUCK_CTRL_FIFTEEN_REG;              /**< offset: 0x77 */
  __IO uint8_t BUCK_CTRL_SIXTEEN_REG;              /**< offset: 0x78 */
  __IO uint8_t BUCK_CTRL_SEVENTEEN_REG;            /**< offset: 0x79 */
  __IO uint8_t BUCK_CTRL_EIGHTEEN_REG;             /**< offset: 0x7A */
  __IO uint8_t BUCK_CTRL_NINTEEN_REG;              /**< offset: 0x7B */
  __IO uint8_t BUCK_CTRL_TWENTY_REG;               /**< offset: 0x7C */
} BUCK18_Type;

/* ----------------------------------------------------------------------------
   -- BUCK18 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BUCK18_Register_Masks BUCK18 Register Masks
 * @{
 */

/*! @name BUCK_BYPASS_SOC_CTRL_ONE_RO_REG -  */
/*! @{ */

#define BUCK18_BUCK_BYPASS_SOC_CTRL_ONE_RO_REG_BUCK_BYPASS_SOC_CTRL_ONE_RO_MASK (0xFFU)
#define BUCK18_BUCK_BYPASS_SOC_CTRL_ONE_RO_REG_BUCK_BYPASS_SOC_CTRL_ONE_RO_SHIFT (0U)
/*! BUCK_BYPASS_SOC_CTRL_ONE_RO - BUCK_BYPASS_SOC_CTRL_ONE_RO */
#define BUCK18_BUCK_BYPASS_SOC_CTRL_ONE_RO_REG_BUCK_BYPASS_SOC_CTRL_ONE_RO(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_BYPASS_SOC_CTRL_ONE_RO_REG_BUCK_BYPASS_SOC_CTRL_ONE_RO_SHIFT)) & BUCK18_BUCK_BYPASS_SOC_CTRL_ONE_RO_REG_BUCK_BYPASS_SOC_CTRL_ONE_RO_MASK)
/*! @} */

/*! @name BUCK_BYPASS_SOC_CTRL_TWO_RO_REG -  */
/*! @{ */

#define BUCK18_BUCK_BYPASS_SOC_CTRL_TWO_RO_REG_BUCK_BYPASS_SOC_CTRL_TWO_RO_MASK (0xFFU)
#define BUCK18_BUCK_BYPASS_SOC_CTRL_TWO_RO_REG_BUCK_BYPASS_SOC_CTRL_TWO_RO_SHIFT (0U)
/*! BUCK_BYPASS_SOC_CTRL_TWO_RO - BUCK_BYPASS_SOC_CTRL_TWO_RO */
#define BUCK18_BUCK_BYPASS_SOC_CTRL_TWO_RO_REG_BUCK_BYPASS_SOC_CTRL_TWO_RO(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_BYPASS_SOC_CTRL_TWO_RO_REG_BUCK_BYPASS_SOC_CTRL_TWO_RO_SHIFT)) & BUCK18_BUCK_BYPASS_SOC_CTRL_TWO_RO_REG_BUCK_BYPASS_SOC_CTRL_TWO_RO_MASK)
/*! @} */

/*! @name REG_RO_ONE_REG -  */
/*! @{ */

#define BUCK18_REG_RO_ONE_REG_REG_RO_ONE_MASK    (0xFFU)
#define BUCK18_REG_RO_ONE_REG_REG_RO_ONE_SHIFT   (0U)
/*! REG_RO_ONE - REG_RO_ONE */
#define BUCK18_REG_RO_ONE_REG_REG_RO_ONE(x)      (((uint8_t)(((uint8_t)(x)) << BUCK18_REG_RO_ONE_REG_REG_RO_ONE_SHIFT)) & BUCK18_REG_RO_ONE_REG_REG_RO_ONE_MASK)
/*! @} */

/*! @name REG_RO_TWO_REG -  */
/*! @{ */

#define BUCK18_REG_RO_TWO_REG_REG_RO_TWO_MASK    (0xFFU)
#define BUCK18_REG_RO_TWO_REG_REG_RO_TWO_SHIFT   (0U)
/*! REG_RO_TWO - REG_RO_TWO */
#define BUCK18_REG_RO_TWO_REG_REG_RO_TWO(x)      (((uint8_t)(((uint8_t)(x)) << BUCK18_REG_RO_TWO_REG_REG_RO_TWO_SHIFT)) & BUCK18_REG_RO_TWO_REG_REG_RO_TWO_MASK)
/*! @} */

/*! @name REG_RO_THREE_REG -  */
/*! @{ */

#define BUCK18_REG_RO_THREE_REG_REG_RO_THREE_MASK (0xFFU)
#define BUCK18_REG_RO_THREE_REG_REG_RO_THREE_SHIFT (0U)
/*! REG_RO_THREE - REG_RO_THREE */
#define BUCK18_REG_RO_THREE_REG_REG_RO_THREE(x)  (((uint8_t)(((uint8_t)(x)) << BUCK18_REG_RO_THREE_REG_REG_RO_THREE_SHIFT)) & BUCK18_REG_RO_THREE_REG_REG_RO_THREE_MASK)
/*! @} */

/*! @name REG_RO_FOUR_REG -  */
/*! @{ */

#define BUCK18_REG_RO_FOUR_REG_REG_RO_FOUR_MASK  (0xFFU)
#define BUCK18_REG_RO_FOUR_REG_REG_RO_FOUR_SHIFT (0U)
/*! REG_RO_FOUR - REG_RO_FOUR */
#define BUCK18_REG_RO_FOUR_REG_REG_RO_FOUR(x)    (((uint8_t)(((uint8_t)(x)) << BUCK18_REG_RO_FOUR_REG_REG_RO_FOUR_SHIFT)) & BUCK18_REG_RO_FOUR_REG_REG_RO_FOUR_MASK)
/*! @} */

/*! @name SYS_CTRL_REG -  */
/*! @{ */

#define BUCK18_SYS_CTRL_REG_REG_SYS_CTRL_MASK    (0xFFU)
#define BUCK18_SYS_CTRL_REG_REG_SYS_CTRL_SHIFT   (0U)
/*! REG_SYS_CTRL - REG_SYS_CTRL */
#define BUCK18_SYS_CTRL_REG_REG_SYS_CTRL(x)      (((uint8_t)(((uint8_t)(x)) << BUCK18_SYS_CTRL_REG_REG_SYS_CTRL_SHIFT)) & BUCK18_SYS_CTRL_REG_REG_SYS_CTRL_MASK)
/*! @} */

/*! @name BUCK_BYPASS_SOC_CTRL_ONE_RW_REG -  */
/*! @{ */

#define BUCK18_BUCK_BYPASS_SOC_CTRL_ONE_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_ONE_RW_MASK (0xFFU)
#define BUCK18_BUCK_BYPASS_SOC_CTRL_ONE_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_ONE_RW_SHIFT (0U)
/*! REG_BUCK_BYPASS_SOC_CTRL_ONE_RW - REG_BUCK_BYPASS_SOC_CTRL_ONE_RW */
#define BUCK18_BUCK_BYPASS_SOC_CTRL_ONE_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_ONE_RW(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_BYPASS_SOC_CTRL_ONE_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_ONE_RW_SHIFT)) & BUCK18_BUCK_BYPASS_SOC_CTRL_ONE_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_ONE_RW_MASK)
/*! @} */

/*! @name BUCK_BYPASS_SOC_CTRL_TWO_RW_REG -  */
/*! @{ */

#define BUCK18_BUCK_BYPASS_SOC_CTRL_TWO_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_TWO_RW_MASK (0xFFU)
#define BUCK18_BUCK_BYPASS_SOC_CTRL_TWO_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_TWO_RW_SHIFT (0U)
/*! REG_BUCK_BYPASS_SOC_CTRL_TWO_RW - REG_BUCK_BYPASS_SOC_CTRL_TWO_RW */
#define BUCK18_BUCK_BYPASS_SOC_CTRL_TWO_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_TWO_RW(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_BYPASS_SOC_CTRL_TWO_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_TWO_RW_SHIFT)) & BUCK18_BUCK_BYPASS_SOC_CTRL_TWO_RW_REG_REG_BUCK_BYPASS_SOC_CTRL_TWO_RW_MASK)
/*! @} */

/*! @name BUCK_CTRL_ONE_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_ONE_REG_REG_BUCK_CTRL_ONE_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_ONE_REG_REG_BUCK_CTRL_ONE_SHIFT (0U)
/*! REG_BUCK_CTRL_ONE - REG_BUCK_CTRL_ONE */
#define BUCK18_BUCK_CTRL_ONE_REG_REG_BUCK_CTRL_ONE(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_ONE_REG_REG_BUCK_CTRL_ONE_SHIFT)) & BUCK18_BUCK_CTRL_ONE_REG_REG_BUCK_CTRL_ONE_MASK)
/*! @} */

/*! @name BUCK_CTRL_TWO_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_TWO_REG_REG_BUCK_CTRL_TWO_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_TWO_REG_REG_BUCK_CTRL_TWO_SHIFT (0U)
/*! REG_BUCK_CTRL_TWO - REG_BUCK_CTRL_TWO */
#define BUCK18_BUCK_CTRL_TWO_REG_REG_BUCK_CTRL_TWO(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_TWO_REG_REG_BUCK_CTRL_TWO_SHIFT)) & BUCK18_BUCK_CTRL_TWO_REG_REG_BUCK_CTRL_TWO_MASK)
/*! @} */

/*! @name BUCK_CTRL_THREE_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_THREE_REG_REG_BUCK_CTRL_THREE_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_THREE_REG_REG_BUCK_CTRL_THREE_SHIFT (0U)
/*! REG_BUCK_CTRL_THREE - REG_BUCK_CTRL_THREE */
#define BUCK18_BUCK_CTRL_THREE_REG_REG_BUCK_CTRL_THREE(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_THREE_REG_REG_BUCK_CTRL_THREE_SHIFT)) & BUCK18_BUCK_CTRL_THREE_REG_REG_BUCK_CTRL_THREE_MASK)
/*! @} */

/*! @name BUCK_CTRL_FOUR_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_FOUR_REG_REG_BUCK_CTRL_FOUR_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_FOUR_REG_REG_BUCK_CTRL_FOUR_SHIFT (0U)
/*! REG_BUCK_CTRL_FOUR - REG_BUCK_CTRL_FOUR */
#define BUCK18_BUCK_CTRL_FOUR_REG_REG_BUCK_CTRL_FOUR(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_FOUR_REG_REG_BUCK_CTRL_FOUR_SHIFT)) & BUCK18_BUCK_CTRL_FOUR_REG_REG_BUCK_CTRL_FOUR_MASK)
/*! @} */

/*! @name BUCK_CTRL_FIVE_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_FIVE_REG_REG_BUCK_CTRL_FIVE_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_FIVE_REG_REG_BUCK_CTRL_FIVE_SHIFT (0U)
/*! REG_BUCK_CTRL_FIVE - REG_BUCK_CTRL_FIVE */
#define BUCK18_BUCK_CTRL_FIVE_REG_REG_BUCK_CTRL_FIVE(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_FIVE_REG_REG_BUCK_CTRL_FIVE_SHIFT)) & BUCK18_BUCK_CTRL_FIVE_REG_REG_BUCK_CTRL_FIVE_MASK)
/*! @} */

/*! @name BUCK_CTRL_SIX_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_SIX_REG_REG_BUCK_CTRL_SIX_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_SIX_REG_REG_BUCK_CTRL_SIX_SHIFT (0U)
/*! REG_BUCK_CTRL_SIX - REG_BUCK_CTRL_SIX */
#define BUCK18_BUCK_CTRL_SIX_REG_REG_BUCK_CTRL_SIX(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_SIX_REG_REG_BUCK_CTRL_SIX_SHIFT)) & BUCK18_BUCK_CTRL_SIX_REG_REG_BUCK_CTRL_SIX_MASK)
/*! @} */

/*! @name BUCK_CTRL_SEVEN_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_SEVEN_REG_REG_BUCK_CTRL_SEVEN_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_SEVEN_REG_REG_BUCK_CTRL_SEVEN_SHIFT (0U)
/*! REG_BUCK_CTRL_SEVEN - REG_BUCK_CTRL_SEVEN */
#define BUCK18_BUCK_CTRL_SEVEN_REG_REG_BUCK_CTRL_SEVEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_SEVEN_REG_REG_BUCK_CTRL_SEVEN_SHIFT)) & BUCK18_BUCK_CTRL_SEVEN_REG_REG_BUCK_CTRL_SEVEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_EIGHT_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_EIGHT_REG_REG_BUCK_CTRL_EIGHT_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_EIGHT_REG_REG_BUCK_CTRL_EIGHT_SHIFT (0U)
/*! REG_BUCK_CTRL_EIGHT - REG_BUCK_CTRL_EIGHT */
#define BUCK18_BUCK_CTRL_EIGHT_REG_REG_BUCK_CTRL_EIGHT(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_EIGHT_REG_REG_BUCK_CTRL_EIGHT_SHIFT)) & BUCK18_BUCK_CTRL_EIGHT_REG_REG_BUCK_CTRL_EIGHT_MASK)
/*! @} */

/*! @name BUCK_CTRL_NINE_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_NINE_REG_REG_BUCK_CTRL_NINE_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_NINE_REG_REG_BUCK_CTRL_NINE_SHIFT (0U)
/*! REG_BUCK_CTRL_NINE - REG_BUCK_CTRL_NINE */
#define BUCK18_BUCK_CTRL_NINE_REG_REG_BUCK_CTRL_NINE(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_NINE_REG_REG_BUCK_CTRL_NINE_SHIFT)) & BUCK18_BUCK_CTRL_NINE_REG_REG_BUCK_CTRL_NINE_MASK)
/*! @} */

/*! @name BUCK_CTRL_TEN_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_TEN_REG_REG_BUCK_CTRL_TEN_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_TEN_REG_REG_BUCK_CTRL_TEN_SHIFT (0U)
/*! REG_BUCK_CTRL_TEN - REG_BUCK_CTRL_TEN */
#define BUCK18_BUCK_CTRL_TEN_REG_REG_BUCK_CTRL_TEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_TEN_REG_REG_BUCK_CTRL_TEN_SHIFT)) & BUCK18_BUCK_CTRL_TEN_REG_REG_BUCK_CTRL_TEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_ELEVEN_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_ELEVEN_REG_REG_BUCK_CTRL_ELEVEN_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_ELEVEN_REG_REG_BUCK_CTRL_ELEVEN_SHIFT (0U)
/*! REG_BUCK_CTRL_ELEVEN - REG_BUCK_CTRL_ELEVEN */
#define BUCK18_BUCK_CTRL_ELEVEN_REG_REG_BUCK_CTRL_ELEVEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_ELEVEN_REG_REG_BUCK_CTRL_ELEVEN_SHIFT)) & BUCK18_BUCK_CTRL_ELEVEN_REG_REG_BUCK_CTRL_ELEVEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_TWELVE_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_TWELVE_REG_REG_BUCK_CTRL_TWELVE_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_TWELVE_REG_REG_BUCK_CTRL_TWELVE_SHIFT (0U)
/*! REG_BUCK_CTRL_TWELVE - REG_BUCK_CTRL_TWELVE */
#define BUCK18_BUCK_CTRL_TWELVE_REG_REG_BUCK_CTRL_TWELVE(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_TWELVE_REG_REG_BUCK_CTRL_TWELVE_SHIFT)) & BUCK18_BUCK_CTRL_TWELVE_REG_REG_BUCK_CTRL_TWELVE_MASK)
/*! @} */

/*! @name BUCK_CTRL_THIRTEEN_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_THIRTEEN_REG_REG_BUCK_CTRL_THIRTEEN_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_THIRTEEN_REG_REG_BUCK_CTRL_THIRTEEN_SHIFT (0U)
/*! REG_BUCK_CTRL_THIRTEEN - REG_BUCK_CTRL_THIRTEEN */
#define BUCK18_BUCK_CTRL_THIRTEEN_REG_REG_BUCK_CTRL_THIRTEEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_THIRTEEN_REG_REG_BUCK_CTRL_THIRTEEN_SHIFT)) & BUCK18_BUCK_CTRL_THIRTEEN_REG_REG_BUCK_CTRL_THIRTEEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_FOURTEEN_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_FOURTEEN_REG_REG_BUCK_CTRL_FOURTEEN_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_FOURTEEN_REG_REG_BUCK_CTRL_FOURTEEN_SHIFT (0U)
/*! REG_BUCK_CTRL_FOURTEEN - REG_BUCK_CTRL_FOURTEEN */
#define BUCK18_BUCK_CTRL_FOURTEEN_REG_REG_BUCK_CTRL_FOURTEEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_FOURTEEN_REG_REG_BUCK_CTRL_FOURTEEN_SHIFT)) & BUCK18_BUCK_CTRL_FOURTEEN_REG_REG_BUCK_CTRL_FOURTEEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_FIFTEEN_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_FIFTEEN_REG_REG_BUCK_CTRL_FIFTEEN_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_FIFTEEN_REG_REG_BUCK_CTRL_FIFTEEN_SHIFT (0U)
/*! REG_BUCK_CTRL_FIFTEEN - REG_BUCK_CTRL_FIFTEEN */
#define BUCK18_BUCK_CTRL_FIFTEEN_REG_REG_BUCK_CTRL_FIFTEEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_FIFTEEN_REG_REG_BUCK_CTRL_FIFTEEN_SHIFT)) & BUCK18_BUCK_CTRL_FIFTEEN_REG_REG_BUCK_CTRL_FIFTEEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_SIXTEEN_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_SIXTEEN_REG_REG_BUCK_CTRL_SIXTEEN_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_SIXTEEN_REG_REG_BUCK_CTRL_SIXTEEN_SHIFT (0U)
/*! REG_BUCK_CTRL_SIXTEEN - REG_BUCK_CTRL_SIXTEEN */
#define BUCK18_BUCK_CTRL_SIXTEEN_REG_REG_BUCK_CTRL_SIXTEEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_SIXTEEN_REG_REG_BUCK_CTRL_SIXTEEN_SHIFT)) & BUCK18_BUCK_CTRL_SIXTEEN_REG_REG_BUCK_CTRL_SIXTEEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_SEVENTEEN_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_SEVENTEEN_REG_REG_BUCK_CTRL_SEVENTEEN_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_SEVENTEEN_REG_REG_BUCK_CTRL_SEVENTEEN_SHIFT (0U)
/*! REG_BUCK_CTRL_SEVENTEEN - REG_BUCK_CTRL_SEVENTEEN */
#define BUCK18_BUCK_CTRL_SEVENTEEN_REG_REG_BUCK_CTRL_SEVENTEEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_SEVENTEEN_REG_REG_BUCK_CTRL_SEVENTEEN_SHIFT)) & BUCK18_BUCK_CTRL_SEVENTEEN_REG_REG_BUCK_CTRL_SEVENTEEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_EIGHTEEN_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_EIGHTEEN_REG_REG_BUCK_CTRL_EIGHTEEN_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_EIGHTEEN_REG_REG_BUCK_CTRL_EIGHTEEN_SHIFT (0U)
/*! REG_BUCK_CTRL_EIGHTEEN - REG_BUCK_CTRL_EIGHTEEN */
#define BUCK18_BUCK_CTRL_EIGHTEEN_REG_REG_BUCK_CTRL_EIGHTEEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_EIGHTEEN_REG_REG_BUCK_CTRL_EIGHTEEN_SHIFT)) & BUCK18_BUCK_CTRL_EIGHTEEN_REG_REG_BUCK_CTRL_EIGHTEEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_NINTEEN_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_NINTEEN_REG_REG_BUCK_CTRL_NINTEEN_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_NINTEEN_REG_REG_BUCK_CTRL_NINTEEN_SHIFT (0U)
/*! REG_BUCK_CTRL_NINTEEN - REG_BUCK_CTRL_NINTEEN */
#define BUCK18_BUCK_CTRL_NINTEEN_REG_REG_BUCK_CTRL_NINTEEN(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_NINTEEN_REG_REG_BUCK_CTRL_NINTEEN_SHIFT)) & BUCK18_BUCK_CTRL_NINTEEN_REG_REG_BUCK_CTRL_NINTEEN_MASK)
/*! @} */

/*! @name BUCK_CTRL_TWENTY_REG -  */
/*! @{ */

#define BUCK18_BUCK_CTRL_TWENTY_REG_REG_BUCK_CTRL_TWENTY_MASK (0xFFU)
#define BUCK18_BUCK_CTRL_TWENTY_REG_REG_BUCK_CTRL_TWENTY_SHIFT (0U)
/*! REG_BUCK_CTRL_TWENTY - REG_BUCK_CTRL_TWENTY */
#define BUCK18_BUCK_CTRL_TWENTY_REG_REG_BUCK_CTRL_TWENTY(x) (((uint8_t)(((uint8_t)(x)) << BUCK18_BUCK_CTRL_TWENTY_REG_REG_BUCK_CTRL_TWENTY_SHIFT)) & BUCK18_BUCK_CTRL_TWENTY_REG_REG_BUCK_CTRL_TWENTY_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group BUCK18_Register_Masks */


/* BUCK18 - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral BUCK18 base address */
  #define BUCK18_BASE                              (0x55002000u)
  /** Peripheral BUCK18 base address */
  #define BUCK18_BASE_NS                           (0x45002000u)
  /** Peripheral BUCK18 base pointer */
  #define BUCK18                                   ((BUCK18_Type *)BUCK18_BASE)
  /** Peripheral BUCK18 base pointer */
  #define BUCK18_NS                                ((BUCK18_Type *)BUCK18_BASE_NS)
  /** Array initializer of BUCK18 peripheral base addresses */
  #define BUCK18_BASE_ADDRS                        { BUCK18_BASE }
  /** Array initializer of BUCK18 peripheral base pointers */
  #define BUCK18_BASE_PTRS                         { BUCK18 }
  /** Array initializer of BUCK18 peripheral base addresses */
  #define BUCK18_BASE_ADDRS_NS                     { BUCK18_BASE_NS }
  /** Array initializer of BUCK18 peripheral base pointers */
  #define BUCK18_BASE_PTRS_NS                      { BUCK18_NS }
#else
  /** Peripheral BUCK18 base address */
  #define BUCK18_BASE                              (0x45002000u)
  /** Peripheral BUCK18 base pointer */
  #define BUCK18                                   ((BUCK18_Type *)BUCK18_BASE)
  /** Array initializer of BUCK18 peripheral base addresses */
  #define BUCK18_BASE_ADDRS                        { BUCK18_BASE }
  /** Array initializer of BUCK18 peripheral base pointers */
  #define BUCK18_BASE_PTRS                         { BUCK18 }
#endif

/*!
 * @}
 */ /* end of group BUCK18_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CACHE64_CTRL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_CTRL_Peripheral_Access_Layer CACHE64_CTRL Peripheral Access Layer
 * @{
 */

/** CACHE64_CTRL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[2048];
  __IO uint32_t CCR;                               /**< Cache control register, offset: 0x800 */
  __IO uint32_t CLCR;                              /**< Cache line control register, offset: 0x804 */
  __IO uint32_t CSAR;                              /**< Cache search address register, offset: 0x808 */
  __IO uint32_t CCVR;                              /**< Cache read/write value register, offset: 0x80C */
} CACHE64_CTRL_Type;

/* ----------------------------------------------------------------------------
   -- CACHE64_CTRL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_CTRL_Register_Masks CACHE64_CTRL Register Masks
 * @{
 */

/*! @name CCR - Cache control register */
/*! @{ */

#define CACHE64_CTRL_CCR_ENCACHE_MASK            (0x1U)
#define CACHE64_CTRL_CCR_ENCACHE_SHIFT           (0U)
/*! ENCACHE - Cache enable
 *  0b0..Cache disabled
 *  0b1..Cache enabled
 */
#define CACHE64_CTRL_CCR_ENCACHE(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_ENCACHE_SHIFT)) & CACHE64_CTRL_CCR_ENCACHE_MASK)

#define CACHE64_CTRL_CCR_ENWRBUF_MASK            (0x2U)
#define CACHE64_CTRL_CCR_ENWRBUF_SHIFT           (1U)
/*! ENWRBUF - Enable Write Buffer
 *  0b0..Write buffer disabled
 *  0b1..Write buffer enabled
 */
#define CACHE64_CTRL_CCR_ENWRBUF(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_ENWRBUF_SHIFT)) & CACHE64_CTRL_CCR_ENWRBUF_MASK)

#define CACHE64_CTRL_CCR_INVW0_MASK              (0x1000000U)
#define CACHE64_CTRL_CCR_INVW0_SHIFT             (24U)
/*! INVW0 - Invalidate Way 0
 *  0b0..No operation
 *  0b1..When setting the GO bit, invalidate all lines in way 0.
 */
#define CACHE64_CTRL_CCR_INVW0(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_INVW0_SHIFT)) & CACHE64_CTRL_CCR_INVW0_MASK)

#define CACHE64_CTRL_CCR_PUSHW0_MASK             (0x2000000U)
#define CACHE64_CTRL_CCR_PUSHW0_SHIFT            (25U)
/*! PUSHW0 - Push Way 0
 *  0b0..No operation
 *  0b1..When setting the GO bit, push all modified lines in way 0
 */
#define CACHE64_CTRL_CCR_PUSHW0(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_PUSHW0_SHIFT)) & CACHE64_CTRL_CCR_PUSHW0_MASK)

#define CACHE64_CTRL_CCR_INVW1_MASK              (0x4000000U)
#define CACHE64_CTRL_CCR_INVW1_SHIFT             (26U)
/*! INVW1 - Invalidate Way 1
 *  0b0..No operation
 *  0b1..When setting the GO bit, invalidate all lines in way 1
 */
#define CACHE64_CTRL_CCR_INVW1(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_INVW1_SHIFT)) & CACHE64_CTRL_CCR_INVW1_MASK)

#define CACHE64_CTRL_CCR_PUSHW1_MASK             (0x8000000U)
#define CACHE64_CTRL_CCR_PUSHW1_SHIFT            (27U)
/*! PUSHW1 - Push Way 1
 *  0b0..No operation
 *  0b1..When setting the GO bit, push all modified lines in way 1
 */
#define CACHE64_CTRL_CCR_PUSHW1(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_PUSHW1_SHIFT)) & CACHE64_CTRL_CCR_PUSHW1_MASK)

#define CACHE64_CTRL_CCR_GO_MASK                 (0x80000000U)
#define CACHE64_CTRL_CCR_GO_SHIFT                (31U)
/*! GO - Initiate Cache Command
 *  0b0..Write: no effect. Read: no cache command active.
 *  0b1..Write: initiate command indicated by bits 27-24. Read: cache command active.
 */
#define CACHE64_CTRL_CCR_GO(x)                   (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_GO_SHIFT)) & CACHE64_CTRL_CCR_GO_MASK)
/*! @} */

/*! @name CLCR - Cache line control register */
/*! @{ */

#define CACHE64_CTRL_CLCR_LGO_MASK               (0x1U)
#define CACHE64_CTRL_CLCR_LGO_SHIFT              (0U)
/*! LGO - Initiate Cache Line Command
 *  0b0..Write: no effect. Read: no line command active.
 *  0b1..Write: initiate line command indicated by bits 27-24. Read: line command active.
 */
#define CACHE64_CTRL_CLCR_LGO(x)                 (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LGO_SHIFT)) & CACHE64_CTRL_CLCR_LGO_MASK)

#define CACHE64_CTRL_CLCR_CACHEADDR_MASK         (0x3FFCU)
#define CACHE64_CTRL_CLCR_CACHEADDR_SHIFT        (2U)
/*! CACHEADDR - Cache address */
#define CACHE64_CTRL_CLCR_CACHEADDR(x)           (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_CACHEADDR_SHIFT)) & CACHE64_CTRL_CLCR_CACHEADDR_MASK)

#define CACHE64_CTRL_CLCR_WSEL_MASK              (0x4000U)
#define CACHE64_CTRL_CLCR_WSEL_SHIFT             (14U)
/*! WSEL - Way select
 *  0b0..Way 0
 *  0b1..Way 1
 */
#define CACHE64_CTRL_CLCR_WSEL(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_WSEL_SHIFT)) & CACHE64_CTRL_CLCR_WSEL_MASK)

#define CACHE64_CTRL_CLCR_TDSEL_MASK             (0x10000U)
#define CACHE64_CTRL_CLCR_TDSEL_SHIFT            (16U)
/*! TDSEL - Tag/Data Select
 *  0b0..Data
 *  0b1..Tag
 */
#define CACHE64_CTRL_CLCR_TDSEL(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_TDSEL_SHIFT)) & CACHE64_CTRL_CLCR_TDSEL_MASK)

#define CACHE64_CTRL_CLCR_LCIVB_MASK             (0x100000U)
#define CACHE64_CTRL_CLCR_LCIVB_SHIFT            (20U)
/*! LCIVB - Line Command Initial Valid Bit */
#define CACHE64_CTRL_CLCR_LCIVB(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCIVB_SHIFT)) & CACHE64_CTRL_CLCR_LCIVB_MASK)

#define CACHE64_CTRL_CLCR_LCIMB_MASK             (0x200000U)
#define CACHE64_CTRL_CLCR_LCIMB_SHIFT            (21U)
/*! LCIMB - Line Command Initial Modified Bit */
#define CACHE64_CTRL_CLCR_LCIMB(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCIMB_SHIFT)) & CACHE64_CTRL_CLCR_LCIMB_MASK)

#define CACHE64_CTRL_CLCR_LCWAY_MASK             (0x400000U)
#define CACHE64_CTRL_CLCR_LCWAY_SHIFT            (22U)
/*! LCWAY - Line Command Way */
#define CACHE64_CTRL_CLCR_LCWAY(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCWAY_SHIFT)) & CACHE64_CTRL_CLCR_LCWAY_MASK)

#define CACHE64_CTRL_CLCR_LCMD_MASK              (0x3000000U)
#define CACHE64_CTRL_CLCR_LCMD_SHIFT             (24U)
/*! LCMD - Line Command
 *  0b00..Search and read or write
 *  0b01..Invalidate
 *  0b10..Push
 *  0b11..Clear
 */
#define CACHE64_CTRL_CLCR_LCMD(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCMD_SHIFT)) & CACHE64_CTRL_CLCR_LCMD_MASK)

#define CACHE64_CTRL_CLCR_LADSEL_MASK            (0x4000000U)
#define CACHE64_CTRL_CLCR_LADSEL_SHIFT           (26U)
/*! LADSEL - Line Address Select
 *  0b0..Cache address
 *  0b1..Physical address
 */
#define CACHE64_CTRL_CLCR_LADSEL(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LADSEL_SHIFT)) & CACHE64_CTRL_CLCR_LADSEL_MASK)

#define CACHE64_CTRL_CLCR_LACC_MASK              (0x8000000U)
#define CACHE64_CTRL_CLCR_LACC_SHIFT             (27U)
/*! LACC - Line access type
 *  0b0..Read
 *  0b1..Write
 */
#define CACHE64_CTRL_CLCR_LACC(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LACC_SHIFT)) & CACHE64_CTRL_CLCR_LACC_MASK)
/*! @} */

/*! @name CSAR - Cache search address register */
/*! @{ */

#define CACHE64_CTRL_CSAR_LGO_MASK               (0x1U)
#define CACHE64_CTRL_CSAR_LGO_SHIFT              (0U)
/*! LGO - Initiate Cache Line Command
 *  0b0..Write: no effect. Read: no line command active.
 *  0b1..Write: initiate line command indicated by bits CLCR[27:24]. Read: line command active.
 */
#define CACHE64_CTRL_CSAR_LGO(x)                 (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_LGO_SHIFT)) & CACHE64_CTRL_CSAR_LGO_MASK)

#define CACHE64_CTRL_CSAR_PHYADDR27_1_MASK       (0xFFFFFFEU)
#define CACHE64_CTRL_CSAR_PHYADDR27_1_SHIFT      (1U)
/*! PHYADDR27_1 - Physical Address */
#define CACHE64_CTRL_CSAR_PHYADDR27_1(x)         (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_PHYADDR27_1_SHIFT)) & CACHE64_CTRL_CSAR_PHYADDR27_1_MASK)

#define CACHE64_CTRL_CSAR_PHYADDR31_29_MASK      (0xE0000000U)
#define CACHE64_CTRL_CSAR_PHYADDR31_29_SHIFT     (29U)
/*! PHYADDR31_29 - Physical Address */
#define CACHE64_CTRL_CSAR_PHYADDR31_29(x)        (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_PHYADDR31_29_SHIFT)) & CACHE64_CTRL_CSAR_PHYADDR31_29_MASK)
/*! @} */

/*! @name CCVR - Cache read/write value register */
/*! @{ */

#define CACHE64_CTRL_CCVR_DATA_MASK              (0xFFFFFFFFU)
#define CACHE64_CTRL_CCVR_DATA_SHIFT             (0U)
/*! DATA - Cache read/write Data */
#define CACHE64_CTRL_CCVR_DATA(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCVR_DATA_SHIFT)) & CACHE64_CTRL_CCVR_DATA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CACHE64_CTRL_Register_Masks */


/* CACHE64_CTRL - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CACHE64_CTRL0 base address */
  #define CACHE64_CTRL0_BASE                       (0x50033000u)
  /** Peripheral CACHE64_CTRL0 base address */
  #define CACHE64_CTRL0_BASE_NS                    (0x40033000u)
  /** Peripheral CACHE64_CTRL0 base pointer */
  #define CACHE64_CTRL0                            ((CACHE64_CTRL_Type *)CACHE64_CTRL0_BASE)
  /** Peripheral CACHE64_CTRL0 base pointer */
  #define CACHE64_CTRL0_NS                         ((CACHE64_CTRL_Type *)CACHE64_CTRL0_BASE_NS)
  /** Peripheral CACHE64_CTRL1 base address */
  #define CACHE64_CTRL1_BASE                       (0x50034000u)
  /** Peripheral CACHE64_CTRL1 base address */
  #define CACHE64_CTRL1_BASE_NS                    (0x40034000u)
  /** Peripheral CACHE64_CTRL1 base pointer */
  #define CACHE64_CTRL1                            ((CACHE64_CTRL_Type *)CACHE64_CTRL1_BASE)
  /** Peripheral CACHE64_CTRL1 base pointer */
  #define CACHE64_CTRL1_NS                         ((CACHE64_CTRL_Type *)CACHE64_CTRL1_BASE_NS)
  /** Array initializer of CACHE64_CTRL peripheral base addresses */
  #define CACHE64_CTRL_BASE_ADDRS                  { CACHE64_CTRL0_BASE, CACHE64_CTRL1_BASE }
  /** Array initializer of CACHE64_CTRL peripheral base pointers */
  #define CACHE64_CTRL_BASE_PTRS                   { CACHE64_CTRL0, CACHE64_CTRL1 }
  /** Array initializer of CACHE64_CTRL peripheral base addresses */
  #define CACHE64_CTRL_BASE_ADDRS_NS               { CACHE64_CTRL0_BASE_NS, CACHE64_CTRL1_BASE_NS }
  /** Array initializer of CACHE64_CTRL peripheral base pointers */
  #define CACHE64_CTRL_BASE_PTRS_NS                { CACHE64_CTRL0_NS, CACHE64_CTRL1_NS }
#else
  /** Peripheral CACHE64_CTRL0 base address */
  #define CACHE64_CTRL0_BASE                       (0x40033000u)
  /** Peripheral CACHE64_CTRL0 base pointer */
  #define CACHE64_CTRL0                            ((CACHE64_CTRL_Type *)CACHE64_CTRL0_BASE)
  /** Peripheral CACHE64_CTRL1 base address */
  #define CACHE64_CTRL1_BASE                       (0x40034000u)
  /** Peripheral CACHE64_CTRL1 base pointer */
  #define CACHE64_CTRL1                            ((CACHE64_CTRL_Type *)CACHE64_CTRL1_BASE)
  /** Array initializer of CACHE64_CTRL peripheral base addresses */
  #define CACHE64_CTRL_BASE_ADDRS                  { CACHE64_CTRL0_BASE, CACHE64_CTRL1_BASE }
  /** Array initializer of CACHE64_CTRL peripheral base pointers */
  #define CACHE64_CTRL_BASE_PTRS                   { CACHE64_CTRL0, CACHE64_CTRL1 }
#endif
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
/** CACHE64_CTRL physical memory base address */
 #define CACHE64_CTRL_PHYMEM_BASES                { 0x18000000u, 0x38000000u }
/** CACHE64_CTRL physical memory size */
 #define CACHE64_CTRL_PHYMEM_SIZES                { 0x08000000u, 0x08000000u }
/** CACHE64_CTRL physical memory base address */
 #define CACHE64_CTRL_PHYMEM_BASES_NS             { 0x08000000u, 0x28000000u }
/** CACHE64_CTRL physical memory size */
 #define CACHE64_CTRL_PHYMEM_SIZES_NS             { 0x08000000u, 0x08000000u }
#else
/** CACHE64_CTRL physical memory base address */
 #define CACHE64_CTRL_PHYMEM_BASES                { 0x08000000u, 0x28000000u }
/** CACHE64_CTRL physical memory size */
 #define CACHE64_CTRL_PHYMEM_SIZES                { 0x08000000u, 0x08000000u }
#endif
/* Backward compatibility */
#define CACHE64_CTRL_CSAR_PHYADDR_MASK (CACHE64_CTRL_CSAR_PHYADDR27_1_MASK | CACHE64_CTRL_CSAR_PHYADDR31_29_MASK)


/*!
 * @}
 */ /* end of group CACHE64_CTRL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CACHE64_POLSEL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_POLSEL_Peripheral_Access_Layer CACHE64_POLSEL Peripheral Access Layer
 * @{
 */

/** CACHE64_POLSEL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[20];
  __IO uint32_t REG0_TOP;                          /**< Region 0 Top Boundary, offset: 0x14 */
  __IO uint32_t REG1_TOP;                          /**< Region 1 Top Boundary, offset: 0x18 */
  __IO uint32_t POLSEL;                            /**< Policy Select, offset: 0x1C */
} CACHE64_POLSEL_Type;

/* ----------------------------------------------------------------------------
   -- CACHE64_POLSEL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_POLSEL_Register_Masks CACHE64_POLSEL Register Masks
 * @{
 */

/*! @name REG0_TOP - Region 0 Top Boundary */
/*! @{ */

#define CACHE64_POLSEL_REG0_TOP_REG0_TOP_MASK    (0x7FFFC00U)
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP_SHIFT   (10U)
/*! REG0_TOP - Upper limit of Region 0 */
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP(x)      (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_REG0_TOP_REG0_TOP_SHIFT)) & CACHE64_POLSEL_REG0_TOP_REG0_TOP_MASK)
/*! @} */

/*! @name REG1_TOP - Region 1 Top Boundary */
/*! @{ */

#define CACHE64_POLSEL_REG1_TOP_REG1_TOP_MASK    (0x7FFFC00U)
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP_SHIFT   (10U)
/*! REG1_TOP - Upper limit of Region 1 */
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP(x)      (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_REG1_TOP_REG1_TOP_SHIFT)) & CACHE64_POLSEL_REG1_TOP_REG1_TOP_MASK)
/*! @} */

/*! @name POLSEL - Policy Select */
/*! @{ */

#define CACHE64_POLSEL_POLSEL_REG0_POLICY_MASK   (0x3U)
#define CACHE64_POLSEL_POLSEL_REG0_POLICY_SHIFT  (0U)
/*! REG0_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG0_POLICY(x)     (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG0_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG0_POLICY_MASK)

#define CACHE64_POLSEL_POLSEL_REG1_POLICY_MASK   (0xCU)
#define CACHE64_POLSEL_POLSEL_REG1_POLICY_SHIFT  (2U)
/*! REG1_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG1_POLICY(x)     (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG1_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG1_POLICY_MASK)

#define CACHE64_POLSEL_POLSEL_REG02_POLICY_MASK  (0x30U)
#define CACHE64_POLSEL_POLSEL_REG02_POLICY_SHIFT (4U)
/*! REG02_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG02_POLICY(x)    (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG02_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG02_POLICY_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CACHE64_POLSEL_Register_Masks */


/* CACHE64_POLSEL - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CACHE64_POLSEL0 base address */
  #define CACHE64_POLSEL0_BASE                     (0x50033000u)
  /** Peripheral CACHE64_POLSEL0 base address */
  #define CACHE64_POLSEL0_BASE_NS                  (0x40033000u)
  /** Peripheral CACHE64_POLSEL0 base pointer */
  #define CACHE64_POLSEL0                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL0_BASE)
  /** Peripheral CACHE64_POLSEL0 base pointer */
  #define CACHE64_POLSEL0_NS                       ((CACHE64_POLSEL_Type *)CACHE64_POLSEL0_BASE_NS)
  /** Peripheral CACHE64_POLSEL1 base address */
  #define CACHE64_POLSEL1_BASE                     (0x50034000u)
  /** Peripheral CACHE64_POLSEL1 base address */
  #define CACHE64_POLSEL1_BASE_NS                  (0x40034000u)
  /** Peripheral CACHE64_POLSEL1 base pointer */
  #define CACHE64_POLSEL1                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL1_BASE)
  /** Peripheral CACHE64_POLSEL1 base pointer */
  #define CACHE64_POLSEL1_NS                       ((CACHE64_POLSEL_Type *)CACHE64_POLSEL1_BASE_NS)
  /** Array initializer of CACHE64_POLSEL peripheral base addresses */
  #define CACHE64_POLSEL_BASE_ADDRS                { CACHE64_POLSEL0_BASE, CACHE64_POLSEL1_BASE }
  /** Array initializer of CACHE64_POLSEL peripheral base pointers */
  #define CACHE64_POLSEL_BASE_PTRS                 { CACHE64_POLSEL0, CACHE64_POLSEL1 }
  /** Array initializer of CACHE64_POLSEL peripheral base addresses */
  #define CACHE64_POLSEL_BASE_ADDRS_NS             { CACHE64_POLSEL0_BASE_NS, CACHE64_POLSEL1_BASE_NS }
  /** Array initializer of CACHE64_POLSEL peripheral base pointers */
  #define CACHE64_POLSEL_BASE_PTRS_NS              { CACHE64_POLSEL0_NS, CACHE64_POLSEL1_NS }
#else
  /** Peripheral CACHE64_POLSEL0 base address */
  #define CACHE64_POLSEL0_BASE                     (0x40033000u)
  /** Peripheral CACHE64_POLSEL0 base pointer */
  #define CACHE64_POLSEL0                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL0_BASE)
  /** Peripheral CACHE64_POLSEL1 base address */
  #define CACHE64_POLSEL1_BASE                     (0x40034000u)
  /** Peripheral CACHE64_POLSEL1 base pointer */
  #define CACHE64_POLSEL1                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL1_BASE)
  /** Array initializer of CACHE64_POLSEL peripheral base addresses */
  #define CACHE64_POLSEL_BASE_ADDRS                { CACHE64_POLSEL0_BASE, CACHE64_POLSEL1_BASE }
  /** Array initializer of CACHE64_POLSEL peripheral base pointers */
  #define CACHE64_POLSEL_BASE_PTRS                 { CACHE64_POLSEL0, CACHE64_POLSEL1 }
#endif

/*!
 * @}
 */ /* end of group CACHE64_POLSEL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CAU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAU_Peripheral_Access_Layer CAU Peripheral Access Layer
 * @{
 */

/** CAU - Register Layout Typedef */
typedef struct {
  __I  uint8_t BYPASS_SOC_PD_CTRL_RO_REG;          /**< offset: 0x0 */
  __I  uint8_t BYPASS_SOC_CTRL_ONE_RO_REG;         /**< offset: 0x1 */
  __I  uint8_t BYPASS_SOC_CTRL_TWO_RO_REG;         /**< offset: 0x2 */
  __I  uint8_t BYPASS_RFU_CTRL_ONE_RO_REG;         /**< offset: 0x3 */
  __I  uint8_t REG_RO_ONE_REG;                     /**< offset: 0x4 */
  __I  uint8_t REG_RO_TWO_REG;                     /**< offset: 0x5 */
  __I  uint8_t REG_RO_THREE_REG;                   /**< offset: 0x6 */
  __I  uint8_t REG_RO_FOUR_REG;                    /**< offset: 0x7 */
  __I  uint8_t REG_RO_FIVE_REG;                    /**< offset: 0x8 */
  __I  uint8_t REG_RO_SIX_REG;                     /**< offset: 0x9 */
  __IO uint8_t SW_RESET_B_REG;                     /**< offset: 0xA */
  __IO uint8_t SYS_CTRL_REG;                       /**< offset: 0xB */
  __IO uint8_t SYS_CTRL_PWR_OPT_SEL_REG;           /**< offset: 0xC */
  __IO uint8_t BYPASS_SOC_PD_CTRL_RW_REG;          /**< offset: 0xD */
  __IO uint8_t BYPASS_SOC_CTRL_ONE_RW_REG;         /**< offset: 0xE */
  __IO uint8_t BYPASS_SOC_CTRL_TWO_RW_REG;         /**< offset: 0xF */
  __IO uint8_t BYPASS_RFU_CTRL_ONE_RW_REG;         /**< offset: 0x10 */
  __IO uint8_t PD_CTRL_ONE_REG;                    /**< offset: 0x11 */
  __IO uint8_t PD_CTRL_TWO_REG;                    /**< offset: 0x12 */
  __IO uint8_t SLP_CTRL_ONE_REG;                   /**< offset: 0x13 */
  __IO uint8_t SLP_CTRL_TWO_REG;                   /**< offset: 0x14 */
  __IO uint8_t BG_CTRL_REG;                        /**< offset: 0x15 */
  __IO uint8_t CPREG_CTRL_ONE_REG;                 /**< offset: 0x16 */
  __IO uint8_t CPREG_CTRL_TWO_REG;                 /**< offset: 0x17 */
  __IO uint8_t CPREG_CTRL_THREE_REG;               /**< offset: 0x18 */
  __IO uint8_t PSEN_CTRL_ONE_REG;                  /**< offset: 0x19 */
  __IO uint8_t PSEN_CTRL_TWO_REG;                  /**< offset: 0x1A */
  __IO uint8_t TSEN_CTRL_ONE_REG;                  /**< offset: 0x1B */
  __IO uint8_t TSEN_CTRL_THREE_REG;                /**< offset: 0x1C */
  __IO uint8_t ADC_CTRL_ONE_REG;                   /**< offset: 0x1D */
  __IO uint8_t RCAL_CTRL_ONE_REG;                  /**< offset: 0x1E */
  __IO uint8_t RCAL_CTRL_TWO_REG;                  /**< offset: 0x1F */
  __IO uint8_t XTAL_CTRL_ONE_REG;                  /**< offset: 0x20 */
  __IO uint8_t XTAL_CTRL_TWO_REG;                  /**< offset: 0x21 */
  __IO uint8_t XTAL_CTRL_THREE_REG;                /**< offset: 0x22 */
  __IO uint8_t XTAL_CTRL_FOUR_REG;                 /**< offset: 0x23 */
  __IO uint8_t XTAL_CTRL_FIVE_REG;                 /**< offset: 0x24 */
  __IO uint8_t XTAL_CTRL_SIX_REG;                  /**< offset: 0x25 */
  __IO uint8_t XTAL_CTRL_SEVEN_REG;                /**< offset: 0x26 */
  __IO uint8_t XTAL_CTRL_EIGHT_REG;                /**< offset: 0x27 */
  __IO uint8_t XTAL_CTRL_NINE_REG;                 /**< offset: 0x28 */
  __IO uint8_t XTAL_CTRL_TEN_REG;                  /**< offset: 0x29 */
  __IO uint8_t XTAL_CTRL_ELEVEN_REG;               /**< offset: 0x2A */
  __IO uint8_t XTAL_CTRL_TWELVE_REG;               /**< offset: 0x2B */
  __IO uint8_t XTAL_CTRL_THIRTEEN_REG;             /**< offset: 0x2C */
  __IO uint8_t XTAL_CTRL_FOURTEEN_REG;             /**< offset: 0x2D */
  __IO uint8_t XTAL_CTRL_FIFTEEN_REG;              /**< offset: 0x2E */
  __IO uint8_t T1_CTRL_RSVD_HI_REG;                /**< offset: 0x2F */
  __IO uint8_t T1_CTRL_RSVD_LO_REG;                /**< offset: 0x30 */
  __IO uint8_t GPIO_CTRL_REG;                      /**< offset: 0x31 */
  __IO uint8_t ATEST_CTRL_ONE_REG;                 /**< offset: 0x32 */
  __IO uint8_t ATEST_CTRL_TWO_REG;                 /**< offset: 0x33 */
  __IO uint8_t ATEST_CTRL_THREE_REG;               /**< offset: 0x34 */
  __IO uint8_t ATEST_CTRL_FOUR_REG;                /**< offset: 0x35 */
  __IO uint8_t ATEST_CTRL_FIVE_REG;                /**< offset: 0x36 */
  __IO uint8_t ATEST_CTRL_SIX_REG;                 /**< offset: 0x37 */
  __IO uint8_t ATEST_CTRL_SEVEN_REG;               /**< offset: 0x38 */
  __IO uint8_t RESERVED_LO_ONE_REG;                /**< offset: 0x39 */
  __IO uint8_t RESERVED_LO_TWO_REG;                /**< offset: 0x3A */
  __IO uint8_t RESERVED_HI_ONE_REG;                /**< offset: 0x3B */
  __IO uint8_t RESERVED_HI_TWO_REG;                /**< offset: 0x3C */
} CAU_Type;

/* ----------------------------------------------------------------------------
   -- CAU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAU_Register_Masks CAU Register Masks
 * @{
 */

/*! @name BYPASS_SOC_PD_CTRL_RO_REG -  */
/*! @{ */

#define CAU_BYPASS_SOC_PD_CTRL_RO_REG_BYPASS_SOC_PD_CTRL_RO_MASK (0xFFU)
#define CAU_BYPASS_SOC_PD_CTRL_RO_REG_BYPASS_SOC_PD_CTRL_RO_SHIFT (0U)
/*! BYPASS_SOC_PD_CTRL_RO - BYPASS_SOC_PD_CTRL_RO */
#define CAU_BYPASS_SOC_PD_CTRL_RO_REG_BYPASS_SOC_PD_CTRL_RO(x) (((uint8_t)(((uint8_t)(x)) << CAU_BYPASS_SOC_PD_CTRL_RO_REG_BYPASS_SOC_PD_CTRL_RO_SHIFT)) & CAU_BYPASS_SOC_PD_CTRL_RO_REG_BYPASS_SOC_PD_CTRL_RO_MASK)
/*! @} */

/*! @name BYPASS_SOC_CTRL_ONE_RO_REG -  */
/*! @{ */

#define CAU_BYPASS_SOC_CTRL_ONE_RO_REG_BYPASS_SOC_CTRL_ONE_RO_MASK (0xFFU)
#define CAU_BYPASS_SOC_CTRL_ONE_RO_REG_BYPASS_SOC_CTRL_ONE_RO_SHIFT (0U)
/*! BYPASS_SOC_CTRL_ONE_RO - BYPASS_SOC_CTRL_ONE_RO */
#define CAU_BYPASS_SOC_CTRL_ONE_RO_REG_BYPASS_SOC_CTRL_ONE_RO(x) (((uint8_t)(((uint8_t)(x)) << CAU_BYPASS_SOC_CTRL_ONE_RO_REG_BYPASS_SOC_CTRL_ONE_RO_SHIFT)) & CAU_BYPASS_SOC_CTRL_ONE_RO_REG_BYPASS_SOC_CTRL_ONE_RO_MASK)
/*! @} */

/*! @name BYPASS_SOC_CTRL_TWO_RO_REG -  */
/*! @{ */

#define CAU_BYPASS_SOC_CTRL_TWO_RO_REG_BYPASS_SOC_CTRL_TWO_RO_MASK (0xFFU)
#define CAU_BYPASS_SOC_CTRL_TWO_RO_REG_BYPASS_SOC_CTRL_TWO_RO_SHIFT (0U)
/*! BYPASS_SOC_CTRL_TWO_RO - BYPASS_SOC_CTRL_TWO_RO */
#define CAU_BYPASS_SOC_CTRL_TWO_RO_REG_BYPASS_SOC_CTRL_TWO_RO(x) (((uint8_t)(((uint8_t)(x)) << CAU_BYPASS_SOC_CTRL_TWO_RO_REG_BYPASS_SOC_CTRL_TWO_RO_SHIFT)) & CAU_BYPASS_SOC_CTRL_TWO_RO_REG_BYPASS_SOC_CTRL_TWO_RO_MASK)
/*! @} */

/*! @name BYPASS_RFU_CTRL_ONE_RO_REG -  */
/*! @{ */

#define CAU_BYPASS_RFU_CTRL_ONE_RO_REG_BYPASS_RFU_CTRL_ONE_RO_MASK (0xFFU)
#define CAU_BYPASS_RFU_CTRL_ONE_RO_REG_BYPASS_RFU_CTRL_ONE_RO_SHIFT (0U)
/*! BYPASS_RFU_CTRL_ONE_RO - BYPASS_RFU_CTRL_ONE_RO */
#define CAU_BYPASS_RFU_CTRL_ONE_RO_REG_BYPASS_RFU_CTRL_ONE_RO(x) (((uint8_t)(((uint8_t)(x)) << CAU_BYPASS_RFU_CTRL_ONE_RO_REG_BYPASS_RFU_CTRL_ONE_RO_SHIFT)) & CAU_BYPASS_RFU_CTRL_ONE_RO_REG_BYPASS_RFU_CTRL_ONE_RO_MASK)
/*! @} */

/*! @name REG_RO_ONE_REG -  */
/*! @{ */

#define CAU_REG_RO_ONE_REG_REG_RO_ONE_MASK       (0xFFU)
#define CAU_REG_RO_ONE_REG_REG_RO_ONE_SHIFT      (0U)
/*! REG_RO_ONE - REG_RO_ONE */
#define CAU_REG_RO_ONE_REG_REG_RO_ONE(x)         (((uint8_t)(((uint8_t)(x)) << CAU_REG_RO_ONE_REG_REG_RO_ONE_SHIFT)) & CAU_REG_RO_ONE_REG_REG_RO_ONE_MASK)
/*! @} */

/*! @name REG_RO_TWO_REG -  */
/*! @{ */

#define CAU_REG_RO_TWO_REG_REG_RO_TWO_MASK       (0xFFU)
#define CAU_REG_RO_TWO_REG_REG_RO_TWO_SHIFT      (0U)
/*! REG_RO_TWO - REG_RO_TWO */
#define CAU_REG_RO_TWO_REG_REG_RO_TWO(x)         (((uint8_t)(((uint8_t)(x)) << CAU_REG_RO_TWO_REG_REG_RO_TWO_SHIFT)) & CAU_REG_RO_TWO_REG_REG_RO_TWO_MASK)
/*! @} */

/*! @name REG_RO_THREE_REG -  */
/*! @{ */

#define CAU_REG_RO_THREE_REG_REG_RO_THREE_MASK   (0xFFU)
#define CAU_REG_RO_THREE_REG_REG_RO_THREE_SHIFT  (0U)
/*! REG_RO_THREE - REG_RO_THREE */
#define CAU_REG_RO_THREE_REG_REG_RO_THREE(x)     (((uint8_t)(((uint8_t)(x)) << CAU_REG_RO_THREE_REG_REG_RO_THREE_SHIFT)) & CAU_REG_RO_THREE_REG_REG_RO_THREE_MASK)
/*! @} */

/*! @name REG_RO_FOUR_REG -  */
/*! @{ */

#define CAU_REG_RO_FOUR_REG_REG_RO_FOUR_MASK     (0xFFU)
#define CAU_REG_RO_FOUR_REG_REG_RO_FOUR_SHIFT    (0U)
/*! REG_RO_FOUR - REG_RO_FOUR */
#define CAU_REG_RO_FOUR_REG_REG_RO_FOUR(x)       (((uint8_t)(((uint8_t)(x)) << CAU_REG_RO_FOUR_REG_REG_RO_FOUR_SHIFT)) & CAU_REG_RO_FOUR_REG_REG_RO_FOUR_MASK)
/*! @} */

/*! @name REG_RO_FIVE_REG -  */
/*! @{ */

#define CAU_REG_RO_FIVE_REG_REG_RO_FIVE_MASK     (0xFFU)
#define CAU_REG_RO_FIVE_REG_REG_RO_FIVE_SHIFT    (0U)
/*! REG_RO_FIVE - REG_RO_FIVE */
#define CAU_REG_RO_FIVE_REG_REG_RO_FIVE(x)       (((uint8_t)(((uint8_t)(x)) << CAU_REG_RO_FIVE_REG_REG_RO_FIVE_SHIFT)) & CAU_REG_RO_FIVE_REG_REG_RO_FIVE_MASK)
/*! @} */

/*! @name REG_RO_SIX_REG -  */
/*! @{ */

#define CAU_REG_RO_SIX_REG_REG_RO_SIX_MASK       (0xFFU)
#define CAU_REG_RO_SIX_REG_REG_RO_SIX_SHIFT      (0U)
/*! REG_RO_SIX - REG_RO_SIX */
#define CAU_REG_RO_SIX_REG_REG_RO_SIX(x)         (((uint8_t)(((uint8_t)(x)) << CAU_REG_RO_SIX_REG_REG_RO_SIX_SHIFT)) & CAU_REG_RO_SIX_REG_REG_RO_SIX_MASK)
/*! @} */

/*! @name SW_RESET_B_REG -  */
/*! @{ */

#define CAU_SW_RESET_B_REG_SW_RESET_B_MASK       (0xFFU)
#define CAU_SW_RESET_B_REG_SW_RESET_B_SHIFT      (0U)
/*! SW_RESET_B - SW_RESET_B */
#define CAU_SW_RESET_B_REG_SW_RESET_B(x)         (((uint8_t)(((uint8_t)(x)) << CAU_SW_RESET_B_REG_SW_RESET_B_SHIFT)) & CAU_SW_RESET_B_REG_SW_RESET_B_MASK)
/*! @} */

/*! @name SYS_CTRL_REG -  */
/*! @{ */

#define CAU_SYS_CTRL_REG_SYS_CTRL_MASK           (0xFFU)
#define CAU_SYS_CTRL_REG_SYS_CTRL_SHIFT          (0U)
/*! SYS_CTRL - SYS_CTRL */
#define CAU_SYS_CTRL_REG_SYS_CTRL(x)             (((uint8_t)(((uint8_t)(x)) << CAU_SYS_CTRL_REG_SYS_CTRL_SHIFT)) & CAU_SYS_CTRL_REG_SYS_CTRL_MASK)
/*! @} */

/*! @name SYS_CTRL_PWR_OPT_SEL_REG -  */
/*! @{ */

#define CAU_SYS_CTRL_PWR_OPT_SEL_REG_SYS_CTRL_PWR_OPT_SEL_MASK (0xFFU)
#define CAU_SYS_CTRL_PWR_OPT_SEL_REG_SYS_CTRL_PWR_OPT_SEL_SHIFT (0U)
/*! SYS_CTRL_PWR_OPT_SEL - SYS_CTRL_PWR_OPT_SEL */
#define CAU_SYS_CTRL_PWR_OPT_SEL_REG_SYS_CTRL_PWR_OPT_SEL(x) (((uint8_t)(((uint8_t)(x)) << CAU_SYS_CTRL_PWR_OPT_SEL_REG_SYS_CTRL_PWR_OPT_SEL_SHIFT)) & CAU_SYS_CTRL_PWR_OPT_SEL_REG_SYS_CTRL_PWR_OPT_SEL_MASK)
/*! @} */

/*! @name BYPASS_SOC_PD_CTRL_RW_REG -  */
/*! @{ */

#define CAU_BYPASS_SOC_PD_CTRL_RW_REG_BYPASS_SOC_PD_CTRL_RW_MASK (0xFFU)
#define CAU_BYPASS_SOC_PD_CTRL_RW_REG_BYPASS_SOC_PD_CTRL_RW_SHIFT (0U)
/*! BYPASS_SOC_PD_CTRL_RW - BYPASS_SOC_PD_CTRL_RW */
#define CAU_BYPASS_SOC_PD_CTRL_RW_REG_BYPASS_SOC_PD_CTRL_RW(x) (((uint8_t)(((uint8_t)(x)) << CAU_BYPASS_SOC_PD_CTRL_RW_REG_BYPASS_SOC_PD_CTRL_RW_SHIFT)) & CAU_BYPASS_SOC_PD_CTRL_RW_REG_BYPASS_SOC_PD_CTRL_RW_MASK)
/*! @} */

/*! @name BYPASS_SOC_CTRL_ONE_RW_REG -  */
/*! @{ */

#define CAU_BYPASS_SOC_CTRL_ONE_RW_REG_BYPASS_SOC_CTRL_ONE_RW_MASK (0xFFU)
#define CAU_BYPASS_SOC_CTRL_ONE_RW_REG_BYPASS_SOC_CTRL_ONE_RW_SHIFT (0U)
/*! BYPASS_SOC_CTRL_ONE_RW - BYPASS_SOC_CTRL_ONE_RW */
#define CAU_BYPASS_SOC_CTRL_ONE_RW_REG_BYPASS_SOC_CTRL_ONE_RW(x) (((uint8_t)(((uint8_t)(x)) << CAU_BYPASS_SOC_CTRL_ONE_RW_REG_BYPASS_SOC_CTRL_ONE_RW_SHIFT)) & CAU_BYPASS_SOC_CTRL_ONE_RW_REG_BYPASS_SOC_CTRL_ONE_RW_MASK)
/*! @} */

/*! @name BYPASS_SOC_CTRL_TWO_RW_REG -  */
/*! @{ */

#define CAU_BYPASS_SOC_CTRL_TWO_RW_REG_BYPASS_SOC_CTRL_TWO_RW_MASK (0xFFU)
#define CAU_BYPASS_SOC_CTRL_TWO_RW_REG_BYPASS_SOC_CTRL_TWO_RW_SHIFT (0U)
/*! BYPASS_SOC_CTRL_TWO_RW - BYPASS_SOC_CTRL_TWO_RW */
#define CAU_BYPASS_SOC_CTRL_TWO_RW_REG_BYPASS_SOC_CTRL_TWO_RW(x) (((uint8_t)(((uint8_t)(x)) << CAU_BYPASS_SOC_CTRL_TWO_RW_REG_BYPASS_SOC_CTRL_TWO_RW_SHIFT)) & CAU_BYPASS_SOC_CTRL_TWO_RW_REG_BYPASS_SOC_CTRL_TWO_RW_MASK)
/*! @} */

/*! @name BYPASS_RFU_CTRL_ONE_RW_REG -  */
/*! @{ */

#define CAU_BYPASS_RFU_CTRL_ONE_RW_REG_BYPASS_RFU_CTRL_ONE_RW_MASK (0xFFU)
#define CAU_BYPASS_RFU_CTRL_ONE_RW_REG_BYPASS_RFU_CTRL_ONE_RW_SHIFT (0U)
/*! BYPASS_RFU_CTRL_ONE_RW - BYPASS_RFU_CTRL_ONE_RW */
#define CAU_BYPASS_RFU_CTRL_ONE_RW_REG_BYPASS_RFU_CTRL_ONE_RW(x) (((uint8_t)(((uint8_t)(x)) << CAU_BYPASS_RFU_CTRL_ONE_RW_REG_BYPASS_RFU_CTRL_ONE_RW_SHIFT)) & CAU_BYPASS_RFU_CTRL_ONE_RW_REG_BYPASS_RFU_CTRL_ONE_RW_MASK)
/*! @} */

/*! @name PD_CTRL_ONE_REG -  */
/*! @{ */

#define CAU_PD_CTRL_ONE_REG_PD_CTRL_ONE_MASK     (0xFFU)
#define CAU_PD_CTRL_ONE_REG_PD_CTRL_ONE_SHIFT    (0U)
/*! PD_CTRL_ONE - PD_CTRL_ONE */
#define CAU_PD_CTRL_ONE_REG_PD_CTRL_ONE(x)       (((uint8_t)(((uint8_t)(x)) << CAU_PD_CTRL_ONE_REG_PD_CTRL_ONE_SHIFT)) & CAU_PD_CTRL_ONE_REG_PD_CTRL_ONE_MASK)
/*! @} */

/*! @name PD_CTRL_TWO_REG -  */
/*! @{ */

#define CAU_PD_CTRL_TWO_REG_PD_CTRL_TWO_MASK     (0xFFU)
#define CAU_PD_CTRL_TWO_REG_PD_CTRL_TWO_SHIFT    (0U)
/*! PD_CTRL_TWO - PD_CTRL_TWO */
#define CAU_PD_CTRL_TWO_REG_PD_CTRL_TWO(x)       (((uint8_t)(((uint8_t)(x)) << CAU_PD_CTRL_TWO_REG_PD_CTRL_TWO_SHIFT)) & CAU_PD_CTRL_TWO_REG_PD_CTRL_TWO_MASK)
/*! @} */

/*! @name SLP_CTRL_ONE_REG -  */
/*! @{ */

#define CAU_SLP_CTRL_ONE_REG_SLP_CTRL_ONE_MASK   (0xFFU)
#define CAU_SLP_CTRL_ONE_REG_SLP_CTRL_ONE_SHIFT  (0U)
/*! SLP_CTRL_ONE - SLP_CTRL_ONE */
#define CAU_SLP_CTRL_ONE_REG_SLP_CTRL_ONE(x)     (((uint8_t)(((uint8_t)(x)) << CAU_SLP_CTRL_ONE_REG_SLP_CTRL_ONE_SHIFT)) & CAU_SLP_CTRL_ONE_REG_SLP_CTRL_ONE_MASK)
/*! @} */

/*! @name SLP_CTRL_TWO_REG -  */
/*! @{ */

#define CAU_SLP_CTRL_TWO_REG_SLP_CTRL_TWO_MASK   (0xFFU)
#define CAU_SLP_CTRL_TWO_REG_SLP_CTRL_TWO_SHIFT  (0U)
/*! SLP_CTRL_TWO - SLP_CTRL_TWO */
#define CAU_SLP_CTRL_TWO_REG_SLP_CTRL_TWO(x)     (((uint8_t)(((uint8_t)(x)) << CAU_SLP_CTRL_TWO_REG_SLP_CTRL_TWO_SHIFT)) & CAU_SLP_CTRL_TWO_REG_SLP_CTRL_TWO_MASK)
/*! @} */

/*! @name BG_CTRL_REG -  */
/*! @{ */

#define CAU_BG_CTRL_REG_BG_CTRL_MASK             (0xFFU)
#define CAU_BG_CTRL_REG_BG_CTRL_SHIFT            (0U)
/*! BG_CTRL - BG_CTRL */
#define CAU_BG_CTRL_REG_BG_CTRL(x)               (((uint8_t)(((uint8_t)(x)) << CAU_BG_CTRL_REG_BG_CTRL_SHIFT)) & CAU_BG_CTRL_REG_BG_CTRL_MASK)
/*! @} */

/*! @name CPREG_CTRL_ONE_REG -  */
/*! @{ */

#define CAU_CPREG_CTRL_ONE_REG_CPREG_CTRL_ONE_MASK (0xFFU)
#define CAU_CPREG_CTRL_ONE_REG_CPREG_CTRL_ONE_SHIFT (0U)
/*! CPREG_CTRL_ONE - CPREG_CTRL_ONE */
#define CAU_CPREG_CTRL_ONE_REG_CPREG_CTRL_ONE(x) (((uint8_t)(((uint8_t)(x)) << CAU_CPREG_CTRL_ONE_REG_CPREG_CTRL_ONE_SHIFT)) & CAU_CPREG_CTRL_ONE_REG_CPREG_CTRL_ONE_MASK)
/*! @} */

/*! @name CPREG_CTRL_TWO_REG -  */
/*! @{ */

#define CAU_CPREG_CTRL_TWO_REG_CPREG_CTRL_TWO_MASK (0xFFU)
#define CAU_CPREG_CTRL_TWO_REG_CPREG_CTRL_TWO_SHIFT (0U)
/*! CPREG_CTRL_TWO - CPREG_CTRL_TWO */
#define CAU_CPREG_CTRL_TWO_REG_CPREG_CTRL_TWO(x) (((uint8_t)(((uint8_t)(x)) << CAU_CPREG_CTRL_TWO_REG_CPREG_CTRL_TWO_SHIFT)) & CAU_CPREG_CTRL_TWO_REG_CPREG_CTRL_TWO_MASK)
/*! @} */

/*! @name CPREG_CTRL_THREE_REG -  */
/*! @{ */

#define CAU_CPREG_CTRL_THREE_REG_CPREG_CTRL_THREE_MASK (0xFFU)
#define CAU_CPREG_CTRL_THREE_REG_CPREG_CTRL_THREE_SHIFT (0U)
/*! CPREG_CTRL_THREE - CPREG_CTRL_THREE */
#define CAU_CPREG_CTRL_THREE_REG_CPREG_CTRL_THREE(x) (((uint8_t)(((uint8_t)(x)) << CAU_CPREG_CTRL_THREE_REG_CPREG_CTRL_THREE_SHIFT)) & CAU_CPREG_CTRL_THREE_REG_CPREG_CTRL_THREE_MASK)
/*! @} */

/*! @name PSEN_CTRL_ONE_REG -  */
/*! @{ */

#define CAU_PSEN_CTRL_ONE_REG_PSEN_CTRL_ONE_MASK (0xFFU)
#define CAU_PSEN_CTRL_ONE_REG_PSEN_CTRL_ONE_SHIFT (0U)
/*! PSEN_CTRL_ONE - PSEN_CTRL_ONE */
#define CAU_PSEN_CTRL_ONE_REG_PSEN_CTRL_ONE(x)   (((uint8_t)(((uint8_t)(x)) << CAU_PSEN_CTRL_ONE_REG_PSEN_CTRL_ONE_SHIFT)) & CAU_PSEN_CTRL_ONE_REG_PSEN_CTRL_ONE_MASK)
/*! @} */

/*! @name PSEN_CTRL_TWO_REG -  */
/*! @{ */

#define CAU_PSEN_CTRL_TWO_REG_PSEN_CTRL_TWO_MASK (0xFFU)
#define CAU_PSEN_CTRL_TWO_REG_PSEN_CTRL_TWO_SHIFT (0U)
/*! PSEN_CTRL_TWO - PSEN_CTRL_TWO */
#define CAU_PSEN_CTRL_TWO_REG_PSEN_CTRL_TWO(x)   (((uint8_t)(((uint8_t)(x)) << CAU_PSEN_CTRL_TWO_REG_PSEN_CTRL_TWO_SHIFT)) & CAU_PSEN_CTRL_TWO_REG_PSEN_CTRL_TWO_MASK)
/*! @} */

/*! @name TSEN_CTRL_ONE_REG -  */
/*! @{ */

#define CAU_TSEN_CTRL_ONE_REG_TSEN_CTRL_ONE_MASK (0xFFU)
#define CAU_TSEN_CTRL_ONE_REG_TSEN_CTRL_ONE_SHIFT (0U)
/*! TSEN_CTRL_ONE - TSEN_CTRL_ONE */
#define CAU_TSEN_CTRL_ONE_REG_TSEN_CTRL_ONE(x)   (((uint8_t)(((uint8_t)(x)) << CAU_TSEN_CTRL_ONE_REG_TSEN_CTRL_ONE_SHIFT)) & CAU_TSEN_CTRL_ONE_REG_TSEN_CTRL_ONE_MASK)
/*! @} */

/*! @name TSEN_CTRL_THREE_REG -  */
/*! @{ */

#define CAU_TSEN_CTRL_THREE_REG_TSEN_CTRL_TWO_MASK (0xFFU)
#define CAU_TSEN_CTRL_THREE_REG_TSEN_CTRL_TWO_SHIFT (0U)
/*! TSEN_CTRL_TWO - TSEN_CTRL_TWO */
#define CAU_TSEN_CTRL_THREE_REG_TSEN_CTRL_TWO(x) (((uint8_t)(((uint8_t)(x)) << CAU_TSEN_CTRL_THREE_REG_TSEN_CTRL_TWO_SHIFT)) & CAU_TSEN_CTRL_THREE_REG_TSEN_CTRL_TWO_MASK)
/*! @} */

/*! @name ADC_CTRL_ONE_REG -  */
/*! @{ */

#define CAU_ADC_CTRL_ONE_REG_ADC_CTRL_MASK       (0xFFU)
#define CAU_ADC_CTRL_ONE_REG_ADC_CTRL_SHIFT      (0U)
/*! ADC_CTRL - ADC_CTRL */
#define CAU_ADC_CTRL_ONE_REG_ADC_CTRL(x)         (((uint8_t)(((uint8_t)(x)) << CAU_ADC_CTRL_ONE_REG_ADC_CTRL_SHIFT)) & CAU_ADC_CTRL_ONE_REG_ADC_CTRL_MASK)
/*! @} */

/*! @name RCAL_CTRL_ONE_REG -  */
/*! @{ */

#define CAU_RCAL_CTRL_ONE_REG_RCAL_CTRL_ONE_MASK (0xFFU)
#define CAU_RCAL_CTRL_ONE_REG_RCAL_CTRL_ONE_SHIFT (0U)
/*! RCAL_CTRL_ONE - RCAL_CTRL_ONE */
#define CAU_RCAL_CTRL_ONE_REG_RCAL_CTRL_ONE(x)   (((uint8_t)(((uint8_t)(x)) << CAU_RCAL_CTRL_ONE_REG_RCAL_CTRL_ONE_SHIFT)) & CAU_RCAL_CTRL_ONE_REG_RCAL_CTRL_ONE_MASK)
/*! @} */

/*! @name RCAL_CTRL_TWO_REG -  */
/*! @{ */

#define CAU_RCAL_CTRL_TWO_REG_RCAL_CTRL_TWO_MASK (0xFFU)
#define CAU_RCAL_CTRL_TWO_REG_RCAL_CTRL_TWO_SHIFT (0U)
/*! RCAL_CTRL_TWO - RCAL_CTRL_TWO */
#define CAU_RCAL_CTRL_TWO_REG_RCAL_CTRL_TWO(x)   (((uint8_t)(((uint8_t)(x)) << CAU_RCAL_CTRL_TWO_REG_RCAL_CTRL_TWO_SHIFT)) & CAU_RCAL_CTRL_TWO_REG_RCAL_CTRL_TWO_MASK)
/*! @} */

/*! @name XTAL_CTRL_ONE_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_ONE_REG_XTAL_CTRL_ONE_MASK (0xFFU)
#define CAU_XTAL_CTRL_ONE_REG_XTAL_CTRL_ONE_SHIFT (0U)
/*! XTAL_CTRL_ONE - XTAL_CTRL_ONE */
#define CAU_XTAL_CTRL_ONE_REG_XTAL_CTRL_ONE(x)   (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_ONE_REG_XTAL_CTRL_ONE_SHIFT)) & CAU_XTAL_CTRL_ONE_REG_XTAL_CTRL_ONE_MASK)
/*! @} */

/*! @name XTAL_CTRL_TWO_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_TWO_REG_XTAL_CTRL_TWO_MASK (0xFFU)
#define CAU_XTAL_CTRL_TWO_REG_XTAL_CTRL_TWO_SHIFT (0U)
/*! XTAL_CTRL_TWO - XTAL_CTRL_TWO */
#define CAU_XTAL_CTRL_TWO_REG_XTAL_CTRL_TWO(x)   (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_TWO_REG_XTAL_CTRL_TWO_SHIFT)) & CAU_XTAL_CTRL_TWO_REG_XTAL_CTRL_TWO_MASK)
/*! @} */

/*! @name XTAL_CTRL_THREE_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_THREE_REG_XTAL_CTRL_THREE_MASK (0xFFU)
#define CAU_XTAL_CTRL_THREE_REG_XTAL_CTRL_THREE_SHIFT (0U)
/*! XTAL_CTRL_THREE - XTAL_CTRL_THREE */
#define CAU_XTAL_CTRL_THREE_REG_XTAL_CTRL_THREE(x) (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_THREE_REG_XTAL_CTRL_THREE_SHIFT)) & CAU_XTAL_CTRL_THREE_REG_XTAL_CTRL_THREE_MASK)
/*! @} */

/*! @name XTAL_CTRL_FOUR_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_FOUR_REG_XTAL_CTRL_FOUR_MASK (0xFFU)
#define CAU_XTAL_CTRL_FOUR_REG_XTAL_CTRL_FOUR_SHIFT (0U)
/*! XTAL_CTRL_FOUR - XTAL_CTRL_FOUR */
#define CAU_XTAL_CTRL_FOUR_REG_XTAL_CTRL_FOUR(x) (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_FOUR_REG_XTAL_CTRL_FOUR_SHIFT)) & CAU_XTAL_CTRL_FOUR_REG_XTAL_CTRL_FOUR_MASK)
/*! @} */

/*! @name XTAL_CTRL_FIVE_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_FIVE_REG_XTAL_CTRL_FIVE_MASK (0xFFU)
#define CAU_XTAL_CTRL_FIVE_REG_XTAL_CTRL_FIVE_SHIFT (0U)
/*! XTAL_CTRL_FIVE - XTAL_CTRL_FIVE */
#define CAU_XTAL_CTRL_FIVE_REG_XTAL_CTRL_FIVE(x) (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_FIVE_REG_XTAL_CTRL_FIVE_SHIFT)) & CAU_XTAL_CTRL_FIVE_REG_XTAL_CTRL_FIVE_MASK)
/*! @} */

/*! @name XTAL_CTRL_SIX_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_SIX_REG_XTAL_CTRL_SIX_MASK (0xFFU)
#define CAU_XTAL_CTRL_SIX_REG_XTAL_CTRL_SIX_SHIFT (0U)
/*! XTAL_CTRL_SIX - XTAL_CTRL_SIX */
#define CAU_XTAL_CTRL_SIX_REG_XTAL_CTRL_SIX(x)   (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_SIX_REG_XTAL_CTRL_SIX_SHIFT)) & CAU_XTAL_CTRL_SIX_REG_XTAL_CTRL_SIX_MASK)
/*! @} */

/*! @name XTAL_CTRL_SEVEN_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_SEVEN_REG_XTAL_CTRL_SEVEN_MASK (0xFFU)
#define CAU_XTAL_CTRL_SEVEN_REG_XTAL_CTRL_SEVEN_SHIFT (0U)
/*! XTAL_CTRL_SEVEN - XTAL_CTRL_SEVEN */
#define CAU_XTAL_CTRL_SEVEN_REG_XTAL_CTRL_SEVEN(x) (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_SEVEN_REG_XTAL_CTRL_SEVEN_SHIFT)) & CAU_XTAL_CTRL_SEVEN_REG_XTAL_CTRL_SEVEN_MASK)
/*! @} */

/*! @name XTAL_CTRL_EIGHT_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_EIGHT_REG_XTAL_CTRL_EIGHT_MASK (0xFFU)
#define CAU_XTAL_CTRL_EIGHT_REG_XTAL_CTRL_EIGHT_SHIFT (0U)
/*! XTAL_CTRL_EIGHT - XTAL_CTRL_EIGHT */
#define CAU_XTAL_CTRL_EIGHT_REG_XTAL_CTRL_EIGHT(x) (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_EIGHT_REG_XTAL_CTRL_EIGHT_SHIFT)) & CAU_XTAL_CTRL_EIGHT_REG_XTAL_CTRL_EIGHT_MASK)
/*! @} */

/*! @name XTAL_CTRL_NINE_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_NINE_REG_XTAL_CTRL_NINE_MASK (0xFFU)
#define CAU_XTAL_CTRL_NINE_REG_XTAL_CTRL_NINE_SHIFT (0U)
/*! XTAL_CTRL_NINE - XTAL_CTRL_NINE */
#define CAU_XTAL_CTRL_NINE_REG_XTAL_CTRL_NINE(x) (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_NINE_REG_XTAL_CTRL_NINE_SHIFT)) & CAU_XTAL_CTRL_NINE_REG_XTAL_CTRL_NINE_MASK)
/*! @} */

/*! @name XTAL_CTRL_TEN_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_TEN_REG_XTAL_CTRL_TEN_MASK (0xFFU)
#define CAU_XTAL_CTRL_TEN_REG_XTAL_CTRL_TEN_SHIFT (0U)
/*! XTAL_CTRL_TEN - XTAL_CTRL_TEN */
#define CAU_XTAL_CTRL_TEN_REG_XTAL_CTRL_TEN(x)   (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_TEN_REG_XTAL_CTRL_TEN_SHIFT)) & CAU_XTAL_CTRL_TEN_REG_XTAL_CTRL_TEN_MASK)
/*! @} */

/*! @name XTAL_CTRL_ELEVEN_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_ELEVEN_REG_XTAL_CTRL_ELEVEN_MASK (0xFFU)
#define CAU_XTAL_CTRL_ELEVEN_REG_XTAL_CTRL_ELEVEN_SHIFT (0U)
/*! XTAL_CTRL_ELEVEN - XTAL_CTRL_ELEVEN */
#define CAU_XTAL_CTRL_ELEVEN_REG_XTAL_CTRL_ELEVEN(x) (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_ELEVEN_REG_XTAL_CTRL_ELEVEN_SHIFT)) & CAU_XTAL_CTRL_ELEVEN_REG_XTAL_CTRL_ELEVEN_MASK)
/*! @} */

/*! @name XTAL_CTRL_TWELVE_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_TWELVE_REG_XTAL_CTRL_TWELVE_MASK (0xFFU)
#define CAU_XTAL_CTRL_TWELVE_REG_XTAL_CTRL_TWELVE_SHIFT (0U)
/*! XTAL_CTRL_TWELVE - XTAL_CTRL_TWELVE */
#define CAU_XTAL_CTRL_TWELVE_REG_XTAL_CTRL_TWELVE(x) (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_TWELVE_REG_XTAL_CTRL_TWELVE_SHIFT)) & CAU_XTAL_CTRL_TWELVE_REG_XTAL_CTRL_TWELVE_MASK)
/*! @} */

/*! @name XTAL_CTRL_THIRTEEN_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_THIRTEEN_REG_XTAL_CTRL_THIRTEEN_MASK (0xFFU)
#define CAU_XTAL_CTRL_THIRTEEN_REG_XTAL_CTRL_THIRTEEN_SHIFT (0U)
/*! XTAL_CTRL_THIRTEEN - XTAL_CTRL_THIRTEEN */
#define CAU_XTAL_CTRL_THIRTEEN_REG_XTAL_CTRL_THIRTEEN(x) (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_THIRTEEN_REG_XTAL_CTRL_THIRTEEN_SHIFT)) & CAU_XTAL_CTRL_THIRTEEN_REG_XTAL_CTRL_THIRTEEN_MASK)
/*! @} */

/*! @name XTAL_CTRL_FOURTEEN_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_FOURTEEN_REG_XTAL_CTRL_FOURTEEN_MASK (0xFFU)
#define CAU_XTAL_CTRL_FOURTEEN_REG_XTAL_CTRL_FOURTEEN_SHIFT (0U)
/*! XTAL_CTRL_FOURTEEN - XTAL_CTRL_FOURTEEN */
#define CAU_XTAL_CTRL_FOURTEEN_REG_XTAL_CTRL_FOURTEEN(x) (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_FOURTEEN_REG_XTAL_CTRL_FOURTEEN_SHIFT)) & CAU_XTAL_CTRL_FOURTEEN_REG_XTAL_CTRL_FOURTEEN_MASK)
/*! @} */

/*! @name XTAL_CTRL_FIFTEEN_REG -  */
/*! @{ */

#define CAU_XTAL_CTRL_FIFTEEN_REG_XTAL_CTRL_FIFTEEN_MASK (0xFFU)
#define CAU_XTAL_CTRL_FIFTEEN_REG_XTAL_CTRL_FIFTEEN_SHIFT (0U)
/*! XTAL_CTRL_FIFTEEN - XTAL_CTRL_FIFTEEN */
#define CAU_XTAL_CTRL_FIFTEEN_REG_XTAL_CTRL_FIFTEEN(x) (((uint8_t)(((uint8_t)(x)) << CAU_XTAL_CTRL_FIFTEEN_REG_XTAL_CTRL_FIFTEEN_SHIFT)) & CAU_XTAL_CTRL_FIFTEEN_REG_XTAL_CTRL_FIFTEEN_MASK)
/*! @} */

/*! @name T1_CTRL_RSVD_HI_REG -  */
/*! @{ */

#define CAU_T1_CTRL_RSVD_HI_REG_XTAL_CTRL_RSVD_HI_MASK (0xFFU)
#define CAU_T1_CTRL_RSVD_HI_REG_XTAL_CTRL_RSVD_HI_SHIFT (0U)
/*! XTAL_CTRL_RSVD_HI - XTAL_CTRL_RSVD_HI */
#define CAU_T1_CTRL_RSVD_HI_REG_XTAL_CTRL_RSVD_HI(x) (((uint8_t)(((uint8_t)(x)) << CAU_T1_CTRL_RSVD_HI_REG_XTAL_CTRL_RSVD_HI_SHIFT)) & CAU_T1_CTRL_RSVD_HI_REG_XTAL_CTRL_RSVD_HI_MASK)
/*! @} */

/*! @name T1_CTRL_RSVD_LO_REG -  */
/*! @{ */

#define CAU_T1_CTRL_RSVD_LO_REG_XTAL_CTRL_RSVD_LO_MASK (0xFFU)
#define CAU_T1_CTRL_RSVD_LO_REG_XTAL_CTRL_RSVD_LO_SHIFT (0U)
/*! XTAL_CTRL_RSVD_LO - XTAL_CTRL_RSVD_LO */
#define CAU_T1_CTRL_RSVD_LO_REG_XTAL_CTRL_RSVD_LO(x) (((uint8_t)(((uint8_t)(x)) << CAU_T1_CTRL_RSVD_LO_REG_XTAL_CTRL_RSVD_LO_SHIFT)) & CAU_T1_CTRL_RSVD_LO_REG_XTAL_CTRL_RSVD_LO_MASK)
/*! @} */

/*! @name GPIO_CTRL_REG -  */
/*! @{ */

#define CAU_GPIO_CTRL_REG_GPIO_CTRL_MASK         (0xFFU)
#define CAU_GPIO_CTRL_REG_GPIO_CTRL_SHIFT        (0U)
/*! GPIO_CTRL - GPIO_CTRL */
#define CAU_GPIO_CTRL_REG_GPIO_CTRL(x)           (((uint8_t)(((uint8_t)(x)) << CAU_GPIO_CTRL_REG_GPIO_CTRL_SHIFT)) & CAU_GPIO_CTRL_REG_GPIO_CTRL_MASK)
/*! @} */

/*! @name ATEST_CTRL_ONE_REG -  */
/*! @{ */

#define CAU_ATEST_CTRL_ONE_REG_ATEST_CTRL_ONE_MASK (0xFFU)
#define CAU_ATEST_CTRL_ONE_REG_ATEST_CTRL_ONE_SHIFT (0U)
/*! ATEST_CTRL_ONE - ATEST_CTRL_ONE */
#define CAU_ATEST_CTRL_ONE_REG_ATEST_CTRL_ONE(x) (((uint8_t)(((uint8_t)(x)) << CAU_ATEST_CTRL_ONE_REG_ATEST_CTRL_ONE_SHIFT)) & CAU_ATEST_CTRL_ONE_REG_ATEST_CTRL_ONE_MASK)
/*! @} */

/*! @name ATEST_CTRL_TWO_REG -  */
/*! @{ */

#define CAU_ATEST_CTRL_TWO_REG_ATEST_CTRL_TWO_MASK (0xFFU)
#define CAU_ATEST_CTRL_TWO_REG_ATEST_CTRL_TWO_SHIFT (0U)
/*! ATEST_CTRL_TWO - ATEST_CTRL_TWO */
#define CAU_ATEST_CTRL_TWO_REG_ATEST_CTRL_TWO(x) (((uint8_t)(((uint8_t)(x)) << CAU_ATEST_CTRL_TWO_REG_ATEST_CTRL_TWO_SHIFT)) & CAU_ATEST_CTRL_TWO_REG_ATEST_CTRL_TWO_MASK)
/*! @} */

/*! @name ATEST_CTRL_THREE_REG -  */
/*! @{ */

#define CAU_ATEST_CTRL_THREE_REG_ATEST_CTRL_THREE_MASK (0xFFU)
#define CAU_ATEST_CTRL_THREE_REG_ATEST_CTRL_THREE_SHIFT (0U)
/*! ATEST_CTRL_THREE - ATEST_CTRL_THREE */
#define CAU_ATEST_CTRL_THREE_REG_ATEST_CTRL_THREE(x) (((uint8_t)(((uint8_t)(x)) << CAU_ATEST_CTRL_THREE_REG_ATEST_CTRL_THREE_SHIFT)) & CAU_ATEST_CTRL_THREE_REG_ATEST_CTRL_THREE_MASK)
/*! @} */

/*! @name ATEST_CTRL_FOUR_REG -  */
/*! @{ */

#define CAU_ATEST_CTRL_FOUR_REG_ATEST_CTRL_FOUR_MASK (0xFFU)
#define CAU_ATEST_CTRL_FOUR_REG_ATEST_CTRL_FOUR_SHIFT (0U)
/*! ATEST_CTRL_FOUR - ATEST_CTRL_FOUR */
#define CAU_ATEST_CTRL_FOUR_REG_ATEST_CTRL_FOUR(x) (((uint8_t)(((uint8_t)(x)) << CAU_ATEST_CTRL_FOUR_REG_ATEST_CTRL_FOUR_SHIFT)) & CAU_ATEST_CTRL_FOUR_REG_ATEST_CTRL_FOUR_MASK)
/*! @} */

/*! @name ATEST_CTRL_FIVE_REG -  */
/*! @{ */

#define CAU_ATEST_CTRL_FIVE_REG_ATEST_CTRL_FIVE_MASK (0xFFU)
#define CAU_ATEST_CTRL_FIVE_REG_ATEST_CTRL_FIVE_SHIFT (0U)
/*! ATEST_CTRL_FIVE - ATEST_CTRL_FIVE */
#define CAU_ATEST_CTRL_FIVE_REG_ATEST_CTRL_FIVE(x) (((uint8_t)(((uint8_t)(x)) << CAU_ATEST_CTRL_FIVE_REG_ATEST_CTRL_FIVE_SHIFT)) & CAU_ATEST_CTRL_FIVE_REG_ATEST_CTRL_FIVE_MASK)
/*! @} */

/*! @name ATEST_CTRL_SIX_REG -  */
/*! @{ */

#define CAU_ATEST_CTRL_SIX_REG_ATEST_CTRL_SIX_MASK (0xFFU)
#define CAU_ATEST_CTRL_SIX_REG_ATEST_CTRL_SIX_SHIFT (0U)
/*! ATEST_CTRL_SIX - ATEST_CTRL_SIX */
#define CAU_ATEST_CTRL_SIX_REG_ATEST_CTRL_SIX(x) (((uint8_t)(((uint8_t)(x)) << CAU_ATEST_CTRL_SIX_REG_ATEST_CTRL_SIX_SHIFT)) & CAU_ATEST_CTRL_SIX_REG_ATEST_CTRL_SIX_MASK)
/*! @} */

/*! @name ATEST_CTRL_SEVEN_REG -  */
/*! @{ */

#define CAU_ATEST_CTRL_SEVEN_REG_ATEST_CTRL_SEVEN_MASK (0xFFU)
#define CAU_ATEST_CTRL_SEVEN_REG_ATEST_CTRL_SEVEN_SHIFT (0U)
/*! ATEST_CTRL_SEVEN - ATEST_CTRL_SEVEN */
#define CAU_ATEST_CTRL_SEVEN_REG_ATEST_CTRL_SEVEN(x) (((uint8_t)(((uint8_t)(x)) << CAU_ATEST_CTRL_SEVEN_REG_ATEST_CTRL_SEVEN_SHIFT)) & CAU_ATEST_CTRL_SEVEN_REG_ATEST_CTRL_SEVEN_MASK)
/*! @} */

/*! @name RESERVED_LO_ONE_REG -  */
/*! @{ */

#define CAU_RESERVED_LO_ONE_REG_RESERVED_LO_ONE_MASK (0xFFU)
#define CAU_RESERVED_LO_ONE_REG_RESERVED_LO_ONE_SHIFT (0U)
/*! RESERVED_LO_ONE - RESERVED_LO_ONE */
#define CAU_RESERVED_LO_ONE_REG_RESERVED_LO_ONE(x) (((uint8_t)(((uint8_t)(x)) << CAU_RESERVED_LO_ONE_REG_RESERVED_LO_ONE_SHIFT)) & CAU_RESERVED_LO_ONE_REG_RESERVED_LO_ONE_MASK)
/*! @} */

/*! @name RESERVED_LO_TWO_REG -  */
/*! @{ */

#define CAU_RESERVED_LO_TWO_REG_RESERVED_LO_TWO_MASK (0xFFU)
#define CAU_RESERVED_LO_TWO_REG_RESERVED_LO_TWO_SHIFT (0U)
/*! RESERVED_LO_TWO - RESERVED_LO_TWO */
#define CAU_RESERVED_LO_TWO_REG_RESERVED_LO_TWO(x) (((uint8_t)(((uint8_t)(x)) << CAU_RESERVED_LO_TWO_REG_RESERVED_LO_TWO_SHIFT)) & CAU_RESERVED_LO_TWO_REG_RESERVED_LO_TWO_MASK)
/*! @} */

/*! @name RESERVED_HI_ONE_REG -  */
/*! @{ */

#define CAU_RESERVED_HI_ONE_REG_RESERVED_HI_ONE_MASK (0xFFU)
#define CAU_RESERVED_HI_ONE_REG_RESERVED_HI_ONE_SHIFT (0U)
/*! RESERVED_HI_ONE - RESERVED_HI_ONE */
#define CAU_RESERVED_HI_ONE_REG_RESERVED_HI_ONE(x) (((uint8_t)(((uint8_t)(x)) << CAU_RESERVED_HI_ONE_REG_RESERVED_HI_ONE_SHIFT)) & CAU_RESERVED_HI_ONE_REG_RESERVED_HI_ONE_MASK)
/*! @} */

/*! @name RESERVED_HI_TWO_REG -  */
/*! @{ */

#define CAU_RESERVED_HI_TWO_REG_RESERVED_HI_TWO_MASK (0xFFU)
#define CAU_RESERVED_HI_TWO_REG_RESERVED_HI_TWO_SHIFT (0U)
/*! RESERVED_HI_TWO - RESERVED_HI_TWO */
#define CAU_RESERVED_HI_TWO_REG_RESERVED_HI_TWO(x) (((uint8_t)(((uint8_t)(x)) << CAU_RESERVED_HI_TWO_REG_RESERVED_HI_TWO_SHIFT)) & CAU_RESERVED_HI_TWO_REG_RESERVED_HI_TWO_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CAU_Register_Masks */


/* CAU - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CAU base address */
  #define CAU_BASE                                 (0x55002000u)
  /** Peripheral CAU base address */
  #define CAU_BASE_NS                              (0x45002000u)
  /** Peripheral CAU base pointer */
  #define CAU                                      ((CAU_Type *)CAU_BASE)
  /** Peripheral CAU base pointer */
  #define CAU_NS                                   ((CAU_Type *)CAU_BASE_NS)
  /** Array initializer of CAU peripheral base addresses */
  #define CAU_BASE_ADDRS                           { CAU_BASE }
  /** Array initializer of CAU peripheral base pointers */
  #define CAU_BASE_PTRS                            { CAU }
  /** Array initializer of CAU peripheral base addresses */
  #define CAU_BASE_ADDRS_NS                        { CAU_BASE_NS }
  /** Array initializer of CAU peripheral base pointers */
  #define CAU_BASE_PTRS_NS                         { CAU_NS }
#else
  /** Peripheral CAU base address */
  #define CAU_BASE                                 (0x45002000u)
  /** Peripheral CAU base pointer */
  #define CAU                                      ((CAU_Type *)CAU_BASE)
  /** Array initializer of CAU peripheral base addresses */
  #define CAU_BASE_ADDRS                           { CAU_BASE }
  /** Array initializer of CAU peripheral base pointers */
  #define CAU_BASE_PTRS                            { CAU }
#endif

/*!
 * @}
 */ /* end of group CAU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CDOG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CDOG_Peripheral_Access_Layer CDOG Peripheral Access Layer
 * @{
 */

/** CDOG - Register Layout Typedef */
typedef struct {
  __IO uint32_t CONTROL;                           /**< Control, offset: 0x0 */
  __IO uint32_t RELOAD;                            /**< Instruction Timer reload, offset: 0x4 */
  __IO uint32_t INSTRUCTION_TIMER;                 /**< Instruction Timer, offset: 0x8 */
  __IO uint32_t SECURE_COUNTER;                    /**< Secure Counter, offset: 0xC */
  __I  uint32_t STATUS;                            /**< Status 1, offset: 0x10 */
  __I  uint32_t STATUS2;                           /**< Status 2, offset: 0x14 */
  __IO uint32_t FLAGS;                             /**< Flags, offset: 0x18 */
  __IO uint32_t PERSISTENT;                        /**< Persistent Data Storage, offset: 0x1C */
  __O  uint32_t START;                             /**< START Command, offset: 0x20 */
  __O  uint32_t STOP;                              /**< STOP Command, offset: 0x24 */
  __O  uint32_t RESTART;                           /**< RESTART Command, offset: 0x28 */
  __O  uint32_t ADD;                               /**< ADD Command, offset: 0x2C */
  __O  uint32_t ADD1;                              /**< ADD1 Command, offset: 0x30 */
  __O  uint32_t ADD16;                             /**< ADD16 Command, offset: 0x34 */
  __O  uint32_t ADD256;                            /**< ADD256 Command, offset: 0x38 */
  __O  uint32_t SUB;                               /**< SUB Command, offset: 0x3C */
  __O  uint32_t SUB1;                              /**< SUB1 Command, offset: 0x40 */
  __O  uint32_t SUB16;                             /**< SUB16 Command, offset: 0x44 */
  __O  uint32_t SUB256;                            /**< SUB256 Command, offset: 0x48 */
} CDOG_Type;

/* ----------------------------------------------------------------------------
   -- CDOG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CDOG_Register_Masks CDOG Register Masks
 * @{
 */

/*! @name CONTROL - Control */
/*! @{ */

#define CDOG_CONTROL_LOCK_CTRL_MASK              (0x3U)
#define CDOG_CONTROL_LOCK_CTRL_SHIFT             (0U)
/*! LOCK_CTRL - Lock control
 *  0b01..Locked
 *  0b10..Unlocked
 */
#define CDOG_CONTROL_LOCK_CTRL(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_LOCK_CTRL_SHIFT)) & CDOG_CONTROL_LOCK_CTRL_MASK)

#define CDOG_CONTROL_TIMEOUT_CTRL_MASK           (0x1CU)
#define CDOG_CONTROL_TIMEOUT_CTRL_SHIFT          (2U)
/*! TIMEOUT_CTRL - TIMEOUT fault control
 *  0b100..Disable both reset and interrupt
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 */
#define CDOG_CONTROL_TIMEOUT_CTRL(x)             (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_TIMEOUT_CTRL_SHIFT)) & CDOG_CONTROL_TIMEOUT_CTRL_MASK)

#define CDOG_CONTROL_MISCOMPARE_CTRL_MASK        (0xE0U)
#define CDOG_CONTROL_MISCOMPARE_CTRL_SHIFT       (5U)
/*! MISCOMPARE_CTRL - MISCOMPARE fault control
 *  0b100..Disable both reset and interrupt
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 */
#define CDOG_CONTROL_MISCOMPARE_CTRL(x)          (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_MISCOMPARE_CTRL_SHIFT)) & CDOG_CONTROL_MISCOMPARE_CTRL_MASK)

#define CDOG_CONTROL_SEQUENCE_CTRL_MASK          (0x700U)
#define CDOG_CONTROL_SEQUENCE_CTRL_SHIFT         (8U)
/*! SEQUENCE_CTRL - SEQUENCE fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_SEQUENCE_CTRL(x)            (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_SEQUENCE_CTRL_SHIFT)) & CDOG_CONTROL_SEQUENCE_CTRL_MASK)

#define CDOG_CONTROL_CONTROL_CTRL_MASK           (0x3800U)
#define CDOG_CONTROL_CONTROL_CTRL_SHIFT          (11U)
/*! CONTROL_CTRL - CONTROL fault control
 *  0b001..Enable reset
 *  0b100..Disable reset
 */
#define CDOG_CONTROL_CONTROL_CTRL(x)             (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_CONTROL_CTRL_SHIFT)) & CDOG_CONTROL_CONTROL_CTRL_MASK)

#define CDOG_CONTROL_STATE_CTRL_MASK             (0x1C000U)
#define CDOG_CONTROL_STATE_CTRL_SHIFT            (14U)
/*! STATE_CTRL - STATE fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_STATE_CTRL(x)               (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_STATE_CTRL_SHIFT)) & CDOG_CONTROL_STATE_CTRL_MASK)

#define CDOG_CONTROL_ADDRESS_CTRL_MASK           (0xE0000U)
#define CDOG_CONTROL_ADDRESS_CTRL_SHIFT          (17U)
/*! ADDRESS_CTRL - ADDRESS fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_ADDRESS_CTRL(x)             (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_ADDRESS_CTRL_SHIFT)) & CDOG_CONTROL_ADDRESS_CTRL_MASK)

#define CDOG_CONTROL_IRQ_PAUSE_MASK              (0x30000000U)
#define CDOG_CONTROL_IRQ_PAUSE_SHIFT             (28U)
/*! IRQ_PAUSE - IRQ pause control
 *  0b01..Keep the timer running
 *  0b10..Stop the timer
 */
#define CDOG_CONTROL_IRQ_PAUSE(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_IRQ_PAUSE_SHIFT)) & CDOG_CONTROL_IRQ_PAUSE_MASK)

#define CDOG_CONTROL_DEBUG_HALT_CTRL_MASK        (0xC0000000U)
#define CDOG_CONTROL_DEBUG_HALT_CTRL_SHIFT       (30U)
/*! DEBUG_HALT_CTRL - DEBUG_HALT control
 *  0b01..Keep the timer running
 *  0b10..Stop the timer
 */
#define CDOG_CONTROL_DEBUG_HALT_CTRL(x)          (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_DEBUG_HALT_CTRL_SHIFT)) & CDOG_CONTROL_DEBUG_HALT_CTRL_MASK)
/*! @} */

/*! @name RELOAD - Instruction Timer reload */
/*! @{ */

#define CDOG_RELOAD_RLOAD_MASK                   (0xFFFFFFFFU)
#define CDOG_RELOAD_RLOAD_SHIFT                  (0U)
/*! RLOAD - Instruction Timer reload value */
#define CDOG_RELOAD_RLOAD(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_RELOAD_RLOAD_SHIFT)) & CDOG_RELOAD_RLOAD_MASK)
/*! @} */

/*! @name INSTRUCTION_TIMER - Instruction Timer */
/*! @{ */

#define CDOG_INSTRUCTION_TIMER_INSTIM_MASK       (0xFFFFFFFFU)
#define CDOG_INSTRUCTION_TIMER_INSTIM_SHIFT      (0U)
/*! INSTIM - Current value of the Instruction Timer */
#define CDOG_INSTRUCTION_TIMER_INSTIM(x)         (((uint32_t)(((uint32_t)(x)) << CDOG_INSTRUCTION_TIMER_INSTIM_SHIFT)) & CDOG_INSTRUCTION_TIMER_INSTIM_MASK)
/*! @} */

/*! @name SECURE_COUNTER - Secure Counter */
/*! @{ */

#define CDOG_SECURE_COUNTER_SECCNT_MASK          (0xFFFFFFFFU)
#define CDOG_SECURE_COUNTER_SECCNT_SHIFT         (0U)
/*! SECCNT - Secure Counter */
#define CDOG_SECURE_COUNTER_SECCNT(x)            (((uint32_t)(((uint32_t)(x)) << CDOG_SECURE_COUNTER_SECCNT_SHIFT)) & CDOG_SECURE_COUNTER_SECCNT_MASK)
/*! @} */

/*! @name STATUS - Status 1 */
/*! @{ */

#define CDOG_STATUS_NUMTOF_MASK                  (0xFFU)
#define CDOG_STATUS_NUMTOF_SHIFT                 (0U)
/*! NUMTOF - Number of TIMEOUT faults since the last POR */
#define CDOG_STATUS_NUMTOF(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMTOF_SHIFT)) & CDOG_STATUS_NUMTOF_MASK)

#define CDOG_STATUS_NUMMISCOMPF_MASK             (0xFF00U)
#define CDOG_STATUS_NUMMISCOMPF_SHIFT            (8U)
/*! NUMMISCOMPF - Number of MISCOMPARE faults since the last POR */
#define CDOG_STATUS_NUMMISCOMPF(x)               (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMMISCOMPF_SHIFT)) & CDOG_STATUS_NUMMISCOMPF_MASK)

#define CDOG_STATUS_NUMILSEQF_MASK               (0xFF0000U)
#define CDOG_STATUS_NUMILSEQF_SHIFT              (16U)
/*! NUMILSEQF - Number of SEQUENCE faults since the last POR */
#define CDOG_STATUS_NUMILSEQF(x)                 (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMILSEQF_SHIFT)) & CDOG_STATUS_NUMILSEQF_MASK)

#define CDOG_STATUS_CURST_MASK                   (0xF0000000U)
#define CDOG_STATUS_CURST_SHIFT                  (28U)
/*! CURST - Current State */
#define CDOG_STATUS_CURST(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_CURST_SHIFT)) & CDOG_STATUS_CURST_MASK)
/*! @} */

/*! @name STATUS2 - Status 2 */
/*! @{ */

#define CDOG_STATUS2_NUMCNTF_MASK                (0xFFU)
#define CDOG_STATUS2_NUMCNTF_SHIFT               (0U)
/*! NUMCNTF - Number of CONTROL faults since the last POR */
#define CDOG_STATUS2_NUMCNTF(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMCNTF_SHIFT)) & CDOG_STATUS2_NUMCNTF_MASK)

#define CDOG_STATUS2_NUMILLSTF_MASK              (0xFF00U)
#define CDOG_STATUS2_NUMILLSTF_SHIFT             (8U)
/*! NUMILLSTF - Number of STATE faults since the last POR */
#define CDOG_STATUS2_NUMILLSTF(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMILLSTF_SHIFT)) & CDOG_STATUS2_NUMILLSTF_MASK)

#define CDOG_STATUS2_NUMILLA_MASK                (0xFF0000U)
#define CDOG_STATUS2_NUMILLA_SHIFT               (16U)
/*! NUMILLA - Number of ADDRESS faults since the last POR */
#define CDOG_STATUS2_NUMILLA(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMILLA_SHIFT)) & CDOG_STATUS2_NUMILLA_MASK)
/*! @} */

/*! @name FLAGS - Flags */
/*! @{ */

#define CDOG_FLAGS_TO_FLAG_MASK                  (0x1U)
#define CDOG_FLAGS_TO_FLAG_SHIFT                 (0U)
/*! TO_FLAG - TIMEOUT fault flag
 *  0b0..A TIMEOUT fault has not occurred
 *  0b1..A TIMEOUT fault has occurred
 */
#define CDOG_FLAGS_TO_FLAG(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_TO_FLAG_SHIFT)) & CDOG_FLAGS_TO_FLAG_MASK)

#define CDOG_FLAGS_MISCOM_FLAG_MASK              (0x2U)
#define CDOG_FLAGS_MISCOM_FLAG_SHIFT             (1U)
/*! MISCOM_FLAG - MISCOMPARE fault flag
 *  0b0..A MISCOMPARE fault has not occurred
 *  0b1..A MISCOMPARE fault has occurred
 */
#define CDOG_FLAGS_MISCOM_FLAG(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_MISCOM_FLAG_SHIFT)) & CDOG_FLAGS_MISCOM_FLAG_MASK)

#define CDOG_FLAGS_SEQ_FLAG_MASK                 (0x4U)
#define CDOG_FLAGS_SEQ_FLAG_SHIFT                (2U)
/*! SEQ_FLAG - SEQUENCE fault flag
 *  0b0..A SEQUENCE fault has not occurred
 *  0b1..A SEQUENCE fault has occurred
 */
#define CDOG_FLAGS_SEQ_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_SEQ_FLAG_SHIFT)) & CDOG_FLAGS_SEQ_FLAG_MASK)

#define CDOG_FLAGS_CNT_FLAG_MASK                 (0x8U)
#define CDOG_FLAGS_CNT_FLAG_SHIFT                (3U)
/*! CNT_FLAG - CONTROL fault flag
 *  0b0..A CONTROL fault has not occurred
 *  0b1..A CONTROL fault has occurred
 */
#define CDOG_FLAGS_CNT_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_CNT_FLAG_SHIFT)) & CDOG_FLAGS_CNT_FLAG_MASK)

#define CDOG_FLAGS_STATE_FLAG_MASK               (0x10U)
#define CDOG_FLAGS_STATE_FLAG_SHIFT              (4U)
/*! STATE_FLAG - STATE fault flag
 *  0b0..A STATE fault has not occurred
 *  0b1..A STATE fault has occurred
 */
#define CDOG_FLAGS_STATE_FLAG(x)                 (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_STATE_FLAG_SHIFT)) & CDOG_FLAGS_STATE_FLAG_MASK)

#define CDOG_FLAGS_ADDR_FLAG_MASK                (0x20U)
#define CDOG_FLAGS_ADDR_FLAG_SHIFT               (5U)
/*! ADDR_FLAG - ADDRESS fault flag
 *  0b0..An ADDRESS fault has not occurred
 *  0b1..An ADDRESS fault has occurred
 */
#define CDOG_FLAGS_ADDR_FLAG(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_ADDR_FLAG_SHIFT)) & CDOG_FLAGS_ADDR_FLAG_MASK)

#define CDOG_FLAGS_POR_FLAG_MASK                 (0x10000U)
#define CDOG_FLAGS_POR_FLAG_SHIFT                (16U)
/*! POR_FLAG - Power-on reset flag
 *  0b0..A Power-on reset event has not occurred
 *  0b1..A Power-on reset event has occurred
 */
#define CDOG_FLAGS_POR_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_POR_FLAG_SHIFT)) & CDOG_FLAGS_POR_FLAG_MASK)
/*! @} */

/*! @name PERSISTENT - Persistent Data Storage */
/*! @{ */

#define CDOG_PERSISTENT_PERSIS_MASK              (0xFFFFFFFFU)
#define CDOG_PERSISTENT_PERSIS_SHIFT             (0U)
/*! PERSIS - Persistent Storage */
#define CDOG_PERSISTENT_PERSIS(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_PERSISTENT_PERSIS_SHIFT)) & CDOG_PERSISTENT_PERSIS_MASK)
/*! @} */

/*! @name START - START Command */
/*! @{ */

#define CDOG_START_STRT_MASK                     (0xFFFFFFFFU)
#define CDOG_START_STRT_SHIFT                    (0U)
/*! STRT - Start command */
#define CDOG_START_STRT(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_START_STRT_SHIFT)) & CDOG_START_STRT_MASK)
/*! @} */

/*! @name STOP - STOP Command */
/*! @{ */

#define CDOG_STOP_STP_MASK                       (0xFFFFFFFFU)
#define CDOG_STOP_STP_SHIFT                      (0U)
/*! STP - Stop command */
#define CDOG_STOP_STP(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_STOP_STP_SHIFT)) & CDOG_STOP_STP_MASK)
/*! @} */

/*! @name RESTART - RESTART Command */
/*! @{ */

#define CDOG_RESTART_RSTRT_MASK                  (0xFFFFFFFFU)
#define CDOG_RESTART_RSTRT_SHIFT                 (0U)
/*! RSTRT - Restart command */
#define CDOG_RESTART_RSTRT(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_RESTART_RSTRT_SHIFT)) & CDOG_RESTART_RSTRT_MASK)
/*! @} */

/*! @name ADD - ADD Command */
/*! @{ */

#define CDOG_ADD_AD_MASK                         (0xFFFFFFFFU)
#define CDOG_ADD_AD_SHIFT                        (0U)
/*! AD - ADD Write Value */
#define CDOG_ADD_AD(x)                           (((uint32_t)(((uint32_t)(x)) << CDOG_ADD_AD_SHIFT)) & CDOG_ADD_AD_MASK)
/*! @} */

/*! @name ADD1 - ADD1 Command */
/*! @{ */

#define CDOG_ADD1_AD1_MASK                       (0xFFFFFFFFU)
#define CDOG_ADD1_AD1_SHIFT                      (0U)
/*! AD1 - ADD 1 */
#define CDOG_ADD1_AD1(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_ADD1_AD1_SHIFT)) & CDOG_ADD1_AD1_MASK)
/*! @} */

/*! @name ADD16 - ADD16 Command */
/*! @{ */

#define CDOG_ADD16_AD16_MASK                     (0xFFFFFFFFU)
#define CDOG_ADD16_AD16_SHIFT                    (0U)
/*! AD16 - ADD 16 */
#define CDOG_ADD16_AD16(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_ADD16_AD16_SHIFT)) & CDOG_ADD16_AD16_MASK)
/*! @} */

/*! @name ADD256 - ADD256 Command */
/*! @{ */

#define CDOG_ADD256_AD256_MASK                   (0xFFFFFFFFU)
#define CDOG_ADD256_AD256_SHIFT                  (0U)
/*! AD256 - ADD 256 */
#define CDOG_ADD256_AD256(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_ADD256_AD256_SHIFT)) & CDOG_ADD256_AD256_MASK)
/*! @} */

/*! @name SUB - SUB Command */
/*! @{ */

#define CDOG_SUB_S0B_MASK                        (0xFFFFFFFFU)
#define CDOG_SUB_S0B_SHIFT                       (0U)
/*! S0B - Subtract Write Value */
#define CDOG_SUB_S0B(x)                          (((uint32_t)(((uint32_t)(x)) << CDOG_SUB_S0B_SHIFT)) & CDOG_SUB_S0B_MASK)
/*! @} */

/*! @name SUB1 - SUB1 Command */
/*! @{ */

#define CDOG_SUB1_S1B_MASK                       (0xFFFFFFFFU)
#define CDOG_SUB1_S1B_SHIFT                      (0U)
/*! S1B - Subtract 1 */
#define CDOG_SUB1_S1B(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_SUB1_S1B_SHIFT)) & CDOG_SUB1_S1B_MASK)
/*! @} */

/*! @name SUB16 - SUB16 Command */
/*! @{ */

#define CDOG_SUB16_SB16_MASK                     (0xFFFFFFFFU)
#define CDOG_SUB16_SB16_SHIFT                    (0U)
/*! SB16 - Subtract 16 */
#define CDOG_SUB16_SB16(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_SUB16_SB16_SHIFT)) & CDOG_SUB16_SB16_MASK)
/*! @} */

/*! @name SUB256 - SUB256 Command */
/*! @{ */

#define CDOG_SUB256_SB256_MASK                   (0xFFFFFFFFU)
#define CDOG_SUB256_SB256_SHIFT                  (0U)
/*! SB256 - Subtract 256 */
#define CDOG_SUB256_SB256(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_SUB256_SB256_SHIFT)) & CDOG_SUB256_SB256_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CDOG_Register_Masks */


/* CDOG - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CDOG base address */
  #define CDOG_BASE                                (0x5014C000u)
  /** Peripheral CDOG base address */
  #define CDOG_BASE_NS                             (0x4014C000u)
  /** Peripheral CDOG base pointer */
  #define CDOG                                     ((CDOG_Type *)CDOG_BASE)
  /** Peripheral CDOG base pointer */
  #define CDOG_NS                                  ((CDOG_Type *)CDOG_BASE_NS)
  /** Array initializer of CDOG peripheral base addresses */
  #define CDOG_BASE_ADDRS                          { CDOG_BASE }
  /** Array initializer of CDOG peripheral base pointers */
  #define CDOG_BASE_PTRS                           { CDOG }
  /** Array initializer of CDOG peripheral base addresses */
  #define CDOG_BASE_ADDRS_NS                       { CDOG_BASE_NS }
  /** Array initializer of CDOG peripheral base pointers */
  #define CDOG_BASE_PTRS_NS                        { CDOG_NS }
#else
  /** Peripheral CDOG base address */
  #define CDOG_BASE                                (0x4014C000u)
  /** Peripheral CDOG base pointer */
  #define CDOG                                     ((CDOG_Type *)CDOG_BASE)
  /** Array initializer of CDOG peripheral base addresses */
  #define CDOG_BASE_ADDRS                          { CDOG_BASE }
  /** Array initializer of CDOG peripheral base pointers */
  #define CDOG_BASE_PTRS                           { CDOG }
#endif
/** Interrupt vectors for the CDOG peripheral type */
#define CDOG_IRQS                                { CDOG_INT_IRQn }

/*!
 * @}
 */ /* end of group CDOG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CIU1 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CIU1_Peripheral_Access_Layer CIU1 Peripheral Access Layer
 * @{
 */

/** CIU1 - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[132];
  __I  uint32_t CIU_CHIP_REV;                      /**< CIU Revision, offset: 0x84 */
       uint8_t RESERVED_1[116];
  __IO uint32_t CIU_CHIP_ECO_CTRL;                 /**< Chip ECO Control, offset: 0xFC */
  __IO uint32_t CIU_CLK_ENABLE;                    /**< Clock Enable, offset: 0x100 */
  __IO uint32_t CIU_CLK_ENABLE2;                   /**< Clock enable2, offset: 0x104 */
  __IO uint32_t CIU_CLK_ENABLE3;                   /**< Clock Enable 3, offset: 0x108 */
       uint8_t RESERVED_2[8];
  __IO uint32_t CIU_CLK_CPU1CLK_CTRL;              /**< CPU1_AHB1 Clock Control, offset: 0x114 */
  __IO uint32_t CIU_CLK_SYSCLK_CTRL;               /**< SYS Clock Control, offset: 0x118 */
       uint8_t RESERVED_3[16];
  __IO uint32_t CIU_CLK_RTU_NCO_CTRL;              /**< RTU NCO Clock Control, offset: 0x12C */
  __IO uint32_t CIU_CLK_LBU1_WLRTU_CTRL;           /**< LBU1 WLRTU1 Clock Control, offset: 0x130 */
  __IO uint32_t CIU_CLK_SOCCLK_CTRL;               /**< SOC Clock Control, offset: 0x134 */
  __IO uint32_t CIU_CLK_SLEEPCLK_CTRL;             /**< Sleep Clock Control, offset: 0x138 */
  __IO uint32_t CIU_CLK_CP15_DIS1;                 /**< Clock Auto Shut-off Enable1, offset: 0x13C */
  __IO uint32_t CIU_CLK_CP15_DIS2;                 /**< Clock Auto Shut-off Enable2, offset: 0x140 */
  __IO uint32_t CIU_CLK_CP15_DIS3;                 /**< Clock Auto Shut-off Enable3, offset: 0x144 */
       uint8_t RESERVED_4[4];
  __IO uint32_t CIU_CLK_ENABLE6;                   /**< Clock Enable 6, offset: 0x14C */
  __IO uint32_t CIU_CLK_SLEEPCLK_CTRL2;            /**< Sleep Clock Control 2, offset: 0x150 */
       uint8_t RESERVED_5[36];
  __IO uint32_t CIU_MAC_CLK_CTRL;                  /**< MAC clock CTRL, offset: 0x178 */
  __IO uint32_t CIU_CLK_ECO_CTRL;                  /**< Clock ECO Control, offset: 0x17C */
  __IO uint32_t CIU_RST_SW1;                       /**< Software Module Reset, offset: 0x180 */
  __IO uint32_t CIU_RST_SW2;                       /**< Software Module Reset, offset: 0x184 */
       uint8_t RESERVED_6[4];
  __IO uint32_t CIU_RST_SW4;                       /**< Software Module Reset, offset: 0x18C */
  __IO uint32_t CIU_RST_SW5;                       /**< Software Module Reset, offset: 0x190 */
       uint8_t RESERVED_7[104];
  __IO uint32_t CIU_RST_ECO_CTRL;                  /**< Reset ECO Control, offset: 0x1FC */
       uint8_t RESERVED_8[4];
  __IO uint32_t CIU_MEM_WRTC2;                     /**< Memory WRTC Control2, offset: 0x204 */
  __IO uint32_t CIU_MEM_WRTC3;                     /**< Memory WRTC Control 3, offset: 0x208 */
       uint8_t RESERVED_9[16];
  __IO uint32_t CIU_MEM_CTRL;                      /**< Memory Control, offset: 0x21C */
  __I  uint32_t CIU_SMU1_DBG_STAT0;                /**< SMU1 debug register0, offset: 0x220 */
  __I  uint32_t CIU_SMU1_DBG_STAT1;                /**< SMU1 debug register1, offset: 0x224 */
  __I  uint32_t CIU_SMU1_DBG_STAT2;                /**< SMU1 debug register2, offset: 0x228 */
       uint8_t RESERVED_10[80];
  __IO uint32_t CIU_MEM_ECO_CTRL;                  /**< Memory ECO Control, offset: 0x27C */
  __IO uint32_t CIU1_INT_MASK;                     /**< CIU1 Interrupt Mask, offset: 0x280 */
  __IO uint32_t CIU1_INT_SELECT;                   /**< CIU1 Interrupt Select, offset: 0x284 */
  __IO uint32_t CIU1_INT_EVENT_MASK;               /**< CIU1 Interrupt Event Mask, offset: 0x288 */
  __I  uint32_t CIU1_INT_STATUS;                   /**< CIU1 Interrupt Status, offset: 0x28C */
  __IO uint32_t CIU_INT_HOST_CTRL;                 /**< Host Interrupt Control, offset: 0x290 */
  __IO uint32_t CIU_BCA1_INT_MASK;                 /**< BCA1 to CPU1 Interrupt Mask, offset: 0x294 */
  __IO uint32_t CIU_BCA1_INT_SELECT;               /**< BCA1 to CPU1 Interrupt Select, offset: 0x298 */
  __IO uint32_t CIU_BCA1_INT_EVENT_MASK;           /**< BCA1 to CPU1 Interrupt Event Mask, offset: 0x29C */
  __I  uint32_t CIU_BCA1_INT_STATUS;               /**< BCA1 to CPU1 Interrupt Status, offset: 0x2A0 */
       uint8_t RESERVED_11[16];
  __IO uint32_t CPU1_ERR_INT_MASK;                 /**< CPU1 ERR Interrupt Mask, offset: 0x2B4 */
  __IO uint32_t CPU1_ERR_INT_SELECT;               /**< CPU1 ERR Interrupt Clear Select, offset: 0x2B8 */
  __IO uint32_t CPU1_ERR_INT_EVENT_MASK;           /**< CPU1 ERR Interrupt Event Mask, offset: 0x2BC */
  __I  uint32_t CPU1_ERR_INT_STATUS;               /**< CPU1 ERR Interrupt Status, offset: 0x2C0 */
       uint8_t RESERVED_12[32];
  __IO uint32_t CPU2_INT_CTRL;                     /**< CPU2 INT control, offset: 0x2E4 */
       uint8_t RESERVED_13[16];
  __IO uint32_t CPU3_INT_CTRL;                     /**< CPU3 INT control, offset: 0x2F8 */
  __IO uint32_t CIU_INT_ECO_CTRL;                  /**< Interrupt ECO Control, offset: 0x2FC */
  __IO uint32_t CIU_PTP_CTRL;                      /**< Vsensor and Vreg Pad Control, offset: 0x300 */
       uint8_t RESERVED_14[156];
  __IO uint32_t CIU_RFU_DBC_MUX_SEL;               /**< RFU related DBC mux selection for different mode, offset: 0x3A0 */
  __IO uint32_t CIU_BCA_DBC_MUX_SEL;               /**< BCA related DBC mux selection for different mode, offset: 0x3A4 */
       uint8_t RESERVED_15[88];
  __I  uint32_t CIU_TST_G2BIST_STATUS;             /**< WL G2BIST Status, offset: 0x400 */
  __I  uint32_t CIU_TST_MBIST_READY;               /**< MBIST Status (BIST_READY), offset: 0x404 */
  __I  uint32_t CIU_TST_MBIST_FAIL;                /**< MBIST Status (BIST_FAIL), offset: 0x408 */
       uint8_t RESERVED_16[28];
  __IO uint32_t CIU_TST_TSTBUS_CTRL2;              /**< Testbux Mux Control2, offset: 0x428 */
       uint8_t RESERVED_17[4];
  __IO uint32_t CIU_TST_CTRL;                      /**< Test Control, offset: 0x430 */
       uint8_t RESERVED_18[72];
  __IO uint32_t CIU_TST_ECO_CTRL;                  /**< Test ECO Control, offset: 0x47C */
       uint8_t RESERVED_19[128];
  __IO uint32_t CIU_GPS_GPIO_MASK;                 /**< GPS GPIO MASK, offset: 0x500 */
  __IO uint32_t CIU_GPS_SW_PERIOD;                 /**< GPS SWITCH CHANNEL PERIOD, offset: 0x504 */
  __IO uint32_t CIU_GPS_SW_EARLY;                  /**< GPS SWITCH CHANNEL EARLY, offset: 0x508 */
  __I  uint32_t CIU_GPS_TMR_RD;                    /**< GPS TIMER READ, offset: 0x50C */
       uint8_t RESERVED_20[1132];
  __IO uint32_t CIU_LDO_ECO_CTRL;                  /**< LDO ECO Control, offset: 0x97C */
       uint8_t RESERVED_21[24];
  __IO uint32_t CIU_AXI_CLK_CTRL2;                 /**< AXI clk bypass contrl2, offset: 0x998 */
  __IO uint32_t CIU_FABRIC_TESTBUS_CTRL;           /**< fabric(scm, wlm) testbus select, offset: 0x99C */
  __IO uint32_t CIU_FABRIC_CREQ_DLY_TIMER;         /**< fabric(scm, wlm) delay timer for c_req, offset: 0x9A0 */
       uint8_t RESERVED_22[88];
  __IO uint32_t CIU_ABU_ECO_CTRL;                  /**< ABU ECO Control, offset: 0x9FC */
  __IO uint32_t CIU1_AHB1_TO_CLEAR;                /**< AHB1 timeout logic clear register, offset: 0xA00 */
  __I  uint32_t CIU_ARB_TO_LAST_ADDR;              /**< AHB Timeout Last Address, offset: 0xA04 */
  __I  uint32_t CIU_ARB_TO_CUR_ADDR;               /**< AHB Current Timeout Address, offset: 0xA08 */
  __IO uint32_t CIU_ARB_CTRL;                      /**< AHB ARB Control, offset: 0xA0C */
       uint8_t RESERVED_23[68];
  __IO uint32_t CIU1_CPU1_ICODE_INV_ADDR_CTRL;     /**< CPU1 Icode invalid address access control, offset: 0xA54 */
  __I  uint32_t CIU1_CPU1_ICODE_INV_ADDR;          /**< CPU1 Icode invalid address, offset: 0xA58 */
  __IO uint32_t CIU1_CPU1_DCODE_INV_ADDR_CTRL;     /**< CPU1 Dcode invalid address access control, offset: 0xA5C */
  __I  uint32_t CIU1_CPU1_DCODE_INV_ADDR;          /**< CPU1 Dcode invalid address, offset: 0xA60 */
  __IO uint32_t CIU1_AHB2AHB_BRIDGE_CTRL;          /**< AHB2AHB Bridge Control Register, offset: 0xA64 */
  __IO uint32_t WL_RAACS_CTRL;                     /**< RAACS control registers, offset: 0xA68 */
  __IO uint32_t WL_RAACS_PERFORMANCE_STATISTICS;   /**< RAACS performance statistics counter., offset: 0xA6C */
  __IO uint32_t CIU_AHB1_TSTBUS_SEL;               /**< AHB1 Control Signals testbus select, offset: 0xA70 */
       uint8_t RESERVED_24[8];
  __IO uint32_t CIU_ARB_ECO_CTRL;                  /**< ARB ECO Control, offset: 0xA7C */
       uint8_t RESERVED_25[8];
  __IO uint32_t CIU_CPU_DYN_CLK_CTRL;              /**< Dynamic CPU Clock Control, offset: 0xA88 */
       uint8_t RESERVED_26[12];
  __I  uint32_t CIU_CPU_DYN_CPUCLK_MONITOR;        /**< Dynamic ahb clock Monitor, offset: 0xA98 */
  __I  uint32_t CIU_CPU_DYN_SYSCLK_MONITOR;        /**< Dynamic sysclk Monitor, offset: 0xA9C */
       uint8_t RESERVED_27[16];
  __IO uint32_t CIU_CPU_CPU1_CTRL;                 /**< CPU1 control register, offset: 0xAB0 */
       uint8_t RESERVED_28[12];
  __IO uint32_t CIU_CPU_CPU1_ACCESS_CTRL;          /**< CPU1 access control register, offset: 0xAC0 */
  __IO uint32_t CIU_CPU_CPU2_ACCESS_CTRL;          /**< CPU2 access control register, offset: 0xAC4 */
  __IO uint32_t CIU_CPU_CPU3_ACCESS_CTRL;          /**< CPU3 access control register, offset: 0xAC8 */
  __I  uint32_t CIU_CPU_CPU1_DBG_STAT1;            /**< CPU1 debug register1, offset: 0xACC */
       uint8_t RESERVED_29[8];
  __IO uint32_t CIU_CPU1_CPU2_FW_DWLD_CTRL;        /**< CPUs FW dwld control register, offset: 0xAD8 */
  __IO uint32_t CIU_CPU_COMM0;                     /**< CPU Communication reserved0, offset: 0xADC */
  __IO uint32_t CIU_CPU_COMM1;                     /**< CPU Communication reserved1, offset: 0xAE0 */
       uint8_t RESERVED_30[88];
  __IO uint32_t CIU_CPU_ECO_CTRL;                  /**< CPU ECO control, offset: 0xB3C */
       uint8_t RESERVED_31[32];
  __IO uint32_t CIU_RFU_CTRL;                      /**< RFU Control and Status, offset: 0xB60 */
  __IO uint32_t CIU_RFU_EXTRA_PORT;                /**< RFU Extra Port Connection, offset: 0xB64 */
       uint8_t RESERVED_32[20];
  __IO uint32_t CIU_RFU_ECO_CTRL;                  /**< RFU ECO Control, offset: 0xB7C */
       uint8_t RESERVED_33[128];
  __IO uint32_t CIU_MCI_EXTRA;                     /**< MCI EXTRA Ports, offset: 0xC00 */
       uint8_t RESERVED_34[252];
  __IO uint32_t CIU_BBUD_CTRL;                     /**< BBUD Control Register, offset: 0xD00 */
  __IO uint32_t CIU_BBUD_EXTRA_PORT;               /**< BBUD Extra Port Connection, offset: 0xD04 */
  __IO uint32_t CIU_BBUD_PTP_INTR_CTRL;            /**< PTP Input capture interrupt control, offset: 0xD08 */
       uint8_t RESERVED_35[112];
  __IO uint32_t CIU_BBUD_ECO_CTRL;                 /**< BBUD ECO Control, offset: 0xD7C */
  __IO uint32_t CIU_AIU_CTRL;                      /**< AIU Control Register, offset: 0xD80 */
       uint8_t RESERVED_36[120];
  __IO uint32_t CIU_AIU_ECO_CTRL;                  /**< AIU ECO Control, offset: 0xDFC */
       uint8_t RESERVED_37[252];
  __IO uint32_t CIU_CBU_ECO_CTRL;                  /**< CBU ECO Control, offset: 0xEFC */
       uint8_t RESERVED_38[1829120];
  __IO uint32_t CIU1_IMU_CPU1_WR_MSG_TO_CPU3;      /**< CPU1(WL) write message to CPU3(MCI) (0xAF0-0xAF4 IMU register access by CPU1), offset: 0x1BF800 */
  __I  uint32_t CIU1_IMU_CPU1_RD_MSG_FROM_CPU3;    /**< cpu1 read message from CPU3, offset: 0x1BF804 */
  __I  uint32_t CIU1_IMU_CPU1_CPU3_MSG_FIFO_STATUS; /**< cpu1 to CPU3 message FIFO status, offset: 0x1BF808 */
  __IO uint32_t CIU1_IMU_CPU1_CPU3_MSG_FIFO_CNTL;  /**< cpu1 to CPU3 message FIFO control, offset: 0x1BF80C */
  __I  uint32_t CIU1_IMU_CPU3_RD_MSG_FROM_CPU1_VAL_DBG; /**< CPU3 last message read (from cpu1), offset: 0x1BF810 */
       uint8_t RESERVED_39[12];
  __IO uint32_t CIU1_IMU_CPU3_WR_MSG_TO_CPU1;      /**< CPU3 write message to cpu1 (0xB04-0xB14 IMU register access by CPU3), offset: 0x1BF820 */
  __I  uint32_t CIU1_IMU_CPU3_RD_MSG_FROM_CPU1;    /**< CPU3 read message from cpu1, offset: 0x1BF824 */
  __I  uint32_t CIU1_IMU_CPU3_CPU1_MSG_FIFO_STATUS; /**< CPU3 to cpu1 message FIFO status, offset: 0x1BF828 */
  __IO uint32_t CIU1_IMU_CPU3_CPU1_MSG_FIFO_CNTL;  /**< CPU3 to cpu1 message FIFO control, offset: 0x1BF82C */
  __I  uint32_t CIU1_IMU_CPU1_RD_MSG_FROM_CPU3_VAL_DBG; /**< cpu1 last message read (from cpu3), offset: 0x1BF830 */
  __IO uint32_t CIU_CPU1_CPU3_MSG_CTRL;            /**< CPU1_CPU3 message register, offset: 0x1BF834 */
  __IO uint32_t CIU1_CPU3_WAKEUP_CTRL;             /**< CIU1 register to wakeup CPU3, offset: 0x1BF838 */
  __IO uint32_t CIU1_CPU1_WAKEUP_DONE;             /**< Wakeup done Control Register to CPU3, offset: 0x1BF83C */
  __IO uint32_t CIU1_CPU3_NS_GP_INT;               /**< Non Secure region GP interrupt to CPU3, offset: 0x1BF840 */
       uint8_t RESERVED_40[184];
  __IO uint32_t CIU_IMU_ECO_BITS;                  /**< IMU ECO Control, offset: 0x1BF8FC */
} CIU1_Type;

/* ----------------------------------------------------------------------------
   -- CIU1 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CIU1_Register_Masks CIU1 Register Masks
 * @{
 */

/*! @name CIU_CHIP_REV - CIU Revision */
/*! @{ */

#define CIU1_CIU_CHIP_REV_CIU_IP_REVISION_MASK   (0xFFFFU)
#define CIU1_CIU_CHIP_REV_CIU_IP_REVISION_SHIFT  (0U)
/*! CIU_IP_REVISION - CIU Revision Number */
#define CIU1_CIU_CHIP_REV_CIU_IP_REVISION(x)     (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CHIP_REV_CIU_IP_REVISION_SHIFT)) & CIU1_CIU_CHIP_REV_CIU_IP_REVISION_MASK)
/*! @} */

/*! @name CIU_CHIP_ECO_CTRL - Chip ECO Control */
/*! @{ */

#define CIU1_CIU_CHIP_ECO_CTRL_ECO_BITS_MASK     (0xFFFFFFFFU)
#define CIU1_CIU_CHIP_ECO_CTRL_ECO_BITS_SHIFT    (0U)
/*! ECO_BITS - Reserved for ECOs */
#define CIU1_CIU_CHIP_ECO_CTRL_ECO_BITS(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CHIP_ECO_CTRL_ECO_BITS_SHIFT)) & CIU1_CIU_CHIP_ECO_CTRL_ECO_BITS_MASK)
/*! @} */

/*! @name CIU_CLK_ENABLE - Clock Enable */
/*! @{ */

#define CIU1_CIU_CLK_ENABLE_BIST_AHB1_CLK_GATING_EN_MASK (0x1U)
#define CIU1_CIU_CLK_ENABLE_BIST_AHB1_CLK_GATING_EN_SHIFT (0U)
/*! BIST_AHB1_CLK_GATING_EN - bist Clock gating for IMEM/DMEM/SMU1/ROM */
#define CIU1_CIU_CLK_ENABLE_BIST_AHB1_CLK_GATING_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_BIST_AHB1_CLK_GATING_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_BIST_AHB1_CLK_GATING_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_CPU1_GATEHCLK_EN_MASK (0x8U)
#define CIU1_CIU_CLK_ENABLE_CPU1_GATEHCLK_EN_SHIFT (3U)
/*! CPU1_GATEHCLK_EN - CPU1 Gate HCLK Control Feature */
#define CIU1_CIU_CLK_ENABLE_CPU1_GATEHCLK_EN(x)  (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_CPU1_GATEHCLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_CPU1_GATEHCLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_CPU1_FABRIC_CLK_EN_MASK (0x10U)
#define CIU1_CIU_CLK_ENABLE_CPU1_FABRIC_CLK_EN_SHIFT (4U)
/*! CPU1_FABRIC_CLK_EN - CPU1 Fabric Clock Control Feature */
#define CIU1_CIU_CLK_ENABLE_CPU1_FABRIC_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_CPU1_FABRIC_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_CPU1_FABRIC_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_CPU1_MEM_SLV_CLK_EN_MASK (0x20U)
#define CIU1_CIU_CLK_ENABLE_CPU1_MEM_SLV_CLK_EN_SHIFT (5U)
/*! CPU1_MEM_SLV_CLK_EN - CPU1 Memory Slave Clock Control Feature */
#define CIU1_CIU_CLK_ENABLE_CPU1_MEM_SLV_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_CPU1_MEM_SLV_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_CPU1_MEM_SLV_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_SMU1_DYN_CLK_GATING_DIS_MASK (0x40U)
#define CIU1_CIU_CLK_ENABLE_SMU1_DYN_CLK_GATING_DIS_SHIFT (6U)
/*! SMU1_DYN_CLK_GATING_DIS - SMU1 Dynamic Clock Gating Feature */
#define CIU1_CIU_CLK_ENABLE_SMU1_DYN_CLK_GATING_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_SMU1_DYN_CLK_GATING_DIS_SHIFT)) & CIU1_CIU_CLK_ENABLE_SMU1_DYN_CLK_GATING_DIS_MASK)

#define CIU1_CIU_CLK_ENABLE_WLRTU1_AHB_CLK_EN_MASK (0x100U)
#define CIU1_CIU_CLK_ENABLE_WLRTU1_AHB_CLK_EN_SHIFT (8U)
/*! WLRTU1_AHB_CLK_EN - WLRTU1 AHB Clock Enable */
#define CIU1_CIU_CLK_ENABLE_WLRTU1_AHB_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_WLRTU1_AHB_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_WLRTU1_AHB_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_SMU1_AHB_CLK_EN_MASK (0x200U)
#define CIU1_CIU_CLK_ENABLE_SMU1_AHB_CLK_EN_SHIFT (9U)
/*! SMU1_AHB_CLK_EN - SMU1 AHB Clock Enable */
#define CIU1_CIU_CLK_ENABLE_SMU1_AHB_CLK_EN(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_SMU1_AHB_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_SMU1_AHB_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_IPS_HCLK_EN_MASK     (0x400U)
#define CIU1_CIU_CLK_ENABLE_IPS_HCLK_EN_SHIFT    (10U)
/*! IPS_HCLK_EN - IPS AHB Clock Enable */
#define CIU1_CIU_CLK_ENABLE_IPS_HCLK_EN(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_IPS_HCLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_IPS_HCLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_LBU1_AHB_CLK_EN_MASK (0x800U)
#define CIU1_CIU_CLK_ENABLE_LBU1_AHB_CLK_EN_SHIFT (11U)
/*! LBU1_AHB_CLK_EN - PBU AHB Clock Enable */
#define CIU1_CIU_CLK_ENABLE_LBU1_AHB_CLK_EN(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_LBU1_AHB_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_LBU1_AHB_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_AHB_CLK_EN_MASK (0x1000U)
#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_AHB_CLK_EN_SHIFT (12U)
/*! CIU_WLAPU_AHB_CLK_EN - APU AHB Clock Enable */
#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_AHB_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_CIU_WLAPU_AHB_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_CIU_WLAPU_AHB_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_SLPCLK_EN_MASK (0x2000U)
#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_SLPCLK_EN_SHIFT (13U)
/*! CIU_WLAPU_SLPCLK_EN - APU Sleep Clock Enable */
#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_SLPCLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_CIU_WLAPU_SLPCLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_CIU_WLAPU_SLPCLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_CAL_CLK_EN_MASK (0x4000U)
#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_CAL_CLK_EN_SHIFT (14U)
/*! CIU_WLAPU_CAL_CLK_EN - APU Calibration Clock Enable */
#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_CAL_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_CIU_WLAPU_CAL_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_CIU_WLAPU_CAL_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_REF_CLK_EN_MASK (0x8000U)
#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_REF_CLK_EN_SHIFT (15U)
/*! CIU_WLAPU_REF_CLK_EN - APU Reference Clock Enable */
#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_REF_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_CIU_WLAPU_REF_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_CIU_WLAPU_REF_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_IPS_CLK_EN_MASK      (0x10000U)
#define CIU1_CIU_CLK_ENABLE_IPS_CLK_EN_SHIFT     (16U)
/*! IPS_CLK_EN - Enable for ips functional clock */
#define CIU1_CIU_CLK_ENABLE_IPS_CLK_EN(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_IPS_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_IPS_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_IPS_PCLK_EN_MASK     (0x20000U)
#define CIU1_CIU_CLK_ENABLE_IPS_PCLK_EN_SHIFT    (17U)
/*! IPS_PCLK_EN - Enable for ips apb clock */
#define CIU1_CIU_CLK_ENABLE_IPS_PCLK_EN(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_IPS_PCLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_IPS_PCLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_MCI_LITE2AHB_HCLK_EN_MASK (0x40000U)
#define CIU1_CIU_CLK_ENABLE_MCI_LITE2AHB_HCLK_EN_SHIFT (18U)
/*! MCI_LITE2AHB_HCLK_EN - Enable for mci lite2ahb module in wl_top */
#define CIU1_CIU_CLK_ENABLE_MCI_LITE2AHB_HCLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_MCI_LITE2AHB_HCLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_MCI_LITE2AHB_HCLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_LBU1_LSBIF_CLK_EN_MASK (0x100000U)
#define CIU1_CIU_CLK_ENABLE_LBU1_LSBIF_CLK_EN_SHIFT (20U)
/*! LBU1_LSBIF_CLK_EN - PBU Device Clock (PCLK) Enable */
#define CIU1_CIU_CLK_ENABLE_LBU1_LSBIF_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_LBU1_LSBIF_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_LBU1_LSBIF_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_EU1_CORE_CLK_EN_MASK (0x400000U)
#define CIU1_CIU_CLK_ENABLE_EU1_CORE_CLK_EN_SHIFT (22U)
/*! EU1_CORE_CLK_EN - EU1 Core Clock Enable */
#define CIU1_CIU_CLK_ENABLE_EU1_CORE_CLK_EN(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_EU1_CORE_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_EU1_CORE_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_MCU1_AHB_CLK_EN_MASK (0x800000U)
#define CIU1_CIU_CLK_ENABLE_MCU1_AHB_CLK_EN_SHIFT (23U)
/*! MCU1_AHB_CLK_EN - MCU1 AHB Clock Enable */
#define CIU1_CIU_CLK_ENABLE_MCU1_AHB_CLK_EN(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_MCU1_AHB_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_MCU1_AHB_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_WL_AHB2APB_HCLK_EN_MASK (0x2000000U)
#define CIU1_CIU_CLK_ENABLE_WL_AHB2APB_HCLK_EN_SHIFT (25U)
/*! WL_AHB2APB_HCLK_EN - Wireless AHB to APB Clock Enable */
#define CIU1_CIU_CLK_ENABLE_WL_AHB2APB_HCLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_WL_AHB2APB_HCLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_WL_AHB2APB_HCLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_MCU1_SYS_CLK_EN_MASK (0x4000000U)
#define CIU1_CIU_CLK_ENABLE_MCU1_SYS_CLK_EN_SHIFT (26U)
/*! MCU1_SYS_CLK_EN - MCU1 System Clock Enable */
#define CIU1_CIU_CLK_ENABLE_MCU1_SYS_CLK_EN(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_MCU1_SYS_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_MCU1_SYS_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_DVFS_CLK_EN_MASK (0x80000000U)
#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_DVFS_CLK_EN_SHIFT (31U)
/*! CIU_WLAPU_DVFS_CLK_EN - APU DVFS Clock Enable */
#define CIU1_CIU_CLK_ENABLE_CIU_WLAPU_DVFS_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE_CIU_WLAPU_DVFS_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE_CIU_WLAPU_DVFS_CLK_EN_MASK)
/*! @} */

/*! @name CIU_CLK_ENABLE2 - Clock enable2 */
/*! @{ */

#define CIU1_CIU_CLK_ENABLE2_IPS_PROM_ADDR_MASK_DIS_MASK (0x1U)
#define CIU1_CIU_CLK_ENABLE2_IPS_PROM_ADDR_MASK_DIS_SHIFT (0U)
/*! IPS_PROM_ADDR_MASK_DIS - ips prom ROM Address Mask Selection */
#define CIU1_CIU_CLK_ENABLE2_IPS_PROM_ADDR_MASK_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE2_IPS_PROM_ADDR_MASK_DIS_SHIFT)) & CIU1_CIU_CLK_ENABLE2_IPS_PROM_ADDR_MASK_DIS_MASK)

#define CIU1_CIU_CLK_ENABLE2_IPS_PROM_DYN_CLK_DIS_MASK (0x2U)
#define CIU1_CIU_CLK_ENABLE2_IPS_PROM_DYN_CLK_DIS_SHIFT (1U)
/*! IPS_PROM_DYN_CLK_DIS - ips ROM Dynamic Clock Gating Feature */
#define CIU1_CIU_CLK_ENABLE2_IPS_PROM_DYN_CLK_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE2_IPS_PROM_DYN_CLK_DIS_SHIFT)) & CIU1_CIU_CLK_ENABLE2_IPS_PROM_DYN_CLK_DIS_MASK)

#define CIU1_CIU_CLK_ENABLE2_BR_AHB1_CLK_EN_MASK (0x1F0000U)
#define CIU1_CIU_CLK_ENABLE2_BR_AHB1_CLK_EN_SHIFT (16U)
/*! BR_AHB1_CLK_EN - BRU AHB Clock Enable */
#define CIU1_CIU_CLK_ENABLE2_BR_AHB1_CLK_EN(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE2_BR_AHB1_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE2_BR_AHB1_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE2_WEU_AHB_CLK_EN_MASK (0x4000000U)
#define CIU1_CIU_CLK_ENABLE2_WEU_AHB_CLK_EN_SHIFT (26U)
/*! WEU_AHB_CLK_EN - WEU AHB Clock Enable */
#define CIU1_CIU_CLK_ENABLE2_WEU_AHB_CLK_EN(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE2_WEU_AHB_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE2_WEU_AHB_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE2_WEU_SYS_CLK_EN_MASK (0x8000000U)
#define CIU1_CIU_CLK_ENABLE2_WEU_SYS_CLK_EN_SHIFT (27U)
/*! WEU_SYS_CLK_EN - WEU SYS Clock Enable */
#define CIU1_CIU_CLK_ENABLE2_WEU_SYS_CLK_EN(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE2_WEU_SYS_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE2_WEU_SYS_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE2_HPU1_CIU_CLK_EN_MASK (0x10000000U)
#define CIU1_CIU_CLK_ENABLE2_HPU1_CIU_CLK_EN_SHIFT (28U)
/*! HPU1_CIU_CLK_EN - HPU1 CIU Clock Enable */
#define CIU1_CIU_CLK_ENABLE2_HPU1_CIU_CLK_EN(x)  (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE2_HPU1_CIU_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE2_HPU1_CIU_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE2_SMU1_TOP_CLK_EN_MASK (0x20000000U)
#define CIU1_CIU_CLK_ENABLE2_SMU1_TOP_CLK_EN_SHIFT (29U)
/*! SMU1_TOP_CLK_EN - SMU1 Top Clock Enable */
#define CIU1_CIU_CLK_ENABLE2_SMU1_TOP_CLK_EN(x)  (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE2_SMU1_TOP_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE2_SMU1_TOP_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE2_SMU1_PORT0_SYS_CLK_EN_MASK (0x40000000U)
#define CIU1_CIU_CLK_ENABLE2_SMU1_PORT0_SYS_CLK_EN_SHIFT (30U)
/*! SMU1_PORT0_SYS_CLK_EN - SMU1 Port 0 System Clock Enable */
#define CIU1_CIU_CLK_ENABLE2_SMU1_PORT0_SYS_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE2_SMU1_PORT0_SYS_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE2_SMU1_PORT0_SYS_CLK_EN_MASK)
/*! @} */

/*! @name CIU_CLK_ENABLE3 - Clock Enable 3 */
/*! @{ */

#define CIU1_CIU_CLK_ENABLE3_WL_MSC_A2A_CLK_EN_MASK (0x1U)
#define CIU1_CIU_CLK_ENABLE3_WL_MSC_A2A_CLK_EN_SHIFT (0U)
/*! WL_MSC_A2A_CLK_EN - Enable Clock for MSC A2A */
#define CIU1_CIU_CLK_ENABLE3_WL_MSC_A2A_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE3_WL_MSC_A2A_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE3_WL_MSC_A2A_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE3_WL_SOC_A2A_CLK_EN_MASK (0x2U)
#define CIU1_CIU_CLK_ENABLE3_WL_SOC_A2A_CLK_EN_SHIFT (1U)
/*! WL_SOC_A2A_CLK_EN - Enable Clock for SOC A2A */
#define CIU1_CIU_CLK_ENABLE3_WL_SOC_A2A_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE3_WL_SOC_A2A_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE3_WL_SOC_A2A_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE3_WLRTU1_CLK_EN_MASK  (0x40U)
#define CIU1_CIU_CLK_ENABLE3_WLRTU1_CLK_EN_SHIFT (6U)
/*! WLRTU1_CLK_EN - Enable WL RTU1 timer clock */
#define CIU1_CIU_CLK_ENABLE3_WLRTU1_CLK_EN(x)    (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE3_WLRTU1_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE3_WLRTU1_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE3_BRU_AHB1_ADDR_MASK_DIS_MASK (0x1000U)
#define CIU1_CIU_CLK_ENABLE3_BRU_AHB1_ADDR_MASK_DIS_SHIFT (12U)
/*! BRU_AHB1_ADDR_MASK_DIS - CPU1 ROM Address Mask Selection */
#define CIU1_CIU_CLK_ENABLE3_BRU_AHB1_ADDR_MASK_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE3_BRU_AHB1_ADDR_MASK_DIS_SHIFT)) & CIU1_CIU_CLK_ENABLE3_BRU_AHB1_ADDR_MASK_DIS_MASK)

#define CIU1_CIU_CLK_ENABLE3_BRU_AHB1_DYN_CLK_GATING_DIS_MASK (0x2000U)
#define CIU1_CIU_CLK_ENABLE3_BRU_AHB1_DYN_CLK_GATING_DIS_SHIFT (13U)
/*! BRU_AHB1_DYN_CLK_GATING_DIS - CPU1 ROM Dynamic Clock Gating Feature */
#define CIU1_CIU_CLK_ENABLE3_BRU_AHB1_DYN_CLK_GATING_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE3_BRU_AHB1_DYN_CLK_GATING_DIS_SHIFT)) & CIU1_CIU_CLK_ENABLE3_BRU_AHB1_DYN_CLK_GATING_DIS_MASK)

#define CIU1_CIU_CLK_ENABLE3_ITCM_AHB1_DYN_CLK_GATING_DIS_MASK (0x4000U)
#define CIU1_CIU_CLK_ENABLE3_ITCM_AHB1_DYN_CLK_GATING_DIS_SHIFT (14U)
/*! ITCM_AHB1_DYN_CLK_GATING_DIS - CPU1 ITCM/IMEM Dynamic Clock Gating Feature */
#define CIU1_CIU_CLK_ENABLE3_ITCM_AHB1_DYN_CLK_GATING_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE3_ITCM_AHB1_DYN_CLK_GATING_DIS_SHIFT)) & CIU1_CIU_CLK_ENABLE3_ITCM_AHB1_DYN_CLK_GATING_DIS_MASK)

#define CIU1_CIU_CLK_ENABLE3_DTCM_AHB1_DYN_CLK_GATING_DIS_MASK (0x8000U)
#define CIU1_CIU_CLK_ENABLE3_DTCM_AHB1_DYN_CLK_GATING_DIS_SHIFT (15U)
/*! DTCM_AHB1_DYN_CLK_GATING_DIS - CPU1 DTCM/DMEM Dynamic Clock Gating Feature */
#define CIU1_CIU_CLK_ENABLE3_DTCM_AHB1_DYN_CLK_GATING_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE3_DTCM_AHB1_DYN_CLK_GATING_DIS_SHIFT)) & CIU1_CIU_CLK_ENABLE3_DTCM_AHB1_DYN_CLK_GATING_DIS_MASK)

#define CIU1_CIU_CLK_ENABLE3_SMU1_BANK_SEG_CLK_EN_MASK (0xFF0000U)
#define CIU1_CIU_CLK_ENABLE3_SMU1_BANK_SEG_CLK_EN_SHIFT (16U)
/*! SMU1_BANK_SEG_CLK_EN - SMU1 bank segment Clock Enable */
#define CIU1_CIU_CLK_ENABLE3_SMU1_BANK_SEG_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE3_SMU1_BANK_SEG_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE3_SMU1_BANK_SEG_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE3_MCI_A2A_CLK_EN_MASK (0x40000000U)
#define CIU1_CIU_CLK_ENABLE3_MCI_A2A_CLK_EN_SHIFT (30U)
/*! MCI_A2A_CLK_EN - Enable Clock for MCI A2A */
#define CIU1_CIU_CLK_ENABLE3_MCI_A2A_CLK_EN(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE3_MCI_A2A_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE3_MCI_A2A_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE3_SMU1_MEM_SYS_CLK_EN_MASK (0x80000000U)
#define CIU1_CIU_CLK_ENABLE3_SMU1_MEM_SYS_CLK_EN_SHIFT (31U)
/*! SMU1_MEM_SYS_CLK_EN - SMU1 mem banks and peripheral control logic Clock Enable */
#define CIU1_CIU_CLK_ENABLE3_SMU1_MEM_SYS_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE3_SMU1_MEM_SYS_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE3_SMU1_MEM_SYS_CLK_EN_MASK)
/*! @} */

/*! @name CIU_CLK_CPU1CLK_CTRL - CPU1_AHB1 Clock Control */
/*! @{ */

#define CIU1_CIU_CLK_CPU1CLK_CTRL_T1_FREQ_SEL_MASK (0xFU)
#define CIU1_CIU_CLK_CPU1CLK_CTRL_T1_FREQ_SEL_SHIFT (0U)
/*! T1_FREQ_SEL - CPU1 Clock Frequency Select */
#define CIU1_CIU_CLK_CPU1CLK_CTRL_T1_FREQ_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_CPU1CLK_CTRL_T1_FREQ_SEL_SHIFT)) & CIU1_CIU_CLK_CPU1CLK_CTRL_T1_FREQ_SEL_MASK)
/*! @} */

/*! @name CIU_CLK_SYSCLK_CTRL - SYS Clock Control */
/*! @{ */

#define CIU1_CIU_CLK_SYSCLK_CTRL_T1_FREQ_SEL_MASK (0xFU)
#define CIU1_CIU_CLK_SYSCLK_CTRL_T1_FREQ_SEL_SHIFT (0U)
/*! T1_FREQ_SEL - Sys Clock Frequency Select */
#define CIU1_CIU_CLK_SYSCLK_CTRL_T1_FREQ_SEL(x)  (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_SYSCLK_CTRL_T1_FREQ_SEL_SHIFT)) & CIU1_CIU_CLK_SYSCLK_CTRL_T1_FREQ_SEL_MASK)
/*! @} */

/*! @name CIU_CLK_RTU_NCO_CTRL - RTU NCO Clock Control */
/*! @{ */

#define CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_REF_CLK_SEL_MASK (0x1U)
#define CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_REF_CLK_SEL_SHIFT (0U)
/*! CIU_WLRTU_REF_CLK_SEL - RTU Reference Clock from UART reference clock tree */
#define CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_REF_CLK_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_REF_CLK_SEL_SHIFT)) & CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_REF_CLK_SEL_MASK)

#define CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_OUT_SEL_MASK (0x2U)
#define CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_OUT_SEL_SHIFT (1U)
/*! CIU_WLRTU_NCO_OUT_SEL - RTU NCO Mode Select (Reference Clock Based) */
#define CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_OUT_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_OUT_SEL_SHIFT)) & CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_OUT_SEL_MASK)

#define CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_ENABLE_MASK (0x4U)
#define CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_ENABLE_SHIFT (2U)
/*! CIU_WLRTU_NCO_ENABLE - RTU NCO Enable (Reference Clock Based) */
#define CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_ENABLE(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_ENABLE_SHIFT)) & CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_ENABLE_MASK)

#define CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_STEP_MASK (0xFFFF0000U)
#define CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_STEP_SHIFT (16U)
/*! CIU_WLRTU_NCO_STEP - Step size for RTU clock NCO (Reference Clock Based) */
#define CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_STEP(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_STEP_SHIFT)) & CIU1_CIU_CLK_RTU_NCO_CTRL_CIU_WLRTU_NCO_STEP_MASK)
/*! @} */

/*! @name CIU_CLK_LBU1_WLRTU_CTRL - LBU1 WLRTU1 Clock Control */
/*! @{ */

#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_USE_REFCLK_MASK (0x2U)
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_USE_REFCLK_SHIFT (1U)
/*! LBU1_USE_REFCLK - Static bit set by FW based on Reference Clock Frequency. If reference clock
 *    frequency is lower and LBU can not support high baud rate of UART, then FW will set
 *    soc_use_ref_mode = 0. This is an indication for Bluetooth subsystem that there is some IP which need PLL
 *    to function which is LBU in this case.
 */
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_USE_REFCLK(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_USE_REFCLK_SHIFT)) & CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_USE_REFCLK_MASK)

#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_CLK_SCALE_EN_MASK (0x4U)
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_CLK_SCALE_EN_SHIFT (2U)
/*! LBU1_CLK_SCALE_EN - Enable lbu1 lsb clock div (upto div by 3/4/5/6 only) */
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_CLK_SCALE_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_CLK_SCALE_EN_SHIFT)) & CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_CLK_SCALE_EN_MASK)

#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_CLK_SCALE_FACTOR_MASK (0x38U)
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_CLK_SCALE_FACTOR_SHIFT (3U)
/*! LBU1_CLK_SCALE_FACTOR - lbu1 lsb clock divider value[2:0] */
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_CLK_SCALE_FACTOR(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_CLK_SCALE_FACTOR_SHIFT)) & CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_CLK_SCALE_FACTOR_MASK)

#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_HIGH_BAUD_SEL_MASK (0x40U)
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_HIGH_BAUD_SEL_SHIFT (6U)
/*! LBU1_HIGH_BAUD_SEL - PBU Bus Reference Clock */
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_HIGH_BAUD_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_HIGH_BAUD_SEL_SHIFT)) & CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_HIGH_BAUD_SEL_MASK)

#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_DIV_BY_2_SEL_MASK (0x80U)
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_DIV_BY_2_SEL_SHIFT (7U)
/*! LBU1_DIV_BY_2_SEL - PBU Bus Reference Clock */
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_DIV_BY_2_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_DIV_BY_2_SEL_SHIFT)) & CIU1_CIU_CLK_LBU1_WLRTU_CTRL_LBU1_DIV_BY_2_SEL_MASK)

#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_TIMER1_USE_SLP_CLK_MASK (0x800U)
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_TIMER1_USE_SLP_CLK_SHIFT (11U)
/*! WLRTU1_TIMER1_USE_SLP_CLK - Timer 1 WL_RTU1 Clock */
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_TIMER1_USE_SLP_CLK(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_TIMER1_USE_SLP_CLK_SHIFT)) & CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_TIMER1_USE_SLP_CLK_MASK)

#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_USE_REF_CLK_MASK (0x1000U)
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_USE_REF_CLK_SHIFT (12U)
/*! WLRTU1_USE_REF_CLK - Static bit set by FW. If it is required that timers need not be programmed
 *    with dynamic switching of T1/Reference, the WL_RTU1 source clock is set on reference clock so
 *    that the timer are not disturbed.
 */
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_USE_REF_CLK(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_USE_REF_CLK_SHIFT)) & CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_USE_REF_CLK_MASK)

#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_DBG_CLK_CTRL_MASK (0x8000U)
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_DBG_CLK_CTRL_SHIFT (15U)
/*! WLRTU1_DBG_CLK_CTRL - WLRTU1 Debug Clock Control Feature */
#define CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_DBG_CLK_CTRL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_DBG_CLK_CTRL_SHIFT)) & CIU1_CIU_CLK_LBU1_WLRTU_CTRL_WLRTU1_DBG_CLK_CTRL_MASK)
/*! @} */

/*! @name CIU_CLK_SOCCLK_CTRL - SOC Clock Control */
/*! @{ */

#define CIU1_CIU_CLK_SOCCLK_CTRL_EU1_CORE_CLK_SEL_MASK (0x3U)
#define CIU1_CIU_CLK_SOCCLK_CTRL_EU1_CORE_CLK_SEL_SHIFT (0U)
/*! EU1_CORE_CLK_SEL - EU1 Core Clock Select */
#define CIU1_CIU_CLK_SOCCLK_CTRL_EU1_CORE_CLK_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_SOCCLK_CTRL_EU1_CORE_CLK_SEL_SHIFT)) & CIU1_CIU_CLK_SOCCLK_CTRL_EU1_CORE_CLK_SEL_MASK)

#define CIU1_CIU_CLK_SOCCLK_CTRL_CIU_WLAPU_CONST_CAL_CLK_SEL_MASK (0x400U)
#define CIU1_CIU_CLK_SOCCLK_CTRL_CIU_WLAPU_CONST_CAL_CLK_SEL_SHIFT (10U)
/*! CIU_WLAPU_CONST_CAL_CLK_SEL - PMU Constant Calibration Clock Select */
#define CIU1_CIU_CLK_SOCCLK_CTRL_CIU_WLAPU_CONST_CAL_CLK_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_SOCCLK_CTRL_CIU_WLAPU_CONST_CAL_CLK_SEL_SHIFT)) & CIU1_CIU_CLK_SOCCLK_CTRL_CIU_WLAPU_CONST_CAL_CLK_SEL_MASK)

#define CIU1_CIU_CLK_SOCCLK_CTRL_CIU_WLAPU_CAL_CLK_SEL_MASK (0x800U)
#define CIU1_CIU_CLK_SOCCLK_CTRL_CIU_WLAPU_CAL_CLK_SEL_SHIFT (11U)
/*! CIU_WLAPU_CAL_CLK_SEL - PMU Calibration Clock */
#define CIU1_CIU_CLK_SOCCLK_CTRL_CIU_WLAPU_CAL_CLK_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_SOCCLK_CTRL_CIU_WLAPU_CAL_CLK_SEL_SHIFT)) & CIU1_CIU_CLK_SOCCLK_CTRL_CIU_WLAPU_CAL_CLK_SEL_MASK)

#define CIU1_CIU_CLK_SOCCLK_CTRL_CIU_USE_REFCLK_MASK (0x4000U)
#define CIU1_CIU_CLK_SOCCLK_CTRL_CIU_USE_REFCLK_SHIFT (14U)
/*! CIU_USE_REFCLK - SoC_Clk Clock */
#define CIU1_CIU_CLK_SOCCLK_CTRL_CIU_USE_REFCLK(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_SOCCLK_CTRL_CIU_USE_REFCLK_SHIFT)) & CIU1_CIU_CLK_SOCCLK_CTRL_CIU_USE_REFCLK_MASK)

#define CIU1_CIU_CLK_SOCCLK_CTRL_WL_AHB2APB_PCLK_DIV_SEL_MASK (0xF0000U)
#define CIU1_CIU_CLK_SOCCLK_CTRL_WL_AHB2APB_PCLK_DIV_SEL_SHIFT (16U)
/*! WL_AHB2APB_PCLK_DIV_SEL - WL AHB2APB PCLK Divider Select */
#define CIU1_CIU_CLK_SOCCLK_CTRL_WL_AHB2APB_PCLK_DIV_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_SOCCLK_CTRL_WL_AHB2APB_PCLK_DIV_SEL_SHIFT)) & CIU1_CIU_CLK_SOCCLK_CTRL_WL_AHB2APB_PCLK_DIV_SEL_MASK)

#define CIU1_CIU_CLK_SOCCLK_CTRL_WL_AHB2APB_WAIT_CYCLES_MASK (0xF0000000U)
#define CIU1_CIU_CLK_SOCCLK_CTRL_WL_AHB2APB_WAIT_CYCLES_SHIFT (28U)
/*! WL_AHB2APB_WAIT_CYCLES - WL AHB2APB Wait Cycles between each APB transaction */
#define CIU1_CIU_CLK_SOCCLK_CTRL_WL_AHB2APB_WAIT_CYCLES(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_SOCCLK_CTRL_WL_AHB2APB_WAIT_CYCLES_SHIFT)) & CIU1_CIU_CLK_SOCCLK_CTRL_WL_AHB2APB_WAIT_CYCLES_MASK)
/*! @} */

/*! @name CIU_CLK_SLEEPCLK_CTRL - Sleep Clock Control */
/*! @{ */

#define CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_SLEEP_CLK_NCO_MVAL_MASK (0xFFFFFFU)
#define CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_SLEEP_CLK_NCO_MVAL_SHIFT (0U)
/*! CIU_SLEEP_CLK_NCO_MVAL - Sleep Clock NCO */
#define CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_SLEEP_CLK_NCO_MVAL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_SLEEP_CLK_NCO_MVAL_SHIFT)) & CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_SLEEP_CLK_NCO_MVAL_MASK)

#define CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_NCO_SLEEP_CLK_SEL_MASK (0x2000000U)
#define CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_NCO_SLEEP_CLK_SEL_SHIFT (25U)
/*! CIU_NCO_SLEEP_CLK_SEL - NCO Sleep Clock Select */
#define CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_NCO_SLEEP_CLK_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_NCO_SLEEP_CLK_SEL_SHIFT)) & CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_NCO_SLEEP_CLK_SEL_MASK)

#define CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_REFCLK_SLEEP_CLK_SEL_MASK (0x10000000U)
#define CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_REFCLK_SLEEP_CLK_SEL_SHIFT (28U)
/*! CIU_REFCLK_SLEEP_CLK_SEL - Reference Clock Sleep Clock Select */
#define CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_REFCLK_SLEEP_CLK_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_REFCLK_SLEEP_CLK_SEL_SHIFT)) & CIU1_CIU_CLK_SLEEPCLK_CTRL_CIU_REFCLK_SLEEP_CLK_SEL_MASK)
/*! @} */

/*! @name CIU_CLK_CP15_DIS1 - Clock Auto Shut-off Enable1 */
/*! @{ */

#define CIU1_CIU_CLK_CP15_DIS1_WLAN_HCLK_MASK    (0x40000U)
#define CIU1_CIU_CLK_CP15_DIS1_WLAN_HCLK_SHIFT   (18U)
/*! WLAN_HCLK - WLAN ahb Arbiter/Decoder Shut Off */
#define CIU1_CIU_CLK_CP15_DIS1_WLAN_HCLK(x)      (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_CP15_DIS1_WLAN_HCLK_SHIFT)) & CIU1_CIU_CLK_CP15_DIS1_WLAN_HCLK_MASK)

#define CIU1_CIU_CLK_CP15_DIS1_CP15_DIS_WLAPU_AHB_CLK_MASK (0x100000U)
#define CIU1_CIU_CLK_CP15_DIS1_CP15_DIS_WLAPU_AHB_CLK_SHIFT (20U)
/*! CP15_DIS_WLAPU_AHB_CLK - APU Shut Off */
#define CIU1_CIU_CLK_CP15_DIS1_CP15_DIS_WLAPU_AHB_CLK(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_CP15_DIS1_CP15_DIS_WLAPU_AHB_CLK_SHIFT)) & CIU1_CIU_CLK_CP15_DIS1_CP15_DIS_WLAPU_AHB_CLK_MASK)
/*! @} */

/*! @name CIU_CLK_CP15_DIS2 - Clock Auto Shut-off Enable2 */
/*! @{ */

#define CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_BROM_CLK_MASK (0x1FU)
#define CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_BROM_CLK_SHIFT (0U)
/*! CP15_DIS_CPU1_BROM_CLK - APU Shut Off */
#define CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_BROM_CLK(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_BROM_CLK_SHIFT)) & CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_BROM_CLK_MASK)

#define CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_DMEM_CLK_MASK (0x300U)
#define CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_DMEM_CLK_SHIFT (8U)
/*! CP15_DIS_CPU1_DMEM_CLK - APU Shut Off */
#define CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_DMEM_CLK(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_DMEM_CLK_SHIFT)) & CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_DMEM_CLK_MASK)

#define CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_IMEM_CLK_MASK (0x1F0000U)
#define CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_IMEM_CLK_SHIFT (16U)
/*! CP15_DIS_CPU1_IMEM_CLK - APU Shut Off 0 = disable this auto shut off feature 1 = AHB clock for
 *    the IMEM is automatically shut off while CPU is asleep
 */
#define CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_IMEM_CLK(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_IMEM_CLK_SHIFT)) & CIU1_CIU_CLK_CP15_DIS2_CP15_DIS_CPU1_IMEM_CLK_MASK)
/*! @} */

/*! @name CIU_CLK_CP15_DIS3 - Clock Auto Shut-off Enable3 */
/*! @{ */

#define CIU1_CIU_CLK_CP15_DIS3_CP15_DIS_WEU_AHB_CLK_MASK (0x100000U)
#define CIU1_CIU_CLK_CP15_DIS3_CP15_DIS_WEU_AHB_CLK_SHIFT (20U)
/*! CP15_DIS_WEU_AHB_CLK - TKIP/WEP WEU AHB Shut Off */
#define CIU1_CIU_CLK_CP15_DIS3_CP15_DIS_WEU_AHB_CLK(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_CP15_DIS3_CP15_DIS_WEU_AHB_CLK_SHIFT)) & CIU1_CIU_CLK_CP15_DIS3_CP15_DIS_WEU_AHB_CLK_MASK)
/*! @} */

/*! @name CIU_CLK_ENABLE6 - Clock Enable 6 */
/*! @{ */

#define CIU1_CIU_CLK_ENABLE6_CAU_SIF_CLK_SEL_MASK (0x100U)
#define CIU1_CIU_CLK_ENABLE6_CAU_SIF_CLK_SEL_SHIFT (8U)
/*! CAU_SIF_CLK_SEL - CAU SIF Clock Select */
#define CIU1_CIU_CLK_ENABLE6_CAU_SIF_CLK_SEL(x)  (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE6_CAU_SIF_CLK_SEL_SHIFT)) & CIU1_CIU_CLK_ENABLE6_CAU_SIF_CLK_SEL_MASK)

#define CIU1_CIU_CLK_ENABLE6_CAU_SIF_AHB1_CLK_EN_MASK (0x200U)
#define CIU1_CIU_CLK_ENABLE6_CAU_SIF_AHB1_CLK_EN_SHIFT (9U)
/*! CAU_SIF_AHB1_CLK_EN - CAU AHB2SIF AHB clock enable */
#define CIU1_CIU_CLK_ENABLE6_CAU_SIF_AHB1_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE6_CAU_SIF_AHB1_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE6_CAU_SIF_AHB1_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE6_GPS_PPS_CLK_EN_MASK (0x400U)
#define CIU1_CIU_CLK_ENABLE6_GPS_PPS_CLK_EN_SHIFT (10U)
/*! GPS_PPS_CLK_EN - GPS PPS Clock Enable */
#define CIU1_CIU_CLK_ENABLE6_GPS_PPS_CLK_EN(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE6_GPS_PPS_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE6_GPS_PPS_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE6_MAC1_G2BIST_CLK_EN_MASK (0x800U)
#define CIU1_CIU_CLK_ENABLE6_MAC1_G2BIST_CLK_EN_SHIFT (11U)
/*! MAC1_G2BIST_CLK_EN - Clock Enable for MAC1 BIST Controller Clock */
#define CIU1_CIU_CLK_ENABLE6_MAC1_G2BIST_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE6_MAC1_G2BIST_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE6_MAC1_G2BIST_CLK_EN_MASK)

#define CIU1_CIU_CLK_ENABLE6_BBUD_MAC_CLK_SEL_MASK (0x2000U)
#define CIU1_CIU_CLK_ENABLE6_BBUD_MAC_CLK_SEL_SHIFT (13U)
/*! BBUD_MAC_CLK_SEL - BBUD MAC Clock Select */
#define CIU1_CIU_CLK_ENABLE6_BBUD_MAC_CLK_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE6_BBUD_MAC_CLK_SEL_SHIFT)) & CIU1_CIU_CLK_ENABLE6_BBUD_MAC_CLK_SEL_MASK)

#define CIU1_CIU_CLK_ENABLE6_PTP_CLK_EN_MASK     (0x4000U)
#define CIU1_CIU_CLK_ENABLE6_PTP_CLK_EN_SHIFT    (14U)
/*! PTP_CLK_EN - PTP input capture pulse interrupt clock enable */
#define CIU1_CIU_CLK_ENABLE6_PTP_CLK_EN(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ENABLE6_PTP_CLK_EN_SHIFT)) & CIU1_CIU_CLK_ENABLE6_PTP_CLK_EN_MASK)
/*! @} */

/*! @name CIU_CLK_SLEEPCLK_CTRL2 - Sleep Clock Control 2 */
/*! @{ */

#define CIU1_CIU_CLK_SLEEPCLK_CTRL2_CIU_SLEEP_CLK_NCO_MVAL_DURING_SLP_MASK (0xFFFFFFU)
#define CIU1_CIU_CLK_SLEEPCLK_CTRL2_CIU_SLEEP_CLK_NCO_MVAL_DURING_SLP_SHIFT (0U)
/*! CIU_SLEEP_CLK_NCO_MVAL_DURING_SLP - Sleep Clock NCO value for the sleep mode */
#define CIU1_CIU_CLK_SLEEPCLK_CTRL2_CIU_SLEEP_CLK_NCO_MVAL_DURING_SLP(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_SLEEPCLK_CTRL2_CIU_SLEEP_CLK_NCO_MVAL_DURING_SLP_SHIFT)) & CIU1_CIU_CLK_SLEEPCLK_CTRL2_CIU_SLEEP_CLK_NCO_MVAL_DURING_SLP_MASK)

#define CIU1_CIU_CLK_SLEEPCLK_CTRL2_CIU_SLEEP_CLK_NCO_MVAL_BYPASS_MASK (0x1000000U)
#define CIU1_CIU_CLK_SLEEPCLK_CTRL2_CIU_SLEEP_CLK_NCO_MVAL_BYPASS_SHIFT (24U)
/*! CIU_SLEEP_CLK_NCO_MVAL_BYPASS - Sleep Clock NCO MVAL Bypass Feature */
#define CIU1_CIU_CLK_SLEEPCLK_CTRL2_CIU_SLEEP_CLK_NCO_MVAL_BYPASS(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_SLEEPCLK_CTRL2_CIU_SLEEP_CLK_NCO_MVAL_BYPASS_SHIFT)) & CIU1_CIU_CLK_SLEEPCLK_CTRL2_CIU_SLEEP_CLK_NCO_MVAL_BYPASS_MASK)
/*! @} */

/*! @name CIU_MAC_CLK_CTRL - MAC clock CTRL */
/*! @{ */

#define CIU1_CIU_MAC_CLK_CTRL_MAC1_BBUD_BYPASS_EN_MASK (0x1U)
#define CIU1_CIU_MAC_CLK_CTRL_MAC1_BBUD_BYPASS_EN_SHIFT (0U)
/*! MAC1_BBUD_BYPASS_EN - Bypass 11J_EN and PUB_SFT from BBUD1 */
#define CIU1_CIU_MAC_CLK_CTRL_MAC1_BBUD_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MAC_CLK_CTRL_MAC1_BBUD_BYPASS_EN_SHIFT)) & CIU1_CIU_MAC_CLK_CTRL_MAC1_BBUD_BYPASS_EN_MASK)

#define CIU1_CIU_MAC_CLK_CTRL_MAC1_BBUD_BYPASS_VAL_MASK (0x6U)
#define CIU1_CIU_MAC_CLK_CTRL_MAC1_BBUD_BYPASS_VAL_SHIFT (1U)
/*! MAC1_BBUD_BYPASS_VAL - Bypass value */
#define CIU1_CIU_MAC_CLK_CTRL_MAC1_BBUD_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MAC_CLK_CTRL_MAC1_BBUD_BYPASS_VAL_SHIFT)) & CIU1_CIU_MAC_CLK_CTRL_MAC1_BBUD_BYPASS_VAL_MASK)
/*! @} */

/*! @name CIU_CLK_ECO_CTRL - Clock ECO Control */
/*! @{ */

#define CIU1_CIU_CLK_ECO_CTRL_ECO_BITS_MASK      (0xFFFFFFFFU)
#define CIU1_CIU_CLK_ECO_CTRL_ECO_BITS_SHIFT     (0U)
/*! ECO_BITS - Reserved for ECOs */
#define CIU1_CIU_CLK_ECO_CTRL_ECO_BITS(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_CLK_ECO_CTRL_ECO_BITS_SHIFT)) & CIU1_CIU_CLK_ECO_CTRL_ECO_BITS_MASK)
/*! @} */

/*! @name CIU_RST_SW1 - Software Module Reset */
/*! @{ */

#define CIU1_CIU_RST_SW1_HPU1__MASK              (0x1U)
#define CIU1_CIU_RST_SW1_HPU1__SHIFT             (0U)
/*! HPU1_ - HPU1 Reset */
#define CIU1_CIU_RST_SW1_HPU1_(x)                (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_HPU1__SHIFT)) & CIU1_CIU_RST_SW1_HPU1__MASK)

#define CIU1_CIU_RST_SW1_SMU1_PORT0_SYS_CLK_N_MASK (0x4U)
#define CIU1_CIU_RST_SW1_SMU1_PORT0_SYS_CLK_N_SHIFT (2U)
/*! SMU1_PORT0_SYS_CLK_N - SMU1 port 0 (SYS_Clk) Soft Reset */
#define CIU1_CIU_RST_SW1_SMU1_PORT0_SYS_CLK_N(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_SMU1_PORT0_SYS_CLK_N_SHIFT)) & CIU1_CIU_RST_SW1_SMU1_PORT0_SYS_CLK_N_MASK)

#define CIU1_CIU_RST_SW1_SMU1_MEM_CLK__MASK      (0x8U)
#define CIU1_CIU_RST_SW1_SMU1_MEM_CLK__SHIFT     (3U)
/*! SMU1_MEM_CLK_ - SMU1 bank clock Soft Reset */
#define CIU1_CIU_RST_SW1_SMU1_MEM_CLK_(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_SMU1_MEM_CLK__SHIFT)) & CIU1_CIU_RST_SW1_SMU1_MEM_CLK__MASK)

#define CIU1_CIU_RST_SW1_SMU1_TM_RST__MASK       (0x80U)
#define CIU1_CIU_RST_SW1_SMU1_TM_RST__SHIFT      (7U)
/*! SMU1_TM_RST_ - SMU1 testmode logic reset */
#define CIU1_CIU_RST_SW1_SMU1_TM_RST_(x)         (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_SMU1_TM_RST__SHIFT)) & CIU1_CIU_RST_SW1_SMU1_TM_RST__MASK)

#define CIU1_CIU_RST_SW1_WEU_SYS_CLK_N_MASK      (0x100U)
#define CIU1_CIU_RST_SW1_WEU_SYS_CLK_N_SHIFT     (8U)
/*! WEU_SYS_CLK_N - WEU sys clock domain soft reset */
#define CIU1_CIU_RST_SW1_WEU_SYS_CLK_N(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_WEU_SYS_CLK_N_SHIFT)) & CIU1_CIU_RST_SW1_WEU_SYS_CLK_N_MASK)

#define CIU1_CIU_RST_SW1_WEU_AHB_CLK_N_MASK      (0x200U)
#define CIU1_CIU_RST_SW1_WEU_AHB_CLK_N_SHIFT     (9U)
/*! WEU_AHB_CLK_N - WEU ahb clock domain soft reset */
#define CIU1_CIU_RST_SW1_WEU_AHB_CLK_N(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_WEU_AHB_CLK_N_SHIFT)) & CIU1_CIU_RST_SW1_WEU_AHB_CLK_N_MASK)

#define CIU1_CIU_RST_SW1_CIU1_CFG_RST__MASK      (0x400U)
#define CIU1_CIU_RST_SW1_CIU1_CFG_RST__SHIFT     (10U)
/*! CIU1_CFG_RST_ - CIU ahb clock domain Soft Reset */
#define CIU1_CIU_RST_SW1_CIU1_CFG_RST_(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_CIU1_CFG_RST__SHIFT)) & CIU1_CIU_RST_SW1_CIU1_CFG_RST__MASK)

#define CIU1_CIU_RST_SW1_CIU1_REGISTER_RST__MASK (0x800U)
#define CIU1_CIU_RST_SW1_CIU1_REGISTER_RST__SHIFT (11U)
/*! CIU1_REGISTER_RST_ - CIU_Reg Module Soft Reset */
#define CIU1_CIU_RST_SW1_CIU1_REGISTER_RST_(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_CIU1_REGISTER_RST__SHIFT)) & CIU1_CIU_RST_SW1_CIU1_REGISTER_RST__MASK)

#define CIU1_CIU_RST_SW1_MCU1_SYS_CLK__MASK      (0x8000U)
#define CIU1_CIU_RST_SW1_MCU1_SYS_CLK__SHIFT     (15U)
/*! MCU1_SYS_CLK_ - MCU1 sysclk domain Soft Reset */
#define CIU1_CIU_RST_SW1_MCU1_SYS_CLK_(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_MCU1_SYS_CLK__SHIFT)) & CIU1_CIU_RST_SW1_MCU1_SYS_CLK__MASK)

#define CIU1_CIU_RST_SW1_WL_AHB2APB_CLK_N_MASK   (0x10000U)
#define CIU1_CIU_RST_SW1_WL_AHB2APB_CLK_N_SHIFT  (16U)
/*! WL_AHB2APB_CLK_N - WL AHB2APB AHB clock domain reset */
#define CIU1_CIU_RST_SW1_WL_AHB2APB_CLK_N(x)     (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_WL_AHB2APB_CLK_N_SHIFT)) & CIU1_CIU_RST_SW1_WL_AHB2APB_CLK_N_MASK)

#define CIU1_CIU_RST_SW1_WL_AHB_RST__MASK        (0x80000U)
#define CIU1_CIU_RST_SW1_WL_AHB_RST__SHIFT       (19U)
/*! WL_AHB_RST_ - WL AHB Decoder Mux and Arbiter and CIU AHB intf Soft Reset */
#define CIU1_CIU_RST_SW1_WL_AHB_RST_(x)          (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_WL_AHB_RST__SHIFT)) & CIU1_CIU_RST_SW1_WL_AHB_RST__MASK)

#define CIU1_CIU_RST_SW1_LBU1__MASK              (0x100000U)
#define CIU1_CIU_RST_SW1_LBU1__SHIFT             (20U)
/*! LBU1_ - LBU1 Soft Reset */
#define CIU1_CIU_RST_SW1_LBU1_(x)                (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_LBU1__SHIFT)) & CIU1_CIU_RST_SW1_LBU1__MASK)

#define CIU1_CIU_RST_SW1_WLAPU_REF_CLK__MASK     (0x200000U)
#define CIU1_CIU_RST_SW1_WLAPU_REF_CLK__SHIFT    (21U)
/*! WLAPU_REF_CLK_ - APU ref Clock Reset */
#define CIU1_CIU_RST_SW1_WLAPU_REF_CLK_(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_WLAPU_REF_CLK__SHIFT)) & CIU1_CIU_RST_SW1_WLAPU_REF_CLK__MASK)

#define CIU1_CIU_RST_SW1_BBU1_DSP__MASK          (0x1000000U)
#define CIU1_CIU_RST_SW1_BBU1_DSP__SHIFT         (24U)
/*! BBU1_DSP_ - BBU1_DSP Reset */
#define CIU1_CIU_RST_SW1_BBU1_DSP_(x)            (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_BBU1_DSP__SHIFT)) & CIU1_CIU_RST_SW1_BBU1_DSP__MASK)

#define CIU1_CIU_RST_SW1_RFU1_PR__MASK           (0x2000000U)
#define CIU1_CIU_RST_SW1_RFU1_PR__SHIFT          (25U)
/*! RFU1_PR_ - RFU1_PR Reset */
#define CIU1_CIU_RST_SW1_RFU1_PR_(x)             (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_RFU1_PR__SHIFT)) & CIU1_CIU_RST_SW1_RFU1_PR__MASK)

#define CIU1_CIU_RST_SW1_WLAPU_AHB_CLK__MASK     (0x4000000U)
#define CIU1_CIU_RST_SW1_WLAPU_AHB_CLK__SHIFT    (26U)
/*! WLAPU_AHB_CLK_ - APU ARM Clock Reset */
#define CIU1_CIU_RST_SW1_WLAPU_AHB_CLK_(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_WLAPU_AHB_CLK__SHIFT)) & CIU1_CIU_RST_SW1_WLAPU_AHB_CLK__MASK)

#define CIU1_CIU_RST_SW1_WLAPU_SLP_CLK__MASK     (0x8000000U)
#define CIU1_CIU_RST_SW1_WLAPU_SLP_CLK__SHIFT    (27U)
/*! WLAPU_SLP_CLK_ - APU Sleep Clock domain Reset */
#define CIU1_CIU_RST_SW1_WLAPU_SLP_CLK_(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_WLAPU_SLP_CLK__SHIFT)) & CIU1_CIU_RST_SW1_WLAPU_SLP_CLK__MASK)

#define CIU1_CIU_RST_SW1_MCU1_MCLK__MASK         (0x10000000U)
#define CIU1_CIU_RST_SW1_MCU1_MCLK__SHIFT        (28U)
/*! MCU1_MCLK_ - MCU1 MCLK domain reset */
#define CIU1_CIU_RST_SW1_MCU1_MCLK_(x)           (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_MCU1_MCLK__SHIFT)) & CIU1_CIU_RST_SW1_MCU1_MCLK__MASK)

#define CIU1_CIU_RST_SW1_EU1_CORE_CLK__MASK      (0x20000000U)
#define CIU1_CIU_RST_SW1_EU1_CORE_CLK__SHIFT     (29U)
/*! EU1_CORE_CLK_ - EU1 Core Soft Reset */
#define CIU1_CIU_RST_SW1_EU1_CORE_CLK_(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_EU1_CORE_CLK__SHIFT)) & CIU1_CIU_RST_SW1_EU1_CORE_CLK__MASK)

#define CIU1_CIU_RST_SW1_MCU1_AHB_CLK__MASK      (0x80000000U)
#define CIU1_CIU_RST_SW1_MCU1_AHB_CLK__SHIFT     (31U)
/*! MCU1_AHB_CLK_ - MCU1 AHB Soft Reset */
#define CIU1_CIU_RST_SW1_MCU1_AHB_CLK_(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW1_MCU1_AHB_CLK__SHIFT)) & CIU1_CIU_RST_SW1_MCU1_AHB_CLK__MASK)
/*! @} */

/*! @name CIU_RST_SW2 - Software Module Reset */
/*! @{ */

#define CIU1_CIU_RST_SW2_W1_CLK__MASK            (0x1U)
#define CIU1_CIU_RST_SW2_W1_CLK__SHIFT           (0U)
/*! W1_CLK_ - W1 Interface (PM chip) Soft Reset */
#define CIU1_CIU_RST_SW2_W1_CLK_(x)              (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW2_W1_CLK__SHIFT)) & CIU1_CIU_RST_SW2_W1_CLK__MASK)

#define CIU1_CIU_RST_SW2_BRU_AHB1_CLK__MASK      (0x8U)
#define CIU1_CIU_RST_SW2_BRU_AHB1_CLK__SHIFT     (3U)
/*! BRU_AHB1_CLK_ - BRU_AHB1 Soft Reset */
#define CIU1_CIU_RST_SW2_BRU_AHB1_CLK_(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW2_BRU_AHB1_CLK__SHIFT)) & CIU1_CIU_RST_SW2_BRU_AHB1_CLK__MASK)

#define CIU1_CIU_RST_SW2_IPS_CLK__MASK           (0x2000U)
#define CIU1_CIU_RST_SW2_IPS_CLK__SHIFT          (13U)
/*! IPS_CLK_ - ips functional clock SW reset */
#define CIU1_CIU_RST_SW2_IPS_CLK_(x)             (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW2_IPS_CLK__SHIFT)) & CIU1_CIU_RST_SW2_IPS_CLK__MASK)

#define CIU1_CIU_RST_SW2_IPS_PROM_CLK__MASK      (0x4000U)
#define CIU1_CIU_RST_SW2_IPS_PROM_CLK__SHIFT     (14U)
/*! IPS_PROM_CLK_ - SW reset for ips_prom_clk */
#define CIU1_CIU_RST_SW2_IPS_PROM_CLK_(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW2_IPS_PROM_CLK__SHIFT)) & CIU1_CIU_RST_SW2_IPS_PROM_CLK__MASK)

#define CIU1_CIU_RST_SW2_WLAN_SUB_G2BIST_RSTB_MASK (0x8000U)
#define CIU1_CIU_RST_SW2_WLAN_SUB_G2BIST_RSTB_SHIFT (15U)
/*! WLAN_SUB_G2BIST_RSTB - SW reset for wlan sub-system g2bist controller */
#define CIU1_CIU_RST_SW2_WLAN_SUB_G2BIST_RSTB(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW2_WLAN_SUB_G2BIST_RSTB_SHIFT)) & CIU1_CIU_RST_SW2_WLAN_SUB_G2BIST_RSTB_MASK)

#define CIU1_CIU_RST_SW2_IPS_HCLK__MASK          (0x80000U)
#define CIU1_CIU_RST_SW2_IPS_HCLK__SHIFT         (19U)
/*! IPS_HCLK_ - ips block hresetn */
#define CIU1_CIU_RST_SW2_IPS_HCLK_(x)            (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW2_IPS_HCLK__SHIFT)) & CIU1_CIU_RST_SW2_IPS_HCLK__MASK)

#define CIU1_CIU_RST_SW2_CPU1_TCM__MASK          (0x400000U)
#define CIU1_CIU_RST_SW2_CPU1_TCM__SHIFT         (22U)
/*! CPU1_TCM_ - CPU1 TCM/DMA/Arbiter reset */
#define CIU1_CIU_RST_SW2_CPU1_TCM_(x)            (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW2_CPU1_TCM__SHIFT)) & CIU1_CIU_RST_SW2_CPU1_TCM__MASK)

#define CIU1_CIU_RST_SW2_APB__MASK               (0x800000U)
#define CIU1_CIU_RST_SW2_APB__SHIFT              (23U)
/*! APB_ - APB core clock Soft Reset (TBD_TREEPIE may not need this) */
#define CIU1_CIU_RST_SW2_APB_(x)                 (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW2_APB__SHIFT)) & CIU1_CIU_RST_SW2_APB__MASK)

#define CIU1_CIU_RST_SW2_WD1_CHIP_RST_DISABLE_MASK (0x10000000U)
#define CIU1_CIU_RST_SW2_WD1_CHIP_RST_DISABLE_SHIFT (28U)
/*! WD1_CHIP_RST_DISABLE - WD1 Chip Reset Disable Feature */
#define CIU1_CIU_RST_SW2_WD1_CHIP_RST_DISABLE(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW2_WD1_CHIP_RST_DISABLE_SHIFT)) & CIU1_CIU_RST_SW2_WD1_CHIP_RST_DISABLE_MASK)

#define CIU1_CIU_RST_SW2_WD1_CPU1_RST_DISABLE_MASK (0x20000000U)
#define CIU1_CIU_RST_SW2_WD1_CPU1_RST_DISABLE_SHIFT (29U)
/*! WD1_CPU1_RST_DISABLE - CPU1 Reset Disable Feature */
#define CIU1_CIU_RST_SW2_WD1_CPU1_RST_DISABLE(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW2_WD1_CPU1_RST_DISABLE_SHIFT)) & CIU1_CIU_RST_SW2_WD1_CPU1_RST_DISABLE_MASK)

#define CIU1_CIU_RST_SW2_CPU1_CORE__MASK         (0x40000000U)
#define CIU1_CIU_RST_SW2_CPU1_CORE__SHIFT        (30U)
/*! CPU1_CORE_ - CPU1 core reset */
#define CIU1_CIU_RST_SW2_CPU1_CORE_(x)           (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW2_CPU1_CORE__SHIFT)) & CIU1_CIU_RST_SW2_CPU1_CORE__MASK)
/*! @} */

/*! @name CIU_RST_SW4 - Software Module Reset */
/*! @{ */

#define CIU1_CIU_RST_SW4_CPU1_DBG__MASK          (0x1U)
#define CIU1_CIU_RST_SW4_CPU1_DBG__SHIFT         (0U)
/*! CPU1_DBG_ - CPU1 debug logic soft reset. */
#define CIU1_CIU_RST_SW4_CPU1_DBG_(x)            (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW4_CPU1_DBG__SHIFT)) & CIU1_CIU_RST_SW4_CPU1_DBG__MASK)

#define CIU1_CIU_RST_SW4_CPU1_WATCHDOG__MASK     (0x2U)
#define CIU1_CIU_RST_SW4_CPU1_WATCHDOG__SHIFT    (1U)
/*! CPU1_WATCHDOG_ - CPU1 watchdog logic soft reset */
#define CIU1_CIU_RST_SW4_CPU1_WATCHDOG_(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW4_CPU1_WATCHDOG__SHIFT)) & CIU1_CIU_RST_SW4_CPU1_WATCHDOG__MASK)

#define CIU1_CIU_RST_SW4_CPU1_G2BIST__MASK       (0x8U)
#define CIU1_CIU_RST_SW4_CPU1_G2BIST__SHIFT      (3U)
/*! CPU1_G2BIST_ - CPU1 g2bist soft reset */
#define CIU1_CIU_RST_SW4_CPU1_G2BIST_(x)         (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW4_CPU1_G2BIST__SHIFT)) & CIU1_CIU_RST_SW4_CPU1_G2BIST__MASK)

#define CIU1_CIU_RST_SW4_CAU_SIF__MASK           (0x10U)
#define CIU1_CIU_RST_SW4_CAU_SIF__SHIFT          (4U)
/*! CAU_SIF_ - CAU sif clock Soft Reset */
#define CIU1_CIU_RST_SW4_CAU_SIF_(x)             (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW4_CAU_SIF__SHIFT)) & CIU1_CIU_RST_SW4_CAU_SIF__MASK)

#define CIU1_CIU_RST_SW4_CAU_SIF_AHB1_CLK__MASK  (0x20U)
#define CIU1_CIU_RST_SW4_CAU_SIF_AHB1_CLK__SHIFT (5U)
/*! CAU_SIF_AHB1_CLK_ - CAU sif ahb1 Clock Soft Reset */
#define CIU1_CIU_RST_SW4_CAU_SIF_AHB1_CLK_(x)    (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW4_CAU_SIF_AHB1_CLK__SHIFT)) & CIU1_CIU_RST_SW4_CAU_SIF_AHB1_CLK__MASK)

#define CIU1_CIU_RST_SW4_WLM_SYS_CLK__MASK       (0x200000U)
#define CIU1_CIU_RST_SW4_WLM_SYS_CLK__SHIFT      (21U)
/*! WLM_SYS_CLK_ - WLM SYS CLK Soft Reset */
#define CIU1_CIU_RST_SW4_WLM_SYS_CLK_(x)         (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW4_WLM_SYS_CLK__SHIFT)) & CIU1_CIU_RST_SW4_WLM_SYS_CLK__MASK)

#define CIU1_CIU_RST_SW4_WL_SYS_CLK__MASK        (0x400000U)
#define CIU1_CIU_RST_SW4_WL_SYS_CLK__SHIFT       (22U)
/*! WL_SYS_CLK_ - WL SYS CLK Soft Reset (Not used in Rendfinch) */
#define CIU1_CIU_RST_SW4_WL_SYS_CLK_(x)          (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW4_WL_SYS_CLK__SHIFT)) & CIU1_CIU_RST_SW4_WL_SYS_CLK__MASK)

#define CIU1_CIU_RST_SW4_MCU1_AHB_CLK_RETENTION__MASK (0x1000000U)
#define CIU1_CIU_RST_SW4_MCU1_AHB_CLK_RETENTION__SHIFT (24U)
/*! MCU1_AHB_CLK_RETENTION_ - MCU1 AHB Soft Retention Reset */
#define CIU1_CIU_RST_SW4_MCU1_AHB_CLK_RETENTION_(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW4_MCU1_AHB_CLK_RETENTION__SHIFT)) & CIU1_CIU_RST_SW4_MCU1_AHB_CLK_RETENTION__MASK)

#define CIU1_CIU_RST_SW4_MCU1_MCLK_RETENTION__MASK (0x2000000U)
#define CIU1_CIU_RST_SW4_MCU1_MCLK_RETENTION__SHIFT (25U)
/*! MCU1_MCLK_RETENTION_ - MCU1 MCLK domain retention reset */
#define CIU1_CIU_RST_SW4_MCU1_MCLK_RETENTION_(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW4_MCU1_MCLK_RETENTION__SHIFT)) & CIU1_CIU_RST_SW4_MCU1_MCLK_RETENTION__MASK)

#define CIU1_CIU_RST_SW4_MCU1_SYS_CLK_RETENTION__MASK (0x4000000U)
#define CIU1_CIU_RST_SW4_MCU1_SYS_CLK_RETENTION__SHIFT (26U)
/*! MCU1_SYS_CLK_RETENTION_ - MCU1 sysclk domain Soft Retention Reset */
#define CIU1_CIU_RST_SW4_MCU1_SYS_CLK_RETENTION_(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW4_MCU1_SYS_CLK_RETENTION__SHIFT)) & CIU1_CIU_RST_SW4_MCU1_SYS_CLK_RETENTION__MASK)
/*! @} */

/*! @name CIU_RST_SW5 - Software Module Reset */
/*! @{ */

#define CIU1_CIU_RST_SW5_WL_MSC_A2A__MASK        (0x8U)
#define CIU1_CIU_RST_SW5_WL_MSC_A2A__SHIFT       (3U)
/*! WL_MSC_A2A_ - MSC a2a soft reset */
#define CIU1_CIU_RST_SW5_WL_MSC_A2A_(x)          (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW5_WL_MSC_A2A__SHIFT)) & CIU1_CIU_RST_SW5_WL_MSC_A2A__MASK)

#define CIU1_CIU_RST_SW5_WL_SOC_A2A__MASK        (0x10U)
#define CIU1_CIU_RST_SW5_WL_SOC_A2A__SHIFT       (4U)
/*! WL_SOC_A2A_ - SOC TOP a2a soft reset */
#define CIU1_CIU_RST_SW5_WL_SOC_A2A_(x)          (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW5_WL_SOC_A2A__SHIFT)) & CIU1_CIU_RST_SW5_WL_SOC_A2A__MASK)

#define CIU1_CIU_RST_SW5_SMU1_AHB_RST__MASK      (0x20U)
#define CIU1_CIU_RST_SW5_SMU1_AHB_RST__SHIFT     (5U)
/*! SMU1_AHB_RST_ - SW reset for smu1 ahb */
#define CIU1_CIU_RST_SW5_SMU1_AHB_RST_(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW5_SMU1_AHB_RST__SHIFT)) & CIU1_CIU_RST_SW5_SMU1_AHB_RST__MASK)

#define CIU1_CIU_RST_SW5_MCI_LITE2AHB_RST__MASK  (0x40U)
#define CIU1_CIU_RST_SW5_MCI_LITE2AHB_RST__SHIFT (6U)
/*! MCI_LITE2AHB_RST_ - SW reset to mci lite2ahb in wl_top */
#define CIU1_CIU_RST_SW5_MCI_LITE2AHB_RST_(x)    (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW5_MCI_LITE2AHB_RST__SHIFT)) & CIU1_CIU_RST_SW5_MCI_LITE2AHB_RST__MASK)

#define CIU1_CIU_RST_SW5_SMU1_CFG_RST__MASK      (0x80U)
#define CIU1_CIU_RST_SW5_SMU1_CFG_RST__SHIFT     (7U)
/*! SMU1_CFG_RST_ - SW reset for smu1 reg */
#define CIU1_CIU_RST_SW5_SMU1_CFG_RST_(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW5_SMU1_CFG_RST__SHIFT)) & CIU1_CIU_RST_SW5_SMU1_CFG_RST__MASK)

#define CIU1_CIU_RST_SW5_SMU1_UNGATED_CLK_RST__MASK (0x100U)
#define CIU1_CIU_RST_SW5_SMU1_UNGATED_CLK_RST__SHIFT (8U)
/*! SMU1_UNGATED_CLK_RST_ - SW reset for the NIC of smu1 */
#define CIU1_CIU_RST_SW5_SMU1_UNGATED_CLK_RST_(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW5_SMU1_UNGATED_CLK_RST__SHIFT)) & CIU1_CIU_RST_SW5_SMU1_UNGATED_CLK_RST__MASK)

#define CIU1_CIU_RST_SW5_GPS_PPS_RST__MASK       (0x200U)
#define CIU1_CIU_RST_SW5_GPS_PPS_RST__SHIFT      (9U)
/*! GPS_PPS_RST_ - SW Reset for the gps pss */
#define CIU1_CIU_RST_SW5_GPS_PPS_RST_(x)         (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW5_GPS_PPS_RST__SHIFT)) & CIU1_CIU_RST_SW5_GPS_PPS_RST__MASK)

#define CIU1_CIU_RST_SW5_MCI_WL_A2A_MHRESETN_MASK (0x400U)
#define CIU1_CIU_RST_SW5_MCI_WL_A2A_MHRESETN_SHIFT (10U)
/*! MCI_WL_A2A_MHRESETN - SW Reset for mci_wl_a2a_mhresetn */
#define CIU1_CIU_RST_SW5_MCI_WL_A2A_MHRESETN(x)  (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW5_MCI_WL_A2A_MHRESETN_SHIFT)) & CIU1_CIU_RST_SW5_MCI_WL_A2A_MHRESETN_MASK)

#define CIU1_CIU_RST_SW5_PTP_RST__MASK           (0x800U)
#define CIU1_CIU_RST_SW5_PTP_RST__SHIFT          (11U)
/*! PTP_RST_ - SW reset for ptp input capture logic */
#define CIU1_CIU_RST_SW5_PTP_RST_(x)             (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_SW5_PTP_RST__SHIFT)) & CIU1_CIU_RST_SW5_PTP_RST__MASK)
/*! @} */

/*! @name CIU_RST_ECO_CTRL - Reset ECO Control */
/*! @{ */

#define CIU1_CIU_RST_ECO_CTRL_ECO_BITS_MASK      (0xFFFFFFFFU)
#define CIU1_CIU_RST_ECO_CTRL_ECO_BITS_SHIFT     (0U)
/*! ECO_BITS - ECO Bits */
#define CIU1_CIU_RST_ECO_CTRL_ECO_BITS(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_RST_ECO_CTRL_ECO_BITS_SHIFT)) & CIU1_CIU_RST_ECO_CTRL_ECO_BITS_MASK)
/*! @} */

/*! @name CIU_MEM_WRTC2 - Memory WRTC Control2 */
/*! @{ */

#define CIU1_CIU_MEM_WRTC2_SMU1_RTC_MASK         (0x3000U)
#define CIU1_CIU_MEM_WRTC2_SMU1_RTC_SHIFT        (12U)
/*! SMU1_RTC - SMU1 SEG1 RTC */
#define CIU1_CIU_MEM_WRTC2_SMU1_RTC(x)           (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC2_SMU1_RTC_SHIFT)) & CIU1_CIU_MEM_WRTC2_SMU1_RTC_MASK)

#define CIU1_CIU_MEM_WRTC2_SMU1_WTC_MASK         (0xC000U)
#define CIU1_CIU_MEM_WRTC2_SMU1_WTC_SHIFT        (14U)
/*! SMU1_WTC - SMU1 SEG1 WTC */
#define CIU1_CIU_MEM_WRTC2_SMU1_WTC(x)           (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC2_SMU1_WTC_SHIFT)) & CIU1_CIU_MEM_WRTC2_SMU1_WTC_MASK)

#define CIU1_CIU_MEM_WRTC2_R1P_RTC_MASK          (0x30000U)
#define CIU1_CIU_MEM_WRTC2_R1P_RTC_SHIFT         (16U)
/*! R1P_RTC - Small Single Port SRAM RTC */
#define CIU1_CIU_MEM_WRTC2_R1P_RTC(x)            (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC2_R1P_RTC_SHIFT)) & CIU1_CIU_MEM_WRTC2_R1P_RTC_MASK)

#define CIU1_CIU_MEM_WRTC2_R1P_WTC_MASK          (0xC0000U)
#define CIU1_CIU_MEM_WRTC2_R1P_WTC_SHIFT         (18U)
/*! R1P_WTC - Small Single Port SRAM WTC */
#define CIU1_CIU_MEM_WRTC2_R1P_WTC(x)            (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC2_R1P_WTC_SHIFT)) & CIU1_CIU_MEM_WRTC2_R1P_WTC_MASK)

#define CIU1_CIU_MEM_WRTC2_R2P_RTC_MASK          (0x300000U)
#define CIU1_CIU_MEM_WRTC2_R2P_RTC_SHIFT         (20U)
/*! R2P_RTC - Small Dual Port SRAM RTC */
#define CIU1_CIU_MEM_WRTC2_R2P_RTC(x)            (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC2_R2P_RTC_SHIFT)) & CIU1_CIU_MEM_WRTC2_R2P_RTC_MASK)

#define CIU1_CIU_MEM_WRTC2_R2P_WTC_MASK          (0xC00000U)
#define CIU1_CIU_MEM_WRTC2_R2P_WTC_SHIFT         (22U)
/*! R2P_WTC - Small Dual Port SRAM WTC */
#define CIU1_CIU_MEM_WRTC2_R2P_WTC(x)            (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC2_R2P_WTC_SHIFT)) & CIU1_CIU_MEM_WRTC2_R2P_WTC_MASK)

#define CIU1_CIU_MEM_WRTC2_SMU1_SEG0_RTC_MASK    (0xC000000U)
#define CIU1_CIU_MEM_WRTC2_SMU1_SEG0_RTC_SHIFT   (26U)
/*! SMU1_SEG0_RTC - SMU1 SEG0 RTC */
#define CIU1_CIU_MEM_WRTC2_SMU1_SEG0_RTC(x)      (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC2_SMU1_SEG0_RTC_SHIFT)) & CIU1_CIU_MEM_WRTC2_SMU1_SEG0_RTC_MASK)

#define CIU1_CIU_MEM_WRTC2_SMU1_SEG0_WTC_MASK    (0xC0000000U)
#define CIU1_CIU_MEM_WRTC2_SMU1_SEG0_WTC_SHIFT   (30U)
/*! SMU1_SEG0_WTC - SMU1 SEG0 WTC */
#define CIU1_CIU_MEM_WRTC2_SMU1_SEG0_WTC(x)      (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC2_SMU1_SEG0_WTC_SHIFT)) & CIU1_CIU_MEM_WRTC2_SMU1_SEG0_WTC_MASK)
/*! @} */

/*! @name CIU_MEM_WRTC3 - Memory WRTC Control 3 */
/*! @{ */

#define CIU1_CIU_MEM_WRTC3_WEU_ROM_RTC_MASK      (0x7U)
#define CIU1_CIU_MEM_WRTC3_WEU_ROM_RTC_SHIFT     (0U)
/*! WEU_ROM_RTC - WEU 256x15 ROM RTC */
#define CIU1_CIU_MEM_WRTC3_WEU_ROM_RTC(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_WEU_ROM_RTC_SHIFT)) & CIU1_CIU_MEM_WRTC3_WEU_ROM_RTC_MASK)

#define CIU1_CIU_MEM_WRTC3_WEU_ROM_RTC_REF_MASK  (0x30U)
#define CIU1_CIU_MEM_WRTC3_WEU_ROM_RTC_REF_SHIFT (4U)
/*! WEU_ROM_RTC_REF - WEU 256x16 ROM RTC_REF */
#define CIU1_CIU_MEM_WRTC3_WEU_ROM_RTC_REF(x)    (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_WEU_ROM_RTC_REF_SHIFT)) & CIU1_CIU_MEM_WRTC3_WEU_ROM_RTC_REF_MASK)

#define CIU1_CIU_MEM_WRTC3_CPU1_ITCM_RTC_MASK    (0xC0U)
#define CIU1_CIU_MEM_WRTC3_CPU1_ITCM_RTC_SHIFT   (6U)
/*! CPU1_ITCM_RTC - CPU1 ITCM RTC */
#define CIU1_CIU_MEM_WRTC3_CPU1_ITCM_RTC(x)      (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_CPU1_ITCM_RTC_SHIFT)) & CIU1_CIU_MEM_WRTC3_CPU1_ITCM_RTC_MASK)

#define CIU1_CIU_MEM_WRTC3_CPU1_ITCM_WTC_MASK    (0x300U)
#define CIU1_CIU_MEM_WRTC3_CPU1_ITCM_WTC_SHIFT   (8U)
/*! CPU1_ITCM_WTC - CPU1 ITCM WTC */
#define CIU1_CIU_MEM_WRTC3_CPU1_ITCM_WTC(x)      (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_CPU1_ITCM_WTC_SHIFT)) & CIU1_CIU_MEM_WRTC3_CPU1_ITCM_WTC_MASK)

#define CIU1_CIU_MEM_WRTC3_CPU1_DTCM_RTC_MASK    (0xC00U)
#define CIU1_CIU_MEM_WRTC3_CPU1_DTCM_RTC_SHIFT   (10U)
/*! CPU1_DTCM_RTC - CPU1 DTCM RTC */
#define CIU1_CIU_MEM_WRTC3_CPU1_DTCM_RTC(x)      (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_CPU1_DTCM_RTC_SHIFT)) & CIU1_CIU_MEM_WRTC3_CPU1_DTCM_RTC_MASK)

#define CIU1_CIU_MEM_WRTC3_CPU1_DTCM_WTC_MASK    (0x3000U)
#define CIU1_CIU_MEM_WRTC3_CPU1_DTCM_WTC_SHIFT   (12U)
/*! CPU1_DTCM_WTC - CPU1 DTCM WTC */
#define CIU1_CIU_MEM_WRTC3_CPU1_DTCM_WTC(x)      (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_CPU1_DTCM_WTC_SHIFT)) & CIU1_CIU_MEM_WRTC3_CPU1_DTCM_WTC_MASK)

#define CIU1_CIU_MEM_WRTC3_CPU1_ROM_RTC_MASK     (0x1C000U)
#define CIU1_CIU_MEM_WRTC3_CPU1_ROM_RTC_SHIFT    (14U)
/*! CPU1_ROM_RTC - CPU1 ROM RTC */
#define CIU1_CIU_MEM_WRTC3_CPU1_ROM_RTC(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_CPU1_ROM_RTC_SHIFT)) & CIU1_CIU_MEM_WRTC3_CPU1_ROM_RTC_MASK)

#define CIU1_CIU_MEM_WRTC3_CPU1_ROM_RTC_REF_MASK (0x60000U)
#define CIU1_CIU_MEM_WRTC3_CPU1_ROM_RTC_REF_SHIFT (17U)
/*! CPU1_ROM_RTC_REF - Cpu1 ROM RTC_REF */
#define CIU1_CIU_MEM_WRTC3_CPU1_ROM_RTC_REF(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_CPU1_ROM_RTC_REF_SHIFT)) & CIU1_CIU_MEM_WRTC3_CPU1_ROM_RTC_REF_MASK)

#define CIU1_CIU_MEM_WRTC3_IPS_IRAM_RTC_MASK     (0x180000U)
#define CIU1_CIU_MEM_WRTC3_IPS_IRAM_RTC_SHIFT    (19U)
/*! IPS_IRAM_RTC - IPS IRAM RTC */
#define CIU1_CIU_MEM_WRTC3_IPS_IRAM_RTC(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_IPS_IRAM_RTC_SHIFT)) & CIU1_CIU_MEM_WRTC3_IPS_IRAM_RTC_MASK)

#define CIU1_CIU_MEM_WRTC3_IPS_IRAM_WTC_MASK     (0x600000U)
#define CIU1_CIU_MEM_WRTC3_IPS_IRAM_WTC_SHIFT    (21U)
/*! IPS_IRAM_WTC - IPS IRAM WTC */
#define CIU1_CIU_MEM_WRTC3_IPS_IRAM_WTC(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_IPS_IRAM_WTC_SHIFT)) & CIU1_CIU_MEM_WRTC3_IPS_IRAM_WTC_MASK)

#define CIU1_CIU_MEM_WRTC3_IPS_PRAM_RTC_MASK     (0x1800000U)
#define CIU1_CIU_MEM_WRTC3_IPS_PRAM_RTC_SHIFT    (23U)
/*! IPS_PRAM_RTC - IPS PRAM RTC */
#define CIU1_CIU_MEM_WRTC3_IPS_PRAM_RTC(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_IPS_PRAM_RTC_SHIFT)) & CIU1_CIU_MEM_WRTC3_IPS_PRAM_RTC_MASK)

#define CIU1_CIU_MEM_WRTC3_IPS_PRAM_WTC_MASK     (0x6000000U)
#define CIU1_CIU_MEM_WRTC3_IPS_PRAM_WTC_SHIFT    (25U)
/*! IPS_PRAM_WTC - IPS PRAM WTC */
#define CIU1_CIU_MEM_WRTC3_IPS_PRAM_WTC(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_IPS_PRAM_WTC_SHIFT)) & CIU1_CIU_MEM_WRTC3_IPS_PRAM_WTC_MASK)

#define CIU1_CIU_MEM_WRTC3_IPS_PROM_RTC_MASK     (0x38000000U)
#define CIU1_CIU_MEM_WRTC3_IPS_PROM_RTC_SHIFT    (27U)
/*! IPS_PROM_RTC - IPS PROM RTC */
#define CIU1_CIU_MEM_WRTC3_IPS_PROM_RTC(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_IPS_PROM_RTC_SHIFT)) & CIU1_CIU_MEM_WRTC3_IPS_PROM_RTC_MASK)

#define CIU1_CIU_MEM_WRTC3_IPS_PROM_RTC_REF_MASK (0xC0000000U)
#define CIU1_CIU_MEM_WRTC3_IPS_PROM_RTC_REF_SHIFT (30U)
/*! IPS_PROM_RTC_REF - IPS PROM RTC_REF */
#define CIU1_CIU_MEM_WRTC3_IPS_PROM_RTC_REF(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_WRTC3_IPS_PROM_RTC_REF_SHIFT)) & CIU1_CIU_MEM_WRTC3_IPS_PROM_RTC_REF_MASK)
/*! @} */

/*! @name CIU_MEM_CTRL - Memory Control */
/*! @{ */

#define CIU1_CIU_MEM_CTRL_SMU1_DEBUG_ON_MASK     (0x20U)
#define CIU1_CIU_MEM_CTRL_SMU1_DEBUG_ON_SHIFT    (5U)
/*! SMU1_DEBUG_ON - 1= enable smu internal register latch for debug */
#define CIU1_CIU_MEM_CTRL_SMU1_DEBUG_ON(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_CTRL_SMU1_DEBUG_ON_SHIFT)) & CIU1_CIU_MEM_CTRL_SMU1_DEBUG_ON_MASK)
/*! @} */

/*! @name CIU_SMU1_DBG_STAT0 - SMU1 debug register0 */
/*! @{ */

#define CIU1_CIU_SMU1_DBG_STAT0_SMU1_DBG_STAT0_MASK (0xFFFFFFFFU)
#define CIU1_CIU_SMU1_DBG_STAT0_SMU1_DBG_STAT0_SHIFT (0U)
/*! SMU1_DBG_STAT0 - smu1 debug addr output */
#define CIU1_CIU_SMU1_DBG_STAT0_SMU1_DBG_STAT0(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_SMU1_DBG_STAT0_SMU1_DBG_STAT0_SHIFT)) & CIU1_CIU_SMU1_DBG_STAT0_SMU1_DBG_STAT0_MASK)
/*! @} */

/*! @name CIU_SMU1_DBG_STAT1 - SMU1 debug register1 */
/*! @{ */

#define CIU1_CIU_SMU1_DBG_STAT1_SMU1_DBG_STAT1_MASK (0xFFFFFFFFU)
#define CIU1_CIU_SMU1_DBG_STAT1_SMU1_DBG_STAT1_SHIFT (0U)
/*! SMU1_DBG_STAT1 - smu1 debug data output */
#define CIU1_CIU_SMU1_DBG_STAT1_SMU1_DBG_STAT1(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_SMU1_DBG_STAT1_SMU1_DBG_STAT1_SHIFT)) & CIU1_CIU_SMU1_DBG_STAT1_SMU1_DBG_STAT1_MASK)
/*! @} */

/*! @name CIU_SMU1_DBG_STAT2 - SMU1 debug register2 */
/*! @{ */

#define CIU1_CIU_SMU1_DBG_STAT2_SMU1_DBG_STAT2_MASK (0xFFFFFFFFU)
#define CIU1_CIU_SMU1_DBG_STAT2_SMU1_DBG_STAT2_SHIFT (0U)
/*! SMU1_DBG_STAT2 - smu1 debug ctrl output */
#define CIU1_CIU_SMU1_DBG_STAT2_SMU1_DBG_STAT2(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_SMU1_DBG_STAT2_SMU1_DBG_STAT2_SHIFT)) & CIU1_CIU_SMU1_DBG_STAT2_SMU1_DBG_STAT2_MASK)
/*! @} */

/*! @name CIU_MEM_ECO_CTRL - Memory ECO Control */
/*! @{ */

#define CIU1_CIU_MEM_ECO_CTRL_ECO_BITS_MASK      (0xFFFFFFFFU)
#define CIU1_CIU_MEM_ECO_CTRL_ECO_BITS_SHIFT     (0U)
/*! ECO_BITS - Reserved for ECOs */
#define CIU1_CIU_MEM_ECO_CTRL_ECO_BITS(x)        (((uint32_t)(((uint32_t)(x)) << CIU1_CIU_MEM_ECO_CTRL_ECO_BITS_SHIFT)) & CIU1_CIU_MEM_ECO_CTRL_ECO_BITS_MASK)
/*! @} */

/*! @name CIU1_INT_MASK - CIU1 Interrupt Mask */
/*! @{ */

#define CIU1_CIU1_INT_MASK_PTP_INPUTCAPTURE_EVENT_INTR_MASK (0x2U)
#define CIU1_CIU1_INT_MASK_PTP_INPUTCAPTURE_EVENT_INTR_SHIFT (1U)
/*! PTP_INPUTCAPTURE_EVENT_INTR - PTP Input Capture Event Interrupt for Time Synchronization. In
 *    case of PTP mode input capture pulse from PAD or HMAC is used to latched PHC Value inside BBUD.
 *    On receiving this interrupt SW will read the PHC timestamp Value from BBUD register
 */
#define CIU1_CIU1_INT_MASK_PTP_INPUTCAPTURE_EVENT_INTR(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_PTP_INPUTCAPTURE_EVENT_INTR_SHIFT)) & CIU1_CIU1_INT_MASK_PTP_INPUTCAPTURE_EVENT_INTR_MASK)

#define CIU1_CIU1_INT_MASK_MCI_WL_WAKEUP_DONE_INT_MASK (0xCU)
#define CIU1_CIU1_INT_MASK_MCI_WL_WAKEUP_DONE_INT_SHIFT (2U)
/*! MCI_WL_WAKEUP_DONE_INT - Wake up Interrupt done, from MCI (CPU3) to WL (CPU1) */
#define CIU1_CIU1_INT_MASK_MCI_WL_WAKEUP_DONE_INT(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_MCI_WL_WAKEUP_DONE_INT_SHIFT)) & CIU1_CIU1_INT_MASK_MCI_WL_WAKEUP_DONE_INT_MASK)

#define CIU1_CIU1_INT_MASK_CPU1_TO_CPU3_MSG_DONE_MASK (0x10U)
#define CIU1_CIU1_INT_MASK_CPU1_TO_CPU3_MSG_DONE_SHIFT (4U)
/*! CPU1_TO_CPU3_MSG_DONE - CPU1 to CPU3 Message Done Interrupt. After CPU3 completed message
 *    processing requested by CPU1 it sends this interrupt to CPU1 by set 1 to CIU_CPU_CPU3_MSG_CTRL[8]
 */
#define CIU1_CIU1_INT_MASK_CPU1_TO_CPU3_MSG_DONE(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_CPU1_TO_CPU3_MSG_DONE_SHIFT)) & CIU1_CIU1_INT_MASK_CPU1_TO_CPU3_MSG_DONE_MASK)

#define CIU1_CIU1_INT_MASK_IMU13_CPU1_MSG_SPACE_AVAIL_IMU_MASK (0x20U)
#define CIU1_CIU1_INT_MASK_IMU13_CPU1_MSG_SPACE_AVAIL_IMU_SHIFT (5U)
/*! IMU13_CPU1_MSG_SPACE_AVAIL_IMU - CPU1 to CPU3 message FIFO space available for CPU1 to write more messages. (Not used) */
#define CIU1_CIU1_INT_MASK_IMU13_CPU1_MSG_SPACE_AVAIL_IMU(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_IMU13_CPU1_MSG_SPACE_AVAIL_IMU_SHIFT)) & CIU1_CIU1_INT_MASK_IMU13_CPU1_MSG_SPACE_AVAIL_IMU_MASK)

#define CIU1_CIU1_INT_MASK_CPU1_TO_CPU2_MSG_DONE_MASK (0x40U)
#define CIU1_CIU1_INT_MASK_CPU1_TO_CPU2_MSG_DONE_SHIFT (6U)
/*! CPU1_TO_CPU2_MSG_DONE - CPU1 to CPU2 Message Done Interrupt. After CPU2 completed message
 *    processing requested by CPU1 it sends this interrupt to CPU1 by set 1 to CIU_CPU_CPU2_MSG_CTRL[8]
 */
#define CIU1_CIU1_INT_MASK_CPU1_TO_CPU2_MSG_DONE(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_CPU1_TO_CPU2_MSG_DONE_SHIFT)) & CIU1_CIU1_INT_MASK_CPU1_TO_CPU2_MSG_DONE_MASK)

#define CIU1_CIU1_INT_MASK_IMU12_CPU1_MSG_SPACE_AVAIL_IMU_MASK (0x80U)
#define CIU1_CIU1_INT_MASK_IMU12_CPU1_MSG_SPACE_AVAIL_IMU_SHIFT (7U)
/*! IMU12_CPU1_MSG_SPACE_AVAIL_IMU - CPU1 to CPU2 message FIFO space available for CPU1 to write more messages.(Not used) */
#define CIU1_CIU1_INT_MASK_IMU12_CPU1_MSG_SPACE_AVAIL_IMU(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_IMU12_CPU1_MSG_SPACE_AVAIL_IMU_SHIFT)) & CIU1_CIU1_INT_MASK_IMU12_CPU1_MSG_SPACE_AVAIL_IMU_MASK)

#define CIU1_CIU1_INT_MASK_RFU_INT_2G_MASK       (0x100U)
#define CIU1_CIU1_INT_MASK_RFU_INT_2G_SHIFT      (8U)
/*! RFU_INT_2G - RFU2G interrupt */
#define CIU1_CIU1_INT_MASK_RFU_INT_2G(x)         (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_RFU_INT_2G_SHIFT)) & CIU1_CIU1_INT_MASK_RFU_INT_2G_MASK)

#define CIU1_CIU1_INT_MASK_RFU_INT_5G_A_MASK     (0x200U)
#define CIU1_CIU1_INT_MASK_RFU_INT_5G_A_SHIFT    (9U)
/*! RFU_INT_5G_A - RFU5G channel A interrupt */
#define CIU1_CIU1_INT_MASK_RFU_INT_5G_A(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_RFU_INT_5G_A_SHIFT)) & CIU1_CIU1_INT_MASK_RFU_INT_5G_A_MASK)

#define CIU1_CIU1_INT_MASK_GPS_INTR_CH_SW_EARLY_MASK (0x400U)
#define CIU1_CIU1_INT_MASK_GPS_INTR_CH_SW_EARLY_SHIFT (10U)
/*! GPS_INTR_CH_SW_EARLY - GPS PPS timer early interrupt */
#define CIU1_CIU1_INT_MASK_GPS_INTR_CH_SW_EARLY(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_GPS_INTR_CH_SW_EARLY_SHIFT)) & CIU1_CIU1_INT_MASK_GPS_INTR_CH_SW_EARLY_MASK)

#define CIU1_CIU1_INT_MASK_GPS_INTR_CH_SW_MASK   (0x800U)
#define CIU1_CIU1_INT_MASK_GPS_INTR_CH_SW_SHIFT  (11U)
/*! GPS_INTR_CH_SW - GPS PPS timer interrupt */
#define CIU1_CIU1_INT_MASK_GPS_INTR_CH_SW(x)     (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_GPS_INTR_CH_SW_SHIFT)) & CIU1_CIU1_INT_MASK_GPS_INTR_CH_SW_MASK)

#define CIU1_CIU1_INT_MASK_APU_INTR_BT_WAKEUP_MASK (0x1000U)
#define CIU1_CIU1_INT_MASK_APU_INTR_BT_WAKEUP_SHIFT (12U)
/*! APU_INTR_BT_WAKEUP - APU BT interrupt. This bit indicates that the BTU has encountered some
 *    event during hardware sleep and would like the firmware to intervene. During BT wake time, this
 *    interrupt path should not be taken. Refer to APU doc for more details on the sleep/wakeup
 *    interrupt split.
 */
#define CIU1_CIU1_INT_MASK_APU_INTR_BT_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_APU_INTR_BT_WAKEUP_SHIFT)) & CIU1_CIU1_INT_MASK_APU_INTR_BT_WAKEUP_MASK)

#define CIU1_CIU1_INT_MASK_APU_INTR_WLAN_WAKEUP1_MASK (0x2000U)
#define CIU1_CIU1_INT_MASK_APU_INTR_WLAN_WAKEUP1_SHIFT (13U)
/*! APU_INTR_WLAN_WAKEUP1 - APU WLAN1 interrupt. This bit indicates that the WLAN hardware needs to
 *    wakeup for an incoming beacon. During WLAN wake time, this interrupt path should not be taken.
 *    Refer to APU doc for more details on the sleep/wakeup interrupt split.
 */
#define CIU1_CIU1_INT_MASK_APU_INTR_WLAN_WAKEUP1(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_APU_INTR_WLAN_WAKEUP1_SHIFT)) & CIU1_CIU1_INT_MASK_APU_INTR_WLAN_WAKEUP1_MASK)

#define CIU1_CIU1_INT_MASK_APU_INTR_GEN_TIMER_WAKEUP_MASK (0x4000U)
#define CIU1_CIU1_INT_MASK_APU_INTR_GEN_TIMER_WAKEUP_SHIFT (14U)
/*! APU_INTR_GEN_TIMER_WAKEUP - APU beacon Timer wakeup interrupt */
#define CIU1_CIU1_INT_MASK_APU_INTR_GEN_TIMER_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_APU_INTR_GEN_TIMER_WAKEUP_SHIFT)) & CIU1_CIU1_INT_MASK_APU_INTR_GEN_TIMER_WAKEUP_MASK)

#define CIU1_CIU1_INT_MASK_APU_INTR_WAKEUP_MASK  (0x8000U)
#define CIU1_CIU1_INT_MASK_APU_INTR_WAKEUP_SHIFT (15U)
/*! APU_INTR_WAKEUP - APU default interrupt. The purpose of this interrupt is to catch any erroneous
 *    host wakeup case. In the event of an erroneous host wakeup, it is possible that the host
 *    wakeup interrupt will not assert. In order to ensure that the APU does not get stuck in some
 *    unknown state, this dummy interrupt will be thrown in it's place. Firmware should only care about
 *    this bit if no other interrupts are set in this register.
 */
#define CIU1_CIU1_INT_MASK_APU_INTR_WAKEUP(x)    (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_APU_INTR_WAKEUP_SHIFT)) & CIU1_CIU1_INT_MASK_APU_INTR_WAKEUP_MASK)

#define CIU1_CIU1_INT_MASK_APU_INTR_HOST_WAKEUP_MASK (0xFFFF0000U)
#define CIU1_CIU1_INT_MASK_APU_INTR_HOST_WAKEUP_SHIFT (16U)
/*! APU_INTR_HOST_WAKEUP - APU Host wakeup interrupt */
#define CIU1_CIU1_INT_MASK_APU_INTR_HOST_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_MASK_APU_INTR_HOST_WAKEUP_SHIFT)) & CIU1_CIU1_INT_MASK_APU_INTR_HOST_WAKEUP_MASK)
/*! @} */

/*! @name CIU1_INT_SELECT - CIU1 Interrupt Select */
/*! @{ */

#define CIU1_CIU1_INT_SELECT_SEL_MASK            (0xFFFFFFFFU)
#define CIU1_CIU1_INT_SELECT_SEL_SHIFT           (0U)
/*! SEL - Interrupt Read/Write Clear for CIU1 Interrupts */
#define CIU1_CIU1_INT_SELECT_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_SELECT_SEL_SHIFT)) & CIU1_CIU1_INT_SELECT_SEL_MASK)
/*! @} */

/*! @name CIU1_INT_EVENT_MASK - CIU1 Interrupt Event Mask */
/*! @{ */

#define CIU1_CIU1_INT_EVENT_MASK_PTP_INPUTCAPTURE_EVENT_INTR_MASK (0x2U)
#define CIU1_CIU1_INT_EVENT_MASK_PTP_INPUTCAPTURE_EVENT_INTR_SHIFT (1U)
/*! PTP_INPUTCAPTURE_EVENT_INTR - PTP Input Capture Event Interrupt for Time Synchronization. In
 *    case of PTP mode input capture pulse from PAD or HMAC is used to latched PHC Value inside BBUD.
 *    On receiving this interrupt SW will read the PHC timestamp Value from BBUD register
 */
#define CIU1_CIU1_INT_EVENT_MASK_PTP_INPUTCAPTURE_EVENT_INTR(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_PTP_INPUTCAPTURE_EVENT_INTR_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_PTP_INPUTCAPTURE_EVENT_INTR_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_MCI_WL_WAKEUP_DONE_INT_MASK (0xCU)
#define CIU1_CIU1_INT_EVENT_MASK_MCI_WL_WAKEUP_DONE_INT_SHIFT (2U)
/*! MCI_WL_WAKEUP_DONE_INT - Wake up Interrupt done, from MCI (CPU3) to WL (CPU1) */
#define CIU1_CIU1_INT_EVENT_MASK_MCI_WL_WAKEUP_DONE_INT(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_MCI_WL_WAKEUP_DONE_INT_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_MCI_WL_WAKEUP_DONE_INT_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_CPU1_TO_CPU3_MSG_DONE_MASK (0x10U)
#define CIU1_CIU1_INT_EVENT_MASK_CPU1_TO_CPU3_MSG_DONE_SHIFT (4U)
/*! CPU1_TO_CPU3_MSG_DONE - CPU1 to CPU3 Message Done Interrupt. After CPU3 completed message
 *    processing requested by CPU1 it sends this interrupt to CPU1 by set 1 to CIU_CPU_CPU3_MSG_CTRL[8]
 */
#define CIU1_CIU1_INT_EVENT_MASK_CPU1_TO_CPU3_MSG_DONE(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_CPU1_TO_CPU3_MSG_DONE_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_CPU1_TO_CPU3_MSG_DONE_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_IMU13_CPU1_MSG_SPACE_AVAIL_IMU_MASK (0x20U)
#define CIU1_CIU1_INT_EVENT_MASK_IMU13_CPU1_MSG_SPACE_AVAIL_IMU_SHIFT (5U)
/*! IMU13_CPU1_MSG_SPACE_AVAIL_IMU - CPU1 to CPU3 message FIFO space available for CPU1 to write more messages. (Not used) */
#define CIU1_CIU1_INT_EVENT_MASK_IMU13_CPU1_MSG_SPACE_AVAIL_IMU(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_IMU13_CPU1_MSG_SPACE_AVAIL_IMU_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_IMU13_CPU1_MSG_SPACE_AVAIL_IMU_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_CPU1_TO_CPU2_MSG_DONE_MASK (0x40U)
#define CIU1_CIU1_INT_EVENT_MASK_CPU1_TO_CPU2_MSG_DONE_SHIFT (6U)
/*! CPU1_TO_CPU2_MSG_DONE - CPU1 to CPU2 Message Done Interrupt. After CPU2 completed message
 *    processing requested by CPU1 it sends this interrupt to CPU1 by set 1 to CIU_CPU_CPU2_MSG_CTRL[8]
 */
#define CIU1_CIU1_INT_EVENT_MASK_CPU1_TO_CPU2_MSG_DONE(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_CPU1_TO_CPU2_MSG_DONE_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_CPU1_TO_CPU2_MSG_DONE_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_IMU12_CPU1_MSG_SPACE_AVAIL_IMU_MASK (0x80U)
#define CIU1_CIU1_INT_EVENT_MASK_IMU12_CPU1_MSG_SPACE_AVAIL_IMU_SHIFT (7U)
/*! IMU12_CPU1_MSG_SPACE_AVAIL_IMU - CPU1 to CPU2 message FIFO space available for CPU1 to write more messages.(Not used) */
#define CIU1_CIU1_INT_EVENT_MASK_IMU12_CPU1_MSG_SPACE_AVAIL_IMU(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_IMU12_CPU1_MSG_SPACE_AVAIL_IMU_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_IMU12_CPU1_MSG_SPACE_AVAIL_IMU_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_RFU_INT_2G_MASK (0x100U)
#define CIU1_CIU1_INT_EVENT_MASK_RFU_INT_2G_SHIFT (8U)
/*! RFU_INT_2G - RFU2G interrupt */
#define CIU1_CIU1_INT_EVENT_MASK_RFU_INT_2G(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_RFU_INT_2G_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_RFU_INT_2G_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_RFU_INT_5G_A_MASK (0x200U)
#define CIU1_CIU1_INT_EVENT_MASK_RFU_INT_5G_A_SHIFT (9U)
/*! RFU_INT_5G_A - RFU5G channel A interrupt */
#define CIU1_CIU1_INT_EVENT_MASK_RFU_INT_5G_A(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_RFU_INT_5G_A_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_RFU_INT_5G_A_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_GPS_INTR_CH_SW_EARLY_MASK (0x400U)
#define CIU1_CIU1_INT_EVENT_MASK_GPS_INTR_CH_SW_EARLY_SHIFT (10U)
/*! GPS_INTR_CH_SW_EARLY - GPS PPS timer early interrupt */
#define CIU1_CIU1_INT_EVENT_MASK_GPS_INTR_CH_SW_EARLY(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_GPS_INTR_CH_SW_EARLY_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_GPS_INTR_CH_SW_EARLY_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_GPS_INTR_CH_SW_MASK (0x800U)
#define CIU1_CIU1_INT_EVENT_MASK_GPS_INTR_CH_SW_SHIFT (11U)
/*! GPS_INTR_CH_SW - GPS PPS timer interrupt */
#define CIU1_CIU1_INT_EVENT_MASK_GPS_INTR_CH_SW(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_GPS_INTR_CH_SW_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_GPS_INTR_CH_SW_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_BT_WAKEUP_MASK (0x1000U)
#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_BT_WAKEUP_SHIFT (12U)
/*! APU_INTR_BT_WAKEUP - APU BT interrupt. This bit indicates that the BTU has encountered some
 *    event during hardware sleep and would like the firmware to intervene. During BT wake time, this
 *    interrupt path should not be taken. Refer to APU doc for more details on the sleep/wakeup
 *    interrupt split.
 */
#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_BT_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_APU_INTR_BT_WAKEUP_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_APU_INTR_BT_WAKEUP_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_WLAN_WAKEUP1_MASK (0x2000U)
#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_WLAN_WAKEUP1_SHIFT (13U)
/*! APU_INTR_WLAN_WAKEUP1 - APU WLAN1 interrupt. This bit indicates that the WLAN hardware needs to
 *    wakeup for an incoming beacon. During WLAN wake time, this interrupt path should not be taken.
 *    Refer to APU doc for more details on the sleep/wakeup interrupt split.
 */
#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_WLAN_WAKEUP1(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_APU_INTR_WLAN_WAKEUP1_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_APU_INTR_WLAN_WAKEUP1_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_GEN_TIMER_WAKEUP_MASK (0x4000U)
#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_GEN_TIMER_WAKEUP_SHIFT (14U)
/*! APU_INTR_GEN_TIMER_WAKEUP - APU beacon Timer wakeup interrupt */
#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_GEN_TIMER_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_APU_INTR_GEN_TIMER_WAKEUP_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_APU_INTR_GEN_TIMER_WAKEUP_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_WAKEUP_MASK (0x8000U)
#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_WAKEUP_SHIFT (15U)
/*! APU_INTR_WAKEUP - APU default interrupt. The purpose of this interrupt is to catch any erroneous
 *    host wakeup case. In the event of an erroneous host wakeup, it is possible that the host
 *    wakeup interrupt will not assert. In order to ensure that the APU does not get stuck in some
 *    unknown state, this dummy interrupt will be thrown in it's place. Firmware should only care about
 *    this bit if no other interrupts are set in this register.
 */
#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_APU_INTR_WAKEUP_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_APU_INTR_WAKEUP_MASK)

#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_HOST_WAKEUP_MASK (0xFFFF0000U)
#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_HOST_WAKEUP_SHIFT (16U)
/*! APU_INTR_HOST_WAKEUP - APU Host wakeup interrupt */
#define CIU1_CIU1_INT_EVENT_MASK_APU_INTR_HOST_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_EVENT_MASK_APU_INTR_HOST_WAKEUP_SHIFT)) & CIU1_CIU1_INT_EVENT_MASK_APU_INTR_HOST_WAKEUP_MASK)
/*! @} */

/*! @name CIU1_INT_STATUS - CIU1 Interrupt Status */
/*! @{ */

#define CIU1_CIU1_INT_STATUS_PTP_INPUTCAPTURE_EVENT_INTR_MASK (0x2U)
#define CIU1_CIU1_INT_STATUS_PTP_INPUTCAPTURE_EVENT_INTR_SHIFT (1U)
/*! PTP_INPUTCAPTURE_EVENT_INTR - PTP Input Capture Event Interrupt for Time Synchronization. In
 *    case of PTP mode input capture pulse from PAD or HMAC is used to latched PHC Value inside BBUD.
 *    On receiving this interrupt SW will read the PHC timestamp Value from BBUD register
 */
#define CIU1_CIU1_INT_STATUS_PTP_INPUTCAPTURE_EVENT_INTR(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_STATUS_PTP_INPUTCAPTURE_EVENT_INTR_SHIFT)) & CIU1_CIU1_INT_STATUS_PTP_INPUTCAPTURE_EVENT_INTR_MASK)

#define CIU1_CIU1_INT_STATUS_MCI_WL_WAKEUP_DONE_INT_MASK (0xCU)
#define CIU1_CIU1_INT_STATUS_MCI_WL_WAKEUP_DONE_INT_SHIFT (2U)
/*! MCI_WL_WAKEUP_DONE_INT - Wake up Interrupt done, from MCI (CPU3) to WL (CPU1) */
#define CIU1_CIU1_INT_STATUS_MCI_WL_WAKEUP_DONE_INT(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_STATUS_MCI_WL_WAKEUP_DONE_INT_SHIFT)) & CIU1_CIU1_INT_STATUS_MCI_WL_WAKEUP_DONE_INT_MASK)

#define CIU1_CIU1_INT_STATUS_CPU1_TO_CPU3_MSG_DONE_MASK (0x10U)
#define CIU1_CIU1_INT_STATUS_CPU1_TO_CPU3_MSG_DONE_SHIFT (4U)
/*! CPU1_TO_CPU3_MSG_DONE - CPU1 to CPU3 Message Done Interrupt. After CPU3 completed message
 *    processing requested by CPU1 it sends this interrupt to CPU1 by set 1 to CIU_CPU_CPU3_MSG_CTRL[8]
 */
#define CIU1_CIU1_INT_STATUS_CPU1_TO_CPU3_MSG_DONE(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_STATUS_CPU1_TO_CPU3_MSG_DONE_SHIFT)) & CIU1_CIU1_INT_STATUS_CPU1_TO_CPU3_MSG_DONE_MASK)

#define CIU1_CIU1_INT_STATUS_IMU13_CPU1_MSG_SPACE_AVAIL_IMU_MASK (0x20U)
#define CIU1_CIU1_INT_STATUS_IMU13_CPU1_MSG_SPACE_AVAIL_IMU_SHIFT (5U)
/*! IMU13_CPU1_MSG_SPACE_AVAIL_IMU - CPU1 to CPU3 message FIFO space available for CPU1 to write more messages. (Not used) */
#define CIU1_CIU1_INT_STATUS_IMU13_CPU1_MSG_SPACE_AVAIL_IMU(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_STATUS_IMU13_CPU1_MSG_SPACE_AVAIL_IMU_SHIFT)) & CIU1_CIU1_INT_STATUS_IMU13_CPU1_MSG_SPACE_AVAIL_IMU_MASK)

#define CIU1_CIU1_INT_STATUS_CPU1_TO_CPU2_MSG_DONE_MASK (0x40U)
#define CIU1_CIU1_INT_STATUS_CPU1_TO_CPU2_MSG_DONE_SHIFT (6U)
/*! CPU1_TO_CPU2_MSG_DONE - CPU1 to CPU2 Message Done Interrupt. After CPU2 completed message
 *    processing requested by CPU1 it sends this interrupt to CPU1 by set 1 to CIU_CPU_CPU2_MSG_CTRL[8]
 */
#define CIU1_CIU1_INT_STATUS_CPU1_TO_CPU2_MSG_DONE(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_STATUS_CPU1_TO_CPU2_MSG_DONE_SHIFT)) & CIU1_CIU1_INT_STATUS_CPU1_TO_CPU2_MSG_DONE_MASK)

#define CIU1_CIU1_INT_STATUS_IMU12_CPU1_MSG_SPACE_AVAIL_IMU_MASK (0x80U)
#define CIU1_CIU1_INT_STATUS_IMU12_CPU1_MSG_SPACE_AVAIL_IMU_SHIFT (7U)
/*! IMU12_CPU1_MSG_SPACE_AVAIL_IMU - CPU1 to CPU2 message FIFO space available for CPU1 to write more messages.(Not used) */
#define CIU1_CIU1_INT_STATUS_IMU12_CPU1_MSG_SPACE_AVAIL_IMU(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_STATUS_IMU12_CPU1_MSG_SPACE_AVAIL_IMU_SHIFT)) & CIU1_CIU1_INT_STATUS_IMU12_CPU1_MSG_SPACE_AVAIL_IMU_MASK)

#define CIU1_CIU1_INT_STATUS_RFU_INT_2G_MASK     (0x100U)
#define CIU1_CIU1_INT_STATUS_RFU_INT_2G_SHIFT    (8U)
/*! RFU_INT_2G - RFU2G interrupt */
#define CIU1_CIU1_INT_STATUS_RFU_INT_2G(x)       (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_STATUS_RFU_INT_2G_SHIFT)) & CIU1_CIU1_INT_STATUS_RFU_INT_2G_MASK)

#define CIU1_CIU1_INT_STATUS_RFU_INT_5G_A_MASK   (0x200U)
#define CIU1_CIU1_INT_STATUS_RFU_INT_5G_A_SHIFT  (9U)
/*! RFU_INT_5G_A - RFU5G channel A interrupt */
#define CIU1_CIU1_INT_STATUS_RFU_INT_5G_A(x)     (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_STATUS_RFU_INT_5G_A_SHIFT)) & CIU1_CIU1_INT_STATUS_RFU_INT_5G_A_MASK)

#define CIU1_CIU1_INT_STATUS_GPS_INTR_CH_SW_EARLY_MASK (0x400U)
#define CIU1_CIU1_INT_STATUS_GPS_INTR_CH_SW_EARLY_SHIFT (10U)
/*! GPS_INTR_CH_SW_EARLY - GPS PPS timer early interrupt */
#define CIU1_CIU1_INT_STATUS_GPS_INTR_CH_SW_EARLY(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_STATUS_GPS_INTR_CH_SW_EARLY_SHIFT)) & CIU1_CIU1_INT_STATUS_GPS_INTR_CH_SW_EARLY_MASK)

#define CIU1_CIU1_INT_STATUS_GPS_INTR_CH_SW_MASK (0x800U)
#define CIU1_CIU1_INT_STATUS_GPS_INTR_CH_SW_SHIFT (11U)
/*! GPS_INTR_CH_SW - GPS PPS timer interrupt */
#define CIU1_CIU1_INT_STATUS_GPS_INTR_CH_SW(x)   (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_STATUS_GPS_INTR_CH_SW_SHIFT)) & CIU1_CIU1_INT_STATUS_GPS_INTR_CH_SW_MASK)

#define CIU1_CIU1_INT_STATUS_APU_INTR_BT_WAKEUP_MASK (0x1000U)
#define CIU1_CIU1_INT_STATUS_APU_INTR_BT_WAKEUP_SHIFT (12U)
/*! APU_INTR_BT_WAKEUP - APU BT interrupt. This bit indicates that the BTU has encountered some
 *    event during hardware sleep and would like the firmware to intervene. During BT wake time, this
 *    interrupt path should not be taken. Refer to APU doc for more details on the sleep/wakeup
 *    interrupt split.
 */
#define CIU1_CIU1_INT_STATUS_APU_INTR_BT_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_STATUS_APU_INTR_BT_WAKEUP_SHIFT)) & CIU1_CIU1_INT_STATUS_APU_INTR_BT_WAKEUP_MASK)

#define CIU1_CIU1_INT_STATUS_APU_INTR_WLAN_WAKEUP1_MASK (0x2000U)
#define CIU1_CIU1_INT_STATUS_APU_INTR_WLAN_WAKEUP1_SHIFT (13U)
/*! APU_INTR_WLAN_WAKEUP1 - APU WLAN1 interrupt. This bit indicates that the WLAN hardware needs to
 *    wakeup for an incoming beacon. During WLAN wake time, this interrupt path should not be taken.
 *    Refer to APU doc for more details on the sleep/wakeup interrupt split.
 */
#define CIU1_CIU1_INT_STATUS_APU_INTR_WLAN_WAKEUP1(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_STATUS_APU_INTR_WLAN_WAKEUP1_SHIFT)) & CIU1_CIU1_INT_STATUS_APU_INTR_WLAN_WAKEUP1_MASK)

#define CIU1_CIU1_INT_STATUS_APU_INTR_GEN_TIMER_WAKEUP_MASK (0x4000U)
#define CIU1_CIU1_INT_STATUS_APU_INTR_GEN_TIMER_WAKEUP_SHIFT (14U)
/*! APU_INTR_GEN_TIMER_WAKEUP - APU beacon Timer wakeup interrupt */
#define CIU1_CIU1_INT_STATUS_APU_INTR_GEN_TIMER_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << CIU1_CIU1_INT_STATUS_APU_INTR_GEN_TIMER_WAKEUP_SHIFT)) & CIU1_CIU1_INT_STATUS_APU_INT