
#ifndef KDOCTOOLS_EXPORT_H
#define KDOCTOOLS_EXPORT_H

#ifdef KDOCTOOLS_STATIC_DEFINE
#  define KDOCTOOLS_EXPORT
#  define KDOCTOOLS_NO_EXPORT
#else
#  ifndef KDOCTOOLS_EXPORT
#    ifdef KF6DocTools_EXPORTS
        /* We are building this library */
#      define KDOCTOOLS_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define KDOCTOOLS_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef KDOCTOOLS_NO_EXPORT
#    define KDOCTOOLS_NO_EXPORT 
#  endif
#endif

#ifndef KDOCTOOLS_DECL_DEPRECATED
#  define KDOCTOOLS_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef KDOCTOOLS_DECL_DEPRECATED_EXPORT
#  define KDOCTOOLS_DECL_DEPRECATED_EXPORT KDOCTOOLS_EXPORT KDOCTOOLS_DECL_DEPRECATED
#endif

#ifndef KDOCTOOLS_DECL_DEPRECATED_NO_EXPORT
#  define KDOCTOOLS_DECL_DEPRECATED_NO_EXPORT KDOCTOOLS_NO_EXPORT KDOCTOOLS_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KDOCTOOLS_NO_DEPRECATED
#    define KDOCTOOLS_NO_DEPRECATED
#  endif
#endif
#include <kdoctools_version.h>

#define KDOCTOOLS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KDOCTOOLS_NO_DEPRECATED) && !defined(KDOCTOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KDOCTOOLS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KDOCTOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KDOCTOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KDOCTOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KDOCTOOLS_NO_DEPRECATED_WARNINGS) && !defined(KDOCTOOLS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KDOCTOOLS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KDOCTOOLS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KDOCTOOLS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KDOCTOOLS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KDOCTOOLS_NO_DEPRECATED)
#  undef KDOCTOOLS_DEPRECATED
#  define KDOCTOOLS_DEPRECATED_EXPORT KDOCTOOLS_EXPORT
#  define KDOCTOOLS_DEPRECATED_NO_EXPORT KDOCTOOLS_NO_EXPORT
#elif defined(KDOCTOOLS_NO_DEPRECATED_WARNINGS)
#  define KDOCTOOLS_DEPRECATED
#  define KDOCTOOLS_DEPRECATED_EXPORT KDOCTOOLS_EXPORT
#  define KDOCTOOLS_DEPRECATED_NO_EXPORT KDOCTOOLS_NO_EXPORT
#else
#  define KDOCTOOLS_DEPRECATED KDOCTOOLS_DECL_DEPRECATED
#  define KDOCTOOLS_DEPRECATED_EXPORT KDOCTOOLS_DECL_DEPRECATED_EXPORT
#  define KDOCTOOLS_DEPRECATED_NO_EXPORT KDOCTOOLS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KDOCTOOLS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KDOCTOOLS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KDOCTOOLS_NO_DEPRECATED
#  define KDOCTOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT KDOCTOOLS_VERSION
#endif
#ifdef KDOCTOOLS_NO_DEPRECATED_WARNINGS
#  define KDOCTOOLS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KDOCTOOLS_DEPRECATED_WARNINGS_SINCE
#  ifdef KDOCTOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KDOCTOOLS_DEPRECATED_WARNINGS_SINCE KDOCTOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KDOCTOOLS_DEPRECATED_WARNINGS_SINCE KDOCTOOLS_VERSION
#  endif
#endif

#ifndef KDOCTOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KDOCTOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KDOCTOOLS_DEPRECATED
#  define KDOCTOOLS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KDOCTOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KDOCTOOLS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KDOCTOOLS_EXPORT_H */
