import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Text } from 'ink';
import { Colors } from '../colors.js';
import { CommandKind } from '../commands/types.js';
export const Help = ({ commands }) => (_jsxs(Box, { flexDirection: "column", marginBottom: 1, borderColor: Colors.Gray, borderStyle: "round", padding: 1, children: [_jsx(Text, { bold: true, color: Colors.Foreground, children: "Basics:" }), _jsxs(Text, { color: Colors.Foreground, children: [_jsx(Text, { bold: true, color: Colors.AccentPurple, children: "Add context" }), ": Use", ' ', _jsx(Text, { bold: true, color: Colors.AccentPurple, children: "@" }), ' ', "to specify files for context (e.g.,", ' ', _jsx(Text, { bold: true, color: Colors.AccentPurple, children: "@src/myFile.ts" }), ") to target specific files or folders."] }), _jsxs(Text, { color: Colors.Foreground, children: [_jsx(Text, { bold: true, color: Colors.AccentPurple, children: "Shell mode" }), ": Execute shell commands via", ' ', _jsx(Text, { bold: true, color: Colors.AccentPurple, children: "!" }), ' ', "(e.g.,", ' ', _jsx(Text, { bold: true, color: Colors.AccentPurple, children: "!npm run start" }), ") or use natural language (e.g.", ' ', _jsx(Text, { bold: true, color: Colors.AccentPurple, children: "start server" }), ")."] }), _jsx(Box, { height: 1 }), _jsx(Text, { bold: true, color: Colors.Foreground, children: "Commands:" }), commands
            .filter((command) => command.description && !command.hidden)
            .map((command) => (_jsxs(Box, { flexDirection: "column", children: [_jsxs(Text, { color: Colors.Foreground, children: [_jsxs(Text, { bold: true, color: Colors.AccentPurple, children: [' ', "/", command.name] }), command.kind === CommandKind.MCP_PROMPT && (_jsx(Text, { color: Colors.Gray, children: " [MCP]" })), command.description && ' - ' + command.description] }), command.subCommands &&
                    command.subCommands
                        .filter((subCommand) => !subCommand.hidden)
                        .map((subCommand) => (_jsxs(Text, { color: Colors.Foreground, children: [_jsxs(Text, { bold: true, color: Colors.AccentPurple, children: ['   ', subCommand.name] }), subCommand.description && ' - ' + subCommand.description] }, subCommand.name)))] }, command.name))), _jsxs(Text, { color: Colors.Foreground, children: [_jsxs(Text, { bold: true, color: Colors.AccentPurple, children: [' ', "!", ' '] }), "- shell command"] }), _jsxs(Text, { color: Colors.Foreground, children: [_jsx(Text, { color: Colors.Gray, children: "[MCP]" }), " - Model Context Protocol command (from external servers)"] }), _jsx(Box, { height: 1 }), _jsx(Text, { bold: true, color: Colors.Foreground, children: "Keyboard Shortcuts:" }), _jsxs(Text, { color: Colors.Foreground, children: [_jsx(Text, { bold: true, color: Colors.AccentPurple, children: "Alt+Left/Right" }), ' ', "- Jump through words in the input"] }), _jsxs(Text, { color: Colors.Foreground, children: [_jsx(Text, { bold: true, color: Colors.AccentPurple, children: "Ctrl+C" }), ' ', "- Quit application"] }), _jsxs(Text, { color: Colors.Foreground, children: [_jsx(Text, { bold: true, color: Colors.AccentPurple, children: process.platform === 'win32' ? 'Ctrl+Enter' : 'Ctrl+J' }), ' ', process.platform === 'linux'
                    ? '- New line (Alt+Enter works for certain linux distros)'
                    : '- New line'] }), _jsxs(Text, { color: Colors.Foreground, children: [_jsx(Text, { bold: true, color: Colors.AccentPurple, children: "Ctrl+L" }), ' ', "- Clear the screen"] }), _jsxs(Text, { color: Colors.Foreground, children: [_jsx(Text, { bold: true, color: Colors.AccentPurple, children: process.platform === 'darwin' ? 'Ctrl+X / Meta+Enter' : 'Ctrl+X' }), ' ', "- Open input in external editor"] }), _jsxs(Text, { color: Colors.Foreground, children: [_jsx(Text, { bold: true, color: Colors.AccentPurple, children: "Ctrl+Y" }), ' ', "- Toggle YOLO mode"] }), _jsxs(Text, { color: Colors.Foreground, children: [_jsx(Text, { bold: true, color: Colors.AccentPurple, children: "Enter" }), ' ', "- Send message"] }), _jsxs(Text, { color: Colors.Foreground, children: [_jsx(Text, { bold: true, color: Colors.AccentPurple, children: "Esc" }), ' ', "- Cancel operation / Clear input (double press)"] }), _jsxs(Text, { color: Colors.Foreground, children: [_jsx(Text, { bold: true, color: Colors.AccentPurple, children: "Shift+Tab" }), ' ', "- Toggle auto-accepting edits"] }), _jsxs(Text, { color: Colors.Foreground, children: [_jsx(Text, { bold: true, color: Colors.AccentPurple, children: "Up/Down" }), ' ', "- Cycle through your prompt history"] }), _jsx(Box, { height: 1 }), _jsxs(Text, { color: Colors.Foreground, children: ["For a full list of shortcuts, see", ' ', _jsx(Text, { bold: true, color: Colors.AccentPurple, children: "docs/keyboard-shortcuts.md" })] })] }));
//# sourceMappingURL=Help.js.map