// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Media_Effects_H
#define WINRT_Windows_Media_Effects_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Media.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Foundation.Numerics.2.h"
#include "winrt/impl/Windows.Graphics.DirectX.Direct3D11.2.h"
#include "winrt/impl/Windows.Media.2.h"
#include "winrt/impl/Windows.Media.Capture.2.h"
#include "winrt/impl/Windows.Media.Editing.2.h"
#include "winrt/impl/Windows.Media.MediaProperties.2.h"
#include "winrt/impl/Windows.Media.Playback.2.h"
#include "winrt/impl/Windows.Media.Render.2.h"
#include "winrt/impl/Windows.Media.Transcoding.2.h"
#include "winrt/impl/Windows.Storage.Streams.2.h"
#include "winrt/impl/Windows.UI.2.h"
#include "winrt/impl/Windows.Media.Effects.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Media_Effects_IAcousticEchoCancellationConfiguration<D>::SetEchoCancellationRenderEndpoint(param::hstring const& deviceId) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAcousticEchoCancellationConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAcousticEchoCancellationConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAcousticEchoCancellationConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetEchoCancellationRenderEndpoint(*(void**)(&deviceId)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAcousticEchoCancellationConfiguration>**)this;
            check_hresult(_winrt_abi_type->SetEchoCancellationRenderEndpoint(*(void**)(&deviceId)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioCaptureEffectsManager<D>::AudioCaptureEffectsChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Effects::AudioCaptureEffectsManager, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioCaptureEffectsManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioCaptureEffectsManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioCaptureEffectsManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_AudioCaptureEffectsChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioCaptureEffectsManager>**)this;
            check_hresult(_winrt_abi_type->add_AudioCaptureEffectsChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioCaptureEffectsManager<D>::AudioCaptureEffectsChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Effects::AudioCaptureEffectsManager, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, AudioCaptureEffectsChanged_revoker>(this, AudioCaptureEffectsChanged(handler));
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioCaptureEffectsManager<D>::AudioCaptureEffectsChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioCaptureEffectsManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioCaptureEffectsManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioCaptureEffectsManager>**)&_winrt_casted_result;
            _winrt_abi_type->remove_AudioCaptureEffectsChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioCaptureEffectsManager>**)this;
            _winrt_abi_type->remove_AudioCaptureEffectsChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioCaptureEffectsManager<D>::GetAudioCaptureEffects() const
    {
        void* effects{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioCaptureEffectsManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioCaptureEffectsManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioCaptureEffectsManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetAudioCaptureEffects(&effects));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioCaptureEffectsManager>**)this;
            check_hresult(_winrt_abi_type->GetAudioCaptureEffects(&effects));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Media::Effects::AudioEffect>{ effects, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioEffect<D>::AudioEffectType() const
    {
        winrt::Windows::Media::Effects::AudioEffectType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AudioEffectType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffect>**)this;
            check_hresult(_winrt_abi_type->get_AudioEffectType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioEffect2<D>::AcousticEchoCancellationConfiguration() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioEffect2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioEffect2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffect2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AcousticEchoCancellationConfiguration(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffect2>**)this;
            check_hresult(_winrt_abi_type->get_AcousticEchoCancellationConfiguration(&value));
        }
        return winrt::Windows::Media::Effects::AcousticEchoCancellationConfiguration{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioEffect2<D>::CanSetState() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioEffect2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioEffect2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffect2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanSetState(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffect2>**)this;
            check_hresult(_winrt_abi_type->get_CanSetState(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioEffect2<D>::State() const
    {
        winrt::Windows::Media::Effects::AudioEffectState value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioEffect2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioEffect2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffect2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_State(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffect2>**)this;
            check_hresult(_winrt_abi_type->get_State(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioEffect2<D>::SetState(winrt::Windows::Media::Effects::AudioEffectState const& newState) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioEffect2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioEffect2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffect2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetState(static_cast<int32_t>(newState)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffect2>**)this;
            check_hresult(_winrt_abi_type->SetState(static_cast<int32_t>(newState)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioEffectDefinition<D>::ActivatableClassId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActivatableClassId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->get_ActivatableClassId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioEffectDefinition<D>::Properties() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Properties(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->get_Properties(&value));
        }
        return winrt::Windows::Foundation::Collections::IPropertySet{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioEffectDefinitionFactory<D>::Create(param::hstring const& activatableClassId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioEffectDefinitionFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioEffectDefinitionFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectDefinitionFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Create(*(void**)(&activatableClassId), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectDefinitionFactory>**)this;
            check_hresult(_winrt_abi_type->Create(*(void**)(&activatableClassId), &value));
        }
        return winrt::Windows::Media::Effects::AudioEffectDefinition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioEffectDefinitionFactory<D>::CreateWithProperties(param::hstring const& activatableClassId, winrt::Windows::Foundation::Collections::IPropertySet const& props) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioEffectDefinitionFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioEffectDefinitionFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectDefinitionFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateWithProperties(*(void**)(&activatableClassId), *(void**)(&props), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectDefinitionFactory>**)this;
            check_hresult(_winrt_abi_type->CreateWithProperties(*(void**)(&activatableClassId), *(void**)(&props), &value));
        }
        return winrt::Windows::Media::Effects::AudioEffectDefinition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioEffectsManagerStatics<D>::CreateAudioRenderEffectsManager(param::hstring const& deviceId, winrt::Windows::Media::Render::AudioRenderCategory const& category) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioEffectsManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioEffectsManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectsManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateAudioRenderEffectsManager(*(void**)(&deviceId), static_cast<int32_t>(category), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectsManagerStatics>**)this;
            check_hresult(_winrt_abi_type->CreateAudioRenderEffectsManager(*(void**)(&deviceId), static_cast<int32_t>(category), &value));
        }
        return winrt::Windows::Media::Effects::AudioRenderEffectsManager{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioEffectsManagerStatics<D>::CreateAudioRenderEffectsManager(param::hstring const& deviceId, winrt::Windows::Media::Render::AudioRenderCategory const& category, winrt::Windows::Media::AudioProcessing const& mode) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioEffectsManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioEffectsManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectsManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateAudioRenderEffectsManagerWithMode(*(void**)(&deviceId), static_cast<int32_t>(category), static_cast<int32_t>(mode), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectsManagerStatics>**)this;
            check_hresult(_winrt_abi_type->CreateAudioRenderEffectsManagerWithMode(*(void**)(&deviceId), static_cast<int32_t>(category), static_cast<int32_t>(mode), &value));
        }
        return winrt::Windows::Media::Effects::AudioRenderEffectsManager{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioEffectsManagerStatics<D>::CreateAudioCaptureEffectsManager(param::hstring const& deviceId, winrt::Windows::Media::Capture::MediaCategory const& category) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioEffectsManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioEffectsManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectsManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateAudioCaptureEffectsManager(*(void**)(&deviceId), static_cast<int32_t>(category), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectsManagerStatics>**)this;
            check_hresult(_winrt_abi_type->CreateAudioCaptureEffectsManager(*(void**)(&deviceId), static_cast<int32_t>(category), &value));
        }
        return winrt::Windows::Media::Effects::AudioCaptureEffectsManager{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioEffectsManagerStatics<D>::CreateAudioCaptureEffectsManager(param::hstring const& deviceId, winrt::Windows::Media::Capture::MediaCategory const& category, winrt::Windows::Media::AudioProcessing const& mode) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioEffectsManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioEffectsManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectsManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateAudioCaptureEffectsManagerWithMode(*(void**)(&deviceId), static_cast<int32_t>(category), static_cast<int32_t>(mode), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioEffectsManagerStatics>**)this;
            check_hresult(_winrt_abi_type->CreateAudioCaptureEffectsManagerWithMode(*(void**)(&deviceId), static_cast<int32_t>(category), static_cast<int32_t>(mode), &value));
        }
        return winrt::Windows::Media::Effects::AudioCaptureEffectsManager{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioRenderEffectsManager<D>::AudioRenderEffectsChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Effects::AudioRenderEffectsManager, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioRenderEffectsManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioRenderEffectsManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioRenderEffectsManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_AudioRenderEffectsChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioRenderEffectsManager>**)this;
            check_hresult(_winrt_abi_type->add_AudioRenderEffectsChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioRenderEffectsManager<D>::AudioRenderEffectsChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Effects::AudioRenderEffectsManager, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, AudioRenderEffectsChanged_revoker>(this, AudioRenderEffectsChanged(handler));
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioRenderEffectsManager<D>::AudioRenderEffectsChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioRenderEffectsManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioRenderEffectsManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioRenderEffectsManager>**)&_winrt_casted_result;
            _winrt_abi_type->remove_AudioRenderEffectsChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioRenderEffectsManager>**)this;
            _winrt_abi_type->remove_AudioRenderEffectsChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioRenderEffectsManager<D>::GetAudioRenderEffects() const
    {
        void* effects{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioRenderEffectsManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioRenderEffectsManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioRenderEffectsManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetAudioRenderEffects(&effects));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioRenderEffectsManager>**)this;
            check_hresult(_winrt_abi_type->GetAudioRenderEffects(&effects));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Media::Effects::AudioEffect>{ effects, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioRenderEffectsManager2<D>::EffectsProviderThumbnail() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioRenderEffectsManager2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioRenderEffectsManager2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioRenderEffectsManager2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EffectsProviderThumbnail(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioRenderEffectsManager2>**)this;
            check_hresult(_winrt_abi_type->get_EffectsProviderThumbnail(&value));
        }
        return winrt::Windows::Storage::Streams::IRandomAccessStreamWithContentType{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioRenderEffectsManager2<D>::EffectsProviderSettingsLabel() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioRenderEffectsManager2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioRenderEffectsManager2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioRenderEffectsManager2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EffectsProviderSettingsLabel(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioRenderEffectsManager2>**)this;
            check_hresult(_winrt_abi_type->get_EffectsProviderSettingsLabel(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IAudioRenderEffectsManager2<D>::ShowSettingsUI() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IAudioRenderEffectsManager2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IAudioRenderEffectsManager2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioRenderEffectsManager2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ShowSettingsUI());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IAudioRenderEffectsManager2>**)this;
            check_hresult(_winrt_abi_type->ShowSettingsUI());
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicAudioEffect<D>::UseInputFrameForOutput() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicAudioEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicAudioEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicAudioEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UseInputFrameForOutput(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicAudioEffect>**)this;
            check_hresult(_winrt_abi_type->get_UseInputFrameForOutput(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicAudioEffect<D>::SupportedEncodingProperties() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicAudioEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicAudioEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicAudioEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedEncodingProperties(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicAudioEffect>**)this;
            check_hresult(_winrt_abi_type->get_SupportedEncodingProperties(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Media::MediaProperties::AudioEncodingProperties>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicAudioEffect<D>::SetEncodingProperties(winrt::Windows::Media::MediaProperties::AudioEncodingProperties const& encodingProperties) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicAudioEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicAudioEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicAudioEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetEncodingProperties(*(void**)(&encodingProperties)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicAudioEffect>**)this;
            check_hresult(_winrt_abi_type->SetEncodingProperties(*(void**)(&encodingProperties)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicAudioEffect<D>::ProcessFrame(winrt::Windows::Media::Effects::ProcessAudioFrameContext const& context) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicAudioEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicAudioEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicAudioEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ProcessFrame(*(void**)(&context)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicAudioEffect>**)this;
            check_hresult(_winrt_abi_type->ProcessFrame(*(void**)(&context)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicAudioEffect<D>::Close(winrt::Windows::Media::Effects::MediaEffectClosedReason const& reason) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicAudioEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicAudioEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicAudioEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Close(static_cast<int32_t>(reason)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicAudioEffect>**)this;
            check_hresult(_winrt_abi_type->Close(static_cast<int32_t>(reason)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicAudioEffect<D>::DiscardQueuedFrames() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicAudioEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicAudioEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicAudioEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DiscardQueuedFrames());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicAudioEffect>**)this;
            check_hresult(_winrt_abi_type->DiscardQueuedFrames());
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicVideoEffect<D>::IsReadOnly() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicVideoEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicVideoEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReadOnly(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)this;
            check_hresult(_winrt_abi_type->get_IsReadOnly(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicVideoEffect<D>::SupportedMemoryTypes() const
    {
        winrt::Windows::Media::Effects::MediaMemoryTypes value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicVideoEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicVideoEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedMemoryTypes(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)this;
            check_hresult(_winrt_abi_type->get_SupportedMemoryTypes(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicVideoEffect<D>::TimeIndependent() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicVideoEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicVideoEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TimeIndependent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)this;
            check_hresult(_winrt_abi_type->get_TimeIndependent(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicVideoEffect<D>::SupportedEncodingProperties() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicVideoEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicVideoEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedEncodingProperties(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)this;
            check_hresult(_winrt_abi_type->get_SupportedEncodingProperties(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Media::MediaProperties::VideoEncodingProperties>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicVideoEffect<D>::SetEncodingProperties(winrt::Windows::Media::MediaProperties::VideoEncodingProperties const& encodingProperties, winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DDevice const& device) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicVideoEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicVideoEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetEncodingProperties(*(void**)(&encodingProperties), *(void**)(&device)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)this;
            check_hresult(_winrt_abi_type->SetEncodingProperties(*(void**)(&encodingProperties), *(void**)(&device)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicVideoEffect<D>::ProcessFrame(winrt::Windows::Media::Effects::ProcessVideoFrameContext const& context) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicVideoEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicVideoEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ProcessFrame(*(void**)(&context)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)this;
            check_hresult(_winrt_abi_type->ProcessFrame(*(void**)(&context)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicVideoEffect<D>::Close(winrt::Windows::Media::Effects::MediaEffectClosedReason const& reason) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicVideoEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicVideoEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Close(static_cast<int32_t>(reason)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)this;
            check_hresult(_winrt_abi_type->Close(static_cast<int32_t>(reason)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IBasicVideoEffect<D>::DiscardQueuedFrames() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IBasicVideoEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IBasicVideoEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DiscardQueuedFrames());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IBasicVideoEffect>**)this;
            check_hresult(_winrt_abi_type->DiscardQueuedFrames());
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_ICompositeVideoFrameContext<D>::SurfacesToOverlay() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::ICompositeVideoFrameContext>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::ICompositeVideoFrameContext, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::ICompositeVideoFrameContext>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SurfacesToOverlay(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::ICompositeVideoFrameContext>**)this;
            check_hresult(_winrt_abi_type->get_SurfacesToOverlay(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DSurface>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_ICompositeVideoFrameContext<D>::BackgroundFrame() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::ICompositeVideoFrameContext>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::ICompositeVideoFrameContext, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::ICompositeVideoFrameContext>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BackgroundFrame(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::ICompositeVideoFrameContext>**)this;
            check_hresult(_winrt_abi_type->get_BackgroundFrame(&value));
        }
        return winrt::Windows::Media::VideoFrame{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_ICompositeVideoFrameContext<D>::OutputFrame() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::ICompositeVideoFrameContext>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::ICompositeVideoFrameContext, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::ICompositeVideoFrameContext>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OutputFrame(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::ICompositeVideoFrameContext>**)this;
            check_hresult(_winrt_abi_type->get_OutputFrame(&value));
        }
        return winrt::Windows::Media::VideoFrame{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_ICompositeVideoFrameContext<D>::GetOverlayForSurface(winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DSurface const& surfaceToOverlay) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::ICompositeVideoFrameContext>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::ICompositeVideoFrameContext, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::ICompositeVideoFrameContext>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetOverlayForSurface(*(void**)(&surfaceToOverlay), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::ICompositeVideoFrameContext>**)this;
            check_hresult(_winrt_abi_type->GetOverlayForSurface(*(void**)(&surfaceToOverlay), &value));
        }
        return winrt::Windows::Media::Editing::MediaOverlay{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IProcessAudioFrameContext<D>::InputFrame() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IProcessAudioFrameContext>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IProcessAudioFrameContext, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IProcessAudioFrameContext>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InputFrame(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IProcessAudioFrameContext>**)this;
            check_hresult(_winrt_abi_type->get_InputFrame(&value));
        }
        return winrt::Windows::Media::AudioFrame{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IProcessAudioFrameContext<D>::OutputFrame() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IProcessAudioFrameContext>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IProcessAudioFrameContext, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IProcessAudioFrameContext>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OutputFrame(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IProcessAudioFrameContext>**)this;
            check_hresult(_winrt_abi_type->get_OutputFrame(&value));
        }
        return winrt::Windows::Media::AudioFrame{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IProcessVideoFrameContext<D>::InputFrame() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IProcessVideoFrameContext>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IProcessVideoFrameContext, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IProcessVideoFrameContext>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InputFrame(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IProcessVideoFrameContext>**)this;
            check_hresult(_winrt_abi_type->get_InputFrame(&value));
        }
        return winrt::Windows::Media::VideoFrame{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IProcessVideoFrameContext<D>::OutputFrame() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IProcessVideoFrameContext>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IProcessVideoFrameContext, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IProcessVideoFrameContext>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OutputFrame(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IProcessVideoFrameContext>**)this;
            check_hresult(_winrt_abi_type->get_OutputFrame(&value));
        }
        return winrt::Windows::Media::VideoFrame{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoCompositor<D>::TimeIndependent() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoCompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoCompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TimeIndependent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositor>**)this;
            check_hresult(_winrt_abi_type->get_TimeIndependent(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoCompositor<D>::SetEncodingProperties(winrt::Windows::Media::MediaProperties::VideoEncodingProperties const& backgroundProperties, winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DDevice const& device) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoCompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoCompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetEncodingProperties(*(void**)(&backgroundProperties), *(void**)(&device)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositor>**)this;
            check_hresult(_winrt_abi_type->SetEncodingProperties(*(void**)(&backgroundProperties), *(void**)(&device)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoCompositor<D>::CompositeFrame(winrt::Windows::Media::Effects::CompositeVideoFrameContext const& context) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoCompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoCompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CompositeFrame(*(void**)(&context)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositor>**)this;
            check_hresult(_winrt_abi_type->CompositeFrame(*(void**)(&context)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoCompositor<D>::Close(winrt::Windows::Media::Effects::MediaEffectClosedReason const& reason) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoCompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoCompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Close(static_cast<int32_t>(reason)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositor>**)this;
            check_hresult(_winrt_abi_type->Close(static_cast<int32_t>(reason)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoCompositor<D>::DiscardQueuedFrames() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoCompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoCompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DiscardQueuedFrames());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositor>**)this;
            check_hresult(_winrt_abi_type->DiscardQueuedFrames());
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoCompositorDefinition<D>::ActivatableClassId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoCompositorDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoCompositorDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositorDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActivatableClassId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositorDefinition>**)this;
            check_hresult(_winrt_abi_type->get_ActivatableClassId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoCompositorDefinition<D>::Properties() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoCompositorDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoCompositorDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositorDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Properties(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositorDefinition>**)this;
            check_hresult(_winrt_abi_type->get_Properties(&value));
        }
        return winrt::Windows::Foundation::Collections::IPropertySet{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoCompositorDefinitionFactory<D>::Create(param::hstring const& activatableClassId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoCompositorDefinitionFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoCompositorDefinitionFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositorDefinitionFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Create(*(void**)(&activatableClassId), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositorDefinitionFactory>**)this;
            check_hresult(_winrt_abi_type->Create(*(void**)(&activatableClassId), &value));
        }
        return winrt::Windows::Media::Effects::VideoCompositorDefinition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoCompositorDefinitionFactory<D>::CreateWithProperties(param::hstring const& activatableClassId, winrt::Windows::Foundation::Collections::IPropertySet const& props) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoCompositorDefinitionFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoCompositorDefinitionFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositorDefinitionFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateWithProperties(*(void**)(&activatableClassId), *(void**)(&props), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoCompositorDefinitionFactory>**)this;
            check_hresult(_winrt_abi_type->CreateWithProperties(*(void**)(&activatableClassId), *(void**)(&props), &value));
        }
        return winrt::Windows::Media::Effects::VideoCompositorDefinition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoEffectDefinition<D>::ActivatableClassId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActivatableClassId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->get_ActivatableClassId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoEffectDefinition<D>::Properties() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Properties(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->get_Properties(&value));
        }
        return winrt::Windows::Foundation::Collections::IPropertySet{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoEffectDefinitionFactory<D>::Create(param::hstring const& activatableClassId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoEffectDefinitionFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoEffectDefinitionFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoEffectDefinitionFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Create(*(void**)(&activatableClassId), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoEffectDefinitionFactory>**)this;
            check_hresult(_winrt_abi_type->Create(*(void**)(&activatableClassId), &value));
        }
        return winrt::Windows::Media::Effects::VideoEffectDefinition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoEffectDefinitionFactory<D>::CreateWithProperties(param::hstring const& activatableClassId, winrt::Windows::Foundation::Collections::IPropertySet const& props) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoEffectDefinitionFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoEffectDefinitionFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoEffectDefinitionFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateWithProperties(*(void**)(&activatableClassId), *(void**)(&props), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoEffectDefinitionFactory>**)this;
            check_hresult(_winrt_abi_type->CreateWithProperties(*(void**)(&activatableClassId), *(void**)(&props), &value));
        }
        return winrt::Windows::Media::Effects::VideoEffectDefinition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformEffectDefinition<D>::PaddingColor() const
    {
        winrt::Windows::UI::Color value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PaddingColor(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->get_PaddingColor(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformEffectDefinition<D>::PaddingColor(winrt::Windows::UI::Color const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_PaddingColor(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->put_PaddingColor(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformEffectDefinition<D>::OutputSize() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OutputSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->get_OutputSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformEffectDefinition<D>::OutputSize(winrt::Windows::Foundation::Size const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_OutputSize(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->put_OutputSize(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformEffectDefinition<D>::CropRectangle() const
    {
        winrt::Windows::Foundation::Rect value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CropRectangle(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->get_CropRectangle(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformEffectDefinition<D>::CropRectangle(winrt::Windows::Foundation::Rect const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CropRectangle(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->put_CropRectangle(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformEffectDefinition<D>::Rotation() const
    {
        winrt::Windows::Media::MediaProperties::MediaRotation value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Rotation(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->get_Rotation(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformEffectDefinition<D>::Rotation(winrt::Windows::Media::MediaProperties::MediaRotation const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Rotation(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->put_Rotation(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformEffectDefinition<D>::Mirror() const
    {
        winrt::Windows::Media::MediaProperties::MediaMirroringOptions value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Mirror(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->get_Mirror(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformEffectDefinition<D>::Mirror(winrt::Windows::Media::MediaProperties::MediaMirroringOptions const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Mirror(static_cast<uint32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->put_Mirror(static_cast<uint32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformEffectDefinition<D>::ProcessingAlgorithm(winrt::Windows::Media::Transcoding::MediaVideoProcessingAlgorithm const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ProcessingAlgorithm(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->put_ProcessingAlgorithm(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformEffectDefinition<D>::ProcessingAlgorithm() const
    {
        winrt::Windows::Media::Transcoding::MediaVideoProcessingAlgorithm value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProcessingAlgorithm(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>**)this;
            check_hresult(_winrt_abi_type->get_ProcessingAlgorithm(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformEffectDefinition2<D>::SphericalProjection() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SphericalProjection(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition2>**)this;
            check_hresult(_winrt_abi_type->get_SphericalProjection(&value));
        }
        return winrt::Windows::Media::Effects::VideoTransformSphericalProjection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformSphericalProjection<D>::IsEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)this;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformSphericalProjection<D>::IsEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)this;
            check_hresult(_winrt_abi_type->put_IsEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformSphericalProjection<D>::FrameFormat() const
    {
        winrt::Windows::Media::MediaProperties::SphericalVideoFrameFormat value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FrameFormat(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)this;
            check_hresult(_winrt_abi_type->get_FrameFormat(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformSphericalProjection<D>::FrameFormat(winrt::Windows::Media::MediaProperties::SphericalVideoFrameFormat const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FrameFormat(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)this;
            check_hresult(_winrt_abi_type->put_FrameFormat(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformSphericalProjection<D>::ProjectionMode() const
    {
        winrt::Windows::Media::Playback::SphericalVideoProjectionMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProjectionMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)this;
            check_hresult(_winrt_abi_type->get_ProjectionMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformSphericalProjection<D>::ProjectionMode(winrt::Windows::Media::Playback::SphericalVideoProjectionMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ProjectionMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)this;
            check_hresult(_winrt_abi_type->put_ProjectionMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformSphericalProjection<D>::HorizontalFieldOfViewInDegrees() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HorizontalFieldOfViewInDegrees(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)this;
            check_hresult(_winrt_abi_type->get_HorizontalFieldOfViewInDegrees(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformSphericalProjection<D>::HorizontalFieldOfViewInDegrees(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_HorizontalFieldOfViewInDegrees(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)this;
            check_hresult(_winrt_abi_type->put_HorizontalFieldOfViewInDegrees(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformSphericalProjection<D>::ViewOrientation() const
    {
        winrt::Windows::Foundation::Numerics::quaternion value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ViewOrientation(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)this;
            check_hresult(_winrt_abi_type->get_ViewOrientation(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Effects_IVideoTransformSphericalProjection<D>::ViewOrientation(winrt::Windows::Foundation::Numerics::quaternion const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ViewOrientation(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>**)this;
            check_hresult(_winrt_abi_type->put_ViewOrientation(impl::bind_in(value)));
        }
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IAcousticEchoCancellationConfiguration> : produce_base<D, winrt::Windows::Media::Effects::IAcousticEchoCancellationConfiguration>
    {
        int32_t __stdcall SetEchoCancellationRenderEndpoint(void* deviceId) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetEchoCancellationRenderEndpoint(*reinterpret_cast<hstring const*>(&deviceId));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IAudioCaptureEffectsManager> : produce_base<D, winrt::Windows::Media::Effects::IAudioCaptureEffectsManager>
    {
        int32_t __stdcall add_AudioCaptureEffectsChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().AudioCaptureEffectsChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Effects::AudioCaptureEffectsManager, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_AudioCaptureEffectsChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AudioCaptureEffectsChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall GetAudioCaptureEffects(void** effects) noexcept final try
        {
            clear_abi(effects);
            typename D::abi_guard guard(this->shim());
            *effects = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Media::Effects::AudioEffect>>(this->shim().GetAudioCaptureEffects());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IAudioEffect> : produce_base<D, winrt::Windows::Media::Effects::IAudioEffect>
    {
        int32_t __stdcall get_AudioEffectType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::AudioEffectType>(this->shim().AudioEffectType());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IAudioEffect2> : produce_base<D, winrt::Windows::Media::Effects::IAudioEffect2>
    {
        int32_t __stdcall get_AcousticEchoCancellationConfiguration(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::AcousticEchoCancellationConfiguration>(this->shim().AcousticEchoCancellationConfiguration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CanSetState(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().CanSetState());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_State(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::AudioEffectState>(this->shim().State());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetState(int32_t newState) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetState(*reinterpret_cast<winrt::Windows::Media::Effects::AudioEffectState const*>(&newState));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IAudioEffectDefinition> : produce_base<D, winrt::Windows::Media::Effects::IAudioEffectDefinition>
    {
        int32_t __stdcall get_ActivatableClassId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ActivatableClassId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Properties(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IPropertySet>(this->shim().Properties());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IAudioEffectDefinitionFactory> : produce_base<D, winrt::Windows::Media::Effects::IAudioEffectDefinitionFactory>
    {
        int32_t __stdcall Create(void* activatableClassId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::AudioEffectDefinition>(this->shim().Create(*reinterpret_cast<hstring const*>(&activatableClassId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateWithProperties(void* activatableClassId, void* props, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::AudioEffectDefinition>(this->shim().CreateWithProperties(*reinterpret_cast<hstring const*>(&activatableClassId), *reinterpret_cast<winrt::Windows::Foundation::Collections::IPropertySet const*>(&props)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IAudioEffectsManagerStatics> : produce_base<D, winrt::Windows::Media::Effects::IAudioEffectsManagerStatics>
    {
        int32_t __stdcall CreateAudioRenderEffectsManager(void* deviceId, int32_t category, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::AudioRenderEffectsManager>(this->shim().CreateAudioRenderEffectsManager(*reinterpret_cast<hstring const*>(&deviceId), *reinterpret_cast<winrt::Windows::Media::Render::AudioRenderCategory const*>(&category)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateAudioRenderEffectsManagerWithMode(void* deviceId, int32_t category, int32_t mode, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::AudioRenderEffectsManager>(this->shim().CreateAudioRenderEffectsManager(*reinterpret_cast<hstring const*>(&deviceId), *reinterpret_cast<winrt::Windows::Media::Render::AudioRenderCategory const*>(&category), *reinterpret_cast<winrt::Windows::Media::AudioProcessing const*>(&mode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateAudioCaptureEffectsManager(void* deviceId, int32_t category, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::AudioCaptureEffectsManager>(this->shim().CreateAudioCaptureEffectsManager(*reinterpret_cast<hstring const*>(&deviceId), *reinterpret_cast<winrt::Windows::Media::Capture::MediaCategory const*>(&category)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateAudioCaptureEffectsManagerWithMode(void* deviceId, int32_t category, int32_t mode, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::AudioCaptureEffectsManager>(this->shim().CreateAudioCaptureEffectsManager(*reinterpret_cast<hstring const*>(&deviceId), *reinterpret_cast<winrt::Windows::Media::Capture::MediaCategory const*>(&category), *reinterpret_cast<winrt::Windows::Media::AudioProcessing const*>(&mode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IAudioRenderEffectsManager> : produce_base<D, winrt::Windows::Media::Effects::IAudioRenderEffectsManager>
    {
        int32_t __stdcall add_AudioRenderEffectsChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().AudioRenderEffectsChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Media::Effects::AudioRenderEffectsManager, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_AudioRenderEffectsChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AudioRenderEffectsChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall GetAudioRenderEffects(void** effects) noexcept final try
        {
            clear_abi(effects);
            typename D::abi_guard guard(this->shim());
            *effects = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Media::Effects::AudioEffect>>(this->shim().GetAudioRenderEffects());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IAudioRenderEffectsManager2> : produce_base<D, winrt::Windows::Media::Effects::IAudioRenderEffectsManager2>
    {
        int32_t __stdcall get_EffectsProviderThumbnail(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IRandomAccessStreamWithContentType>(this->shim().EffectsProviderThumbnail());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_EffectsProviderSettingsLabel(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().EffectsProviderSettingsLabel());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ShowSettingsUI() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ShowSettingsUI();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IBasicAudioEffect> : produce_base<D, winrt::Windows::Media::Effects::IBasicAudioEffect>
    {
        int32_t __stdcall get_UseInputFrameForOutput(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().UseInputFrameForOutput());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedEncodingProperties(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Media::MediaProperties::AudioEncodingProperties>>(this->shim().SupportedEncodingProperties());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetEncodingProperties(void* encodingProperties) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetEncodingProperties(*reinterpret_cast<winrt::Windows::Media::MediaProperties::AudioEncodingProperties const*>(&encodingProperties));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ProcessFrame(void* context) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ProcessFrame(*reinterpret_cast<winrt::Windows::Media::Effects::ProcessAudioFrameContext const*>(&context));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Close(int32_t reason) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Close(*reinterpret_cast<winrt::Windows::Media::Effects::MediaEffectClosedReason const*>(&reason));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DiscardQueuedFrames() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DiscardQueuedFrames();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IBasicVideoEffect> : produce_base<D, winrt::Windows::Media::Effects::IBasicVideoEffect>
    {
        int32_t __stdcall get_IsReadOnly(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsReadOnly());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedMemoryTypes(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::MediaMemoryTypes>(this->shim().SupportedMemoryTypes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TimeIndependent(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().TimeIndependent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedEncodingProperties(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Media::MediaProperties::VideoEncodingProperties>>(this->shim().SupportedEncodingProperties());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetEncodingProperties(void* encodingProperties, void* device) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetEncodingProperties(*reinterpret_cast<winrt::Windows::Media::MediaProperties::VideoEncodingProperties const*>(&encodingProperties), *reinterpret_cast<winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DDevice const*>(&device));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ProcessFrame(void* context) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ProcessFrame(*reinterpret_cast<winrt::Windows::Media::Effects::ProcessVideoFrameContext const*>(&context));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Close(int32_t reason) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Close(*reinterpret_cast<winrt::Windows::Media::Effects::MediaEffectClosedReason const*>(&reason));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DiscardQueuedFrames() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DiscardQueuedFrames();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::ICompositeVideoFrameContext> : produce_base<D, winrt::Windows::Media::Effects::ICompositeVideoFrameContext>
    {
        int32_t __stdcall get_SurfacesToOverlay(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DSurface>>(this->shim().SurfacesToOverlay());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BackgroundFrame(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::VideoFrame>(this->shim().BackgroundFrame());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_OutputFrame(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::VideoFrame>(this->shim().OutputFrame());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetOverlayForSurface(void* surfaceToOverlay, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Editing::MediaOverlay>(this->shim().GetOverlayForSurface(*reinterpret_cast<winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DSurface const*>(&surfaceToOverlay)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IProcessAudioFrameContext> : produce_base<D, winrt::Windows::Media::Effects::IProcessAudioFrameContext>
    {
        int32_t __stdcall get_InputFrame(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::AudioFrame>(this->shim().InputFrame());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_OutputFrame(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::AudioFrame>(this->shim().OutputFrame());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IProcessVideoFrameContext> : produce_base<D, winrt::Windows::Media::Effects::IProcessVideoFrameContext>
    {
        int32_t __stdcall get_InputFrame(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::VideoFrame>(this->shim().InputFrame());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_OutputFrame(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::VideoFrame>(this->shim().OutputFrame());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IVideoCompositor> : produce_base<D, winrt::Windows::Media::Effects::IVideoCompositor>
    {
        int32_t __stdcall get_TimeIndependent(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().TimeIndependent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetEncodingProperties(void* backgroundProperties, void* device) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetEncodingProperties(*reinterpret_cast<winrt::Windows::Media::MediaProperties::VideoEncodingProperties const*>(&backgroundProperties), *reinterpret_cast<winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DDevice const*>(&device));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CompositeFrame(void* context) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CompositeFrame(*reinterpret_cast<winrt::Windows::Media::Effects::CompositeVideoFrameContext const*>(&context));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Close(int32_t reason) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Close(*reinterpret_cast<winrt::Windows::Media::Effects::MediaEffectClosedReason const*>(&reason));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DiscardQueuedFrames() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DiscardQueuedFrames();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IVideoCompositorDefinition> : produce_base<D, winrt::Windows::Media::Effects::IVideoCompositorDefinition>
    {
        int32_t __stdcall get_ActivatableClassId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ActivatableClassId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Properties(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IPropertySet>(this->shim().Properties());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IVideoCompositorDefinitionFactory> : produce_base<D, winrt::Windows::Media::Effects::IVideoCompositorDefinitionFactory>
    {
        int32_t __stdcall Create(void* activatableClassId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::VideoCompositorDefinition>(this->shim().Create(*reinterpret_cast<hstring const*>(&activatableClassId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateWithProperties(void* activatableClassId, void* props, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::VideoCompositorDefinition>(this->shim().CreateWithProperties(*reinterpret_cast<hstring const*>(&activatableClassId), *reinterpret_cast<winrt::Windows::Foundation::Collections::IPropertySet const*>(&props)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IVideoEffectDefinition> : produce_base<D, winrt::Windows::Media::Effects::IVideoEffectDefinition>
    {
        int32_t __stdcall get_ActivatableClassId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ActivatableClassId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Properties(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IPropertySet>(this->shim().Properties());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IVideoEffectDefinitionFactory> : produce_base<D, winrt::Windows::Media::Effects::IVideoEffectDefinitionFactory>
    {
        int32_t __stdcall Create(void* activatableClassId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::VideoEffectDefinition>(this->shim().Create(*reinterpret_cast<hstring const*>(&activatableClassId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateWithProperties(void* activatableClassId, void* props, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::VideoEffectDefinition>(this->shim().CreateWithProperties(*reinterpret_cast<hstring const*>(&activatableClassId), *reinterpret_cast<winrt::Windows::Foundation::Collections::IPropertySet const*>(&props)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition> : produce_base<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition>
    {
        int32_t __stdcall get_PaddingColor(struct struct_Windows_UI_Color* value) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Color>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Color>(this->shim().PaddingColor());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_PaddingColor(struct struct_Windows_UI_Color value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PaddingColor(*reinterpret_cast<winrt::Windows::UI::Color const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_OutputSize(winrt::Windows::Foundation::Size* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Size>(this->shim().OutputSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_OutputSize(winrt::Windows::Foundation::Size value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OutputSize(*reinterpret_cast<winrt::Windows::Foundation::Size const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CropRectangle(winrt::Windows::Foundation::Rect* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Rect>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Rect>(this->shim().CropRectangle());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CropRectangle(winrt::Windows::Foundation::Rect value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CropRectangle(*reinterpret_cast<winrt::Windows::Foundation::Rect const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Rotation(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::MediaProperties::MediaRotation>(this->shim().Rotation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Rotation(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Rotation(*reinterpret_cast<winrt::Windows::Media::MediaProperties::MediaRotation const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Mirror(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::MediaProperties::MediaMirroringOptions>(this->shim().Mirror());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Mirror(uint32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Mirror(*reinterpret_cast<winrt::Windows::Media::MediaProperties::MediaMirroringOptions const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ProcessingAlgorithm(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ProcessingAlgorithm(*reinterpret_cast<winrt::Windows::Media::Transcoding::MediaVideoProcessingAlgorithm const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ProcessingAlgorithm(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Transcoding::MediaVideoProcessingAlgorithm>(this->shim().ProcessingAlgorithm());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition2> : produce_base<D, winrt::Windows::Media::Effects::IVideoTransformEffectDefinition2>
    {
        int32_t __stdcall get_SphericalProjection(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Effects::VideoTransformSphericalProjection>(this->shim().SphericalProjection());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Effects::IVideoTransformSphericalProjection> : produce_base<D, winrt::Windows::Media::Effects::IVideoTransformSphericalProjection>
    {
        int32_t __stdcall get_IsEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FrameFormat(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::MediaProperties::SphericalVideoFrameFormat>(this->shim().FrameFormat());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FrameFormat(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FrameFormat(*reinterpret_cast<winrt::Windows::Media::MediaProperties::SphericalVideoFrameFormat const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ProjectionMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Playback::SphericalVideoProjectionMode>(this->shim().ProjectionMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ProjectionMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ProjectionMode(*reinterpret_cast<winrt::Windows::Media::Playback::SphericalVideoProjectionMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_HorizontalFieldOfViewInDegrees(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().HorizontalFieldOfViewInDegrees());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_HorizontalFieldOfViewInDegrees(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().HorizontalFieldOfViewInDegrees(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ViewOrientation(winrt::Windows::Foundation::Numerics::quaternion* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::quaternion>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::quaternion>(this->shim().ViewOrientation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ViewOrientation(winrt::Windows::Foundation::Numerics::quaternion value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ViewOrientation(*reinterpret_cast<winrt::Windows::Foundation::Numerics::quaternion const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::Media::Effects
{
    inline AudioEffectDefinition::AudioEffectDefinition(param::hstring const& activatableClassId) :
        AudioEffectDefinition(impl::call_factory<AudioEffectDefinition, IAudioEffectDefinitionFactory>([&](IAudioEffectDefinitionFactory const& f) { return f.Create(activatableClassId); }))
    {
    }
    inline AudioEffectDefinition::AudioEffectDefinition(param::hstring const& activatableClassId, winrt::Windows::Foundation::Collections::IPropertySet const& props) :
        AudioEffectDefinition(impl::call_factory<AudioEffectDefinition, IAudioEffectDefinitionFactory>([&](IAudioEffectDefinitionFactory const& f) { return f.CreateWithProperties(activatableClassId, props); }))
    {
    }
    inline auto AudioEffectsManager::CreateAudioRenderEffectsManager(param::hstring const& deviceId, winrt::Windows::Media::Render::AudioRenderCategory const& category)
    {
        return impl::call_factory<AudioEffectsManager, IAudioEffectsManagerStatics>([&](IAudioEffectsManagerStatics const& f) { return f.CreateAudioRenderEffectsManager(deviceId, category); });
    }
    inline auto AudioEffectsManager::CreateAudioRenderEffectsManager(param::hstring const& deviceId, winrt::Windows::Media::Render::AudioRenderCategory const& category, winrt::Windows::Media::AudioProcessing const& mode)
    {
        return impl::call_factory<AudioEffectsManager, IAudioEffectsManagerStatics>([&](IAudioEffectsManagerStatics const& f) { return f.CreateAudioRenderEffectsManager(deviceId, category, mode); });
    }
    inline auto AudioEffectsManager::CreateAudioCaptureEffectsManager(param::hstring const& deviceId, winrt::Windows::Media::Capture::MediaCategory const& category)
    {
        return impl::call_factory<AudioEffectsManager, IAudioEffectsManagerStatics>([&](IAudioEffectsManagerStatics const& f) { return f.CreateAudioCaptureEffectsManager(deviceId, category); });
    }
    inline auto AudioEffectsManager::CreateAudioCaptureEffectsManager(param::hstring const& deviceId, winrt::Windows::Media::Capture::MediaCategory const& category, winrt::Windows::Media::AudioProcessing const& mode)
    {
        return impl::call_factory<AudioEffectsManager, IAudioEffectsManagerStatics>([&](IAudioEffectsManagerStatics const& f) { return f.CreateAudioCaptureEffectsManager(deviceId, category, mode); });
    }
    inline VideoCompositorDefinition::VideoCompositorDefinition(param::hstring const& activatableClassId) :
        VideoCompositorDefinition(impl::call_factory<VideoCompositorDefinition, IVideoCompositorDefinitionFactory>([&](IVideoCompositorDefinitionFactory const& f) { return f.Create(activatableClassId); }))
    {
    }
    inline VideoCompositorDefinition::VideoCompositorDefinition(param::hstring const& activatableClassId, winrt::Windows::Foundation::Collections::IPropertySet const& props) :
        VideoCompositorDefinition(impl::call_factory<VideoCompositorDefinition, IVideoCompositorDefinitionFactory>([&](IVideoCompositorDefinitionFactory const& f) { return f.CreateWithProperties(activatableClassId, props); }))
    {
    }
    inline VideoEffectDefinition::VideoEffectDefinition(param::hstring const& activatableClassId) :
        VideoEffectDefinition(impl::call_factory<VideoEffectDefinition, IVideoEffectDefinitionFactory>([&](IVideoEffectDefinitionFactory const& f) { return f.Create(activatableClassId); }))
    {
    }
    inline VideoEffectDefinition::VideoEffectDefinition(param::hstring const& activatableClassId, winrt::Windows::Foundation::Collections::IPropertySet const& props) :
        VideoEffectDefinition(impl::call_factory<VideoEffectDefinition, IVideoEffectDefinitionFactory>([&](IVideoEffectDefinitionFactory const& f) { return f.CreateWithProperties(activatableClassId, props); }))
    {
    }
    inline VideoTransformEffectDefinition::VideoTransformEffectDefinition() :
        VideoTransformEffectDefinition(impl::call_factory_cast<VideoTransformEffectDefinition(*)(winrt::Windows::Foundation::IActivationFactory const&), VideoTransformEffectDefinition>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<VideoTransformEffectDefinition>(); }))
    {
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Media::Effects::IAcousticEchoCancellationConfiguration> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IAudioCaptureEffectsManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IAudioEffect> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IAudioEffect2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IAudioEffectDefinition> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IAudioEffectDefinitionFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IAudioEffectsManagerStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IAudioRenderEffectsManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IAudioRenderEffectsManager2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IBasicAudioEffect> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IBasicVideoEffect> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::ICompositeVideoFrameContext> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IProcessAudioFrameContext> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IProcessVideoFrameContext> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IVideoCompositor> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IVideoCompositorDefinition> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IVideoCompositorDefinitionFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IVideoEffectDefinition> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IVideoEffectDefinitionFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IVideoTransformEffectDefinition2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::IVideoTransformSphericalProjection> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::AcousticEchoCancellationConfiguration> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::AudioCaptureEffectsManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::AudioEffect> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::AudioEffectDefinition> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::AudioEffectsManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::AudioRenderEffectsManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::CompositeVideoFrameContext> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::ProcessAudioFrameContext> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::ProcessVideoFrameContext> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::VideoCompositorDefinition> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::VideoEffectDefinition> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::VideoTransformEffectDefinition> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Effects::VideoTransformSphericalProjection> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
