// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Graphics_Holographic_H
#define WINRT_Windows_Graphics_Holographic_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Graphics.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Foundation.Numerics.2.h"
#include "winrt/impl/Windows.Graphics.DirectX.2.h"
#include "winrt/impl/Windows.Graphics.DirectX.Direct3D11.2.h"
#include "winrt/impl/Windows.Perception.2.h"
#include "winrt/impl/Windows.Perception.Spatial.2.h"
#include "winrt/impl/Windows.UI.Core.2.h"
#include "winrt/impl/Windows.Graphics.Holographic.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera<D>::RenderTargetSize() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RenderTargetSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)this;
            check_hresult(_winrt_abi_type->get_RenderTargetSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera<D>::ViewportScaleFactor() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ViewportScaleFactor(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)this;
            check_hresult(_winrt_abi_type->get_ViewportScaleFactor(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera<D>::ViewportScaleFactor(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ViewportScaleFactor(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)this;
            check_hresult(_winrt_abi_type->put_ViewportScaleFactor(value));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera<D>::IsStereo() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStereo(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)this;
            check_hresult(_winrt_abi_type->get_IsStereo(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera<D>::Id() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera<D>::SetNearPlaneDistance(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetNearPlaneDistance(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)this;
            check_hresult(_winrt_abi_type->SetNearPlaneDistance(value));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera<D>::SetFarPlaneDistance(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetFarPlaneDistance(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera>**)this;
            check_hresult(_winrt_abi_type->SetFarPlaneDistance(value));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera2<D>::LeftViewportParameters() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LeftViewportParameters(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera2>**)this;
            check_hresult(_winrt_abi_type->get_LeftViewportParameters(&result));
        }
        return winrt::Windows::Graphics::Holographic::HolographicCameraViewportParameters{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera2<D>::RightViewportParameters() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RightViewportParameters(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera2>**)this;
            check_hresult(_winrt_abi_type->get_RightViewportParameters(&result));
        }
        return winrt::Windows::Graphics::Holographic::HolographicCameraViewportParameters{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera2<D>::Display() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Display(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera2>**)this;
            check_hresult(_winrt_abi_type->get_Display(&result));
        }
        return winrt::Windows::Graphics::Holographic::HolographicDisplay{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera3<D>::IsPrimaryLayerEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsPrimaryLayerEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera3>**)this;
            check_hresult(_winrt_abi_type->get_IsPrimaryLayerEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera3<D>::IsPrimaryLayerEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsPrimaryLayerEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera3>**)this;
            check_hresult(_winrt_abi_type->put_IsPrimaryLayerEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera3<D>::MaxQuadLayerCount() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxQuadLayerCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera3>**)this;
            check_hresult(_winrt_abi_type->get_MaxQuadLayerCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera3<D>::QuadLayers() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_QuadLayers(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera3>**)this;
            check_hresult(_winrt_abi_type->get_QuadLayers(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Graphics::Holographic::HolographicQuadLayer>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera4<D>::CanOverrideViewport() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanOverrideViewport(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera4>**)this;
            check_hresult(_winrt_abi_type->get_CanOverrideViewport(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera5<D>::IsHardwareContentProtectionSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsHardwareContentProtectionSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera5>**)this;
            check_hresult(_winrt_abi_type->get_IsHardwareContentProtectionSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera5<D>::IsHardwareContentProtectionEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsHardwareContentProtectionEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera5>**)this;
            check_hresult(_winrt_abi_type->get_IsHardwareContentProtectionEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera5<D>::IsHardwareContentProtectionEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsHardwareContentProtectionEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera5>**)this;
            check_hresult(_winrt_abi_type->put_IsHardwareContentProtectionEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCamera6<D>::ViewConfiguration() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCamera6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCamera6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ViewConfiguration(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCamera6>**)this;
            check_hresult(_winrt_abi_type->get_ViewConfiguration(&value));
        }
        return winrt::Windows::Graphics::Holographic::HolographicViewConfiguration{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraPose<D>::HolographicCamera() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraPose, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HolographicCamera(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)this;
            check_hresult(_winrt_abi_type->get_HolographicCamera(&value));
        }
        return winrt::Windows::Graphics::Holographic::HolographicCamera{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraPose<D>::Viewport() const
    {
        winrt::Windows::Foundation::Rect value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraPose, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Viewport(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)this;
            check_hresult(_winrt_abi_type->get_Viewport(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraPose<D>::TryGetViewTransform(winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const& coordinateSystem) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraPose, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetViewTransform(*(void**)(&coordinateSystem), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)this;
            check_hresult(_winrt_abi_type->TryGetViewTransform(*(void**)(&coordinateSystem), &value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Graphics::Holographic::HolographicStereoTransform>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraPose<D>::ProjectionTransform() const
    {
        winrt::Windows::Graphics::Holographic::HolographicStereoTransform value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraPose, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProjectionTransform(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)this;
            check_hresult(_winrt_abi_type->get_ProjectionTransform(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraPose<D>::TryGetCullingFrustum(winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const& coordinateSystem) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraPose, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetCullingFrustum(*(void**)(&coordinateSystem), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)this;
            check_hresult(_winrt_abi_type->TryGetCullingFrustum(*(void**)(&coordinateSystem), &value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Perception::Spatial::SpatialBoundingFrustum>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraPose<D>::TryGetVisibleFrustum(winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const& coordinateSystem) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraPose, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetVisibleFrustum(*(void**)(&coordinateSystem), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)this;
            check_hresult(_winrt_abi_type->TryGetVisibleFrustum(*(void**)(&coordinateSystem), &value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Perception::Spatial::SpatialBoundingFrustum>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraPose<D>::NearPlaneDistance() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraPose, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_NearPlaneDistance(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)this;
            check_hresult(_winrt_abi_type->get_NearPlaneDistance(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraPose<D>::FarPlaneDistance() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraPose, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FarPlaneDistance(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose>**)this;
            check_hresult(_winrt_abi_type->get_FarPlaneDistance(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraPose2<D>::OverrideViewTransform(winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const& coordinateSystem, winrt::Windows::Graphics::Holographic::HolographicStereoTransform const& coordinateSystemToViewTransform) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraPose2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OverrideViewTransform(*(void**)(&coordinateSystem), impl::bind_in(coordinateSystemToViewTransform)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose2>**)this;
            check_hresult(_winrt_abi_type->OverrideViewTransform(*(void**)(&coordinateSystem), impl::bind_in(coordinateSystemToViewTransform)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraPose2<D>::OverrideProjectionTransform(winrt::Windows::Graphics::Holographic::HolographicStereoTransform const& projectionTransform) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraPose2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OverrideProjectionTransform(impl::bind_in(projectionTransform)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose2>**)this;
            check_hresult(_winrt_abi_type->OverrideProjectionTransform(impl::bind_in(projectionTransform)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraPose2<D>::OverrideViewport(winrt::Windows::Foundation::Rect const& leftViewport, winrt::Windows::Foundation::Rect const& rightViewport) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraPose2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OverrideViewport(impl::bind_in(leftViewport), impl::bind_in(rightViewport)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraPose2>**)this;
            check_hresult(_winrt_abi_type->OverrideViewport(impl::bind_in(leftViewport), impl::bind_in(rightViewport)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraRenderingParameters<D>::SetFocusPoint(winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const& coordinateSystem, winrt::Windows::Foundation::Numerics::float3 const& position) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetFocusPoint(*(void**)(&coordinateSystem), impl::bind_in(position)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>**)this;
            check_hresult(_winrt_abi_type->SetFocusPoint(*(void**)(&coordinateSystem), impl::bind_in(position)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraRenderingParameters<D>::SetFocusPoint(winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const& coordinateSystem, winrt::Windows::Foundation::Numerics::float3 const& position, winrt::Windows::Foundation::Numerics::float3 const& normal) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetFocusPointWithNormal(*(void**)(&coordinateSystem), impl::bind_in(position), impl::bind_in(normal)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>**)this;
            check_hresult(_winrt_abi_type->SetFocusPointWithNormal(*(void**)(&coordinateSystem), impl::bind_in(position), impl::bind_in(normal)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraRenderingParameters<D>::SetFocusPoint(winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const& coordinateSystem, winrt::Windows::Foundation::Numerics::float3 const& position, winrt::Windows::Foundation::Numerics::float3 const& normal, winrt::Windows::Foundation::Numerics::float3 const& linearVelocity) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetFocusPointWithNormalLinearVelocity(*(void**)(&coordinateSystem), impl::bind_in(position), impl::bind_in(normal), impl::bind_in(linearVelocity)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>**)this;
            check_hresult(_winrt_abi_type->SetFocusPointWithNormalLinearVelocity(*(void**)(&coordinateSystem), impl::bind_in(position), impl::bind_in(normal), impl::bind_in(linearVelocity)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraRenderingParameters<D>::Direct3D11Device() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Direct3D11Device(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>**)this;
            check_hresult(_winrt_abi_type->get_Direct3D11Device(&value));
        }
        return winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DDevice{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraRenderingParameters<D>::Direct3D11BackBuffer() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Direct3D11BackBuffer(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>**)this;
            check_hresult(_winrt_abi_type->get_Direct3D11BackBuffer(&value));
        }
        return winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DSurface{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraRenderingParameters2<D>::ReprojectionMode() const
    {
        winrt::Windows::Graphics::Holographic::HolographicReprojectionMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ReprojectionMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2>**)this;
            check_hresult(_winrt_abi_type->get_ReprojectionMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraRenderingParameters2<D>::ReprojectionMode(winrt::Windows::Graphics::Holographic::HolographicReprojectionMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ReprojectionMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2>**)this;
            check_hresult(_winrt_abi_type->put_ReprojectionMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraRenderingParameters2<D>::CommitDirect3D11DepthBuffer(winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DSurface const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CommitDirect3D11DepthBuffer(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2>**)this;
            check_hresult(_winrt_abi_type->CommitDirect3D11DepthBuffer(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraRenderingParameters3<D>::IsContentProtectionEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsContentProtectionEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters3>**)this;
            check_hresult(_winrt_abi_type->get_IsContentProtectionEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraRenderingParameters3<D>::IsContentProtectionEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsContentProtectionEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters3>**)this;
            check_hresult(_winrt_abi_type->put_IsContentProtectionEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraRenderingParameters4<D>::DepthReprojectionMethod() const
    {
        winrt::Windows::Graphics::Holographic::HolographicDepthReprojectionMethod value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DepthReprojectionMethod(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters4>**)this;
            check_hresult(_winrt_abi_type->get_DepthReprojectionMethod(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraRenderingParameters4<D>::DepthReprojectionMethod(winrt::Windows::Graphics::Holographic::HolographicDepthReprojectionMethod const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DepthReprojectionMethod(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters4>**)this;
            check_hresult(_winrt_abi_type->put_DepthReprojectionMethod(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraViewportParameters<D>::HiddenAreaMesh() const
    {
        uint32_t value_impl_size{};
        winrt::Windows::Foundation::Numerics::float2* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraViewportParameters>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraViewportParameters, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraViewportParameters>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HiddenAreaMesh(&value_impl_size, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraViewportParameters>**)this;
            check_hresult(_winrt_abi_type->get_HiddenAreaMesh(&value_impl_size, &value));
        }
        return com_array<winrt::Windows::Foundation::Numerics::float2>{ value, value_impl_size, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicCameraViewportParameters<D>::VisibleAreaMesh() const
    {
        uint32_t value_impl_size{};
        winrt::Windows::Foundation::Numerics::float2* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicCameraViewportParameters>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicCameraViewportParameters, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraViewportParameters>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VisibleAreaMesh(&value_impl_size, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicCameraViewportParameters>**)this;
            check_hresult(_winrt_abi_type->get_VisibleAreaMesh(&value_impl_size, &value));
        }
        return com_array<winrt::Windows::Foundation::Numerics::float2>{ value, value_impl_size, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicDisplay<D>::DisplayName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DisplayName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay>**)this;
            check_hresult(_winrt_abi_type->get_DisplayName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicDisplay<D>::MaxViewportSize() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxViewportSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay>**)this;
            check_hresult(_winrt_abi_type->get_MaxViewportSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicDisplay<D>::IsStereo() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStereo(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay>**)this;
            check_hresult(_winrt_abi_type->get_IsStereo(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicDisplay<D>::IsOpaque() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsOpaque(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay>**)this;
            check_hresult(_winrt_abi_type->get_IsOpaque(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicDisplay<D>::AdapterId() const
    {
        winrt::Windows::Graphics::Holographic::HolographicAdapterId value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AdapterId(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay>**)this;
            check_hresult(_winrt_abi_type->get_AdapterId(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicDisplay<D>::SpatialLocator() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SpatialLocator(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay>**)this;
            check_hresult(_winrt_abi_type->get_SpatialLocator(&value));
        }
        return winrt::Windows::Perception::Spatial::SpatialLocator{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicDisplay2<D>::RefreshRate() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RefreshRate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay2>**)this;
            check_hresult(_winrt_abi_type->get_RefreshRate(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicDisplay3<D>::TryGetViewConfiguration(winrt::Windows::Graphics::Holographic::HolographicViewConfigurationKind const& kind) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicDisplay3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetViewConfiguration(static_cast<int32_t>(kind), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplay3>**)this;
            check_hresult(_winrt_abi_type->TryGetViewConfiguration(static_cast<int32_t>(kind), &result));
        }
        return winrt::Windows::Graphics::Holographic::HolographicViewConfiguration{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicDisplayStatics<D>::GetDefault() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicDisplayStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicDisplayStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplayStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDefault(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicDisplayStatics>**)this;
            check_hresult(_winrt_abi_type->GetDefault(&result));
        }
        return winrt::Windows::Graphics::Holographic::HolographicDisplay{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrame<D>::AddedCameras() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrame>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrame, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AddedCameras(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)this;
            check_hresult(_winrt_abi_type->get_AddedCameras(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::Holographic::HolographicCamera>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrame<D>::RemovedCameras() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrame>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrame, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RemovedCameras(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)this;
            check_hresult(_winrt_abi_type->get_RemovedCameras(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::Holographic::HolographicCamera>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrame<D>::GetRenderingParameters(winrt::Windows::Graphics::Holographic::HolographicCameraPose const& cameraPose) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrame>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrame, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetRenderingParameters(*(void**)(&cameraPose), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)this;
            check_hresult(_winrt_abi_type->GetRenderingParameters(*(void**)(&cameraPose), &value));
        }
        return winrt::Windows::Graphics::Holographic::HolographicCameraRenderingParameters{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrame<D>::Duration() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrame>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrame, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Duration(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)this;
            check_hresult(_winrt_abi_type->get_Duration(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrame<D>::CurrentPrediction() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrame>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrame, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CurrentPrediction(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)this;
            check_hresult(_winrt_abi_type->get_CurrentPrediction(&value));
        }
        return winrt::Windows::Graphics::Holographic::HolographicFramePrediction{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrame<D>::UpdateCurrentPrediction() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrame>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrame, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateCurrentPrediction());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)this;
            check_hresult(_winrt_abi_type->UpdateCurrentPrediction());
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrame<D>::PresentUsingCurrentPrediction() const
    {
        winrt::Windows::Graphics::Holographic::HolographicFramePresentResult result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrame>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrame, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PresentUsingCurrentPrediction(reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)this;
            check_hresult(_winrt_abi_type->PresentUsingCurrentPrediction(reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrame<D>::PresentUsingCurrentPrediction(winrt::Windows::Graphics::Holographic::HolographicFramePresentWaitBehavior const& waitBehavior) const
    {
        winrt::Windows::Graphics::Holographic::HolographicFramePresentResult result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrame>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrame, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PresentUsingCurrentPredictionWithBehavior(static_cast<int32_t>(waitBehavior), reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)this;
            check_hresult(_winrt_abi_type->PresentUsingCurrentPredictionWithBehavior(static_cast<int32_t>(waitBehavior), reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrame<D>::WaitForFrameToFinish() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrame>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrame, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WaitForFrameToFinish());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame>**)this;
            check_hresult(_winrt_abi_type->WaitForFrameToFinish());
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrame2<D>::GetQuadLayerUpdateParameters(winrt::Windows::Graphics::Holographic::HolographicQuadLayer const& layer) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrame2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrame2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetQuadLayerUpdateParameters(*(void**)(&layer), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame2>**)this;
            check_hresult(_winrt_abi_type->GetQuadLayerUpdateParameters(*(void**)(&layer), &value));
        }
        return winrt::Windows::Graphics::Holographic::HolographicQuadLayerUpdateParameters{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrame3<D>::Id() const
    {
        winrt::Windows::Graphics::Holographic::HolographicFrameId value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrame3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrame3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrame3>**)this;
            check_hresult(_winrt_abi_type->get_Id(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFramePrediction<D>::CameraPoses() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFramePrediction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFramePrediction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePrediction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CameraPoses(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePrediction>**)this;
            check_hresult(_winrt_abi_type->get_CameraPoses(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::Holographic::HolographicCameraPose>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFramePrediction<D>::Timestamp() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFramePrediction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFramePrediction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePrediction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Timestamp(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePrediction>**)this;
            check_hresult(_winrt_abi_type->get_Timestamp(&value));
        }
        return winrt::Windows::Perception::PerceptionTimestamp{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFramePresentationMonitor<D>::ReadReports() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFramePresentationMonitor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationMonitor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationMonitor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadReports(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationMonitor>**)this;
            check_hresult(_winrt_abi_type->ReadReports(&result));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::Holographic::HolographicFramePresentationReport>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFramePresentationReport<D>::CompositorGpuDuration() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CompositorGpuDuration(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>**)this;
            check_hresult(_winrt_abi_type->get_CompositorGpuDuration(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFramePresentationReport<D>::AppGpuDuration() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppGpuDuration(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>**)this;
            check_hresult(_winrt_abi_type->get_AppGpuDuration(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFramePresentationReport<D>::AppGpuOverrun() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppGpuOverrun(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>**)this;
            check_hresult(_winrt_abi_type->get_AppGpuOverrun(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFramePresentationReport<D>::MissedPresentationOpportunityCount() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MissedPresentationOpportunityCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>**)this;
            check_hresult(_winrt_abi_type->get_MissedPresentationOpportunityCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFramePresentationReport<D>::PresentationCount() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PresentationCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>**)this;
            check_hresult(_winrt_abi_type->get_PresentationCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrameRenderingReport<D>::FrameId() const
    {
        winrt::Windows::Graphics::Holographic::HolographicFrameId value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FrameId(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>**)this;
            check_hresult(_winrt_abi_type->get_FrameId(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrameRenderingReport<D>::MissedLatchCount() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MissedLatchCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>**)this;
            check_hresult(_winrt_abi_type->get_MissedLatchCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrameRenderingReport<D>::SystemRelativeFrameReadyTime() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SystemRelativeFrameReadyTime(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>**)this;
            check_hresult(_winrt_abi_type->get_SystemRelativeFrameReadyTime(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrameRenderingReport<D>::SystemRelativeActualGpuFinishTime() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SystemRelativeActualGpuFinishTime(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>**)this;
            check_hresult(_winrt_abi_type->get_SystemRelativeActualGpuFinishTime(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrameRenderingReport<D>::SystemRelativeTargetLatchTime() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SystemRelativeTargetLatchTime(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>**)this;
            check_hresult(_winrt_abi_type->get_SystemRelativeTargetLatchTime(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrameScanoutMonitor<D>::ReadReports() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutMonitor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutMonitor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutMonitor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadReports(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutMonitor>**)this;
            check_hresult(_winrt_abi_type->ReadReports(&result));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Graphics::Holographic::HolographicFrameScanoutReport>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrameScanoutReport<D>::RenderingReport() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RenderingReport(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>**)this;
            check_hresult(_winrt_abi_type->get_RenderingReport(&value));
        }
        return winrt::Windows::Graphics::Holographic::HolographicFrameRenderingReport{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrameScanoutReport<D>::MissedScanoutCount() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MissedScanoutCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>**)this;
            check_hresult(_winrt_abi_type->get_MissedScanoutCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrameScanoutReport<D>::SystemRelativeLatchTime() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SystemRelativeLatchTime(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>**)this;
            check_hresult(_winrt_abi_type->get_SystemRelativeLatchTime(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrameScanoutReport<D>::SystemRelativeScanoutStartTime() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SystemRelativeScanoutStartTime(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>**)this;
            check_hresult(_winrt_abi_type->get_SystemRelativeScanoutStartTime(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicFrameScanoutReport<D>::SystemRelativePhotonTime() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SystemRelativePhotonTime(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>**)this;
            check_hresult(_winrt_abi_type->get_SystemRelativePhotonTime(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicQuadLayer<D>::PixelFormat() const
    {
        winrt::Windows::Graphics::DirectX::DirectXPixelFormat value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicQuadLayer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PixelFormat(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayer>**)this;
            check_hresult(_winrt_abi_type->get_PixelFormat(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicQuadLayer<D>::Size() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicQuadLayer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayer>**)this;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicQuadLayerFactory<D>::Create(winrt::Windows::Foundation::Size const& size) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Create(impl::bind_in(size), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerFactory>**)this;
            check_hresult(_winrt_abi_type->Create(impl::bind_in(size), &value));
        }
        return winrt::Windows::Graphics::Holographic::HolographicQuadLayer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicQuadLayerFactory<D>::CreateWithPixelFormat(winrt::Windows::Foundation::Size const& size, winrt::Windows::Graphics::DirectX::DirectXPixelFormat const& pixelFormat) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateWithPixelFormat(impl::bind_in(size), static_cast<int32_t>(pixelFormat), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerFactory>**)this;
            check_hresult(_winrt_abi_type->CreateWithPixelFormat(impl::bind_in(size), static_cast<int32_t>(pixelFormat), &value));
        }
        return winrt::Windows::Graphics::Holographic::HolographicQuadLayer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicQuadLayerUpdateParameters<D>::AcquireBufferToUpdateContent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AcquireBufferToUpdateContent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>**)this;
            check_hresult(_winrt_abi_type->AcquireBufferToUpdateContent(&value));
        }
        return winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DSurface{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicQuadLayerUpdateParameters<D>::UpdateViewport(winrt::Windows::Foundation::Rect const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateViewport(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>**)this;
            check_hresult(_winrt_abi_type->UpdateViewport(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicQuadLayerUpdateParameters<D>::UpdateContentProtectionEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateContentProtectionEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>**)this;
            check_hresult(_winrt_abi_type->UpdateContentProtectionEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicQuadLayerUpdateParameters<D>::UpdateExtents(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateExtents(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>**)this;
            check_hresult(_winrt_abi_type->UpdateExtents(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicQuadLayerUpdateParameters<D>::UpdateLocationWithStationaryMode(winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const& coordinateSystem, winrt::Windows::Foundation::Numerics::float3 const& position, winrt::Windows::Foundation::Numerics::quaternion const& orientation) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateLocationWithStationaryMode(*(void**)(&coordinateSystem), impl::bind_in(position), impl::bind_in(orientation)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>**)this;
            check_hresult(_winrt_abi_type->UpdateLocationWithStationaryMode(*(void**)(&coordinateSystem), impl::bind_in(position), impl::bind_in(orientation)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicQuadLayerUpdateParameters<D>::UpdateLocationWithDisplayRelativeMode(winrt::Windows::Foundation::Numerics::float3 const& position, winrt::Windows::Foundation::Numerics::quaternion const& orientation) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateLocationWithDisplayRelativeMode(impl::bind_in(position), impl::bind_in(orientation)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>**)this;
            check_hresult(_winrt_abi_type->UpdateLocationWithDisplayRelativeMode(impl::bind_in(position), impl::bind_in(orientation)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicQuadLayerUpdateParameters2<D>::CanAcquireWithHardwareProtection() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanAcquireWithHardwareProtection(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters2>**)this;
            check_hresult(_winrt_abi_type->get_CanAcquireWithHardwareProtection(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicQuadLayerUpdateParameters2<D>::AcquireBufferToUpdateContentWithHardwareProtection() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AcquireBufferToUpdateContentWithHardwareProtection(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters2>**)this;
            check_hresult(_winrt_abi_type->AcquireBufferToUpdateContentWithHardwareProtection(&value));
        }
        return winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DSurface{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace<D>::PrimaryAdapterId() const
    {
        winrt::Windows::Graphics::Holographic::HolographicAdapterId value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PrimaryAdapterId(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)this;
            check_hresult(_winrt_abi_type->get_PrimaryAdapterId(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace<D>::SetDirect3D11Device(winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DDevice const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetDirect3D11Device(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)this;
            check_hresult(_winrt_abi_type->SetDirect3D11Device(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace<D>::CameraAdded(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Graphics::Holographic::HolographicSpace, winrt::Windows::Graphics::Holographic::HolographicSpaceCameraAddedEventArgs> const& handler) const
    {
        winrt::event_token cookie{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_CameraAdded(*(void**)(&handler), put_abi(cookie)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)this;
            check_hresult(_winrt_abi_type->add_CameraAdded(*(void**)(&handler), put_abi(cookie)));
        }
        return cookie;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace<D>::CameraAdded(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Graphics::Holographic::HolographicSpace, winrt::Windows::Graphics::Holographic::HolographicSpaceCameraAddedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, CameraAdded_revoker>(this, CameraAdded(handler));
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace<D>::CameraAdded(winrt::event_token const& cookie) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)&_winrt_casted_result;
            _winrt_abi_type->remove_CameraAdded(impl::bind_in(cookie));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)this;
            _winrt_abi_type->remove_CameraAdded(impl::bind_in(cookie));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace<D>::CameraRemoved(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Graphics::Holographic::HolographicSpace, winrt::Windows::Graphics::Holographic::HolographicSpaceCameraRemovedEventArgs> const& handler) const
    {
        winrt::event_token cookie{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_CameraRemoved(*(void**)(&handler), put_abi(cookie)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)this;
            check_hresult(_winrt_abi_type->add_CameraRemoved(*(void**)(&handler), put_abi(cookie)));
        }
        return cookie;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace<D>::CameraRemoved(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Graphics::Holographic::HolographicSpace, winrt::Windows::Graphics::Holographic::HolographicSpaceCameraRemovedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, CameraRemoved_revoker>(this, CameraRemoved(handler));
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace<D>::CameraRemoved(winrt::event_token const& cookie) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)&_winrt_casted_result;
            _winrt_abi_type->remove_CameraRemoved(impl::bind_in(cookie));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)this;
            _winrt_abi_type->remove_CameraRemoved(impl::bind_in(cookie));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace<D>::CreateNextFrame() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateNextFrame(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace>**)this;
            check_hresult(_winrt_abi_type->CreateNextFrame(&value));
        }
        return winrt::Windows::Graphics::Holographic::HolographicFrame{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace2<D>::UserPresence() const
    {
        winrt::Windows::Graphics::Holographic::HolographicSpaceUserPresence value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UserPresence(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace2>**)this;
            check_hresult(_winrt_abi_type->get_UserPresence(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace2<D>::UserPresenceChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Graphics::Holographic::HolographicSpace, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_UserPresenceChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace2>**)this;
            check_hresult(_winrt_abi_type->add_UserPresenceChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace2<D>::UserPresenceChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Graphics::Holographic::HolographicSpace, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, UserPresenceChanged_revoker>(this, UserPresenceChanged(handler));
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace2<D>::UserPresenceChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace2>**)&_winrt_casted_result;
            _winrt_abi_type->remove_UserPresenceChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace2>**)this;
            _winrt_abi_type->remove_UserPresenceChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace2<D>::WaitForNextFrameReady() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WaitForNextFrameReady());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace2>**)this;
            check_hresult(_winrt_abi_type->WaitForNextFrameReady());
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace2<D>::WaitForNextFrameReadyWithHeadStart(winrt::Windows::Foundation::TimeSpan const& requestedHeadStartDuration) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WaitForNextFrameReadyWithHeadStart(impl::bind_in(requestedHeadStartDuration)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace2>**)this;
            check_hresult(_winrt_abi_type->WaitForNextFrameReadyWithHeadStart(impl::bind_in(requestedHeadStartDuration)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace2<D>::CreateFramePresentationMonitor(uint32_t maxQueuedReports) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFramePresentationMonitor(maxQueuedReports, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace2>**)this;
            check_hresult(_winrt_abi_type->CreateFramePresentationMonitor(maxQueuedReports, &result));
        }
        return winrt::Windows::Graphics::Holographic::HolographicFramePresentationMonitor{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpace3<D>::CreateFrameScanoutMonitor(uint32_t maxQueuedReports) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpace3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpace3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFrameScanoutMonitor(maxQueuedReports, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpace3>**)this;
            check_hresult(_winrt_abi_type->CreateFrameScanoutMonitor(maxQueuedReports, &result));
        }
        return winrt::Windows::Graphics::Holographic::HolographicFrameScanoutMonitor{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpaceCameraAddedEventArgs<D>::Camera() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraAddedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraAddedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraAddedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Camera(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraAddedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Camera(&value));
        }
        return winrt::Windows::Graphics::Holographic::HolographicCamera{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpaceCameraAddedEventArgs<D>::GetDeferral() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraAddedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraAddedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraAddedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeferral(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraAddedEventArgs>**)this;
            check_hresult(_winrt_abi_type->GetDeferral(&value));
        }
        return winrt::Windows::Foundation::Deferral{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpaceCameraRemovedEventArgs<D>::Camera() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraRemovedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraRemovedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraRemovedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Camera(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraRemovedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Camera(&value));
        }
        return winrt::Windows::Graphics::Holographic::HolographicCamera{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpaceStatics<D>::CreateForCoreWindow(winrt::Windows::UI::Core::CoreWindow const& window) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateForCoreWindow(*(void**)(&window), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics>**)this;
            check_hresult(_winrt_abi_type->CreateForCoreWindow(*(void**)(&window), &value));
        }
        return winrt::Windows::Graphics::Holographic::HolographicSpace{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpaceStatics2<D>::IsSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>**)this;
            check_hresult(_winrt_abi_type->get_IsSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpaceStatics2<D>::IsAvailable() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsAvailable(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>**)this;
            check_hresult(_winrt_abi_type->get_IsAvailable(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpaceStatics2<D>::IsAvailableChanged(winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_IsAvailableChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>**)this;
            check_hresult(_winrt_abi_type->add_IsAvailableChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpaceStatics2<D>::IsAvailableChanged(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, IsAvailableChanged_revoker>(this, IsAvailableChanged(handler));
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpaceStatics2<D>::IsAvailableChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>**)&_winrt_casted_result;
            _winrt_abi_type->remove_IsAvailableChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>**)this;
            _winrt_abi_type->remove_IsAvailableChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicSpaceStatics3<D>::IsConfigured() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsConfigured(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics3>**)this;
            check_hresult(_winrt_abi_type->get_IsConfigured(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicViewConfiguration<D>::NativeRenderTargetSize() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_NativeRenderTargetSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_NativeRenderTargetSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicViewConfiguration<D>::RenderTargetSize() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RenderTargetSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_RenderTargetSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicViewConfiguration<D>::RequestRenderTargetSize(winrt::Windows::Foundation::Size const& size) const
    {
        winrt::Windows::Foundation::Size result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestRenderTargetSize(impl::bind_in(size), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)this;
            check_hresult(_winrt_abi_type->RequestRenderTargetSize(impl::bind_in(size), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicViewConfiguration<D>::SupportedPixelFormats() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedPixelFormats(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_SupportedPixelFormats(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicViewConfiguration<D>::PixelFormat() const
    {
        winrt::Windows::Graphics::DirectX::DirectXPixelFormat value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PixelFormat(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_PixelFormat(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicViewConfiguration<D>::PixelFormat(winrt::Windows::Graphics::DirectX::DirectXPixelFormat const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_PixelFormat(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)this;
            check_hresult(_winrt_abi_type->put_PixelFormat(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicViewConfiguration<D>::IsStereo() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStereo(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_IsStereo(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicViewConfiguration<D>::RefreshRate() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RefreshRate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_RefreshRate(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicViewConfiguration<D>::Kind() const
    {
        winrt::Windows::Graphics::Holographic::HolographicViewConfigurationKind value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Kind(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_Kind(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicViewConfiguration<D>::Display() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Display(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_Display(&value));
        }
        return winrt::Windows::Graphics::Holographic::HolographicDisplay{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicViewConfiguration<D>::IsEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicViewConfiguration<D>::IsEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>**)this;
            check_hresult(_winrt_abi_type->put_IsEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Graphics_Holographic_IHolographicViewConfiguration2<D>::SupportedDepthReprojectionMethods() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedDepthReprojectionMethods(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration2>**)this;
            check_hresult(_winrt_abi_type->get_SupportedDepthReprojectionMethods(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::Holographic::HolographicDepthReprojectionMethod>{ value, take_ownership_from_abi };
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicCamera> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicCamera>
    {
        int32_t __stdcall get_RenderTargetSize(winrt::Windows::Foundation::Size* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Size>(this->shim().RenderTargetSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ViewportScaleFactor(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().ViewportScaleFactor());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ViewportScaleFactor(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ViewportScaleFactor(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStereo(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStereo());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Id(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetNearPlaneDistance(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetNearPlaneDistance(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetFarPlaneDistance(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetFarPlaneDistance(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicCamera2> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicCamera2>
    {
        int32_t __stdcall get_LeftViewportParameters(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Graphics::Holographic::HolographicCameraViewportParameters>(this->shim().LeftViewportParameters());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RightViewportParameters(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Graphics::Holographic::HolographicCameraViewportParameters>(this->shim().RightViewportParameters());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Display(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Graphics::Holographic::HolographicDisplay>(this->shim().Display());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicCamera3> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicCamera3>
    {
        int32_t __stdcall get_IsPrimaryLayerEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsPrimaryLayerEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsPrimaryLayerEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsPrimaryLayerEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxQuadLayerCount(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().MaxQuadLayerCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_QuadLayers(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Graphics::Holographic::HolographicQuadLayer>>(this->shim().QuadLayers());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicCamera4> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicCamera4>
    {
        int32_t __stdcall get_CanOverrideViewport(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().CanOverrideViewport());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicCamera5> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicCamera5>
    {
        int32_t __stdcall get_IsHardwareContentProtectionSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsHardwareContentProtectionSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsHardwareContentProtectionEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsHardwareContentProtectionEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsHardwareContentProtectionEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsHardwareContentProtectionEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicCamera6> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicCamera6>
    {
        int32_t __stdcall get_ViewConfiguration(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicViewConfiguration>(this->shim().ViewConfiguration());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose>
    {
        int32_t __stdcall get_HolographicCamera(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicCamera>(this->shim().HolographicCamera());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Viewport(winrt::Windows::Foundation::Rect* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Rect>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Rect>(this->shim().Viewport());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetViewTransform(void* coordinateSystem, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::Graphics::Holographic::HolographicStereoTransform>>(this->shim().TryGetViewTransform(*reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const*>(&coordinateSystem)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ProjectionTransform(struct struct_Windows_Graphics_Holographic_HolographicStereoTransform* value) noexcept final try
        {
            zero_abi<winrt::Windows::Graphics::Holographic::HolographicStereoTransform>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicStereoTransform>(this->shim().ProjectionTransform());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetCullingFrustum(void* coordinateSystem, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::Perception::Spatial::SpatialBoundingFrustum>>(this->shim().TryGetCullingFrustum(*reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const*>(&coordinateSystem)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetVisibleFrustum(void* coordinateSystem, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::Perception::Spatial::SpatialBoundingFrustum>>(this->shim().TryGetVisibleFrustum(*reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const*>(&coordinateSystem)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_NearPlaneDistance(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().NearPlaneDistance());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FarPlaneDistance(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().FarPlaneDistance());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose2> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicCameraPose2>
    {
        int32_t __stdcall OverrideViewTransform(void* coordinateSystem, struct struct_Windows_Graphics_Holographic_HolographicStereoTransform coordinateSystemToViewTransform) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OverrideViewTransform(*reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const*>(&coordinateSystem), *reinterpret_cast<winrt::Windows::Graphics::Holographic::HolographicStereoTransform const*>(&coordinateSystemToViewTransform));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OverrideProjectionTransform(struct struct_Windows_Graphics_Holographic_HolographicStereoTransform projectionTransform) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OverrideProjectionTransform(*reinterpret_cast<winrt::Windows::Graphics::Holographic::HolographicStereoTransform const*>(&projectionTransform));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OverrideViewport(winrt::Windows::Foundation::Rect leftViewport, winrt::Windows::Foundation::Rect rightViewport) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OverrideViewport(*reinterpret_cast<winrt::Windows::Foundation::Rect const*>(&leftViewport), *reinterpret_cast<winrt::Windows::Foundation::Rect const*>(&rightViewport));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters>
    {
        int32_t __stdcall SetFocusPoint(void* coordinateSystem, winrt::Windows::Foundation::Numerics::float3 position) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetFocusPoint(*reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const*>(&coordinateSystem), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&position));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetFocusPointWithNormal(void* coordinateSystem, winrt::Windows::Foundation::Numerics::float3 position, winrt::Windows::Foundation::Numerics::float3 normal) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetFocusPoint(*reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const*>(&coordinateSystem), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&position), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&normal));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetFocusPointWithNormalLinearVelocity(void* coordinateSystem, winrt::Windows::Foundation::Numerics::float3 position, winrt::Windows::Foundation::Numerics::float3 normal, winrt::Windows::Foundation::Numerics::float3 linearVelocity) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetFocusPoint(*reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const*>(&coordinateSystem), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&position), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&normal), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&linearVelocity));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Direct3D11Device(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DDevice>(this->shim().Direct3D11Device());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Direct3D11BackBuffer(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DSurface>(this->shim().Direct3D11BackBuffer());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2>
    {
        int32_t __stdcall get_ReprojectionMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicReprojectionMode>(this->shim().ReprojectionMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ReprojectionMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReprojectionMode(*reinterpret_cast<winrt::Windows::Graphics::Holographic::HolographicReprojectionMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CommitDirect3D11DepthBuffer(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CommitDirect3D11DepthBuffer(*reinterpret_cast<winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DSurface const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters3> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters3>
    {
        int32_t __stdcall get_IsContentProtectionEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsContentProtectionEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsContentProtectionEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsContentProtectionEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters4> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters4>
    {
        int32_t __stdcall get_DepthReprojectionMethod(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicDepthReprojectionMethod>(this->shim().DepthReprojectionMethod());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DepthReprojectionMethod(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DepthReprojectionMethod(*reinterpret_cast<winrt::Windows::Graphics::Holographic::HolographicDepthReprojectionMethod const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicCameraViewportParameters> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicCameraViewportParameters>
    {
        int32_t __stdcall get_HiddenAreaMesh(uint32_t* __valueSize, winrt::Windows::Foundation::Numerics::float2** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            std::tie(*__valueSize, *value) = detach_abi(this->shim().HiddenAreaMesh());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VisibleAreaMesh(uint32_t* __valueSize, winrt::Windows::Foundation::Numerics::float2** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            std::tie(*__valueSize, *value) = detach_abi(this->shim().VisibleAreaMesh());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay>
    {
        int32_t __stdcall get_DisplayName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DisplayName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxViewportSize(winrt::Windows::Foundation::Size* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Size>(this->shim().MaxViewportSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStereo(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStereo());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsOpaque(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsOpaque());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AdapterId(struct struct_Windows_Graphics_Holographic_HolographicAdapterId* value) noexcept final try
        {
            zero_abi<winrt::Windows::Graphics::Holographic::HolographicAdapterId>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicAdapterId>(this->shim().AdapterId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SpatialLocator(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Perception::Spatial::SpatialLocator>(this->shim().SpatialLocator());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay2> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay2>
    {
        int32_t __stdcall get_RefreshRate(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().RefreshRate());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay3> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicDisplay3>
    {
        int32_t __stdcall TryGetViewConfiguration(int32_t kind, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Graphics::Holographic::HolographicViewConfiguration>(this->shim().TryGetViewConfiguration(*reinterpret_cast<winrt::Windows::Graphics::Holographic::HolographicViewConfigurationKind const*>(&kind)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicDisplayStatics> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicDisplayStatics>
    {
        int32_t __stdcall GetDefault(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Graphics::Holographic::HolographicDisplay>(this->shim().GetDefault());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicFrame> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicFrame>
    {
        int32_t __stdcall get_AddedCameras(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::Holographic::HolographicCamera>>(this->shim().AddedCameras());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RemovedCameras(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::Holographic::HolographicCamera>>(this->shim().RemovedCameras());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetRenderingParameters(void* cameraPose, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicCameraRenderingParameters>(this->shim().GetRenderingParameters(*reinterpret_cast<winrt::Windows::Graphics::Holographic::HolographicCameraPose const*>(&cameraPose)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Duration(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().Duration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CurrentPrediction(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicFramePrediction>(this->shim().CurrentPrediction());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateCurrentPrediction() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().UpdateCurrentPrediction();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall PresentUsingCurrentPrediction(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Graphics::Holographic::HolographicFramePresentResult>(this->shim().PresentUsingCurrentPrediction());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall PresentUsingCurrentPredictionWithBehavior(int32_t waitBehavior, int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Graphics::Holographic::HolographicFramePresentResult>(this->shim().PresentUsingCurrentPrediction(*reinterpret_cast<winrt::Windows::Graphics::Holographic::HolographicFramePresentWaitBehavior const*>(&waitBehavior)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WaitForFrameToFinish() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().WaitForFrameToFinish();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicFrame2> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicFrame2>
    {
        int32_t __stdcall GetQuadLayerUpdateParameters(void* layer, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicQuadLayerUpdateParameters>(this->shim().GetQuadLayerUpdateParameters(*reinterpret_cast<winrt::Windows::Graphics::Holographic::HolographicQuadLayer const*>(&layer)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicFrame3> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicFrame3>
    {
        int32_t __stdcall get_Id(struct struct_Windows_Graphics_Holographic_HolographicFrameId* value) noexcept final try
        {
            zero_abi<winrt::Windows::Graphics::Holographic::HolographicFrameId>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicFrameId>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicFramePrediction> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicFramePrediction>
    {
        int32_t __stdcall get_CameraPoses(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::Holographic::HolographicCameraPose>>(this->shim().CameraPoses());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Timestamp(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Perception::PerceptionTimestamp>(this->shim().Timestamp());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicFramePresentationMonitor> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicFramePresentationMonitor>
    {
        int32_t __stdcall ReadReports(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::Holographic::HolographicFramePresentationReport>>(this->shim().ReadReports());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport>
    {
        int32_t __stdcall get_CompositorGpuDuration(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().CompositorGpuDuration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AppGpuDuration(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().AppGpuDuration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AppGpuOverrun(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().AppGpuOverrun());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MissedPresentationOpportunityCount(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().MissedPresentationOpportunityCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PresentationCount(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().PresentationCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport>
    {
        int32_t __stdcall get_FrameId(struct struct_Windows_Graphics_Holographic_HolographicFrameId* value) noexcept final try
        {
            zero_abi<winrt::Windows::Graphics::Holographic::HolographicFrameId>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicFrameId>(this->shim().FrameId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MissedLatchCount(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().MissedLatchCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SystemRelativeFrameReadyTime(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().SystemRelativeFrameReadyTime());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SystemRelativeActualGpuFinishTime(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().SystemRelativeActualGpuFinishTime());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SystemRelativeTargetLatchTime(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().SystemRelativeTargetLatchTime());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutMonitor> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutMonitor>
    {
        int32_t __stdcall ReadReports(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Graphics::Holographic::HolographicFrameScanoutReport>>(this->shim().ReadReports());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport>
    {
        int32_t __stdcall get_RenderingReport(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicFrameRenderingReport>(this->shim().RenderingReport());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MissedScanoutCount(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().MissedScanoutCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SystemRelativeLatchTime(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().SystemRelativeLatchTime());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SystemRelativeScanoutStartTime(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().SystemRelativeScanoutStartTime());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SystemRelativePhotonTime(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().SystemRelativePhotonTime());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayer> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayer>
    {
        int32_t __stdcall get_PixelFormat(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>(this->shim().PixelFormat());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Size(winrt::Windows::Foundation::Size* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Size>(this->shim().Size());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerFactory> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerFactory>
    {
        int32_t __stdcall Create(winrt::Windows::Foundation::Size size, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicQuadLayer>(this->shim().Create(*reinterpret_cast<winrt::Windows::Foundation::Size const*>(&size)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateWithPixelFormat(winrt::Windows::Foundation::Size size, int32_t pixelFormat, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicQuadLayer>(this->shim().CreateWithPixelFormat(*reinterpret_cast<winrt::Windows::Foundation::Size const*>(&size), *reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXPixelFormat const*>(&pixelFormat)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters>
    {
        int32_t __stdcall AcquireBufferToUpdateContent(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DSurface>(this->shim().AcquireBufferToUpdateContent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateViewport(winrt::Windows::Foundation::Rect value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().UpdateViewport(*reinterpret_cast<winrt::Windows::Foundation::Rect const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateContentProtectionEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().UpdateContentProtectionEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateExtents(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().UpdateExtents(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateLocationWithStationaryMode(void* coordinateSystem, winrt::Windows::Foundation::Numerics::float3 position, winrt::Windows::Foundation::Numerics::quaternion orientation) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().UpdateLocationWithStationaryMode(*reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const*>(&coordinateSystem), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&position), *reinterpret_cast<winrt::Windows::Foundation::Numerics::quaternion const*>(&orientation));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateLocationWithDisplayRelativeMode(winrt::Windows::Foundation::Numerics::float3 position, winrt::Windows::Foundation::Numerics::quaternion orientation) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().UpdateLocationWithDisplayRelativeMode(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&position), *reinterpret_cast<winrt::Windows::Foundation::Numerics::quaternion const*>(&orientation));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters2> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters2>
    {
        int32_t __stdcall get_CanAcquireWithHardwareProtection(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().CanAcquireWithHardwareProtection());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AcquireBufferToUpdateContentWithHardwareProtection(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DSurface>(this->shim().AcquireBufferToUpdateContentWithHardwareProtection());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicSpace> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicSpace>
    {
        int32_t __stdcall get_PrimaryAdapterId(struct struct_Windows_Graphics_Holographic_HolographicAdapterId* value) noexcept final try
        {
            zero_abi<winrt::Windows::Graphics::Holographic::HolographicAdapterId>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicAdapterId>(this->shim().PrimaryAdapterId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetDirect3D11Device(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetDirect3D11Device(*reinterpret_cast<winrt::Windows::Graphics::DirectX::Direct3D11::IDirect3DDevice const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_CameraAdded(void* handler, winrt::event_token* cookie) noexcept final try
        {
            zero_abi<winrt::event_token>(cookie);
            typename D::abi_guard guard(this->shim());
            *cookie = detach_from<winrt::event_token>(this->shim().CameraAdded(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Graphics::Holographic::HolographicSpace, winrt::Windows::Graphics::Holographic::HolographicSpaceCameraAddedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_CameraAdded(winrt::event_token cookie) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CameraAdded(*reinterpret_cast<winrt::event_token const*>(&cookie));
            return 0;
        }
        int32_t __stdcall add_CameraRemoved(void* handler, winrt::event_token* cookie) noexcept final try
        {
            zero_abi<winrt::event_token>(cookie);
            typename D::abi_guard guard(this->shim());
            *cookie = detach_from<winrt::event_token>(this->shim().CameraRemoved(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Graphics::Holographic::HolographicSpace, winrt::Windows::Graphics::Holographic::HolographicSpaceCameraRemovedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_CameraRemoved(winrt::event_token cookie) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CameraRemoved(*reinterpret_cast<winrt::event_token const*>(&cookie));
            return 0;
        }
        int32_t __stdcall CreateNextFrame(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicFrame>(this->shim().CreateNextFrame());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicSpace2> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicSpace2>
    {
        int32_t __stdcall get_UserPresence(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicSpaceUserPresence>(this->shim().UserPresence());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_UserPresenceChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().UserPresenceChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Graphics::Holographic::HolographicSpace, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_UserPresenceChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().UserPresenceChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall WaitForNextFrameReady() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().WaitForNextFrameReady();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WaitForNextFrameReadyWithHeadStart(int64_t requestedHeadStartDuration) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().WaitForNextFrameReadyWithHeadStart(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&requestedHeadStartDuration));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateFramePresentationMonitor(uint32_t maxQueuedReports, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Graphics::Holographic::HolographicFramePresentationMonitor>(this->shim().CreateFramePresentationMonitor(maxQueuedReports));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicSpace3> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicSpace3>
    {
        int32_t __stdcall CreateFrameScanoutMonitor(uint32_t maxQueuedReports, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Graphics::Holographic::HolographicFrameScanoutMonitor>(this->shim().CreateFrameScanoutMonitor(maxQueuedReports));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraAddedEventArgs> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraAddedEventArgs>
    {
        int32_t __stdcall get_Camera(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicCamera>(this->shim().Camera());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeferral(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Deferral>(this->shim().GetDeferral());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraRemovedEventArgs> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraRemovedEventArgs>
    {
        int32_t __stdcall get_Camera(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicCamera>(this->shim().Camera());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics>
    {
        int32_t __stdcall CreateForCoreWindow(void* window, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicSpace>(this->shim().CreateForCoreWindow(*reinterpret_cast<winrt::Windows::UI::Core::CoreWindow const*>(&window)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>
    {
        int32_t __stdcall get_IsSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsAvailable(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsAvailable());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_IsAvailableChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().IsAvailableChanged(*reinterpret_cast<winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_IsAvailableChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsAvailableChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics3> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics3>
    {
        int32_t __stdcall get_IsConfigured(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsConfigured());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration>
    {
        int32_t __stdcall get_NativeRenderTargetSize(winrt::Windows::Foundation::Size* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Size>(this->shim().NativeRenderTargetSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RenderTargetSize(winrt::Windows::Foundation::Size* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Size>(this->shim().RenderTargetSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestRenderTargetSize(winrt::Windows::Foundation::Size size, winrt::Windows::Foundation::Size* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Size>(this->shim().RequestRenderTargetSize(*reinterpret_cast<winrt::Windows::Foundation::Size const*>(&size)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedPixelFormats(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>>(this->shim().SupportedPixelFormats());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PixelFormat(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>(this->shim().PixelFormat());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_PixelFormat(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PixelFormat(*reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXPixelFormat const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStereo(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStereo());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RefreshRate(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().RefreshRate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Kind(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicViewConfigurationKind>(this->shim().Kind());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Display(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::Holographic::HolographicDisplay>(this->shim().Display());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration2> : produce_base<D, winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration2>
    {
        int32_t __stdcall get_SupportedDepthReprojectionMethods(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::Holographic::HolographicDepthReprojectionMethod>>(this->shim().SupportedDepthReprojectionMethods());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::Graphics::Holographic
{
    inline auto HolographicDisplay::GetDefault()
    {
        return impl::call_factory_cast<winrt::Windows::Graphics::Holographic::HolographicDisplay(*)(IHolographicDisplayStatics const&), HolographicDisplay, IHolographicDisplayStatics>([](IHolographicDisplayStatics const& f) { return f.GetDefault(); });
    }
    inline HolographicQuadLayer::HolographicQuadLayer(winrt::Windows::Foundation::Size const& size) :
        HolographicQuadLayer(impl::call_factory<HolographicQuadLayer, IHolographicQuadLayerFactory>([&](IHolographicQuadLayerFactory const& f) { return f.Create(size); }))
    {
    }
    inline HolographicQuadLayer::HolographicQuadLayer(winrt::Windows::Foundation::Size const& size, winrt::Windows::Graphics::DirectX::DirectXPixelFormat const& pixelFormat) :
        HolographicQuadLayer(impl::call_factory<HolographicQuadLayer, IHolographicQuadLayerFactory>([&](IHolographicQuadLayerFactory const& f) { return f.CreateWithPixelFormat(size, pixelFormat); }))
    {
    }
    inline auto HolographicSpace::CreateForCoreWindow(winrt::Windows::UI::Core::CoreWindow const& window)
    {
        return impl::call_factory<HolographicSpace, IHolographicSpaceStatics>([&](IHolographicSpaceStatics const& f) { return f.CreateForCoreWindow(window); });
    }
    inline auto HolographicSpace::IsSupported()
    {
        return impl::call_factory_cast<bool(*)(IHolographicSpaceStatics2 const&), HolographicSpace, IHolographicSpaceStatics2>([](IHolographicSpaceStatics2 const& f) { return f.IsSupported(); });
    }
    inline auto HolographicSpace::IsAvailable()
    {
        return impl::call_factory_cast<bool(*)(IHolographicSpaceStatics2 const&), HolographicSpace, IHolographicSpaceStatics2>([](IHolographicSpaceStatics2 const& f) { return f.IsAvailable(); });
    }
    inline auto HolographicSpace::IsAvailableChanged(winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler)
    {
        return impl::call_factory<HolographicSpace, IHolographicSpaceStatics2>([&](IHolographicSpaceStatics2 const& f) { return f.IsAvailableChanged(handler); });
    }
    inline auto HolographicSpace::IsAvailableChanged(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler)
    {
        auto f = get_activation_factory<HolographicSpace, winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2>();
        return HolographicSpace::IsAvailableChanged_revoker{ f, f.IsAvailableChanged(handler) };
    }
    inline auto HolographicSpace::IsAvailableChanged(winrt::event_token const& token)
    {
        impl::call_factory<HolographicSpace, IHolographicSpaceStatics2>([&](IHolographicSpaceStatics2 const& f) { return f.IsAvailableChanged(token); });
    }
    inline auto HolographicSpace::IsConfigured()
    {
        return impl::call_factory_cast<bool(*)(IHolographicSpaceStatics3 const&), HolographicSpace, IHolographicSpaceStatics3>([](IHolographicSpaceStatics3 const& f) { return f.IsConfigured(); });
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicCamera> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicCamera2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicCamera3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicCamera4> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicCamera5> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicCamera6> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicCameraPose> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicCameraPose2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicCameraRenderingParameters4> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicCameraViewportParameters> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicDisplay> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicDisplay2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicDisplay3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicDisplayStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicFrame> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicFrame2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicFrame3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicFramePrediction> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationMonitor> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicFramePresentationReport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicFrameRenderingReport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutMonitor> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicFrameScanoutReport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicQuadLayer> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicQuadLayerUpdateParameters2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicSpace> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicSpace2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicSpace3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraAddedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicSpaceCameraRemovedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicSpaceStatics3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::IHolographicViewConfiguration2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicCamera> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicCameraPose> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicCameraRenderingParameters> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicCameraViewportParameters> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicDisplay> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicFrame> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicFramePrediction> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicFramePresentationMonitor> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicFramePresentationReport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicFrameRenderingReport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicFrameScanoutMonitor> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicFrameScanoutReport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicQuadLayer> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicQuadLayerUpdateParameters> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicSpace> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicSpaceCameraAddedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicSpaceCameraRemovedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Holographic::HolographicViewConfiguration> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
