// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Graphics_Effects_H
#define WINRT_Windows_Graphics_Effects_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Graphics.h"
#include "winrt/impl/Windows.Graphics.Effects.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Graphics_Effects_IGraphicsEffect<D>::Name() const
    {
        void* name{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Effects::IGraphicsEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Effects::IGraphicsEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Effects::IGraphicsEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Name(&name));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Effects::IGraphicsEffect>**)this;
            check_hresult(_winrt_abi_type->get_Name(&name));
        }
        return hstring{ name, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Graphics_Effects_IGraphicsEffect<D>::Name(param::hstring const& name) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Graphics::Effects::IGraphicsEffect>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Graphics::Effects::IGraphicsEffect, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Effects::IGraphicsEffect>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Name(*(void**)(&name)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Graphics::Effects::IGraphicsEffect>**)this;
            check_hresult(_winrt_abi_type->put_Name(*(void**)(&name)));
        }
    }
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Effects::IGraphicsEffect> : produce_base<D, winrt::Windows::Graphics::Effects::IGraphicsEffect>
    {
        int32_t __stdcall get_Name(void** name) noexcept final try
        {
            clear_abi(name);
            typename D::abi_guard guard(this->shim());
            *name = detach_from<hstring>(this->shim().Name());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Name(void* name) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Name(*reinterpret_cast<hstring const*>(&name));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Graphics::Effects::IGraphicsEffectSource> : produce_base<D, winrt::Windows::Graphics::Effects::IGraphicsEffectSource>
    {
    };
}
WINRT_EXPORT namespace winrt::Windows::Graphics::Effects
{
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Graphics::Effects::IGraphicsEffect> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Graphics::Effects::IGraphicsEffectSource> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
