/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.autoupdate.Downloader;

public class DownloadManager
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger(DownloadManager.class);
    private final int initiator;
    private Collection<Downloader> currentDownloads = new ConcurrentLinkedQueue<Downloader>();
    private Collection<Downloader> completedDownloads = new ConcurrentLinkedQueue<Downloader>();
    private boolean shutdown = false;
    private boolean cancelDownloads = false;

    @Deprecated
    public DownloadManager(ConnectionParam connectionParam) {
        this(7);
    }

    DownloadManager(int initiator) {
        super("ZAP-DownloadManager");
        this.setDaemon(true);
        this.initiator = initiator;
    }

    public Downloader downloadFile(URL url, File targetFile, long size, String hash) {
        LOGGER.debug("Download file {} to {}", (Object)url, (Object)targetFile.getAbsolutePath());
        Downloader dl = new Downloader(url, targetFile, size, hash, this.initiator);
        dl.start();
        this.currentDownloads.add(dl);
        return dl;
    }

    @Override
    public void run() {
        while (this.getCurrentDownloadCount() > 0 || !this.shutdown) {
            ArrayList<Downloader> finishedDownloads = new ArrayList<Downloader>();
            for (Downloader dl : this.currentDownloads) {
                if (!dl.isAlive()) {
                    if (dl.getException() != null) {
                        LOGGER.debug("Download failed {}", (Object)dl.getTargetFile().getAbsolutePath());
                    } else if (dl.isValidated()) {
                        LOGGER.debug("Download finished {}", (Object)dl.getTargetFile().getAbsolutePath());
                    } else if (dl.isCancelled()) {
                        LOGGER.debug("Download cancelled {}", (Object)dl.getTargetFile().getAbsolutePath());
                    } else {
                        LOGGER.error("Validation failed {}", (Object)dl.getTargetFile().getAbsolutePath());
                        dl.cancelDownload();
                        if (View.isInitialised()) {
                            View.getSingleton().showWarningDialog(Constant.messages.getString("cfu.warn.badhash", dl.getTargetFile().getName()));
                        }
                    }
                    finishedDownloads.add(dl);
                    continue;
                }
                if (this.cancelDownloads) {
                    LOGGER.debug("Cancelling download {}", (Object)dl.getTargetFile().getAbsolutePath());
                    dl.cancelDownload();
                    continue;
                }
                LOGGER.debug("Still downloading {} progress % {}", (Object)dl.getTargetFile().getAbsolutePath(), (Object)dl.getProgressPercent());
            }
            for (Downloader dl : finishedDownloads) {
                this.completedDownloads.add(dl);
                this.currentDownloads.remove(dl);
            }
            try {
                if (this.getCurrentDownloadCount() > 0) {
                    DownloadManager.sleep(200L);
                    continue;
                }
                DownloadManager.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        LOGGER.debug("Shutdown");
    }

    public int getCurrentDownloadCount() {
        return this.currentDownloads.size();
    }

    public void shutdown(boolean cancelDownloads) {
        this.shutdown = true;
        this.cancelDownloads = cancelDownloads;
    }

    public int getProgressPercent(URL url) throws Exception {
        for (Downloader dl : this.currentDownloads) {
            if (!dl.getUrl().equals(url)) continue;
            if (dl.getException() != null) {
                throw dl.getException();
            }
            return dl.getProgressPercent();
        }
        for (Downloader dl : this.completedDownloads) {
            if (!dl.getUrl().equals(url)) continue;
            if (dl.getException() != null) {
                throw dl.getException();
            }
            return 100;
        }
        return -1;
    }

    public List<Downloader> getProgress() {
        ArrayList<Downloader> allDownloads = new ArrayList<Downloader>();
        for (Downloader d : this.currentDownloads) {
            allDownloads.add(d);
        }
        for (Downloader d : this.completedDownloads) {
            allDownloads.add(d);
        }
        return allDownloads;
    }
}

