/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authorization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.authorization.AuthorizationAPI;
import org.zaproxy.zap.extension.authorization.BasicAuthorizationDetectionMethod;
import org.zaproxy.zap.extension.authorization.ContextAuthorizationPanel;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ContextDataFactory;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.ContextPanelFactory;

public class ExtensionAuthorization
extends ExtensionAdaptor
implements ContextPanelFactory,
ContextDataFactory {
    private static final Logger LOGGER = LogManager.getLogger(ExtensionAuthorization.class);
    public static final String NAME = "ExtensionAuthorization";
    private static final int NO_AUTH_METHOD = -1;
    private Map<Integer, ContextAuthorizationPanel> contextPanelsMap = new HashMap<Integer, ContextAuthorizationPanel>();

    public ExtensionAuthorization() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(205);
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("authorization.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addContextDataFactory(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addContextPanelFactory(this);
        }
        extensionHook.addApiImplementor(new AuthorizationAPI());
    }

    @Override
    public AbstractContextPropertiesPanel getContextPanel(Context context) {
        ContextAuthorizationPanel panel = this.contextPanelsMap.get(context.getId());
        if (panel == null) {
            panel = new ContextAuthorizationPanel(this, context.getId());
            this.contextPanelsMap.put(context.getId(), panel);
        }
        return panel;
    }

    @Override
    public void discardContexts() {
        this.contextPanelsMap.clear();
    }

    @Override
    public void discardContext(Context ctx) {
        this.contextPanelsMap.remove(ctx.getId());
    }

    @Override
    public void loadContextData(Session session, Context context) {
        try {
            List<String> loadedData = session.getContextDataStrings(context.getId(), 230);
            if (loadedData != null && loadedData.size() > 0) {
                int type = Integer.parseInt(loadedData.get(0));
                switch (type) {
                    case 0: {
                        context.setAuthorizationDetectionMethod(BasicAuthorizationDetectionMethod.loadMethodFromSession(session, context.getId()));
                    }
                }
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("Unable to load Authorization Detection method.", (Throwable)e);
        }
    }

    @Override
    public void persistContextData(Session session, Context context) {
        try {
            int type = context.getAuthorizationDetectionMethod().getMethodUniqueIdentifier();
            session.setContextData(context.getId(), 230, Integer.toString(type));
            context.getAuthorizationDetectionMethod().persistMethodToSession(session, context.getId());
        }
        catch (DatabaseException e) {
            LOGGER.error("Unable to persist Authorization Detection method.", (Throwable)e);
        }
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public void exportContextData(Context ctx, Configuration config) {
        config.setProperty("context.authorization.type", (Object)ctx.getAuthorizationDetectionMethod().getMethodUniqueIdentifier());
        ctx.getAuthorizationDetectionMethod().exportMethodData(config);
    }

    @Override
    public void importContextData(Context ctx, Configuration config) throws ConfigurationException {
        int type = config.getInt("context.authorization.type", -1);
        switch (type) {
            case 0: {
                ctx.setAuthorizationDetectionMethod(new BasicAuthorizationDetectionMethod(config));
                break;
            }
            default: {
                LOGGER.warn("No authorization detection method found for ID: {}", (Object)type);
            }
        }
    }
}

