/*
 * Decompiled with CFR 0.152.
 */
package hughai.ui;

import hughai.PlayerObjects;
import hughai.ui.ConsoleEntryPoint;
import hughai.utils.Exec;
import hughai.utils.FileHelper;
import hughai.utils.Formatting;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ConsoleJava {
    final String classdir = "console-classes";
    final String jarfilename = "Console.jar";
    final String consoletemplatefilename = "JavaConsoleTemplate.txt";
    JPanel textpanel;
    GridLayout gridLayout;
    JTextArea textarea;
    JButton gobutton;
    JButton quitbutton;
    JTextArea outputTextarea;
    PlayerObjects playerObjects;

    public ConsoleJava(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.init();
    }

    void init() {
        try {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.gridLayout = new GridLayout(2, 1);
            this.textpanel = new JPanel(this.gridLayout);
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            jPanel.add("Center", this.textpanel);
            jPanel.add("South", jPanel2);
            this.textarea = new JTextArea();
            JScrollPane jScrollPane = new JScrollPane(this.textarea);
            this.outputTextarea = new JTextArea();
            JScrollPane jScrollPane2 = new JScrollPane(this.outputTextarea);
            this.gobutton = new JButton("Go");
            this.quitbutton = new JButton("Quit");
            String string = this.playerObjects.getCSAI().getAIDirectoryPath() + "JavaConsoleTemplate.txt";
            FileHelper fileHelper = new FileHelper(this.playerObjects);
            String string2 = fileHelper.readFile(string);
            if (string2 != null) {
                this.textarea.setText(string2);
            } else {
                this.textarea.setText("<Missing file " + string + ">");
            }
            this.gobutton.addActionListener(new GoButton());
            this.quitbutton.addActionListener(new QuitButton());
            this.textpanel.add(jScrollPane);
            this.textpanel.add(jScrollPane2);
            jPanel2.add(this.gobutton);
            jPanel2.add(this.quitbutton);
            this.playerObjects.getMainUI().addPanelToTabbedPanel("Java Console", jPanel);
        }
        catch (Exception exception) {
            this.playerObjects.getLogFile().WriteLine(Formatting.exceptionToStackTrace(exception));
            throw new RuntimeException(exception);
        }
    }

    String localizeClassPath(String string) {
        if (File.separator.equals("/")) {
            return string.replace(";", ":").replace("\\", "/");
        }
        return string.replace(":", ";").replace("/", "\\");
    }

    void debug(Object object) {
        this.playerObjects.getLogFile().WriteLine("" + object);
    }

    class QuitButton
    implements ActionListener {
        QuitButton() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    class GoButton
    implements ActionListener {
        GoButton() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = ConsoleJava.this.playerObjects.getCSAI().getAIDirectoryPath();
                System.out.println(ConsoleJava.this.textarea.getText());
                new File(string + "src-console" + File.separator + "console").mkdirs();
                PrintWriter printWriter = new PrintWriter(string + "src-console" + File.separator + "console" + File.separator + "ConsoleText.java");
                printWriter.write(ConsoleJava.this.textarea.getText());
                printWriter.write("\n");
                printWriter.close();
                new File(string + "console-classes").mkdirs();
                String string2 = ConsoleJava.this.localizeClassPath(ConsoleJava.this.playerObjects.getConfig().getConsoleclasspath());
                string2 = string2.replace("$aidir/", string);
                Exec exec = new Exec(ConsoleJava.this.playerObjects);
                String string3 = "";
                try {
                    string3 = exec.exec("javac -classpath " + string2 + " -d " + string + "console-classes" + " console" + File.separator + "ConsoleText.java", string + "src-console");
                    ConsoleJava.this.debug(string3);
                }
                catch (Exception exception) {
                    ConsoleJava.this.outputTextarea.setText("Error during compilation: " + exception.getMessage());
                    return;
                }
                try {
                    string3 = exec.exec("jar -cf " + string + "Console.jar" + " console", string + "console-classes");
                    ConsoleJava.this.debug(string3);
                }
                catch (Exception exception) {
                    ConsoleJava.this.outputTextarea.setText("Error during jar creation: " + exception.getMessage());
                    return;
                }
                URL[] uRLArray = new URL[]{new File(string + "Console.jar").toURI().toURL()};
                ClassLoader classLoader = ConsoleJava.class.getClassLoader();
                if (classLoader == null) {
                    System.out.println("using system classloader as base");
                    classLoader = ClassLoader.getSystemClassLoader();
                } else {
                    System.out.println("using our classloader as base");
                }
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, classLoader);
                Class<?> clazz = uRLClassLoader.loadClass("console.ConsoleText");
                if (!ConsoleEntryPoint.class.isAssignableFrom(clazz)) {
                    throw new RuntimeException("Invalid class");
                }
                Object obj = clazz.newInstance();
                ConsoleEntryPoint consoleEntryPoint = (ConsoleEntryPoint)obj;
                try {
                    string3 = consoleEntryPoint.go(ConsoleJava.this.playerObjects);
                    ConsoleJava.this.outputTextarea.setText(string3);
                }
                catch (Exception exception) {
                    String string4 = Formatting.exceptionToStackTrace(exception);
                    ConsoleJava.this.outputTextarea.setText(string4);
                }
            }
            catch (Exception exception) {
                ConsoleJava.this.playerObjects.getLogFile().WriteLine(Formatting.exceptionToStackTrace(exception));
            }
        }
    }
}

