/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class CollectionConverter<T, C extends Collection<T>>
implements Converter<C, Object> {
    private final Converter<T, Object> elementConverter;
    private final Function<Integer, C> fn;

    public static <T> CollectionConverter<T, List<T>> forList(Converter<T, Object> elementConverter) {
        return new CollectionConverter(elementConverter, new CreateListFunction());
    }

    public static <T> CollectionConverter<T, Set<T>> forSet(Converter<T, Object> elementConverter) {
        return new CollectionConverter(elementConverter, new CreateSetFunction());
    }

    public CollectionConverter(Converter<T, Object> elementConverter, Function<Integer, C> fn) {
        this.elementConverter = (Converter)Assert.notNull(elementConverter, (String)"Element converter cannot be null.");
        this.fn = (Function)Assert.notNull(fn, (String)"Collection function cannot be null.");
    }

    @Override
    public Object applyTo(C ts) {
        if (Collections.isEmpty(ts)) {
            return ts;
        }
        Collection c = (Collection)this.fn.apply(ts.size());
        for (Object element : ts) {
            Object encoded = this.elementConverter.applyTo(element);
            c.add(encoded);
        }
        return c;
    }

    private C toElementList(Collection<?> c) {
        Assert.notEmpty(c, (String)"Collection cannot be null or empty.");
        Collection result = (Collection)this.fn.apply(c.size());
        for (Object o : c) {
            T element = this.elementConverter.applyFrom(o);
            result.add(element);
        }
        return (C)result;
    }

    @Override
    public C applyFrom(Object value) {
        if (value == null) {
            return null;
        }
        List c = value.getClass().isArray() && !value.getClass().getComponentType().isPrimitive() ? Collections.arrayToList((Object)value) : (value instanceof Collection ? (List)value : java.util.Collections.singletonList(value));
        Object result = Collections.isEmpty((Collection)c) ? (Collection)this.fn.apply(0) : this.toElementList(c);
        return result;
    }

    private static class CreateSetFunction<T>
    implements Function<Integer, Set<T>> {
        private CreateSetFunction() {
        }

        @Override
        public Set<T> apply(Integer size) {
            return size > 0 ? new LinkedHashSet(size) : new LinkedHashSet();
        }
    }

    private static class CreateListFunction<A>
    implements Function<Integer, List<A>> {
        private CreateListFunction() {
        }

        @Override
        public List<A> apply(Integer size) {
            return size > 0 ? new ArrayList(size) : new ArrayList();
        }
    }
}

