/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.signer.model.SignerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignPayloadRequest
extends SignerRequest
implements ToCopyableBuilder<Builder, SignPayloadRequest> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileName").getter(SignPayloadRequest.getter(SignPayloadRequest::profileName)).setter(SignPayloadRequest.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileName").build()}).build();
    private static final SdkField<String> PROFILE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileOwner").getter(SignPayloadRequest.getter(SignPayloadRequest::profileOwner)).setter(SignPayloadRequest.setter(Builder::profileOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileOwner").build()}).build();
    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("payload").getter(SignPayloadRequest.getter(SignPayloadRequest::payload)).setter(SignPayloadRequest.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()}).build();
    private static final SdkField<String> PAYLOAD_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("payloadFormat").getter(SignPayloadRequest.getter(SignPayloadRequest::payloadFormat)).setter(SignPayloadRequest.setter(Builder::payloadFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD, PROFILE_OWNER_FIELD, PAYLOAD_FIELD, PAYLOAD_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SignPayloadRequest.memberNameToFieldInitializer();
    private final String profileName;
    private final String profileOwner;
    private final SdkBytes payload;
    private final String payloadFormat;

    private SignPayloadRequest(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.profileOwner = builder.profileOwner;
        this.payload = builder.payload;
        this.payloadFormat = builder.payloadFormat;
    }

    public final String profileName() {
        return this.profileName;
    }

    public final String profileOwner() {
        return this.profileOwner;
    }

    public final SdkBytes payload() {
        return this.payload;
    }

    public final String payloadFormat() {
        return this.payloadFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadFormat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignPayloadRequest)) {
            return false;
        }
        SignPayloadRequest other = (SignPayloadRequest)((Object)obj);
        return Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.profileOwner(), other.profileOwner()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.payloadFormat(), other.payloadFormat());
    }

    public final String toString() {
        return ToString.builder((String)"SignPayloadRequest").add("ProfileName", (Object)this.profileName()).add("ProfileOwner", (Object)this.profileOwner()).add("Payload", (Object)this.payload()).add("PayloadFormat", (Object)this.payloadFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "profileOwner": {
                return Optional.ofNullable(clazz.cast(this.profileOwner()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "payloadFormat": {
                return Optional.ofNullable(clazz.cast(this.payloadFormat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("profileName", PROFILE_NAME_FIELD);
        map.put("profileOwner", PROFILE_OWNER_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        map.put("payloadFormat", PAYLOAD_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignPayloadRequest, T> g) {
        return obj -> g.apply((SignPayloadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerRequest.BuilderImpl
    implements Builder {
        private String profileName;
        private String profileOwner;
        private SdkBytes payload;
        private String payloadFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(SignPayloadRequest model) {
            super(model);
            this.profileName(model.profileName);
            this.profileOwner(model.profileOwner);
            this.payload(model.payload);
            this.payloadFormat(model.payloadFormat);
        }

        public final String getProfileName() {
            return this.profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getProfileOwner() {
            return this.profileOwner;
        }

        public final void setProfileOwner(String profileOwner) {
            this.profileOwner = profileOwner;
        }

        @Override
        public final Builder profileOwner(String profileOwner) {
            this.profileOwner = profileOwner;
            return this;
        }

        public final ByteBuffer getPayload() {
            return this.payload == null ? null : this.payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload(payload == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)payload));
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        public final String getPayloadFormat() {
            return this.payloadFormat;
        }

        public final void setPayloadFormat(String payloadFormat) {
            this.payloadFormat = payloadFormat;
        }

        @Override
        public final Builder payloadFormat(String payloadFormat) {
            this.payloadFormat = payloadFormat;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SignPayloadRequest build() {
            return new SignPayloadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SignerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SignPayloadRequest> {
        public Builder profileName(String var1);

        public Builder profileOwner(String var1);

        public Builder payload(SdkBytes var1);

        public Builder payloadFormat(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

