/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.common.inject.Module;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ExtensiblePlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rule.RulePersistenceService;
import org.opensearch.rule.RulePersistenceServiceRegistry;
import org.opensearch.rule.RuleRoutingService;
import org.opensearch.rule.RuleRoutingServiceRegistry;
import org.opensearch.rule.action.CreateRuleAction;
import org.opensearch.rule.action.DeleteRuleAction;
import org.opensearch.rule.action.GetRuleAction;
import org.opensearch.rule.action.TransportCreateRuleAction;
import org.opensearch.rule.action.TransportDeleteRuleAction;
import org.opensearch.rule.action.TransportGetRuleAction;
import org.opensearch.rule.action.TransportUpdateRuleAction;
import org.opensearch.rule.action.UpdateRuleAction;
import org.opensearch.rule.autotagging.Attribute;
import org.opensearch.rule.autotagging.AutoTaggingRegistry;
import org.opensearch.rule.autotagging.FeatureType;
import org.opensearch.rule.rest.RestCreateRuleAction;
import org.opensearch.rule.rest.RestDeleteRuleAction;
import org.opensearch.rule.rest.RestGetRuleAction;
import org.opensearch.rule.rest.RestUpdateRuleAction;
import org.opensearch.rule.spi.AttributesExtension;
import org.opensearch.rule.spi.RuleFrameworkExtension;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;

public class RuleFrameworkPlugin
extends Plugin
implements ExtensiblePlugin,
ActionPlugin {
    public static final String RULE_THREAD_POOL_NAME = "rule_serial_executor";
    public static final int RULE_THREAD_COUNT = 1;
    public static final int RULE_QUEUE_SIZE = 100;
    private final RulePersistenceServiceRegistry rulePersistenceServiceRegistry = new RulePersistenceServiceRegistry();
    private final RuleRoutingServiceRegistry ruleRoutingServiceRegistry = new RuleRoutingServiceRegistry();
    private final List<RuleFrameworkExtension> ruleFrameworkExtensions = new ArrayList<RuleFrameworkExtension>();

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        this.ruleFrameworkExtensions.forEach(this::consumeFrameworkExtension);
        return List.of(new ActionPlugin.ActionHandler((ActionType)GetRuleAction.INSTANCE, TransportGetRuleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteRuleAction.INSTANCE, TransportDeleteRuleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CreateRuleAction.INSTANCE, TransportCreateRuleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateRuleAction.INSTANCE, TransportUpdateRuleAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new RestGetRuleAction(), new RestDeleteRuleAction(), new RestCreateRuleAction(), new RestUpdateRuleAction());
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return List.of(new FixedExecutorBuilder(settings, RULE_THREAD_POOL_NAME, 1, 100, "rule-threadpool"));
    }

    public Collection<Module> createGuiceModules() {
        return List.of(b -> {
            b.bind(RulePersistenceServiceRegistry.class).toInstance((Object)this.rulePersistenceServiceRegistry);
            b.bind(RuleRoutingServiceRegistry.class).toInstance((Object)this.ruleRoutingServiceRegistry);
        });
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        this.ruleFrameworkExtensions.addAll(loader.loadExtensions(RuleFrameworkExtension.class));
        List attributesExtensions = loader.loadExtensions(AttributesExtension.class);
        List<Attribute> attributes = attributesExtensions.stream().map(AttributesExtension::getAttribute).toList();
        for (RuleFrameworkExtension ruleFrameworkExtension : this.ruleFrameworkExtensions) {
            ruleFrameworkExtension.setAttributes(attributes);
        }
    }

    private void consumeFrameworkExtension(RuleFrameworkExtension ruleFrameworkExtension) {
        FeatureType featureType = (FeatureType)ruleFrameworkExtension.getFeatureTypeSupplier().get();
        AutoTaggingRegistry.registerFeatureType((FeatureType)featureType);
        this.rulePersistenceServiceRegistry.register(featureType, (RulePersistenceService)ruleFrameworkExtension.getRulePersistenceServiceSupplier().get());
        this.ruleRoutingServiceRegistry.register(featureType, (RuleRoutingService)ruleFrameworkExtension.getRuleRoutingServiceSupplier().get());
    }
}

