/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.io.StringWriter;
import java.util.Arrays;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;

public class JavascriptUtil {
    private static final String[] RESERVED_ARRAY = new String[]{"as", "break", "case", "catch", "class", "const", "continue", "default", "delete", "do", "else", "export", "extends", "false", "finally", "for", "function", "if", "import", "in", "instanceof", "is", "namespace", "new", "null", "package", "private", "public", "return", "super", "switch", "this", "throw", "true", "try", "typeof", "use", "var", "void", "while", "with", "abstract", "debugger", "enum", "goto", "implements", "interface", "native", "protected", "synchronized", "throws", "transient", "volatile", "boolean", "byte", "char", "double", "final", "float", "int", "long", "short", "static"};
    private static SortedSet<String> reserved = new TreeSet<String>();

    public static String escapeJavaScript(String str) {
        return JavascriptUtil.escapeJavaScript(str, true);
    }

    public static String escapeJavaScript(String str, boolean escapeSingleQuote) {
        if (str == null) {
            return null;
        }
        boolean escapeForwardSlash = true;
        StringWriter stringWriter = new StringWriter(str.length() * 2);
        int sz = str.length();
        block13: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                stringWriter.write("\\u" + JavascriptUtil.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                stringWriter.write("\\u0" + JavascriptUtil.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                stringWriter.write("\\u00" + JavascriptUtil.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        stringWriter.write(92);
                        stringWriter.write(98);
                        break;
                    }
                    case '\n': {
                        stringWriter.write(92);
                        stringWriter.write(110);
                        break;
                    }
                    case '\t': {
                        stringWriter.write(92);
                        stringWriter.write(116);
                        break;
                    }
                    case '\f': {
                        stringWriter.write(92);
                        stringWriter.write(102);
                        break;
                    }
                    case '\r': {
                        stringWriter.write(92);
                        stringWriter.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            stringWriter.write("\\u00" + JavascriptUtil.hex(ch));
                            break;
                        }
                        stringWriter.write("\\u000" + JavascriptUtil.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuote) {
                        stringWriter.write(92);
                    }
                    stringWriter.write(39);
                    continue block13;
                }
                case '\"': {
                    stringWriter.write(92);
                    stringWriter.write(34);
                    continue block13;
                }
                case '\\': {
                    stringWriter.write(92);
                    stringWriter.write(92);
                    continue block13;
                }
                case '/': {
                    if (escapeForwardSlash) {
                        stringWriter.write(92);
                    }
                    stringWriter.write(47);
                    continue block13;
                }
                default: {
                    stringWriter.write(ch);
                }
            }
        }
        return stringWriter.toString();
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    public static String unescapeJavaScript(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer writer = new StringBuffer(str.length());
        int sz = str.length();
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    writer.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Unable to parse unicode value: " + unicode + " cause: " + nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        writer.append('\\');
                        break;
                    }
                    case '\'': {
                        writer.append('\'');
                        break;
                    }
                    case '\"': {
                        writer.append('\"');
                        break;
                    }
                    case 'r': {
                        writer.append('\r');
                        break;
                    }
                    case 'f': {
                        writer.append('\f');
                        break;
                    }
                    case 't': {
                        writer.append('\t');
                        break;
                    }
                    case 'n': {
                        writer.append('\n');
                        break;
                    }
                    case 'b': {
                        writer.append('\b');
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        writer.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            writer.append(ch);
        }
        if (hadSlash) {
            writer.append('\\');
        }
        return writer.toString();
    }

    public static boolean isReservedWord(String name) {
        return reserved.contains(name);
    }

    static {
        reserved.addAll(Arrays.asList(RESERVED_ARRAY));
    }
}

