/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.readers.pymol.PyMOLReader;
import org.jmol.adapter.readers.pymol.PyMOLScene;
import org.jmol.atomdata.RadiusData;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Point3fi;
import org.jmol.viewer.ShapeManager;

class JmolObject {
    int shape;
    private BS bsAtoms;
    private Object info;
    private int size = -1;
    private Object[] colors;
    int modelIndex = Integer.MIN_VALUE;
    String jmolName;
    int argb;
    double translucency = 0.0;
    boolean visible = true;
    RadiusData rd;
    public String cacheID;

    JmolObject(int shape, String branchNameID, BS bsAtoms, Object info) {
        this.shape = shape;
        this.bsAtoms = bsAtoms;
        this.info = info;
        this.jmolName = branchNameID;
    }

    void offset(int modelOffset, int atomOffset) {
        if (modelOffset > 0) {
            if (this.modelIndex != Integer.MIN_VALUE) {
                this.modelIndex += modelOffset;
            }
            switch (this.shape) {
                case 12294: 
                case 1610625028: {
                    return;
                }
                case 4115: {
                    int i = (Integer)this.info;
                    if (i >= 0) {
                        this.info = modelOffset + i;
                    }
                    return;
                }
                case 1073742031: {
                    Map movie = (Map)this.info;
                    int[] frames = (int[])movie.get("frames");
                    int j = frames.length;
                    while (--j >= 0) {
                        int n = j;
                        frames[n] = frames[n] + modelOffset;
                    }
                    return;
                }
            }
        }
        if (atomOffset <= 0) {
            return;
        }
        if (this.shape == 12290) {
            Collection map = ((Map)this.info).values();
            for (Object o : map) {
                BSUtil.offset((BS)o, 0, atomOffset);
            }
            return;
        }
        if (this.bsAtoms != null) {
            BSUtil.offset(this.bsAtoms, 0, atomOffset);
        }
        if (this.colors != null) {
            short[] colixes = (short[])this.colors[0];
            short[] c = new short[colixes.length + atomOffset];
            System.arraycopy(colixes, 0, c, atomOffset, colixes.length);
            this.colors[0] = c;
        }
    }

    void finalizeObject(PyMOLScene pymolScene, ModelSet m, String mepList, boolean doCache) {
        ShapeManager sm = m.sm;
        String color = "color";
        SB sb = null;
        if (this.bsAtoms != null) {
            this.modelIndex = this.getModelIndex(m);
        }
        switch (this.shape) {
            case 0x20002A: {
                sm.vwr.displayAtoms(this.bsAtoms, false, false, 1275069441, true);
                return;
            }
            case 12295: {
                BS bs = sm.vwr.getModelUndeletedAtomsBitSet(this.argb);
                BSUtil.invertInPlace(bs, sm.vwr.ms.ac);
                sm.vwr.select(bs, false, 0, true);
                sm.restrictSelected(false, true);
                return;
            }
            case 12294: 
            case 1610625028: {
                if (this.bsAtoms == null) {
                    if (this.info == null) {
                        sm.vwr.displayAtoms(null, true, false, 0, true);
                    }
                    sm.vwr.setObjectProp((String)this.info, this.shape);
                } else {
                    sm.vwr.displayAtoms(this.bsAtoms, this.shape == 1610625028, false, 1275069441, true);
                }
                return;
            }
            case 12290: {
                sm.vwr.defineAtomSets((Map)this.info);
                return;
            }
            case 1073742031: {
                sm.vwr.am.setMovie((Map)this.info);
                return;
            }
            case 4115: {
                int frame = (Integer)this.info;
                if (frame >= 0) {
                    sm.vwr.setCurrentModelIndex(frame);
                } else {
                    sm.vwr.setAnimationRange(-1, -1);
                    sm.vwr.setCurrentModelIndex(-1);
                }
                return;
            }
            case 1073742139: {
                sm.vwr.stm.saveScene(this.jmolName, (Map)this.info);
                sm.vwr.stm.saveOrientation(this.jmolName, (float[])((Map)this.info).get("pymolView"));
                return;
            }
            case 5: {
                sm.loadShape(this.shape);
                sm.setShapePropertyBs(this.shape, "pymolLabels", this.info, this.bsAtoms);
                return;
            }
            case 1677721602: {
                break;
            }
            case 1: 
            case 659488: {
                if (this.size != -1) {
                    sm.setShapeSizeBs(1, this.size, null, this.bsAtoms);
                    BS bsBonds = sm.vwr.getBondsForSelectedAtoms(this.bsAtoms);
                    if (this.info != null) {
                        Object[] o = (Object[])this.info;
                        BS bsH = (BS)o[0];
                        float stick_h_scale = ((Number)o[1]).floatValue();
                        int hsize = (int)((float)this.size * stick_h_scale);
                        sm.vwr.setBooleanProperty("bondmodeor", true);
                        sm.setShapeSizeBs(1, hsize, null, bsH);
                        sm.vwr.setBooleanProperty("bondmodeor", false);
                    }
                    pymolScene.setUniqueBonds(bsBonds, this.shape == 1);
                    this.size = -1;
                }
                this.shape = 1;
                break;
            }
            case 1153433601: {
                this.shape = 0;
                break;
            }
            case 0: {
                break;
            }
            case 9: 
            case 10: {
                sm.loadShape(this.shape);
                BS bsCarb = m.getAtoms(0x200024, null);
                BSUtil.andNot(this.bsAtoms, bsCarb);
                break;
            }
            case 16: {
                sm.loadShape(this.shape);
                sm.setShapePropertyBs(this.shape, "ignore", BSUtil.copyInvert(this.bsAtoms, sm.vwr.ms.ac), null);
                break;
            }
            default: {
                if (this.visible) break;
                return;
            }
        }
        switch (this.shape) {
            case 23: {
                Hashtable<String, Object> map = new Hashtable<String, Object>();
                map.put("mesh_width", pymolScene.getDefaultDouble(90));
                map.put("info", this.info);
                sm.vwr.setCGO(map);
                break;
            }
            case 0: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 20: 
            case 24: {
                if (!(this.info instanceof Object[])) break;
                sm.loadShape(this.shape);
                sm.setShapePropertyBs(this.shape, "params", this.info, this.bsAtoms);
                break;
            }
            case 6: {
                if (this.modelIndex < 0) {
                    return;
                }
                sm.loadShape(this.shape);
                MeasurementData md = (MeasurementData)this.info;
                md.setModelSet(m);
                Lst<Object> points = md.points;
                int i = points.size();
                while (--i >= 0) {
                    ((Point3fi)points.get((int)i)).mi = (short)this.modelIndex;
                }
                sm.setShapePropertyBs(this.shape, "measure", md, this.bsAtoms);
                return;
            }
            case 135180: {
                String sID;
                String string = sID = this.bsAtoms == null ? (String)this.info : this.jmolName;
                if (sm.getShapeIdFromObjectName(sID) >= 0) {
                    sm.vwr.setObjectProp(sID, 1610625028);
                    return;
                }
                sb = new SB();
                sb.append("isosurface ID ").append(PT.esc(sID));
                if (this.modelIndex < 0) {
                    this.modelIndex = sm.vwr.am.cmi;
                }
                if (this.bsAtoms == null) {
                    sb.append(" model ").append(m.getModelNumberDotted(this.modelIndex)).append(" color density sigma 1.0 ").append(PT.esc(this.cacheID)).append(" ").append(PT.esc(sID));
                    if (!doCache) break;
                    sb.append(";isosurface cache");
                    break;
                }
                String lighting = (String)((Object[])this.info)[0];
                String only = (String)((Object[])this.info)[1];
                only = " only";
                BS bsCarve = (BS)((Object[])this.info)[2];
                double carveDistance = ((Number)((Object[])this.info)[3]).doubleValue();
                String resolution = "";
                if (lighting == null) {
                    lighting = "mesh nofill";
                    resolution = " resolution 1.5";
                }
                boolean haveMep = PT.isOneOf(sID, mepList);
                String model = m.getModelNumberDotted(this.modelIndex);
                String ignore = "";
                String type = this.size < 0 ? " sasurface " : " solvent ";
                sb.append(" model ").append(model).append(resolution).append(" select ").append(Escape.eBS(this.bsAtoms)).append(only).append(ignore).append(type).appendD(Math.abs((double)this.size / 1000.0));
                if (!haveMep) {
                    if (this.argb == 0) {
                        sb.append(" map property color");
                    } else {
                        sb.append(";color isosurface ").append(Escape.escapeColor(this.argb));
                    }
                }
                sb.append(";isosurface frontOnly ").append(lighting);
                if (this.translucency > 0.0) {
                    sb.append(";color isosurface translucent " + this.translucency);
                }
                if (bsCarve != null && !bsCarve.isEmpty()) {
                    sb.append(";isosurface slab within " + carveDistance + " {" + model + " and " + Escape.eBS(bsCarve) + "}");
                }
                if (!doCache || haveMep) break;
                sb.append(";isosurface cache");
                break;
            }
            case 0x400000C0: {
                Lst mep = (Lst)this.info;
                String sID = mep.get(mep.size() - 2).toString();
                String mapID = mep.get(mep.size() - 1).toString();
                double min = PyMOLReader.floatAt(PyMOLReader.listAt(mep, 3), 0);
                double max = PyMOLReader.floatAt(PyMOLReader.listAt(mep, 3), 2);
                sb = new SB();
                sb.append(";isosurface ID ").append(PT.esc(sID)).append(" map ").append(PT.esc(this.cacheID)).append(" ").append(PT.esc(mapID)).append(";color isosurface range " + min + " " + max + ";isosurface colorscheme rwb;set isosurfacekey true");
                if (this.translucency > 0.0) {
                    sb.append(";color isosurface translucent " + this.translucency);
                }
                if (!doCache) break;
                sb.append(";isosurface cache");
                break;
            }
            case 1073742018: {
                this.modelIndex = sm.vwr.am.cmi;
                Lst mesh = (Lst)this.info;
                String sID = mesh.get(mesh.size() - 2).toString();
                sb = new SB();
                sb.append("isosurface ID ").append(PT.esc(sID)).append(" model ").append(m.getModelNumberDotted(this.modelIndex)).append(" color ").append(Escape.escapeColor(this.argb)).append("  ").append(PT.esc(this.cacheID)).append(" ").append(PT.esc(sID)).append(" mesh nofill frontonly");
                Lst<Object> list = PyMOLReader.sublistAt(mesh, 2, 0);
                double within = PyMOLReader.floatAt(list, 11);
                list = PyMOLReader.listAt(list, 12);
                if (within > 0.0) {
                    P3 pt = new P3();
                    sb.append(";isosurface slab within ").appendD(within).append(" [ ");
                    for (int j = list.size() - 3; j >= 0; j -= 3) {
                        PyMOLReader.pointAt(list, j, pt);
                        sb.append(Escape.eP(pt));
                    }
                    sb.append(" ]");
                }
                if (doCache && !PT.isOneOf(sID, mepList)) {
                    sb.append(";isosurface cache");
                }
                sb.append(";set meshScale ").appendI(this.size / 500);
                break;
            }
            case 134222850: {
                sb = (SB)this.info;
                break;
            }
            case 1112152078: {
                this.shape = 10;
                sm.loadShape(10);
                sm.setShapePropertyBs(this.shape, "putty", this.info, this.bsAtoms);
            }
        }
        if (sb != null) {
            sm.vwr.runScriptCautiously(sb.toString());
            return;
        }
        if (this.size != -1 || this.rd != null) {
            sm.setShapeSizeBs(this.shape, this.size, this.rd, this.bsAtoms);
        }
        if (this.argb != 0) {
            sm.setShapePropertyBs(this.shape, color, this.argb, this.bsAtoms);
        }
        if (this.translucency > 0.0) {
            sm.setShapePropertyBs(this.shape, "translucentLevel", this.translucency, this.bsAtoms);
            sm.setShapePropertyBs(this.shape, "translucency", "translucent", this.bsAtoms);
        } else if (this.colors != null) {
            sm.setShapePropertyBs(this.shape, "colors", this.colors, this.bsAtoms);
        }
    }

    private int getModelIndex(ModelSet m) {
        if (this.bsAtoms == null) {
            return -1;
        }
        int iAtom = this.bsAtoms.nextSetBit(0);
        if (iAtom >= m.at.length) {
            System.err.println("JmolObject PyMOL LOADING ERROR IN MERGE. atom index too large");
        }
        return iAtom < 0 ? -1 : (int)m.at[iAtom].mi;
    }

    void setColors(short[] colixes, double translucency) {
        this.colors = new Object[]{colixes, translucency};
    }

    void setSize(double size) {
        this.size = (int)(size * 1000.0);
    }

    public String toString() {
        return "[JmolObject " + this.shape + " " + (this.bsAtoms == null ? "" : this.bsAtoms.cardinality() + " atoms") + "]";
    }
}

