/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.Util;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;

class AttributeMapper
extends SimpleAttributeSet {
    public static final int toCSS = 0;
    public static final int toHTML = 1;
    public static final int toJava = 2;

    public AttributeMapper() {
    }

    public AttributeMapper(AttributeSet a) {
        super(a);
    }

    public AttributeSet getMappedAttributes(int direction) {
        switch (direction) {
            case 0: {
                this.mapToCSSAttributes();
                break;
            }
            case 1: {
                this.mapToHTMLAttributes();
                break;
            }
            case 2: {
                this.mapToJavaAttributes();
            }
        }
        return this;
    }

    private void mapToCSSAttributes() {
        Object cssFontSize = this.getAttribute(CSS.Attribute.FONT_SIZE);
        if (cssFontSize != null) {
            int fontNumber = Integer.parseInt(cssFontSize.toString());
            this.addAttribute(CSS.Attribute.FONT_SIZE, SHTMLPanelImpl.FONT_SIZES[fontNumber - 1] + "pt");
        }
        this.mapToHTMLAttributes();
    }

    private void mapToHTMLAttributes() {
        Object cssFontFamily = this.getAttribute(CSS.Attribute.FONT_FAMILY);
        if (cssFontFamily != null) {
            if (cssFontFamily.toString().equalsIgnoreCase("SansSerif")) {
                this.addAttribute(CSS.Attribute.FONT_FAMILY, "SansSerif, Sans-Serif");
            } else if (cssFontFamily.toString().contains("Monospaced")) {
                this.addAttribute(CSS.Attribute.FONT_FAMILY, "Monospace, Monospaced");
            }
        }
    }

    private void mapToJavaAttributes() {
        Object htmlFontFace = this.getAttribute(HTML.Attribute.FACE);
        Object cssFontFamily = this.getAttribute(CSS.Attribute.FONT_FAMILY);
        if (htmlFontFace != null) {
            if (cssFontFamily != null) {
                this.removeAttribute(HTML.Attribute.FACE);
                if (cssFontFamily.toString().contains("Sans-Serif")) {
                    Util.styleSheet().addCSSAttribute(this, CSS.Attribute.FONT_FAMILY, "SansSerif");
                } else if (cssFontFamily.toString().contains("Monospace")) {
                    Util.styleSheet().addCSSAttribute(this, CSS.Attribute.FONT_FAMILY, "Monospaced");
                }
            } else {
                this.removeAttribute(HTML.Attribute.FACE);
                if (htmlFontFace.toString().contains("Sans-Serif")) {
                    Util.styleSheet().addCSSAttribute(this, CSS.Attribute.FONT_FAMILY, "SansSerif");
                } else if (htmlFontFace.toString().contains("Monospace")) {
                    Util.styleSheet().addCSSAttribute(this, CSS.Attribute.FONT_FAMILY, "Monospaced");
                } else {
                    Util.styleSheet().addCSSAttribute(this, CSS.Attribute.FONT_FAMILY, htmlFontFace.toString());
                }
            }
        } else if (cssFontFamily != null) {
            if (cssFontFamily.toString().contains("Sans-Serif")) {
                Util.styleSheet().addCSSAttribute(this, CSS.Attribute.FONT_FAMILY, "SansSerif");
            } else if (cssFontFamily.toString().contains("Monospace")) {
                Util.styleSheet().addCSSAttribute(this, CSS.Attribute.FONT_FAMILY, "Monospaced");
            }
        }
    }
}

