module $__XILINX_BLOCKRAM_TDP_ (...);

parameter INIT = 0;
parameter OPTION_MODE = "FULL";
parameter OPTION_RSTTYPE = "SYNC";
parameter OPTION_HAS_RDFIRST = 0;

parameter PORT_A_WIDTH = 1;
parameter PORT_A_WR_EN_WIDTH = 1;
parameter PORT_A_USED = 1;
parameter PORT_A_OPTION_WRITE_MODE = "NO_CHANGE";
parameter PORT_A_RD_INIT_VALUE = 0;
parameter PORT_A_RD_SRST_VALUE = 0;
parameter PORT_A_RD_ARST_VALUE = 0;
parameter PORT_A_OPTION_RST_PRIORITY = "CE";

parameter PORT_B_WIDTH = 1;
parameter PORT_B_WR_EN_WIDTH = 1;
parameter PORT_B_USED = 0;
parameter PORT_B_OPTION_WRITE_MODE = "NO_CHANGE";
parameter PORT_B_RD_INIT_VALUE = 0;
parameter PORT_B_RD_SRST_VALUE = 0;
parameter PORT_B_RD_ARST_VALUE = 0;
parameter PORT_B_OPTION_RST_PRIORITY = "CE";

input CLK_C;

input PORT_A_CLK;
input PORT_A_CLK_EN;
input [13:0] PORT_A_ADDR;
input [PORT_A_WIDTH-1:0] PORT_A_WR_DATA;
input [PORT_A_WR_EN_WIDTH-1:0] PORT_A_WR_EN;
output [PORT_A_WIDTH-1:0] PORT_A_RD_DATA;
input PORT_A_RD_SRST;
input PORT_A_RD_ARST;

input PORT_B_CLK;
input PORT_B_CLK_EN;
input [13:0] PORT_B_ADDR;
input [PORT_B_WIDTH-1:0] PORT_B_WR_DATA;
input [PORT_B_WR_EN_WIDTH-1:0] PORT_B_WR_EN;
output [PORT_B_WIDTH-1:0] PORT_B_RD_DATA;
input PORT_B_RD_SRST;
input PORT_B_RD_ARST;

`include "brams_defs.vh"

`define PARAMS_COMMON \
	.WRITE_MODE_A(PORT_A_OPTION_WRITE_MODE), \
	.WRITE_MODE_B(PORT_B_OPTION_WRITE_MODE), \
	.DATA_WIDTH_A(PORT_A_USED ? PORT_A_WIDTH : 0), \
	.DATA_WIDTH_B(PORT_B_USED ? PORT_B_WIDTH : 0), \
	.EN_RSTRAM_A("TRUE"), \
	.EN_RSTRAM_B("TRUE"), \
	.DOA_REG(0), \
	.DOB_REG(0), \
	.RST_PRIORITY_A(PORT_A_OPTION_RST_PRIORITY), \
	.RST_PRIORITY_B(PORT_B_OPTION_RST_PRIORITY), \
	.RSTTYPE(OPTION_RSTTYPE), \
	.INIT_A(ival(PORT_A_WIDTH, PORT_A_RD_INIT_VALUE)), \
	.INIT_B(ival(PORT_B_WIDTH, PORT_B_RD_INIT_VALUE)), \
	.SRVAL_A(ival(PORT_A_WIDTH, OPTION_RSTTYPE == "SYNC" ? PORT_A_RD_SRST_VALUE : PORT_A_RD_ARST_VALUE)), \
	.SRVAL_B(ival(PORT_B_WIDTH, OPTION_RSTTYPE == "SYNC" ? PORT_B_RD_SRST_VALUE : PORT_B_RD_ARST_VALUE)),

wire RST_A = OPTION_RSTTYPE == "SYNC" ? PORT_A_RD_SRST : PORT_A_RD_ARST;
wire RST_B = OPTION_RSTTYPE == "SYNC" ? PORT_B_RD_SRST : PORT_B_RD_ARST;

`MAKE_DI(DI_A, DIP_A, PORT_A_WR_DATA)
`MAKE_DI(DI_B, DIP_B, PORT_B_WR_DATA)
`MAKE_DO(DO_A, DOP_A, PORT_A_RD_DATA)
`MAKE_DO(DO_B, DOP_B, PORT_B_RD_DATA)

generate

if (OPTION_MODE == "FULL") begin
	wire [3:0] WE_A = {4{PORT_A_WR_EN}};
	wire [3:0] WE_B = {4{PORT_B_WR_EN}};
	RAMB16BWER #(
		`PARAMS_INIT_18
		`PARAMS_INITP_18
		`PARAMS_COMMON
	) _TECHMAP_REPLACE_ (
		.DOA(DO_A),
		.DOPA(DOP_A),
		.DIA(DI_A),
		.DIPA(DIP_A),
		.DOB(DO_B),
		.DOPB(DOP_B),
		.DIB(DI_B),
		.DIPB(DIP_B),
		.ADDRA(PORT_A_ADDR),
		.ADDRB(PORT_B_ADDR),
		.CLKA(PORT_A_CLK),
		.CLKB(PORT_B_CLK),
		.ENA(PORT_A_CLK_EN),
		.ENB(PORT_B_CLK_EN),
		.REGCEA(1'b0),
		.REGCEB(1'b0),
		.RSTA(RST_A),
		.RSTB(RST_B),
		.WEA(WE_A),
		.WEB(WE_B),
	);
end else begin
	wire [1:0] WE_A = {2{PORT_A_WR_EN}};
	wire [1:0] WE_B = {2{PORT_B_WR_EN}};
	RAMB8BWER #(
		`PARAMS_INIT_9
		`PARAMS_INITP_9
		`PARAMS_COMMON
		.RAM_MODE("TDP"),
	) _TECHMAP_REPLACE_ (
		.DOADO(DO_A),
		.DOPADOP(DOP_A),
		.DIADI(DI_A),
		.DIPADIP(DIP_A),
		.DOBDO(DO_B),
		.DOPBDOP(DOP_B),
		.DIBDI(DI_B),
		.DIPBDIP(DIP_B),
		.ADDRAWRADDR(PORT_A_ADDR),
		.ADDRBRDADDR(PORT_B_ADDR),
		.CLKAWRCLK(PORT_A_CLK),
		.CLKBRDCLK(PORT_B_CLK),
		.ENAWREN(PORT_A_CLK_EN),
		.ENBRDEN(PORT_B_CLK_EN),
		.REGCEA(1'b0),
		.REGCEBREGCE(1'b0),
		.RSTA(RST_A),
		.RSTBRST(RST_B),
		.WEAWEL(WE_A),
		.WEBWEU(WE_B),
	);
end

endgenerate

endmodule


module $__XILINX_BLOCKRAM_SDP_ (...);

parameter INIT = 0;
parameter OPTION_RSTTYPE = "SYNC";
parameter OPTION_WRITE_MODE = "READ_FIRST";

parameter PORT_W_WIDTH = 1;
parameter PORT_W_WR_EN_WIDTH = 1;
parameter PORT_W_USED = 1;

parameter PORT_R_WIDTH = 1;
parameter PORT_R_USED = 0;
parameter PORT_R_RD_INIT_VALUE = 0;
parameter PORT_R_RD_SRST_VALUE = 0;
parameter PORT_R_RD_ARST_VALUE = 0;
parameter PORT_R_OPTION_RST_PRIORITY = "CE";

input CLK_C;

input PORT_W_CLK;
input PORT_W_CLK_EN;
input [13:0] PORT_W_ADDR;
input [PORT_W_WIDTH-1:0] PORT_W_WR_DATA;
input [PORT_W_WR_EN_WIDTH-1:0] PORT_W_WR_EN;

input PORT_R_CLK;
input PORT_R_CLK_EN;
input [13:0] PORT_R_ADDR;
output [PORT_R_WIDTH-1:0] PORT_R_RD_DATA;
input PORT_R_RD_SRST;
input PORT_R_RD_ARST;

`include "brams_defs.vh"

wire RST = OPTION_RSTTYPE == "SYNC" ? PORT_R_RD_SRST : PORT_R_RD_ARST;

`MAKE_DI(DI, DIP, PORT_W_WR_DATA)
`MAKE_DO(DO, DOP, PORT_R_RD_DATA)

localparam [35:0] RST_VALUE = OPTION_RSTTYPE == "SYNC" ? PORT_R_RD_SRST_VALUE : PORT_R_RD_ARST_VALUE;

RAMB8BWER #(
	`PARAMS_INIT_9
	`PARAMS_INITP_9
	.WRITE_MODE_A(OPTION_WRITE_MODE),
	.WRITE_MODE_B(OPTION_WRITE_MODE),
	.DATA_WIDTH_A(PORT_W_USED ? PORT_W_WIDTH : 0),
	.DATA_WIDTH_B(PORT_R_USED ? PORT_R_WIDTH : 0),
	.EN_RSTRAM_A("TRUE"),
	.EN_RSTRAM_B("TRUE"),
	.DOA_REG(0),
	.DOB_REG(0),
	.RST_PRIORITY_A("CE"),
	.RST_PRIORITY_B(PORT_R_OPTION_RST_PRIORITY),
	.RSTTYPE(OPTION_RSTTYPE),
	.INIT_A(ival(18, PORT_R_RD_INIT_VALUE[17:0])),
	.INIT_B(ival(18, PORT_R_RD_INIT_VALUE[35:18])),
	.SRVAL_A(ival(18, RST_VALUE[17:0])),
	.SRVAL_B(ival(18, RST_VALUE[35:18])),
	.RAM_MODE("SDP"),
) _TECHMAP_REPLACE_ (
	.DOADO(DO[15:0]),
	.DOPADOP(DOP[1:0]),
	.DIADI(DI[15:0]),
	.DIPADIP(DIP[1:0]),
	.DOBDO(DO[31:16]),
	.DOPBDOP(DOP[3:2]),
	.DIBDI(DI[31:16]),
	.DIPBDIP(DIP[3:2]),
	.ADDRAWRADDR(PORT_W_ADDR),
	.ADDRBRDADDR(PORT_R_ADDR),
	.CLKAWRCLK(PORT_W_CLK),
	.CLKBRDCLK(PORT_R_CLK),
	.ENAWREN(PORT_W_CLK_EN),
	.ENBRDEN(PORT_R_CLK_EN),
	.REGCEA(1'b0),
	.REGCEBREGCE(1'b0),
	.RSTA(1'b0),
	.RSTBRST(RST),
	.WEAWEL(PORT_W_WR_EN[1:0]),
	.WEBWEU(PORT_W_WR_EN[3:2]),
);

endmodule
