/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.cli;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import net.sf.sdedit.cli.Option;
import net.sf.sdedit.util.ObjectFactory;
import org.apache.commons.cli.CommandLine;

public class OptionObject {
    private final PropertyDescriptor property;
    private final org.apache.commons.cli.Option option;

    public OptionObject(PropertyDescriptor property) {
        this.property = property;
        this.option = this.makeOption();
    }

    private Option option() {
        return this.method().getAnnotation(Option.class);
    }

    public Method method() {
        return this.property.getReadMethod();
    }

    public org.apache.commons.cli.Option getOption() {
        return this.option;
    }

    private boolean isArray() {
        return this.method().getReturnType().isArray();
    }

    private boolean isBoolean() {
        return Boolean.TYPE == this.getType();
    }

    private Class<?> getType() {
        if (this.isArray()) {
            return this.method().getReturnType().getComponentType();
        }
        return this.method().getReturnType();
    }

    public String getGroup() {
        String group = this.option().group();
        if ("".equals(group)) {
            return null;
        }
        return group;
    }

    public boolean isRequired() {
        return this.option().required() && this.option().dflt().length() == 0 && !this.isBoolean();
    }

    public String getName() {
        String name = this.option().name();
        if ("".equals(name)) {
            name = this.property.getName();
        }
        return name;
    }

    private String getArgName() {
        String argName;
        if (this.isArray()) {
            String type = this.method().getReturnType().getComponentType().getSimpleName();
            argName = type + this.option().separator() + type + this.option().separator() + "...";
        } else {
            argName = this.getType().getSimpleName();
        }
        return argName;
    }

    private String getDescription() {
        String description = null;
        String dflt = this.option().dflt();
        if ("".equals(dflt) && !"".equals(this.option().inherit())) {
            dflt = "<" + this.option().inherit() + ">";
        }
        if (this.getType().isEnum() || !"".equals(this.option().description()) || !"".equals(dflt)) {
            description = this.option().description();
            if (this.getType().isEnum()) {
                Class<?> c = this.getType();
                Enum[] constants = (Enum[])c.getEnumConstants();
                if (!"".equals(description)) {
                    description = description + ". ";
                }
                description = description + "One of ";
                boolean first = true;
                for (Enum constant : constants) {
                    if (first) {
                        first = false;
                    } else {
                        description = description + ", ";
                    }
                    description = description + constant.name();
                }
            }
            if (!"".equals(dflt)) {
                description = !"".equals(description) ? description + ". Default is " + dflt : "Default is " + dflt;
            }
            description = description + ".";
        }
        return description;
    }

    private org.apache.commons.cli.Option makeOption() {
        String opt = this.getName();
        String longOpt = this.option().longOpt();
        if ("".equals(longOpt)) {
            longOpt = null;
        }
        org.apache.commons.cli.Option option = new org.apache.commons.cli.Option(opt, this.getDescription());
        option.setLongOpt(longOpt);
        option.setRequired(this.option().required() && this.getGroup() == null && this.dflt() == null && this.inherit() == null);
        option.setArgName(this.getArgName());
        if (this.isBoolean()) {
            option.setArgs(0);
            option.setRequired(false);
            option.setOptionalArg(false);
        } else if (this.isArray()) {
            int numArgs = this.option().numArgs();
            if (numArgs <= 0) {
                numArgs = -2;
            }
            option.setArgs(numArgs);
            option.setValueSeparator(this.option().separator());
            option.setOptionalArg(this.option().isArgOptional());
        } else {
            option.setArgs(1);
            if (this.getType().isPrimitive()) {
                option.setRequired(true);
            }
        }
        return option;
    }

    private Object createFromString(Class<?> cls, String string) {
        if (cls.isEnum()) {
            Class<?> enumClass = cls;
            return Enum.valueOf(enumClass, string);
        }
        try {
            return ObjectFactory.createFromString(cls, string);
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("cannot convert value " + string + " to type " + cls.getSimpleName());
        }
    }

    private Object makeScalar(CommandLine line) {
        String value = line.getOptionValue(this.getName());
        if (value == null) {
            value = this.dflt();
        }
        if (value == null) {
            return null;
        }
        return this.createFromString(this.getType(), value);
    }

    private Object makeArray(CommandLine line) {
        String[] values = line.getOptionValues(this.getName());
        if (values == null && this.dflt() != null) {
            values = this.dflt().split(String.valueOf(this.option().separator()));
        }
        if (values == null) {
            values = new String[]{};
        }
        Object array = null;
        if (values != null) {
            Class<?> type = this.getType();
            array = Array.newInstance(type, values.length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(array, i, this.createFromString(type, values[i]));
            }
        }
        return array;
    }

    public String inherit() {
        String inh = this.option().inherit();
        if ("".equals(inh)) {
            return null;
        }
        return inh;
    }

    private String dflt() {
        String dflt = this.option().dflt();
        if ("".equals(dflt)) {
            return null;
        }
        return dflt;
    }

    public Object getValue(CommandLine commandLine) {
        boolean has = commandLine.hasOption(this.getName());
        if (this.isBoolean()) {
            return has;
        }
        if (!has && this.dflt() == null) {
            return null;
        }
        if (this.isArray()) {
            return this.makeArray(commandLine);
        }
        return this.makeScalar(commandLine);
    }
}

