/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.enums;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.keycloak.common.ClientConnection;

public enum SslRequired {
    ALL,
    EXTERNAL,
    NONE;


    public boolean isRequired(ClientConnection connection) {
        return this.isRequired(connection.getRemoteAddr());
    }

    public boolean isRequired(String host) {
        switch (this.ordinal()) {
            case 0: {
                return true;
            }
            case 2: {
                return false;
            }
            case 1: {
                return !this.isLocal(host);
            }
        }
        return true;
    }

    private boolean isLocal(String host) {
        if (host == null || host.isEmpty()) {
            return false;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            return inetAddress.isLoopbackAddress() || inetAddress.isSiteLocalAddress() || inetAddress.isLinkLocalAddress() || this.isUniqueLocal(inetAddress);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private boolean isUniqueLocal(InetAddress address) {
        if (address instanceof Inet6Address) {
            byte[] addr = address.getAddress();
            return (byte)(addr[0] & 0xFE) == -4;
        }
        return false;
    }
}

