/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.tools.CompositeList;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.Utils;

public final class SearchCompilerQueryWizard {
    private SearchCompilerQueryWizard() {
    }

    public static String constructQuery(String search) {
        try {
            Matcher matcher = Pattern.compile("\\s+GLOBAL\\s*$", 258).matcher(search);
            if (matcher.find()) {
                SearchCompiler.Match match = SearchCompiler.compile(matcher.replaceFirst(""));
                return SearchCompilerQueryWizard.constructQuery(match, ";", "");
            }
            matcher = Pattern.compile("\\s+IN BBOX\\s*$", 258).matcher(search);
            if (matcher.find()) {
                SearchCompiler.Match match = SearchCompiler.compile(matcher.replaceFirst(""));
                return SearchCompilerQueryWizard.constructQuery(match, "[bbox:{{bbox}}];", "");
            }
            matcher = Pattern.compile("\\s+(?<mode>IN|AROUND)\\s+(?<area>[^\" ]+|\"[^\"]+\")\\s*$", 258).matcher(search);
            if (matcher.find()) {
                SearchCompiler.Match match = SearchCompiler.compile(matcher.replaceFirst(""));
                String mode = matcher.group("mode").toUpperCase(Locale.ENGLISH);
                String area = Utils.strip(matcher.group("area"), "\"");
                if ("IN".equals(mode)) {
                    return SearchCompilerQueryWizard.constructQuery(match, ";\n{{geocodeArea:" + area + "}}->.searchArea;", "(area.searchArea)");
                }
                if ("AROUND".equals(mode)) {
                    return SearchCompilerQueryWizard.constructQuery(match, ";\n{{radius=1000}}", "(around:{{radius}},{{geocodeCoords:" + area + "}})");
                }
                throw new IllegalStateException(mode);
            }
            SearchCompiler.Match match = SearchCompiler.compile(search);
            return SearchCompilerQueryWizard.constructQuery(match, "[bbox:{{bbox}}];", "");
        }
        catch (UnsupportedOperationException | SearchParseError e) {
            throw new UncheckedParseException(e);
        }
    }

    private static String constructQuery(SearchCompiler.Match match, String bounds, String queryLineSuffix) {
        List<SearchCompiler.Match> normalized = SearchCompilerQueryWizard.normalizeToDNF(match);
        ArrayList<Object> queryLines = new ArrayList<Object>();
        queryLines.add("[out:xml][timeout:90]" + bounds);
        queryLines.add("(");
        for (SearchCompiler.Match conjunction : normalized) {
            EnumSet<OsmPrimitiveType> types = EnumSet.noneOf(OsmPrimitiveType.class);
            String query = SearchCompilerQueryWizard.constructQuery(conjunction, types);
            queryLines.addAll((types.isEmpty() || types.size() == 3 ? Stream.of("nwr") : types.stream().map(OsmPrimitiveType::getAPIName)).map(type -> "  " + type + query + queryLineSuffix + ";").collect(Collectors.toList()));
        }
        queryLines.add(");");
        queryLines.add("(._;>;);");
        queryLines.add("out meta;");
        return String.join((CharSequence)"\n", queryLines);
    }

    private static String constructQuery(SearchCompiler.Match match, Set<OsmPrimitiveType> types) {
        boolean negated;
        if (match instanceof SearchCompiler.Not) {
            negated = true;
            match = ((SearchCompiler.Not)match).getMatch();
        } else {
            negated = false;
        }
        if (match instanceof SearchCompiler.And) {
            return ((SearchCompiler.And)match).map(m -> SearchCompilerQueryWizard.constructQuery(m, types), (s1, s2) -> s1 + s2);
        }
        if (match instanceof SearchCompiler.KeyValue) {
            String key = ((SearchCompiler.KeyValue)match).getKey();
            String value = ((SearchCompiler.KeyValue)match).getValue();
            if ("newer".equals(key)) {
                return "(newer:" + SearchCompilerQueryWizard.quote("{{date:" + value + "}}") + ")";
            }
            return "[~" + SearchCompilerQueryWizard.quote(key) + "~" + SearchCompilerQueryWizard.quote(value) + "]";
        }
        if (match instanceof SearchCompiler.ExactKeyValue) {
            String key = ((SearchCompiler.ExactKeyValue)match).getKey();
            String value = ((SearchCompiler.ExactKeyValue)match).getValue();
            SearchCompiler.ExactKeyValue.Mode mode = ((SearchCompiler.ExactKeyValue)match).getMode();
            switch (mode) {
                case ANY_VALUE: {
                    return "[" + (negated ? "!" : "") + SearchCompilerQueryWizard.quote(key) + "]";
                }
                case EXACT: {
                    return "[" + SearchCompilerQueryWizard.quote(key) + (negated ? "!=" : "=") + SearchCompilerQueryWizard.quote(value) + "]";
                }
                case ANY_KEY: 
                case EXACT_REGEXP: {
                    String valueQuery;
                    Matcher matcher = Pattern.compile("/(?<regex>.*)/(?<flags>i)?").matcher(value);
                    String string = valueQuery = matcher.matches() ? SearchCompilerQueryWizard.quote(matcher.group("regex")) + Optional.ofNullable(matcher.group("flags")).map(f -> "," + f).orElse("") : SearchCompilerQueryWizard.quote(value);
                    if (mode == SearchCompiler.ExactKeyValue.Mode.ANY_KEY) {
                        return "[~\"^.*$\"" + (negated ? "!~" : "~") + valueQuery + "]";
                    }
                    return "[" + SearchCompilerQueryWizard.quote(key) + (negated ? "!~" : "~") + valueQuery + "]";
                }
                case MISSING_KEY: {
                    return "[" + SearchCompilerQueryWizard.quote(key) + (negated ? "!~" : "~") + SearchCompilerQueryWizard.quote("^$") + "]";
                }
            }
            return "";
        }
        if (match instanceof SearchCompiler.BooleanMatch) {
            String key = ((SearchCompiler.BooleanMatch)match).getKey();
            return negated ? "[" + SearchCompilerQueryWizard.quote(key) + "~\"false|no|0|off\"]" : "[" + SearchCompilerQueryWizard.quote(key) + "~\"true|yes|1|on\"]";
        }
        if (match instanceof SearchCompiler.UserMatch) {
            String user = ((SearchCompiler.UserMatch)match).getUser();
            return user.matches("\\d+") ? "(uid:" + user + ")" : "(user:" + SearchCompilerQueryWizard.quote(user) + ")";
        }
        if (match instanceof SearchCompiler.ExactType) {
            types.add(((SearchCompiler.ExactType)match).getType());
            return "";
        }
        Logging.warn("Unsupported match type {0}: {1}", match.getClass(), match);
        return "/*" + match + "*/";
    }

    private static String quote(String s) {
        return "\"" + s.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
    }

    private static List<SearchCompiler.Match> normalizeToDNF(SearchCompiler.Match match) {
        if (match instanceof SearchCompiler.And) {
            return ((SearchCompiler.And)match).map(SearchCompilerQueryWizard::normalizeToDNF, (lhs, rhs) -> lhs.stream().flatMap(l -> rhs.stream().map(r -> new SearchCompiler.And((SearchCompiler.Match)l, (SearchCompiler.Match)r))).collect(Collectors.toList()));
        }
        if (match instanceof SearchCompiler.Or) {
            return ((SearchCompiler.Or)match).map(SearchCompilerQueryWizard::normalizeToDNF, CompositeList::new);
        }
        if (match instanceof SearchCompiler.Xor) {
            throw new UnsupportedOperationException(match.toString());
        }
        if (match instanceof SearchCompiler.Not) {
            SearchCompiler.Match innerMatch = ((SearchCompiler.Not)match).getMatch();
            if (innerMatch instanceof SearchCompiler.BooleanMatch || innerMatch instanceof SearchCompiler.KeyValue || innerMatch instanceof SearchCompiler.ExactKeyValue) {
                return Collections.singletonList(match);
            }
            throw new UnsupportedOperationException(match.toString());
        }
        return Collections.singletonList(match);
    }
}

