/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.FreeColClientHolder;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.DialogHandler;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.FreeColActionUI;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.i18n.NameCache;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyWas;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.EuropeWas;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LastSale;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.MarketWas;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.NativeTrade;
import net.sf.freecol.common.model.NativeTradeItem;
import net.sf.freecol.common.model.ObjectWas;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeLocation;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TradeRouteStop;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.UnitWas;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Introspector;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.FreeColServer;

public final class InGameController
extends FreeColClientHolder {
    private static final Logger logger = Logger.getLogger(InGameController.class.getName());
    private static final short UNIT_LAST_MOVE_DELAY = 300;
    private static final StringTemplate abortTrade = StringTemplate.template("");
    private static final Comparator<Unit> tradeRouteUnitComparator = Comparator.comparing(u -> u.getTradeRoute().getName()).thenComparing(Function.identity());
    private MoveMode moveMode = MoveMode.NEXT_ACTIVE_UNIT;
    private final java.util.Map<String, Integer> messagesToIgnore = Collections.synchronizedMap(new HashMap());
    private final List<ModelMessage> turnReportMessages = new ArrayList<ModelMessage>();

    public InGameController(FreeColClient freeColClient) {
        super(freeColClient);
    }

    public void sound(String soundKey) {
        this.getGUI().playSound(soundKey);
    }

    private boolean requireOurTurn() {
        if (this.currentPlayerIsMyPlayer()) {
            return true;
        }
        if (this.getFreeColClient().isInGame()) {
            this.showInformationPanel(null, "info.notYourTurn");
        }
        return false;
    }

    private Settlement getSettlementAt(Tile tile, Direction direction) {
        return tile.getNeighbourOrNull(direction).getSettlement();
    }

    private StringTemplate getNationAt(Tile tile, Direction direction) {
        Tile newTile = tile.getNeighbourOrNull(direction);
        Player player = null;
        player = newTile.hasSettlement() ? newTile.getSettlement().getOwner() : (newTile.getFirstUnit() != null ? newTile.getFirstUnit().getOwner() : this.getGame().getUnknownEnemy());
        return player.getNationLabel();
    }

    private void invokeLater(Runnable runnable) {
        this.getFreeColClient().getGUI().invokeNowOrLater(runnable);
    }

    private void changeView(Unit unit, boolean force) {
        this.invokeLater(() -> this.getGUI().changeView(unit, force));
    }

    private void changeView(Tile tile) {
        this.invokeLater(() -> {
            if (tile != null) {
                this.getGUI().changeView(tile);
            } else {
                this.getGUI().changeView();
            }
        });
    }

    private void displayChat(String sender, String message, Color color, boolean pri) {
        this.invokeLater(() -> this.getGUI().displayChat(sender, message, color, pri));
    }

    private void fireChanges(ObjectWas ... objs) {
        this.invokeLater(() -> {
            for (ObjectWas o : objs) {
                if (o == null) continue;
                o.fireChanges();
            }
        });
    }

    private void showColonyPanel(Colony colony, Unit unit) {
        this.invokeLater(() -> this.getGUI().showColonyPanel(colony, unit));
    }

    private void showColonyPanelWithCarrier(Colony colony, Unit unit) {
        this.showColonyPanel(colony, unit.isCarrier() ? unit : null);
    }

    private void error(StringTemplate template, String message) {
        this.invokeLater(() -> this.getGUI().showErrorPanel(template, message));
    }

    private void showEmigrationDialog(Player player, boolean foy, int n) {
        this.invokeLater(() -> this.getGUI().showEmigrationDialog(player, foy, value -> this.emigrate(player, Europe.MigrationType.convertToMigrantSlot(value), n - 1, foy)));
    }

    private void showEventPanel(String header, String imageKey, String footer) {
        this.invokeLater(() -> this.getGUI().showEventPanel(header, imageKey, footer));
    }

    private void showInformationPanel(FreeColObject disp, String messageId) {
        this.showInformationPanel(disp, StringTemplate.template(messageId));
    }

    private void showInformationPanel(FreeColObject disp, StringTemplate template) {
        this.invokeLater(() -> this.getGUI().showInformationPanel(disp, template));
    }

    private void getMissionaryChoice(Unit unit, IndianSettlement is, Direction direction) {
        Player player = unit.getOwner();
        boolean canEstablish = !is.hasMissionary();
        boolean canDenounce = !canEstablish && !is.hasMissionary(player);
        this.invokeLater(() -> {
            Constants.MissionaryAction act = this.getGUI().getMissionaryChoice(unit, is, canEstablish, canDenounce);
            if (act == null) {
                return;
            }
            switch (act) {
                case MISSIONARY_ESTABLISH_MISSION: 
                case MISSIONARY_DENOUNCE_HERESY: {
                    if (!this.askServer().missionary(unit, direction, act == Constants.MissionaryAction.MISSIONARY_DENOUNCE_HERESY) || !is.hasMissionary(player)) break;
                    this.sound("sound.event.missionEstablished");
                    player.invalidateCanSeeTiles();
                    break;
                }
                case MISSIONARY_INCITE_INDIANS: {
                    Player enemy = (Player)this.getGUI().getChoice(unit.getTile(), StringTemplate.key("missionarySettlement.inciteQuestion"), unit, "missionarySettlement.cancel", CollectionUtils.transform(this.getGame().getLiveEuropeanPlayers(player), CollectionUtils.alwaysTrue(), p -> new ChoiceItem<Player>(Messages.message(p.getCountryLabel()), (Player)p)));
                    if (enemy == null) break;
                    this.askServer().incite(unit, is, enemy, -1);
                    break;
                }
                default: {
                    logger.warning("showUseMissionaryDialog fail");
                }
            }
        });
    }

    private void showNamingDialog(StringTemplate template, String defaultName, Unit unit, DialogHandler<String> handler) {
        this.invokeLater(() -> this.getGUI().showNamingDialog(template, defaultName, unit, handler));
    }

    private void showNegotiationDialog(Unit unit, Settlement settlement, DiplomaticTrade agreement, StringTemplate comment, Direction direction) {
        Player player = unit.getOwner();
        this.invokeLater(() -> {
            DiplomaticTrade dt = this.getGUI().showNegotiationDialog(unit, settlement, agreement, comment);
            if (direction != null && dt != null && dt.getStatus() != DiplomaticTrade.TradeStatus.REJECT_TRADE) {
                this.moveDiplomacy(unit, direction, dt);
            }
        });
    }

    private void showStatusPanel(String message) {
        if (message == null) {
            this.invokeLater(() -> this.getGUI().closeStatusPanel());
        } else {
            this.invokeLater(() -> this.getGUI().showStatusPanel(message));
        }
    }

    private boolean updateActiveUnit(Tile tile) {
        Player player = this.getMyPlayer();
        if (this.moveMode != MoveMode.NEXT_ACTIVE_UNIT) {
            if (this.getGUI().getActiveUnit() != null) {
                this.moveMode = MoveMode.NEXT_ACTIVE_UNIT;
            }
            return false;
        }
        if (player.hasNextActiveUnit()) {
            this.changeView(player.getNextActiveUnit(), false);
            return true;
        }
        if (!this.doExecuteGotoOrders()) {
            return true;
        }
        this.changeView(tile);
        ClientOptions options = this.getClientOptions();
        if (options.getBoolean("model.option.autoEndTurn")) {
            this.doEndTurn(options.getBoolean("model.option.showEndTurnDialog"));
        }
        return true;
    }

    private void updateGUI(Tile tile, boolean updateUnit) {
        this.displayModelMessages(false, false);
        GUI gui = this.getGUI();
        Unit active = gui.getActiveUnit();
        boolean update = updateUnit || active == null || !active.isCandidateForNextActiveUnit() || !this.getMyPlayer().owns(active);
        this.invokeLater(() -> {
            if (update) {
                this.updateActiveUnit(tile);
            }
            gui.updateMapControls();
            gui.updateMenuBar();
        });
    }

    private boolean askAssignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        if (tradeRoute == unit.getTradeRoute()) {
            return true;
        }
        if (tradeRoute != null && unit.getTradeRoute() != null && !this.getGUI().confirmClearTradeRoute(unit)) {
            return false;
        }
        return this.askServer().assignTradeRoute(unit, tradeRoute) && unit.getTradeRoute() == tradeRoute;
    }

    private boolean askClaimTile(Player player, Tile tile, FreeColGameObject claimant, int price) {
        Player owner = tile.getOwner();
        if (price < 0) {
            return false;
        }
        if (price > 0) {
            Constants.ClaimAction act = this.getGUI().getClaimChoice(tile, player, price, owner);
            if (act == null) {
                return false;
            }
            switch (act) {
                case CLAIM_ACCEPT: {
                    break;
                }
                case CLAIM_STEAL: {
                    price = -1;
                    break;
                }
                default: {
                    logger.warning("Claim dialog fail: " + act);
                    return false;
                }
            }
        }
        return this.askServer().claimTile(tile, claimant, price) && player.owns(tile);
    }

    private boolean askClearGotoOrders(Unit unit) {
        if (!this.askAssignTradeRoute(unit, null) || !this.askSetDestination(unit, null)) {
            return false;
        }
        this.getGUI().clearGotoPath();
        return true;
    }

    private boolean askEmbark(Unit unit, Unit carrier) {
        ColonyWas colonyWas = unit.getColony() != null ? new ColonyWas(unit.getColony()) : null;
        EuropeWas europeWas = unit.isInEurope() ? new EuropeWas(unit.getOwner().getEurope()) : null;
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().embark(unit, carrier, null) && unit.getLocation() == carrier) {
            this.sound("sound.event.loadCargo");
            this.fireChanges(unitWas, colonyWas, europeWas);
            return true;
        }
        return false;
    }

    private Unit askEmigrate(Europe europe, int slot) {
        if (europe == null || !Europe.MigrationType.validMigrantSlot(slot)) {
            return null;
        }
        EuropeWas europeWas = new EuropeWas(europe);
        Unit newUnit = null;
        if (this.askServer().emigrate(slot) && (newUnit = europeWas.getNewUnit()) != null) {
            this.fireChanges(europeWas);
        }
        return newUnit;
    }

    private void emigration(Player player, int n, boolean fountainOfYouth) {
        Europe europe = player.getEurope();
        if (europe == null) {
            return;
        }
        while (n > 0 || player.checkEmigrate()) {
            if (!CollectionUtils.allSame(europe.getExpandedRecruitables(false))) {
                this.showEmigrationDialog(player, fountainOfYouth, n);
                return;
            }
            Unit u = this.askEmigrate(europe, Europe.MigrationType.getDefaultSlot());
            if (u == null) break;
            player.addModelMessage(player.getEmigrationMessage(u));
            --n;
        }
    }

    private boolean askLoadGoods(Location loc, GoodsType type, int amount, Unit carrier) {
        TradeLocation trl = carrier.getTradeLocation();
        if (trl == null) {
            return false;
        }
        int loadable = carrier.getLoadableAmount(type);
        if (amount > loadable) {
            amount = loadable;
        }
        Player player = carrier.getOwner();
        if (carrier.isInEurope()) {
            if (!player.canTrade(type)) {
                return false;
            }
            if (!player.checkGold(player.getMarket().getBidPrice(type, amount))) {
                this.showInformationPanel(null, "info.notEnoughGold");
                return false;
            }
        }
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        return this.askServer().loadGoods(loc, type, amount, carrier) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount;
    }

    private boolean askSetDestination(Unit unit, Location destination) {
        if (unit.getDestination() == destination) {
            return true;
        }
        return this.askServer().setDestination(unit, destination) && unit.getDestination() == destination;
    }

    private boolean askUnloadGoods(GoodsType type, int amount, Unit carrier) {
        Player player = this.getMyPlayer();
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        return this.askServer().unloadGoods(type, amount, carrier) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount;
    }

    private String getSaveGameString(Game game) {
        Player player = this.getMyPlayer();
        String gid = Integer.toHexString(game.getUUID().hashCode());
        Turn turn = game.getTurn();
        return (gid + "_" + Messages.message(player.getNationLabel()) + "_" + turn.getSaveGameSuffix() + ".fsg").replaceAll(" ", "_");
    }

    private void autoSaveGame() {
        Game game = this.getGame();
        if (game == null) {
            return;
        }
        ClientOptions options = this.getClientOptions();
        String prefix = options.getText("model.option.autoSavePrefix");
        String lastTurnName = prefix + "-" + options.getText("model.option.lastTurnName") + ".fsg";
        String beforeLastTurnName = prefix + "-" + options.getText("model.option.beforeLastTurnName") + ".fsg";
        File lastTurnFile = FreeColDirectories.getAutosaveFile(lastTurnName);
        File beforeLastTurnFile = FreeColDirectories.getAutosaveFile(beforeLastTurnName);
        if (lastTurnFile != null) {
            if (lastTurnFile.exists()) {
                if (beforeLastTurnFile.exists()) {
                    Utils.deleteFile(beforeLastTurnFile);
                }
                try {
                    if (!lastTurnFile.renameTo(beforeLastTurnFile)) {
                        logger.warning("Could not rename: " + lastTurnFile.getPath());
                    }
                }
                catch (NullPointerException | SecurityException ex) {
                    logger.log(Level.WARNING, "Could not rename: " + lastTurnFile.getPath(), ex);
                }
            }
            this.saveGame(lastTurnFile);
        }
        int saveGamePeriod = options.getInteger("model.option.autosavePeriod");
        int turnNumber = game.getTurn().getNumber();
        if (saveGamePeriod >= 1 && turnNumber % saveGamePeriod == 0) {
            String fileName = prefix + "-" + this.getSaveGameString(game);
            this.saveGame(FreeColDirectories.getAutosaveFile(fileName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveGame(File file) {
        if (file == null) {
            return false;
        }
        FreeColServer server = this.getFreeColServer();
        boolean result = false;
        if (server != null) {
            this.showStatusPanel(Messages.message("status.savingGame"));
            try {
                server.saveGame(file, this.getClientOptions(), this.getGUI().getActiveUnit());
                result = true;
            }
            catch (IOException ioe) {
                this.error(FreeCol.badFile("error.couldNotSave", file), null);
                logger.log(Level.WARNING, "Save fail", ioe);
            }
            finally {
                this.showStatusPanel(null);
            }
        }
        return result;
    }

    private void startIgnoringMessage(String key, Turn turn) {
        this.messagesToIgnore.put(key, turn.getNumber());
        logger.finer("Ignore message start: " + key);
    }

    private void stopIgnoringMessage(String key) {
        this.messagesToIgnore.remove(key);
        logger.finer("Ignore message stop: " + key);
    }

    private void reapIgnoredMessages(Turn turn) {
        CollectionUtils.removeInPlace(this.messagesToIgnore, e -> (Integer)e.getValue() < turn.getNumber());
    }

    private boolean continueIgnoreMessage(String key, Turn turn) {
        boolean ret;
        Integer value = -1;
        boolean bl = ret = key != null && (value = this.messagesToIgnore.get(key)) != null && value + 1 == turn.getNumber();
        if (ret) {
            this.messagesToIgnore.put(key, value + 1);
        }
        return ret;
    }

    public void displayTurnReportMessages() {
        this.getGUI().showReportTurnPanel(this.turnReportMessages);
    }

    private boolean displayModelMessages(boolean allMessages, boolean endOfTurn) {
        ClientOptions co = this.getClientOptions();
        Player player = this.getMyPlayer();
        Turn thisTurn = this.getGame().getTurn();
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        List<ModelMessage> todo = allMessages ? player.getModelMessages() : player.getNewModelMessages();
        for (ModelMessage m : todo) {
            String key = m.getOptionName();
            try {
                if ((key == null || co.getBoolean(key)) && !this.continueIgnoreMessage(m.getIgnoredMessageKey(), thisTurn)) {
                    messages.add(m);
                }
            }
            catch (RuntimeException rte) {
                logger.warning("Bogus ModelMessage with key<" + key + ">: " + m);
            }
            m.setDisplayed(true);
        }
        this.reapIgnoredMessages(thisTurn);
        if (!messages.isEmpty()) {
            Runnable uiTask;
            if (endOfTurn) {
                this.turnReportMessages.addAll(messages);
                uiTask = () -> this.displayTurnReportMessages();
            } else {
                uiTask = () -> this.getGUI().showModelMessages(messages);
            }
            this.getGUI().invokeNowOrWait(uiTask);
        }
        return !messages.isEmpty();
    }

    public boolean nextModelMessage() {
        return this.displayModelMessages(false, false);
    }

    private boolean doExecuteGotoOrders() {
        Player player = this.getMyPlayer();
        Unit active = this.getGUI().getActiveUnit();
        boolean ret = true;
        this.moveMode = this.moveMode.maximize(MoveMode.EXECUTE_GOTO_ORDERS);
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        Predicate<Unit> tradePred = u -> u.isReadyToTrade() && player.owns((Ownable)u);
        for (Unit unit : CollectionUtils.transform(player.getUnits(), tradePred, Function.identity(), tradeRouteUnitComparator)) {
            this.changeView(unit, false);
            if (this.moveToDestination(unit, messages)) continue;
            ret = false;
            break;
        }
        if (!messages.isEmpty()) {
            this.turnReportMessages.addAll(messages);
            for (ModelMessage m : messages) {
                player.addModelMessage(m);
            }
            this.nextModelMessage();
            ret = false;
        }
        if (!ret) {
            return false;
        }
        if (this.getGUI().isPanelShowing()) {
            return false;
        }
        if (active != null) {
            player.setNextGoingToUnit(active);
        }
        while (player.hasNextGoingToUnit()) {
            Unit unit = player.getNextGoingToUnit();
            this.changeView(unit, false);
            if (!this.moveToDestination(unit, null)) {
                ret = false;
                break;
            }
            if (active != unit) continue;
            active = null;
        }
        this.nextModelMessage();
        if (ret) {
            this.changeView(active, false);
        }
        return ret;
    }

    private void doEndTurn(boolean showDialog) {
        List<Unit> units;
        Player player = this.getMyPlayer();
        if (this.getGUI().isPanelShowing()) {
            return;
        }
        if (showDialog && !(units = CollectionUtils.transform(player.getUnits(), Unit::isCandidateForNextActiveUnit)).isEmpty()) {
            this.getGUI().showEndTurnDialog(units, value -> {
                if (value != null && value.booleanValue()) {
                    this.endTurn(false);
                }
            });
            return;
        }
        this.moveMode = this.moveMode.maximize(MoveMode.END_TURN);
        this.changeView(null);
        units = CollectionUtils.transform(player.getUnits(), Unit::couldMove);
        units.stream().forEach(unit -> {
            if (unit.getState() != Unit.UnitState.SKIPPED) {
                this.igc().changeState((Unit)unit, Unit.UnitState.SKIPPED);
            }
        });
        if (!this.doExecuteGotoOrders() || this.moveMode.ordinal() < MoveMode.END_TURN.ordinal()) {
            return;
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.DESYNC) && DebugUtils.checkDesyncAction(this.getFreeColClient())) {
            logger.warning("Reconnecting on desync");
            this.getFreeColClient().getConnectController().requestLogout(Game.LogoutReason.RECONNECT);
            return;
        }
        this.getGUI().closeMenus();
        this.moveMode = MoveMode.NEXT_ACTIVE_UNIT;
        this.turnReportMessages.clear();
        this.askServer().endTurn();
    }

    private boolean moveToDestination(Unit unit, List<ModelMessage> messages) {
        boolean ret;
        Player player = this.getMyPlayer();
        Location destination = unit.getDestination();
        if (!this.requireOurTurn() || unit.isAtSea() || unit.getMovesLeft() <= 0 || unit.getState() == Unit.UnitState.SKIPPED) {
            ret = true;
        } else if (unit.getTradeRoute() != null) {
            ret = this.followTradeRoute(unit, messages);
        } else if (destination == null) {
            ret = true;
        } else if (!this.changeState(unit, Unit.UnitState.ACTIVE)) {
            ret = true;
        } else {
            PathNode path = unit.findPath(destination);
            if (path == null) {
                StringTemplate src = unit.getLocation().getLocationLabelFor(player);
                StringTemplate dst = destination.getLocationLabelFor(player);
                Object template = ((StringTemplate)((StringTemplate)StringTemplate.template("info.moveToDestinationFailed").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL))).addStringTemplate("%location%", src)).addStringTemplate("%destination%", dst);
                this.showInformationPanel((FreeColObject)unit, (StringTemplate)template);
                this.changeState(unit, Unit.UnitState.SKIPPED);
                ret = false;
            } else if (!this.movePath(unit, path)) {
                ret = false;
            } else if (unit.isAtLocation(destination)) {
                Colony colony;
                Colony colony2 = colony = unit.hasTile() ? unit.getTile().getColony() : null;
                if (!this.askClearGotoOrders(unit)) {
                    ret = false;
                } else if (colony != null) {
                    if (this.checkCashInTreasureTrain(unit)) {
                        ret = true;
                    } else {
                        this.showColonyPanelWithCarrier(colony, unit);
                        ret = false;
                    }
                } else {
                    ret = unit.getMovesLeft() == 0;
                }
            } else {
                ret = true;
            }
        }
        return ret;
    }

    private boolean movePath(Unit unit, PathNode path) {
        while (path != null) {
            if (!unit.isAtLocation(path.getLocation())) {
                if (path.getLocation() instanceof Europe) {
                    if (unit.hasTile() && unit.getTile().isDirectlyHighSeasConnected()) {
                        return this.moveTowardEurope(unit, (Europe)path.getLocation());
                    }
                    logger.warning("Can not move to Europe from " + unit.getLocation() + " on path: " + path.fullPathToString());
                    return false;
                }
                if (path.getLocation() instanceof Tile) {
                    if (path.getDirection() == null) {
                        if (unit.isInEurope()) {
                            return this.moveAwayFromEurope(unit, unit.getGame().getMap());
                        }
                        logger.warning("Null direction on path: " + path.fullPathToString());
                        return false;
                    }
                    if (!this.moveDirection(unit, path.getDirection(), false)) {
                        return unit.getMoveType(path.getDirection()) == Unit.MoveType.MOVE_NO_MOVES;
                    }
                } else {
                    if (path.getLocation() instanceof Unit) {
                        return this.moveEmbark(unit, path.getDirection());
                    }
                    logger.warning("Bad path: " + path.fullPathToString());
                    return false;
                }
            }
            path = path.next;
        }
        return true;
    }

    public boolean moveDirection(Unit unit, Direction direction, boolean interactive) {
        Location destination = unit.getDestination();
        Tile oldTile = unit.getTile();
        boolean destinationImminent = destination != null && oldTile != null && Map.isSameLocation(oldTile.getNeighbourOrNull(direction), destination);
        Unit.MoveType mt = unit.getMoveType(direction);
        boolean result = mt.isLegal();
        switch (mt) {
            case MOVE_HIGH_SEAS: {
                result = destination instanceof Europe && this.getMyPlayer().getEurope() != null ? this.moveTowardEurope(unit, (Europe)destination) : (destination == null ? this.moveHighSeas(unit, direction) : this.moveTile(unit, direction));
                break;
            }
            case MOVE: {
                result = this.moveTile(unit, direction);
                break;
            }
            case EXPLORE_LOST_CITY_RUMOUR: {
                result = this.moveExplore(unit, direction);
                break;
            }
            case ATTACK_UNIT: {
                result = this.moveAttack(unit, direction);
                break;
            }
            case ATTACK_SETTLEMENT: {
                result = this.moveAttackSettlement(unit, direction);
                break;
            }
            case EMBARK: {
                result = this.moveEmbark(unit, direction);
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST: {
                result = this.moveLearnSkill(unit, direction);
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_SCOUT: {
                result = this.moveScoutIndianSettlement(unit, direction);
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY: {
                result = this.moveUseMissionary(unit, direction);
                break;
            }
            case ENTER_FOREIGN_COLONY_WITH_SCOUT: {
                result = this.moveScoutColony(unit, direction);
                break;
            }
            case ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS: {
                result = this.moveTrade(unit, direction);
                break;
            }
            case MOVE_NO_ACCESS_BEACHED: {
                if (!interactive && !destinationImminent) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.showInformationPanel((FreeColObject)unit, (StringTemplate)StringTemplate.template("move.noAccessBeached").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_CONTACT: {
                if (!interactive && !destinationImminent) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.showInformationPanel((FreeColObject)unit, (StringTemplate)StringTemplate.template("move.noAccessContact").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_GOODS: {
                if (!interactive && !destinationImminent) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.showInformationPanel((FreeColObject)unit, (StringTemplate)((StringTemplate)StringTemplate.template("move.noAccessGoods").addStringTemplate("%nation%", nation)).addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            case MOVE_NO_ACCESS_LAND: {
                if (this.moveDisembark(unit, direction) || !interactive) break;
                this.sound("sound.event.illegalMove");
                break;
            }
            case MOVE_NO_ACCESS_MISSION_BAN: {
                if (!interactive && !destinationImminent) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.showInformationPanel((FreeColObject)unit, (StringTemplate)((StringTemplate)StringTemplate.template("move.noAccessMissionBan").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL))).addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_SETTLEMENT: {
                if (!interactive && !destinationImminent) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.showInformationPanel((FreeColObject)unit, (StringTemplate)((StringTemplate)StringTemplate.template("move.noAccessSettlement").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL))).addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_SKILL: {
                if (!interactive && !destinationImminent) break;
                this.sound("sound.event.illegalMove");
                this.showInformationPanel((FreeColObject)unit, (StringTemplate)StringTemplate.template("move.noAccessSkill").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            case MOVE_NO_ACCESS_TRADE: {
                if (!interactive && !destinationImminent) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.showInformationPanel((FreeColObject)unit, (StringTemplate)StringTemplate.template("move.noAccessTrade").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_WAR: {
                if (!interactive && !destinationImminent) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.showInformationPanel((FreeColObject)unit, (StringTemplate)StringTemplate.template("move.noAccessWar").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_WATER: {
                if (!interactive && !destinationImminent) break;
                this.sound("sound.event.illegalMove");
                this.showInformationPanel((FreeColObject)unit, (StringTemplate)StringTemplate.template("move.noAccessWater").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            case MOVE_NO_ATTACK_MARINE: {
                if (!interactive && !destinationImminent) break;
                this.sound("sound.event.illegalMove");
                this.showInformationPanel((FreeColObject)unit, (StringTemplate)StringTemplate.template("move.noAttackWater").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            case MOVE_NO_MOVES: {
                destinationImminent = false;
                this.changeState(unit, Unit.UnitState.SKIPPED);
                break;
            }
            case MOVE_NO_TILE: {
                if (!interactive && !destinationImminent) break;
                this.sound("sound.event.illegalMove");
                this.showInformationPanel((FreeColObject)unit, (StringTemplate)StringTemplate.template("move.noTile").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            default: {
                if (interactive || destinationImminent) {
                    this.sound("sound.event.illegalMove");
                }
                result = false;
            }
        }
        if (destinationImminent && !unit.isDisposed() && !this.askClearGotoOrders(unit)) {
            result = false;
        }
        if (unit == this.getGUI().getActiveUnit()) {
            this.changeView(unit, true);
        }
        return result;
    }

    private boolean moveAwayFromEurope(Unit unit, Location destination) {
        List<Unit> ul;
        if (this.getClientOptions().getBoolean("model.option.autoloadEmigrants") && unit.isInEurope() && !(ul = CollectionUtils.transform(unit.getOwner().getEurope().getUnits(), Unit.sentryPred)).isEmpty()) {
            this.moveAutoload(unit, ul);
        }
        EuropeWas europeWas = !unit.isInEurope() ? null : new EuropeWas(unit.getOwner().getEurope());
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askServer().moveTo(unit, destination);
        if (ret) {
            this.fireChanges(unitWas, europeWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    private boolean moveTowardEurope(Unit unit, Europe europe) {
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().moveTo(unit, europe)) {
            this.fireChanges(unitWas);
            this.updateGUI(null, false);
        }
        return false;
    }

    private boolean moveAttack(Unit unit, Direction direction) {
        Tile tile = unit.getTile();
        Tile target = tile.getNeighbourOrNull(direction);
        Unit u = target.getFirstUnit();
        if (u == null || unit.getOwner().owns(u)) {
            return false;
        }
        if (this.askClearGotoOrders(unit) && this.getGUI().confirmHostileAction(unit, target) && this.getGUI().confirmPreCombat(unit, target)) {
            this.askServer().attack(unit, direction);
            this.nextModelMessage();
        }
        return false;
    }

    public void attackRanged(Unit unit, Tile target) {
        if (!unit.canAttackRanged(target)) {
            return;
        }
        if (this.askClearGotoOrders(unit) && this.getGUI().confirmHostileAction(unit, target) && this.getGUI().confirmPreCombat(unit, target)) {
            this.askServer().attackRanged(unit, target);
            this.nextModelMessage();
        }
    }

    private boolean moveAttackSettlement(Unit unit, Direction direction) {
        Tile tile = unit.getTile();
        Tile target = tile.getNeighbourOrNull(direction);
        Settlement settlement = target.getSettlement();
        if (settlement == null || unit.getOwner().owns(settlement)) {
            return false;
        }
        Constants.ArmedUnitSettlementAction act = this.getGUI().getArmedUnitSettlementChoice(settlement);
        if (act == null) {
            return false;
        }
        switch (act) {
            case SETTLEMENT_ATTACK: {
                if (!this.getGUI().confirmHostileAction(unit, target) || !this.getGUI().confirmPreCombat(unit, target)) break;
                this.askServer().attack(unit, direction);
                Colony col = target.getColony();
                if (col != null && unit.getOwner().owns(col)) {
                    this.showColonyPanel(col, unit);
                }
                this.nextModelMessage();
                break;
            }
            case SETTLEMENT_TRIBUTE: {
                int amount;
                int n = settlement instanceof Colony ? this.getGUI().confirmEuropeanTribute(unit, (Colony)settlement, this.nationSummary(settlement.getOwner())) : (amount = settlement instanceof IndianSettlement ? this.getGUI().confirmNativeTribute(unit, (IndianSettlement)settlement) : -1);
                if (amount <= 0) break;
                return this.moveTribute(unit, amount, direction);
            }
            default: {
                logger.warning("showArmedUnitSettlementDialog fail: " + act);
            }
        }
        return false;
    }

    private boolean moveAutoload(Unit carrier, List<Unit> embark) {
        boolean update = false;
        for (Unit u : embark) {
            if (!carrier.couldCarry(u)) continue;
            update |= this.askEmbark(u, carrier);
            if (u.getLocation() == carrier) continue;
            this.changeState(u, Unit.UnitState.SKIPPED);
        }
        if (update) {
            this.updateGUI(null, false);
        }
        return carrier.couldMove();
    }

    private boolean moveDiplomacy(Unit unit, Direction direction, DiplomaticTrade dt) {
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        if (settlement instanceof Colony) {
            Player player = unit.getOwner();
            Colony colony = (Colony)settlement;
            Player other = colony.getOwner();
            if (other == player.getREFPlayer()) {
                return false;
            }
            this.askServer().diplomacy(unit, colony, dt);
            player.clearNationSummary(player);
            player.clearNationSummary(other);
        }
        return false;
    }

    private boolean moveDisembark(Unit unit, Direction direction) {
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (tile.getFirstUnit() != null && tile.getFirstUnit().getOwner() != unit.getOwner()) {
            return false;
        }
        List<Unit> disembarkable = CollectionUtils.transform(unit.getUnits(), u -> u.getMoveType(tile).isProgress());
        if (disembarkable.isEmpty()) {
            return false;
        }
        for (Unit u2 : disembarkable) {
            this.changeState(u2, Unit.UnitState.ACTIVE);
        }
        if (disembarkable.size() == 1) {
            if (this.getGUI().confirm(tile, StringTemplate.key("disembark.text"), disembarkable.get(0), "ok", "cancel")) {
                this.moveDirection(disembarkable.get(0), direction, false);
            }
        } else {
            Unit u2;
            List choices = CollectionUtils.transform(disembarkable, CollectionUtils.alwaysTrue(), u -> new ChoiceItem<Unit>(u.getDescription(Unit.UnitLabelType.NATIONAL), (Unit)u));
            choices.add(new ChoiceItem<Unit>(Messages.message("all"), unit));
            u2 = (Unit)this.getGUI().getChoice(unit.getTile(), StringTemplate.key("disembark.text"), unit, "none", choices);
            if (u2 != null) {
                if (u2 == unit) {
                    for (Unit dUnit : disembarkable) {
                        this.moveDirection(dUnit, direction, false);
                    }
                } else {
                    this.moveDirection(u2, direction, false);
                }
            }
        }
        return true;
    }

    private boolean moveEmbark(Unit unit, Direction direction) {
        if (unit.getColony() != null && !this.getGUI().confirmLeaveColony(unit)) {
            return false;
        }
        Tile sourceTile = unit.getTile();
        Tile destinationTile = sourceTile.getNeighbourOrNull(direction);
        Unit carrier = null;
        List choices = CollectionUtils.transform(destinationTile.getUnits(), u -> u.canAdd(unit), u -> new ChoiceItem<Unit>(u.getDescription(Unit.UnitLabelType.NATIONAL), (Unit)u));
        if (choices.isEmpty()) {
            throw new RuntimeException("Unit " + unit.getId() + " found no carrier to embark upon.");
        }
        if (choices.size() == 1) {
            carrier = (Unit)choices.get(0).getObject();
        } else {
            carrier = (Unit)this.getGUI().getChoice(unit.getTile(), StringTemplate.key("embark.text"), unit, "none", choices);
            if (carrier == null) {
                return false;
            }
        }
        if (this.askClearGotoOrders(unit) && this.askServer().embark(unit, carrier, direction) && unit.getLocation() == carrier) {
            unit.getOwner().invalidateCanSeeTiles();
        } else {
            this.changeState(unit, Unit.UnitState.SKIPPED);
        }
        return false;
    }

    private boolean moveExplore(Unit unit, Direction direction) {
        Tile now = unit.getTile();
        Tile tile = now.getNeighbourOrNull(direction);
        if (!this.getGUI().confirm(now, StringTemplate.key("exploreLostCityRumour.text"), unit, "exploreLostCityRumour.yes", "exploreLostCityRumour.no")) {
            if (unit.getDestination() != null) {
                this.askClearGotoOrders(unit);
            }
            return false;
        }
        if (tile.getLostCityRumour().getType() == LostCityRumour.RumourType.MOUNDS && !this.getGUI().confirm(now, StringTemplate.key("exploreMoundsRumour.text"), unit, "exploreLostCityRumour.yes", "exploreLostCityRumour.no")) {
            this.askServer().declineMounds(unit, direction);
            return false;
        }
        this.moveTile(unit, direction);
        return false;
    }

    private boolean moveHighSeas(Unit unit, Direction direction) {
        Tile oldTile = unit.getTile();
        Tile newTile = oldTile.getNeighbourOrNull(direction);
        if (newTile == null || !oldTile.isDirectlyHighSeasConnected() && newTile.isDirectlyHighSeasConnected()) {
            TradeRouteStop stop;
            if (unit.getTradeRoute() != null && (stop = unit.getStop()) != null && TradeRoute.isStopValid(unit, stop) && stop.getLocation() instanceof Europe) {
                return this.moveTowardEurope(unit, (Europe)stop.getLocation());
            }
            if (unit.getDestination() instanceof Europe) {
                return this.moveTowardEurope(unit, (Europe)unit.getDestination());
            }
            if (this.getGUI().confirm(oldTile, (StringTemplate)StringTemplate.template("highseas.text").addAmount("%number%", unit.getSailTurns()), unit, "highseas.yes", "highseas.no")) {
                return this.moveTowardEurope(unit, unit.getOwner().getEurope());
            }
        }
        return this.moveTile(unit, direction);
    }

    private boolean moveLearnSkill(Unit unit, Direction direction) {
        if (this.askClearGotoOrders(unit) && this.askServer().askSkill(unit, direction)) {
            IndianSettlement is = (IndianSettlement)this.getSettlementAt(unit.getTile(), direction);
            UnitType skill = is.getLearnableSkill();
            if (skill == null) {
                this.showInformationPanel((FreeColObject)is, "info.noMoreSkill");
            } else if (unit.getUnitChange("model.unitChange.natives") == null) {
                this.showInformationPanel((FreeColObject)is, (StringTemplate)((StringTemplate)StringTemplate.template("info.cantLearnSkill").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL))).addNamed("%skill%", skill));
            } else if (this.getGUI().confirm(unit.getTile(), (StringTemplate)StringTemplate.template("learnSkill.text").addNamed("%skill%", skill), unit, "learnSkill.yes", "learnSkill.no") && this.askServer().learnSkill(unit, direction)) {
                if (unit.isDisposed()) {
                    this.showInformationPanel((FreeColObject)is, "learnSkill.die");
                } else if (unit.getType() != skill) {
                    this.showInformationPanel((FreeColObject)is, "learnSkill.leave");
                }
            }
        }
        return false;
    }

    private boolean moveTile(Unit unit, Direction direction) {
        boolean ret;
        boolean discover;
        List<Unit> ul;
        ClientOptions options = this.getClientOptions();
        if (unit.canCarryUnits() && unit.hasSpaceLeft() && options.getBoolean("model.option.autoloadSentries") && unit.isInColony() && !(ul = unit.getTile().getUnitList()).isEmpty() && !this.moveAutoload(unit, CollectionUtils.transform(ul, Unit.sentryPred))) {
            return false;
        }
        Tile newTile = unit.getTile().getNeighbourOrNull(direction);
        boolean bl = discover = newTile != null && newTile.getDiscoverableRegion() != null;
        if (!this.askServer().move(unit, direction)) {
            this.changeState(unit, Unit.UnitState.SKIPPED);
            return false;
        }
        unit.getOwner().invalidateCanSeeTiles();
        if (unit.getMovesLeft() <= 0 && options.getBoolean("model.option.unitLastMoveDelay")) {
            Utils.delay(300L, "Last move delay interrupted.");
        }
        boolean bl2 = ret = !unit.isDisposed() && !this.checkCashInTreasureTrain(unit);
        if (ret) {
            Tile tile = unit.getTile();
            if (unit.isInColony() && unit.isCarrier() && unit.getTradeRoute() == null && Map.isSameLocation(tile, unit.getDestination())) {
                this.showColonyPanelWithCarrier(tile.getColony(), unit);
                ret = false;
            }
        }
        return ret && !discover;
    }

    private boolean moveScoutColony(Unit unit, Direction direction) {
        boolean canNeg;
        Game game = this.getGame();
        Colony colony = (Colony)this.getSettlementAt(unit.getTile(), direction);
        boolean bl = canNeg = colony.getOwner() != unit.getOwner().getREFPlayer();
        if (!this.askClearGotoOrders(unit)) {
            return false;
        }
        Constants.ScoutColonyAction act = this.getGUI().getScoutForeignColonyChoice(colony, unit, canNeg);
        if (act == null) {
            return true;
        }
        switch (act) {
            case SCOUT_COLONY_ATTACK: {
                return this.moveAttackSettlement(unit, direction);
            }
            case SCOUT_COLONY_NEGOTIATE: {
                Player player = unit.getOwner();
                DiplomaticTrade agreement = new DiplomaticTrade(game, DiplomaticTrade.TradeContext.DIPLOMATIC, player, colony.getOwner(), null, 0);
                this.showNegotiationDialog(unit, colony, agreement, agreement.getSendMessage(player, colony), direction);
                return false;
            }
            case SCOUT_COLONY_SPY: {
                return this.moveSpy(unit, direction);
            }
        }
        logger.warning("showScoutForeignColonyDialog fail: " + act);
        return true;
    }

    private boolean moveScoutIndianSettlement(Unit unit, Direction direction) {
        if (!this.askClearGotoOrders(unit) || !this.askServer().scoutSettlement(unit, direction)) {
            return false;
        }
        Tile unitTile = unit.getTile();
        Tile tile = unitTile.getNeighbourOrNull(direction);
        Player player = unit.getOwner();
        IndianSettlement is = tile.getIndianSettlement();
        int count = player.getNationSummary(is.getOwner()).getNumberOfSettlements();
        Constants.ScoutIndianSettlementAction act = this.getGUI().getScoutIndianSettlementChoice(is, count <= 0 ? Messages.message("many") : Integer.toString(count));
        if (act == null) {
            return false;
        }
        switch (act) {
            case SCOUT_SETTLEMENT_ATTACK: {
                if (!this.getGUI().confirmPreCombat(unit, tile)) break;
                this.askServer().attack(unit, direction);
                break;
            }
            case SCOUT_SETTLEMENT_SPEAK: {
                this.moveMode = this.moveMode.minimize(MoveMode.EXECUTE_GOTO_ORDERS);
                this.askServer().scoutSpeakToChief(unit, is);
                break;
            }
            case SCOUT_SETTLEMENT_TRIBUTE: {
                return this.moveTribute(unit, 1, direction);
            }
            default: {
                logger.warning("showScoutIndianSettlementDialog fail: " + act);
            }
        }
        return false;
    }

    private boolean moveSpy(Unit unit, Direction direction) {
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        if (settlement instanceof Colony && !unit.getOwner().owns(settlement)) {
            this.askServer().spy(unit, settlement);
        } else {
            logger.warning("Unit " + unit + " can not spy on " + settlement);
        }
        return false;
    }

    private boolean moveTrade(Unit unit, Direction direction) {
        if (!this.askClearGotoOrders(unit)) {
            return false;
        }
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        if (settlement instanceof Colony) {
            Game game = this.getGame();
            Player player = unit.getOwner();
            DiplomaticTrade agreement = new DiplomaticTrade(game, DiplomaticTrade.TradeContext.TRADE, player, settlement.getOwner(), null, 0);
            this.showNegotiationDialog(unit, settlement, agreement, agreement.getSendMessage(player, settlement), direction);
        } else if (settlement instanceof IndianSettlement) {
            this.askServer().newNativeTradeSession(unit, (IndianSettlement)settlement);
            this.changeView(unit, false);
        } else {
            throw new RuntimeException("Bogus settlement: " + settlement.getId());
        }
        return false;
    }

    private boolean moveTribute(Unit unit, int amount, Direction direction) {
        Game game = this.getGame();
        Player player = unit.getOwner();
        Tile tile = unit.getTile();
        Tile target = tile.getNeighbourOrNull(direction);
        Settlement settlement = target.getSettlement();
        Player other = settlement.getOwner();
        if (settlement.getOwner().isIndian()) {
            this.askServer().demandTribute(unit, direction);
            return false;
        }
        DiplomaticTrade agreement = DiplomaticTrade.makePeaceTreaty(DiplomaticTrade.TradeContext.TRIBUTE, player, other);
        agreement.add(new GoldTradeItem(game, other, player, amount));
        return this.moveDiplomacy(unit, direction, agreement);
    }

    private boolean moveUseMissionary(Unit unit, Direction direction) {
        if (!this.askClearGotoOrders(unit)) {
            return false;
        }
        IndianSettlement is = (IndianSettlement)this.getSettlementAt(unit.getTile(), direction);
        this.getMissionaryChoice(unit, is, direction);
        return false;
    }

    private boolean followTradeRoute(Unit unit, List<ModelMessage> messages) {
        Player player = unit.getOwner();
        TradeRoute tr = unit.getTradeRoute();
        boolean detailed = this.getClientOptions().getBoolean("model.option.guiShowGoodsMovement");
        boolean checkProduction = this.getClientOptions().getBoolean("model.option.stockAccountsForProduction");
        List<TradeRouteStop> stops = unit.getCurrentStops();
        boolean result = true;
        LogBuilder lb = new LogBuilder(detailed && !tr.isSilent() ? 256 : -1);
        lb.mark();
        boolean valid = true;
        for (TradeRouteStop trs : stops) {
            if (TradeRoute.isStopValid(unit, trs)) continue;
            lb.add(" ", Messages.message(trs.invalidStopLabel(player)));
            valid = false;
        }
        if (!valid) {
            this.clearOrders(unit);
            stops.clear();
            result = false;
        }
        while (!stops.isEmpty()) {
            TradeRouteStop stop = stops.remove(0);
            if (!unit.atStop(stop)) {
                if (unit.getMovesLeft() <= 0 || unit.getState() == Unit.UnitState.SKIPPED) {
                    lb.add(" ", Messages.message(stop.getLabelFor("tradeRoute.toStop", player)));
                    break;
                }
                Location destination = stop.getLocation();
                PathNode path = unit.findPath(destination);
                if (path == null) {
                    lb.add("\n", Messages.message(stop.getLabelFor("tradeRoute.pathStop", player)));
                    this.changeState(unit, Unit.UnitState.SKIPPED);
                    break;
                }
                this.movePath(unit, path);
                if (!unit.atStop(stop)) {
                    this.changeState(unit, Unit.UnitState.SKIPPED);
                    break;
                }
            }
            lb.mark();
            this.unloadUnitAtStop(unit, lb);
            this.loadUnitAtStop(unit, lb);
            lb.grew("\n", Messages.message(stop.getLabelFor("tradeRoute.atStop", player)));
            if (unit.getMovesLeft() <= 0) break;
            TradeRouteStop next = null;
            List<TradeRouteStop> moreStops = unit.getCurrentStops();
            if (unit.atStop(moreStops.get(0))) {
                moreStops.remove(0);
            }
            for (TradeRouteStop trs : moreStops) {
                if (!trs.hasWork(unit, !checkProduction ? 0 : unit.getTurnsToReach(trs.getLocation()))) continue;
                next = trs;
                break;
            }
            if (next == null) {
                lb.add(" ", Messages.message("tradeRoute.wait"));
                this.changeState(unit, Unit.UnitState.SKIPPED);
                unit.setMovesLeft(0);
                break;
            }
            List<TradeRouteStop> skipped = tr.getStopSublist(stops.get(0), next);
            if (!skipped.isEmpty()) {
                Object t = StringTemplate.label("").add("tradeRoute.skipped");
                String sep = " ";
                for (TradeRouteStop trs : skipped) {
                    ((StringTemplate)((StringTemplate)t).addName(sep)).addStringTemplate(trs.getLocation().getLocationLabelFor(player));
                    sep = ", ";
                }
                ((StringTemplate)t).addName(".");
                lb.add(" ", Messages.message(t));
            }
            while (!stops.isEmpty() && stops.get(0) != next) {
                stops.remove(0);
            }
            if (this.askServer().setCurrentStop(unit, tr.getIndex(next))) continue;
            this.changeState(unit, Unit.UnitState.SKIPPED);
            break;
        }
        if (lb.grew(new Object[0])) {
            ModelMessage m = (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "tradeRoute.prefix", unit).addName("%route%", tr.getName())).addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL))).addName("%data%", lb.toString());
            if (messages != null) {
                messages.add(m);
            } else {
                player.addModelMessage(m);
                this.turnReportMessages.add(m);
            }
        }
        return result;
    }

    private boolean loadUnitAtStop(Unit unit, LogBuilder lb) {
        AbstractGoods ag;
        boolean enhancedTradeRoutes = this.getSpecification().getBoolean("model.option.enhancedTradeRoutes");
        TradeRoute tradeRoute = unit.getTradeRoute();
        TradeLocation trl = unit.getTradeLocation();
        if (trl == null) {
            return false;
        }
        TradeRouteStop stop = unit.getStop();
        boolean ret = false;
        List<AbstractGoods> toLoad = stop.getCompactCargo();
        StringTemplate unexpected = StringTemplate.label(", ");
        StringTemplate noLoad = StringTemplate.label(", ");
        StringTemplate left = StringTemplate.label(", ");
        StringTemplate loaded = StringTemplate.label(", ");
        StringTemplate nonePresent = StringTemplate.label(", ");
        for (Goods g : unit.getCompactGoodsList()) {
            ag = CollectionUtils.find(toLoad, AbstractGoods.matches(g.getType()));
            if (ag == null) {
                unexpected.addStringTemplate(g.getLabel());
                continue;
            }
            int goodsAmount = g.getAmount();
            if (ag.getAmount() <= goodsAmount) {
                noLoad.addStringTemplate((StringTemplate)StringTemplate.template("tradeRoute.loadStop.noLoad.carrier").addNamed("%goodsType%", ag.getType()));
                toLoad.remove(ag);
                continue;
            }
            ag.setAmount(ag.getAmount() - goodsAmount);
        }
        HashMap<GoodsType, Location> limit = new HashMap<GoodsType, Location>();
        Iterator<AbstractGoods> iterator = toLoad.iterator();
        while (iterator.hasNext()) {
            ag = iterator.next();
            GoodsType type = ag.getType();
            int present = stop.getAvailableGoodsCount(type);
            int exportAmount = stop.getExportAmount(type, 0);
            int importAmount = Integer.MAX_VALUE;
            TradeRouteStop unload = null;
            if (enhancedTradeRoutes) {
                List<TradeRouteStop> stops = unit.getCurrentStops();
                stops.remove(0);
                Location start = unit.getLocation();
                int turns = 0;
                for (TradeRouteStop trs : stops) {
                    int amountIn = trs.getImportAmount(type, turns += unit.getTurnsToReach(start, trs.getLocation()));
                    int amountOut = trs.getExportAmount(type, turns);
                    if (CollectionUtils.none(trs.getCompactCargo(), AbstractGoods.matches(type)) || amountIn > amountOut) {
                        importAmount = amountIn;
                        unload = trs;
                        break;
                    }
                    start = trs.getLocation();
                }
            }
            if (enhancedTradeRoutes && unload == null) {
                noLoad.addStringTemplate((StringTemplate)StringTemplate.template("tradeRoute.loadStop.noLoad.noUnload").addNamed("%goodsType%", type));
                ag.setAmount(0);
            } else if (present <= 0) {
                nonePresent.addNamed(type);
                ag.setAmount(0);
            } else if (exportAmount <= 0) {
                noLoad.addStringTemplate((StringTemplate)((StringTemplate)StringTemplate.template("tradeRoute.loadStop.noLoad.export").addNamed("%goodsType%", type)).addAmount("%more%", present));
                ag.setAmount(0);
            } else if (importAmount <= 0) {
                noLoad.addStringTemplate((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("tradeRoute.loadStop.noLoad.import").addNamed("%goodsType%", type)).addAmount("%more%", present)).addStringTemplate("%location%", unload.getLocation().getLocationLabelFor(unit.getOwner())));
                ag.setAmount(0);
            } else if (exportAmount <= importAmount && exportAmount < ag.getAmount()) {
                ag.setAmount(exportAmount);
                limit.put(type, stop.getLocation());
            } else if (importAmount <= exportAmount && importAmount < ag.getAmount()) {
                int already = unit.getGoodsCount(type);
                if (already >= importAmount) {
                    if (already > importAmount) {
                        this.askUnloadGoods(type, already - importAmount, unit);
                    }
                    noLoad.addStringTemplate((StringTemplate)StringTemplate.template("tradeRoute.loadStop.noLoad.already").addNamed("%goodsType%", type));
                    ag.setAmount(0);
                } else {
                    ag.setAmount(importAmount - already);
                }
                limit.put(type, unload.getLocation());
            } else if (present > ag.getAmount()) {
                limit.put(type, unit);
            } else {
                limit.put(type, null);
            }
            if (ag.getAmount() <= 0) {
                iterator.remove();
            }
            logger.log(Level.FINEST, "Load " + tradeRoute.getName() + " with " + unit.getId() + " at " + stop.getLocation() + " of " + type.getSuffix() + " from " + present + " exporting " + exportAmount + " importing " + importAmount + " to " + (unload == null ? "?" : unload.getLocation().toString()) + " limited by " + limit.get(type) + " -> " + ag.getAmount());
        }
        if (enhancedTradeRoutes) {
            toLoad.sort(AbstractGoods.descendingAmountComparator);
        }
        boolean done = false;
        for (AbstractGoods ag2 : toLoad) {
            GoodsType type = ag2.getType();
            int amount = ag2.getAmount();
            if (!done) {
                if (unit.getLoadableAmount(type) < amount) {
                    done = true;
                } else if (stop.getLocation() instanceof Europe) {
                    done = !this.buyGoods(type, amount, unit);
                } else {
                    boolean bl = done = !this.askLoadGoods(stop.getLocation(), type, amount, unit);
                }
            }
            if (done) {
                left.addNamed(ag2);
                continue;
            }
            int present = stop.getAvailableGoodsCount(type);
            Location why = (Location)limit.get(type);
            if (present == 0) {
                loaded.addStringTemplate(ag2.getLabel());
            } else if (why == null) {
                loaded.addStringTemplate((StringTemplate)((StringTemplate)StringTemplate.template("tradeRoute.loadStop.load.fail").addStringTemplate("%goods%", ag2.getLabel())).addAmount("%more%", present));
            } else if (why == unit) {
                loaded.addStringTemplate((StringTemplate)((StringTemplate)StringTemplate.template("tradeRoute.loadStop.load.carrier").addStringTemplate("%goods%", ag2.getLabel())).addAmount("%more%", present));
            } else if (Map.isSameLocation(why, stop.getLocation())) {
                loaded.addStringTemplate((StringTemplate)((StringTemplate)StringTemplate.template("tradeRoute.loadStop.load.export").addStringTemplate("%goods%", ag2.getLabel())).addAmount("%more%", present));
            } else {
                loaded.addStringTemplate((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("tradeRoute.loadStop.load.import").addStringTemplate("%goods%", ag2.getLabel())).addAmount("%more%", present)).addStringTemplate("%location%", why.getLocationLabelFor(unit.getOwner())));
            }
            ret = true;
        }
        if (!loaded.isEmpty()) {
            lb.add("\n  ", Messages.message(StringTemplate.template("tradeRoute.loadStop.load").addStringTemplate("%goodsList%", loaded)));
        }
        if (!unexpected.isEmpty()) {
            lb.add("\n  ", Messages.message(StringTemplate.template("tradeRoute.loadStop.unexpected").addStringTemplate("%goodsList%", unexpected)));
        }
        if (!left.isEmpty()) {
            noLoad.addStringTemplate((StringTemplate)StringTemplate.template("tradeRoute.loadStop.noLoad.left").addStringTemplate("%goodsList%", left));
        }
        if (!nonePresent.isEmpty()) {
            noLoad.addStringTemplate((StringTemplate)StringTemplate.template("tradeRoute.loadStop.noLoad.goods").addStringTemplate("%goodsList%", nonePresent));
        }
        if (!noLoad.isEmpty()) {
            lb.add("\n  ", Messages.message(StringTemplate.template("tradeRoute.loadStop.noLoad").addStringTemplate("%goodsList%", noLoad)));
        }
        return ret;
    }

    private boolean unloadUnitAtStop(Unit unit, LogBuilder lb) {
        TradeLocation trl = unit.getTradeLocation();
        if (trl == null) {
            return false;
        }
        TradeRouteStop stop = unit.getStop();
        List<GoodsType> goodsTypesToLoad = stop.getCargo();
        StringTemplate unloaded = StringTemplate.label(", ");
        StringTemplate noUnload = StringTemplate.label(", ");
        boolean ret = false;
        block5: for (Goods goods : unit.getCompactGoodsList()) {
            GoodsType type = goods.getType();
            if (goodsTypesToLoad.contains(type)) continue;
            int present = goods.getAmount();
            if (present <= 0) {
                logger.warning("Unexpected empty goods unload " + goods);
                continue;
            }
            int toUnload = present;
            int amount = toUnload;
            int atStop = trl.getImportAmount(type, 0);
            if (amount > atStop) {
                StringTemplate locName = ((Location)((Object)trl)).getLocationLabel();
                int option = this.getClientOptions().getInteger("model.option.unloadOverflowResponse");
                switch (option) {
                    case 0: {
                        Object template = ((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("traderoute.warehouseCapacity").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL))).addStringTemplate("%colony%", locName)).addAmount("%amount%", toUnload - atStop)).addNamed("%goods%", goods);
                        if (this.getGUI().confirm(unit.getTile(), (StringTemplate)template, unit, "yes", "no")) break;
                        if (atStop == 0) continue block5;
                        amount = atStop;
                        break;
                    }
                    case 1: {
                        amount = atStop;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        logger.warning("Illegal UNLOAD_OVERFLOW_RESPONSE: " + Integer.toString(option));
                    }
                }
            }
            if (amount == 0) {
                noUnload.addStringTemplate(goods.getLabel());
                continue;
            }
            ret = this.askUnloadGoods(type, amount, unit);
            int retained = unit.getGoodsCount(type);
            if (!ret || present == retained) {
                noUnload.addStringTemplate((StringTemplate)StringTemplate.template("tradeRoute.unloadStop.noUnload.fail").addStringTemplate("%goods%", goods.getLabel()));
                ret = false;
                break;
            }
            if (present - retained != amount) {
                unloaded.addStringTemplate((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("tradeRoute.unloadStop.unload.fail").addNamed("%goodsType%", type)).addAmount("%amount%", amount)).addAmount("%more%", retained));
                continue;
            }
            if (amount > atStop) {
                if (retained > 0) {
                    unloaded.addStringTemplate((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("tradeRoute.unloadStop.unload.keep").addNamed("%goodsType%", type)).addAmount("%amount%", atStop)).addAmount("%more%", retained));
                    continue;
                }
                unloaded.addStringTemplate((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("tradeRoute.unloadStop.unload.overflow").addNamed("%goodsType%", type)).addAmount("%amount%", atStop)).addAmount("%more%", amount - atStop));
                continue;
            }
            unloaded.addStringTemplate(goods.getLabel());
        }
        if (!unloaded.isEmpty()) {
            lb.add("\n  ", Messages.message(StringTemplate.template("tradeRoute.unloadStop.unload").addStringTemplate("%goodsList%", unloaded)));
        }
        if (!noUnload.isEmpty()) {
            lb.add("\n  ", Messages.message(StringTemplate.template("tradeRoute.unloadStop.noUnload").addStringTemplate("%goodsList%", noUnload)));
        }
        return ret;
    }

    public boolean abandonColony(Colony colony) {
        boolean ret;
        Player player = this.getMyPlayer();
        if (colony == null || !player.owns(colony) || colony.getUnitCount() > 0 || !this.requireOurTurn()) {
            return false;
        }
        Tile tile = colony.getTile();
        boolean bl = ret = this.askServer().abandonColony(colony) && !tile.hasSettlement();
        if (ret) {
            player.invalidateCanSeeTiles();
            this.updateGUI(tile, false);
        }
        return ret;
    }

    public void addPlayerHandler(List<Player> players) {
        this.getGame().addPlayers(players);
    }

    public void animateAttackHandler(Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success) {
        this.invokeLater(() -> this.getGUI().animateUnitAttack(attacker, defender, attackerTile, defenderTile, success));
    }

    public void animateMoveHandler(Unit unit, Tile oldTile, Tile newTile) {
        this.invokeLater(() -> this.getGUI().animateUnitMove(unit, oldTile, newTile));
    }

    public boolean assignTeacher(Unit student, Unit teacher) {
        boolean ret;
        Player player = this.getMyPlayer();
        if (!(student != null && player.owns(student) && student.getColony() != null && student.isInColony() && teacher != null && player.owns(teacher) && student.canBeStudent(teacher) && teacher.getColony() != null && student.getColony() == teacher.getColony() && teacher.getColony().canTrain(teacher) && this.requireOurTurn())) {
            return false;
        }
        UnitWas unitWas = new UnitWas(student);
        boolean bl = ret = this.askServer().assignTeacher(student, teacher) && student.getTeacher() == teacher;
        if (ret) {
            this.fireChanges(unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean assignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        if (unit == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askAssignTradeRoute(unit, tradeRoute);
        if (ret) {
            this.fireChanges(unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean boardShip(Unit unit, Unit carrier) {
        if (unit == null || unit.isCarrier() || carrier == null || !carrier.canCarryUnits() || !unit.isAtLocation(carrier.getLocation()) || !this.requireOurTurn()) {
            return false;
        }
        boolean ret = this.askEmbark(unit, carrier);
        if (ret) {
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean buildColony(Unit unit) {
        StringTemplate warnings;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return false;
        }
        if (!unit.canBuildColony()) {
            this.showInformationPanel((FreeColObject)unit, (StringTemplate)StringTemplate.template("buildColony.badUnit").addName("%unit%", unit.getName()));
            return false;
        }
        if (this.joinColony(unit) || tile.getColony() != null) {
            return false;
        }
        Player player = this.getMyPlayer();
        Player.NoClaimReason reason = player.canClaimToFoundSettlementReason(tile);
        switch (reason) {
            case NONE: 
            case NATIVES: {
                break;
            }
            default: {
                this.showInformationPanel(null, reason.getDescriptionKey());
                return false;
            }
        }
        if (this.getClientOptions().getBoolean("model.option.guiShowColonyWarnings") && !(warnings = tile.getBuildColonyWarnings(unit)).isEmpty() && !this.getGUI().confirm(tile, warnings, unit, "buildColony.yes", "buildColony.no")) {
            return false;
        }
        String name = this.getGUI().getNewColonyName(player, tile);
        if (name == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = player.owns(tile);
        if (!ret && !(ret = this.askClaimTile(player, tile, unit, player.getLandPrice(tile)))) {
            NameCache.putSettlementName(player, name);
        }
        if (ret) {
            boolean bl = ret = this.askServer().buildColony(name, unit) && tile.hasSettlement();
            if (ret) {
                this.sound("sound.event.buildingComplete");
                player.invalidateCanSeeTiles();
                this.fireChanges(unitWas);
                for (Unit u : tile.getUnitList()) {
                    this.checkCashInTreasureTrain(u);
                }
                this.updateGUI(null, false);
                this.showColonyPanelWithCarrier((Colony)tile.getSettlement(), unit);
            }
        }
        return ret;
    }

    public boolean buyGoods(GoodsType type, int amount, Unit carrier) {
        Player player = this.getMyPlayer();
        if (!(type != null && amount > 0 && carrier != null && carrier.isInEurope() && player.owns(carrier) && this.requireOurTurn())) {
            return false;
        }
        Europe europe = player.getEurope();
        EuropeWas europeWas = new EuropeWas(europe);
        MarketWas marketWas = new MarketWas(player);
        UnitWas unitWas = new UnitWas(carrier);
        boolean ret = this.askLoadGoods(europe, type, amount, carrier);
        if (ret) {
            marketWas.add(new AbstractGoods(type, -amount));
            this.sound("sound.event.loadCargo");
            this.fireChanges(unitWas, europeWas, marketWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean chat(String chat) {
        if (chat == null) {
            return false;
        }
        Player player = this.getMyPlayer();
        boolean sent = this.askServer().chat(player, chat);
        this.displayChat(player.getName(), chat, player.getNationColor(), false);
        return sent;
    }

    public void chatHandler(String sender, String message, Color color, boolean pri) {
        this.displayChat(sender, message, color, pri);
    }

    public boolean changeState(Unit unit, Unit.UnitState state) {
        boolean ret;
        Player enemy;
        Tile tile;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        if (unit.getState() == state) {
            return true;
        }
        if (!unit.checkSetState(state)) {
            return false;
        }
        Player player = this.getMyPlayer();
        if (state == Unit.UnitState.FORTIFYING && unit.isOffensiveUnit() && !unit.isOwnerHidden() && (tile = unit.getTile()) != null && tile.getOwningSettlement() != null && player != (enemy = tile.getOwningSettlement().getOwner()) && player.getStance(enemy) != Stance.ALLIANCE && !this.getGUI().confirmHostileAction(unit, tile)) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().changeState(unit, state) && unit.getState() == state;
        if (ret) {
            this.fireChanges(unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean changeWorkImprovementType(Unit unit, TileImprovementType improvementType) {
        boolean ret;
        if (unit == null || !unit.hasTile() || !unit.checkSetState(Unit.UnitState.IMPROVING) || improvementType == null || improvementType.isNatural() || !this.requireOurTurn()) {
            return false;
        }
        Player player = this.getMyPlayer();
        Tile tile = unit.getTile();
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = player.owns(tile) || this.askClaimTile(player, tile, unit, player.getLandPrice(tile));
        if (ret) {
            this.updateGUI(null, false);
            boolean bl2 = ret = this.askServer().changeWorkImprovementType(unit, improvementType) && unit.getWorkImprovement() != null && unit.getWorkImprovement().getType() == improvementType;
            if (ret) {
                this.fireChanges(unitWas);
                this.updateGUI(null, false);
            }
        }
        return ret;
    }

    public boolean changeWorkType(Unit unit, GoodsType workType) {
        boolean ret;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().changeWorkType(unit, workType) && unit.getWorkType() == workType;
        if (ret) {
            this.fireChanges(unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean checkCashInTreasureTrain(Unit unit) {
        boolean ret;
        if (!(unit != null && unit.canCarryTreasure() && unit.canCashInTreasureTrain() && this.requireOurTurn())) {
            return false;
        }
        Tile tile = unit.getTile();
        Europe europe = unit.getOwner().getEurope();
        if (europe != null && !unit.isInEurope()) {
            StringTemplate template;
            int fee = unit.getTransportFee();
            if (fee == 0) {
                template = StringTemplate.template("cashInTreasureTrain.free");
            } else {
                int percent = this.getSpecification().getInteger("model.option.treasureTransportFee");
                template = StringTemplate.template("cashInTreasureTrain.pay").addAmount("%fee%", percent);
            }
            if (!this.getGUI().confirm(unit.getTile(), template, unit, "accept", "reject")) {
                return false;
            }
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().cashInTreasureTrain(unit) && unit.isDisposed();
        if (ret) {
            this.sound("sound.event.cashInTreasureTrain");
            this.fireChanges(unitWas);
        }
        return ret;
    }

    private boolean chooseFoundingFather(List<FoundingFather> ffs, FoundingFather ff) {
        if (ffs == null) {
            return false;
        }
        if (ff == null) {
            return false;
        }
        Player player = this.getMyPlayer();
        player.setCurrentFather(ff);
        return this.askServer().chooseFoundingFather(ffs, ff);
    }

    public void chooseFoundingFatherHandler(List<FoundingFather> ffs) {
        if (ffs == null || ffs.isEmpty()) {
            return;
        }
        this.invokeLater(() -> this.getGUI().showChooseFoundingFatherDialog(ffs, ff -> this.chooseFoundingFather(ffs, (FoundingFather)ff)));
    }

    public boolean claimTile(Tile tile, FreeColGameObject claimant) {
        if (tile == null || claimant == null || !this.requireOurTurn()) {
            return false;
        }
        Player player = this.getMyPlayer();
        int price = (claimant instanceof Settlement ? player.canClaimForSettlement(tile) : player.canClaimForImprovement(tile)) ? 0 : player.getLandPrice(tile);
        UnitWas unitWas = claimant instanceof Unit ? new UnitWas((Unit)claimant) : null;
        boolean ret = this.askClaimTile(player, tile, claimant, price);
        if (ret) {
            this.fireChanges(unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean clearGotoOrders(Unit unit) {
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askClearGotoOrders(unit);
        if (ret) {
            this.fireChanges(unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean clearOrders(Unit unit) {
        boolean ret;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        if (unit.getState() == Unit.UnitState.IMPROVING && !this.getGUI().confirm(unit.getTile(), (StringTemplate)StringTemplate.template("clearOrders.text").addAmount("%turns%", unit.getWorkTurnsLeft()), unit, "ok", "cancel")) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askClearGotoOrders(unit) && this.changeState(unit, Unit.UnitState.ACTIVE);
        if (ret) {
            this.fireChanges(unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean clearSpeciality(Unit unit) {
        boolean ret;
        Tile tile;
        UnitType newType;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        UnitTypeChange uc = unit.getUnitChange("model.unitChange.clearSkill");
        UnitType unitType = newType = uc == null ? null : uc.to;
        if (newType == null) {
            this.showInformationPanel((FreeColObject)unit, (StringTemplate)StringTemplate.template("clearSpeciality.impossible").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
            return false;
        }
        Tile tile2 = tile = this.getGUI().isPanelShowing() ? null : unit.getTile();
        if (!this.getGUI().confirm(tile, (StringTemplate)((StringTemplate)StringTemplate.template("clearSpeciality.areYouSure").addStringTemplate("%oldUnit%", unit.getLabel(Unit.UnitLabelType.NATIONAL))).addNamed("%unit%", newType), unit, "ok", "cancel")) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().clearSpeciality(unit) && unit.getType() == newType;
        if (ret) {
            this.fireChanges(unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public void closeColony(Colony colony, boolean abandon) {
        if (abandon) {
            this.abandonColony(colony);
        } else {
            this.updateGUI(colony.getTile(), false);
        }
    }

    public void closeHandler(String panel) {
        this.getGUI().closePanel(panel);
    }

    public boolean declareIndependence() {
        if (!this.requireOurTurn()) {
            return false;
        }
        Player player = this.getMyPlayer();
        if (player.getNewLandName() == null) {
            return false;
        }
        StringTemplate declare = player.checkDeclareIndependence();
        if (declare != null) {
            this.showInformationPanel(null, declare);
            return false;
        }
        List<String> names = this.getGUI().showConfirmDeclarationDialog();
        if (names == null || names.get(0) == null || names.get(0).isEmpty() || names.get(1) == null || names.get(1).isEmpty()) {
            return false;
        }
        this.getGUI().showDeclarationPanel(() -> {
            this.askServer().declareIndependence((String)names.get(0), (String)names.get(1));
            this.updateGUI(null, false);
        });
        return true;
    }

    public boolean deleteTradeRoute(TradeRoute tradeRoute) {
        Player player = this.getMyPlayer();
        String name = tradeRoute.getName();
        boolean ret = this.askServer().deleteTradeRoute(tradeRoute);
        return ret && player.getTradeRouteByName(name, null) == null;
    }

    public void diplomacyHandler(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement) {
        Player player = this.getMyPlayer();
        Player otherPlayer = agreement.getOtherPlayer(player);
        StringTemplate nation = otherPlayer.getNationLabel();
        switch (agreement.getStatus()) {
            case ACCEPT_TRADE: {
                boolean visibilityChange = false;
                for (Colony c : agreement.getColoniesGivenBy(player)) {
                    player.removeSettlement(c);
                    visibilityChange = true;
                }
                for (Unit u : agreement.getUnitsGivenBy(player)) {
                    player.removeUnit(u);
                    visibilityChange = true;
                }
                if (visibilityChange) {
                    player.invalidateCanSeeTiles();
                }
                ModelMessage mm = (ModelMessage)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "diplomacy.offerAccepted", otherPlayer).addStringTemplate("%nation%", nation);
                player.addModelMessage(mm);
                this.updateGUI(null, false);
                break;
            }
            case REJECT_TRADE: {
                Object t = StringTemplate.template("diplomacy.offerRejected").addStringTemplate("%nation%", nation);
                this.showInformationPanel(null, (StringTemplate)t);
                break;
            }
            case PROPOSE_TRADE: {
                this.invokeLater(() -> {
                    StringTemplate template = agreement.getReceiveMessage(otherPlayer);
                    DiplomaticTrade ourAgreement = this.getGUI().showNegotiationDialog(our, other, agreement, template);
                    if (ourAgreement == null) {
                        ourAgreement = agreement;
                        ourAgreement.setStatus(DiplomaticTrade.TradeStatus.REJECT_TRADE);
                    }
                    this.askServer().diplomacy(our, other, ourAgreement);
                });
                break;
            }
            default: {
                logger.warning("Bogus trade status: " + agreement.getStatus());
            }
        }
    }

    public boolean disbandUnit(Unit unit) {
        boolean ret;
        Tile tile;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        if (unit.getColony() != null && !this.getGUI().confirmLeaveColony(unit)) {
            return false;
        }
        Tile tile2 = tile = this.getGUI().isPanelShowing() ? null : unit.getTile();
        if (!this.getGUI().confirm(tile, StringTemplate.key("disbandUnit.text"), unit, "disbandUnit.yes", "cancel")) {
            return false;
        }
        boolean bl = ret = this.askServer().disbandUnit(unit) && unit.isDisposed();
        if (ret) {
            this.updateGUI(tile, false);
        }
        if (this.getMyPlayer().getUnitCount() == 0 && this.setDead()) {
            this.updateGUI(null, true);
        }
        return ret;
    }

    private void emigrate(Player player, int slot, int n, boolean foY) {
        if (player == null || !player.isColonial() || !Europe.MigrationType.validMigrantSlot(slot)) {
            return;
        }
        if (this.askEmigrate(player.getEurope(), slot) != null) {
            this.emigration(player, n, foY);
        }
    }

    public void endTurn(boolean showDialog) {
        if (!this.requireOurTurn()) {
            return;
        }
        this.doEndTurn(showDialog && this.getClientOptions().getBoolean("model.option.showEndTurnDialog"));
    }

    public boolean equipUnitForRole(Unit unit, Role role, int roleCount) {
        boolean ret;
        if (unit == null || role == null || 0 > roleCount || roleCount > role.getMaximumCount() || !this.requireOurTurn()) {
            return false;
        }
        if (role == unit.getRole() && roleCount == unit.getRoleCount()) {
            return true;
        }
        Player player = this.getMyPlayer();
        Colony colony = unit.getColony();
        ColonyWas colonyWas = null;
        EuropeWas europeWas = null;
        MarketWas marketWas = null;
        int price = -1;
        List<AbstractGoods> req = unit.getGoodsDifference(role, roleCount);
        if (unit.isInEurope()) {
            europeWas = new EuropeWas(player.getEurope());
            marketWas = new MarketWas(player);
            for (AbstractGoods ag : req) {
                GoodsType goodsType = ag.getType();
                if (player.canTrade(goodsType) || this.payArrears(goodsType)) continue;
                return false;
            }
            try {
                price = player.getEurope().priceGoods(req);
                if (!player.checkGold(price)) {
                    return false;
                }
            }
            catch (FreeColException fce) {
                return false;
            }
            for (AbstractGoods ag : req) {
                ag.setAmount(-ag.getAmount());
            }
            marketWas.addAll(req);
        } else if (colony != null) {
            colonyWas = new ColonyWas(colony);
            for (AbstractGoods ag : req) {
                if (colony.getGoodsCount(ag.getType()) >= ag.getAmount()) continue;
                Object template = ((StringTemplate)((StringTemplate)StringTemplate.template("equipUnit.impossible").addName("%colony%", colony.getName())).addNamed("%equipment%", ag.getType())).addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL));
                this.showInformationPanel((FreeColObject)unit, (StringTemplate)template);
                return false;
            }
        } else {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().equipUnitForRole(unit, role, roleCount) && unit.getRole() == role;
        if (ret) {
            this.fireChanges(colonyWas, europeWas, marketWas, unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public void errorHandler(StringTemplate template, String message) {
        this.error(template, message);
    }

    public boolean executeGotoOrders() {
        if (!this.requireOurTurn() || this.getGUI().isPanelShowing()) {
            return false;
        }
        return this.doExecuteGotoOrders();
    }

    public void featureChangeHandler(FreeColGameObject parent, List<FreeColObject> children, boolean add) {
        for (FreeColObject fco : children) {
            Player player;
            if (fco instanceof Ability) {
                if (add) {
                    parent.addAbility((Ability)fco);
                    continue;
                }
                parent.removeAbility((Ability)fco);
                continue;
            }
            if (fco instanceof Modifier) {
                if (add) {
                    parent.addModifier((Modifier)fco);
                    continue;
                }
                parent.removeModifier((Modifier)fco);
                continue;
            }
            if (fco instanceof HistoryEvent) {
                if (parent instanceof Player && add) {
                    player = (Player)parent;
                    player.addHistory((HistoryEvent)fco);
                    continue;
                }
                logger.warning("Feature change NYI: " + parent + "/" + add + "/" + fco);
                continue;
            }
            if (fco instanceof LastSale) {
                if (parent instanceof Player && add) {
                    player = (Player)parent;
                    player.addLastSale((LastSale)fco);
                    continue;
                }
                logger.warning("Feature change NYI: " + parent + "/" + add + "/" + fco);
                continue;
            }
            if (fco instanceof ModelMessage) {
                if (parent instanceof Player && add) {
                    player = (Player)parent;
                    player.addModelMessage((ModelMessage)fco);
                    continue;
                }
                logger.warning("Feature change NYI: " + parent + "/" + add + "/" + fco);
                continue;
            }
            logger.warning("featureChange unrecognized: " + fco);
        }
    }

    private boolean firstContact(Player player, Player other, Tile tile, boolean result) {
        if (player == null || player == other || tile == null) {
            return false;
        }
        boolean ret = this.askServer().firstContact(player, other, tile, result);
        if (ret) {
            this.updateGUI(tile, false);
        }
        return ret;
    }

    public void firstContactHandler(Player player, Player other, Tile tile, int n) {
        this.invokeLater(() -> this.getGUI().showFirstContactDialog(player, other, tile, n, b -> this.firstContact(player, other, tile, (boolean)b)));
    }

    public void fountainOfYouthHandler(int n) {
        this.showEmigrationDialog(this.getMyPlayer(), true, n);
    }

    public void gameEndedHandler(String score) {
        this.invokeLater(() -> {
            this.highScore("true".equalsIgnoreCase(score));
            this.getGUI().showVictoryDialog(result -> this.victory((Boolean)result));
        });
    }

    public boolean goToTile(Unit unit, PathNode path) {
        if (unit == null || !this.getMyPlayer().owns(unit) || path == null || !this.requireOurTurn()) {
            return false;
        }
        if (!this.getGUI().confirmClearTradeRoute(unit)) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askSetDestination(unit, path.getLastNode().getLocation());
        if (ret) {
            this.moveToDestination(unit, null);
            this.fireChanges(unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean highScore(Boolean high) {
        return this.askServer().getHighScores(high == null ? null : (high != false ? "highscores.yes" : "highscores.no"));
    }

    public void highScoresHandler(String key, List<HighScore> scores) {
        this.invokeLater(() -> this.getGUI().showHighScoresPanel(key, scores));
    }

    public boolean ignoreMessage(ModelMessage message, boolean flag) {
        String key;
        if (message == null || (key = message.getIgnoredMessageKey()) == null) {
            return false;
        }
        if (flag) {
            Turn turn = this.getGame().getTurn();
            if (!this.continueIgnoreMessage(key, turn)) {
                this.startIgnoringMessage(key, turn);
            }
        } else {
            this.stopIgnoringMessage(key);
        }
        return true;
    }

    public void inciteHandler(Unit unit, IndianSettlement is, Player enemy, int gold) {
        Player player = this.getMyPlayer();
        if (gold >= 0) {
            if (!player.checkGold(gold)) {
                this.showInformationPanel((FreeColObject)is, (StringTemplate)((StringTemplate)StringTemplate.template("missionarySettlement.inciteGoldFail").add("%player%", enemy.getName())).addAmount("%amount%", gold));
            } else {
                this.invokeLater(() -> {
                    if (this.getGUI().confirm(unit.getTile(), (StringTemplate)((StringTemplate)StringTemplate.template("missionarySettlement.inciteConfirm").addStringTemplate("%enemy%", enemy.getNationLabel())).addAmount("%amount%", gold), unit, "yes", "no")) {
                        this.askServer().incite(unit, is, enemy, gold);
                    }
                });
            }
        }
    }

    public void indianDemandHandler(Unit unit, Colony colony, GoodsType type, int amount) {
        Player player = this.getMyPlayer();
        int opt = this.getClientOptions().getInteger("model.option.indianDemandResponse");
        switch (opt) {
            case 0: {
                this.invokeLater(() -> this.getGUI().showNativeDemandDialog(unit, colony, type, amount, accept -> this.askServer().indianDemand(unit, colony, type, amount, accept != false ? Constants.IndianDemandAction.INDIAN_DEMAND_ACCEPT : Constants.IndianDemandAction.INDIAN_DEMAND_REJECT)));
                return;
            }
            case 1: {
                boolean accepted = true;
                break;
            }
            case 2: {
                boolean accepted = false;
                break;
            }
            default: {
                throw new RuntimeException("Impossible option value: " + opt);
            }
        }
        String nation = Messages.message(unit.getOwner().getNationLabel());
        ModelMessage m = type == null ? (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.gold.text", colony, unit).addName("%nation%", nation)).addName("%colony%", colony.getName())).addAmount("%amount%", amount) : (type.isFoodType() ? (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.food.text", colony, unit).addName("%nation%", nation)).addName("%colony%", colony.getName())).addAmount("%amount%", amount) : (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.other.text", colony, unit).addName("%nation%", nation)).addName("%colony%", colony.getName())).addAmount("%amount%", amount)).addNamed("%goods%", type));
        player.addModelMessage(m);
        this.invokeLater(() -> this.nextModelMessage());
    }

    private boolean joinColony(Unit unit) {
        boolean ret;
        Tile tile = unit.getTile();
        Colony colony = tile == null ? null : tile.getColony();
        boolean bl = ret = colony != null && this.askServer().joinColony(unit, colony) && unit.getState() == Unit.UnitState.IN_COLONY;
        if (ret) {
            this.updateGUI(null, false);
            this.showColonyPanel(colony, unit);
        }
        return ret;
    }

    public boolean leaveShip(Unit unit) {
        boolean ret;
        Unit carrier;
        if (unit == null || (carrier = unit.getCarrier()) == null || !this.requireOurTurn()) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().disembark(unit) && unit.getLocation() != carrier;
        if (ret) {
            this.checkCashInTreasureTrain(unit);
            this.fireChanges(unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean loadCargo(Goods goods, Unit carrier) {
        if (goods == null || goods.getAmount() <= 0 || goods.getLocation() == null || carrier == null || !carrier.isCarrier() || !this.requireOurTurn()) {
            return false;
        }
        if (goods.getLocation() instanceof Europe) {
            return this.buyGoods(goods.getType(), goods.getAmount(), carrier);
        }
        UnitWas carrierWas = new UnitWas(carrier);
        UnitWas sourceWas = null;
        ColonyWas colonyWas = null;
        if (goods.getLocation() instanceof Unit) {
            Unit source = (Unit)goods.getLocation();
            sourceWas = new UnitWas(source);
        } else {
            Colony colony = carrier.getColony();
            if (colony == null) {
                return false;
            }
            colonyWas = new ColonyWas(colony);
        }
        boolean ret = this.askLoadGoods(goods.getLocation(), goods.getType(), goods.getAmount(), carrier);
        if (ret) {
            this.sound("sound.event.loadCargo");
            this.fireChanges(colonyWas, sourceWas, carrierWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public void loadGame() {
        File file = this.getGUI().showLoadSaveFileDialog(FreeColDirectories.getSaveDirectory(), "fsg", "*");
        if (file == null) {
            return;
        }
        FreeColClient fcc = this.getFreeColClient();
        if (fcc.isInGame() && !this.getGUI().confirmStopGame()) {
            return;
        }
        if (fcc.isLoggedIn()) {
            fcc.getConnectController().requestLogout(Game.LogoutReason.LOGIN);
        }
        fcc.stopServer();
        this.getGUI().prepareShowingMainMenu();
        this.getGUI().repaint();
        FreeColDirectories.setSavegameFile(file.getPath());
        if (!this.getConnectController().startSavedGame(file)) {
            this.getGUI().showMainPanel(null);
        }
    }

    public void logoutHandler(Player player, Game.LogoutReason reason) {
        if (player == null) {
            return;
        }
        Game game = this.getGame();
        if (game.getCurrentPlayer() == player) {
            game.setCurrentPlayer(game.getNextPlayer());
        }
        if (this.getMyPlayer() == player) {
            this.getFreeColClient().getConnectController().logout(reason);
        }
    }

    private boolean lootCargo(Unit unit, List<Goods> goods, String defenderId) {
        if (unit == null || goods == null || goods.isEmpty() || defenderId == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askServer().loot(unit, defenderId, goods);
        if (ret) {
            this.fireChanges(unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public void lootCargoHandler(Unit unit, List<Goods> goods, String loserId) {
        this.invokeLater(() -> this.getGUI().showCaptureGoodsDialog(unit, goods, gl -> this.lootCargo(unit, (List<Goods>)gl, loserId)));
    }

    public boolean monarchAction(Monarch.MonarchAction action, boolean accept) {
        if (action == null) {
            return false;
        }
        boolean ret = false;
        switch (action) {
            case RAISE_TAX_ACT: 
            case RAISE_TAX_WAR: 
            case MONARCH_MERCENARIES: 
            case HESSIAN_MERCENARIES: {
                ret = this.askServer().answerMonarch(action, accept);
                break;
            }
        }
        if (ret) {
            this.updateGUI(null, false);
        }
        return ret;
    }

    public void monarchActionHandler(Monarch.MonarchAction action, StringTemplate template, String monarchKey) {
        this.invokeLater(() -> this.getGUI().showMonarchDialog(action, template, monarchKey, b -> this.monarchAction(action, (boolean)b)));
    }

    public boolean moveTo(Unit unit, Location destination) {
        if (unit == null || destination == null || !this.requireOurTurn()) {
            return false;
        }
        if (destination instanceof Europe) {
            if (unit.isInEurope()) {
                this.sound("sound.event.illegalMove");
                return false;
            }
            return this.moveTowardEurope(unit, (Europe)destination);
        }
        if (destination instanceof Map) {
            if (unit.hasTile() && unit.getTile().getMap() == destination) {
                this.sound("sound.event.illegalMove");
                return false;
            }
            return this.moveAwayFromEurope(unit, destination);
        }
        if (destination instanceof Settlement) {
            if (unit.hasTile()) {
                this.sound("sound.event.illegalMove");
                return false;
            }
            return this.moveAwayFromEurope(unit, destination);
        }
        return false;
    }

    public void moveUnit(Unit unit, Direction direction) {
        Colony colony;
        if (unit == null || !unit.hasTile() || direction == null || !this.requireOurTurn()) {
            return;
        }
        if (!this.askClearGotoOrders(unit)) {
            return;
        }
        Tile oldTile = unit.getTile();
        UnitWas unitWas = new UnitWas(unit);
        ColonyWas colonyWas = unit.getColony() == null ? null : new ColonyWas(unit.getColony());
        this.changeState(unit, Unit.UnitState.ACTIVE);
        this.moveDirection(unit, direction, true);
        this.fireChanges(unitWas, colonyWas);
        this.updateGUI(null, false);
        if (unit.getTile() != oldTile && !unit.couldMove() && !unit.isDisposed() && unit.hasTile() && (colony = unit.getTile().getColony()) != null) {
            this.showColonyPanel(colony, unit);
        }
    }

    public boolean nameNewRegion(Tile tile, Unit unit, Region region, String name) {
        if (tile == null || unit == null || region == null) {
            return false;
        }
        return this.askServer().newRegionName(region, tile, unit, name);
    }

    public NationSummary nationSummary(Player player) {
        if (player == null) {
            return null;
        }
        Player myPlayer = this.getMyPlayer();
        NationSummary ns = myPlayer.getNationSummary(player);
        if (ns != null) {
            return ns;
        }
        if (this.askServer().nationSummary(myPlayer, player)) {
            return myPlayer.getNationSummary(player);
        }
        return null;
    }

    public void nationSummaryHandler(Player other, NationSummary ns) {
        Player player = this.getMyPlayer();
        player.putNationSummary(other, ns);
        logger.info("Updated nation summary of " + other.getSuffix() + " for " + player.getSuffix() + " with " + ns);
    }

    public void nativeTradeHandler(NativeTrade.NativeTradeAction action, NativeTrade nt) {
        StringTemplate prompt;
        Constants.TradeAction act;
        NativeTradeItem nti;
        if (nt == null) {
            return;
        }
        GUI gui = this.getGUI();
        IndianSettlement is = nt.getIndianSettlement();
        Unit unit = nt.getUnit();
        Player player = this.getMyPlayer();
        if (!player.owns(unit)) {
            logger.warning("We do not own the trading unit: " + unit);
            return;
        }
        switch (action) {
            case ACK_OPEN: {
                nti = null;
                act = null;
                prompt = null;
                break;
            }
            case ACK_BUY: {
                nti = null;
                act = null;
                prompt = (StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("trade.bought").addNamed("%goodsType%", nt.getItem().getGoods().getType())).addStringTemplate("%nation%", is.getOwner().getNationLabel())).addStringTemplate("%settlement%", is.getLocationLabelFor(player));
                break;
            }
            case ACK_SELL: {
                nti = null;
                act = null;
                prompt = (StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("trade.sold").addNamed("%goodsType%", nt.getItem().getGoods().getType())).addStringTemplate("%nation%", is.getOwner().getNationLabel())).addStringTemplate("%settlement%", is.getLocationLabelFor(player));
                break;
            }
            case ACK_GIFT: {
                nti = null;
                act = null;
                prompt = (StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("trade.gave").addNamed("%goodsType%", nt.getItem().getGoods().getType())).addStringTemplate("%nation%", is.getOwner().getNationLabel())).addStringTemplate("%settlement%", is.getLocationLabelFor(player));
                break;
            }
            case ACK_BUY_HAGGLE: {
                act = Constants.TradeAction.BUY;
                nti = nt.getItem();
                prompt = null;
                break;
            }
            case ACK_SELL_HAGGLE: {
                act = Constants.TradeAction.SELL;
                nti = nt.getItem();
                prompt = null;
                break;
            }
            case NAK_GOODS: {
                nti = null;
                act = null;
                prompt = (StringTemplate)StringTemplate.template("trade.noTradeGoods").addNamed("%goodsType%", nt.getItem().getGoods().getType());
                break;
            }
            case NAK_HAGGLE: {
                this.showInformationPanel(null, StringTemplate.template("trade.noTradeHaggle"));
                return;
            }
            case NAK_HOSTILE: {
                this.showInformationPanel(null, StringTemplate.template("trade.noTradeHostile"));
                return;
            }
            case NAK_NOSALE: {
                this.showInformationPanel(null, StringTemplate.template("trade.nothingToSell"));
                return;
            }
            default: {
                logger.warning("Bogus native trade: " + nt);
                return;
            }
        }
        this.invokeLater(() -> {
            Unit current = gui.getActiveUnit();
            gui.changeView(unit, false);
            UnitWas uw = new UnitWas(unit);
            this.nativeTrade(nt, act, nti, prompt);
            uw.fireChanges();
            gui.changeView(current, false);
        });
    }

    private void nativeTrade(NativeTrade nt, Constants.TradeAction act, NativeTradeItem nti, StringTemplate prompt) {
        IndianSettlement is = nt.getIndianSettlement();
        Unit unit = nt.getUnit();
        Object base = ((StringTemplate)StringTemplate.template("trade.welcome").addStringTemplate("%nation%", is.getOwner().getNationLabel())).addStringTemplate("%settlement%", is.getLocationLabelFor(unit.getOwner()));
        nt.limitSettlementToUnit(3);
        Function<NativeTradeItem, ChoiceItem> goodsMapper = i -> {
            String label = Messages.message(i.getGoods().getLabel(true));
            return new ChoiceItem<NativeTradeItem>(label, (NativeTradeItem)i);
        };
        while (!nt.getDone()) {
            if (act == null) {
                if (prompt == null) {
                    prompt = base;
                }
                if ((act = this.getGUI().getIndianSettlementTradeChoice(is, prompt, nt.canBuy(), nt.canSell(), nt.canGift())) == null) break;
                prompt = base;
            }
            switch (act) {
                case BUY: {
                    Constants.TradeBuyAction tba;
                    act = null;
                    if (nti == null) {
                        nti = (NativeTradeItem)this.getGUI().getChoice(unit.getTile(), StringTemplate.key("buyProposition.text"), is, "nothing", CollectionUtils.transform(nt.getSettlementToUnit(), NativeTradeItem::priceIsValid, goodsMapper));
                        if (nti == null) break;
                        nt.setItem(nti);
                    }
                    if ((tba = this.getGUI().getBuyChoice(unit, is, nti.getGoods(), nti.getPrice(), unit.getOwner().checkGold(nti.getPrice()))) == Constants.TradeBuyAction.BUY) {
                        this.askServer().nativeTrade(NativeTrade.NativeTradeAction.BUY, nt);
                        return;
                    }
                    if (tba != Constants.TradeBuyAction.HAGGLE) break;
                    nti.setPrice(0);
                    this.askServer().nativeTrade(NativeTrade.NativeTradeAction.BUY, nt);
                    return;
                }
                case SELL: {
                    Constants.TradeSellAction tsa;
                    act = null;
                    if (nti == null) {
                        nti = (NativeTradeItem)this.getGUI().getChoice(unit.getTile(), StringTemplate.key("sellProposition.text"), is, "nothing", CollectionUtils.transform(nt.getUnitToSettlement(), NativeTradeItem::priceIsValid, goodsMapper));
                        if (nti == null) break;
                        nt.setItem(nti);
                    }
                    if ((tsa = this.getGUI().getSellChoice(unit, is, nti.getGoods(), nti.getPrice())) == Constants.TradeSellAction.SELL) {
                        this.askServer().nativeTrade(NativeTrade.NativeTradeAction.SELL, nt);
                        return;
                    }
                    if (tsa != Constants.TradeSellAction.HAGGLE) break;
                    nti.setPrice(0);
                    this.askServer().nativeTrade(NativeTrade.NativeTradeAction.SELL, nt);
                    return;
                }
                case GIFT: {
                    act = null;
                    nti = (NativeTradeItem)this.getGUI().getChoice(unit.getTile(), StringTemplate.key("gift.text"), is, "cancel", CollectionUtils.transform(nt.getUnitToSettlement(), CollectionUtils.alwaysTrue(), goodsMapper));
                    if (nti == null) break;
                    nt.setItem(nti);
                    this.askServer().nativeTrade(NativeTrade.NativeTradeAction.GIFT, nt);
                    return;
                }
                default: {
                    logger.warning("showIndianSettlementTradeDialog fail: " + act);
                    nt.setDone();
                }
            }
            nti = null;
        }
        this.askServer().nativeTrade(NativeTrade.NativeTradeAction.CLOSE, nt);
    }

    private boolean newLandName(Unit unit, String name) {
        if (unit == null || name == null) {
            return false;
        }
        if (!this.askServer().newLandName(unit, name)) {
            return false;
        }
        Player player = unit.getOwner();
        Object t = StringTemplate.template("event.firstLanding").addName("%name%", name);
        this.invokeLater(() -> {
            FreeColPanel firstLandinPanel = this.getGUI().showEventPanel(Messages.message(t), "image.flavor.event.firstLanding", null);
            firstLandinPanel.addClosingCallback(() -> {
                String key = FreeColActionUI.getHumanKeyStrokeText(this.getFreeColClient().getActionManager().getFreeColAction("buildColonyAction").getAccelerator());
                player.addModelMessage((ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.TUTORIAL, "buildColony.tutorial", player).addName("%colonyKey%", key)).add("%colonyMenuItem%", "buildColonyAction.name")).add("%ordersMenuItem%", "menuBar.orders"));
                this.nextModelMessage();
            });
        });
        return true;
    }

    public void newLandNameHandler(Unit unit, String defaultName) {
        this.showNamingDialog(StringTemplate.key("newLand.text"), defaultName, unit, name -> this.newLandName(unit, name == null || name.isEmpty() ? defaultName : name));
    }

    private boolean newRegionName(Region region, Tile tile, Unit unit, String name) {
        if (tile == null || unit == null || region == null) {
            return false;
        }
        return this.askServer().newRegionName(region, tile, unit, name);
    }

    public void newRegionNameHandler(Region region, Tile tile, Unit unit, String name) {
        this.invokeLater(() -> {
            if (region.hasName()) {
                if (region.isPacific()) {
                    this.showEventPanel(Messages.message("event.discoverPacific"), "image.flavor.event.discoverPacific", null);
                }
                this.newRegionName(region, tile, unit, name);
            } else if (this.getClientOptions().getBoolean("model.option.guiShowRegionNaming")) {
                this.showNamingDialog((StringTemplate)StringTemplate.template("nameRegion.text").addStringTemplate("%type%", region.getLabel()), name, unit, n -> this.newRegionName(region, tile, unit, n == null || n.isEmpty() ? name : n));
            } else {
                this.newRegionName(region, tile, unit, name);
            }
        });
    }

    public TradeRoute newTradeRoute(Player player) {
        if (player == null) {
            return null;
        }
        int n = player.getTradeRouteCount();
        return this.askServer().newTradeRoute() && player.getTradeRouteCount() == n + 1 ? player.getNewestTradeRoute() : null;
    }

    public void newTradeRouteHandler(TradeRoute tr) {
        Player player = this.getMyPlayer();
        player.addTradeRoute(tr);
    }

    private boolean newTurn(int turn) {
        Turn currTurn;
        Game game = this.getGame();
        Player player = this.getMyPlayer();
        if (turn < 0) {
            logger.warning("Bad turn in newTurn: " + turn);
            return false;
        }
        Turn newTurn = new Turn(turn);
        game.setTurn(newTurn);
        logger.info("New turn: " + newTurn + "/" + turn);
        if (this.getClientOptions().getBoolean("model.option.audioAlerts")) {
            this.sound("sound.event.alertSound");
        }
        if ((currTurn = game.getTurn()).isFirstSeasonTurn()) {
            player.addModelMessage((ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.WARNING, "twoTurnsPerYear", player).addStringTemplate("%year%", currTurn.getLabel())).addAmount("%amount%", Turn.getSeasonNumber()));
        }
        player.clearNationCache();
        return true;
    }

    public void newTurnHandler(int turn) {
        this.invokeLater(() -> this.newTurn(turn));
    }

    public boolean nextActiveUnit() {
        if (!this.requireOurTurn()) {
            return false;
        }
        this.updateGUI(null, false);
        return true;
    }

    public void partialHandler(FreeColGameObject fcgo, java.util.Map<String, String> fields) {
        for (Map.Entry<String, String> e : fields.entrySet()) {
            try {
                Introspector intro = new Introspector(fcgo.getClass(), e.getKey());
                intro.setter(fcgo, e.getValue());
            }
            catch (Introspector.IntrospectorException ie) {
                logger.log(Level.WARNING, "Partial update setter fail: " + fcgo.getId() + "/" + e.getKey() + "=" + e.getValue(), ie);
            }
        }
        Player player = this.getMyPlayer();
        if (fcgo instanceof Player && fcgo == player || fcgo instanceof Ownable && player.owns((Ownable)((Object)fcgo))) {
            player.invalidateCanSeeTiles();
        }
    }

    public boolean payArrears(GoodsType type) {
        boolean ret;
        if (!this.requireOurTurn() || type == null) {
            return false;
        }
        Player player = this.getMyPlayer();
        int arrears = player.getArrears(type);
        if (arrears <= 0) {
            return false;
        }
        if (!player.checkGold(arrears)) {
            this.showInformationPanel(null, (StringTemplate)StringTemplate.template("payArrears.noGold").addAmount("%amount%", arrears));
            return false;
        }
        Object t = StringTemplate.template("payArrears.text").addAmount("%amount%", arrears);
        if (!this.getGUI().confirm(null, (StringTemplate)t, type, "ok", "cancel")) {
            return false;
        }
        boolean bl = ret = this.askServer().payArrears(type) && player.canTrade(type);
        if (ret) {
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean payForBuilding(Colony colony) {
        boolean ret;
        if (!this.requireOurTurn() || colony == null) {
            return false;
        }
        if (!this.getSpecification().getBoolean("model.option.payForBuilding")) {
            this.showInformationPanel(null, "payForBuilding.disabled");
            return false;
        }
        if (!colony.canPayToFinishBuilding()) {
            this.showInformationPanel(null, "info.notEnoughGold");
            return false;
        }
        int price = colony.getPriceForBuilding();
        Object t = StringTemplate.template("payForBuilding.text").addAmount("%amount%", price);
        if (!this.getGUI().confirm(null, (StringTemplate)t, colony, "yes", "no")) {
            return false;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        boolean bl = ret = this.askServer().payForBuilding(colony) && colony.getPriceForBuilding() == 0;
        if (ret) {
            this.fireChanges(colonyWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean putOutsideColony(Unit unit) {
        boolean ret;
        Colony colony;
        if (unit == null || (colony = unit.getColony()) == null || !this.requireOurTurn()) {
            return false;
        }
        if (!this.getGUI().confirmLeaveColony(unit)) {
            return false;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().putOutsideColony(unit) && unit.getLocation() == colony.getTile();
        if (ret) {
            this.fireChanges(colonyWas, unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public void reconnect() {
        FreeColClient fcc = this.getFreeColClient();
        this.invokeLater(() -> {
            if (this.getGUI().confirm("reconnect.text", "reconnect.no", "reconnect.yes")) {
                logger.finest("Reconnect quit.");
                fcc.getConnectController().requestLogout(Game.LogoutReason.QUIT);
            } else {
                logger.finest("Reconnect accepted.");
                fcc.getConnectController().requestLogout(Game.LogoutReason.RECONNECT);
            }
        });
    }

    public void reconnectHandler() {
        this.invokeLater(() -> this.reconnect());
    }

    public boolean recruitUnitInEurope(int index) {
        if (!this.requireOurTurn() || !Europe.MigrationType.validMigrantIndex(index)) {
            return false;
        }
        Player player = this.getMyPlayer();
        if (!player.isColonial()) {
            return false;
        }
        if (!player.checkGold(player.getEuropeanRecruitPrice())) {
            this.showInformationPanel(null, "info.notEnoughGold");
            return false;
        }
        Unit newUnit = this.askEmigrate(player.getEurope(), Europe.MigrationType.migrantIndexToSlot(index));
        if (newUnit != null) {
            this.changeView(newUnit, false);
            this.updateGUI(null, false);
        }
        return newUnit != null;
    }

    public void removeHandler(List<FreeColGameObject> objects, FreeColGameObject divert) {
        Player player = this.getMyPlayer();
        boolean visibilityChange = false;
        boolean updateUnit = false;
        for (FreeColGameObject fcgo : objects) {
            if (divert != null) {
                player.divertModelMessages(fcgo, divert);
            }
            if (fcgo instanceof Settlement) {
                Settlement settlement = (Settlement)fcgo;
                if (settlement.getOwner() != null) {
                    settlement.getOwner().removeSettlement(settlement);
                }
                visibilityChange = true;
            } else if (fcgo instanceof Unit) {
                Unit u = (Unit)fcgo;
                updateUnit |= u == this.getGUI().getActiveUnit();
                if (u.getOwner() != null) {
                    u.getOwner().removeUnit(u);
                }
                visibilityChange = true;
            }
            fcgo.disposeResources();
        }
        if (visibilityChange) {
            player.invalidateCanSeeTiles();
        }
        if (updateUnit) {
            this.updateGUI(null, true);
        }
    }

    public boolean rename(Nameable object) {
        Player player = this.getMyPlayer();
        if (!(object instanceof Ownable) || !player.owns((Ownable)((Object)object))) {
            return false;
        }
        String name = null;
        if (object instanceof Colony) {
            Colony colony = (Colony)object;
            name = this.getGUI().getInput(colony.getTile(), StringTemplate.key("renameColony.text"), colony.getName(), "rename", "cancel");
            if (name == null) {
                return false;
            }
            if (name.isEmpty()) {
                this.showInformationPanel(null, "info.enterSomeText");
                return false;
            }
            if (colony.getName().equals(name)) {
                return false;
            }
            if (player.getSettlementByName(name) != null) {
                this.showInformationPanel((FreeColObject)((Colony)object), (StringTemplate)StringTemplate.template("nameColony.notUnique").addName("%name%", name));
                return false;
            }
        } else if (object instanceof Unit) {
            Unit unit = (Unit)object;
            name = this.getGUI().getInput(unit.getTile(), StringTemplate.key("renameUnit.text"), unit.getName(), "rename", "cancel");
            if (name == null) {
                return false;
            }
        } else {
            logger.warning("Tried to rename an unsupported Nameable: " + object);
            return false;
        }
        if (this.askServer().rename((FreeColGameObject)((Object)object), name)) {
            this.invokeLater(() -> {
                GUI gui = this.getGUI();
                gui.updateMapControls();
                gui.updateMenuBar();
                gui.refresh();
            });
            return true;
        }
        return false;
    }

    public boolean saveAndQuit() {
        if (!this.saveGame()) {
            return false;
        }
        this.getFreeColClient().quit();
        return true;
    }

    public boolean saveGame() {
        if (!this.getFreeColClient().canSaveCurrentGame()) {
            return false;
        }
        Game game = this.getGame();
        if (game == null) {
            return false;
        }
        String fileName = this.getSaveGameString(game);
        File file = this.getGUI().showSaveDialog(FreeColDirectories.getSaveDirectory(), fileName);
        if (file == null) {
            return false;
        }
        if (!this.getClientOptions().getBoolean("model.option.confirmSaveOverwrite") || !file.exists() || this.getGUI().confirm("saveConfirmationDialog.areYouSure.text", "ok", "cancel")) {
            FreeColDirectories.setSavegameFile(file.getPath());
            return this.saveGame(file);
        }
        return false;
    }

    public void scoutSpeakToChiefHandler(Unit unit, IndianSettlement is, String result) {
        switch (result) {
            case "": {
                break;
            }
            case "die": {
                this.showInformationPanel((FreeColObject)is, "scoutSettlement.speakDie");
                break;
            }
            case "expert": {
                this.showInformationPanel((FreeColObject)is, (StringTemplate)StringTemplate.template("scoutSettlement.expertScout").addNamed("%unit%", unit.getType()));
                break;
            }
            case "tales": {
                this.showInformationPanel((FreeColObject)is, "scoutSettlement.speakTales");
                break;
            }
            case "nothing": {
                this.showInformationPanel((FreeColObject)is, (StringTemplate)StringTemplate.template("scoutSettlement.speakNothing").addStringTemplate("%nation%", unit.getOwner().getNationLabel()));
                break;
            }
            default: {
                this.showInformationPanel((FreeColObject)is, (StringTemplate)StringTemplate.template("scoutSettlement.speakBeads").add("%amount%", result));
            }
        }
    }

    public boolean selectDestination(Unit unit) {
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        if (!this.getGUI().confirmClearTradeRoute(unit)) {
            return false;
        }
        Location destination = this.getGUI().showSelectDestinationDialog(unit);
        if (destination == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askSetDestination(unit, destination);
        if (ret) {
            if (destination instanceof Europe) {
                if (unit.hasTile() && unit.getTile().isDirectlyHighSeasConnected()) {
                    this.moveTowardEurope(unit, (Europe)destination);
                } else {
                    this.moveToDestination(unit, null);
                }
            } else if (unit.isInEurope()) {
                this.moveAwayFromEurope(unit, destination);
            } else {
                this.moveToDestination(unit, null);
            }
            this.fireChanges(unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean sellGoods(Goods goods) {
        if (goods == null || !(goods.getLocation() instanceof Unit) || !this.requireOurTurn()) {
            return false;
        }
        Player player = this.getMyPlayer();
        Unit carrier = (Unit)goods.getLocation();
        EuropeWas europeWas = new EuropeWas(player.getEurope());
        MarketWas marketWas = new MarketWas(player);
        UnitWas unitWas = new UnitWas(carrier);
        boolean ret = this.askUnloadGoods(goods.getType(), goods.getAmount(), carrier);
        if (ret) {
            marketWas.add(new AbstractGoods(goods.getType(), goods.getAmount()));
            this.sound("sound.event.sellCargo");
            this.fireChanges(europeWas, marketWas, unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public void setAIHandler(Player player, boolean ai) {
        player.setAI(ai);
    }

    public boolean setBuildQueue(Colony colony, List<BuildableType> buildQueue) {
        if (colony == null || buildQueue == null || !this.requireOurTurn()) {
            return false;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        boolean ret = this.askServer().setBuildQueue(colony, buildQueue);
        if (ret) {
            this.fireChanges(colonyWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    private boolean setCurrentPlayer(Player player) {
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && this.currentPlayerIsMyPlayer()) {
            this.getFreeColClient().getGUI().invokeNowOrWait(() -> this.getGUI().closeMenus());
        }
        Game game = this.getGame();
        game.setCurrentPlayer(player);
        if (this.getMyPlayer().equals(player)) {
            this.moveMode = MoveMode.NEXT_ACTIVE_UNIT;
            FreeColDebugger.finishDebugRun(this.getFreeColClient(), false);
            if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.DESYNC) && DebugUtils.checkDesyncAction(this.getFreeColClient())) {
                FreeCol.fatal(logger, "Exiting on desynchronization");
            }
            if (this.getFreeColServer() != null && game.getTurn().getNumber() > 0) {
                this.autoSaveGame();
            }
            player.removeDisplayedModelMessages();
            this.displayModelMessages(true, true);
            player.invalidateCanSeeTiles();
            Europe europe = player.getEurope();
            if (player.hasAbility("model.ability.selectRecruit")) {
                this.emigration(player, 0, false);
            } else {
                while (player.checkEmigrate()) {
                    this.askEmigrate(europe, Europe.MigrationType.getUnspecificSlot());
                }
            }
            if (!this.getFreeColClient().getSinglePlayer()) {
                this.sound("sound.anthem." + player.getNationId());
            }
            player.resetIterators();
            this.updateGUI(player.getFallbackTile(), false);
            this.getGUI().refresh();
        }
        return true;
    }

    public void setCurrentPlayerHandler(Player currentPlayer) {
        this.setCurrentPlayer(currentPlayer);
    }

    private boolean setDead() {
        FreeColClient fcc = this.getFreeColClient();
        Player player = this.getMyPlayer();
        Game.LogoutReason reason = null;
        if (fcc.getSinglePlayer()) {
            if (player.getPlayerType() != Player.PlayerType.RETIRED) {
                if (player.getPlayerType() != Player.PlayerType.UNDEAD && this.getGUI().confirm("defeatedSinglePlayer.text", "defeatedSinglePlayer.yes", "quit")) {
                    this.askServer().enterRevengeMode();
                    return true;
                }
                reason = Game.LogoutReason.DEFEATED;
            }
        } else if (!this.getGUI().confirm("defeated.text", "defeated.yes", "quit")) {
            reason = Game.LogoutReason.DEFEATED;
        }
        FreeColDebugger.finishDebugRun(fcc, true);
        if (reason != null) {
            fcc.getConnectController().requestLogout(reason);
        }
        return false;
    }

    public void setDeadHandler(Player dead) {
        Player player = this.getMyPlayer();
        if (player == dead) {
            this.invokeLater(() -> this.setDead());
        } else {
            player.setStance(dead, null);
        }
    }

    public void setGameConnected() {
        Player player = this.getMyPlayer();
        if (player != null) {
            player.refilterModelMessages(this.getClientOptions());
        }
    }

    public boolean setGoodsLevels(Colony colony, GoodsType goodsType) {
        if (colony == null || goodsType == null) {
            return false;
        }
        return this.askServer().setGoodsLevels(colony, colony.getExportData(goodsType));
    }

    public boolean setInDebugMode() {
        FreeColDebugger.enableDebugMode(FreeColDebugger.DebugMode.MENUS);
        this.getFreeColClient().getConnectController().requestLogout(Game.LogoutReason.RECONNECT);
        return true;
    }

    public boolean setStanceHandler(Stance stance, Player first, Player second) {
        if (stance == null || first == null || second == null) {
            return false;
        }
        Player player = this.getMyPlayer();
        Stance old = first.getStance(second);
        try {
            first.setStance(second, stance);
        }
        catch (IllegalStateException e) {
            logger.log(Level.WARNING, "Illegal stance transition", e);
            return false;
        }
        player.clearNationSummary(second);
        if (player == first && old == Stance.UNCONTACTED) {
            this.invokeLater(() -> this.sound("sound.event.meet." + second.getNationId()));
        }
        return true;
    }

    public void spySettlementHandler(Tile tile) {
        Colony colony = tile.getColony();
        if (colony != null) {
            this.showColonyPanel(colony, null);
        }
    }

    public boolean trainUnitInEurope(UnitType unitType) {
        boolean ret;
        Europe europe;
        if (!this.requireOurTurn() || unitType == null) {
            return false;
        }
        Player player = this.getMyPlayer();
        if (!player.checkGold((europe = player.getEurope()).getUnitPrice(unitType))) {
            this.showInformationPanel(null, "info.notEnoughGold");
            return false;
        }
        EuropeWas europeWas = new EuropeWas(europe);
        Unit newUnit = null;
        boolean bl = ret = this.askServer().trainUnitInEurope(unitType) && (newUnit = europeWas.getNewUnit()) != null;
        if (ret) {
            this.fireChanges(europeWas);
            this.changeView(newUnit, false);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public boolean unload(Unit unit) {
        if (unit == null || !unit.isCarrier() || !this.requireOurTurn()) {
            return false;
        }
        boolean ret = true;
        Colony colony = unit.getColony();
        if (colony != null) {
            for (Unit u : unit.getUnitList()) {
                if (this.leaveShip(u)) continue;
                ret = false;
            }
            for (Goods goods : unit.getGoodsList()) {
                if (this.unloadCargo(goods, false)) continue;
                ret = false;
            }
        } else if (unit.isInEurope()) {
            Player player = this.getMyPlayer();
            for (Goods goods : unit.getCompactGoodsList()) {
                if (!player.canTrade(goods.getType()) || this.sellGoods(goods)) continue;
                ret = false;
            }
            if (unit.hasGoodsCargo()) {
                this.getGUI().showDumpCargoDialog(unit, goodsList -> {
                    for (Goods g : goodsList) {
                        this.unloadCargo(g, true);
                    }
                });
                return false;
            }
        } else {
            for (Goods goods : unit.getGoodsList()) {
                if (this.unloadCargo(goods, false)) continue;
                ret = false;
            }
        }
        return ret;
    }

    public boolean unloadCargo(Goods goods, boolean dump) {
        if (goods == null || goods.getAmount() <= 0 || !(goods.getLocation() instanceof Unit) || !this.requireOurTurn()) {
            return false;
        }
        Unit carrier = (Unit)goods.getLocation();
        if (carrier.isInEurope()) {
            return this.sellGoods(goods);
        }
        Colony colony = carrier.getColony();
        ColonyWas colonyWas = colony == null ? null : new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(carrier);
        boolean ret = this.askUnloadGoods(goods.getType(), goods.getAmount(), carrier);
        if (ret) {
            if (!dump) {
                this.sound("sound.event.unloadCargo");
            }
            this.fireChanges(colonyWas, unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    public void updateHandler(List<FreeColObject> objects) {
        Game game = this.getGame();
        Player player = this.getMyPlayer();
        for (FreeColObject fco : objects) {
            FreeColGameObject fcgo = game.getFreeColGameObject(fco.getId());
            if (fcgo == null) {
                logger.warning("Update of missing FCGO: " + fco.getId());
                continue;
            }
            if (!fcgo.copyIn(fco)) {
                logger.warning("Update copy-in failed: " + fco.getId());
                continue;
            }
            if (!(fco instanceof Tile)) continue;
            this.invokeLater(() -> this.getGUI().refreshTile((Tile)fco));
        }
        player.invalidateCanSeeTiles();
    }

    public boolean updateTradeRoute(TradeRoute route) {
        if (route == null) {
            return false;
        }
        return this.askServer().updateTradeRoute(route);
    }

    private boolean victory(Boolean quit) {
        if (quit.booleanValue()) {
            this.invokeLater(() -> this.getFreeColClient().getConnectController().newGame());
        } else {
            this.askServer().continuePlaying();
        }
        return true;
    }

    public boolean waitUnit() {
        if (!this.requireOurTurn()) {
            return false;
        }
        this.updateGUI(null, true);
        return true;
    }

    public boolean work(Unit unit, WorkLocation workLocation) {
        boolean ret;
        if (unit == null || workLocation == null || !this.requireOurTurn()) {
            return false;
        }
        if (unit.getStudent() != null && !this.getGUI().confirmAbandonEducation(unit, false)) {
            return false;
        }
        Colony colony = workLocation.getColony();
        Tile tile = workLocation.getWorkTile();
        if (tile != null) {
            if (tile.hasLostCityRumour()) {
                this.showInformationPanel(null, "tileHasRumour");
                return false;
            }
            if (!unit.getOwner().owns(tile) && !this.claimTile(tile, colony)) {
                return false;
            }
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().work(unit, workLocation) && unit.getLocation() == workLocation;
        if (ret) {
            this.fireChanges(colonyWas, unitWas);
            this.updateGUI(null, false);
        }
        return ret;
    }

    private static enum MoveMode {
        NEXT_ACTIVE_UNIT,
        EXECUTE_GOTO_ORDERS,
        END_TURN;


        public MoveMode minimize(MoveMode m) {
            return this.ordinal() > m.ordinal() ? m : this;
        }

        public MoveMode maximize(MoveMode m) {
            return this.ordinal() < m.ordinal() ? m : this;
        }
    }
}

